/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;
import org.eclipse.jdt.core.tests.compiler.regression.JavadocTest;

public class JavadocTest_16
extends JavadocTest {
    String docCommentSupport = "enabled";
    String reportInvalidJavadoc = "error";
    String reportMissingJavadocDescription = "return_tag";
    String reportInvalidJavadocVisibility = "private";
    String reportMissingJavadocTags = "error";
    String reportMissingJavadocComments = null;
    String reportMissingJavadocCommentsVisibility = null;
    String reportDeprecation = "error";
    String reportJavadocDeprecation = null;
    String processAnnotations = null;

    public JavadocTest_16(String name) {
        super(name);
    }

    public static Class javadocTestClass() {
        return JavadocTest_16.class;
    }

    public static Test suite() {
        return JavadocTest_16.buildMinimalComplianceTestSuite(JavadocTest_16.javadocTestClass(), 8192);
    }

    @Override
    protected Map getCompilerOptions() {
        Map options = super.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.doc.comment.support", this.docCommentSupport);
        options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadoc", this.reportInvalidJavadoc);
        if (!"ignore".equals(this.reportInvalidJavadoc)) {
            options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadocTagsVisibility", this.reportInvalidJavadocVisibility);
        }
        if (this.reportJavadocDeprecation != null) {
            options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadocTagsDeprecatedRef", this.reportJavadocDeprecation);
        }
        if (this.reportMissingJavadocComments != null) {
            options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocComments", this.reportMissingJavadocComments);
            options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocCommentsOverriding", "enabled");
            if (this.reportMissingJavadocCommentsVisibility != null) {
                options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocCommentsVisibility", this.reportMissingJavadocCommentsVisibility);
            }
        } else {
            options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocComments", this.reportInvalidJavadoc);
        }
        if (this.reportMissingJavadocTags != null) {
            options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocTags", this.reportMissingJavadocTags);
            options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocTagsOverriding", "enabled");
        } else {
            options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocTags", this.reportInvalidJavadoc);
        }
        if (this.reportMissingJavadocDescription != null) {
            options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocTagDescription", this.reportMissingJavadocDescription);
        }
        if (this.processAnnotations != null) {
            options.put("org.eclipse.jdt.core.compiler.processAnnotations", this.processAnnotations);
        }
        options.put("org.eclipse.jdt.core.compiler.problem.fieldHiding", "ignore");
        options.put("org.eclipse.jdt.core.compiler.problem.syntheticAccessEmulation", "ignore");
        options.put("org.eclipse.jdt.core.compiler.problem.deprecation", this.reportDeprecation);
        options.put("org.eclipse.jdt.core.compiler.problem.unusedImport", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.rawTypeReference", "ignore");
        options.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "ignore");
        return options;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.docCommentSupport = "enabled";
        this.reportInvalidJavadoc = "error";
        this.reportInvalidJavadocVisibility = "private";
        this.reportMissingJavadocTags = "ignore";
        this.reportMissingJavadocComments = "ignore";
        this.reportMissingJavadocCommentsVisibility = "public";
        this.reportDeprecation = "error";
        this.reportInvalidJavadoc = "error";
    }

    public void testInlineReturn1() {
        if (this.complianceLevel < 0x3C0000L) {
            return;
        }
        this.runConformTest(new String[]{"X.java", "public class X {\n\t/** {@return 42} */\n\tpublic int sample() {\n\t\treturn 42;\n\t}\n}\n"});
    }

    public void testInlineReturn2() {
        if (this.complianceLevel < 0x3C0000L) {
            return;
        }
        this.runConformTest(new String[]{"X.java", "public class X {\n\t/** {@return some lengthy description} */\n\tpublic int sample() {\n\t\treturn 42;\n\t}\n}\n"});
    }

    public void testInlineReturn3() {
        if (this.complianceLevel < 0x3C0000L) {
            return;
        }
        this.runConformTest(new String[]{"X.java", "public class X {\n\t/** {@return {@code true} or else\n\t *  {@code false}}\n\t */\n\tpublic boolean sample() {\n\t\treturn false;\n\t}\n}\n"});
    }

    public void testInlineReturn4() {
        if (this.complianceLevel < 0x3C0000L) {
            return;
        }
        this.runConformTest(new String[]{"X.java", "public class X {\n\t/** {@return {true} or\n\t *  {false}}\n\t */\n\tpublic boolean sample() {\n\t\treturn false;\n\t}\n}\n"});
    }

    public void testInlineReturn_broken1() {
        if (this.complianceLevel < 0x3C0000L) {
            return;
        }
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t/** {@return with unbalanced brace{} */\n\tpublic int sample() {\n\t\treturn 42;\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\t/** {@return with unbalanced brace{} */\n\t    ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Missing closing brace for inline tag\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void testInlineReturn_broken2() {
        if (this.complianceLevel < 0x3C0000L) {
            return;
        }
        this.runNegativeTest(new String[]{"X.java", "public class X\n\t/** {@return with unbalanced brace}} */\n\tpublic int sample() {\n\t\treturn 42;\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X\n\t             ^\nSyntax error on token \"X\", { expected after this token\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }
}

