/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;
import org.eclipse.jdt.core.tests.compiler.regression.JavadocTest;

public class JavadocTest_18
extends JavadocTest {
    String docCommentSupport = "enabled";
    String reportInvalidJavadoc = "error";
    String reportMissingJavadocDescription = "return_tag";
    String reportInvalidJavadocVisibility = "private";
    String reportMissingJavadocTags = "error";
    String reportMissingJavadocComments = null;
    String reportMissingJavadocCommentsVisibility = null;
    String reportDeprecation = "error";
    String reportJavadocDeprecation = null;
    String processAnnotations = null;

    public JavadocTest_18(String name) {
        super(name);
    }

    public static Class javadocTestClass() {
        return JavadocTest_18.class;
    }

    public static Test suite() {
        return JavadocTest_18.buildMinimalComplianceTestSuite(JavadocTest_18.javadocTestClass(), 32768);
    }

    @Override
    protected Map getCompilerOptions() {
        Map options = super.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.doc.comment.support", this.docCommentSupport);
        options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadoc", this.reportInvalidJavadoc);
        if (!"ignore".equals(this.reportInvalidJavadoc)) {
            options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadocTagsVisibility", this.reportInvalidJavadocVisibility);
        }
        if (this.reportJavadocDeprecation != null) {
            options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadocTagsDeprecatedRef", this.reportJavadocDeprecation);
        }
        if (this.reportMissingJavadocComments != null) {
            options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocComments", this.reportMissingJavadocComments);
            options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocCommentsOverriding", "enabled");
            if (this.reportMissingJavadocCommentsVisibility != null) {
                options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocCommentsVisibility", this.reportMissingJavadocCommentsVisibility);
            }
        } else {
            options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocComments", this.reportInvalidJavadoc);
        }
        if (this.reportMissingJavadocTags != null) {
            options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocTags", this.reportMissingJavadocTags);
            options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocTagsOverriding", "enabled");
        } else {
            options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocTags", this.reportInvalidJavadoc);
        }
        if (this.reportMissingJavadocDescription != null) {
            options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocTagDescription", this.reportMissingJavadocDescription);
        }
        if (this.processAnnotations != null) {
            options.put("org.eclipse.jdt.core.compiler.processAnnotations", this.processAnnotations);
        }
        options.put("org.eclipse.jdt.core.compiler.problem.fieldHiding", "ignore");
        options.put("org.eclipse.jdt.core.compiler.problem.syntheticAccessEmulation", "ignore");
        options.put("org.eclipse.jdt.core.compiler.problem.deprecation", this.reportDeprecation);
        options.put("org.eclipse.jdt.core.compiler.problem.unusedImport", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.rawTypeReference", "ignore");
        options.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "ignore");
        return options;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.docCommentSupport = "enabled";
        this.reportInvalidJavadoc = "error";
        this.reportInvalidJavadocVisibility = "private";
        this.reportMissingJavadocTags = "ignore";
        this.reportMissingJavadocComments = "ignore";
        this.reportMissingJavadocCommentsVisibility = "public";
        this.reportDeprecation = "error";
        this.reportInvalidJavadoc = "error";
    }

    public void test001() {
        if (this.complianceLevel < 0x3E0000L) {
            return;
        }
        this.runNegativeTest(new String[]{"X.java", " /**\n * {@snippet : public static void main(String... args) {\n *       for (var arg : args) {                 \n *           if (!arg.isBlank()) {\n *               System.out.println(arg);\n *           }\n *       }                                      \n *   }\n *   }\n */\npublic class X {\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\t* {@snippet : public static void main(String... args) {\n\t              ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Snippet content should be on a new line\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test002() {
        if (this.complianceLevel < 0x3E0000L) {
            return;
        }
        this.runNegativeTest(new String[]{"X.java", " /**\n * {@snippet :  * public static void main(String... args) {\n *       for (var arg : args) {                 \n *           if (!arg.isBlank()) {\n *               System.out.println(arg);\n *           }\n *       }                                      \n *   }\n *   }\n */\npublic class X {\n}"}, null, AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test003() {
        if (this.complianceLevel < 0x3E0000L) {
            return;
        }
        this.runNegativeTest(new String[]{"X.java", " /**\n * {@snippet:\n *abcd                  \n */\npublic class X {\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\t* {@snippet:\n\t  ^^^^^^^^^^\nJavadoc: Missing closing brace for inline tag\n----------\n2. ERROR in X.java (at line 2)\n\t* {@snippet:\n\t    ^^^^^^^^\nJavadoc: Space required after snippet tag\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test004() {
        if (this.complianceLevel < 0x3E0000L) {
            return;
        }
        this.runConformTest(new String[]{"X.java", " /**\n * {@snippet :\n *abcd   }               \n */\npublic class X {\n}"});
    }

    public void test005() {
        if (this.complianceLevel < 0x3E0000L) {
            return;
        }
        this.runNegativeTest(new String[]{"X.java", " /**\n * {@snippet :\n * while(true){{{             \n * }             \n */\npublic class X {\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\t* {@snippet :\n\t  ^^^^^^^^^^^\nJavadoc: Missing closing brace for inline tag\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test006() {
        if (this.complianceLevel < 0x3E0000L) {
            return;
        }
        this.runNegativeTest(new String[]{"X.java", " /**\n * {@snippet \n *              \n * }             \n */\npublic class X {\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\t* }             \n\t   ^^^^^^^^^^^^^\nJavadoc: Snippet is invalid due to missing colon\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test007() {
        if (this.complianceLevel < 0x3E0000L) {
            return;
        }
        this.runNegativeTest(new String[]{"X.java", " /**\n * {@snippet \n *              \n * }             \n */\npublic class X {\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\t* }             \n\t   ^^^^^^^^^^^^^\nJavadoc: Snippet is invalid due to missing colon\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test008() {
        if (this.complianceLevel < 0x3E0000L) {
            return;
        }
        this.runNegativeTest(new String[]{"X.java", " /**\n * {@snippet : \n *     abc // @replace substring='a'  regex='a'       \n * }             \n */\npublic class X {\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\t*     abc // @replace substring='a'  regex='a'       \n\t          ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Attribute regex and substring used simulataneously\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test009() {
        if (this.complianceLevel < 0x3E0000L) {
            return;
        }
        this.runNegativeTest(new String[]{"X.java", " /**\n * {@snippet : \n *     abc // @highlight substring='a'  region='abcd'      \n *      //@end region='abc'        \n * }             \n */\npublic class X {\n}"}, "----------\n1. ERROR in X.java (at line 5)\n\t* }             \n\t   ^^^^^^^^^^^^^\nJavadoc: Region in the snippet is not closed\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test010() {
        if (this.complianceLevel < 0x3E0000L) {
            return;
        }
        this.runNegativeTest(new String[]{"X.java", " /**\n * {@snippet : \n *     abc // @highlight substring='a'  region='abcd'      \n *     abc // @highlight substring='a'  region='abcd'      \n *      //@end region='abcd'        \n *      //@end region='abcd'        \n * }             \n */\npublic class X {\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\t*     abc // @highlight substring='a'  region='abcd'      \n\t                                       ^^^^^^\nJavadoc: Duplicate region\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }
}

