/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.JavadocTest;

public class JavadocTest_1_3
extends JavadocTest {
    String docCommentSupport = "enabled";
    String reportInvalidJavadoc = "error";
    String reportInvalidJavadocVisibility = "private";
    String reportMissingJavadocTags = "error";
    String reportMissingJavadocComments = null;
    String reportMissingJavadocCommentsVisibility = null;

    public JavadocTest_1_3(String name) {
        super(name);
    }

    public static Class testClass() {
        return JavadocTest_1_3.class;
    }

    public static Test suite() {
        return JavadocTest_1_3.buildMinimalComplianceTestSuite(JavadocTest_1_3.testClass(), 32);
    }

    @Override
    protected Map getCompilerOptions() {
        Map options = super.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.doc.comment.support", this.docCommentSupport);
        options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadoc", this.reportInvalidJavadoc);
        if (!"ignore".equals(this.reportInvalidJavadoc)) {
            options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadocTagsVisibility", this.reportInvalidJavadocVisibility);
        }
        if (this.reportMissingJavadocComments != null) {
            options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocComments", this.reportMissingJavadocComments);
        } else {
            options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocComments", this.reportInvalidJavadoc);
        }
        if (this.reportMissingJavadocCommentsVisibility != null) {
            options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocCommentsVisibility", this.reportMissingJavadocCommentsVisibility);
        }
        if (this.reportMissingJavadocTags != null) {
            options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocTags", this.reportMissingJavadocTags);
        } else {
            options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocTags", this.reportInvalidJavadoc);
        }
        options.put("org.eclipse.jdt.core.compiler.problem.fieldHiding", "ignore");
        options.put("org.eclipse.jdt.core.compiler.problem.syntheticAccessEmulation", "ignore");
        options.put("org.eclipse.jdt.core.compiler.problem.deprecation", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.unusedImport", "error");
        return options;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.docCommentSupport = "enabled";
        this.reportInvalidJavadoc = "error";
        this.reportInvalidJavadocVisibility = "private";
        this.reportMissingJavadocTags = "error";
        this.reportMissingJavadocComments = "ignore";
    }

    public void test006() {
        this.runNegativeTest(new String[]{"X.java", " /**\n  * Invalid type parameter reference\n  * @param <E> Type parameter\n  */\n public class X {}"}, "----------\n1. ERROR in X.java (at line 3)\n\t* @param <E> Type parameter\n\t   ^^^^^\nJavadoc: Unexpected tag\n----------\n");
    }

    public void test020() {
        this.runNegativeTest(new String[]{"X.java", " /**\n  * Invalid type parameter reference\n  * @param <V> Type parameter 2\n  * @param\n  * @param <U> Type parameter 1\n  */\n public class X<T, U, V> {}"}, "----------\n1. ERROR in X.java (at line 4)\n\t* @param\n\t   ^^^^^\nJavadoc: Missing parameter name\n----------\n2. ERROR in X.java (at line 7)\n\tpublic class X<T, U, V> {}\n\t               ^\nJavadoc: Missing tag for parameter T\n----------\n");
    }

    public void test021() {
        this.runNegativeTest(new String[]{"X.java", " /**\n  * Invalid type parameter reference: compile error\n  * @param <T> Type parameter 2\n  * @param <V> Type parameter 2\n  * @param <U> Type parameter 1\n  */\n public class X<T, , V> {}"}, "----------\n1. ERROR in X.java (at line 4)\n\t* @param <V> Type parameter 2\n\t          ^\nJavadoc: V cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 5)\n\t* @param <U> Type parameter 1\n\t          ^\nJavadoc: U cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 7)\n\tpublic class X<T, , V> {}\n\t                  ^\nSyntax error on token \",\", delete this token\n----------\n");
    }

    public void test022() {
        this.runNegativeTest(new String[]{"X.java", " /**\n  * Invalid type parameter reference: compile error\n  * @param <T> Type parameter 2\n  * @param <V> Type parameter 2\n  * @param <U> Type parameter 1\n  */\n public class X<T, U, V extend Exception> {}"}, "----------\n1. ERROR in X.java (at line 7)\n\tpublic class X<T, U, V extend Exception> {}\n\t                       ^^^^^^\nSyntax error on token \"extend\", extends expected\n----------\n2. ERROR in X.java (at line 7)\n\tpublic class X<T, U, V extend Exception> {}\n\t                       ^^^^^^\nextend cannot be resolved to a type\n----------\n");
    }

    public void test026() {
        this.runNegativeTest(new String[]{"X.java", " public class X {\n\t/**\n\t * Invalid type parameter reference\n\t * @param val int\n\t * @param <E> Type parameter\n\t * @param obj Object\n\t */\n\tpublic void foo(int val, Object obj) {}\n}"}, "----------\n1. ERROR in X.java (at line 5)\n\t* @param <E> Type parameter\n\t   ^^^^^\nJavadoc: Unexpected tag\n----------\n");
    }

    public void test036() {
        this.runNegativeTest(new String[]{"X.java", " public class X {\n\t/**\n\t * Invalid type parameter reference: compile error\n\t * @param <T> Type parameter 2\n\t * @param <V> Type parameter 2\n\t * @param <U> Type parameter 1\n\t * @param val int\n\t * @param obj Object\n\t */\n\tpublic <T, , V> void foo(int val, Object obj) {}\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\t* @param <T> Type parameter 2\n\t   ^^^^^\nJavadoc: Unexpected tag\n----------\n2. ERROR in X.java (at line 5)\n\t* @param <V> Type parameter 2\n\t   ^^^^^\nJavadoc: Unexpected tag\n----------\n3. ERROR in X.java (at line 6)\n\t* @param <U> Type parameter 1\n\t   ^^^^^\nJavadoc: Unexpected tag\n----------\n4. ERROR in X.java (at line 10)\n\tpublic <T, , V> void foo(int val, Object obj) {}\n\t           ^\nSyntax error on token \",\", delete this token\n----------\n");
    }

    public void test040() {
        this.runConformReferenceTest(new String[]{"X.java", "/**\n * @category\n */\npublic class X {\n}\n"});
    }

    public void testBug96237_Public01() {
        this.reportInvalidJavadocVisibility = "public";
        this.runConformTest(new String[]{"comment6/Valid.java", "package comment6;\npublic class Valid {\n    /**\n     * @see Valid.Inner\n     */\n    public class Inner { }\n}\n/**\n * See also {@link Valid.Inner}\n */\nclass Sub2 extends Valid { }"});
    }

    public void testBug96237_Public02() {
        this.reportInvalidJavadocVisibility = "public";
        this.runNegativeTest(new String[]{"comment6/Invalid.java", "package comment6;\npublic class Invalid {\n    /**\n     * @see Inner\n     */\n    public class Inner { }\n}\n/**\n * See also {@link Inner} \n */\nclass Sub1 extends Invalid { }\n"}, "");
    }

    public void testBug96237_Public03() {
        this.reportInvalidJavadocVisibility = "public";
        this.runNegativeTest(new String[]{"comment6a/def/Test.java", "package comment6a.def;\npublic class Test {\n    /**\n     * @see Inner\n     */\n    public class Inner { }\n}\n", "comment6a/test/Invalid.java", "package comment6a.test;\nimport comment6a.def.Test;\n/**\n * See also {@link Inner}\n */\npublic class Invalid extends Test { \n}", "comment6a/test/Invalid2.java", "package comment6a.test;\nimport comment6a.def.Test;\n/**\n * @see Test.Inner\n */\npublic class Invalid2 extends Test { \n}", "comment6a/test/Valid.java", "package comment6a.test;\nimport comment6a.def.Test;\n/**\n * @see comment6a.def.Test.Inner\n */\npublic class Valid extends Test { \n}"}, "----------\n1. ERROR in comment6a\\test\\Invalid.java (at line 4)\n\t* See also {@link Inner}\n\t                  ^^^^^\nJavadoc: Invalid member type qualification\n----------\n----------\n1. ERROR in comment6a\\test\\Invalid2.java (at line 4)\n\t* @see Test.Inner\n\t       ^^^^^^^^^^\nJavadoc: Invalid member type qualification\n----------\n");
    }

    public void testBug96237_Public04() {
        this.reportInvalidJavadocVisibility = "public";
        this.runNegativeTest(new String[]{"comment6b/Invalid.java", "package comment6b;\n\n/**\n * @see Inner\n */\npublic class Invalid implements Test { \n}", "comment6b/Test.java", "package comment6b;\npublic interface Test {\n    /**\n     * @see Inner\n     */\n    public class Inner { }\n}\n", "comment6b/Valid.java", "package comment6b;\n\n/**\n * @see Test.Inner\n */\npublic class Valid implements Test { \n}"}, "----------\n1. ERROR in comment6b\\Invalid.java (at line 4)\n\t* @see Inner\n\t       ^^^^^\nJavadoc: Invalid member type qualification\n----------\n");
    }

    public void testBug96237_Public05() {
        this.reportInvalidJavadocVisibility = "public";
        this.runNegativeTest(new String[]{"test/a/Test.java", "package test.a;\n/**\n * @see Inner\n * @see Test.Inner\n */\npublic class Test {\n\tclass Inner {}\n}\n"}, "----------\n1. ERROR in test\\a\\Test.java (at line 3)\n\t* @see Inner\n\t       ^^^^^\nJavadoc: 'public' visibility for malformed doc comments hides this 'default' reference\n----------\n2. ERROR in test\\a\\Test.java (at line 4)\n\t* @see Test.Inner\n\t       ^^^^^^^^^^\nJavadoc: 'public' visibility for malformed doc comments hides this 'default' reference\n----------\n");
    }

    public void testBug96237_Public06() {
        this.reportInvalidJavadocVisibility = "public";
        this.runNegativeTest(new String[]{"test/b/Test.java", "package test.b;\n/** \n * @see Inner.Level2\n * @see Test.Inner.Level2\n */\npublic class Test {\n\t/** \n\t * @see Level2\n\t * @see Test.Inner.Level2\n\t */\n\tpublic class Inner {\n\t\tclass Level2 {}\n\t}\n}\n"}, "----------\n1. ERROR in test\\b\\Test.java (at line 3)\n\t* @see Inner.Level2\n\t       ^^^^^^^^^^^^\nJavadoc: 'public' visibility for malformed doc comments hides this 'default' reference\n----------\n2. ERROR in test\\b\\Test.java (at line 4)\n\t* @see Test.Inner.Level2\n\t       ^^^^^^^^^^^^^^^^^\nJavadoc: 'public' visibility for malformed doc comments hides this 'default' reference\n----------\n3. ERROR in test\\b\\Test.java (at line 8)\n\t* @see Level2\n\t       ^^^^^^\nJavadoc: 'public' visibility for malformed doc comments hides this 'default' reference\n----------\n4. ERROR in test\\b\\Test.java (at line 9)\n\t* @see Test.Inner.Level2\n\t       ^^^^^^^^^^^^^^^^^\nJavadoc: 'public' visibility for malformed doc comments hides this 'default' reference\n----------\n");
    }

    public void testBug96237_Public07() {
        this.reportInvalidJavadocVisibility = "public";
        this.runNegativeTest(new String[]{"test/c/Test.java", "package test.c;\n/**\n * @see Inner.Level2.Level3\n * @see Test.Inner.Level2.Level3\n */\npublic class Test {\n\tpublic class Inner {\n\t\t/**\n\t\t * @see Level3\n\t\t * @see Level2.Level3\n\t\t * @see Inner.Level2.Level3\n\t\t * @see Test.Inner.Level2.Level3\n\t\t */\n\t\tpublic class Level2 {\n\t\t\tclass Level3 {\n\t\t\t}\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in test\\c\\Test.java (at line 3)\n\t* @see Inner.Level2.Level3\n\t       ^^^^^^^^^^^^^^^^^^^\nJavadoc: 'public' visibility for malformed doc comments hides this 'default' reference\n----------\n2. ERROR in test\\c\\Test.java (at line 4)\n\t* @see Test.Inner.Level2.Level3\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: 'public' visibility for malformed doc comments hides this 'default' reference\n----------\n3. ERROR in test\\c\\Test.java (at line 9)\n\t* @see Level3\n\t       ^^^^^^\nJavadoc: 'public' visibility for malformed doc comments hides this 'default' reference\n----------\n4. ERROR in test\\c\\Test.java (at line 10)\n\t* @see Level2.Level3\n\t       ^^^^^^^^^^^^^\nJavadoc: 'public' visibility for malformed doc comments hides this 'default' reference\n----------\n5. ERROR in test\\c\\Test.java (at line 11)\n\t* @see Inner.Level2.Level3\n\t       ^^^^^^^^^^^^^^^^^^^\nJavadoc: 'public' visibility for malformed doc comments hides this 'default' reference\n----------\n6. ERROR in test\\c\\Test.java (at line 12)\n\t* @see Test.Inner.Level2.Level3\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: 'public' visibility for malformed doc comments hides this 'default' reference\n----------\n");
    }

    public void testBug96237_Public08() {
        this.reportInvalidJavadocVisibility = "public";
        this.runNegativeTest(new String[]{"test/d/Reference.java", "package test.d;\nclass Reference {\n}\n", "test/d/Test.java", "package test.d;\n/**\n * @see Secondary\n * @see Reference\n */\npublic class Test {\n}\nclass Secondary {}"}, "----------\n1. ERROR in test\\d\\Test.java (at line 3)\n\t* @see Secondary\n\t       ^^^^^^^^^\nJavadoc: 'public' visibility for malformed doc comments hides this 'default' reference\n----------\n2. ERROR in test\\d\\Test.java (at line 4)\n\t* @see Reference\n\t       ^^^^^^^^^\nJavadoc: 'public' visibility for malformed doc comments hides this 'default' reference\n----------\n");
    }

    public void testBug96237_Private01() {
        this.reportInvalidJavadocVisibility = "private";
        this.runConformTest(new String[]{"comment6/Valid.java", "package comment6;\npublic class Valid {\n    /**\n     * @see Valid.Inner\n     */\n    public class Inner { }\n}\n/**\n * See also {@link Valid.Inner}\n */\nclass Sub2 extends Valid { }"});
    }

    public void testBug96237_Private02() {
        this.reportInvalidJavadocVisibility = "private";
        this.runNegativeTest(new String[]{"comment6/Invalid.java", "package comment6;\npublic class Invalid {\n    /**\n     * @see Inner\n     */\n    public class Inner { }\n}\n/**\n * See also {@link Inner} \n */\nclass Sub1 extends Invalid { }\n"}, "----------\n1. ERROR in comment6\\Invalid.java (at line 9)\n\t* See also {@link Inner} \n\t                  ^^^^^\nJavadoc: Invalid member type qualification\n----------\n");
    }

    public void testBug96237_Private03() {
        this.reportInvalidJavadocVisibility = "private";
        this.runNegativeTest(new String[]{"comment6a/def/Test.java", "package comment6a.def;\npublic class Test {\n    /**\n     * @see Inner\n     */\n    public class Inner { }\n}\n", "comment6a/test/Invalid.java", "package comment6a.test;\nimport comment6a.def.Test;\n/**\n * See also {@link Inner}\n */\npublic class Invalid extends Test { \n}", "comment6a/test/Invalid2.java", "package comment6a.test;\nimport comment6a.def.Test;\n/**\n * @see Test.Inner\n */\npublic class Invalid2 extends Test { \n}", "comment6a/test/Valid.java", "package comment6a.test;\nimport comment6a.def.Test;\n/**\n * @see comment6a.def.Test.Inner\n */\npublic class Valid extends Test { \n}"}, "----------\n1. ERROR in comment6a\\test\\Invalid.java (at line 4)\n\t* See also {@link Inner}\n\t                  ^^^^^\nJavadoc: Invalid member type qualification\n----------\n----------\n1. ERROR in comment6a\\test\\Invalid2.java (at line 4)\n\t* @see Test.Inner\n\t       ^^^^^^^^^^\nJavadoc: Invalid member type qualification\n----------\n");
    }

    public void testBug96237_Private04() {
        this.reportInvalidJavadocVisibility = "private";
        this.runNegativeTest(new String[]{"comment6b/Invalid.java", "package comment6b;\n\n/**\n * @see Inner\n */\npublic class Invalid implements Test { \n}", "comment6b/Test.java", "package comment6b;\npublic interface Test {\n    /**\n     * @see Inner\n     */\n    public class Inner { }\n}\n", "comment6b/Valid.java", "package comment6b;\n\n/**\n * @see Test.Inner\n */\npublic class Valid implements Test { \n}"}, "----------\n1. ERROR in comment6b\\Invalid.java (at line 4)\n\t* @see Inner\n\t       ^^^^^\nJavadoc: Invalid member type qualification\n----------\n");
    }

    public void testBug96237_Private05() {
        this.reportInvalidJavadocVisibility = "private";
        this.runConformTest(new String[]{"test/a/Test.java", "package test.a;\n/**\n * @see Inner\n * @see Test.Inner\n */\npublic class Test {\n\tclass Inner {}\n}\n"});
    }

    public void testBug96237_Private06() {
        this.reportInvalidJavadocVisibility = "private";
        this.runConformTest(new String[]{"test/b/Test.java", "package test.b;\n/** \n * @see Inner.Level2\n * @see Test.Inner.Level2\n */\npublic class Test {\n\t/** \n\t * @see Level2\n\t * @see Test.Inner.Level2\n\t */\n\tpublic class Inner {\n\t\tclass Level2 {}\n\t}\n}\n"});
    }

    public void testBug96237_Private07() {
        this.reportInvalidJavadocVisibility = "private";
        this.runConformTest(new String[]{"test/c/Test.java", "package test.c;\n/**\n * @see Inner.Level2.Level3\n * @see Test.Inner.Level2.Level3\n */\npublic class Test {\n\tpublic class Inner {\n\t\t/**\n\t\t * @see Level3\n\t\t * @see Level2.Level3\n\t\t * @see Inner.Level2.Level3\n\t\t * @see Test.Inner.Level2.Level3\n\t\t */\n\t\tpublic class Level2 {\n\t\t\tclass Level3 {\n\t\t\t}\n\t\t}\n\t}\n}\n"});
    }

    public void testBug96237_Private08() {
        this.reportInvalidJavadocVisibility = "private";
        this.runConformTest(new String[]{"test/d/Reference.java", "package test.d;\nclass Reference {\n}\n", "test/d/Test.java", "package test.d;\n/**\n * @see Secondary\n * @see Reference\n */\npublic class Test {\n}\nclass Secondary {}"});
    }

    public void testBug95286_Default() {
        this.reportMissingJavadocComments = "error";
        this.reportMissingJavadocCommentsVisibility = "default";
        this.runConformTest(new String[]{"test/package-info.java", "/**\n * Javadoc for all package \n */\npackage test;\n"});
    }

    public void testBug95286_Private() {
        this.reportMissingJavadocComments = "error";
        this.reportMissingJavadocCommentsVisibility = "private";
        this.runConformTest(new String[]{"test/package-info.java", "/**\n * Javadoc for all package \n */\npackage test;\n"});
    }

    public void testBug101283g() {
        this.reportMissingJavadocTags = "disabled";
        this.runNegativeTest(new String[]{"test/X.java", "package test;\npublic class X {\n\tint foo() { return 0; }\n\tclass XX extends X2 {\n\t\tint bar() {\n\t\t\treturn foo();\n\t\t}\n\t}\n}\nclass X2 {\n\tint foo() {\n\t\treturn 0;\n\t}\n}\n", "test/Y.java", "package test;\npublic class Y {\n\tint foo;\n\tclass YY extends Y2 {\n\t/**\n\t *  @see #foo\n\t */\n\t\tint bar() {\n\t\t\treturn foo;\n\t\t}\n\t}\n}\nclass Y2 {\n\tint foo;\n}\n"}, "");
    }

    public void testBug119857() {
        this.runNegativeTest(new String[]{"DefaultInformationControl.java", "public class DefaultInformationControl {\n\tpublic interface IInformationPresenter {\n\t\t/**\n\t\t * Updates the given presentation of the given information and\n\t\t * thereby may manipulate the information to be displayed. The manipulation\n\t\t * could be the extraction of textual encoded style information etc. Returns the\n\t\t * manipulated information.\n\t\t *\n\t\t * @param hoverInfo the information to be presented\n\t\t * @param maxWidth the maximal width in pixels\n\t\t * @param maxHeight the maximal height in pixels\n\t\t *\n\t\t * @return the manipulated information\n\t\t * @deprecated As of 3.2, replaced by {@link IInformationPresenterExtension#updatePresentation(String, int, int)}\n\t\t * \t\t\t\tsee bug https://bugs.eclipse.org/bugs/show_bug.cgi?id=38528 for details.\n\t\t */\n\t\tString updatePresentation(String hoverInfo, int maxWidth, int maxHeight);\n\t}\n\t/**\n\t * An information presenter determines the style presentation\n\t * of information displayed in the default information control.\n\t * The interface can be implemented by clients.\n\t * \n\t * @since 3.2\n\t */\n\tpublic interface IInformationPresenterExtension {\n\t\t\n\t\t/**\n\t\t * Updates the given presentation of the given information and\n\t\t * thereby may manipulate the information to be displayed. The manipulation\n\t\t * could be the extraction of textual encoded style information etc. Returns the\n\t\t * manipulated information.\n\t\t * <p>\n\t\t * Replaces {@link IInformationPresenter#updatePresentation(String, int, int)}\n\t\t * <em>Make sure that you do not pass in a <code>Display</code></em> until\n\t\t * https://bugs.eclipse.org/bugs/show_bug.cgi?id=38528 is fixed.\n\t\t * </p>\n\t\t *\n\t\t * @param hoverInfo the information to be presented\n\t\t * @param maxWidth the maximal width in pixels\n\t\t * @param maxHeight the maximal height in pixels\n\t\t *\n\t\t * @return the manipulated information\n\t\t */\n\t\tString updatePresentation(String hoverInfo, int maxWidth, int maxHeight);\n\t}\n}\n"}, "");
    }

    public void testBug119857_Fields() {
        this.runNegativeTest(new String[]{"TestFields.java", "/**\n * @see MyInnerClass#foo\n */\npublic class TestFields {\n    /**\n     * @see MyInnerClass#foo\n     */\n    public class MyInnerClass {\n            Object foo;\n    }\n}"}, "");
    }

    public void testBug119857_Methods() {
        this.runNegativeTest(new String[]{"TestMethods.java", "/**\n * @see MyInnerClass#foo()\n * @see MyInnerInterface#foo()\n */\npublic class TestMethods {\n    /**\n     * @see MyInnerInterface#foo()\n     */\n    public class MyInnerClass {\n            public void foo() {}\n    }\n    /**\n     * @see MyInnerClass#foo()\n     */\n    public interface MyInnerInterface {\n            public void foo();\n    }\n}"}, "");
    }

    public void testBug119857_Types() {
        this.runNegativeTest(new String[]{"TestTypes.java", "/**\n * @see MyInnerClass\n * @see MyInnerInterface\n */\npublic class TestTypes {\n\t/**\n\t * @see MyInnerInterface\n\t */\n\tpublic class MyInnerClass {\n\t        public void foo() {}\n\t}\n\t/**\n\t * @see MyInnerClass\n\t */\n\tpublic interface MyInnerInterface {\n\t        public void foo();\n\t}\n}"}, "");
    }

    public void testBug119857_Private01() {
        this.reportMissingJavadocTags = "ignore";
        this.runConformTest(new String[]{"pack/Test.java", "package pack;\npublic class Test {\n\tstatic class Inner {\n\t\tpublic Object foo() { return null; }\n\t}\n\tpublic Inner field;\n\t/** \n\t * @see Inner#foo()\n\t */\n\tpublic Object foo() {\n\t\treturn field.foo();\n\t}\n}\n"});
    }

    public void testBug119857_Public01() {
        this.reportMissingJavadocTags = "disabled";
        this.reportInvalidJavadocVisibility = "public";
        this.runNegativeTest(new String[]{"pack/Test.java", "package pack;\npublic class Test {\n\tstatic class Inner {\n\t\tpublic Object foo() { return null; }\n\t}\n\tpublic Inner field;\n\t/** \n\t * @see Inner#foo()\n\t */\n\tpublic Object foo() {\n\t\treturn field.foo();\n\t}\n}\n"}, "----------\n1. ERROR in pack\\Test.java (at line 8)\r\n\t* @see Inner#foo()\r\n\t       ^^^^^\nJavadoc: 'public' visibility for malformed doc comments hides this 'default' reference\n----------\n");
    }

    public void testBug119857_Private02() {
        this.reportMissingJavadocTags = "ignore";
        this.runNegativeTest(new String[]{"test/Test.java", "package test;\npublic class Test {\n\tstatic class Inner1 {\n\t\tpublic Object foo() { return null; }\n\t}\n\tstatic class Inner2 {\n\t\tpublic Inner1 field;\n\t\t/** \n\t\t * @see Inner1#foo()\n\t\t */\n\t\tpublic Object foo() {\n\t\t\treturn field.foo();\n\t\t}\n\t}\n}\n"}, "");
    }

    public void testBug119857_Public02() {
        this.reportMissingJavadocTags = "ignore";
        this.reportInvalidJavadocVisibility = "public";
        this.runConformTest(new String[]{"test/Test.java", "package test;\npublic class Test {\n\tstatic class Inner1 {\n\t\tpublic Object foo() { return null; }\n\t}\n\tstatic class Inner2 {\n\t\tpublic Inner1 field;\n\t\t/** \n\t\t * @see Inner1#foo()\n\t\t */\n\t\tpublic Object foo() {\n\t\t\treturn field.foo();\n\t\t}\n\t}\n}\n"});
    }

    public void testBug119857_Public03() {
        this.reportMissingJavadocTags = "ignore";
        this.reportInvalidJavadocVisibility = "public";
        this.runNegativeTest(new String[]{"pack/Test.java", "package pack;\npublic class Test {\n\tstatic class Inner1 {\n\t\tpublic Object foo() { return null; }\n\t}\n\tpublic static class Inner2 {\n\t\tpublic Inner1 field;\n\t\t/** \n\t\t * @see Inner1#foo()\n\t\t */\n\t\tpublic Object foo() {\n\t\t\treturn field.foo();\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in pack\\Test.java (at line 9)\n\t* @see Inner1#foo()\n\t       ^^^^^^\nJavadoc: 'public' visibility for malformed doc comments hides this 'default' reference\n----------\n");
    }
}

