/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.io.File;
import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;

public class Jsr14Test
extends AbstractRegressionTest {
    public Jsr14Test(String name) {
        super(name);
    }

    @Override
    protected Map getCompilerOptions() {
        Map<String, String> options = super.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.compliance", CompilerOptions.getFirstSupportedJavaVersion());
        options.put("org.eclipse.jdt.core.compiler.source", CompilerOptions.getFirstSupportedJavaVersion());
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", CompilerOptions.getFirstSupportedJavaVersion());
        return options;
    }

    public static Test suite() {
        return Jsr14Test.buildMinimalComplianceTestSuite(Jsr14Test.testClass(), 32);
    }

    public void test1() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(X.class);\n\t}\n}"}, "class X");
        String expectedOutput = "// Compiled from X.java (version 1.8 : 52.0, super bit)\npublic class X {\n  \n  // Method descriptor #6 ()V\n  // Stack: 1, Locals: 1\n  public X();\n    0  aload_0 [this]\n    1  invokespecial java.lang.Object() [8]\n    4  return\n      Line numbers:\n        [pc: 0, line: 1]\n      Local variable table:\n        [pc: 0, pc: 5] local: this index: 0 type: X\n  \n  // Method descriptor #15 ([Ljava/lang/String;)V\n  // Stack: 2, Locals: 1\n  public static void main(java.lang.String[] args);\n    0  getstatic java.lang.System.out : java.io.PrintStream [16]\n    3  ldc <Class X> [1]\n    5  invokevirtual java.io.PrintStream.println(java.lang.Object) : void [22]\n    8  return\n      Line numbers:\n        [pc: 0, line: 3]\n        [pc: 8, line: 4]\n      Local variable table:\n        [pc: 0, pc: 9] local: args index: 0 type: java.lang.String[]\n}";
        this.checkDisassembledClassFile(OUTPUT_DIR + File.separator + "X.class", "X", expectedOutput);
    }

    public static Class testClass() {
        return Jsr14Test.class;
    }
}

