/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractComparableTest;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;
import org.eclipse.jdt.core.util.ClassFileBytesDisassembler;
import org.eclipse.jdt.core.util.ClassFormatException;
import org.eclipse.jdt.internal.compiler.util.Util;

public class LocalEnumTest
extends AbstractComparableTest {
    String reportMissingJavadocComments = null;

    public LocalEnumTest(String name) {
        super(name);
    }

    public static Test suite() {
        return LocalEnumTest.buildMinimalComplianceTestSuite(LocalEnumTest.testClass(), 8192);
    }

    public static Class testClass() {
        return LocalEnumTest.class;
    }

    @Override
    protected Map getCompilerOptions() {
        Map options = super.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.doc.comment.support", "enabled");
        options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadoc", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadocTags", "enabled");
        options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadocTagsVisibility", "private");
        options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocTags", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocTagsVisibility", "private");
        options.put("org.eclipse.jdt.core.compiler.problem.missingOverrideAnnotationForInterfaceMethodImplementation", "disabled");
        options.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", "ignore");
        options.put("org.eclipse.jdt.core.compiler.problem.unusedParameter", "ignore");
        options.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "ignore");
        if (this.reportMissingJavadocComments != null) {
            options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocComments", this.reportMissingJavadocComments);
        }
        return options;
    }

    @Override
    protected void setUp() throws Exception {
        this.runJavacOptIn = true;
        super.setUp();
        this.reportMissingJavadocComments = null;
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        this.runJavacOptIn = false;
    }

    @Override
    protected void runConformTest(String[] testFiles) {
        this.runConformTest(testFiles, "", this.getCompilerOptions());
    }

    @Override
    protected void runConformTest(String[] testFiles, String expectedOutput) {
        this.runConformTest(testFiles, expectedOutput, this.getCompilerOptions());
    }

    private void verifyClassFile(String expectedOutput, String classFileName, int mode, boolean positive) throws IOException, ClassFormatException {
        String result = this.getClassFileContents(classFileName, mode);
        this.verifyOutput(result, expectedOutput, positive);
    }

    private String getClassFileContents(String classFileName, int mode) throws IOException, ClassFormatException {
        File f = new File(OUTPUT_DIR + File.separator + classFileName);
        byte[] classFileBytes = Util.getFileByteContent((File)f);
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        String result = disassembler.disassemble(classFileBytes, "\n", mode);
        return result;
    }

    private void verifyOutput(String result, String expectedOutput, boolean positive) {
        int index = result.indexOf(expectedOutput);
        if (positive) {
            if (index == -1 || expectedOutput.length() == 0) {
                System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(result, 3));
                System.out.println("...");
            }
            if (index == -1) {
                LocalEnumTest.assertEquals("Wrong contents", expectedOutput, result);
            }
        } else if (index != -1) {
            LocalEnumTest.assertEquals("Unexpected contents", "", result);
        }
    }

    public void test000() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static void main(String[] args) {\n          enum Role { M, D }\n enum T {\n       PHILIPPE(37) {\n               public boolean isManager() {\n                       return true;\n               }\n       },\n       DAVID(27),\n       JEROME(33),\n       OLIVIER(35),\n       KENT(40),\n       YODA(41),\n       FREDERIC;\n       final static int OLD = 41;\n\n\n   int age;\n       Role role;\n\n       T() { this(OLD); }\n       T(int age) {\n               this.age = age;\n       }\n       public int age() { return this.age; }\n       public boolean isManager() { return false; }\n       void setRole(boolean mgr) {\n               this.role = mgr ? Role.M : Role.D;\n       }\n}\n       System.out.print(\"JDTCore team:\");\n       T oldest = null;\n       int maxAge = Integer.MIN_VALUE;\n       for (T t : T.values()) {\n            if (t == T.YODA) continue;// skip YODA\n            t.setRole(t.isManager());\n                        if (t.age() > maxAge) {\n               oldest = t;\n               maxAge = t.age();\n            }\n                      Location l = switch(t) {\n                         case PHILIPPE, DAVID, JEROME, FREDERIC-> Location.SNZ;\n                         case OLIVIER, KENT -> Location.OTT;\n                         default-> throw new AssertionError(\"Unknown team member: \" + t);\n                       };\n\n            System.out.print(\" \"+ t + ':'+t.age()+':'+l+':'+t.role);\n        }\n        System.out.println(\" WINNER is:\" + T.valueOf(oldest.name()));\n    }\n\n   private enum Location { SNZ, OTT }\n}"}, "JDTCore team: PHILIPPE:37:SNZ:M DAVID:27:SNZ:D JEROME:33:SNZ:D OLIVIER:35:OTT:D KENT:40:OTT:D FREDERIC:41:SNZ:D WINNER is:FREDERIC");
    }

    public void test001() {
        this.runNegativeTest(new String[]{"X.java", "class X { \n\tpublic static void main(String[] args) {\n    enum Y { \n\t   BLEU, \n\t   BLANC, \n\t   ROUGE;\n\t   static {\n\t   \t BLEU = null;\n\t   }\n\t }\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 8)\n\tBLEU = null;\n\t^^^^\nThe final field Y.BLEU cannot be assigned\n----------\n");
    }

    public void test002() {
        this.runNegativeTest(new String[]{"X.java", "class X { \n\tpublic static void main(String[] args) {\n    enum Y { \n\t\t\n\t\tBLEU, \n\t\tBLANC, \n\t\tROUGE,\n\t\tBLEU;\n\t }\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 5)\n\tBLEU, \n\t^^^^\nDuplicate field Y.BLEU\n----------\n2. ERROR in X.java (at line 8)\n\tBLEU;\n\t^^^^\nDuplicate field Y.BLEU\n----------\n");
    }

    public void test003() {
        this.runNegativeTest(new String[]{"X.java", "class X { \n\tpublic static void main(String[] args) {\n    enum Y { \n\t\n\t\tpublic BLEU, \n\t\ttransient BLANC, \n\t\tROUGE, \n\t\tabstract RED {\n\t\t\tvoid _test() {}\n\t\t}\n\t }\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 5)\n\tpublic BLEU, \n\t       ^^^^\nIllegal modifier for the enum constant BLEU; no modifier is allowed\n----------\n2. ERROR in X.java (at line 6)\n\ttransient BLANC, \n\t          ^^^^^\nIllegal modifier for the enum constant BLANC; no modifier is allowed\n----------\n3. ERROR in X.java (at line 8)\n\tabstract RED {\n\t         ^^^\nIllegal modifier for the enum constant RED; no modifier is allowed\n----------\n");
    }

    public void test004() {
        this.runConformTest(new String[]{"X.java", "public class X { \n\tpublic static void main(String[] args) {\n     enum Y { \n\t\t\n\t\tBLEU,\n\t\tBLANC,\n\t\tROUGE;\n\t\t\n\t\tpublic static void main(String[] a) {\n\t\t\tSystem.out.println(BLEU);\n\t\t}\n\t\t\n\t  }\n\t  Y.main(args);\n\t}\n}\n"}, "BLEU");
    }

    public void test005() {
        this.runNegativeTest(new String[]{"X.java", "class X { \n\tpublic static void main(String[] args) {\n     enum Y { \n\t\t;\n\t\tprotected Object clone() { return this; }\n\t  }\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tprotected Object clone() { return this; }\n\t                 ^^^^^^^\nCannot override the final method from Enum<Y>\n----------\n2. WARNING in X.java (at line 5)\n\tprotected Object clone() { return this; }\n\t                 ^^^^^^^\nThe method clone() of type Y should be tagged with @Override since it actually overrides a superclass method\n----------\n");
    }

    public void test006() {
        this.runConformTest(new String[]{"X.java", "public class X { \n\tpublic static void main(String[] args) {\n     enum Y { \n\t\t\n\t\tBLEU,\n\t\tBLANC,\n\t\tROUGE;\n\t\t\n\t\tpublic static void main(String[] args) {\n\t\t\tfor(Y y: Y.values()) {\n\t\t\t\tSystem.out.print(y);\n\t\t\t}\n\t\t}\n\t\t\n\t  }\n\t  Y.main(args);\n\t}\n}\n"}, "BLEUBLANCROUGE");
    }

    public void test007() {
        this.runConformTest(new String[]{"X.java", "public class X { \n\tpublic static void main(String[] args) {\n     enum Y { \n\t\t\n\t\tBLEU,\n\t\tBLANC,\n\t\tROUGE;\n\t\t\n      int $VALUES;\n\t\tpublic static void main(String[] args) {\n\t\t\t\tfor(Y y: Y.values()) {\n\t\t\t\t\tSystem.out.print(y);\n\t\t\t}\n\t\t}\n\t\t\n\t  }\n\t  Y.main(args);\n\t}\n}\n"}, "BLEUBLANCROUGE");
    }

    public void test008() {
        this.runNegativeTest(new String[]{"X.java", "class X { \n\tpublic static void main(String[] args) {\n     enum Y { \n\t\t\n\t\tBLEU,\n\t\tBLANC,\n\t\tROUGE;\n\t\t\n      void dup() {} \n      void values() {} \n      void dup() {} \n      void values() {} \n      Missing dup() {} \n\t\tpublic static void main(String[] args) {\n\t\t\t\tfor(Y y: Y.values()) {\n\t\t\t\t\tSystem.out.print(y);\n\t\t}\n\t}\n\t\n\t  }\n\t  Y.main(args);\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\tvoid dup() {} \n\t     ^^^^^\nDuplicate method dup() in type Y\n----------\n2. ERROR in X.java (at line 10)\n\tvoid values() {} \n\t     ^^^^^^^^\nThe enum Y already defines the method values() implicitly\n----------\n3. ERROR in X.java (at line 11)\n\tvoid dup() {} \n\t     ^^^^^\nDuplicate method dup() in type Y\n----------\n4. ERROR in X.java (at line 12)\n\tvoid values() {} \n\t     ^^^^^^^^\nThe enum Y already defines the method values() implicitly\n----------\n5. ERROR in X.java (at line 13)\n\tMissing dup() {} \n\t^^^^^^^\nMissing cannot be resolved to a type\n----------\n6. ERROR in X.java (at line 13)\n\tMissing dup() {} \n\t        ^^^^^\nDuplicate method dup() in type Y\n----------\n7. WARNING in X.java (at line 14)\n\tpublic static void main(String[] args) {\n\t                                 ^^^^\nThe parameter args is hiding another local variable defined in an enclosing scope\n----------\n");
    }

    public void test009() {
        this.runConformTest(new String[]{"X.java", "public class X { \n\tpublic static void main(String[] args) {\n     enum Y { \n\t\n\t\tBLEU,\n\t\tBLANC,\n\t\tROUGE;\n\t\t\n\t\t//void values() {}\n\t\t\n\t\tpublic static void main(String[] args) {\n\t\t\tY y = BLEU;\n\t\t\tswitch(y) {\n\t\t\t\tcase BLEU :\n\t\t\t\t\tSystem.out.println(\"SUCCESS\");\n\t\t\t\t\tbreak;\n\t\t\t\tcase BLANC :\n\t\t\t\tcase ROUGE :\n\t\t\t\t\tSystem.out.println(\"FAILED\");\n\t\t\t\t\tbreak;\n\t           default: // nop\n   \t\t}\n\t\t}\n\t\t\n\t  }\n\t  Y.main(args);\n\t}\n}"}, "SUCCESS");
    }

    public void test010() {
        this.runNegativeTest(new String[]{"X.java", "class X { \n\tpublic static void main(String[] args) {\n     enum Y { \n\t\t\n\t\tBLEU,\n\t\tBLANC,\n\t\tROUGE;\n\t\t\n\t\t//void values() {}\n\t\t\n\t\tpublic static void main(String[] args) {\n\t\t\tY y = BLEU;\n\t\t\tswitch(y) {\n\t\t\t\tcase BLEU :\n\t\t\t\t\tbreak;\n\t\t\t\tcase BLEU :\n\t\t\t\tcase BLANC :\n\t\t\t\tcase ROUGE :\n\t\t\t\t\tSystem.out.println(\"FAILED\");\n\t\t\t\t\tbreak;\n              default: // nop\n\t\t\t}\n\t\t}\n\t\n\t  }\n\t  Y.main(args);\n\t}\n}"}, "----------\n1. WARNING in X.java (at line 11)\n\tpublic static void main(String[] args) {\n\t                                 ^^^^\nThe parameter args is hiding another local variable defined in an enclosing scope\n----------\n2. ERROR in X.java (at line 16)\n\tcase BLEU :\n\t     ^^^^\nDuplicate case\n----------\n");
    }

    public void test011() {
        this.runNegativeTest(new String[]{"X.java", "class X { \n\tpublic static void main(String[] args) {\n     enum Y { \n\t\n\tBLEU,\n\tBLANC,\n\tROUGE;\n\t\n   void values() {} \n   void values() {} \n\tpublic static void main(String[] args) {\n\t\tfor(Y y: Y.values()) {\n\t\t\tSystem.out.print(y);\n\t\t}\n\t}\n\t\n\t  }\n\t  Y.main(args);\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\tvoid values() {} \n\t     ^^^^^^^^\nThe enum Y already defines the method values() implicitly\n----------\n2. ERROR in X.java (at line 10)\n\tvoid values() {} \n\t     ^^^^^^^^\nThe enum Y already defines the method values() implicitly\n----------\n3. WARNING in X.java (at line 11)\n\tpublic static void main(String[] args) {\n\t                                 ^^^^\nThe parameter args is hiding another local variable defined in an enclosing scope\n----------\n");
    }

    public void testNPE012() {
        this.runNegativeTest(new String[]{"X.java", "class X { \n\tpublic static void main(String[] args) {\n\t  enum Y implements Runnable { \n\t\n\tBLEU,\n\tBLANC,\n\tROUGE;\n\t  }\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tenum Y implements Runnable { \n\t     ^\nThe type Y must implement the inherited abstract method Runnable.run()\n----------\n");
    }

    public void test013() {
        this.runNegativeTest(new String[]{"X.java", "class X { \n\tpublic static void main(String[] args) {\n\t  enum Y  { \n\t\n\tBLEU(10),\n\tBLANC(20),\n\tROUGE(30);\n\t  }\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tBLEU(10),\n\t^^^^\nThe constructor Y(int) is undefined\n----------\n2. ERROR in X.java (at line 6)\n\tBLANC(20),\n\t^^^^^\nThe constructor Y(int) is undefined\n----------\n3. ERROR in X.java (at line 7)\n\tROUGE(30);\n\t^^^^^\nThe constructor Y(int) is undefined\n----------\n");
    }

    public void test014() {
        this.runConformTest(new String[]{"X.java", "public class X { \n\tpublic static void main(String[] args) {\n\t  enum Y  { \n\t\n\tBLEU(10),\n\tBLANC(20),\n\tROUGE(30);\n\n\tint val;\n\tY(int val) {\n\t\tthis.val = val;\n\t}\n\n\tpublic static void main(String[] args) {\n\t\tfor(Y y: values()) {\n\t\t\tSystem.out.print(y.val);\n\t\t}\n\t}\n\t  }\n\t  Y.main(args);\n\t}\n}\n"}, "102030");
    }

    public void test015() {
        this.runNegativeTest(new String[]{"X.java", "class X { \n\tpublic static void main(String[] args) {\n\t  enum Y  { \n\t\n\tBLEU(10),\n\tBLANC(),\n\tROUGE(30);\n\n\tint val;\n\tY(int val) {\n\t\tthis.val = val;\n\t}\n\n\tpublic static void main(String[] a) {\n\t\tfor(Y y: values()) {\n\t\t\tSystem.out.print(y.val);\n\t\t}\n\t}\n\t  }\n\t  Y.main(args);\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tBLANC(),\n\t^^^^^\nThe constructor Y() is undefined\n----------\n");
    }

    public void test016() {
        this.runConformTest(new String[]{"X.java", "public class X { \n\tpublic static void main(String[] args) {\n\t  enum Y  { \n\t\n\tBLEU(10) {\n\t\tString foo() { // inner\n\t\t\treturn super.foo() + this.val;\n\t\t}\n\t},\n\tBLANC(20),\n\tROUGE(30);\n\n\tint val;\n\tY(int val) {\n\t\tthis.val = val;\n\t}\n\tString foo() {  // outer\n\t\treturn this.name();\n\t}\n\tpublic static void main(String[] args) {\n\t\tfor(Y y: values()) {\n\t\t\tSystem.out.print(y.foo());\n\t\t}\n\t}\n\t  }\n\t  Y.main(args);\n\t}\n}\n"}, "BLEU10BLANCROUGE");
    }

    public void test017() {
        this.runConformTest(new String[]{"X.java", "public class X { \n\tpublic static void main(String[] args) {\n\t  enum Y  { \n\t\n\tBLEU()\n\t  }\n\t}\n}\n"}, "");
    }

    public void test018() {
        this.runNegativeTest(new String[]{"X.java", "class X { \n\tpublic static void main(String[] args) {\n\t  enum Y  { \n\t    BLEU()\n\t  }\n\t\t\n\t  class XX extends Y implements Y {\n\t  }\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tclass XX extends Y implements Y {\n\t                 ^\nThe type Y cannot be the superclass of XX; a superclass must be a class\n----------\n2. ERROR in X.java (at line 7)\n\tclass XX extends Y implements Y {\n\t                              ^\nThe type Y cannot be a superinterface of XX; a superinterface must be an interface\n----------\n");
    }

    public void test019() {
        this.runConformTest(new String[]{"X.java", "public class X { \n\tpublic static void main(String[] args) {\n enum MonthEnum {\n    JANUARY   (30),\n    FEBRUARY  (28),\n    MARCH     (31),\n    APRIL     (30),\n    MAY       (31),\n    JUNE      (30),\n    JULY      (31),\n    AUGUST    (31),\n    SEPTEMBER (31),\n    OCTOBER   (31),\n    NOVEMBER  (30),\n    DECEMBER  (31);\n    \n    private final int days;\n    \n    MonthEnum(int days) {\n        this.days = days;\n    }\n    \n    public int getDays() {\n    \tboolean leapYear = true;\n    \tswitch(this) {\n    \t\tcase FEBRUARY: if(leapYear) return days+1;\n           default: return days;\n    \t}\n    }\n    \n    public static void main(String[] args) {\n    \tSystem.out.println(JANUARY.getDays());\n    }\n    \n\t  }\n\t  MonthEnum.main(args);\n\t}\n}\n"}, "30");
    }

    public void test020() {
        this.runConformTest(new String[]{"Foo.java", "public class Foo{\n\t public static void main(String[] args) {\n       enum Rank {FIRST,SECOND,THIRD}\n\t }\n}\n"}, "");
    }

    public void test021() {
        this.runNegativeTest(new String[]{"Foo.java", "public class Foo {\n\t public static void main(String[] args) {\n      enum Rank {FIRST,SECOND,THIRD;\n            void bar() { foo(); } \n      }\n\t }\n    void foo() {}\n}\n"}, "----------\n1. ERROR in Foo.java (at line 4)\n\tvoid bar() { foo(); } \n\t             ^^^\nCannot make a static reference to the non-static method foo() from the type Foo\n----------\n");
    }

    public void test022() {
        if (this.complianceLevel < 0x410000L) {
            return;
        }
        this.runConformTest(new String[]{"X.java", "public class X {\n\t\n\t\n\tvoid foo() {\n\t    enum MX { BLEU, BLANC, ROUGE }\n\t\tMX e = MX.BLEU; \n\t\tswitch(e) {\n\t\t\tcase MX.BLEU : break;\n\t\t\tcase MX.BLANC : break;\n\t\t\tcase MX.ROUGE : break;\n\t\t}\n\t}\n}\n"}, "");
    }

    public void test023() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t    enum RuleType{ SUCCESS, FAILURE }\n\t\tSystem.out.print(RuleType.valueOf(RuleType.SUCCESS.name()));\n\t}\n}"}, "SUCCESS");
    }

    public void test024() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n     final enum Y {\n\t    FOO() {}\n     }\n\t}\n}\n\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tfinal enum Y {\n\t           ^\nIllegal modifier for local enum Y; no explicit modifier is permitted\n----------\n");
    }

    public void test025() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n      enum Y {\n\tSUC, CESS;\n\tpublic static void main(String[] args) {\n\t\tfor (Y y : values()) {\n\t\t\tSystem.out.print(y.name());\n\t\t}\n\t}\n\t}\n\tY.main(args);\n}\n}"}, "SUCCESS");
    }

    public void test026() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t   enum Couleur { BLEU, BLANC, ROUGE }\n   }\n  class Y {\n\tvoid foo(Couleur c) {\n\t\tswitch (c) {\n\t\t\tcase BLEU :\n\t\t\t\tbreak;\n\t\t\tcase BLANC :\n\t\t\t\tbreak;\n\t\t\tcase ROUGE :\n\t\t\t\tbreak;\n\t\t}\n\t}\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tvoid foo(Couleur c) {\n\t         ^^^^^^^\nCouleur cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 8)\n\tcase BLEU :\n\t     ^^^^\nBLEU cannot be resolved to a variable\n----------\n3. ERROR in X.java (at line 10)\n\tcase BLANC :\n\t     ^^^^^\nBLANC cannot be resolved to a variable\n----------\n4. ERROR in X.java (at line 12)\n\tcase ROUGE :\n\t     ^^^^^\nROUGE cannot be resolved to a variable\n----------\n");
    }

    public void test027() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args) {\n\tenum Couleur { BLEU, BLANC, ROUGE }\n\tclass Y {\n\t\tvoid foo(Couleur c) {\n\t\t\tswitch (c) {\n\t\t\t\tcase BLEU :\n\t\t\t\t\tbreak;\n\t\t\t\tcase BLANC :\n\t\t\t\t\tbreak;\n\t\t\t\tcase ROUGE :\n\t\t\t\t\tbreak;\n               default: // nop\n\t\t\t}\n\t\t}\t\n\t}\n  }\n}\n"}, "");
    }

    public void test028() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args) {\n\tenum Couleur { \n\t\tBLEU, BLANC, ROUGE;\n\t\tstatic int C = 0;\n\t\tstatic void FOO() {}\n\t}\n\tclass Y {\n\t\tvoid foo(Couleur c) {\n\t\t\tswitch (c) {\n\t\t\t\tcase BLEU :\n\t\t\t\t\tbreak;\n\t\t\t\tcase BLANC :\n\t\t\t\t\tbreak;\n\t\t\t\tcase ROUGE :\n\t\t\t\t\tbreak;\n               default: // nop\n\t\t\t}\n\t\t\tFOO();\n\t\t\tC++;\n\t\t}\t\n\t}\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 19)\n\tFOO();\n\t^^^\nThe method FOO() is undefined for the type Y\n----------\n2. ERROR in X.java (at line 20)\n\tC++;\n\t^\nC cannot be resolved to a variable\n----------\n");
    }

    public void test029() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args) {\n\tenum Couleur { \n\t\tBLEU, BLANC, ROUGE; // take precedence over toplevel BLEU type\n\t}\n\tclass Y {\n\t\tvoid foo(Couleur c) {\n\t\t\tswitch (c) {\n\t\t\t\tcase BLEU :\n\t\t\t\t\tbreak;\n\t\t\t\tcase BLANC :\n\t\t\t\t\tbreak;\n\t\t\t\tcase ROUGE :\n\t\t\t\t\tbreak;\n               default: // nop\n\t\t\t}\n\t\t}\t\n\t}\n  }\n}\n\nclass BLEU {}\n"}, "");
    }

    public void test030() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args) {\n\tenum Couleur { \n\t\tBLEU, BLANC, ROUGE; // take precedence over sibling constant from Color\n\t}\n\tenum Color { \n\t\tBLEU, BLANC, ROUGE;\n\t}\n\tclass Y {\n\t\tvoid foo(Couleur c) {\n\t\t\tswitch (c) {\n\t\t\t\tcase BLEU :\n\t\t\t\t\tbreak;\n\t\t\t\tcase BLANC :\n\t\t\t\t\tbreak;\n\t\t\t\tcase ROUGE :\n\t\t\t\t\tbreak;\n               default: // nop\n\t\t\t}\n\t\t}\t\n\t}\n  }\n}\n\nclass BLEU {}\n"}, "");
    }

    public void test031() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args) {\n\tenum Couleur { \n\t\tBLEU, BLANC, ROUGE; // take precedence over toplevel BLEU type\n\t}\n\tclass Y implements IX, JX {\n\t\tvoid foo(Couleur c) {\n\t\t\tswitch (c) {\n\t\t\t\tcase BLEU :\n\t\t\t\t\tbreak;\n\t\t\t\tcase BLANC :\n\t\t\t\t\tbreak;\n\t\t\t\tcase ROUGE :\n\t\t\t\t\tbreak;\n               default: // nop\n\t\t\t}\n\t\t}\t\n\t}\n  }\n}\n\ninterface IX {\n\tint BLEU = 1;\n}\ninterface JX {\n\tint BLEU = 2;\n}\nclass BLEU {}\n\n"}, "");
    }

    public void test032() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args) {\n     class Y extends Enum {\n\t}\n  }\n}"}, "----------\n1. WARNING in X.java (at line 3)\n\tclass Y extends Enum {\n\t                ^^^^\nEnum is a raw type. References to generic type Enum<E> should be parameterized\n----------\n2. ERROR in X.java (at line 3)\n\tclass Y extends Enum {\n\t                ^^^^\nThe type Y may not subclass Enum explicitly\n----------\n");
    }

    public void test033() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args) {\n\t/**\n\t * Valid javadoc\n\t * @author ffr\n\t */\n enum E {\n\t/** Valid javadoc */\n\tTEST,\n\t/** Valid javadoc */\n\tVALID;\n\t/** Valid javadoc */\n\tpublic void foo() {}\n\t}\n  }\n}\n"});
    }

    public void test034() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args) {\n\t/**\n\t * Invalid javadoc\n\t * @exception NullPointerException Invalid tag\n\t * @throws NullPointerException Invalid tag\n\t * @return Invalid tag\n\t * @param x Invalid tag\n\t */\n\t enum E { TEST, VALID }\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\t* @exception NullPointerException Invalid tag\n\t   ^^^^^^^^^\nJavadoc: Unexpected tag\n----------\n2. ERROR in X.java (at line 6)\n\t* @throws NullPointerException Invalid tag\n\t   ^^^^^^\nJavadoc: Unexpected tag\n----------\n3. ERROR in X.java (at line 7)\n\t* @return Invalid tag\n\t   ^^^^^^\nJavadoc: Unexpected tag\n----------\n4. ERROR in X.java (at line 8)\n\t* @param x Invalid tag\n\t   ^^^^^\nJavadoc: Unexpected tag\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test035() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args) {\n\t/**\n\t * @see \"Valid normal string\"\n\t * @see <a href=\"http://download.oracle.com/javase/6/docs/technotes/tools/windows/javadoc.html\">Valid URL link reference</a>\n\t * @see Object\n\t * @see #TEST\n\t * @see E\n\t * @see E#TEST\n\t */\n    enum E { TEST, VALID }\n  }\n}"});
    }

    public void test036() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args) {\n\t/**\n\t * @see \"invalid\" no text allowed after the string\n\t * @see <a href=\"invalid\">invalid</a> no text allowed after the href\n\t * @see\n\t * @see #VALIDE\n\t */\n    enum E { TEST, VALID }\n  }\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\t* @see \"invalid\" no text allowed after the string\n\t                ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Unexpected text\n----------\n2. ERROR in X.java (at line 5)\n\t* @see <a href=\"invalid\">invalid</a> no text allowed after the href\n\t                                 ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Unexpected text\n----------\n3. ERROR in X.java (at line 6)\n\t* @see\n\t   ^^^\nJavadoc: Missing reference\n----------\n4. ERROR in X.java (at line 7)\n\t* @see #VALIDE\n\t        ^^^^^^\nJavadoc: VALIDE cannot be resolved or is not a field\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test037() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args) {\n\t/**\n\t * Value test: {@value #TEST}\n\t * or: {@value E#TEST}\n\t */\n    enum E { TEST, VALID }\n  }\n}"});
    }

    public void test038() {
        this.reportMissingJavadocComments = "error";
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args) {\n    enum E { TEST, VALID;\n\t  public void foo() {}\n  }\n}\n}"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X {\n\t             ^\nJavadoc: Missing comment for public declaration\n----------\n2. ERROR in X.java (at line 2)\n\tpublic static void main(String[] args) {\n\t                   ^^^^^^^^^^^^^^^^^^^\nJavadoc: Missing comment for public declaration\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test039() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args) {\n    enum E {\n\t/**\n\t * @exception NullPointerException Invalid tag\n\t * @throws NullPointerException Invalid tag\n\t * @return Invalid tag\n\t * @param x Invalid tag\n\t */\n\tTEST,\n\tVALID;\n  }\n}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\t* @exception NullPointerException Invalid tag\n\t   ^^^^^^^^^\nJavadoc: Unexpected tag\n----------\n2. ERROR in X.java (at line 6)\n\t* @throws NullPointerException Invalid tag\n\t   ^^^^^^\nJavadoc: Unexpected tag\n----------\n3. ERROR in X.java (at line 7)\n\t* @return Invalid tag\n\t   ^^^^^^\nJavadoc: Unexpected tag\n----------\n4. ERROR in X.java (at line 8)\n\t* @param x Invalid tag\n\t   ^^^^^\nJavadoc: Unexpected tag\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test040() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args) {\n    enum E {\n\t/**\n\t * @see E\n\t * @see #VALID\n\t */\n\tTEST,\n\t/**\n\t * @see E#TEST\n\t * @see E\n\t */\n\tVALID;\n\t/**\n\t * @param x the object\n\t * @return String\n\t * @see Object\n\t */\n\tpublic String val(Object x) { return x.toString(); }\n  }\n}\n}\n"});
    }

    public void test041() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args) {\n    enum E {\n\t/**\n\t * @see e\n\t * @see #VALIDE\n\t */\n\tTEST,\n\t/**\n\t * @see E#test\n\t * @see EUX\n\t */\n\tVALID;\n\t/**\n\t * @param obj the object\n\t * @return\n\t * @see Objet\n\t */\n\tpublic String val(Object x) { return x.toString(); }\n  }\n}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\t* @see e\n\t       ^\nJavadoc: e cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 6)\n\t* @see #VALIDE\n\t        ^^^^^^\nJavadoc: VALIDE cannot be resolved or is not a field\n----------\n3. ERROR in X.java (at line 10)\n\t* @see E#test\n\t         ^^^^\nJavadoc: test cannot be resolved or is not a field\n----------\n4. ERROR in X.java (at line 11)\n\t* @see EUX\n\t       ^^^\nJavadoc: EUX cannot be resolved to a type\n----------\n5. ERROR in X.java (at line 15)\n\t* @param obj the object\n\t         ^^^\nJavadoc: Parameter obj is not declared\n----------\n6. ERROR in X.java (at line 16)\n\t* @return\n\t   ^^^^^^\nJavadoc: Description expected after @return\n----------\n7. ERROR in X.java (at line 17)\n\t* @see Objet\n\t       ^^^^^\nJavadoc: Objet cannot be resolved to a type\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test042() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args) {\n    enum E {\n\t/**\n\t * Test value: {@value #TEST}\n\t */\n\tTEST,\n\t/**\n\t * Valid value: {@value E#VALID}\n\t */\n\tVALID;\n\t/**\n\t * Test value: {@value #TEST}\n\t * Valid value: {@value E#VALID}\n\t * @param x the object\n\t * @return String\n\t */\n\tpublic String val(Object x) { return x.toString(); }\n  }\n}\n}\n"});
    }

    public void _NAtest043() {
        this.runConformTest(new String[]{"test/E.java", "package test;\npublic enum E { TEST, VALID }\n", "test/X.java", "import static test.E.TEST;\n\t/**\n\t * @see test.E\n\t * @see test.E#VALID\n\t * @see #TEST\n\t */\npublic class X {}\n"});
    }

    public void _NAtest044() {
        this.runConformTest(new String[]{"test/E.java", "package test;\npublic enum E { TEST, VALID }\n", "test/X.java", "import static test.E.TEST;\n\t/**\n\t * Valid value = {@value test.E#VALID}\n\t * Test value = {@value #TEST}\n\t */\npublic class X {}\n"});
    }

    public void test045() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args) {\n    enum Y {\n      FIRST,\n      SECOND,\n      THIRD;\n\n      static {\n        for (Y t : values()) {\n          System.out.print(t.name());\n        }\n      }\n\n      Y() {}\n      static void foo(){}\n\n     }\n     Y.foo();\n   }\n}"}, "FIRSTSECONDTHIRD");
    }

    public void test046() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args) {\n    enum Y{\n  a(1);\n  Y(int i) {\n  }\n  }\n  }\n}"}, "");
    }

    public void test047() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args) {\n    enum Y{ \n\t;\n\tY() {\n\t\tsuper();\n\t}\n  }\n   }\n}"}, "----------\n1. ERROR in X.java (at line 6)\n\tsuper();\n\t^^^^^^^^\nCannot invoke super constructor from enum constructor Y()\n----------\n");
    }

    public void test048() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args) {\n    enum StopLight {\n    RED{\n        public StopLight next(){ return GREEN; }\n    },\n    GREEN{\n        public StopLight next(){ return YELLOW; }\n    },\n    YELLOW{\n        public StopLight next(){ return RED; }\n    };\n\n   public abstract StopLight next();\n   }\n   }\n}"}, "");
    }

    public void test049() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args) {\n    public abstract enum Y {}\n   }\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tpublic abstract enum Y {}\n\t                     ^\nIllegal modifier for local enum Y; no explicit modifier is permitted\n----------\n");
    }

    public void test050() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args) {\n     enum Y {}\n   }\n}"}, "");
    }

    public void test051() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args) {\n     enum Y {\n\tBLEU (0) {\n\t}\n\t;\n\tY() {\n\t\tthis(0);\n\t}\n\tY(int i) {\n\t}\n   }\n   }\n}\n"}, "");
    }

    public void test052() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args) {\n     enum Y {\n\tA\n\t;\n\t\n\tpublic abstract void foo();\n   }\n   }\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tA\n\t^\nThe enum constant A must implement the abstract method foo()\n----------\n");
    }

    public void test053() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args) {\n     enum Y {\n\tA () { public void foo() {} }\n\t;\n\t\n\tpublic abstract void foo();\n   }\n   }\n}\n"}, "");
    }

    public void test054() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args) {\n     enum Y {\n\tA() {}\n\t;\n\t\n\tpublic abstract void foo();\n   }\n   }\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tA() {}\n\t^\nThe enum constant A must implement the abstract method foo()\n----------\n");
    }

    public void test055() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args) {\n     enum Y {\n\t;\n\t\n\tpublic abstract void foo();\n   }\n   }\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tpublic abstract void foo();\n\t                     ^^^^^\nThe enum Y can only define the abstract method foo() if it also defines enum constants with corresponding implementations\n----------\n");
    }

    public void test056() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args) {\n     enum Y {\n    PLUS {\n        double eval(double x, double y) { return x + y; }\n    };\n\n    // Perform the arithmetic X represented by this constant\n    abstract double eval(double x, double y);\n   }\n   }\n}"}, "");
        String expectedOutput = "// Signature: Ljava/lang/Enum<LX$1Y;>;\nabstract static enum X$1Y {\n";
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        byte[] classFileBytes = Util.getFileByteContent((File)new File(OUTPUT_DIR + File.separator + "X$1Y.class"));
        String actualOutput = disassembler.disassemble(classFileBytes, "\n", 1);
        int index = actualOutput.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(actualOutput, 3));
        }
        if (index == -1) {
            LocalEnumTest.assertEquals("Wrong contents", expectedOutput, actualOutput);
        }
    }

    public void test057() {
        this.runConformTest(new String[]{"Enum2.java", "public class Enum2 {\n    public static void main(String[] args) {\n    \tenum Color { RED, GREEN };\n        Color c= Color.GREEN;\n        switch (c) {\n        case RED:\n            System.out.println(Color.RED);\n            break;\n        case GREEN:\n            System.out.println(c);\n            break;\n        default: // nop\n        }\n    }\n}\n"}, "GREEN");
    }

    public void test058() {
        this.runNegativeTest(new String[]{"X.java", "class A {\n\tpublic static void main(String[] args) {\n\tenum X { a }\n\tclass B {\n\t void _test(X x, int a) {\n\t\tif (x == a) a++; // incomparable types: X and int\n\t\tswitch(x) {\n\t\t\tcase a : System.out.println(a); // prints '9'\n           default: // nop\n\t\t}\n\t}\n\t void _test2(X x, final int aa) {\n\t\tswitch(x) {\n\t\t\tcase aa : // unqualified enum constant error\n\t\t\t\tSystem.out.println(a); // cannot find a\n           default: // nop\n\t\t}\n\t}\n\t}\n\t\tnew B()._test(X.a, 9);\n\t\tnew B()._test2(X.a, 3);\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tif (x == a) a++; // incomparable types: X and int\n\t    ^^^^^^\nIncompatible operand types X and int\n----------\n2. ERROR in X.java (at line 14)\n\tcase aa : // unqualified enum constant error\n\t     ^^\naa cannot be resolved or is not a field\n----------\n3. ERROR in X.java (at line 15)\n\tSystem.out.println(a); // cannot find a\n\t                   ^\na cannot be resolved to a variable\n----------\n");
    }

    public void test059() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args) {\n     enum Y {\n\t  \tMONDAY {\n\t\t\tpublic void foo() {\n\t\t}\n\t  };\n\t\tprivate Y() {}\n\t\tpublic static void main(String[] ags) {\n\t  \t\tSystem.out.println(\"SUCCESS\");\n\t\t}\n\t  }\n\t  Y.main(args);\n\t}\n}\n"}, "SUCCESS");
    }

    public void _NAtest060() {
        this.runNegativeTest(new String[]{"com/flarion/test/a/MyEnum.java", "package com.flarion.test.a;\npublic enum MyEnum {\n\n    First, Second;\n    \n}\n", "com/flarion/test/b/MyClass.java", "package com.flarion.test.b;\nimport com.flarion.test.a.MyEnum;\nimport static com.flarion.test.a.MyEnum.First;\nimport static com.flarion.test.a.MyEnum.Second;\npublic class MyClass {\n\n    public void myMethod() {\n        MyEnum e = MyEnum.First;\n        switch (e) {\n        case First:\n            break;\n        case Second:\n            break;\n        default: // nop\n        }\n        throw new Exception();\n    }\n}\n"}, "----------\n1. WARNING in com\\flarion\\test\\b\\MyClass.java (at line 3)\n\timport static com.flarion.test.a.MyEnum.First;\n\t              ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nThe import com.flarion.test.a.MyEnum.First is never used\n----------\n2. WARNING in com\\flarion\\test\\b\\MyClass.java (at line 4)\n\timport static com.flarion.test.a.MyEnum.Second;\n\t              ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nThe import com.flarion.test.a.MyEnum.Second is never used\n----------\n3. ERROR in com\\flarion\\test\\b\\MyClass.java (at line 16)\n\tthrow new Exception();\n\t^^^^^^^^^^^^^^^^^^^^^^\nUnhandled exception type Exception\n----------\n");
    }

    public void test061() {
        this.runNegativeTest(new String[]{"X.java", "\nclass A {\n\tpublic void foo() {\n\t\t enum X {\n\t\t\tA, B, C;\n\t\t\tpublic static final X D = null;\n\t\t}\n\t\tX x = X.A;\n\t\tswitch (x) {\n\t\t\tcase D:\n\t\t}\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 9)\n\tswitch (x) {\n\t        ^\nThe enum constant A needs a corresponding case label in this enum switch on X\n----------\n2. WARNING in X.java (at line 9)\n\tswitch (x) {\n\t        ^\nThe enum constant B needs a corresponding case label in this enum switch on X\n----------\n3. WARNING in X.java (at line 9)\n\tswitch (x) {\n\t        ^\nThe enum constant C needs a corresponding case label in this enum switch on X\n----------\n4. ERROR in X.java (at line 10)\n\tcase D:\n\t     ^\nThe field X.D cannot be referenced from an enum case label; only enum constants can be used in enum switch\n----------\n");
    }

    public void test062() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.missingDefaultCase", "warning");
        this.runNegativeTest(new String[]{"X.java", "\nclass A {\n\tprivate void foo() {\n\t\tenum X {\n\t\t\tA, B, C;\n\t\t\tpublic static final X D = null;\n\t\t}\n\t\tX x = X.A;\n\t\tswitch (x) {\n\t\t\tcase X.D:\n\t\t}\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 9)\n\tswitch (x) {\n\t        ^\nThe switch over the enum type X should have a default case\n----------\n2. WARNING in X.java (at line 9)\n\tswitch (x) {\n\t        ^\nThe enum constant A needs a corresponding case label in this enum switch on X\n----------\n3. WARNING in X.java (at line 9)\n\tswitch (x) {\n\t        ^\nThe enum constant B needs a corresponding case label in this enum switch on X\n----------\n4. WARNING in X.java (at line 9)\n\tswitch (x) {\n\t        ^\nThe enum constant C needs a corresponding case label in this enum switch on X\n----------\n5. ERROR in X.java (at line 10)\n\tcase X.D:\n\t       ^\nThe field X.D cannot be referenced from an enum case label; only enum constants can be used in enum switch\n----------\n", null, true, options);
    }

    public void test063() {
        this.runConformTest(new String[]{"X.java", "public class X<T> {\n  public static void main(String[] args) {\n  enum Option { ALPHA, BRAVO  };\n    Option item = Option.ALPHA;\n    switch (item) {\n    case ALPHA:      break;\n    case BRAVO:      break;\n    default:         break;\n    }\n  }\n}\n"}, "");
    }

    public void test064() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args) {\ninterface B {\n\tpublic void _test();\n\t\n\t}\n\t enum Y implements B {\n\n\t\tC1 {\n\t\t\tpublic void _test() {};\n\t\t},\n\t\tC2 {\n\t\t\tpublic void _test() {};\n\t\t}\n\t}\n\n\t}\n}\n"}, "");
    }

    public void test065() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args) {\n\t enum Y  {\n \t\tA;\n  \t\tprivate void foo() {\n    \t\tY e= new Y() {\n    \t\t};\n  \t\t}\n  \t  }\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tY e= new Y() {\n\t         ^\nCannot instantiate the type Y\n----------\n");
    }

    public void test066() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args) {\n\t enum Y  {\n    \tSUCCESS (0) {};\n    \tprivate Y(int i) {}\n    \tpublic static void main(String[] args) {\n       \tfor (Y y : values()) {\n           \tSystem.out.print(y);\n       \t}\n   \t}\n   }\n   Y.main(args);\n  }\n}"}, "SUCCESS");
    }

    public void test067() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args) {\n\t enum Y  {\n    \tONE, TWO, THREE;\n    \tabstract int getSquare();\n    \tabstract int getSquare();\n    }\n  }\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\tONE, TWO, THREE;\n\t^^^\nThe enum constant ONE must implement the abstract method getSquare()\n----------\n2. ERROR in X.java (at line 4)\n\tONE, TWO, THREE;\n\t     ^^^\nThe enum constant TWO must implement the abstract method getSquare()\n----------\n3. ERROR in X.java (at line 4)\n\tONE, TWO, THREE;\n\t          ^^^^^\nThe enum constant THREE must implement the abstract method getSquare()\n----------\n4. ERROR in X.java (at line 5)\n\tabstract int getSquare();\n\t             ^^^^^^^^^^^\nDuplicate method getSquare() in type Y\n----------\n5. ERROR in X.java (at line 6)\n\tabstract int getSquare();\n\t             ^^^^^^^^^^^\nDuplicate method getSquare() in type Y\n----------\n");
    }

    public void test068() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args) {\n\t enum Y  {\n    \tA(1, 3), B(1, 3), C(1, 3) { }\n   \t;\n    \tpublic Y(int i, int j) { }\n    }\n  }\n}"}, "----------\n1. ERROR in X.java (at line 6)\n\tpublic Y(int i, int j) { }\n\t       ^^^^^^^^^^^^^^^\nIllegal modifier for the enum constructor; only private is permitted.\n----------\n");
    }

    public void test069() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args) {\n\t enum Y  {\n    \tA(1, 3), B(1, 3), C(1, 3) { }\n   \t;\n    \tprotected Y(int i, int j) { }\n    }\n  }\n}"}, "----------\n1. ERROR in X.java (at line 6)\n\tprotected Y(int i, int j) { }\n\t          ^^^^^^^^^^^^^^^\nIllegal modifier for the enum constructor; only private is permitted.\n----------\n");
    }

    public void test070() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args) {\n\t enum Y  {\n    \tPLUS {\n        \tdouble eval(double x, double y) { return x + y; }\n    \t};\n\n    \t// Perform the arithmetic X represented by this constant\n    \tabstract double eval(double x, double y);\n    }\n  }\n}"}, "");
        String expectedOutput = "  // Method descriptor #18 (Ljava/lang/String;I)V\n  // Stack: 3, Locals: 3\n  private X$1Y(java.lang.String arg0, int arg1);\n    0  aload_0 [this]\n    1  aload_1 [arg0]\n    2  iload_2 [arg1]\n    3  invokespecial java.lang.Enum(java.lang.String, int) [25]\n    6  return\n";
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        byte[] classFileBytes = Util.getFileByteContent((File)new File(OUTPUT_DIR + File.separator + "X$1Y.class"));
        String actualOutput = disassembler.disassemble(classFileBytes, "\n", 1);
        int index = actualOutput.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(actualOutput, 3));
        }
        if (index == -1) {
            LocalEnumTest.assertEquals("Wrong contents", expectedOutput, actualOutput);
        }
    }

    public void test071() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args) {\n    enum X1 implements I {\n\t;\n    }\n  }\n}\ninterface I {}\n"}, "");
        this.runConformTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args) {\n\tenum X1a implements I {\n\t\tA;\n    }\n  }\n}\ninterface I {}\n"}, "");
        this.runConformTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args) {\n  \tenum X1b implements I {\n\t\tA() { void random() {} };\n\t}\n  }\n}\ninterface I {}\n"}, "");
    }

    public void test072() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args) {\n  \tenum X2 implements I {\n\t;\n\t\tpublic void _test() {}\n\t}\n  }\n}\ninterface I { void _test(); }\n"}, "");
        this.runConformTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args) {\n\t enum X2a implements I {\n\t \tA;\n\t public void _test() {}\n\t}\n  }\n}\ninterface I { void _test(); }\n"}, "");
        this.runConformTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args) {\n\t\tenum X2b implements I {\n\t\t\tA() { public void _test() {} };\n\t\tpublic void _test() {}\n\t}\n  }\n}\ninterface I { void _test(); }\n"}, "");
        this.runConformTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args) {\n \t enum X2c implements I {\n\t\tA() { void random() {} };\n\t\tpublic void _test() {}\n\t}\n  }\n}\ninterface I { void _test(); }\n"}, "");
    }

    public void test073() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args) {\n\t\tenum X3 implements I {\n\t;\n\t\tpublic abstract void _test();\n\t}\n  }\n}\ninterface I { void _test(); }\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tpublic abstract void _test();\n\t                     ^^^^^^^\nThe enum X3 can only define the abstract method _test() if it also defines enum constants with corresponding implementations\n----------\n");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args) {\n  \tenum X3a implements I {\n\t\tA;\n\t\tpublic abstract void _test();\n\t}\n  }\n}\ninterface I { void _test(); }\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tA;\n\t^\nThe enum constant A must implement the abstract method _test()\n----------\n");
        this.runConformTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args) {\n\tenum X3b implements I {\n\t\tA() { public void _test() {} };\n\t\tpublic abstract void _test();\n\t}\n  }\n}\ninterface I { void _test(); }\n"}, "");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args) {\n \t enum X3c implements I {\n\t\tA() { void random() {} };\n\t public abstract void _test();\n\t}\n  }\n}\ninterface I { void _test(); }\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tA() { void random() {} };\n\t^\nThe enum constant A must implement the abstract method _test()\n----------\n");
    }

    public void test074() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args) {\n  \tenum X4 {\n\t;\n\t\tpublic abstract void _test();\n\t}\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tpublic abstract void _test();\n\t                     ^^^^^^^\nThe enum X4 can only define the abstract method _test() if it also defines enum constants with corresponding implementations\n----------\n");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args) {\n \tenum X4a {\n\t\tA;\n\t\tpublic abstract void _test();\n\t}\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tA;\n\t^\nThe enum constant A must implement the abstract method _test()\n----------\n");
        this.runConformTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args) {\n\tenum X4b {\n\t\tA() { public void _test() {} };\n\t\tpublic abstract void _test();\n\t}\n  }\n}\n"}, "");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args) {\n\t\tenum X4c {\n\t\t\tA() { void random() {} };\n\t\tpublic abstract void _test();\n\t}\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tA() { void random() {} };\n\t^\nThe enum constant A must implement the abstract method _test()\n----------\n");
    }

    public void testNPE075() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args) {\n  \tenum X5 implements I {\n\t;\n\t}\n  }\n}\ninterface I { void _test(); }\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tenum X5 implements I {\n\t     ^^\nThe type X5 must implement the inherited abstract method I._test()\n----------\n");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args) {\n\tenum X5a implements I {\n\t\tA;\n\t}\n  }\n}\ninterface I { void _test(); }\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tenum X5a implements I {\n\t     ^^^\nThe type X5a must implement the inherited abstract method I._test()\n----------\n");
        this.runConformTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args) {\n  \tenum X5b implements I {\n\t\tA() { public void _test() {} };\n\t;\n\t}\n  }\n}\ninterface I { void _test(); }\n"}, "");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args) {\n\tenum X5c implements I {\n\t\tA() { void random() {} };\n\t\t;\n\tprivate X5c() {}\n\t}\n  }\n}\ninterface I { void _test(); }\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tA() { void random() {} };\n\t^\nThe enum constant A must implement the abstract method _test()\n----------\n");
    }

    public void test076() {
        this.runConformTest(new String[]{"X.java", "public class X {\nenum E implements I {\n\tA;\n\tpublic E foo() {\n\t\tSystem.out.println(\"SUCCESS\");\n\t\treturn null;\n\t}\n}\n\tpublic static void main(String[] args) { ((I) E.A).foo(); }\n}\ninterface I { I foo(); }\n"}, "SUCCESS");
    }

    public void test077() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t\n\tpublic static void main(String[] args) {\nenum E {\n\tA {\n\t\tvoid bar() {\n\t\t\tnew M();\n\t\t}\n\t};\n\tabstract void bar();\n\t\n\tclass M {\n\t\tM() {\n\t\t\tSystem.out.println(\"SUCCESS\");\n\t\t}\n\t}\n}\n\t\tE.A.bar();\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 6)\n\tvoid bar() {\n\t     ^^^^^\nThe method bar() of type new E(){} should be tagged with @Override since it actually overrides a superclass method\n----------\n2. ERROR in X.java (at line 7)\n\tnew M();\n\t^^^^^^^\nCannot instantiate local class 'E.M' in a static context\n----------\n");
    }

    public void test078() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t\n\tpublic static void main(String[] args) {\nenum E {\n\tA {\n\t\tvoid bar() {\n\t\t\tnew X(){\n\t\t\t\tvoid baz() {\n\t\t\t\t\tnew M();\n\t\t\t\t}\n\t\t\t}.baz();\n\t\t}\n\t};\n\tabstract void bar();\n\t\n\tclass M {\n\t\tM() {\n\t\t\tSystem.out.println(\"SUCCESS\");\n\t\t}\n\t}\n}\n\t\tE.A.bar();\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 6)\n\tvoid bar() {\n\t     ^^^^^\nThe method bar() of type new E(){} should be tagged with @Override since it actually overrides a superclass method\n----------\n2. ERROR in X.java (at line 9)\n\tnew M();\n\t^^^^^^^\nCannot instantiate local class 'E.M' in a static context\n----------\n");
    }

    public void test079() throws Exception {
        if (this.complianceLevel < 0x3D0000L) {
            return;
        }
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t\n\tpublic static void main(String[] args) {\n     enum Y {\n\t\tA, B;\n\t\tprivate strictfp Y() {}\n\t  }\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 6)\n\tprivate strictfp Y() {}\n\t        ^^^^^^^^\nFloating-point expressions are always strictly evaluated from source level 17. Keyword 'strictfp' is not required.\n----------\n2. ERROR in X.java (at line 6)\n\tprivate strictfp Y() {}\n\t                 ^^^\nIllegal modifier for the constructor in type Y; only public, protected & private are permitted\n----------\n");
        this.runConformTest(new String[]{"X.java", "public class X {\n\t\n\tpublic static void main(String[] args) {\n\t\tstrictfp enum Y {\n\t\tA, B;\n\t\tprivate Y() {}\n\t  }\n\t}\n}\n"}, "");
        String[] expectedOutputs = new String[]{"  private X$1Y(java.lang.String arg0, int arg1);\n", "  public static new X(){}[] values();\n", "  public static new X(){} valueOf(java.lang.String arg0);\n"};
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        byte[] classFileBytes = Util.getFileByteContent((File)new File(OUTPUT_DIR + File.separator + "X$1Y.class"));
        String actualOutput = disassembler.disassemble(classFileBytes, "\n", 1);
        int i = 0;
        int max = expectedOutputs.length;
        while (i < max) {
            String expectedOutput = expectedOutputs[i];
            int index = actualOutput.indexOf(expectedOutput);
            if (index == -1 || expectedOutput.length() == 0) {
                System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(actualOutput, 3));
            }
            if (index == -1) {
                LocalEnumTest.assertEquals("Wrong contents", expectedOutput, actualOutput);
            }
            ++i;
        }
    }

    public void test080() {
        this.runConformTest(new String[]{"X.java", "interface TestInterface {\n\tint test();\n}\n\npublic class X {\n\tpublic static void main(String[] args) {\n   \tenum Y implements TestInterface {\n\t\tTEST {\n\t\t\tpublic int test() {\n\t\t\t\treturn 42;\n\t\t\t}\n\t\t},\n\t\tENUM {\n\t\t\tpublic int test() {\n\t\t\t\treturn 37;\n\t\t\t}\n\t\t};\n\t  }\n\t}\n} \n"}, "");
    }

    public void test081() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {}\n\tvoid foo() {\n\t\tenum E {}\n\t}\n}"}, "");
    }

    public void test082() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\tclass Y {\n\t\tenum E {}\n\t}\n\t}\n}"}, "");
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t class Y {\n\t\tenum E {}\n\t}\n}\n}"}, "");
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {}\n\tvoid foo() {\n\t\tclass Local {\n\t\t\tenum E {}\n\t\t}\n\t}\n}"}, "");
    }

    public void test083() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n \t\tenum Y {\n\tINPUT {\n\t\t@Override\n\t\tpublic Y getReverse() {\n\t\t\treturn OUTPUT;\n\t\t}\n\t},\n\tOUTPUT {\n\t\t@Override\n\t\tpublic Y getReverse() {\n\t\t\treturn INPUT;\n\t\t}\n\t},\n\tINOUT {\n\t\t@Override\n\t\tpublic Y getReverse() {\n\t\t\treturn INOUT;\n\t\t}\n\t};\n\tY(){}\n  Zork z;\n\tpublic abstract Y getReverse();\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 23)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test084() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n \t\tenum Y {\n\tINPUT {\n\t\t@Override\n\t\tpublic Y getReverse() {\n\t\t\treturn OUTPUT;\n\t\t}\n\t},\n\tOUTPUT {\n\t\t@Override\n\t\tpublic Y getReverse() {\n\t\t\treturn INPUT;\n\t\t}\n\t},\n\tINOUT {\n\t\t@Override\n\t\tpublic Y getReverse() {\n\t\t\treturn INOUT;\n\t\t}\n\t};\n\tY(){}\n\tpublic abstract Y getReverse();\n\t\t}\n\t\t}\n}\n"}, "");
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        byte[] classFileBytes = Util.getFileByteContent((File)new File(OUTPUT_DIR + File.separator + "X$1Y.class"));
        String actualOutput = disassembler.disassemble(classFileBytes, "\n", 1);
        String expectedOutput = "  // Method descriptor #20 (Ljava/lang/String;I)V\n  // Stack: 3, Locals: 3\n  private X$1Y(java.lang.String arg0, int arg1);\n";
        int index = actualOutput.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(actualOutput, 3));
        }
        if (index == -1) {
            LocalEnumTest.assertEquals("unexpected bytecode sequence", expectedOutput, actualOutput);
        }
    }

    public void test085() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\tenum Test1 {\n\t\ttest11, test12\n\t};\n\tenum Test2 {\n\t\ttest21, test22\n\t};\n\n  class Y {\n\tvoid foo1(Test1 t1, Test2 t2) {\n\t\tboolean b = t1 == t2;\n\t}\n\tvoid foo2(Test1 t1, Object t2) {\n\t\tboolean b = t1 == t2;\n\t}\n\tvoid foo3(Test1 t1, Enum t2) {\n\t\tboolean b = t1 == t2;\n\t}\n\tpublic void foo() {\n\t\tboolean booleanTest = (Test1.test11 == Test2.test22);\n\t}\n\t}\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 12)\n\tboolean b = t1 == t2;\n\t            ^^^^^^^^\nIncompatible operand types Test1 and Test2\n----------\n2. WARNING in X.java (at line 17)\n\tvoid foo3(Test1 t1, Enum t2) {\n\t                    ^^^^\nEnum is a raw type. References to generic type Enum<E> should be parameterized\n----------\n3. ERROR in X.java (at line 21)\n\tboolean booleanTest = (Test1.test11 == Test2.test22);\n\t                      ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nIncompatible operand types Test1 and Test2\n----------\n");
    }

    public void test086() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\tenum Test1 {\n\t\tV;\n\t\tstatic int foo = 0;\n\t}\n\t}\n}\n"}, "");
    }

    public void _test087_more_meaningful_error_msg_required() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\tenum Test1 {\n\t\tV;\n\t\tinterface Foo {}\n\t}\n\t}\n}\n"}, "");
    }

    public void test088() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\n\tenum Test1 {\n\t\tV;\n\t}\n\t}\n\tObject foo() {\n\t\treturn this;\n\t}\n\n}\n"}, "");
    }

    public void test089() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\n\tenum Test1 {\n\t\tV;\n\t\tprotected final Test1 clone() { return V; }\n\t}\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tprotected final Test1 clone() { return V; }\n\t                      ^^^^^^^\nCannot override the final method from Enum<Test1>\n----------\n2. WARNING in X.java (at line 6)\n\tprotected final Test1 clone() { return V; }\n\t                      ^^^^^^^\nThe method clone() of type Test1 should be tagged with @Override since it actually overrides a superclass method\n----------\n");
    }

    public void test090() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\n\tpublic static void main(String[] args) {\n\tenum Test1 {\n\t\tV;\n\t\tpublic Test1 foo() { return V; }\n\t}\n\t}\n\tZork z;\n}\n", "java/lang/Object.java", "package java.lang;\npublic class Object {\n\tpublic Object foo() { return this; }\n}\n"}, "----------\n1. WARNING in X.java (at line 6)\n\tpublic Test1 foo() { return V; }\n\t             ^^^^^\nThe method foo() of type Test1 should be tagged with @Override since it actually overrides a superclass method\n----------\n2. ERROR in X.java (at line 9)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test091() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\n\tpublic static void main(String[] args) {\n\tenum Test1 {\n\t\tV;\n\t\tvoid foo() {}\n\t}\n\tclass Member<E extends Test1> {\n\t\tvoid bar(E e) {\n\t\t\te.foo();\n\t\t}\n\t}\n\t}\n}\n"}, "");
    }

    public void test092() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\n\tpublic static void main(String[] args) {\n\tenum Test1 {\n\t\tV;\n\t\tvoid foo() {}\n\t}\n\tclass Member<E extends Object & Test1> {\n\t\tvoid bar(E e) {\n\t\t\te.foo();\n\t\t}\n\t}\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\tclass Member<E extends Object & Test1> {\n\t                                ^^^^^\nThe type Test1 is not an interface; it cannot be specified as a bounded parameter\n----------\n2. ERROR in X.java (at line 10)\n\te.foo();\n\t  ^^^\nThe method foo() is undefined for the type E\n----------\n");
    }

    public void test093() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\n\tpublic static void main(String[] args) {\n\tenum Test1 {\n\t\tV;\n\t\tvoid foo() {}\n\t}\n\tclass Member<E extends Test1> {\n\t\tE e;\n\t\tvoid bar(Member<? extends Test1> me) {\n\t\t}\n\t}\n\t}\n}\n"}, "");
    }

    public void test094() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tenum Y {}\n\t}\n}\n"}, "");
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        byte[] classFileBytes = Util.getFileByteContent((File)new File(OUTPUT_DIR + File.separator + "X$1Y.class"));
        String actualOutput = disassembler.disassemble(classFileBytes, "\n", 1);
        String expectedOutput = "// Signature: Ljava/lang/Enum<LX$1Y;>;\nstatic final enum X$1Y {\n  \n  // Field descriptor #6 [LX$1Y;\n  private static final synthetic X$1Y[] ENUM$VALUES;\n  \n  // Method descriptor #8 ()V\n  // Stack: 1, Locals: 0\n  static {};\n    0  iconst_0\n    1  anewarray X$1Y [1]\n    4  putstatic X$1Y.ENUM$VALUES : new X(){}[] [10]\n    7  return\n      Line numbers:\n        [pc: 0, line: 3]\n  \n  // Method descriptor #15 (Ljava/lang/String;I)V\n  // Stack: 3, Locals: 3\n  private X$1Y(java.lang.String arg0, int arg1);\n    0  aload_0 [this]\n    1  aload_1 [arg0]\n    2  iload_2 [arg1]\n    3  invokespecial java.lang.Enum(java.lang.String, int) [16]\n    6  return\n      Line numbers:\n        [pc: 0, line: 3]\n      Local variable table:\n        [pc: 0, pc: 7] local: this index: 0 type: new X(){}\n  \n  // Method descriptor #21 ()[LX$1Y;\n  // Stack: 5, Locals: 3\n  public static new X(){}[] values();\n     0  getstatic X$1Y.ENUM$VALUES : new X(){}[] [10]\n     3  dup\n     4  astore_0\n     5  iconst_0\n     6  aload_0\n     7  arraylength\n     8  dup\n     9  istore_1\n    10  anewarray X$1Y [1]\n    13  dup\n    14  astore_2\n    15  iconst_0\n    16  iload_1\n    17  invokestatic java.lang.System.arraycopy(java.lang.Object, int, java.lang.Object, int, int) : void [22]\n    20  aload_2\n    21  areturn\n      Line numbers:\n        [pc: 0, line: 1]\n  \n  // Method descriptor #29 (Ljava/lang/String;)LX$1Y;\n  // Stack: 2, Locals: 1\n  public static new X(){} valueOf(java.lang.String arg0);\n     0  ldc <Class X$1Y> [1]\n     2  aload_0 [arg0]\n     3  invokestatic java.lang.Enum.valueOf(java.lang.Class, java.lang.String) : java.lang.Enum [30]\n     6  checkcast X$1Y [1]\n     9  areturn\n";
        int index = actualOutput.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(actualOutput, 3));
        }
        if (index == -1) {
            LocalEnumTest.assertEquals("unexpected bytecode sequence", expectedOutput, actualOutput);
        }
    }

    public void testNPE095() {
        this.runNegativeTest(new String[]{"X.java", "public class X { \n\tpublic static void main(String[] args) {\n\t\tenum Y implements I, J { \n\t\t\tROUGE;\n\t\t}\n\t}\n}\ninterface I { void foo(); }\ninterface J { void foo(); }\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tenum Y implements I, J { \n\t     ^\nThe type Y must implement the inherited abstract method J.foo()\n----------\n");
        this.runNegativeTest(new String[]{"X.java", "public class X { \n\tpublic static void main(String[] args) {\n\t\tenum Y implements I, J { \n\t\t\tROUGE;\n\t\t\tpublic void foo() {}\n\t\t}\n\t}\n}\ninterface I { void foo(int i); }\ninterface J { void foo(); }\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tenum Y implements I, J { \n\t     ^\nThe type Y must implement the inherited abstract method I.foo(int)\n----------\n");
    }

    public void testNPE096() {
        this.runConformTest(new String[]{"X.java", "public class X { \n\tpublic static void main(String[] args) {\n\t\tenum Y implements I { \n\t\t\tROUGE;\n\t\t\tpublic void foo(A a) {}\n\t\t}\n\t}\n}\ninterface I { void foo(A<String> a); }\nclass A<T> {}\n"}, "");
        this.runConformTest(new String[]{"X.java", "public class X { \n\tpublic static void main(String[] args) {\n\t\t enum Y implements I { \n\t\t\tROUGE { public void foo(A a) {} }\n\t\t\t;\n\t\t}\n\t}\n}\ninterface I { void foo(A<String> a); }\nclass A<T> {}\n"}, "");
        this.runNegativeTest(new String[]{"X.java", "public class X { \n\tpublic static void main(String[] args) {\n\t\t enum Y implements I { \n\t\t\tROUGE;\n\t\t\tpublic void foo(A<String> a) {}\n\t\t}\n\t}\n}\ninterface I { void foo(A a); }\nclass A<T> {}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tenum Y implements I { \n\t     ^\nThe type Y must implement the inherited abstract method I.foo(A)\n----------\n2. ERROR in X.java (at line 5)\n\tpublic void foo(A<String> a) {}\n\t            ^^^^^^^^^^^^^^^^\nName clash: The method foo(A<String>) of type Y has the same erasure as foo(A) of type I but does not override it\n----------\n3. WARNING in X.java (at line 9)\n\tinterface I { void foo(A a); }\n\t                       ^\nA is a raw type. References to generic type A<T> should be parameterized\n----------\n");
    }

    public void test097() {
        this.runNegativeTest(new String[]{"E.java", "public class E {\n\tenum Numbers { ONE, TWO, THREE }\n\tstatic final String BLANK = \"    \";\n\tvoid foo() {\n\t\t/**\n\t\t * Enumeration of some basic colors.\n\t\t */\n\t\tenum Colors {\n\t\t\tBLACK,\n\t\t\tWHITE,\n\t\t\tRED  \n\t\t}\n\t\tColors color = Colors.BLACK;\n\t\tswitch (color) {\n\t\t\tcase BLUE:\n\t\t\tcase RED:\n\t\t\t\tbreak;\n\t\t\tdefault: // nop\n\t\t} \n\t}\n}\n"}, "----------\n1. ERROR in E.java (at line 15)\n\tcase BLUE:\n\t     ^^^^\nBLUE cannot be resolved or is not a field\n----------\n");
    }

    public void test098() {
        this.runNegativeTest(new String[]{"E.java", "public class E {\n\tenum Numbers { ONE, TWO, THREE }\n\tstatic final String BLANK = \"    \";\n\tvoid foo() {\n\t\t/**\n\t\t * Enumeration of some basic colors.\n\t\t */\n\t\tenum Colors {\n\t\t\tBLACK,\n\t\t\tWHITE,\n\t\t\tRED;  \n  \t\t\tZork z;\n\t\t}\n\t\tColors color = Colors.BLACK;\n\t\tswitch (color) {\n\t\t} \n\t}\n}\n"}, "----------\n1. ERROR in E.java (at line 12)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n2. WARNING in E.java (at line 15)\n\tswitch (color) {\n\t        ^^^^^\nThe enum constant BLACK needs a corresponding case label in this enum switch on Colors\n----------\n3. WARNING in E.java (at line 15)\n\tswitch (color) {\n\t        ^^^^^\nThe enum constant RED needs a corresponding case label in this enum switch on Colors\n----------\n4. WARNING in E.java (at line 15)\n\tswitch (color) {\n\t        ^^^^^\nThe enum constant WHITE needs a corresponding case label in this enum switch on Colors\n----------\n");
    }

    public void _NAtest099() {
        this.runNegativeTest(new String[]{"X.java", "class A<T> {\n\tpublic static void main(String[] args) {\n\tenum E {\n\t\tv1, v2;\n\t}\n\tpublic class X extends A<Integer> {\n\t\tvoid a(A.E e) {\n\t\t\tb(e); // no unchecked warning\n\t\t}\n\n\t\tvoid b(E e) {\n\t\t\tA<Integer>.E e1 = e;\n\t\t}\n\t}\n}\n}\n\n"}, "----------\n1. ERROR in X.java (at line 13)\n\tA<Integer>.E e1 = e;\n\t^^^^^^^^^^^^\nThe member type A.E cannot be qualified with a parameterized type, since it is static. Remove arguments from qualifying type A<Integer>\n----------\n");
    }

    public void testNPE100() {
        this.runNegativeTest(new String[]{"X.java", "public class X { \n\tpublic static void main(String[] args) {\n\t\tenum Y {\n\n\t\t\tanEnumValue {\n\t\t\t\tprivate final Y thisOne = anEnumValue;\n\n\t\t\t\t@Override String getMessage() {\n\t\t\t\t\treturn \"Here is what thisOne gets assigned: \" + thisOne;\n\t\t\t\t}\n\t\t\t};\n\n\t\t\tabstract String getMessage();\n\n\t\t\tpublic static void main(String[] arguments) {\n\t\t\t\tSystem.out.println(anEnumValue.getMessage());\n\t\t\t\tSystem.out.println(\"SUCCESS\");\n\t\t\t}\n\t\t}\n\t}\n\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tprivate final Y thisOne = anEnumValue;\n\t                          ^^^^^^^^^^^\nCannot refer to the static enum field Y.anEnumValue within an initializer\n----------\n", AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacBugFixed_6_10);
    }

    public void test101() {
        this.runNegativeTest(new String[]{"X.java", "interface Foo {\n  public boolean bar();\n}\npublic class X { \n\tpublic static void main(String[] args) {\nenum BugDemo {\n  CONSTANT(new Foo() {\n    public boolean bar() {\n      Zork z;\n      return true;\n    }\n  });\n  BugDemo(Foo foo) {\n  }\n  }\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test102() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\n\npublic class X <T> {\n\tpublic static void main(String[] args) {\n\tenum SomeEnum {\n\t\tA, B;\n\t\tstatic SomeEnum foo() {\n\t\t\treturn null;\n\t\t}\n\t}\n\tEnum<SomeEnum> e = SomeEnum.A;\n\t\t\n\tSet<SomeEnum> set1 = EnumSet.of(SomeEnum.A);\n\tSet<SomeEnum> set2 = EnumSet.of(SomeEnum.foo());\n\t\n\tFoo<Bar> foo = null;\n}\n}\nclass Foo <U extends Foo<U>> {\n}\nclass Bar extends Foo {\n}\n"}, "----------\n1. ERROR in X.java (at line 16)\n\tFoo<Bar> foo = null;\n\t    ^^^\nBound mismatch: The type Bar is not a valid substitute for the bounded parameter <U extends Foo<U>> of the type Foo<U>\n----------\n2. WARNING in X.java (at line 21)\n\tclass Bar extends Foo {\n\t                  ^^^\nFoo is a raw type. References to generic type Foo<U> should be parameterized\n----------\n");
    }

    public void test103() {
        this.runNegativeTest(new String[]{"BadEnum.java", "public class BadEnum {\n  public interface EnumInterface<T extends Object> {\n    public T getMethod();\n  }\n\tpublic static void main(String[] args) {\n   enum EnumClass implements EnumInterface<String> {\n    ENUM1 { public String getMethod() { return \"ENUM1\";} },\n    ENUM2 { public String getMethod() { return \"ENUM2\";} };\n  }\n}\n}\n}\n"}, "----------\n1. ERROR in BadEnum.java (at line 12)\n\t}\n\t^\nSyntax error on token \"}\", delete this token\n----------\n");
    }

    public void _NA_test104() {
        this.runConformTest(new String[]{"p/Placeholder.java", "package p;\n\npublic class Placeholder {\n    public static void main(String... argv) {\n        ClassWithBadEnum.EnumClass constant = ClassWithBadEnum.EnumClass.ENUM1;\n        ClassWithBadEnum.main(argv);\n\t}\n}    \n\n", "p/ClassWithBadEnum.java", "package p;\n\npublic class ClassWithBadEnum {\n\tpublic interface EnumInterface<T extends Object> {\n\t    public T getMethod();\n\t}\n\n\tpublic enum EnumClass implements EnumInterface<String> {\n\t\tENUM1 { public String getMethod() { return \"ENUM1\";} },\n\t\tENUM2 { public String getMethod() { return \"ENUM2\";} };\n\t}\n\tprivate EnumClass enumVar; \n\tpublic EnumClass getEnumVar() {\n\t\treturn enumVar;\n\t}\n\tpublic void setEnumVar(EnumClass enumVar) {\n\t\tthis.enumVar = enumVar;\n\t}\n\n\tpublic static void main(String... argv) {\n\t\tint a = 1;\n\t\tClassWithBadEnum badEnum = new ClassWithBadEnum();\n\t\tbadEnum.setEnumVar(ClassWithBadEnum.EnumClass.ENUM1);\n\t\t// Should fail if bug manifests itself because there will be two getInternalValue() methods\n\t\t// one returning an Object instead of a String\n\t\tString s3 = badEnum.getEnumVar().getMethod();\n\t\tSystem.out.println(s3);\n\t}\n}  \n"}, "ENUM1");
    }

    public void _NA_test105() {
        this.runConformTest(new String[]{"pack/X.java", "package pack;\nimport static pack.Color.*;\npublic class X {\n    public static void main(String[] args) {\n        Color c = BLACK;\n        switch(c) {\n        case BLACK:\n            System.out.print(\"Black\");\n            break;\n        case WHITE:\n            System.out.print(\"White\");\n            break;\n        default: // nop\n        }\n    }\n}", "pack/Color.java", "package pack;\nenum Color {WHITE, BLACK}"}, "Black");
        this.runConformTest(new String[]{"pack/Color.java", "package pack;\nenum Color {BLACK, WHITE}"}, "", null, false, null);
        this.executeClass("pack/X.java", "Black", null, false, null, null, null);
    }

    public void _NA_test106() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.incompleteEnumSwitch", "ignore");
        this.runConformTest(new String[]{"pack/X.java", "package pack;\nimport static pack.Color.*;\npublic class X {\n    public static void main(String[] args) {\n        Color c = BLACK;\n        switch(c) {\n        }\n\t\t System.out.print(\"SUCCESS\");\n    }\n}", "pack/Color.java", "package pack;\nenum Color {WHITE, BLACK}"}, "SUCCESS", null, true, null, options, null);
        this.runConformTest(new String[]{"pack/Color.java", "package pack;\nenum Color {BLACK, WHITE}"}, "", null, false, null);
        this.executeClass("pack/X.java", "SUCCESS", null, false, null, null, null);
    }

    public void _NA_test107() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.incompleteEnumSwitch", "ignore");
        this.runConformTest(new String[]{"pack/X.java", "package pack;\nimport static pack.Color.*;\npublic class X {\n    public static void main(String[] args) {\n        Color c = BLACK;\n        switch(c) {\n        case BLACK:\n            System.out.print(\"Black\");\n            break;\n        case WHITE:\n            System.out.print(\"White\");\n            break;\n        }\n        switch(c) {\n        case BLACK:\n            System.out.print(\"Black\");\n            break;\n        case WHITE:\n            System.out.print(\"White\");\n            break;\n        }\n    }\n}", "pack/Color.java", "package pack;\nenum Color {WHITE, BLACK}"}, "BlackBlack", null, true, null, options, null);
        this.runConformTest(new String[]{"pack/Color.java", "package pack;\nenum Color { BLACK }"}, "", null, false, null);
        this.executeClass("pack/X.java", "BlackBlack", null, false, null, null, null);
    }

    public void _NA_test108() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.incompleteEnumSwitch", "ignore");
        this.runConformTest(new String[]{"pack/X.java", "package pack;\nimport static pack.Color.*;\npublic class X {\n    public static void main(String[] args) {\n        Color c = BLACK;\n        switch(c) {\n        case BLACK:\n            System.out.print(\"Black\");\n            break;\n        case WHITE:\n            System.out.print(\"White\");\n            break;\n        default:\n            System.out.print(\"Error\");\n            break;\n        }\n    }\n}", "pack/Color.java", "package pack;\nenum Color {WHITE, BLACK}"}, "Black", null, true, null, options, null);
        this.runConformTest(new String[]{"pack/Color.java", "package pack;\nenum Color {RED, GREEN, YELLOW, BLACK, WHITE}"}, "", null, false, null);
        this.executeClass("pack/X.java", "Black", null, false, null, null, null);
    }

    public void _NA_test109() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.incompleteEnumSwitch", "ignore");
        this.runConformTest(new String[]{"pack/X.java", "package pack;\nimport static pack.Color.*;\npublic class X {\n    public static void main(String[] args) {\n\t\tColor c = null;\n\t\t try {\n        \tc = BLACK;\n\t\t} catch(NoSuchFieldError e) {\n\t\t\tSystem.out.print(\"SUCCESS\");\n\t\t\treturn;\n\t\t}\n      \tswitch(c) {\n       \tcase BLACK:\n          \tSystem.out.print(\"Black\");\n          \tbreak;\n       \tcase WHITE:\n          \tSystem.out.print(\"White\");\n          \tbreak;\n      \t}\n    }\n}", "pack/Color.java", "package pack;\nenum Color {WHITE, BLACK}"}, "Black", null, true, null, options, null);
        this.runConformTest(new String[]{"pack/Color.java", "package pack;\nenum Color {RED, GREEN, YELLOW, WHITE}"}, "", null, false, null);
        this.executeClass("pack/X.java", "SUCCESS", null, false, null, null, null);
    }

    public void _NAtest110() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.incompleteEnumSwitch", "ignore");
        this.runConformTest(new String[]{"pack/X.java", "package pack;\nimport static pack.Color.*;\npublic class X {\n\tpublic int[] $SWITCH_TABLE$pack$Color;\n\tpublic int[] $SWITCH_TABLE$pack$Color() { return null; }\n   public static void main(String[] args) {\n        Color c = BLACK;\n        switch(c) {\n        case BLACK:\n            System.out.print(\"Black\");\n            break;\n        case WHITE:\n            System.out.print(\"White\");\n            break;\n        }\n    }\n}", "pack/Color.java", "package pack;\nenum Color {WHITE, BLACK}"}, "Black", null, true, null, options, null);
        this.runConformTest(new String[]{"pack/Color.java", "package pack;\nenum Color {BLACK, WHITE}"}, "", null, false, null);
        this.executeClass("pack/X.java", "Black", null, false, null, null, null);
    }

    public void _NA_test111() {
        this.runConformTest(new String[]{"pack/X.java", "package pack;\nimport static pack.Color.*;\n@SuppressWarnings(\"incomplete-switch\")\npublic class X {\n\tpublic int[] $SWITCH_TABLE$pack$Color;\n\tpublic int[] $SWITCH_TABLE$pack$Color() { return null; }\n   public static void main(String[] args) {\n        Color c = BLACK;\n        switch(c) {\n        case BLACK:\n            System.out.print(\"Black\");\n            break;\n        case WHITE:\n            System.out.print(\"White\");\n            break;\n        }\n\t\t foo();\n    }\n   public static void foo() {\n        Color c = BLACK;\n        switch(c) {\n        case BLACK:\n            System.out.print(\"Black\");\n            break;\n        case WHITE:\n            System.out.print(\"White\");\n            break;\n        }\n    }\n}", "pack/Color.java", "package pack;\nenum Color {WHITE, BLACK}"}, "BlackBlack");
        this.runConformTest(new String[]{"pack/Color.java", "package pack;\nenum Color {BLACK, WHITE}"}, "", null, false, null);
        this.executeClass("pack/X.java", "BlackBlack", null, false, null, null, null);
    }

    public void _NA_test112() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.incompleteEnumSwitch", "ignore");
        options.put("org.eclipse.jdt.core.compiler.problem.enablePreviewFeatures", "enabled");
        options.put("org.eclipse.jdt.core.compiler.problem.reportPreviewFeatures", "ignore");
        this.runConformTest(new String[]{"com/annot/X.java", "package com.annot;\nimport java.lang.annotation.Target;\nimport java.lang.annotation.ElementType;\n\npublic class X {\n   public static void main(String[] args) {\n  enum TestType {\n    CORRECTNESS,\n    PERFORMANCE\n  }\n  @Target(ElementType.METHOD)\n  @interface Test {\n    TestType type() default TestType.CORRECTNESS;\n  }\n  @Test(type=TestType.PERFORMANCE)\n  public void _testBar() throws Exception {\n    Test annotation = this.getClass().getMethod(\"testBar\").getAnnotation(Test.class);\n    switch (annotation.type()) {\n      case PERFORMANCE:\n        System.out.println(TestType.PERFORMANCE);\n        break;\n      case CORRECTNESS:\n        System.out.println(TestType.CORRECTNESS);\n        break;\n    }   \n  }\n  }\n}"}, "", null, true, new String[]{"--enable-preview"}, options, null);
    }

    public void _test113() {
        if (this.complianceLevel >= 0x3C0000L) {
            return;
        }
        this.runNegativeTest(new String[]{"X.java", "public class X {\n   public static void main(String[] args) {\n\t\tenum BugDemo {\n\t\t\tFOO() {\n\t\t\t\tstatic int bar;\n\t\t\t}\n  \t\t}\n  \t}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tstatic int bar;\n\t           ^^^\nThe field bar cannot be declared static in a non-static inner type, unless initialized with a constant expression\n----------\n");
    }

    public void test114() {
        this.runConformTest(new String[]{"LocalEnumTest.java", "import java.lang.reflect.*;\nimport java.lang.annotation.*;\ninterface I {\n\tvoid foo();\n}\n@Retention(RetentionPolicy.RUNTIME)\n@interface ExpectedModifiers {\n\tint value();\n}\n@ExpectedModifiers(Modifier.FINAL)\npublic enum LocalEnumTest {\n\tX(255);\n\tLocalEnumTest(int r) {}\n\tpublic static void main(String argv[]) throws Exception {\n\t\ttest(\"LocalEnumTest\");\n\t\ttest(\"LocalEnumTest$1EnumA\");\n\t\ttest(\"LocalEnumTest$1EnumB\");\n\t\ttest(\"LocalEnumTest$1EnumB2\");\n\t\ttest(\"LocalEnumTest$1EnumB3\");\n\t\ttest(\"LocalEnumTest$1EnumC3\");\n\t\ttest(\"LocalEnumTest$1EnumD\");\n\t\t@ExpectedModifiers(Modifier.FINAL|Modifier.STATIC)\n\t\tenum EnumA {\n\t\t\tA;\n\t\t}\n\t\t@ExpectedModifiers(Modifier.STATIC)\n\t\tenum EnumB {\n\t\t\tB {\n\t\t\t\tint value() { return 1; }\n\t\t\t};\n\t\t\tint value(){ return 0; }\n\t\t}\n\t\t@ExpectedModifiers(Modifier.STATIC)\n\t\tenum EnumB2 {\n\t\t\tB2 {};\n\t\t\tint value(){ return 0; }\n\t\t}\n\t\t@ExpectedModifiers(Modifier.FINAL|Modifier.STATIC)\n\t\tenum EnumB3 {\n\t\t\tB3;\n\t\t\tint value(){ return 0; }\n\t\t}\n\t\t@ExpectedModifiers(Modifier.STATIC)\n\t\tenum EnumC implements I {\n\t\t\tC {\n\t\t\t\tint value() { return 1; }\n\t\t\t};\n\t\t\tint value(){ return 0; }\n\t\t\tpublic void foo(){}\n\t\t}\n\t\t@ExpectedModifiers(Modifier.STATIC)\n\t\tenum EnumC2 implements I {\n\t\t\tC2 {};\n\t\t\tint value(){ return 0; }\n\t\t\tpublic void foo(){}\n\t\t}\n\t\t@ExpectedModifiers(Modifier.FINAL|Modifier.STATIC)\n\t\tenum EnumC3 implements I {\n\t\t\tC3;\n\t\t\tint value(){ return 0; }\n\t\t\tpublic void foo(){}\n\t\t}\n\t\t@ExpectedModifiers(Modifier.ABSTRACT|Modifier.STATIC)\n\t\tenum EnumD {\n\t\t\tD {\n\t\t\t\tint value() { return 1; }\n\t\t\t};\n\t\t\tabstract int value();\n\t\t}\n\t}\n\tstatic void test(String className) throws Exception {\n\t\tClass c = Class.forName(className);\n\t\tExpectedModifiers em = (ExpectedModifiers) c.getAnnotation(ExpectedModifiers.class);\n\t\tif (em != null) {\n\t\t\tint classModifiers = c.getModifiers();\n\t\t\tint expected = em.value();\n\t\t\tif (expected != (classModifiers & (Modifier.ABSTRACT|Modifier.FINAL|Modifier.STATIC))) {\n\t\t\t\tif ((expected & Modifier.ABSTRACT) != (classModifiers & Modifier.ABSTRACT))\n\t\t\t\t\tSystem.out.println(\"FAILED ABSTRACT: \" + className);\n\t\t\t\tif ((expected & Modifier.FINAL) != (classModifiers & Modifier.FINAL))\n\t\t\t\t\tSystem.out.println(\"FAILED FINAL: \" + className);\n\t\t\t\tif ((expected & Modifier.STATIC) != (classModifiers & Modifier.STATIC))\n\t\t\t\t\tSystem.out.println(\"FAILED STATIC: \" + className);\n\t\t\t}\n\t\t}\n\t}\n}\n"}, "");
    }

    public void test115() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String argv[]) {\n\t\tenum Y {\n\t\t\tVALUE;\n\n\t\t\tstatic int ASD;\n\t\t\tfinal static int CST = 0;\n\t\t\t\n\t\t\tprivate Y() {\n\t\t\t\tVALUE = null;\n\t\t\t\tASD = 5;\n\t\t\t\tY.VALUE = null;\n\t\t\t\tY.ASD = 5;\n\t\t\t\t\n\t\t\t\tSystem.out.println(CST);\n\t\t\t}\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 10)\n\tVALUE = null;\n\t^^^^^\nCannot refer to the static enum field Y.VALUE within an initializer\n----------\n2. ERROR in X.java (at line 11)\n\tASD = 5;\n\t^^^\nCannot refer to the static enum field Y.ASD within an initializer\n----------\n3. ERROR in X.java (at line 12)\n\tY.VALUE = null;\n\t  ^^^^^\nCannot refer to the static enum field Y.VALUE within an initializer\n----------\n4. ERROR in X.java (at line 13)\n\tY.ASD = 5;\n\t  ^^^\nCannot refer to the static enum field Y.ASD within an initializer\n----------\n");
    }

    public void test116() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String argv[]) {\n\t\tenum Y {\n\t\t\tBLEU, \n\t\t\tBLANC, \n\t\t\tROUGE;\n\t\t\t{\n\t\t\t\tBLEU = null;\n\t\t\t}\n\t\t}\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 8)\n\tBLEU = null;\n\t^^^^\nCannot refer to the static enum field Y.BLEU within an initializer\n----------\n");
    }

    public void test117() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String argv[]) {\n\t\tenum Y {\n\t\t\tBLEU, \n\t\t\tBLANC, \n\t\t\tROUGE;\n\t\t\t{\n\t\t\t\tY x = BLEU.BLANC; // ko\n\t\t\t\tY x2 = BLEU; // ko\n\t\t\t}\n\t\t\tstatic {\n\t\t\t\tY x = BLEU.BLANC; // ok\n\t\t\t\tY x2 = BLEU; // ok\n\t\t\t}\t\n\t\t\tY dummy = BLEU; // ko\n\t\t\tstatic Y DUMMY = BLANC; // ok\n\t\t\tY() {\n\t\t\t\tY x = BLEU.BLANC; // ko\n\t\t\t\tY x2 = BLEU; // ko\n\t\t\t}\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\tY x = BLEU.BLANC; // ko\n\t      ^^^^\nCannot refer to the static enum field Y.BLEU within an initializer\n----------\n2. ERROR in X.java (at line 8)\n\tY x = BLEU.BLANC; // ko\n\t           ^^^^^\nCannot refer to the static enum field Y.BLANC within an initializer\n----------\n3. WARNING in X.java (at line 8)\n\tY x = BLEU.BLANC; // ko\n\t           ^^^^^\nThe static field Y.BLANC should be accessed in a static way\n----------\n4. ERROR in X.java (at line 9)\n\tY x2 = BLEU; // ko\n\t       ^^^^\nCannot refer to the static enum field Y.BLEU within an initializer\n----------\n5. WARNING in X.java (at line 12)\n\tY x = BLEU.BLANC; // ok\n\t           ^^^^^\nThe static field Y.BLANC should be accessed in a static way\n----------\n6. ERROR in X.java (at line 15)\n\tY dummy = BLEU; // ko\n\t          ^^^^\nCannot refer to the static enum field Y.BLEU within an initializer\n----------\n7. ERROR in X.java (at line 18)\n\tY x = BLEU.BLANC; // ko\n\t      ^^^^\nCannot refer to the static enum field Y.BLEU within an initializer\n----------\n8. ERROR in X.java (at line 18)\n\tY x = BLEU.BLANC; // ko\n\t           ^^^^^\nCannot refer to the static enum field Y.BLANC within an initializer\n----------\n9. WARNING in X.java (at line 18)\n\tY x = BLEU.BLANC; // ko\n\t           ^^^^^\nThe static field Y.BLANC should be accessed in a static way\n----------\n10. ERROR in X.java (at line 19)\n\tY x2 = BLEU; // ko\n\t       ^^^^\nCannot refer to the static enum field Y.BLEU within an initializer\n----------\n");
    }

    public void test118() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.ArrayList;\n\npublic class X {\n\tpublic static void main(String argv[]) {\n\t\tenum Y {\n\t\t\t one,\n\t\t\t two;\n\t\t\t \n\t\t\t static ArrayList someList;\n\t\t\t \n\t\t\t private Y() {\n\t\t\t \t\t if (someList == null) {\n\t\t\t \t\t \t\t someList = new ArrayList();\n\t\t\t \t\t }\n\t\t\t }\n\t\t}\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 9)\n\tstatic ArrayList someList;\n\t       ^^^^^^^^^\nArrayList is a raw type. References to generic type ArrayList<E> should be parameterized\n----------\n2. ERROR in X.java (at line 12)\n\tif (someList == null) {\n\t    ^^^^^^^^\nCannot refer to the static enum field Y.someList within an initializer\n----------\n3. ERROR in X.java (at line 13)\n\tsomeList = new ArrayList();\n\t^^^^^^^^\nCannot refer to the static enum field Y.someList within an initializer\n----------\n4. WARNING in X.java (at line 13)\n\tsomeList = new ArrayList();\n\t               ^^^^^^^^^\nArrayList is a raw type. References to generic type ArrayList<E> should be parameterized\n----------\n");
    }

    public void test119() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String argv[]) {\n\t\tenum Y {\n\t\t\tBLEU, BLANC, ROUGE;\n\t\t\tfinal static int CST = 0;\n          \t\tenum Member {\n          \t\t\t;\n             \t \tObject obj1 = CST;\n              \t\tObject obj2 = BLEU;\n          \t\t}\n       \t}\n     }\n}\n"}, "");
    }

    public void test120() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String argv[]) {\n\t\tenum Y {\n\n\t\t\tA() {\n\t\t\t\tfinal Y a = A;\n\t\t\t\tfinal Y a2 = B.A;\n\t\t\t\t@Override void foo() {\n\t\t\t\t\tSystem.out.println(String.valueOf(a));\n\t\t\t\t\tSystem.out.println(String.valueOf(a2));\n\t\t\t\t}\n\t\t\t},\n\t\t\tB() {\n\t\t\t\t@Override void foo(){}\n\t\t\t};\n\t\t\tabstract void foo();\n\t\t\t\n\t\t\tpublic static void main(String[] args) {\n\t\t\t\tA.foo();\n\t\t\t}\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tfinal Y a = A;\n\t            ^\nCannot refer to the static enum field Y.A within an initializer\n----------\n2. ERROR in X.java (at line 7)\n\tfinal Y a2 = B.A;\n\t             ^\nCannot refer to the static enum field Y.B within an initializer\n----------\n3. ERROR in X.java (at line 7)\n\tfinal Y a2 = B.A;\n\t               ^\nCannot refer to the static enum field Y.A within an initializer\n----------\n4. WARNING in X.java (at line 7)\n\tfinal Y a2 = B.A;\n\t               ^\nThe static field Y.A should be accessed in a static way\n----------\n", AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacBugFixed_6_10);
    }

    public void test121() {
        this.runNegativeTest(new String[]{"X.java", "class X { \n\tpublic static void main(String[] args) {\nenum Y {\n\n\tUNKNOWN();\n\n\tprivate static String error;\n\n\t{\n\t\terror = \"error\";\n\t}\n}\n}\n\n}\n"}, "----------\n1. ERROR in X.java (at line 10)\n\terror = \"error\";\n\t^^^^^\nCannot refer to the static enum field Y.error within an initializer\n----------\n");
    }

    public void test122() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic void foo() {\n\t\tenum State {\n\t\t\tNORMAL\n}\n\t\tState state = State.NORMAL;\n\t\tswitch (state) {\n\t\tcase (NORMAL) :\n\t\t\tSystem.out.println(State.NORMAL);\n\t\t\tbreak;\n       default: // nop\n\t\t}\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 8)\n\tcase (NORMAL) :\n\t     ^^^^^^^^\nEnum constants cannot be surrounded by parenthesis\n----------\n");
    }

    public void test123() {
        this.runNegativeTest(new String[]{"Foo.java", "public class Foo { \n\tpublic static void main(String[] args) {\nenum Y {\n A(0);\n Y(int x) {\n    t[0]=x;\n }\n private static final int[] t = new int[12];\n}\n}\n\n}\n"}, "----------\n1. ERROR in Foo.java (at line 6)\n\tt[0]=x;\n\t^\nCannot refer to the static enum field Y.t within an initializer\n----------\n");
    }

    public void test124() {
        this.runNegativeTest(new String[]{"X.java", " public class X {\n\tpublic void foo() {\n\t\tenum Y {\n\t\tmax {\n\t\t{ \n\t\t\t\tval=3;  \n\t\t\t}         \n\t\t\t@Override public String toString() {\n\t\t\t\treturn Integer.toString(val);\n\t\t\t}\n\t\t}; \n\t\t{\n\t\t\tval=2;\n\t\t}\n\t\tprivate int val; \n\t\t}\n}\n  public static void main(String[] args) {\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tval=3;  \n\t^^^\nCannot make a static reference to the non-static field val\n----------\n2. ERROR in X.java (at line 9)\n\treturn Integer.toString(val);\n\t                        ^^^\nCannot make a static reference to the non-static field val\n----------\n");
    }

    public void test125() {
        this.runNegativeTest(new String[]{"X.java", "\npublic class X {\n\tinterface I {\n\t\tdefault int values(){\n\t\tenum E implements I {\n\t\t\tA, B, C;\n\t\t}\n\t}\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 5)\n\tenum E implements I {\n\t     ^\nThis static method cannot hide the instance method from X.I\n----------\n");
    }

    public void test126() {
        this.runConformTest(new String[]{"X.java", "  public class X {\n    public static void main(String[] args) {\n      enum NoValues {}\n      System.out.println(\"[\"+NoValues.values().length+\"]\");\n    }\n  }\n"}, "[0]");
    }

    public void test127() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static void main(String[] args) {\n\t\tenum Y {\n\t\t\tVALUE {\n\t\t\t\tvoid foo() {\n\t\t\t\t};\n\t\t\t};\n\t\t\tabstract void foo();\n\t\t}\n      System.out.println(\"[\"+Y.values().length+\"]\");\n    }\n}"}, "[1]");
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        byte[] classFileBytes = Util.getFileByteContent((File)new File(OUTPUT_DIR + File.separator + "X.class"));
        String actualOutput = disassembler.disassemble(classFileBytes, "\n", 1);
        String expectedOutput = "public class X {\n  \n  // Method descriptor #6 ()V\n  // Stack: 1, Locals: 1\n  public X();\n    0  aload_0 [this]\n    1  invokespecial java.lang.Object() [8]\n    4  return\n      Line numbers:\n        [pc: 0, line: 1]\n      Local variable table:\n        [pc: 0, pc: 5] local: this index: 0 type: X\n  \n  // Method descriptor #15 ([Ljava/lang/String;)V\n  // Stack: 2, Locals: 1\n  public static void main(java.lang.String[] args);\n     0  getstatic java.lang.System.out : java.io.PrintStream [16]\n     3  invokestatic X$1Y.values() : X$1Y[] [22]\n     6  arraylength\n     7  invokedynamic 0 makeConcatWithConstants(int) : java.lang.String [28]\n    12  invokevirtual java.io.PrintStream.println(java.lang.String) : void [32]\n    15  return\n      Line numbers:\n        [pc: 0, line: 10]\n        [pc: 15, line: 11]\n      Local variable table:\n        [pc: 0, pc: 16] local: args index: 0 type: java.lang.String[]\n\n  Inner classes:\n    [inner class info: #23 X$1Y, outer class info: #0\n     inner name: #52 Y, accessflags: 17416 abstract static],\n    [inner class info: #53 java/lang/invoke/MethodHandles$Lookup, outer class info: #55 java/lang/invoke/MethodHandles\n     inner name: #57 Lookup, accessflags: 25 public static final]\n\nNest Members:\n   #23 X$1Y,\n   #59 X$1Y$1\nBootstrap methods:\n  0 : # 48 invokestatic java/lang/invoke/StringConcatFactory.makeConcatWithConstants:(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/invoke/CallSite;\n\tMethod arguments:\n\t\t#49 [\u0001]\n}";
        int index = actualOutput.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(actualOutput, 3));
        }
        if (index == -1) {
            LocalEnumTest.assertEquals("unexpected bytecode sequence", expectedOutput, actualOutput);
        }
        if ((index = (actualOutput = (disassembler = ToolFactory.createDefaultClassFileBytesDisassembler()).disassemble(classFileBytes = Util.getFileByteContent((File)new File(OUTPUT_DIR + File.separator + "X$1Y$1.class")), "\n", 1)).indexOf(expectedOutput = "ENUM$VALUES")) != -1) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(actualOutput, 3));
        }
        if (index != -1) {
            LocalEnumTest.assertTrue((String)"Must not have field ENUM$VALUES", (boolean)false);
        }
    }

    public void test128() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.rawTypeReference", "ignore");
        options.put("org.eclipse.jdt.core.compiler.problem.missingSerialVersion", "ignore");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main( String[] args) {\n\t\tEnum e = new Enum(\"foo\", 2) {\n\t\t\tpublic int compareTo( Object o) {\n\t\t\t\treturn 0;\n\t\t\t}\n\t\t};\n\t\tSystem.out.println(e);\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tEnum e = new Enum(\"foo\", 2) {\n\t             ^^^^\nThe type new Enum(){} may not subclass Enum explicitly\n----------\n", null, true, options);
    }

    public void test129() throws Exception {
        this.runConformTest(new String[]{"X.java", "  public class X {\n    public void foo(){\n\t\tenum Y {\n        A, B, C;\n\t\t}\n\t}\n\tpublic static void main(String[] args) {\n    }\n}\n"}, "");
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        byte[] classFileBytes = Util.getFileByteContent((File)new File(OUTPUT_DIR + File.separator + "X.class"));
        String actualOutput = disassembler.disassemble(classFileBytes, "\n", 1);
        String expectedOutput = "public class X {\n  \n  // Method descriptor #6 ()V\n  // Stack: 1, Locals: 1\n  public X();\n    0  aload_0 [this]\n    1  invokespecial java.lang.Object() [8]\n    4  return\n      Line numbers:\n        [pc: 0, line: 1]\n      Local variable table:\n        [pc: 0, pc: 5] local: this index: 0 type: X\n  \n  // Method descriptor #6 ()V\n  // Stack: 0, Locals: 1\n  public void foo();\n    0  return\n      Line numbers:\n        [pc: 0, line: 6]\n      Local variable table:\n        [pc: 0, pc: 1] local: this index: 0 type: X\n  \n  // Method descriptor #16 ([Ljava/lang/String;)V\n  // Stack: 0, Locals: 1\n  public static void main(java.lang.String[] args);\n    0  return\n      Line numbers:\n        [pc: 0, line: 8]\n      Local variable table:\n        [pc: 0, pc: 1] local: args index: 0 type: java.lang.String[]\n\n  Inner classes:\n    [inner class info: #22 X$1Y, outer class info: #0\n     inner name: #24 Y, accessflags: 16408 static final]\n\nNest Members:\n   #22 X$1Y\n}";
        int index = actualOutput.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(actualOutput, 3));
        }
        if (index == -1) {
            LocalEnumTest.assertEquals("unexpected bytecode sequence", expectedOutput, actualOutput);
        }
    }

    public void test130() {
        this.runConformTest(new String[]{"X.java", "public class X {\n   public static void main(String[] args) {\n      enum Action {ONE, TWO}\n      for(Action a : Action.values()) {\n         switch(a) {\n         case ONE:\n            System.out.print(\"1\");\n            break;\n         case TWO:\n            System.out.print(\"2\");\n            break;\n         default:\n            System.out.print(\"default\");\n         }\n      }\n   }\n}"}, "12");
        this.runConformTest(new String[]{"X.java", "public class X {\n   public static void main(String[] args) {\n      enum Action {ONE, TWO, THREE}\n      for(Action a : Action.values()) {\n         switch(a) {\n         case ONE:\n            System.out.print(\"1\");\n            break;\n         case TWO:\n            System.out.print(\"2\");\n            break;\n         default:\n            System.out.print(\"default\");\n         }\n      }\n   }\n}"}, "12default");
    }

    public void test131() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\t//A,B\n\t;\n\tpublic static void main(String[] args) {\n\t\tenum Y { }\n \t\ttry {\n\t\t\tSystem.out.println(Y.valueOf(null));\n\t\t} catch (NullPointerException e) {\n\t\t\tSystem.out.println(\"NullPointerException\");\n\t\t} catch (IllegalArgumentException e) {\n\t\t\tSystem.out.println(\"IllegalArgumentException\");\n\t\t}\n\t}\n}\n"}, "NullPointerException");
    }

    public void test132() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tenum Y {\n\t\t\tA,B\n\t\t\t;\n\t\t}\n\t\ttry {\n\t\t\tSystem.out.println(Y.valueOf(null));\n\t\t} catch (NullPointerException e) {\n\t\t\tSystem.out.println(\"NullPointerException\");\n\t\t} catch (IllegalArgumentException e) {\n\t\t\tSystem.out.println(\"IllegalArgumentException\");\n\t\t}\n\t}\n}\n"}, "NullPointerException");
    }

    public void test133() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tenum Y {\n\t\t\tA, B, C;\n\t\t}\n\t}\n}\n"}, "");
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        byte[] classFileBytes = Util.getFileByteContent((File)new File(OUTPUT_DIR + File.separator + "X.class"));
        String actualOutput = disassembler.disassemble(classFileBytes, "\n", 1);
        String expectedOutput = "public class X {\n  \n  // Method descriptor #6 ()V\n  // Stack: 1, Locals: 1\n  public X();\n    0  aload_0 [this]\n    1  invokespecial java.lang.Object() [8]\n    4  return\n      Line numbers:\n        [pc: 0, line: 1]\n      Local variable table:\n        [pc: 0, pc: 5] local: this index: 0 type: X\n  \n  // Method descriptor #15 ([Ljava/lang/String;)V\n  // Stack: 0, Locals: 1\n  public static void main(java.lang.String[] args);\n    0  return\n      Line numbers:\n        [pc: 0, line: 6]\n      Local variable table:\n        [pc: 0, pc: 1] local: args index: 0 type: java.lang.String[]\n\n  Inner classes:\n    [inner class info: #21 X$1Y, outer class info: #0\n     inner name: #23 Y, accessflags: 16408 static final]\n\nNest Members:\n   #21 X$1Y\n}";
        int index = actualOutput.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(actualOutput, 3));
        }
        if (index == -1) {
            LocalEnumTest.assertEquals("unexpected bytecode sequence", expectedOutput, actualOutput);
        }
    }

    public void test134() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tenum Y {\n    \t\tINITIAL ,\n    \t\tOPENED {\n        \t{\n            \tSystem.out.printf(\"After the %s constructor\\n\",INITIAL);\n        \t}\n\t\t}\n    }\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 7)\n\tSystem.out.printf(\"After the %s constructor\\n\",INITIAL);\n\t                                               ^^^^^^^\nCannot refer to the static enum field Y.INITIAL within an initializer\n----------\n", AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacBugFixed_6_10);
    }

    public void test135() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    boolean foo() {\n\t\tenum E {\n    \t\tA,\n    \t\tB\n\t\t}\n\t\t E e = E.A;\n        boolean b;\n        switch (e) {\n          case A:\n              b = true;\n              break;\n          case B:\n              b = false;\n              break;\n        }\n        return b;\n    }\n}"}, "----------\n1. ERROR in X.java (at line 17)\n\treturn b;\n\t       ^\nThe local variable b may not have been initialized. Note that a problem regarding missing 'default:' on 'switch' has been suppressed, which is perhaps related to this problem\n----------\n");
    }

    public void test136() {
        this.runConformTest(new String[]{"X.java", "import p.BeanName;\npublic class X {\n\tObject o = BeanName.CreateStepApiOperation;\n}", "p/BeanName.java", "package p;\npublic enum BeanName {\n\n    //~ Enum constants ---------------------------------------------------------\n\n    AbortAllJobsOperation,\n    AbortJobApiOperation,\n    AbortStepOperation,\n    AclVoter,\n    AcquireNamedLockApiOperation,\n    AuthenticationManager,\n    BeginStepOperation,\n    CloneApiOperation,\n    CommanderDao,\n    CommanderServer,\n    ConfigureQuartzOperation,\n    CreateAclEntryApiOperation,\n    CreateActualParameterApiOperation,\n    CreateFormalParameterApiOperation,\n    CreateProcedureApiOperation,\n    CreateProjectApiOperation,\n    CreateResourceApiOperation,\n    CreateScheduleApiOperation,\n    CreateStepApiOperation,\n    DeleteAclEntryApiOperation,\n    DeleteActualParameterApiOperation,\n    DeleteFormalParameterApiOperation,\n    DeleteJobApiOperation,\n    DeleteProcedureApiOperation,\n    DeleteProjectApiOperation,\n    DeletePropertyApiOperation,\n    DeleteResourceApiOperation,\n    DeleteScheduleApiOperation,\n    DeleteStepApiOperation,\n    DispatchApiRequestOperation,\n    DumpStatisticsApiOperation,\n    ExpandJobStepAction,\n    ExportApiOperation,\n    FinishStepOperation,\n    GetAccessApiOperation,\n    GetAclEntryApiOperation,\n    GetActualParameterApiOperation,\n    GetActualParametersApiOperation,\n    GetFormalParameterApiOperation,\n    GetFormalParametersApiOperation,\n    GetJobDetailsApiOperation,\n    GetJobInfoApiOperation,\n    GetJobStatusApiOperation,\n    GetJobStepDetailsApiOperation,\n    GetJobStepStatusApiOperation,\n    GetJobsApiOperation,\n    GetProcedureApiOperation,\n    GetProceduresApiOperation,\n    GetProjectApiOperation,\n    GetProjectsApiOperation,\n    GetPropertiesApiOperation,\n    GetPropertyApiOperation,\n    GetResourceApiOperation,\n    GetResourcesApiOperation,\n    GetResourcesInPoolApiOperation,\n    GetScheduleApiOperation,\n    GetSchedulesApiOperation,\n    GetStepApiOperation,\n    GetStepsApiOperation,\n    GetVersionsApiOperation,\n    GraphWorkflowApiOperation,\n    HibernateFlushListener,\n    ImportApiOperation,\n    IncrementPropertyApiOperation,\n    InvokeCommandOperation,\n    InvokePostProcessorOperation,\n    LoginApiOperation,\n    LogManager,\n    LogMessageApiOperation,\n    ModifyAclEntryApiOperation,\n    ModifyActualParameterApiOperation,\n    ModifyFormalParameterApiOperation,\n    ModifyProcedureApiOperation,\n    ModifyProjectApiOperation,\n    ModifyPropertyApiOperation,\n    ModifyResourceApiOperation,\n    ModifyScheduleApiOperation,\n    ModifyStepApiOperation,\n    MoveStepApiOperation,\n    PauseSchedulerApiOperation,\n    QuartzQueue,\n    QuartzScheduler,\n    ReleaseNamedLockApiOperation,\n    ResourceInvoker,\n    RunProcedureApiOperation,\n    RunQueryApiOperation,\n    SaxReader,\n    ScheduleStepsOperation,\n    SessionCache,\n    SetJobNameApiOperation,\n    SetPropertyApiOperation,\n    SetStepStatusAction,\n    StartWorkflowOperation,\n    StateRefreshOperation,\n    StepCompletionPrecondition,\n    StepOutcomePrecondition,\n    StepScheduler,\n    TemplateOperation,\n    TimeoutWatchdog,\n    UpdateConfigurationOperation,\n    Workspace,\n    XmlRequestHandler;\n\n    //~ Static fields/initializers ---------------------------------------------\n\n    public static final int MAX_BEAN_NAME_LENGTH = 33;\n\n    //~ Methods ----------------------------------------------------------------\n\n    /**\n     * Get this bean name as a property name, i.e. uncapitalized.\n     *\n     * @return String\n     */\n    public String getPropertyName()\n    {\n        return null;\n    }\n}\n"}, "");
    }

    public void test137() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\n    interface Interface {\n        public int value();\n    }\n\n\n    public static void main(String[] args) {\n    \tenum MyEnum implements Interface {\n        ;\n\n        \tMyEnum(int value) { this.value = value; }        \n       \tpublic int value() { return this.value; }\n        \tprivate int value;\n    \t}\n        System.out.println(MyEnum.values().length);\n    }\n}"}, "0");
    }

    public void test138() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    public static void main(String[] args) {\n    \tenum Y {\n\t\t\tPLUS {\n\t\t\t\tdouble eval(double x, double y) {\n\t\t\t\t\treturn x + y;\n\t\t\t\t}\n\t\t\t},\n\t\t\tMINUS {\n\t\t\t\t@Override\n\t\t\t\tabstract double eval(double x, double y);\n\t\t\t};\n\t\t\tabstract double eval(double x, double y);\n\t\t}\n\t}\n}\n\n"}, "----------\n1. WARNING in X.java (at line 5)\n\tdouble eval(double x, double y) {\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^\nThe method eval(double, double) of type new Y(){} should be tagged with @Override since it actually overrides a superclass method\n----------\n2. ERROR in X.java (at line 9)\n\tMINUS {\n\t^^^^^\nThe enum constant MINUS cannot define abstract methods\n----------\n3. ERROR in X.java (at line 11)\n\tabstract double eval(double x, double y);\n\t                ^^^^^^^^^^^^^^^^^^^^^^^^\nThe method eval cannot be abstract in the enum constant MINUS\n----------\n");
    }

    public void test139() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    public static void main(String[] args) {\n    \tenum Y {\n\t\t\tPLUS {\n\t\t\t\tdouble eval(double x, double y) {\n\t\t\t\t\treturn x + y;\n\t\t\t\t}\n\t\t\t},\n\t\t\tMINUS {\n\t\t\t\tabstract double eval2(double x, double y);\n\t\t\t};\n\n\t\t\tabstract double eval(double x, double y);\n\t\t}\n\t}\n}\n\n"}, "----------\n1. WARNING in X.java (at line 5)\n\tdouble eval(double x, double y) {\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^\nThe method eval(double, double) of type new Y(){} should be tagged with @Override since it actually overrides a superclass method\n----------\n2. ERROR in X.java (at line 9)\n\tMINUS {\n\t^^^^^\nThe enum constant MINUS cannot define abstract methods\n----------\n3. ERROR in X.java (at line 9)\n\tMINUS {\n\t^^^^^\nThe enum constant MINUS must implement the abstract method eval(double, double)\n----------\n4. ERROR in X.java (at line 10)\n\tabstract double eval2(double x, double y);\n\t                ^^^^^^^^^^^^^^^^^^^^^^^^^\nThe method eval2 cannot be abstract in the enum constant MINUS\n----------\n");
    }

    public void test140() {
        if (this.complianceLevel < 0x3D0000L) {
            return;
        }
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid bar(X x) {\n\t\tenum Y {\n\t\t\tPLUS {/*ANONYMOUS*/}, MINUS;\n\t\t}\n\t\tY y = Y.PLUS;\n\t\tRunnable r = (Runnable)y;\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 7)\n\tRunnable r = (Runnable)y;\n\t             ^^^^^^^^^^^\nCannot cast from Y to Runnable\n----------\n");
    }

    public void test141() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid bar(X x) {\n\t\tenum Y {\n\t\t\tPLUS, MINUS;\n\t\t}\n\t\tY y = Y.PLUS;\n\t\tRunnable r = (Runnable)y;\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 7)\n\tRunnable r = (Runnable)y;\n\t             ^^^^^^^^^^^\nCannot cast from Y to Runnable\n----------\n");
    }

    public void test142() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tenum Week {\n\t\t\tMonday, Tuesday, Wednesday, Thursday, Friday, Saturday, Sunday\n\t\t}\n\t\tfor (Week w : Week.values())\n\t\t\tSystem.out.print(w + \" \");\n\t\tfor (Week w : java.util.EnumSet.range(Week.Monday, Week.Friday)) {\n\t\t\tSystem.out.print(w + \" \");\n\t\t}\n\t}\n}\n"}, "Monday Tuesday Wednesday Thursday Friday Saturday Sunday Monday Tuesday Wednesday Thursday Friday");
    }

    public void test143() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tenum Y {\n  \t\t\tA {\n    \t\t\t@Override\n    \t\t\tpublic String toString() {\n      \t\t\t\treturn a();\n    \t\t\t}\n    \t\t\tpublic abstract String a();\n  \t\t\t}\n\t\t}\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\tA {\n\t^\nThe enum constant A cannot define abstract methods\n----------\n2. ERROR in X.java (at line 9)\n\tpublic abstract String a();\n\t                       ^^^\nThe method a cannot be abstract in the enum constant A\n----------\n");
    }

    public void test144() {
        this.runNegativeTest(new String[]{"X.java", "public class X{\n\tenum Y<T> {}\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\tenum Y<T> {}\n\t       ^\nSyntax error, enum declaration cannot have type parameters\n----------\n");
    }

    public void test145() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.staticAccessReceiver", "error");
        this.runNegativeTest(true, new String[]{"ClassC.java", "public class ClassC {\n  void bar() {\n\t enum EnumA {\n  \t\tB1,\n  \t\tB2;\n  \t\tpublic void foo(){}\n\t }\n    EnumA.B1.B1.foo();\n    EnumA.B1.B2.foo();\n  }\n}"}, null, options, "----------\n1. ERROR in ClassC.java (at line 8)\n\tEnumA.B1.B1.foo();\n\t         ^^\nThe static field EnumA.B1 should be accessed in a static way\n----------\n2. ERROR in ClassC.java (at line 9)\n\tEnumA.B1.B2.foo();\n\t         ^^\nThe static field EnumA.B2 should be accessed in a static way\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test146() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tfinal String test;\n\tpublic X() { // error\n\t\tenum MyEnum {\n\t\t\tA, B\n\t\t}\n\t\tMyEnum e = MyEnum.A;\n\t\tswitch (e) {\n\t\t\tcase A:\n\t\t\t\ttest = \"a\";\n\t\t\t\tbreak;\n\t\t\tcase B:\n\t\t\t\ttest = \"a\";\n\t\t\t\tbreak;\n\t\t\t// default: test = \"unknown\"; // enabling this line fixes above error\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tpublic X() { // error\n\t       ^^^\nThe blank final field test may not have been initialized. Note that a problem regarding missing 'default:' on 'switch' has been suppressed, which is perhaps related to this problem\n----------\n");
    }

    public void test146b() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.missingDefaultCase", "warning");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tfinal String test;\n\tpublic X() { // error\n\t\tenum MyEnum {\n\t\t\tA, B\n\t\t}\n\t\tMyEnum e = MyEnum.A;\n\t\tswitch (e) {\n\t\t\tcase A:\n\t\t\t\ttest = \"a\";\n\t\t\t\tbreak;\n\t\t\tcase B:\n\t\t\t\ttest = \"a\";\n\t\t\t\tbreak;\n\t\t\t// default: test = \"unknown\"; // enabling this line fixes above error\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tpublic X() { // error\n\t       ^^^\nThe blank final field test may not have been initialized\n----------\n2. WARNING in X.java (at line 8)\n\tswitch (e) {\n\t        ^\nThe switch over the enum type MyEnum should have a default case\n----------\n", null, true, options);
    }

    public void test147() {
        this.runNegativeTest(new String[]{"p/X.java", "package p;\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tpublic abstract enum E {\n\t\t\tSUCCESS;\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in p\\X.java (at line 4)\n\tpublic abstract enum E {\n\t                     ^\nIllegal modifier for local enum E; no explicit modifier is permitted\n----------\n", null, true, null, true, false, false);
    }

    public void test148() {
        this.runNegativeTest(new String[]{"p/X.java", "package p;\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tabstract enum E implements Runnable {\n\t\t\tSUCCESS;\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in p\\X.java (at line 4)\n\tabstract enum E implements Runnable {\n\t              ^\nIllegal modifier for local enum E; no explicit modifier is permitted\n----------\n", null, true, null, true, false, false);
    }

    public void _NA_test149() throws Exception {
        this.runConformTest(new String[]{"p/X.java", "package p;\npublic class X {\n\tpublic enum E implements Runnable {\n\t\tSUCCESS;\n\t\tpublic void run(){}\n\t}\n\tpublic static void main(String[] args) {\n\t\tClass<E> c = E.class;\n\t\tSystem.out.println(c.getName() + \":\" + X.E.SUCCESS);\n\t}\n}\n"}, "p.X$E:SUCCESS");
        String expectedOutput = "// Signature: Ljava/lang/Enum<Lp/X$E;>;Ljava/lang/Runnable;\npublic static final enum p.X$E implements java.lang.Runnable {\n";
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        byte[] classFileBytes = Util.getFileByteContent((File)new File(OUTPUT_DIR + File.separator + "p" + File.separator + "X$E.class"));
        String actualOutput = disassembler.disassemble(classFileBytes, "\n", 1);
        int index = actualOutput.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(actualOutput, 3));
        }
        if (index == -1) {
            LocalEnumTest.assertEquals("Wrong contents", expectedOutput, actualOutput);
        }
    }

    public void test150() throws Exception {
        this.runConformTest(new String[]{"p/X.java", "package p;\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tenum E implements Runnable {\n\t\t\tSUCCESS;\n\t\t\tpublic void run(){}\n\t\t}\n\t\tClass<E> c = E.class;\n\t\tSystem.out.println(c.getName() + \":\" + E.SUCCESS);\n\t}\n}\n"}, "p.X$1E:SUCCESS");
    }

    public void test151() throws Exception {
        this.runConformTest(new String[]{"p/X.java", "package p;\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tenum E implements Runnable {\n\t\t\tSUCCESS {};\n\t\t\tpublic void run(){}\n\t\t}\n\t\tClass<E> c = E.class;\n\t\tSystem.out.println(c.getName() + \":\" + E.SUCCESS);\n\t}\n}\n"}, "p.X$1E:SUCCESS");
        String expectedOutput = "// Signature: Ljava/lang/Enum<Lp/X$1E;>;Ljava/lang/Runnable;\nabstract static enum p.X$1E implements java.lang.Runnable {\n  \n  // Field descriptor #8 Lp/X$1E;\n  public static final enum p.X$1E SUCCESS;\n  \n  // Field descriptor #10 [Lp/X$1E;\n  private static final synthetic p.X$1E[] ENUM$VALUES;\n  \n  // Method descriptor #12 ()V\n  // Stack: 4, Locals: 0\n  static {};\n     0  new p.X$1E$1 [14]\n     3  dup\n     4  ldc <String \"SUCCESS\"> [16]\n     6  iconst_0\n     7  invokespecial p.X$1E$1(java.lang.String, int) [17]\n    10  putstatic p.X$1E.SUCCESS : new p.X(){} [21]\n    13  iconst_1\n    14  anewarray p.X$1E [1]\n    17  dup\n    18  iconst_0\n    19  getstatic p.X$1E.SUCCESS : new p.X(){} [21]\n    22  aastore\n    23  putstatic p.X$1E.ENUM$VALUES : new p.X(){}[] [23]\n    26  return\n      Line numbers:\n        [pc: 0, line: 5]\n        [pc: 13, line: 4]\n  \n  // Method descriptor #20 (Ljava/lang/String;I)V\n  // Stack: 3, Locals: 3\n  private X$1E(java.lang.String arg0, int arg1);\n    0  aload_0 [this]\n    1  aload_1 [arg0]\n    2  iload_2 [arg1]\n    3  invokespecial java.lang.Enum(java.lang.String, int) [27]\n    6  return\n      Line numbers:\n        [pc: 0, line: 4]\n      Local variable table:\n        [pc: 0, pc: 7] local: this index: 0 type: new p.X(){}\n  \n  // Method descriptor #12 ()V\n  // Stack: 0, Locals: 1\n  public void run();\n    0  return\n      Line numbers:\n        [pc: 0, line: 6]\n      Local variable table:\n        [pc: 0, pc: 1] local: this index: 0 type: new p.X(){}\n  \n  // Method descriptor #31 ()[Lp/X$1E;\n  // Stack: 5, Locals: 3\n  public static new p.X(){}[] values();\n     0  getstatic p.X$1E.ENUM$VALUES : new p.X(){}[] [23]\n     3  dup\n     4  astore_0\n     5  iconst_0\n     6  aload_0\n     7  arraylength\n     8  dup\n     9  istore_1\n    10  anewarray p.X$1E [1]\n    13  dup\n    14  astore_2\n    15  iconst_0\n    16  iload_1\n    17  invokestatic java.lang.System.arraycopy(java.lang.Object, int, java.lang.Object, int, int) : void [32]\n    20  aload_2\n    21  areturn\n      Line numbers:\n        [pc: 0, line: 1]\n  \n  // Method descriptor #39 (Ljava/lang/String;)Lp/X$1E;\n  // Stack: 2, Locals: 1\n  public static new p.X(){} valueOf(java.lang.String arg0);\n     0  ldc <Class p.X$1E> [1]\n     2  aload_0 [arg0]\n     3  invokestatic java.lang.Enum.valueOf(java.lang.Class, java.lang.String) : java.lang.Enum [40]\n     6  checkcast p.X$1E [1]\n     9  areturn\n      Line numbers:\n        [pc: 0, line: 1]\n\n";
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        byte[] classFileBytes = Util.getFileByteContent((File)new File(OUTPUT_DIR + File.separator + "p" + File.separator + "X$1E.class"));
        String actualOutput = disassembler.disassemble(classFileBytes, "\n", 1);
        int index = actualOutput.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(actualOutput, 3));
        }
        if (index == -1) {
            LocalEnumTest.assertEquals("Wrong contents", expectedOutput, actualOutput);
        }
    }

    public void test152() {
        this.runConformTest(new String[]{"Y.java", "public class Y {\n\tpublic static void main(String[] args) {\n\t\tenum E implements Runnable {\n\t\t\tSUCCESS {};\n\t\t\tpublic void run(){}\n\t\t}\n\t\tSystem.out.println(E.SUCCESS);\n\t}\n}\n"}, "SUCCESS", null, false, null);
    }

    public void test153() {
        this.runNegativeTest(new String[]{"Y.java", "public class Y {\n\tpublic static void main(String[] args) {\n\t\tenum TestEnum {\n\t\t\tRED, GREEN, BLUE; \n    \t\tstatic int test = 0;  \n\n    \t\tTestEnum() {\n        \t\tTestEnum.test=10;\n    \t\t}\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in Y.java (at line 8)\n\tTestEnum.test=10;\n\t         ^^^^\nCannot refer to the static enum field TestEnum.test within an initializer\n----------\n", AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacBugFixed_6_10);
    }

    public void test154() {
        this.runNegativeTest(new String[]{"Y.java", "public class Y {\n\tpublic static void main(String[] args) {\n\t\tenum TestEnum2 {\n\t\t\t; \n   \t\tstatic int test = 0;  \n\t\t\tTestEnum2() {\n        \t\tTestEnum2.test=11;\n   \t\t}\n\t\t}\n\t}\n}\nclass X {\n\tstatic int test = 0;\n\tX() {\n\t\tX.test = 13;\n\t}\n}\n"}, "----------\n1. ERROR in Y.java (at line 7)\n\tTestEnum2.test=11;\n\t          ^^^^\nCannot refer to the static enum field TestEnum2.test within an initializer\n----------\n", AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacBugFixed_6_10);
    }

    public void test155() {
        this.runConformTest(new String[]{"Y.java", "public class Y {\n\tpublic static void main(String[] args) {\n\t\tenum TestEnum {\n\t\t\tRED, GREEN, BLUE; \n    \t\tstatic int test = 0;  \n\t\t}\n\n\t\tenum TestEnum2 {\n\t\t\t; \n    \t\tTestEnum2() {\n        \t\tTestEnum.test=12;\n    \t\t}\n\t\t}\n\t}\n}\n"}, "");
    }

    public void test156() {
        this.runConformTest(new String[]{"Y.java", "public class Y {\n\tpublic static void main(String[] args) {\n\t\tenum TestEnum {\n\t\t\tRED, GREEN, BLUE; \n    \t\tstatic int test = 0;  \n\n    \t\tTestEnum() {\n       \t\t new Object() {\n\t\t\t\t{ TestEnum.test=10; }\n\t\t\t\t};\n\t\t\t}\n\t\t}\n    }\n}\n"}, "");
    }

    public void test157() {
        this.runNegativeTest(new String[]{"Y.java", "public class Y {\n\tpublic static void main(String[] args) {\n\t\tenum Foo {\n\t\t\tONE, TWO, THREE;\n\t\t\tstatic int val = 10;\n\t\t\tFoo () {\n\t\t\t\tthis(Foo.val);\n\t\t\t\tSystem.out.println(Foo.val);\n\t\t\t}\n\t\t\tFoo(int i){}\n\t\t\t{\n\t\t\t\tSystem.out.println(Foo.val);\n\t\t\t}\n\t\t\tint field = Foo.val;\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in Y.java (at line 7)\n\tthis(Foo.val);\n\t         ^^^\nCannot refer to the static enum field Foo.val within an initializer\n----------\n2. ERROR in Y.java (at line 8)\n\tSystem.out.println(Foo.val);\n\t                       ^^^\nCannot refer to the static enum field Foo.val within an initializer\n----------\n3. ERROR in Y.java (at line 12)\n\tSystem.out.println(Foo.val);\n\t                       ^^^\nCannot refer to the static enum field Foo.val within an initializer\n----------\n4. ERROR in Y.java (at line 14)\n\tint field = Foo.val;\n\t                ^^^\nCannot refer to the static enum field Foo.val within an initializer\n----------\n", AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacBugFixed_6_10);
    }

    public void test158() {
        this.runNegativeTest(new String[]{"Y.java", "public class Y {\n\tpublic static void main(String[] args) {\n\t\tenum Foo {\n\t\t\tONE, TWO, THREE;\n\t\t\tstatic int val = 10;\n\t\t\tFoo () {\n\t\t\t\tthis(val);\n\t\t\t\tSystem.out.println(val);\n\t\t\t}\n\t\t\tFoo(int i){}\n\t\t\t{\n\t\t\t\tSystem.out.println(val);\n\t\t\t}\n\t\t\tint field = val;\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in Y.java (at line 7)\n\tthis(val);\n\t     ^^^\nCannot refer to the static enum field Foo.val within an initializer\n----------\n2. ERROR in Y.java (at line 8)\n\tSystem.out.println(val);\n\t                   ^^^\nCannot refer to the static enum field Foo.val within an initializer\n----------\n3. ERROR in Y.java (at line 12)\n\tSystem.out.println(val);\n\t                   ^^^\nCannot refer to the static enum field Foo.val within an initializer\n----------\n4. ERROR in Y.java (at line 14)\n\tint field = val;\n\t            ^^^\nCannot refer to the static enum field Foo.val within an initializer\n----------\n");
    }

    public void test159() {
        this.runNegativeTest(new String[]{"Y.java", "public class Y {\n\tpublic static void main(String[] args) {\n\t\tenum Foo {\n\t\t\tONE, TWO, THREE;\n\t\t\tstatic int val = 10;\n\t\t\tFoo () {\n\t\t\t\tthis(get().val);\n\t\t\t\tSystem.out.println(get().val);\n\t\t\t}\n\t\t\tFoo(int i){}\n\t\t\t{\n\t\t\t\tSystem.out.println(get().val);\n\t\t\t}\n\t\t\tint field = get().val;\n\t\t\tFoo get() { return ONE; }\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in Y.java (at line 7)\n\tthis(get().val);\n\t     ^^^\nCannot refer to an instance method while explicitly invoking a constructor\n----------\n2. WARNING in Y.java (at line 7)\n\tthis(get().val);\n\t           ^^^\nThe static field Foo.val should be accessed in a static way\n----------\n3. ERROR in Y.java (at line 7)\n\tthis(get().val);\n\t           ^^^\nCannot refer to the static enum field Foo.val within an initializer\n----------\n4. WARNING in Y.java (at line 8)\n\tSystem.out.println(get().val);\n\t                         ^^^\nThe static field Foo.val should be accessed in a static way\n----------\n5. ERROR in Y.java (at line 8)\n\tSystem.out.println(get().val);\n\t                         ^^^\nCannot refer to the static enum field Foo.val within an initializer\n----------\n6. WARNING in Y.java (at line 12)\n\tSystem.out.println(get().val);\n\t                         ^^^\nThe static field Foo.val should be accessed in a static way\n----------\n7. ERROR in Y.java (at line 12)\n\tSystem.out.println(get().val);\n\t                         ^^^\nCannot refer to the static enum field Foo.val within an initializer\n----------\n8. WARNING in Y.java (at line 14)\n\tint field = get().val;\n\t                  ^^^\nThe static field Foo.val should be accessed in a static way\n----------\n9. ERROR in Y.java (at line 14)\n\tint field = get().val;\n\t                  ^^^\nCannot refer to the static enum field Foo.val within an initializer\n----------\n");
    }

    public void test160() {
        this.runNegativeTest(new String[]{"Y.java", "public class Y {\n\tpublic static void main(String[] args) {\n\tenum Foo {\n\t\tONE, TWO, THREE;\n\t\tstatic int val = 10;\n\t\tFoo () {\n\t\t\tthis(get().val = 1);\n\t\t\tSystem.out.println(get().val = 2);\n\t\t}\n\t\tFoo(int i){}\n\t\t{\n\t\t\tSystem.out.println(get().val = 3);\n\t\t}\n\t\tint field = get().val = 4;\n\t\tFoo get() { return ONE; }\n\t}\n\t}\n}\n"}, "----------\n1. ERROR in Y.java (at line 7)\n\tthis(get().val = 1);\n\t     ^^^\nCannot refer to an instance method while explicitly invoking a constructor\n----------\n2. WARNING in Y.java (at line 7)\n\tthis(get().val = 1);\n\t           ^^^\nThe static field Foo.val should be accessed in a static way\n----------\n3. ERROR in Y.java (at line 7)\n\tthis(get().val = 1);\n\t           ^^^\nCannot refer to the static enum field Foo.val within an initializer\n----------\n4. WARNING in Y.java (at line 8)\n\tSystem.out.println(get().val = 2);\n\t                         ^^^\nThe static field Foo.val should be accessed in a static way\n----------\n5. ERROR in Y.java (at line 8)\n\tSystem.out.println(get().val = 2);\n\t                         ^^^\nCannot refer to the static enum field Foo.val within an initializer\n----------\n6. WARNING in Y.java (at line 12)\n\tSystem.out.println(get().val = 3);\n\t                         ^^^\nThe static field Foo.val should be accessed in a static way\n----------\n7. ERROR in Y.java (at line 12)\n\tSystem.out.println(get().val = 3);\n\t                         ^^^\nCannot refer to the static enum field Foo.val within an initializer\n----------\n8. WARNING in Y.java (at line 14)\n\tint field = get().val = 4;\n\t                  ^^^\nThe static field Foo.val should be accessed in a static way\n----------\n9. ERROR in Y.java (at line 14)\n\tint field = get().val = 4;\n\t                  ^^^\nCannot refer to the static enum field Foo.val within an initializer\n----------\n");
    }

    public void _NA_test161() {
        this.runConformTest(new String[]{"LocalEnumTest1.java", "enum LocalEnumTest1 {\n\t;\n\tstatic int foo = LocalEnumTest2.bar;\n}\nenum LocalEnumTest2 {\n\t;\n\tstatic int bar = LocalEnumTest1.foo;\n}\n"}, "");
    }

    public void test162() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.HashMap;\nimport java.util.Map;\n\npublic class X { \n\tpublic static void main(String[] args) {\n\t\tenum Status {\n\t\t\tGOOD((byte) 0x00), BAD((byte) 0x02);\n\n\t\t\tprivate static Map<Byte, Status> mapping;\n\n\t\t\tprivate Status(final byte newValue) {\n\n\t\t\t\tif (Status.mapping == null) {\n\t\t\t\t\tStatus.mapping = new HashMap<Byte, Status>();\n\t\t\t\t}\n\n\t\t\t\tStatus.mapping.put(newValue, this);\n\t\t\t}\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 13)\n\tif (Status.mapping == null) {\n\t           ^^^^^^^\nCannot refer to the static enum field Status.mapping within an initializer\n----------\n2. ERROR in X.java (at line 14)\n\tStatus.mapping = new HashMap<Byte, Status>();\n\t       ^^^^^^^\nCannot refer to the static enum field Status.mapping within an initializer\n----------\n3. ERROR in X.java (at line 17)\n\tStatus.mapping.put(newValue, this);\n\t       ^^^^^^^\nCannot refer to the static enum field Status.mapping within an initializer\n----------\n");
    }

    public void test163() {
        this.runConformTest(new String[]{"X.java", "import java.util.HashMap;\nimport java.util.Map;\n\npublic class X { \n\tpublic static void main(String[] args) {\n\t\tenum Status {\n\t\t\tGOOD((byte) 0x00), BAD((byte) 0x02);\n\t\t\tprivate byte value;\n\t\t\tprivate static Map<Byte, Status> mapping;\n\t\t\tprivate Status(final byte newValue) {\n\t\t\t\tthis.value = newValue;\n\t\t\t}\n\t\t\tstatic {\n\t\t\t\tStatus.mapping = new HashMap<Byte, Status>();\n\t\t\t\tfor (Status s : values()) {\n\t\t\t\t\tStatus.mapping.put(s.value, s);\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n}\n"}, "");
    }

    public void test164() {
        this.runNegativeTest(new String[]{"X.java", "public class X { \n\tpublic static void main(String[] args) {\n\t\tenum Y {\n\t\t\t;\n\t\t\tprivate Y valueOf(String arg0) { return null; }\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tprivate Y valueOf(String arg0) { return null; }\n\t          ^^^^^^^^^^^^^^^^^^^^\nThe enum Y already defines the method valueOf(String) implicitly\n----------\n");
    }

    public void test165() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "class Other {\n\tint dupField;//1\n\tint dupField;//2\n\tint dupField;//3\n\tint dupField;//4\n\tvoid dupMethod(int i) {}//5\n\tvoid dupMethod(int i) {}//6\n\tvoid dupMethod(int i) {}//7\n\tvoid dupMethod(int i) {}//8\n\tvoid foo() {\n\t\tint i = dupMethod(dupField);\n\t}\n}\n\npublic class X { \n\tpublic static void main(String[] args) {\n\t\tenum Y {\n       \t;\n        \tprivate Y valueOf(String arg0) { return null; }//9\n        \tprivate Y valueOf(String arg0) { return null; }//10\n        \tprivate Y valueOf(String arg0) { return null; }//11\n       \tvoid foo() {\n        \t\tint i = valueOf(\"\");\n        \t}\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tint dupField;//1\n\t    ^^^^^^^^\nDuplicate field Other.dupField\n----------\n2. ERROR in X.java (at line 3)\n\tint dupField;//2\n\t    ^^^^^^^^\nDuplicate field Other.dupField\n----------\n3. ERROR in X.java (at line 4)\n\tint dupField;//3\n\t    ^^^^^^^^\nDuplicate field Other.dupField\n----------\n4. ERROR in X.java (at line 5)\n\tint dupField;//4\n\t    ^^^^^^^^\nDuplicate field Other.dupField\n----------\n5. ERROR in X.java (at line 6)\n\tvoid dupMethod(int i) {}//5\n\t     ^^^^^^^^^^^^^^^^\nDuplicate method dupMethod(int) in type Other\n----------\n6. ERROR in X.java (at line 7)\n\tvoid dupMethod(int i) {}//6\n\t     ^^^^^^^^^^^^^^^^\nDuplicate method dupMethod(int) in type Other\n----------\n7. ERROR in X.java (at line 8)\n\tvoid dupMethod(int i) {}//7\n\t     ^^^^^^^^^^^^^^^^\nDuplicate method dupMethod(int) in type Other\n----------\n8. ERROR in X.java (at line 9)\n\tvoid dupMethod(int i) {}//8\n\t     ^^^^^^^^^^^^^^^^\nDuplicate method dupMethod(int) in type Other\n----------\n9. ERROR in X.java (at line 11)\n\tint i = dupMethod(dupField);\n\t        ^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from void to int\n----------\n10. ERROR in X.java (at line 19)\n\tprivate Y valueOf(String arg0) { return null; }//9\n\t          ^^^^^^^^^^^^^^^^^^^^\nThe enum Y already defines the method valueOf(String) implicitly\n----------\n11. ERROR in X.java (at line 20)\n\tprivate Y valueOf(String arg0) { return null; }//10\n\t          ^^^^^^^^^^^^^^^^^^^^\nThe enum Y already defines the method valueOf(String) implicitly\n----------\n12. ERROR in X.java (at line 21)\n\tprivate Y valueOf(String arg0) { return null; }//11\n\t          ^^^^^^^^^^^^^^^^^^^^\nThe enum Y already defines the method valueOf(String) implicitly\n----------\n13. ERROR in X.java (at line 23)\n\tint i = valueOf(\"\");\n\t        ^^^^^^^^^^^\nType mismatch: cannot convert from Y to int\n----------\n");
    }

    public void test166() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X { \n\tpublic static void main(String[] args) {\n\t\tenum Y {\n        \t;\n       \tprivate int valueOf(String arg0) { return 0; }//11\n        \tvoid foo() {\n        \t\tint i = valueOf(\"\");\n        \t}\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tprivate int valueOf(String arg0) { return 0; }//11\n\t            ^^^^^^^^^^^^^^^^^^^^\nThe enum Y already defines the method valueOf(String) implicitly\n----------\n2. ERROR in X.java (at line 7)\n\tint i = valueOf(\"\");\n\t        ^^^^^^^^^^^\nType mismatch: cannot convert from Y to int\n----------\n", null, true, null, true, false, false);
        String expectedPartialOutput = "  public static void main(java.lang.String[] arg0);\n     0  new java.lang.Error [16]\n     3  dup\n     4  ldc <String \"Unresolved compilation problems: \\n\\tThe enum Y already defines the method valueOf(String) implicitly\\n\\tType mismatch: cannot convert from Y to int\\n\"> [18]\n     6  invokespecial java.lang.Error(java.lang.String) [20]\n     9  athrow\n";
        this.verifyClassFile(expectedPartialOutput, "X.class", 4, true);
    }

    public void test167() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X { \n\tpublic static void main(String[] args) {\n\t\tenum Y {\n    \t\t;\n    \t\tstatic int valueOf(String arg0) { return 0; }//9\n   \t\tvoid foo() {\n    \t\t\tint i = Y.valueOf(\"\");\n   \t\t}\n\t\t}\n\t\tclass Other {\n    \t\tvoid foo() {\n    \t\t\tint i = Y.valueOf(\"\");\n    \t\t}\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tstatic int valueOf(String arg0) { return 0; }//9\n\t           ^^^^^^^^^^^^^^^^^^^^\nThe enum Y already defines the method valueOf(String) implicitly\n----------\n2. ERROR in X.java (at line 7)\n\tint i = Y.valueOf(\"\");\n\t        ^^^^^^^^^^^^^\nType mismatch: cannot convert from Y to int\n----------\n----------\n1. ERROR in X.java (at line 12)\n\tint i = Y.valueOf(\"\");\n\t        ^^^^^^^^^^^^^\nType mismatch: cannot convert from Y to int\n----------\n", null, true, null, true, false, false);
    }

    public void test168() {
        this.runNegativeTest(new String[]{"X.java", "public class X { \n\tpublic static void main(String[] args) {\n\t\tenum BadEnum {\n    \t\tCRAZY(CRAZY), // <-- illegal forward reference reported by all compilers\n    \t\tIMPOSSIBLE(BadEnum.IMPOSSIBLE); // <-- illegal forward reference (javac 1.6 only)\n    \t\tprivate BadEnum(BadEnum self) {\n    \t\t}\n\t\t}\n\t\tclass A {\n    \t\tA x1 = new A(x1);//1 - WRONG\n    \t\tstatic A X2 = new A(A.X2);//2 - OK\n    \t\tA x3 = new A(this.x3);//3 - OK\n    \t\tA(A x) {}\n    \t\tA(int i) {}\n    \t\tint VALUE() { return 13; }\n    \t\tint value() { return 14; }\n\t\t}\n\t\tclass Y extends A {\n    \t\tA x1 = new A(x1);//6 - WRONG\n    \t\tstatic A X2 = new A(Y.X2);//7 - OK\n    \t\tA x3 = new A(this.x3);//8 - OK\n    \t\tY(Y y) { super(y); }\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tCRAZY(CRAZY), // <-- illegal forward reference reported by all compilers\n\t      ^^^^^\nCannot reference a field before it is defined\n----------\n2. ERROR in X.java (at line 5)\n\tIMPOSSIBLE(BadEnum.IMPOSSIBLE); // <-- illegal forward reference (javac 1.6 only)\n\t                   ^^^^^^^^^^\nCannot reference a field before it is defined\n----------\n3. ERROR in X.java (at line 10)\n\tA x1 = new A(x1);//1 - WRONG\n\t             ^^\nCannot reference a field before it is defined\n----------\n4. ERROR in X.java (at line 11)\n\tstatic A X2 = new A(A.X2);//2 - OK\n\t              ^^^^^^^^^^^\nCannot instantiate local class 'A' in a static context\n----------\n5. WARNING in X.java (at line 19)\n\tA x1 = new A(x1);//6 - WRONG\n\t  ^^\nThe field Y.x1 is hiding a field from type A\n----------\n6. ERROR in X.java (at line 19)\n\tA x1 = new A(x1);//6 - WRONG\n\t             ^^\nCannot reference a field before it is defined\n----------\n7. WARNING in X.java (at line 20)\n\tstatic A X2 = new A(Y.X2);//7 - OK\n\t         ^^\nThe field Y.X2 is hiding a field from type A\n----------\n8. ERROR in X.java (at line 20)\n\tstatic A X2 = new A(Y.X2);//7 - OK\n\t              ^^^^^^^^^^^\nCannot instantiate local class 'A' in a static context\n----------\n9. WARNING in X.java (at line 21)\n\tA x3 = new A(this.x3);//8 - OK\n\t  ^^\nThe field Y.x3 is hiding a field from type A\n----------\n");
    }

    public void test168_extract() {
        this.runNegativeTest(new String[]{"X.java", "public class X { \n\tpublic static void main(String[] args) {\n\t\tclass A {\n    \t\tA(A a) {}\n    \t\tstatic A X2 = new A(A.X2);\n\t\t}\n\t\tclass Y extends A {\n    \t\tstatic A X3 = new A(Y.X3);\n    \t\tY(Y y) { super(y); }\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tstatic A X2 = new A(A.X2);\n\t              ^^^^^^^^^^^\nCannot instantiate local class 'A' in a static context\n----------\n2. ERROR in X.java (at line 8)\n\tstatic A X3 = new A(Y.X3);\n\t              ^^^^^^^^^^^\nCannot instantiate local class 'A' in a static context\n----------\n");
    }

    public void test169() {
        this.runNegativeTest(new String[]{"X.java", "public class X { \n\tpublic static void main(String[] args) {\n\t\tenum BadEnum {\n    \t\tNOWAY(BadEnum.NOWAY.CONST),\n    \t\tINVALID(INVALID.CONST),\n    \t\tWRONG(WRONG.VALUE()),\n    \t\tILLEGAL(ILLEGAL.value());\n    \t\tfinal static int CONST = 12;\n    \t\tprivate BadEnum(int i) {\n    \t\t}\n    \t\tint VALUE() { return 13; }\n    \t\tint value() { return 14; }\n\t\t}\n\t\tclass Y {\n    \t\tfinal static int CONST = 12;\n    \t\tY x4 = new Y(x4.CONST);//4 - WRONG\n    \t\tY x5 = new Y(x5.value());//5 - WRONG\n   \t\tY(int i) {}\n    \t\tint VALUE() { return 13; }\n    \t\tint value() { return 14; }\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tNOWAY(BadEnum.NOWAY.CONST),\n\t              ^^^^^\nCannot reference a field before it is defined\n----------\n2. WARNING in X.java (at line 4)\n\tNOWAY(BadEnum.NOWAY.CONST),\n\t                    ^^^^^\nThe static field BadEnum.CONST should be accessed in a static way\n----------\n3. ERROR in X.java (at line 5)\n\tINVALID(INVALID.CONST),\n\t        ^^^^^^^\nCannot reference a field before it is defined\n----------\n4. WARNING in X.java (at line 5)\n\tINVALID(INVALID.CONST),\n\t                ^^^^^\nThe static field BadEnum.CONST should be accessed in a static way\n----------\n5. ERROR in X.java (at line 6)\n\tWRONG(WRONG.VALUE()),\n\t      ^^^^^\nCannot reference a field before it is defined\n----------\n6. ERROR in X.java (at line 7)\n\tILLEGAL(ILLEGAL.value());\n\t        ^^^^^^^\nCannot reference a field before it is defined\n----------\n7. ERROR in X.java (at line 16)\n\tY x4 = new Y(x4.CONST);//4 - WRONG\n\t             ^^\nCannot reference a field before it is defined\n----------\n8. WARNING in X.java (at line 16)\n\tY x4 = new Y(x4.CONST);//4 - WRONG\n\t                ^^^^^\nThe static field Y.CONST should be accessed in a static way\n----------\n9. ERROR in X.java (at line 17)\n\tY x5 = new Y(x5.value());//5 - WRONG\n\t             ^^\nCannot reference a field before it is defined\n----------\n");
    }

    public void test170() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n   public static final int FOO = X.OFFSET + 0;\n   public static final int BAR = OFFSET + 1;\n   public static final int OFFSET = 0;  // cannot move this above, else more errors\n\tpublic static void main(String[] args) {\n\t\tenum Days {\n    \t\tMonday(\"Mon\", Days.OFFSET + 0),    // should not complain\n    \t\tTuesday(\"Tue\", Days.Wednesday.hashCode()),   // should complain since enum constant\n    \t\tWednesday(\"Wed\", OFFSET + 2);   // should complain since unqualified\n    \t\tpublic static final int OFFSET = 0;  // cannot move this above, else more errors\n   \t\tDays(String abbr, int index) {\n    \t\t}\n\t\t}\n\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tpublic static final int BAR = OFFSET + 1;\n\t                              ^^^^^^\nCannot reference a field before it is defined\n----------\n2. ERROR in X.java (at line 8)\n\tTuesday(\"Tue\", Days.Wednesday.hashCode()),   // should complain since enum constant\n\t                    ^^^^^^^^^\nCannot reference a field before it is defined\n----------\n3. ERROR in X.java (at line 9)\n\tWednesday(\"Wed\", OFFSET + 2);   // should complain since unqualified\n\t                 ^^^^^^\nCannot reference a field before it is defined\n----------\n4. WARNING in X.java (at line 10)\n\tpublic static final int OFFSET = 0;  // cannot move this above, else more errors\n\t                        ^^^^^^\nThe field Days.OFFSET is hiding a field from type X\n----------\n");
    }

    public void test171() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "warning");
        this.runConformTest(true, new String[]{"X.java", "public class X { \n\tpublic static void main(String[] args) {\n    \tenum Colors {\n\t    \tBLEU,\n\t    \tBLANC,\n\t     \tROUGE\n\t \t}\n\t\tfor (Colors c: Colors.values()) {\n           System.out.print(c);\n\t\t}\n\t}\n}\n"}, null, options, "", "BLEUBLANCROUGE", null, null);
    }

    public void test172() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "warning");
        this.runConformTest(true, new String[]{"X.java", "public class X { \n\tpublic static void main(String[] args) {\n   \tenum Greet {\n\t    \tHELLO, HOWDY, BONJOUR; \n   \t}\n\t\tenum Colors {\n       \tRED, BLACK, BLUE;\n   \t}\n   \tenum Complaint {       \tWARNING, ERROR, FATAL_ERROR, PANIC;\n   \t}\n\t\tGreet g = Greet.valueOf(\"HELLO\");\n\t\tSystem.out.print(g);\n       Colors c = Enum.valueOf(Colors.class, \"RED\");\n\t\tSystem.out.print(c);\n   }\n}\n"}, null, customOptions, "----------\n1. WARNING in X.java (at line 9)\n\tenum Complaint {       \tWARNING, ERROR, FATAL_ERROR, PANIC;\n\t     ^^^^^^^^^\nThe type Complaint is never used locally\n----------\n", "HELLORED", null, AbstractRegressionTest.JavacTestOptions.Excuse.EclipseHasSomeMoreWarnings);
    }

    public void test173() {
        this.runNegativeTest(new String[]{"X.java", "public class X { \n\tpublic static void main(String[] args) {\n\t\tenum E {\n\t\t\tA(E.STATIK);\n\t\t\tprivate static int STATIK = 1;\n\t\t\tprivate E(final int i) {}\n\t\t}\n\t\tenum E2 {\n\t\t\tA(E2.STATIK);\n\t\t\tstatic int STATIK = 1;\n\t\t\tprivate E2(final int i) {}\n\t\t}\n   }\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tA(E.STATIK);\n\t    ^^^^^^\nCannot reference a field before it is defined\n----------\n----------\n1. ERROR in X.java (at line 9)\n\tA(E2.STATIK);\n\t     ^^^^^^\nCannot reference a field before it is defined\n----------\n");
    }

    public void test174() {
        this.runConformTest(new String[]{"X.java", "import java.util.HashMap;\nimport java.util.Map;\npublic class X {\n\tpublic static void main(String[] args) throws Exception {\n\t\tinterface S {}\n\t\tenum A implements S {\n\t\t\tL;\n\t\t}\n\t\tEnum<? extends S> enumConstant = A.L;\n\t\tMap<String, Enum> m = new HashMap<>();\n\t\tfor (Enum e : enumConstant.getDeclaringClass().getEnumConstants()) {\n\t\t\tm.put(e.name(), e);\n\t\t}\n\t\tSystem.out.print(1);\n\t}\n}\n"}, "1");
    }

    public void test175() {
        this.runConformTest(new String[]{"X.java", "import java.util.HashMap;\nimport java.util.Map;\npublic class X {\n\tpublic static void main(String[] args) throws Exception {\n\t\tinterface S {}\n\t\tenum A implements S {\n\t\t\tL, M, N, O;\n\t\t}\n\t\tEnum[] tab = new Enum[] {A.L, A.M, A.N, A.O};\n\t\tMap m = new HashMap();\n\t\tfor (Enum s : tab) {\n\t\t\tm.put(s.name(), s);\n\t\t}\n\t\tSystem.out.print(1);\n\t}\n}\n"}, "1");
    }

    public void test176() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) throws Exception {\n\t\tenum Y {\n\t\t\tA(\"\"), B(\"SUCCESS\"), C(\"Hello\");\n\n\t\t\tString message;\n\n\t\t\tY(@Deprecated String s) {\n\t\t\t\tthis.message = s;\n\t\t\t}\n\t\t\t@Override\n\t\t\tpublic String toString() {\n\t\t\t\treturn this.message;\n\t\t\t}\n\t\t}\n\t}\n}\n"}, "");
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.processAnnotations", "enabled");
        this.runConformTest(false, new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) throws Exception {\n\t\tenum Y {\n\t\t\tA(\"\"), B(\"SUCCESS\"), C(\"Hello\");\n\n\t\t\tString message;\n\n\t\t\tY(@Deprecated String s) {\n\t\t\t\tthis.message = s;\n\t\t\t}\n\t\t\t@Override\n\t\t\tpublic String toString() {\n\t\t\t\treturn this.message;\n\t\t\t}\n\t\t}\n\t\tSystem.out.println(Y.B);\n\t}\n}\n"}, null, options, "", "SUCCESS", "", AbstractRegressionTest.JavacTestOptions.Excuse.JavacHasWarningsEclipseNotConfigured);
    }

    public void test177() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) throws Exception {\n\t\tenum Y {\n\t\t\tA(\"\", 0, \"A\"), B(\"SUCCESS\", 0, \"B\"), C(\"Hello\", 0, \"C\");\n\n\t\t\tprivate String message;\n\t\t\tprivate int index;\n\t\t\tprivate String name;\n\n\t\t\tY(@Deprecated String s, int i, @Deprecated String name) {\n\t\t\t\tthis.message = s;\n\t\t\t\tthis.index = i;\n\t\t\t\tthis.name = name;\n\t\t\t}\n\t\t\t@Override\n\t\t\tpublic String toString() {\n\t\t\t\treturn this.message + this.name;\n\t\t\t}\n\t\t}\n\t}\n}\n"}, "");
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.processAnnotations", "enabled");
        this.runConformTest(false, new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) throws Exception {\n\t\tenum Y {\n\t\t\tA(\"\", 0, \"A\"), B(\"SUCCESS\", 0, \"B\"), C(\"Hello\", 0, \"C\");\n\n\t\t\tprivate String message;\n\t\t\tprivate int index;\n\t\t\tprivate String name;\n\n\t\t\tY(@Deprecated String s, int i, @Deprecated String name) {\n\t\t\t\tthis.message = s;\n\t\t\t\tthis.index = i;\n\t\t\t\tthis.name = name;\n\t\t\t}\n\t\t\t@Override\n\t\t\tpublic String toString() {\n\t\t\t\treturn this.message + this.name;\n\t\t\t}\n\t\t}\n\t\tSystem.out.println(Y.B);\n\t}\n}\n"}, null, options, "", "SUCCESSB", "", AbstractRegressionTest.JavacTestOptions.Excuse.JavacHasWarningsEclipseNotConfigured);
    }

    public void _NA_test178() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static enum Y {\n\t\tA(\"\", 0, \"A\"), B(\"SUCCESS\", 0, \"B\"), C(\"Hello\", 0, \"C\");\n\t\t\n\t\tprivate String message;\n\t\tprivate int index;\n\t\tprivate String name;\n\t\tY(@Deprecated String s, int i, @Deprecated String name) {\n\t\t\tthis.message = s;\n\t\t\tthis.index = i;\n\t\t\tthis.name = name;\n\t\t}\n\t\t@Override\n\t\tpublic String toString() {\n\t\t\treturn this.message + this.name;\n\t\t}\n\t}\n}"}, "");
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.processAnnotations", "enabled");
        this.runConformTest(false, new String[]{"Z.java", "public class Z {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(X.Y.B);\n\t}\n}"}, null, options, "", "SUCCESSB", "", null);
    }

    public void test179() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.processAnnotations", "enabled");
        this.runConformTest(false, new String[]{"Z.java", "public class Z {\n\tpublic static void main(String[] args) {\n\t\tclass X {\n\t\t\tenum Y {\n\t\t\t\tA(\"\", 0, \"A\"), B(\"SUCCESS\", 0, \"B\"), C(\"Hello\", 0, \"C\");\n\t\t\n\t\t\t\tprivate String message;\n\t\t\t\tprivate int index;\n\t\t\t\tprivate String name;\n\t\t\t\tY(@Deprecated String s, int i, @Deprecated String name) {\n\t\t\t\t\tthis.message = s;\n\t\t\t\t\tthis.index = i;\n\t\t\t\t\tthis.name = name;\n\t\t\t\t}\n\t\t\t\t@Override\n\t\t\t\tpublic String toString() {\n\t\t\t\t\treturn this.message + this.name;\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t\tSystem.out.println(X.Y.B);\n\t}\n}"}, null, options, "", "SUCCESSB", "", AbstractRegressionTest.JavacTestOptions.Excuse.JavacHasWarningsEclipseNotConfigured);
    }

    public void test180() {
        this.runConformTest(new String[]{"p/package-info.java", "@p.Annot(state=p.MyEnum.BROKEN)\npackage p;", "p/Annot.java", "package p;\n@Annot(state=MyEnum.KO)\npublic @interface Annot {\n\tMyEnum state() default MyEnum.KO;\n}", "p/MyEnum.java", "package p;\n@Annot(state=MyEnum.KO)\npublic enum MyEnum {\n\tWORKS, OK, KO, BROKEN, ;\n}"}, "");
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.processAnnotations", "enabled");
        this.runConformTest(false, new String[]{"X.java", "import p.MyEnum;\nimport p.Annot;\npublic class X {\n\tpublic static void main(String[] args) {\n\t\t@Annot(state=MyEnum.KO)\n\t\tenum LocalEnum {\n\t\t\tA, B, ;\n\t\t}\n\t\tSystem.out.print(LocalEnum.class);\n\t}\n}"}, null, options, "", "class X$1LocalEnum", "", null);
    }

    public void test180a() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.annotation.nullanalysis", "enabled");
        this.runConformTest(new String[]{"p/package-info.java", "@p.Annot(state=p.MyEnum.BROKEN)\npackage p;", "p/Annot.java", "package p;\n@Annot(state=MyEnum.KO)\npublic @interface Annot {\n\tMyEnum state() default MyEnum.KO;\n}", "p/MyEnum.java", "package p;\n@Annot(state=MyEnum.KO)\npublic enum MyEnum {\n\tWORKS, OK, KO, BROKEN, ;\n}"}, "", null, true, null, options, null);
        options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.processAnnotations", "enabled");
        this.runConformTest(false, new String[]{"X.java", "import p.MyEnum;\nimport p.Annot;\npublic class X {\n\tpublic static void main(String[] args) {\n\t\t@Annot(state=MyEnum.OK)\n\t\tenum LocalEnum {\n\t\t\tA, B, ;\n\t\t}\n\t\tSystem.out.print(LocalEnum.class);\n\t}\n}"}, null, options, "", "class X$1LocalEnum", "", null);
    }

    public void test181() {
        this.runConformTest(new String[]{"B.java", "public class B {\n\tenum X {\n\t\tA {\n\t\t\t@Override\n\t\t\tpublic Object foo(final String s) {\n\t\t\t\tclass Local {\n\t\t\t\t\tpublic String toString() {\n\t\t\t\t\t\treturn s;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\treturn new Local();\n\t\t\t}\n\t\t};\n\t\tpublic abstract Object foo(String s);\n\t}\n\tpublic static void main(String... args) {\n\t\t System.out.println(X.A.foo(\"SUCCESS\"));\n\t}\n}"}, "SUCCESS");
    }

    public void test182() throws Exception {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", "optimize out");
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String argv[])   {\n\t\tfoo();\n\t}\n\tpublic static void foo() {\n\t\tenum E {\n\t\t\ta1(1), a2(2);\n\t\t\tstatic int[] VALUES = { 1, 2 };\n\t\t\tprivate int value;\n\t\t\tE(int v) {\n\t\t\t\tthis.value = v;\n\t\t\t}\n\t\t\tpublic int val() {\n\t\t\t\treturn this.value;\n\t\t\t}\n\t\t}\n\t\tint n = 0;\n\t\tfor (E e : E.values()) {\n\t\t\tif (e.val() == E.VALUES[n++] ) {\n\t\t\t\tSystem.out.print(e.val());\n\t\t\t}\n\t\t}\n\t}\n}"}, "12", null, true, null, customOptions, null);
    }

    public void test183() throws Exception {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", "optimize out");
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String argv[]) {\n\t}\n\tstatic {\n\t\tenum E {\n\t\t\ta1(1), a2(2);\n\t\t\tstatic int[] VALUES = { 1, 2 };\n\t\t\tprivate int value;\n\t\t\tE(int v) {\n\t\t\t\tthis.value = v;\n\t\t\t}\n\t\t\tpublic int val() {\n\t\t\t\treturn this.value;\n\t\t\t}\n\t\t}\n\t\tint n = 0;\n\t\tfor (E e : E.values()) {\n\t\t\tif (e.val() == E.VALUES[n++] ) {\n\t\t\t\tSystem.out.print(e.val());\n\t\t\t}\n\t\t}\n\t}\n}"}, "12", null, true, null, customOptions, null);
    }

    public void test184() throws Exception {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", "optimize out");
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String argv[]) {\n\t\tnew X();\n\t}\n\tX() {\n\t\tenum E {\n\t\t\ta1(1), a2(2);\n\t\t\tstatic int[] VALUES = { 1, 2 };\n\t\t\tprivate int value;\n\t\t\tE(int v) {\n\t\t\t\tthis.value = v;\n\t\t\t}\n\t\t\tpublic int val() {\n\t\t\t\treturn this.value;\n\t\t\t}\n\t\t}\n\t\tint n = 0;\n\t\tfor (E e : E.values()) {\n\t\t\tif (e.val() == E.VALUES[n++] ) {\n\t\t\t\tSystem.out.print(e.val());\n\t\t\t}\n\t\t}\n\t}\n}"}, "12", null, true, null, customOptions, null);
    }

    public void test185() {
        this.runNegativeTest(new String[]{"X.java", "public class X{\n\tpublic static void main(String argv[]) {\n\t\tenum Y{\n  \t\t\tA, B;\n  \t\t\tprivate Y() throws Exception {\n  \t\t\t}\n\t\t}\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\tA, B;\n\t^\nUnhandled exception type Exception\n----------\n2. ERROR in X.java (at line 4)\n\tA, B;\n\t   ^\nUnhandled exception type Exception\n----------\n");
    }

    public void test186() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.missingEnumCaseDespiteDefault", "enabled");
        this.runNegativeTest(new String[]{"Y.java", "public class Y {\n    void _test(boolean val) {\n\t\t enum X {\n\t\t   A, B;\n\t\t }\n\t\t X x= val? X.A : X.B;\n        switch (x) {\n\t\t\tcase A: System.out.println(\"A\"); break;\n \t\t\tdefault : System.out.println(\"unknown\"); break;\n        }\n    }\n}\n"}, "----------\n1. WARNING in Y.java (at line 7)\n\tswitch (x) {\n\t        ^\nThe enum constant B should have a corresponding case label in this enum switch on X. To suppress this problem, add a comment //$CASES-OMITTED$ on the line above the 'default:'\n----------\n", null, true, options, false, false, false, false, AbstractRegressionTest.JavacTestOptions.Excuse.EclipseHasSomeMoreWarnings, false);
    }

    public void test187() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.missingEnumCaseDespiteDefault", "enabled");
        options.put("org.eclipse.jdt.core.compiler.problem.incompleteEnumSwitch", "error");
        this.runConformTest(new String[]{"Y.java", "public class Y {\n    void _test(boolean val) {\n\t\t enum X {\n\t\t   A, B;\n\t\t }\n\t\t X x= val? X.A : X.B;\n        switch (x) {\n\t\t\tcase A: System.out.println(\"A\");\n           //$FALL-THROUGH$\n           //$CASES-OMITTED$\n \t\t\tdefault : System.out.println(\"unknown\"); break;\n        }\n    }\n}\n"}, "", null, true, null, options, null);
    }

    public void test187a() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.missingEnumCaseDespiteDefault", "enabled");
        this.runNegativeTest(new String[]{"Y.java", "public class Y {\n    void _test(boolean val) {\n\t\t enum X {\n\t\t   A, B;\n\t\t }\n\t\t X x= val? X.A : X.B;\n        switch (x) {\n\t\t\tcase A: System.out.println(\"A\"); break;\n           //$CASES-OMITTED$\n        }\n    }\n}\n"}, "----------\n1. WARNING in Y.java (at line 7)\n\tswitch (x) {\n\t        ^\nThe enum constant B needs a corresponding case label in this enum switch on X\n----------\n", null, true, options, false, false, false, false, AbstractRegressionTest.JavacTestOptions.Excuse.EclipseHasSomeMoreWarnings, false);
    }

    public void test187b() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.missingDefaultCase", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.suppressOptionalErrors", "enabled");
        this.runConformTest(new String[]{"Y.java", "public class Y {\n    @SuppressWarnings(\"incomplete-switch\")\n    void _test(boolean val) {\n\t\t enum X {\n\t\t   A, B;\n\t\t }\n\t\t X x= val? X.A : X.B;\n        switch (x) {\n\t\t\tcase A: System.out.println(\"A\"); break;\n        }\n    }\n}\n"}, "", null, true, null, options, null);
    }

    public void test188() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.missingDefaultCase", "warning");
        this.runNegativeTest(new String[]{"Y.java", "public class Y {\n    void _test(boolean val) {\n\t\t enum X {\n\t\t   A, B;\n\t\t }\n\t\t X x= val? X.A : X.B;\n        switch (x) {\n\t\t\tcase A: System.out.println(\"A\"); break;\n\t\t\tcase B: System.out.println(\"B\"); break;\n        }\n    }\n}\n"}, "----------\n1. WARNING in Y.java (at line 7)\n\tswitch (x) {\n\t        ^\nThe switch over the enum type X should have a default case\n----------\n", null, true, options, false, false, false, false, AbstractRegressionTest.JavacTestOptions.Excuse.EclipseHasSomeMoreWarnings, false);
    }

    public void test189() {
        Map options = this.getCompilerOptions();
        this.runNegativeTest(new String[]{"Y.java", "public class Y {\n    public int test(boolean val) {\n\t\t enum X {\n\t\t   A, B;\n\t\t }\n\t\t X x= val? X.A : X.B;\n        switch (x) {\n\t\t\tcase A: return 1;\n\t\t\tcase B: return 2;\n        }\n    }\n}\n"}, "----------\n1. ERROR in Y.java (at line 2)\n\tpublic int test(boolean val) {\n\t           ^^^^^^^^^^^^^^^^^\nThis method must return a result of type int. Note that a problem regarding missing 'default:' on 'switch' has been suppressed, which is perhaps related to this problem\n----------\n", null, true, options);
    }

    public void test433060() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.redundantSpecificationOfTypeArguments", "error");
        this.runNegativeTest(new String[]{"Y.java", "public class Y{\n\tpublic static void main(String argv[]) {\n\t\tenum X<T> {\n\t\t\tOBJ;\n\t\t}\n\t}\n}"}, "----------\n1. ERROR in Y.java (at line 3)\n\tenum X<T> {\n\t       ^\nSyntax error, enum declaration cannot have type parameters\n----------\n", null, true, options);
    }

    public void test434442() {
        this.runConformTest(new String[]{"Y.java", "public class Y {\n  public static void main(String[] args) {\n\t\tenum Letter {\n  \t\t\tA, B;\n\t\t}\n\t\tinterface I {\n  \t\t\tpublic default void test(Letter letter) {\n    \t\t\tswitch (letter) {\n      \t\t\t\tcase A:\n        \t\t\t\tSystem.out.print(\"A\");\n        \t\t\t\tbreak;\n      \t\t\t\tcase B:\n        \t\t\t\tSystem.out.print(\"B\");\n        \t\t\t\tbreak;\n    \t\t\t}\n  \t\t\t}\n\t\t}\n\t\tclass X implements I {\n  \t\t}\n\t\ttry{\n\t\t\tX x = new X();\n\t\t\tx.test(Letter.A);\n\t  \t}\n    \tcatch (Exception e) {\n      \t\te.printStackTrace();\n    \t}\n  }\n} \n\n"}, "A");
    }

    public void test476281() {
        this.runConformTest(new String[]{"Y.java", "public class Y {\n  public static void main(String[] args) {\n\t\tenum LambdaEnumLocalClassBug {\n  \t\t\tA(() -> {\n    \t\t\tclass Foo {\n    \t\t\t}\n    \t\t\tnew Foo();\n    \t\t\tSystem.out.println(\"Success\");\n  \t\t\t})\n\t\t\t;\n  \t\t\tprivate final Runnable runnable;\n  \t\t\tprivate LambdaEnumLocalClassBug(Runnable runnable) {\n    \t\t\tthis.runnable = runnable;\n  \t\t\t}\n\t\t}\n    \tLambdaEnumLocalClassBug.A.runnable.run();\n  }\n} \n"}, "Success");
    }

    public void test476281a() {
        this.runConformTest(new String[]{"Y.java", "public class Y {\n  public static void main(String[] args) {\n\t\tenum Test {\n  \t\t\tB(new Runnable() {\n\t\t\t\tpublic void run() {\n\t\t\t\t\t//\n\t\t\t\t\tclass Foo {\n\t\t\t\t\t\n\t\t\t\t\t}\n\t\t\t\t\tnew Foo();\n   \t\t \t\tSystem.out.println(\"Success\");\n\t\t\t\t}\n\t\t\t});\n  \t\t\tprivate final Runnable runnable;\n  \t\t\tprivate Test(Runnable runnable) {\n    \t\t\tthis.runnable = runnable;\n  \t\t\t}\n\t\t}\n    \tTest.B.runnable.run();\n  }\n} \n"}, "Success");
    }

    public void test566758() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n\t<T> void m(T t) {\n\t\tinterface Y {\n\t\t\tT foo(); // T should not be allowed\n\t\t}\n\t}\n\t\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\tT foo(); // T should not be allowed\n\t^\nCannot make a static reference to the non-static type T\n----------\n", null, true);
    }
}

