/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;
import org.eclipse.jdt.core.util.ClassFileBytesDisassembler;
import org.eclipse.jdt.core.util.ClassFormatException;
import org.eclipse.jdt.internal.compiler.util.Util;

public class LocalStaticsTest
extends AbstractRegressionTest {
    public static Class<?> testClass() {
        return LocalStaticsTest.class;
    }

    public static Test suite() {
        return LocalStaticsTest.buildMinimalComplianceTestSuite(LocalStaticsTest.testClass(), 8192);
    }

    public LocalStaticsTest(String testName) {
        super(testName);
    }

    @Override
    protected Map<String, String> getCompilerOptions() {
        Map<String, String> defaultOptions = super.getCompilerOptions();
        defaultOptions.put("org.eclipse.jdt.core.compiler.compliance", "16");
        defaultOptions.put("org.eclipse.jdt.core.compiler.source", "16");
        defaultOptions.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "16");
        defaultOptions.put("org.eclipse.jdt.core.compiler.problem.reportPreviewFeatures", "ignore");
        defaultOptions.put("org.eclipse.jdt.core.compiler.storeAnnotations", "enabled");
        return defaultOptions;
    }

    @Override
    protected void runConformTest(String[] testFiles, String expectedOutput) {
        this.runConformTest(testFiles, expectedOutput, this.getCompilerOptions());
    }

    @Override
    protected void runConformTest(String[] testFiles, String expectedOutput, Map<String, String> customOptions) {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.testFiles = testFiles;
        runner.expectedOutputString = expectedOutput;
        runner.vmArguments = new String[]{"--enable-preview"};
        runner.customOptions = customOptions;
        runner.runConformTest();
    }

    @Override
    protected void runNegativeTest(String[] testFiles, String expectedCompilerLog) {
        this.runNegativeTest(testFiles, expectedCompilerLog, null);
    }

    protected void runWarningTest(String[] testFiles, String expectedCompilerLog) {
        this.runWarningTest(testFiles, expectedCompilerLog, null);
    }

    protected void runWarningTest(String[] testFiles, String expectedCompilerLog, Map<String, String> customOptions) {
        this.runWarningTest(testFiles, expectedCompilerLog, customOptions, null);
    }

    protected void runWarningTest(String[] testFiles, String expectedCompilerLog, Map<String, String> customOptions, String javacAdditionalTestOptions) {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.testFiles = testFiles;
        runner.expectedCompilerLog = expectedCompilerLog;
        runner.customOptions = customOptions;
        runner.runWarningTest();
    }

    private static void verifyClassFile(String expectedOutput, String classFileName) throws IOException, ClassFormatException {
        String result = LocalStaticsTest.getClassfileContent(classFileName);
        int index = result.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(result, 3));
            System.out.println("...");
        }
        if (index == -1) {
            LocalStaticsTest.assertEquals("Wrong contents", expectedOutput, result);
        }
    }

    private static String getClassfileContent(String classFileName) throws IOException, ClassFormatException {
        File f = new File(OUTPUT_DIR + File.separator + classFileName);
        byte[] classFileBytes = Util.getFileByteContent((File)f);
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        String result = disassembler.disassemble(classFileBytes, "\n", 4);
        return result;
    }

    public void testBug566284_001() {
        this.runConformTest(new String[]{"X.java", "public class X {\n static void foo() {\n   interface F {\n     static int create(int lo) {\n       I myI = s -> lo;\n       return myI.bar(0);\n     }\n   }\n   System.out.println(F.create(0));\n     }\n public static void main(String[] args) {\n   X.foo();\n }\n}\n\ninterface I {\n int bar(int l);\n}"}, "0");
    }

    public void testBug566284_002() {
        this.runConformTest(new String[]{"X.java", "public class X {\n static void foo() {\n   record R() {\n     static int create(int lo) {\n       I myI = s -> lo;\n       return myI.bar(0);\n     }\n   }\n   System.out.println(R.create(0));\n     }\n public static void main(String[] args) {\n   X.foo();\n }\n}\n\ninterface I {\n int bar(int l);\n}"}, "0");
    }

    public void testBug566284_003() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n static int si;\n int nsi;\n\n void m() {\n   int li;\n\n   interface F {\n     static int fi = 0;\n\n     default void foo(int i) {\n       System.out.println(li); // error, local variable of method of outer enclosing class\n       System.out.println(nsi); // error, non-static member\n       System.out.println(fi); // ok, static member of current class\n       System.out.println(si); // ok, static member of enclosing class\n       System.out.println(i); // ok, local variable of current method\n     }\n\n     static void bar(int lo) {\n       int k = lo; // ok\n       int j = fi; // ok\n       I myI = s -> lo; // ok, local var of method\n     }\n\n     static void bar2(int lo) {\n       I myI = s -> li; // error - local var of outer class\n     }\n   }\n }\n}\n\ninterface I {\n int bar(int l);\n}"}, "----------\n1. ERROR in X.java (at line 12)\n\tSystem.out.println(li); // error, local variable of method of outer enclosing class\n\t                   ^^\nCannot make a static reference to the non-static variable li\n----------\n2. ERROR in X.java (at line 13)\n\tSystem.out.println(nsi); // error, non-static member\n\t                   ^^^\nCannot make a static reference to the non-static field nsi\n----------\n3. ERROR in X.java (at line 26)\n\tI myI = s -> li; // error - local var of outer class\n\t             ^^\nCannot make a static reference to the non-static variable li\n----------\n");
    }

    public void testBug566518_001() {
        this.runConformTest(new String[]{"X.java", "public class X {\n static void foo() {\n   int f = switch (5) {\n\t\t\tcase 5: {\n\t\t\t\tinterface I{\n\t\t\t\t\t\n\t\t\t\t}\n\t\t\t\tclass C implements I{\n\t\t\t\t\tpublic int j = 5;\n\t\t\t\t}\n\t\t\t\t\n\t\t\t\tyield new C().j;\n\t\t\t}\n\t\t\tdefault:\n\t\t\t\tthrow new IllegalArgumentException(\"Unexpected value: \" );\n\t\t\t};\n\tSystem.out.println(f);\n }\n public static void main(String[] args) {\n   X.foo();\n }\n}"}, "5");
    }

    public void testBug566518_002() {
        this.runConformTest(new String[]{"X.java", "public class X {\n static void foo() {\n   class F {\n     int create(int lo) {\n       I myI = s -> lo;\n       return myI.bar(0);\n     }\n   }\n   System.out.println(new F().create(0));\n     }\n public static void main(String[] args) {\n   X.foo();\n }\n}\n\ninterface I {\n int bar(int l);\n}"}, "0");
    }

    public void testBug566518_003() {
        this.runConformTest(new String[]{"X.java", "public interface X {\n static void foo() {\n   class F {\n     int create(int lo) {\n       I myI = s -> lo;\n       return myI.bar(0);\n     }\n   }\n   System.out.println(new F().create(0));\n     }\n public static void main(String[] args) {\n   X.foo();\n }\n}\n\ninterface I {\n int bar(int l);\n}"}, "0");
    }

    public void testBug566518_004() {
        this.runConformTest(new String[]{"X.java", "public interface X {\n static void foo() {\n   interface F {\n     static int create(int lo) {\n       I myI = s -> lo;\n       return myI.bar(0);\n     }\n   }\n   System.out.println(F.create(0));\n     }\n public static void main(String[] args) {\n   X.foo();\n }\n}\n\ninterface I {\n int bar(int l);\n}"}, "0");
    }

    public void testBug566518_005() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n static void foo() {\n   int f = switch (5) {\n\t\t\tcase 5: {\n\t\t\t\tinterface I{\n\t\t\t\t\t\n\t\t\t\t}\n\t\t\t\tclass C implements I{\n\t\t\t\t\tpublic int j = 5;\n\t\t\t\t}\n\t\t\t\t\n\t\t\t\tyield new C().j;\n\t\t\t}\n\t\t\tdefault:\n\t\t\t\tthrow new IllegalArgumentException(\"Unexpected value: \" );\n\t\t\t};\n\tSystem.out.println(f);\n\tclass C1 implements I{\n\t\tpublic int j = 5;\n\t}\n }\n public static void main(String[] args) {\n   X.foo();\n }\n}\n"}, "----------\n1. ERROR in X.java (at line 18)\n\tclass C1 implements I{\n\t                    ^\nI cannot be resolved to a type\n----------\n");
    }

    public void testBug566518_006() {
        this.runConformTest(new String[]{"X.java", "public enum X {\n A, B, C;\n public void foo() {\n   int f = switch (5) {\n\t\t\tcase 5: {\n\t\t\t\tinterface I{\n\t\t\t\t\t\n\t\t\t\t}\n\t\t\t\tclass C implements I{\n\t\t\t\t\tpublic int j = 5;\n\t\t\t\t}\n\t\t\t\t\n\t\t\t\tyield new C().j;\n\t\t\t}\n\t\t\tdefault:\n\t\t\t\tthrow new IllegalArgumentException(\"Unexpected value: \" );\n\t\t\t};\n }\n public static void main(String[] args) {\n   X x = X.A;\n\tSystem.out.println();\n }\n}"}, "");
    }

    public void testBug566715_001() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T> {\n static void foo() {\n\tinterface I {\n\t\tX<T> supply();\n\t}\n }\n}\n"}, "----------\n1. WARNING in X.java (at line 3)\n\tinterface I {\n\t          ^\nThe type I is never used locally\n----------\n2. ERROR in X.java (at line 4)\n\tX<T> supply();\n\t  ^\nCannot make a static reference to the non-static type T\n----------\n");
    }

    public void testBug566715_002() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T> {\n  void foo() {\n\tinterface I {\n\t\tX<T> supply();\n\t}\n }\n}\n"}, "----------\n1. WARNING in X.java (at line 3)\n\tinterface I {\n\t          ^\nThe type I is never used locally\n----------\n2. ERROR in X.java (at line 4)\n\tX<T> supply();\n\t  ^\nCannot make a static reference to the non-static type T\n----------\n");
    }

    public void testBug566715_003() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T> {\n  void foo() {\n\trecord R(X<T> x) {}\n }\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\trecord R(X<T> x) {}\n\t           ^\nCannot make a static reference to the non-static type T\n----------\n");
    }

    public void testBug566720_001() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T> {\n  void foo() {\n\tpublic interface I {}\n }\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tpublic interface I {}\n\t                 ^\nIllegal modifier for the local interface I; abstract and strictfp are the only modifiers allowed explicitly \n----------\n");
    }

    public void testBug566720_002() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T> {\n  void foo() {\n\tprivate interface I {}\n }\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tprivate interface I {}\n\t                  ^\nIllegal modifier for the local interface I; abstract and strictfp are the only modifiers allowed explicitly \n----------\n");
    }

    public void testBug566720_003() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T> {\n  void foo() {\n\tprotected interface I {}\n }\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tprotected interface I {}\n\t                    ^\nIllegal modifier for the local interface I; abstract and strictfp are the only modifiers allowed explicitly \n----------\n");
    }

    public void testBug566720_004() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T> {\n  void foo() {\n\tfinal interface I {}\n }\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tfinal interface I {}\n\t                ^\nIllegal modifier for the local interface I; abstract and strictfp are the only modifiers allowed explicitly \n----------\n");
    }

    public void testBug566720_005() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T> {\n  public static void main(String[] args) {\n\tstatic interface I {}\n }\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tstatic interface I {}\n\t                 ^\nIllegal modifier for the local interface I; abstract and strictfp are the only modifiers allowed explicitly \n----------\n");
    }

    public void testBug566748_001() {
        this.runNegativeTest(new String[]{"X.java", "class X<T> {\n        int count;\n        void doNothing() {}\n     void foo1(String s) {\n        int i;\n       interface I {\n               default X<T> bar() {\n                       if (count > 0 || i > 0 || s == null)\n                               return null;\n                       doNothing();\n                               return null;\n               }\n       } \n    }\n     void foo2(String s) {\n       try {\n               throw new Exception();\n       } catch (Exception e) {\n               interface I {\n                       default int bar() {\n                         return e != null ? 0 : 1;\n                       }\n               } \n               \n       }\n    }\n}"}, "----------\n1. WARNING in X.java (at line 6)\n\tinterface I {\n\t          ^\nThe type I is never used locally\n----------\n2. ERROR in X.java (at line 7)\n\tdefault X<T> bar() {\n\t          ^\nCannot make a static reference to the non-static type T\n----------\n3. ERROR in X.java (at line 8)\n\tif (count > 0 || i > 0 || s == null)\n\t    ^^^^^\nCannot make a static reference to the non-static field count\n----------\n4. ERROR in X.java (at line 8)\n\tif (count > 0 || i > 0 || s == null)\n\t                 ^\nCannot make a static reference to the non-static variable i\n----------\n5. ERROR in X.java (at line 8)\n\tif (count > 0 || i > 0 || s == null)\n\t                          ^\nCannot make a static reference to the non-static variable s\n----------\n6. ERROR in X.java (at line 10)\n\tdoNothing();\n\t^^^^^^^^^\nCannot make a static reference to the non-static method doNothing() from the type X<T>\n----------\n7. WARNING in X.java (at line 19)\n\tinterface I {\n\t          ^\nThe type I is never used locally\n----------\n8. ERROR in X.java (at line 21)\n\treturn e != null ? 0 : 1;\n\t       ^\nCannot make a static reference to the non-static variable e\n----------\n");
    }

    public void testBug566748_002() {
        this.runNegativeTest(new String[]{"X.java", "interface X<T> {\n int count = 0;\n\n default void doNothing() {}\n\n default void foo1(String s) {\n   int i;\n   interface I {\n     default X<T> bar() {\n       if (count > 0 || i > 0 || s == null)\n         return null;\n       doNothing();\n       return null;\n     }\n   }\n }\n\n default void foo2(String s) {\n       try {\n               throw new Exception();\n       } catch (Exception e) {\n               interface I { \n                       default int bar() {\n                         return e != null ? 0 : 1;\n                       }   \n               }   \n                   \n       }   \n    }\n}"}, "----------\n1. WARNING in X.java (at line 8)\n\tinterface I {\n\t          ^\nThe type I is never used locally\n----------\n2. ERROR in X.java (at line 9)\n\tdefault X<T> bar() {\n\t          ^\nCannot make a static reference to the non-static type T\n----------\n3. ERROR in X.java (at line 10)\n\tif (count > 0 || i > 0 || s == null)\n\t                 ^\nCannot make a static reference to the non-static variable i\n----------\n4. ERROR in X.java (at line 10)\n\tif (count > 0 || i > 0 || s == null)\n\t                          ^\nCannot make a static reference to the non-static variable s\n----------\n5. ERROR in X.java (at line 12)\n\tdoNothing();\n\t^^^^^^^^^\nCannot make a static reference to the non-static method doNothing() from the type X<T>\n----------\n6. WARNING in X.java (at line 22)\n\tinterface I { \n\t          ^\nThe type I is never used locally\n----------\n7. ERROR in X.java (at line 24)\n\treturn e != null ? 0 : 1;\n\t       ^\nCannot make a static reference to the non-static variable e\n----------\n");
    }

    public void testBug564557AnnotInterface_001() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n void foo() {\n   class I {\n     @interface Annot {\n     }\n   }\n }\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\t@interface Annot {\n\t           ^^^^^\nThe member annotation Annot can only be defined inside a top-level class or interface or in a static context\n----------\n");
    }

    public void testBug564557AnnotInterface_002() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n void foo() {\n   interface I {\n     @interface Annot {\n     }\n   }\n }\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\t@interface Annot {\n\t           ^^^^^\nThe member annotation Annot can only be defined inside a top-level class or interface or in a static context\n----------\n");
    }

    public void testBug564557MethodInvocation_003() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n void foo() {\n   Zork();\n   interface I {\n     default void bar() {}\n     default void b1() {\n       class J {\n          void jb2() {\n           bar();\n         }\n       }\n     }\n   }\n }\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tZork();\n\t^^^^\nThe method Zork() is undefined for the type X\n----------\n");
    }

    public void testBug564557MethodInvocation_004() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n void foo() {\n   interface I {\n     default void bar() {}\n     default void b1() {\n       interface J {\n          default void jb2() {\n           bar();\n         }\n       }\n     }\n   }\n }\n}"}, "----------\n1. WARNING in X.java (at line 3)\n\tinterface I {\n\t          ^\nThe type I is never used locally\n----------\n2. WARNING in X.java (at line 5)\n\tdefault void b1() {\n\t             ^^^^\nThe method b1() from the type I is never used locally\n----------\n3. WARNING in X.java (at line 6)\n\tinterface J {\n\t          ^\nThe type J is never used locally\n----------\n4. ERROR in X.java (at line 8)\n\tbar();\n\t^^^\nCannot make a static reference to the non-static method bar() from the type I\n----------\n");
    }

    public void testBug564557BinaryForm_005() throws Exception {
        this.runConformTest(new String[]{"X.java", "class X {\n public static void main(String[] args) {\n   System.out.println(\"\");\n }\n void foo() {\n   interface I {\n   }\n }\n}"}, "");
        String expectedOutput = "abstract static interface X$1I {\n";
        LocalStaticsTest.verifyClassFile(expectedOutput, "X$1I.class");
    }

    public void testBug564557BinaryForm_006() throws Exception {
        this.runConformTest(new String[]{"X.java", "class X {\n public static void main(String[] args) {\n   System.out.println(\"\");\n }\n void foo() {\n   enum I {\n   }\n }\n}"}, "");
        String expectedOutput = "static final enum X$1I {\n";
        LocalStaticsTest.verifyClassFile(expectedOutput, "X$1I.class");
    }

    public void testBug564557thisInStatic_007() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n void foo() {\n   interface I {\n     int count = 0;\n     static void bar() {\n       int i = this.count;\n     }\n   }\n }\n}"}, "----------\n1. WARNING in X.java (at line 3)\n\tinterface I {\n\t          ^\nThe type I is never used locally\n----------\n2. WARNING in X.java (at line 4)\n\tint count = 0;\n\t    ^^^^^\nThe value of the field I.count is not used\n----------\n3. ERROR in X.java (at line 6)\n\tint i = this.count;\n\t        ^^^^\nCannot use this in a static context\n----------\n");
    }

    public void testBug564557thisInStatic_008() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n int count = 0;\n void foo() {\n   interface I {\n     static void bar() {\n       int i = X.this.count;\n     }\n   }\n }\n}"}, "----------\n1. WARNING in X.java (at line 4)\n\tinterface I {\n\t          ^\nThe type I is never used locally\n----------\n2. ERROR in X.java (at line 6)\n\tint i = X.this.count;\n\t        ^^^^^^\nNo enclosing instance of the type X is accessible in scope\n----------\n");
    }

    public void testBug568514LocalEnums_001() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n    public void foo() {\n        public enum I {}\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tpublic enum I {}\n\t            ^\nIllegal modifier for local enum I; no explicit modifier is permitted\n----------\n");
    }

    public void testBug568514LocalEnums_002() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.enablePreviewFeatures", "disabled");
        this.runNegativeTest(new String[]{"X.java", "class X {\n    public void foo() {\n        public enum I {}\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tpublic enum I {}\n\t            ^\nIllegal modifier for local enum I; no explicit modifier is permitted\n----------\n", null, true, options);
    }

    public void testBug568514LocalEnums_003() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n    public void foo() {\n        public enum I {}\n    Zork;\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tZork;\n\t^^^^\nSyntax error, insert \"VariableDeclarators\" to complete LocalVariableDeclaration\n----------\n");
    }

    public void testBug568514LocalEnums_004() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n    public void foo() {\n        public strictfp enum I {}\n    Zork;\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tZork;\n\t^^^^\nSyntax error, insert \"VariableDeclarators\" to complete LocalVariableDeclaration\n----------\n");
    }

    public void testBug566579_001() {
        this.runConformTest(new String[]{"X.java", "public class X {\n private String I=null;\n public void foo() {\n   int f = switch (5) {\n\t\t\tcase 5: {\n\t\t\t\tinterface I{\n\t\t\t\t\tpublic int getVal();\n\t\t\t\t}\n\t\t\t\tclass C implements I{\n\t\t\t\t\tprivate int j=5;\n\t\t\t\t\t@Override\n\t\t\t\t\tpublic int getVal() {\n\t\t\t\t\t\treturn j;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\t\n\t\t\t\tI abc= new C();\t\t\t\tyield abc.getVal();\n\t\t\t}\n\t\t\tdefault:\n\t\t\t\tyield (I==null ? 0 : I.length());\n\t\t\t};\n }\n public static void main(String[] args) {\n   X x = new X();\n   x.I = \"abc\";\n\tSystem.out.println();\n }\n}"}, "");
    }

    public void testBug566579_002() {
        this.runConformTest(new String[]{"X.java", "public class X {\t\n\tpublic void main5(int i) {\n\t\tinterface i{\n\t\t\tpublic static int i=0;\n\t\t}\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println();\n\t}\n}"}, "");
    }

    public void testBug566579_003() {
        this.runConformTest(new String[]{"X.java", "public class X {\t\n\tpublic void main5() {\n\t\tint i=10;\n\t\tinterface i{\n\t\t\tpublic static int i=0;\n\t\t}\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println();\n\t}\n}"}, "");
    }

    public void testBug566579_004() {
        this.runConformTest(new String[]{"X.java", "public class X {\t\n\tpublic void main5() {\n\t\ttry {\n\t\t\tint i=10;\n\t\t} catch(NullPointerException npe) {\n\t\t\tinterface i{\n\t\t\t\tpublic static int npe=0;\n\t\t\t}\n\t\t}\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println();\n\t}\n}"}, "");
    }

    public void testBug569444_001() {
        this.runConformTest(new String[]{"X.java", "public class X {\n public static void main(String[] args) {\n   System.out.println(\"hello\");\n   class Y{\n     static int field;\n     public static void foo() {}\n   }\n   record R() {}\n }\n class Z {\n   static int f2;\n   static {};\n }\n}"}, "hello");
    }

    public void testBug569444_002() {
        this.runConformTest(new String[]{"X.java", "public class X {\n private void foo() {\n   class Y {\n     static record R() {}\n     static class Z{}\n     interface I{}\n     static interface II{}\n   }\n }\n public static void main(String[] args) {\n   System.out.println(\"hello\");\n }\n}"}, "hello");
    }

    public void testBug569444_003() {
        this.runConformTest(new String[]{"X.java", "public class X {\n public void foo() {\n   @SuppressWarnings(\"unused\")\n   class Y {\n     static record R() {}\n      class Z{\n       static class zz{}\n     }\n     interface I{\n       abstract int bar();\n     }\n   }\n    new Y.I() {\n     @Override\n     public int bar() {\n       return 0;\n     }\n     \n   };\n }\n public static void main(String[] args) {\n   System.out.println(\"hello\");\n }\n}"}, "hello");
    }

    public void testBug569444_004() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n public void foo() {\n    @SuppressWarnings(\"unused\")\n    static class zzz{}\n }\n public static void main(String[] args) {\n   System.out.println(\"hello\");\n }\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\tstatic class zzz{}\n\t             ^^^\nIllegal modifier for the local class zzz; only abstract or final is permitted\n----------\n");
    }

    public void testBug569444_005() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n public void foo() {\n     static class Z{} //  static not allowed\n     class Y{\n       static class ZZ{} // static allowed\n     }\n   static record R() {} // explicit static not allowed\n   static interface I {} // explicit static not allowed\n    }\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tstatic class Z{} //  static not allowed\n\t             ^\nIllegal modifier for the local class Z; only abstract or final is permitted\n----------\n2. ERROR in X.java (at line 7)\n\tstatic record R() {} // explicit static not allowed\n\t              ^\nA local class or interface R is implicitly static; cannot have explicit static declaration\n----------\n3. ERROR in X.java (at line 8)\n\tstatic interface I {} // explicit static not allowed\n\t                 ^\nIllegal modifier for the local interface I; abstract and strictfp are the only modifiers allowed explicitly \n----------\n");
    }

    public void testBug569444_006() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n public void foo() {\n   for (;;) {\n     static class Y  {}\n     static record R() {}\n     static interface I{}\n     break;\n   }\n    }\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\tstatic class Y  {}\n\t             ^\nIllegal modifier for the local class Y; only abstract or final is permitted\n----------\n2. ERROR in X.java (at line 5)\n\tstatic record R() {}\n\t              ^\nA local class or interface R is implicitly static; cannot have explicit static declaration\n----------\n3. ERROR in X.java (at line 6)\n\tstatic interface I{}\n\t                 ^\nIllegal modifier for the local interface I; abstract and strictfp are the only modifiers allowed explicitly \n----------\n");
    }

    public void testBug571163_001() {
        this.runNegativeTest(new String[]{"X.java", " class X {\n    public void foo() {\n        class Y {\n            static Y y;\n             static {\n                y = Y.this;\n            }\n            class Z {\n                static Y yy;\n                static {\n                       yy = Y.this; //error not flagged here\n                }\n            }\n        } \n     }\n}"}, "----------\n1. ERROR in X.java (at line 6)\n\ty = Y.this;\n\t    ^^^^^^\nCannot use this in a static context\n----------\n2. ERROR in X.java (at line 11)\n\tyy = Y.this; //error not flagged here\n\t     ^^^^^^\nCannot use this in a static context\n----------\n");
    }

    public void testBug571300_001() {
        this.runConformTest(new String[]{"X.java", "class X {\n  public static void main(String[] args) {\n   new X().foo();  \n }\n public void foo() {\n   interface I {\n     class Z {}\n   }\n    I.Z z = new I.Z() { // error flagged incorrectly\n     public String toString() {\n       return \"I.Z\";\n     }\n    };\n    System.out.println(z.toString());\n  }\n}"}, "I.Z");
    }

    public void testBug571274_001() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n void m() {\n   interface Y<T> {\n     class Z {\n        T foo() {// T should not be allowed\n         return null;\n       }\n     }\n   }\n }\n }"}, "----------\n1. WARNING in X.java (at line 3)\n\tinterface Y<T> {\n\t          ^\nThe type Y<T> is never used locally\n----------\n2. WARNING in X.java (at line 4)\n\tclass Z {\n\t      ^\nThe type Y<T>.Z is never used locally\n----------\n3. ERROR in X.java (at line 5)\n\tT foo() {// T should not be allowed\n\t^\nCannot make a static reference to the non-static type T\n----------\n");
    }

    public void testBug566774_001() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n static String a;\n String b;\n static String concat() {\n        return a + b;\n }\n }"}, "----------\n1. ERROR in X.java (at line 5)\n\treturn a + b;\n\t           ^\nCannot make a static reference to the non-static field b\n----------\n");
    }

    public void testBug566774_002() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n static String a;\n String b;\n int index() {\n     interface I {\n\t\tclass Matcher {\n\t\t\tvoid check() {\n\t\t\t\tif (a == null || b == null) {\n\t\t\t\t\tthrow new IllegalArgumentException();\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t   }\n\tI.Matcher matcher = new I.Matcher();\n\tmatcher.check();\n\treturn 0;\n }\n }"}, "----------\n1. ERROR in X.java (at line 8)\n\tif (a == null || b == null) {\n\t                 ^\nCannot make a static reference to the non-static field b\n----------\n");
    }

    public void testBug566774_003() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n public static void main(String[] args) {\n \tclass Checker1 {\n \t\tvoid checkWhitespace(int x) {\n     \t\tString arg = args[x];\n\t\t\tif (!arg.trim().equals(arg)) {\n\t\t\t\tthrow new IllegalArgumentException();\n\t\t\t}\n\t\t}\n\t}\n\tfinal Checker1 c1 = new Checker1();\n\tfor (int i = 1; i < args.length; i++) {\n\t\tRunnable r = () -> {\n\t\t\tc1.checkWhitespace(i);\n\t\t};\n\t}\n }\n }"}, "----------\n1. ERROR in X.java (at line 12)\n\tfor (int i = 1; i < args.length; i++) {\n\t                                 ^\nLocal variable i is required to be final or effectively final based on its usage\n----------\n");
    }

    public void testBug566774_004() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n public static void main(String[] args) {\n \tinterface I {\n \t\tclass Checker2 {\n \t\t\tvoid checkFlag(int x) {\n     \t\t\tString arg = args[x];\n\t\t\t\tif (!arg.startsWith(\"-\")) {\n\t\t\t\t\tthrow new IllegalArgumentException();\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n\tI.Checker2 c2 = new I.Checker2();\n\tfor (int i = 1; i < args.length; i++) {\n\t\tRunnable r = () -> {\n\t\t\tc2.checkFlag(i);\n\t\t};\n\t}\n }\n }"}, "----------\n1. ERROR in X.java (at line 6)\n\tString arg = args[x];\n\t             ^^^^\nCannot make a static reference to the non-static variable args\n----------\n2. ERROR in X.java (at line 14)\n\tfor (int i = 1; i < args.length; i++) {\n\t                                 ^\nLocal variable i is required to be final or effectively final based on its usage\n----------\n");
    }

    public void testBug572994_001() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\n public class Singleton {\n   private static Singleton pinstance = new Singleton();\n   public static Singleton instance() {\n     return pinstance;\n   }\n   public String message() {\n     return \"Hello world!\";\n   }\n }\n \n public static void main(String[] args) {\n   System.out.println(Singleton.instance().message());\n }\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\tprivate static Singleton pinstance = new Singleton();\n\t                                     ^^^^^^^^^^^^^^^\nNo enclosing instance of type X is accessible. Must qualify the allocation with an enclosing instance of type X (e.g. x.new A() where x is an instance of X).\n----------\n");
    }

    public void testBug572994_002() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\n public class Singleton {\n   private static Singleton pinstance = this;\n   public static Singleton instance() {\n     return pinstance;\n   }\n   public String message() {\n     return \"Hello world!\";\n   }\n }\n \n public static void main(String[] args) {\n   System.out.println(Singleton.instance().message());\n }\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\tprivate static Singleton pinstance = this;\n\t                                     ^^^^\nCannot use this in a static context\n----------\n");
    }

    public void testBug572994_003() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\n public class Singleton {\n   private static Y pinstance = new Y();\n   public static Y instance() {\n     return pinstance;\n   }\n   public String message() {\n     return \"Hello world!\";\n   }\n }\n \n public static void main(String[] args) {\n }\n class Y {}\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\tprivate static Y pinstance = new Y();\n\t                             ^^^^^^^\nNo enclosing instance of type X is accessible. Must qualify the allocation with an enclosing instance of type X (e.g. x.new A() where x is an instance of X).\n----------\n");
    }

    public void testBug574791_1() {
        this.runConformTest(new String[]{"EnumTester.java", "public class EnumTester {\n\tpublic static void main(String[] args) {\n\t\tTest e = Test.ONE;\n\t\tSystem.out.println(e.value());\n\t\tSystem.out.println(MyTest.TWO.value());\n\t\tI TWO = new I() {\n\t\t\tprivate static final String value = getString();\n\t\t\t@Override\n\t\t\tpublic String value() {\n\t\t\t\treturn value;\n\t\t\t}\n\t\t};\n\t\tSystem.out.println(TWO.value());\n\t}\n\tprivate static String getString() {\n\t\treturn \"Hi from EnumTester\";\n\t}\n\tclass MyTest {\n\t\tpublic static final String value = getString();\n\t\tprivate static String getString() {\n\t\t\treturn \"Hi from MyTest\";\n\t\t}\n\t\tpublic static I TWO = new I() {\n\t\t\tprivate static final String value = getString();\n\t\t\t@Override\n\t\t\tpublic String value() {\n\t\t\t\treturn value;\n\t\t\t}\n\t\t};\n\t}\n\tinterface I {\n\t\tpublic String value();\n\t}\n}\nenum Test {\n\tONE {\n\t\tprivate static final String value = getString();\n\t\t@Override\n\t\tString value() {\n\t\t\treturn value;\n\t\t}\n\t};\n\tabstract String value();\n\tprivate static String getString() {\n\t\treturn \"Hi from Test\";\n\t}\n}"}, "Hi from Test\nHi from MyTest\nHi from EnumTester");
    }

    public void testBug574791_2() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n }\n}\nenum Test {\n\tONE {\n\t\tprivate static final String value = getString();\n\t\t@Override\n\t\tString value() {\n\t\t\treturn value;\n\t\t}\n\t},\n\tTWO {\n\t\tString value() {\n\t\t\treturn \"TWO\";\n\t\t}\n\t},\n\t;\n\tabstract String value();\n\tprivate static String getString() {\n\t\treturn \"default\";\n\t}\n}"}, "");
        String expectedOutput = "  // Method descriptor #17 ()V\n  // Stack: 1, Locals: 0\n  static {};\n    0  invokestatic Test.getString() : java.lang.String [18]\n    3  putstatic Test$1.value : java.lang.String [22]\n    6  return";
        String content = LocalStaticsTest.getClassfileContent("Test$1.class");
        LocalStaticsTest.assertTrue((String)"Expected code not found", (content.indexOf(expectedOutput) != -1 ? 1 : 0) != 0);
        expectedOutput = "  static {};";
        content = LocalStaticsTest.getClassfileContent("Test$2.class");
        LocalStaticsTest.assertTrue((String)"Unexpected code found", (content.indexOf(expectedOutput) == -1 ? 1 : 0) != 0);
    }

    public void testBug574791_3() {
        this.runConformTest(new String[]{"EnumTester.java", "public class EnumTester {\n\tpublic static void main(String[] args) {\n\t\tTest e = Test.ONE;\n\t\tSystem.out.println(e.value());\n\t\tSystem.out.println(MyTest.TWO.value());\n\t\tI TWO = new I() {\n\t\t\tprivate static final String value = getString();\n\t\t\t@Override\n\t\t\tpublic String value() {\n\t\t\t\treturn value;\n\t\t\t}\n\t\t};\n\t\tSystem.out.println(TWO.value());\n\t}\n\tprivate static String getString() {\n\t\treturn \"Hi from EnumTester\";\n\t}\n\tclass MyTest {\n\t\tpublic static String value;\n     static {\n       value = getString();\n     }\n\t\tprivate static String getString() {\n\t\t\treturn \"Hi from MyTest\";\n\t\t}\n\t\tpublic static I TWO = new I() {\n\t\t\tprivate static final String value = getString();\n\t\t\t@Override\n\t\t\tpublic String value() {\n\t\t\t\treturn value;\n\t\t\t}\n\t\t};\n\t}\n\tinterface I {\n\t\tpublic String value();\n\t}\n}\nenum Test {\n\tONE {\n\t\tpublic static String value;\n     static {\n       value = getString();\n     }\n\t\t@Override\n\t\tString value() {\n\t\t\treturn value;\n\t\t}\n\t};\n\tabstract String value();\n\tprivate static String getString() {\n\t\treturn \"Hi from Test\";\n\t}\n}"}, "Hi from Test\nHi from MyTest\nHi from EnumTester");
    }
}

