/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;

public class LocalVariableTest
extends AbstractRegressionTest {
    public LocalVariableTest(String name) {
        super(name);
    }

    public static Test suite() {
        return LocalVariableTest.buildAllCompliancesTestSuite(LocalVariableTest.testClass());
    }

    public void test001() {
        this.runConformTest(new String[]{"p/X.java", "package p;\npublic class X {\n        int foo(){\n                int i;\n                return 1;\n        }\n}\n"});
    }

    public void test002() {
        this.runConformTest(new String[]{"p/X.java", "package p;\npublic class X {\n  void foo() {\n    String temp;\n    try {\n      return;\n    }\n    catch (Exception e){\n    }\n  }\n}\n"});
    }

    public void test003() {
        this.runConformTest(new String[]{"p/X.java", "package p;\npublic class X {\n  void foo() {\n    String temp;\n    try {\n      return;\n    }\n    catch (Exception e) {\n    }\n  }\n}\n"});
    }

    public void test004() {
        this.runConformTest(new String[]{"p/X.java", "package p;\npublic class X {\n  {\n     int i = 1;\n    System.out.println(i);\n  }\n  X(int j){\n  }\n}\n"});
    }

    public void test005() {
        this.runConformTest(new String[]{"p/X.java", "package p;\npublic class X {\n  int j;\n  void f1() {\n    int l;\n    switch (j) {\n      case 0 :\n        l = 10;\n\t\t l++;\n        break;\n      case 1 :\n        l = 20;\n        break;\n      case 2 :\n        l = 30;\n        break;\n      default :\n        l = 10;\n        break;\n    }\n  }\n  public static void main(String args[]) {\n  }\n}\n"});
    }

    public void test006() {
        this.runConformTest(new String[]{"p/Truc.java", "package p;\npublic class Truc{\n   void foo(){\n      final int i; \n\t   i = 1;\n      if (false) i = 2;\n   } \n\tpublic static void main(java.lang.String[] args) {\n  \t\tSystem.out.println(\"SUCCESS\"); \n\t}\t\n}"}, "SUCCESS");
    }

    public void test007() {
        this.runConformTest(new String[]{"p/A.java", "package p;\nimport p.helper.Y;\nclass A extends Y {\n  class Y {\n    int j = i;// i is a protected member inherited from Y\n  }\n}", "p/helper/Y.java", "package p.helper;\npublic class Y {\n  protected int i = 10;\n  public inner in = new inner();\n    \n  protected class inner {\n    public int  f() {\n      return 20;\n    }\n  }\n}"});
    }

    public void test008() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n\tclass Y {\n\t\tY innerY;\n\n\t\tint longMemberName;\n\t}\n\n\tstatic public void main(String args[]) {\n\t\tY y;\n\t\tSystem.out.println(y.innerY.longMemberName);\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 10)\n\tSystem.out.println(y.innerY.longMemberName);\n\t                   ^\nThe local variable y may not have been initialized\n----------\n");
    }

    public void test009() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n\tclass Y {\n\t\tint longMemberName;\n\t}\n\n\tstatic public void main(String args[]) {\n\t\tY y;\n\t\tSystem.out.println(y.longMemberName);\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 8)\n\tSystem.out.println(y.longMemberName);\n\t                   ^\nThe local variable y may not have been initialized\n----------\n");
    }

    public void test010() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.doc.comment.support", "enabled");
        this.runConformTest(new String[]{"p/X.java", "package p;\n/**\n * @see Y\n */\npublic class X {\n}", "p/Y.java", "package p;\nclass Z {\n}"}, "", null, true, null, options, null);
    }

    public void test011() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n        public static void main(String[] args) {\n                int x = 2;\n                if (true) {\n                        int x = 4;\n                }\n        }\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tint x = 4;\n\t    ^\nDuplicate local variable x\n----------\n");
    }

    public void test012() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n        public static void main(String[] args) {\n                int x = x = 0;\n                if (true) {\n                        int x = x = 1;\n                }\n        }\n}\n"}, "----------\n1. WARNING in X.java (at line 3)\n\tint x = x = 0;\n\t    ^^^^^^^^^\nThe assignment to variable x has no effect\n----------\n2. ERROR in X.java (at line 5)\n\tint x = x = 1;\n\t    ^\nDuplicate local variable x\n----------\n3. WARNING in X.java (at line 5)\n\tint x = x = 1;\n\t    ^^^^^^^^^\nThe assignment to variable x has no effect\n----------\n");
    }

    public void test013() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n        public static void main(String[] args) {\n                int x = 2;\n                try {\n                \t\n                } catch(Exception x) {\n                } catch(Exception e) {\n                }\n        }\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\t} catch(Exception x) {\n\t                  ^\nDuplicate parameter x\n----------\n2. ERROR in X.java (at line 7)\n\t} catch(Exception e) {\n\t        ^^^^^^^^^\nUnreachable catch block for Exception. It is already handled by the catch block for Exception\n----------\n");
    }

    public void test014() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo(){\n\t\tint x = 0;\n\t\tString x = \"\";\n\t\tx.toString();\n\t  }\n\t}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tString x = \"\";\n\t       ^\nDuplicate local variable x\n----------\n");
    }

    public void test015() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", "optimize out");
        this.runConformTest(new String[]{"X.java", "public class X {\n        public static boolean test() {\n                boolean b = false;\n                assert b = true;\n                return false;\n        }\n        public static void main(String[] args) {\n                test();\n                System.out.println(\"SUCCESS\");\n        }\n}\n"}, "SUCCESS", null, true, null, options, null);
    }

    public void test016() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.doc.comment.support", "enabled");
        options.put("org.eclipse.jdt.core.compiler.problem.unusedParameter", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.unusedParameterIncludeDocCommentReference", "enabled");
        options.put("org.eclipse.jdt.core.compiler.problem.unusedParameterWhenOverridingConcrete", "disabled");
        options.put("org.eclipse.jdt.core.compiler.problem.unusedParameterWhenImplementingAbstract", "disabled");
        this.runNegativeTest(true, new String[]{"X.java", "public class X extends Parent implements Doable {\n\t/**\n\t * @param value\n\t */\n\tvoid foo(int value) { // X#foo(...)\n\t}\n\tvoid bar(int value) { // X#bar(...)\n\t}\n\n\tvoid top(int value) { /* X#top(...)*/}\n\tvoid parent(int value) { /* X#parent(...) */}\n\tpublic void doit(int value) { /* X#doit(...) */}\n}\nabstract class Top {\n\t/**\n\t * @param value\n\t */\n\tabstract void top(int value); // Top#top(...)\n}\nabstract class Parent extends Top {\n\t/**\n\t * @param value\n\t */\n\tvoid parent(int value) { /* Parent#parent(...) */}\n}\ninterface Doable {\n\t/**\n\t * @param value\n\t */\n\tvoid doit (int value); // Doable#doit(...)\n}"}, null, options, "----------\n1. ERROR in X.java (at line 7)\n\tvoid bar(int value) { // X#bar(...)\n\t             ^^^^^\nThe value of the parameter value is not used\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test017() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.doc.comment.support", "disabled");
        options.put("org.eclipse.jdt.core.compiler.problem.unusedParameter", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.unusedParameterIncludeDocCommentReference", "enabled");
        options.put("org.eclipse.jdt.core.compiler.problem.unusedParameterWhenOverridingConcrete", "disabled");
        options.put("org.eclipse.jdt.core.compiler.problem.unusedParameterWhenImplementingAbstract", "disabled");
        this.runNegativeTest(true, new String[]{"X.java", "public class X extends Parent implements Doable {\n\t/**\n\t * @param value\n\t */\n\tvoid foo(int value) { // X#foo(...)\n\t}\n\tvoid bar(int value) { // X#bar(...)\n\t}\n\n\tvoid top(int value) { /* X#top(...)*/}\n\tvoid parent(int value) { /* X#parent(...) */}\n\tpublic void doit(int value) { /* X#doit(...) */}\n}\nabstract class Top {\n\t/**\n\t * @param value\n\t */\n\tabstract void top(int value); // Top#top(...)\n}\nabstract class Parent extends Top {\n\t/**\n\t * @param value\n\t */\n\tvoid parent(int value) { /* Parent#parent(...) */}\n}\ninterface Doable {\n\t/**\n\t * @param value\n\t */\n\tvoid doit (int value); // Doable#doit(...)\n}"}, null, options, "----------\n1. ERROR in X.java (at line 5)\n\tvoid foo(int value) { // X#foo(...)\n\t             ^^^^^\nThe value of the parameter value is not used\n----------\n2. ERROR in X.java (at line 7)\n\tvoid bar(int value) { // X#bar(...)\n\t             ^^^^^\nThe value of the parameter value is not used\n----------\n3. ERROR in X.java (at line 24)\n\tvoid parent(int value) { /* Parent#parent(...) */}\n\t                ^^^^^\nThe value of the parameter value is not used\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test018() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.doc.comment.support", "enabled");
        options.put("org.eclipse.jdt.core.compiler.problem.unusedParameter", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.unusedParameterIncludeDocCommentReference", "disabled");
        options.put("org.eclipse.jdt.core.compiler.problem.unusedParameterWhenOverridingConcrete", "disabled");
        options.put("org.eclipse.jdt.core.compiler.problem.unusedParameterWhenImplementingAbstract", "disabled");
        this.runNegativeTest(true, new String[]{"X.java", "public class X extends Parent implements Doable {\n\t/**\n\t * @param value\n\t */\n\tvoid foo(int value) { // X#foo(...)\n\t}\n\tvoid bar(int value) { // X#bar(...)\n\t}\n\n\tvoid top(int value) { /* X#top(...)*/}\n\tvoid parent(int value) { /* X#parent(...) */}\n\tpublic void doit(int value) { /* X#doit(...) */}\n}\nabstract class Top {\n\t/**\n\t * @param value\n\t */\n\tabstract void top(int value); // Top#top(...)\n}\nabstract class Parent extends Top {\n\t/**\n\t * @param value\n\t */\n\tvoid parent(int value) { /* Parent#parent(...) */}\n}\ninterface Doable {\n\t/**\n\t * @param value\n\t */\n\tvoid doit (int value); // Doable#doit(...)\n}"}, null, options, "----------\n1. ERROR in X.java (at line 5)\n\tvoid foo(int value) { // X#foo(...)\n\t             ^^^^^\nThe value of the parameter value is not used\n----------\n2. ERROR in X.java (at line 7)\n\tvoid bar(int value) { // X#bar(...)\n\t             ^^^^^\nThe value of the parameter value is not used\n----------\n3. ERROR in X.java (at line 24)\n\tvoid parent(int value) { /* Parent#parent(...) */}\n\t                ^^^^^\nThe value of the parameter value is not used\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test019() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.doc.comment.support", "enabled");
        options.put("org.eclipse.jdt.core.compiler.problem.unusedParameter", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.unusedParameterIncludeDocCommentReference", "disabled");
        options.put("org.eclipse.jdt.core.compiler.problem.unusedParameterWhenOverridingConcrete", "enabled");
        options.put("org.eclipse.jdt.core.compiler.problem.unusedParameterWhenImplementingAbstract", "enabled");
        this.runNegativeTest(true, new String[]{"X.java", "public class X extends Parent implements Doable {\n\t/**\n\t * @param value\n\t */\n\tvoid foo(int value) { // X#foo(...)\n\t}\n\tvoid bar(int value) { // X#bar(...)\n\t}\n\n\tvoid top(int value) { /* X#top(...)*/}\n\tvoid parent(int value) { /* X#parent(...) */}\n\tpublic void doit(int value) { /* X#doit(...) */}\n}\nabstract class Top {\n\t/**\n\t * @param value\n\t */\n\tabstract void top(int value); // Top#top(...)\n}\nabstract class Parent extends Top {\n\t/**\n\t * @param value\n\t */\n\tvoid parent(int value) { /* Parent#parent(...) */}\n}\ninterface Doable {\n\t/**\n\t * @param value\n\t */\n\tvoid doit (int value); // Doable#doit(...)\n}"}, null, options, "----------\n1. ERROR in X.java (at line 5)\n\tvoid foo(int value) { // X#foo(...)\n\t             ^^^^^\nThe value of the parameter value is not used\n----------\n2. ERROR in X.java (at line 7)\n\tvoid bar(int value) { // X#bar(...)\n\t             ^^^^^\nThe value of the parameter value is not used\n----------\n3. ERROR in X.java (at line 10)\n\tvoid top(int value) { /* X#top(...)*/}\n\t             ^^^^^\nThe value of the parameter value is not used\n----------\n4. ERROR in X.java (at line 11)\n\tvoid parent(int value) { /* X#parent(...) */}\n\t                ^^^^^\nThe value of the parameter value is not used\n----------\n5. ERROR in X.java (at line 12)\n\tpublic void doit(int value) { /* X#doit(...) */}\n\t                     ^^^^^\nThe value of the parameter value is not used\n----------\n6. ERROR in X.java (at line 24)\n\tvoid parent(int value) { /* Parent#parent(...) */}\n\t                ^^^^^\nThe value of the parameter value is not used\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test020() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.doc.comment.support", "enabled");
        options.put("org.eclipse.jdt.core.compiler.problem.unusedParameter", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.unusedParameterIncludeDocCommentReference", "disabled");
        options.put("org.eclipse.jdt.core.compiler.problem.unusedParameterWhenOverridingConcrete", "enabled");
        options.put("org.eclipse.jdt.core.compiler.problem.unusedParameterWhenImplementingAbstract", "enabled");
        this.runNegativeTest(true, new String[]{"X.java", "public class X extends Parent implements Doable {\n\t/** @param value */\n\tvoid foo(int value) { // X#foo(...)\n\t}\n\tvoid bar(int value) { // X#bar(...)\n\t}\n\n\t/** @param value */\n\tvoid top(int value) { /* X#top(...)*/}\n\t/** @param value */\n\tvoid parent(int value) { /* X#parent(...) */}\n\t/** @param value */\n\tpublic void doit(int value) { /* X#doit(...) */}\n}\nabstract class Top {\n\t/** @param value */\n\tabstract void top(int value); // Top#top(...)\n}\nabstract class Parent extends Top {\n\t/** @param value */\n\tvoid parent(int value) { /* Parent#parent(...) */}\n}\ninterface Doable {\n\t/** @param value */\n\tvoid doit (int value); // Doable#doit(...)\n}"}, null, options, "----------\n1. ERROR in X.java (at line 3)\n\tvoid foo(int value) { // X#foo(...)\n\t             ^^^^^\nThe value of the parameter value is not used\n----------\n2. ERROR in X.java (at line 5)\n\tvoid bar(int value) { // X#bar(...)\n\t             ^^^^^\nThe value of the parameter value is not used\n----------\n3. ERROR in X.java (at line 9)\n\tvoid top(int value) { /* X#top(...)*/}\n\t             ^^^^^\nThe value of the parameter value is not used\n----------\n4. ERROR in X.java (at line 11)\n\tvoid parent(int value) { /* X#parent(...) */}\n\t                ^^^^^\nThe value of the parameter value is not used\n----------\n5. ERROR in X.java (at line 13)\n\tpublic void doit(int value) { /* X#doit(...) */}\n\t                     ^^^^^\nThe value of the parameter value is not used\n----------\n6. ERROR in X.java (at line 21)\n\tvoid parent(int value) { /* Parent#parent(...) */}\n\t                ^^^^^\nThe value of the parameter value is not used\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test412119a() {
        this.runConformTest(new String[]{"p/X.java", "package p;\nclass X {\n\t\n\tvoid somethingDangerous() {}\n\tvoid foo() {\n\t\ttry {\n\t\t\tsomethingDangerous();\n\t\t} catch(Exception e) {\n\t\t\tthrow new RuntimeException();\n\t\t}\n\t}\n}\n"});
    }

    public void test412119b() {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.customOptions = this.getCompilerOptions();
        runner.customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedExceptionParameter", "error");
        runner.testFiles = new String[]{"p/X.java", "package p;\nclass X {\n\tvoid somethingDangerous() {}\n\tvoid foo() {\n\t\ttry {\n\t\t\tsomethingDangerous();\n\t\t} catch(Exception e) {\n\t\t\t\tthrow new RuntimeException();\n\t\t}\n\t\ttry {\n\t\t\tsomethingDangerous();\n\t\t} catch(Exception e1) {\n\t\t\t\tif (true)\n\t\t\t\t\tthrow new RuntimeException(e1);\n\t\t}\n\t\ttry {\n\t\t\tsomethingDangerous();\n\t\t} catch(Exception e2) {\n\t\t\tthrow new RuntimeException(e2);\n\t\t}\n    }\n}\n"};
        runner.expectedCompilerLog = "----------\n1. ERROR in p\\X.java (at line 7)\n\t} catch(Exception e) {\n\t                  ^\nThe value of the exception parameter e is not used\n----------\n";
        runner.javacTestOptions = AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError;
        runner.runNegativeTest();
    }

    public void test412119c() {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.customOptions = this.getCompilerOptions();
        runner.customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedExceptionParameter", "error");
        runner.testFiles = new String[]{"p/X.java", "package p;\nclass X {\nclass Z2 extends Exception {\n\tprivate static final long serialVersionUID = 1L;}\nclass Z1 extends Exception {\n\tprivate static final long serialVersionUID = 1L;}\n\tvoid somethingDangerous(int x, int y) throws Z1, Z2 {\n\t\tif (x < 1)\n\t\t\tthrow new Z1();\n\t\tif (y > 1) \n\t\t\tthrow new Z2();\n\t}\n\tvoid foo(int x, int y) {\n\t\ttry {\n\t\t\tsomethingDangerous(x, y);\n\t\t} catch(Z2|Z1 z) {\n\t\t\tthrow new RuntimeException();\n\t\t}\n\t\ttry {\n\t\t\tsomethingDangerous(x, y);\n\t\t} catch(Z2|Z1 z2) {\n\t\t\tthrow new RuntimeException(z2);\n\t\t}\n\t}\n}\n"};
        runner.expectedCompilerLog = "----------\n1. ERROR in p\\X.java (at line 16)\n\t} catch(Z2|Z1 z) {\n\t              ^\nThe value of the exception parameter z is not used\n----------\n";
        runner.javacTestOptions = AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError;
        runner.runNegativeTest();
    }

    public void test412119d() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unusedParameter", "warning");
        options.put("org.eclipse.jdt.core.compiler.problem.unusedExceptionParameter", "warning");
        this.runNegativeTest(new String[]{"p/X.java", "package p;\nclass X {\n\t@SuppressWarnings(\"unused\")\n\tvoid foo(int x) {}\n\tvoid somethingDangerous() {}\n\t@SuppressWarnings(\"unused\")\n\tvoid foo3() {\n\t\ttry {\n\t\t\tsomethingDangerous();\n\t\t} catch(Exception e) {\n\t\t\tthrow new RuntimeException();\n\t\t}\n\t}\n}\n"}, "", null, true, options);
    }

    public void testBug537033() {
        this.runNegativeTest(new String[]{"ShowBug.java", "import java.util.concurrent.Callable;\n\npublic class ShowBug {\n    private static abstract class X {\n        abstract void x(int val);\n    }\n\n    public ShowBug() {\n        final X x = new X() {\n            void x(int val) {\n                if (val > 0) {\n                    // (1) The local variable x may not have been initialized\n                    x.x(val - 1);\n                }\n            }\n        };\n\n        new Callable<Void>() {\n            public Void call() {\n                // (2) Missing code implementation in the compiler\n                x.x(10);          \n                return null;\n            }\n        }.call();\n    }\n}\n"}, this.complianceLevel < 0x370000L ? "----------\n1. WARNING in ShowBug.java (at line 9)\n\tfinal X x = new X() {\n\t                ^^^\nAccess to enclosing constructor ShowBug.X() is emulated by a synthetic accessor method\n----------\n2. ERROR in ShowBug.java (at line 13)\n\tx.x(val - 1);\n\t^\nThe local variable x may not have been initialized\n----------\n" : "----------\n1. ERROR in ShowBug.java (at line 13)\n\tx.x(val - 1);\n\t^\nThe local variable x may not have been initialized\n----------\n");
    }

    public static Class testClass() {
        return LocalVariableTest.class;
    }
}

