/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;
import org.eclipse.jdt.core.tests.compiler.regression.JavadocTest;

public class MarkdownCommentsTest
extends JavadocTest {
    private static final AbstractRegressionTest.JavacTestOptions JAVAC_TEST_OPTIONS = new AbstractRegressionTest.JavacTestOptions(" -source 23 -Xdoclint");
    private static final String[] VMARGS = new String[0];
    String docCommentSupport;
    String reportInvalidJavadoc;
    String reportMissingJavadocDescription;
    String reportInvalidJavadocVisibility;
    String reportMissingJavadocTags;
    String reportMissingJavadocComments;
    String reportMissingJavadocCommentsVisibility;
    String reportDeprecation;
    String processAnnotations = null;
    String reportJavadocDeprecation = null;

    public MarkdownCommentsTest(String name) {
        super(name);
    }

    public static Test suite() {
        return MarkdownCommentsTest.buildMinimalComplianceTestSuite(MarkdownCommentsTest.class, 0x100000);
    }

    @Override
    protected Map getCompilerOptions() {
        Map options = super.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.doc.comment.support", this.docCommentSupport);
        options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadoc", this.reportInvalidJavadoc);
        options.put("org.eclipse.jdt.core.compiler.problem.unusedImport", "error");
        if (!"ignore".equals(this.reportInvalidJavadoc)) {
            options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadocTagsVisibility", this.reportInvalidJavadocVisibility);
        }
        if (this.reportJavadocDeprecation != null) {
            options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadocTagsDeprecatedRef", this.reportJavadocDeprecation);
        }
        if (this.reportMissingJavadocComments != null) {
            options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocComments", this.reportMissingJavadocComments);
            options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocCommentsOverriding", "enabled");
            if (this.reportMissingJavadocCommentsVisibility != null) {
                options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocCommentsVisibility", this.reportMissingJavadocCommentsVisibility);
            }
        } else {
            options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocComments", this.reportInvalidJavadoc);
        }
        if (this.reportMissingJavadocTags != null) {
            options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocTags", this.reportMissingJavadocTags);
            options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocTagsOverriding", "enabled");
        } else {
            options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocTags", this.reportInvalidJavadoc);
        }
        if (this.reportMissingJavadocDescription != null) {
            options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocTagDescription", this.reportMissingJavadocDescription);
        }
        if (this.processAnnotations != null) {
            options.put("org.eclipse.jdt.core.compiler.processAnnotations", this.processAnnotations);
        }
        options.put("org.eclipse.jdt.core.compiler.problem.fieldHiding", "ignore");
        options.put("org.eclipse.jdt.core.compiler.problem.syntheticAccessEmulation", "ignore");
        options.put("org.eclipse.jdt.core.compiler.problem.deprecation", this.reportDeprecation);
        options.put("org.eclipse.jdt.core.compiler.problem.unusedImport", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.rawTypeReference", "ignore");
        options.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "ignore");
        return options;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.docCommentSupport = "enabled";
        this.reportInvalidJavadoc = "error";
        this.reportInvalidJavadocVisibility = "private";
        this.reportMissingJavadocTags = "ignore";
        this.reportMissingJavadocComments = "ignore";
        this.reportMissingJavadocCommentsVisibility = "public";
        this.reportDeprecation = "error";
        this.reportMissingJavadocDescription = "all_standard_tags";
    }

    @Override
    protected void runConformTest(String[] testFiles, String expectedOutput) {
        this.runConformTest(testFiles, expectedOutput, (Map<String, String>)this.getCompilerOptions(), VMARGS, JAVAC_TEST_OPTIONS);
    }

    @Override
    protected void runNegativeTest(String[] testFiles, String expectedErrors) {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.testFiles = testFiles;
        runner.expectedCompilerLog = expectedErrors;
        runner.customOptions = this.getCompilerOptions();
        runner.vmArguments = VMARGS;
        runner.javacTestOptions = JAVAC_TEST_OPTIONS;
        runner.runNegativeTest();
    }

    void runWarningTest(String[] testFiles, String expectedWarnings) {
        this.reportInvalidJavadoc = "warning";
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.testFiles = testFiles;
        runner.expectedCompilerLog = expectedWarnings;
        runner.vmArguments = VMARGS;
        runner.javacTestOptions = JAVAC_TEST_OPTIONS;
        runner.runWarningTest();
    }

    public void test001() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t///\n\t/// @param parameters array of String\n\t///\n\tpublic int sample(String[] params) {\n\t\treturn 42;\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\t/// @param parameters array of String\n\t           ^^^^^^^^^^\nJavadoc: Parameter parameters is not declared\n----------\n");
    }

    public void test002() {
        this.runWarningTest(new String[]{"X.java", "public class X {\n\t///\n\t/// @param params\n\t///\n\tpublic int sample(String[] params) {\n\t\treturn 42;\n\t}\n\tpublic static void main(String... args) {}\n}\n"}, "----------\n1. WARNING in X.java (at line 3)\n\t/// @param params\n\t           ^^^^^^\nJavadoc: Description expected after this reference\n----------\n");
    }

    public void test003() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\t///\n\t/// @param params array of String\n\t///\n\tpublic int sample(String[] params) {\n\t\treturn 42;\n\t}\n\tpublic static void main(String... args) {}\n}\n"}, "");
    }

    public void test004() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t///\n\t/// @see #method()\n\t///\n\tpublic void sample() {\n\t\treturn;\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\t/// @see #method()\n\t          ^^^^^^\nJavadoc: The method method() is undefined for the type X\n----------\n");
    }

    public void test005() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\t///\n\t/// @see #method()\n\t///\n\tpublic void sample() {\n\t\treturn;\n\t}\n\tprotected void method() {}\n\tpublic static void main(String... args) {}\n}\n"}, "");
    }

    public void test006() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\t/// @see #method()\n\tpublic static void main(String[] arguments) {\n\t\tSystem.out.println(\"Hello\");\n\t}\n\tprotected static void method() {}\n}\n"}, "Hello");
    }

    public void test007() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t///\n\t/// @see #method()\n\tpublic static void main(String[] arguments) {\n\t\tSystem.out.println(\"Hello\");\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\t/// @see #method()\n\t          ^^^^^^\nJavadoc: The method method() is undefined for the type X\n----------\n");
    }

    public void test008() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t/// @see #method()\n\t///\n\tpublic static void main(String[] arguments) {\n\t\tSystem.out.println(\"Hello\");\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\t/// @see #method()\n\t          ^^^^^^\nJavadoc: The method method() is undefined for the type X\n----------\n");
    }

    public void test009() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t//// @see #method()\n\t////\n\tpublic static void main(String[] arguments) {\n\t\tSystem.out.println(\"Hello\");\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\t//// @see #method()\n\t           ^^^^^^\nJavadoc: The method method() is undefined for the type X\n----------\n");
    }

    public void test010() {
        String bkup = this.reportMissingJavadocTags;
        try {
            this.reportMissingJavadocTags = "error";
            this.runNegativeTest(new String[]{"X.java", "public class X {\n\t/// Some text here without the necessary tags for main method\n\t/// @param arguments array of strings\n\t/// @return java.lang.Str -- should not raise an error\n\n\t/// no tags here\n\tpublic static void main(String[] arguments) {\n\t\tSystem.out.println(\"Hello\");\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tpublic static void main(String[] arguments) {\n\t                                 ^^^^^^^^^\nJavadoc: Missing tag for parameter arguments\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
        }
        finally {
            this.reportMissingJavadocTags = bkup;
        }
    }

    public void test011() {
        String bkup = this.reportMissingJavadocTags;
        try {
            this.reportMissingJavadocTags = "error";
            this.runNegativeTest(new String[]{"X.java", "public class X {\n\t/// Some text here without the necessary tags for main method\n\t/// @param arguments array of strings\n\t/// @return java.lang.Str\n\n\t// This line will be ignored and the previous block will be considered as the Javadoc\n\tpublic static void main(String[] arguments) {\n\t\tSystem.out.println(\"Hello\");\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\t/// @return java.lang.Str\n\t     ^^^^^^\nJavadoc: Unexpected tag\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
        }
        finally {
            this.reportMissingJavadocTags = bkup;
        }
    }

    public void test012() {
        String bkup = this.reportMissingJavadocTags;
        try {
            this.reportJavadocDeprecation = "error";
            this.runWarningTest(new String[]{"X.java", "public class X {\n\t/// Some text here without the necessary tags for main method\n\t/// @param arguments \n\n\t// This line will be ignored and the previous block will be considered as the Javadoc\n\tpublic static void main(String[] arguments) {\n\t\tSystem.out.println(\"Hello\");\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 3)\n\t/// @param arguments \n\t           ^^^^^^^^^\nJavadoc: Description expected after this reference\n----------\n");
        }
        finally {
            this.reportMissingJavadocTags = bkup;
        }
    }

    public void test013() {
        String bkup = this.reportMissingJavadocTags;
        try {
            this.reportMissingJavadocTags = "error";
            this.runNegativeTest(new String[]{"X.java", "public class X {\n\t/// Some text here without the necessary tags for main method\n\t/// @param arguments array of strings\n\n\t/**\n\t * This will be the effective javadoc and will be reported for missing tags\n\t */\n\tpublic static void main(String[] arguments) {\n\t\tSystem.out.println(\"Hello\");\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\tpublic static void main(String[] arguments) {\n\t                                 ^^^^^^^^^\nJavadoc: Missing tag for parameter arguments\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
        }
        finally {
            this.reportMissingJavadocTags = bkup;
        }
    }

    public void test014() {
        String bkup = this.reportMissingJavadocTags;
        try {
            this.reportMissingJavadocTags = "error";
            this.runNegativeTest(new String[]{"X.java", "public class X {\n\t/**\n\t * Some text here without the necessary tags for main method\n\t * @param arguments\n\t */\n\n\t///\n\t/// This will be the effective javadoc and will be reported for missing tags\n\t///\n\tpublic static void main(String[] arguments) {\n\t\tSystem.out.println(\"Hello\");\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 10)\n\tpublic static void main(String[] arguments) {\n\t                                 ^^^^^^^^^\nJavadoc: Missing tag for parameter arguments\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
        }
        finally {
            this.reportMissingJavadocTags = bkup;
        }
    }

    public void test015() {
        String bkup = this.reportMissingJavadocTags;
        try {
            this.reportMissingJavadocTags = "ignore";
            this.runNegativeTest(new String[]{"X.java", "public class X {\n\t///\n\t/// Reference to an invalid type [Strings]\n\t///\n\tpublic static void main() {\n\t\tSystem.out.println(\"Hello\");\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\t/// Reference to an invalid type [Strings]\n\t                                  ^^^^^^^\nJavadoc: Strings cannot be resolved to a type\n----------\n");
        }
        finally {
            this.reportMissingJavadocTags = bkup;
        }
    }

    public void test016() {
        String bkup = this.reportMissingJavadocTags;
        try {
            this.reportMissingJavadocTags = "ignore";
            this.runNegativeTest(new String[]{"X.java", "public class X {\n\t///\n\t/// Reference to an invalid type [java.langs.Strings]\n\t///\n\tpublic static void main() {\n\t\tSystem.out.println(\"Hello\");\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\t/// Reference to an invalid type [java.langs.Strings]\n\t                                  ^^^^^^^^^^^^^^^^^^\nJavadoc: java.langs cannot be resolved to a type\n----------\n");
        }
        finally {
            this.reportMissingJavadocTags = bkup;
        }
    }

    public void test017() {
        String bkup = this.reportMissingJavadocTags;
        try {
            this.reportMissingJavadocTags = "ignore";
            this.runNegativeTest(new String[]{"X.java", "public class X {\n\t///\n\t/// Reference to an invalid type [Strings] [java.langs.Strings]\n\t///\n\tpublic static void main() {\n\t\tSystem.out.println(\"Hello\");\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\t/// Reference to an invalid type [Strings] [java.langs.Strings]\n\t                                  ^^^^^^^\nJavadoc: Strings cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 3)\n\t/// Reference to an invalid type [Strings] [java.langs.Strings]\n\t                                            ^^^^^^^^^^^^^^^^^^\nJavadoc: java.langs cannot be resolved to a type\n----------\n");
        }
        finally {
            this.reportMissingJavadocTags = bkup;
        }
    }

    public void test018() {
        String bkup = this.reportMissingJavadocTags;
        try {
            this.reportMissingJavadocTags = "ignore";
            this.runNegativeTest(new String[]{"X.java", "public class X {\n\t///\n\t/// Reference to an invalid type [Strings][java.langs.Strings]\n\t///\n\tpublic static void main() {\n\t\tSystem.out.println(\"Hello\");\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\t/// Reference to an invalid type [Strings][java.langs.Strings]\n\t                                           ^^^^^^^^^^^^^^^^^^\nJavadoc: java.langs cannot be resolved to a type\n----------\n");
        }
        finally {
            this.reportMissingJavadocTags = bkup;
        }
    }

    public void test019() {
        String bkup = this.reportMissingJavadocTags;
        try {
            this.reportMissingJavadocTags = "ignore";
            this.runNegativeTest(new String[]{"X.java", "public class X {\n\t///\n\t/// Reference to an invalid method in a valid type [charArray()][java.lang.String#toCharArrays()]\n\t///\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(\"Hello\");\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\t/// Reference to an invalid method in a valid type [charArray()][java.lang.String#toCharArrays()]\n\t                                                                                  ^^^^^^^^^^^^\nJavadoc: The method toCharArrays() is undefined for the type String\n----------\n");
        }
        finally {
            this.reportMissingJavadocTags = bkup;
        }
    }

    public void test020() {
        String bkup = this.reportMissingJavadocTags;
        try {
            this.reportMissingJavadocTags = "ignore";
            this.runNegativeTest(new String[]{"X.java", "public class X {\n\t///\n\t/// Reference to an invalid method in a valid type [\\[\\]][java.lang.String#toCharArrays()]\n\t///\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(\"Hello\");\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\t/// Reference to an invalid method in a valid type [\\[\\]][java.lang.String#toCharArrays()]\n\t                                                                           ^^^^^^^^^^^^\nJavadoc: The method toCharArrays() is undefined for the type String\n----------\n");
        }
        finally {
            this.reportMissingJavadocTags = bkup;
        }
    }

    public void test021() {
        String bkup = this.reportMissingJavadocTags;
        try {
            this.reportMissingJavadocTags = "ignore";
            this.runNegativeTest(new String[]{"X.java", "///\n/// Reference to method with array parameter: [#main(String[])]\n///\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(\"Hello\");\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\t/// Reference to method with array parameter: [#main(String[])]\n\t                                                    ^^^^^^^^\nJavadoc: Invalid parameters declaration\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
        }
        finally {
            this.reportMissingJavadocTags = bkup;
        }
    }

    public void test022() {
        String bkup = this.reportMissingJavadocTags;
        try {
            this.reportMissingJavadocTags = "ignore";
            this.runConformTest(new String[]{"X.java", "import java.lang.annotation.Documented;\n/**\n * Reference type {@link Documented}:\n */\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(\"Hello\");\n\t}\n}\n"}, "Hello");
        }
        finally {
            this.reportMissingJavadocTags = bkup;
        }
    }

    public void test023() {
        String bkup = this.reportMissingJavadocTags;
        try {
            this.reportMissingJavadocTags = "ignore";
            this.runNegativeTest(new String[]{"X.java", "import java.lang.annotation.Documented;\n/**\n * Reference type but no reference here - :\n */\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(\"Hello\");\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\timport java.lang.annotation.Documented;\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nThe import java.lang.annotation.Documented is never used\n----------\n");
        }
        finally {
            this.reportMissingJavadocTags = bkup;
        }
    }

    public void test024() {
        String bkup = this.reportMissingJavadocTags;
        try {
            this.reportMissingJavadocTags = "ignore";
            this.runConformTest(new String[]{"X.java", "import java.lang.annotation.Documented;\n///\n/// Reference type {@link Documented}:\n///\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(\"Hello\");\n\t}\n}\n"}, "Hello");
        }
        finally {
            this.reportMissingJavadocTags = bkup;
        }
    }

    public void test025() {
        String bkup = this.reportMissingJavadocTags;
        try {
            this.reportMissingJavadocTags = "ignore";
            this.runNegativeTest(new String[]{"X.java", "import java.lang.annotation.Documented;\n///\n/// Reference type but no reference here:\n///\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(\"Hello\");\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\timport java.lang.annotation.Documented;\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nThe import java.lang.annotation.Documented is never used\n----------\n");
        }
        finally {
            this.reportMissingJavadocTags = bkup;
        }
    }
}

