/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.io.File;
import java.util.Arrays;
import java.util.stream.Stream;
import junit.framework.Test;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest9;
import org.eclipse.jdt.core.util.IAttributeNamesConstants;
import org.eclipse.jdt.core.util.IClassFileAttribute;
import org.eclipse.jdt.core.util.IClassFileReader;
import org.eclipse.jdt.core.util.IModuleAttribute;

public class ModuleAttributeTests
extends AbstractRegressionTest9 {
    private static String[] allowedAttributes = new String[]{new String(IAttributeNamesConstants.MODULE), new String(IAttributeNamesConstants.MODULE_MAIN_CLASS), new String(IAttributeNamesConstants.MODULE_PACKAGES), new String(IAttributeNamesConstants.RUNTIME_VISIBLE_ANNOTATIONS), new String(IAttributeNamesConstants.RUNTIME_INVISIBLE_ANNOTATIONS), new String(IAttributeNamesConstants.SOURCE)};

    public ModuleAttributeTests(String name) {
        super(name);
    }

    public static Class<?> testClass() {
        return ModuleAttributeTests.class;
    }

    public static Test suite() {
        return ModuleAttributeTests.buildMinimalComplianceTestSuite(ModuleAttributeTests.testClass(), 64);
    }

    private IModuleAttribute getModuleAttribute(String[] contents) {
        this.runConformTest(contents);
        IClassFileReader cfr = ToolFactory.createDefaultClassFileReader((String)(OUTPUT_DIR + File.separator + "module-info.class"), (int)17);
        ModuleAttributeTests.assertNotNull((String)"Error reading module-info.class", (Object)cfr);
        IClassFileAttribute attr = Arrays.stream(cfr.getAttributes()).filter(e -> new String(e.getAttributeName()).equals("Module")).findFirst().orElse(null);
        ModuleAttributeTests.assertNotNull((String)"Module attribute not found", (Object)attr);
        ModuleAttributeTests.assertTrue((String)"Not a module attribute", (boolean)(attr instanceof IModuleAttribute));
        return (IModuleAttribute)attr;
    }

    public void test001() throws Exception {
        this.runConformTest(new String[]{"module-info.java", "module test {\n}\n"});
        IClassFileReader cfr = ToolFactory.createDefaultClassFileReader((String)(OUTPUT_DIR + File.separator + "module-info.class"), (int)17);
        ModuleAttributeTests.assertNotNull((String)"Error reading module-info.class", (Object)cfr);
        IClassFileAttribute moduleAttribute = null;
        IClassFileAttribute[] attrs = cfr.getAttributes();
        int i = 0;
        int max = attrs.length;
        while (i < max) {
            if (new String(attrs[i].getAttributeName()).equals("Module")) {
                moduleAttribute = attrs[i];
            }
            ++i;
        }
        ModuleAttributeTests.assertNotNull((String)"Module attribute not found", moduleAttribute);
    }

    public void testBug508889_002() throws Exception {
        this.runConformTest(new String[]{"module-info.java", "module first {\n}\n"});
        IClassFileReader cfr = ToolFactory.createDefaultClassFileReader((String)(OUTPUT_DIR + File.separator + "module-info.class"), (int)17);
        ModuleAttributeTests.assertNotNull((String)"Error reading module-info.class", (Object)cfr);
        long count = Arrays.stream(cfr.getAttributes()).filter(e -> new String(e.getAttributeName()).equals("Module")).count();
        ModuleAttributeTests.assertEquals((String)"Unexpected number of module attributes", (long)1L, (long)count);
    }

    public void _testBug508889_003() throws Exception {
        String[] contents = new String[]{"module-info.java", "module first {\nexports pack1;\nexports pack2 to zero;\n}\n", "pack1/X11.java", "package pack1;\npublic class X11 {}\n", "pack2/X21.java", "package pack2;\npublic class X21 {}\n"};
        IModuleAttribute module = this.getModuleAttribute(contents);
        ModuleAttributeTests.assertEquals("Wrong Module Name", "first", new String(module.getModuleName()));
        ModuleAttributeTests.assertTrue((String)"Unexpected attribute length", (module.getAttributeLength() > 0L ? 1 : 0) != 0);
    }

    public void testBug521521() throws Exception {
        this.runConformTest(new String[]{"module-info.java", "module test {\n}\n"});
        IClassFileReader cfr = ToolFactory.createDefaultClassFileReader((String)(OUTPUT_DIR + File.separator + "module-info.class"), (int)17);
        ModuleAttributeTests.assertNotNull((String)"Error reading module-info.class", (Object)cfr);
        int flags = cfr.getAccessFlags();
        ModuleAttributeTests.assertTrue((String)"Invalid access flags", ((flags & 0xFFFF7FFF) == 0 ? 1 : 0) != 0);
    }

    public void testBug521521a() throws Exception {
        this.runConformTest(new String[]{"module-info.java", "open module test {\n}\n"});
        IClassFileReader cfr = ToolFactory.createDefaultClassFileReader((String)(OUTPUT_DIR + File.separator + "module-info.class"), (int)17);
        ModuleAttributeTests.assertNotNull((String)"Error reading module-info.class", (Object)cfr);
        int flags = cfr.getAccessFlags();
        ModuleAttributeTests.assertTrue((String)"Invalid access flags", ((flags & 0xFFFF7FFF) == 0 ? 1 : 0) != 0);
    }

    public void testModuleCompile() throws Exception {
        String pack1_x11java = "pack1/X11.java";
        String pack2_x21java = "pack2/X21.java";
        this.associateToModule("first", pack1_x11java, pack2_x21java);
        String[] contents = new String[]{"module-info.java", "module first {\nexports pack1;\nexports pack2 to zero;\n}\n", pack1_x11java, "package pack1;\npublic class X11 {}\n", pack2_x21java, "package pack2;\npublic class X21 {}\n"};
        this.runConformTest(contents);
    }

    public void testBug495967() throws Exception {
        String pack1_x11java = "pack1/pack2/pack3/pack4/X11.java";
        String pack2_x21java = "pack21/pack22/pack23/pack24/X21.java";
        String pack3_x31java = "pack31/pack32/pack33/pack34/X31.java";
        String pack4_x41java = "pack41/pack42/pack43/pack44/X41.java";
        String pack5_x51java = "pack51/pack52/pack53/pack54/X51.java";
        String pack6_x61java = "pack61/pack62/pack63/pack64/X61.java";
        String pack7_x71java = "pack71/pack72/pack73/pack74/X71.java";
        String pack8_x81java = "pack81/pack82/pack83/pack84/X81.java";
        String pack9_x91java = "pack91/pack92/pack93/pack94/X91.java";
        this.associateToModule("first", pack1_x11java, pack2_x21java, pack3_x31java, pack4_x41java, pack5_x51java, pack6_x61java, pack7_x71java, pack8_x81java, pack9_x91java);
        String[] contents = new String[]{"module-info.java", "module first {\nexports pack1.pack2.pack3.pack4 to zero, one, two, three, four, five, six, seven, eight, nine, ten, eleven, twelve, thirteen, fourteen, fifteen, sixteen, seventeen, eighteen, nineteen, twenty;\nexports pack21.pack22.pack23.pack24 to zero, one, two, three, four, five, six, seven, eight, nine, ten, eleven, twelve, thirteen, fourteen, fifteen, sixteen, seventeen, eighteen, nineteen, twenty;\nexports pack31.pack32.pack33.pack34 to zero, one, two, three, four, five, six, seven, eight, nine, ten, eleven, twelve, thirteen, fourteen, fifteen, sixteen, seventeen, eighteen, nineteen, twenty;\nexports pack41.pack42.pack43.pack44 to zero, one, two, three, four, five, six, seven, eight, nine, ten, eleven, twelve, thirteen, fourteen, fifteen, sixteen, seventeen, eighteen, nineteen, twenty;\nexports pack51.pack52.pack53.pack54 to zero, one, two, three, four, five, six, seven, eight, nine, ten, eleven, twelve, thirteen, fourteen, fifteen, sixteen, seventeen, eighteen, nineteen, twenty;\nexports pack61.pack62.pack63.pack64 to zero, one, two, three, four, five, six, seven, eight, nine, ten, eleven, twelve, thirteen, fourteen, fifteen, sixteen, seventeen, eighteen, nineteen, twenty;\nexports pack71.pack72.pack73.pack74 to zero, one, two, three, four, five, six, seven, eight, nine, ten, eleven, twelve, thirteen, fourteen, fifteen, sixteen, seventeen, eighteen, nineteen, twenty;\nexports pack81.pack82.pack83.pack84 to zero, one, two, three, four, five;\nexports pack91.pack92.pack93.pack94 to zero, one, two, three, four, five, six, seven, eight, nine, ten, eleven, twelve, thirteen, fourteen, fifteen, sixteen, seventeen, eighteen, nineteen, twenty;\n}\n", pack1_x11java, "package pack1.pack2.pack3.pack4;\npublic class X11 {}\n", pack2_x21java, "package pack21.pack22.pack23.pack24;\npublic class X21 {}\n", pack3_x31java, "package pack31.pack32.pack33.pack34;\npublic class X31 {}\n", pack4_x41java, "package pack41.pack42.pack43.pack44;\npublic class X41 {}\n", pack5_x51java, "package pack51.pack52.pack53.pack54;\npublic class X51 {}\n", pack6_x61java, "package pack61.pack62.pack63.pack64;\npublic class X61 {}\n", pack7_x71java, "package pack71.pack72.pack73.pack74;\npublic class X71 {}\n", pack8_x81java, "package pack81.pack82.pack83.pack84;\npublic class X81 {}\n", pack9_x91java, "package pack91.pack92.pack93.pack94;\npublic class X91 {}\n"};
        this.runConformTest(contents);
    }

    public void testBug519330() throws Exception {
        String[] contents = new String[]{"module-info.java", "module java.base {\n}\n"};
        IModuleAttribute moduleAttribute = this.getModuleAttribute(contents);
        ModuleAttributeTests.assertTrue((String)"module java.base should not require any other modules", (moduleAttribute.getRequiresCount() == 0 ? 1 : 0) != 0);
    }

    public void testBug533134() throws Exception {
        IClassFileAttribute[] attrs;
        String[] contents = new String[]{"module-info.java", "@Deprecated\nmodule test {\n}\n"};
        this.runConformTest(contents);
        IClassFileReader cfr = ToolFactory.createDefaultClassFileReader((String)(OUTPUT_DIR + File.separator + "module-info.class"), (int)17);
        ModuleAttributeTests.assertNotNull((String)"Error reading module-info.class", (Object)cfr);
        IClassFileAttribute[] iClassFileAttributeArray = attrs = cfr.getAttributes();
        int n = attrs.length;
        int n2 = 0;
        while (n2 < n) {
            IClassFileAttribute attr = iClassFileAttributeArray[n2];
            String name = new String(attr.getAttributeName());
            ModuleAttributeTests.assertTrue((String)("Attribute " + name + " is not allowed"), (boolean)Stream.of(allowedAttributes).anyMatch(a -> a.equals(name)));
            ++n2;
        }
    }
}

