/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.function.Consumer;
import junit.framework.Test;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractModuleCompilationTest;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;
import org.eclipse.jdt.core.tests.util.Util;
import org.eclipse.jdt.core.util.IClassFileAttribute;
import org.eclipse.jdt.core.util.IClassFileReader;
import org.eclipse.jdt.core.util.IModuleAttribute;
import org.eclipse.jdt.internal.compiler.codegen.AttributeNamesConstants;
import org.eclipse.jdt.internal.compiler.lookup.SplitPackageBinding;

public class ModuleCompilationTests
extends AbstractModuleCompilationTest {
    public ModuleCompilationTests(String name) {
        super(name);
    }

    public static Test suite() {
        return ModuleCompilationTests.buildMinimalComplianceTestSuite(ModuleCompilationTests.testClass(), 64);
    }

    public static Class<?> testClass() {
        return ModuleCompilationTests.class;
    }

    public void test001() {
        this.runNegativeModuleTest(new String[]{"p/X.java", "package p;\npublic class X {\n\tpublic static void main(String[] args) {\n     java.sql.Connection con = null;\n\t}\n}", "module-info.java", "module mod.one { \n\trequires java.base;\n}"}, " -9 \"" + this.getSourceDir() + File.separator + "module-info.java\" \"" + this.getSourceDir() + File.separator + "p/X.java\"", "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/p/X.java (at line 4)\n\tjava.sql.Connection con = null;\n\t^^^^^^^^^^^^^^^^^^^\nThe type java.sql.Connection is not accessible\n----------\n1 problem (1 error)\n", true, "package java.sql");
    }

    public void test002() {
        this.runConformModuleTest(new String[]{"p/X.java", "package p;\npublic class X {\n\tpublic static void main(String[] args) {\n     java.sql.Connection con = null;\n     System.out.println(con);\n\t}\n}", "module-info.java", "module mod.one { \n\trequires java.base;\n\trequires java.sql;\n}"}, " -9 \"" + OUTPUT_DIR + File.separator + "module-info.java\" \"" + OUTPUT_DIR + File.separator + "p/X.java\"", "", "", true);
    }

    public void test003() {
        this.runConformModuleTest(new String[]{"p/X.java", "package p;\npublic class X {\n\tpublic static void main(String[] args) {\n     java.sql.Connection con = null;\n     System.out.println(con);\n\t}\n}"}, "\"" + OUTPUT_DIR + File.separator + "p/X.java\"", "", "", true);
    }

    public void test004() {
        Set<String> classFiles = this.runConformModuleTest(new String[]{"module-info.java", "module mod.one { \n\trequires java.base;\n\trequires java.sql;\n}"}, " -9 \"" + OUTPUT_DIR + File.separator + "module-info.java\"", "", "", true);
        String fileName = this.getEcjOutputDir() + File.separator + "module-info.class";
        this.assertClassFile("Missing modul-info.class: " + fileName, fileName, classFiles);
    }

    public void test005() {
        Set<String> classFiles = this.runConformModuleTest(new String[]{"p/X.java", "package p;\npublic class X {\n\tjava.sql.Connection con;\n}", "module-info.java", "module mod.one { \n\trequires java.base;\n\trequires java.sql;\n\trequires java.desktop;\n}", "q/Y.java", "package q;\npublic class Y {\n   java.awt.Image image;\n}"}, " -9 \"" + OUTPUT_DIR + File.separator + "module-info.java\" \"" + OUTPUT_DIR + File.separator + "q/Y.java\" \"" + OUTPUT_DIR + File.separator + "p/X.java\"", "", "", true);
        String fileName = this.getEcjOutputDir() + File.separator + "module-info.class";
        this.assertClassFile("Missing modul-info.class: " + fileName, fileName, classFiles);
    }

    public void test006() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = OUTPUT_DIR + File.separator + "src";
        String moduleLoc = directory + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n\trequires java.base;\n\trequires java.sql;\n\trequires java.desktop;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "p", "X.java", "package p;\npublic class X {\n\tjava.sql.Connection con;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "q", "Y.java", "package q;\npublic class Y {\n   java.awt.Image image;\n}");
        StringBuilder buffer = new StringBuilder();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" --module-source-path \"" + directory + "\"");
        this.runConformModuleTest(files, buffer, "", "");
    }

    public void test007() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = OUTPUT_DIR + File.separator + "src";
        String moduleLoc = directory + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n\trequires java.base;\n\trequires transitive java.sql;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "p", "X.java", "package p;\npublic class X {\n\tpublic static java.sql.Connection getConnection() {\n\t\treturn null;\n\t}\n}");
        moduleLoc = directory + File.separator + "mod.two";
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.two { \n\trequires java.base;\n\trequires mod.one;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "q", "Y.java", "package q;\npublic class Y {\n   java.sql.Connection con = p.X.getConnection();\n}");
        StringBuilder buffer = new StringBuilder();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" --module-source-path \"" + directory + "\"");
        this.runNegativeModuleTest(files, buffer, "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.two/q/Y.java (at line 3)\n\tjava.sql.Connection con = p.X.getConnection();\n\t                          ^^^\nThe type p.X is not accessible\n----------\n1 problem (1 error)\n", "p.X");
    }

    public void test008() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = OUTPUT_DIR + File.separator + "src";
        String moduleLoc = directory + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n\texports p;\n\trequires mod.two;\n\trequires transitive java.sql;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "p", "X.java", "package p;\nimport q.Y;\npublic class X {\n\tpublic static java.sql.Connection getConnection() {\n\t\treturn Y.con;\n\t}\n}");
        moduleLoc = directory + File.separator + "mod.two";
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.two { \n\texports q;\n\trequires java.sql;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "q", "Y.java", "package q;\npublic class Y {\n   public static java.sql.Connection con = null;\n}");
        StringBuilder buffer = new StringBuilder();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" -warn:-exports").append(" --module-source-path \"" + directory + "\"");
        this.runConformModuleTest(files, buffer, "", "");
    }

    public void test008a() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = OUTPUT_DIR + File.separator + "src";
        String moduleLoc = directory + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n\texports p.q;\n\trequires java.base;\n\trequires transitive java.sql;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "p" + File.separator + "q", "X.java", "package p.q;\npublic class X {\n\tpublic static java.sql.Connection getConnection() {\n\t\treturn null;\n\t}\n}");
        moduleLoc = directory + File.separator + "mod.two";
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.two { \n\trequires java.base;\n\trequires mod.one;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "q" + File.separator + "r", "Y.java", "package q.r;\npublic class Y {\n   java.sql.Connection con = p.q.X.getConnection();\n}");
        String systemDirectory = OUTPUT_DIR + File.separator + "system";
        this.writeFile(systemDirectory, "readme.txt", "Not a valid system");
        StringBuilder buffer = new StringBuilder();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append("--system ").append(systemDirectory).append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" --module-source-path \"" + directory + "\"");
        this.runNegativeModuleTest(files, buffer, "", "invalid location for system libraries: ---OUTPUT_DIR_PLACEHOLDER---/system\n", "system");
    }

    public void test009() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = OUTPUT_DIR + File.separator + "src";
        String moduleLoc = directory + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n\texports p;\n\trequires java.base;\n\trequires transitive java.sql;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "p", "X.java", "package p;\npublic class X {\n\tpublic static java.sql.Connection getConnection() {\n\t\treturn null;\n\t}\n}");
        moduleLoc = directory + File.separator + "mod.two";
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.two { \n\trequires java.base;\n\trequires mod.one;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "q", "Y.java", "package q;\npublic class Y {\n   java.sql.Connection con = p.X.getConnection();\n}");
        StringBuilder buffer = new StringBuilder();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" --module-source-path \"" + directory + "\"");
        this.runConformModuleTest(files, buffer, "", "");
    }

    private void createUnnamedLibrary(String unnamedLoc, String unnamedBin) {
        this.writeFile(unnamedLoc + File.separator + "s" + File.separator + "t", "Tester.java", "package s.t;\npublic class Tester {\n}");
        StringBuilder buffer = new StringBuilder();
        buffer.append("-d " + unnamedBin).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\"").append(" -sourcepath \"" + unnamedLoc + "\" ").append(unnamedLoc + File.separator + "s" + File.separator + "t" + File.separator + "Tester.java");
        this.runConformTest(new String[0], buffer.toString(), "", "", false);
    }

    private void createReusableModules(String srcDir, String outDir, File modDir) {
        File mod2;
        String moduleLoc = srcDir + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n\texports p;\n\trequires java.base;\n\trequires transitive java.sql;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "p", "X.java", "package p;\npublic class X {\n\tpublic static java.sql.Connection getConnection() {\n\t\treturn null;\n\t}\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "p1", "X1.java", "package p1;\npublic class X1 {\n\tpublic static java.sql.Connection getConnection() {\n\t\treturn null;\n\t}\n}");
        moduleLoc = srcDir + File.separator + "mod.two";
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.two { \n\texports q;\n\trequires java.base;\n\trequires mod.one;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "q", "Y.java", "package q;\npublic class Y {\n   java.sql.Connection con = p.X.getConnection();\n}");
        StringBuilder buffer = new StringBuilder();
        buffer.append("-d " + outDir).append(" -9 ").append(" --module-path \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" --module-source-path \"" + srcDir + "\"");
        for (String string : files) {
            buffer.append(" \"").append(string).append("\"");
        }
        this.runConformTest(new String[0], buffer.toString(), "", "", false);
        String string = String.valueOf(modDir) + File.separator + "mod.one.jar";
        try {
            Util.zip(new File(outDir + File.separator + "mod.one"), string);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (!modDir.exists() && !modDir.mkdirs()) {
            ModuleCompilationTests.fail((String)("Coult not create folder " + String.valueOf(modDir)));
        }
        if (!(mod2 = new File(modDir, "mod.two")).mkdir()) {
            ModuleCompilationTests.fail((String)("Coult not create folder " + String.valueOf(mod2)));
        }
        Util.copy(outDir + File.separator + "mod.two", mod2.getAbsolutePath());
        Util.flushDirectoryContent(new File(outDir));
        Util.flushDirectoryContent(new File(srcDir));
    }

    public void test010() {
        Util.flushDirectoryContent(new File(OUTPUT_DIR));
        String outDir = OUTPUT_DIR + File.separator + "bin";
        String srcDir = OUTPUT_DIR + File.separator + "src";
        File modDir = new File(OUTPUT_DIR + File.separator + "mod");
        this.createReusableModules(srcDir, outDir, modDir);
        String moduleLoc = srcDir + File.separator + "mod.three";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.three { \n\trequires mod.one;\n\trequires mod.two;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "r", "Z.java", "package r;\npublic class Z extends Object {\n\tp.X x = null;\n\tq.Y y = null;\n}");
        StringBuilder buffer = new StringBuilder();
        buffer.append("-d " + outDir).append(" -9 ").append(" -p \"").append(Util.getJavaClassLibsAsString()).append(modDir.getAbsolutePath()).append("\" ").append(" --module-source-path \"" + srcDir + "\"");
        this.runConformModuleTest(files, buffer, "", "");
    }

    public void test011() {
        this.runConformModuleTest(new String[]{"p/X.java", "package p;\npublic class X {\n   java.lang.SecurityException ex = null;\n}", "module-info.java", "module mod.one { \n\trequires java.base;\n}"}, " -9 \"" + OUTPUT_DIR + File.separator + "module-info.java\" \"" + OUTPUT_DIR + File.separator + "p/X.java\"", "", "", true);
    }

    public void test012() {
        Util.flushDirectoryContent(new File(OUTPUT_DIR));
        String outDir = OUTPUT_DIR + File.separator + "bin";
        String srcDir = OUTPUT_DIR + File.separator + "src";
        File modDir = new File(OUTPUT_DIR + File.separator + "mod");
        this.createReusableModules(srcDir, outDir, modDir);
        String moduleLoc = srcDir + File.separator + "mod.three";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.three { \n\trequires mod.one;\n\trequires mod.two;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "r", "Z.java", "package r;\npublic class Z extends Object {\n}");
        StringBuilder buffer = new StringBuilder();
        buffer.append("-d " + outDir).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append(String.valueOf(modDir) + File.separator + "mod.one.jar").append(File.pathSeparator).append(String.valueOf(modDir) + File.separator + "mod.two").append(File.pathSeparator).append("\" ").append(" --module-source-path \"" + srcDir + "\"");
        this.runNegativeModuleTest(files, buffer, "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.three/module-info.java (at line 2)\n\trequires mod.one;\n\t         ^^^^^^^\nmod.one cannot be resolved to a module\n----------\n2. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.three/module-info.java (at line 3)\n\trequires mod.two;\n\t         ^^^^^^^\nmod.two cannot be resolved to a module\n----------\n2 problems (2 errors)\n", "module");
    }

    public void test013() {
        Util.flushDirectoryContent(new File(OUTPUT_DIR));
        String outDir = OUTPUT_DIR + File.separator + "bin";
        String srcDir = OUTPUT_DIR + File.separator + "src";
        File modDir = new File(OUTPUT_DIR + File.separator + "mod");
        this.createReusableModules(srcDir, outDir, modDir);
        String moduleLoc = srcDir + File.separator + "mod.three";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc + File.separator + "p", "Z.java", "package r;\npublic class Z extends Object {\n\tp.X x = null;\n\tq.Y y = null;\n}");
        StringBuilder buffer = new StringBuilder();
        buffer.append("-d " + outDir).append(" -9").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append(String.valueOf(modDir) + File.separator + "mod.one.jar").append(File.pathSeparator).append(String.valueOf(modDir) + File.separator + "mod.two").append(File.pathSeparator).append("\" ");
        this.runConformModuleTest(files, buffer, "", "");
    }

    public void testBug495500a() throws Exception {
        this.runConformTest(new String[]{"X.java", "/** */\npublic class X {\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\" -9 -d \"" + OUTPUT_DIR + "\"", "", "", true);
        String expectedOutput = "// Compiled from X.java (version 9 : 53.0, super bit)";
        this.checkDisassembledClassFile(OUTPUT_DIR + File.separator + "X.class", "X", expectedOutput);
    }

    public void testBug495500b() throws Exception {
        this.runConformTest(new String[]{"X.java", "/** */\npublic class X {\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\" -9 -source 8 -target 9 -d \"" + OUTPUT_DIR + "\"", "", "", true);
        String expectedOutput = "// Compiled from X.java (version 9 : 53.0, super bit)";
        this.checkDisassembledClassFile(OUTPUT_DIR + File.separator + "X.class", "X", expectedOutput);
    }

    public void testBug495500c() throws Exception {
        this.runConformTest(new String[]{"X.java", "/** */\npublic class X {\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\" -9 -source 9 -target 9 -d \"" + OUTPUT_DIR + "\"", "", "", true);
        String expectedOutput = "// Compiled from X.java (version 9 : 53.0, super bit)";
        this.checkDisassembledClassFile(OUTPUT_DIR + File.separator + "X.class", "X", expectedOutput);
    }

    public void test014() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = OUTPUT_DIR + File.separator + "src";
        String moduleLoc = directory + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n\trequires java.base;\n\trequires transitive java.sql;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "p", "X.java", "package p;\npublic class X {\n\tpublic static java.sql.Connection getConnection() {\n\t\treturn null;\n\t}\n}");
        moduleLoc = directory + File.separator + "mod.two";
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.two { \n\trequires java.base;\n\trequires mod.one;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "q", "Y.java", "package q;\npublic class Y {\n   java.sql.Connection con = p.X.getConnection();\n}");
        StringBuilder buffer = new StringBuilder();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" --module-source-path \"" + directory + "\"").append(" --add-exports mod.one/p=mod.two");
        this.runConformModuleTest(files, buffer, "", "");
    }

    public void test015() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = OUTPUT_DIR + File.separator + "src";
        String moduleLoc = directory + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n\trequires java.base;\n\trequires transitive java.sql;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "p", "X.java", "package p;\npublic class X {\n\tpublic static java.sql.Connection getConnection() {\n\t\treturn null;\n\t}\n}");
        moduleLoc = directory + File.separator + "mod.two";
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.two { \n\trequires java.base;\n\trequires java.sql;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "q", "Y.java", "package q;\npublic class Y {\n   java.sql.Connection con = p.X.getConnection();\n}");
        StringBuilder buffer = new StringBuilder();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" --module-source-path \"" + directory + "\"").append(" --add-exports mod.one/p=mod.two");
        this.runNegativeModuleTest(files, buffer, "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.two/q/Y.java (at line 3)\n\tjava.sql.Connection con = p.X.getConnection();\n\t                          ^^^\nThe type p.X is not accessible\n----------\n1 problem (1 error)\n", "does not read it", AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacBug8207032);
    }

    public void test016() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = OUTPUT_DIR + File.separator + "src";
        String moduleLoc = directory + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n\trequires java.base;\n\trequires transitive java.sql;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "p", "X.java", "package p;\npublic class X {\n\tpublic static java.sql.Connection getConnection() {\n\t\treturn null;\n\t}\n}");
        moduleLoc = directory + File.separator + "mod.two";
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.two { \n\trequires java.base;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "q", "Y.java", "package q;\npublic class Y {\n   java.sql.Connection con = p.X.getConnection();\n}");
        StringBuilder buffer = new StringBuilder();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" --module-source-path \"" + directory + "\"").append(" --add-exports mod.one/p=mod.two").append(" --add-reads mod.two=mod.one");
        this.runConformModuleTest(files, buffer, "", "");
    }

    public void test017() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = OUTPUT_DIR + File.separator + "src";
        String moduleLoc = directory + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n\trequires java.base;\n\trequires transitive java.sql;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "p", "X.java", "package p;\npublic class X {\n\tpublic static java.sql.Connection getConnection() {\n\t\treturn null;\n\t}\n}");
        moduleLoc = directory + File.separator + "mod.two";
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.two { \n\trequires java.base;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "q", "Y.java", "package q;\npublic class Y {\n   java.sql.Connection con = p.X.getConnection();\n}");
        StringBuilder buffer = new StringBuilder();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" --module-source-path \"" + directory + "\"").append(" --add-exports mod.one/p=mod.three").append(" --add-reads mod.two=mod.one");
        this.runNegativeModuleTest(files, buffer, "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.two/q/Y.java (at line 3)\n\tjava.sql.Connection con = p.X.getConnection();\n\t                          ^^^\nThe type p.X is not accessible\n----------\n1 problem (1 error)\n", "visible");
    }

    public void test018() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = OUTPUT_DIR + File.separator + "src";
        String moduleLoc = directory + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n\trequires java.base;\n\trequires transitive java.sql;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "p", "X.java", "package p;\npublic class X {\n\tpublic static java.sql.Connection getConnection() {\n\t\treturn null;\n\t}\n}");
        moduleLoc = directory + File.separator + "mod.two";
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.two { \n\trequires java.base;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "q", "Y.java", "package q;\npublic class Y {\n   java.sql.Connection con = p.X.getConnection();\n}");
        moduleLoc = directory + File.separator + "mod.three";
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.three { \n\trequires java.base;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "r", "Z.java", "package r;\npublic class Z {\n   java.sql.Connection con = p.X.getConnection();\n}");
        StringBuilder buffer = new StringBuilder();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" --module-source-path \"" + directory + "\"").append(" --add-exports mod.one/p=mod.two,mod.three").append(" --add-reads mod.two=mod.one").append(" --add-reads mod.three=mod.one");
        this.runConformModuleTest(files, buffer, "", "");
    }

    public void test019() {
        AbstractModuleCompilationTest.Runner runner = new AbstractModuleCompilationTest.Runner();
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = OUTPUT_DIR + File.separator + "src";
        String moduleLoc = directory + File.separator + "mod.one";
        runner.createFile(moduleLoc + File.separator + "p", "X.java", "package p;\npublic abstract class X extends com.sun.security.ntlm.Server {\n\t//public X() {}\n\tpublic X(String arg0, String arg1) throws com.sun.security.ntlm.NTLMException {\n\t\tsuper(arg0, arg1);\n\t}\n}");
        runner.commandLine.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" -sourcepath \"" + moduleLoc + "\" ").append(" --add-exports java.base/com.sun.security.ntlm=ALL-UNNAMED ");
        runner.javacVersionOptions = "-source 9 -Xlint:-options";
        runner.runConformModuleTest();
    }

    public void test019b() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = OUTPUT_DIR + File.separator + "src";
        String unnamedLoc = directory + File.separator + "nomodule";
        String unnamedBin = OUTPUT_DIR + File.separator + "un_bin";
        String moduleLoc = directory + File.separator + "mod" + File.separator + "mod.one";
        this.createUnnamedLibrary(unnamedLoc, unnamedBin);
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one {\n\texports p.q;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "p" + File.separator + "q", "X.java", "package p.q;\npublic abstract class X {\n\ts.t.Tester t;\n}");
        StringBuilder buffer = new StringBuilder();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append(unnamedBin + File.pathSeparator).append("\"").append(" --module-source-path \"" + directory + File.separator + "mod\" ").append(" --add-reads mod.one=ALL-UNNAMED ");
        this.runConformModuleTest(files, buffer, "", "");
    }

    public void test019c() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = OUTPUT_DIR + File.separator + "src";
        String unnamedLoc = directory + File.separator + "nomodule";
        String unnamedBin = OUTPUT_DIR + File.separator + "un_bin";
        this.createUnnamedLibrary(unnamedLoc, unnamedBin);
        ArrayList<String> files = new ArrayList<String>();
        String moduleLoc = directory + File.separator + "mod.one";
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one {\n\texports p.q;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "p" + File.separator + "q", "X.java", "package p.q;\nimport s.*;\nimport s.t.*;\npublic abstract class X {\n}");
        StringBuilder buffer = new StringBuilder();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append(unnamedBin + File.pathSeparator).append("\"").append(" --module-source-path \"" + directory + "\" ").append(" --add-reads mod.one=ALL-UNNAMED ");
        this.runNegativeModuleTest(files, buffer, "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.one/p/q/X.java (at line 2)\n\timport s.*;\n\t       ^\nThe package s is not accessible\n----------\n1 problem (1 error)\n", "package s", AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacBug8204534);
    }

    public void test019fail() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = OUTPUT_DIR + File.separator + "src";
        String moduleLoc = directory + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc + File.separator + "p", "X.java", "package p;\npublic abstract class X extends com.sun.security.ntlm.Server {\n\t//public X() {}\n\tpublic X(String arg0, String arg1) throws com.sun.security.ntlm.NTLMException {\n\t\tsuper(arg0, arg1);\n\t}\n}");
        StringBuilder buffer = new StringBuilder();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" -sourcepath \"" + moduleLoc + "\" ");
        this.runNegativeModuleTest(files, buffer, "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.one/p/X.java (at line 2)\n\tpublic abstract class X extends com.sun.security.ntlm.Server {\n\t                                ^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nThe type com.sun.security.ntlm.Server is not accessible\n----------\n2. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.one/p/X.java (at line 4)\n\tpublic X(String arg0, String arg1) throws com.sun.security.ntlm.NTLMException {\n\t                                          ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nThe type com.sun.security.ntlm.NTLMException is not accessible\n----------\n2 problems (2 errors)\n", "package com.sun.security.ntlm");
    }

    public void test020() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = OUTPUT_DIR + File.separator + "src";
        String moduleLoc = directory + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n\trequires java.base;\n\trequires transitive java.sql;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "p", "X.java", "package p;\npublic class X {\n\tpublic static java.sql.Connection getConnection() {\n\t\treturn null;\n\t}\n}");
        StringBuilder buffer = new StringBuilder();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" --module-source-path \"" + directory + "\"").append(" --add-exports mod.one=mod.two,mod.three");
        this.runNegativeModuleTest(files, buffer, "", "incorrectly formatted option: --add-exports mod.one=mod.two,mod.three\n", "option");
    }

    public void test021() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = OUTPUT_DIR + File.separator + "src";
        String moduleLoc = directory + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n\trequires java.base;\n\trequires transitive java.sql;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "p", "X.java", "package p;\npublic class X {\n\tpublic static java.sql.Connection getConnection() {\n\t\treturn null;\n\t}\n}");
        StringBuilder buffer = new StringBuilder();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" --module-source-path \"" + directory + "\"").append(" --add-reads mod.one/mod.two");
        this.runNegativeModuleTest(files, buffer, "", "incorrectly formatted option: --add-reads mod.one/mod.two\n", "option");
    }

    public void test022() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = OUTPUT_DIR + File.separator + "src";
        String moduleLoc = directory + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n\trequires java.base;\n\trequires transitive java.sql;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "p", "X.java", "package p;\npublic class X {\n\tpublic static java.sql.Connection getConnection() {\n\t\treturn null;\n\t}\n}");
        StringBuilder buffer = new StringBuilder();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" --module-source-path \"" + directory + "\"").append(" --add-exports mod.one/p=mod.three").append(" --add-exports mod.one/p=mod.three");
        this.runNegativeModuleTest(files, buffer, "", "can specify a package in a module only once with --add-export\n", "export");
    }

    public void test023() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = OUTPUT_DIR + File.separator + "src";
        String moduleLoc = directory + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n\trequires java.base;\n\trequires transitive java.sql;\n}");
        StringBuilder buffer = new StringBuilder();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append("\"" + moduleLoc + File.separator + "module-info.java\" ").append(" -extdirs " + OUTPUT_DIR + File.separator + "src");
        this.runNegativeModuleTest(files, buffer, "", "option -extdirs not supported at compliance level 9 and above\n", "extdirs");
    }

    public void test024() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = OUTPUT_DIR + File.separator + "src";
        String moduleLoc = directory + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n\trequires java.base;\n\trequires transitive java.sql;\n}");
        StringBuilder buffer = new StringBuilder();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" \"" + moduleLoc + File.separator + "module-info.java\" ").append(" -bootclasspath " + OUTPUT_DIR + File.separator + "src");
        this.runNegativeModuleTest(files, buffer, "", "option -bootclasspath not supported at compliance level 9 and above\n", "option --boot-class-path cannot be used together with --release");
    }

    public void test025() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = OUTPUT_DIR + File.separator + "src";
        String moduleLoc = directory + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n\trequires java.base;\n\trequires transitive java.sql;\n}");
        StringBuilder buffer = new StringBuilder();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append("\"" + moduleLoc + File.separator + "module-info.java\" ").append(" -endorseddirs " + OUTPUT_DIR + File.separator + "src");
        this.runNegativeModuleTest(files, buffer, "", "option -endorseddirs not supported at compliance level 9 and above\n", "endorseddirs");
    }

    public void test026() {
        AbstractModuleCompilationTest.Runner runner = new AbstractModuleCompilationTest.Runner();
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = OUTPUT_DIR + File.separator + "src";
        String moduleLoc = directory + File.separator + "mod.one";
        runner.createFile(moduleLoc, "module-info.java", "module mod.one { \n\trequires java.base;\n\trequires transitive java.sql;\n}");
        String javaHome = System.getProperty("java.home");
        runner.commandLine.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" --system \"").append(javaHome).append("\"");
        runner.javacVersionOptions = "-source 9 -Xlint:-options";
        runner.runConformModuleTest();
    }

    public void test028() {
        Util.flushDirectoryContent(new File(OUTPUT_DIR));
        String outDir = OUTPUT_DIR + File.separator + "bin";
        String srcDir = OUTPUT_DIR + File.separator + "src";
        File modDir = new File(OUTPUT_DIR + File.separator + "mod");
        this.createReusableModules(srcDir, outDir, modDir);
        String moduleLoc = srcDir + File.separator + "mod.three";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.three { \n\trequires mod.one;\n\trequires mod.two;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "r", "Z.java", "package r;\npublic class Z extends Object {\n\tp.X x = null;\n\tp1.X1 x1 = null;\n}");
        StringBuilder buffer = new StringBuilder();
        buffer.append("-d " + outDir).append(" -9 ").append(" -p \"").append(Util.getJavaClassLibsAsString()).append(modDir.getAbsolutePath()).append("\" ").append(" --module-source-path \"" + srcDir + "\"");
        this.runNegativeModuleTest(files, buffer, "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.three/r/Z.java (at line 4)\n\tp1.X1 x1 = null;\n\t^^^^^\nThe type p1.X1 is not accessible\n----------\n1 problem (1 error)\n", "visible");
    }

    public void test029() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = OUTPUT_DIR + File.separator + "src";
        String moduleLoc = directory + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n\trequires java.base;\n\trequires java.sql;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "p", "X.java", "package p;\npublic class X {\n\tpublic static java.sql.Connection getConnection() {\n\t\treturn null;\n\t}\n}");
        moduleLoc = directory + File.separator + "mod.two";
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.two { \n\trequires java.base;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "q", "Y.java", "package q;\npublic class Y {\n   java.sql.Connection con = p.X.getConnection();\n}");
        StringBuilder buffer = new StringBuilder();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" --module-source-path \"" + directory + "\"").append(" --add-exports mod.one/p=mod.two,mod.three").append(" --add-reads mod.two=mod.one");
        this.runNegativeModuleTest(files, buffer, "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.one/p/X.java (at line 3)\n\tpublic static java.sql.Connection getConnection() {\n\t              ^^^^^^^^^^^^^^^^^^^\nThe type Connection from module java.sql may not be accessible to clients due to missing 'requires transitive'\n----------\n----------\n2. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.two/q/Y.java (at line 3)\n\tjava.sql.Connection con = p.X.getConnection();\n\t^^^^^^^^^^^^^^^^^^^\nThe type java.sql.Connection is not accessible\n----------\n2 problems (1 error, 1 warning)\n", "visible");
    }

    public void test030() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = OUTPUT_DIR + File.separator + "src";
        String moduleLoc = directory + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n\trequires java.base;\n\trequires java.sql;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "p", "X.java", "package p;\npublic class X {\n\tpublic static java.sql.Connection getConnection() {\n\t\treturn null;\n\t}\n}");
        moduleLoc = directory + File.separator + "mod.two";
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.two { \n\trequires java.base;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "q", "Y.java", "package q;\nimport java.sql.*;\npublic class Y {\n   Connection con = null;\n}");
        StringBuilder buffer = new StringBuilder();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" -warn:-exports").append(" --module-source-path \"" + directory + "\"").append(" --add-exports mod.one/p=mod.two,mod.three").append(" --add-reads mod.two=mod.one");
        this.runNegativeModuleTest(files, buffer, "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.two/q/Y.java (at line 2)\n\timport java.sql.*;\n\t       ^^^^^^^^\nThe package java.sql is not accessible\n----------\n2. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.two/q/Y.java (at line 4)\n\tConnection con = null;\n\t^^^^^^^^^^\nConnection cannot be resolved to a type\n----------\n2 problems (2 errors)\n", "visible");
    }

    public void test031() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = OUTPUT_DIR + File.separator + "src";
        String moduleLoc = directory + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n\trequires java.base;\n\trequires java.sql;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "p", "X.java", "package p;\npublic class X {\n\tstatic java.sql.Connection getConnection() {\n\t\treturn null;\n\t}\n}");
        moduleLoc = directory + File.separator + "mod.two";
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.two { \n\trequires java.base;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "q", "Y.java", "package q;\nimport java.sql.Connection;\npublic class Y {\n   Connection con = null;\n}");
        StringBuilder buffer = new StringBuilder();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" --module-source-path \"" + directory + "\"").append(" --add-exports mod.one/p=mod.two,mod.three").append(" --add-reads mod.two=mod.one");
        this.runNegativeModuleTest(files, buffer, "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.two/q/Y.java (at line 2)\n\timport java.sql.Connection;\n\t       ^^^^^^^^^^^^^^^^^^^\nThe type java.sql.Connection is not accessible\n----------\n2. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.two/q/Y.java (at line 4)\n\tConnection con = null;\n\t^^^^^^^^^^\nConnection cannot be resolved to a type\n----------\n2 problems (2 errors)\n", "visible");
    }

    public void test032() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = OUTPUT_DIR + File.separator + "src";
        String moduleLoc = directory + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n\trequires java.base;\n}");
        this.writeFileCollecting(files, moduleLoc + "/p", "X.java", "package p;\npublic class X {\n\tpublic static class Inner {\n\t}\n}");
        StringBuilder buffer = new StringBuilder();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" --module-source-path \"" + directory + "\"");
        this.runConformModuleTest(files, buffer, "", "");
    }

    public void test033() {
        File libDir = new File(LIB_DIR);
        Util.delete(libDir);
        libDir.mkdirs();
        try {
            Util.createJar(new String[]{"a/A.java", "package a;\npublic class A {\n}"}, LIB_DIR + "/lib1.jar", "9");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = OUTPUT_DIR + File.separator + "src";
        String moduleLoc = directory + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n\trequires java.base;\n\trequires java.sql;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "p", "X.java", "package p;\npublic class X extends a.A {\n}");
        StringBuilder buffer = new StringBuilder();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append(LIB_DIR).append(File.separator).append("lib1.jar").append(File.pathSeparator).append("\" ").append(" --module-source-path \"" + directory + "\"");
        this.runNegativeModuleTest(files, buffer, "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.one/p/X.java (at line 2)\n\tpublic class X extends a.A {\n\t                       ^^^\nThe type a.A is not accessible\n----------\n1 problem (1 error)\n", "package a does not exist");
    }

    public void test034() {
        File libDir = new File(LIB_DIR);
        Util.delete(libDir);
        libDir.mkdirs();
        try {
            Util.createJar(new String[]{"a/A.java", "package a;\npublic class A {\n}"}, LIB_DIR + "/lib1.jar", "9");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = OUTPUT_DIR + File.separator + "src";
        String moduleLoc = directory + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n\trequires java.base;\n\trequires java.sql;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "p", "X.java", "package p;\npublic class X extends a.A {\n}");
        StringBuilder buffer = new StringBuilder();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append("-p \"").append(LIB_DIR).append("\" ").append(" --module-source-path \"" + directory + "\"");
        this.runNegativeModuleTest(files, buffer, "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.one/p/X.java (at line 2)\n\tpublic class X extends a.A {\n\t                       ^^^\nThe type a.A is not accessible\n----------\n1 problem (1 error)\n", "does not read");
    }

    public void test035() {
        File libDir = new File(LIB_DIR);
        Util.delete(libDir);
        libDir.mkdirs();
        try {
            Util.createJar(new String[]{"a/A.java", "package a;\npublic class A {\n}"}, LIB_DIR + "/lib1.jar", "9");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = OUTPUT_DIR + File.separator + "src";
        String moduleLoc = directory + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n\trequires java.base;\n\trequires java.sql;\n\trequires lib1;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "p", "X.java", "package p;\npublic class X extends a.A {\n}");
        StringBuilder buffer = new StringBuilder();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append("-p \"").append(LIB_DIR).append("\" ").append(" -warn:-module ").append(" --module-source-path \"" + directory + "\"");
        this.runConformModuleTest(files, buffer, "", "");
    }

    public void testBug515985() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = OUTPUT_DIR + File.separator + "src";
        String moduleLoc = directory + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n\texports pm;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "impl", "Other.java", "package impl;\npublic class Other {\n    public void privateMethod() {}}\n");
        this.writeFileCollecting(files, moduleLoc + File.separator + "pm", "C1.java", "package pm;\nimport impl.Other;\npublic class C1 extends Other {\n}\n");
        moduleLoc = directory + File.separator + "mod.two";
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.two { \n\trequires mod.one;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "po", "Client.java", "package po;\nimport pm.C1;\npublic class Client {\n    void test1(C1 one) {\n        one.privateMethod(); // ecj: The method privateMethod() is undefined for the type C1\n    }\n}\n");
        StringBuilder buffer = new StringBuilder();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" --module-source-path \"" + directory + "\"");
        this.runConformModuleTest(files, buffer, "", "");
    }

    public void testApiLeak1() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = OUTPUT_DIR + File.separator + "src";
        String moduleLoc = directory + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n\texports pm;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "impl", "Other.java", "package impl;\npublic class Other {\n}\n");
        this.writeFileCollecting(files, moduleLoc + File.separator + "pm", "C1.java", "package pm;\nimport impl.Other;\npublic class C1 extends Other {\n\tpublic void m1(Other o) {}\n}\n");
        moduleLoc = directory + File.separator + "mod.two";
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.two { \n\trequires mod.one;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "impl", "Other.java", "package impl;\npublic class Other {\n}\n");
        this.writeFileCollecting(files, moduleLoc + File.separator + "po", "Client.java", "package po;\nimport pm.C1;\npublic class Client {\n    void test1(C1 one) {\n        one.m1(one);\n    }\n}\n");
        StringBuilder buffer = new StringBuilder();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" --module-source-path \"" + directory + "\"");
        this.runConformModuleTest(files, buffer, "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.one/pm/C1.java (at line 4)\n\tpublic void m1(Other o) {}\n\t               ^^^^^\nThe type Other is not exported from this module\n----------\n1 problem (1 warning)\n");
    }

    public void testApiLeak2() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = OUTPUT_DIR + File.separator + "src";
        String moduleLoc = directory + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n\texports pm;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "impl", "SomeImpl.java", "package impl;\npublic class SomeImpl {\n}\n");
        this.writeFileCollecting(files, moduleLoc + File.separator + "pm", "C1.java", "package pm;\nimport impl.SomeImpl;\npublic class C1 {\n\tpublic void m1(SomeImpl o) {}\n}\n");
        this.writeFileCollecting(files, moduleLoc + File.separator + "pm", "Other.java", "package pm;\nimport impl.SomeImpl;\npublic class Other extends SomeImpl {\n}\n");
        moduleLoc = directory + File.separator + "mod.two";
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.two { \n\trequires mod.one;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "impl", "SomeImpl.java", "package impl;\npublic class SomeImpl {\n}\n");
        this.writeFileCollecting(files, moduleLoc + File.separator + "po", "Client.java", "package po;\nimport pm.C1;\nimport pm.Other;\nimport impl.SomeImpl;\npublic class Client {\n    void test1(C1 one) {\n\t\t SomeImpl impl = new SomeImpl();\n        one.m1(impl);\n\t\t one.m1(new Other());\n    }\n}\n");
        StringBuilder buffer = new StringBuilder();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" -info:+exports").append(" --module-source-path \"" + directory + "\"");
        this.runNegativeModuleTest(files, buffer, "", "----------\n1. INFO in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.one/pm/C1.java (at line 4)\n\tpublic void m1(SomeImpl o) {}\n\t               ^^^^^^^^\nThe type SomeImpl is not exported from this module\n----------\n----------\n2. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.two/po/Client.java (at line 8)\n\tone.m1(impl);\n\t    ^^\nThe method m1(impl.SomeImpl) in the type C1 is not applicable for the arguments (impl.SomeImpl)\n----------\n2 problems (1 error, 0 warnings, 1 info)\n", "incompatible");
    }

    public void testPackageConflict0() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = OUTPUT_DIR + File.separator + "src";
        String moduleLoc = directory + File.separator + "mod.x";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.x { \n\texports pm;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "pm", "C1x.java", "package pm;\npublic class C1x {\n}\n");
        moduleLoc = directory + File.separator + "mod.y";
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.y { \n\trequires transitive mod.x;\n}");
        moduleLoc = directory + File.separator + "mod.one";
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n\texports pm;\n\texports p2;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "pm", "C1.java", "package pm;\npublic class C1 {\n}\n");
        this.writeFileCollecting(files, moduleLoc + File.separator + "p2", "C2.java", "package p2;\npublic class C2 {\n}\n");
        moduleLoc = directory + File.separator + "mod.two";
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.two { \n\texports pm;\n\texports p2.sub;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "pm", "C3.java", "package pm;\npublic class C3 {\n}\n");
        this.writeFileCollecting(files, moduleLoc + File.separator + "p2" + File.separator + "sub", "C4.java", "package p2.sub;\npublic class C4 {\n}\n");
        moduleLoc = directory + File.separator + "mod.three";
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.three { \n\trequires mod.one;\n\trequires mod.two;\n\trequires transitive mod.y;\n}");
        StringBuilder buffer = new StringBuilder();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" --module-source-path \"" + directory + "\"");
        this.runNegativeModuleTest(files, buffer, "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.three/module-info.java (at line 2)\n\trequires mod.one;\n\t^^^^^^^^^^^^^^^^\nThe package pm is accessible from more than one module: mod.one, mod.two, mod.x\n----------\n2. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.three/module-info.java (at line 3)\n\trequires mod.two;\n\t^^^^^^^^^^^^^^^^\nThe package pm is accessible from more than one module: mod.one, mod.two, mod.x\n----------\n3. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.three/module-info.java (at line 4)\n\trequires transitive mod.y;\n\t^^^^^^^^^^^^^^^^^^^^^^^^^\nThe package pm is accessible from more than one module: mod.one, mod.two, mod.x\n----------\n3 problems (3 errors)\n", "reads package pm");
    }

    public void testPackageConflict1() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = OUTPUT_DIR + File.separator + "src";
        String moduleLoc = directory + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n\texports pm;\n\texports p2;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "pm", "C1.java", "package pm;\npublic class C1 {\n}\n");
        this.writeFileCollecting(files, moduleLoc + File.separator + "p2", "C2.java", "package p2;\npublic class C2 {\n}\n");
        moduleLoc = directory + File.separator + "mod.two";
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.two { \n\texports pm;\n\texports p2.sub;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "pm", "C3.java", "package pm;\npublic class C3 {\n}\n");
        this.writeFileCollecting(files, moduleLoc + File.separator + "p2" + File.separator + "sub", "C4.java", "package p2.sub;\npublic class C4 {\n}\n");
        moduleLoc = directory + File.separator + "mod.three";
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.three { \n\trequires mod.one;\n\trequires mod.two;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "po", "Client.java", "package po;\nimport pm.*;\nimport pm.C3;\nimport p2.C2;\npublic class Client {\n    void test1(C1 one) {\n    }\n\t pm.C1 f1;\n\t p2.sub.C4 f4;\n}\n");
        StringBuilder buffer = new StringBuilder();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" --module-source-path \"" + directory + "\"");
        this.runNegativeModuleTest(files, buffer, "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.three/module-info.java (at line 2)\n\trequires mod.one;\n\t^^^^^^^^^^^^^^^^\nThe package pm is accessible from more than one module: mod.one, mod.two\n----------\n2. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.three/module-info.java (at line 3)\n\trequires mod.two;\n\t^^^^^^^^^^^^^^^^\nThe package pm is accessible from more than one module: mod.one, mod.two\n----------\n----------\n3. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.three/po/Client.java (at line 2)\n\timport pm.*;\n\t       ^^\nThe package pm is accessible from more than one module: mod.one, mod.two\n----------\n4. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.three/po/Client.java (at line 3)\n\timport pm.C3;\n\t       ^^\nThe package pm is accessible from more than one module: mod.one, mod.two\n----------\n5. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.three/po/Client.java (at line 8)\n\tpm.C1 f1;\n\t^^\nThe package pm is accessible from more than one module: mod.one, mod.two\n----------\n5 problems (5 errors)\n", "reads package pm");
    }

    public void testPackageConflict3() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = OUTPUT_DIR + File.separator + "src";
        ArrayList<String> files = new ArrayList<String>();
        String moduleLoc = directory + File.separator + "mod.one";
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n\texports pm;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "pm", "C1.java", "package pm;\npublic class C1 {\n}\n");
        moduleLoc = directory + File.separator + "mod.two";
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.two { \n\trequires mod.one;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "pm", "C3.java", "package pm;\npublic class C3 {\n}\n");
        StringBuilder buffer = new StringBuilder();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" --module-source-path \"" + directory + "\"");
        this.runNegativeModuleTest(files, buffer, "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.two/pm/C3.java (at line 1)\n\tpackage pm;\n\t        ^^\nThe package pm conflicts with a package accessible from another module: mod.one\n----------\n1 problem (1 error)\n", "");
    }

    public void testPackageConflict4() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = OUTPUT_DIR + File.separator + "src";
        File srcDir = new File(directory);
        String moduleLoc = directory + File.separator + "mod.x";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.x { \n\texports pm;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "pm", "C1.java", "package pm;\npublic class C1 {\n}\n");
        moduleLoc = directory + File.separator + "mod.y";
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.y { \n\texports pm;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "pm", "C1.java", "package pm;\npublic class C1 {\n}\n");
        StringBuilder buffer = new StringBuilder();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" --module-source-path \"" + directory + "\"");
        this.runConformModuleTest(files, buffer, "", "");
        Util.flushDirectoryContent(srcDir);
        files.clear();
        this.writeFileCollecting(files, directory + File.separator + "p", "X.java", "public class X extends pm.C1 { \n}");
        buffer = new StringBuilder();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" --module-path \"" + OUTPUT_DIR + File.separator + out + "\"");
        this.runNegativeModuleTest(files, buffer, "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/p/X.java (at line 1)\n\tpublic class X extends pm.C1 { \n\t                       ^^\nThe package pm is accessible from more than one module: mod.x, mod.y\n----------\n1 problem (1 error)\n", "package conflict");
    }

    public void _testPackageConflict4a() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = OUTPUT_DIR + File.separator + "src";
        File srcDir = new File(directory);
        String moduleLoc = directory + File.separator + "mod.x";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.x { \n\texports pm;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "pm", "C1.java", "package pm;\npublic class C1 {\n}\n");
        StringBuilder buffer = new StringBuilder();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" --module-source-path \"" + directory + "\"");
        this.runConformModuleTest(files, buffer, "", "");
        Util.flushDirectoryContent(srcDir);
        files.clear();
        this.writeFileCollecting(files, directory + File.separator + "p", "X.java", "public class X extends pm.C1 { \n}");
        buffer = new StringBuilder();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" --module-path \"" + OUTPUT_DIR + File.separator + out + "\"");
        this.runNegativeModuleTest(files, buffer, "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/p/X.java (at line 1)\n\tpublic class X extends pm.C1 { \n\t                       ^^\npm cannot be resolved to a type\n----------\n1 problem (1 error)\n", "package conflict");
    }

    public void testPackageConflict5() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = OUTPUT_DIR + File.separator + "src";
        File srcDir = new File(directory);
        String moduleLoc = directory + File.separator + "mod.x";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.x { \n\texports pm;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "pm", "C1.java", "package pm;\npublic class C1 {\n}\n");
        moduleLoc = directory + File.separator + "mod.y";
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.y { \n\texports pm;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "pm", "C1.java", "package pm;\npublic class C1 {\n}\n");
        StringBuilder buffer = new StringBuilder();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" --module-source-path \"" + directory + "\"");
        this.runConformModuleTest(files, buffer, "", "");
        Util.flushDirectoryContent(srcDir);
        files.clear();
        this.writeFileCollecting(files, directory + File.separator + "p", "X.java", "public class X extends pm.C1 { \n}");
        buffer = new StringBuilder();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" --module-path \"" + OUTPUT_DIR + File.separator + out + "\"").append(" --add-modules mod.x,mod.y");
        this.runNegativeModuleTest(files, buffer, "", "The package pm is accessible from more than one module: mod.y, mod.x\n", "reads package pm from both");
        buffer = new StringBuilder();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" --module-path \"" + OUTPUT_DIR + File.separator + out + "\"").append(" --add-modules mod.x,mod.z");
        this.runNegativeModuleTest(files, buffer, "", "invalid module name: mod.z\n", "module not found");
    }

    public void testPackageConflict6() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = OUTPUT_DIR + File.separator + "src";
        File srcDir = new File(directory);
        String moduleLoc = directory + File.separator + "mod.x";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.x { \n\texports pm;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "pm", "C1.java", "package pm;\npublic class C1 {\n}\n");
        moduleLoc = directory + File.separator + "mod.y";
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.y { \n\texports pm;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "pm", "C1.java", "package pm;\npublic class C1 {\n}\n");
        StringBuilder buffer = new StringBuilder();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" --module-source-path \"" + directory + "\"");
        this.runConformModuleTest(files, buffer, "", "");
        Util.flushDirectoryContent(srcDir);
        files.clear();
        this.writeFileCollecting(files, directory + File.separator + "p", "X.java", "public class X extends pm.C1 { \n}");
        buffer = new StringBuilder();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" --module-path \"" + OUTPUT_DIR + File.separator + out + "\"").append(" --add-modules mod.x,");
        this.runNegativeModuleTest(files, buffer, "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/p/X.java (at line 1)\n\tpublic class X extends pm.C1 { \n\t                       ^^\nThe package pm is accessible from more than one module: mod.x, mod.y\n----------\n1 problem (1 error)\n", "package conflict");
    }

    public void testPackageConflict7() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = OUTPUT_DIR + File.separator + "src";
        File srcDir = new File(directory);
        String moduleLoc = directory + File.separator + "mod.x";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.x { \n\texports pm;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "pm", "C1.java", "package pm;\npublic class C1 {\n}\n");
        moduleLoc = directory + File.separator + "mod.y";
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.y { \n\texports pm;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "pm", "C1.java", "package pm;\npublic class C1 {\n}\n");
        StringBuilder buffer = new StringBuilder();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" --module-source-path \"" + directory + "\"");
        this.runConformModuleTest(files, buffer, "", "");
        Util.flushDirectoryContent(srcDir);
        files.clear();
        this.writeFileCollecting(files, directory + File.separator + "p", "X.java", "public class X { \n}");
        buffer = new StringBuilder();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" --module-path \"" + OUTPUT_DIR + File.separator + out + "\"").append(" --add-modules mod.x,mod.y");
        this.runNegativeModuleTest(files, buffer, "", "The package pm is accessible from more than one module: mod.y, mod.x\n", "reads package pm from both");
    }

    public void testPackageTypeConflict1() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = OUTPUT_DIR + File.separator + "src";
        String moduleLoc = directory + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "p1" + File.separator + "p2", "t3.java", "package p1.p2;\npublic class t3 {\n}\n");
        moduleLoc = directory + File.separator + "mod.two";
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.two { \n\texports p1.p2.t3;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "p1" + File.separator + "p2" + File.separator + "t3", "t4.java", "package p1.p2.t3;\npublic class t4 {\n}\n");
        moduleLoc = directory + File.separator + "mod.three";
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.three { \n\trequires mod.one;\n\trequires mod.two;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "po", "Client.java", "package po;\npublic class Client {\n\t p1.p2.t3.t4 f;\n}\n");
        StringBuilder buffer = new StringBuilder();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" --module-source-path \"" + directory + "\"");
        this.runConformModuleTest(files, buffer, "", "");
    }

    public void testBug519922() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = OUTPUT_DIR + File.separator + "src";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, directory + File.separator + "test", "Test.java", "package test;\n\npublic class Test implements org.eclipse.SomeInterface {\n}\n");
        StringBuilder buffer = new StringBuilder();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ");
        this.runNegativeModuleTest(files, buffer, "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/test/Test.java (at line 3)\n\tpublic class Test implements org.eclipse.SomeInterface {\n\t                             ^^^^^^^^^^^\norg.eclipse cannot be resolved to a type\n----------\n1 problem (1 error)\n", "does not exist");
    }

    public void testMixedSourcepath() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = OUTPUT_DIR + File.separator + "src";
        String moduleLoc = directory + File.separator + "mod" + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one {\n\texports p.q;\n}");
        StringBuilder buffer = new StringBuilder();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\"").append(" -sourcepath \"" + directory + "\" ").append(" --module-source-path \"" + directory + File.separator + "mod\" ").append(" --add-reads mod.one=ALL-UNNAMED ");
        this.runNegativeModuleTest(files, buffer, "", "cannot specify both -source-path and --module-source-path\n", "cannot specify both");
    }

    public void testAPILeakDetection1() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = OUTPUT_DIR + File.separator + "src";
        String moduleLoc = directory + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n\texports p.exp;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "p" + File.separator + "exp", "C1.java", "package p.exp;\nimport p.priv.*;\nclass C0 {\n\tpublic void test(C0 c) {}\n}\npublic class C1 {\n\tpublic C2 f;\n\tpublic void test1(C0 c) {}\n\tpublic void test2(C2 c) {}\n\tprotected void test3(C0 c) {}\n\tprotected void test4(C2 c) {}\n\tpublic p.priv.C2 test5() { return null; }\n}\n");
        this.writeFileCollecting(files, moduleLoc + File.separator + "p" + File.separator + "priv", "C2.java", "package p.priv;\npublic class C2 {\n}\n");
        StringBuilder buffer = new StringBuilder();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" -err:exports").append(" --module-source-path \"" + directory + "\"");
        this.runNegativeModuleTest(files, buffer, "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.one/p/exp/C1.java (at line 7)\n\tpublic C2 f;\n\t       ^^\nThe type C2 is not exported from this module\n----------\n2. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.one/p/exp/C1.java (at line 8)\n\tpublic void test1(C0 c) {}\n\t                  ^^\nThe type C0 is not accessible to clients that require this module\n----------\n3. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.one/p/exp/C1.java (at line 9)\n\tpublic void test2(C2 c) {}\n\t                  ^^\nThe type C2 is not exported from this module\n----------\n4. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.one/p/exp/C1.java (at line 12)\n\tpublic p.priv.C2 test5() { return null; }\n\t       ^^^^^^^^^\nThe type C2 is not exported from this module\n----------\n4 problems (4 errors)\n", "is not exported");
    }

    public void testAPILeakDetection2() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = OUTPUT_DIR + File.separator + "src";
        String moduleLoc = directory + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n\texports p.exp;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "p" + File.separator + "exp", "C1.java", "package p.exp;\nimport java.util.*;\nclass C0 {\n\tpublic void test(C0 c) {}\n}\npublic class C1 {\n\tpublic List<C0> f1;\n\tpublic C0[] f2;\n}\n");
        StringBuilder buffer = new StringBuilder();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" -err:+exports").append(" --module-source-path \"" + directory + "\"");
        this.runNegativeModuleTest(files, buffer, "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.one/p/exp/C1.java (at line 7)\n\tpublic List<C0> f1;\n\t            ^^\nThe type C0 is not accessible to clients that require this module\n----------\n2. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.one/p/exp/C1.java (at line 8)\n\tpublic C0[] f2;\n\t       ^^\nThe type C0 is not accessible to clients that require this module\n----------\n2 problems (2 errors)\n", "not accessible to clients");
    }

    public void testAPILeakDetection3() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = OUTPUT_DIR + File.separator + "src";
        String moduleLoc = directory + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n\texports p.exp;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "p" + File.separator + "exp", "C1.java", "package p.exp;\nimport java.util.*;\nclass C0 {\n\tpublic void test(C0 c) {}\n}\npublic class C1 {\n\t@SuppressWarnings(\"exports\")\n\tpublic List<C0> f1;\n\t@SuppressWarnings(\"exports\")\n\tpublic C0[] f2;\n}\n");
        StringBuilder buffer = new StringBuilder();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" -warn:+exports,+suppress").append(" --module-source-path \"" + directory + "\"");
        this.runConformModuleTest(files, buffer, "", "");
    }

    public void testAPILeakDetection4() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = OUTPUT_DIR + File.separator + "src";
        String moduleLoc = directory + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n\texports p.exp;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "p" + File.separator + "exp", "C1.java", "package p.exp;\npublic class C1 {\n\tstatic class C3 {\n\t\tpublic static class C4 {}\n\t}\n\tpublic C3 f1;\n\tpublic C3.C4 f2;\n}\n");
        StringBuilder buffer = new StringBuilder();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" -err:+exports").append(" --module-source-path \"" + directory + "\"");
        this.runNegativeModuleTest(files, buffer, "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.one/p/exp/C1.java (at line 6)\n\tpublic C3 f1;\n\t       ^^\nThe type C1.C3 is not accessible to clients that require this module\n----------\n2. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.one/p/exp/C1.java (at line 7)\n\tpublic C3.C4 f2;\n\t       ^^^^^\nThe type C1.C3.C4 is not accessible to clients that require this module\n----------\n2 problems (2 errors)\n", "one is not accessible to clients");
    }

    public void testAPILeakDetection5() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = OUTPUT_DIR + File.separator + "src";
        String moduleLoc = directory + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n\texports p.exp1;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "p" + File.separator + "exp1", "C1.java", "package p.exp1;\npublic class C1 {\n}\n");
        moduleLoc = directory + File.separator + "mod.two";
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.two { \n\texports p.exp2;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "p" + File.separator + "exp2", "C2.java", "package p.exp2;\npublic class C2 {\n}\n");
        moduleLoc = directory + File.separator + "mod.three";
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.three { \n\trequires mod.one; // missing transitive\n\trequires transitive mod.two;\n\texports p.exp3;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "p" + File.separator + "exp3", "C3.java", "package p.exp3;\npublic class C3 {\n\tpublic void m1(p.exp1.C1 arg) {}\n\tpublic void m2(p.exp2.C2 arg) {}\n}\n");
        StringBuilder buffer = new StringBuilder();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" -err:+exports").append(" --module-source-path \"" + directory + "\"");
        this.runNegativeModuleTest(files, buffer, "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.three/p/exp3/C3.java (at line 3)\n\tpublic void m1(p.exp1.C1 arg) {}\n\t               ^^^^^^^^^\nThe type C1 from module mod.one may not be accessible to clients due to missing 'requires transitive'\n----------\n1 problem (1 error)\n", "is not indirectly exported");
    }

    public void testAPILeakDetection6() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = OUTPUT_DIR + File.separator + "src";
        String moduleLoc = directory + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n\texports p.exp;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "p" + File.separator + "exp", "C1.java", "package p.exp;\nimport java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@interface ANN {}\nclass C0 {}\npublic class C1 {\n\tpublic @ANN String f1;\n\tpublic @ANN C0 f3;\n\tpublic @ANN String test(@ANN String arg, @ANN C0 c) { return \"\"; }\n}\n");
        StringBuilder buffer = new StringBuilder();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" -err:exports").append(" --module-source-path \"" + directory + "\"");
        this.runNegativeModuleTest(files, buffer, "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.one/p/exp/C1.java (at line 8)\n\tpublic @ANN C0 f3;\n\t            ^^\nThe type C0 is not accessible to clients that require this module\n----------\n2. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.one/p/exp/C1.java (at line 9)\n\tpublic @ANN String test(@ANN String arg, @ANN C0 c) { return \"\"; }\n\t                                              ^^\nThe type C0 is not accessible to clients that require this module\n----------\n2 problems (2 errors)\n", "is not accessible to clients");
    }

    public void testAPILeakDetection7() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = OUTPUT_DIR + File.separator + "src";
        String moduleLoc = directory + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n\texports p.exp;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "p" + File.separator + "exp", "C1.java", "package p.exp;\npublic enum C1 {\n\tX, Y, Z;\n}\n");
        StringBuilder buffer = new StringBuilder();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" -err:exports").append(" --module-source-path \"" + directory + "\"");
        this.runConformModuleTest(files, buffer, "", "");
    }

    public void testBug486013_comment27() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = OUTPUT_DIR + File.separator + "src";
        String projLoc = directory + File.separator + "Proj";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, projLoc + File.separator + "p" + File.separator + "exp", "C1.java", "package p.exp;\nimport java.util.*;\npublic class C1 {\n\tList<?> l;\n}\n");
        StringBuilder buffer = new StringBuilder();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" -err:exports");
        this.runConformModuleTest(files, buffer, "", "");
    }

    public void testBug518295a() {
        Util.flushDirectoryContent(new File(OUTPUT_DIR));
        String outDir = OUTPUT_DIR + File.separator + "bin";
        String srcDir = OUTPUT_DIR + File.separator + "src";
        File modDir = new File(OUTPUT_DIR + File.separator + "mod");
        this.createReusableModules(srcDir, outDir, modDir);
        String moduleLoc = srcDir + File.separator + "mod.three";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.three { \n\trequires mod.one;\n\trequires mod.two;\n}");
        StringBuilder buffer = new StringBuilder();
        buffer.append("-d " + outDir).append(" -9 ").append(" -p \"").append(Util.getJavaClassLibsAsString()).append(modDir.getAbsolutePath()).append("\" ").append("-classNames mod.one/p.XYZ").append(" --module-source-path \"" + srcDir + "\"");
        files.forEach(name -> {
            StringBuilder stringBuilder2 = buffer.append(" \"" + name + "\"");
        });
        this.runNegativeTest(new String[0], buffer.toString(), "", "invalid class name: mod.one/p.XYZ\n", false);
    }

    public void testBug518295b() {
        Util.flushDirectoryContent(new File(OUTPUT_DIR));
        String outDir = OUTPUT_DIR + File.separator + "bin";
        String srcDir = OUTPUT_DIR + File.separator + "src";
        File modDir = new File(OUTPUT_DIR + File.separator + "mod");
        this.createReusableModules(srcDir, outDir, modDir);
        String moduleLoc = srcDir + File.separator + "mod.three";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.three { \n\trequires mod.one;\n\trequires mod.two;\n}");
        StringBuilder buffer = new StringBuilder();
        buffer.append("-d " + outDir).append(" -9 ").append(" -p \"").append(Util.getJavaClassLibsAsString()).append(modDir.getAbsolutePath()).append("\" ").append("-classNames mod.xyz/p.X").append(" --module-source-path \"" + srcDir + "\"");
        files.forEach(name -> {
            StringBuilder stringBuilder2 = buffer.append(" \"" + name + "\"");
        });
        this.runNegativeTest(new String[0], buffer.toString(), "", "invalid module name: mod.xyz\n", false);
    }

    public void testBug518295c() {
        Util.flushDirectoryContent(new File(OUTPUT_DIR));
        String outDir = OUTPUT_DIR + File.separator + "bin";
        String srcDir = OUTPUT_DIR + File.separator + "src";
        File modDir = new File(OUTPUT_DIR + File.separator + "mod");
        this.createReusableModules(srcDir, outDir, modDir);
        String moduleLoc = srcDir + File.separator + "mod.three";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.three { \n\trequires mod.one;\n\trequires mod.two;\n}");
        StringBuilder buffer = new StringBuilder();
        buffer.append("-d " + outDir).append(" -9 ").append(" -p \"").append(Util.getJavaClassLibsAsString()).append(modDir.getAbsolutePath()).append("\" ").append("-classNames mod.one/p.X").append(" --module-source-path \"" + srcDir + "\"");
        this.runConformModuleTest(files, buffer, "", "");
    }

    public void testUnnamedPackage_Bug520839() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = OUTPUT_DIR + File.separator + "src";
        String moduleLoc = directory + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n\trequires java.base;\n}");
        this.writeFileCollecting(files, moduleLoc, "X.java", "public class X {\n}");
        StringBuilder buffer = new StringBuilder();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" --module-source-path \"" + directory + "\"");
        this.runNegativeModuleTest(files, buffer, "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.one/X.java (at line 1)\n\tpublic class X {\n\t^\nMust declare a named package because this compilation unit is associated to the named module 'mod.one'\n----------\n1 problem (1 error)\n", "unnamed package is not allowed in named modules");
    }

    public void testAutoModule1() throws Exception {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String[] sources = new String[]{"p/a/X.java", "package p.a;\npublic class X {}\n;"};
        String jarPath = OUTPUT_DIR + File.separator + "lib-x.jar";
        Util.createJar(sources, jarPath, "1.8");
        String out = "bin";
        String directory = OUTPUT_DIR + File.separator + "src";
        String moduleLoc = directory + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n\trequires lib.x;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "q", "X.java", "package q;\npublic class X {\n\tp.a.X f;\n}");
        StringBuilder buffer = new StringBuilder();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" -info:+module ").append(" --module-path \"" + jarPath + "\"");
        this.runConformModuleTest(files, buffer, "", "----------\n1. INFO in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.one/module-info.java (at line 2)\n\trequires lib.x;\n\t         ^^^^^\nName of automatic module 'lib.x' is unstable, it is derived from the module's file name.\n----------\n1 problem (1 info)\n");
    }

    public void testBug521458a() {
        Util.flushDirectoryContent(new File(OUTPUT_DIR));
        String outDir = OUTPUT_DIR + File.separator + "bin";
        String srcDir = OUTPUT_DIR + File.separator + "src";
        File modDir = new File(OUTPUT_DIR + File.separator + "mod");
        this.createReusableModules(srcDir, outDir, modDir);
        String moduleLoc = srcDir + File.separator + "mod.three";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod._3_ { \n\trequires mod.one;\n\trequires mod.two;\n}");
        StringBuilder buffer = new StringBuilder();
        buffer.append("-d " + outDir).append(" -9 ").append(" -p \"").append(Util.getJavaClassLibsAsString()).append(modDir.getAbsolutePath()).append("\" ").append("-classNames mod.one/p.X").append(" --module-source-path \"" + srcDir + "\"");
        this.runNegativeModuleTest(files, buffer, "", "module name mod._3_ does not match expected name mod.three\n", "does not match expected name");
    }

    public void _testBug521458b() {
        Util.flushDirectoryContent(new File(OUTPUT_DIR));
        String outDir = OUTPUT_DIR + File.separator + "bin";
        String srcDir = OUTPUT_DIR + File.separator + "src";
        File modDir = new File(OUTPUT_DIR + File.separator + "mod");
        this.createReusableModules(srcDir, outDir, modDir);
        String moduleLoc = srcDir + File.separator + "mod.three";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.3 { \n\trequires mod.one;\n\trequires mod.two;\n}");
        StringBuilder buffer = new StringBuilder();
        buffer.append("-d " + outDir).append(" -9 ").append(" -p \"").append(Util.getJavaClassLibsAsString()).append(modDir.getAbsolutePath()).append("\" ").append("-classNames mod.one/p.X").append(" --module-source-path \"" + srcDir + "\"");
        this.runNegativeModuleTest(files, buffer, "", "module name mod.3 does not match expected name mod.three\r\n", outDir);
    }

    public void testBug521362_emptyFile() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = OUTPUT_DIR + File.separator + "src";
        String moduleLoc = directory + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n\texports p1;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "p1", "X.java", "");
        StringBuilder buffer = new StringBuilder();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" --module-source-path \"" + directory + "\"");
        this.runNegativeModuleTest(files, buffer, "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.one/module-info.java (at line 2)\n\texports p1;\n\t        ^^\nThe package p1 does not exist or is empty\n----------\n1 problem (1 error)\n", "empty");
    }

    public void testBug521362_mismatchingdeclaration() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = OUTPUT_DIR + File.separator + "src";
        String moduleLoc = directory + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n\texports p1;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "p1", "X.java", "package q;\n");
        StringBuilder buffer = new StringBuilder();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" --module-source-path \"" + directory + "\"");
        this.runNegativeModuleTest(files, buffer, "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.one/module-info.java (at line 2)\n\texports p1;\n\t        ^^\nThe package p1 does not exist or is empty\n----------\n1 problem (1 error)\n", "package is empty");
    }

    public void testBug521362_multiplePackages() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = OUTPUT_DIR + File.separator + "src";
        String moduleLoc = directory + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n\texports p1;\n\texports p2;\n\texports p3;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "p1", "X.java", "package q;\n");
        this.writeFileCollecting(files, moduleLoc + File.separator + "p2", "X.java", "package q2;\n");
        this.writeFileCollecting(files, moduleLoc + File.separator + "p3", "X.java", "package p3;\n");
        StringBuilder buffer = new StringBuilder();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" --module-source-path \"" + directory + "\"");
        this.runNegativeModuleTest(files, buffer, "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.one/module-info.java (at line 2)\n\texports p1;\n\t        ^^\nThe package p1 does not exist or is empty\n----------\n2. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.one/module-info.java (at line 3)\n\texports p2;\n\t        ^^\nThe package p2 does not exist or is empty\n----------\n2 problems (2 errors)\n", "package is empty");
    }

    public void testBug521362_multiplePackages2() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = OUTPUT_DIR + File.separator + "src";
        String moduleLoc = directory + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n\texports p1;\n\texports p2;\n\texports p3.p4.p5;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "p1", "X.java", "package q;\n");
        this.writeFileCollecting(files, moduleLoc + File.separator + "p2", "X.java", "package q2;\n");
        this.writeFileCollecting(files, moduleLoc + File.separator + "p3" + File.separator + "p4" + File.separator + "p5", "X.java", "package p3.p4.p5;\n");
        StringBuilder buffer = new StringBuilder();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" --module-source-path \"" + directory + "\"");
        this.runNegativeModuleTest(files, buffer, "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.one/module-info.java (at line 2)\n\texports p1;\n\t        ^^\nThe package p1 does not exist or is empty\n----------\n2. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.one/module-info.java (at line 3)\n\texports p2;\n\t        ^^\nThe package p2 does not exist or is empty\n----------\n2 problems (2 errors)\n", "package is empty");
    }

    public void testBug500170a() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String directory = this.getSourceDir();
        String moduleLoc = directory + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n\trequires java.sql;\n}");
        StringBuilder buffer = new StringBuilder();
        buffer.append("-d " + this.getEcjOutputDir()).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" --module-source-path \"" + directory + "\" ").append(moduleLoc + File.separator + "module-info.java");
        Set<String> classFiles = this.runConformModuleTest(new String[0], buffer.toString(), "", "", false);
        String fileName = this.getEcjOutputDir() + File.separator + "mod.one" + File.separator + "module-info.class";
        this.assertClassFile("Missing modul-info.class: " + fileName, fileName, classFiles);
    }

    public void testBug500170b() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = OUTPUT_DIR + File.separator + "src";
        String moduleLoc = directory + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n\trequires java.sql;\n}");
        StringBuilder buffer = new StringBuilder();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -8").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ");
        this.runNegativeModuleTest(files, buffer, "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.one/module-info.java (at line 1)\n\tmodule mod.one { \n\t^^^^^^\nSyntax error on token(s), misplaced construct(s)\n----------\n2. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.one/module-info.java (at line 1)\n\tmodule mod.one { \n\t^^^^^^^^^^^^^^\nSyntax error on token(s), misplaced construct(s)\n----------\n3. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.one/module-info.java (at line 2)\n\trequires java.sql;\n\t             ^\nSyntax error on token \".\", , expected\n----------\n4. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.one/module-info.java (at line 3)\n\t}\n\t^\nSyntax error on token \"}\", delete this token\n----------\n4 problems (4 errors)\n", "modules are not supported");
    }

    public void testBug522472c() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = OUTPUT_DIR + File.separator + "src";
        File srcDir = new File(directory);
        String moduleLoc = directory + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n\texports x.y.z;\n\texports a.b.c;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "x" + File.separator + "y" + File.separator + "z", "X.java", "package x.y.z;\n");
        this.writeFileCollecting(files, moduleLoc + File.separator + "a" + File.separator + "b" + File.separator + "c", "A.java", "package a.b.c;\npublic class A {}");
        moduleLoc = directory + File.separator + "mod.one.a";
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one.a { \n\texports x.y.z;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "x" + File.separator + "y" + File.separator + "z", "X.java", "package x.y.z;\npublic class X {}\n");
        StringBuilder buffer = new StringBuilder();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" --module-source-path \"" + directory + "\" ");
        this.runConformModuleTest(files, buffer, "", "");
        Util.flushDirectoryContent(srcDir);
        files.clear();
        moduleLoc = directory + File.separator + "mod.two";
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.two { \n\trequires mod.one;\n\trequires mod.one.a;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "p" + File.separator + "q" + File.separator + "r", "Main.java", "package p.q.r;\nimport a.b.c.*;\nimport x.y.z.*;\n@SuppressWarnings(\"unused\")\npublic class Main {}");
        buffer = new StringBuilder();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" --module-path \"" + OUTPUT_DIR + File.separator + out + "\" ").append(" --module-source-path \"" + directory + "\" ");
        this.runNegativeModuleTest(files, buffer, "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.two/module-info.java (at line 2)\n\trequires mod.one;\n\t^^^^^^^^^^^^^^^^\nThe package x.y.z is accessible from more than one module: mod.one, mod.one.a\n----------\n2. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.two/module-info.java (at line 3)\n\trequires mod.one.a;\n\t^^^^^^^^^^^^^^^^^^\nThe package x.y.z is accessible from more than one module: mod.one, mod.one.a\n----------\n2 problems (2 errors)\n", "module mod.two reads package x.y.z from both mod.one and mod.one.a");
    }

    public void testReleaseOption1() throws Exception {
        this.runConformTest(new String[]{"X.java", "/** */\npublic class X {\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\" --release 8 -d \"" + OUTPUT_DIR + "\"", "", "", true);
        String expectedOutput = "// Compiled from X.java (version 1.8 : 52.0, super bit)";
        this.checkDisassembledClassFile(OUTPUT_DIR + File.separator + "X.class", "X", expectedOutput);
    }

    public void testReleaseOption2() throws Exception {
        if (!isJRE17Plus) {
            return;
        }
        this.runConformTest(new String[]{"X.java", "/** */\npublic class X {\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\" --release 10 -d \"" + OUTPUT_DIR + "\"", "", "", true);
        String expectedOutput = "// Compiled from X.java (version 10 : 54.0, super bit)";
        this.checkDisassembledClassFile(OUTPUT_DIR + File.separator + "X.class", "X", expectedOutput);
    }

    public void testReleaseOption3() throws Exception {
        if (!isJRE17Plus) {
            return;
        }
        this.runConformTest(new String[]{"X.java", "/** */\npublic class X {\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\" --release 10 -d \"" + OUTPUT_DIR + "\"", "", "", true);
        String expectedOutput = "// Compiled from X.java (version 10 : 54.0, super bit)";
        this.checkDisassembledClassFile(OUTPUT_DIR + File.separator + "X.class", "X", expectedOutput);
    }

    public void testReleaseOption4() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "/** */\npublic class X {\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\" --release 8 -source 1.6 -d \"" + OUTPUT_DIR + "\"", "", "option -source is not supported when --release is used\n", true);
    }

    public void testReleaseOption5() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "/** */\npublic class X {\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\" --release 8 -target 1.8 -d \"" + OUTPUT_DIR + "\"", "", "option -target is not supported when --release is used\n", true);
    }

    public void testReleaseOption6() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "/** */\npublic class X {\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\" --release 5 -d \"" + OUTPUT_DIR + "\"", "", "release 5 is not found in the system\n", true);
    }

    public void testReleaseOption7() throws Exception {
        this.runConformTest(new String[]{"X.java", "import java.util.stream.*;\n/** */\npublic class X {\n\tpublic Stream<String> emptyStream() {\n\t\tStream<String> st = Stream.empty();\n\t\treturn st;\n\t}\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\" --release 8 -d \"" + OUTPUT_DIR + "\"", "", "", true);
    }

    public void testReleaseOption8() throws Exception {
        if (isJRE20Plus) {
            return;
        }
        String output = "\tpublic java.util.SequencedCollection<String> emptyCollection() {\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\njava.util.SequencedCollection cannot be resolved to a type\n";
        this.runNegativeTest(new String[]{"X.java", "/** */\npublic class X {\n\tpublic java.util.SequencedCollection<String> emptyCollection() {\n\t\treturn null;\n\t}\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\" --release 8 -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 3)\n" + output + "----------\n1 problem (1 error)\n", true);
    }

    public void testReleaseOption9() throws Exception {
        if (isJRE20Plus) {
            return;
        }
        this.runNegativeTest(new String[]{"X.java", "interface I {\n  int add(int x, int y);\n}\npublic class X {\n  public static void main(String[] args) {\n    String i = \"\"\"\n    \t\t\"\"\";\n  }\n}\n"}, "\"" + OUTPUT_DIR + File.separator + "X.java\" --release 8 -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 6)\n\tString i = \"\"\"\n    \t\t\"\"\";\n\t           ^^^^^^^^^^^^^\nThe Java feature 'Text Blocks' is only available with source level 15 and above\n----------\n1 problem (1 error)\n", true);
    }

    public void testReleaseOption10() throws Exception {
        if (isJRE12Plus) {
            return;
        }
        this.runNegativeTest(new String[]{"X.java", "import java.io.*;\n\npublic class X {\n\tpublic static void main(String[] args) {\n\t\ttry {\n\t\t\tSystem.out.println();\n\t\t\tReader r = new FileReader(args[0]);\n\t\t\tr.read();\n\t\t} catch(IOException | FileNotFoundException e) {\n\t\t\te.printStackTrace();\n\t\t}\n\t}\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\" --release 8 -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 9)\n\t} catch(IOException | FileNotFoundException e) {\n\t        ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nMulti-catch parameters are not allowed for source level below 1.7\n----------\n2. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 9)\n\t} catch(IOException | FileNotFoundException e) {\n\t                      ^^^^^^^^^^^^^^^^^^^^^\nThe exception FileNotFoundException is already caught by the alternative IOException\n----------\n2 problems (2 errors)\n", true);
    }

    public void testReleaseOption11() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t}\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\" -bootclasspath " + OUTPUT_DIR + File.separator + "src  --release 9 -d \"" + OUTPUT_DIR + "\"", "", "option -bootclasspath not supported at compliance level 9 and above\n", true);
    }

    public void _testReleaseOption12() throws Exception {
        String javaHome = System.getProperty("java.home");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t}\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\" --system \"" + javaHome + "\" --release 8 -d \"" + OUTPUT_DIR + "\"", "", "----------\noption --system not supported below compliance level 9", true);
    }

    public void testReleaseOption13() {
        this.runConformModuleTest(new String[]{"p/X.java", "package p;\npublic class X {\n\tpublic static void main(String[] args) {\n\t}\n}", "module-info.java", "module mod.one { \n\trequires java.base;\n}"}, " --release 9 \"" + OUTPUT_DIR + File.separator + "module-info.java\" \"" + OUTPUT_DIR + File.separator + "p/X.java\"", "", "", true);
    }

    public void testReleaseOption13a() {
        AbstractModuleCompilationTest.Runner runner = new AbstractModuleCompilationTest.Runner();
        runner.createFile(OUTPUT_DIR + File.separator + "p", "X.java", "package p;\npublic class X {\n\tpublic static void main(String[] args) {\n\t}\n}");
        runner.createFile(OUTPUT_DIR, "module-info.java", "module mod.one { \n\trequires java.base;\n}");
        runner.commandLine.append(" --release 10");
        runner.javacTestOptions = new AbstractRegressionTest.JavacTestOptions(0x360000L);
        runner.runConformModuleTest();
    }

    public void testReleaseOption14() {
        this.runNegativeModuleTest(new String[]{"module-info.java", "module mod.one { \n}"}, " --release 8 \"" + this.getSourceDir() + File.separator + "module-info.java\" ", "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/module-info.java (at line 1)\n\tmodule mod.one { \n\t^^^^^^\nSyntax error on token(s), misplaced construct(s)\n----------\n2. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/module-info.java (at line 1)\n\tmodule mod.one { \n\t           ^^^\nSyntax error, insert \"Identifier (\" to complete MethodHeaderName\n----------\n3. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/module-info.java (at line 1)\n\tmodule mod.one { \n\t           ^^^\nSyntax error, insert \")\" to complete MethodDeclaration\n----------\n3 problems (3 errors)\n", true, "");
    }

    public void testReleaseOption15() {
        AbstractModuleCompilationTest.Runner runner = new AbstractModuleCompilationTest.Runner();
        String fooDir = OUTPUT_DIR + File.separator + "foo";
        runner.createFile(fooDir, "Module.java", "package foo;\npublic class Module {}\n");
        runner.createFile(fooDir, "X.java", "package foo;\npublic class X { \n\tpublic Module getModule(String name) {\n\t\treturn null;\n\t}\n}");
        runner.commandLine.append(" --release 8 ");
        runner.javacTestOptions = AbstractRegressionTest.JavacTestOptions.Excuse.JavacHasWarningsEclipseNotConfigured;
        runner.runConformModuleTest();
    }

    public void testReleaseOption16() {
        this.runNegativeModuleTest(new String[]{"foo/Module.java", "package foo;\npublic class Module {}\n", "bar/X.java", "package bar;\nimport foo.*;\npublic class X { \n\tpublic Module getModule(String name) {\n\t\treturn null;\n\t}\n}"}, " -source 9 \"" + this.getSourceDir() + File.separator + "foo" + File.separator + "Module.java\" \"" + this.getSourceDir() + File.separator + "bar" + File.separator + "X.java\" ", "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/bar/X.java (at line 4)\n\tpublic Module getModule(String name) {\n\t       ^^^^^^\nThe type Module is ambiguous\n----------\n1 problem (1 error)\n", true, "");
    }

    public void testReleaseOption17() {
        this.runNegativeModuleTest(new String[]{"foo/Module.java", "package foo;\npublic class Module {}\n", "foo/X.java", "package foo;\npublic class X { \n\tpublic Module getModule(String name) {\n\t\treturn null;\n\t}\n}"}, " --release 60 \"" + OUTPUT_DIR + File.separator + "foo" + File.separator + "Module.java\" \"" + OUTPUT_DIR + File.separator + "foo" + File.separator + "X.java\" ", "", "release version 60 is not supported\n", true, "");
    }

    public void testReleaseOption18() {
        this.runNegativeModuleTest(new String[]{"X.java", "/** */\npublic class X {\n}"}, " --release 6 -1.8 \"" + OUTPUT_DIR + File.separator + "foo" + File.separator + "Module.java\" \"" + OUTPUT_DIR + File.separator + "foo" + File.separator + "X.java\" ", "", "option 1.8 is not supported when --release is used\n", true, "");
    }

    public void testReleaseOption19() {
        this.runNegativeModuleTest(new String[]{"X.java", "/** */\npublic class X {\n}"}, " -9 --release 9 \"" + OUTPUT_DIR + File.separator + "foo" + File.separator + "Module.java\" \"" + OUTPUT_DIR + File.separator + "foo" + File.separator + "X.java\" ", "", "option 9 is not supported when --release is used\n", true, "");
    }

    public void testReleaseOption20() throws Exception {
        if (!isJRE12Plus || isJRE20Plus) {
            return;
        }
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\n\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tString[] strings = List.of(\"\").toArray(String[]::new);\n\t}\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\" --release 8 -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 5)\n\tString[] strings = List.of(\"\").toArray(String[]::new);\n\t                        ^^\nThe method of(String) is undefined for the type List\n----------\n1 problem (1 error)\n", true);
    }

    public void testReleaseOption21() throws Exception {
        if (!isJRE12Plus) {
            return;
        }
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tInteger.toUnsignedString(1, 1);\n\t}\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\" --release 8 -d \"" + OUTPUT_DIR + "\"", "", "", true);
    }

    public void testReleaseOption22() {
        if (isJRE11Plus || isJRE12Plus) {
            return;
        }
        this.runConformTest(new String[]{"p/X.java", "package p;\npublic class X {\n\tpublic static void main(String[] args) {\n\t}\n}", "module-info.java", "module mod.one { \n\trequires java.base;\n\trequires java.xml.ws.annotation;\n}"}, " --limit-modules java.base,java.xml.ws.annotation  --release 10 \"" + OUTPUT_DIR + File.separator + "module-info.java\" \"" + OUTPUT_DIR + File.separator + "p/X.java\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/module-info.java (at line 3)\n\trequires java.xml.ws.annotation;\n\t         ^^^^^^^^^^^^^^^^^^^^^^\nThe module java.xml.ws.annotation has been deprecated since version 9 and marked for removal\n----------\n1 problem (1 warning)\n", true);
    }

    public void testReleaseOption23() {
        if (!isJRE11Plus) {
            return;
        }
        this.runNegativeTest(new String[]{"p/X.java", "package p;\npublic class X {\n\tpublic static void main(String[] args) {\n\t}\n}", "module-info.java", "module mod.one { \n\trequires java.xml.ws.annotation;\n}"}, " --limit-modules java.base,java.xml.ws.annotation  --release 11 \"" + OUTPUT_DIR + File.separator + "module-info.java\" \"" + OUTPUT_DIR + File.separator + "p/X.java\"", "", "invalid module name: java.xml.ws.annotation\n", true);
    }

    public void testReleaseOption24() {
        if (!isJRE11Plus) {
            return;
        }
        this.runNegativeTest(new String[]{"p/X.java", "package p;\npublic class X {\n\tpublic static void main(String[] args) {\n\t}\n}", "module-info.java", "module mod.one { \n\trequires java.xml.ws.annotation;\n}"}, " --limit-modules java.base,java.xml.ws.annotation  --release 12 \"" + OUTPUT_DIR + File.separator + "module-info.java\" \"" + OUTPUT_DIR + File.separator + "p/X.java\"", "", "invalid module name: java.xml.ws.annotation\n", true);
    }

    public void testLimitModules1() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = OUTPUT_DIR + File.separator + "src";
        String moduleLoc = directory + File.separator + "mod.x";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.x { \n\texports pm;\n\trequires java.sql;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "pm", "C1.java", "package pm;\npublic class C1 {\n}\n");
        StringBuilder buffer = new StringBuilder();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" --limit-modules java.base").append(" --module-source-path \"" + directory + "\"");
        this.runNegativeModuleTest(files, buffer, "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.x/module-info.java (at line 3)\n\trequires java.sql;\n\t         ^^^^^^^^\njava.sql cannot be resolved to a module\n----------\n1 problem (1 error)\n", "module not found");
    }

    public void testLimitModules2() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = OUTPUT_DIR + File.separator + "src";
        String moduleLoc = directory + File.separator + "mod.x";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.x { \n\texports pm;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "pm", "C1.java", "package pm;\nimport java.sql.Connection;\npublic class C1 {\n}\n");
        StringBuilder buffer = new StringBuilder();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" --limit-modules java.base").append(" --module-source-path \"" + directory + "\"");
        this.runNegativeModuleTest(files, buffer, "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.x/pm/C1.java (at line 2)\n\timport java.sql.Connection;\n\t       ^^^^^^^^\nThe import java.sql cannot be resolved\n----------\n1 problem (1 error)\n", "is not visible");
    }

    public void testLimitModules3() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = OUTPUT_DIR + File.separator + "src";
        String moduleLoc = directory + File.separator + "mod.x";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.x { \n\texports pm;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "pm", "C1.java", "package pm;\npublic class C1 {\n}\n");
        StringBuilder buffer = new StringBuilder();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" --limit-modules java.sql").append(" --module-source-path \"" + directory + "\"");
        this.runConformModuleTest(files, buffer, "", "");
    }

    public void testLimitModules4() {
        Util.flushDirectoryContent(new File(OUTPUT_DIR));
        String outDir = OUTPUT_DIR + File.separator + "bin";
        String srcDir = OUTPUT_DIR + File.separator + "src";
        File modDir = new File(OUTPUT_DIR + File.separator + "mod");
        this.createReusableModules(srcDir, outDir, modDir);
        String moduleLoc = srcDir + File.separator + "mod.three";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.three { \n\trequires mod.one;\n\trequires mod.two;\n}");
        StringBuilder buffer = new StringBuilder();
        buffer.append("-d " + outDir).append(" -9 ").append(" --module-path \"").append(Util.getJavaClassLibsAsString()).append(modDir.getAbsolutePath()).append("\" ").append(" --limit-modules mod.one,mod.two ").append(" --module-source-path \"" + srcDir + "\" ");
        this.runConformModuleTest(files, buffer, "", "");
    }

    public void testLimitModules5() {
        Util.flushDirectoryContent(new File(OUTPUT_DIR));
        String outDir = OUTPUT_DIR + File.separator + "bin";
        String srcDir = OUTPUT_DIR + File.separator + "src";
        File modDir = new File(OUTPUT_DIR + File.separator + "mod");
        this.createReusableModules(srcDir, outDir, modDir);
        String moduleLoc = srcDir + File.separator + "mod.three";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.three { \n\trequires mod.one;\n\trequires mod.two;\n}");
        StringBuilder buffer = new StringBuilder();
        buffer.append("-d " + outDir).append(" -9 ").append(" --module-path \"").append(Util.getJavaClassLibsAsString()).append(modDir.getAbsolutePath()).append("\" ").append(" --limit-modules mod.one ").append(" --module-source-path \"" + srcDir + "\" ");
        this.runNegativeModuleTest(files, buffer, "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.three/module-info.java (at line 3)\n\trequires mod.two;\n\t         ^^^^^^^\nmod.two cannot be resolved to a module\n----------\n1 problem (1 error)\n", "");
    }

    public void testBug519600() {
        Util.flushDirectoryContent(new File(OUTPUT_DIR));
        String outDir = OUTPUT_DIR + File.separator + "bin";
        String srcDir = OUTPUT_DIR + File.separator + "src";
        String moduleLoc = srcDir + File.separator + "test";
        AbstractModuleCompilationTest.Runner runner = new AbstractModuleCompilationTest.Runner();
        runner.createFile(moduleLoc, "module-info.java", "module test {}");
        runner.createFile(moduleLoc + File.separator + "test", "Thing.java", "package test;\nimport java.util.Comparator;\nimport java.util.Iterator;\npublic abstract class Thing implements Iterator<Object> {\n    void breaking() {\n        remove(); // allowed (good)\n        Iterator.super.remove(); // not 1.7-compliant (must be an error)\n        Comparator.naturalOrder(); // not 1.7-compliant (bad error message)\n    }\n}\n");
        runner.commandLine.append("-d " + outDir).append(" -source 9 ").append(" --module-source-path \"" + srcDir + "\" ");
        runner.javacVersionOptions = "-Xlint:-options";
        runner.runConformModuleTest();
    }

    public void testBug508889_001() throws Exception {
        this.runConformTest(new String[]{"module-info.java", "module mymodule {\n}"}, "\"" + OUTPUT_DIR + File.separator + "module-info.java\" -9 -source 9 -target 9 -d \"" + OUTPUT_DIR + "\"", "", "", true);
        String expectedOutput = "// Compiled from module-info.java (version 9 : 53.0, no super bit)\n module mymodule  {\n  // Version: \n\n  requires java.base;\n\n}";
        this.checkDisassembledClassFile(OUTPUT_DIR + File.separator + "module-info.class", "module-info", expectedOutput);
    }

    public void testBug508889_002() throws Exception {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = OUTPUT_DIR + File.separator + "src";
        String moduleLoc = directory + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n    exports pack1;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "pack1", "X11.java", "package pack1;\npublic class X11 {\n}");
        StringBuilder buffer = new StringBuilder();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ");
        this.runConformModuleTest(files, buffer, "", "");
        String expectedOutput = "// Compiled from module-info.java (version 9 : 53.0, no super bit)\n module mod.one  {\n  // Version: \n\n  requires java.base;\n\n  exports pack1;\n\n}";
        this.checkDisassembledClassFile(OUTPUT_DIR + File.separator + out + File.separator + "module-info.class", "module-info", expectedOutput);
    }

    public void testBug508889_003() throws Exception {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = OUTPUT_DIR + File.separator + "src";
        String moduleLoc = directory + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n    exports pack1;\n    exports pack2 to second;\n    opens pack3;\n    opens pack4 to third;\n    uses pack5.X51;\n    provides pack1.I11 with pack1.X11;\n    requires transitive java.sql;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "pack1", "I11.java", "package pack1;\npublic interface I11 {\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "pack1", "X11.java", "package pack1;\npublic class X11 implements I11{\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "pack2", "X21.java", "package pack2;\npublic class X21 {\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "pack3", "X31.java", "package pack3;\npublic class X31 {\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "pack4", "X41.java", "package pack4;\npublic class X41 {\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "pack5", "X51.java", "package pack5;\npublic class X51 {\n}");
        StringBuilder buffer = new StringBuilder();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ");
        files.forEach(name -> {
            StringBuilder stringBuilder2 = buffer.append(" \"" + name + "\"");
        });
        this.runConformTest(new String[0], buffer.toString(), "", "", false);
        String expectedOutput = "// Compiled from module-info.java (version 9 : 53.0, no super bit)\n module mod.one  {\n  // Version: \n\n  requires transitive java.sql;\n  requires java.base;\n\n  exports pack1;\n  exports pack2 to second;\n\n  opens pack3;\n  opens pack4 to third;\n\n  uses pack5.X51\n\n  provides pack1.I11 with pack1.X11;\n\n}";
        this.checkDisassembledClassFile(OUTPUT_DIR + File.separator + out + File.separator + "module-info.class", "module-info", expectedOutput);
    }

    public void testBug520858() {
        Util.flushDirectoryContent(new File(OUTPUT_DIR));
        String outDir = OUTPUT_DIR + File.separator + "bin";
        String srcDir = OUTPUT_DIR + File.separator + "src";
        String moduleLoc = srcDir + File.separator + "test";
        AbstractModuleCompilationTest.Runner runner = new AbstractModuleCompilationTest.Runner();
        runner.createFile(moduleLoc, "module-info.java", "module test {\n\trequires org.astro;\n}");
        runner.createFile(moduleLoc + File.separator + "p", "Test.java", "package p;\nimport org.astro.World;\npublic class Test {\n\tWorld w = null;\n}");
        moduleLoc = srcDir + File.separator + "org.astro";
        runner.createFile(moduleLoc, "module-info.java", "module org.astro {\n\texports org.astro;\n}");
        runner.createFile(moduleLoc + File.separator + "org" + File.separator + "astro", "World.java", "package org.astro;\npublic interface World {\n\tpublic static String name() {\n\t\treturn \"\";\n\t}\n}");
        runner.commandLine.append("-d " + outDir).append(" -source 9 ").append(" --module-source-path \"" + srcDir + "\" ");
        runner.javacVersionOptions = " -Xlint:-options";
        runner.runConformModuleTest();
    }

    public void testBug520858a() {
        Util.flushDirectoryContent(new File(OUTPUT_DIR));
        String outDir = OUTPUT_DIR + File.separator + "bin";
        String srcDir = OUTPUT_DIR + File.separator + "src";
        String moduleLoc = srcDir + File.separator + "test";
        AbstractModuleCompilationTest.Runner runner = new AbstractModuleCompilationTest.Runner();
        this.writeFile(moduleLoc, "module-info.java", "module test {\n\trequires org.astro;\n}");
        runner.createFile(moduleLoc + File.separator + "p", "Test.java", "package p;\nimport org.astro.World;\npublic class Test {\n\tWorld w = null;\n}");
        moduleLoc = srcDir + File.separator + "org.astro";
        this.writeFile(moduleLoc, "module-info.java", "module org.astro {\n\texports org.astro;\n}");
        this.writeFile(moduleLoc + File.separator + "org" + File.separator + "astro", "World.java", "package org.astro;\npublic interface World {\n\tpublic static String name() {\n\t\treturn \"\";\n\t}\n}");
        runner.commandLine.append("-d " + outDir).append(" -source 9 ").append(" --module-source-path \"" + srcDir + "\" ");
        runner.javacVersionOptions = " -Xlint:-options";
        runner.runConformModuleTest();
    }

    public void testBug520858b() {
        Util.flushDirectoryContent(new File(OUTPUT_DIR));
        String outDir = OUTPUT_DIR + File.separator + "bin";
        String srcDir = OUTPUT_DIR + File.separator + "src";
        String moduleLoc = srcDir + File.separator + "test";
        AbstractModuleCompilationTest.Runner runner = new AbstractModuleCompilationTest.Runner();
        runner.createFile(moduleLoc, "module-info.java", "module test {\n\trequires org.astro;\n}");
        runner.createFile(moduleLoc + File.separator + "p", "Test.java", "package p;\nimport org.astro.World;\npublic class Test {\n\tWorld w = null;\n}");
        moduleLoc = srcDir + File.separator + "org.astro";
        this.writeFile(moduleLoc, "module-info.java", "module org.astro {\n\texports org.astro;\n}");
        runner.createFile(moduleLoc + File.separator + "org" + File.separator + "astro", "World.java", "package org.astro;\npublic interface World {\n\tpublic static String name() {\n\t\treturn \"\";\n\t}\n}");
        runner.commandLine.append("-d " + outDir).append(" -source 9 ").append(" --module-source-path \"" + srcDir + "\" ");
        runner.javacVersionOptions = " -Xlint:-options";
        runner.runConformModuleTest();
    }

    public void testBug520858c() {
        Util.flushDirectoryContent(new File(OUTPUT_DIR));
        String outDir = OUTPUT_DIR + File.separator + "bin";
        String srcDir = OUTPUT_DIR + File.separator + "src";
        String moduleLoc = srcDir + File.separator + "test";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc + File.separator + "p", "Test.java", "package p;\nimport org.astro.World;\npublic class Test {\n\tWorld w = null;\n}");
        moduleLoc = srcDir + File.separator + "org.astro";
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module org.astro {\n\texports org.astro;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "org" + File.separator + "astro", "World.java", "package org.astro;\npublic interface World {\n\tpublic static String name() {\n\t\treturn \"\";\n\t}\n}");
        StringBuilder buffer = new StringBuilder();
        buffer.append("-d " + outDir).append(" -source 9 ").append(" --module-source-path \"" + srcDir + "\" ");
        this.runNegativeModuleTest(files, buffer, "", "'---OUTPUT_DIR_PLACEHOLDER---/src/test/p/Test.java' does not belong to a module on the module source path\n", "not in a module on the module source path");
    }

    public void testBug520858d() {
        Util.flushDirectoryContent(new File(OUTPUT_DIR));
        String outDir = OUTPUT_DIR + File.separator + "bin";
        String srcDir = OUTPUT_DIR + File.separator + "src";
        String moduleLoc = srcDir + File.separator + "test";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc + File.separator + "p", "Test.java", "package p;\nimport org.astro.World;\npublic class Test {\n\tWorld w = null;\n}");
        moduleLoc = srcDir + File.separator + "org.astro";
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module org.astro {\n\texports org.astro;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "org" + File.separator + "astro", "World.java", "package org.astro;\npublic interface World {\n\tpublic static String name() {\n\t\treturn \"\";\n\t}\n}");
        StringBuilder buffer = new StringBuilder();
        buffer.append("-d " + outDir).append(" -source 9 ").append(" --module-source-path \"" + srcDir + "\" ").append(srcDir + File.separator + "org.astro" + File.separator + "org" + File.separator + "astro" + File.separator + "World.java ").append(srcDir + File.separator + "test" + File.separator + "p" + File.separator + "Test.java");
        this.runNegativeModuleTest(Collections.emptyList(), buffer, "", "'---OUTPUT_DIR_PLACEHOLDER---/src/test/p/Test.java' does not belong to a module on the module source path\n", "not in a module on the module source path");
    }

    public void testBug520858e() {
        Util.flushDirectoryContent(new File(OUTPUT_DIR));
        String outDir = OUTPUT_DIR + File.separator + "bin";
        String srcDir = OUTPUT_DIR + File.separator + "src";
        String moduleLoc = srcDir + File.separator + "test";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc + File.separator + "p", "Test.java", "package p;\nimport org.astro.World;\npublic class Test {\n\tWorld w = null;\n}");
        moduleLoc = srcDir + File.separator + "org.astro";
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module org.astro {\n\texports org.astro;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "org" + File.separator + "astro", "World.java", "package org.astro;\npublic interface World {\n\tpublic static String name() {\n\t\treturn \"\";\n\t}\n}");
        StringBuilder buffer = new StringBuilder();
        buffer.append("-d " + outDir).append(" -source 9 ").append(" --module-source-path \"" + srcDir + "\" ").append(srcDir + File.separator + "org.astro" + File.separator + "org" + File.separator + "astro" + File.separator + "World.java ").append(srcDir + File.separator + "org.astro" + File.separator + "module-info.java ").append(srcDir + File.separator + "test" + File.separator + "p" + File.separator + "Test.java");
        this.runNegativeModuleTest(Collections.emptyList(), buffer, "", "'---OUTPUT_DIR_PLACEHOLDER---/src/test/p/Test.java' does not belong to a module on the module source path\n", "not in a module on the module source path");
    }

    public void testBug530575() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = OUTPUT_DIR + File.separator + "src";
        File srcDir = new File(directory);
        String moduleLoc = directory + File.separator + "mod.x";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.x { \n\texports px;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "px", "C1.java", "package px;\npublic class C1 {\n}\n");
        moduleLoc = directory + File.separator + "mod.y";
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.y { \n\texports py;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "py", "C1.java", "package py;\npublic class C1 {\n}\n");
        StringBuilder buffer = new StringBuilder();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" --module-source-path \"" + directory + "\"");
        for (String fileName : files) {
            buffer.append(" \"").append(fileName).append("\"");
        }
        this.runConformTest(new String[0], buffer.toString(), "", "", false);
        Util.flushDirectoryContent(srcDir);
        files.clear();
        this.writeFileCollecting(files, directory, "module-info.java", "module test { \n\trequires mod.x;\n\trequires mod.y;\n}");
        this.writeFileCollecting(files, directory + File.separator + "p", "X.java", "package p;\npublic class X extends px.C1 { \n\tpy.C1 c = null;\n}");
        buffer = new StringBuilder();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" --module-path \"" + OUTPUT_DIR + File.separator + out + File.separator + "mod.x" + File.pathSeparator + OUTPUT_DIR + File.separator + out + File.separator + "mod.y\"");
        this.runConformModuleTest(files, buffer, "", "");
    }

    public void testBug533411() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = OUTPUT_DIR + File.separator + "src";
        String moduleLoc = directory + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n\trequires java.sql;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "p", "Test.java", "package p;\npublic class Test {\n\tjava.sql.Connection conn = null;\n}");
        StringBuilder buffer = new StringBuilder();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" --module-source-path \"" + directory + "\" ").append(moduleLoc + File.separator + "p" + File.separator + "Test.java");
        Set<String> classFiles = this.runConformModuleTest(new String[0], buffer.toString(), "", "", false);
        String fileName = OUTPUT_DIR + File.separator + out + File.separator + "mod.one" + File.separator + "module-info.class";
        this.assertClassFile("Missing modul-info.class: " + fileName, fileName, classFiles);
    }

    public void test_npe_bug535107() {
        this.runConformModuleTest(new String[]{"p/X.java", "package p;\nimport java.lang.annotation.*;\n@Target(ElementType.MODULE)\npublic @interface X {\n\tElementType value();\n}", "module-info.java", "import java.lang.annotation.*;\n@p.X(ElementType.MODULE)\nmodule mod.one { \n}"}, " -9 \"" + OUTPUT_DIR + File.separator + "module-info.java\" \"" + OUTPUT_DIR + File.separator + "p/X.java\"", "", "", true);
    }

    public void testBug540067a() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = OUTPUT_DIR + File.separator + "src";
        String moduleLoc = directory + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n exports p;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "p", "X.java", "package p;\npublic class X {\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "p" + File.separator + "q", "Test.java", "/*nothing in it */");
        StringBuilder buffer = new StringBuilder();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" --module-source-path \"" + directory + "\" ").append(moduleLoc + File.separator + "module-info.java ").append(moduleLoc + File.separator + "p" + File.separator + "X.java ").append(moduleLoc + File.separator + "p" + File.separator + "q" + File.separator + "Test.java");
        this.runConformModuleTest(new String[0], buffer.toString(), "", "", false);
    }

    public void testBug540067b() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = OUTPUT_DIR + File.separator + "src";
        String moduleLoc = directory + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n exports p;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "p", "X.java", "package p;\npublic class X {\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "p" + File.separator + "q", "Test.java", "package p.q;");
        StringBuilder buffer = new StringBuilder();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" --module-source-path \"" + directory + "\" ").append(moduleLoc + File.separator + "module-info.java ").append(moduleLoc + File.separator + "p" + File.separator + "X.java ").append(moduleLoc + File.separator + "p" + File.separator + "q" + File.separator + "Test.java");
        this.runConformModuleTest(new String[0], buffer.toString(), "", "", false);
    }

    public void testBug540067c() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = OUTPUT_DIR + File.separator + "src";
        String moduleLoc = directory + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n exports p;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "p", "X.java", "package p;\npublic class X {\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "p" + File.separator + "q", "Test.java", "package p.q;\nclass Test {}");
        StringBuilder buffer = new StringBuilder();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" --module-source-path \"" + directory + "\" ").append(moduleLoc + File.separator + "module-info.java ").append(moduleLoc + File.separator + "p" + File.separator + "X.java ").append(moduleLoc + File.separator + "p" + File.separator + "q" + File.separator + "Test.java");
        this.runConformModuleTest(new String[0], buffer.toString(), "", "", false);
    }

    public void testBug540067d() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = OUTPUT_DIR + File.separator + "src";
        String moduleLoc = directory + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n exports p;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "p", "X.java", "package p;\npublic class X {\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "p" + File.separator + "q", "Test.java", "class Test {}");
        StringBuilder buffer = new StringBuilder();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" --module-source-path \"" + directory + "\" ").append(moduleLoc + File.separator + "module-info.java ").append(moduleLoc + File.separator + "p" + File.separator + "X.java ").append(moduleLoc + File.separator + "p" + File.separator + "q" + File.separator + "Test.java");
        this.runNegativeModuleTest(new String[0], buffer.toString(), "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.one/p/q/Test.java (at line 1)\n\tclass Test {}\n\t^\nMust declare a named package because this compilation unit is associated to the named module 'mod.one'\n----------\n1 problem (1 error)\n", false, "unnamed package is not allowed in named modules");
    }

    public void testBug540067e() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = OUTPUT_DIR + File.separator + "src";
        String moduleLoc = directory + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n exports p;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "p", "X.java", "package p;\npublic class X {\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "p" + File.separator + "q", "Test.java", "import java.lang.*;");
        StringBuilder buffer = new StringBuilder();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" -warn:-unused").append(" --module-source-path \"" + directory + "\" ").append(moduleLoc + File.separator + "module-info.java ").append(moduleLoc + File.separator + "p" + File.separator + "X.java ").append(moduleLoc + File.separator + "p" + File.separator + "q" + File.separator + "Test.java");
        this.runNegativeModuleTest(new String[0], buffer.toString(), "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.one/p/q/Test.java (at line 1)\n\timport java.lang.*;\n\t^\nMust declare a named package because this compilation unit is associated to the named module 'mod.one'\n----------\n1 problem (1 error)\n", false, "unnamed package is not allowed in named modules");
    }

    public void testBug548195() {
        IClassFileAttribute[] attrs;
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = OUTPUT_DIR + File.separator + "src";
        String moduleLoc = directory + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n exports p;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "p", "X.java", "package p;\npublic class X {\n}");
        StringBuilder buffer = new StringBuilder();
        String binDir = OUTPUT_DIR + File.separator + out;
        buffer.append("-d " + binDir).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" -warn:-unused").append(" --module-source-path \"" + directory + "\" ").append(" --module-version 47.11 ");
        String outText = isJRE9Plus ? "" : "Could not invoke method java.lang.module.ModuleDescriptor.Version.parse(), cannot validate module version.\n";
        this.runConformModuleTest(files, buffer, outText, "");
        IClassFileReader cfr = ToolFactory.createDefaultClassFileReader((String)(binDir + File.separator + "mod.one" + File.separator + "module-info.class"), (int)17);
        ModuleCompilationTests.assertNotNull((String)"Error reading module-info.class", (Object)cfr);
        IClassFileAttribute[] iClassFileAttributeArray = attrs = cfr.getAttributes();
        int n = attrs.length;
        int n2 = 0;
        while (n2 < n) {
            IClassFileAttribute attr = iClassFileAttributeArray[n2];
            char[] name = attr.getAttributeName();
            if (CharOperation.equals((char[])name, (char[])AttributeNamesConstants.ModuleName)) {
                IModuleAttribute modAttr = (IModuleAttribute)attr;
                String expectedVersion = isJRE9Plus ? "47.11" : "";
                ModuleCompilationTests.assertEquals("version in attribute", expectedVersion, new String(modAttr.getModuleVersionValue()));
                return;
            }
            ++n2;
        }
        ModuleCompilationTests.fail((String)"module attribute not found");
    }

    public void testBug548195fail() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = OUTPUT_DIR + File.separator + "src";
        String moduleLoc = directory + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n exports p;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "p", "X.java", "package p;\npublic class X {\n}");
        StringBuilder buffer = new StringBuilder();
        String binDir = OUTPUT_DIR + File.separator + out;
        buffer.append("-d " + binDir).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" -warn:-unused").append(" --module-source-path \"" + directory + "\" ").append(" --module-version fourtyseven.11 ");
        if (isJRE9Plus) {
            this.runNegativeModuleTest(files, buffer, "", "fourtyseven.11: Version string does not start with a number\n", "bad value");
        } else {
            this.runConformModuleTest(files, buffer, "Could not invoke method java.lang.module.ModuleDescriptor.Version.parse(), cannot validate module version.\n", "");
        }
    }

    public void testPackageTypeConflict2() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = OUTPUT_DIR + File.separator + "src";
        String moduleLoc = directory + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n\texports p1.p2;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "p1" + File.separator + "p2", "t3.java", "package p1.p2;\npublic class t3 {\n}\n");
        moduleLoc = directory + File.separator + "mod.two";
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.two { \n\texports p1.p2.t3;\n\trequires mod.one;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "p1" + File.separator + "p2" + File.separator + "t3", "t4.java", "package p1.p2.t3;\npublic class t4 {\n}\n");
        StringBuilder buffer = new StringBuilder();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" --module-source-path \"" + directory + "\"");
        this.runNegativeModuleTest(files, buffer, "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.two/p1/p2/t3/t4.java (at line 1)\n\tpackage p1.p2.t3;\n\t        ^^^^^^^^\nThe package p1.p2.t3 collides with a type\n----------\n1 problem (1 error)\n", "package p1.p2.t3 clashes with class of same name");
    }

    public void testBug550178() throws Exception {
        Util.flushDirectoryContent(new File(OUTPUT_DIR));
        String outDir = OUTPUT_DIR + File.separator + "bin";
        String srcDir = OUTPUT_DIR + File.separator + "src";
        File modDir = new File(OUTPUT_DIR + File.separator + "mod");
        this.createReusableModules(srcDir, outDir, modDir);
        String moduleLoc = srcDir + File.separator + "mod.three";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.three { \n\texports pkg.invalid;\n}");
        StringBuilder buffer = new StringBuilder();
        buffer.append("-d " + outDir).append(" -9 ").append(" --module-path \"").append(Util.getJavaClassLibsAsString()).append(modDir.getAbsolutePath()).append("\" ").append(" --module-source-path \"" + srcDir + "\" ");
        this.runNegativeModuleTest(files, buffer, "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.three/module-info.java (at line 2)\n\texports pkg.invalid;\n\t        ^^^^^^^^^^^\nThe package pkg.invalid does not exist or is empty\n----------\n1 problem (1 error)\n", "");
    }

    public void testRelease565930_1() throws Exception {
        this.runConformTest(new String[]{"Dummy.java", "public class Dummy {\n\tboolean b = new String(\"a\").contains(\"b\");\n}"}, "\"" + OUTPUT_DIR + File.separator + "Dummy.java\" --release 9 -d \"" + OUTPUT_DIR + "\"", "", "", true);
    }

    public void testRelease565930_2() throws Exception {
        this.runConformTest(new String[]{"Main.java", "public final class Main<T extends Object> {\n    public void test() {\n    \tfinal ClassLoader classLoader = this.getClass().getClassLoader();\n    } \n}"}, "\"" + OUTPUT_DIR + File.separator + "Main.java\" --release 9 -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/Main.java (at line 3)\n\tfinal ClassLoader classLoader = this.getClass().getClassLoader();\n\t                  ^^^^^^^^^^^\nThe value of the local variable classLoader is not used\n----------\n1 problem (1 warning)\n", true);
    }

    public void testBug571363() throws Exception {
        if (!isJRE12Plus) {
            return;
        }
        this.runConformTest(new String[]{"A.java", "public final class A {\n    org.w3c.dom.Element list;\n}"}, "\"" + OUTPUT_DIR + File.separator + "A.java\" -classpath \"" + this.getCompilerTestsPluginDirectoryPath() + File.separator + "workspace" + File.separator + "Test571363.jar\" --release 11 -d \"" + OUTPUT_DIR + "\"", "", "", true);
    }

    public void testBug574097() {
        Util.flushDirectoryContent(new File(OUTPUT_DIR));
        String outDir = OUTPUT_DIR + File.separator + "bin";
        String srcDir = OUTPUT_DIR + File.separator + "src";
        File modDir = new File(OUTPUT_DIR + File.separator + "mod");
        String moduleLoc = srcDir + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n\texports p;\n\trequires transitive java.compiler;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "p", "TestProcessor.java", "package p;\nimport java.util.Set;\nimport javax.annotation.processing.AbstractProcessor;\nimport javax.annotation.processing.RoundEnvironment;\nimport javax.lang.model.element.TypeElement;\npublic class TestProcessor extends AbstractProcessor {\n\t@Override\n\tpublic boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {\n\t\treturn false;\n\t}\n}");
        StringBuilder buffer = new StringBuilder();
        buffer.append("-d " + outDir).append(" -9 ").append(" --module-path \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" --module-source-path \"" + srcDir + "\"");
        for (String fileName : files) {
            buffer.append(" \"").append(fileName).append("\"");
        }
        this.runConformTest(new String[0], buffer.toString(), "", "", false);
        String jarName = String.valueOf(modDir) + File.separator + "mod.one.jar";
        try {
            Util.zip(new File(outDir + File.separator + "mod.one"), jarName);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (!modDir.exists() && !modDir.mkdirs()) {
            ModuleCompilationTests.fail((String)("Coult not create folder " + String.valueOf(modDir)));
        }
        Util.flushDirectoryContent(new File(srcDir));
        files = new ArrayList();
        moduleLoc = srcDir + File.separator + "mod.two";
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.two { \n\texports q;\n\trequires java.base;\n\trequires mod.one;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "q", "A.java", "package q;\npublic class A {\n   p.TestProcessor prc = null;\n}");
        buffer = new StringBuilder();
        buffer.append("-d " + outDir).append(" -9 ").append(" --module-path \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" --module-source-path \"" + srcDir + "\"").append(" --processor-module-path \"" + jarName + "\"");
        for (String name : files) {
            buffer.append(" \"").append(name).append("\"");
        }
        this.runNegativeTest(new String[0], buffer.toString(), "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.two/module-info.java (at line 4)\n\trequires mod.one;\n\t         ^^^^^^^\nmod.one cannot be resolved to a module\n----------\n----------\n2. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.two/q/A.java (at line 3)\n\tp.TestProcessor prc = null;\n\t^\np cannot be resolved to a type\n----------\n2 problems (2 errors)\n", false);
    }

    public void testBug522472a() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = OUTPUT_DIR + File.separator + "src";
        File srcDir = new File(directory);
        String moduleLoc = directory + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n\texports x.y.z;\n\texports a.b.c;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "x" + File.separator + "y" + File.separator + "z", "X.java", "package x.y.z;\n");
        this.writeFileCollecting(files, moduleLoc + File.separator + "a" + File.separator + "b" + File.separator + "c", "A.java", "package a.b.c;\npublic class A {}");
        StringBuilder buffer = new StringBuilder();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" --module-source-path \"" + directory + "\" ");
        this.runConformModuleTest(files, buffer, "", "");
        Util.flushDirectoryContent(srcDir);
        files.clear();
        moduleLoc = directory + File.separator + "mod.two";
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.two { \n\trequires mod.one;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "p" + File.separator + "q" + File.separator + "r", "Main.java", "package p.q.r;\nimport a.b.c.*;\nimport x.y.z.*;\npublic class Main {}");
        buffer = new StringBuilder();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" --module-path \"" + OUTPUT_DIR + File.separator + out + "\" ").append(" --module-source-path \"" + directory + "\" ");
        this.runConformModuleTest(files, buffer, "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.two/p/q/r/Main.java (at line 2)\n\timport a.b.c.*;\n\t       ^^^^^\nThe import a.b.c is never used\n----------\n2. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.two/p/q/r/Main.java (at line 3)\n\timport x.y.z.*;\n\t       ^^^^^\nThe import x.y.z is never used\n----------\n2 problems (2 warnings)\n");
    }

    public void testBug522472b() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = OUTPUT_DIR + File.separator + "src";
        File srcDir = new File(directory);
        String moduleLoc = directory + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n\texports x.y.z;\n\texports a.b.c;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "x" + File.separator + "y" + File.separator + "z", "X.java", "package x.y.z;\n");
        this.writeFileCollecting(files, moduleLoc + File.separator + "a" + File.separator + "b" + File.separator + "c", "A.java", "package a.b.c;\npublic class A {}");
        moduleLoc = directory + File.separator + "mod.one.a";
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one.a { \n\texports x.y.z;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "x" + File.separator + "y" + File.separator + "z", "X.java", "package x.y.z;\n");
        StringBuilder buffer = new StringBuilder();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" --module-source-path \"" + directory + "\" ");
        this.runConformModuleTest(files, buffer, "", "");
        Util.flushDirectoryContent(srcDir);
        files.clear();
        moduleLoc = directory + File.separator + "mod.two";
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.two { \n\trequires mod.one;\n\trequires mod.one.a;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "p" + File.separator + "q" + File.separator + "r", "Main.java", "package p.q.r;\nimport a.b.c.*;\nimport x.y.z.*;\npublic class Main {}");
        buffer = new StringBuilder();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" --module-path \"" + OUTPUT_DIR + File.separator + out + "\" ").append(" --module-source-path \"" + directory + "\" ");
        this.runNegativeModuleTest(files, buffer, "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.two/module-info.java (at line 2)\n\trequires mod.one;\n\t^^^^^^^^^^^^^^^^\nThe package x.y.z is accessible from more than one module: mod.one, mod.one.a\n----------\n2. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.two/module-info.java (at line 3)\n\trequires mod.one.a;\n\t^^^^^^^^^^^^^^^^^^\nThe package x.y.z is accessible from more than one module: mod.one, mod.one.a\n----------\n----------\n3. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.two/p/q/r/Main.java (at line 3)\n\timport x.y.z.*;\n\t       ^^^^^\nThe import x.y.z cannot be resolved\n----------\n3 problems (3 errors)\n", "reads package x.y.z from both");
    }

    public void testBug522472d() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = OUTPUT_DIR + File.separator + "src";
        String moduleLoc = directory + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n\texports x.y.z;\n\texports a.b.c;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "x" + File.separator + "y" + File.separator + "z", "X.java", "package x.y.z;\n");
        this.writeFileCollecting(files, moduleLoc + File.separator + "a" + File.separator + "b" + File.separator + "c", "A.java", "package a.b.c;\npublic class A {}");
        moduleLoc = directory + File.separator + "mod.one.a";
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one.a { \n\texports x.y.z;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "x" + File.separator + "y" + File.separator + "z", "X.java", "package x.y.z;\n");
        StringBuilder buffer = new StringBuilder();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" --module-source-path \"" + directory + "\" ");
        moduleLoc = directory + File.separator + "mod.two";
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.two { \n\trequires mod.one;\n\trequires mod.one.a;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "p" + File.separator + "q" + File.separator + "r", "Main.java", "package p.q.r;\nimport a.b.c.*;\nimport x.y.z.*;\npublic class Main {}");
        this.runNegativeModuleTest(files, buffer, "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.two/module-info.java (at line 2)\n\trequires mod.one;\n\t^^^^^^^^^^^^^^^^\nThe package x.y.z is accessible from more than one module: mod.one, mod.one.a\n----------\n2. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.two/module-info.java (at line 3)\n\trequires mod.one.a;\n\t^^^^^^^^^^^^^^^^^^\nThe package x.y.z is accessible from more than one module: mod.one, mod.one.a\n----------\n----------\n3. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.two/p/q/r/Main.java (at line 3)\n\timport x.y.z.*;\n\t       ^^^^^\nThe package x.y.z is accessible from more than one module: mod.one, mod.one.a\n----------\n3 problems (3 errors)\n", "reads package x.y.z from both");
    }

    public void testIssue2357_001() throws Exception {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = OUTPUT_DIR + File.separator + "src";
        String moduleLoc = directory + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n    exports pack1;\n    exports pack2 to second;\n    opens pack3;\n    opens pack4 to third;\n    uses pack5.X51;\n    provides pack1.I11 with pack1.X11;\n    requires static java.sql;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "pack1", "I11.java", "package pack1;\npublic interface I11 {\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "pack1", "X11.java", "package pack1;\npublic class X11 implements I11{\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "pack2", "X21.java", "package pack2;\npublic class X21 {\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "pack3", "X31.java", "package pack3;\npublic class X31 {\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "pack4", "X41.java", "package pack4;\npublic class X41 {\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "pack5", "X51.java", "package pack5;\npublic class X51 {\n}");
        StringBuilder buffer = new StringBuilder();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ");
        files.forEach(name -> {
            StringBuilder stringBuilder2 = buffer.append(" \"" + name + "\"");
        });
        this.runConformTest(new String[0], buffer.toString(), "", "", false);
        String expectedOutput = "// Compiled from module-info.java (version 9 : 53.0, no super bit)\n module mod.one  {\n  // Version: \n\n  requires static java.sql;\n  requires java.base;\n\n  exports pack1;\n  exports pack2 to second;\n\n  opens pack3;\n  opens pack4 to third;\n\n  uses pack5.X51\n\n  provides pack1.I11 with pack1.X11;\n\n}";
        this.checkDisassembledClassFile(OUTPUT_DIR + File.separator + out + File.separator + "module-info.class", "module-info", expectedOutput);
    }

    public void testPatchModuleSingle() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out1 = OUTPUT_DIR + File.separator + "bin1";
        String src1 = OUTPUT_DIR + File.separator + "src1";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, src1, "module-info.java", "module mod.one { \n}");
        this.writeFileCollecting(files, src1 + File.separator + "test1", "A.java", "package test1;\npublic class A {}");
        StringBuilder buffer = new StringBuilder();
        buffer.append("-d " + out1).append(" -9 ").append(" -proc:none ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ");
        this.runConformModuleTest(files, buffer, "", "");
        files.clear();
        String out2 = "bin2";
        String src2 = OUTPUT_DIR + File.separator + "src2";
        this.writeFileCollecting(files, src2 + File.separator + "test2", "B.java", "package test2;\nimport test1.A;\nclass B extends A {}\n");
        buffer = new StringBuilder();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out2).append(" -9 ").append(" -proc:none ").append(" --patch-module mod.one=\"").append(src2).append("\" ").append(" --module-path \"").append(Util.getJavaClassLibsAsString()).append(File.pathSeparatorChar).append(out1).append("\" ");
        this.runConformModuleTest(files, buffer, "", "");
    }

    public void testPatchModuleSingle_duplicateModule() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String src1 = OUTPUT_DIR + File.separator + "src1";
        String src2 = OUTPUT_DIR + File.separator + "src2";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, src1 + File.separator + "test1", "A.java", "package test1;\npublic class A {}");
        StringBuilder buffer = new StringBuilder();
        buffer.append(" -9 ").append(" -proc:none ").append(" --patch-module mod.one=\"").append(src1).append("\" ").append(" --patch-module mod.one=\"").append(src2).append("\" ").append(" --module-path \"").append(Util.getJavaClassLibsAsString()).append("\" ");
        this.runNegativeModuleTest(files, buffer, "", "duplicate module in --patch-module: mod.one\n", "--patch-module specified more than once");
    }

    public void testPatchModuleSingle_duplicateLocation1() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String src1 = OUTPUT_DIR + File.separator + "src1";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, src1 + File.separator + "test1", "A.java", "package test1;\npublic class A {}");
        StringBuilder buffer = new StringBuilder();
        buffer.append(" -9 ").append(" -proc:none ").append(" --patch-module mod.one=\"").append(src1).append("\"").append(File.pathSeparatorChar).append("\"").append(src1).append("\" ").append(" --module-path \"").append(Util.getJavaClassLibsAsString()).append("\" ");
        this.runNegativeModuleTest(files, buffer, "", "location ---OUTPUT_DIR_PLACEHOLDER---/src1 is specified more than once in --patch-module\n", "", AbstractRegressionTest.JavacTestOptions.SKIP);
    }

    public void testPatchModuleSingle_duplicateLocation2() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String src1 = OUTPUT_DIR + File.separator + "src1";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, src1 + File.separator + "test1", "A.java", "package test1;\npublic class A {}");
        StringBuilder buffer = new StringBuilder();
        buffer.append(" -9 ").append(" -proc:none ").append(" --patch-module mod.one=\"").append(src1).append("\" ").append(" --patch-module mod.two=\"").append(src1).append("\" ").append(" --module-path \"").append(Util.getJavaClassLibsAsString()).append("\" ");
        this.runNegativeModuleTest(files, buffer, "", "location ---OUTPUT_DIR_PLACEHOLDER---/src1 is specified more than once in --patch-module\n", "", AbstractRegressionTest.JavacTestOptions.SKIP);
    }

    public void testPatchModuleSingle_syntaxErr() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String src1 = OUTPUT_DIR + File.separator + "src1";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, src1 + File.separator + "test1", "A.java", "package test1;\npublic class A {}");
        StringBuilder buffer = new StringBuilder();
        buffer.append(" -9 ").append(" -proc:none ").append(" --patch-module mod.one \"").append(src1).append("\" ").append(" --module-path \"").append(Util.getJavaClassLibsAsString()).append("\" ");
        this.runNegativeModuleTest(files, buffer, "", "invalid syntax for --patch-module: mod.one\n", "bad value for --patch-module option");
    }

    public void testPatchModuleSingle_noSuchModule() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String src1 = OUTPUT_DIR + File.separator + "src1";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, src1 + File.separator + "test1", "A.java", "package test1;\npublic class A {}");
        StringBuilder buffer = new StringBuilder();
        buffer.append(" -9 ").append(" -proc:none ").append(" --patch-module mod.one=\"").append(src1).append("\" ").append(" --module-path \"").append(Util.getJavaClassLibsAsString()).append("\" ");
        this.runNegativeModuleTest(files, buffer, "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src1/test1/A.java (at line 1)\n\tpackage test1;\n\t        ^^^^^\nmod.one cannot be resolved to a module\n----------\n1 problem (1 error)\n", "module not found");
    }

    public void testPatchModuleMulti() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out1 = OUTPUT_DIR + File.separator + "bin1";
        String src1 = OUTPUT_DIR + File.separator + "src1";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, src1, "module-info.java", "module mod.one { \n}");
        this.writeFileCollecting(files, src1 + File.separator + "test1", "A.java", "package test1;\npublic class A {}");
        StringBuilder buffer = new StringBuilder();
        buffer.append("-d " + out1).append(" -9 ").append(" -proc:none ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ");
        this.runConformModuleTest(files, buffer, "", "");
        String out2 = OUTPUT_DIR + File.separator + "bin2";
        String src2 = OUTPUT_DIR + File.separator + "src2";
        files.clear();
        this.writeFileCollecting(files, src2, "module-info.java", "module mod.two { \n}");
        this.writeFileCollecting(files, src2 + File.separator + "test2", "B.java", "package test2;\npublic class B {}");
        buffer = new StringBuilder();
        buffer.append("-d " + out2).append(" -9 ").append(" -proc:none ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ");
        this.runConformModuleTest(files, buffer, "", "");
        files.clear();
        String out3 = "bin3";
        String src3 = OUTPUT_DIR + File.separator + "src3";
        this.writeFileCollecting(files, src3 + File.separator + "test3", "C.java", "package test2;\nimport test1.A;\nclass C extends A {}\n");
        String src4 = OUTPUT_DIR + File.separator + "src4";
        this.writeFileCollecting(files, src4 + File.separator + "test4", "E.java", "package test4;\nimport test2.B;\nclass E extends B {}\n");
        buffer = new StringBuilder();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out3).append(" -9 ").append(" -proc:none ").append(" --patch-module mod.one=\"").append(src3).append("\" ").append(" --patch-module mod.two=\"").append(src4).append("\" ").append(" --module-path \"").append(Util.getJavaClassLibsAsString()).append(File.pathSeparatorChar).append(out1).append(File.pathSeparatorChar).append(out2).append("\" ");
        this.runConformModuleTest(files, buffer, "", "");
    }

    public void testPatchModuleMulti2() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = OUTPUT_DIR + File.separator + "bin";
        String src = OUTPUT_DIR + File.separator + "src";
        String m1src = src + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, m1src, "module-info.java", "module mod.one {}\n");
        this.writeFileCollecting(files, m1src + File.separator + "test1", "A.java", "package test1;\npublic class A {}");
        String m2src = src + File.separator + "mod.two";
        this.writeFileCollecting(files, m2src, "module-info.java", "module mod.two {} \n");
        this.writeFileCollecting(files, m2src + File.separator + "test2", "B.java", "package test2;\npublic class B {}\n");
        String srcPatch1 = OUTPUT_DIR + File.separator + "src1";
        this.writeFileCollecting(files, srcPatch1 + File.separator + "test3", "C.java", "package test2;\nimport test1.A;\nclass C extends A {}\n");
        String srcPatch2 = OUTPUT_DIR + File.separator + "src2";
        this.writeFileCollecting(files, srcPatch2 + File.separator + "test4", "E.java", "package test4;\nimport test2.B;\nclass E extends B {}\n");
        StringBuilder buffer = new StringBuilder();
        buffer.append("-d ").append(out).append(" -9 ").append(" -proc:none ").append(" --module-source-path \"").append(src).append("\"").append(" --patch-module mod.one=\"").append(srcPatch1).append("\" ").append(" --patch-module mod.two=\"").append(srcPatch2).append("\" ").append(" --module-path \"").append(Util.getJavaClassLibsAsString()).append("\" ");
        this.runConformModuleTest(files, buffer, "", "");
    }

    public void testGH2646() {
        try {
            class Counter
            implements Consumer<SplitPackageBinding> {
                int count;

                Counter() {
                }

                @Override
                public void accept(SplitPackageBinding t) {
                    ++this.count;
                }
            }
            Counter counter = new Counter();
            SplitPackageBinding.instanceListener = counter;
            this.runConformModuleTest(new String[]{"p/X.java", "package p;\npublic class X {\n\tjava.sql.Connection con;\n}", "module-info.java", "module mod.one { \n\trequires java.se;\n}", "q/Y.java", "package q;\npublic class Y {\n   java.awt.Image image;\n}"}, " -9 \"" + OUTPUT_DIR + File.separator + "module-info.java\" \"" + OUTPUT_DIR + File.separator + "q/Y.java\" \"" + OUTPUT_DIR + File.separator + "p/X.java\" -d " + OUTPUT_DIR, "", "", true);
            ModuleCompilationTests.assertTrue((String)("Number of SplitPackageBinding created: " + counter.count), (counter.count <= 20 ? 1 : 0) != 0);
        }
        finally {
            SplitPackageBinding.instanceListener = null;
        }
    }

    public void testGH2748() throws IOException {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        ArrayList<CallSite> modules = new ArrayList<CallSite>();
        String[] stringArray = new String[]{"A", "B"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String m = stringArray[n2];
            String out = OUTPUT_DIR + File.separator + "module" + m + File.separator + "bin";
            String src = OUTPUT_DIR + File.separator + "module" + m + File.separator + "src";
            modules.add((CallSite)((Object)out));
            ArrayList<String> files = new ArrayList<String>();
            this.writeFileCollecting(files, src, "module-info.java", "module split.module" + m + " {\n\texports pkg.bug.split.sub" + m + ";\n}");
            this.writeFileCollecting(files, Paths.get(src, "pkg", "bug", "split", "sub" + m).toString(), "SubModule" + m + ".java", "package pkg.bug.split.sub" + m + ";\n\npublic class SubModule" + m + " {\n\t\n}");
            StringBuilder buffer = new StringBuilder();
            buffer.append("-d " + out).append(" -9 ").append(" -proc:none ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ");
            this.runConformModuleTest(files, buffer, "", "");
            ++n2;
        }
        String[] sources = new String[]{"pkg/bug/service/IService.java", "package pkg.bug.service;\n\npublic interface IService {\n\n}"};
        String jarPath = OUTPUT_DIR + File.separator + "autoModule.jar";
        Util.createJar(sources, jarPath, "1.8");
        modules.add((CallSite)((Object)jarPath));
        String outFinal = OUTPUT_DIR + File.separator + "modularizedApp" + File.separator + "bin";
        String srcFinal = OUTPUT_DIR + File.separator + "modularizedApp" + File.separator + "src";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, srcFinal, "module-info.java", "module split.app {\t\n\trequires autoModule;\n\trequires split.moduleA;\n\trequires split.moduleB;\n\t\n\texports pkg.bug.app;\n}");
        this.writeFileCollecting(files, Paths.get(srcFinal, "pkg", "bug", "app").toString(), "App.java", "package pkg.bug.app;\n\nimport pkg.bug.split.subA.SubModuleA;\n\npublic class App {\n\tpublic static void main(String[] args) {\n\t\tnew SubModuleA();\n\t}\n}");
        this.writeFileCollecting(files, Paths.get(srcFinal, "pkg", "bug", "service", "impl").toString(), "AppServiceImpl.java", "package pkg.bug.service.impl;\n\nimport pkg.bug.service.IService;\n\npublic class AppServiceImpl implements IService {\n\n}");
        String modulePath = String.join((CharSequence)File.pathSeparator, modules);
        StringBuilder buffer = new StringBuilder();
        buffer.append("-d " + outFinal).append(" -9 ").append(" -proc:none ").append(" --module-path \"").append(Util.getJavaClassLibsAsString()).append(File.pathSeparatorChar).append(modulePath).append("\" ").append(" --add-modules autoModule ");
        this.runConformModuleTest(files, buffer, "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/modularizedApp/src/module-info.java (at line 2)\n\trequires autoModule;\n\t         ^^^^^^^^^^\nName of automatic module 'autoModule' is unstable, it is derived from the module's file name.\n----------\n1 problem (1 warning)\n");
    }
}

