/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.stream.Collectors;
import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractModuleCompilationTest;
import org.eclipse.jdt.core.util.ClassFormatException;

public class ModuleImportTests
extends AbstractModuleCompilationTest {
    public ModuleImportTests(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        this.runJavacOptIn = true;
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        this.runJavacOptIn = false;
    }

    public static Test suite() {
        return ModuleImportTests.buildMinimalComplianceTestSuite(ModuleImportTests.testClass(), 0x100000);
    }

    public static Class<?> testClass() {
        return ModuleImportTests.class;
    }

    @Override
    protected StringBuilder trimJavacLog(StringBuilder log) {
        if (log.length() > 6 && log.substring(0, 6).equals("Note: ")) {
            StringBuilder filtered = new StringBuilder();
            filtered.append(log.toString().lines().filter(line -> !line.equals("Note: Recompile with -Xlint:preview for details.")).filter(line -> !line.startsWith("Note: ") || !line.endsWith(" preview features of Java SE 24.")).collect(Collectors.joining("\n")));
            return filtered;
        }
        return log;
    }

    public void test000_previewDisabled() {
        this.runNegativeModuleTest(new String[]{"p/X.java", "package p;\nimport module java.sql;\npublic class X {\n\tpublic static void main(String[] args) {\n\t\t@SuppressWarnings(\"unused\")\n\t\tConnection con = null;\n\t}\n}\n", "module-info.java", "module mod.one {\n}\n"}, " -24 \"" + this.getSourceDir() + File.separator + "module-info.java\" \"" + this.getSourceDir() + File.separator + "p/X.java\"", "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/p/X.java (at line 2)\n\timport module java.sql;\n\t              ^^^^^^^^\nModule Import Declarations is a preview feature and disabled by default. Use --enable-preview to enable\n----------\n2. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/p/X.java (at line 6)\n\tConnection con = null;\n\t^^^^^^^^^^\nConnection cannot be resolved to a type\n----------\n2 problems (2 errors)\n", true, "disabled");
    }

    public void test000_previewWrongVersion() {
        this.runNegativeModuleTest(new String[]{"p/X.java", "package p;\nimport module java.sql;\npublic class X {\n\tpublic static void main(String[] args) {\n\t\t@SuppressWarnings(\"unused\")\n\t\tConnection con = null;\n\t}\n}\n", "module-info.java", "module mod.one {\n}\n"}, " -22 --enable-preview \"" + this.getSourceDir() + File.separator + "module-info.java\" \"" + this.getSourceDir() + File.separator + "p/X.java\"", "", "Preview of features is supported only at the latest source level\n", true, "only supported for release 24");
    }

    public void test001_simpleOK() throws IOException, ClassFormatException {
        this.runConformModuleTest(new String[]{"p/X.java", "package p;\nimport /*ignoreme*/ module java.sql;\n@SuppressWarnings(\"preview\")\npublic class X {\n\tpublic static void main(String[] args) {\n\t\t@SuppressWarnings(\"unused\")\n\t\tConnection con = null;\n\t}\n}\n", "module-info.java", "module mod.one {\n\trequires java.sql;\n}\n"}, " -24 --enable-preview \"" + OUTPUT_DIR + File.separator + "module-info.java\" \"" + OUTPUT_DIR + File.separator + "p/X.java\"", "", "", true);
        this.verifyClassFile("version 24 : 68.65535", "p/X.class", 4);
    }

    public void test002_moduleNotRead() {
        this.runNegativeModuleTest(new String[]{"p/X.java", "package p;\nimport module java.sql;\npublic class X {\n\tpublic static void main(String[] args) {\n\t\t@SuppressWarnings(\"unused\")\n\t\tConnection con = null;\n\t}\n}\n", "module-info.java", "module mod.one {\n}\n"}, " -24 --enable-preview \"" + this.getSourceDir() + File.separator + "module-info.java\" \"" + this.getSourceDir() + File.separator + "p/X.java\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/src/p/X.java (at line 2)\n\timport module java.sql;\n\t              ^^^^^^^^\nYou are using a preview language feature that may or may not be supported in a future release\n----------\n2. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/p/X.java (at line 2)\n\timport module java.sql;\n\t              ^^^^^^^^\nModule mod.one does not read module java.sql\n----------\n3. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/p/X.java (at line 6)\n\tConnection con = null;\n\t^^^^^^^^^^\nConnection cannot be resolved to a type\n----------\n3 problems (2 errors, 1 warning)\n", true, "read");
    }

    public void test003_unresolvableModule() {
        this.runNegativeModuleTest(new String[]{"p/X.java", "package p;\nimport module missing;\n@SuppressWarnings(\"preview\")\npublic class X {\n\tpublic static void main(String[] args) {\n\t\t@SuppressWarnings(\"unused\")\n\t\tConnection con = null;\n\t}\n}\n", "module-info.java", "module mod.one {\n}\n"}, " -24 --enable-preview \"" + this.getSourceDir() + File.separator + "module-info.java\" \"" + this.getSourceDir() + File.separator + "p/X.java\"", "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/p/X.java (at line 2)\n\timport module missing;\n\t              ^^^^^^^\nThe import missing cannot be resolved\n----------\n2. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/p/X.java (at line 7)\n\tConnection con = null;\n\t^^^^^^^^^^\nConnection cannot be resolved to a type\n----------\n2 problems (2 errors)\n", true, "imported module not found");
    }

    public void test004_selfImport_OK() throws IOException, ClassFormatException {
        String modsDir = this.getSourceDir() + File.separator + "mods";
        String modOneDir = modsDir + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, modOneDir + File.separator + "p1", "X1.java", "package p1;\npublic class X1 {}\n");
        this.writeFileCollecting(files, modOneDir + File.separator + "p2", "X2.java", "package p2;\npublic class X2 {}\n");
        this.writeFileCollecting(files, modOneDir + File.separator + "p", "X.java", "package p;\nimport module mod.one;\n@SuppressWarnings(\"preview\")\npublic class X {\n\tX1 x1;\n\tX2 x2;\n}\n");
        this.writeFileCollecting(files, modOneDir, "module-info.java", "module mod.one {\n\texports p1;\n\texports p2 to mod.one;\n}\n");
        StringBuilder commandLine = new StringBuilder();
        commandLine.append(" -24 --enable-preview ");
        this.runConformModuleTest(files, commandLine, "", "");
        String classFile = String.join((CharSequence)File.separator, "p", "X.class");
        this.verifyClassFile("version 24 : 68.65535", classFile, 4);
    }

    public void test005_selfImport_NOK() {
        String modsDir = this.getSourceDir() + File.separator + "mods";
        String modOneDir = modsDir + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, modOneDir + File.separator + "p1", "X1.java", "package p1;\npublic class X1 {}\n");
        this.writeFileCollecting(files, modOneDir + File.separator + "p", "X.java", "package p;\nimport module mod.one;\n@SuppressWarnings(\"preview\")\npublic class X {\n\tX1 x1;\n}\n");
        this.writeFileCollecting(files, modOneDir, "module-info.java", "module mod.one {\n\texports p1 to mod.other;\n}\n");
        StringBuilder commandLine = new StringBuilder();
        commandLine.append(" -24 --enable-preview ");
        this.runNegativeModuleTest(files, commandLine, "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mods/mod.one/p/X.java (at line 5)\n\tX1 x1;\n\t^^\nX1 cannot be resolved to a type\n----------\n1 problem (1 error)\n", "cannot find symbol");
    }

    public void test006_selfImportInModule() throws IOException, ClassFormatException {
        String modsDir = this.getSourceDir() + File.separator + "mods";
        String modOneDir = modsDir + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, modOneDir + File.separator + "api", "IService.java", "package api;\npublic interface IService {}\n");
        this.writeFileCollecting(files, modOneDir + File.separator + "impl", "ServiceImpl.java", "package impl;\nimport api.IService;\npublic class ServiceImpl implements IService {\n\tpublic static IService provider() { return new ServiceImpl(); }\n}\n");
        this.writeFileCollecting(files, modOneDir, "module-info.java", "import module mod.one;\n@SuppressWarnings(\"preview\")\nmodule mod.one {\n\texports api;\n\texports impl to mod.one;\n\tprovides IService with ServiceImpl;\n}\n");
        StringBuilder commandLine = new StringBuilder();
        commandLine.append(" -24 --enable-preview ");
        this.runConformModuleTest(files, commandLine, "", "");
        this.verifyClassFile("version 24 : 68.65535", "module-info.class", 4);
    }

    public void test007_shadowing() throws IOException, ClassFormatException {
        String srcDir = this.getSourceDir();
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, srcDir + File.separator + "p1", "Connection.java", "package p1;\npublic class Connection {\n\tpublic void foo() {}\n}\n");
        this.writeFileCollecting(files, srcDir, "module-info.java", "module mod.one {\n\trequires java.sql;\n}\n");
        this.writeFileCollecting(files, srcDir + File.separator + "p2", "Client.java", "package p2;\nimport module java.sql;\nimport p1.Connection;\n@SuppressWarnings(\"preview\")\nclass Client {\n\tvoid m(Connection c, ConnectionBuilder builder) { // ConnectionBuiler is from java.sql\n\t\tc.foo(); // ensure we select p1.Connection\n\t}\n}\n");
        StringBuilder commandLine = new StringBuilder();
        commandLine.append(" -24 --enable-preview ");
        this.runConformModuleTest(files, commandLine, "", "");
        String classFile = String.join((CharSequence)File.separator, "p2", "Client.class");
        this.verifyClassFile("version 24 : 68.65535", classFile, 4);
    }

    public void test008_shadowing() throws IOException, ClassFormatException {
        String srcDir = this.getSourceDir();
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, srcDir + File.separator + "p1", "Connection.java", "package p1;\npublic class Connection {\n\tpublic void foo() {}\n}\n");
        this.writeFileCollecting(files, srcDir, "module-info.java", "module mod.one {\n\trequires java.sql;\n}\n");
        this.writeFileCollecting(files, srcDir + File.separator + "p2", "Client.java", "package p2;\nimport module java.sql;\nimport p1.*;\n@SuppressWarnings({ \"preview\", \"unused\" }) // module import is not actually used\nclass Client {\n\tvoid m(Connection c) {\n\t\tc.foo(); // ensure we select p1.Connection\n\t}\n}\n");
        StringBuilder commandLine = new StringBuilder();
        commandLine.append(" -24 --enable-preview ");
        this.runConformModuleTest(files, commandLine, "", "");
        String classFile = String.join((CharSequence)File.separator, "p2", "Client.class");
        this.verifyClassFile("version 24 : 68.65535", classFile, 4);
    }

    public void test008_shadowing_static_nested() throws IOException, ClassFormatException {
        String srcDir = this.getSourceDir() + File.separator + "src";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, srcDir + File.separator + "p1", "Outer.java", "package p1;\npublic class Outer {\n\tpublic static class Connection {\n\t\tpublic void foo() {}\n\t}\n}\n");
        this.writeFileCollecting(files, srcDir, "module-info.java", "module mod.one {\n\trequires java.sql;\n}\n");
        this.writeFileCollecting(files, srcDir + File.separator + "p2", "Client.java", "package p2;\nimport module java.sql;\nimport p1.Outer.*;\n@SuppressWarnings({ \"preview\", \"unused\" }) // module import is not actually used\nclass Client {\n\tvoid m(Connection c) {\n\t\tc.foo(); // ensure we select p1.Outer.Connection\n\t}\n}\n");
        StringBuilder commandLine = new StringBuilder();
        commandLine.append(" -24 --enable-preview ");
        this.runConformModuleTest(files, commandLine, "", "");
        String classFile = String.join((CharSequence)File.separator, "p2", "Client.class");
        this.verifyClassFile("version 24 : 68.65535", classFile, 4);
    }

    public void test009_ambiguous_modules() {
        String srcDir = this.getSourceDir();
        ArrayList<String> files = new ArrayList<String>();
        String modOneDir = srcDir + File.separator + "mod.one";
        this.writeFileCollecting(files, modOneDir, "module-info.java", "module mod.one {\n\texports p1;\n\texports p2;\n\trequires transitive java.sql;\n}\n");
        this.writeFileCollecting(files, modOneDir + File.separator + "p1", "Connection.java", "package p1;\npublic class Connection {\n}\n");
        this.writeFileCollecting(files, modOneDir + File.separator + "p1", "Other.java", "package p1;\npublic class Other {\n}\n");
        this.writeFileCollecting(files, modOneDir + File.separator + "p2", "Other.java", "package p2;\npublic class Other{\n}\n");
        String modTwoDir = srcDir + File.separator + "mod.two";
        this.writeFileCollecting(files, modTwoDir, "module-info.java", "module mod.two {\n\trequires mod.one;\n}\n");
        this.writeFileCollecting(files, modTwoDir + File.separator + "p3", "Client.java", "package p3;\nimport module mod.one;\n@SuppressWarnings(\"preview\")\nclass Client {\n\tConnection conn; // module conflict mod.one java.sql (via requires transitive)\n\tOther other; // package conflict mod.one/p1 mod.one/p2\n}\n");
        StringBuilder commandLine = new StringBuilder();
        commandLine.append(" -24 --enable-preview ");
        commandLine.append(" --module-source-path \"").append(srcDir).append("\"");
        commandLine.append(" -d \"").append(OUTPUT_DIR).append(File.separatorChar).append("bin").append("\"");
        this.runNegativeModuleTest(files, commandLine, "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.two/p3/Client.java (at line 5)\n\tConnection conn; // module conflict mod.one java.sql (via requires transitive)\n\t^^^^^^^^^^\nThe type Connection is ambiguous\n----------\n2. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.two/p3/Client.java (at line 6)\n\tOther other; // package conflict mod.one/p1 mod.one/p2\n\t^^^^^\nThe type Other is ambiguous\n----------\n2 problems (2 errors)\n", "reference to Connection is ambiguous");
    }

    public void test009_ambiguous_modules2() {
        String srcDir = this.getSourceDir();
        ArrayList<String> files = new ArrayList<String>();
        String modOneDir = srcDir + File.separator + "mod.one";
        this.writeFileCollecting(files, modOneDir, "module-info.java", "module mod.one {\n\texports p1;\n}\n");
        this.writeFileCollecting(files, modOneDir + File.separator + "p1", "Connection.java", "package p1;\npublic class Connection {\n}\n");
        String modTwoDir = srcDir + File.separator + "mod.two";
        this.writeFileCollecting(files, modTwoDir, "module-info.java", "module mod.two {\n\trequires mod.one;\n\trequires java.sql;\n}\n");
        this.writeFileCollecting(files, modTwoDir + File.separator + "p3", "Client.java", "package p3;\nimport module mod.one;\nimport module java.sql;\n@SuppressWarnings(\"preview\")\nclass Client {\n\tConnection conn; // module conflict mod.one java.sql\n}\n");
        StringBuilder commandLine = new StringBuilder();
        commandLine.append(" -24 --enable-preview ");
        commandLine.append(" --module-source-path \"").append(srcDir).append("\"");
        commandLine.append(" -d \"").append(OUTPUT_DIR).append(File.separatorChar).append("bin").append("\"");
        this.runNegativeModuleTest(files, commandLine, "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.two/p3/Client.java (at line 6)\n\tConnection conn; // module conflict mod.one java.sql\n\t^^^^^^^^^^\nThe type Connection is ambiguous\n----------\n1 problem (1 error)\n", "reference to Connection is ambiguous");
    }

    public void test010_notAccessible() {
        String srcDir = OUTPUT_DIR + File.separator + "src";
        String modOneDir = srcDir + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, modOneDir, "module-info.java", "module mod.one {\n\texports p1;\n}\n");
        this.writeFileCollecting(files, modOneDir + File.separator + "p1", "NoAccess.java", "package p1;\nclass NoAccess {\n}\n");
        this.writeFileCollecting(files, modOneDir + File.separator + "p1", "Access.java", "package p1;\npublic class Access {\n}\n");
        String modTwoDir = srcDir + File.separator + "mod.two";
        this.writeFileCollecting(files, modTwoDir, "module-info.java", "module mod.two {\n\trequires mod.one;\n}\n");
        this.writeFileCollecting(files, modTwoDir + File.separator + "p2", "Client.java", "package p2;\nimport module mod.one;\n@SuppressWarnings(\"preview\")\nclass Client {\n\tAccess good;\n\tNoAccess bad;\n}\n");
        StringBuilder commandLine = new StringBuilder();
        commandLine.append(" -24 --enable-preview");
        commandLine.append(" --module-source-path ").append(srcDir);
        commandLine.append(" -d ").append(OUTPUT_DIR + File.separator + "bin");
        this.runNegativeModuleTest(files, commandLine, "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.two/p2/Client.java (at line 6)\n\tNoAccess bad;\n\t^^^^^^^^\nNoAccess cannot be resolved to a type\n----------\n1 problem (1 error)\n", "cannot find symbol");
    }

    public void test011_transitive() throws IOException, ClassFormatException {
        String srcDir = OUTPUT_DIR + File.separator + "src";
        String modOneDir = srcDir + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, modOneDir, "module-info.java", "module mod.one {\n\texports p1;\n}\n");
        this.writeFileCollecting(files, modOneDir + File.separator + "p1", "Access.java", "package p1;\npublic class Access {\n}\n");
        String modTwoDir = srcDir + File.separator + "mod.two";
        this.writeFileCollecting(files, modTwoDir, "module-info.java", "module mod.two {\n\trequires transitive mod.one;\n}\n");
        String modThreeDir = srcDir + File.separator + "mod.three";
        this.writeFileCollecting(files, modThreeDir, "module-info.java", "module mod.three {\n\trequires mod.two;\n}\n");
        this.writeFileCollecting(files, modThreeDir + File.separator + "p2", "Client.java", "package p2;\nimport module mod.two;\n@SuppressWarnings(\"preview\")\nclass Client {\n\tAccess good;\n}\n");
        StringBuilder commandLine = new StringBuilder();
        commandLine.append(" -24 --enable-preview");
        commandLine.append(" --module-source-path ").append(srcDir);
        this.runConformModuleTest(files, commandLine, "", "");
        String classFile = String.join((CharSequence)File.separator, "mod.three", "p2", "Client.class");
        this.verifyClassFile("version 24 : 68.65535", classFile, 4);
    }

    public void test012_redundant() {
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, OUTPUT_DIR + File.separator + "p", "X.java", "package p;\nimport module java.sql;\nimport module java.sql; // redundant\n@SuppressWarnings(\"preview\")\npublic class X {\n\tpublic static void main(String[] args) {\n\t\t@SuppressWarnings(\"unused\")\n\t\tConnection con = null;\n\t\tZork zork;\n\t}\n}\n");
        this.writeFileCollecting(files, OUTPUT_DIR, "module-info.java", "module mod.one {\n\trequires java.sql;\n}\n");
        StringBuilder commandLine = new StringBuilder();
        commandLine.append(" -24 --enable-preview");
        this.runNegativeModuleTest(files, commandLine, "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/p/X.java (at line 3)\n\timport module java.sql; // redundant\n\t              ^^^^^^^^\nThe import java.sql is never used\n----------\n2. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/p/X.java (at line 9)\n\tZork zork;\n\t^^^^\nZork cannot be resolved to a type\n----------\n2 problems (1 error, 1 warning)\n", "cannot find symbol");
    }

    public void test013_inUnnamedModule() throws IOException, ClassFormatException {
        this.runConformModuleTest(new String[]{"p/X.java", "package p;\nimport module java.sql;\n@SuppressWarnings(\"preview\")\npublic class X {\n\tConnection con = null;\n}\n"}, " -24 --enable-preview \"" + OUTPUT_DIR + File.separator + "p/X.java\"", "", "", true);
        this.verifyClassFile("version 24 : 68.65535", "p/X.class", 4);
    }

    public void test014_moduleAsPackageName_regular() {
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, OUTPUT_DIR + File.separator + "module", "Z.java", "package module;\npublic class Z {}\n");
        this.writeFileCollecting(files, OUTPUT_DIR + File.separator + "test", "X.java", "package test;\nimport module.Z;\npublic class X extends Z {}\n");
        StringBuilder commandLine = new StringBuilder(" -24 --enable-preview");
        this.runConformModuleTest(files, commandLine, "", "");
    }

    public void test014_moduleAsPackageName_moduleInfo() {
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, OUTPUT_DIR + File.separator + "module", "Z.java", "package module;\npublic class Z {}\n");
        this.writeFileCollecting(files, OUTPUT_DIR, "module-info.java", "import module.Z;\nmodule one {\n\tuses Z;\n}\n");
        StringBuilder commandLine = new StringBuilder(" -24 --enable-preview");
        this.runConformModuleTest(files, commandLine, "", "");
    }

    public void testIllegalModifierRequiresJavaBase_1() {
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, OUTPUT_DIR, "module-info.java", "module one {\n\trequires transitive java.base;\n}\n");
        this.runNegativeModuleTest(files, new StringBuilder(" --release 24"), "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/module-info.java (at line 2)\n\trequires transitive java.base;\n\t         ^^^^^^^^^^^^^^^^^^^^\nModifier 'transitive' is allowed for dependence on module 'java.base' only when preview is enabled\n----------\n1 problem (1 error)\n", "transitive modifier for java.base are a preview feature");
    }

    public void testIllegalModifierRequiresJavaBase_2() {
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, OUTPUT_DIR, "module-info.java", "module one {\n\trequires static java.base;\n}\n");
        this.runNegativeModuleTest(files, new StringBuilder(" --release 24"), "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/module-info.java (at line 2)\n\trequires static java.base;\n\t         ^^^^^^^^^^^^^^^^\nModifiers are not allowed for dependence on module 'java.base'\n----------\n1 problem (1 error)\n", "modifier static not allowed here");
    }

    public void testIllegalModifierRequiresJavaBase_3() throws IOException, ClassFormatException {
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, OUTPUT_DIR, "module-info.java", "module one {\n\trequires transitive java.base;\n}\n");
        this.runConformModuleTest(files, new StringBuilder(" --release 24 --enable-preview"), "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/module-info.java (at line 2)\n\trequires transitive java.base;\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nYou are using a preview language feature that may or may not be supported in a future release\n----------\n1 problem (1 warning)\n");
        this.verifyClassFile("version 24 : 68.65535", "module-info.class", 4, this.complianceLevel <= 0x440000L);
    }

    public void testIllegalModifierRequiresJavaBase_4() {
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, OUTPUT_DIR, "module-info.java", "module one {\n\trequires static java.base;\n}\n");
        this.runNegativeModuleTest(files, new StringBuilder(" --release 24 --enable-preview"), "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/module-info.java (at line 2)\n\trequires static java.base;\n\t         ^^^^^^^^^^^^^^^^\nModifiers are not allowed for dependence on module 'java.base'\n----------\n1 problem (1 error)\n", "modifier static not allowed here");
    }

    public void testUseRequiresTransitiveJavaBase() throws IOException, ClassFormatException {
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, OUTPUT_DIR, "module-info.java", "module one {\n\trequires transitive java.base;\n}\n");
        this.writeFileCollecting(files, OUTPUT_DIR + File.separator + "p1", "Client.java", "package p1;\nimport module one;\n@SuppressWarnings(\"preview\")\npublic class Client {\n\tBigDecimal num;\n}\n");
        this.runConformModuleTest(files, new StringBuilder(" --release 24 --enable-preview"), "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/module-info.java (at line 2)\n\trequires transitive java.base;\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nYou are using a preview language feature that may or may not be supported in a future release\n----------\n1 problem (1 warning)\n");
        this.verifyClassFile("version 24 : 68.65535", "module-info.class", 4, true);
        this.verifyClassFile("version 24 : 68.65535", "p1/Client.class", 4);
    }
}

