/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.io.File;
import javax.lang.model.SourceVersion;
import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractBatchCompilerTest;
import org.eclipse.jdt.core.tests.util.Util;

public class MultiReleaseJarTests
extends AbstractBatchCompilerTest {
    private boolean isJRE10 = false;

    public MultiReleaseJarTests(String name) {
        super(name);
        try {
            SourceVersion valueOf = SourceVersion.valueOf("RELEASE_10");
            if (valueOf != null) {
                this.isJRE10 = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Test suite() {
        return MultiReleaseJarTests.buildMinimalComplianceTestSuite(MultiReleaseJarTests.testClass(), 64);
    }

    public static Class<?> testClass() {
        return MultiReleaseJarTests.class;
    }

    public void test001() {
        String path = this.getCompilerTestsPluginDirectoryPath() + File.separator + "workspace" + File.separator + "multi.jar";
        String[] libs = new String[]{path};
        this.runNegativeTest(new String[]{"src/X.java", "import a.b.c.MultiVersion1.Inner;\nimport p.q.r.MultiVersion2.Inner;\npublic class X {\n}\n"}, "\"" + OUTPUT_DIR + File.separator + "src/X.java\" -classpath " + path + " --release 8 ", "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/X.java (at line 1)\n\timport a.b.c.MultiVersion1.Inner;\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^\nThe import a.b.c.MultiVersion1.Inner cannot be resolved\n----------\n2. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/X.java (at line 2)\n\timport p.q.r.MultiVersion2.Inner;\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^\nThe import p.q.r.MultiVersion2.Inner cannot be resolved\n----------\n2 problems (2 errors)\n", false);
    }

    public void test002() {
        String path = this.getCompilerTestsPluginDirectoryPath() + File.separator + "workspace" + File.separator + "multi.jar";
        String[] libs = new String[]{path};
        this.runNegativeTest(new String[]{"src/X.java", "import a.b.c.MultiVersion1.Inner;\nimport p.q.r.MultiVersion2.Inner;\npublic class X {\n}\n"}, "\"" + OUTPUT_DIR + File.separator + "src/X.java\" -classpath " + path + " --release 9 ", "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/X.java (at line 1)\n\timport a.b.c.MultiVersion1.Inner;\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^\nThe type a.b.c.MultiVersion1.Inner is not visible\n----------\n1 problem (1 error)\n", false);
    }

    public void test003() {
        String path = this.getCompilerTestsPluginDirectoryPath() + File.separator + "workspace" + File.separator + "multi.jar";
        String[] libs = new String[]{path};
        this.runConformTest(new String[]{"src/X.java", "import p.q.r.MultiVersion3.Inner;\npublic class X {\n  Inner i = null;\n  p.q.r.MultiVersion2.Inner i2 = null;\n}\n"}, "\"" + OUTPUT_DIR + File.separator + "src/X.java\" -classpath " + path + " --release 9 ", "", "", false);
    }

    public void test004() {
        String path = this.getCompilerTestsPluginDirectoryPath() + File.separator + "workspace" + File.separator + "multi.jar";
        String[] libs = new String[]{path};
        this.runNegativeTest(new String[]{"src/X.java", "import p.q.r.MultiVersion3.Inner;\nimport p.q.r.MultiVersion2.Inner;\npublic class X {\n  Inner i = null;\n}\n"}, "\"" + OUTPUT_DIR + File.separator + "src/X.java\" -classpath " + path + " --release 9 ", "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/X.java (at line 2)\n\timport p.q.r.MultiVersion2.Inner;\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^\nThe import p.q.r.MultiVersion2.Inner collides with another import statement\n----------\n1 problem (1 error)\n", false);
    }

    public void test005() {
        Util.flushDirectoryContent(new File(OUTPUT_DIR));
        String path = this.getCompilerTestsPluginDirectoryPath() + File.separator + "workspace" + File.separator + "multi.jar";
        String[] libs = new String[]{path};
        File directory = new File(OUTPUT_DIR + File.separator + "src" + File.separator + "MyModule");
        File out = new File(OUTPUT_DIR + File.separator + "out");
        if (!directory.exists() && !directory.mkdirs()) {
            System.out.println("Could not create " + directory.toString());
            return;
        }
        if (!out.exists() && !out.mkdirs()) {
            System.out.println("Could not create " + directory.toString());
            return;
        }
        this.runNegativeTest(new String[]{"src/MyModule/module-info.java", "module MyModule {\n  requires Version9;\n}", "src/MyModule/p/X.java", "package p;\npublic class X {\n  java.sql.Connection con = null;\n}\n"}, "  -d \"" + out.toString() + "\"  --module-source-path \"" + directory.toString() + "\"  \"" + OUTPUT_DIR + File.separator + "src" + File.separator + "MyModule" + File.separator + "module-info.java\" \"" + OUTPUT_DIR + File.separator + "src" + File.separator + "MyModule" + File.separator + "p" + File.separator + "X.java\"  --module-path " + path + " --release 9 ", "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/MyModule/p/X.java (at line 3)\n\tjava.sql.Connection con = null;\n\t^^^^^^^^^^^^^^^^^^^\nThe type java.sql.Connection is not accessible\n----------\n1 problem (1 error)\n", false);
    }

    public void test006() {
        if (!this.isJRE10) {
            return;
        }
        String path = this.getCompilerTestsPluginDirectoryPath() + File.separator + "workspace" + File.separator + "multi.jar";
        String[] libs = new String[]{path};
        File directory = new File(OUTPUT_DIR + File.separator + "src" + File.separator + "MyModule");
        File out = new File(OUTPUT_DIR + File.separator + "out");
        if (!directory.exists() && !directory.mkdirs()) {
            System.out.println("Could not create " + directory.toString());
            return;
        }
        if (!out.exists() && !directory.mkdirs()) {
            System.out.println("Could not create " + directory.toString());
            return;
        }
        this.runConformTest(new String[]{"src/MyModule/module-info.java", "module MyModule {\n  requires Version10;\n}", "src/MyModule/p/X.java", "package p;\npublic class X {\n  java.sql.Connection con = null;\n}\n"}, "  -d \"" + out.toString() + "\"  --module-source-path \"" + directory.toString() + "\"  \"" + OUTPUT_DIR + File.separator + "src" + File.separator + "MyModule" + File.separator + "module-info.java\" \"" + OUTPUT_DIR + File.separator + "src" + File.separator + "MyModule" + File.separator + "p" + File.separator + "X.java\"  --module-path " + path + " --release 10 ", "", "", false);
    }
}

