/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractComparableTest;
import org.eclipse.jdt.core.tests.util.Util;
import org.eclipse.jdt.internal.compiler.batch.FileSystem;
import org.eclipse.jdt.internal.compiler.batch.Main;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.junit.Assert;

public class NameEnvironmentAnswerListenerTest
extends AbstractComparableTest {
    public NameEnvironmentAnswerListenerTest(String name) {
        super(name);
    }

    public void testNameEnvironmentAnswerListener() throws IOException {
        EclipseBatchCompiler compiler;
        Object path = LIB_DIR;
        if (!((String)path).endsWith(File.separator)) {
            path = (String)path + File.separator;
        }
        String libPath = (String)path + "lib.jar";
        Util.createJar(new String[]{"p/Color.java", "package p;\npublic enum Color {\n\tR, Y;\n\tpublic static Color getColor() {\n\t\treturn R;\n\t}\n}"}, libPath, "17");
        String unusedLibPath = (String)path + "lib_unused.jar";
        Util.createJar(new String[]{"p2/Color.java", "package p2;\npublic enum Color {\n\tR, Y;\n\tpublic static Color getColor() {\n\t\treturn R;\n\t}\n}"}, unusedLibPath, "17");
        String srcDir = (String)path + "src";
        String[] pathsAndContents = new String[]{"s/X.java", "package s;\nimport p.Color;\npublic class X {\n\tpublic static final Color MY = Color.R;\n}"};
        Util.createSourceDir(pathsAndContents, srcDir);
        ArrayList<String> classpath = new ArrayList<String>(Arrays.asList(this.getDefaultClassPaths()));
        classpath.add(libPath);
        classpath.add(unusedLibPath);
        File outputDirectory = new File(Util.getOutputDirectory());
        if (!outputDirectory.isDirectory()) {
            outputDirectory.mkdirs();
        }
        ArrayList<Object> ecjArguments = new ArrayList<Object>();
        ecjArguments.add("-classpath");
        ecjArguments.add(classpath.stream().map(jar -> jar.equals(unusedLibPath) ? String.format("%s[-**/*]", jar) : jar).collect(Collectors.joining(File.pathSeparator)));
        ecjArguments.add("-d");
        ecjArguments.add(outputDirectory.getAbsolutePath());
        ecjArguments.add("--release");
        ecjArguments.add("17");
        ecjArguments.add(srcDir + File.separator + "s" + File.separator + "X.java");
        File logFile = new File(outputDirectory, "compile.log");
        Throwable throwable = null;
        Object var12_12 = null;
        try (PrintWriter log = new PrintWriter(new FileOutputStream(logFile));){
            compiler = new EclipseBatchCompiler(log);
            boolean compileOK = compiler.compile(ecjArguments.toArray(new String[ecjArguments.size()]));
            if (!compileOK) {
                String logOutputString = Util.fileContent(logFile.getAbsolutePath());
                Assert.fail((String)("Compile failed, output: '" + logOutputString + "'"));
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        String libPathExpected = libPath.replace('\\', '/');
        String unusedLibPathExpected = unusedLibPath.replace('\\', '/');
        Set<String> answeredFileNames = compiler.answeredFileNames;
        Assert.assertTrue((String)("must reference p.Color: " + String.valueOf(answeredFileNames)), (boolean)answeredFileNames.stream().anyMatch(s -> s.contains(libPathExpected)));
        Assert.assertFalse((String)("must not reference p2.Color: " + String.valueOf(answeredFileNames)), (boolean)answeredFileNames.stream().anyMatch(s -> s.contains(unusedLibPathExpected)));
    }

    static class EclipseBatchCompiler
    extends Main {
        Set<String> answeredFileNames = new LinkedHashSet<String>();

        public EclipseBatchCompiler(PrintWriter errAndOutWriter) {
            super(errAndOutWriter, errAndOutWriter, false, null, null);
            this.setSeverity("org.eclipse.jdt.core.compiler.problem.forbiddenReference", 1, true);
            this.setSeverity("org.eclipse.jdt.core.compiler.problem.discouragedReference", 1, true);
        }

        public FileSystem getLibraryAccess() {
            FileSystem nameEnvironment = super.getLibraryAccess();
            nameEnvironment.setNameEnvironmentAnswerListener(this::recordNameEnvironmentAnswer);
            return nameEnvironment;
        }

        protected void recordNameEnvironmentAnswer(NameEnvironmentAnswer answer) {
            Assert.assertNotNull((String)"don't call without answer", (Object)answer);
            char[] fileName = null;
            if (answer.getBinaryType() != null) {
                URI uri = answer.getBinaryType().getURI();
                this.answeredFileNames.add(uri.toString());
                return;
            }
            if (answer.getCompilationUnit() != null) {
                fileName = answer.getCompilationUnit().getFileName();
            } else if (answer.getSourceTypes() != null && answer.getSourceTypes().length > 0) {
                fileName = answer.getSourceTypes()[0].getFileName();
            } else if (answer.getResolvedBinding() != null) {
                fileName = answer.getResolvedBinding().getFileName();
            }
            if (fileName != null) {
                this.answeredFileNames.add(new String(fileName));
            }
        }
    }
}

