/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.io.File;
import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;

public class NegativeTypeAnnotationTest
extends AbstractRegressionTest {
    public static Class testClass() {
        return NegativeTypeAnnotationTest.class;
    }

    public static Test suite() {
        return NegativeTypeAnnotationTest.buildMinimalComplianceTestSuite(NegativeTypeAnnotationTest.testClass(), 32);
    }

    public NegativeTypeAnnotationTest(String testName) {
        super(testName);
    }

    public void test001() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X extends @Marker2 Object {}"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X extends @Marker2 Object {}\n\t                        ^^^^^^^\nMarker2 cannot be resolved to a type\n----------\n");
    }

    public void test002() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "import java.io.Serializable;\npublic class X implements @Marker2 Serializable {\n\tprivate static final long serialVersionUID = 1L;\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\tpublic class X implements @Marker2 Serializable {\n\t                           ^^^^^^^\nMarker2 cannot be resolved to a type\n----------\n");
    }

    public void test003() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X extends @Marker Object {}"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X extends @Marker Object {}\n\t                        ^^^^^^\nMarker cannot be resolved to a type\n----------\n");
    }

    public void test004() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X<@Marker T> {}"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X<@Marker T> {}\n\t                ^^^^^^\nMarker cannot be resolved to a type\n----------\n");
    }

    public void test005() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X<@Marker T> {}"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X<@Marker T> {}\n\t                ^^^^^^\nMarker cannot be resolved to a type\n----------\n");
    }

    public void test006() throws Exception {
        this.runNegativeTest(new String[]{"Y.java", "class Y {}\n", "X.java", "public class X extends @A(id=\"Hello, World!\") @B @C('(') Y {\n}"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X extends @A(id=\"Hello, World!\") @B @C('(') Y {\n\t                        ^\nA cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 1)\n\tpublic class X extends @A(id=\"Hello, World!\") @B @C('(') Y {\n\t                                               ^\nB cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 1)\n\tpublic class X extends @A(id=\"Hello, World!\") @B @C('(') Y {\n\t                                                  ^\nC cannot be resolved to a type\n----------\n");
    }

    public void test007() throws Exception {
        this.runNegativeTest(new String[]{"I.java", "interface I {}\n", "J.java", "interface J {}\n", "X.java", "public class X implements @A(id=\"Hello, World!\") I, @B @C('(') J {}"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X implements @A(id=\"Hello, World!\") I, @B @C('(') J {}\n\t                           ^\nA cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 1)\n\tpublic class X implements @A(id=\"Hello, World!\") I, @B @C('(') J {}\n\t                                                     ^\nB cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 1)\n\tpublic class X implements @A(id=\"Hello, World!\") I, @B @C('(') J {}\n\t                                                        ^\nC cannot be resolved to a type\n----------\n");
    }

    public void test010() throws Exception {
        this.runNegativeTest(new String[]{"Y.java", "class Y<T> {}\n", "X.java", "public class X extends @A(\"Hello, World!\") Y<@B @C('(') String> {\n}"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X extends @A(\"Hello, World!\") Y<@B @C('(') String> {\n\t                        ^\nA cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 1)\n\tpublic class X extends @A(\"Hello, World!\") Y<@B @C('(') String> {\n\t                                              ^\nB cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 1)\n\tpublic class X extends @A(\"Hello, World!\") Y<@B @C('(') String> {\n\t                                                 ^\nC cannot be resolved to a type\n----------\n");
    }

    public void test011() throws Exception {
        this.runNegativeTest(new String[]{"I.java", "interface I<T> {}\n", "J.java", "interface J<T> {}\n", "X.java", "public class X implements I<@A(\"Hello, World!\") String>,  @B J<@C('(') Integer> {}"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X implements I<@A(\"Hello, World!\") String>,  @B J<@C('(') Integer> {}\n\t                             ^\nA cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 1)\n\tpublic class X implements I<@A(\"Hello, World!\") String>,  @B J<@C('(') Integer> {}\n\t                                                           ^\nB cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 1)\n\tpublic class X implements I<@A(\"Hello, World!\") String>,  @B J<@C('(') Integer> {}\n\t                                                                ^\nC cannot be resolved to a type\n----------\n");
    }

    public void test012() throws Exception {
        this.runNegativeTest(new String[]{"E.java", "class E extends RuntimeException {\n\tprivate static final long serialVersionUID = 1L;\n}\n", "E1.java", "class E1 extends RuntimeException {\n\tprivate static final long serialVersionUID = 1L;\n}\n", "E2.java", "class E2 extends RuntimeException {\n\tprivate static final long serialVersionUID = 1L;\n}\n", "X.java", "public class X {\n\tvoid foo() throws @A(\"Hello, World!\") E, E1, @B @C('(') E2 {}\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\tvoid foo() throws @A(\"Hello, World!\") E, E1, @B @C('(') E2 {}\n\t                   ^\nA cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 2)\n\tvoid foo() throws @A(\"Hello, World!\") E, E1, @B @C('(') E2 {}\n\t                                              ^\nB cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 2)\n\tvoid foo() throws @A(\"Hello, World!\") E, E1, @B @C('(') E2 {}\n\t                                                 ^\nC cannot be resolved to a type\n----------\n");
    }

    public void test013() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo(@B(3) X this) {}\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\tvoid foo(@B(3) X this) {}\n\t          ^\nB cannot be resolved to a type\n----------\n");
    }

    public void test014() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t@B(3) int foo() {\n\t\treturn 1;\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\t@B(3) int foo() {\n\t ^\nB cannot be resolved to a type\n----------\n");
    }

    public void test015() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t@B(3) int field;\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\t@B(3) int field;\n\t ^\nB cannot be resolved to a type\n----------\n");
    }

    public void test016() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tint foo(@B(3) String s) {\n\t\treturn s.length();\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\tint foo(@B(3) String s) {\n\t         ^\nB cannot be resolved to a type\n----------\n");
    }

    public void test017() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tint foo(String @B(3) [] s) {\n\t\treturn s.length;\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\tint foo(String @B(3) [] s) {\n\t                ^\nB cannot be resolved to a type\n----------\n");
    }

    public void test018() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tint @B(3) [] field;\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\tint @B(3) [] field;\n\t     ^\nB cannot be resolved to a type\n----------\n");
    }

    public void test019() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X<@A @B(3) T> {}"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X<@A @B(3) T> {}\n\t                ^\nA cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 1)\n\tpublic class X<@A @B(3) T> {}\n\t                   ^\nB cannot be resolved to a type\n----------\n");
    }

    public void test020() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t<@A @B(3) T> void foo(T t) {}\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\t<@A @B(3) T> void foo(T t) {}\n\t  ^\nA cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 2)\n\t<@A @B(3) T> void foo(T t) {}\n\t     ^\nB cannot be resolved to a type\n----------\n");
    }

    public void test021() throws Exception {
        this.runNegativeTest(new String[]{"Z.java", "public class Z {}", "X.java", "public class X<T extends @A Z & @B(3) Cloneable> {}"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X<T extends @A Z & @B(3) Cloneable> {}\n\t                          ^\nA cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 1)\n\tpublic class X<T extends @A Z & @B(3) Cloneable> {}\n\t                                 ^\nB cannot be resolved to a type\n----------\n");
    }

    public void test022() throws Exception {
        this.runNegativeTest(new String[]{"Y.java", "public class Y<T> {}", "X.java", "public class X<T extends Y<@A String @C[][]@B[]> & @B(3) Cloneable> {}"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X<T extends Y<@A String @C[][]@B[]> & @B(3) Cloneable> {}\n\t                            ^\nA cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 1)\n\tpublic class X<T extends Y<@A String @C[][]@B[]> & @B(3) Cloneable> {}\n\t                                      ^\nC cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 1)\n\tpublic class X<T extends Y<@A String @C[][]@B[]> & @B(3) Cloneable> {}\n\t                                            ^\nB cannot be resolved to a type\n----------\n4. ERROR in X.java (at line 1)\n\tpublic class X<T extends Y<@A String @C[][]@B[]> & @B(3) Cloneable> {}\n\t                                                    ^\nB cannot be resolved to a type\n----------\n");
    }

    public void test023() throws Exception {
        this.runNegativeTest(new String[]{"Z.java", "public class Z {}", "X.java", "public class X {\n\t<T extends @A Z & @B(3) Cloneable> void foo(T t) {}\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\t<T extends @A Z & @B(3) Cloneable> void foo(T t) {}\n\t            ^\nA cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 2)\n\t<T extends @A Z & @B(3) Cloneable> void foo(T t) {}\n\t                   ^\nB cannot be resolved to a type\n----------\n");
    }

    public void test024() throws Exception {
        this.runNegativeTest(new String[]{"Z.java", "public class Z {}", "Y.java", "public class Y<T> {}", "X.java", "public class X {\n\t<T extends Y<@A Z @C[][]@B[]> & @B(3) Cloneable> void foo(T t) {}\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\t<T extends Y<@A Z @C[][]@B[]> & @B(3) Cloneable> void foo(T t) {}\n\t              ^\nA cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 2)\n\t<T extends Y<@A Z @C[][]@B[]> & @B(3) Cloneable> void foo(T t) {}\n\t                   ^\nC cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 2)\n\t<T extends Y<@A Z @C[][]@B[]> & @B(3) Cloneable> void foo(T t) {}\n\t                         ^\nB cannot be resolved to a type\n----------\n4. ERROR in X.java (at line 2)\n\t<T extends Y<@A Z @C[][]@B[]> & @B(3) Cloneable> void foo(T t) {}\n\t                                 ^\nB cannot be resolved to a type\n----------\n");
    }

    public void test025() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo(String s) {\n\t\t@C int i;\n\t\t@A String [] @B(3)[] tab = new String[][] {};\n\t\tif (tab != null) {\n\t\t\ti = 0;\n\t\t\tSystem.out.println(i + tab.length);\n\t\t} else {\n\t\t\tSystem.out.println(tab.length);\n\t\t}\n\t\ti = 4;\n\t\tSystem.out.println(-i + tab.length);\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\t@C int i;\n\t ^\nC cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 4)\n\t@A String [] @B(3)[] tab = new String[][] {};\n\t ^\nA cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 4)\n\t@A String [] @B(3)[] tab = new String[][] {};\n\t              ^\nB cannot be resolved to a type\n----------\n");
    }

    public void test026() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t<T> X(T t) {\n\t}\n\tpublic Object foo() {\n\t\tX x = new <@A @B(1) String>X(null);\n\t\treturn x;\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 5)\n\tX x = new <@A @B(1) String>X(null);\n\t            ^\nA cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 5)\n\tX x = new <@A @B(1) String>X(null);\n\t               ^\nB cannot be resolved to a type\n----------\n");
    }

    public void test027() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t<T> X(T t) {\n\t}\n\tpublic Object foo() {\n\t\tX x = new <@A @B(1) String>X(null);\n\t\treturn x;\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 5)\n\tX x = new <@A @B(1) String>X(null);\n\t            ^\nA cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 5)\n\tX x = new <@A @B(1) String>X(null);\n\t               ^\nB cannot be resolved to a type\n----------\n");
    }

    public void test028() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\n\tstatic <T, U> T foo(T t, U u) {\n\t\treturn t;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(X.<@A @B(1) String[], @C('-') X>foo(new String[]{\"SUCCESS\"}, null)[0]);\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tSystem.out.println(X.<@A @B(1) String[], @C('-') X>foo(new String[]{\"SUCCESS\"}, null)[0]);\n\t                       ^\nA cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 7)\n\tSystem.out.println(X.<@A @B(1) String[], @C('-') X>foo(new String[]{\"SUCCESS\"}, null)[0]);\n\t                          ^\nB cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 7)\n\tSystem.out.println(X.<@A @B(1) String[], @C('-') X>foo(new String[]{\"SUCCESS\"}, null)[0]);\n\t                                          ^\nC cannot be resolved to a type\n----------\n");
    }

    public void test029() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X extends @Marker2 Object {}"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X extends @Marker2 Object {}\n\t                        ^^^^^^^\nMarker2 cannot be resolved to a type\n----------\n");
    }

    public void test030() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "import java.io.Serializable;\npublic class X implements @Marker2 Serializable {\n\tprivate static final long serialVersionUID = 1L;\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\tpublic class X implements @Marker2 Serializable {\n\t                           ^^^^^^^\nMarker2 cannot be resolved to a type\n----------\n");
    }

    public void test031() throws Exception {
        this.runNegativeTest(new String[]{"Marker.java", "import java.lang.annotation.Target;\nimport static java.lang.annotation.ElementType.*;\n@Target(TYPE)\n@interface Marker {}", "X.java", "public class X<@Marker T> {}", "java/lang/annotation/ElementType.java", "package java.lang.annotation;\npublic enum ElementType {\n    TYPE,\n    FIELD,\n    METHOD,\n    PARAMETER,\n    CONSTRUCTOR,\n    LOCAL_VARIABLE,\n    ANNOTATION_TYPE,\n    PACKAGE,\n    TYPE_PARAMETER,\n    TYPE_USE\n}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X<@Marker T> {}\n\t               ^^^^^^^\nThe annotation @Marker is disallowed for this location\n----------\n");
    }

    public void test032() throws Exception {
        this.runConformTest(new String[]{"Marker.java", "@interface Marker {}", "X.java", "public class X<@Marker T> {}"}, "");
    }

    public void test033() throws Exception {
        this.runNegativeTest(new String[]{"Marker.java", "@interface Marker {}", "Y.java", "public class Y {}", "X.java", "public class X extends @Marker Y {}"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X extends @Marker Y {}\n\t                       ^^^^^^^\nAnnotation types that do not specify explicit target element types cannot be applied here\n----------\n");
    }

    public void test034() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "import java.util.Map;\nimport java.util.List;\npublic class X {\n\t@H String @E[] @F[] @G[] field;\n\t@A Map<@B String, @C List<@D Object>> field2;\n\t@A Map<@B String, @H String @E[] @F[] @G[]> field3;\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\t@H String @E[] @F[] @G[] field;\n\t ^\nH cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 4)\n\t@H String @E[] @F[] @G[] field;\n\t           ^\nE cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 4)\n\t@H String @E[] @F[] @G[] field;\n\t                ^\nF cannot be resolved to a type\n----------\n4. ERROR in X.java (at line 4)\n\t@H String @E[] @F[] @G[] field;\n\t                     ^\nG cannot be resolved to a type\n----------\n5. ERROR in X.java (at line 5)\n\t@A Map<@B String, @C List<@D Object>> field2;\n\t ^\nA cannot be resolved to a type\n----------\n6. ERROR in X.java (at line 5)\n\t@A Map<@B String, @C List<@D Object>> field2;\n\t        ^\nB cannot be resolved to a type\n----------\n7. ERROR in X.java (at line 5)\n\t@A Map<@B String, @C List<@D Object>> field2;\n\t                   ^\nC cannot be resolved to a type\n----------\n8. ERROR in X.java (at line 5)\n\t@A Map<@B String, @C List<@D Object>> field2;\n\t                           ^\nD cannot be resolved to a type\n----------\n9. ERROR in X.java (at line 6)\n\t@A Map<@B String, @H String @E[] @F[] @G[]> field3;\n\t ^\nA cannot be resolved to a type\n----------\n10. ERROR in X.java (at line 6)\n\t@A Map<@B String, @H String @E[] @F[] @G[]> field3;\n\t        ^\nB cannot be resolved to a type\n----------\n11. ERROR in X.java (at line 6)\n\t@A Map<@B String, @H String @E[] @F[] @G[]> field3;\n\t                   ^\nH cannot be resolved to a type\n----------\n12. ERROR in X.java (at line 6)\n\t@A Map<@B String, @H String @E[] @F[] @G[]> field3;\n\t                             ^\nE cannot be resolved to a type\n----------\n13. ERROR in X.java (at line 6)\n\t@A Map<@B String, @H String @E[] @F[] @G[]> field3;\n\t                                  ^\nF cannot be resolved to a type\n----------\n14. ERROR in X.java (at line 6)\n\t@A Map<@B String, @H String @E[] @F[] @G[]> field3;\n\t                                       ^\nG cannot be resolved to a type\n----------\n");
    }

    public void test035() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "import java.util.Map;\nimport java.util.List;\npublic class X {\n\t@H java.lang.String @E[] @F[] @G[] field;\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\t@H java.lang.String @E[] @F[] @G[] field;\n\t ^\nH cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 4)\n\t@H java.lang.String @E[] @F[] @G[] field;\n\t                     ^\nE cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 4)\n\t@H java.lang.String @E[] @F[] @G[] field;\n\t                          ^\nF cannot be resolved to a type\n----------\n4. ERROR in X.java (at line 4)\n\t@H java.lang.String @E[] @F[] @G[] field;\n\t                               ^\nG cannot be resolved to a type\n----------\n");
    }

    public void test036() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args) {\n    System.out.println(int @NonEmpty [] [] @NonEmpty @Empty [] [] @NonEmpty[].class); // illegal!\n    System.out.println(X @NonEmpty [] [] @NonEmpty @Empty [] [] @NonEmpty[].class); // illegal!\n    System.out.println(int [] [] [] [] [].class);\n    System.out.println(X [] [] [] [] [].class);\n  }\n}\n@interface Empty {\n}\n@interface NonEmpty {\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tSystem.out.println(int @NonEmpty [] [] @NonEmpty @Empty [] [] @NonEmpty[].class); // illegal!\n\t                       ^^^^^^^^^\nSyntax error, type annotations are illegal here\n----------\n2. ERROR in X.java (at line 3)\n\tSystem.out.println(int @NonEmpty [] [] @NonEmpty @Empty [] [] @NonEmpty[].class); // illegal!\n\t                                       ^^^^^^^^^^^^^^^^\nSyntax error, type annotations are illegal here\n----------\n3. ERROR in X.java (at line 3)\n\tSystem.out.println(int @NonEmpty [] [] @NonEmpty @Empty [] [] @NonEmpty[].class); // illegal!\n\t                                                              ^^^^^^^^^\nSyntax error, type annotations are illegal here\n----------\n4. ERROR in X.java (at line 4)\n\tSystem.out.println(X @NonEmpty [] [] @NonEmpty @Empty [] [] @NonEmpty[].class); // illegal!\n\t                     ^^^^^^^^^\nSyntax error, type annotations are illegal here\n----------\n5. ERROR in X.java (at line 4)\n\tSystem.out.println(X @NonEmpty [] [] @NonEmpty @Empty [] [] @NonEmpty[].class); // illegal!\n\t                                     ^^^^^^^^^^^^^^^^\nSyntax error, type annotations are illegal here\n----------\n6. ERROR in X.java (at line 4)\n\tSystem.out.println(X @NonEmpty [] [] @NonEmpty @Empty [] [] @NonEmpty[].class); // illegal!\n\t                                                            ^^^^^^^^^\nSyntax error, type annotations are illegal here\n----------\n");
    }

    public void test037() {
        this.runNegativeTest(new String[]{"X.java", "@interface Marker {}\n@Marker\t// line 2: Don't complain \npublic class X<@Marker T>  extends @Marker Object{\t\t// 3: Complain only on super type and not on class type parameter\n\tpublic @Marker Object foo(@Marker Object obj) {  // 4: Don't complain on both\n\t\treturn null;\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tpublic class X<@Marker T>  extends @Marker Object{\t\t// 3: Complain only on super type and not on class type parameter\n\t                                   ^^^^^^^\nAnnotation types that do not specify explicit target element types cannot be applied here\n----------\n");
    }

    public void test038() {
        this.runNegativeTest(new String[]{"X.java", "import java.lang.annotation.Target;\nimport static java.lang.annotation.ElementType.*;\n@Target({PACKAGE, TYPE, METHOD, FIELD, CONSTRUCTOR, PARAMETER, LOCAL_VARIABLE})\n@interface Marker {}\npublic class X<@Marker T>  extends @Marker Object{\t\t// 3: Complain \n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tpublic class X<@Marker T>  extends @Marker Object{\t\t// 3: Complain \n\t               ^^^^^^^\nThe annotation @Marker is disallowed for this location\n----------\n2. ERROR in X.java (at line 5)\n\tpublic class X<@Marker T>  extends @Marker Object{\t\t// 3: Complain \n\t                                   ^^^^^^^\nThe annotation @Marker is disallowed for this location\n----------\n");
    }

    public void test039() {
        this.runNegativeTest(new String[]{"X.java", "import @Marker java.lang.String; // Compilation error \npublic class X { \n}\n@interface Marker {}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\timport @Marker java.lang.String; // Compilation error \n\t       ^^^^^^^\nSyntax error, type annotations are illegal here\n----------\n");
    }

    public void test040() {
        this.runNegativeTest(new String[]{"X.java", "public class X { \n\tpublic void foo(Object myObject) {\n\t\tString myString = (@NonNull) myObject;\t}\n}\n@interface NonNull {}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tString myString = (@NonNull) myObject;\t}\n\t                   ^\nSyntax error on token \"@\", delete this token\n----------\n");
    }

    public void test0385111() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.ArrayList;\nimport java.util.List;\npublic class X {\n    public void foo(String fileName) {\n        List<String> l = new @MissingTypeNotIgnored ArrayList<String>();\n        List<String> l1 = new @MissingTypeIgnored ArrayList<>();\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tList<String> l = new @MissingTypeNotIgnored ArrayList<String>();\n\t                      ^^^^^^^^^^^^^^^^^^^^^\nMissingTypeNotIgnored cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 6)\n\tList<String> l1 = new @MissingTypeIgnored ArrayList<>();\n\t                       ^^^^^^^^^^^^^^^^^^\nMissingTypeIgnored cannot be resolved to a type\n----------\n");
    }

    public void test0385111a() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    public void foo(String fileName) {\n        try (@Annot X x = null; @Annot X x2 = null) {\n        } catch (@Annot NullPointerException | @Annot UnsupportedOperationException e) {\n        }\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\ttry (@Annot X x = null; @Annot X x2 = null) {\n\t      ^^^^^\nAnnot cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 3)\n\ttry (@Annot X x = null; @Annot X x2 = null) {\n\t            ^\nThe resource type X does not implement java.lang.AutoCloseable\n----------\n3. ERROR in X.java (at line 3)\n\ttry (@Annot X x = null; @Annot X x2 = null) {\n\t                         ^^^^^\nAnnot cannot be resolved to a type\n----------\n4. ERROR in X.java (at line 3)\n\ttry (@Annot X x = null; @Annot X x2 = null) {\n\t                               ^\nThe resource type X does not implement java.lang.AutoCloseable\n----------\n5. ERROR in X.java (at line 4)\n\t} catch (@Annot NullPointerException | @Annot UnsupportedOperationException e) {\n\t          ^^^^^\nAnnot cannot be resolved to a type\n----------\n6. ERROR in X.java (at line 4)\n\t} catch (@Annot NullPointerException | @Annot UnsupportedOperationException e) {\n\t                                        ^^^^^\nAnnot cannot be resolved to a type\n----------\n");
    }

    public void test0383913() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic void foo(Object obj, X this) {}\n\tpublic void foo(Object obj1, X this, Object obj2) {}\n\tpublic void foo(Object obj, Object obj2, Object obj3, X this) {}\n\tclass Y {\n\t\tY(Object obj, Y Y.this){}\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\tpublic void foo(Object obj, X this) {}\n\t                              ^^^^\nOnly the first formal parameter may be declared explicitly as 'this'\n----------\n2. ERROR in X.java (at line 3)\n\tpublic void foo(Object obj1, X this, Object obj2) {}\n\t                               ^^^^\nOnly the first formal parameter may be declared explicitly as 'this'\n----------\n3. ERROR in X.java (at line 4)\n\tpublic void foo(Object obj, Object obj2, Object obj3, X this) {}\n\t                                                        ^^^^\nOnly the first formal parameter may be declared explicitly as 'this'\n----------\n4. ERROR in X.java (at line 6)\n\tY(Object obj, Y Y.this){}\n\t                  ^^^^\nOnly the first formal parameter may be declared explicitly as 'this'\n----------\n");
    }

    public void test0383913b() {
        this.runNegativeTest(new String[]{"Outer.java", "public class Outer {\n    Outer(Outer Outer.this) {}\n    Outer(Outer this, int i) {}\n    class Inner<K,V> {\n        class InnerMost<T> {\n            InnerMost(Outer.Inner this) {}\n            InnerMost(Outer.Inner Outer.Inner.this, int i, float f) {}\n            InnerMost(Outer Outer.this, float f) {}\n            InnerMost(Outer.Inner<K,V>.InnerMost<T> Outer.Inner.InnerMost.this, Object obj) {}\n            InnerMost(Inner<K,V> Outer.Inner.InnerMost.this, int i) {}\n            InnerMost(Outer.Inner<K, V> this, float f, int i) {}\n            InnerMost(Outer.Inner<K,V> Inner.this, long l) {}\n        }\n    }\n}\n"}, "----------\n1. ERROR in Outer.java (at line 2)\n\tOuter(Outer Outer.this) {}\n\t                  ^^^^\nExplicit 'this' parameter is allowed only in instance methods of non-anonymous classes and inner class constructors\n----------\n2. ERROR in Outer.java (at line 3)\n\tOuter(Outer this, int i) {}\n\t            ^^^^\nExplicit 'this' parameter is allowed only in instance methods of non-anonymous classes and inner class constructors\n----------\n3. WARNING in Outer.java (at line 6)\n\tInnerMost(Outer.Inner this) {}\n\t          ^^^^^^^^^^^\nOuter.Inner is a raw type. References to generic type Outer.Inner<K,V> should be parameterized\n----------\n4. ERROR in Outer.java (at line 6)\n\tInnerMost(Outer.Inner this) {}\n\t          ^^^^^^^^^^^\nThe declared type of the explicit 'this' parameter is expected to be Outer.Inner<K,V>\n----------\n5. ERROR in Outer.java (at line 6)\n\tInnerMost(Outer.Inner this) {}\n\t                      ^^^^\nThe explicit 'this' parameter is expected to be qualified with Inner\n----------\n6. WARNING in Outer.java (at line 7)\n\tInnerMost(Outer.Inner Outer.Inner.this, int i, float f) {}\n\t          ^^^^^^^^^^^\nOuter.Inner is a raw type. References to generic type Outer.Inner<K,V> should be parameterized\n----------\n7. ERROR in Outer.java (at line 7)\n\tInnerMost(Outer.Inner Outer.Inner.this, int i, float f) {}\n\t          ^^^^^^^^^^^\nThe declared type of the explicit 'this' parameter is expected to be Outer.Inner<K,V>\n----------\n8. ERROR in Outer.java (at line 7)\n\tInnerMost(Outer.Inner Outer.Inner.this, int i, float f) {}\n\t                      ^^^^^^^^^^^^^^^^\nThe explicit 'this' parameter is expected to be qualified with Inner\n----------\n9. ERROR in Outer.java (at line 8)\n\tInnerMost(Outer Outer.this, float f) {}\n\t          ^^^^^\nThe declared type of the explicit 'this' parameter is expected to be Outer.Inner<K,V>\n----------\n10. ERROR in Outer.java (at line 8)\n\tInnerMost(Outer Outer.this, float f) {}\n\t                ^^^^^^^^^^\nThe explicit 'this' parameter is expected to be qualified with Inner\n----------\n11. ERROR in Outer.java (at line 9)\n\tInnerMost(Outer.Inner<K,V>.InnerMost<T> Outer.Inner.InnerMost.this, Object obj) {}\n\t          ^^^^^^^^^^^^^^^^^^^^^^^^^^\nThe declared type of the explicit 'this' parameter is expected to be Outer.Inner<K,V>\n----------\n12. ERROR in Outer.java (at line 9)\n\tInnerMost(Outer.Inner<K,V>.InnerMost<T> Outer.Inner.InnerMost.this, Object obj) {}\n\t                                        ^^^^^^^^^^^^^^^^^^^^^^^^^^\nThe explicit 'this' parameter is expected to be qualified with Inner\n----------\n13. ERROR in Outer.java (at line 10)\n\tInnerMost(Inner<K,V> Outer.Inner.InnerMost.this, int i) {}\n\t                     ^^^^^^^^^^^^^^^^^^^^^^^^^^\nThe explicit 'this' parameter is expected to be qualified with Inner\n----------\n14. ERROR in Outer.java (at line 11)\n\tInnerMost(Outer.Inner<K, V> this, float f, int i) {}\n\t                            ^^^^\nThe explicit 'this' parameter is expected to be qualified with Inner\n----------\n");
    }

    public void test0383913c() {
        this.runNegativeTest(new String[]{"Outer.java", "public class Outer {\n    class Inner<K,V> {\n        class InnerMost<T> {\n            public void foo(Outer Outer.this) {}\n            public void foo(Inner<K,V> Inner.this, int i) {}\n            public void foo(InnerMost this, int i, int j) {}\n            public void foo(Inner.InnerMost<T> this, Object obj) {}\n            public void foo(InnerMost<T> this, float f) {}\n            public void foo(Inner<K,V>.InnerMost<T> this, long l) {}\n            public void foo(Outer.Inner<K,V>.InnerMost<T> this, float f, float ff) {}\n            public void foo(InnerMost<T> Outer.Inner.InnerMost.this, int i, float f) {}\n        }\n    }\n}\n"}, "----------\n1. ERROR in Outer.java (at line 4)\n\tpublic void foo(Outer Outer.this) {}\n\t                ^^^^^\nThe declared type of the explicit 'this' parameter is expected to be Outer.Inner<K,V>.InnerMost<T>\n----------\n2. ERROR in Outer.java (at line 4)\n\tpublic void foo(Outer Outer.this) {}\n\t                      ^^^^^^^^^^\nThe explicit 'this' parameter for a method cannot have a qualifying name\n----------\n3. ERROR in Outer.java (at line 5)\n\tpublic void foo(Inner<K,V> Inner.this, int i) {}\n\t                ^^^^^\nThe declared type of the explicit 'this' parameter is expected to be Outer.Inner<K,V>.InnerMost<T>\n----------\n4. ERROR in Outer.java (at line 5)\n\tpublic void foo(Inner<K,V> Inner.this, int i) {}\n\t                           ^^^^^^^^^^\nThe explicit 'this' parameter for a method cannot have a qualifying name\n----------\n5. WARNING in Outer.java (at line 6)\n\tpublic void foo(InnerMost this, int i, int j) {}\n\t                ^^^^^^^^^\nOuter.Inner.InnerMost is a raw type. References to generic type Outer.Inner<K,V>.InnerMost<T> should be parameterized\n----------\n6. ERROR in Outer.java (at line 6)\n\tpublic void foo(InnerMost this, int i, int j) {}\n\t                ^^^^^^^^^\nThe declared type of the explicit 'this' parameter is expected to be Outer.Inner<K,V>.InnerMost<T>\n----------\n7. ERROR in Outer.java (at line 7)\n\tpublic void foo(Inner.InnerMost<T> this, Object obj) {}\n\t                ^^^^^^^^^^^^^^^\nThe member type Outer.Inner.InnerMost<T> must be qualified with a parameterized type, since it is not static\n----------\n8. ERROR in Outer.java (at line 7)\n\tpublic void foo(Inner.InnerMost<T> this, Object obj) {}\n\t                ^^^^^^^^^^^^^^^\nThe declared type of the explicit 'this' parameter is expected to be Outer.Inner<K,V>.InnerMost<T>\n----------\n9. ERROR in Outer.java (at line 11)\n\tpublic void foo(InnerMost<T> Outer.Inner.InnerMost.this, int i, float f) {}\n\t                             ^^^^^^^^^^^^^^^^^^^^^^^^^^\nThe explicit 'this' parameter for a method cannot have a qualifying name\n----------\n");
    }

    public void test0383913d() {
        this.runNegativeTest(new String[]{"Outer.java", "import java.lang.annotation.Target;\nimport static java.lang.annotation.ElementType.*;\npublic class Outer {\n    class Inner<K,V> {\n\t\tpublic Inner(@Missing Outer Outer.this) {}\n        class InnerMost<T> {\n            public void bar() {\n                new AnonymousInner() {\n                    public void foobar(AnonymousInner this) {}\n                };\n            }\n            void bar(int i) {\n                class Local {\n                    public int hashCode(Local this, int k) { return 0; }\n                    public int hashCode(Outer.Local this) { return 0; }\n                }\n            }\n        }\n    }\n    static class StaticNested {\n        public StaticNested(@Marker Outer.StaticNested Outer.StaticNested.this) {}\n    }\n    public static void foo(@Marker Outer this) {}\n    public void foo(@Missing Outer this, int i) {}\n}\ninterface AnonymousInner {\n    public void foobar(AnonymousInner this);\n}\n@Target(TYPE_USE)\n@interface Marker {}", "java/lang/annotation/ElementType.java", "package java.lang.annotation;\npublic enum ElementType {\n    TYPE,\n    FIELD,\n    METHOD,\n    PARAMETER,\n    CONSTRUCTOR,\n    LOCAL_VARIABLE,\n    ANNOTATION_TYPE,\n    PACKAGE,\n    TYPE_PARAMETER,\n    TYPE_USE\n}\n"}, "----------\n1. ERROR in Outer.java (at line 5)\n\tpublic Inner(@Missing Outer Outer.this) {}\n\t              ^^^^^^^\nMissing cannot be resolved to a type\n----------\n2. ERROR in Outer.java (at line 9)\n\tpublic void foobar(AnonymousInner this) {}\n\t                                  ^^^^\nExplicit 'this' parameter is allowed only in instance methods of non-anonymous classes and inner class constructors\n----------\n3. ERROR in Outer.java (at line 15)\n\tpublic int hashCode(Outer.Local this) { return 0; }\n\t                    ^^^^^^^^^^^\nOuter.Local cannot be resolved to a type\n----------\n4. ERROR in Outer.java (at line 21)\n\tpublic StaticNested(@Marker Outer.StaticNested Outer.StaticNested.this) {}\n\t                    ^^^^^^^\nType annotations are not allowed on type names used to access static members\n----------\n5. ERROR in Outer.java (at line 21)\n\tpublic StaticNested(@Marker Outer.StaticNested Outer.StaticNested.this) {}\n\t                                                                  ^^^^\nExplicit 'this' parameter is allowed only in instance methods of non-anonymous classes and inner class constructors\n----------\n6. ERROR in Outer.java (at line 23)\n\tpublic static void foo(@Marker Outer this) {}\n\t                                     ^^^^\nExplicit 'this' parameter is allowed only in instance methods of non-anonymous classes and inner class constructors\n----------\n7. ERROR in Outer.java (at line 24)\n\tpublic void foo(@Missing Outer this, int i) {}\n\t                 ^^^^^^^\nMissing cannot be resolved to a type\n----------\n");
    }

    public void test0383908() {
        this.runNegativeTest(new String[]{"X.java", "public class X { \n\tvoid foo(X this) {}\n   void foo() {}\n}\nclass Y {\n\tvoid foo(Y this) {}\n\tpublic static void main(String[] args) {\n\t\tnew Y().foo();\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\tvoid foo(X this) {}\n\t     ^^^^^^^^^^^\nDuplicate method foo() in type X\n----------\n2. ERROR in X.java (at line 3)\n\tvoid foo() {}\n\t     ^^^^^\nDuplicate method foo() in type X\n----------\n");
    }

    public void test383596() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "package p. @Marker q.x. @Marker @Marker y. @Marker @Marker @Marker z. z2;\npublic class X {\n}"}, "----------\n1. ERROR in X.java (at line 1)\n\tpackage p. @Marker q.x. @Marker @Marker y. @Marker @Marker @Marker z. z2;\n\t           ^^^^^^^\nSyntax error, type annotations are illegal here\n----------\n2. ERROR in X.java (at line 1)\n\tpackage p. @Marker q.x. @Marker @Marker y. @Marker @Marker @Marker z. z2;\n\t                        ^^^^^^^^^^^^^^^\nSyntax error, type annotations are illegal here\n----------\n3. ERROR in X.java (at line 1)\n\tpackage p. @Marker q.x. @Marker @Marker y. @Marker @Marker @Marker z. z2;\n\t                                           ^^^^^^^^^^^^^^^^^^^^^^^\nSyntax error, type annotations are illegal here\n----------\n");
    }

    public void test383596a() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "@Marker package p. @Marker q.x. @Marker @Marker y. @Marker @Marker @Marker z. z2;\npublic class X {\n}"}, "----------\n1. ERROR in X.java (at line 1)\n\t@Marker package p. @Marker q.x. @Marker @Marker y. @Marker @Marker @Marker z. z2;\n\t^^^^^^^\nPackage annotations must be in file package-info.java\n----------\n2. ERROR in X.java (at line 1)\n\t@Marker package p. @Marker q.x. @Marker @Marker y. @Marker @Marker @Marker z. z2;\n\t                   ^^^^^^^\nSyntax error, type annotations are illegal here\n----------\n3. ERROR in X.java (at line 1)\n\t@Marker package p. @Marker q.x. @Marker @Marker y. @Marker @Marker @Marker z. z2;\n\t                                ^^^^^^^^^^^^^^^\nSyntax error, type annotations are illegal here\n----------\n4. ERROR in X.java (at line 1)\n\t@Marker package p. @Marker q.x. @Marker @Marker y. @Marker @Marker @Marker z. z2;\n\t                                                   ^^^^^^^^^^^^^^^^^^^^^^^\nSyntax error, type annotations are illegal here\n----------\n");
    }

    public void test039b() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "import p. @Marker q.x. @Marker @Marker y. @Marker @Marker @Marker z. z2;\npublic class X {\n}"}, "----------\n1. ERROR in X.java (at line 1)\n\timport p. @Marker q.x. @Marker @Marker y. @Marker @Marker @Marker z. z2;\n\t       ^\nThe import p cannot be resolved\n----------\n2. ERROR in X.java (at line 1)\n\timport p. @Marker q.x. @Marker @Marker y. @Marker @Marker @Marker z. z2;\n\t          ^^^^^^^\nSyntax error, type annotations are illegal here\n----------\n3. ERROR in X.java (at line 1)\n\timport p. @Marker q.x. @Marker @Marker y. @Marker @Marker @Marker z. z2;\n\t                       ^^^^^^^^^^^^^^^\nSyntax error, type annotations are illegal here\n----------\n4. ERROR in X.java (at line 1)\n\timport p. @Marker q.x. @Marker @Marker y. @Marker @Marker @Marker z. z2;\n\t                                          ^^^^^^^^^^^^^^^^^^^^^^^\nSyntax error, type annotations are illegal here\n----------\n");
    }

    public void test383596b() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "import p. @Marker q.x. @Marker @Marker y. @Marker @Marker @Marker z.*;\npublic class X {\n}"}, "----------\n1. ERROR in X.java (at line 1)\n\timport p. @Marker q.x. @Marker @Marker y. @Marker @Marker @Marker z.*;\n\t       ^\nThe import p cannot be resolved\n----------\n2. ERROR in X.java (at line 1)\n\timport p. @Marker q.x. @Marker @Marker y. @Marker @Marker @Marker z.*;\n\t          ^^^^^^^\nSyntax error, type annotations are illegal here\n----------\n3. ERROR in X.java (at line 1)\n\timport p. @Marker q.x. @Marker @Marker y. @Marker @Marker @Marker z.*;\n\t                       ^^^^^^^^^^^^^^^\nSyntax error, type annotations are illegal here\n----------\n4. ERROR in X.java (at line 1)\n\timport p. @Marker q.x. @Marker @Marker y. @Marker @Marker @Marker z.*;\n\t                                          ^^^^^^^^^^^^^^^^^^^^^^^\nSyntax error, type annotations are illegal here\n----------\n");
    }

    public void test041() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "import static p. @Marker q.x. @Marker @Marker y. @Marker @Marker @Marker z.z2;\npublic class X {\n}"}, "----------\n1. ERROR in X.java (at line 1)\n\timport static p. @Marker q.x. @Marker @Marker y. @Marker @Marker @Marker z.z2;\n\t              ^\nThe import p cannot be resolved\n----------\n2. ERROR in X.java (at line 1)\n\timport static p. @Marker q.x. @Marker @Marker y. @Marker @Marker @Marker z.z2;\n\t                 ^^^^^^^\nSyntax error, type annotations are illegal here\n----------\n3. ERROR in X.java (at line 1)\n\timport static p. @Marker q.x. @Marker @Marker y. @Marker @Marker @Marker z.z2;\n\t                              ^^^^^^^^^^^^^^^\nSyntax error, type annotations are illegal here\n----------\n4. ERROR in X.java (at line 1)\n\timport static p. @Marker q.x. @Marker @Marker y. @Marker @Marker @Marker z.z2;\n\t                                                 ^^^^^^^^^^^^^^^^^^^^^^^\nSyntax error, type annotations are illegal here\n----------\n");
    }

    public void test042() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "import static p. @Marker q.x. @Marker @Marker y. @Marker @Marker @Marker z.*;\npublic class X {\n}"}, "----------\n1. ERROR in X.java (at line 1)\n\timport static p. @Marker q.x. @Marker @Marker y. @Marker @Marker @Marker z.*;\n\t              ^\nThe import p cannot be resolved\n----------\n2. ERROR in X.java (at line 1)\n\timport static p. @Marker q.x. @Marker @Marker y. @Marker @Marker @Marker z.*;\n\t                 ^^^^^^^\nSyntax error, type annotations are illegal here\n----------\n3. ERROR in X.java (at line 1)\n\timport static p. @Marker q.x. @Marker @Marker y. @Marker @Marker @Marker z.*;\n\t                              ^^^^^^^^^^^^^^^\nSyntax error, type annotations are illegal here\n----------\n4. ERROR in X.java (at line 1)\n\timport static p. @Marker q.x. @Marker @Marker y. @Marker @Marker @Marker z.*;\n\t                                                 ^^^^^^^^^^^^^^^^^^^^^^^\nSyntax error, type annotations are illegal here\n----------\n");
    }

    public void test043() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n   class Y {\n       class Z {\n           Z(X. @Marker Y  Y.this) {\n           }\n       }\n    }\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\tZ(X. @Marker Y  Y.this) {\n\t      ^^^^^^\nMarker cannot be resolved to a type\n----------\n");
    }

    public void test044() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tstatic X x;\n\tpublic class InnerBar {\n\t}\n\tpublic class SubInnerBar extends InnerBar {\n\t\tSubInnerBar() {\n\t\t\tX.@Marker x. @Marker @Marker @Marker x.super();\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tX.@Marker x. @Marker @Marker @Marker x.super();\n\t  ^^^^^^^\nSyntax error, type annotations are illegal here\n----------\n2. ERROR in X.java (at line 7)\n\tX.@Marker x. @Marker @Marker @Marker x.super();\n\t             ^^^^^^^^^^^^^^^^^^^^^^^\nSyntax error, type annotations are illegal here\n----------\n3. WARNING in X.java (at line 7)\n\tX.@Marker x. @Marker @Marker @Marker x.super();\n\t                                     ^\nThe static field X.x should be accessed in a static way\n----------\n");
    }

    public void test045() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tstatic X x;\n\tpublic class InnerBar {\n\t}\n\tpublic class SubInnerBar extends InnerBar {\n\t\tSubInnerBar() {\n\t\t\tX.@Marker x. @Marker @Marker @Marker x.<String>super();\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tX.@Marker x. @Marker @Marker @Marker x.<String>super();\n\t  ^^^^^^^\nSyntax error, type annotations are illegal here\n----------\n2. ERROR in X.java (at line 7)\n\tX.@Marker x. @Marker @Marker @Marker x.<String>super();\n\t             ^^^^^^^^^^^^^^^^^^^^^^^\nSyntax error, type annotations are illegal here\n----------\n3. WARNING in X.java (at line 7)\n\tX.@Marker x. @Marker @Marker @Marker x.<String>super();\n\t                                     ^\nThe static field X.x should be accessed in a static way\n----------\n4. WARNING in X.java (at line 7)\n\tX.@Marker x. @Marker @Marker @Marker x.<String>super();\n\t                                        ^^^^^^\nUnused type arguments for the non generic constructor X.InnerBar() of type X.InnerBar; it should not be parameterized with arguments <String>\n----------\n");
    }

    public void test046() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tBar bar;\n\tclass Bar {\n\t\t//static Bar x;\n\t\tpublic class InnerBar {\n\t\t\tInnerBar(Bar x) {\n\t\t\t}\n\t\t}\n\t\tpublic class SubInnerBar extends InnerBar {\n\t\t\tSubInnerBar() {\n\t\t\t\tX. @Marker bar.this();\n\t\t\t}\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 11)\n\tX. @Marker bar.this();\n\t^^^^^^^^^^^^^^\nIllegal enclosing instance specification for type X.Bar.SubInnerBar\n----------\n2. ERROR in X.java (at line 11)\n\tX. @Marker bar.this();\n\t^^^^^^^^^^^^^^\nCannot make a static reference to the non-static field X.bar\n----------\n3. ERROR in X.java (at line 11)\n\tX. @Marker bar.this();\n\t   ^^^^^^^\nSyntax error, type annotations are illegal here\n----------\n");
    }

    public void test047() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tBar bar;\n\tclass Bar {\n\t\t//static Bar x;\n\t\tpublic class InnerBar {\n\t\t\tInnerBar(Bar x) {\n\t\t\t}\n\t\t}\n\t\tpublic class SubInnerBar extends InnerBar {\n\t\t\tSubInnerBar() {\n\t\t\t\tX.@Marker bar.<String>this();\n\t\t\t}\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 11)\n\tX.@Marker bar.<String>this();\n\t^^^^^^^^^^^^^\nIllegal enclosing instance specification for type X.Bar.SubInnerBar\n----------\n2. ERROR in X.java (at line 11)\n\tX.@Marker bar.<String>this();\n\t^^^^^^^^^^^^^\nCannot make a static reference to the non-static field X.bar\n----------\n3. ERROR in X.java (at line 11)\n\tX.@Marker bar.<String>this();\n\t  ^^^^^^^\nSyntax error, type annotations are illegal here\n----------\n4. WARNING in X.java (at line 11)\n\tX.@Marker bar.<String>this();\n\t               ^^^^^^\nUnused type arguments for the non generic constructor X.Bar.SubInnerBar() of type X.Bar.SubInnerBar; it should not be parameterized with arguments <String>\n----------\n");
    }

    public void test048() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tX bar;\n\tprivate void foo(X x) {\n\t\tSystem.out.println((x. @Marker bar));\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tSystem.out.println((x. @Marker bar));\n\t                       ^^^^^^^\nSyntax error, type annotations are illegal here\n----------\n");
    }

    public void test049() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tclass Y {\n\t\tclass Z {\n\t\t\tvoid foo() {\n\t\t\t\tObject o = X.@Marker Y.this; \n\t\t\t}\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tObject o = X.@Marker Y.this; \n\t             ^^^^^^^\nSyntax error, type annotations are illegal here\n----------\n");
    }

    public void test050() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic class Y  {\n\t\tpublic void foo() {\n\t\t\tX. @Marker Y.super.hashCode();\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tX. @Marker Y.super.hashCode();\n\t   ^^^^^^^\nSyntax error, type annotations are illegal here\n----------\n");
    }

    public void test051() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic class Y  {\n\t\tpublic void foo() {\n\t\t\tClass<?> c = X. @Marker @Illegal Y.class;\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tClass<?> c = X. @Marker @Illegal Y.class;\n\t                ^^^^^^^^^^^^^^^^\nSyntax error, type annotations are illegal here\n----------\n");
    }

    public void test052() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic class Y  {\n\t\tpublic void foo() {\n\t\t\tClass<?> c = X. @Marker @Another Y @YetMore [].class;\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tClass<?> c = X. @Marker @Another Y @YetMore [].class;\n\t                ^^^^^^^^^^^^^^^^\nSyntax error, type annotations are illegal here\n----------\n2. ERROR in X.java (at line 4)\n\tClass<?> c = X. @Marker @Another Y @YetMore [].class;\n\t                                   ^^^^^^^^\nSyntax error, type annotations are illegal here\n----------\n");
    }

    public void test053() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    static int x;\n    static boolean fb;\n\t public void foo(boolean b) {\n\t\tx = (X.@Marker x * 10);\n\t\tx = (X.@Marker x / 10);\n\t\tx = (X.@Marker x % 10);\n\t\tx = (X.@Marker x + 10);\n\t\tx = (X.@Marker x - 10);\n\t\tx = (X.@Marker x << 10);\n\t\tx = (X.@Marker x >> 10);\n\t\tx = (X.@Marker x >>> 10);\n\t\tb = (X.@Marker x < 10);\n\t\tb = (X.@Marker x > 10);\n\t\tb = (X.@Marker x <= 10);\n\t\tb = (X.@Marker x >= 10);\n\t\tb = (X.@Marker x instanceof Object);\n\t\tb = (X.@Marker x == 10);\n\t\tb = (X.@Marker x != 10);\n\t\tx = (X.@Marker x & 10);\n\t\tx = (X.@Marker x ^ 10);\n\t\tx = (X.@Marker x | 10);\n\t\tfb = (X.@Marker fb && true);\n\t\tfb = (X.@Marker fb || true);\n\t\tx = (X.@Marker fb ? 10 : 10);\n\t }\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tx = (X.@Marker x * 10);\n\t       ^^^^^^^\nSyntax error, type annotations are illegal here\n----------\n2. ERROR in X.java (at line 6)\n\tx = (X.@Marker x / 10);\n\t       ^^^^^^^\nSyntax error, type annotations are illegal here\n----------\n3. ERROR in X.java (at line 7)\n\tx = (X.@Marker x % 10);\n\t       ^^^^^^^\nSyntax error, type annotations are illegal here\n----------\n4. ERROR in X.java (at line 8)\n\tx = (X.@Marker x + 10);\n\t       ^^^^^^^\nSyntax error, type annotations are illegal here\n----------\n5. ERROR in X.java (at line 9)\n\tx = (X.@Marker x - 10);\n\t       ^^^^^^^\nSyntax error, type annotations are illegal here\n----------\n6. ERROR in X.java (at line 10)\n\tx = (X.@Marker x << 10);\n\t       ^^^^^^^\nSyntax error, type annotations are illegal here\n----------\n7. ERROR in X.java (at line 11)\n\tx = (X.@Marker x >> 10);\n\t       ^^^^^^^\nSyntax error, type annotations are illegal here\n----------\n8. ERROR in X.java (at line 12)\n\tx = (X.@Marker x >>> 10);\n\t       ^^^^^^^\nSyntax error, type annotations are illegal here\n----------\n9. ERROR in X.java (at line 13)\n\tb = (X.@Marker x < 10);\n\t       ^^^^^^^\nSyntax error, type annotations are illegal here\n----------\n10. ERROR in X.java (at line 14)\n\tb = (X.@Marker x > 10);\n\t       ^^^^^^^\nSyntax error, type annotations are illegal here\n----------\n11. ERROR in X.java (at line 15)\n\tb = (X.@Marker x <= 10);\n\t       ^^^^^^^\nSyntax error, type annotations are illegal here\n----------\n12. ERROR in X.java (at line 16)\n\tb = (X.@Marker x >= 10);\n\t       ^^^^^^^\nSyntax error, type annotations are illegal here\n----------\n13. ERROR in X.java (at line 17)\n\tb = (X.@Marker x instanceof Object);\n\t    ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nIncompatible conditional operand types int and Object\n----------\n14. ERROR in X.java (at line 17)\n\tb = (X.@Marker x instanceof Object);\n\t       ^^^^^^^\nSyntax error, type annotations are illegal here\n----------\n15. ERROR in X.java (at line 18)\n\tb = (X.@Marker x == 10);\n\t       ^^^^^^^\nSyntax error, type annotations are illegal here\n----------\n16. ERROR in X.java (at line 19)\n\tb = (X.@Marker x != 10);\n\t       ^^^^^^^\nSyntax error, type annotations are illegal here\n----------\n17. ERROR in X.java (at line 20)\n\tx = (X.@Marker x & 10);\n\t       ^^^^^^^\nSyntax error, type annotations are illegal here\n----------\n18. ERROR in X.java (at line 21)\n\tx = (X.@Marker x ^ 10);\n\t       ^^^^^^^\nSyntax error, type annotations are illegal here\n----------\n19. ERROR in X.java (at line 22)\n\tx = (X.@Marker x | 10);\n\t       ^^^^^^^\nSyntax error, type annotations are illegal here\n----------\n20. ERROR in X.java (at line 23)\n\tfb = (X.@Marker fb && true);\n\t        ^^^^^^^\nSyntax error, type annotations are illegal here\n----------\n21. ERROR in X.java (at line 24)\n\tfb = (X.@Marker fb || true);\n\t        ^^^^^^^\nSyntax error, type annotations are illegal here\n----------\n22. ERROR in X.java (at line 25)\n\tx = (X.@Marker fb ? 10 : 10);\n\t       ^^^^^^^\nSyntax error, type annotations are illegal here\n----------\n");
    }

    public void test054() throws Exception {
    }

    public void test055() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "@interface Annot {\n\tString bar();\n}\n@Annot(bar = X. @Marker s)\npublic class X {\n\tfinal static String s = \"\";\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\t@Annot(bar = X. @Marker s)\n\t                ^^^^^^^\nSyntax error, type annotations are illegal here\n----------\n");
    }

    public void test056() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    static int x;\n    int foo() {\n        return X.@Marker x;\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\treturn X.@Marker x;\n\t         ^^^^^^^\nSyntax error, type annotations are illegal here\n----------\n");
    }

    public void test057() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    static int x[];\n    int foo() {\n        return X.@Marker x[0];\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\treturn X.@Marker x[0];\n\t         ^^^^^^^\nSyntax error, type annotations are illegal here\n----------\n");
    }

    public void test058() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    static X x;\n    int foo() {\n        return X.@Marker x.<String> foo();\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\treturn X.@Marker x.<String> foo();\n\t         ^^^^^^^\nSyntax error, type annotations are illegal here\n----------\n2. WARNING in X.java (at line 4)\n\treturn X.@Marker x.<String> foo();\n\t                    ^^^^^^\nUnused type arguments for the non generic method foo() of type X; it should not be parameterized with arguments <String>\n----------\n");
    }

    public void test059() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    static X x;\n    int foo() {\n        return X.@Marker x. @Blah foo();\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\treturn X.@Marker x. @Blah foo();\n\t         ^^^^^^^\nSyntax error, type annotations are illegal here\n----------\n2. ERROR in X.java (at line 4)\n\treturn X.@Marker x. @Blah foo();\n\t                    ^^^^^\nSyntax error, type annotations are illegal here\n----------\n");
    }

    public void test060() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    static Y y;\n    class Y {\n        class Z {\n            void foo() {\n                Z z = X. @Marker y.new Z();\n            }\n        }\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tZ z = X. @Marker y.new Z();\n\t         ^^^^^^^\nSyntax error, type annotations are illegal here\n----------\n");
    }

    public void test061() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    static X x;\n    X getX() {\n        return (X.@Marker x);\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\treturn (X.@Marker x);\n\t          ^^^^^^^\nSyntax error, type annotations are illegal here\n----------\n");
    }

    public void test062() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic <T> @Marker Object foo() {\n\t\treturn null;\t}\n}\n@interface Marker {\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tpublic <T> @Marker Object foo() {\n\t           ^^^^^^^\nAnnotation types that do not specify explicit target element types cannot be applied here\n----------\n");
    }

    public void test063() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tObject o = @Marker int.class;\n}\n@interface Marker {\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tObject o = @Marker int.class;\n\t           ^^^^^^^\nSyntax error, type annotations are illegal here\n----------\n");
    }

    public void test064() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "@interface X {\n\t<T> @Marker String foo();\n}\n@interface Marker {\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\t<T> @Marker String foo();\n\t    ^^^^^^^\nSyntax error, type annotations are illegal here\n----------\n2. ERROR in X.java (at line 2)\n\t<T> @Marker String foo();\n\t                   ^^^^^\nAnnotation attributes cannot be generic\n----------\n");
    }

    public void test065() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tObject o = new <String> @Marker X();\n}\n@interface Marker {\n}\n"}, "----------\n1. WARNING in X.java (at line 2)\n\tObject o = new <String> @Marker X();\n\t                ^^^^^^\nUnused type arguments for the non generic constructor X() of type X; it should not be parameterized with arguments <String>\n----------\n2. ERROR in X.java (at line 2)\n\tObject o = new <String> @Marker X();\n\t                        ^^^^^^^\nAnnotation types that do not specify explicit target element types cannot be applied here\n----------\n");
    }

    public void test066() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tObject o = new X().new <String> @Marker X();\n}\n@interface Marker {\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tObject o = new X().new <String> @Marker X();\n\t                                ^^^^^^^\nAnnotation types that do not specify explicit target element types cannot be applied here\n----------\n2. ERROR in X.java (at line 2)\n\tObject o = new X().new <String> @Marker X();\n\t                                ^^^^^^^^^\nX.X cannot be resolved to a type\n----------\n");
    }

    public void test067() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tObject o = x.new <String> @Marker X() {};\n}\n@interface Marker {\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tObject o = x.new <String> @Marker X() {};\n\t           ^\nx cannot be resolved to a variable\n----------\n");
    }

    public void test068() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tObject o = new <String> @Marker X() {};\n}\n@interface Marker {\n}\n"}, "----------\n1. WARNING in X.java (at line 2)\n\tObject o = new <String> @Marker X() {};\n\t                ^^^^^^\nUnused type arguments for the non generic constructor X() of type X; it should not be parameterized with arguments <String>\n----------\n2. ERROR in X.java (at line 2)\n\tObject o = new <String> @Marker X() {};\n\t                        ^^^^^^^\nAnnotation types that do not specify explicit target element types cannot be applied here\n----------\n");
    }

    public void test069() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "class X<final T> {\n\tObject o = (Object) (public X<final String>) null;\n}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tclass X<final T> {\n\t        ^^^^^\nSyntax error on token \"final\", delete this token\n----------\n2. ERROR in X.java (at line 2)\n\tObject o = (Object) (public X<final String>) null;\n\t                     ^^^^^^\nSyntax error on token \"public\", delete this token\n----------\n3. ERROR in X.java (at line 2)\n\tObject o = (Object) (public X<final String>) null;\n\t                              ^^^^^\nSyntax error on token \"final\", delete this token\n----------\n");
    }

    public void test0388085() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n\tpublic void main() {\n\t\tfinal One<@Marker ? extends Two<@Marker ? super Three<? extends Four<@Marker ? super String, @Marker ? extends Object>>>> one = null;\t\tone = null;\n\t}\n}\nclass One<R> {}\nclass Two<S> {}\nclass Three<T> {}\nclass Four<U, V> {}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tfinal One<@Marker ? extends Two<@Marker ? super Three<? extends Four<@Marker ? super String, @Marker ? extends Object>>>> one = null;\t\tone = null;\n\t           ^^^^^^\nMarker cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 3)\n\tfinal One<@Marker ? extends Two<@Marker ? super Three<? extends Four<@Marker ? super String, @Marker ? extends Object>>>> one = null;\t\tone = null;\n\t                                 ^^^^^^\nMarker cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 3)\n\tfinal One<@Marker ? extends Two<@Marker ? super Three<? extends Four<@Marker ? super String, @Marker ? extends Object>>>> one = null;\t\tone = null;\n\t                                                                      ^^^^^^\nMarker cannot be resolved to a type\n----------\n4. ERROR in X.java (at line 3)\n\tfinal One<@Marker ? extends Two<@Marker ? super Three<? extends Four<@Marker ? super String, @Marker ? extends Object>>>> one = null;\t\tone = null;\n\t                                                                                              ^^^^^^\nMarker cannot be resolved to a type\n----------\n");
    }

    public void test0388085a() {
        this.runNegativeTest(new String[]{"X.java", "import java.lang.annotation.Target;\nimport static java.lang.annotation.ElementType.*;\nclass X {\n\tpublic void main() {\n\t\tfinal One<@Marker ? extends Two<@Marker ? super Three<? extends Four<@Marker ? super String, @Marker ? extends Object>>>> one = null;\t\tone = null;\n\t}\n}\nclass One<R> {}\nclass Two<S> {}\nclass Three<T> {}\nclass Four<U, V> {}\n@interface Marker {}"}, "----------\n1. ERROR in X.java (at line 5)\n\tfinal One<@Marker ? extends Two<@Marker ? super Three<? extends Four<@Marker ? super String, @Marker ? extends Object>>>> one = null;\t\tone = null;\n\t          ^^^^^^^\nAnnotation types that do not specify explicit target element types cannot be applied here\n----------\n2. ERROR in X.java (at line 5)\n\tfinal One<@Marker ? extends Two<@Marker ? super Three<? extends Four<@Marker ? super String, @Marker ? extends Object>>>> one = null;\t\tone = null;\n\t                                ^^^^^^^\nAnnotation types that do not specify explicit target element types cannot be applied here\n----------\n3. ERROR in X.java (at line 5)\n\tfinal One<@Marker ? extends Two<@Marker ? super Three<? extends Four<@Marker ? super String, @Marker ? extends Object>>>> one = null;\t\tone = null;\n\t                                                                     ^^^^^^^\nAnnotation types that do not specify explicit target element types cannot be applied here\n----------\n4. ERROR in X.java (at line 5)\n\tfinal One<@Marker ? extends Two<@Marker ? super Three<? extends Four<@Marker ? super String, @Marker ? extends Object>>>> one = null;\t\tone = null;\n\t                                                                                             ^^^^^^^\nAnnotation types that do not specify explicit target element types cannot be applied here\n");
    }

    public void test0390882() {
        this.runNegativeTest(new String[]{"X.java", "import java.lang.annotation.Target;\nimport static java.lang.annotation.ElementType.*;\npublic class X {    \n \tObject o1 = (@Marker java.lang.Integer) null;   // 1. Right.\n\tObject o2 = (java. @Marker lang.Integer) null;  // 2. Wrong.\n\tObject o3 = (java.lang. @Marker Integer) null;  // 3. Legal.\n\tpublic void foo(java. @Marker lang.Integer arg) {}\n\tpublic void bar(java.lang. @Marker Integer arg) {}\n\tpublic void foobar(@Marker java.lang.Integer arg) {}\n}\n@Target(TYPE_USE)\n@interface Marker {}\n", "java/lang/annotation/ElementType.java", "package java.lang.annotation;\npublic enum ElementType {\n    TYPE,\n    FIELD,\n    METHOD,\n    PARAMETER,\n    CONSTRUCTOR,\n    LOCAL_VARIABLE,\n    ANNOTATION_TYPE,\n    PACKAGE,\n    TYPE_PARAMETER,\n    TYPE_USE\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tObject o1 = (@Marker java.lang.Integer) null;   // 1. Right.\n\t             ^^^^^^^\nIllegally placed annotation: type annotations must directly precede the simple name of the type they are meant to affect (or the [] for arrays)\n----------\n2. ERROR in X.java (at line 5)\n\tObject o2 = (java. @Marker lang.Integer) null;  // 2. Wrong.\n\t                   ^^^^^^^\nSyntax error, type annotations are illegal here\n----------\n3. ERROR in X.java (at line 7)\n\tpublic void foo(java. @Marker lang.Integer arg) {}\n\t                      ^^^^^^^\nSyntax error, type annotations are illegal here\n----------\n4. ERROR in X.java (at line 9)\n\tpublic void foobar(@Marker java.lang.Integer arg) {}\n\t                   ^^^^^^^\nIllegally placed annotation: type annotations must directly precede the simple name of the type they are meant to affect (or the [] for arrays)\n----------\n");
    }

    public void test0390882a() {
        this.runNegativeTest(new String[]{"X.java", "import java.lang.annotation.Target;\nimport static java.lang.annotation.ElementType.*;\npublic class X {    \n \tObject o1 = (java. @Marker @Annot lang.Integer) null;  // 1. Wrong.\n\tObject o2 = (java.lang. @Marker @Annot Integer) null;  // 2. Legal\n\tObject o3 = (java.@lang lang) null;  // 3. Wrong.\n}\n@Target(TYPE_USE)\n@interface Marker {}\n@Target(TYPE_USE)\n@interface Annot {}", "java/lang/annotation/ElementType.java", "package java.lang.annotation;\npublic enum ElementType {\n    TYPE,\n    FIELD,\n    METHOD,\n    PARAMETER,\n    CONSTRUCTOR,\n    LOCAL_VARIABLE,\n    ANNOTATION_TYPE,\n    PACKAGE,\n    TYPE_PARAMETER,\n    TYPE_USE\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tObject o1 = (java. @Marker @Annot lang.Integer) null;  // 1. Wrong.\n\t                   ^^^^^^^^^^^^^^\nSyntax error, type annotations are illegal here\n----------\n2. ERROR in X.java (at line 6)\n\tObject o3 = (java.@lang lang) null;  // 3. Wrong.\n\t             ^^^^^^^^^^^^^^^\njava.lang cannot be resolved to a type\n----------\n");
    }

    public void test0390882b() {
        this.runNegativeTest(new String[]{"X.java", "import java.lang.annotation.Target;\nimport static java.lang.annotation.ElementType.*;\npublic class X {    \n \tObject o1 = (@Marker @Annot java.util.List<String>) null; \t// 1. Wrong.\n\tObject o2 = (java. @Marker @Annot lang.Integer[]) null;\t\t// 2. Wrong.\n\tObject o3 = (@Marker @Annot java.util.List<String>[]) null; // 3. Wrong.\n\tObject o4 = (java.util.List<String> @Marker @Annot []) null; // 4. Right.\n\tObject o5 = (java.lang.Integer @Marker @Annot []) null;\t// 5. Right.\n}\n@Target(TYPE_USE)\n@interface Marker {}\n@Target(TYPE_USE)\n@interface Annot {}", "java/lang/annotation/ElementType.java", "package java.lang.annotation;\npublic enum ElementType {\n    TYPE,\n    FIELD,\n    METHOD,\n    PARAMETER,\n    CONSTRUCTOR,\n    LOCAL_VARIABLE,\n    ANNOTATION_TYPE,\n    PACKAGE,\n    TYPE_PARAMETER,\n    TYPE_USE\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tObject o1 = (@Marker @Annot java.util.List<String>) null; \t// 1. Wrong.\n\t             ^^^^^^^\nIllegally placed annotation: type annotations must directly precede the simple name of the type they are meant to affect (or the [] for arrays)\n----------\n2. ERROR in X.java (at line 4)\n\tObject o1 = (@Marker @Annot java.util.List<String>) null; \t// 1. Wrong.\n\t                     ^^^^^^\nIllegally placed annotation: type annotations must directly precede the simple name of the type they are meant to affect (or the [] for arrays)\n----------\n3. ERROR in X.java (at line 5)\n\tObject o2 = (java. @Marker @Annot lang.Integer[]) null;\t\t// 2. Wrong.\n\t                   ^^^^^^^^^^^^^^\nSyntax error, type annotations are illegal here\n----------\n4. ERROR in X.java (at line 6)\n\tObject o3 = (@Marker @Annot java.util.List<String>[]) null; // 3. Wrong.\n\t             ^^^^^^^\nIllegally placed annotation: type annotations must directly precede the simple name of the type they are meant to affect (or the [] for arrays)\n----------\n5. ERROR in X.java (at line 6)\n\tObject o3 = (@Marker @Annot java.util.List<String>[]) null; // 3. Wrong.\n\t                     ^^^^^^\nIllegally placed annotation: type annotations must directly precede the simple name of the type they are meant to affect (or the [] for arrays)\n----------\n");
    }

    public void test0385137() {
        this.runNegativeTest(new String[]{"A.java", "package p;import java.lang.annotation.Target;\nimport static java.lang.annotation.ElementType.*;\npublic class A<T> { \n\tstatic class B<T> {\t\tstatic class C<K, V> {\t\t}\t\t}\n   public void foo() {\n\t\tObject o = (@Marker @Annot A.@Marker B.@Marker C) null;\n\t\tObject o2 = (@Marker p.@Marker A.@Marker B.@Marker C) null;\n   }\n}\n@Target(TYPE_USE)\n@interface Marker {}\n@Target(TYPE_USE)\n@interface Annot {}\n", "java/lang/annotation/ElementType.java", "package java.lang.annotation;\npublic enum ElementType {\n    TYPE,\n    FIELD,\n    METHOD,\n    PARAMETER,\n    CONSTRUCTOR,\n    LOCAL_VARIABLE,\n    ANNOTATION_TYPE,\n    PACKAGE,\n    TYPE_PARAMETER,\n    TYPE_USE\n}\n"}, "----------\n1. ERROR in A.java (at line 6)\n\tObject o = (@Marker @Annot A.@Marker B.@Marker C) null;\n\t            ^^^^^^^^^^^^^^\nType annotations are not allowed on type names used to access static members\n----------\n2. WARNING in A.java (at line 6)\n\tObject o = (@Marker @Annot A.@Marker B.@Marker C) null;\n\t            ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nA.B.C is a raw type. References to generic type A.B.C<K,V> should be parameterized\n----------\n3. ERROR in A.java (at line 6)\n\tObject o = (@Marker @Annot A.@Marker B.@Marker C) null;\n\t                             ^^^^^^^\nType annotations are not allowed on type names used to access static members\n----------\n4. ERROR in A.java (at line 7)\n\tObject o2 = (@Marker p.@Marker A.@Marker B.@Marker C) null;\n\t             ^^^^^^^\nIllegally placed annotation: type annotations must directly precede the simple name of the type they are meant to affect (or the [] for arrays)\n----------\n5. WARNING in A.java (at line 7)\n\tObject o2 = (@Marker p.@Marker A.@Marker B.@Marker C) null;\n\t             ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nA.B.C is a raw type. References to generic type A.B.C<K,V> should be parameterized\n----------\n6. ERROR in A.java (at line 7)\n\tObject o2 = (@Marker p.@Marker A.@Marker B.@Marker C) null;\n\t                       ^^^^^^^\nType annotations are not allowed on type names used to access static members\n----------\n7. ERROR in A.java (at line 7)\n\tObject o2 = (@Marker p.@Marker A.@Marker B.@Marker C) null;\n\t                                 ^^^^^^^\nType annotations are not allowed on type names used to access static members\n----------\n");
    }

    public void test0385137a() {
        this.runNegativeTest(new String[]{"A.java", "package p;import java.lang.annotation.Target;\nimport static java.lang.annotation.ElementType.*;\npublic class A { \n\tstatic class B<T> {\t\tstatic class C<K, V> {\t\t}\t\t}\n   public void foo() {\n\t\tObject o1 = (@Marker p.@Marker A.@Marker B.@Marker C[]) null;\n\t\tObject o2 = (@Marker @Annot A.@Annot B.C<Integer, String>) null;\n\t\tObject o5 = (@Marker @Annot A.B<String>[]) null;\n   }\n}\n@Target(TYPE_USE)\n@interface Marker {}\n@Target(TYPE_USE)\n@interface Annot {}\n", "java/lang/annotation/ElementType.java", "package java.lang.annotation;\npublic enum ElementType {\n    TYPE,\n    FIELD,\n    METHOD,\n    PARAMETER,\n    CONSTRUCTOR,\n    LOCAL_VARIABLE,\n    ANNOTATION_TYPE,\n    PACKAGE,\n    TYPE_PARAMETER,\n    TYPE_USE\n}\n"}, "----------\n1. ERROR in A.java (at line 6)\n\tObject o1 = (@Marker p.@Marker A.@Marker B.@Marker C[]) null;\n\t             ^^^^^^^\nIllegally placed annotation: type annotations must directly precede the simple name of the type they are meant to affect (or the [] for arrays)\n----------\n2. ERROR in A.java (at line 6)\n\tObject o1 = (@Marker p.@Marker A.@Marker B.@Marker C[]) null;\n\t                       ^^^^^^^\nType annotations are not allowed on type names used to access static members\n----------\n3. ERROR in A.java (at line 6)\n\tObject o1 = (@Marker p.@Marker A.@Marker B.@Marker C[]) null;\n\t                                 ^^^^^^^\nType annotations are not allowed on type names used to access static members\n----------\n4. ERROR in A.java (at line 7)\n\tObject o2 = (@Marker @Annot A.@Annot B.C<Integer, String>) null;\n\t             ^^^^^^^^^^^^^^\nType annotations are not allowed on type names used to access static members\n----------\n5. ERROR in A.java (at line 7)\n\tObject o2 = (@Marker @Annot A.@Annot B.C<Integer, String>) null;\n\t                              ^^^^^^\nType annotations are not allowed on type names used to access static members\n----------\n6. ERROR in A.java (at line 8)\n\tObject o5 = (@Marker @Annot A.B<String>[]) null;\n\t             ^^^^^^^^^^^^^^\nType annotations are not allowed on type names used to access static members\n----------\n");
    }

    public void testBug391196() {
        this.runNegativeTest(new String[]{"p/Bug391196.java", "package p;\npublic class Bug391196 {\n\t@Marker\n\tpublic class X<@Marker @Marker2 T> {\n\t\t@Marker @Marker2 X(@Marker int i) {}\n\t\t@Unresolved X() {}\n\t}\n\t@Marker\n\tenum Color {RED, BLUE}\n\t@Marker\n\tinterface Inter {}\n@java.lang.annotation.Target (java.lang.annotation.ElementType.TYPE_USE)\n@interface Marker {}\n@java.lang.annotation.Target (java.lang.annotation.ElementType.TYPE_USE)\n@interface Marker2 {}\n}\n", "java/lang/annotation/ElementType.java", "package java.lang.annotation;\npublic enum ElementType {\n    TYPE,\n    FIELD,\n    METHOD,\n    PARAMETER,\n    CONSTRUCTOR,\n    LOCAL_VARIABLE,\n    ANNOTATION_TYPE,\n    PACKAGE,\n    TYPE_PARAMETER,\n    TYPE_USE\n}\n"}, "----------\n1. ERROR in p\\Bug391196.java (at line 6)\n\t@Unresolved X() {}\n\t ^^^^^^^^^^\nUnresolved cannot be resolved to a type\n----------\n");
    }

    public void testBug391315() {
        this.runNegativeTest(new String[]{"X.java", "class X<T> {\n\tX<@Marker ?> l;\n\tX<@Marker2 ?> l2;\n\tX<@Marker3 ?> l3;\n\tclass Y {\n\t\tvoid Y1(Y this) {}\n\t}\n}\n@java.lang.annotation.Target (java.lang.annotation.ElementType.TYPE_PARAMETER)\n@interface Marker {}\n@java.lang.annotation.Target (java.lang.annotation.ElementType.TYPE_USE)\n@interface Marker2 {}\n@interface Marker3 {}\n", "java/lang/annotation/ElementType.java", "package java.lang.annotation;\npublic enum ElementType {\n    TYPE,\n    FIELD,\n    METHOD,\n    PARAMETER,\n    CONSTRUCTOR,\n    LOCAL_VARIABLE,\n    ANNOTATION_TYPE,\n    PACKAGE,\n    TYPE_PARAMETER,\n    TYPE_USE\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tX<@Marker ?> l;\n\t  ^^^^^^^\nThe annotation @Marker is disallowed for this location\n----------\n2. ERROR in X.java (at line 4)\n\tX<@Marker3 ?> l3;\n\t  ^^^^^^^^\nAnnotation types that do not specify explicit target element types cannot be applied here\n----------\n");
    }

    public void testBug391315a() {
        this.runNegativeTest(new String[]{"X.java", "public class X<@Marker T> {\n\t@Marker T t;\n\tT t2 = (@Marker T) null;\n}\nclass X2<@Marker2 T> {\n\t@Marker2 T t;\n\tT t2 = (@Marker2 T) null;\n}\n@java.lang.annotation.Target (java.lang.annotation.ElementType.TYPE_USE)\n@interface Marker {}\n@java.lang.annotation.Target (java.lang.annotation.ElementType.TYPE_PARAMETER)\n@interface Marker2 {}", "java/lang/annotation/ElementType.java", "package java.lang.annotation;\npublic enum ElementType {\n    TYPE,\n    FIELD,\n    METHOD,\n    PARAMETER,\n    CONSTRUCTOR,\n    LOCAL_VARIABLE,\n    ANNOTATION_TYPE,\n    PACKAGE,\n    TYPE_PARAMETER,\n    TYPE_USE\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\t@Marker2 T t;\n\t^^^^^^^^\nThe annotation @Marker2 is disallowed for this location\n----------\n2. ERROR in X.java (at line 7)\n\tT t2 = (@Marker2 T) null;\n\t        ^^^^^^^^\nThe annotation @Marker2 is disallowed for this location\n----------\n");
    }

    public void testBug391500() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tclass Y {\n\t\tclass Z {\n\t\t}\n\t\tZ z1 = new @Marker X().new @Marker Y().new @Marker Z();\n\t\tZ z3 = new @Marker Z(){};\n\t};\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tZ z1 = new @Marker X().new @Marker Y().new @Marker Z();\n\t            ^^^^^^\nMarker cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 5)\n\tZ z1 = new @Marker X().new @Marker Y().new @Marker Z();\n\t                            ^^^^^^\nMarker cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 5)\n\tZ z1 = new @Marker X().new @Marker Y().new @Marker Z();\n\t                                            ^^^^^^\nMarker cannot be resolved to a type\n----------\n4. ERROR in X.java (at line 6)\n\tZ z3 = new @Marker Z(){};\n\t            ^^^^^^\nMarker cannot be resolved to a type\n----------\n");
    }

    public void testBug391464() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T> {\n\tpublic void foo() {\n\t\tObject o = (X @Marker []) null;\n\t\to = (java.lang.String @Marker []) null;\n\t\to = (X<String> @Marker []) null;\n\t\to = (java.util.List<String> @Marker []) null;\n\t\tif (o == null) return;\n\t}}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tObject o = (X @Marker []) null;\n\t               ^^^^^^\nMarker cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 4)\n\to = (java.lang.String @Marker []) null;\n\t                       ^^^^^^\nMarker cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 5)\n\to = (X<String> @Marker []) null;\n\t                ^^^^^^\nMarker cannot be resolved to a type\n----------\n4. ERROR in X.java (at line 6)\n\to = (java.util.List<String> @Marker []) null;\n\t                             ^^^^^^\nMarker cannot be resolved to a type\n----------\n");
    }

    public void testBug391464_2() {
        this.runNegativeTest(new String[]{"X.java", "public class X  {\n\tclass Y {\n\t\tclass Z {}\n\t}\n\t@M X.@M Y.@Unreported Z z = null;\n}\n@java.lang.annotation.Target (java.lang.annotation.ElementType.TYPE_USE)\n@interface M {\n}\n", "java/lang/annotation/ElementType.java", "package java.lang.annotation;\npublic enum ElementType {\n    TYPE,\n    FIELD,\n    METHOD,\n    PARAMETER,\n    CONSTRUCTOR,\n    LOCAL_VARIABLE,\n    ANNOTATION_TYPE,\n    PACKAGE,\n    TYPE_PARAMETER,\n    TYPE_USE\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\t@M X.@M Y.@Unreported Z z = null;\n\t           ^^^^^^^^^^\nUnreported cannot be resolved to a type\n----------\n");
    }

    public void testBug391108() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t@Marker @Marker2 @Marker3 public void foo() {}\n\t@Marker @Marker2 @Marker3 void foo2() {}\n}\n@java.lang.annotation.Target (java.lang.annotation.ElementType.TYPE_USE)\n@interface Marker {}\n@java.lang.annotation.Target (java.lang.annotation.ElementType.METHOD)\n@interface Marker2 {}\n@java.lang.annotation.Target ({java.lang.annotation.ElementType.TYPE_USE, java.lang.annotation.ElementType.METHOD})\n@interface Marker3 {}", "java/lang/annotation/ElementType.java", "package java.lang.annotation;\npublic enum ElementType {\n    TYPE,\n    FIELD,\n    METHOD,\n    PARAMETER,\n    CONSTRUCTOR,\n    LOCAL_VARIABLE,\n    ANNOTATION_TYPE,\n    PACKAGE,\n    TYPE_PARAMETER,\n    TYPE_USE\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\t@Marker @Marker2 @Marker3 public void foo() {}\n\t^^^^^^^\nType annotation is illegal for a method that returns void\n----------\n2. ERROR in X.java (at line 3)\n\t@Marker @Marker2 @Marker3 void foo2() {}\n\t^^^^^^^\nType annotation is illegal for a method that returns void\n----------\n");
    }

    public void test392119() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "@Marker78 @Marker8 @Marker7\npublic class X {\n    Zork z;\n}\n@java.lang.annotation.Target ({java.lang.annotation.ElementType.TYPE_USE, java.lang.annotation.ElementType.TYPE})\n@interface Marker78 {\n}\n@java.lang.annotation.Target ({java.lang.annotation.ElementType.TYPE})\n@interface Marker7 {\n}\n@java.lang.annotation.Target ({java.lang.annotation.ElementType.TYPE_USE})\n@interface Marker8 {\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n", null, true, null, true, false, false);
        String expectedOutput = "  RuntimeInvisibleAnnotations: \n    #24 @Marker78(\n    )\n    #25 @Marker8(\n    )\n    #26 @Marker7(\n    )\n  Attribute: MissingTypes Length: 4\n}";
        this.checkDisassembledClassFile(OUTPUT_DIR + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test392119b() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "@Marker78 @Marker8 @Marker7\npublic class X {\n    Zork z;\n}\n@java.lang.annotation.Retention(java.lang.annotation.RetentionPolicy.CLASS)\n@java.lang.annotation.Target ({java.lang.annotation.ElementType.TYPE_USE, java.lang.annotation.ElementType.TYPE})\n@interface Marker78 {\n}\n@java.lang.annotation.Retention(java.lang.annotation.RetentionPolicy.CLASS)\n@java.lang.annotation.Target ({java.lang.annotation.ElementType.TYPE})\n@interface Marker7 {\n}\n@java.lang.annotation.Retention(java.lang.annotation.RetentionPolicy.CLASS)\n@java.lang.annotation.Target ({java.lang.annotation.ElementType.TYPE_USE})\n@interface Marker8 {\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n", null, true, null, true, false, false);
        String expectedOutput = "  RuntimeInvisibleAnnotations: \n    #24 @Marker78(\n    )\n    #25 @Marker8(\n    )\n    #26 @Marker7(\n    )\n  Attribute: MissingTypes Length: 4\n}";
        this.checkDisassembledClassFile(OUTPUT_DIR + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test392119c() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "@Marker78 @Marker8 @Marker7\npublic class X {\n    Zork z;\n}\n@java.lang.annotation.Retention(java.lang.annotation.RetentionPolicy.RUNTIME)\n@java.lang.annotation.Target ({java.lang.annotation.ElementType.TYPE_USE, java.lang.annotation.ElementType.TYPE})\n@interface Marker78 {\n}\n@java.lang.annotation.Retention(java.lang.annotation.RetentionPolicy.RUNTIME)\n@java.lang.annotation.Target ({java.lang.annotation.ElementType.TYPE})\n@interface Marker7 {\n}\n@java.lang.annotation.Retention(java.lang.annotation.RetentionPolicy.RUNTIME)\n@java.lang.annotation.Target ({java.lang.annotation.ElementType.TYPE_USE})\n@interface Marker8 {\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n", null, true, null, true, false, false);
        String expectedOutput = "  RuntimeVisibleAnnotations: \n    #24 @Marker78(\n    )\n    #25 @Marker8(\n    )\n    #26 @Marker7(\n    )\n";
        this.checkDisassembledClassFile(OUTPUT_DIR + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void testBug394355() {
        this.runNegativeTest(new String[]{"X.java", "import java.lang.annotation.Target;\nimport static java.lang.annotation.ElementType.*;\npublic class X {\n\tpublic void foo(@Marker @Marker2 X this) {}\n\tclass Y {\n\t\tY(@Marker @Marker2 X X.this) {}\n\t}\n}\n@Target (java.lang.annotation.ElementType.TYPE_USE)\n@interface Marker {}\n@Target ({METHOD, PARAMETER, TYPE, PACKAGE, FIELD, CONSTRUCTOR, LOCAL_VARIABLE, TYPE_PARAMETER})\n@interface Marker2 {}", "java/lang/annotation/ElementType.java", "package java.lang.annotation;\npublic enum ElementType {\n    TYPE,\n    FIELD,\n    METHOD,\n    PARAMETER,\n    CONSTRUCTOR,\n    LOCAL_VARIABLE,\n    ANNOTATION_TYPE,\n    PACKAGE,\n    TYPE_PARAMETER,\n    TYPE_USE\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tpublic void foo(@Marker @Marker2 X this) {}\n\t                        ^^^^^^^^\nThe annotation @Marker2 is disallowed for this location\n----------\n2. ERROR in X.java (at line 6)\n\tY(@Marker @Marker2 X X.this) {}\n\t          ^^^^^^^^\nThe annotation @Marker2 is disallowed for this location\n----------\n");
    }

    public void testBug399453() {
        this.runNegativeTest(new String[]{"X.java", "import java.lang.annotation.Target;\nimport static java.lang.annotation.ElementType.*;\npublic class X {\n\tpublic void foo() {\n\t\tint @Marker [][][] i = new @Marker2 int @Marker @Marker2 [2] @Marker @Marker2 [@Marker bar()] @Marker @Marker2 [];\n\t\tint @Marker [][][] j = new @Marker2 int @Marker @Marker2 [2] @Marker @Marker2 [@Marker X.bar2(2)] @Marker @Marker2 [];\n\t}\n\tpublic int bar() {\n\t\treturn 2;\n\t}\n\tpublic static int bar2(int k) {\n\t\treturn k;\n\t}\n}\n@Target (java.lang.annotation.ElementType.TYPE_USE)\n@interface Marker {}\n@Target (java.lang.annotation.ElementType.TYPE_USE)\n@interface Marker2 {}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tint @Marker [][][] i = new @Marker2 int @Marker @Marker2 [2] @Marker @Marker2 [@Marker bar()] @Marker @Marker2 [];\n\t                                                                               ^^^^^^^\nSyntax error, type annotations are illegal here\n----------\n2. ERROR in X.java (at line 6)\n\tint @Marker [][][] j = new @Marker2 int @Marker @Marker2 [2] @Marker @Marker2 [@Marker X.bar2(2)] @Marker @Marker2 [];\n\t                                                                               ^^^^^^^\nSyntax error, type annotations are illegal here\n----------\n");
    }

    public void testBug391894() {
        this.runNegativeTest(new String[]{"X.java", "import java.lang.annotation.Target;\nimport static java.lang.annotation.ElementType.*;\npublic class X {\n\tpublic void foo() {\n\t\tint @Marker [][][] i = new @Marker2 int @Marker @Marker2 [2] @Marker @Marker2 [@Marker bar()] ;\n\t\tint @Marker [] j = new @Marker2 int @Marker @Marker2 [2] @Marker @Marker2 [@Marker bar()] ;\n\t}\n\tpublic int bar() {\n\t\treturn 2;\n\t}\n}\n@Target (java.lang.annotation.ElementType.TYPE_USE)\n@interface Marker {}\n@Target (java.lang.annotation.ElementType.TYPE_USE)\n@interface Marker2 {}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tint @Marker [][][] i = new @Marker2 int @Marker @Marker2 [2] @Marker @Marker2 [@Marker bar()] ;\n\t                       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from int[][] to int[][][]\n----------\n2. ERROR in X.java (at line 5)\n\tint @Marker [][][] i = new @Marker2 int @Marker @Marker2 [2] @Marker @Marker2 [@Marker bar()] ;\n\t                                                                               ^^^^^^^\nSyntax error, type annotations are illegal here\n----------\n3. ERROR in X.java (at line 6)\n\tint @Marker [] j = new @Marker2 int @Marker @Marker2 [2] @Marker @Marker2 [@Marker bar()] ;\n\t                   ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from int[][] to int[]\n----------\n4. ERROR in X.java (at line 6)\n\tint @Marker [] j = new @Marker2 int @Marker @Marker2 [2] @Marker @Marker2 [@Marker bar()] ;\n\t                                                                           ^^^^^^^\nSyntax error, type annotations are illegal here\n----------\n");
    }

    public void test402618() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\ninterface I {\n\tvoid foo(List<String> l);\n}\n\npublic class X {\n\tpublic void main(String[] args) {\n\t\tI i = @Readonly List<@English String>::<@NonNegative Integer>size;\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\tI i = @Readonly List<@English String>::<@NonNegative Integer>size;\n\t       ^^^^^^^^\nReadonly cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 8)\n\tI i = @Readonly List<@English String>::<@NonNegative Integer>size;\n\t                      ^^^^^^^\nEnglish cannot be resolved to a type\n----------\n3. WARNING in X.java (at line 8)\n\tI i = @Readonly List<@English String>::<@NonNegative Integer>size;\n\t                                        ^^^^^^^^^^^^^^^^^^^^\nUnused type arguments for the non generic method size() of type List<String>; it should not be parameterized with arguments <Integer>\n----------\n4. ERROR in X.java (at line 8)\n\tI i = @Readonly List<@English String>::<@NonNegative Integer>size;\n\t                                         ^^^^^^^^^^^\nNonNegative cannot be resolved to a type\n----------\n");
    }

    public void testBug403132() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tclass Y {\n\t\tclass Z {\n\t\t\tpublic Z (@A X.@B Y Y.this, String str) {}\n    \t \tpublic void foo (@A X.@B Y.@C Z this, String str) {}\n\t\t}\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tpublic Z (@A X.@B Y Y.this, String str) {}\n\t           ^\nA cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 4)\n\tpublic Z (@A X.@B Y Y.this, String str) {}\n\t                ^\nB cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 5)\n\tpublic void foo (@A X.@B Y.@C Z this, String str) {}\n\t                  ^\nA cannot be resolved to a type\n----------\n4. ERROR in X.java (at line 5)\n\tpublic void foo (@A X.@B Y.@C Z this, String str) {}\n\t                       ^\nB cannot be resolved to a type\n----------\n5. ERROR in X.java (at line 5)\n\tpublic void foo (@A X.@B Y.@C Z this, String str) {}\n\t                            ^\nC cannot be resolved to a type\n----------\n");
    }

    public void testBug403410() {
        this.runNegativeTest(new String[]{"X.java", "import java.lang.annotation.Target;\nimport static java.lang.annotation.ElementType.*;\n@Target (java.lang.annotation.ElementType.TYPE_USE)\n@interface A {}\npublic class X {\n\tclass Y {\n\t\tpublic Y (final @A X X.this) {}\n\t\tpublic Y (static @A X X.this, int i) {}\n\t\tpublic void foo(final @A Y this) {}\n\t\tpublic void foo(static @A Y this, int i) {}\n}\n}"}, "----------\n1. ERROR in X.java (at line 7)\n\tpublic Y (final @A X X.this) {}\n\t          ^^^^^^^^^^^^^^^^^\nSyntax error, modifiers are not allowed here\n----------\n2. ERROR in X.java (at line 8)\n\tpublic Y (static @A X X.this, int i) {}\n\t          ^^^^^^^^^^^^^^^^^^\nSyntax error, modifiers are not allowed here\n----------\n3. ERROR in X.java (at line 9)\n\tpublic void foo(final @A Y this) {}\n\t                ^^^^^^^^^^^^^^^\nSyntax error, modifiers are not allowed here\n----------\n4. ERROR in X.java (at line 10)\n\tpublic void foo(static @A Y this, int i) {}\n\t                ^^^^^^^^^^^^^^^^\nSyntax error, modifiers are not allowed here\n----------\n");
    }

    public void test403581() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\npublic class X {\n\tvoid foo(List<String> @Marker ... ls) {}\n}\n@java.lang.annotation.Target(java.lang.annotation.ElementType.TYPE_USE)\n@interface Marker {\n}\n"}, "----------\n1. WARNING in X.java (at line 3)\n\tvoid foo(List<String> @Marker ... ls) {}\n\t                                  ^^\nType safety: Potential heap pollution via varargs parameter ls\n----------\n");
    }

    public void test392671() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n    public void foobar(X this, int, int k) {} // NPE!\n}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tclass X {\n\t        ^\nSyntax error, insert \"}\" to complete ClassBody\n----------\n2. ERROR in X.java (at line 2)\n\tpublic void foobar(X this, int, int k) {} // NPE!\n\t                           ^^^\nSyntax error, insert \"... VariableDeclaratorId\" to complete SingleVariableDeclarator\n----------\n3. ERROR in X.java (at line 3)\n\t}\n\t^\nSyntax error on token \"}\", delete this token\n----------\n");
    }

    public void test406587() {
        this.runNegativeTest(new String[]{"p/X.java", "package p;\nimport java.lang.annotation.*;\npublic class X {\n\t@B(1) @A(1) String field1;\n\t@B @A X.Y field3;\n\t@A @B p.X.Y field4;\n\t@B(1) @A(1) java.lang.@A(1) @B(1) String field2;\n\tpublic @B(1) @A(1) java.lang. @A(1) @B(1)  String foo(@A(1) @B(1) java.lang. @A(1) @B(1) String str1) {\n\t\t@A(1) @B(1)  String local1;\n\t\t@A(1) @B(1) java.lang.  @B(1) @A(1) String local2;\n\t\t@B @A X.Y local3;\n\t\t@B @A p.X.Y local4;\n\t\t@B @A p.q.X local5;\n\t\treturn null;\n\t}\n\tclass Y {}}\n@Target({ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.LOCAL_VARIABLE})\n@interface A {\n\tint value() default -1;\n}\n@Target(ElementType.TYPE_USE)\n@interface B {\n\tint value() default -1;\n}\n"}, "----------\n1. ERROR in p\\X.java (at line 6)\n\t@A @B p.X.Y field4;\n\t   ^^\nIllegally placed annotation: type annotations must directly precede the simple name of the type they are meant to affect (or the [] for arrays)\n----------\n2. ERROR in p\\X.java (at line 7)\n\t@B(1) @A(1) java.lang.@A(1) @B(1) String field2;\n\t^^\nIllegally placed annotation: type annotations must directly precede the simple name of the type they are meant to affect (or the [] for arrays)\n----------\n3. ERROR in p\\X.java (at line 7)\n\t@B(1) @A(1) java.lang.@A(1) @B(1) String field2;\n\t                      ^^\nThe annotation @A is disallowed for this location\n----------\n4. ERROR in p\\X.java (at line 8)\n\tpublic @B(1) @A(1) java.lang. @A(1) @B(1)  String foo(@A(1) @B(1) java.lang. @A(1) @B(1) String str1) {\n\t       ^^\nIllegally placed annotation: type annotations must directly precede the simple name of the type they are meant to affect (or the [] for arrays)\n----------\n5. ERROR in p\\X.java (at line 8)\n\tpublic @B(1) @A(1) java.lang. @A(1) @B(1)  String foo(@A(1) @B(1) java.lang. @A(1) @B(1) String str1) {\n\t                              ^^\nThe annotation @A is disallowed for this location\n----------\n6. ERROR in p\\X.java (at line 8)\n\tpublic @B(1) @A(1) java.lang. @A(1) @B(1)  String foo(@A(1) @B(1) java.lang. @A(1) @B(1) String str1) {\n\t                                                            ^^\nIllegally placed annotation: type annotations must directly precede the simple name of the type they are meant to affect (or the [] for arrays)\n----------\n7. ERROR in p\\X.java (at line 8)\n\tpublic @B(1) @A(1) java.lang. @A(1) @B(1)  String foo(@A(1) @B(1) java.lang. @A(1) @B(1) String str1) {\n\t                                                                             ^^\nThe annotation @A is disallowed for this location\n----------\n8. ERROR in p\\X.java (at line 10)\n\t@A(1) @B(1) java.lang.  @B(1) @A(1) String local2;\n\t      ^^\nIllegally placed annotation: type annotations must directly precede the simple name of the type they are meant to affect (or the [] for arrays)\n----------\n9. ERROR in p\\X.java (at line 10)\n\t@A(1) @B(1) java.lang.  @B(1) @A(1) String local2;\n\t                              ^^\nThe annotation @A is disallowed for this location\n----------\n10. ERROR in p\\X.java (at line 12)\n\t@B @A p.X.Y local4;\n\t^^\nIllegally placed annotation: type annotations must directly precede the simple name of the type they are meant to affect (or the [] for arrays)\n----------\n11. ERROR in p\\X.java (at line 13)\n\t@B @A p.q.X local5;\n\t      ^^^\np.q cannot be resolved to a type\n----------\n");
    }

    public void test417076() {
        this.runNegativeTest(new String[]{"X.java", "import java.lang.annotation.ElementType;\nimport java.lang.annotation.Target;\n@Target(ElementType.TYPE_USE)\n@interface A {\n}\n@Target(ElementType.TYPE_USE)\n@interface B {\n}\n@Target(ElementType.TYPE_USE)\n@interface C {\n}\npublic class X {\n\tpublic @A String foo(int @B @C @D ... args) {\n\t      return null;\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 13)\n\tpublic @A String foo(int @B @C @D ... args) {\n\t                                ^\nD cannot be resolved to a type\n----------\n");
    }

    public void test417076b() {
        this.runNegativeTest(new String[]{"X.java", "import java.lang.annotation.ElementType;\nimport java.lang.annotation.Target;\n@Target(ElementType.TYPE_USE)\n@interface A {\n}\n@Target(ElementType.TYPE_USE)\n@interface B {\n}\n@Target(ElementType.TYPE_USE)\n@interface C {\n}\npublic class X {\n\tpublic @A String foo(int @B @C @A ... args) {\n\t      return null;\n\t}\n\tpublic @A String goo(int @B @C @A ... args) {\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 16)\n\tpublic @A String goo(int @B @C @A ... args) {\n\t                 ^^^^^^^^^^^^^^^^^^^^^^^^^^\nThis method must return a result of type String\n----------\n");
    }

    public void test415308a() {
        this.runNegativeTest(new String[]{"X.java", "import java.lang.annotation.ElementType;\nimport java.lang.annotation.Target;\n\n@Target(ElementType.TYPE_USE)\n@interface Illegal {\n}\nclass Y {\n\tstatic class Z {\n\t\tZ() {}\n\t}\n}\nclass X {\n\tY.Z foo() {\n\t\t@Illegal Y.Z z = null;\n\t\treturn z;\n\t}\n\tY.Z bar() {\n\t\tY.Z z = (@Illegal Y.Z)null;\n\t\treturn z;\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 14)\n\t@Illegal Y.Z z = null;\n\t^^^^^^^^\nType annotations are not allowed on type names used to access static members\n----------\n2. ERROR in X.java (at line 18)\n\tY.Z z = (@Illegal Y.Z)null;\n\t         ^^^^^^^^\nType annotations are not allowed on type names used to access static members\n----------\n");
    }

    public void test415308a2() {
        this.runNegativeTest(new String[]{"X.java", "import java.lang.annotation.ElementType;\nimport java.lang.annotation.Target;\n\n@Target(ElementType.TYPE_USE)\n@interface Illegal {\n}\nclass Y {\n\tstatic class Z {\n\t\tZ() {}\n\t}\n}\nclass X {\n\tY.Z[] foo() {\n\t\t@Illegal Y.Z[] z = null;\n\t\treturn z;\n\t}\n\tY.Z[] bar() {\n\t\tY.Z[] z = (@Illegal Y.Z[])null;\n\t\treturn z;\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 14)\n\t@Illegal Y.Z[] z = null;\n\t^^^^^^^^\nType annotations are not allowed on type names used to access static members\n----------\n2. ERROR in X.java (at line 18)\n\tY.Z[] z = (@Illegal Y.Z[])null;\n\t           ^^^^^^^^\nType annotations are not allowed on type names used to access static members\n----------\n");
    }

    public void test415308b() {
        this.runNegativeTest(new String[]{"X.java", "import java.lang.annotation.ElementType;\nimport java.lang.annotation.Target;\n\n@Target(ElementType.TYPE_USE)\n@interface Illegal {\n}\nclass Y {\n\tstatic class YY {\n\t\tclass Z {\n\t\t\tZ() {}\n\t\t}\n\t}\n}\nclass X {\n\tY.YY.Z foo() {\n\t\t@Illegal Y.YY.Z z = null;\n\t\treturn z;\n\t}\n\tY.YY.Z foo2() {\n\t\tY.@Illegal YY.Z z = null;\n\t\treturn z;\n\t}\n\tY.YY.Z foo3() {\n\t\tY.YY.@Illegal Z z = null;\n\t\treturn z;\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 16)\n\t@Illegal Y.YY.Z z = null;\n\t^^^^^^^^\nType annotations are not allowed on type names used to access static members\n----------\n");
    }

    public void test415308b2() {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.testFiles = new String[]{"X.java", "import java.lang.annotation.ElementType;\nimport java.lang.annotation.Target;\n\n@Target(ElementType.TYPE_USE)\n@interface Illegal {\n}\nclass Y {\n\tstatic class YY {\n\t\tclass Z {\n\t\t\tZ() {}\n\t\t}\n\t}\n}\nclass X {\n\tY.YY.Z[] foo() {\n\t\t@Illegal Y.YY.Z[] z = null;\n\t\treturn z;\n\t}\n\tY.YY.Z[] foo2() {\n\t\tY.@Illegal YY.Z[] z = null;\n\t\treturn z;\n\t}\n\tY.YY.Z[] foo3() {\n\t\tY.YY.@Illegal Z[] z = null;\n\t\treturn z;\n\t}\n}\n"};
        runner.expectedCompilerLog = "----------\n1. ERROR in X.java (at line 16)\n\t@Illegal Y.YY.Z[] z = null;\n\t^^^^^^^^\nType annotations are not allowed on type names used to access static members\n----------\n";
        runner.javacTestOptions = AbstractRegressionTest.JavacTestOptions.EclipseJustification.EclipseBug561549;
        runner.runNegativeTest();
    }

    public void test415308c() {
        this.runNegativeTest(new String[]{"X.java", "import java.lang.annotation.ElementType;\nimport java.lang.annotation.Target;\n\n@Target(ElementType.TYPE_USE)\n@interface IllegalTypeUse {\n}\n@Target({ElementType.TYPE_USE, ElementType.PARAMETER})\n@interface LegalTypeUseParam {\n}\n@Target(ElementType.PARAMETER)\n@interface LegalParam {\n}\nclass Y {\n\tstatic class Z {\n\t\tZ() {}\n\t}\n}\nclass X {\n\tY.Z foo(@LegalParam Y.Z z) { //Legal\n\t\treturn z;\n\t}\n\tY.Z foo2(@LegalTypeUseParam Y.Z z) { //Legal\n\t\treturn z;\n\t}\n\tY.Z foo3(@IllegalTypeUse @LegalParam Y.Z z) { //Illegal\n\t\treturn z;\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 25)\n\tY.Z foo3(@IllegalTypeUse @LegalParam Y.Z z) { //Illegal\n\t         ^^^^^^^^^^^^^^^\nType annotations are not allowed on type names used to access static members\n----------\n");
    }

    public void test415308d() {
        this.runNegativeTest(new String[]{"X.java", "import java.lang.annotation.ElementType;\nimport java.lang.annotation.Target;\n\n@Target(ElementType.TYPE_USE)\n@interface Illegal {\n}\nclass Y {\n\tstatic class Z {\n\t\tZ() {}\n\t}\n}\nclass X {\n   @Illegal \n\tY.Z z;\n}\n"}, "----------\n1. ERROR in X.java (at line 13)\n\t@Illegal \n\t^^^^^^^^\nType annotations are not allowed on type names used to access static members\n----------\n");
    }

    public void test415308d2() {
        this.runNegativeTest(new String[]{"X.java", "import java.lang.annotation.ElementType;\nimport java.lang.annotation.Target;\n\n@Target({ElementType.TYPE_USE, ElementType.FIELD})\n@interface Legal {\n}\nclass Y {\n\tstatic class Z {\n\t\tZ() {}\n\t}\n}\nclass X {\n   @Legal \n\tY.Z z;\n}\n"}, "");
    }

    public void test415308e() {
        this.runNegativeTest(new String[]{"X.java", "import java.lang.annotation.ElementType;\nimport java.lang.annotation.Target;\n\n@Target(ElementType.TYPE_USE)\n@interface Illegal {\n}\n@Target(ElementType.TYPE_USE)\n@interface Illegal2 {\n}\n@Target(ElementType.FIELD)\n@interface Legal {\n}\nclass Y {\n\tstatic class YY {\n\t\tclass Z {\n\t\t\tZ() {}\n\t\t}\n\t}\n}\nclass X {\n   @Legal @Illegal @Illegal2\n\tY.YY.Z z;\n}\n"}, "----------\n1. ERROR in X.java (at line 21)\n\t@Legal @Illegal @Illegal2\n\t       ^^^^^^^^\nType annotations are not allowed on type names used to access static members\n----------\n2. ERROR in X.java (at line 21)\n\t@Legal @Illegal @Illegal2\n\t                ^^^^^^^^^\nType annotations are not allowed on type names used to access static members\n----------\n");
    }

    public void test415308f() {
        this.runNegativeTest(new String[]{"X.java", "import java.lang.annotation.ElementType;\nimport java.lang.annotation.Target;\n\n@Target(ElementType.TYPE_USE)\n@interface Illegal {\n}\nclass Y {\n\tstatic class Z {\n\t\tZ() {}\n\t}\n}\nclass X {\n   public @Illegal Y.Z foo() { return null;}\n}\n"}, "----------\n1. ERROR in X.java (at line 13)\n\tpublic @Illegal Y.Z foo() { return null;}\n\t       ^^^^^^^^\nType annotations are not allowed on type names used to access static members\n----------\n");
    }

    public void test415308f2() {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.testFiles = new String[]{"X.java", "import java.lang.annotation.ElementType;\nimport java.lang.annotation.Target;\n\n@Target(ElementType.TYPE_USE)\n@interface Illegal {\n}\nclass Y {\n\tstatic class Z {\n\t\tZ() {}\n\t}\n}\nclass X {\n   public @Illegal Y.Z[] foo() { return null;}\n}\n"};
        runner.expectedCompilerLog = "----------\n1. ERROR in X.java (at line 13)\n\tpublic @Illegal Y.Z[] foo() { return null;}\n\t       ^^^^^^^^\nType annotations are not allowed on type names used to access static members\n----------\n";
        runner.javacTestOptions = AbstractRegressionTest.JavacTestOptions.EclipseJustification.EclipseBug561549;
        runner.runNegativeTest();
    }

    public void test415308g() {
        this.runNegativeTest(new String[]{"X.java", "import java.lang.annotation.ElementType;\nimport java.lang.annotation.Target;\n\n@Target(ElementType.TYPE_USE)\n@interface Illegal {\n}\nclass Y {\n\tenum A { B }\n}\nclass X {\n\t@Illegal Y.A foo(@Illegal Y.A a) {\n\t\treturn a;\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 11)\n\t@Illegal Y.A foo(@Illegal Y.A a) {\n\t^^^^^^^^\nType annotations are not allowed on type names used to access static members\n----------\n2. ERROR in X.java (at line 11)\n\t@Illegal Y.A foo(@Illegal Y.A a) {\n\t                 ^^^^^^^^\nType annotations are not allowed on type names used to access static members\n----------\n");
    }

    public void test418041() {
        this.runNegativeTest(new String[]{"X.java", "import java.lang.annotation.ElementType;\nimport java.lang.annotation.Target;\nimport java.util.List;\n@Target(ElementType.TYPE_USE)\n@interface Readonly {\n}\nclass UnmodifiableList<T> implements\n@Readonly List<@Readonly T> { }\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tclass UnmodifiableList<T> implements\n\t      ^^^^^^^^^^^^^^^^\nThe type UnmodifiableList<T> must implement the inherited abstract method List<T>.addAll(int, Collection<? extends T>)\n----------\n2. ERROR in X.java (at line 7)\n\tclass UnmodifiableList<T> implements\n\t      ^^^^^^^^^^^^^^^^\nThe type UnmodifiableList<T> must implement the inherited abstract method List<T>.addAll(Collection<? extends T>)\n----------\n3. ERROR in X.java (at line 7)\n\tclass UnmodifiableList<T> implements\n\t      ^^^^^^^^^^^^^^^^\nThe type UnmodifiableList<T> must implement the inherited abstract method List<T>.lastIndexOf(Object)\n----------\n4. ERROR in X.java (at line 7)\n\tclass UnmodifiableList<T> implements\n\t      ^^^^^^^^^^^^^^^^\nThe type UnmodifiableList<T> must implement the inherited abstract method List<T>.subList(int, int)\n----------\n5. ERROR in X.java (at line 7)\n\tclass UnmodifiableList<T> implements\n\t      ^^^^^^^^^^^^^^^^\nThe type UnmodifiableList<T> must implement the inherited abstract method List<T>.contains(Object)\n----------\n6. ERROR in X.java (at line 7)\n\tclass UnmodifiableList<T> implements\n\t      ^^^^^^^^^^^^^^^^\nThe type UnmodifiableList<T> must implement the inherited abstract method List<T>.get(int)\n----------\n7. ERROR in X.java (at line 7)\n\tclass UnmodifiableList<T> implements\n\t      ^^^^^^^^^^^^^^^^\nThe type UnmodifiableList<T> must implement the inherited abstract method List<T>.retainAll(Collection<?>)\n----------\n8. ERROR in X.java (at line 7)\n\tclass UnmodifiableList<T> implements\n\t      ^^^^^^^^^^^^^^^^\nThe type UnmodifiableList<T> must implement the inherited abstract method List<T>.clear()\n----------\n9. ERROR in X.java (at line 7)\n\tclass UnmodifiableList<T> implements\n\t      ^^^^^^^^^^^^^^^^\nThe type UnmodifiableList<T> must implement the inherited abstract method List<T>.indexOf(Object)\n----------\n10. ERROR in X.java (at line 7)\n\tclass UnmodifiableList<T> implements\n\t      ^^^^^^^^^^^^^^^^\nThe type UnmodifiableList<T> must implement the inherited abstract method List<T>.toArray(T[])\n----------\n11. ERROR in X.java (at line 7)\n\tclass UnmodifiableList<T> implements\n\t      ^^^^^^^^^^^^^^^^\nThe type UnmodifiableList<T> must implement the inherited abstract method List<T>.toArray()\n----------\n12. ERROR in X.java (at line 7)\n\tclass UnmodifiableList<T> implements\n\t      ^^^^^^^^^^^^^^^^\nThe type UnmodifiableList<T> must implement the inherited abstract method List<T>.isEmpty()\n----------\n13. ERROR in X.java (at line 7)\n\tclass UnmodifiableList<T> implements\n\t      ^^^^^^^^^^^^^^^^\nThe type UnmodifiableList<T> must implement the inherited abstract method List<T>.listIterator(int)\n----------\n14. ERROR in X.java (at line 7)\n\tclass UnmodifiableList<T> implements\n\t      ^^^^^^^^^^^^^^^^\nThe type UnmodifiableList<T> must implement the inherited abstract method List<T>.listIterator()\n----------\n15. ERROR in X.java (at line 7)\n\tclass UnmodifiableList<T> implements\n\t      ^^^^^^^^^^^^^^^^\nThe type UnmodifiableList<T> must implement the inherited abstract method List<T>.add(int, T)\n----------\n16. ERROR in X.java (at line 7)\n\tclass UnmodifiableList<T> implements\n\t      ^^^^^^^^^^^^^^^^\nThe type UnmodifiableList<T> must implement the inherited abstract method List<T>.add(T)\n----------\n17. ERROR in X.java (at line 7)\n\tclass UnmodifiableList<T> implements\n\t      ^^^^^^^^^^^^^^^^\nThe type UnmodifiableList<T> must implement the inherited abstract method List<T>.set(int, T)\n----------\n18. ERROR in X.java (at line 7)\n\tclass UnmodifiableList<T> implements\n\t      ^^^^^^^^^^^^^^^^\nThe type UnmodifiableList<T> must implement the inherited abstract method List<T>.size()\n----------\n19. ERROR in X.java (at line 7)\n\tclass UnmodifiableList<T> implements\n\t      ^^^^^^^^^^^^^^^^\nThe type UnmodifiableList<T> must implement the inherited abstract method List<T>.containsAll(Collection<?>)\n----------\n20. ERROR in X.java (at line 7)\n\tclass UnmodifiableList<T> implements\n\t      ^^^^^^^^^^^^^^^^\nThe type UnmodifiableList<T> must implement the inherited abstract method List<T>.remove(int)\n----------\n21. ERROR in X.java (at line 7)\n\tclass UnmodifiableList<T> implements\n\t      ^^^^^^^^^^^^^^^^\nThe type UnmodifiableList<T> must implement the inherited abstract method List<T>.remove(Object)\n----------\n22. ERROR in X.java (at line 7)\n\tclass UnmodifiableList<T> implements\n\t      ^^^^^^^^^^^^^^^^\nThe type UnmodifiableList<T> must implement the inherited abstract method List<T>.removeAll(Collection<?>)\n----------\n23. ERROR in X.java (at line 7)\n\tclass UnmodifiableList<T> implements\n\t      ^^^^^^^^^^^^^^^^\nThe type UnmodifiableList<T> must implement the inherited abstract method List<T>.iterator()\n----------\n");
    }

    public void test418041a() {
        this.runNegativeTest(new String[]{"X.java", "public class X <@Marker T extends @Marker Y<@Marker ?>, @Marker Q extends @Marker Integer> {\n}\n@java.lang.annotation.Target (java.lang.annotation.ElementType.TYPE_USE)\n@interface Marker {}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X <@Marker T extends @Marker Y<@Marker ?>, @Marker Q extends @Marker Integer> {\n\t                                          ^\nY cannot be resolved to a type\n----------\n2. WARNING in X.java (at line 1)\n\tpublic class X <@Marker T extends @Marker Y<@Marker ?>, @Marker Q extends @Marker Integer> {\n\t                                                                          ^^^^^^^^^^^^^^^\nThe type parameter Q should not be bounded by the final type Integer. Final types cannot be further extended\n----------\n");
    }

    public void testWildcardCapture() {
        this.runNegativeTest(new String[]{"X.java", "import java.lang.annotation.ElementType;\nimport java.lang.annotation.Target;\nimport java.util.List;\n@Target(ElementType.TYPE_USE)\n@interface NonNull {\n}\n@Target(ElementType.TYPE_USE)\n@interface Nullable {\n}\n@Target(ElementType.TYPE_USE)\n@interface T {\n}\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tList<@Nullable ? extends X> lx1 = null;\n\t\tList<@NonNull ? extends X> lx2 = null;\n\t\tlx1 = lx2;\n\t\tlx1.add(lx2.get(0));\n\t\tlx1.add(lx1.get(0));\n       getAdd(lx1, lx2);\n\t}\n\tstatic <@NonNull P>  void getAdd(List<P> p1, List<P> p2) {\n\t\tp1.add(p2.get(0));\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 18)\n\tlx1.add(lx2.get(0));\n\t    ^^^\nThe method add(capture#3-of ? extends X) in the type List<capture#3-of ? extends X> is not applicable for the arguments (capture#4-of ? extends X)\n----------\n2. ERROR in X.java (at line 19)\n\tlx1.add(lx1.get(0));\n\t    ^^^\nThe method add(capture#5-of ? extends X) in the type List<capture#5-of ? extends X> is not applicable for the arguments (capture#6-of ? extends X)\n----------\n3. ERROR in X.java (at line 20)\n\tgetAdd(lx1, lx2);\n\t^^^^^^\nThe method getAdd(List<P>, List<P>) in the type X is not applicable for the arguments (List<capture#7-of ? extends X>, List<capture#8-of ? extends X>)\n----------\n");
    }

    public void testBug414038() {
        this.runNegativeTest(new String[]{"X.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@interface NonNull { int[].class value() default 0;}\npublic class X extends @NonNull() Object {    \n    public static int i = 0; \n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\t@interface NonNull { int[].class value() default 0;}\n\t                          ^^^^^^\nSyntax error on tokens, delete these tokens\n----------\n");
    }

    public void testGenericConstructor() {
        this.runNegativeTest(new String[]{"X.java", "import java.lang.annotation.Annotation;\nimport java.lang.annotation.ElementType;\nimport java.lang.annotation.Target;\n@Target(ElementType.TYPE_USE)\n@interface T {\n} \npublic class X { \n\n\t<P> @T X() {\n\t}\n   @T <P> X(X x) {\n   }\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\t<P> @T X() {\n\t    ^\nSyntax error on token \"@\", delete this token\n----------\n");
    }

    public void test419833() {
        this.runNegativeTest(new String[]{"X.java", "import java.lang.annotation.Target;\nimport java.lang.annotation.ElementType;\n@Target(ElementType.TYPE_USE)\n@interface T {\n}\nclass S {\n}\ninterface I {\n}\npublic class X extends @T S implements @T  {\n\tpublic int foo() {\n       return 0;\n\t}\t\n}\n"}, "----------\n1. ERROR in X.java (at line 10)\n\tpublic class X extends @T S implements @T  {\n\t                                       ^\nSyntax error on token \"@\", delete this token\n----------\n");
    }

    public void test420038() {
        this.runNegativeTest(new String[]{"X.java", "import java.lang.annotation.ElementType;\nimport java.lang.annotation.Target;\n@Target(ElementType.TYPE_USE)\n@interface T {\n}\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tClass<?> c = int @T [].class; \n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\tClass<?> c = int @T [].class; \n\t                 ^^\nSyntax error, type annotations are illegal here\n----------\n");
    }

    public void test420284() {
        this.runNegativeTest(new String[]{"X.java", "import java.io.Serializable;\nimport java.util.List;\npublic class X {\n    void foo(Object o) {\n        Integer i = (Integer & Serializable) o;\n        List<@NonNull Integer> l;\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tList<@NonNull Integer> l;\n\t      ^^^^^^^\nNonNull cannot be resolved to a type\n----------\n");
    }

    public void test391521() {
        this.runNegativeTest(new String[]{"X.java", "class Y {}\npublic class X {\n    Y y1 = (@Marker Z) null;\n    Y y2 = new @Marker Z();\n    Y[] y3 = (@Marker Z[]) null;\n    Y[] y4 = new @Marker Z[0];\n    Y[] y5 = (@Marker Y.Z) null;\n    Y[] y6 = new @Marker Y.  Z();\n    Y[] y7 = (@Marker Y.Z[]) null;\n    Y[] y8 = new @Marker Y[0].  Z;\n    Y[] y9 = new @Marker Y.  Z[0];\n}\n@java.lang.annotation.Target (java.lang.annotation.ElementType.TYPE_USE)\n@interface Marker{}\n\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tY y1 = (@Marker Z) null;\n\t                ^\nZ cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 4)\n\tY y2 = new @Marker Z();\n\t                   ^\nZ cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 5)\n\tY[] y3 = (@Marker Z[]) null;\n\t                  ^\nZ cannot be resolved to a type\n----------\n4. ERROR in X.java (at line 6)\n\tY[] y4 = new @Marker Z[0];\n\t                     ^\nZ cannot be resolved to a type\n----------\n5. ERROR in X.java (at line 7)\n\tY[] y5 = (@Marker Y.Z) null;\n\t                  ^^^\nY.Z cannot be resolved to a type\n----------\n6. ERROR in X.java (at line 8)\n\tY[] y6 = new @Marker Y.  Z();\n\t                     ^^^^^\nY.Z cannot be resolved to a type\n----------\n7. ERROR in X.java (at line 9)\n\tY[] y7 = (@Marker Y.Z[]) null;\n\t                  ^^^\nY.Z cannot be resolved to a type\n----------\n8. ERROR in X.java (at line 10)\n\tY[] y8 = new @Marker Y[0].  Z;\n\t                            ^\nZ cannot be resolved or is not a field\n----------\n9. ERROR in X.java (at line 11)\n\tY[] y9 = new @Marker Y.  Z[0];\n\t                     ^^^^^\nY.Z cannot be resolved to a type\n----------\n");
    }

    public void test414038() {
        this.runNegativeTest(new String[]{"X.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@interface NonNull { int[].class value() default 0;}\npublic class X extends @NonNull() Object {    \n    public static int i = 0; \n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\t@interface NonNull { int[].class value() default 0;}\n\t                          ^^^^^^\nSyntax error on tokens, delete these tokens\n----------\n", true);
    }

    public void test421791() {
        this.runNegativeTest(new String[]{"X.java", "import java.lang.annotation.ElementType;\nimport java.lang.annotation.Target;\n@Target(ElementType.TYPE_USE)\n@interface T {}\n@T\n@interface T2 {}\npublic class X {}\n"}, "", true);
    }

    public void testBug426977() {
        Map<String, String> customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.storeAnnotations", "enabled");
        this.runNegativeTest(new String[]{"test/X.java", "package test;\nimport java.lang.annotation.ElementType;\nimport java.lang.annotation.Target;\n\npublic class X {\n    test.@A Outer<>.@A Inner<> i;\n}\nclass Outer<T> {\n    class Inner {}\n}\n@Target(ElementType.TYPE_USE)\n@interface A {}\n"}, "----------\n1. ERROR in test\\X.java (at line 6)\n\ttest.@A Outer<>.@A Inner<> i;\n\t^^^^^^^^^^^^^\nIncorrect number of arguments for type Outer<T>; it cannot be parameterized with arguments <>\n----------\n", null, true, customOptions);
    }

    public void testBug426977a() {
        Map<String, String> customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.storeAnnotations", "enabled");
        this.runNegativeTest(new String[]{"test/X.java", "package test;\nimport java.lang.annotation.ElementType;\nimport java.lang.annotation.Target;\n\npublic class X {\n    test.@A Outer<Object>.@A Inner<> i;\n}\nclass Outer<T> {\n    class Inner {}\n}\n@Target(ElementType.TYPE_USE)\n@interface A {}\n"}, "----------\n1. ERROR in test\\X.java (at line 6)\n\ttest.@A Outer<Object>.@A Inner<> i;\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nThe type Outer<Object>.Inner is not generic; it cannot be parameterized with arguments <>\n----------\n", null, true, customOptions);
    }

    public void test425599() {
        Map<String, String> customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.storeAnnotations", "enabled");
        this.runNegativeTest(new String[]{"X.java", "import java.lang.annotation.ElementType;\nimport java.lang.annotation.Target;\npublic class X {\n    Object ax = new @A Outer().new Middle<String>();\n}\n@Target(ElementType.TYPE_USE) @interface A {}\nclass Outer {\n    class Middle<E> {}\n}\n"}, "", null, true, customOptions);
    }

    public void test427955() {
        Map<String, String> customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.storeAnnotations", "enabled");
        this.runNegativeTest(new String[]{"X.java", "/**\n * @param <K> unused\n * @param <V> unused\n */\npublic class X {}\nclass Outer<K, V> {\n  void method() {\n    //Internal compiler error: java.lang.NullPointerException at\n    // org.eclipse.jdt.internal.compiler.lookup.TypeSystem.getUnannotatedType(TypeSystem.java:76)\n    new Inner<>(null);\n  }\n  final class Inner<K2, V2> {\n    /**\n     * @param next unused \n     */\n    Inner(Inner<K2, V2> next) {}\n  }\n}\n"}, "", null, true, customOptions);
    }

    public void test419827a() {
        this.runNegativeTest(new String[]{"X.java", "import java.lang.annotation.ElementType;\nimport java.lang.annotation.Repeatable;\nimport java.lang.annotation.Target;\n\n@Target({ElementType.TYPE_USE})\n@Repeatable(FooContainer.class)\n@interface Foo {}\n@Target({ElementType.TYPE, ElementType.TYPE_USE})\n@interface FooContainer {\n\tFoo[] value();\n}\npublic class X{}\n"}, "", true);
    }

    public void test419827b() {
        this.runNegativeTest(new String[]{"X.java", "import java.lang.annotation.ElementType;\nimport java.lang.annotation.Repeatable;\nimport java.lang.annotation.Target;\n\n@Target({ElementType.TYPE_USE})\n@Repeatable(FooContainer.class)\n@interface Foo {}\n@Target({ElementType.TYPE})\n@interface FooContainer {\n\tFoo[] value();\n}\npublic class X{}\n"}, "", true);
    }

    public void test552082_comment_0() throws Exception {
        this.runNegativeTest(new String[]{"EclipseReturnValueAnnotationTest.java", "class EclipseReturnValueAnnotationTest {\n    \n    @interface SomeAnnotation {}\n\n     public @SomeAnnotation String foo(Object anything) {\n         return \"foo\";\n     }\n\n     public  <T>  @SomeAnnotation String bar(T anything) { // Error - type annotation position\n         return \"bar\";\n     }\n\n     public @SomeAnnotation <T> String baz(T anything) {  // OK - declaration annotation on method \n         return \"baz\";\n     }\n}\n"}, "----------\n1. ERROR in EclipseReturnValueAnnotationTest.java (at line 9)\n\tpublic  <T>  @SomeAnnotation String bar(T anything) { // Error - type annotation position\n\t             ^^^^^^^^^^^^^^^\nAnnotation types that do not specify explicit target element types cannot be applied here\n----------\n");
    }

    public void testIssue2554() throws Exception {
        if (this.complianceLevel < 0x3D0000L) {
            return;
        }
        this.runNegativeTest(new String[]{"X.java", "import java.lang.annotation.ElementType;\nimport java.lang.annotation.Target;\n\n@Target(ElementType.TYPE_USE)\n@interface T {\n}\npublic sealed interface X permits @T A {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println();\n\t}\n}\nfinal class A implements X {}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tpublic sealed interface X permits @T A {\n\t                                  ^^\nSyntax error, type annotations are illegal here\n----------\n");
    }
}

