/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractNullAnnotationTest;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;
import org.eclipse.jdt.core.tests.compiler.regression.NullAnnotationTests9;
import org.eclipse.jdt.core.tests.util.Util;

public class NullAnnotationTests21
extends AbstractNullAnnotationTest {
    public NullAnnotationTests21(String name) {
        super(name);
    }

    public static Test suite() {
        return NullAnnotationTests21.buildMinimalComplianceTestSuite(NullAnnotationTests21.testClass(), 262144);
    }

    public static Class<?> testClass() {
        return NullAnnotationTests21.class;
    }

    @Override
    @Deprecated
    protected void setUpAnnotationLib() throws IOException {
        if (this.LIBS == null) {
            String[] defaultLibs = this.getDefaultClassPaths();
            int len = defaultLibs.length;
            this.LIBS = new String[len + 1];
            System.arraycopy(defaultLibs, 0, this.LIBS, 0, len);
            this.LIBS[len] = NullAnnotationTests9.createAnnotation_2_4_jar(Util.getOutputDirectory() + File.separator, null);
        }
    }

    private AbstractRegressionTest.Runner getDefaultRunner() {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.classLibraries = this.LIBS;
        Map opts = this.getCompilerOptions();
        opts.put("org.eclipse.jdt.core.compiler.source", "21");
        runner.customOptions = opts;
        runner.javacTestOptions = AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError;
        return runner;
    }

    public void test_typePatternIsNN() {
        AbstractRegressionTest.Runner runner = this.getDefaultRunner();
        runner.testFiles = new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n\tvoid foo(Object o) {\n\t\tswitch (o) {\n\t\t\tcase Integer i -> consumeInt(i);\n\t\t\tdefault -> System.out.println(\"default\");\n\t\t}\n\t}\n\tvoid consumeInt(@NonNull Integer i) {\n\t\tSystem.out.print(i);\n\t}\n\tpublic static void main(String... args) {\n\t\tnew X().foo(3);\n\t}\n}\n"};
        runner.expectedCompilerLog = "";
        runner.expectedOutputString = "3";
        runner.runConformTest();
    }

    public void test_totalTypePatternDoesNotAdmitNull() {
        AbstractRegressionTest.Runner runner = this.getDefaultRunner();
        runner.testFiles = new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n\tvoid foo(Number n) {\n\t\ttry {\n\t\t\tswitch (n) {\n\t\t\t\tcase Integer i -> consumeInt(i);\n\t\t\t\tcase Number n0 -> consumeNumber(n0);\n\t\t\t}\n\t\t} catch (NullPointerException npe) {\n\t\t\t// Expecting an NPE because selector is null\n\t\t\tSystem.out.print(npe.getMessage());\n\t\t}\n\t}\n\tvoid consumeInt(@NonNull Integer i) {\n\t\tSystem.out.print(i);\n\t}\n\tvoid consumeNumber(@NonNull Number n) {\n     System.out.println(\"consumeNumber \");\n\t\tSystem.out.print(n.toString());\n\t}\n\tpublic static void main(String... args) {\n\t\tnew X().foo(null);\n\t}\n}\n"};
        runner.expectedCompilerLog = "";
        runner.expectedOutputString = "null";
        runner.runConformTest();
    }

    public void test_totalTypePatternNonNullExpression() {
        AbstractRegressionTest.Runner runner = this.getDefaultRunner();
        runner.testFiles = new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n\tvoid foo(Number n) {\n\t\tif (n == null) return;\n\t\tswitch (n) {\n\t\t\tcase Integer i -> System.out.print(i);\n\t\t\tcase Number n0 -> consumeNumber(n0);\n\t\t}\n\t}\n\tvoid consumeNumber(@NonNull Number n) {\n\t\tSystem.out.print(n.toString());\n\t}\n\tpublic static void main(String... args) {\n\t\tnew X().foo(null);\n\t}\n}\n"};
        runner.expectedCompilerLog = "";
        runner.expectedOutputString = "";
        runner.runConformTest();
    }

    public void test_totalTypePatternNonNullExpression_swExpr() {
        AbstractRegressionTest.Runner runner = this.getDefaultRunner();
        runner.testFiles = new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n\tint foo(Number n) {\n\t\tif (n == null) return -1;\n\t\treturn switch (n) {\n\t\t\tcase Integer i -> i;\n\t\t\tcase Number n0 -> consumeNumber(n0);\n\t\t};\n\t}\n\tint consumeNumber(@NonNull Number n) {\n\t\treturn Integer.valueOf(n.toString());\n\t}\n\tpublic static void main(String... args) {\n\t\tnew X().foo(null);\n\t}\n}\n"};
        runner.expectedCompilerLog = "";
        runner.expectedOutputString = "";
        runner.runConformTest();
    }

    public void test_totalTypePatternPlusNullPattern() {
        AbstractRegressionTest.Runner runner = this.getDefaultRunner();
        runner.testFiles = new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n\tvoid foo(Number n) {\n\t\tswitch (n) {\n\t\t\tcase null -> System.out.print(\"null\");\n\t\t\tcase Integer i -> System.out.print(i);\n\t\t\tcase Number n0 -> consumeNumber(n0);\n\t\t}\n\t}\n\tvoid consumeNumber(@NonNull Number n) {\n\t\tSystem.out.print(n.toString());\n\t}\n\tpublic static void main(String... args) {\n\t\tnew X().foo(null);\n\t}\n}\n"};
        runner.expectedCompilerLog = "";
        runner.expectedOutputString = "null";
        runner.runConformTest();
    }

    public void test_totalTypePatternNullableExpression() {
        AbstractRegressionTest.Runner runner = this.getDefaultRunner();
        runner.testFiles = new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n\tvoid foo(@Nullable Number n) {\n\t\tswitch (n) {\n\t\t\tcase Integer i -> System.out.print(i);\n\t\t\tcase Number n0 -> consumeNumber(n0);\n\t\t}\n\t}\n\tvoid consumeNumber(@NonNull Number n) {\n\t\tSystem.out.print(n.toString());\n\t}\n\tpublic static void main(String... args) {\n\t\tnew X().foo(null);\n\t}\n}\n"};
        runner.expectedCompilerLog = "----------\n1. ERROR in X.java (at line 4)\n\tswitch (n) {\n\t        ^\nPotential null pointer access: this expression has a '@Nullable' type\n----------\n";
        runner.runNegativeTest();
    }

    public void test_switchOverNNValueWithNullCase() {
        AbstractRegressionTest.Runner runner = this.getDefaultRunner();
        runner.customOptions.put("org.eclipse.jdt.core.compiler.problem.redundantNullCheck", "warning");
        runner.testFiles = new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n\tvoid foo(@NonNull Object o) {\n\t\tswitch (o) {\n\t\t\tcase Integer i -> consumeInt(i);\n\t\t\tcase null -> System.out.print(\"null\");\n\t\t\tdefault -> System.out.println(\"default\");\n\t\t}\n\t}\n\tvoid consumeInt(@NonNull Integer i) {\n\t\tSystem.out.print(i);\n\t}\n\tpublic static void main(String... args) {\n\t\tnew X().foo(3);\n\t}\n}\n"};
        runner.expectedCompilerLog = "----------\n1. WARNING in X.java (at line 6)\n\tcase null -> System.out.print(\"null\");\n\t^^^^^^^^^\nUnnecessary 'null' pattern, the switch selector expression cannot be null\n----------\n";
        runner.expectedOutputString = "3";
        runner.runConformTest();
    }

    public void _test_switchNullInSameCase() {
        AbstractRegressionTest.Runner runner = this.getDefaultRunner();
        runner.customOptions.put("org.eclipse.jdt.core.compiler.problem.redundantNullCheck", "warning");
        runner.testFiles = new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n\tvoid foo(Object o) {\n\t\tswitch (o) {\n\t\t\tcase null, Integer i -> consumeInt(i);\n\t\t\tdefault -> System.out.println(\"default\");\n\t\t}\n\t}\n\tvoid consumeInt(@NonNull Integer i) {\n\t\tSystem.out.print(i);\n\t}\n\tpublic static void main(String... args) {\n\t\tnew X().foo(3);\n\t}\n}\n"};
        runner.expectedCompilerLog = "----------\n1. ERROR in X.java (at line 5)\n\tcase null, Integer i -> consumeInt(i);\n\t                                   ^\nNull type mismatch: required '@NonNull Integer' but the provided value is inferred as @Nullable\n----------\n";
        runner.runNegativeTest();
    }

    public void test_switchOverNNValueWithNullCase_swExpr() {
        AbstractRegressionTest.Runner runner = this.getDefaultRunner();
        runner.customOptions.put("org.eclipse.jdt.core.compiler.problem.redundantNullCheck", "warning");
        runner.testFiles = new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n\tint foo(@NonNull Object o) {\n\t\treturn switch (o) {\n\t\t\tcase Integer i -> consumeInt(i);\n\t\t\tcase null -> 0;\n\t\t\tdefault -> -1;\n\t\t};\n\t}\n\tint consumeInt(@NonNull Integer i) {\n\t\treturn i;\n\t}\n\tpublic static void main(String... args) {\n\t\tSystem.out.print(new X().foo(3));\n\t}\n}\n"};
        runner.expectedCompilerLog = "----------\n1. WARNING in X.java (at line 6)\n\tcase null -> 0;\n\t^^^^^^^^^\nUnnecessary 'null' pattern, the switch selector expression cannot be null\n----------\n";
        runner.expectedOutputString = "3";
        runner.runConformTest();
    }

    public void test_nullHostileSwitch() {
        AbstractRegressionTest.Runner runner = this.getDefaultRunner();
        runner.customOptions.put("org.eclipse.jdt.core.compiler.problem.redundantNullCheck", "warning");
        runner.testFiles = new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n\tvoid foo(@Nullable Object o) {\n\t\tswitch (o) {\n\t\t\tcase Integer i -> consumeInt(i);\n\t\t\tdefault -> System.out.println(o);\n\t\t};\n\t}\n\tvoid consumeInt(@NonNull Integer i) {\n\t}\n\tpublic static void main(String... args) {\n\t\tnew X().foo(null);\n\t}\n}\n"};
        runner.expectedCompilerLog = "----------\n1. ERROR in X.java (at line 4)\n\tswitch (o) {\n\t        ^\nPotential null pointer access: this expression has a '@Nullable' type\n----------\n";
        runner.runNegativeTest();
    }

    public void test_defaultDoesNotApplyToNull() {
        AbstractRegressionTest.Runner runner = this.getDefaultRunner();
        runner.customOptions.put("org.eclipse.jdt.core.compiler.problem.redundantNullCheck", "warning");
        runner.testFiles = new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n\tvoid foo(@Nullable Object o) {\n\t\tswitch (o) {\n\t\t\tcase Integer i -> consumeInt(i);\n\t\t\tcase null -> System.out.print(\"null\");\n\t\t\tdefault -> System.out.println(o.toString());\n\t\t};\n\t}\n\tvoid consumeInt(@NonNull Integer i) {\n\t}\n\tpublic static void main(String... args) {\n\t\tnew X().foo(null);\n\t}\n}\n"};
        runner.expectedCompilerLog = "";
        runner.expectedOutputString = "null";
        runner.runConformTest();
    }

    public void test_defaultDoesNotApplyToNull_field() {
        AbstractRegressionTest.Runner runner = this.getDefaultRunner();
        runner.customOptions.put("org.eclipse.jdt.core.compiler.problem.syntacticNullAnalysisForFields", "enabled");
        runner.testFiles = new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n\t@Nullable Object o;\n\tvoid foo() {\n\t\tswitch (this.o) {\n\t\t\tcase Integer i -> consumeInt(i);\n\t\t\tcase null -> System.out.print(\"null\");\n\t\t\tdefault -> System.out.println(this.o.toString());\n\t\t};\n\t}\n\tvoid consumeInt(@NonNull Integer i) {\n\t}\n\tpublic static void main(String... args) {\n\t\tnew X().foo();\n\t}\n}\n"};
        runner.expectedCompilerLog = "";
        runner.expectedOutputString = "null";
        runner.runConformTest();
    }

    public void test_defaultDoesNotApplyToNull_field2() {
        AbstractRegressionTest.Runner runner = this.getDefaultRunner();
        runner.customOptions.put("org.eclipse.jdt.core.compiler.problem.syntacticNullAnalysisForFields", "enabled");
        runner.testFiles = new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n\t@Nullable Object o;\n\tvoid foo(X x) {\n\t\tswitch (x.o) {\n\t\t\tcase Integer i -> consumeInt(i);\n\t\t\tcase null -> System.out.print(\"null\");\n\t\t\tdefault -> System.out.println(x.o.toString());\n\t\t};\n\t}\n\tvoid consumeInt(@NonNull Integer i) {\n\t}\n\tpublic static void main(String... args) {\n\t\tnew X().foo(new X());\n\t}\n}\n"};
        runner.expectedCompilerLog = "";
        runner.expectedOutputString = "null";
        runner.runConformTest();
    }

    public void testBug576329() {
        AbstractRegressionTest.Runner runner = this.getDefaultRunner();
        runner.customOptions.put("org.eclipse.jdt.core.compiler.problem.syntacticNullAnalysisForFields", "enabled");
        runner.testFiles = new String[]{"Main.java", "public class Main {\n    int length;\n    public String switchOnArray(Object argv[]) {\n        return switch(argv.length) {\n        case 0 -> \"0\";\n        default -> \"x\";\n        };\n    }\n\tpublic static void main(String... args) {\n\t\tSystem.out.print(new Main().switchOnArray(args));\n\t}\n}\n"};
        runner.expectedCompilerLog = "";
        runner.expectedOutputString = "0";
        runner.runConformTest();
    }

    public void testInstanceOfPatternIsNonNull() {
        AbstractRegressionTest.Runner runner = this.getDefaultRunner();
        runner.testFiles = new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n\tpublic static void consumeNonNull(@NonNull String s) {\n\t\tSystem.out.println(\"nonnull\");\n\t}\n\tpublic static void main(String... args) {\n\t\tObject o = Math.random() < 0 ? new Object() : \"blah\";\n\t\tif (o instanceof String message) {\n\t\t\tconsumeNonNull(message);\n\t\t}\n\t}\n}\n"};
        runner.expectedCompilerLog = "";
        runner.expectedOutputString = "nonnull";
        runner.runConformTest();
    }

    public void testInstanceOfPatternIsLaterAssignedNull() {
        AbstractRegressionTest.Runner runner = this.getDefaultRunner();
        runner.testFiles = new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n\tpublic static void consumeNonNull(@NonNull String s) {\n\t\tSystem.out.println(\"nonnull\");\n\t}\n\tpublic static void main(String... args) {\n\t\tObject o = Math.random() >= 0 ? new Object() : \"blah\";\n\t\tif (o instanceof String message) {\n\t\t\tconsumeNonNull(message);\n\t\t\tmessage = null;\n\t\t\tconsumeNonNull(message);\n\t\t}\n\t}\n}\n"};
        runner.expectedCompilerLog = "----------\n1. ERROR in X.java (at line 11)\n\tconsumeNonNull(message);\n\t               ^^^^^^^\nNull type mismatch: required '@NonNull String' but the provided value is null\n----------\n";
        runner.runNegativeTest();
    }

    public void testNullableVar() {
        AbstractRegressionTest.Runner runner = this.getDefaultRunner();
        runner.testFiles = new String[]{"Test.java", "\nimport org.eclipse.jdt.annotation.NonNull;\n\npublic class Test {\n\tpublic @NonNull Test getSomeValue() { return this; }\n\t\n\tvoid test(boolean rainyDay) {\n\t\tvar a = rainyDay ? getSomeValue() : null;\n\t\ta.getSomeValue(); // problem not detected\n\t}\n\tvoid test2(boolean rainyDay) {\n\t\tTest a = rainyDay ? getSomeValue() : null;\n\t\ta.getSomeValue(); // Potential null pointer access: The variable a may be null at this location\n\t}\n}\n"};
        runner.expectedCompilerLog = "----------\n1. ERROR in Test.java (at line 9)\n\ta.getSomeValue(); // problem not detected\n\t^\nPotential null pointer access: The variable a may be null at this location\n----------\n2. ERROR in Test.java (at line 13)\n\ta.getSomeValue(); // Potential null pointer access: The variable a may be null at this location\n\t^\nPotential null pointer access: The variable a may be null at this location\n----------\n";
        runner.runNegativeTest();
    }

    public void _testGH629_01() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.source", "18");
        options.put("org.eclipse.jdt.core.compiler.annotation.nonnull", "test.NonNull");
        options.put("org.eclipse.jdt.core.compiler.annotation.nullable", "test.Nullable");
        options.put("org.eclipse.jdt.core.compiler.annotation.nullanalysis", "enabled");
        this.runNegativeTestWithLibs(new String[]{"Configuration.java", "public interface Configuration {\n}\n", "Init.java", "public interface Init<C extends Configuration> {\n}\n", "Annot.java", "public @interface Annot {\n    Class<? extends Init<? extends Configuration>>[] inits(); \n}\n", "App.java", "interface I<T> {}\n@Annot(inits = {App.MyInit.class})\npublic class App {\n    static class MyInit implements I<String>, Init<Configuration> {}\n}\n"}, options, "");
    }

    public void _testGH629_02() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.source", "18");
        options.put("org.eclipse.jdt.core.compiler.annotation.nonnull", "test.NonNull");
        options.put("org.eclipse.jdt.core.compiler.annotation.nullable", "test.Nullable");
        options.put("org.eclipse.jdt.core.compiler.annotation.nullanalysis", "enabled");
        this.runNegativeTestWithLibs(new String[]{"Annot.java", "public @interface Annot {\n    Class<? extends Init<? extends Configuration>>[] inits(); \n}\n", "App.java", "@Annot(inits = {App.MyInit.class})\npublic class App {\n    static class MyInit implements Init<Configuration> {}\n}\n", "Configuration.java", "public interface Configuration {\n}\n", "Init.java", "public interface Init<C extends Configuration> {\n}\n"}, options, "");
    }

    public void testBug572361() {
        this.runConformTestWithLibs(new String[]{"NonNullByDefaultAndRecords.java", "import org.eclipse.jdt.annotation.NonNullByDefault;\n\n@NonNullByDefault\npublic record NonNullByDefaultAndRecords () { }\n"}, this.getCompilerOptions(), "");
    }

    public void testIssue233_ok() throws Exception {
        AbstractRegressionTest.Runner runner = this.getDefaultRunner();
        runner.customOptions = this.getCompilerOptions();
        runner.customOptions.put("org.eclipse.jdt.core.compiler.problem.redundantNullAnnotation", "ignore");
        runner.testFiles = new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\nrecord A1(@NonNull String ca1, String ca2) {}\nrecord B1(@Nullable String cb1, String cb2) {}\n@NonNullByDefault\npublic class X {\n\trecord A2(@NonNull String ca1, String ca2) {}\n\trecord B2(@Nullable String cb1, String cb2) {}\n\n\tpublic static @NonNull String workWithA(A1 a, boolean f) {\n\t\treturn f ? a.ca1() : a.ca2();\n\t}\n\tpublic static @NonNull String workWithA(A2 a, boolean f) {\n\t\treturn f ? a.ca1() : a.ca2();\n\t}\n\tpublic static String workWithB(B1 b, boolean f) {\n\t\tif (f) {\n\t\t\tString c = b.cb1();\n\t\t\treturn c != null ? c : \"default \";\n\t\t}\n\t\treturn b.cb2();\n\t}\n\tpublic static String workWithB(B2 b, boolean f) {\n\t\tif (f) {\n\t\t\tString c = b.cb1();\n\t\t\treturn c != null ? c : \"default \";\n\t\t}\n\t\treturn b.cb2();\n\t}\n\tpublic static void main(String... args) {\n\t\t@NonNull String sa11 = workWithA(new A1(\"hello \", \"A11 \"), true);\n\t\t@NonNull String sa12 = workWithA(new A1(\"hello \", \"A12 \"), false);\n\t\t@NonNull String sb11 = workWithB(new B1(null, \"B11 \"), true);\n\t\t@NonNull String sb12 = workWithB(new B1(null, \"B12 \"), false);\n\t\t@NonNull String sa21 = workWithA(new A2(\"hello \", \"A21 \"), true);\n\t\t@NonNull String sa22 = workWithA(new A2(\"hello \", \"A22 \"), false);\n\t\t@NonNull String sb21 = workWithB(new B2(null, \"B21\"), true);\n\t\t@NonNull String sb22 = workWithB(new B2(null, \"B22\"), false);\n\t\tSystem.out.println(sa11+sa12+sb11+sb12+sa21+sa22+sb21+sb22);\n\t}\n}\n"};
        runner.expectedOutputString = "hello A12 default B12 hello A22 default B22";
        runner.runConformTest();
    }

    public void testIssue233_nok() throws Exception {
        AbstractRegressionTest.Runner runner = this.getDefaultRunner();
        runner.customOptions = this.getCompilerOptions();
        runner.customOptions.put("org.eclipse.jdt.core.compiler.problem.redundantNullAnnotation", "ignore");
        runner.testFiles = new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\nrecord A1(@Nullable String ca1, String ca2) {}\nrecord B1(@NonNull String cb1, String cb2) {}\n@NonNullByDefault\npublic class X {\n\trecord A2(@Nullable String ca1, String ca2) {}\n\trecord B2(@NonNull String cb1, String cb2) {}\n\n\tpublic static @NonNull String workWithA(A1 a, boolean f) {\n\t\treturn f ? a.ca1() : a.ca2();\n\t}\n\tpublic static @NonNull String workWithA(A2 a, boolean f) {\n\t\treturn f ? a.ca1() : a.ca2();\n\t}\n\tpublic static String workWithB(B1 b, boolean f) {\n\t\tif (f) {\n\t\t\tString c = b.cb1();\n\t\t\treturn c != null ? c : \"default \";\n\t\t}\n\t\treturn b.cb2();\n\t}\n\tpublic static String workWithB(B2 b, boolean f) {\n\t\tif (f) {\n\t\t\tString c = b.cb1();\n\t\t\treturn c != null ? c : \"default \";\n\t\t}\n\t\treturn b.cb2();\n\t}\n\tpublic static void main(String... args) {\n\t\t@NonNull String sa11 = workWithA(new A1(\"hello \", \"A11 \"), true);\n\t\t@NonNull String sa12 = workWithA(new A1(\"hello \", \"A12 \"), false);\n\t\t@NonNull String sb11 = workWithB(new B1(null, \"B11 \"), true);\n\t\t@NonNull String sb12 = workWithB(new B1(null, \"B12 \"), false);\n\t\t@NonNull String sa21 = workWithA(new A2(\"hello \", \"A21 \"), true);\n\t\t@NonNull String sa22 = workWithA(new A2(\"hello \", \"A22 \"), false);\n\t\t@NonNull String sb21 = workWithB(new B2(null, \"B21\"), true);\n\t\t@NonNull String sb22 = workWithB(new B2(null, \"B22\"), false);\n\t\tSystem.out.println(sa11+sa12+sb11+sb12+sa21+sa22+sb21+sb22);\n\t}\n}\n"};
        runner.expectedCompilerLog = "----------\n1. ERROR in X.java (at line 10)\n\treturn f ? a.ca1() : a.ca2();\n\t           ^^^^^^^\nNull type mismatch (type annotations): required '@NonNull String' but this expression has type '@Nullable String'\n----------\n2. WARNING in X.java (at line 10)\n\treturn f ? a.ca1() : a.ca2();\n\t                     ^^^^^^^\nNull type safety (type annotations): The expression of type 'String' needs unchecked conversion to conform to '@NonNull String'\n----------\n3. ERROR in X.java (at line 13)\n\treturn f ? a.ca1() : a.ca2();\n\t           ^^^^^^^\nNull type mismatch (type annotations): required '@NonNull String' but this expression has type '@Nullable String'\n----------\n4. ERROR in X.java (at line 18)\n\treturn c != null ? c : \"default \";\n\t       ^\nRedundant null check: The variable c cannot be null at this location\n----------\n5. WARNING in X.java (at line 20)\n\treturn b.cb2();\n\t       ^^^^^^^\nNull type safety (type annotations): The expression of type 'String' needs unchecked conversion to conform to '@NonNull String'\n----------\n6. ERROR in X.java (at line 25)\n\treturn c != null ? c : \"default \";\n\t       ^\nRedundant null check: The variable c cannot be null at this location\n----------\n7. ERROR in X.java (at line 32)\n\t@NonNull String sb11 = workWithB(new B1(null, \"B11 \"), true);\n\t                                        ^^^^\nNull type mismatch: required '@NonNull String' but the provided value is null\n----------\n8. ERROR in X.java (at line 33)\n\t@NonNull String sb12 = workWithB(new B1(null, \"B12 \"), false);\n\t                                        ^^^^\nNull type mismatch: required '@NonNull String' but the provided value is null\n----------\n9. ERROR in X.java (at line 36)\n\t@NonNull String sb21 = workWithB(new B2(null, \"B21\"), true);\n\t                                        ^^^^\nNull type mismatch: required '@NonNull String' but the provided value is null\n----------\n10. ERROR in X.java (at line 37)\n\t@NonNull String sb22 = workWithB(new B2(null, \"B22\"), false);\n\t                                        ^^^^\nNull type mismatch: required '@NonNull String' but the provided value is null\n----------\n";
        runner.expectedOutputString = "hellodefault";
        runner.runNegativeTest();
    }

    public void testIssue233_npeWitness() throws Exception {
        AbstractRegressionTest.Runner runner = this.getDefaultRunner();
        runner.testFiles = new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic record X(@NonNull String ca1, String ca2, @Nullable String ca2) {}\n"};
        runner.expectedCompilerLog = "----------\n1. ERROR in X.java (at line 2)\n\tpublic record X(@NonNull String ca1, String ca2, @Nullable String ca2) {}\n\t                                            ^^^\nDuplicate component ca2 in record\n----------\n2. ERROR in X.java (at line 2)\n\tpublic record X(@NonNull String ca1, String ca2, @Nullable String ca2) {}\n\t                                                                  ^^^\nDuplicate component ca2 in record\n----------\n";
        runner.runNegativeTest();
    }

    public void testGH1399() {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.testFiles = new String[]{"C.java", "@interface Ann { Class<? extends A> value(); }\nclass A {}\n@Ann(C.B.class) // <- ERROR: Type mismatch: cannot convert from Class<C.B> to Class<? extends A>\nclass C<T extends Number> {\n    class B extends A {}\n}\n"};
        runner.runConformTest();
    }

    public void testGH1399_2() {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.testFiles = new String[]{"C.java", "@interface Ann { Class<? extends A> value(); }\nclass A {}\n@Ann(C.B.class)\nclass C<T extends java.util.List<Number>> {\n    class B extends A {}\n}\n"};
        runner.runConformTest();
    }

    public void testGH1302() {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.testFiles = new String[]{"p/package-info.java", "@org.eclipse.jdt.annotation.NonNullByDefault\npackage p;\n", "p/Parent.java", "package p;\nimport java.util.Map;\npublic interface Parent {\n  Map<String, String> model();\n}\n", "p/Child.java", "package p;\nimport java.util.Map;\npublic record Child(Map<String, String> model) implements Parent {\n}\n"};
        runner.customOptions = this.getCompilerOptions();
        runner.classLibraries = this.LIBS;
        runner.runConformTest();
    }

    public void testGH1691_a() {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.testFiles = new String[]{"bug/package-info.java", "@org.eclipse.jdt.annotation.NonNullByDefault\npackage bug;\n", "bug/BlahSuper.java", "package bug;\n\nimport java.io.IOException;\nimport java.io.OutputStream;\n\npublic sealed interface BlahSuper<T, E extends Exception> permits Blah, BlahOther { }\nabstract non-sealed class BlahOther implements BlahSuper<OutputStream, IOException> { }\n", "bug/Blah.java", "package bug;\n\nimport java.io.IOException;\nimport java.io.OutputStream;\n\npublic abstract non-sealed class Blah<T, E extends Exception> implements BlahSuper<T, E> {\n\tpublic abstract static class InnerBlah extends Blah<OutputStream, IOException> { }\n}\n"};
        runner.classLibraries = this.LIBS;
        runner.runConformTest();
    }

    public void testGH1691_b() {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.testFiles = new String[]{"bug/Marker.java", "package bug;\npublic interface Marker {}\n", "bug/MyException.java", "package bug;\nimport java.io.IOException;\npublic class MyException extends IOException implements Marker {}\n", "bug/BlahSuper.java", "package bug;\n\nimport java.io.OutputStream;\nimport org.eclipse.jdt.annotation.NonNullByDefault;\n\n@NonNullByDefault\npublic sealed interface BlahSuper<T, E extends Exception & Marker> permits Blah, BlahOther { }\n@NonNullByDefault\nabstract non-sealed class BlahOther implements BlahSuper<OutputStream, MyException> { }\n", "bug/Blah.java", "package bug;\n\nimport java.io.OutputStream;\nimport org.eclipse.jdt.annotation.NonNull;\n\npublic abstract non-sealed class Blah<T, E extends Exception & @NonNull Marker> implements BlahSuper<T, E> {\n\tpublic abstract static class InnerBlah extends Blah<OutputStream, @NonNull MyException> { }\n}\n"};
        runner.classLibraries = this.LIBS;
        runner.runConformTest();
    }

    public void testGH1009() {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.annotatedTypeArgumentToUnannotated", "error");
        runner.customOptions = options;
        runner.testFiles = new String[]{"UnsafeNullTypeConversionFalsePositive.java", "import java.util.ArrayList;\nimport java.util.List;\nimport java.util.stream.Collectors;\n\nimport org.eclipse.jdt.annotation.NonNull;\n\npublic class UnsafeNullTypeConversionFalsePositive {\n\n\tpublic static void main(final String[] args) {\n\t\tfinal List<@NonNull StringBuffer> someList = new ArrayList<>();\n\t\tList<@NonNull String> results;\n\t\t// was buggy:\n\t\tresults = someList.stream().map(String::new).collect(Collectors.toList());\n\t\t// was OK:\n\t\tresults = someList.stream().map(buff -> new String(buff)).collect(Collectors.toList());\n\t\tresults = someList.stream().<@NonNull String>map(String::new).collect(Collectors.toList());\n\t}\n}\n"};
        runner.classLibraries = this.LIBS;
        runner.runConformTest();
    }

    public void testGH1760() {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.testFiles = new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\nimport java.util.*;\nimport java.util.stream.*;\npublic class X {\n\tList<@NonNull String> filter(List<@Nullable String> input) {\n\t\treturn input.stream()\n\t\t\t\t\t.filter(Objects::nonNull)\n\t\t\t\t\t.collect(Collectors.toList());\n\t}\n}\n"};
        runner.classLibraries = this.LIBS;
        runner.runConformTest();
    }

    public void _testGH1964_since_22() {
        if (this.complianceLevel < 0x430000L) {
            return;
        }
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.customOptions = this.getCompilerOptions();
        runner.customOptions.put("org.eclipse.jdt.core.compiler.problem.enablePreviewFeatures", "enabled");
        runner.customOptions.put("org.eclipse.jdt.core.compiler.problem.reportPreviewFeatures", "ignore");
        runner.customOptions.put("org.eclipse.jdt.core.compiler.compliance", "23");
        runner.customOptions.put("org.eclipse.jdt.core.compiler.source", "23");
        runner.customOptions.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "23");
        runner.vmArguments = new String[]{"--enable-preview"};
        runner.testFiles = new String[]{"JDK21TestingMain.java", "import static java.util.FormatProcessor.FMT;\nimport static java.lang.StringTemplate.RAW;\n\npublic final class JDK21TestingMain\n{\n  public static void main(final String[] args)\n  {\n    final int fourtyTwo = 42;\n    final String str = FMT.\"\\{fourtyTwo}\";\n\n    final int x=1;\n    final int y=2;\n    final StringTemplate st = RAW.\"\\{x} + \\{y} = \\{x + y}\";\n\n    final var x1 = STR.\"Hello World\";\n    final var x2 = FMT.\"Hello World\";\n    final var x3 = RAW.\"Hello World\";\n\n    System.out.println(STR.\"Hello World\");\n\n    System.out.println();\n  }\n}\n"};
        runner.classLibraries = this.LIBS;
        runner.runConformTest();
    }

    public void testGH1771() {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.customOptions = this.getCompilerOptions();
        runner.customOptions.put("org.eclipse.jdt.core.compiler.problem.nullSpecViolation", "error");
        runner.customOptions.put("org.eclipse.jdt.core.compiler.annotation.inheritNullAnnotations", "enabled");
        runner.testFiles = new String[]{"p/Foo.java", "package p;\n\npublic interface Foo\n{\n\t@org.eclipse.jdt.annotation.NonNullByDefault\n\trecord Bar(Object foo) implements\n\t          Foo\n\t{\n\t}\n\n\t@org.eclipse.jdt.annotation.Nullable\n\tObject foo();\n}\n"};
        runner.classLibraries = this.LIBS;
        runner.expectedCompilerLog = "----------\n1. ERROR in p\\Foo.java (at line 6)\n\trecord Bar(Object foo) implements\n\t           ^^^^^^\nThe default '@NonNull' conflicts with the inherited '@Nullable' annotation in the overridden method from Foo\n----------\n";
        runner.runNegativeTest();
    }

    public void testGH1771_corrected() {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.customOptions = this.getCompilerOptions();
        runner.customOptions.put("org.eclipse.jdt.core.compiler.problem.nullSpecViolation", "error");
        runner.customOptions.put("org.eclipse.jdt.core.compiler.annotation.inheritNullAnnotations", "enabled");
        runner.testFiles = new String[]{"p/Foo.java", "package p;\n\npublic interface Foo\n{\n\t@org.eclipse.jdt.annotation.NonNullByDefault\n\trecord Bar(@org.eclipse.jdt.annotation.Nullable Object foo) implements\n\t          Foo\n\t{\n\t}\n\n\t@org.eclipse.jdt.annotation.Nullable\n\tObject foo();\n}\n"};
        runner.classLibraries = this.LIBS;
        runner.runConformTest();
    }

    public void testGH1771_otherConflict1() {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.customOptions = this.getCompilerOptions();
        runner.customOptions.put("org.eclipse.jdt.core.compiler.problem.nullSpecViolation", "error");
        runner.customOptions.put("org.eclipse.jdt.core.compiler.annotation.inheritNullAnnotations", "enabled");
        runner.testFiles = new String[]{"p/Foo.java", "package p;\nimport org.eclipse.jdt.annotation.*;\npublic interface Foo {\n\n\t@NonNull Object foo();\n\n\trecord BarNOK(\n\t\t\tObject foo // conflicts with inherited @NonNull Object foo()\n\t\t) implements Foo { }\n\n\trecord BarNOK2(\n\t\t\t@Nullable Object foo // conflicts with inherited @NonNull Object foo()\n\t\t) implements Foo { }\n\n\trecord BarNOK3(Object foo) {\n\t\t@Override\n\t\tpublic @NonNull Object foo() { // try to outsmart analysis by improved explicit accessor\n\t\t\treturn foo; // simple contract violation\n\t\t}\n\t}\n\n\t@NonNullByDefault\n\trecord BarOK(Object foo) implements Foo { }\n}\n"};
        runner.classLibraries = this.LIBS;
        runner.expectedCompilerLog = "----------\n1. ERROR in p\\Foo.java (at line 8)\n\tObject foo // conflicts with inherited @NonNull Object foo()\n\t^^^^^^\nImplicit accessor method for 'Object foo' cannot override inherited method '@NonNull Object foo()' from Foo.BarNOK due to incompatible nullness constraints\n----------\n2. ERROR in p\\Foo.java (at line 12)\n\t@Nullable Object foo // conflicts with inherited @NonNull Object foo()\n\t          ^^^^^^\nImplicit accessor method for '@Nullable Object foo' cannot override inherited method '@NonNull Object foo()' from Foo.BarNOK2 due to incompatible nullness constraints\n----------\n3. WARNING in p\\Foo.java (at line 18)\n\treturn foo; // simple contract violation\n\t       ^^^\nNull type safety (type annotations): The expression of type 'Object' needs unchecked conversion to conform to '@NonNull Object'\n----------\n";
        runner.runNegativeTest();
    }

    public void testGH1771_otherConflict2() {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.customOptions = this.getCompilerOptions();
        runner.customOptions.put("org.eclipse.jdt.core.compiler.problem.nullSpecViolation", "error");
        runner.customOptions.put("org.eclipse.jdt.core.compiler.annotation.inheritNullAnnotations", "enabled");
        runner.testFiles = new String[]{"p/Foo.java", "package p;\nimport org.eclipse.jdt.annotation.*;\npublic interface Foo {\n\n\t@Nullable Object foo();\n\n\trecord BarNOK(\n\t\t\tObject foo // legally covariant override @Nullable Object -> Object\n\t\t) implements Foo { }\n\n\trecord BarOK1(\n\t\t\t@NonNull Object foo // legally covariant override @Nullable Object -> @NonNull Object\n\t\t) implements Foo { }\n\n\t@NonNullByDefault\n\trecord BarNOK3(\n\t\t\tObject foo // conflict between implicits: default & inherited\n\t\t) implements Foo { }\n\n\trecord BarOK(@Nullable Object foo) implements Foo { }\n}\n"};
        runner.classLibraries = this.LIBS;
        runner.expectedCompilerLog = "----------\n1. ERROR in p\\Foo.java (at line 17)\n\tObject foo // conflict between implicits: default & inherited\n\t^^^^^^\nThe default '@NonNull' conflicts with the inherited '@Nullable' annotation in the overridden method from Foo\n----------\n";
        runner.runNegativeTest();
    }

    public void testIssue2521() {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.testFiles = new String[]{"X.java", "@org.eclipse.jdt.annotation.NonNullByDefault\n\npublic sealed interface X {\n\n\trecord Stuff() implements X {}\n\n\tstatic Stuff match(X pm) {\n\t\treturn switch(pm) {\n\t\t\tcase Stuff s -> s;\n\t\t \t//default -> new Stuff(); //... you should not need as we exhausted it but Eclipse NPE w/o a default.\n\t\t};\n\t}\n\n\tpublic static void main(String[] args) {\n\t    System.out.println(match(new Stuff()));\n\t}\n}\n"};
        runner.expectedOutputString = "Stuff[]";
        runner.classLibraries = this.LIBS;
        runner.runConformTest();
    }

    public void testIssue2522() {
        AbstractRegressionTest.Runner runner = this.getDefaultRunner();
        runner.testFiles = new String[]{"PatternMatching.java", "import org.eclipse.jdt.annotation.*;\n\npublic sealed interface PatternMatching {\n\n    record Stuff() implements PatternMatching {}\n\n    @NonNull\n    static Stuff match(PatternMatching pm, int v) {\n    \tif (v == 0) {\n\t\t\tStuff r = switch (pm) {\n\t\t\tcase Stuff s -> s;\n\t\t\tcase null -> throw new NullPointerException();\n\t\t\t};\n\t\t\treturn r; // no error here - good\n    \t} else if (v == 1) {\n\t\t\tStuff r = switch (pm) {\n\t\t\tcase Stuff s -> s;\n\t\t\tcase null -> throw new NullPointerException();\n\t\t\t};\n\t\t\treturn null; // get error here\t- good\n    \t} else if (v == 2) {\n\t\t\tStuff r = switch (pm) {\n\t\t\tcase Stuff s -> s;\n\t\t\t};\n\t\t\treturn r; // no error here -- good\n    \t} else if (v == 3) {\n\t\t\tStuff r = switch (pm) {\n\t\t\tcase Stuff s -> null; // <<<<<---------------------------- Line 28 - error Why ???\n\t\t\t};\n\t\t\treturn r; // get error here - good\n    \t} else if (v == 4) {\n\t\t\tStuff r = switch (pm) {\n\t\t\tcase Stuff s -> s;\n\t\t\tcase null -> null;  // <<<-------------------------------- Line 34 - error Why ??\n\t\t\t};\n\t\t\treturn new Stuff(); // no error here   // good\n    \t}\n    \treturn new Stuff();\n    }\n}\n"};
        runner.expectedCompilerLog = "----------\n1. ERROR in PatternMatching.java (at line 20)\n\treturn null; // get error here\t- good\n\t       ^^^^\nNull type mismatch: required 'PatternMatching.@NonNull Stuff' but the provided value is null\n----------\n2. ERROR in PatternMatching.java (at line 30)\n\treturn r; // get error here - good\n\t       ^\nNull type mismatch: required 'PatternMatching.@NonNull Stuff' but the provided value is null\n----------\n";
        runner.runNegativeTest();
    }

    public void testIssue2522_2() {
        AbstractRegressionTest.Runner runner = this.getDefaultRunner();
        runner.testFiles = new String[]{"PatternMatching.java", "import org.eclipse.jdt.annotation.*;\n\npublic sealed interface PatternMatching {\n\n    record Stuff() implements PatternMatching {}\n\n    @NonNull\n    static Stuff match(PatternMatching pm, int v) {\n    \tif (v == 0) {\n\t\t\treturn switch (pm) {\n\t\t\tcase Stuff s -> s;\n\t\t\tcase null -> throw new NullPointerException();\n\t\t\t}; // no error here - good\n    \t} else if (v == 2) {\n\t\t\treturn switch (pm) {\n\t\t\tcase Stuff s -> s;\n\t\t\t}; // no error here -- good\n    \t} else if (v == 3) {\n\t\t\treturn switch (pm) {\n\t\t\tcase Stuff s -> null;  // get error here - good\n\t\t\t};\n    \t}\n    \treturn new Stuff();\n    }\n}\n"};
        runner.expectedCompilerLog = "----------\n1. ERROR in PatternMatching.java (at line 20)\n\tcase Stuff s -> null;  // get error here - good\n\t                ^^^^\nNull type mismatch: required 'PatternMatching.@NonNull Stuff' but the provided value is null\n----------\n";
        runner.runNegativeTest();
    }

    public void testIssue3381() {
        AbstractRegressionTest.Runner runner = this.getDefaultRunner();
        runner.testFiles = new String[]{"X.java", "import org.eclipse.jdt.annotation.Nullable;\n\npublic class X {\n\tvoid foo() {\n\t\t@Nullable Integer i = null;\n\t\tswitch (i) {\n\t\t\tcase Integer ii -> System.out.println();\n\t\t}\n\t}\n\tvoid goo() {\n\t\t@Nullable Integer i = null;\n\t\tswitch (i) {\n\t\t\tdefault -> System.out.println();\n\t\t}\n\t}\n}\n"};
        runner.expectedCompilerLog = "----------\n1. ERROR in X.java (at line 6)\n\tswitch (i) {\n\t        ^\nNull pointer access: The variable i can only be null at this location\n----------\n2. ERROR in X.java (at line 12)\n\tswitch (i) {\n\t        ^\nNull pointer access: This expression of type Integer is null but requires auto-unboxing\n----------\n";
        runner.runNegativeTest();
    }

    public void testIssue3319() {
        AbstractRegressionTest.Runner runner = this.getDefaultRunner();
        runner.testFiles = new String[]{"X.java", "import org.eclipse.jdt.annotation.NonNull;\n\npublic class X {\n\tstatic @NonNull Object foo(Object o) {\n\t\tswitch (o) {\n\t\t\tcase String s -> {\n\t\t\t\tif (o == null) {\n\t\t\t\t\tSystem.out.println(\"o cannot be null at all!\");\n\t\t\t\t}\n\t\t\t\tSystem.out.println();\n\t\t\t}\n\t\t\tdefault -> {\n\t\t\t\tif (o == null) {\n\t\t\t\t\tSystem.out.println(\"o cannot be null at all!\");\n\t\t\t\t}\n\t\t\t\tSystem.out.println();\n\t\t\t}\n\t\t}\n\t\treturn new Object();\n\t}\n\n\tstatic @NonNull Object foo(X o) {\n\t\tswitch (o) {\n\t\t\tcase X s  -> {\n\t\t\t\tif (o == null) {\n\t\t\t\t\tSystem.out.println(\"o cannot be null at all!\");\n\t\t\t\t}\n\t\t\t\tSystem.out.println(s);\n\t\t\t}\n\t\t}\n\t\treturn new Object();\n\t}\n}\n"};
        runner.expectedCompilerLog = "----------\n1. ERROR in X.java (at line 7)\n\tif (o == null) {\n\t    ^\nNull comparison always yields false: The variable o cannot be null at this location\n----------\n2. WARNING in X.java (at line 7)\n\tif (o == null) {\n\t\t\t\t\tSystem.out.println(\"o cannot be null at all!\");\n\t\t\t\t}\n\t               ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nDead code\n----------\n3. ERROR in X.java (at line 13)\n\tif (o == null) {\n\t    ^\nNull comparison always yields false: The variable o cannot be null at this location\n----------\n4. WARNING in X.java (at line 13)\n\tif (o == null) {\n\t\t\t\t\tSystem.out.println(\"o cannot be null at all!\");\n\t\t\t\t}\n\t               ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nDead code\n----------\n5. ERROR in X.java (at line 25)\n\tif (o == null) {\n\t    ^\nNull comparison always yields false: The variable o cannot be null at this location\n----------\n6. WARNING in X.java (at line 25)\n\tif (o == null) {\n\t\t\t\t\tSystem.out.println(\"o cannot be null at all!\");\n\t\t\t\t}\n\t               ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nDead code\n----------\n";
        runner.runNegativeTest();
    }

    public void testGH701() {
        AbstractRegressionTest.Runner runner = this.getDefaultRunner();
        runner.testFiles = new String[]{"X.java", "import static org.eclipse.jdt.annotation.DefaultLocation.*;\n\n\n@org.eclipse.jdt.annotation.NonNullByDefault({FIELD, PARAMETER, RETURN_TYPE}) // not RECORD_COMPONENT!\npublic class X {\n\trecord R(X x) {}\n\tX test(R r) {\n\t\treturn r.x();\n\t}\n}\n"};
        runner.expectedCompilerLog = "----------\n1. WARNING in X.java (at line 8)\n\treturn r.x();\n\t       ^^^^^\nNull type safety (type annotations): The expression of type 'X' needs unchecked conversion to conform to '@NonNull X'\n----------\n";
        runner.runWarningTest();
    }
}

