/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractNullAnnotationTest;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;
import org.eclipse.jdt.core.tests.compiler.regression.InMemoryNameEnvironment9;
import org.eclipse.jdt.core.tests.util.Util;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.batch.BasicModule;
import org.eclipse.jdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.jdt.internal.compiler.batch.FileSystem;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.IModule;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;

public class NullAnnotationTests9
extends AbstractNullAnnotationTest {
    Map<String, IModule> moduleMap = new HashMap<String, IModule>();
    Map<String, String> file2module = new HashMap<String, String>();

    public NullAnnotationTests9(String name) {
        super(name);
    }

    public static Test suite() {
        return NullAnnotationTests9.buildMinimalComplianceTestSuite(NullAnnotationTests9.testClass(), 64);
    }

    public static Class<?> testClass() {
        return NullAnnotationTests9.class;
    }

    @Override
    @Deprecated
    protected void setUpAnnotationLib() throws IOException {
        if (this.LIBS == null) {
            String[] defaultLibs = this.getDefaultClassPaths();
            int len = defaultLibs.length;
            this.LIBS = new String[len + 1];
            System.arraycopy(defaultLibs, 0, this.LIBS, 0, len);
            this.LIBS[len] = NullAnnotationTests9.createAnnotation_2_4_jar(Util.getOutputDirectory() + File.separator, null);
        }
    }

    public static String createAnnotation_2_4_jar(String dirName, String jcl9Path) throws IOException {
        String[] stringArray;
        String jarFileName = dirName + "org.eclipse.jdt.annotation_2.4.0.jar";
        String[] stringArray2 = new String[]{"module-info.java", "module org.eclipse.jdt.annotation {\n\texports org.eclipse.jdt.annotation;\n}\n", "org/eclipse/jdt/annotation/DefaultLocation.java", "package org.eclipse.jdt.annotation;\n\npublic enum DefaultLocation {\n\t\n\tPARAMETER, RETURN_TYPE, FIELD, TYPE_PARAMETER, TYPE_BOUND, TYPE_ARGUMENT, ARRAY_CONTENTS, RECORD_COMPONENT\n}\n", "org/eclipse/jdt/annotation/NonNullByDefault.java", "package org.eclipse.jdt.annotation;\n\nimport java.lang.annotation.ElementType;\nimport static org.eclipse.jdt.annotation.DefaultLocation.*;\n\nimport java.lang.annotation.*;\n \n@Documented\n@Retention(RetentionPolicy.CLASS)\n@Target({ ElementType.MODULE, ElementType.PACKAGE, ElementType.TYPE, ElementType.METHOD, ElementType.CONSTRUCTOR, ElementType.FIELD, ElementType.LOCAL_VARIABLE })\npublic @interface NonNullByDefault {\n\tDefaultLocation[] value() default { PARAMETER, RETURN_TYPE, FIELD, TYPE_BOUND, TYPE_ARGUMENT, RECORD_COMPONENT };\n}", "org/eclipse/jdt/annotation/NonNull.java", "package org.eclipse.jdt.annotation;\nimport static java.lang.annotation.ElementType.TYPE_USE;\n\nimport java.lang.annotation.*;\n \n@Documented\n@Retention(RetentionPolicy.CLASS)\n@Target({ TYPE_USE })\npublic @interface NonNull {\n\t// marker annotation with no members\n}\n", "org/eclipse/jdt/annotation/Nullable.java", "package org.eclipse.jdt.annotation;\n\nimport static java.lang.annotation.ElementType.TYPE_USE;\n\nimport java.lang.annotation.*;\n \n@Documented\n@Retention(RetentionPolicy.CLASS)\n@Target({ TYPE_USE })\npublic @interface Nullable {\n\t// marker annotation with no members\n}\n"};
        if (jcl9Path != null) {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = jcl9Path;
        } else {
            stringArray = null;
        }
        Util.createJar(stringArray2, null, jarFileName, stringArray, "9");
        return jarFileName;
    }

    @Override
    protected INameEnvironment getNameEnvironment(String[] testFiles, String[] classPaths, Map<String, String> options) {
        INameEnvironment[] classLibs;
        this.classpaths = classPaths == null ? this.getDefaultClassPaths() : classPaths;
        INameEnvironment[] iNameEnvironmentArray = classLibs = this.getClassLibs(classPaths == null, options);
        int n = classLibs.length;
        int n2 = 0;
        while (n2 < n) {
            INameEnvironment nameEnvironment = iNameEnvironmentArray[n2];
            ((FileSystem)nameEnvironment).scanForModules(this.createParser());
            ++n2;
        }
        return new InMemoryNameEnvironment9(testFiles, this.moduleMap, classLibs);
    }

    @Override
    protected CompilationUnit[] getCompilationUnits(String[] testFiles) {
        HashMap<String, char[]> moduleFiles = new HashMap<String, char[]>();
        int i = 0;
        while (i < testFiles.length) {
            IModule module = this.extractModuleDesc(testFiles[i], testFiles[i + 1]);
            if (module != null) {
                this.moduleMap.put(String.valueOf(module.name()), module);
                moduleFiles.put(testFiles[0], module.name());
            }
            i += 2;
        }
        CompilationUnit[] compilationUnits = Util.compilationUnits(testFiles);
        int i2 = 0;
        while (i2 < compilationUnits.length) {
            char[] fileName = compilationUnits[i2].getFileName();
            String fileNameString = String.valueOf(compilationUnits[i2].getFileName());
            if (CharOperation.endsWith((char[])fileName, (char[])TypeConstants.MODULE_INFO_FILE_NAME)) {
                compilationUnits[i2].module = (char[])moduleFiles.get(fileNameString.replace(File.separator, "/"));
            } else {
                String modName = this.file2module.get(fileNameString.replace(File.separator, "/"));
                if (modName != null) {
                    compilationUnits[i2].module = modName.toCharArray();
                }
            }
            ++i2;
        }
        return compilationUnits;
    }

    IModule extractModuleDesc(String fileName, String fileContent) {
        CompilationResult compilationResult;
        CompilationUnit cu;
        Parser parser;
        CompilationUnitDeclaration unit;
        if (fileName.toLowerCase().endsWith("module-info.java") && (unit = (parser = this.createParser()).parse((ICompilationUnit)(cu = new CompilationUnit(fileContent.toCharArray(), fileName, null)), compilationResult = new CompilationResult((ICompilationUnit)cu, 0, 1, 10))).isModuleInfo() && unit.moduleDeclaration != null) {
            return new BasicModule(unit.moduleDeclaration, null);
        }
        return null;
    }

    Parser createParser() {
        HashMap<String, String> opts = new HashMap<String, String>();
        opts.put("org.eclipse.jdt.core.compiler.source", "9");
        return new Parser(new ProblemReporter(this.getErrorHandlingPolicy(), new CompilerOptions(opts), this.getProblemFactory()), false);
    }

    void associateToModule(String moduleName, String ... fileNames) {
        String[] stringArray = fileNames;
        int n = fileNames.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName = stringArray[n2];
            this.file2module.put(fileName, moduleName);
            ++n2;
        }
    }

    private AbstractRegressionTest.Runner getDefaultRunner() {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.classLibraries = this.LIBS;
        runner.libsOnModulePath = true;
        runner.javacTestOptions = AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError;
        return runner;
    }

    public void test_nnbd_in_module_01() {
        this.associateToModule("my.mod", "my.mod/p/X.java");
        AbstractRegressionTest.Runner runner = this.getDefaultRunner();
        runner.testFiles = new String[]{"my.mod/module-info.java", "import org.eclipse.jdt.annotation.*;\n@NonNullByDefault\nmodule my.mod {\n\t\trequires static org.eclipse.jdt.annotation;\n}\n", "my.mod/p/X.java", "package p;\npublic class X {\n\t\tString f; // missing nn init\n    \tvoid foo(String s) {\n        this.f = s; // OK\n    \t}\n}\n"};
        runner.expectedCompilerLog = "----------\n1. ERROR in my.mod\\p\\X.java (at line 3)\n\tString f; // missing nn init\n\t       ^\nThe @NonNull field f may not have been initialized\n----------\n";
        runner.runNegativeTest();
    }

    public void test_nnbd_in_module_02() throws IOException {
        String jarPath = OUTPUT_DIR + "/mod.one.jar";
        Util.createJar(new String[]{"module-info.java", "@org.eclipse.jdt.annotation.NonNullByDefault\nmodule mod.one {\n\trequires org.eclipse.jdt.annotation;\n\texports p.q;\n}\n", "p/q/API.java", "package p.q;\npublic class API {\n\tpublic String id(String in) { return in; }\n}\n"}, null, jarPath, this.LIBS, "9");
        this.associateToModule("my.mod", "my.mod/p/X.java");
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.shouldFlushOutputDirectory = false;
        runner.classLibraries = Arrays.copyOf(this.LIBS, this.LIBS.length + 1);
        runner.classLibraries[runner.classLibraries.length - 1] = jarPath;
        runner.libsOnModulePath = true;
        runner.testFiles = new String[]{"my.mod/module-info.java", "import org.eclipse.jdt.annotation.*;\n@NonNullByDefault\nmodule my.mod {\n\t\trequires static org.eclipse.jdt.annotation;\n\t\trequires mod.one;\n}\n", "my.mod/p/X.java", "package p;\nimport p.q.API;\npublic class X {\n    \tvoid foo(API api) {\n        api.id(api.id(\"\")); // OK\n        api.id(null); // NOK\n    \t}\n}\n"};
        runner.expectedCompilerLog = "----------\n1. ERROR in my.mod\\p\\X.java (at line 6)\n\tapi.id(null); // NOK\n\t       ^^^^\nNull type mismatch: required '@NonNull String' but the provided value is null\n----------\n";
        runner.javacTestOptions = AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError;
        runner.runNegativeTest();
    }

    public void test_redundant_nnbd_vs_module() {
        this.associateToModule("my.mod", "my.mod/p/X.java", "my.mod/p2/package-info.java");
        AbstractRegressionTest.Runner runner = this.getDefaultRunner();
        runner.testFiles = new String[]{"my.mod/module-info.java", "import org.eclipse.jdt.annotation.*;\n@NonNullByDefault\nmodule my.mod {\n\t\trequires static org.eclipse.jdt.annotation;\n}\n", "my.mod/p/X.java", "package p;\n@org.eclipse.jdt.annotation.NonNullByDefault\npublic class X {\n\t\tString f; // missing nn init\n    \tvoid foo(String s) {\n        this.f = s; // OK\n    \t}\n}\n", "my.mod/p/Y.java", "package p;\nimport static org.eclipse.jdt.annotation.DefaultLocation.*;\n@org.eclipse.jdt.annotation.NonNullByDefault(PARAMETER)\npublic class Y {\n\t\tString f; // missing init is NOT a problem\n    \tvoid foo(String s) {\n        this.f = s; // OK\n    \t}\n}\n", "my.mod/p2/package-info.java", "@org.eclipse.jdt.annotation.NonNullByDefault\npackage p2;\n"};
        runner.expectedCompilerLog = "----------\n1. WARNING in my.mod\\p\\X.java (at line 2)\n\t@org.eclipse.jdt.annotation.NonNullByDefault\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nNullness default is redundant with a default specified for the enclosing module my.mod\n----------\n2. ERROR in my.mod\\p\\X.java (at line 4)\n\tString f; // missing nn init\n\t       ^\nThe @NonNull field f may not have been initialized\n----------\n----------\n1. WARNING in my.mod\\p2\\package-info.java (at line 1)\n\t@org.eclipse.jdt.annotation.NonNullByDefault\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nNullness default is redundant with a default specified for the enclosing module my.mod\n----------\n";
        runner.runNegativeTest();
    }

    public void testBug536037a() {
        if (this.complianceLevel < 0x360000L) {
            return;
        }
        this.runConformTestWithLibs(new String[]{"Bar.java", "@org.eclipse.jdt.annotation.NonNullByDefault\npublic class Bar {\n    static void bar(Iterable<String> list) {\n        for(var s : list);\n    }\n}\n"}, null, "");
        this.verifier.shutDown();
    }

    public void testBug536037b() {
        if (this.complianceLevel < 0x360000L) {
            return;
        }
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.annotation.nonnull", "test.NonNull");
        options.put("org.eclipse.jdt.core.compiler.annotation.nullable", "test.Nullable");
        this.runNegativeTestWithLibs(new String[]{"test/NonNull.java", "package test;\nimport java.lang.annotation.*;\n@Target({ElementType.LOCAL_VARIABLE,ElementType.PARAMETER}) public @interface NonNull {}\n", "test/Nullable.java", "package test;\nimport java.lang.annotation.*;\n@Target({ElementType.LOCAL_VARIABLE,ElementType.PARAMETER}) public @interface Nullable {}\n", "Bar.java", "import test.*;\npublic class Bar {\n    static void bar1(@Nullable String s1, Iterable<String> list) {\n\t\t@NonNull var s2 = s1;\n\t\tfor (@NonNull var s : list);\n\t }\n    static void bar2(int[] array) {\n\t\t@NonNull var i1 = 3;\n\t\tfor (@NonNull var s : array);\n\t }\n}\n"}, options, "----------\n1. ERROR in Bar.java (at line 4)\n\t@NonNull var s2 = s1;\n\t                  ^^\nNull type mismatch: required '@NonNull String' but the provided value is specified as @Nullable\n----------\n2. WARNING in Bar.java (at line 5)\n\tfor (@NonNull var s : list);\n\t                      ^^^^\nNull type safety: The expression of type 'String' needs unchecked conversion to conform to '@NonNull String'\n----------\n3. ERROR in Bar.java (at line 8)\n\t@NonNull var i1 = 3;\n\t^^^^^^^^\nThe nullness annotation @NonNull is not applicable for the primitive type int\n----------\n4. ERROR in Bar.java (at line 9)\n\tfor (@NonNull var s : array);\n\t     ^^^^^^^^\nThe nullness annotation @NonNull is not applicable for the primitive type int\n----------\n");
    }

    public void testGH1152() {
        AbstractRegressionTest.Runner runner = this.getDefaultRunner();
        runner.testFiles = new String[]{"bug/NonNullBug.java", "package bug;\nimport org.eclipse.jdt.annotation.NonNull;\npublic class NonNullBug {\n\tinterface Interface<@NonNull T> { }\n\n\tclass Class<T> implements Interface<@NonNull T> {} // 4.28 Null constraint mismatch: The type 'T' is not a valid substitute for the type parameter '@NonNull T'\n}\n"};
        runner.runConformTest();
    }
}

