/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.io.IOException;
import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;
import org.eclipse.jdt.core.util.ClassFormatException;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileConstants;

public class PatternMatching16Test
extends AbstractRegressionTest {
    private static final AbstractRegressionTest.JavacTestOptions JAVAC_OPTIONS = new AbstractRegressionTest.JavacTestOptions("-source 16");

    public static Class<?> testClass() {
        return PatternMatching16Test.class;
    }

    public static Test suite() {
        return PatternMatching16Test.buildMinimalComplianceTestSuite(PatternMatching16Test.testClass(), 8192);
    }

    public PatternMatching16Test(String testName) {
        super(testName);
    }

    protected Map<String, String> getCompilerOptions(boolean preview) {
        Map<String, String> defaultOptions = super.getCompilerOptions();
        if (this.complianceLevel >= ClassFileConstants.getLatestJDKLevel() && preview) {
            defaultOptions.put("org.eclipse.jdt.core.compiler.problem.enablePreviewFeatures", "enabled");
        }
        return defaultOptions;
    }

    @Override
    protected void runConformTest(String[] testFiles, String expectedOutput, Map<String, String> customOptions) {
        if (!isJRE16Plus) {
            return;
        }
        this.runConformTest(testFiles, expectedOutput, customOptions, new String[]{"--enable-preview"}, JAVAC_OPTIONS);
    }

    protected void runNegativeTest(String[] testFiles, String expectedCompilerLog, String javacLog, String[] classLibraries, boolean shouldFlushOutputDirectory, Map<String, String> customOptions) {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.testFiles = testFiles;
        runner.expectedCompilerLog = expectedCompilerLog;
        runner.javacTestOptions = JAVAC_OPTIONS;
        runner.customOptions = customOptions;
        runner.expectedJavacOutputString = javacLog;
        runner.runNegativeTest();
    }

    public void test000a() {
        Map<String, String> options = this.getCompilerOptions(false);
        options.put("org.eclipse.jdt.core.compiler.compliance", "15");
        options.put("org.eclipse.jdt.core.compiler.source", "15");
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "15");
        this.runNegativeTest(new String[]{"X1.java", "public class X1 {\n  public void foo(Object obj) {\n\t\tif (obj instanceof String s) {\n\t\t}\n \t}\n}\n"}, "----------\n1. ERROR in X1.java (at line 3)\n\tif (obj instanceof String s) {\n\t                   ^^^^^^^^\nThe Java feature 'Type Patterns' is only available with source level 16 and above\n----------\n", null, true, options);
        options.put("org.eclipse.jdt.core.compiler.compliance", "16");
        options.put("org.eclipse.jdt.core.compiler.source", "16");
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "16");
    }

    public void test000b() {
        if (this.complianceLevel < ClassFileConstants.getLatestJDKLevel()) {
            return;
        }
        Map<String, String> options = this.getCompilerOptions(true);
        options.put("org.eclipse.jdt.core.compiler.compliance", "14");
        options.put("org.eclipse.jdt.core.compiler.source", "14");
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "14");
        this.runNegativeTest(new String[]{"X1.java", "public class X1 {\n  public void foo(Object obj) {\n\t\tif (obj instanceof String s) {\n\t\t}\n \t}\n}\n"}, "----------\n1. ERROR in X1.java (at line 0)\n\tpublic class X1 {\n\t^\nPreview features enabled at an invalid source release level 14, preview can be enabled only at source level " + PREVIEW_ALLOWED_LEVEL + "\n----------\n", null, true, options);
        options.put("org.eclipse.jdt.core.compiler.compliance", "16");
        options.put("org.eclipse.jdt.core.compiler.source", "16");
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "16");
    }

    public void test001() {
        Map<String, String> options = this.getCompilerOptions(false);
        this.runConformTest(new String[]{"X1.java", "public class X1 {\n  public void foo(Object obj) {\n\t\tif (obj instanceof String s) {\n\t\t}\n \t}\n  public static void main(String[] obj) {\n\t}\n}\n"}, "", options);
    }

    public void test002() {
        Map<String, String> options = this.getCompilerOptions(true);
        this.runNegativeTest(new String[]{"X2.java", "@SuppressWarnings(\"preview\")\npublic class X2 {\n  public void foo(Integer obj) {\n\t\tif (obj instanceof String s) {\n\t\t}\n \t}\n}\n"}, "----------\n1. ERROR in X2.java (at line 4)\n\tif (obj instanceof String s) {\n\t    ^^^^^^^^^^^^^^^^^^^^^^^\nIncompatible conditional operand types Integer and String\n----------\n", "", null, true, options);
    }

    public void test003() {
        Map<String, String> options = this.getCompilerOptions(true);
        this.runNegativeTest(new String[]{"X3.java", "@SuppressWarnings(\"preview\")\npublic class X3 {\n  public void foo(Number num) {\n\t\tif (num instanceof Integer s) {\n\t\t} else if (num instanceof String) {\n\t\t}\n \t}\n}\n"}, "----------\n1. ERROR in X3.java (at line 5)\n\t} else if (num instanceof String) {\n\t           ^^^^^^^^^^^^^^^^^^^^^\nIncompatible conditional operand types Number and String\n----------\n", "", null, true, options);
    }

    public void test003a() {
        Map<String, String> options = this.getCompilerOptions(false);
        String[] testFiles = new String[]{"X3.java", "@SuppressWarnings(\"preview\")\npublic class X3 {\n  public void foo(Number num) {\n\t\tif (num instanceof int) {\n\t\t\tSystem.out.print(\"int\");\n\t\t}\n \t}\n\tpublic static void main(String... args) {\n\t\tnew X3().foo(3);\t}\n}\n"};
        this.runNegativeTest(testFiles, "----------\n1. ERROR in X3.java (at line 4)\n\tif (num instanceof int) {\n\t    ^^^^^^^^^^^^^^^^^^\nIncompatible conditional operand types Number and int\n----------\n", "", null, true, options);
    }

    public void test004() {
        Map<String, String> options = this.getCompilerOptions(true);
        this.runNegativeTest(new String[]{"X4.java", "@SuppressWarnings(\"preview\")\npublic class X4 {\n  public void foo(Object obj) {\n\t\tString s = null;\n\t\tif (obj instanceof Integer s) {\n\t\t} else if (obj instanceof String) {\n\t\t}\n \t}\n}\n"}, "----------\n1. ERROR in X4.java (at line 5)\n\tif (obj instanceof Integer s) {\n\t                           ^\nDuplicate local variable s\n----------\n", "", null, true, options);
    }

    public void test005() {
        Map<String, String> options = this.getCompilerOptions(true);
        this.runConformTest(new String[]{"X5.java", "@SuppressWarnings(\"preview\")\npublic class X5 {\n@SuppressWarnings(\"preview\")\n  public static void foo(Object obj) {\n\t\tif (obj instanceof Integer i) {\n\t\t\tSystem.out.print(i);\n\t\t} else if (obj instanceof String s) {\n\t\t\tSystem.out.print(s);\n\t\t}\n \t}\n  public static void main(String[] obj) {\n\t\tfoo(100);\n\t}\n}\n"}, "100", options);
    }

    public void test006() {
        Map<String, String> options = this.getCompilerOptions(true);
        this.runConformTest(new String[]{"X6.java", "@SuppressWarnings(\"preview\")\npublic class X6 {\n  public static void foo(Object obj) {\n\t\tif (obj instanceof Integer i) {\n\t\t\tSystem.out.print(i);\n\t\t} else if (obj instanceof String s) {\n\t\t\tSystem.out.print(s);\n\t\t}\n \t}\n  public static void main(String[] obj) {\n\t\tfoo(\"abcd\");\n\t}\n}\n"}, "abcd", options);
    }

    public void test006a() {
        Map<String, String> options = this.getCompilerOptions(true);
        this.runNegativeTest(new String[]{"X6a.java", "@SuppressWarnings(\"preview\")\npublic class X6a {\n\tpublic static void foo(Object obj) {\n\t\tif (obj != null) {\n\t\t\tif (obj instanceof Integer i) {\n\t\t\t\tSystem.out.print(i);\n\t\t\t} else if (obj instanceof String s) {\n\t\t\t\tSystem.out.print(i);\n\t\t\t}\n \t\t}\n \t\tSystem.out.print(i);\n\t}\n  public static void main(String[] obj) {\n\t\tfoo(\"abcd\");\n\t}\n}\n"}, "----------\n1. ERROR in X6a.java (at line 8)\n\tSystem.out.print(i);\n\t                 ^\ni cannot be resolved to a variable\n----------\n2. ERROR in X6a.java (at line 11)\n\tSystem.out.print(i);\n\t                 ^\ni cannot be resolved to a variable\n----------\n", "", null, true, options);
    }

    public void test006b() {
        Map<String, String> options = this.getCompilerOptions(true);
        this.runNegativeTest(new String[]{"X6b.java", "@SuppressWarnings(\"preview\")\npublic class X6b {\n\tpublic static void foo(Object obj) {\n\t\tif (obj != null) {\n\t\t\tif (obj instanceof Integer i) {\n\t\t\t\tSystem.out.print(i);\n\t\t\t} else if (obj instanceof String s) {\n\t\t\t\tSystem.out.print(i);\n\t\t\t}\n \t\t}\n \t\tSystem.out.print(s);\n\t}\n  public static void main(String[] obj) {\n\t\tfoo(\"abcd\");\n\t}\n}\n"}, "----------\n1. ERROR in X6b.java (at line 8)\n\tSystem.out.print(i);\n\t                 ^\ni cannot be resolved to a variable\n----------\n2. ERROR in X6b.java (at line 11)\n\tSystem.out.print(s);\n\t                 ^\ns cannot be resolved to a variable\n----------\n", "", null, true, options);
    }

    public void test006c() {
        Map<String, String> options = this.getCompilerOptions(true);
        this.runNegativeTest(new String[]{"X6c.java", "@SuppressWarnings(\"preview\")\npublic class X6c {\n  public static void foo(Object obj) {\n\t\tif (obj instanceof Integer i) {\n\t\t\tSystem.out.print(i);\n\t\t} else if (obj instanceof String s) {\n\t\t\tSystem.out.print(i);\n\t\t}\n \t}\n  public static void main(String[] obj) {\n\t\tfoo(\"abcd\");\n\t}\n}\n"}, "----------\n1. ERROR in X6c.java (at line 7)\n\tSystem.out.print(i);\n\t                 ^\ni cannot be resolved to a variable\n----------\n", "", null, true, options);
    }

    public void test006d() {
        Map<String, String> options = this.getCompilerOptions(true);
        this.runNegativeTest(new String[]{"X6d.java", "@SuppressWarnings(\"preview\")\npublic class X6d {\n  public static void foo(Object obj) {\n\t\tif (obj instanceof Integer i) {\n\t\t\tSystem.out.print(i);\n\t\t} else {\n\t\t\tSystem.out.print(i);\n\t\t}\n \t}\n  public static void main(String[] obj) {\n\t\tfoo(\"abcd\");\n\t}\n}\n"}, "----------\n1. ERROR in X6d.java (at line 7)\n\tSystem.out.print(i);\n\t                 ^\ni cannot be resolved to a variable\n----------\n", "", null, true, options);
    }

    public void test007() {
        Map<String, String> options = this.getCompilerOptions(true);
        this.runNegativeTest(new String[]{"X7.java", "@SuppressWarnings(\"preview\")\npublic class X7 {\n  public static void foo(Object obj) {\n\t\tif (obj instanceof Integer i) {\n\t\t\tSystem.out.print(i);\n\t\t} else if (obj instanceof String s) {\n\t\t\tSystem.out.print(i);\n\t\t}\n \t}\n  public static void main(String[] obj) {\n\t\tfoo(\"abcd\");\n\t}\n}\n"}, "----------\n1. ERROR in X7.java (at line 7)\n\tSystem.out.print(i);\n\t                 ^\ni cannot be resolved to a variable\n----------\n", "X7.java:4: warning: [preview] pattern matching in instanceof is a preview feature and may be removed in a future release.\n\t\tif (obj instanceof Integer i) {\n\t\t                           ^\nX7.java:6: warning: [preview] pattern matching in instanceof is a preview feature and may be removed in a future release.\n\t\t} else if (obj instanceof String s) {\n\t\t                                 ^\nX7.java:7: error: cannot find symbol\n\t\t\tSystem.out.print(i);\n\t\t\t                 ^\n  symbol:   variable i\n  location: class X7\n1 error\n2 warnings", null, true, options);
    }

    public void test008() {
        Map<String, String> options = this.getCompilerOptions(true);
        this.runConformTest(new String[]{"X8.java", "@SuppressWarnings(\"preview\")\npublic class X8 {\n  \tpublic static void foo(Object b) {\n\t\tObject c = null;\n\t\tif (b != c) {\n\t\t\tif ((b instanceof String s) && (s.length() != 0))\n\t\t\t\tSystem.out.println(\"s:\" + s);\n\t\t\telse \n\t\t\t\tSystem.out.println(\"b:\" + b);\n\t\t}\n\t}  public static void main(String[] obj) {\n\t\tfoo(100);\n\t\tfoo(\"abcd\");\n\t}\n}\n"}, "b:100\ns:abcd", options);
    }

    public void test009() {
        Map<String, String> options = this.getCompilerOptions(true);
        this.runConformTest(new String[]{"X9.java", "@SuppressWarnings(\"preview\")\npublic class X9 {\n  \tpublic static void foo(Object b) {\n\t\tObject c = null;\n\t\tif (b != c) {\n\t\t\tif ((b instanceof String s) && (s.length() != 0))\n\t\t\t\tSystem.out.println(\"s:\" + s);\n\t\t\telse if ((b instanceof Integer i2))\n\t\t\t\tSystem.out.println(\"i2:\" + i2);\n\t\t}\n\t}  public static void main(String[] obj) {\n\t\tfoo(100);\n\t\tfoo(\"abcd\");\n\t}\n}\n"}, "i2:100\ns:abcd", options);
    }

    public void test010() {
        Map<String, String> options = this.getCompilerOptions(true);
        this.runConformTest(new String[]{"X10.java", "@SuppressWarnings(\"preview\")\npublic class X10 {\n  \tpublic static void foo(Object b) {\n\t\tObject c = null;\n\t\tif (b != c) {\n\t\t\tif (b != null && (b instanceof String s))\n\t\t\t\tSystem.out.println(\"s:\" + s);\n\t\t\telse \t\t\t\tSystem.out.println(\"b:\" + b);\n\t\t}\n\t}  public static void main(String[] obj) {\n\t\tfoo(100);\n\t\tfoo(\"abcd\");\n\t}\n}\n"}, "b:100\ns:abcd", options);
    }

    public void test011() {
        Map<String, String> options = this.getCompilerOptions(true);
        this.runNegativeTest(new String[]{"X11.java", "@SuppressWarnings(\"preview\")\npublic class X11 {\n  \tpublic static void foo(Object b) {\n\t\tObject c = null;\n\t\tif (b == null && (b instanceof String s)) {\n\t\t} else {\t\t}\n\t\tSystem.out.println(s);\n\t}  public static void main(String[] obj) {\n\t\tfoo(100);\n\t\tfoo(\"abcd\");\n\t}\n}\n"}, "----------\n1. ERROR in X11.java (at line 7)\n\tSystem.out.println(s);\n\t                   ^\ns cannot be resolved to a variable\n----------\n", "", null, true, options);
    }

    public void test012() {
        Map<String, String> options = this.getCompilerOptions(true);
        this.runNegativeTest(new String[]{"X12.java", "@SuppressWarnings(\"preview\")\npublic class X12 {\n  \tpublic static void foo(Object b) {\n\t\tObject c = new Object();\n\t\tif (b != c) {\n\t\t\tif (b == null && (b instanceof String s)) {\n\t\t\t\tSystem.out.println(\"s:\" + s);\n\t\t\t} else {\n\t\t\t\tSystem.out.println(\"b:\" + b);\n\t\t\t}\n\t\t\ts = null;\n\t\t}\n\t}  public static void main(String[] obj) {\n\t\tfoo(100);\n\t\tfoo(\"abcd\");\n\t}\n}\n"}, "----------\n1. ERROR in X12.java (at line 11)\n\ts = null;\n\t^\ns cannot be resolved to a variable\n----------\n", "", null, true, options);
    }

    public void test013() {
        Map<String, String> options = this.getCompilerOptions(true);
        this.runNegativeTest(new String[]{"X13.java", "@SuppressWarnings(\"preview\")\npublic class X13 {\n  \tpublic static void foo(Object b) {\n\t\tObject c = null;\n\t\tif (b != c) {\n\t\t\tif (b == null && (b instanceof String s))\n\t\t\t\tSystem.out.println(\"s:\" + s);\n\t\t\telse \t\t\t\tSystem.out.println(\"b:\" + b);\n\t\t\tSystem.out.println(s);\n\t\t}\n\t}  public static void main(String[] obj) {\n\t\tfoo(100);\n\t\tfoo(\"abcd\");\n\t}\n}\n"}, "----------\n1. ERROR in X13.java (at line 9)\n\tSystem.out.println(s);\n\t                   ^\ns cannot be resolved to a variable\n----------\n", "", null, true, options);
    }

    public void test014() {
        Map<String, String> options = this.getCompilerOptions(true);
        this.runNegativeTest(new String[]{"X14.java", "@SuppressWarnings(\"preview\")\npublic class X14 {\n  \tpublic static void foo(Object o) {\n\t\tif (!(o instanceof String s)) {\n\t\t\tSystem.out.print(\"then:\" + s);\n\t\t} else {\n\t\t\tSystem.out.print(\"else:\" + s);\n\t\t}\n\t}  public static void main(String[] obj) {\n\t\tfoo(\"abcd\");\n\t}\n}\n"}, "----------\n1. ERROR in X14.java (at line 5)\n\tSystem.out.print(\"then:\" + s);\n\t                           ^\ns cannot be resolved to a variable\n----------\n", "", null, true, options);
    }

    public void test014a() {
        Map<String, String> options = this.getCompilerOptions(true);
        this.runNegativeTest(new String[]{"X14a.java", "@SuppressWarnings(\"preview\")\npublic class X14a {\n  \tpublic static void foo(Object o) {\n\t\tif (!(o instanceof String s)) {\n\t\t\tSystem.out.print(\"then:\" + s);\n\t\t} else {\n\t\t\tSystem.out.print(\"else:\" + s);\n\t\t}\n\t}  public static void main(String[] obj) {\n\t\tfoo(\"abcd\");\n\t}\n}\n"}, "----------\n1. ERROR in X14a.java (at line 5)\n\tSystem.out.print(\"then:\" + s);\n\t                           ^\ns cannot be resolved to a variable\n----------\n", "", null, true, options);
    }

    public void test014b() {
        Map<String, String> options = this.getCompilerOptions(true);
        this.runNegativeTest(new String[]{"X14b.java", "@SuppressWarnings(\"preview\")\npublic class X14b {\n  \tpublic static void foo(Object o) {\n\t\tif (!!(o instanceof String s)) {\n\t\t\tSystem.out.print(\"then:\" + s);\n\t\t} else {\n\t\t\tSystem.out.print(\"else:\" + s);\n\t\t}\n\t}  public static void main(String[] obj) {\n\t\tfoo(\"abcd\");\n\t}\n}\n"}, "----------\n1. ERROR in X14b.java (at line 7)\n\tSystem.out.print(\"else:\" + s);\n\t                           ^\ns cannot be resolved to a variable\n----------\n", "", null, true, options);
    }

    public void test014c() {
        Map<String, String> options = this.getCompilerOptions(true);
        this.runNegativeTest(new String[]{"X14c.java", "@SuppressWarnings(\"preview\")\npublic class X14c {\n  \tpublic static void foo(Object o) {\n\t\tif (o == null) {\n\t\t\tSystem.out.print(\"null\");\n\t\t} else if(!(o instanceof String s)) {\n\t\t\tSystem.out.print(\"else:\" + s);\n\t\t}\n\t}  public static void main(String[] obj) {\n\t\tfoo(\"abcd\");\n\t}\n}\n"}, "----------\n1. ERROR in X14c.java (at line 7)\n\tSystem.out.print(\"else:\" + s);\n\t                           ^\ns cannot be resolved to a variable\n----------\n", "", null, true, options);
    }

    public void test014d() {
        Map<String, String> options = this.getCompilerOptions(true);
        this.runConformTest(new String[]{"X14d.java", "@SuppressWarnings(\"preview\")\npublic class X14d {\n  \tpublic static void foo(Object o) {\n\t\tif (o == null) {\n\t\t\tSystem.out.print(\"null\");\n\t\t} else if(!!(o instanceof String s)) {\n\t\t\tSystem.out.print(\"else:\" + s);\n\t\t}\n\t}  public static void main(String[] obj) {\n\t\tfoo(\"abcd\");\n\t}\n}\n"}, "else:abcd", options);
    }

    public void test014e() {
        Map<String, String> options = this.getCompilerOptions(true);
        this.runConformTest(new String[]{"X14a.java", "@SuppressWarnings(\"preview\")\npublic class X14a {\n  \tpublic static void foo(Object o) {\n\t\t if (!(!(o instanceof String s))) {\n\t\t\tSystem.out.print(\"s:\" + s);\n\t\t} else {\n\t\t}\n\t}  public static void main(String[] obj) {\n\t\tfoo(\"abcd\");\n\t}\n}\n"}, "s:abcd", options);
    }

    public void test015() {
        Map<String, String> options = this.getCompilerOptions(true);
        this.runConformTest(new String[]{"X15.java", "@SuppressWarnings(\"preview\")\npublic class X15 {\n  \tpublic static void foo(Object o) {\n\t\tif (!(o instanceof String s)) {\n\t\t\tthrow new IllegalArgumentException();\n\t\t} else {\n\t\t\tSystem.out.print(\"s:\" + s);\n\t\t}\n\t\tSystem.out.print(s);\n\t}  public static void main(String[] obj) {\n\t\tfoo(\"abcd\");\n\t}\n}\n"}, "s:abcdabcd", options);
    }

    public void test015a() {
        Map<String, String> options = this.getCompilerOptions(true);
        this.runConformTest(new String[]{"X15a.java", "@SuppressWarnings(\"preview\")\npublic class X15a {\n  \tpublic static void foo(Object o) {\n\t\tif (!(o instanceof String s)) {\n\t\t\tthrow new IllegalArgumentException();\n\t\t}\n\t\tSystem.out.print(s);\n\t}  public static void main(String[] obj) {\n\t\tfoo(\"abcd\");\n\t}\n}\n"}, "abcd", options);
    }

    public void test015b() {
        Map<String, String> options = this.getCompilerOptions(true);
        this.runNegativeTest(new String[]{"X15b.java", "@SuppressWarnings(\"preview\")\npublic class X15b {\n  \tpublic static void foo(Object o) {\n\t\tif (!(o instanceof String s)) {\n\t\t\t//throw new IllegalArgumentException();\n\t\t} else {\n\t\t\tSystem.out.print(\"s:\" + s);\n\t\t}\n\t\tSystem.out.print(s);\n\t}  public static void main(String[] obj) {\n\t\tfoo(\"abcd\");\n\t}\n}\n"}, "----------\n1. ERROR in X15b.java (at line 9)\n\tSystem.out.print(s);\n\t                 ^\ns cannot be resolved to a variable\n----------\n", "", null, true, options);
    }

    public void test016() {
        Map<String, String> options = this.getCompilerOptions(true);
        this.runConformTest(new String[]{"X16.java", "@SuppressWarnings(\"preview\")\npublic class X16 {\n  \tpublic static void foo(Object o) {\n\t\tboolean b = (o instanceof String[] s && s.length == 1);\n\t\tSystem.out.print(b);\n\t}  public static void main(String[] obj) {\n\t\tfoo(new String[]{\"one\"});\n\t}\n}\n"}, "true", options);
    }

    public void test017() {
        Map<String, String> options = this.getCompilerOptions(true);
        this.runNegativeTest(new String[]{"X17.java", "@SuppressWarnings(\"preview\")\npublic class X17 {\n  \tpublic static void foo(Object o) {\n\t\tboolean b = (o instanceof String[] s && s.length == 1);\n\t\tSystem.out.print(s[0]);\n\t}  public static void main(String[] obj) {\n\t\tfoo(new String[]{\"one\"});\n\t}\n}\n"}, "----------\n1. ERROR in X17.java (at line 5)\n\tSystem.out.print(s[0]);\n\t                 ^\ns cannot be resolved to a variable\n----------\n", "", null, true, options);
    }

    public void test018() {
        Map<String, String> options = this.getCompilerOptions(true);
        this.runConformTest(new String[]{"X18.java", "@SuppressWarnings(\"preview\")\npublic class X18 {\n  public static void main(String[] obj) {\n  \t\tfoo(obj);\n  }\n  public static void foo(Object[] obj) {\n\t\tboolean a = true;\n\t\t{\n\t\t\tboolean b = (obj instanceof String[] s && s.length == 0);\n\t\t\tSystem.out.print(b + \",\");\n\t\t}\n\t\tboolean b = a ? false : (obj instanceof String[] s && s.length == 0);\n\t\tSystem.out.print(b);\n\t}\n}\n"}, "true,false", options);
    }

    public void test019() {
        Map<String, String> options = this.getCompilerOptions(true);
        this.runConformTest(new String[]{"X19.java", "@SuppressWarnings(\"preview\")\npublic class X19 {\n  public static void main(String[] obj) {\n  \t\tfoo(obj);\n  }\n  public static void foo(Object[] obj) {\n\t\tboolean a = true;\n\t\tboolean b = a ? false : (obj instanceof String[] s && s.length == 0);\n\t\tSystem.out.print(b + \",\");\n\t\t{\n\t\t\tb = (obj instanceof String[] s && s.length == 0);\n\t\t\tSystem.out.print(b);\n\t\t}\n\t}\n}\n"}, "false,true", options);
    }

    public void test019b() {
        Map<String, String> options = this.getCompilerOptions(true);
        this.runNegativeTest(new String[]{"X19b.java", "@SuppressWarnings(\"preview\")\npublic class X19b {\n  public static void main(String[] obj) {\n  \t\tfoo(obj);\n  }\n  public static void foo(Object[] obj) {\n\t\tboolean a = true;\n\t\tif (obj instanceof String[] s && s.length == 0) {\n\t\t\tboolean b = (obj instanceof String[] s && s.length == 0);\n\t\t\tSystem.out.print(b);\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in X19b.java (at line 9)\n\tboolean b = (obj instanceof String[] s && s.length == 0);\n\t                                     ^\nA pattern variable with the same name is already defined in the statement\n----------\n", "", null, true, options);
    }

    public void test020() {
        Map<String, String> options = this.getCompilerOptions(true);
        this.runNegativeTest(new String[]{"X20.java", "public class X20 {\n  public static void main(String[] obj) {\n  \t\tfoo(obj);\n  }\n  public static void foo(Object[] o) {\n\t\tboolean b = (o instanceof String[] s) && s instanceof CharSequence[] s2;\n\t\tSystem.out.print(b1);\n\t}\n}\n"}, this.complianceLevel < 0x410000L ? "----------\n1. ERROR in X20.java (at line 6)\n\tboolean b = (o instanceof String[] s) && s instanceof CharSequence[] s2;\n\t                                         ^\nExpression type cannot be a subtype of the Pattern type\n----------\n2. ERROR in X20.java (at line 7)\n\tSystem.out.print(b1);\n\t                 ^^\nb1 cannot be resolved to a variable\n----------\n" : "----------\n1. ERROR in X20.java (at line 7)\n\tSystem.out.print(b1);\n\t                 ^^\nb1 cannot be resolved to a variable\n----------\n", "", null, true, options);
    }

    public void test020a() {
        Map<String, String> options = this.getCompilerOptions(true);
        this.runConformTest(new String[]{"X20.java", "@SuppressWarnings(\"preview\")\npublic class X20 {\n  public static void main(String[] obj) {\n  \t\tfoo(obj);\n  }\n  public static void foo(Object[] o) {\n\t\tboolean b = (o instanceof CharSequence[] s) && s instanceof String[] s2;\n\t\tSystem.out.print(b);\n\t}\n}\n"}, "true", options);
    }

    public void test021() {
        Map<String, String> options = this.getCompilerOptions(true);
        this.runNegativeTest(new String[]{"X21.java", "@SuppressWarnings(\"preview\")\npublic class X21 {\n  public static void main(String[] obj) {\n  \t\tfoo(obj);\n  }\n  public static void foo(Object[] o) {\n\t\tboolean b = (o instanceof CharSequence[] s) && s instanceof String[] s2;\n\t\tSystem.out.print(s);\n\t\tSystem.out.print(s2);\n\t}\n}\n"}, "----------\n1. ERROR in X21.java (at line 8)\n\tSystem.out.print(s);\n\t                 ^\ns cannot be resolved to a variable\n----------\n2. ERROR in X21.java (at line 9)\n\tSystem.out.print(s2);\n\t                 ^^\ns2 cannot be resolved to a variable\n----------\n", "", null, true, options);
    }

    public void test022() {
        Map<String, String> options = this.getCompilerOptions(true);
        this.runConformTest(new String[]{"X22.java", "@SuppressWarnings(\"preview\")\npublic class X22 {\n  public static void main(String[] o) {\n\t\tfoo(\"one\");\n\t}\n  public static void foo(Object o) {\n\t\twhile ((o instanceof String s) && s.length() > 0) {\n\t\t\to = s.substring(0, s.length() - 1);\n\t\t\tSystem.out.println(s);\n\t\t}\n\t}\n}\n"}, "one\non\no", options);
    }

    public void test022a() {
        Map<String, String> options = this.getCompilerOptions(true);
        this.runNegativeTest(new String[]{"X22a.java", "@SuppressWarnings(\"preview\")\npublic class X22a {\n  public static void main(String[] o) {\n\t\tfoo(\"one\");\n\t}\n  public static void foo(Object o) {\n\t\tdo {\n\t\t\to = s.substring(0, s.length() - 1);\n\t\t\tSystem.out.println(s);\n\t\t} while ((o instanceof String s) && s.length() > 0);\n\t}\n}\n"}, "----------\n1. ERROR in X22a.java (at line 8)\n\to = s.substring(0, s.length() - 1);\n\t    ^\ns cannot be resolved\n----------\n2. ERROR in X22a.java (at line 8)\n\to = s.substring(0, s.length() - 1);\n\t                   ^\ns cannot be resolved\n----------\n3. ERROR in X22a.java (at line 9)\n\tSystem.out.println(s);\n\t                   ^\ns cannot be resolved to a variable\n----------\n", null, true, options);
    }

    public void test022b() {
        Map<String, String> options = this.getCompilerOptions(true);
        this.runNegativeTest(new String[]{"X22b.java", "@SuppressWarnings(\"preview\")\npublic class X22b {\n  public static void main(String[] o) {\n\t\tfoo(\"one\");\n\t}\n  public static void foo(Object o) {\n\t\tdo {\n\t\t\t// nothing\n\t\t} while ((o instanceof String s));\n\t\tSystem.out.println(s);\n\t}\n}\n"}, "----------\n1. ERROR in X22b.java (at line 10)\n\tSystem.out.println(s);\n\t                   ^\ns cannot be resolved to a variable\n----------\n", null, true, options);
    }

    public void test022c() {
        Map<String, String> options = this.getCompilerOptions(true);
        this.runConformTest(new String[]{"X22c.java", "@SuppressWarnings(\"preview\")\npublic class X22c {\n  public static void main(String[] o) {\n\t\tfoo(\"one\");\n\t}\n  public static void foo(Object o) {\n\t\tdo {\n\t\t\t// nothing\n\t\t} while (!(o instanceof String s));\n\t\tSystem.out.println(s);\n\t}\n}\n"}, "one", options);
    }

    public void test023() {
        Map<String, String> options = this.getCompilerOptions(true);
        this.runNegativeTest(new String[]{"X23.java", "@SuppressWarnings(\"preview\")\npublic class X23 {\n  public static void main(String[] o) {\n\t\tfoo(\"one\");\n\t}\n  public static void foo(Object o) {\n\t\twhile (!(o instanceof String s) && s.length() > 0) {\n\t\t\tSystem.out.println(s);\n\t\t\tbreak;\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in X23.java (at line 7)\n\twhile (!(o instanceof String s) && s.length() > 0) {\n\t                                   ^\ns cannot be resolved\n----------\n2. ERROR in X23.java (at line 8)\n\tSystem.out.println(s);\n\t                   ^\ns cannot be resolved to a variable\n----------\n", "", null, true, options);
    }

    public void test023a() {
        Map<String, String> options = this.getCompilerOptions(true);
        this.runNegativeTest(new String[]{"X23a.java", "@SuppressWarnings(\"preview\")\npublic class X23a {\n  public static void main(String[] o) {\n\t\tfoo(\"one\");\n\t}\n  public static void foo(Object o) {\n\t\tdo {\n\t\t\tSystem.out.println(s);\n\t\t\tbreak;\n\t\t} while (!(o instanceof String s) && s.length() > 0);\n\t}\n}\n"}, "----------\n1. ERROR in X23a.java (at line 8)\n\tSystem.out.println(s);\n\t                   ^\ns cannot be resolved to a variable\n----------\n2. ERROR in X23a.java (at line 10)\n\t} while (!(o instanceof String s) && s.length() > 0);\n\t                                     ^\ns cannot be resolved\n----------\n", "", null, true, options);
    }

    public void test023b() {
        Map<String, String> options = this.getCompilerOptions(true);
        this.runNegativeTest(new String[]{"X23b.java", "@SuppressWarnings(\"preview\")\npublic class X23b {\n  public static void main(String[] o) {\n\t\tfoo(\"one\");\n\t}\n  public static void foo(Object o) {\n\t\twhile (!(o instanceof String s) && s.length() > 0) {\n\t\t\tSystem.out.println(s);\n\t\t\t//break;\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in X23b.java (at line 7)\n\twhile (!(o instanceof String s) && s.length() > 0) {\n\t                                   ^\ns cannot be resolved\n----------\n2. ERROR in X23b.java (at line 8)\n\tSystem.out.println(s);\n\t                   ^\ns cannot be resolved to a variable\n----------\n", "", null, true, options);
    }

    public void test023c() {
        Map<String, String> options = this.getCompilerOptions(true);
        this.runNegativeTest(new String[]{"X23c.java", "@SuppressWarnings(\"preview\")\npublic class X23c {\n  public static void main(String[] o) {\n\t\tfoo(\"one\");\n\t}\n  public static void foo(Object o) {\n\t\tdo {\n\t\t\tSystem.out.println(s);\n\t\t\t//break;\n\t\t}while (!(o instanceof String s) && s.length() > 0);\n\t}\n}\n"}, "----------\n1. ERROR in X23c.java (at line 8)\n\tSystem.out.println(s);\n\t                   ^\ns cannot be resolved to a variable\n----------\n2. ERROR in X23c.java (at line 10)\n\t}while (!(o instanceof String s) && s.length() > 0);\n\t                                    ^\ns cannot be resolved\n----------\n", "", null, true, options);
    }

    public void test024a() {
        Map<String, String> options = this.getCompilerOptions(true);
        this.runConformTest(new String[]{"X24a.java", "@SuppressWarnings(\"preview\")\npublic class X24a {\n  public static void main(String[] o) {\n\t\tfoo(\"one\");\n\t}\n  public static void foo(Object o) {\n\t\twhile (!(o instanceof String s)) {\n\t\t\tthrow new IllegalArgumentException();\n\t\t}\n\t\tSystem.out.println(s);\n\t}\n}\n"}, "one", options);
    }

    public void test024b() {
        Map<String, String> options = this.getCompilerOptions(true);
        this.runConformTest(new String[]{"X24a.java", "@SuppressWarnings(\"preview\")\npublic class X24a {\n  public static void main(String[] o) {\n\t\tfoo(\"one\");\n\t}\n  public static void foo(Object o) {\n\t\tfor (;!(o instanceof String s);) {\n\t\t\t throw new IllegalArgumentException();\n\t\t}\n\t\tSystem.out.println(s);\n\t}\n}\n"}, "one", options);
    }

    public void test025() {
        Map<String, String> options = this.getCompilerOptions(true);
        this.runNegativeTest(new String[]{"X25.java", "@SuppressWarnings(\"preview\")\npublic class X25 {\n  public static void main(String[] o) {\n\t\tfoo(\"one\", \"two\");\n\t}\n  public static void foo(Object o, Object p) {\n\t\tif ((o instanceof String s) != p instanceof String s) {\n\t\t\tSystem.out.print(\"s:\" + s);\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in X25.java (at line 8)\n\tSystem.out.print(\"s:\" + s);\n\t                        ^\ns cannot be resolved to a variable\n----------\n", "", null, true, options);
    }

    public void test025a() {
        Map<String, String> options = this.getCompilerOptions(true);
        this.runNegativeTest(new String[]{"X25.java", "@SuppressWarnings(\"preview\")\npublic class X25 {\n  public static void main(String[] o) {\n\t\tfoo(\"one\");\n\t}\n  public static void foo(Object o) {\n\t\tif ( (o instanceof String a) || (! (o instanceof String a)) ) {\n\t\t\tSystem.out.print(\"a:\" + a);\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in X25.java (at line 8)\n\tSystem.out.print(\"a:\" + a);\n\t                        ^\na cannot be resolved to a variable\n----------\n", "", null, true, options);
    }

    public void test025b() {
        Map<String, String> options = this.getCompilerOptions(true);
        this.runConformTest(new String[]{"X25.java", "@SuppressWarnings(\"preview\")\npublic class X25 {\n  public static void main(String[] o) {\n\t\tfoo(\"one\");\n\t}\n  public static void foo(Object o) {\n\t\tif ( (o instanceof String a) || (! (o instanceof String a)) ) {\n\t\t\tSystem.out.println(\"none\");\n\t\t} else {\n\t\t\tSystem.out.print(\"a:\" + a);\n\t\t}\n\t}\n}\n"}, "none", options);
    }

    public void test025c() {
        Map<String, String> options = this.getCompilerOptions(true);
        this.runConformTest(new String[]{"X25.java", "@SuppressWarnings(\"preview\")\npublic class X25 {\n  public static void main(String[] o) {\n\t\tfoo(\"one\", new Integer(0));\n\t}\n  public static void foo(Object o, Object p) {\n\t\tif ( (o instanceof String a) || (! (p instanceof String a)) ) {\n\t\t\tSystem.out.println(\"none\");\n\t\t} else {\n\t\t\tSystem.out.print(\"a:\" + a);\n\t\t}\n\t}\n}\n"}, "none", options);
    }

    public void test026() {
        Map<String, String> options = this.getCompilerOptions(true);
        this.runNegativeTest(new String[]{"X26.java", "@SuppressWarnings(\"preview\")\npublic class X26 {\n  public static void main(String[] o) {\n\t\tfoo(\"one\", \"two\");\n\t}\n  public static void foo(Object o, Object p) {\n\t\tif ((o instanceof String s) && (p instanceof String s)) {\n\t\t\tSystem.out.print(\"s:\" + s);\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in X26.java (at line 7)\n\tif ((o instanceof String s) && (p instanceof String s)) {\n\t                                                    ^\nA pattern variable with the same name is already defined in the statement\n----------\n", "", null, true, options);
    }

    public void test026a() {
        Map<String, String> options = this.getCompilerOptions(true);
        this.runNegativeTest(new String[]{"X26.java", "@SuppressWarnings(\"preview\")\npublic class X26 {\n  public static void main(String[] o) {\n\t\tfoo(\"one\", \"two\");\n\t}\n  public static void foo(Object o, Object p) {\n\t\tif ((o instanceof String s) && (!(o instanceof String s))) {\n\t\t\tSystem.out.print(\"s:\" + s);\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in X26.java (at line 7)\n\tif ((o instanceof String s) && (!(o instanceof String s))) {\n\t                                                      ^\nA pattern variable with the same name is already defined in the statement\n----------\n", "", null, true, options);
    }

    public void test026b() {
        Map<String, String> options = this.getCompilerOptions(true);
        this.runNegativeTest(new String[]{"X26.java", "@SuppressWarnings(\"preview\")\npublic class X26 {\n  public static void main(String[] o) {\n\t\tfoo(\"one\", \"two\");\n\t}\n  public static void foo(Object o, Object p) {\n\t\tif ((o instanceof String s) == p instanceof String s) {\n\t\t\tSystem.out.print(\"s:\" + s);\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in X26.java (at line 8)\n\tSystem.out.print(\"s:\" + s);\n\t                        ^\ns cannot be resolved to a variable\n----------\n", "", null, true, options);
    }

    public void test027() {
        this.runConformTest(new String[]{"X27.java", "@SuppressWarnings(\"preview\")\npublic class X27 {\n  public static void main(String[] o) {\n\t\tfoo(\"one\");\n\t}\n  public static void foo(Object obj) {\n\t\tfor(int i = 0; (obj instanceof String[] s && s.length > 0 && i < s.length); i++) {\n\t\t\tSystem.out.println(s[i]);\n\t\t}\n\t}\n}\n"}, "", this.getCompilerOptions(true));
    }

    public void test028() {
        this.runConformTest(new String[]{"X28.java", "@SuppressWarnings(\"preview\")\npublic class X28 {\n  public static void main(String[] o) {\n\t\tfoo(new String[] {\"one\", \"two\"});\n\t}\n  public static void foo(Object obj) {\n\t\tfor(int i = 0; (obj instanceof String[] s && s.length > 0 && i < s.length); i++) {\n\t\t\tSystem.out.println(s[i]);\n\t\t}\n\t}\n}\n"}, "one\ntwo", this.getCompilerOptions(true));
    }

    public void test029() {
        this.runConformTest(new String[]{"X29.java", "@SuppressWarnings(\"preview\")\npublic class X29 {\n  public static void main(String[] o) {\n\t\tfoo(new String[] {\"one\", \"two\"});\n\t}\n  public static void foo(Object obj) {\n\t\tfor(int i = 0; (obj instanceof String[] s) && s.length > 0 && i < s.length; i = (s != null ? i + 1 : i)) {\n\t\t\tSystem.out.println(s[i]);\n\t\t}\n\t}\n}\n"}, "one\ntwo", this.getCompilerOptions(true));
    }

    public void test030() {
        this.runNegativeTest(new String[]{"X30.java", "@SuppressWarnings(\"preview\")\npublic class X30 {\n  public static void main(String[] o) {\n\t\tfoo(\"one\");\n\t}\n  public static void foo(Object obj) {\n\t\tfor(int i = 0, length = (obj instanceof String s) ? s.length() : 0; i < length; i++) {\n\t\t\tSystem.out.print(s.charAt(i));\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in X30.java (at line 8)\n\tSystem.out.print(s.charAt(i));\n\t                 ^\ns cannot be resolved\n----------\n", "", null, true, this.getCompilerOptions(true));
    }

    public void test031() {
        this.runNegativeTest(new String[]{"X31.java", "@SuppressWarnings(\"preview\")\npublic class X31 {\n  public static void main(String[] o) {\n\t\tfoo(\"one\");\n\t}\n  public static void foo(Object obj) {\n\t\tfor(int i = 0; !(obj instanceof String[] s) && s.length > 0 && i < s.length; i++) {\n\t\t\tSystem.out.println(s[i]);\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in X31.java (at line 7)\n\tfor(int i = 0; !(obj instanceof String[] s) && s.length > 0 && i < s.length; i++) {\n\t                                               ^\ns cannot be resolved to a variable\n----------\n2. ERROR in X31.java (at line 7)\n\tfor(int i = 0; !(obj instanceof String[] s) && s.length > 0 && i < s.length; i++) {\n\t                                                                   ^\ns cannot be resolved to a variable\n----------\n3. ERROR in X31.java (at line 8)\n\tSystem.out.println(s[i]);\n\t                   ^\ns cannot be resolved to a variable\n----------\n", "", null, true, this.getCompilerOptions(true));
    }

    public void test032() {
        this.runConformTest(new String[]{"X32.java", "@SuppressWarnings(\"preview\")\npublic class X32 {\n  public static void main(String[] o) {\n\t\tfoo(\"one\");\n\t}\n  public static void foo(Object obj) {\n\t\tString res = null;\n\t\tint i = 0;\n\t\tswitch(i) {\n\t\tcase 0:\n\t\t\tres = (obj instanceof String) ? null : null;\n\t\tdefault:\n\t\t\tbreak;\n\t\t}\n\t\tSystem.out.println(res);\n\t}\n}\n"}, "null", this.getCompilerOptions(false));
    }

    public void test032a() {
        this.runConformTest(new String[]{"X32.java", "@SuppressWarnings(\"preview\")\npublic class X32 {\n  public static void main(String[] o) {\n\t\tfoo(\"one\");\n\t}\n  public static void foo(Object obj) {\n\t\tString res = null;\n\t\tint i = 0;\n\t\tswitch(i) {\n\t\tcase 0:\n\t\t\tres = (obj instanceof String s) ? s : null;\n\t\tdefault:\n\t\t\tbreak;\n\t\t}\n\t\tSystem.out.println(res);\n\t}\n}\n"}, "one", this.getCompilerOptions(false));
    }

    public void test033() {
        this.runNegativeTest(new String[]{"X33.java", "@SuppressWarnings(\"preview\")\npublic class X33 {\n  public static void main(String[] o) {\n\t\tfoo(\"one\");\n\t}\n  public static void foo(Object obj) {\n\t\tString res = null;\n\t\tint i = 0;\n\t\tswitch(i) {\n\t\tcase 0:\n\t\t\tres = (obj instanceof String s) ? s : null;\n\t\t\tres = s.substring(1);\n\t\tdefault:\n\t\t\tbreak;\n\t\t}\n\t\tSystem.out.println(res);\n\t}\n}\n"}, "----------\n1. ERROR in X33.java (at line 12)\n\tres = s.substring(1);\n\t      ^\ns cannot be resolved\n----------\n", "", null, true, this.getCompilerOptions(true));
    }

    public void test034() {
        this.runNegativeTest(new String[]{"X34.java", "@SuppressWarnings(\"preview\")\npublic class X34 {\n  public static void main(String[] o) {\n\t\tfoo(\"one\");\n\t}\n  public static void foo(Object obj) {\n\t\tint i = 0;\n\t\tString result = switch(i) {\n\t\t\tcase 0 -> {\n\t\t\t\tresult = (obj instanceof String s) ? s : null;\n\t\t\t\tyield result;\n\t\t\t}\n\t\t\tdefault -> {\n\t\t\t\tyield result;\n\t\t\t}\n\t\t};\n\t\tSystem.out.println(result);\n\t}\n}\n"}, "----------\n1. ERROR in X34.java (at line 14)\n\tyield result;\n\t      ^^^^^^\nThe local variable result may not have been initialized\n----------\n", "", null, true, this.getCompilerOptions(true));
    }

    public void test035() {
        this.runNegativeTest(new String[]{"X35.java", "@SuppressWarnings(\"preview\")\npublic class X35 {\n  public static void main(String[] o) {\n\t\tfoo(\"one\");\n\t}\n  public static void foo(Object obj) {\n\t\tint i = 0;\n\t\tString result = switch(i) {\n\t\t\tcase 0 -> {\n\t\t\t\tresult = (obj instanceof String s) ? s : null;\n\t\t\t\tyield s;\n\t\t\t}\n\t\t\tdefault -> {\n\t\t\t\tyield s;\n\t\t\t}\n\t\t};\n\t\tSystem.out.println(result);\n\t}\n}\n"}, "----------\n1. ERROR in X35.java (at line 11)\n\tyield s;\n\t      ^\ns cannot be resolved to a variable\n----------\n2. ERROR in X35.java (at line 14)\n\tyield s;\n\t      ^\ns cannot be resolved to a variable\n----------\n", "", null, true, this.getCompilerOptions(false));
    }

    public void test036() {
        this.runConformTest(new String[]{"X36.java", "@SuppressWarnings(\"preview\")\npublic class X36 {\n  public static void main(String[] o) {\n\t\tfoo(\"one\");\n\t}\n  public static void foo(Object obj) {\n\t\tint i = 0;\n\t\tString result = switch(i) {\n\t\t\tdefault -> {\n\t\t\t\tresult = (obj instanceof String s) ? s : null;\n\t\t\t\tyield result;\n\t\t\t}\n\t\t};\n\t\tSystem.out.println(result);\n\t}\n}\n"}, "one", this.getCompilerOptions(false));
    }

    public void test037() {
        this.runNegativeTest(new String[]{"X37.java", "@SuppressWarnings(\"preview\")\npublic class X37 {\n  public static void main(String[] o) {\n\t\tfoo(new String[] {\"abcd\"});\n\t}\n  public static void foo(Object[] obj) {\n\t\tfor(int i = 0; (obj[i] instanceof String s) && s.length() > 0 ; i++) {\n\t\t\tSystem.out.println(s[i]);\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in X37.java (at line 8)\n\tSystem.out.println(s[i]);\n\t                   ^^^^\nThe type of the expression must be an array type but it resolved to String\n----------\n", "", null, true, this.getCompilerOptions(true));
    }

    public void test038() {
        this.runNegativeTest(new String[]{"X38.java", "@SuppressWarnings(\"preview\")\npublic class X38 {\n  public static void main(String[] o) {\n\t\tfoo(new String[] {\"abcd\"});\n\t}\n  public static void foo(Object[] obj) {\n\t\tfor(int i = 0; (obj[i] instanceof String s) && s.length() > 0 ;) {\n\t\t\tthrow new IllegalArgumentException();\n\t\t}\n\t\tSystem.out.println(s);\n\t}\n}\n"}, "----------\n1. ERROR in X38.java (at line 10)\n\tSystem.out.println(s);\n\t                   ^\ns cannot be resolved to a variable\n----------\n", "", null, true, this.getCompilerOptions(true));
    }

    public void test039() {
        this.runConformTest(new String[]{"X39.java", "@SuppressWarnings(\"preview\")\npublic class X39 {\n  public static void main(String[] o) {\n\t\tfoo(new String[] {\"one\"});;\n\t}\n  public static void foo(Object[] obj) {\n\t\tfor(int i = 0; i < obj.length && (obj[i] instanceof String s) && i < s.length(); i++) {\n\t\t\tSystem.out.println(s);\n\t\t}\n\t}\n}\n"}, "one", this.getCompilerOptions(true));
    }

    public void test040() {
        this.runConformTest(new String[]{"X40.java", "@SuppressWarnings(\"preview\")\npublic class X40 {\n\tString a;\n    Object o1 = \"x\";\n    public static void main(String argv[]) {\n        System.out.println(new X40().foo());\n    }\n    public String foo() {\n        String res = \"\";\n    \t Object o2 = \"x\";\n        if (o1 instanceof String s) { \n            res = \"then_\" + s;\n        } else {\n            res = \"else_\";\n        }\n        return res;\n    }\n}\n"}, "then_x", this.getCompilerOptions(true));
    }

    public void test041() {
        this.runConformTest(new String[]{"X41.java", "@SuppressWarnings(\"preview\")\npublic class X41 {\n\tString a;\n    Object o1 = \"x\";\n    public static void main(String argv[]) {\n        System.out.println(new X41().foo());\n    }\n    public String foo() {\n        String res = \"\";\n        Object o2 = \"x\";\n        if ( !(o1 instanceof String s) || !o1.equals(s) ) { \n            res = \"then_\";\n        } else {\n            res = \"else_\" + s;\n        }\n        return res;\n    }\n}\n"}, "else_x", this.getCompilerOptions(true));
    }

    public void test042() {
        this.runConformTest(new String[]{"X42.java", "@SuppressWarnings(\"preview\")\npublic class X42 {\n\t String a;\n    Object o1 = \"x\";\n    public static void main(String argv[]) {\n        System.out.println(new X42().foo());\n    }\n    public String foo() {\n        String res = \"\";\n        Object o2 = o1;\n        if ( !(o1 instanceof String s) || !o1.equals(s) ) { \n            res = \"then_\";\n        } else {\n            res = \"else_\" + s;\n        }\n        return res;\n    }\n}\n"}, "else_x", this.getCompilerOptions(true));
    }

    public void test043() {
        this.runConformTest(new String[]{"X43.java", "@SuppressWarnings(\"preview\")\npublic class X43 {\n\t public static void main(String argv[]) {\n\t\tSystem.out.println(new X43().foo(\"foo\", \"test\"));\n\t}\n\tpublic boolean foo(Object obj, String s) {\n\t\tclass Inner {\n\t\t\tpublic boolean foo(Object obj) {\n\t\t\t\tif (obj instanceof String s) {\n\t\t\t\t\t// s is shadowed now\n\t\t\t\t\tif (!\"foo\".equals(s))\n\t\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t\t// s is not shadowed\n\t\t\t\treturn \"test\".equals(s);\n\t\t\t}\n\t\t}\n\t\treturn new Inner().foo(obj);\n\t}\n}\n"}, "true", this.getCompilerOptions(true));
    }

    public void test044() {
        Map<String, String> compilerOptions = this.getCompilerOptions(true);
        String old = compilerOptions.get("org.eclipse.jdt.core.compiler.codegen.unusedLocal");
        compilerOptions.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", "optimize out");
        this.runConformTest(new String[]{"X44.java", "@SuppressWarnings(\"preview\")\nclass Inner<T> {\n    public boolean foo(Object obj) {\n        if (obj instanceof Inner<?> p) {\n            return true;\n        }\n        return false;\n    }\n} \npublic class X44  {\n    public static void main(String argv[]) {\n    \tInner<String> param = new Inner<>();\n    \tSystem.out.println(new Inner<String>().foo(param));\n    }\n}\n"}, "true", compilerOptions);
        compilerOptions.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", old);
    }

    public void test045() {
        Map<String, String> compilerOptions = this.getCompilerOptions(true);
        String old = compilerOptions.get("org.eclipse.jdt.core.compiler.codegen.unusedLocal");
        compilerOptions.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", "optimize out");
        this.runConformTest(new String[]{"X45.java", "@SuppressWarnings(\"preview\")\npublic class X45 {\n    Object s = \"test\";\n    boolean result = s instanceof String s1;\n\t public static void main(String argv[]) {\n    \tSystem.out.println(\"true\");\n    }\n}\n"}, "true", compilerOptions);
        compilerOptions.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", old);
    }

    public void test046() {
        Map<String, String> compilerOptions = this.getCompilerOptions(true);
        String old = compilerOptions.get("org.eclipse.jdt.core.compiler.codegen.unusedLocal");
        compilerOptions.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", "optimize out");
        this.runConformTest(new String[]{"X46.java", "@SuppressWarnings(\"preview\")\npublic class X46 {\n    Object s = \"test\";\n    boolean result = (s instanceof String s1 && s1 != null);\n\t public static void main(String argv[]) {\n    \tSystem.out.println(\"true\");\n    }\n}\n"}, "true", compilerOptions);
        compilerOptions.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", old);
    }

    public void test047() {
        Map<String, String> compilerOptions = this.getCompilerOptions(true);
        String old = compilerOptions.get("org.eclipse.jdt.core.compiler.codegen.unusedLocal");
        compilerOptions.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", "optimize out");
        this.runConformTest(new String[]{"InstanceOfPatternTest.java", "public class InstanceOfPatternTest {\n\tpublic static void main(String[] args) {\n\t\tif (getChars() instanceof String s) {\n\t\t\tSystem.out.println(s);\n\t\t}\n\t}\n\tstatic CharSequence getChars() {\n\t\treturn \"xyz\";\n\t}\n}\n"}, "xyz", compilerOptions);
        compilerOptions.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", old);
    }

    public void test048() {
        Map<String, String> compilerOptions = this.getCompilerOptions(true);
        String old = compilerOptions.get("org.eclipse.jdt.core.compiler.codegen.unusedLocal");
        compilerOptions.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", "optimize out");
        this.runConformTest(new String[]{"InstanceOfPatternTest.java", "public class InstanceOfPatternTest {\n\tpublic static void main(String[] args) {\n\t\tif (getChars() instanceof String s) {\n\t\t\tSystem.out.println(s);\n\t\t}\n\t}\n\tstatic CharSequence getChars() {\n\t\treturn \"xyz\";\n\t}\n}\n"}, "xyz", compilerOptions);
        compilerOptions.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", old);
    }

    public void test049() {
        Map<String, String> compilerOptions = this.getCompilerOptions(true);
        String old = compilerOptions.get("org.eclipse.jdt.core.compiler.codegen.unusedLocal");
        compilerOptions.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", "optimize out");
        this.runConformTest(new String[]{"InstanceOfPatternTest.java", "public class InstanceOfPatternTest {\n\tpublic static void main(String[] args) {\n\t\tif ( ((CharSequence) getChars()) instanceof String s) {\n\t\t\tSystem.out.println(s);\n\t\t}\n\t}\n\tstatic Object getChars() {\n\t\treturn \"xyz\";\n\t}\n}\n"}, "xyz", compilerOptions);
        compilerOptions.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", old);
    }

    public void test050() {
        Map<String, String> compilerOptions = this.getCompilerOptions(true);
        String old = compilerOptions.get("org.eclipse.jdt.core.compiler.codegen.unusedLocal");
        compilerOptions.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", "optimize out");
        this.runNegativeTest(new String[]{"InstanceOfPatternTest.java", "@SuppressWarnings(\"preview\")\npublic class InstanceOfPatternTest {\n\tpublic static void main(String[] args) {\n\t\tif ( ((s) -> {return s;}) instanceof I s) {\n\t\t\tSystem.out.println(s);\n\t\t}\n\t}\n} \ninterface I {\n\tpublic String foo(String s);\n}\n"}, "----------\n1. ERROR in InstanceOfPatternTest.java (at line 4)\n\tif ( ((s) -> {return s;}) instanceof I s) {\n\t     ^^^^^^^\nThe target type of this expression must be a functional interface\n----------\n", "", null, true, compilerOptions);
        compilerOptions.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", old);
    }

    public void test051() {
        Map<String, String> compilerOptions = this.getCompilerOptions(true);
        String old = compilerOptions.get("org.eclipse.jdt.core.compiler.codegen.unusedLocal");
        compilerOptions.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", "optimize out");
        this.runConformTest(new String[]{"InstanceOfPatternTest.java", "public class InstanceOfPatternTest {\n\tstatic String STR = \"2\";\n\tpublic static void main(String[] args) {\n\t\tif ( switch(STR) {\n\t\t\t\tcase \"1\" -> (CharSequence) \"one\";\n\t\t\t\tdefault -> (CharSequence) \"Unknown\";\n\t\t\t  } \n\t\t\t\tinstanceof String s) {\n\t\t\tSystem.out.println(s);\n\t\t}\n\t}\n}\n"}, "Unknown", compilerOptions);
        compilerOptions.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", old);
    }

    public void test052() {
        Map<String, String> compilerOptions = this.getCompilerOptions(false);
        String old = compilerOptions.get("org.eclipse.jdt.core.compiler.codegen.unusedLocal");
        compilerOptions.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", "optimize out");
        this.runConformTest(new String[]{"X.java", "public class X {\n\t@SuppressWarnings(\"preview\")\n\tpublic static void main(String args[]) {\n\t\tString result = null;\n\t\tObject obj = \"abc\";\n\t\tint i = switch (0) {\n\t\t\tcase 1 -> {\n\t\t\t\tyield 1;\n\t\t\t}\n\t\t\tdefault -> {\n\t\t\t\tfor (int j = 0; !(obj instanceof String s);) {\n\t\t\t\t\tobj = null;\n\t\t\t\t}\n\t\t\t\tresult = s;\n\t\t\t\tSystem.out.println(result);\n\t\t\t\tyield 2;\n\t\t\t}\n\t\t};\n\t\tSystem.out.println(i);\n\t}\n}\n"}, "abc\n2", compilerOptions);
        compilerOptions.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", old);
    }

    public void testBug562392a() {
        Map<String, String> compilerOptions = this.getCompilerOptions(true);
        this.runConformTest(new String[]{"X.java", "public class X<T> {\n\tpublic boolean foo(T obj) {\n\t\tif (obj instanceof String s) {\n\t\t\tSystem.out.println(s);\n\t\t}\n\t\treturn true;\n\t}\n\tpublic static void main(String argv[]) {\n\t\tString s = \"x\";\n\t\tSystem.out.println(new X<Object>().foo(s));\n\t}\n}\n"}, "x\ntrue", compilerOptions);
    }

    public void testBug562392b() {
        Map<String, String> compilerOptions = this.getCompilerOptions(true);
        this.runNegativeTest(new String[]{"X.java", "@SuppressWarnings(\"preview\")\npublic class X<T> {\n\tpublic boolean foo(Object obj) {\n        if (obj instanceof T) {\n            return false;\n        }\n        return true;\n    }\n\tpublic static void main(String argv[]) {\n\t\tSystem.out.println(\"\");\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tif (obj instanceof T) {\n\t    ^^^\nType Object cannot be safely cast to T\n----------\n", "X.java:4: error: Object cannot be safely cast to T\n        if (obj instanceof T) {\n            ^\n  where T is a type-variable:\n    T extends Object declared in class X", null, true, compilerOptions);
    }

    public void testBug562392c() {
        Map<String, String> compilerOptions = this.getCompilerOptions(true);
        this.runNegativeTest(new String[]{"X.java", "@SuppressWarnings(\"preview\")\npublic class X<T> {\n\tpublic boolean foo(Object obj) {\n        if (obj instanceof T t) {\n            return false;\n        }\n        return true;\n    }\n\tpublic static void main(String argv[]) {\n\t\tSystem.out.println(\"\");\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tif (obj instanceof T t) {\n\t    ^^^^^^^^^^^^^^^^^^\nType Object cannot be safely cast to T\n----------\n", "X.java:4: error: Object cannot be safely cast to T\n        if (obj instanceof T t) {\n            ^\n  where T is a type-variable:\n    T extends Object declared in class X", null, true, compilerOptions);
    }

    public void testBug562392d() {
        Map<String, String> compilerOptions = this.getCompilerOptions(true);
        this.runNegativeTest(new String[]{"X.java", "@SuppressWarnings(\"preview\")\npublic class X<T> {\n\tpublic boolean foo(Object obj) {\n        if (null instanceof T t) {\n            return false;\n        }\n        return true;\n    }\n\tpublic static void main(String argv[]) {\n\t\tSystem.out.println(abc);\n\t}\n}\n"}, this.complianceLevel < 0x410000L ? "----------\n1. ERROR in X.java (at line 4)\n\tif (null instanceof T t) {\n\t    ^^^^\nExpression type cannot be a subtype of the Pattern type\n----------\n2. ERROR in X.java (at line 10)\n\tSystem.out.println(abc);\n\t                   ^^^\nabc cannot be resolved to a variable\n----------\n" : "----------\n1. ERROR in X.java (at line 10)\n\tSystem.out.println(abc);\n\t                   ^^^\nabc cannot be resolved to a variable\n----------\n", "", null, true, compilerOptions);
    }

    public void testBug562392e() {
        Map<String, String> compilerOptions = this.getCompilerOptions(true);
        this.runNegativeTest(new String[]{"X.java", "@SuppressWarnings(\"preview\")\npublic class X<T> {\n\tpublic boolean foo(X<?> obj) {\n        if (obj instanceof X<String> p) {\n            return true;\n        }\n        return false;\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tif (obj instanceof X<String> p) {\n\t    ^^^^^^^^^^^^^^^^^^^^^^^^^^\nType X<capture#1-of ?> cannot be safely cast to X<String>\n----------\n", "", null, true, compilerOptions);
    }

    public void testBug562392f() {
        Map<String, String> compilerOptions = this.getCompilerOptions(true);
        this.runNegativeTest(new String[]{"X.java", "class Outer<T> {\n    static class Inner<T> {\n    }\n}\n@SuppressWarnings({\"preview\", \"rawtypes\"})\nclass X<T> {\n    public boolean foo(Outer.Inner obj) {\n        if (obj instanceof Outer<?> p) {\n            return true;\n        }\n        return false;\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\tif (obj instanceof Outer<?> p) {\n\t    ^^^^^^^^^^^^^^^^^^^^^^^^^\nIncompatible conditional operand types Outer.Inner and Outer<?>\n----------\n", "", null, true, compilerOptions);
    }

    public void testBug562392g() {
        Map<String, String> compilerOptions = this.getCompilerOptions(true);
        this.runConformTest(new String[]{"X.java", "class Outer<T> {\n    static class Inner<T> {\n    }\n}\n@SuppressWarnings({\"preview\", \"rawtypes\"})\nclass X<T> {\n    public boolean foo(Object obj) {\n        if (obj instanceof Outer.Inner<?> p) {\n            return true;\n        }\n        return false;\n    }\n\tpublic static void main(String argv[]) {\n\t\tOuter.Inner inn = new Outer.Inner();\n    \tSystem.out.println(new X<String>().foo(inn));\n\t}\n}\n"}, "true", compilerOptions);
    }

    public void testBug562392h() {
        Map<String, String> compilerOptions = this.getCompilerOptions(true);
        this.runNegativeTest(new String[]{"X.java", "@SuppressWarnings({\"rawtypes\"})\nclass Y extends X {}\n@SuppressWarnings({\"rawtypes\"})\npublic class X<T> {\n\tpublic boolean foo(X[] obj) {\n        if (obj instanceof Y[] p) {\n            return true;\n        }\n        return false;\n    }\n\tpublic static void main(String argv[]) {\n\t\tObject[] param = {new X()};\n       System.out.println(new X<String>().foo(param));\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 13)\n\tSystem.out.println(new X<String>().foo(param));\n\t                                   ^^^\nThe method foo(X[]) in the type X<String> is not applicable for the arguments (Object[])\n----------\n", "", null, true, compilerOptions);
    }

    public void testBug562392i() {
        Map<String, String> options = this.getCompilerOptions(false);
        options.put("org.eclipse.jdt.core.compiler.compliance", "15");
        options.put("org.eclipse.jdt.core.compiler.source", "15");
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "15");
        this.runNegativeTest(new String[]{"Test.java", "import java.util.ArrayList;\nimport java.util.List;\nimport java.util.function.Function;\nimport java.util.function.UnaryOperator;\n@SuppressWarnings({\"preview\"})\npublic class Test<T> {\n    public boolean foo(Function<ArrayList<T>, ArrayList<T>> obj) {\n        if (obj instanceof UnaryOperator<? extends List<T>>) {\n            return false;\n        }\n        return true;\n    }\n}\n"}, "----------\n1. ERROR in Test.java (at line 8)\n\tif (obj instanceof UnaryOperator<? extends List<T>>) {\n\t    ^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nCannot perform instanceof check against parameterized type UnaryOperator<? extends List<T>>. Use the form UnaryOperator<?> instead since further generic type information will be erased at runtime\n----------\n", "", null, true, options);
        options.put("org.eclipse.jdt.core.compiler.compliance", "16");
        options.put("org.eclipse.jdt.core.compiler.source", "16");
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "16");
    }

    public void testBug562392j() {
        Map<String, String> compilerOptions = this.getCompilerOptions(true);
        this.runConformTest(new String[]{"Test.java", "import java.util.ArrayList;\nimport java.util.List;\nimport java.util.function.Function;\nimport java.util.function.UnaryOperator;\n@SuppressWarnings({\"preview\", \"rawtypes\"})\npublic class Test<T> {\n    public boolean foo(Function<ArrayList<T>, ArrayList<T>> obj) {\n        if (obj instanceof UnaryOperator<? extends List<T>>) {\n            return false;\n        }\n        return true;\n    }\n\tpublic static void main(String argv[]) {\n       System.out.println(\"\");\n\t}\n}\n"}, "", compilerOptions);
    }

    public void test053() {
        Map<String, String> compilerOptions = this.getCompilerOptions(true);
        this.runConformTest(new String[]{"X.java", "public class X {\n\t@SuppressWarnings(\"preview\")\n\tpublic static void main(String argv[]) {\n\t\tObject obj = \"x\";\n\t\tif (obj instanceof String s) {\n\t\t\tSystem.out.println(s);\n\t\t}\n\t\tString s = \"y\";\n\t\tSystem.out.println(s);\n\t}\n}\n"}, "x\ny", compilerOptions);
    }

    public void test054() {
        Map<String, String> compilerOptions = this.getCompilerOptions(true);
        this.runConformTest(new String[]{"X.java", "public class X {\n\t@SuppressWarnings(\"preview\")\n\tpublic static void main(String argv[]) {\n\t\tObject obj = \"x\";\n\t\twhile (!(obj instanceof String s)) {\n\t\t\tString s = \"y\";\n\t\t\tSystem.out.println(s);\n\t\t}\n\t\tSystem.out.println(s);\n\t}\n}\n"}, "x", compilerOptions);
    }

    public void test055() {
        Map<String, String> compilerOptions = this.getCompilerOptions(true);
        this.runConformTest(new String[]{"X.java", "public class X {\npublic static void main(String argv[]) {\n\t\tString result = \"\";\n\t\tObject obj = \"abc\";\n\t\tfor (; !(obj instanceof String a);) {\n\t\t\tString a = \"\";\n\t\t\tresult = a;\n\t\t\tobj = null;\n\t\t}\n\t\tif (!result.equals(\"abc\")) {\n\t\t\tSystem.out.println(\"PASS\");\n\t\t} else {\n\t\t\tSystem.out.println(\"FAIL\");\n\t\t}\n\t}\n}\n"}, "PASS", compilerOptions);
    }

    public void test056() {
        Map<String, String> compilerOptions = this.getCompilerOptions(true);
        this.runConformTest(new String[]{"X.java", "@SuppressWarnings(\"preview\")\npublic class X {\n\tpublic static int impl(I a) {\n\t\treturn a.foo(\"Default\");\n\t}\n\tpublic static void main(String argv[]) {\n\t\tString result = \"\";\n\t\tObject obj = \"a\";\n\t\tfor (int i = 0; !(obj instanceof String a); i = impl(a -> a.length())) {\n\t\t\tobj = null;\n\t\t}\n\t\tif (!result.equals(\"\"))\n\t\t\tSystem.out.println(\"FAIL\");\n\t\telse\n\t\t\tSystem.out.println(\"PASS\");\n\t}\n}\ninterface I {\n\tint foo(String s);\n}\n"}, "PASS", compilerOptions);
    }

    public void test056a() {
        Map<String, String> compilerOptions = this.getCompilerOptions(true);
        this.runConformTest(new String[]{"X.java", "@SuppressWarnings(\"preview\")\npublic class X {\n\tpublic static int impl(I a) {\n\t\treturn a.foo(\"Default\");\n\t}\n\tpublic static void main(String argv[]) {\n\t\tString result = \"\";\n\t\tObject obj = \"a\";\n\t\tfor (int i = 0; !(obj instanceof String a); i = impl(x -> {\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tString a = \"\";\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\treturn a.length();\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t})) {\n\t\t\tobj = null;\n\t\t}\n\t\tif (!result.equals(\"\"))\n\t\t\tSystem.out.println(\"FAIL\");\n\t\telse\n\t\t\tSystem.out.println(\"PASS\");\n\t}\n}\ninterface I {\n\tint foo(String s);\n}\n"}, "PASS", compilerOptions);
    }

    public void test056b() {
        Map<String, String> compilerOptions = this.getCompilerOptions(true);
        this.runConformTest(new String[]{"X.java", "@SuppressWarnings(\"preview\")\npublic class X {\n\tpublic static int impl(I a) {\n\t\treturn a.foo(\"Default\");\n\t}\n\tpublic static void main(String argv[]) {\n\t\tString result = \"\";\n\t\tObject obj = \"a\";\n\t\tif (!(obj instanceof String a)) {\n\t\t\t  int i = impl(a -> a.length());\n\t\t}\n\t\tif (!result.equals(\"\"))\n\t\t\tSystem.out.println(\"FAIL\");\n\t\telse\n\t\t\tSystem.out.println(\"PASS\");\n\t}\n}\ninterface I {\n\tint foo(String s);\n}\n"}, "PASS", compilerOptions);
    }

    public void test056d() {
        Map<String, String> compilerOptions = this.getCompilerOptions(true);
        this.runNegativeTest(new String[]{"X.java", "@SuppressWarnings(\"preview\")\npublic class X {\n\tpublic static int impl(I a) {\n\t\treturn a.foo(\"Default\");\n\t}\n\tpublic static void main(String argv[]) {\n\t\tString result = \"\";\n\t\tObject obj = \"a\";\n\t\tfor (int i = 0; (obj instanceof String a); i = impl(a -> a.length())) {\n\t\t\tobj = null;\n\t\t}\n\t\tif (!result.equals(\"\"))\n\t\t\tSystem.out.println(\"FAIL\");\n\t\telse\n\t\t\tSystem.out.println(\"PASS\");\n\t}\n}\ninterface I {\n\tint foo(String s);\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\tfor (int i = 0; (obj instanceof String a); i = impl(a -> a.length())) {\n\t                                                    ^\nLambda expression's parameter a cannot redeclare another local variable defined in an enclosing scope. \n----------\n", "", null, true, compilerOptions);
    }

    public void test057() {
        Map<String, String> compilerOptions = this.getCompilerOptions(true);
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t@SuppressWarnings(\"preview\")\n\tpublic static void main(String argv[]) {\n\t\tObject obj = \"x\";\n\t\tif (obj instanceof String s) {\n\t\t\tString s = \"\";\n\t\t\tSystem.out.println(s);\n\t\t}\n\t\tString s = \"y\";\n\t\tSystem.out.println(s);\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tString s = \"\";\n\t       ^\nA pattern variable with the same name is already defined in the statement\n----------\n", "", null, true, compilerOptions);
    }

    public void test058() {
        Map<String, String> compilerOptions = this.getCompilerOptions(true);
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t@SuppressWarnings(\"preview\")\n\tpublic static void main(String[] s) {\n\t\tObject obj = \"x\";\n\t\tif (obj instanceof String[] s && s.length > 0) {\n\t\t\tSystem.out.println(s[0]);\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tif (obj instanceof String[] s && s.length > 0) {\n\t                            ^\nDuplicate local variable s\n----------\n", "", null, true, compilerOptions);
    }

    public void test059() {
        Map<String, String> compilerOptions = this.getCompilerOptions(true);
        this.runConformTest(new String[]{"X.java", "public class X {\n static int count;\n public static void main(String[] args) {\n   int i = 10;\n   if (foo() instanceof String s) {\n     ++i;\n   }\n   System.out.println(\"count:\"+X.count+\" i:\"+i);\n }\n public static Object foo() {\n   ++X.count;\n   return new Object();\n }  \n}"}, "count:1 i:10", compilerOptions);
    }

    public void test060() {
        Map<String, String> compilerOptions = this.getCompilerOptions(true);
        this.runConformTest(new String[]{"X.java", "public class X {\n static int count;\n public static void main(String[] args) {\n   int i = 10;\n   if (foo() instanceof String s) {\n     ++i;\n   }\n   System.out.println(\"count:\"+X.count+\" i:\"+i);\n }\n public static Object foo() {\n   ++X.count;\n   return new String(\"hello\");\n }  \n}"}, "count:1 i:11", compilerOptions);
    }

    public void test061() {
        Map<String, String> compilerOptions = this.getCompilerOptions(true);
        this.runConformTest(new String[]{"X.java", "public class X {\n static int count;\n static String STR = \"FAIL\";\n @SuppressWarnings(\"preview\")\n public static void main(String[] args) {\n   if ( switch(STR) {\n       default -> (CharSequence)\"PASS\";\n       } instanceof String s) {\n     System.out.println(s);\n   }\n }\n}"}, "PASS", compilerOptions);
    }

    public void test062() {
        Map<String, String> compilerOptions = this.getCompilerOptions(true);
        this.runNegativeTest(new String[]{"X.java", "public class X {\n @SuppressWarnings(\"preview\")\n public void foo(Object o) {\n   int len  = (o instanceof String p) ? test(p -> p.length()) : test(p -> p.length());\n }\n  public int test(FI fi) {\n\t  return fi.length(\"\");\n  } \n  interface FI {\n\t  public int length(String str);\n  }}"}, "----------\n1. ERROR in X.java (at line 4)\n\tint len  = (o instanceof String p) ? test(p -> p.length()) : test(p -> p.length());\n\t                                          ^\nLambda expression's parameter p cannot redeclare another local variable defined in an enclosing scope. \n----------\n", "", null, true, compilerOptions);
    }

    public void test063() {
        Map<String, String> compilerOptions = this.getCompilerOptions(true);
        this.runNegativeTest(new String[]{"X.java", "public class X {\n @SuppressWarnings(\"preview\")\n public void foo(Object o) {\n   int len  = !(o instanceof String p) ? test(p -> p.length()) : test(p -> p.length());\n }\n  public int test(FI fi) {\n\t  return fi.length(\"\");\n  } \n  interface FI {\n\t  public int length(String str);\n  }}"}, "----------\n1. ERROR in X.java (at line 4)\n\tint len  = !(o instanceof String p) ? test(p -> p.length()) : test(p -> p.length());\n\t                                                                   ^\nLambda expression's parameter p cannot redeclare another local variable defined in an enclosing scope. \n----------\n", "", null, true, compilerOptions);
    }

    public void test063a() {
        Map<String, String> compilerOptions = this.getCompilerOptions(true);
        this.runNegativeTest(new String[]{"X.java", "public class X {\n @SuppressWarnings(\"preview\")\n public void foo(Object o) {\n   int len  = (o instanceof String p) ? test(p1 -> p.length()) : test(p2 -> p.length());\n }\n  public int test(FI fi) {\n\t  return fi.length(\"\");\n  } \n  interface FI {\n\t  public int length(String str);\n  }}"}, "----------\n1. ERROR in X.java (at line 4)\n\tint len  = (o instanceof String p) ? test(p1 -> p.length()) : test(p2 -> p.length());\n\t                                                                         ^\np cannot be resolved\n----------\n", "", null, true, compilerOptions);
    }

    public void test063b() {
        Map<String, String> compilerOptions = this.getCompilerOptions(true);
        this.runNegativeTest(new String[]{"X.java", "public class X {\n @SuppressWarnings(\"preview\")\n public void foo(Object o) {\n\t\tint len = (o instanceof String p) ? test(new X.FI() {\n\t\t\t@Override\n\t\t\tpublic int length(String p1) {\n\t\t\t\treturn p.length();\n\t\t\t}\n\t\t}) : test(new X.FI() {\n\t\t\t@Override\n\t\t\tpublic int length(String p2) {\n\t\t\t\treturn p.length();\n\t\t\t}\n\t\t});\n\t}\n\tpublic int test(FI fi) {\n\t\treturn fi.length(\"\");\n\t}\n\tinterface FI {\n\t\tpublic int length(String str);\n\t}}"}, "----------\n1. ERROR in X.java (at line 12)\n\treturn p.length();\n\t       ^\np cannot be resolved\n----------\n", "", null, true, compilerOptions);
    }

    public void test063c() {
        Map<String, String> compilerOptions = this.getCompilerOptions(true);
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String argv[]) {\n\t\tSystem.out.println(new X().foo(\"test\"));\n\t}\n @SuppressWarnings(\"preview\")\n public int foo(Object o) {\n\t\tint len = (o instanceof String p) ? test(new X.FI() {\n\t\t\tString s = p; // allowed\n\t\t\t@Override\n\t\t\tpublic int length(String p) {\n\t\t\t\treturn p.length();\n\t\t\t}\n\t\t}) : test(new X.FI() {\n\t\t\t@Override\n\t\t\tpublic int length(String p) {\n\t\t\t\treturn p.length();\n\t\t\t}\n\t\t});\n\t\treturn len;\n\t}\n\tpublic int test(FI fi) {\n\t\treturn fi.length(\"fi\");\n\t}\n\tinterface FI {\n\t\tpublic int length(String str);\n\t}}"}, "2", compilerOptions);
    }

    public void test064() {
        Map<String, String> compilerOptions = this.getCompilerOptions(true);
        this.runConformTest(new String[]{"X.java", "@SuppressWarnings(\"preview\")\npublic class X {\n \tpublic static void main(String argv[]) {\n\t\tSystem.out.println(new X().foo(\"foo\", \"test\"));\n\t}\n\tpublic boolean foo(Object obj, String s) {\n\t\tclass Inner {\n\t\t\tpublic boolean foo(Object obj) {\n\t\t\t\tif (obj instanceof String s) {\n\t\t\t\t\t// s is shadowed now\n\t\t\t\t\tif (\"foo\".equals(s))\n\t\t\t\t\t\treturn false;\n\t\t\t\t} else if (obj instanceof String s) { \n\t\t\t\t}\n\t\t\t\t// s is not shadowed\n\t\t\t\treturn \"test\".equals(s);\n\t\t\t}\n\t\t}\n\t\treturn new Inner().foo(obj);\n\t}}"}, "false", compilerOptions);
    }

    public void test065() {
        Map<String, String> compilerOptions = this.getCompilerOptions(true);
        this.runConformTest(new String[]{"X.java", "@SuppressWarnings(\"preview\")\npublic class X {\n \tpublic static void main(String argv[]) {\n\t\tnew X().foo(\"foo\");\n\t}\n\tpublic void foo(Object o) {\n\t\tif ((o instanceof String s)) {\n\t\t\tSystem.out.println(\"if:\" + s);\n\t\t} else {\n\t\t\tthrow new IllegalArgumentException();\n\t\t}\n\t\tSystem.out.println(\"after:\" + s);\n\t}}"}, "if:foo\nafter:foo", compilerOptions);
    }

    public void test066() {
        Map<String, String> compilerOptions = this.getCompilerOptions(true);
        this.runConformTest(new String[]{"X.java", "@SuppressWarnings(\"preview\")\npublic class X {\n    protected Object x = \"FIELD X\";\n    public void f(Object obj, boolean b) {\n        if ((x instanceof String x)) {\n            System.out.println(x.toLowerCase());\n        }\n    }\n\tpublic static void main(String[] args) {\n\t\tnew X().f(Integer.parseInt(\"1\"), false);\n\t}\n}"}, "field x", compilerOptions);
    }

    public void test067() {
        Map<String, String> compilerOptions = this.getCompilerOptions(true);
        this.runConformTest(new String[]{"X.java", "@SuppressWarnings(\"preview\")\npublic class X {\n    protected Object x = \"FIELD X\";\n    public void f(Object obj, boolean b) {\n        if ((x instanceof String x) && x.length() > 0) {\n            System.out.println(x.toLowerCase());\n        }\n    }\n\tpublic static void main(String[] args) {\n\t\tnew X().f(Integer.parseInt(\"1\"), false);\n\t}\n}"}, "field x", compilerOptions);
    }

    public void test068() {
        Map<String, String> compilerOptions = this.getCompilerOptions(true);
        this.runConformTest(new String[]{"X.java", "@SuppressWarnings(\"preview\")\npublic class X {\n    static void foo(Object o) {\n\t\tif (o instanceof X x || o instanceof X) {\n            System.out.println(\"X\");\n\t\t}\n\t}\n\tpublic static void main(String[] args) {\n\t\tfoo(new X());\n\t}\n}"}, "X", compilerOptions);
    }

    public void test069() {
        Map<String, String> compilerOptions = this.getCompilerOptions(true);
        this.runNegativeTest(new String[]{"X.java", "@SuppressWarnings(\"preview\")\nclass XPlus extends X {}\npublic class X {\n    static void foo(Object o) {\n\t\tif (o instanceof X x && x instanceof XPlus x) {\n            System.out.println(\"X\");\n\t\t}\n\t}\n\tpublic static void main(String[] args) {\n\t\tfoo(new X());\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 5)\n\tif (o instanceof X x && x instanceof XPlus x) {\n\t                                           ^\nA pattern variable with the same name is already defined in the statement\n----------\n", null, true, compilerOptions);
    }

    public void test070() {
        this.runNegativeTest(new String[]{"X.java", "@SuppressWarnings(\"preview\")\npublic class X {\n    static void foo(Object o) {\n\t\tif (o instanceof X x || o instanceof X x) {\n            System.out.println(\"X\");\n\t\t}\n\t}\n\tpublic static void main(String[] args) {\n\t\tfoo(new X());\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 4)\r\n\tif (o instanceof X x || o instanceof X x) {\r\n\t                                       ^\nA pattern variable with the same name is already defined in the statement\n----------\n");
    }

    public void test071() {
        Map<String, String> compilerOptions = this.getCompilerOptions(true);
        this.runNegativeTest(new String[]{"X.java", "@SuppressWarnings(\"preview\")\npublic class X {\n    static void foo(Object o) {\n\t\tif (o instanceof X x || o instanceof X x) {\n            System.out.println(x);\n\t\t}\n\t}\n\tpublic static void main(String[] args) {\n\t\tfoo(new X());\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\tif (o instanceof X x || o instanceof X x) {\n\t                                       ^\nA pattern variable with the same name is already defined in the statement\n----------\n2. ERROR in X.java (at line 5)\n\tSystem.out.println(x);\n\t                   ^\nx cannot be resolved to a variable\n----------\n", null, true, compilerOptions);
    }

    public void test072() {
        Map<String, String> compilerOptions = this.getCompilerOptions(true);
        this.runNegativeTest(new String[]{"X.java", "@SuppressWarnings(\"preview\")\npublic class X {\n    static void foo(Object o) {\n\t\tif (o instanceof X x || o instanceof X x) {\n\t\t\tthrow new IllegalArgumentException();\n\t\t}\n     System.out.println(x);\n\t}\n\tpublic static void main(String[] args) {\n\t\tfoo(new X());\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\tif (o instanceof X x || o instanceof X x) {\n\t                                       ^\nA pattern variable with the same name is already defined in the statement\n----------\n2. ERROR in X.java (at line 7)\n\tSystem.out.println(x);\n\t                   ^\nx cannot be resolved to a variable\n----------\n", null, true, compilerOptions);
    }

    public void test073() {
        Map<String, String> compilerOptions = this.getCompilerOptions(true);
        this.runConformTest(new String[]{"X.java", "@SuppressWarnings(\"preview\")\npublic class X {\n static void foo(Object o) {\n\t\ttry {\n\t\t\tif (!(o instanceof X x) || x != null || x!= null) { // allowed \n\t\t\t\tthrow new IllegalArgumentException();\n\t\t\t}\n    \t \tSystem.out.println(x); // allowed \n\t  \t} catch (Throwable e) {\n\t  \t\te.printStackTrace(System.out);\n\t  \t}\n\t}\n\tpublic static void main(String[] args) {\n\t\tfoo(new X());\n\t}\n}"}, "java.lang.IllegalArgumentException\n\tat X.foo(X.java:6)\n\tat X.main(X.java:14)", compilerOptions);
    }

    public void test074() {
        Map<String, String> compilerOptions = this.getCompilerOptions(true);
        this.runNegativeTest(new String[]{"X.java", "@SuppressWarnings(\"preview\")\npublic class X {\n   static void foo(Object o) {\n\t\tif (!(o instanceof X x) || x != null || x!= null) {\n     \tSystem.out.println(x); // not allowed\n\t\t}\n\t  }\n\tpublic static void main(String[] args) {\n\t\tfoo(new X());\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 5)\n\tSystem.out.println(x); // not allowed\n\t                   ^\nx cannot be resolved to a variable\n----------\n", null, true, compilerOptions);
    }

    public void test075() {
        Map<String, String> compilerOptions = this.getCompilerOptions(true);
        this.runConformTest(new String[]{"X.java", "@SuppressWarnings(\"preview\")\npublic class X {\n public boolean isMyError(Exception e) {\n        return e instanceof MyError my && (my.getMessage().contains(\"something\") || my.getMessage().contains(\"somethingelse\"));\n }\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(\"hello\");\n\t}\n}\nclass MyError extends Exception {}\n"}, "hello", compilerOptions);
    }

    public void test076() {
        Map<String, String> compilerOptions = this.getCompilerOptions(true);
        this.runNegativeTest(new String[]{"X.java", "@SuppressWarnings(\"preview\")\npublic class X {\n   static void foo(Object o) {\n\t   if ( (! (o instanceof String a)) || (o instanceof String a) ) {\n\t\t   // Nothing\n\t   }\n\t  }\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(\"hello\");\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tif ( (! (o instanceof String a)) || (o instanceof String a) ) {\n\t                                                         ^\nA pattern variable with the same name is already defined in the statement\n----------\n", null, true, compilerOptions);
    }

    public void test077() {
        Map<String, String> compilerOptions = this.getCompilerOptions(true);
        this.runConformTest(new String[]{"X.java", "public class X {\n    static void foo(Object o) {\n\t\tif (o instanceof X x) {\n\t\t\tx = null;\n         System.out.println(x);\n\t\t}\n\t}\n\tpublic static void main(String[] args) {\n\t\tfoo(new X());\n\t}\n}"}, "null", compilerOptions);
    }

    public void test078() {
        Map<String, String> compilerOptions = this.getCompilerOptions(true);
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    static void foo(Object o) {\n\t\tif (o instanceof final X x) {\n\t\t\tx = null;\n\t\t}\n\t}\n\tpublic static void main(String[] args) {\n\t\tfoo(new X());\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\tx = null;\n\t^\nThe pattern variable x is final and cannot be assigned again\n----------\n", null, true, compilerOptions);
    }

    public void test079() {
        Map<String, String> compilerOptions = this.getCompilerOptions(true);
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    static void foo(Object o) {\n\t\tif (o instanceof public X x) {\n\t\t\tx = null;\n\t\t}\n\t}\n\tpublic static void main(String[] args) {\n\t\tfoo(new X());\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tif (o instanceof public X x) {\n\t                          ^\nIllegal modifier for the pattern variable x; only final is permitted\n----------\n", null, true, compilerOptions);
    }

    public void test080() {
        Map<String, String> compilerOptions = this.getCompilerOptions(true);
        this.runConformTest(new String[]{"X.java", "public class X {\n    static void foo(Object o) {\n\t\tif (o instanceof final X x) {\n            System.out.println(\"X\");\n\t\t}\n\t}\n\tpublic static void main(String[] args) {\n\t\tfoo(new X());\n\t}\n}"}, "X", compilerOptions);
    }

    public void test081() {
        Map<String, String> compilerOptions = this.getCompilerOptions(true);
        this.runNegativeTest(new String[]{"X.java", "public class X<T> {\n\tpublic void foo(T o) {\n\t\t// Rejected\n\t\tboolean b1 = (o instanceof String a) ? (o instanceof String a) : false;\n\t\tboolean b2 = !(o instanceof String a) ? (o instanceof String a) : false;\n\t\tboolean b3 = (o instanceof String a) ? !(o instanceof String a) : false;\n\t\tboolean b4 = !(o instanceof String a) ? !(o instanceof String a) : false;\n\t\t\n\t\tboolean b5 = (o instanceof String a) ? true : (o instanceof String a);\n\t\tboolean b6 = !(o instanceof String a) ? true : (o instanceof String a);\n\t\tboolean b7 = (o instanceof String a) ? true : !(o instanceof String a);\n\t\tboolean b8 = !(o instanceof String a) ? true : !(o instanceof String a);\n\t\t\n\t\tboolean b9 = (o instanceof String) ? (o instanceof String a) : (o instanceof String a);\n\t\tboolean b10 = (o instanceof String) ? !(o instanceof String a) : !(o instanceof String a);\n\t\t\n\t\t// These are allowed\n\t\tboolean b11 = (o instanceof String) ? !(o instanceof String a) : !!(o instanceof String a);\n\t\tboolean b12 = (o instanceof String) ? !(o instanceof String a) : (o instanceof String a);\n\t\tboolean b21 = (o instanceof String a) ? false : ((o instanceof String a) ? false : true); \n\t} \n}"}, "----------\n1. ERROR in X.java (at line 4)\n\tboolean b1 = (o instanceof String a) ? (o instanceof String a) : false;\n\t                                                            ^\nA pattern variable with the same name is already defined in the statement\n----------\n2. ERROR in X.java (at line 5)\n\tboolean b2 = !(o instanceof String a) ? (o instanceof String a) : false;\n\t                                                             ^\nA pattern variable with the same name is already defined in the statement\n----------\n3. ERROR in X.java (at line 6)\n\tboolean b3 = (o instanceof String a) ? !(o instanceof String a) : false;\n\t                                                             ^\nA pattern variable with the same name is already defined in the statement\n----------\n4. ERROR in X.java (at line 7)\n\tboolean b4 = !(o instanceof String a) ? !(o instanceof String a) : false;\n\t                                                              ^\nA pattern variable with the same name is already defined in the statement\n----------\n5. ERROR in X.java (at line 9)\n\tboolean b5 = (o instanceof String a) ? true : (o instanceof String a);\n\t                                                                   ^\nA pattern variable with the same name is already defined in the statement\n----------\n6. ERROR in X.java (at line 10)\n\tboolean b6 = !(o instanceof String a) ? true : (o instanceof String a);\n\t                                                                    ^\nA pattern variable with the same name is already defined in the statement\n----------\n7. ERROR in X.java (at line 11)\n\tboolean b7 = (o instanceof String a) ? true : !(o instanceof String a);\n\t                                                                    ^\nA pattern variable with the same name is already defined in the statement\n----------\n8. ERROR in X.java (at line 12)\n\tboolean b8 = !(o instanceof String a) ? true : !(o instanceof String a);\n\t                                                                     ^\nA pattern variable with the same name is already defined in the statement\n----------\n9. ERROR in X.java (at line 14)\n\tboolean b9 = (o instanceof String) ? (o instanceof String a) : (o instanceof String a);\n\t                                                                                    ^\nA pattern variable with the same name is already defined in the statement\n----------\n10. ERROR in X.java (at line 15)\n\tboolean b10 = (o instanceof String) ? !(o instanceof String a) : !(o instanceof String a);\n\t                                                                                       ^\nA pattern variable with the same name is already defined in the statement\n----------\n", null, true, compilerOptions);
    }

    public void testBug570831a() {
        Map<String, String> compilerOptions = this.getCompilerOptions(true);
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void run() {\n\t\tString s = \"s\";\n\t\tObject o = null;\n\t\t{\n\t\t\twhile (!(o instanceof String v)) {\n\t\t\t\to = null;\n\t\t\t}\n\t\t\ts = s + v; // allowed\n\t\t}\n\t\tfor (int i = 0; i < 1; i++) {\n\t\t\ts = s + v; // not allowed\n\t\t}\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 12)\n\ts = s + v; // not allowed\n\t        ^\nv cannot be resolved to a variable\n----------\n", null, true, compilerOptions);
    }

    public void testBug570831b() {
        Map<String, String> compilerOptions = this.getCompilerOptions(true);
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void run() {\n\t\tString s = \"s\";\n\t\tObject o = null;\n\t\t{\n\t\t\tint local = 0;\n\t\t\twhile (!(o instanceof String v)) {\n\t\t\t\to = null;\n\t\t\t}\n\t\t\ts = s + v; // allowed\n\t\t}\n\t\tfor (int i = 0; i < 1; i++) {\n\t\t\ts = s + v; // not allowed\n\t\t}\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 13)\n\ts = s + v; // not allowed\n\t        ^\nv cannot be resolved to a variable\n----------\n", null, true, compilerOptions);
    }

    public void testBug572380_1() {
        Map<String, String> options = this.getCompilerOptions(false);
        this.runConformTest(new String[]{"X1.java", "\npublic class X1 {\n    boolean b1, b2, b3;\n\n    static boolean bubbleOut(Object obj) {\n\t       return obj instanceof X1 that && that.b1 && that.b2 && that.b3;\n    }\n\n    static boolean propagateTrueIn(Object obj) {\n        return obj instanceof X1 that && (that.b1 && that.b2 && that.b3);\n    }\n\n    public static void main(String[] obj) {\n        var ip = new X1();\n        ip.b1 = ip.b2 = ip.b3 = true;\n        System.out.println(bubbleOut(ip) && propagateTrueIn(ip));\n    }\n\n}\n"}, "true", options);
    }

    public void testBug572380_2() {
        Map<String, String> options = this.getCompilerOptions(false);
        this.runConformTest(new String[]{"X1.java", "\npublic class X1 {\n    boolean b1, b2, b3;\n    static boolean testErrorOr(Object obj) {\n        return (!(obj instanceof X1 that)) || that.b1 && that.b2;\n    }\n    \n    public static void main(String[] obj) {\n        var ip = new X1();\n        ip.b1 = ip.b2 = ip.b3 = true;\n        System.out.println(testErrorOr(ip));\n    }\n\n}\n"}, "true", options);
    }

    public void testBug574892() {
        Map<String, String> options = this.getCompilerOptions(false);
        this.runConformTest(new String[]{"X1.java", "\npublic class X1 {\n    static boolean testConditional(Object obj) {\n        return obj instanceof Integer other\n                && ( other.intValue() > 100\n                   ? other.intValue() < 200 : other.intValue() < 50);\n    }\n    public static void main(String[] obj) {\n        System.out.println(testConditional(101));\n    }\n}\n"}, "true", options);
    }

    public void testBug572431_1() {
        Map<String, String> options = this.getCompilerOptions(false);
        this.runConformTest(new String[]{"X.java", "public class X {\n\t\t\t   static public void something () {\n\t\t\t      boolean bool = true;\n\t\t\t      Object object = null;\n\t\t\t      if (object instanceof String string) {\n\t\t\t      } else if (bool && object instanceof Integer integer) {\n\t\t\t      }\n\t\t\t   }\n\t\t\t   static public void main (String[] args) throws Exception {\n\t\t\t   }\n\t\t\t}"}, "", options);
    }

    public void testBug572431_2() {
        Map<String, String> options = this.getCompilerOptions(false);
        this.runConformTest(new String[]{"X.java", "public class X {\n  static public void something () {\n    boolean bool = true;\n    Object object = null;\n    if (object instanceof String string) {\n    } else if (bool) {\n      if (object instanceof Integer integer) {\n      }\n    }\n  }\n  static public void main (String[] args) throws Exception {\n  }\n}"}, "", options);
    }

    public void testBug572431_3() {
        Map<String, String> options = this.getCompilerOptions(false);
        this.runConformTest(new String[]{"X.java", "public class X {\n  static public void something () {\n    boolean bool = true;\n    Object object = null;\n    if (bool && object instanceof Integer i) {\n\t   }\n  }\n  static public void main (String[] args) throws Exception {\n  }\n}"}, "", options);
    }

    public void testBug572431_4() {
        Map<String, String> options = this.getCompilerOptions(false);
        this.runConformTest(new String[]{"X.java", "public class X {\n  static public void something () {\n    boolean bool = true;\n    Object object = null;\n    if (!(object instanceof Integer i)) {\n\t   }\n  }\n  static public void main (String[] args) throws Exception {\n  }\n}"}, "", options);
    }

    public void testBug572431_5() {
        Map<String, String> options = this.getCompilerOptions(false);
        this.runConformTest(new String[]{"X.java", "public class X {\n  static public void something () {\n    boolean bool = true;\n    Object object = null;\n    if (false) {\n\t   } else if (!(object instanceof Integer i)) {\n\t   }\n  }\n  static public void main (String[] args) throws Exception {\n  }\n}"}, "", options);
    }

    public void testBug572431_6() {
        Map<String, String> options = this.getCompilerOptions(false);
        this.runConformTest(new String[]{"X.java", "public class X {\n  static public void something () {\n    boolean bool = true;\n\t\tObject object = null;\n\t\tfor (int i = 0; i < 10; i++) {\n\t\t\tif (object instanceof String string) {\n\t\t\t\tSystem.out.println(i);\n\t\t\t} else if (bool) {\n\t\t\t\tif (i == 4) continue;\n\t\t\t\tSystem.out.println(i);\n\t\t\t}\n\t\t}\n  }\n  static public void main (String[] args) throws Exception {\n  }\n}"}, "", options);
    }

    public void testBug573880() {
        if (this.complianceLevel < 0x3D0000L) {
            return;
        }
        Map<String, String> compilerOptions = this.getCompilerOptions(true);
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic void foo(Object o) {\n\t\tif (o instanceof var s) {\n\t\t\tSystem.out.println(s);\n\t\t}\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tif (o instanceof var s) {\n\t                 ^^^\n'var' is not allowed here\n----------\n", null, true, compilerOptions);
    }

    public void testBug574906() {
        Map<String, String> options = this.getCompilerOptions(false);
        this.runConformTest(new String[]{"X1.java", "\npublic class X1 {\n    static boolean testConditional(Object obj) {\n        return obj instanceof Number oNum && oNum.intValue() < 0 && !(oNum instanceof Integer);\n    }\n    public static void main(String[] obj) {\n        System.out.println(testConditional(-2f));\n    }\n}\n"}, "true", options);
    }

    public void testBug575035() throws ClassFormatException, IOException {
        Map<String, String> options = this.getCompilerOptions(false);
        String source = "import java.lang.annotation.ElementType;\nimport java.lang.annotation.Retention;\nimport java.lang.annotation.RetentionPolicy;\nimport java.lang.annotation.Target;\n \npublic class Test {\n    @Target({ ElementType.LOCAL_VARIABLE})\n    @Retention(RetentionPolicy.RUNTIME)\n    @interface Var {}\n    @Target({ ElementType.TYPE_USE})\n    @Retention(RetentionPolicy.RUNTIME)\n    @interface Type {}\n    public static void main(String[] args) {        @Var @Type String y = \"OK: \";\n        if (((Object)\"local\") instanceof @Var @Type String x) {\n            System.out.println(new StringBuilder(y).append(x));\n        }\n    }\n}";
        String expectedOutput = "  public static void main(String[] args);\n     0  ldc <String \"OK: \"> [16]\n     2  astore_1 [y]\n     3  ldc <String \"local\"> [18]\n     5  dup\n     6  astore_3\n     7  instanceof String [20]\n    10  ifeq 36\n    13  aload_3\n    14  checkcast String [20]\n    17  astore_2 [x]\n    18  getstatic System.out : PrintStream [22]\n    21  new StringBuilder [28]\n    24  dup\n    25  aload_1 [y]\n    26  invokespecial StringBuilder(String) [30]\n    29  aload_2 [x]\n    30  invokevirtual StringBuilder.append(String) : StringBuilder [33]\n    33  invokevirtual PrintStream.println(Object) : void [37]\n    36  return\n      Line numbers:\n        [pc: 0, line: 13]\n        [pc: 3, line: 14]\n        [pc: 18, line: 15]\n        [pc: 36, line: 17]\n      Local variable table:\n        [pc: 0, pc: 37] local: args index: 0 type: String[]\n        [pc: 3, pc: 37] local: y index: 1 type: String\n        [pc: 18, pc: 36] local: x index: 2 type: String\n      Stack map table: number of frames 1\n        [pc: 36, append: {String}]\n    RuntimeVisibleTypeAnnotations: \n      #50 @Type(\n        target type = 0x40 LOCAL_VARIABLE\n        local variable entries:\n          [pc: 3, pc: 37] index: 1\n      )\n      #50 @Type(\n        target type = 0x40 LOCAL_VARIABLE\n        local variable entries:\n          [pc: 18, pc: 36] index: 2\n      )\n\n  Inner classes:\n    [inner class info: #54 Test$Type, outer class info: #1 Test\n     inner name: #56 Type, accessflags: 9736 abstract static],\n    [inner class info: #57 Test$Var, outer class info: #1 Test\n     inner name: #59 Var, accessflags: 9736 abstract static]\n\nNest Members:\n   #54 Test$Type,\n   #57 Test$Var\n}";
        this.checkClassFile("Test", source, expectedOutput, 9);
        this.runConformTest(new String[]{"Test.java", source}, "OK: local", options);
    }

    public void testBug578628_1() {
        if (this.complianceLevel < 0x3E0000L) {
            return;
        }
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    public static Object str = \"a\";\n    public static void foo() {\n    \tif (str instanceof (String a && a == null)) {\n            System.out.println(true);\n        } else {\n        \tSystem.out.println(false);\n        }\n    } \n    public static void main(String[] argv) {\n    \tfoo();\n    }\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\tif (str instanceof (String a && a == null)) {\n\t                   ^\nSyntax error on token \"(\", delete this token\n----------\n2. ERROR in X.java (at line 4)\n\tif (str instanceof (String a && a == null)) {\n\t                                          ^\nSyntax error on token \")\", delete this token\n----------\n", false);
    }

    public void testBug578628_1a() {
        if (this.complianceLevel < 0x3E0000L) {
            return;
        }
        Map<String, String> compilerOptions = this.getCompilerOptions(true);
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static Object str = \"a\";\n    public static void foo() {\n    \tif (str instanceof String a && a == null) {\n            System.out.println(true);\n        } else {\n        \tSystem.out.println(false);\n        }\n    } \n    public static void main(String[] argv) {\n    \tfoo();\n    }\n}"}, "false", compilerOptions);
    }

    public void testBug578628_2() {
        if (this.complianceLevel < 0x3E0000L) {
            return;
        }
        Map<String, String> compilerOptions = this.getCompilerOptions(true);
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static Object str = \"a\";\n    public static void foo() {\n    \tif (str instanceof String a && a != null) {\n            System.out.println(true);\n        } else {\n        \tSystem.out.println(false);\n        }\n    } \n    public static void main(String[] argv) {\n    \tfoo();\n    }\n}"}, "true", compilerOptions);
    }

    public void testBug578628_3() {
        if (this.complianceLevel < 0x3E0000L) {
            return;
        }
        Map<String, String> compilerOptions = this.getCompilerOptions(true);
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static Object str = \"a\";\n    public static void foo() {\n    \tbar(str instanceof String a && a == null);\n    } \n    public static void bar(boolean arg) {\n    \tSystem.out.println(arg);\n    }\n    public static void main(String[] argv) {\n    \tfoo();\n    }\n}"}, "false", compilerOptions);
    }

    public void testBug578628_4() {
        if (this.complianceLevel < 0x410000L) {
            return;
        }
        Map<String, String> compilerOptions = this.getCompilerOptions(true);
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static Object str = \"a\";\npublic static void foo() {\n    \tboolean b = switch (str) {\n    \t\tcase String s -> {\n    \t\t\tyield (str instanceof String a && a != null);\n    \t\t}\n    \t\tdefault -> false;\n    \t};\n    \tSystem.out.println(b);\n    }\n    public static void main(String[] argv) {\n    \tfoo();\n    }\n}"}, "true", compilerOptions);
    }

    public void testGH1726() {
        if (this.complianceLevel < 0x410000L) {
            return;
        }
        Map<String, String> compilerOptions = this.getCompilerOptions(true);
        this.runConformTest(new String[]{"X.java", "public class X {\n\trecord A(int x) {\n\t}\n\n\tpublic static int foo(Object a) {\n\t\treturn a instanceof A(int x) ? x : 1;\n\t}\n\n\tpublic static void main(String [] args) {\n\t\tSystem.out.println(\"\" + foo(new A(1234)) + foo(args));\n\t}\n}\n"}, "12341", compilerOptions);
    }

    public void testGH1725() {
        if (this.complianceLevel < 0x410000L) {
            return;
        }
        Map<String, String> compilerOptions = this.getCompilerOptions(true);
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic abstract sealed class A permits B, C {\n\t}\n\n\tpublic final class C extends A {\n\t}\n\n\tpublic abstract sealed class B extends A permits D {\n\t}\n\n\tpublic final class D extends B {\n\t}\n\n\tpublic String foo(A a) {\n\t\treturn switch (a) {\n\t\t\tcase D d -> \"1234\";\n\t\t\tcase C c -> \"6789\";\n\t\t};\n\t}\n\tpublic static void main(String [] args) {\n\t\tSystem.out.println(new X().foo(new X().new D()) + new X().foo(new X().new C()));\n\t}\n}\n"}, "12346789", compilerOptions);
    }

    public void testGH1725_2() {
        if (this.complianceLevel < 0x410000L) {
            return;
        }
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic abstract sealed class A permits B, C {\n\t}\n\n\tpublic final class C extends A {\n\t}\n\n\tpublic sealed class B extends A permits D {\n\t}\n\n\tpublic final class D extends B {\n\t}\n\n\tpublic String foo(A a) {\n\t\treturn switch (a) {\n\t\t\tcase D d -> \"1234\";\n\t\t\t// case B b -> \"blah\";\n\t\t\tcase C c -> \"6789\";\n\t\t};\n\t}\n\tpublic static void main(String [] args) {\n\t\tSystem.out.println(new X().foo(new X().new D()) + new X().foo(new X().new C()));\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 15)\n\treturn switch (a) {\n\t               ^\nA switch expression should have a default case\n----------\n", false);
    }

    public void testGHI1759() {
        this.runConformTest(new String[]{"X.java", "import java.util.Arrays;\nimport java.util.List;\npublic class X {\n\tpublic static void main(String [] args) {\n        Object obj = \"test\";\n        List<String> values = Arrays.asList(\"fail\", \"test\", \"pass\");\n        if (obj instanceof String str && values.stream().anyMatch(str::equalsIgnoreCase)) {\n            System.out.println(str);\n        }\n    }\n\n}\n"}, "test");
    }

    public void testGHI1759_2() {
        this.runConformTest(new String[]{"X.java", "import java.util.Arrays;\nimport java.util.List;\npublic class X {\n\tpublic static void main(String [] args) {\n        Object obj = \"test\";\n        List<String> values = Arrays.asList(\"fail\", \"test\", \"pass\");\n        if (!(obj instanceof String str) || values.stream().anyMatch(str::equalsIgnoreCase)) {\n            System.out.println(obj);\n        }\n    }\n\n}\n"}, "test");
    }

    public void testGHI1759_3() {
        this.runConformTest(new String[]{"X.java", "import java.util.Arrays;\nimport java.util.List;\npublic class X {\n    public static void main(String [] args) {\n        Object obj = \"test\";\n        List<String> values = Arrays.asList(\"fail\", \"test\", \"pass\");\n        if (obj instanceof String str) {\n        \tif (values.stream().anyMatch(str::equalsIgnoreCase)) {\n        \t\tSystem.out.println(str);\n        \t}\n        }\n    }\n}\n"}, "test");
    }

    public void testGHI1485() {
        if (this.complianceLevel < 0x410000L) {
            return;
        }
        this.runConformTest(new String[]{"X.java", "public class X {\n    static class PvsVariable {\n    }\n\n    static class PvsVariableNext_1 extends PvsVariable {\n    }\n\n    static class PvsVariableNext_2 extends PvsVariableNext_1 {\n    }\n\n    static class PvsVariableNext_3 extends PvsVariableNext_2 {\n    }\n\n    static class PvsVariableNext_4 extends PvsVariableNext_3 {\n    }\n\n    public static void main(String[] args) {\n        final var pvsVariable = new PvsVariableNext_3();\n        final Object origVar =\n                pvsVariable instanceof PvsVariableNext_1 var_first\n                    ? \"PvsVariableNext_1\"\n                    : (pvsVariable instanceof PvsVariableNext_2 var_second &&\n                       pvsVariable instanceof PvsVariableNext_3 var_three &&\n                       true) ? \"PvsVariableNext_2 && PvsVariableNext_3\"\n                                : \"None\";\n        System.out.println(origVar);\n    }\n}\n"}, "PvsVariableNext_1");
    }

    public void testGHI1887() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T> {\n\tpublic void foo(T o) {\n\t\t/*\n\t\t * 6.3.1 Scope for Pattern Variables in Expressions\n\t\t * 6.3.1.1 Conditional-And Operator &&\n\t\t *\n\t\t * It is a compile-time error if any of the following conditions hold:\n\t\t\t\u2022 A pattern variable is both (i) introduced by a when true and (ii) introduced by\n\t\t\tb when true.\n\t\t\t\u2022 A pattern variable is both (i) introduced by a when false and (ii) introduced by\n\t\t\tb when false.\n\t\t */\n\t\tboolean b = o instanceof String a && o instanceof Double a;   // Error: correct\n\t\tb = !(o instanceof String a) && !(o instanceof Double a);     // <<<----- Error NOT reported by ECJ. Javac complains\n\n\t\t/*\n\t\t * 6.3.1.2 Conditional-Or Operator ||\n\t\t *\n\t\t * It is a compile-time error if any of the following conditions hold:\n\t\t\t\u2022 A pattern variable is both (i) introduced by a when true and (ii) introduced by\n\t\t\tb when true.\n\t\t\t\u2022 A pattern variable is both (i) introduced by a when false and (ii) introduced by\n\t\t\tb when false.\n\t\t */\n\t\tb =  o instanceof String a || o instanceof Double a;      // <<<----- Error NOT reported by ECJ. Javac complains\n\t\tb =  !(o instanceof String a) || !(o instanceof Double a); // Error: correct\n\n\t\t/*\n\t\t * 6.3.1.4 Conditional Operator a ? b : c\n\t\t *\n\t\t * It is a compile-time error if any of the following conditions hold:\n\t\t\t\u2022 A pattern variable is both (i) introduced by a when true and (ii) introduced by\n\t\t\tc when true.\n\t\t\t\u2022 A pattern variable is both (i) introduced by a when true and (ii) introduced by\n\t\t\tc when false.\n\t\t\t\u2022 A pattern variable is both (i) introduced by a when false and (ii) introduced by\n\t\t\tb when true.\n\t\t\t\u2022 A pattern variable is both (i) introduced by a when false and (ii) introduced by\n\t\t\tb when false.\n\t\t\t\u2022 A pattern variable is both (i) introduced by b when true and (ii) introduced by\n\t\t\tc when true.\n\t\t\t\u2022 A pattern variable is both (i) introduced by b when false and (ii) introduced by\n\t\t\tc when false.\n\t\t */\n\n\t\tb = o instanceof String a ? true : o instanceof String a;  // error correctly reported\n\t\tb = o instanceof String a ? true : !(o instanceof String a); // error correctly reported\n\t\tb = !(o instanceof String a) ? o instanceof String a : true; // error correctly reported\n\t\tb = !(o instanceof String a) ? !(o instanceof String a) : true; // error correctly reported\n\t\tb = b ? (o instanceof String a) : (o instanceof String a); // error correctly reported\n\t\tb = b ? !(o instanceof String a) : !(o instanceof String a); // error correctly reported\n\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 13)\n\tboolean b = o instanceof String a && o instanceof Double a;   // Error: correct\n\t                                                         ^\nA pattern variable with the same name is already defined in the statement\n----------\n2. ERROR in X.java (at line 14)\n\tb = !(o instanceof String a) && !(o instanceof Double a);     // <<<----- Error NOT reported by ECJ. Javac complains\n\t                                                      ^\nA pattern variable with the same name is already defined in the statement\n----------\n3. ERROR in X.java (at line 25)\n\tb =  o instanceof String a || o instanceof Double a;      // <<<----- Error NOT reported by ECJ. Javac complains\n\t                                                  ^\nA pattern variable with the same name is already defined in the statement\n----------\n4. ERROR in X.java (at line 26)\n\tb =  !(o instanceof String a) || !(o instanceof Double a); // Error: correct\n\t                                                       ^\nA pattern variable with the same name is already defined in the statement\n----------\n5. ERROR in X.java (at line 46)\n\tb = o instanceof String a ? true : o instanceof String a;  // error correctly reported\n\t                                                       ^\nA pattern variable with the same name is already defined in the statement\n----------\n6. ERROR in X.java (at line 47)\n\tb = o instanceof String a ? true : !(o instanceof String a); // error correctly reported\n\t                                                         ^\nA pattern variable with the same name is already defined in the statement\n----------\n7. ERROR in X.java (at line 48)\n\tb = !(o instanceof String a) ? o instanceof String a : true; // error correctly reported\n\t                                                   ^\nA pattern variable with the same name is already defined in the statement\n----------\n8. ERROR in X.java (at line 49)\n\tb = !(o instanceof String a) ? !(o instanceof String a) : true; // error correctly reported\n\t                                                     ^\nA pattern variable with the same name is already defined in the statement\n----------\n9. ERROR in X.java (at line 50)\n\tb = b ? (o instanceof String a) : (o instanceof String a); // error correctly reported\n\t                                                       ^\nA pattern variable with the same name is already defined in the statement\n----------\n10. ERROR in X.java (at line 51)\n\tb = b ? !(o instanceof String a) : !(o instanceof String a); // error correctly reported\n\t                                                         ^\nA pattern variable with the same name is already defined in the statement\n----------\n");
    }

    public void testGH1406() throws ClassFormatException, IOException {
        Map<String, String> options = this.getCompilerOptions(false);
        String source = "\t\t\tpublic class X {\n\tpublic static void main(String[] args) {\n\t\tObject o = null;\n\t\tif (o instanceof String x) {\n\n\t\t}\n\t}\n}\n";
        String expectedOutput = "  public static void main(String[] args);\n     0  aconst_null\n     1  astore_1 [o]\n     2  aload_1 [o]\n     3  instanceof String [16]\n     6  ifeq 14\n     9  aload_1 [o]\n    10  checkcast String [16]\n    13  astore_2\n    14  return\n";
        this.checkClassFile("X", source, expectedOutput, 9);
        this.runConformTest(new String[]{"X.java", source}, "", options);
    }

    public void testGH1406_2() throws ClassFormatException, IOException {
        Map<String, String> options = this.getCompilerOptions(false);
        String source = "\t\t\tpublic class X {\n    Object o = \"Helo\";\n    public void foo() {\n        if (o instanceof String s) {\n\n        }\n    }\n\n    public static void main(String [] args) {\n        new X().foo();\n    }\n}\n";
        String expectedOutput = "  public void foo();\n     0  aload_0 [this]\n     1  getfield X.o : Object [14]\n     4  dup\n     5  astore_2\n     6  instanceof String [21]\n     9  ifeq 17\n    12  aload_2\n    13  checkcast String [21]\n    16  astore_1\n    17  return\n";
        this.checkClassFile("X", source, expectedOutput, 9);
        this.runConformTest(new String[]{"X.java", source}, "", options);
    }

    public void testIssue1889() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tstatic public Object a0 = \"a\";\n\n\tpublic static void main(String argv[]) {\n\t\tString res = \"\";\n\t\tObject ax = a0;\n\n\t\tif ( (! (ax instanceof String a)) && (ax instanceof String a) ) {\n\t\t\tres += \"t\" + a; // after then\n\t\t} else {\n\t\t\tres += \"e\" + \"\"; // after else\n\t\t}\n\t\tif (!res.equals(\"e\")) {\n\t\t\tSystem.out.println(\"Got: \" + res + \", expected: e\");\n\t\t} else {\n\t\t\tSystem.out.println(\"OK!\");\n\t\t}\n\t}\n}\n"}, "OK!");
    }

    public void testIssue1889_2() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  public static void main(String[] o) {\n\t\tfoo(\"one\");\n\t\tfoo(new X());\n\t}\n  public static void foo(Object o) {\n\t  \tboolean b  = (o instanceof String) ? (o instanceof String a) : (! (o instanceof String  a));\n\t  \tSystem.out.println(b);\n\t}\n}\n"}, "true\ntrue");
    }

    public void testIssue1889_3() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  public static void main(String[] o) {\n\t\tfoo(\"one\");\n\t\tfoo(new X());\n\t}\n  public static void foo(Object o) {\n\t  \tboolean b  = (o instanceof String) ? !(o instanceof String a) : (o instanceof String  a);\n\t  \tSystem.out.println(b);\n\t}\n}\n"}, "false\nfalse");
    }

    public void testIssue1889_4() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  public static void main(String[] o) {\n\t\tfoo(\"one\");\n\t\tfoo(new X());\n\t}\n  public static void foo(Object o) {\n\t  \tboolean b  = (o instanceof String) ? !!(o instanceof String a) : (o instanceof String  c);\n\t  \tSystem.out.println(b);\n\t}\n}\n"}, "true\nfalse");
    }

    public void testIssue1889_5() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  public static void main(String[] o) {\n\t\tfoo(\"one\");\n\t\tfoo(new X());\n\t}\n  public static void foo(Object o) {\n\t  \tboolean b  = (o instanceof String) ? (o instanceof String a) : (o instanceof String  c);\n\t  \tSystem.out.println(b);\n\t}\n}\n"}, "true\nfalse");
    }

    public void testIssue1889_6() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  public static void main(String[] o) {\n\t\tfoo(\"one\");\n\t\tfoo(new X());\n\t}\n  public static void foo(Object o) {\n\t  \tboolean b  = (o instanceof String) ? (o instanceof String a) : !!(o instanceof String  c);\n\t  \tSystem.out.println(b);\n\t}\n}\n"}, "true\nfalse");
    }

    public void testIssue1889_7() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  public static void main(String[] o) {\n\t\tfoo(\"one\");\n\t\tfoo(new X());\n\t}\n  public static void foo(Object o) {\n\t  \tboolean b  = (o instanceof String s1) ? (o instanceof String s2) : (o instanceof String  s3);\n\t  \tSystem.out.println(b);\n\t}\n}\n"}, "true\nfalse");
    }

    public void testIssue1889_8() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  public static void main(String[] o) {\n\t\tfoo(\"one\");\n\t\tfoo(new X());\n\t}\n  public static void foo(Object o) {\n\t  \tboolean b  = !(o instanceof String s1) ? (o instanceof String s2) : (o instanceof String  s3);\n\t  \tSystem.out.println(b);\n\t}\n}\n"}, "true\nfalse");
    }

    public void testIssue1889_9() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  public static void main(String[] o) {\n\t\tfoo(\"one\");\n\t\tfoo(new X());\n\t}\n  public static void foo(Object o) {\n\t  \tboolean b  = !!(o instanceof String s1) ? (o instanceof String s2) : (o instanceof String  s3);\n\t  \tSystem.out.println(b);\n\t}\n}\n"}, "true\nfalse");
    }

    public void testIssue1889_10() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  public static void main(String[] o) {\n\t\tfoo(\"one\");\n\t\tfoo(new X());\n\t}\n  public static void foo(Object o) {\n\t  \tboolean b  = !!(o instanceof String s1) ? !!!!(o instanceof String s2) : !!!!!!!(o instanceof String  s3);\n\t  \tSystem.out.println(b);\n\t}\n}\n"}, "true\ntrue");
    }

    public void testWhileLoop() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tvoid foo(Object o) {\n\t\twhile (o instanceof String s) {\n\t\t\tSystem.out.println(\"while\");\n\t\t\treturn;\n\t\t}\n\t\tSystem.out.println(\"!while\");\n\t}\n\tpublic static void main(String [] args) {\n\t    new X().foo(\"\");\n\t     new X().foo(null);\n\t}\n}\n"}, "while\n!while");
    }

    public void testForLoop() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tvoid foo(Object o) {\n\t\tfor(; (o instanceof String s);) {\n\t\t\tSystem.out.println(\"for\");\n\t\t\treturn;\n\t\t}\n\t\tSystem.out.println(\"!for\");\n\t}\n\tpublic static void main(String [] args) {\n\t    new X().foo(\"\");\n\t     new X().foo(null);\n\t}\n}\n"}, "for\n!for");
    }

    public void testBoxing() {
        if (this.complianceLevel < 0x410000L) {
            return;
        }
        this.runConformTest(new String[]{"X.java", "public class X {\n\n\tpublic static void foo(Boolean b) {\n\t\tSystem.out.println(b);\n\t}\n\n\tpublic static void main(String [] args) {\n\t\tObject o = new Object();\n\t\tfoo(o instanceof String);\n\t\tfoo(\"Hello\" instanceof String);\n\t\tfoo(o instanceof String s);\n\t\tfoo(\"Hello\" instanceof String s);\n\t}\n}\n"}, "false\ntrue\nfalse\ntrue");
    }
}

