/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;

public class PolymorphicSignatureTest
extends AbstractRegressionTest {
    public PolymorphicSignatureTest(String name) {
        super(name);
    }

    public static Test suite() {
        return PolymorphicSignatureTest.buildMinimalComplianceTestSuite(PolymorphicSignatureTest.testClass(), 32);
    }

    public static Class testClass() {
        return PolymorphicSignatureTest.class;
    }

    public void test0001() {
        this.runConformTest(new String[]{"X.java", "import java.lang.invoke.*;\npublic class X {\n   public static void main(String[] args) throws Throwable{\n      MethodType mt; MethodHandle mh; \n      MethodHandles.Lookup lookup = MethodHandles.lookup();\n      mt = MethodType.methodType(String.class, char.class, char.class);\n      mh = lookup.findVirtual(String.class, \"replace\", mt);\n      String s = (String) mh.invokeExact(\"daddy\",'d','n');\n      System.out.println(s);\n   }\n}\n"}, "nanny");
    }

    public void test0002() {
        this.runConformTest(new String[]{"X.java", "import static java.lang.invoke.MethodHandles.*; \nimport java.lang.invoke.MethodHandle;\npublic class X {\n\tpublic static void main(String[] args) throws Throwable {\n\t\tMethodHandle mh = dropArguments(insertArguments(identity(int.class), 0, 42), 0, Object[].class);\n\t\tint value = (int)mh.invokeExact(new Object[0]);\n\t\tSystem.out.println(value);\n\t}\n}"}, "42");
    }

    public void testBug515863() {
        this.runConformTest(new String[]{"Test.java", "import java.lang.invoke.MethodHandle;\nimport java.util.ArrayList;\nimport java.util.Collections;\n\npublic class Test {\n\t\n\tpublic void foo() throws Throwable {\n\t\t\n\t\tMethodHandle mh = null;\n\t\tmh.invoke(null);                           // works, no issues.\n\t\tmh.invoke(null, new ArrayList<>());        // Bug 501457 fixed this\n\t\tmh.invoke(null, Collections.emptyList());  // This triggers UOE\n\t\t\n\t}\n}\n"});
    }

    public void testBug475996() {
        if (!isJRE9Plus) {
            return;
        }
        this.runConformTest(new String[]{"X.java", "import java.lang.invoke.VarHandle;\npublic class X<T> {\n\tstatic class Token {}\n\tToken NIL = new Token();\n\tVarHandle RESULT;\n\tvoid call(T t) {\n\t\tRESULT.compareAndSet(this, null, (t==null) ? NIL : t);\n\t}\n}\n"});
    }
}

