/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest9;
import org.eclipse.jdt.core.tests.util.Util;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileConstants;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.JavaFeature;

public class PreviewFeatureTest
extends AbstractRegressionTest9 {
    public static Class<?> testClass() {
        return PreviewFeatureTest.class;
    }

    public static Test suite() {
        return PreviewFeatureTest.buildMinimalComplianceTestSuite(PreviewFeatureTest.testClass(), 8192);
    }

    public PreviewFeatureTest(String testName) {
        super(testName);
    }

    @Override
    protected Map<String, String> getCompilerOptions() {
        Map<String, String> options = super.getCompilerOptions();
        if (isJRE17Plus) {
            options.put("org.eclipse.jdt.core.compiler.release", "enabled");
        }
        return options;
    }

    private String[] getClasspathWithPreviewAPI() {
        File libDir = new File(LIB_DIR);
        Util.delete(libDir);
        libDir.mkdirs();
        String jarPath = LIB_DIR + "/lib1.jar";
        try {
            Util.createJar(new String[]{"jdk/internal/javac/PreviewFeature.java", "package jdk.internal.javac;\nimport java.lang.annotation.*;\n@Target({ElementType.METHOD,\n         ElementType.CONSTRUCTOR,\n         ElementType.FIELD,\n         ElementType.PACKAGE,\n         ElementType.MODULE,\n         ElementType.TYPE})\n@Retention(RetentionPolicy.CLASS)\npublic @interface PreviewFeature {\n    public Feature feature();\n    public enum Feature {\n        /**\n         * A key for testing.\n         */\n        TEST;\n    }\n}", "p/ABC.java", "package p;\nimport jdk.internal.javac.PreviewFeature;\n@PreviewFeature(feature=PreviewFeature.Feature.TEST)\npublic class ABC {\n  @PreviewFeature(feature=PreviewFeature.Feature.TEST)\n  public void doSomething() {}\n}"}, jarPath, "9");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String[] javaClassLibs = Util.getJavaClassLibs();
        int javaClassLibsLength = javaClassLibs.length;
        String[] xClassLibs = new String[javaClassLibsLength + 1];
        System.arraycopy(javaClassLibs, 0, xClassLibs, 0, javaClassLibsLength);
        xClassLibs[javaClassLibsLength] = jarPath;
        return xClassLibs;
    }

    public void test001() {
        if (this.complianceLevel >= 0x3D0000L) {
            return;
        }
        String[] classLibs = this.getClasspathWithPreviewAPI();
        Map<String, String> options = this.getCompilerOptions();
        String old = options.get("org.eclipse.jdt.core.compiler.problem.enablePreviewFeatures");
        options.put("org.eclipse.jdt.core.compiler.problem.enablePreviewFeatures", "disabled");
        try {
            this.runNegativeTest(new String[]{"X.java", "import p.*;\npublic class X {\n    Zork z = null;\n    ABC abc = null;\n   public void foo () {\n      (new ABC()).doSomething();\n   }\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tZork z = null;\n\t^^^^\nZork cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 4)\n\tABC abc = null;\n\t^^^\nThis API is part of the preview feature 'Test Feature' which is disabled by default. Use --enable-preview to enable\n----------\n3. ERROR in X.java (at line 6)\n\t(new ABC()).doSomething();\n\t^^^^^^^^^^^^^^^^^^^^^^^^^\nThis API is part of the preview feature 'Test Feature' which is disabled by default. Use --enable-preview to enable\n----------\n4. ERROR in X.java (at line 6)\n\t(new ABC()).doSomething();\n\t     ^^^\nThis API is part of the preview feature 'Test Feature' which is disabled by default. Use --enable-preview to enable\n----------\n", classLibs, true, options);
        }
        finally {
            options.put("org.eclipse.jdt.core.compiler.problem.enablePreviewFeatures", old);
        }
    }

    public void test002() {
        if (this.complianceLevel >= 0x3D0000L) {
            return;
        }
        Map<String, String> options = this.getCompilerOptions();
        String old = options.get("org.eclipse.jdt.core.compiler.problem.enablePreviewFeatures");
        options.put("org.eclipse.jdt.core.compiler.problem.enablePreviewFeatures", "disabled");
        String[] classLibs = this.getClasspathWithPreviewAPI();
        try {
            this.runNegativeTest(new String[]{"X.java", "import p.*;\n@SuppressWarnings(\"preview\")\npublic class X {\n    Zork z = null;\n    ABC abc = null;\n   public void foo () {\n      (new ABC()).doSomething();\n   }\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tZork z = null;\n\t^^^^\nZork cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 5)\n\tABC abc = null;\n\t^^^\nThis API is part of the preview feature 'Test Feature' which is disabled by default. Use --enable-preview to enable\n----------\n3. ERROR in X.java (at line 7)\n\t(new ABC()).doSomething();\n\t^^^^^^^^^^^^^^^^^^^^^^^^^\nThis API is part of the preview feature 'Test Feature' which is disabled by default. Use --enable-preview to enable\n----------\n4. ERROR in X.java (at line 7)\n\t(new ABC()).doSomething();\n\t     ^^^\nThis API is part of the preview feature 'Test Feature' which is disabled by default. Use --enable-preview to enable\n----------\n", classLibs, true, options);
        }
        finally {
            options.put("org.eclipse.jdt.core.compiler.problem.enablePreviewFeatures", old);
        }
    }

    public void test003() {
        if (this.complianceLevel < ClassFileConstants.getLatestJDKLevel()) {
            return;
        }
        Map<String, String> options = this.getCompilerOptions();
        String old = options.get("org.eclipse.jdt.core.compiler.problem.enablePreviewFeatures");
        options.put("org.eclipse.jdt.core.compiler.problem.enablePreviewFeatures", "enabled");
        String[] classLibs = this.getClasspathWithPreviewAPI();
        try {
            this.runNegativeTest(new String[]{"X.java", "import p.*;\npublic class X {\n    Zork z = null;\n    ABC abc = null;\n   public void foo () {\n      (new ABC()).doSomething();\n   }\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tZork z = null;\n\t^^^^\nZork cannot be resolved to a type\n----------\n2. WARNING in X.java (at line 4)\n\tABC abc = null;\n\t^^^\nYou are using an API that is part of the preview feature 'Test Feature' and may be removed in future\n----------\n3. WARNING in X.java (at line 6)\n\t(new ABC()).doSomething();\n\t^^^^^^^^^^^^^^^^^^^^^^^^^\nYou are using an API that is part of the preview feature 'Test Feature' and may be removed in future\n----------\n4. WARNING in X.java (at line 6)\n\t(new ABC()).doSomething();\n\t     ^^^\nYou are using an API that is part of the preview feature 'Test Feature' and may be removed in future\n----------\n", classLibs, true, options);
        }
        finally {
            options.put("org.eclipse.jdt.core.compiler.problem.enablePreviewFeatures", old);
        }
    }

    public void test004() {
        if (this.complianceLevel < ClassFileConstants.getLatestJDKLevel()) {
            return;
        }
        Map<String, String> options = this.getCompilerOptions();
        String old = options.get("org.eclipse.jdt.core.compiler.problem.enablePreviewFeatures");
        options.put("org.eclipse.jdt.core.compiler.problem.enablePreviewFeatures", "enabled");
        String[] classLibs = this.getClasspathWithPreviewAPI();
        try {
            this.runNegativeTest(new String[]{"X.java", "import p.*;\n@SuppressWarnings(\"preview\")\npublic class X {\n    Zork z = null;\n    ABC abc = null;\n   public void foo () {\n      (new ABC()).doSomething();\n   }\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tZork z = null;\n\t^^^^\nZork cannot be resolved to a type\n----------\n", classLibs, true, options);
        }
        finally {
            options.put("org.eclipse.jdt.core.compiler.problem.enablePreviewFeatures", old);
        }
    }

    public void test005() {
        if (this.complianceLevel < 0x3C0000L) {
            return;
        }
        Map<String, String> options = this.getCompilerOptions();
        String old = options.get("org.eclipse.jdt.core.compiler.problem.enablePreviewFeatures");
        if (this.complianceLevel == ClassFileConstants.getLatestJDKLevel()) {
            options.put("org.eclipse.jdt.core.compiler.problem.enablePreviewFeatures", "enabled");
        }
        try {
            if (this.complianceLevel < ClassFileConstants.getLatestJDKLevel()) {
                PreviewFeatureTest.assertFalse((boolean)JavaFeature.PRIMITIVES_IN_PATTERNS.isSupported(new CompilerOptions(options)));
            } else {
                PreviewFeatureTest.assertTrue((boolean)JavaFeature.PRIMITIVES_IN_PATTERNS.isSupported(new CompilerOptions(options)));
            }
        }
        finally {
            options.put("org.eclipse.jdt.core.compiler.problem.enablePreviewFeatures", old);
        }
    }
}

