/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.io.IOException;
import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest9;
import org.eclipse.jdt.core.tests.compiler.regression.DefaultJavaRuntimeEnvironment;
import org.eclipse.jdt.core.tests.compiler.regression.InMemoryNameEnvironment9;
import org.eclipse.jdt.core.tests.util.PreviewTest;
import org.eclipse.jdt.core.util.ClassFormatException;
import org.eclipse.jdt.internal.compiler.batch.FileSystem;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;

@PreviewTest
public class PreviewFlagTest
extends AbstractRegressionTest9 {
    private static final AbstractRegressionTest.JavacTestOptions JAVAC_OPTIONS = new AbstractRegressionTest.JavacTestOptions("--enable-preview -source 24");
    private static final String[] VMARGS = new String[]{"--enable-preview"};
    private String extraLibPath;

    public static Class<?> testClass() {
        return PreviewFlagTest.class;
    }

    public static Test suite() {
        return PreviewFlagTest.buildMinimalComplianceTestSuite(PreviewFlagTest.testClass(), 0x200000);
    }

    public PreviewFlagTest(String testName) {
        super(testName);
    }

    @Override
    protected void setUp() throws Exception {
        this.runJavacOptIn = true;
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        this.runJavacOptIn = false;
    }

    protected Map<String, String> getCompilerOptions(boolean preview) {
        Map<String, String> defaultOptions = super.getCompilerOptions();
        defaultOptions.put("org.eclipse.jdt.core.compiler.compliance", "24");
        defaultOptions.put("org.eclipse.jdt.core.compiler.source", "24");
        defaultOptions.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "24");
        defaultOptions.put("org.eclipse.jdt.core.compiler.problem.enablePreviewFeatures", preview ? "enabled" : "disabled");
        defaultOptions.put("org.eclipse.jdt.core.compiler.problem.reportPreviewFeatures", "warning");
        return defaultOptions;
    }

    @Override
    protected Map<String, String> getCompilerOptions() {
        return this.getCompilerOptions(false);
    }

    @Override
    protected String[] getDefaultClassPaths() {
        String[] libs = DefaultJavaRuntimeEnvironment.getDefaultClassPaths();
        if (this.extraLibPath != null) {
            String[] l = new String[libs.length + 1];
            System.arraycopy(libs, 0, l, 0, libs.length);
            l[libs.length] = this.extraLibPath;
            return l;
        }
        return libs;
    }

    @Override
    protected INameEnvironment getNameEnvironment(String[] testFiles, String[] classPaths, Map<String, String> options) {
        INameEnvironment[] classLibs;
        this.classpaths = classPaths == null ? this.getDefaultClassPaths() : classPaths;
        INameEnvironment[] iNameEnvironmentArray = classLibs = this.getClassLibs(false, options);
        int n = classLibs.length;
        int n2 = 0;
        while (n2 < n) {
            INameEnvironment nameEnvironment = iNameEnvironmentArray[n2];
            ((FileSystem)nameEnvironment).scanForModules(this.createParser());
            ++n2;
        }
        return new InMemoryNameEnvironment9(testFiles, this.moduleMap, classLibs);
    }

    @Override
    protected void runConformTest(String[] testFiles, String expectedOutput) {
        this.runConformTest(testFiles, expectedOutput, this.getCompilerOptions(true), VMARGS, JAVAC_OPTIONS);
    }

    @Override
    protected void runConformTest(String[] testFiles, String expectedOutput, Map<String, String> customOptions) {
        if (!isJRE22Plus) {
            return;
        }
        this.runConformTest(testFiles, expectedOutput, customOptions, VMARGS, JAVAC_OPTIONS);
    }

    @Override
    protected void runNegativeTest(String[] testFiles, String expectedCompilerLog) {
        Map<String, String> customOptions = this.getCompilerOptions(true);
        Runner runner = new Runner();
        runner.testFiles = testFiles;
        runner.expectedCompilerLog = expectedCompilerLog;
        runner.javacTestOptions = JAVAC_OPTIONS;
        runner.customOptions = customOptions;
        runner.expectedJavacOutputString = null;
        runner.runNegativeTest();
    }

    public void testIssue3614_001() throws IOException, ClassFormatException {
        this.runConformTest(new String[]{"X.java", "\tpublic class X {\n\t\tpublic static void main(String[] args) {\n\t\t\tScopedValue<Integer> si = ScopedValue.newInstance();\n\t\t\tSystem.out.println(si == null ? \"hello\" : \"world\");\n\t\t}\n\t}\n"}, "world");
        String expectedOutput = "version 24 : 68.65535";
        this.verifyClassFile(expectedOutput, "X.class", 4);
    }

    public void testIssue3614_002() throws IOException, ClassFormatException {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.enablePreviewFeatures", "disabled");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tScopedValue<Integer> si = ScopedValue.newInstance();\n\t\tSystem.out.println(si == null ? \"hello\" : \"world\");\n\t}\n\tpublic int foo() {}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tScopedValue<Integer> si = ScopedValue.newInstance();\n\t                          ^^^^^^^^^^^\nThis API is part of the preview feature 'Scoped Values' which is disabled by default. Use --enable-preview to enable\n----------\n2. ERROR in X.java (at line 6)\n\tpublic int foo() {}\n\t           ^^^^^\nThis method must return a result of type int\n----------\n", null, true, options);
    }

    public void testIssue3614_003() throws Exception {
        Runner runner = new Runner();
        runner.customOptions = this.getCompilerOptions(false);
        runner.javacTestOptions = AbstractRegressionTest.JavacTestOptions.DEFAULT;
        runner.testFiles = new String[]{"X.java", "import com.sun.source.tree.ImportTree;\npublic class X {\n\tboolean foo(ImportTree tree) {\n\t\treturn tree.isModule();\n\t}\n\tpublic static void main(String... args) {}\n}\n"};
        runner.expectedCompilerLog = "----------\n1. WARNING in X.java (at line 4)\n\treturn tree.isModule();\n\t       ^^^^^^^^^^^^^^^\nThis API is part of the preview feature 'Module Import Declarations' which is disabled by default. Use --enable-preview to enable\n----------\n";
        runner.runConformTest();
    }

    public void testIssue3614_003_enabled() throws Exception {
        Runner runner = new Runner();
        runner.customOptions = this.getCompilerOptions(true);
        runner.vmArguments = VMARGS;
        runner.javacTestOptions = JAVAC_OPTIONS;
        runner.testFiles = new String[]{"X.java", "import com.sun.source.tree.ImportTree;\npublic class X {\n\tboolean foo(ImportTree tree) {\n\t\treturn tree.isModule();\n\t}\n\tpublic void main(String... args) {\n\t\tSystem.out.print(42);\n\t}\n}\n"};
        runner.expectedCompilerLog = "----------\n1. WARNING in X.java (at line 4)\n\treturn tree.isModule();\n\t       ^^^^^^^^^^^^^^^\nYou are using an API that is part of the preview feature 'Module Import Declarations' and may be removed in future\n----------\n";
        runner.expectedOutputString = "42";
        runner.runConformTest();
    }

    public void testIssue3943_001() throws IOException, ClassFormatException {
        Map<String, String> options = this.getCompilerOptions();
        String str = options.get("org.eclipse.jdt.core.compiler.compliance");
        options.put("org.eclipse.jdt.core.compiler.compliance", "23");
        options.put("org.eclipse.jdt.core.compiler.source", "23");
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "23");
        options.put("org.eclipse.jdt.core.compiler.problem.enablePreviewFeatures", "disabled");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tScopedValue<Integer> si = ScopedValue.newInstance();\n\t\tSystem.out.println(si == null ? \"hello\" : \"world\");\n\t}\n\tpublic int foo() {}\n}\n"}, "----------\n1. WARNING in X.java (at line 3)\n\tScopedValue<Integer> si = ScopedValue.newInstance();\n\t                          ^^^^^^^^^^^\nYou are using an API that is part of the preview feature 'Scoped Values' and may be removed in future\n----------\n2. ERROR in X.java (at line 6)\n\tpublic int foo() {}\n\t           ^^^^^\nThis method must return a result of type int\n----------\n", null, true, options);
        options.put("org.eclipse.jdt.core.compiler.compliance", str);
        options.put("org.eclipse.jdt.core.compiler.source", str);
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", str);
        options.put("org.eclipse.jdt.core.compiler.problem.enablePreviewFeatures", "enabled");
    }

    public void testIssue3943_002() throws IOException, ClassFormatException {
        Map<String, String> options = this.getCompilerOptions();
        String str = options.get("org.eclipse.jdt.core.compiler.compliance");
        options.put("org.eclipse.jdt.core.compiler.compliance", "23");
        options.put("org.eclipse.jdt.core.compiler.source", "23");
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "23");
        options.put("org.eclipse.jdt.core.compiler.problem.enablePreviewFeatures", "disabled");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t@SuppressWarnings(\"preview\")\n\tpublic static void main(String[] args) {\n\t\tScopedValue<Integer> si = ScopedValue.newInstance();\n\t\tSystem.out.println(si == null ? \"hello\" : \"world\");\n\t}\n\tpublic int foo() {}\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tpublic int foo() {}\n\t           ^^^^^\nThis method must return a result of type int\n----------\n", null, true, options);
        options.put("org.eclipse.jdt.core.compiler.compliance", str);
        options.put("org.eclipse.jdt.core.compiler.source", str);
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", str);
        options.put("org.eclipse.jdt.core.compiler.problem.enablePreviewFeatures", "enabled");
    }

    class Runner
    extends AbstractRegressionTest.Runner {
        public Runner(boolean reportPreview) {
            this();
            this.customOptions.put("org.eclipse.jdt.core.compiler.problem.reportPreviewFeatures", reportPreview ? "warning" : "ignore");
        }

        public Runner() {
            this.vmArguments = VMARGS;
            this.javacTestOptions = JAVAC_OPTIONS;
            this.customOptions = PreviewFlagTest.this.getCompilerOptions();
            this.customOptions.put("org.eclipse.jdt.core.compiler.problem.enablePreviewFeatures", "enabled");
        }
    }
}

