/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest9;
import org.eclipse.jdt.core.tests.compiler.regression.DefaultJavaRuntimeEnvironment;
import org.eclipse.jdt.core.tests.compiler.regression.InMemoryNameEnvironment9;
import org.eclipse.jdt.core.tests.util.PreviewTest;
import org.eclipse.jdt.internal.compiler.batch.FileSystem;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;

@PreviewTest
public class PrimitiveInPatternsTest
extends AbstractRegressionTest9 {
    private static final AbstractRegressionTest.JavacTestOptions JAVAC_OPTIONS = new AbstractRegressionTest.JavacTestOptions("--enable-preview -source 24");
    private static final String[] VMARGS = new String[]{"--enable-preview"};
    private String extraLibPath;

    public static Class<?> testClass() {
        return PrimitiveInPatternsTest.class;
    }

    public static Test suite() {
        return PrimitiveInPatternsTest.buildMinimalComplianceTestSuite(PrimitiveInPatternsTest.testClass(), 0x200000);
    }

    public PrimitiveInPatternsTest(String testName) {
        super(testName);
    }

    @Override
    protected void setUp() throws Exception {
        this.runJavacOptIn = true;
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        this.runJavacOptIn = false;
    }

    protected Map<String, String> getCompilerOptions(boolean preview) {
        Map<String, String> defaultOptions = super.getCompilerOptions();
        defaultOptions.put("org.eclipse.jdt.core.compiler.compliance", "24");
        defaultOptions.put("org.eclipse.jdt.core.compiler.source", "24");
        defaultOptions.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "24");
        defaultOptions.put("org.eclipse.jdt.core.compiler.problem.enablePreviewFeatures", preview ? "enabled" : "disabled");
        defaultOptions.put("org.eclipse.jdt.core.compiler.problem.reportPreviewFeatures", "warning");
        return defaultOptions;
    }

    @Override
    protected Map<String, String> getCompilerOptions() {
        return this.getCompilerOptions(false);
    }

    @Override
    protected String[] getDefaultClassPaths() {
        String[] libs = DefaultJavaRuntimeEnvironment.getDefaultClassPaths();
        if (this.extraLibPath != null) {
            String[] l = new String[libs.length + 1];
            System.arraycopy(libs, 0, l, 0, libs.length);
            l[libs.length] = this.extraLibPath;
            return l;
        }
        return libs;
    }

    @Override
    protected INameEnvironment getNameEnvironment(String[] testFiles, String[] classPaths, Map<String, String> options) {
        INameEnvironment[] classLibs;
        this.classpaths = classPaths == null ? this.getDefaultClassPaths() : classPaths;
        INameEnvironment[] iNameEnvironmentArray = classLibs = this.getClassLibs(false, options);
        int n = classLibs.length;
        int n2 = 0;
        while (n2 < n) {
            INameEnvironment nameEnvironment = iNameEnvironmentArray[n2];
            ((FileSystem)nameEnvironment).scanForModules(this.createParser());
            ++n2;
        }
        return new InMemoryNameEnvironment9(testFiles, this.moduleMap, classLibs);
    }

    @Override
    protected void runConformTest(String[] testFiles, String expectedOutput) {
        this.runConformTest(testFiles, expectedOutput, this.getCompilerOptions(true), VMARGS, JAVAC_OPTIONS);
    }

    @Override
    protected void runConformTest(String[] testFiles, String expectedOutput, Map<String, String> customOptions) {
        if (!isJRE23Plus) {
            return;
        }
        this.runConformTest(testFiles, expectedOutput, customOptions, VMARGS, JAVAC_OPTIONS);
    }

    @Override
    protected void runConformTest(String[] testFiles, String expectedOutputString, String[] classLibraries, boolean shouldFlushOutputDirectory, String[] vmArguments) {
        this.runTest(shouldFlushOutputDirectory, testFiles, classLibraries, null, false, null, false, null, false, vmArguments, expectedOutputString, null, AbstractRegressionTest.JavacTestOptions.DEFAULT);
    }

    @Override
    protected void runNegativeTest(String[] testFiles, String expectedCompilerLog) {
        Map<String, String> customOptions = this.getCompilerOptions(true);
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.testFiles = testFiles;
        runner.expectedCompilerLog = expectedCompilerLog;
        runner.javacTestOptions = JAVAC_OPTIONS;
        runner.customOptions = customOptions;
        runner.expectedJavacOutputString = null;
        runner.runNegativeTest();
    }

    protected void runNegativeTest(String[] testFiles, String expectedCompilerLog, String javacLog, String[] classLibraries, boolean shouldFlushOutputDirectory, Map<String, String> customOptions) {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.testFiles = testFiles;
        runner.expectedCompilerLog = expectedCompilerLog;
        runner.javacTestOptions = JAVAC_OPTIONS;
        runner.customOptions = customOptions;
        runner.expectedJavacOutputString = javacLog;
        runner.runNegativeTest();
    }

    public void test001() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static byte foo(byte b) {\n\t\tif (b instanceof byte) {\n\t\t\treturn b;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static void main(String[] args) {\n\t\tbyte b = 1;\n\t\tSystem.out.println(X.foo(b));\n\t}\n}\n"}, "1");
    }

    public void test002() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static byte foo(byte b) {\n\t\tif (b instanceof byte bb) {\n\t\t\treturn bb;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static void main(String[] args) {\n\t\tbyte b = 1;\n\t\tSystem.out.println(X.foo(b));\n\t}\n}\n"}, "1");
    }

    public void test003() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static int foo(int i) {\n\t\tif (i instanceof int) {\n\t\t\treturn i;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static void main(String[] args) {\n\t\tint i = 1;\n\t\tSystem.out.println(X.foo(i));\n\t}\n}\n"}, "1");
    }

    public void test004() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static int foo(int i) {\n\t\tif (i instanceof int) {\n\t\t\treturn i;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static void main(String[] args) {\n\t\tint i = 1;\n\t\tSystem.out.println(X.foo(i));\n\t}\n}\n"}, "1");
    }

    public void test005() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static long foo(long l) {\n\t\tif (l instanceof long) {\n\t\t\treturn l;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static void main(String[] args) {\n\t\tlong l = 1L;\n\t\tSystem.out.println(X.foo(l));\n\t}\n}\n"}, "1");
    }

    public void test006() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static long foo(long l) {\n\t\tif (l instanceof long ll) {\n\t\t\treturn ll;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static void main(String[] args) {\n\t\tlong l = 1L;\n\t\tSystem.out.println(X.foo(l));\n\t}\n}\n"}, "1");
    }

    public void test007() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static float foo(float f) {\n\t\tif (f instanceof float) {\n\t\t\treturn f;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static void main(String[] args) {\n\t\tfloat f = 1.0f;\n\t\tSystem.out.println(X.foo(f));\n\t}\n}\n"}, "1.0");
    }

    public void test008() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static float foo(float f) {\n\t\tif (f instanceof float ff) {\n\t\t\treturn ff;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static void main(String[] args) {\n\t\tfloat f = 1.0f;\n\t\tSystem.out.println(X.foo(f));\n\t}\n}\n"}, "1.0");
    }

    public void test009() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static double foo(double d) {\n\t\tif (d instanceof double) {\n\t\t\treturn d;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static void main(String[] args) {\n\t\tdouble d = 1.0;\n\t\tSystem.out.println(X.foo(d));\n\t}\n}\n"}, "1.0");
    }

    public void test010() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static double foo(double d) {\n\t\tif (d instanceof double dd) {\n\t\t\treturn dd;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static void main(String[] args) {\n\t\tdouble d = 1.0;\n\t\tSystem.out.println(X.foo(d));\n\t}\n}\n"}, "1.0");
    }

    public void test011() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static byte foo() {\n\t\tif (bar() instanceof byte) {\n\t\t\tbyte b = (byte) bar();\n\t\t\treturn b;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static byte bar() {\n\t\tbyte b = 1;\n\t\treturn b;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(X.foo());\n\t}\n}\n"}, "1");
    }

    public void test012() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static byte foo() {\n\t\tif (bar() instanceof byte b) {\n\t\t\treturn b;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static byte bar() {\n\t\tbyte b = 1;\n\t\treturn b;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(X.foo());\n\t}\n}\n"}, "1");
    }

    public void test013() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static int foo() {\n\t\tif (bar() instanceof int) {\n\t\t\tint i = (int) bar();\n\t\t\treturn i;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static int bar() {\n\t\tint i = 1;\n\t\treturn i;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(X.foo());\n\t}\n}\n"}, "1");
    }

    public void test014() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static int foo() {\n\t\tif (bar() instanceof int i) {\n\t\t\treturn i;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static int bar() {\n\t\tint i = 1;\n\t\treturn i;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(X.foo());\n\t}\n}\n"}, "1");
    }

    public void test015() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static long foo() {\n\t\tif (bar() instanceof long) {\n\t\t\tlong l = (long) bar();\n\t\t\treturn l;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static long bar() {\n\t\treturn 1L;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(X.foo());\n\t}\n}\n"}, "1");
    }

    public void test016() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static long foo() {\n\t\tif (bar() instanceof long l) {\n\t\t\treturn l;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static long bar() {\n\t\treturn 1L;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(X.foo());\n\t}\n}\n"}, "1");
    }

    public void test017() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static float foo() {\n\t\tif (bar() instanceof float) {\n\t\t\tfloat f = (float) bar();\n\t\t\treturn f;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static float bar() {\n\t\tfloat f = 1.0f;\n\t\treturn f;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(X.foo());\n\t}\n}\n"}, "1.0");
    }

    public void test018() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static float foo() {\n\t\tif (bar() instanceof float f) {\n\t\t\treturn f;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static float bar() {\n\t\tfloat f = 1.0f;\n\t\treturn f;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(X.foo());\n\t}\n}\n"}, "1.0");
    }

    public void test019() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static double foo() {\n\t\tif (bar() instanceof double) {\n\t\t\tdouble d = (double) bar();\n\t\t\treturn d;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static double bar() {\n\t\tdouble d = 1.0d;\n\t\treturn d;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(X.foo());\n\t}\n}\n"}, "1.0");
    }

    public void test020() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static double foo() {\n\t\tif (bar() instanceof double) {\n\t\t\tdouble d = (double) bar();\n\t\t\treturn d;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static double bar() {\n\t\tdouble d = 1.0d;\n\t\treturn d;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(X.foo());\n\t}\n}\n"}, "1.0");
    }

    public void test021() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static short foo(byte b) {\n\t\tif (b instanceof short) {\n\t\t\tshort s = (short)b;\n\t\t\treturn s;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static void main(String[] args) {\n\t\tbyte b = 1;\n\t\tSystem.out.println(X.foo(b));\n\t}\n}\n"}, "1");
    }

    public void test022() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static short foo(byte b) {\n\t\tif (b instanceof short s) {\n\t\t\treturn s;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static void main(String[] args) {\n\t\tbyte b = 1;\n\t\tSystem.out.println(X.foo(b));\n\t}\n}\n"}, "1");
    }

    public void test023() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static int foo(byte b) {\n\t\tif (b instanceof int) {\n\t\t\tint i = (int)b;\n\t\t\treturn i;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static void main(String[] args) {\n\t\tbyte b = 1;\n\t\tSystem.out.println(X.foo(b));\n\t}\n}\n"}, "1");
    }

    public void test024() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static int foo(byte b) {\n\t\tif (b instanceof int i) {\n\t\t\treturn i;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static void main(String[] args) {\n\t\tbyte b = 1;\n\t\tSystem.out.println(X.foo(b));\n\t}\n}\n"}, "1");
    }

    public void test025() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static long foo(byte b) {\n\t\tif (b instanceof long) {\n\t\t\tlong l = (long)b;\n\t\t\treturn l;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static void main(String[] args) {\n\t\tbyte b = 1;\n\t\tSystem.out.println(X.foo(b));\n\t}\n}\n"}, "1");
    }

    public void test026() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static long foo(byte b) {\n\t\tif (b instanceof long l) {\n\t\t\treturn l;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static void main(String[] args) {\n\t\tbyte b = 1;\n\t\tSystem.out.println(X.foo(b));\n\t}\n}\n"}, "1");
    }

    public void test027() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static float foo(byte b) {\n\t\tif (b instanceof float) {\n\t\t\tfloat f = (float)b;\n\t\t\treturn f;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static void main(String[] args) {\n\t\tbyte b = 1;\n\t\tSystem.out.println(X.foo(b));\n\t}\n}\n"}, "1.0");
    }

    public void test028() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static float foo(byte b) {\n\t\tif (b instanceof float f) {\n\t\t\treturn f;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static void main(String[] args) {\n\t\tbyte b = 1;\n\t\tSystem.out.println(X.foo(b));\n\t}\n}\n"}, "1.0");
    }

    public void test029() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static double foo(byte b) {\n\t\tif (b instanceof double) {\n\t\t\tdouble d = (double)b;\n\t\t\treturn d;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static void main(String[] args) {\n\t\tbyte b = 1;\n\t\tSystem.out.println(X.foo(b));\n\t}\n}\n"}, "1.0");
    }

    public void test030() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static double foo(byte b) {\n\t\tif (b instanceof double d) {\n\t\t\treturn d;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static void main(String[] args) {\n\t\tbyte b = 1;\n\t\tSystem.out.println(X.foo(b));\n\t}\n}\n"}, "1.0");
    }

    public void test031() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static int foo(short s) {\n\t\tif (s instanceof int) {\n\t\t\tint i = (int) s;\n\t\t\treturn i;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static void main(String[] args) {\n\t\tshort s = 1;\n\t\tSystem.out.println(X.foo(s));\n\t}\n}\n"}, "1");
    }

    public void test032() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static int foo(short s) {\n\t\tif (s instanceof int i) {\n\t\t\treturn i;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static void main(String[] args) {\n\t\tshort s = 1;\n\t\tSystem.out.println(X.foo(s));\n\t}\n}\n"}, "1");
    }

    public void test033() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static long foo(short s) {\n\t\tif (s instanceof long) {\n\t\t\tlong l = (long)s;\n\t\t\treturn l;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static void main(String[] args) {\n\t\tshort s = 1;\n\t\tSystem.out.println(X.foo(s));\n\t}\n}\n"}, "1");
    }

    public void test034() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static long foo(short s) {\n\t\tif (s instanceof long l) {\n\t\t\treturn l;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static void main(String[] args) {\n\t\tshort s = 1;\n\t\tSystem.out.println(X.foo(s));\n\t}\n}\n"}, "1");
    }

    public void test035() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static float foo(short s) {\n\t\tif (s instanceof float) {\n\t\t\tfloat f = (float)s;\n\t\t\treturn f;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static void main(String[] args) {\n\t\tshort s = 1;\n\t\tSystem.out.println(X.foo(s));\n\t}\n}\n"}, "1.0");
    }

    public void test036() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static float foo(short s) {\n\t\tif (s instanceof float f) {\n\t\t\treturn f;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static void main(String[] args) {\n\t\tshort s = 1;\n\t\tSystem.out.println(X.foo(s));\n\t}\n}\n"}, "1.0");
    }

    public void test037() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static double foo(short s) {\n\t\tif (s instanceof double) {\n\t\t\tdouble d = (double)s;\n\t\t\treturn d;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static void main(String[] args) {\n\t\tshort s = 1;\n\t\tSystem.out.println(X.foo(s));\n\t}\n}\n"}, "1.0");
    }

    public void test038() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static double foo(short s) {\n\t\tif (s instanceof double d) {\n\t\t\treturn d;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static void main(String[] args) {\n\t\tshort s = 1;\n\t\tSystem.out.println(X.foo(s));\n\t}\n}\n"}, "1.0");
    }

    public void test039() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static int foo(char c) {\n\t\tif (c instanceof int) {\n\t\t\tint i = (int) c;\n\t\t\treturn i;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static void main(String[] args) {\n\t\tchar c = 1;\n\t\tSystem.out.println(X.foo(c));\n\t}\n}\n"}, "1");
    }

    public void test040() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static int foo(char c) {\n\t\tif (c instanceof int i) {\n\t\t\treturn i;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static void main(String[] args) {\n\t\tchar c = 1;\n\t\tSystem.out.println(X.foo(c));\n\t}\n}\n"}, "1");
    }

    public void test041() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static long foo(char c) {\n\t\tif (c instanceof long) {\n\t\t\tlong l = (long)c;\n\t\t\treturn l;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static void main(String[] args) {\n\t\tchar c = 1;\n\t\tSystem.out.println(X.foo(c));\n\t}\n}\n"}, "1");
    }

    public void test042() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static long foo(char c) {\n\t\tif (c instanceof long l) {\n\t\t\treturn l;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static void main(String[] args) {\n\t\tchar c = 1;\n\t\tSystem.out.println(X.foo(c));\n\t}\n}\n"}, "1");
    }

    public void test043() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static float foo(char c) {\n\t\tif (c instanceof float) {\n\t\t\tfloat f = (float)c;\n\t\t\treturn f;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static void main(String[] args) {\n\t\tchar c = 1;\n\t\tSystem.out.println(X.foo(c));\n\t}\n}\n"}, "1.0");
    }

    public void test044() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static float foo(char c) {\n\t\tif (c instanceof float f) {\n\t\t\treturn f;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static void main(String[] args) {\n\t\tchar c = 1;\n\t\tSystem.out.println(X.foo(c));\n\t}\n}\n"}, "1.0");
    }

    public void test045() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static double foo(char c) {\n\t\tif (c instanceof double) {\n\t\t\tdouble d = (double)c;\n\t\t\treturn d;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static void main(String[] args) {\n\t\tchar c = 1;\n\t\tSystem.out.println(X.foo(c));\n\t}\n}\n"}, "1.0");
    }

    public void test046() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static double foo(char c) {\n\t\tif (c instanceof double d) {\n\t\t\treturn d;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static void main(String[] args) {\n\t\tchar c = 1;\n\t\tSystem.out.println(X.foo(c));\n\t}\n}\n"}, "1.0");
    }

    public void test047() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static long foo(int i) {\n\t\tif (i instanceof long) {\n\t\t\tlong l = (long)i;\n\t\t\treturn l;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static void main(String[] args) {\n\t\tint i = 1;\n\t\tSystem.out.println(X.foo(i));\n\t}\n}\n"}, "1");
    }

    public void test048() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static long foo(int i) {\n\t\tif (i instanceof long l) {\n\t\t\treturn l;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static void main(String[] args) {\n\t\tint i = 1;\n\t\tSystem.out.println(X.foo(i));\n\t}\n}\n"}, "1");
    }

    public void test049() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static float foo(int i) {\n\t\tif (i instanceof float) {\n\t\t\tfloat f = (float)i;\n\t\t\treturn f;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static void main(String[] args) {\n\t\tint i = 1;\n\t\tSystem.out.println(X.foo(i));\n\t}\n}\n"}, "1.0");
    }

    public void test050() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static float foo(int i) {\n\t\tif (i instanceof float f) {\n\t\t\treturn f;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static void main(String[] args) {\n\t\tint i = 1;\n\t\tSystem.out.println(X.foo(i));\n\t}\n}\n"}, "1.0");
    }

    public void test051() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static double foo(int i) {\n\t\tif (i instanceof double) {\n\t\t\tdouble d = (double)i;\n\t\t\treturn d;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static void main(String[] args) {\n\t\tint i = 1;\n\t\tSystem.out.println(X.foo(i));\n\t}\n}\n"}, "1.0");
    }

    public void test052() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static double foo(int i) {\n\t\tif (i instanceof double d) {\n\t\t\treturn d;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static void main(String[] args) {\n\t\tint i = 1;\n\t\tSystem.out.println(X.foo(i));\n\t}\n}\n"}, "1.0");
    }

    public void test053() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static float foo(long l) {\n\t\tif (l instanceof float) {\n\t\t\tfloat f = (float)l;\n\t\t\treturn f;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static void main(String[] args) {\n\t\tlong l = 1;\n\t\tSystem.out.println(X.foo(l));\n\t}\n}\n"}, "1.0");
    }

    public void test054() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static float foo(long l) {\n\t\tif (l instanceof float f) {\n\t\t\treturn f;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static void main(String[] args) {\n\t\tlong l = 1;\n\t\tSystem.out.println(X.foo(l));\n\t}\n}\n"}, "1.0");
    }

    public void test055() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static double foo(long l) {\n\t\tif (l instanceof double) {\n\t\t\tdouble d = (double)l;\n\t\t\treturn d;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static void main(String[] args) {\n\t\tlong l = 1;\n\t\tSystem.out.println(X.foo(l));\n\t}\n}\n"}, "1.0");
    }

    public void test056() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static double foo(long l) {\n\t\tif (l instanceof double d) {\n\t\t\treturn d;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static void main(String[] args) {\n\t\tlong l = 1;\n\t\tSystem.out.println(X.foo(l));\n\t}\n}\n"}, "1.0");
    }

    public void test057() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static double foo(float f) {\n\t\tif (f instanceof double) {\n\t\t\tdouble d = (double)f;\n\t\t\treturn d;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static void main(String[] args) {\n\t\tfloat f = 1.0f;\n\t\tSystem.out.println(X.foo(f));\n\t}\n}\n"}, "1.0");
    }

    public void test058() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static double foo(float f) {\n\t\tif (f instanceof double d) {\n\t\t\treturn d;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static void main(String[] args) {\n\t\tfloat f = 1.0f;\n\t\tSystem.out.println(X.foo(f));\n\t}\n}\n"}, "1.0");
    }

    public void test059() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static float foo(int i) {\n\t\tif (i instanceof float) {\n\t\t\tfloat f = (float)i;\n\t\t\treturn f;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static void main(String[] args) {\n\t\tint i = 1234567890;\n\t\tSystem.out.println(X.foo(i));\n\t}\n}\n"}, "-1.0");
    }

    public void test060() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static float foo(int i) {\n\t\tif (i instanceof float f) {\n\t\t\treturn f;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static void main(String[] args) {\n\t\tint i = 1234567890;\n\t\tSystem.out.println(X.foo(i));\n\t}\n}\n"}, "-1.0");
    }

    public void test061() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static float foo(int i) {\n\t\tif (i instanceof float) {\n\t\t\tfloat f = (float)i;\n\t\t\treturn f;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static void main(String[] args) {\n\t\tint i = Integer.MAX_VALUE;\n\t\tSystem.out.println(X.foo(i));\n\t}\n}\n"}, "-1.0");
    }

    public void test062() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static float foo(int i) {\n\t\tif (i instanceof float f) {\n\t\t\treturn f;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static void main(String[] args) {\n\t\tint i = Integer.MAX_VALUE;\n\t\tSystem.out.println(X.foo(i));\n\t}\n}\n"}, "-1.0");
    }

    public void test063() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static short foo() {\n\t\tif (getByte() instanceof short) {\n\t\t\tshort s = (short) getByte();\n\t\t\treturn s;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static byte getByte() {\n\t\treturn 1;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(X.foo());\n\t}\n}\n"}, "1");
    }

    public void test064() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static short foo() {\n\t\tif (getByte() instanceof short s) {\n\t\t\treturn s;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static byte getByte() {\n\t\treturn 1;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(X.foo());\n\t}\n}\n"}, "1");
    }

    public void test065() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static int foo() {\n\t\tif (getByte()  instanceof int) {\n\t\t\tint i = (int)getByte() ;\n\t\t\treturn i;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static byte getByte() {\n\t\treturn 1;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(X.foo());\n\t}\n}\n"}, "1");
    }

    public void test066() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static int foo() {\n\t\tif (getByte()  instanceof int i) {\n\t\t\treturn i;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static byte getByte() {\n\t\treturn 1;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(X.foo());\n\t}\n}\n"}, "1");
    }

    public void test067() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static long foo() {\n\t\tif (getByte()  instanceof long) {\n\t\t\tlong l = (long)getByte() ;\n\t\t\treturn l;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static byte getByte() {\n\t\treturn 1;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(X.foo());\n\t}\n}\n"}, "1");
    }

    public void test068() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static long foo() {\n\t\tif (getByte()  instanceof long l) {\n\t\t\treturn l;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static byte getByte() {\n\t\treturn 1;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(X.foo());\n\t}\n}\n"}, "1");
    }

    public void test069() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static float foo() {\n\t\tif (getByte() instanceof float) {\n\t\t\tfloat f = (float)getByte() ;\n\t\t\treturn f;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static byte getByte() {\n\t\treturn 1;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(X.foo());\n\t}\n}\n"}, "1.0");
    }

    public void test070() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static float foo() {\n\t\tif (getByte()  instanceof float f) {\n\t\t\treturn f;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static byte getByte() {\n\t\treturn 1;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(X.foo());\n\t}\n}\n"}, "1.0");
    }

    public void test071() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static double foo() {\n\t\tif (getByte()  instanceof double) {\n\t\t\tdouble d = (double)getByte() ;\n\t\t\treturn d;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static byte getByte() {\n\t\treturn 1;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(X.foo());\n\t}\n}\n"}, "1.0");
    }

    public void test072() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static double foo() {\n\t\tif (getByte()  instanceof double d) {\n\t\t\treturn d;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static byte getByte() {\n\t\treturn 1;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(X.foo());\n\t}\n}\n"}, "1.0");
    }

    public void test073() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static int fooInt() {\n\t\tif (getShort() instanceof int) {\n\t\t\tint i = (int) getShort();\n\t\t\treturn i;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static long fooLong() {\n\t\tif (getShort() instanceof long) {\n\t\t\tlong l = (long)getShort();\n\t\t\treturn l;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static float fooFloat() {\n\t\tif (getShort() instanceof float) {\n\t\t\tfloat f = (float)getShort();\n\t\t\treturn f;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static double fooDouble() {\n\t\tif (getShort() instanceof double) {\n\t\t\tdouble d = (double)getShort();\n\t\t\treturn d;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static short getShort() {\n\t\treturn 1;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(X.fooInt());\n\t\tSystem.out.println(X.fooLong());\n\t\tSystem.out.println(X.fooFloat());\n\t\tSystem.out.println(X.fooDouble());\n\t}\n}\n"}, "1\n1\n1.0\n1.0");
    }

    public void test074() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static int fooInt() {\n\t\tif (getShort() instanceof int i) {\n\t\t\treturn i;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static long fooLong() {\n\t\tif (getShort() instanceof long l) {\n\t\t\treturn l;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static float fooFloat() {\n\t\tif (getShort() instanceof float f) {\n\t\t\treturn f;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static double fooDouble() {\n\t\tif (getShort() instanceof double d) {\n\t\t\treturn d;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static short getShort() {\n\t\treturn 1;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(X.fooInt());\n\t\tSystem.out.println(X.fooLong());\n\t\tSystem.out.println(X.fooFloat());\n\t\tSystem.out.println(X.fooDouble());\n\t}\n}\n"}, "1\n1\n1.0\n1.0");
    }

    public void test075() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static int fooInt() {\n\t\tif (getChar() instanceof int) {\n\t\t\tint i = (int) getChar();\n\t\t\treturn i;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static long fooLong() {\n\t\tif (getChar() instanceof long) {\n\t\t\tlong l = (long)getChar();\n\t\t\treturn l;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static float fooFloat() {\n\t\tif (getChar() instanceof float) {\n\t\t\tfloat f = (float)getChar();\n\t\t\treturn f;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static double fooDouble() {\n\t\tif (getChar() instanceof double) {\n\t\t\tdouble d = (double)getChar();\n\t\t\treturn d;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static char getChar() {\n\t\treturn (char)1;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(X.fooInt());\n\t\tSystem.out.println(X.fooLong());\n\t\tSystem.out.println(X.fooFloat());\n\t\tSystem.out.println(X.fooDouble());\n\t}\n}\n"}, "1\n1\n1.0\n1.0");
    }

    public void test076() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static int fooInt() {\n\t\tif (getChar() instanceof int i) {\n\t\t\treturn i;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static long fooLong() {\n\t\tif (getChar() instanceof long l) {\n\t\t\treturn l;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static float fooFloat() {\n\t\tif (getChar() instanceof float f) {\n\t\t\treturn f;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static double fooDouble() {\n\t\tif (getChar() instanceof double d) {\n\t\t\treturn d;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static char getChar() {\n\t\treturn (char)1;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(X.fooInt());\n\t\tSystem.out.println(X.fooLong());\n\t\tSystem.out.println(X.fooFloat());\n\t\tSystem.out.println(X.fooDouble());\n\t}\n}\n"}, "1\n1\n1.0\n1.0");
    }

    public void test077() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static long fooLong() {\n\t\tif (getInt() instanceof long) {\n\t\t\tlong l = (long)getInt();\n\t\t\treturn l;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static float fooFloat() {\n\t\tif (getInt() instanceof float) {\n\t\t\tfloat f = (float)getInt();\n\t\t\treturn f;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static double fooDouble() {\n\t\tif (getInt() instanceof double) {\n\t\t\tdouble d = (double)getInt();\n\t\t\treturn d;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static int getInt() {\n\t\treturn 1;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(X.fooLong());\n\t\tSystem.out.println(X.fooFloat());\n\t\tSystem.out.println(X.fooDouble());\n\t}\n}\n"}, "1\n1.0\n1.0");
    }

    public void test078() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static long fooLong() {\n\t\tif (getInt() instanceof long l) {\n\t\t\treturn l;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static float fooFloat() {\n\t\tif (getInt() instanceof float f) {\n\t\t\treturn f;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static double fooDouble() {\n\t\tif (getInt() instanceof double d) {\n\t\t\treturn d;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static int getInt() {\n\t\treturn 1;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(X.fooLong());\n\t\tSystem.out.println(X.fooFloat());\n\t\tSystem.out.println(X.fooDouble());\n\t}\n}\n"}, "1\n1.0\n1.0");
    }

    public void test079() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static float fooFloat() {\n\t\tif (getLong() instanceof float) {\n\t\t\tfloat f = (float)getLong();\n\t\t\treturn f;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static double fooDouble() {\n\t\tif (getLong() instanceof double) {\n\t\t\tdouble d = (double) getLong();\n\t\t\treturn d;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static long getLong() {\n\t\treturn 1L;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(X.fooFloat());\n\t\tSystem.out.println(X.fooDouble());\n\t}\n}\n"}, "1.0\n1.0");
    }

    public void test080() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static float fooFloat() {\n\t\tif (getLong() instanceof float f) {\n\t\t\treturn f;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static double fooDouble() {\n\t\tif (getLong() instanceof double d) {\n\t\t\treturn d;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static long getLong() {\n\t\treturn 1L;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(X.fooFloat());\n\t\tSystem.out.println(X.fooDouble());\n\t}\n}\n"}, "1.0\n1.0");
    }

    public void test081() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static double fooDouble() {\n\t\tif (getFloat() instanceof double) {\n\t\t\tdouble d = (double) getFloat();\n\t\t\treturn d;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static float getFloat() {\n\t\treturn 1.0f;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(X.fooDouble());\n\t}\n}\n"}, "1.0");
    }

    public void test082() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static double fooDouble() {\n\t\tif (getFloat() instanceof double d) {\n\t\t\treturn d;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static float getFloat() {\n\t\treturn 1.0f;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(X.fooDouble());\n\t}\n}\n"}, "1.0");
    }

    public void test083() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static float foo(int i) {\n\t\tif (i instanceof float) {\n\t\t\tfloat f = (float)i;\n\t\t\treturn f;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static void main(String[] args) {\n\t\tint i = 1234567890;\n\t\tSystem.out.println(X.foo(i));\n\t}\n}\n"}, "-1.0");
    }

    public void test084() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static float foo(int i) {\n\t\tif (i instanceof float f) {\n\t\t\treturn f;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static void main(String[] args) {\n\t\tint i = 1234567890;\n\t\tSystem.out.println(X.foo(i));\n\t}\n}\n"}, "-1.0");
    }

    public void test085() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static float foo(int i) {\n\t\tif (i instanceof float) {\n\t\t\tfloat f = (float)i;\n\t\t\treturn f;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static void main(String[] args) {\n\t\tint i = Integer.MAX_VALUE;\n\t\tSystem.out.println(X.foo(i));\n\t}\n}\n"}, "-1.0");
    }

    public void test086() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static float foo(int i) {\n\t\tif (i instanceof float f) {\n\t\t\treturn f;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static void main(String[] args) {\n\t\tint i = Integer.MAX_VALUE;\n\t\tSystem.out.println(X.foo(i));\n\t}\n}\n"}, "-1.0");
    }

    public void test087() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static byte d2b(double d) {\n\t\tif (d instanceof byte) {\n\t\t\tbyte r = (byte) d;\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tpublic static short d2s(double d) {\n\t\tif (d instanceof short) {\n\t\t\tshort r = (short) d;\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tpublic static char d2c(double d) {\n\t\tif (d instanceof char) {\n\t\t\tchar r = (char) d;\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tpublic static int d2i(double d) {\n\t\tif (d instanceof int) {\n\t\t\tint r = (int) d;\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tpublic static long d2l(double d) {\n\t\tif (d instanceof long) {\n\t\t\tlong r = (long) d;\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tpublic static float d2f(double d) {\n\t\tif (d instanceof float) {\n\t\t\tfloat r = (float) d;\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tpublic static void main(String[] args) {\n\t\tdouble d = 49;\n\t\tSystem.out.println(X.d2b(d));\n\t\tSystem.out.println(X.d2s(d));\n\t\tSystem.out.println(X.d2c(d));\n\t\tSystem.out.println(X.d2i(d));\n\t\tSystem.out.println(X.d2l(d));\n\t\tSystem.out.println(X.d2f(d));\n\t}\n}\n"}, "49\n49\n1\n49\n49\n49.0");
    }

    public void test088() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static byte d2b(double d) {\n\t\tif (d instanceof byte r) {\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tpublic static short d2s(double d) {\n\t\tif (d instanceof short r) {\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tpublic static char d2c(double d) {\n\t\tif (d instanceof char r) {\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tpublic static int d2i(double d) {\n\t\tif (d instanceof int r) {\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tpublic static long d2l(double d) {\n\t\tif (d instanceof long r) {\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tpublic static float d2f(double d) {\n\t\tif (d instanceof float r) {\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tpublic static void main(String[] args) {\n\t\tdouble d = 49;\n\t\tSystem.out.println(X.d2b(d));\n\t\tSystem.out.println(X.d2s(d));\n\t\tSystem.out.println(X.d2c(d));\n\t\tSystem.out.println(X.d2i(d));\n\t\tSystem.out.println(X.d2l(d));\n\t\tSystem.out.println(X.d2f(d));\n\t}\n}\n"}, "49\n49\n1\n49\n49\n49.0");
    }

    public void test089() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static byte d2b() {\n\t\tif (getDouble() instanceof byte) {\n\t\t\tbyte r = (byte) getDouble();\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tpublic static short d2s() {\n\t\tif (getDouble() instanceof short) {\n\t\t\tshort r = (short) getDouble();\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tpublic static char d2c() {\n\t\tif (getDouble() instanceof char) {\n\t\t\tchar r = (char) getDouble();\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tpublic static int d2i() {\n\t\tif (getDouble() instanceof int) {\n\t\t\tint r = (int) getDouble();\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tpublic static long d2l() {\n\t\tif (getDouble() instanceof long) {\n\t\t\tlong r = (long) getDouble();\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tpublic static float d2f() {\n\t\tif (getDouble() instanceof float) {\n\t\t\tfloat r = (float) getDouble();\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tprivate static double getDouble() {\n\t\treturn 49;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(X.d2b());\n\t\tSystem.out.println(X.d2s());\n\t\tSystem.out.println(X.d2c());\n\t\tSystem.out.println(X.d2i());\n\t\tSystem.out.println(X.d2l());\n\t\tSystem.out.println(X.d2f());\n\t}\n}\n"}, "49\n49\n1\n49\n49\n49.0");
    }

    public void test090() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static byte d2b() {\n\t\tif (getDouble() instanceof byte r) {\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tpublic static short d2s() {\n\t\tif (getDouble() instanceof short r) {\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tpublic static char d2c() {\n\t\tif (getDouble() instanceof char r) {\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tpublic static int d2i() {\n\t\tif (getDouble() instanceof int r) {\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tpublic static long d2l() {\n\t\tif (getDouble() instanceof long r) {\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tpublic static float d2f() {\n\t\tif (getDouble() instanceof float r) {\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tprivate static double getDouble() {\n\t\treturn 49;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(X.d2b());\n\t\tSystem.out.println(X.d2s());\n\t\tSystem.out.println(X.d2c());\n\t\tSystem.out.println(X.d2i());\n\t\tSystem.out.println(X.d2l());\n\t\tSystem.out.println(X.d2f());\n\t}\n}\n"}, "49\n49\n1\n49\n49\n49.0");
    }

    public void test091() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static byte f2b(float f) {\n\t\tif (f instanceof byte) {\n\t\t\tbyte r = (byte) f;\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tpublic static short f2s(float f) {\n\t\tif (f instanceof short) {\n\t\t\tshort r = (short) f;\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tpublic static char f2c(float f) {\n\t\tif (f instanceof char) {\n\t\t\tchar r = (char) f;\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tpublic static int f2i(float f) {\n\t\tif (f instanceof int) {\n\t\t\tint r = (int) f;\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tpublic static long f2l(float f) {\n\t\tif (f instanceof long) {\n\t\t\tlong r = (long) f;\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tpublic static float f2f(float f) {\n\t\tif (f instanceof float) {\n\t\t\tfloat r = (float) f;\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tpublic static void main(String[] args) {\n\t\tfloat f = 49;\n\t\tSystem.out.println(X.f2b(f));\n\t\tSystem.out.println(X.f2s(f));\n\t\tSystem.out.println(X.f2c(f));\n\t\tSystem.out.println(X.f2i(f));\n\t\tSystem.out.println(X.f2l(f));\n\t\tSystem.out.println(X.f2f(f));\n\n\t}\n}\n"}, "49\n49\n1\n49\n49\n49.0");
    }

    public void test092() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static byte f2b(float f) {\n\t\tif (f instanceof byte r) {\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tpublic static short f2s(float f) {\n\t\tif (f instanceof short r) {\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tpublic static char f2c(float f) {\n\t\tif (f instanceof char r) {\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tpublic static int f2i(float f) {\n\t\tif (f instanceof int r) {\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tpublic static long f2l(float f) {\n\t\tif (f instanceof long r) {\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tpublic static void main(String[] args) {\n\t\tfloat f = 49;\n\t\tSystem.out.println(X.f2b(f));\n\t\tSystem.out.println(X.f2s(f));\n\t\tSystem.out.println(X.f2c(f));\n\t\tSystem.out.println(X.f2i(f));\n\t\tSystem.out.println(X.f2l(f));\n\t}\n}\n"}, "49\n49\n1\n49\n49");
    }

    public void test093() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static byte f2b() {\n\t\tif (getFloat() instanceof byte) {\n\t\t\tbyte r = (byte) getFloat();\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tpublic static short f2s() {\n\t\tif (getFloat() instanceof short) {\n\t\t\tshort r = (short) getFloat();\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tpublic static char f2c() {\n\t\tif (getFloat() instanceof char) {\n\t\t\tchar r = (char) getFloat();\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tpublic static int f2i() {\n\t\tif (getFloat() instanceof int) {\n\t\t\tint r = (int) getFloat();\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tpublic static long f2l() {\n\t\tif (getFloat() instanceof long) {\n\t\t\tlong r = (long) getFloat();\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tprivate static float getFloat() {\n\t\treturn 49;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(X.f2b());\n\t\tSystem.out.println(X.f2s());\n\t\tSystem.out.println(X.f2c());\n\t\tSystem.out.println(X.f2i());\n\t\tSystem.out.println(X.f2l());\n\t}\n}\n"}, "49\n49\n1\n49\n49");
    }

    public void test094() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static byte f2b() {\n\t\tif (getFloat() instanceof byte r) {\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tpublic static short f2s() {\n\t\tif (getFloat() instanceof short r) {\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tpublic static char f2c() {\n\t\tif (getFloat() instanceof char r) {\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tpublic static int f2i() {\n\t\tif (getFloat() instanceof int r) {\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tpublic static long f2l() {\n\t\tif (getFloat() instanceof long r) {\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tprivate static float getFloat() {\n\t\treturn 49;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(X.f2b());\n\t\tSystem.out.println(X.f2s());\n\t\tSystem.out.println(X.f2c());\n\t\tSystem.out.println(X.f2i());\n\t\tSystem.out.println(X.f2l());\n\t}\n}\n"}, "49\n49\n1\n49\n49");
    }

    public void test095() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static byte l2b(long l) {\n\t\tif (l instanceof byte) {\n\t\t\tbyte r = (byte) l;\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tpublic static short l2s(long l) {\n\t\tif (l instanceof short) {\n\t\t\tshort r = (short) l;\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tpublic static char l2c(long l) {\n\t\tif (l instanceof char) {\n\t\t\tchar r = (char) l;\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tpublic static int l2i(long l) {\n\t\tif (l instanceof int) {\n\t\t\tint r = (int) l;\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tpublic static void main(String[] args) {\n\t\tlong l = 49;\n\t\tSystem.out.println(X.l2b(l));\n\t\tSystem.out.println(X.l2s(l));\n\t\tSystem.out.println(X.l2c(l));\n\t\tSystem.out.println(X.l2i(l));\n\n\t}\n}\n"}, "49\n49\n1\n49");
    }

    public void test096() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static byte l2b(long l) {\n\t\tif (l instanceof byte r) {\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tpublic static short l2s(long l) {\n\t\tif (l instanceof short r) {\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tpublic static char l2c(long l) {\n\t\tif (l instanceof char r) {\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tpublic static int l2i(long l) {\n\t\tif (l instanceof int r) {\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tpublic static void main(String[] args) {\n\t\tlong l = 49;\n\t\tSystem.out.println(X.l2b(l));\n\t\tSystem.out.println(X.l2s(l));\n\t\tSystem.out.println(X.l2c(l));\n\t\tSystem.out.println(X.l2i(l));\n\t}\n}\n"}, "49\n49\n1\n49");
    }

    public void test097() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static byte l2b() {\n\t\tif (getLong() instanceof byte) {\n\t\t\tbyte r = (byte) getLong();\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tpublic static short l2s() {\n\t\tif (getLong() instanceof short) {\n\t\t\tshort r = (short) getLong();\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tpublic static char l2c() {\n\t\tif (getLong() instanceof char) {\n\t\t\tchar r = (char) getLong();\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tpublic static int l2i() {\n\t\tif (getLong() instanceof int) {\n\t\t\tint r = (int) getLong();\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tprivate static long getLong() {\n\t\treturn 49;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(X.l2b());\n\t\tSystem.out.println(X.l2s());\n\t\tSystem.out.println(X.l2c());\n\t\tSystem.out.println(X.l2i());\n\t}\n}\n"}, "49\n49\n1\n49");
    }

    public void test098() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static byte l2b() {\n\t\tif (getLong() instanceof byte r) {\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tpublic static short l2s() {\n\t\tif (getLong() instanceof short r) {\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tpublic static char l2c() {\n\t\tif (getLong() instanceof char r) {\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tpublic static int l2i() {\n\t\tif (getLong() instanceof int r) {\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tprivate static long getLong() {\n\t\treturn 49;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(X.l2b());\n\t\tSystem.out.println(X.l2s());\n\t\tSystem.out.println(X.l2c());\n\t\tSystem.out.println(X.l2i());\n\t}\n}\n"}, "49\n49\n1\n49");
    }

    public void test099() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static byte i2b(int i) {\n\t\tif (i instanceof byte) {\n\t\t\tbyte r = (byte) i;\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tpublic static short i2s(int i) {\n\t\tif (i instanceof short) {\n\t\t\tshort r = (short) i;\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tpublic static char i2c(int i) {\n\t\tif (i instanceof char) {\n\t\t\tchar r = (char) i;\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tpublic static void main(String[] args) {\n\t\tint i = 49;\n\t\tSystem.out.println(X.i2b(i));\n\t\tSystem.out.println(X.i2s(i));\n\t\tSystem.out.println(X.i2c(i));\n\n\t}\n}\n"}, "49\n49\n1");
    }

    public void test100() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static byte i2b(int i) {\n\t\tif (i instanceof byte r) {\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tpublic static short i2s(int i) {\n\t\tif (i instanceof short r) {\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tpublic static char i2c(int i) {\n\t\tif (i instanceof char r) {\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tpublic static void main(String[] args) {\n\t\tint i = 49;\n\t\tSystem.out.println(X.i2b(i));\n\t\tSystem.out.println(X.i2s(i));\n\t\tSystem.out.println(X.i2c(i));\n\t}\n}\n"}, "49\n49\n1");
    }

    public void test101() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static byte i2b() {\n\t\tif (getInt() instanceof byte) {\n\t\t\tbyte r = (byte) getInt();\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tpublic static short i2s() {\n\t\tif (getInt() instanceof short) {\n\t\t\tshort r = (short) getInt();\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tpublic static char i2c() {\n\t\tif (getInt() instanceof char) {\n\t\t\tchar r = (char) getInt();\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tprivate static int getInt() {\n\t\treturn 49;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(X.i2b());\n\t\tSystem.out.println(X.i2s());\n\t\tSystem.out.println(X.i2c());\n\t}\n}\n"}, "49\n49\n1");
    }

    public void test102() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static byte i2b() {\n\t\tif (getInt() instanceof byte r) {\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tpublic static short i2s() {\n\t\tif (getInt() instanceof short r) {\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tpublic static char i2c() {\n\t\tif (getInt() instanceof char r) {\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tprivate static int getInt() {\n\t\treturn 49;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(X.i2b());\n\t\tSystem.out.println(X.i2s());\n\t\tSystem.out.println(X.i2c());\n\t}\n}\n"}, "49\n49\n1");
    }

    public void test103() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static byte c2b(char c) {\n\t\tif (c instanceof byte) {\n\t\t\tbyte r = (byte) c;\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tpublic static short c2s(char c) {\n\t\tif (c instanceof short) {\n\t\t\tshort r = (short) c;\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tpublic static void main(String[] args) {\n\t\tchar c = 49;\n\t\tSystem.out.println(X.c2b(c));\n\t\tSystem.out.println(X.c2s(c));\n\n\t}\n}\n"}, "49\n49");
    }

    public void test104() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static byte c2b(char c) {\n\t\tif (c instanceof byte r) {\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tpublic static short c2s(char c) {\n\t\tif (c instanceof short r) {\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tpublic static void main(String[] args) {\n\t\tchar c = 49;\n\t\tSystem.out.println(X.c2b(c));\n\t\tSystem.out.println(X.c2s(c));\n\t}\n}\n"}, "49\n49");
    }

    public void test105() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static byte c2b() {\n\t\tif (getChar() instanceof byte) {\n\t\t\tbyte r = (byte) getChar();\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tpublic static short c2s() {\n\t\tif (getChar() instanceof short) {\n\t\t\tshort r = (short) getChar();\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tprivate static char getChar() {\n\t\treturn 49;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(X.c2b());\n\t\tSystem.out.println(X.c2s());\n\t}\n}\n"}, "49\n49");
    }

    public void test106() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static byte c2b() {\n\t\tif (getChar() instanceof byte r) {\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tpublic static short c2s() {\n\t\tif (getChar() instanceof short r) {\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tprivate static char getChar() {\n\t\treturn 49;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(X.c2b());\n\t\tSystem.out.println(X.c2s());\n\t}\n}\n"}, "49\n49");
    }

    public void test107() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static byte s2b(short s) {\n\t\tif (s instanceof byte) {\n\t\t\tbyte r = (byte) s;\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tpublic static char s2c(short s) {\n\t\tif (s instanceof char) {\n\t\t\tchar r = (char) s;\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tpublic static void main(String[] args) {\n\t\tshort s = 49;\n\t\tSystem.out.println(X.s2b(s));\n\t\tSystem.out.println(X.s2c(s));\n\n\t}\n}\n"}, "49\n1");
    }

    public void test108() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static byte s2b(short s) {\n\t\tif (s instanceof byte r) {\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tpublic static char s2c(short s) {\n\t\tif (s instanceof char r) {\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tpublic static void main(String[] args) {\n\t\tshort s = 49;\n\t\tSystem.out.println(X.s2b(s));\n\t\tSystem.out.println(X.s2c(s));\n\t}\n}\n"}, "49\n1");
    }

    public void test109() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static byte s2b() {\n\t\tif (getShort() instanceof byte) {\n\t\t\tbyte r = (byte) getShort();\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tpublic static char s2c() {\n\t\tif (getShort() instanceof char) {\n\t\t\tchar r = (char) getShort();\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tprivate static short getShort() {\n\t\treturn 49;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(X.s2b());\n\t\tSystem.out.println(X.s2c());\n\t}\n}\n"}, "49\n1");
    }

    public void test110() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static byte s2b() {\n\t\tif (getShort() instanceof byte r) {\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tpublic static char s2c() {\n\t\tif (getShort() instanceof char r) {\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tprivate static short getShort() {\n\t\treturn 49;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(X.s2b());\n\t\tSystem.out.println(X.s2c());\n\t}\n}\n"}, "49\n1");
    }

    public void test111() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static char b2c(byte b) {\n\t\tif (b instanceof char) {\n\t\t\tchar r = (char) b;\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tpublic static void main(String[] args) {\n\t\tbyte b = 49;\n\t\tSystem.out.println(X.b2c(b));\n\n\t}\n}\n"}, "1");
    }

    public void test112() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static char b2c(byte b) {\n\t\tif (b instanceof char r) {\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tpublic static void main(String[] args) {\n\t\tbyte b = 49;\n\t\tSystem.out.println(X.b2c(b));\n\t}\n}\n"}, "1");
    }

    public void test113() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static char b2c() {\n\t\tif (getByte() instanceof char) {\n\t\t\tchar r = (char) getByte();\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tprivate static byte getByte() {\n\t\treturn 49;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(X.b2c());\n\t}\n}\n"}, "1");
    }

    public void test114() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static char b2c() {\n\t\tif (getByte() instanceof char r) {\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tprivate static byte getByte() {\n\t\treturn 49;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(X.b2c());\n\t}\n}\n"}, "1");
    }

    public void test115() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static Boolean boolean2Boolean(boolean b) {\n\t\tif (b instanceof Boolean) {\n\t\t\tBoolean r = (Boolean) b;\n\t\t\treturn r;\n\t\t}\n\t\treturn Boolean.FALSE;\n\t}\n\tpublic static void main(String[] args) {\n\t\tboolean b = true;\n\t\tSystem.out.println(X.boolean2Boolean(b));\n\n\t}\n}\n"}, "true");
    }

    public void test116() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static Boolean boolean2Boolean(boolean b) {\n\t\tif (b instanceof Boolean r) {\n\t\t\treturn r;\n\t\t}\n\t\treturn Boolean.FALSE;\n\t}\n\tpublic static void main(String[] args) {\n\t\tboolean b = true;\n\t\tSystem.out.println(X.boolean2Boolean(b));\n\t}\n}\n"}, "true");
    }

    public void test117() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static Boolean boolean2Boolean() {\n\t\tif (getboolean() instanceof Boolean) {\n\t\t\tBoolean r = (Boolean) getboolean();\n\t\t\treturn r;\n\t\t}\n\t\treturn Boolean.FALSE;\n\t}\n\tprivate static boolean getboolean() {\n\t\treturn true;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(X.boolean2Boolean());\n\t}\n}\n"}, "true");
    }

    public void test118() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static Boolean boolean2Boolean() {\n\t\tif (getboolean() instanceof Boolean r) {\n\t\t\treturn r;\n\t\t}\n\t\treturn Boolean.FALSE;\n\t}\n\tprivate static boolean getboolean() {\n\t\treturn true;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(X.boolean2Boolean());\n\t}\n}\n"}, "true");
    }

    public void test119() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static Byte byte2Byte(byte b) {\n\t\tif (b instanceof Byte) {\n\t\t\tByte r = (Byte) b;\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tpublic static void main(String[] args) {\n\t\tbyte b = 49;\n\t\tSystem.out.println(X.byte2Byte(b));\n\n\t}\n}\n"}, "49");
    }

    public void test120() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static Byte byte2Byte(byte b) {\n\t\tif (b instanceof Byte r) {\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tpublic static void main(String[] args) {\n\t\tbyte b = 49;\n\t\tSystem.out.println(X.byte2Byte(b));\n\t}\n}\n"}, "49");
    }

    public void test121() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static Byte byte2Byte() {\n\t\tif (getbyte() instanceof Byte) {\n\t\t\tByte r = (Byte) getbyte();\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tprivate static byte getbyte() {\n\t\treturn 49;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(X.byte2Byte());\n\t}\n}\n"}, "49");
    }

    public void test122() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static Byte byte2Byte() {\n\t\tif (getbyte() instanceof Byte r) {\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tprivate static byte getbyte() {\n\t\treturn 49;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(X.byte2Byte());\n\t}\n}\n"}, "49");
    }

    public void test123() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static Short short2Short(short s) {\n\t\tif (s instanceof Short) {\n\t\t\tShort r = (Short) s;\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tpublic static void main(String[] args) {\n\t\tshort s = 49;\n\t\tSystem.out.println(X.short2Short(s));\n\n\t}\n}\n"}, "49");
    }

    public void test124() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static Short short2Short(short s) {\n\t\tif (s instanceof Short r) {\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tpublic static void main(String[] args) {\n\t\tshort s = 49;\n\t\tSystem.out.println(X.short2Short(s));\n\t}\n}\n"}, "49");
    }

    public void test125() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static Short short2Short() {\n\t\tif (getshort() instanceof Short) {\n\t\t\tShort r = (Short) getshort();\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tprivate static short getshort() {\n\t\treturn 49;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(X.short2Short());\n\t}\n}\n"}, "49");
    }

    public void test126() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static Short short2Short() {\n\t\tif (getshort() instanceof Short r) {\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tprivate static short getshort() {\n\t\treturn 49;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(X.short2Short());\n\t}\n}\n"}, "49");
    }

    public void test127() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static Character char2Character(char c) {\n\t\tif (c instanceof Character) {\n\t\t\tCharacter r = (Character) c;\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tpublic static void main(String[] args) {\n\t\tchar c = 49;\n\t\tSystem.out.println(X.char2Character(c));\n\n\t}\n}\n"}, "1");
    }

    public void test128() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static Character char2Character(char c) {\n\t\tif (c instanceof Character r) {\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tpublic static void main(String[] args) {\n\t\tchar c = 49;\n\t\tSystem.out.println(X.char2Character(c));\n\t}\n}\n"}, "1");
    }

    public void test129() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static Character char2Character() {\n\t\tif (getChar() instanceof Character) {\n\t\t\tCharacter r = (Character) getChar();\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tprivate static char getChar() {\n\t\treturn 49;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(X.char2Character());\n\t}\n}\n"}, "1");
    }

    public void test130() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static Character char2Character() {\n\t\tif (getChar() instanceof Character r) {\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tprivate static char getChar() {\n\t\treturn 49;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(X.char2Character());\n\t}\n}\n"}, "1");
    }

    public void test131() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static Integer int2Integer(int i) {\n\t\tif (i instanceof Integer) {\n\t\t\tInteger r = (Integer) i;\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tpublic static void main(String[] args) {\n\t\tint i = 49;\n\t\tSystem.out.println(X.int2Integer(i));\n\n\t}\n}\n"}, "49");
    }

    public void test132() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static Integer int2Integer(int i) {\n\t\tif (i instanceof Integer r) {\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tpublic static void main(String[] args) {\n\t\tint i = 49;\n\t\tSystem.out.println(X.int2Integer(i));\n\t}\n}\n"}, "49");
    }

    public void test133() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static Integer int2Integer() {\n\t\tif (getInt() instanceof Integer) {\n\t\t\tInteger r = (Integer) getInt();\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tprivate static int getInt() {\n\t\treturn 49;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(X.int2Integer());\n\t}\n}\n"}, "49");
    }

    public void test134() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static Integer int2Integer() {\n\t\tif (getInteger() instanceof Integer r) {\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tprivate static int getInteger() {\n\t\treturn 49;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(X.int2Integer());\n\t}\n}\n"}, "49");
    }

    public void test135() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static Long long2Long(long l) {\n\t\tif (l instanceof Long) {\n\t\t\tLong r = (Long) l;\n\t\t\treturn r;\n\t\t}\n\t\treturn 0L;\n\t}\n\tpublic static void main(String[] args) {\n\t\tlong l = 49;\n\t\tSystem.out.println(X.long2Long(l));\n\n\t}\n}\n"}, "49");
    }

    public void test136() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static Long long2Long(long l) {\n\t\tif (l instanceof Long r) {\n\t\t\treturn r;\n\t\t}\n\t\treturn 0L;\n\t}\n\tpublic static void main(String[] args) {\n\t\tlong l = 49;\n\t\tSystem.out.println(X.long2Long(l));\n\t}\n}\n"}, "49");
    }

    public void test137() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static Long long2Long() {\n\t\tif (getLong() instanceof Long) {\n\t\t\tLong r = (Long) getLong();\n\t\t\treturn r;\n\t\t}\n\t\treturn 0L;\n\t}\n\tprivate static long getLong() {\n\t\treturn 49L;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(X.long2Long());\n\t}\n}\n"}, "49");
    }

    public void test138() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static Long long2Long() {\n\t\tif (getLong() instanceof Long r) {\n\t\t\treturn r;\n\t\t}\n\t\treturn 0L;\n\t}\n\tprivate static long getLong() {\n\t\treturn 49L;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(X.long2Long());\n\t}\n}\n"}, "49");
    }

    public void test139() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static Float float2Float(float f) {\n\t\tif (f instanceof Float) {\n\t\t\tFloat r = (Float) f;\n\t\t\treturn r;\n\t\t}\n\t\treturn 0.0f;\n\t}\n\tpublic static void main(String[] args) {\n\t\tfloat f = 49.0f;\n\t\tSystem.out.println(X.float2Float(f));\n\n\t}\n}\n"}, "49.0");
    }

    public void test140() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static Float float2Float(float f) {\n\t\tif (f instanceof Float r) {\n\t\t\treturn r;\n\t\t}\n\t\treturn 0.0f;\n\t}\n\tpublic static void main(String[] args) {\n\t\tfloat f = 49.0f;\n\t\tSystem.out.println(X.float2Float(f));\n\t}\n}\n"}, "49.0");
    }

    public void test141() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static Float float2Float() {\n\t\tif (getFloat() instanceof Float) {\n\t\t\tFloat r = (Float) getFloat();\n\t\t\treturn r;\n\t\t}\n\t\treturn 0.0f;\n\t}\n\tprivate static float getFloat() {\n\t\treturn 49.0f;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(X.float2Float());\n\t}\n}\n"}, "49.0");
    }

    public void test142() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static Float float2Float() {\n\t\tif (getFloat() instanceof Float r) {\n\t\t\treturn r;\n\t\t}\n\t\treturn 0.0f;\n\t}\n\tprivate static float getFloat() {\n\t\treturn 49.0f;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(X.float2Float());\n\t}\n}\n"}, "49.0");
    }

    public void test143() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static Double double2Double(double d) {\n\t\tif (d instanceof Double) {\n\t\t\tDouble r = (Double) d;\n\t\t\treturn r;\n\t\t}\n\t\treturn 0.0d;\n\t}\n\tpublic static void main(String[] args) {\n\t\tdouble d = 49.0d;\n\t\tSystem.out.println(X.double2Double(d));\n\n\t}\n}\n"}, "49.0");
    }

    public void test144() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static Double double2Double(double d) {\n\t\tif (d instanceof Double r) {\n\t\t\treturn r;\n\t\t}\n\t\treturn 0.0d;\n\t}\n\tpublic static void main(String[] args) {\n\t\tdouble d = 49.0d;\n\t\tSystem.out.println(X.double2Double(d));\n\t}\n}\n"}, "49.0");
    }

    public void test145() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static Double double2Double() {\n\t\tif (getDouble() instanceof Double) {\n\t\t\tDouble r = (Double) getDouble();\n\t\t\treturn r;\n\t\t}\n\t\treturn 0.0d;\n\t}\n\tprivate static double getDouble() {\n\t\treturn 49.0d;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(X.double2Double());\n\t}\n}\n"}, "49.0");
    }

    public void test146() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static Double double2Double() {\n\t\tif (getDouble() instanceof Double r) {\n\t\t\treturn r;\n\t\t}\n\t\treturn 0.0d;\n\t}\n\tprivate static double getDouble() {\n\t\treturn 49.0d;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(X.double2Double());\n\t}\n}\n"}, "49.0");
    }

    public void test147() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static Comparable foo(byte b) {\n\t\tif (b instanceof Comparable r) {\n\t\t\treturn r;\n\t\t}\n\t\treturn null;\n\t}\n\tpublic static void main(String[] args) {\n\t\tbyte b = 1;\n\t\tSystem.out.println(X.foo(b));\n\t}\n}\n"}, "1");
    }

    public void test148() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static Comparable<Byte> foo(byte b) {\n\t\tif (b instanceof Comparable r) {\n\t\t\treturn r;\n\t\t}\n\t\treturn null;\n\t}\n\tpublic static void main(String[] args) {\n\t\tbyte b = 1;\n\t\tSystem.out.println(X.foo(b));\n\t}\n}\n"}, "1");
    }

    public void test149() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static Comparable<Byte> foo(byte b) {\n\t\tif (b instanceof Comparable<Byte> r) {\n\t\t\treturn r;\n\t\t}\n\t\treturn null;\n\t}\n\tpublic static void main(String[] args) {\n\t\tbyte b = 1;\n\t\tSystem.out.println(X.foo(b));\n\t}\n}\n"}, "1");
    }

    public void test150() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static Number foo(byte b) {\n\t\tif (b instanceof Number r) {\n\t\t\treturn r;\n\t\t}\n\t\treturn null;\n\t}\n\tpublic static void main(String[] args) {\n\t\tbyte b = 1;\n\t\tSystem.out.println(X.foo(b));\n\t}\n}\n"}, "1");
    }

    public void test151() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static Comparable foo1(boolean b) {\n\t\tif (b instanceof Comparable r) {\n\t\t\treturn r;\n\t\t}\n\t\treturn null;\n\t}\n\tpublic static Comparable<Boolean> foo2(boolean b) {\n\t\tif (b instanceof Comparable r) {\n\t\t\treturn r;\n\t\t}\n\t\treturn null;\n\t}\n\tpublic static Comparable<Boolean> foo3(boolean b) {\n\t\tif (b instanceof Comparable<Boolean> r) {\n\t\t\treturn r;\n\t\t}\n\t\treturn null;\n\t}\n\tpublic static void main(String[] args) {\n\t\tboolean b = true;\n\t\tSystem.out.println(X.foo1(b));\n\t\tSystem.out.println(X.foo2(b));\n\t\tSystem.out.println(X.foo3(b));\n\t}\n}\n"}, "true\ntrue\ntrue");
    }

    public void test152() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static Number foo(boolean b) {\n\t\tif (b instanceof Number r) {\n\t\t\treturn r;\n\t\t}\n\t\treturn null;\n\t}\n\tpublic static void main(String[] args) {\n\t\tboolean b = true;\n\t\tSystem.out.println(X.foo(b));\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tif (b instanceof Number r) {\n\t    ^^^^^^^^^^^^^^^^^^^^^\nIncompatible conditional operand types boolean and Number\n----------\n");
    }

    public void test153() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static Comparable foo1(short s) {\n\t\tif (s instanceof Comparable r) {\n\t\t\treturn r;\n\t\t}\n\t\treturn null;\n\t}\n\tpublic static Comparable<Short> foo2(short s) {\n\t\tif (s instanceof Comparable r) {\n\t\t\treturn r;\n\t\t}\n\t\treturn null;\n\t}\n\tpublic static Comparable<Short> foo3(short s) {\n\t\tif (s instanceof Comparable<Short> r) {\n\t\t\treturn r;\n\t\t}\n\t\treturn null;\n\t}\n\tpublic static Number foo4(short s) {\n\t\tif (s instanceof Number r) {\n\t\t\treturn r;\n\t\t}\n\t\treturn null;\n\t}\n\tpublic static void main(String[] args) {\n\t\tshort s = 1;\n\t\tSystem.out.println(X.foo1(s));\n\t\tSystem.out.println(X.foo2(s));\n\t\tSystem.out.println(X.foo3(s));\n\t\tSystem.out.println(X.foo4(s));\n\t}\n}\n"}, "1\n1\n1\n1");
    }

    public void test154() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static Comparable foo1(char c) {\n\t\tif (c instanceof Comparable r) {\n\t\t\treturn r;\n\t\t}\n\t\treturn null;\n\t}\n\tpublic static Comparable<Character> foo2(char c) {\n\t\tif (c instanceof Comparable r) {\n\t\t\treturn r;\n\t\t}\n\t\treturn null;\n\t}\n\tpublic static Comparable<Character> foo3(char c) {\n\t\tif (c instanceof Comparable<Character> r) {\n\t\t\treturn r;\n\t\t}\n\t\treturn null;\n\t}\n\tpublic static void main(String[] args) {\n\t\tchar c = 49;\n\t\tSystem.out.println(X.foo1(c));\n\t\tSystem.out.println(X.foo2(c));\n\t\tSystem.out.println(X.foo3(c));\n\t}\n}\n"}, "1\n1\n1");
    }

    public void test155() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static Comparable foo1(int i) {\n\t\tif (i instanceof Comparable r) {\n\t\t\treturn r;\n\t\t}\n\t\treturn null;\n\t}\n\tpublic static Comparable<Integer> foo2(int i) {\n\t\tif (i instanceof Comparable r) {\n\t\t\treturn r;\n\t\t}\n\t\treturn null;\n\t}\n\tpublic static Comparable<Integer> foo3(int i) {\n\t\tif (i instanceof Comparable<Integer> r) {\n\t\t\treturn r;\n\t\t}\n\t\treturn null;\n\t}\n\tpublic static Number foo4(int i) {\n\t\tif (i instanceof Number r) {\n\t\t\treturn r;\n\t\t}\n\t\treturn null;\n\t}\n\tpublic static void main(String[] args) {\n\t\tint i = 49;\n\t\tSystem.out.println(X.foo1(i));\n\t\tSystem.out.println(X.foo2(i));\n\t\tSystem.out.println(X.foo3(i));\n\t\tSystem.out.println(X.foo4(i));\n\t}\n}\n"}, "49\n49\n49\n49");
    }

    public void test156() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static Comparable foo1(long l) {\n\t\tif (l instanceof Comparable r) {\n\t\t\treturn r;\n\t\t}\n\t\treturn null;\n\t}\n\tpublic static Comparable<Long> foo2(long l) {\n\t\tif (l instanceof Comparable r) {\n\t\t\treturn r;\n\t\t}\n\t\treturn null;\n\t}\n\tpublic static Comparable<Long> foo3(long l) {\n\t\tif (l instanceof Comparable<Long> r) {\n\t\t\treturn r;\n\t\t}\n\t\treturn null;\n\t}\n\tpublic static Number foo4(long l) {\n\t\tif (l instanceof Number r) {\n\t\t\treturn r;\n\t\t}\n\t\treturn null;\n\t}\n\tpublic static void main(String[] args) {\n\t\tlong l = 49;\n\t\tSystem.out.println(X.foo1(l));\n\t\tSystem.out.println(X.foo2(l));\n\t\tSystem.out.println(X.foo3(l));\n\t\tSystem.out.println(X.foo4(l));\n\t}\n}\n"}, "49\n49\n49\n49");
    }

    public void test157() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static Comparable foo1(float f) {\n\t\tif (f instanceof Comparable r) {\n\t\t\treturn r;\n\t\t}\n\t\treturn null;\n\t}\n\tpublic static Comparable<Float> foo2(float f) {\n\t\tif (f instanceof Comparable r) {\n\t\t\treturn r;\n\t\t}\n\t\treturn null;\n\t}\n\tpublic static Comparable<Float> foo3(float f) {\n\t\tif (f instanceof Comparable<Float> r) {\n\t\t\treturn r;\n\t\t}\n\t\treturn null;\n\t}\n\tpublic static Number foo4(float f) {\n\t\tif (f instanceof Number r) {\n\t\t\treturn r;\n\t\t}\n\t\treturn null;\n\t}\n\tpublic static void main(String[] args) {\n\t\tfloat f = 49.0f;\n\t\tSystem.out.println(X.foo1(f));\n\t\tSystem.out.println(X.foo2(f));\n\t\tSystem.out.println(X.foo3(f));\n\t\tSystem.out.println(X.foo4(f));\n\t}\n}\n"}, "49.0\n49.0\n49.0\n49.0");
    }

    public void test158() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static Comparable foo1(double d) {\n\t\tif (d instanceof Comparable r) {\n\t\t\treturn r;\n\t\t}\n\t\treturn null;\n\t}\n\tpublic static Comparable<Double> foo2(double d) {\n\t\tif (d instanceof Comparable r) {\n\t\t\treturn r;\n\t\t}\n\t\treturn null;\n\t}\n\tpublic static Comparable<Double> foo3(double d) {\n\t\tif (d instanceof Comparable<Double> r) {\n\t\t\treturn r;\n\t\t}\n\t\treturn null;\n\t}\n\tpublic static Number foo4(double d) {\n\t\tif (d instanceof Number r) {\n\t\t\treturn r;\n\t\t}\n\t\treturn null;\n\t}\n\tpublic static void main(String[] args) {\n\t\tdouble d = 49.0d;\n\t\tSystem.out.println(X.foo1(d));\n\t\tSystem.out.println(X.foo2(d));\n\t\tSystem.out.println(X.foo3(d));\n\t\tSystem.out.println(X.foo4(d));\n\t}\n}\n"}, "49.0\n49.0\n49.0\n49.0");
    }

    public void test159() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static boolean Boolean2boolean(Boolean b) {\n\t\tif (b instanceof boolean) {\n\t\t\tboolean r = (boolean) b;\n\t\t\treturn r;\n\t\t}\n\t\treturn false;\n\t}\n\tpublic static void main(String[] args) {\n\t\tboolean b = true;\n\t\tSystem.out.println(X.Boolean2boolean(b));\n\t}\n}\n"}, "true");
    }

    public void test160() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static boolean Boolean2boolean(Boolean b) {\n\t\tif (b instanceof boolean r) {\n\t\t\treturn r;\n\t\t}\n\t\treturn false;\n\t}\n\tpublic static void main(String[] args) {\n\t\tboolean b = true;\n\t\tSystem.out.println(X.Boolean2boolean(b));\n\t}\n}\n"}, "true");
    }

    public void test161() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static boolean Boolean2boolean() {\n\t\tif (getBoolean() instanceof boolean) {\n\t\t\tboolean r = (boolean) getBoolean();\n\t\t\treturn r;\n\t\t}\n\t\treturn false;\n\t}\n\tprivate static Boolean getBoolean() {\n\t\treturn Boolean.TRUE;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(X.Boolean2boolean());\n\t}\n}\n"}, "true");
    }

    public void test162() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static boolean Boolean2boolean() {\n\t\tif (getBoolean() instanceof boolean r) {\n\t\t\treturn r;\n\t\t}\n\t\treturn false;\n\t}\n\tprivate static Boolean getBoolean() {\n\t\treturn Boolean.TRUE;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(X.Boolean2boolean());\n\t}\n}\n"}, "true");
    }

    public void test163() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static byte Byte2byte(Byte b) {\n\t\tif (b instanceof byte) {\n\t\t\tbyte r = (byte) b;\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tpublic static void main(String[] args) {\n\t\tbyte b = 1;\n\t\tSystem.out.println(X.Byte2byte(b));\n\t}\n}\n"}, "1");
    }

    public void test164() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static byte Byte2byte(Byte b) {\n\t\tif (b instanceof byte r) {\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tpublic static void main(String[] args) {\n\t\tbyte b = 1;\n\t\tSystem.out.println(X.Byte2byte(b));\n\t}\n}\n"}, "1");
    }

    public void test165() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static byte Byte2byte() {\n\t\tif (getByte() instanceof byte) {\n\t\t\tbyte r = (byte) getByte();\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tprivate static Byte getByte() {\n\t\treturn 1;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(X.Byte2byte());\n\t}\n}\n"}, "1");
    }

    public void test166() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static byte Byte2byte() {\n\t\tif (getByte() instanceof byte r) {\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tprivate static Byte getByte() {\n\t\treturn 1;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(X.Byte2byte());\n\t}\n}\n"}, "1");
    }

    public void test167() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static char Character2char(Character b) {\n        if (b instanceof char) {\n            char r = (char) b;\n            return r;\n        }\n        return 0;\n    }\n    public static void main(String[] args) {\n        char b = 49;\n        System.out.println(X.Character2char(b));\n    }\n}\n"}, "1");
    }

    public void test168() {
        this.runConformTest(new String[]{"X.java", "    public class X {\n        public static char Character2char(Character b) {\n            if (b instanceof char r) {\n                return r;\n            }\n            return 0;\n        }\n        public static void main(String[] args) {\n            char b = 49;\n            System.out.println(X.Character2char(b));\n        }\n    }\n"}, "1");
    }

    public void test169() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static char Character2char() {\n        if (getCharacter() instanceof char) {\n            char r = (char) getCharacter();\n            return r;\n        }\n        return 0;\n    }\n    private static Character getCharacter() {\n        return 49;\n    }\n    public static void main(String[] args) {\n        System.out.println(X.Character2char());\n    }\n}\n"}, "1");
    }

    public void test170() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static char Character2char() {\n        if (getCharacter() instanceof char r) {\n            return r;\n        }\n        return 0;\n    }\n    private static Character getCharacter() {\n        return 49;\n    }\n    public static void main(String[] args) {\n        System.out.println(X.Character2char());\n    }\n}\n"}, "1");
    }

    public void test171() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static short Short2short(Short b) {\n        if (b instanceof short) {\n            short r = (short) b;\n            return r;\n        }\n        return 0;\n    }\n    public static void main(String[] args) {\n        short b = 1;\n        System.out.println(X.Short2short(b));\n    }\n}\n"}, "1");
    }

    public void test172() {
        this.runConformTest(new String[]{"X.java", "    public class X {\n        public static short Short2short(Short b) {\n            if (b instanceof short r) {\n                return r;\n            }\n            return 0;\n        }\n        public static void main(String[] args) {\n            short b = 1;\n            System.out.println(X.Short2short(b));\n        }\n    }\n"}, "1");
    }

    public void test173() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static short Short2short() {\n        if (getShort() instanceof short) {\n            short r = (short) getShort();\n            return r;\n        }\n        return 0;\n    }\n    private static Short getShort() {\n        return 1;\n    }\n    public static void main(String[] args) {\n        System.out.println(X.Short2short());\n    }\n}\n"}, "1");
    }

    public void test174() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static short Short2short() {\n        if (getShort() instanceof short r) {\n            return r;\n        }\n        return 0;\n    }\n    private static Short getShort() {\n        return 1;\n    }\n    public static void main(String[] args) {\n        System.out.println(X.Short2short());\n    }\n}\n"}, "1");
    }

    public void test175() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static int Integer2int(Integer b) {\n        if (b instanceof int) {\n            int r = (int) b;\n            return r;\n        }\n        return 0;\n    }\n    public static void main(String[] args) {\n        int b = 1;\n        System.out.println(X.Integer2int(b));\n    }\n}\n"}, "1");
    }

    public void test176() {
        this.runConformTest(new String[]{"X.java", "    public class X {\n        public static int Integer2int(Integer b) {\n            if (b instanceof int r) {\n                return r;\n            }\n            return 0;\n        }\n        public static void main(String[] args) {\n            int b = 1;\n            System.out.println(X.Integer2int(b));\n        }\n    }\n"}, "1");
    }

    public void test177() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static int Integer2int() {\n        if (getInteger() instanceof int) {\n            int r = (int) getInteger();\n            return r;\n        }\n        return 0;\n    }\n    private static Integer getInteger() {\n        return 1;\n    }\n    public static void main(String[] args) {\n        System.out.println(X.Integer2int());\n    }\n}\n"}, "1");
    }

    public void test178() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static int Integer2int() {\n        if (getInteger() instanceof int r) {\n            return r;\n        }\n        return 0;\n    }\n    private static Integer getInteger() {\n        return 1;\n    }\n    public static void main(String[] args) {\n        System.out.println(X.Integer2int());\n    }\n}\n"}, "1");
    }

    public void test179() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static long Long2long(Long b) {\n        if (b instanceof long) {\n            long r = (long) b;\n            return r;\n        }\n        return 0;\n    }\n    public static void main(String[] args) {\n        long b = 1;\n        System.out.println(X.Long2long(b));\n    }\n}\n"}, "1");
    }

    public void test180() {
        this.runConformTest(new String[]{"X.java", "    public class X {\n        public static long Long2long(Long b) {\n            if (b instanceof long r) {\n                return r;\n            }\n            return 0;\n        }\n        public static void main(String[] args) {\n            long b = 1;\n            System.out.println(X.Long2long(b));\n        }\n    }\n"}, "1");
    }

    public void test181() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static long Long2long() {\n        if (getLong() instanceof long) {\n            long r = (long) getLong();\n            return r;\n        }\n        return 0;\n    }\n    private static Long getLong() {\n        return 1L;\n    }\n    public static void main(String[] args) {\n        System.out.println(X.Long2long());\n    }\n}\n"}, "1");
    }

    public void test182() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static long Long2long() {\n        if (getLong() instanceof long r) {\n            return r;\n        }\n        return 0;\n    }\n    private static Long getLong() {\n        return 1L;\n    }\n    public static void main(String[] args) {\n        System.out.println(X.Long2long());\n    }\n}\n"}, "1");
    }

    public void test183() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static float Float2float(Float b) {\n        if (b instanceof float) {\n            float r = (float) b;\n            return r;\n        }\n        return 0.0f;\n    }\n    public static void main(String[] args) {\n        float b = 1.0f;\n        System.out.println(X.Float2float(b));\n    }\n}\n"}, "1.0");
    }

    public void test184() {
        this.runConformTest(new String[]{"X.java", "    public class X {\n        public static float Float2float(Float b) {\n            if (b instanceof float r) {\n                return r;\n            }\n            return 0.0f;\n        }\n        public static void main(String[] args) {\n            float b = 1.0f;\n            System.out.println(X.Float2float(b));\n        }\n    }\n"}, "1.0");
    }

    public void test185() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static float Float2float() {\n        if (getFloat() instanceof float) {\n            float r = (float) getFloat();\n            return r;\n        }\n        return 0.0f;\n    }\n    private static Float getFloat() {\n        return 1.0f;\n    }\n    public static void main(String[] args) {\n        System.out.println(X.Float2float());\n    }\n}\n"}, "1.0");
    }

    public void test186() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static float Float2float() {\n        if (getFloat() instanceof float r) {\n            return r;\n        }\n        return 0.0f;\n    }\n    private static Float getFloat() {\n        return 1.0f;\n    }\n    public static void main(String[] args) {\n        System.out.println(X.Float2float());\n    }\n}\n"}, "1.0");
    }

    public void test187() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static double Double2double(Double b) {\n        if (b instanceof double) {\n            double r = (double) b;\n            return r;\n        }\n        return 0.0d;\n    }\n    public static void main(String[] args) {\n        double b = 1.0d;\n        System.out.println(X.Double2double(b));\n    }\n}\n"}, "1.0");
    }

    public void test188() {
        this.runConformTest(new String[]{"X.java", "    public class X {\n        public static double Double2double(Double b) {\n            if (b instanceof double r) {\n                return r;\n            }\n            return 0.0d;\n        }\n        public static void main(String[] args) {\n            double b = 1.0d;\n            System.out.println(X.Double2double(b));\n        }\n    }\n"}, "1.0");
    }

    public void test189() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static double Double2double() {\n        if (getDouble() instanceof double) {\n            double r = (double) getDouble();\n            return r;\n        }\n        return 0.0d;\n    }\n    private static Double getDouble() {\n        return 1.0d;\n    }\n    public static void main(String[] args) {\n        System.out.println(X.Double2double());\n    }\n}\n"}, "1.0");
    }

    public void test190() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static double Double2double() {\n        if (getDouble() instanceof double r) {\n            return r;\n        }\n        return 0.0d;\n    }\n    private static Double getDouble() {\n        return 1.0d;\n    }\n    public static void main(String[] args) {\n        System.out.println(X.Double2double());\n    }\n}\n"}, "1.0");
    }

    public void test191() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static short Byte2short(Byte b) {\n\t\tif (b instanceof short) {\n\t\t\tshort r = (short) b;\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tpublic static void main(String[] args) {\n\t\tbyte b = 1;\n\t\tSystem.out.println(X.Byte2short(b));\n\t}\n}\n"}, "1");
    }

    public void test192() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static short Byte2short(Byte b) {\n\t\tif (b instanceof short r) {\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tpublic static void main(String[] args) {\n\t\tbyte b = 1;\n\t\tSystem.out.println(X.Byte2short(b));\n\t}\n}\n"}, "1");
    }

    public void test193() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static short Byte2short() {\n\t\tif (getByte() instanceof short) {\n\t\t\tshort r = (short) getByte();\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tprivate static Byte getByte() {\n\t\treturn 1;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(X.Byte2short());\n\t}\n}\n"}, "1");
    }

    public void test194() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static short Byte2short() {\n\t\tif (getByte() instanceof short r) {\n\t\t\treturn r;\n\t\t}\n\t\treturn 0;\n\t}\n\tprivate static Byte getByte() {\n\t\treturn 1;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(X.Byte2short());\n\t}\n}\n"}, "1");
    }

    public void test195() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static int Byte2int(Byte b) {\n        if (b instanceof int) {\n            int r = (int) b;\n            return r;\n        }\n        return 0;\n    }\n    public static void main(String[] args) {\n        byte b = 1;\n        System.out.println(X.Byte2int(b));\n    }\n}\n"}, "1");
    }

    public void test196() {
        this.runConformTest(new String[]{"X.java", "    public class X {\n        public static int Byte2int(Byte b) {\n            if (b instanceof int r) {\n                return r;\n            }\n            return 0;\n        }\n        public static void main(String[] args) {\n            byte b = 1;\n            System.out.println(X.Byte2int(b));\n        }\n    }\n"}, "1");
    }

    public void test197() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static int Byte2int() {\n        if (getByte() instanceof int) {\n            int r = (int) getByte();\n            return r;\n        }\n        return 0;\n    }\n    private static Byte getByte() {\n        return 1;\n    }\n    public static void main(String[] args) {\n        System.out.println(X.Byte2int());\n    }\n}\n"}, "1");
    }

    public void test198() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static int Byte2int() {\n        if (getByte() instanceof int r) {\n            return r;\n        }\n        return 0;\n    }\n    private static Byte getByte() {\n        return 1;\n    }\n    public static void main(String[] args) {\n        System.out.println(X.Byte2int());\n    }\n}\n"}, "1");
    }

    public void test199() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static long Byte2long(Byte b) {\n        if (b instanceof long) {\n            long r = (long) b;\n            return r;\n        }\n        return 0;\n    }\n    public static void main(String[] args) {\n        byte b = 1;\n        System.out.println(X.Byte2long(b));\n    }\n}\n"}, "1");
    }

    public void test200() {
        this.runConformTest(new String[]{"X.java", "    public class X {\n        public static long Byte2long(Byte b) {\n            if (b instanceof long r) {\n                return r;\n            }\n            return 0;\n        }\n        public static void main(String[] args) {\n            byte b = 1;\n            System.out.println(X.Byte2long(b));\n        }\n    }\n"}, "1");
    }

    public void test201() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static long Byte2long() {\n        if (getByte() instanceof long) {\n            long r = (long) getByte();\n            return r;\n        }\n        return 0;\n    }\n    private static Byte getByte() {\n        return 1;\n    }\n    public static void main(String[] args) {\n        System.out.println(X.Byte2long());\n    }\n}\n"}, "1");
    }

    public void test202() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static long Byte2long() {\n        if (getByte() instanceof long r) {\n            return r;\n        }\n        return 0;\n    }\n    private static Byte getByte() {\n        return 1;\n    }\n    public static void main(String[] args) {\n        System.out.println(X.Byte2long());\n    }\n}\n"}, "1");
    }

    public void test203() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static float Byte2float(Byte b) {\n        if (b instanceof float) {\n            float r = (float) b;\n            return r;\n        }\n        return 0.0f;\n    }\n    public static void main(String[] args) {\n        byte b = 1;\n        System.out.println(X.Byte2float(b));\n    }\n}\n"}, "1.0");
    }

    public void test204() {
        this.runConformTest(new String[]{"X.java", "    public class X {\n        public static float Byte2float(Byte b) {\n            if (b instanceof float r) {\n                return r;\n            }\n            return 0.0f;\n        }\n        public static void main(String[] args) {\n            byte b = 1;\n            System.out.println(X.Byte2float(b));\n        }\n    }\n"}, "1.0");
    }

    public void test205() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static float Byte2float() {\n        if (getByte() instanceof float) {\n            float r = (float) getByte();\n            return r;\n        }\n        return 0.0f;\n    }\n    private static Byte getByte() {\n        return 1;\n    }\n    public static void main(String[] args) {\n        System.out.println(X.Byte2float());\n    }\n}\n"}, "1.0");
    }

    public void test206() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static float Byte2float() {\n        if (getByte() instanceof float r) {\n            return r;\n        }\n        return 0.0f;\n    }\n    private static Byte getByte() {\n        return 1;\n    }\n    public static void main(String[] args) {\n        System.out.println(X.Byte2float());\n    }\n}\n"}, "1.0");
    }

    public void test207() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static double Byte2double(Byte b) {\n        if (b instanceof double) {\n            double r = (double) b;\n            return r;\n        }\n        return 0.0d;\n    }\n    public static void main(String[] args) {\n        byte b = 1;\n        System.out.println(X.Byte2double(b));\n    }\n}\n"}, "1.0");
    }

    public void test208() {
        this.runConformTest(new String[]{"X.java", "    public class X {\n        public static double Byte2double(Byte b) {\n            if (b instanceof double r) {\n                return r;\n            }\n            return 0.0d;\n        }\n        public static void main(String[] args) {\n            byte b = 1;\n            System.out.println(X.Byte2double(b));\n        }\n    }\n"}, "1.0");
    }

    public void test209() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static double Byte2double() {\n        if (getByte() instanceof double) {\n            double r = (double) getByte();\n            return r;\n        }\n        return 0.0d;\n    }\n    private static Byte getByte() {\n        return 1;\n    }\n    public static void main(String[] args) {\n        System.out.println(X.Byte2double());\n    }\n}\n"}, "1.0");
    }

    public void test210() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static double Byte2double() {\n        if (getByte() instanceof double r) {\n            return r;\n        }\n        return 0.0d;\n    }\n    private static Byte getByte() {\n        return 1;\n    }\n    public static void main(String[] args) {\n        System.out.println(X.Byte2double());\n    }\n}\n"}, "1.0");
    }

    public void test212() {
        this.runConformTest(new String[]{"X.java", "    public class X {\n        public static int Short2int(Short b) {\n            if (b instanceof int r) {\n                return r;\n            }\n            return 0;\n        }\n        public static void main(String[] args) {\n            short b = 1;\n            System.out.println(X.Short2int(b));\n        }\n    }\n"}, "1");
    }

    public void test213() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static int Short2int() {\n        if (getShort() instanceof int) {\n            int r = (int) getShort();\n            return r;\n        }\n        return 0;\n    }\n    private static Short getShort() {\n        return 1;\n    }\n    public static void main(String[] args) {\n        System.out.println(X.Short2int());\n    }\n}\n"}, "1");
    }

    public void test214() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static int Short2int() {\n        if (getShort() instanceof int r) {\n            return r;\n        }\n        return 0;\n    }\n    private static Short getShort() {\n        return 1;\n    }\n    public static void main(String[] args) {\n        System.out.println(X.Short2int());\n    }\n}\n"}, "1");
    }

    public void test215() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static long Short2long(Short b) {\n        if (b instanceof long) {\n            long r = (long) b;\n            return r;\n        }\n        return 0;\n    }\n    public static void main(String[] args) {\n        short b = 1;\n        System.out.println(X.Short2long(b));\n    }\n}\n"}, "1");
    }

    public void test216() {
        this.runConformTest(new String[]{"X.java", "    public class X {\n        public static long Short2long(Short b) {\n            if (b instanceof long r) {\n                return r;\n            }\n            return 0;\n        }\n        public static void main(String[] args) {\n            short b = 1;\n            System.out.println(X.Short2long(b));\n        }\n    }\n"}, "1");
    }

    public void test217() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static long Short2long() {\n        if (getShort() instanceof long) {\n            long r = (long) getShort();\n            return r;\n        }\n        return 0;\n    }\n    private static Short getShort() {\n        return 1;\n    }\n    public static void main(String[] args) {\n        System.out.println(X.Short2long());\n    }\n}\n"}, "1");
    }

    public void test218() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static long Short2long() {\n        if (getShort() instanceof long r) {\n            return r;\n        }\n        return 0;\n    }\n    private static Short getShort() {\n        return 1;\n    }\n    public static void main(String[] args) {\n        System.out.println(X.Short2long());\n    }\n}\n"}, "1");
    }

    public void test219() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static float Short2float(Short b) {\n        if (b instanceof float) {\n            float r = (float) b;\n            return r;\n        }\n        return 0.0f;\n    }\n    public static void main(String[] args) {\n        short b = 1;\n        System.out.println(X.Short2float(b));\n    }\n}\n"}, "1.0");
    }

    public void test220() {
        this.runConformTest(new String[]{"X.java", "    public class X {\n        public static float Short2float(Short b) {\n            if (b instanceof float r) {\n                return r;\n            }\n            return 0.0f;\n        }\n        public static void main(String[] args) {\n            short b = 1;\n            System.out.println(X.Short2float(b));\n        }\n    }\n"}, "1.0");
    }

    public void test221() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static float Short2float() {\n        if (getShort() instanceof float) {\n            float r = (float) getShort();\n            return r;\n        }\n        return 0.0f;\n    }\n    private static Short getShort() {\n        return 1;\n    }\n    public static void main(String[] args) {\n        System.out.println(X.Short2float());\n    }\n}\n"}, "1.0");
    }

    public void test222() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static float Short2float() {\n        if (getShort() instanceof float r) {\n            return r;\n        }\n        return 0.0f;\n    }\n    private static Short getShort() {\n        return 1;\n    }\n    public static void main(String[] args) {\n        System.out.println(X.Short2float());\n    }\n}\n"}, "1.0");
    }

    public void test223() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static double Short2double(Short b) {\n        if (b instanceof double) {\n            double r = (double) b;\n            return r;\n        }\n        return 0.0d;\n    }\n    public static void main(String[] args) {\n        short b = 1;\n        System.out.println(X.Short2double(b));\n    }\n}\n"}, "1.0");
    }

    public void test224() {
        this.runConformTest(new String[]{"X.java", "    public class X {\n        public static double Short2double(Short b) {\n            if (b instanceof double r) {\n                return r;\n            }\n            return 0.0d;\n        }\n        public static void main(String[] args) {\n            short b = 1;\n            System.out.println(X.Short2double(b));\n        }\n    }\n"}, "1.0");
    }

    public void test225() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static double Short2double() {\n        if (getShort() instanceof double) {\n            double r = (double) getShort();\n            return r;\n        }\n        return 0.0d;\n    }\n    private static Short getShort() {\n        return 1;\n    }\n    public static void main(String[] args) {\n        System.out.println(X.Short2double());\n    }\n}\n"}, "1.0");
    }

    public void test226() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static double Short2double() {\n        if (getShort() instanceof double r) {\n            return r;\n        }\n        return 0.0d;\n    }\n    private static Short getShort() {\n        return 1;\n    }\n    public static void main(String[] args) {\n        System.out.println(X.Short2double());\n    }\n}\n"}, "1.0");
    }

    public void test227() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static int Character2int(Character b) {\n        if (b instanceof int) {\n            int r = (int) b;\n            return r;\n        }\n        return 0;\n    }\n    public static void main(String[] args) {\n        char b = 1;\n        System.out.println(X.Character2int(b));\n    }\n}\n"}, "1");
    }

    public void test228() {
        this.runConformTest(new String[]{"X.java", "    public class X {\n        public static int Character2int(Character b) {\n            if (b instanceof int r) {\n                return r;\n            }\n            return 0;\n        }\n        public static void main(String[] args) {\n            char b = 1;\n            System.out.println(X.Character2int(b));\n        }\n    }\n"}, "1");
    }

    public void test229() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static int Character2int() {\n        if (getCharacter() instanceof int) {\n            int r = (int) getCharacter();\n            return r;\n        }\n        return 0;\n    }\n    private static Character getCharacter() {\n        return 1;\n    }\n    public static void main(String[] args) {\n        System.out.println(X.Character2int());\n    }\n}\n"}, "1");
    }

    public void test230() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static int Character2int() {\n        if (getCharacter() instanceof int r) {\n            return r;\n        }\n        return 0;\n    }\n    private static Character getCharacter() {\n        return 1;\n    }\n    public static void main(String[] args) {\n        System.out.println(X.Character2int());\n    }\n}\n"}, "1");
    }

    public void test231() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static long Character2long(Character b) {\n        if (b instanceof long) {\n            long r = (long) b;\n            return r;\n        }\n        return 0;\n    }\n    public static void main(String[] args) {\n        char b = 1;\n        System.out.println(X.Character2long(b));\n    }\n}\n"}, "1");
    }

    public void test232() {
        this.runConformTest(new String[]{"X.java", "    public class X {\n        public static long Character2long(Character b) {\n            if (b instanceof long r) {\n                return r;\n            }\n            return 0;\n        }\n        public static void main(String[] args) {\n            char b = 1;\n            System.out.println(X.Character2long(b));\n        }\n    }\n"}, "1");
    }

    public void test233() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static long Character2long() {\n        if (getCharacter() instanceof long) {\n            long r = (long) getCharacter();\n            return r;\n        }\n        return 0;\n    }\n    private static Character getCharacter() {\n        return 1;\n    }\n    public static void main(String[] args) {\n        System.out.println(X.Character2long());\n    }\n}\n"}, "1");
    }

    public void test234() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static long Character2long() {\n        if (getCharacter() instanceof long r) {\n            return r;\n        }\n        return 0;\n    }\n    private static Character getCharacter() {\n        return 1;\n    }\n    public static void main(String[] args) {\n        System.out.println(X.Character2long());\n    }\n}\n"}, "1");
    }

    public void test235() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static float Character2float(Character b) {\n        if (b instanceof float) {\n            float r = (float) b;\n            return r;\n        }\n        return 0.0f;\n    }\n    public static void main(String[] args) {\n        char b = 1;\n        System.out.println(X.Character2float(b));\n    }\n}\n"}, "1.0");
    }

    public void test236() {
        this.runConformTest(new String[]{"X.java", "    public class X {\n        public static float Character2float(Character b) {\n            if (b instanceof float r) {\n                return r;\n            }\n            return 0.0f;\n        }\n        public static void main(String[] args) {\n            char b = 1;\n            System.out.println(X.Character2float(b));\n        }\n    }\n"}, "1.0");
    }

    public void test237() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static float Character2float() {\n        if (getCharacter() instanceof float) {\n            float r = (float) getCharacter();\n            return r;\n        }\n        return 0.0f;\n    }\n    private static Character getCharacter() {\n        return 1;\n    }\n    public static void main(String[] args) {\n        System.out.println(X.Character2float());\n    }\n}\n"}, "1.0");
    }

    public void test238() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static float Character2float() {\n        if (getCharacter() instanceof float r) {\n            return r;\n        }\n        return 0.0f;\n    }\n    private static Character getCharacter() {\n        return 1;\n    }\n    public static void main(String[] args) {\n        System.out.println(X.Character2float());\n    }\n}\n"}, "1.0");
    }

    public void test239() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static double Character2double(Character b) {\n        if (b instanceof double) {\n            double r = (double) b;\n            return r;\n        }\n        return 0.0d;\n    }\n    public static void main(String[] args) {\n        char b = 1;\n        System.out.println(X.Character2double(b));\n    }\n}\n"}, "1.0");
    }

    public void test240() {
        this.runConformTest(new String[]{"X.java", "    public class X {\n        public static double Character2double(Character b) {\n            if (b instanceof double r) {\n                return r;\n            }\n            return 0.0d;\n        }\n        public static void main(String[] args) {\n            char b = 1;\n            System.out.println(X.Character2double(b));\n        }\n    }\n"}, "1.0");
    }

    public void test241() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static double Character2double() {\n        if (getCharacter() instanceof double) {\n            double r = (double) getCharacter();\n            return r;\n        }\n        return 0.0d;\n    }\n    private static Character getCharacter() {\n        return 1;\n    }\n    public static void main(String[] args) {\n        System.out.println(X.Character2double());\n    }\n}\n"}, "1.0");
    }

    public void test242() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static double Character2double() {\n        if (getCharacter() instanceof double r) {\n            return r;\n        }\n        return 0.0d;\n    }\n    private static Character getCharacter() {\n        return 1;\n    }\n    public static void main(String[] args) {\n        System.out.println(X.Character2double());\n    }\n}\n"}, "1.0");
    }

    public void test243() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static long Integer2long(Integer b) {\n        if (b instanceof long) {\n            long r = (long) b;\n            return r;\n        }\n        return 0;\n    }\n    public static void main(String[] args) {\n        int b = 1;\n        System.out.println(X.Integer2long(b));\n    }\n}\n"}, "1");
    }

    public void test244() {
        this.runConformTest(new String[]{"X.java", "    public class X {\n        public static long Integer2long(Integer b) {\n            if (b instanceof long r) {\n                return r;\n            }\n            return 0;\n        }\n        public static void main(String[] args) {\n            int b = 1;\n            System.out.println(X.Integer2long(b));\n        }\n    }\n"}, "1");
    }

    public void test245() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static long Integer2long() {\n        if (getInteger() instanceof long) {\n            long r = (long) getInteger();\n            return r;\n        }\n        return 0;\n    }\n    private static Integer getInteger() {\n        return 1;\n    }\n    public static void main(String[] args) {\n        System.out.println(X.Integer2long());\n    }\n}\n"}, "1");
    }

    public void test246() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static long Integer2long() {\n        if (getInteger() instanceof long r) {\n            return r;\n        }\n        return 0;\n    }\n    private static Integer getInteger() {\n        return 1;\n    }\n    public static void main(String[] args) {\n        System.out.println(X.Integer2long());\n    }\n}\n"}, "1");
    }

    public void test247() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static float Integer2float(Integer b) {\n        if (b instanceof float) {\n            float r = (float) b;\n            return r;\n        }\n        return 0.0f;\n    }\n    public static void main(String[] args) {\n        int b = 1;\n        System.out.println(X.Integer2float(b));\n    }\n}\n"}, "1.0");
    }

    public void test248() {
        this.runConformTest(new String[]{"X.java", "    public class X {\n        public static float Integer2float(Integer b) {\n            if (b instanceof float r) {\n                return r;\n            }\n            return 0.0f;\n        }\n        public static void main(String[] args) {\n            int b = 1;\n            System.out.println(X.Integer2float(b));\n        }\n    }\n"}, "1.0");
    }

    public void test249() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static float Integer2float() {\n        if (getInteger() instanceof float) {\n            float r = (float) getInteger();\n            return r;\n        }\n        return 0.0f;\n    }\n    private static Integer getInteger() {\n        return 1;\n    }\n    public static void main(String[] args) {\n        System.out.println(X.Integer2float());\n    }\n}\n"}, "1.0");
    }

    public void test250() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static float Integer2float() {\n        if (getInteger() instanceof float r) {\n            return r;\n        }\n        return 0.0f;\n    }\n    private static Integer getInteger() {\n        return 1;\n    }\n    public static void main(String[] args) {\n        System.out.println(X.Integer2float());\n    }\n}\n"}, "1.0");
    }

    public void test251() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static double Integer2double(Integer b) {\n        if (b instanceof double) {\n            double r = (double) b;\n            return r;\n        }\n        return 0.0d;\n    }\n    public static void main(String[] args) {\n        int b = 1;\n        System.out.println(X.Integer2double(b));\n    }\n}\n"}, "1.0");
    }

    public void test252() {
        this.runConformTest(new String[]{"X.java", "    public class X {\n        public static double Integer2double(Integer b) {\n            if (b instanceof double r) {\n                return r;\n            }\n            return 0.0d;\n        }\n        public static void main(String[] args) {\n            int b = 1;\n            System.out.println(X.Integer2double(b));\n        }\n    }\n"}, "1.0");
    }

    public void test253() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static double Integer2double() {\n        if (getInteger() instanceof double) {\n            double r = (double) getInteger();\n            return r;\n        }\n        return 0.0d;\n    }\n    private static Integer getInteger() {\n        return 1;\n    }\n    public static void main(String[] args) {\n        System.out.println(X.Integer2double());\n    }\n}\n"}, "1.0");
    }

    public void test254() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static double Integer2double() {\n        if (getInteger() instanceof double r) {\n            return r;\n        }\n        return 0.0d;\n    }\n    private static Integer getInteger() {\n        return 1;\n    }\n    public static void main(String[] args) {\n        System.out.println(X.Integer2double());\n    }\n}\n"}, "1.0");
    }

    public void test255() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static float Long2float(Long b) {\n        if (b instanceof float) {\n            float r = (float) b;\n            return r;\n        }\n        return 0.0f;\n    }\n    public static void main(String[] args) {\n        long b = 1L;\n        System.out.println(X.Long2float(b));\n    }\n}\n"}, "1.0");
    }

    public void test256() {
        this.runConformTest(new String[]{"X.java", "    public class X {\n        public static float Long2float(Long b) {\n            if (b instanceof float r) {\n                return r;\n            }\n            return 0.0f;\n        }\n        public static void main(String[] args) {\n            long b = 1L;\n            System.out.println(X.Long2float(b));\n        }\n    }\n"}, "1.0");
    }

    public void test257() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static float Long2float() {\n        if (getLong() instanceof float) {\n            float r = (float) getLong();\n            return r;\n        }\n        return 0.0f;\n    }\n    private static Long getLong() {\n        return 1L;\n    }\n    public static void main(String[] args) {\n        System.out.println(X.Long2float());\n    }\n}\n"}, "1.0");
    }

    public void test258() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static float Long2float() {\n        if (getLong() instanceof float r) {\n            return r;\n        }\n        return 0.0f;\n    }\n    private static Long getLong() {\n        return 1L;\n    }\n    public static void main(String[] args) {\n        System.out.println(X.Long2float());\n    }\n}\n"}, "1.0");
    }

    public void test259() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static double Long2double(Long b) {\n        if (b instanceof double) {\n            double r = (double) b;\n            return r;\n        }\n        return 0.0d;\n    }\n    public static void main(String[] args) {\n        long b = 1L;\n        System.out.println(X.Long2double(b));\n    }\n}\n"}, "1.0");
    }

    public void test260() {
        this.runConformTest(new String[]{"X.java", "    public class X {\n        public static double Long2double(Long b) {\n            if (b instanceof double r) {\n                return r;\n            }\n            return 0.0d;\n        }\n        public static void main(String[] args) {\n            long b = 1L;\n            System.out.println(X.Long2double(b));\n        }\n    }\n"}, "1.0");
    }

    public void test261() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static double Long2double() {\n        if (getLong() instanceof double) {\n            double r = (double) getLong();\n            return r;\n        }\n        return 0.0d;\n    }\n    private static Long getLong() {\n        return 1L;\n    }\n    public static void main(String[] args) {\n        System.out.println(X.Long2double());\n    }\n}\n"}, "1.0");
    }

    public void test262() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static double Long2double() {\n        if (getLong() instanceof double r) {\n            return r;\n        }\n        return 0.0d;\n    }\n    private static Long getLong() {\n        return 1L;\n    }\n    public static void main(String[] args) {\n        System.out.println(X.Long2double());\n    }\n}\n"}, "1.0");
    }

    public void test263() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static double Float2double(Float b) {\n        if (b instanceof double) {\n            double r = (double) b;\n            return r;\n        }\n        return 0.0d;\n    }\n    public static void main(String[] args) {\n        float b = 1.0f;\n        System.out.println(X.Float2double(b));\n    }\n}\n"}, "1.0");
    }

    public void test264() {
        this.runConformTest(new String[]{"X.java", "    public class X {\n        public static double Float2double(Float b) {\n            if (b instanceof double r) {\n                return r;\n            }\n            return 0.0d;\n        }\n        public static void main(String[] args) {\n            float b = 1.0f;\n            System.out.println(X.Float2double(b));\n        }\n    }\n"}, "1.0");
    }

    public void test265() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static double Float2double() {\n        if (getFloat() instanceof double) {\n            double r = (double) getFloat();\n            return r;\n        }\n        return 0.0d;\n    }\n    private static Float getFloat() {\n        return 1.0f;\n    }\n    public static void main(String[] args) {\n        System.out.println(X.Float2double());\n    }\n}\n"}, "1.0");
    }

    public void test266() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static double Float2double() {\n        if (getFloat() instanceof double r) {\n            return r;\n        }\n        return 0.0d;\n    }\n    private static Float getFloat() {\n        return 1.0f;\n    }\n    public static void main(String[] args) {\n        System.out.println(X.Float2double());\n    }\n}\n"}, "1.0");
    }

    public void test267() {
        this.runConformTest(new String[]{"X.java", "record R(byte b) {}\npublic class X {\n\tpublic static short Byte2Recshort(R r) {\n\t\tif (r instanceof R(short y)) {\n\t\t\treturn y;\n\t\t}\n\t\treturn 0;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(X.Byte2Recshort(new R((byte)1)));\n\t}\n}\n"}, "1");
    }

    public void testIssue2928_001() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static boolean foo(Double d) {\n    \tboolean b;\n        switch (d) {\n            case 1d -> b = true;\n            default -> b = false;\n        }\n        return b;\n    }\n    public static void main(String[] args) {\n\t\tSystem.out.println(X.foo(1d));\n\t}\n}\n"}, "true");
    }

    public void testIssue2928_002() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static boolean foo(double d) {\n    \tboolean b;\n        switch (d) {\n            case 1d -> b = true;\n            default -> b = false;\n        }\n        return b;\n    }\n    public static void main(String[] args) {\n\t\tSystem.out.println(X.foo(1d));\n\t}\n}\n"}, "true");
    }

    public void testIssue2928_003() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static boolean foo(double d) {\n    \tboolean b;\n        switch (d) {\n            case 1d -> b = true;\n            default -> b = false;\n        }\n        return b;\n    }\n    public static void main(String[] args) {\n\t\tSystem.out.println(X.foo(2d));\n\t}\n}\n"}, "false");
    }

    public void testIssue2928_004() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static boolean foo(double d) {\n    \tboolean b;\n        switch (d) {\n            default -> b = false;\n        }\n        return b;\n    }\n    public static void main(String[] args) {\n\t\tSystem.out.println(X.foo(1d));\n\t}\n}\n"}, "false");
    }

    public void testNonPrim001() {
        this.runConformTest(new String[]{"X.java", "class Y<T> {\n    public boolean foo(T t) {\n        if (t instanceof T) {\n            return false;\n        }\n        return true;\n    }\n}\npublic class X  {\n    public static void main(String argv[]) {\n    \tSystem.out.println(new Y<X>().foo(null));\n    }\n}\n"}, "true");
    }

    public void testGuardedPattern_001() {
        this.runConformTest(new String[]{"X.java", "public class X  {\n    public static int foo(Integer myInt) {\n        return switch (myInt) {\n            case int i when i > 10 -> i;\n            default -> 0;\n        };\n    }\n\n    public static void main(String argv[]) {\n    \tInteger i = 100;\n    \tSystem.out.println(X.foo(i) == i);\n    }\n}\n"}, "true");
    }

    public void testEnhancedPrimitiveSwitch_001() {
        this.runNegativeTest(new String[]{"X.java", "\t public class X {\n\t    public static int foo(double d) {\n\t    \tint i = 0;\n\t        switch (d) {\n\t            case 1d : i = 1; break;\n\t        }\n\t        return i;\n\t    }\n\n\t    public static void main(String[] args) {\n\t\t\tSystem.out.println(X.foo(1d));\n\t\t}\n\t}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tswitch (d) {\n\t        ^\nAn enhanced switch statement should be exhaustive; a default label expected\n----------\n");
    }

    public void testByteToFloat_001() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static float byteToFloat(Byte a) {\n\t\treturn switch (a) {\n\t\t\tcase float y -> y;\n\t\t\tdefault -> 2;\n\t\t};\n\t}\n\tpublic static void main(String[] args) {\n\t\tByte b = 1;\n\t\tSystem.out.println(X.byteToFloat(b));\n\t}\n}\n"}, "1.0");
    }

    public void testByteToFloat_002() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static float byteToFloat(Byte a) {\n\t\treturn switch (a) {\n\t\t\tcase float y -> y;\n\t\t\tdefault -> 2;\n\t\t};\n\t}\n\tpublic static void main(String[] args) {\n\t\tByte b = 2;\n\t\tSystem.out.println(X.byteToFloat(b));\n\t}\n}\n"}, "2.0");
    }

    public void testEnhancedPrimitiveSwitchNPE_001() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n\t// Y is not defined/visible\n\t<T extends Y> void foo(T single) {\n\t\tswitch (single) {\n\t\tcase int i -> System.out.print(i);\n\t\tdefault -> System.out.print('-');\n\t\t}\n\t\tSystem.out.println(\"hello\");\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\t<T extends Y> void foo(T single) {\n\t           ^\nY cannot be resolved to a type\n----------\n");
    }

    public void testIssue2936_001() {
        this.runConformTest(new String[]{"X.java", "record R<Short>(Short s) {}\npublic class X {\n\tpublic static <Short> short foo(R<Short> s) {\n\t\treturn switch (s) {\n\t\t\tcase R(Short s1) -> 1;\n\t\t\tdefault -> 0;\n\t\t};\n\t}\n\tpublic static void main(String[] args) {\n\t\tShort s = 100;\n\t\tR<Short> r = new R<>(s);\n\t\tSystem.out.println(X.foo(r));\n\t}\n}\n"}, "1");
    }

    public void testIssue2936_002() {
        this.runConformTest(new String[]{"X.java", "public class X  {\n    public static <T extends Object> float foo(T t) {\n        if (t instanceof float i) { return i; }\n        return 100.0f;\n    }\n    public static void main(String argv[]) {\n        System.out.println(X.foo(1.0f));\n        System.out.println(X.foo(2));\n    }\n}\n"}, "1.0\n100.0");
    }

    public void testIssue2937_1() {
        this.runConformTest(new String[]{"X.java", "record Record<T extends Short>(T t) {}\npublic class X {\n\tpublic static <T extends Short> short foo(Record<T> s) {\n\t\treturn switch (s) {\n\t\t\tcase Record(short s1) -> s1;\n\t\t\tdefault -> 0;\n\t\t};\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.print(foo(new Record((short) 2)));\n\t}\n}\n"}, "2");
    }

    public void testIssue2937_2() {
        this.runConformTest(new String[]{"X.java", "record Record<T extends Short>(T t) {}\npublic class X {\n\tpublic static short foo(Record<?> s) {\n\t\treturn switch (s) {\n\t\t\tcase Record(short s1) -> s1;\n\t\t\tdefault -> 0;\n\t\t};\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.print(foo(new Record((short) 2)));\n\t}\n}\n"}, "2");
    }

    public void testSpec001() {
        this.runNegativeTest(new String[]{"X.java", "\tpublic class X {\n\t\tpublic int getStatus() {\n\t\t\treturn 100;\n\t\t}\n\t\tpublic static int foo(X x) {\n\t\t\treturn switch (x.getStatus()) {\n\t\t    case int i -> i;\n\t\t\tdefault -> -1;\n\t\t};\n\t\t}\n\t\tpublic static void main(String[] args) {\n\t\t\tX x = new X();\n\t\t\tSystem.out.println(X.foo(x));\n\t\t}\n\t}\n"}, "----------\n1. ERROR in X.java (at line 8)\r\n\tdefault -> -1;\r\n\t^^^^^^^\nSwitch case cannot have both unconditional pattern and default label\n----------\n");
    }

    public void testSpec002() {
        this.runNegativeTest(new String[]{"X.java", "\tpublic class X {\n\t\tpublic int getStatus() {\n\t\t\treturn 100;\n\t\t}\n\t\tpublic static int foo(X x) {\n\t\t\treturn switch (x.getStatus()) {\n\t\t    case int i when i > 10 -> i * i;\n\t\t    case int i -> i;\n\t\t\tdefault -> -1;\n\t\t};\n\t\t}\n\t\tpublic static void main(String[] args) {\n\t\t\tX x = new X();\n\t\t\tSystem.out.println(X.foo(x));\n\t\t}\n\t}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\tdefault -> -1;\n\t^^^^^^^\nSwitch case cannot have both unconditional pattern and default label\n----------\n");
    }

    public void testSpec003() {
        this.runConformTest(new String[]{"X.java", "\timport java.util.Map;\n\n\tsealed interface JsonValue {}\n\trecord JsonString(String s) implements JsonValue { }\n\trecord JsonNumber(double d) implements JsonValue { }\n\trecord JsonObject(Map<String, JsonValue> map) implements JsonValue { }\n\n\n\tpublic class X {\n\n\t\tpublic static void foo() {\n\t\t\tvar json = new JsonObject(Map.of(\"name\", new JsonString(\"John\"),\n\t                \"age\",  new JsonNumber(30)));\n\t        JsonValue v = json.map().get(\"age\");\n\t\t\tSystem.out.println(v);\n\t\t}\n\t\tpublic static void main(String[] args) {\n\t\t\tX.foo();\n\t\t}\n\t}\n"}, "JsonNumber[d=30.0]");
    }

    public void testSpec004() {
        this.runConformTest(new String[]{"X.java", "\timport java.util.Map;\n\n\tsealed interface JsonValue {}\n\trecord JsonString(String s) implements JsonValue { }\n\trecord JsonNumber(double d) implements JsonValue { }\n\trecord JsonObject(Map<String, JsonValue> map) implements JsonValue { }\n\n\n\tpublic class X {\n\n\t\tpublic static JsonObject foo() {\n\t\t\tvar json = new JsonObject(Map.of(\"name\", new JsonString(\"John\"),\n\t                \"age\",  new JsonNumber(30)));\n\t\t\treturn json;\n\t\t}\n\t\tpublic static void bar(Object json) {\n\t\t\tif (json instanceof JsonObject(var map)\n\t\t\t\t    && map.get(\"name\") instanceof JsonString(String n)\n\t\t\t\t    && map.get(\"age\")  instanceof JsonNumber(double a)) {\n\t\t\t\t    int age = (int)a;  // unavoidable (and potentially lossy!) cast\n\t\t\t\t    System.out.println(age);\n\t\t\t\t}\n\t\t}\n\t\tpublic static void main(String[] args) {\n\t\t\tX.bar(X.foo());\n\t\t}\n\t}\n"}, "30");
    }

    public void testSpec005() {
        this.runConformTest(new String[]{"X.java", "\timport java.util.HashMap;\n\timport java.util.Map;\n\n\tsealed interface I {}\n\trecord ZNumber(double d) implements I { }\n\trecord ZObject(Map<String, I> map) implements I { }\n\n\n\tpublic class X {\n\n\t\tpublic static ZObject foo() {\n\t\t\tMap<String, I> myMap = new HashMap<>();\n\t\t\tmyMap.put(\"age\",  new ZNumber(30));\n\t\t\treturn new ZObject(myMap);\n\t\t}\n\t\tpublic static void bar(Object json) {\n\t\t\tif (json instanceof ZObject(var map)) {\n\t\t\t\tif (map.get(\"age\")  instanceof ZNumber(double d)) {\n\t\t\t\t\tSystem.out.println(\"double:\"+d);\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t\tpublic static void main(String[] args) {\n\t\t\tX.bar(X.foo());\n\t\t}\n\t}\n"}, "double:30.0");
    }

    public void testSpec006() {
        this.runConformTest(new String[]{"X.java", "\timport java.util.HashMap;\n\timport java.util.Map;\n\n\tsealed interface I {}\n\trecord ZNumber(double d) implements I { }\n\trecord ZObject(Map<String, I> map) implements I { }\n\n\n\tpublic class X {\n\n\t\tpublic static ZObject foo() {\n\t\t\tMap<String, I> myMap = new HashMap<>();\n\t\t\tmyMap.put(\"age\",  new ZNumber(30));\n\t\t\treturn new ZObject(myMap);\n\t\t}\n\t\tpublic static void bar(Object json) {\n\t\t\tif (json instanceof ZObject(var map)) {\n\t\t\t\tif (map.get(\"age\")  instanceof ZNumber(int i)) {\n\t\t\t\t\tSystem.out.println(\"int:\"+i);\n\t\t\t\t} else if (map.get(\"age\")  instanceof ZNumber(double d)) {\n\t\t\t\t\tSystem.out.println(\"double:\"+d);\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t\tpublic static void main(String[] args) {\n\t\t\tX.bar(X.foo());\n\t\t}\n\t}\n"}, "int:30");
    }

    public void testGH3181() {
        this.runConformTest(new String[]{"X.java", "record Record<T extends Long>(T t) {\n}\n\npublic class X {\n\tpublic static <T extends Long> double foo(Record<T> s) {\n\t\treturn switch (s) {\n\t\tcase Record(double s1) -> s1 + 1.0;\n\t\tdefault -> 0;\n\t\t};\n\t}\n\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(foo(new Record<>(42L)));\n\t}\n}\n"}, "43.0");
    }

    public void testGH3129() {
        this.runConformTest(new String[]{"X.java", "record Record(Long i) {\n}\n\npublic class X {\n\tpublic static double convert(Record r) {\n\t\treturn r instanceof Record(double d) ? d + 1.0 : 0;\n\t}\n\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(convert(new Record(42L)));\n\t}\n}\n"}, "43.0");
    }

    public void testIssuePrimitivesWithNull() {
        this.runConformTest(new String[]{"X.java", "public class X  {\n    record R(Integer i) {}\n    public static int foo(R r) {\n        if (r instanceof R(int i)) { return i; }\n        return -1;\n    }\n    public static void main(String argv[]) {\n        System.out.println(foo(new R(null)));\n    }\n}\n"}, "-1");
    }

    public void _testSpec00X() {
        this.runNegativeTest(new String[]{"X.java", ""}, "----------\n2. ERROR in X.java (at line 16)\n\tZork();\n\t^^^^\nThe method Zork() is undefined for the type X\n----------\n");
    }

    public void testIssue3336() {
        this.runConformTest(new String[]{"X.java", "public interface X {\n\n\tpublic static void main(String[] args) {\n\t\tLong lng = Long.valueOf(42);\n\n\t\tswitch (lng) {\n\t\tcase -1l -> System.out.println(\"-1L\");\n\t\tcase null -> System.out.println(\"Null\");\n\t\tdefault -> System.out.println(\"Default\");\n\t\t}\n\t}\n\n}\n"}, "Default");
    }

    public void testIssue3505() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\n\tpublic static int foo() {\n\t\tY<Float> y = new Y<>();\n\t\ty.value = 100f;\n\t\treturn y.get() instanceof float ? 1 : 0;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(X.foo());\n\t}\n}\n\nclass Y<T> {\n\tT value;\n\tpublic T get() {\n\t\treturn this.value;\n\t}\n}"}, "1");
    }

    public void testIssue3535_001() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\n\tstatic Integer getInteger() {\n\t\treturn Integer.MIN_VALUE;\n\t}\n\tpublic int foo() {\n\t\tInteger i = 10;\n\t\tY<Integer> f = new Y<>();\n\t\tf.put(X.getInteger()); // This makes all the difference\n\t\treturn f.get() instanceof float ? 3 : 2;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(new X().foo());\n\t}\n\n}\nclass Y <T> {\n    T t;\n    T get() {\n        return t;\n    }\n    void put( T t) {\n    \tthis.t = t;\n    }\n}\n"}, "3");
    }

    public void testIssue3535_002() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\n\tstatic Integer getInteger() {\n\t\treturn Integer.MAX_VALUE;\n\t}\n\tpublic int foo() {\n\t\tInteger i = 10;\n\t\tY<Integer> f = new Y<>();\n\t\tf.put(X.getInteger()); // This makes all the difference\n\t\treturn f.get() instanceof float ? 3 : 2;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(new X().foo());\n\t}\n\n}\nclass Y <T> {\n    T t;\n    T get() {\n        return t;\n    }\n    void put( T t) {\n    \tthis.t = t;\n    }\n}\n"}, "2");
    }

    public void testIssue3536() {
        this.runConformTest(new String[]{"X.java", "\trecord Record(Byte b) {}\n\tpublic class X {\n\t\tpublic static void main(String argv[]) {\n\t\t\tX x = new X();\n\t\t\tSystem.out.println(x.foo(new Record(null)));\n\t\t}\n\t\tpublic int foo(Record r) {\n\t\t\tint result = 0;\n\t\t\tresult = r instanceof Record(short s) ? 0 : 1;\n\t\t\treturn result;\n\t\t}\n\t}\n"}, "1");
    }
}

