/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.io.IOException;
import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest9;
import org.eclipse.jdt.core.tests.compiler.regression.DefaultJavaRuntimeEnvironment;
import org.eclipse.jdt.core.tests.compiler.regression.InMemoryNameEnvironment9;
import org.eclipse.jdt.core.tests.util.PreviewTest;
import org.eclipse.jdt.core.util.ClassFormatException;
import org.eclipse.jdt.internal.compiler.batch.FileSystem;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;

@PreviewTest
public class PrimitiveInPatternsTestSH
extends AbstractRegressionTest9 {
    private static final AbstractRegressionTest.JavacTestOptions JAVAC_OPTIONS = new AbstractRegressionTest.JavacTestOptions("--enable-preview -source 24 -Xlint:-preview");
    private static final String[] VMARGS = new String[]{"--enable-preview"};
    private static final String[] PRIMITIVES = new String[]{"boolean", "byte", "char", "short", "int", "long", "float", "double"};
    private static final String[] BOXES = new String[]{"Boolean", "Byte", "Character", "Short", "Integer", "Long", "Float", "Double"};
    private static final String[] MAXVALUES = new String[]{"true", "Byte.MAX_VALUE", "'z'", "Short.MAX_VALUE", "Integer.MAX_VALUE", "Long.MAX_VALUE", "Float.MAX_VALUE", "Double.MAX_VALUE"};
    private static final String[] GOODVALUES = new String[]{"true", "49", "'1'", "49", "49", "49L", "49.0f", "49.0d"};
    private static final String[] NEGVALUES = new String[]{"false", "-1", "'-'", "-1", "-1", "-1L", "-1.0f", "-1.0d"};
    private static final String[] CONSTANTS = new String[]{"true", "1", "'1'", "300", "40000", "5000000000", "6.0E20", "7.0E40"};
    private static final boolean[] IS_NUMERICAL;
    private static String MAX_VALUES_STRING;
    private String extraLibPath;

    static {
        boolean[] blArray = new boolean[8];
        blArray[1] = true;
        blArray[3] = true;
        blArray[4] = true;
        blArray[5] = true;
        blArray[6] = true;
        blArray[7] = true;
        IS_NUMERICAL = blArray;
        MAX_VALUES_STRING = "true|127|z|32767|2147483647|9223372036854775807|3.4028235E38|1.7976931348623157E308|";
    }

    private static String fillIn(String template, int idx) {
        return template.replaceAll("PRIM", PRIMITIVES[idx]).replaceAll("BOX", BOXES[idx]).replace("NEGVAL", NEGVALUES[idx]).replace("VAL", GOODVALUES[idx]).replace("MAX", MAXVALUES[idx]);
    }

    private static String fillInMax(String template, int idx, boolean useMax) {
        return template.replaceAll("PRIM", PRIMITIVES[idx]).replaceAll("BOX", BOXES[idx]).replace("NEGVAL", NEGVALUES[idx]).replace("VAL", useMax ? MAXVALUES[idx] : GOODVALUES[idx]);
    }

    static String toConstantOfType(String constVal, String ptype) {
        return switch (ptype) {
            case "long" -> constVal + "L";
            case "float" -> constVal + "f";
            case "double" -> constVal + "d";
            default -> constVal;
        };
    }

    public static Class<?> testClass() {
        return PrimitiveInPatternsTestSH.class;
    }

    public static Test suite() {
        return PrimitiveInPatternsTestSH.buildMinimalComplianceTestSuite(PrimitiveInPatternsTestSH.testClass(), 0x200000);
    }

    public PrimitiveInPatternsTestSH(String testName) {
        super(testName);
    }

    @Override
    protected void setUp() throws Exception {
        this.runJavacOptIn = true;
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        this.runJavacOptIn = false;
    }

    protected Map<String, String> getCompilerOptions(boolean preview) {
        Map<String, String> defaultOptions = super.getCompilerOptions();
        defaultOptions.put("org.eclipse.jdt.core.compiler.compliance", "24");
        defaultOptions.put("org.eclipse.jdt.core.compiler.source", "24");
        defaultOptions.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "24");
        defaultOptions.put("org.eclipse.jdt.core.compiler.problem.enablePreviewFeatures", preview ? "enabled" : "disabled");
        defaultOptions.put("org.eclipse.jdt.core.compiler.problem.reportPreviewFeatures", "warning");
        return defaultOptions;
    }

    @Override
    protected Map<String, String> getCompilerOptions() {
        return this.getCompilerOptions(false);
    }

    @Override
    protected String[] getDefaultClassPaths() {
        String[] libs = DefaultJavaRuntimeEnvironment.getDefaultClassPaths();
        if (this.extraLibPath != null) {
            String[] l = new String[libs.length + 1];
            System.arraycopy(libs, 0, l, 0, libs.length);
            l[libs.length] = this.extraLibPath;
            return l;
        }
        return libs;
    }

    @Override
    protected INameEnvironment getNameEnvironment(String[] testFiles, String[] classPaths, Map<String, String> options) {
        INameEnvironment[] classLibs;
        this.classpaths = classPaths == null ? this.getDefaultClassPaths() : classPaths;
        INameEnvironment[] iNameEnvironmentArray = classLibs = this.getClassLibs(false, options);
        int n = classLibs.length;
        int n2 = 0;
        while (n2 < n) {
            INameEnvironment nameEnvironment = iNameEnvironmentArray[n2];
            ((FileSystem)nameEnvironment).scanForModules(this.createParser());
            ++n2;
        }
        return new InMemoryNameEnvironment9(testFiles, this.moduleMap, classLibs);
    }

    @Override
    protected void runConformTest(String[] testFiles, String expectedOutput) {
        this.runConformTest(testFiles, expectedOutput, this.getCompilerOptions(true), VMARGS, JAVAC_OPTIONS);
        this.checkPreviewFlag(testFiles);
    }

    @Override
    protected void runConformTest(String[] testFiles, String expectedOutput, Map<String, String> customOptions) {
        if (!isJRE23Plus) {
            return;
        }
        this.runConformTest(testFiles, expectedOutput, customOptions, VMARGS, JAVAC_OPTIONS);
        this.checkPreviewFlag(testFiles);
    }

    @Override
    protected void runConformTest(String[] testFiles, String expectedOutputString, String[] classLibraries, boolean shouldFlushOutputDirectory, String[] vmArguments) {
        this.runTest(shouldFlushOutputDirectory, testFiles, classLibraries, null, false, null, false, null, false, vmArguments, expectedOutputString, null, AbstractRegressionTest.JavacTestOptions.DEFAULT);
        this.checkPreviewFlag(testFiles);
    }

    void checkPreviewFlag(String[] testFiles) {
        String className = testFiles[0].replace(".java", ".class");
        try {
            this.verifyClassFile("version 24 : 68.65535", className, 4);
        }
        catch (IOException | ClassFormatException e) {
            e.printStackTrace();
            PrimitiveInPatternsTestSH.fail((String)e.getMessage());
        }
    }

    private void runConformTest_skipPreviewCheck(String[] testFiles, String expectedOutput) {
        this.runConformTest(testFiles, expectedOutput, this.getCompilerOptions(true), VMARGS, JAVAC_OPTIONS);
    }

    @Override
    protected void runNegativeTest(String[] testFiles, String expectedCompilerLog) {
        Map<String, String> customOptions = this.getCompilerOptions(true);
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.testFiles = testFiles;
        runner.expectedCompilerLog = expectedCompilerLog;
        runner.javacTestOptions = JAVAC_OPTIONS;
        runner.customOptions = customOptions;
        runner.expectedJavacOutputString = null;
        runner.runNegativeTest();
    }

    protected void runNegativeTest(String[] testFiles, String expectedCompilerLog, String javacLog, String[] classLibraries, boolean shouldFlushOutputDirectory, Map<String, String> customOptions) {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.testFiles = testFiles;
        runner.expectedCompilerLog = expectedCompilerLog;
        runner.javacTestOptions = JAVAC_OPTIONS;
        runner.customOptions = customOptions;
        runner.expectedJavacOutputString = javacLog;
        runner.runNegativeTest();
    }

    public void testIdentity() throws IOException, ClassFormatException {
        StringBuilder methods = new StringBuilder();
        StringBuilder calls = new StringBuilder();
        String methodTmpl = "\tpublic static PRIM fooPRIM(PRIM v) {\n\t\tif (v instanceof PRIM) {\n\t\t\treturn v;\n\t\t}\n\t\treturn NEGVAL;\n\t}\n";
        String callTmpl = "\t\tPRIM vPRIM = VAL;\n\t\tSystem.out.print(X.fooPRIM(vPRIM));\n\t\tSystem.out.print('|');\n";
        int i = 0;
        while (i < PRIMITIVES.length) {
            methods.append(PrimitiveInPatternsTestSH.fillIn(methodTmpl, i));
            calls.append(PrimitiveInPatternsTestSH.fillInMax(callTmpl, i, true));
            ++i;
        }
        StringBuilder classX = new StringBuilder("public class X {\n");
        classX.append(methods.toString());
        classX.append("public static void main(String[] args) {\n");
        classX.append((CharSequence)calls);
        classX.append("}}\n");
        this.runConformTest(new String[]{"X.java", classX.toString()}, MAX_VALUES_STRING);
        this.verifyClassFile("version 24 : 68.65535", "X.class", 4);
    }

    public void testIdentityPattern() {
        StringBuilder methods = new StringBuilder();
        StringBuilder calls = new StringBuilder();
        String methodTmpl = "\tpublic static PRIM fooPRIM(PRIM v) {\n\t\tif (v instanceof PRIM vv) {\n\t\t\treturn vv;\n\t\t}\n\t\treturn NEGVAL;\n\t}\n";
        String callTmpl = "\t\tPRIM vPRIM = VAL;\n\t\tSystem.out.print(X.fooPRIM(vPRIM));\n\t\tSystem.out.print('|');\n";
        int i = 0;
        while (i < PRIMITIVES.length) {
            methods.append(PrimitiveInPatternsTestSH.fillIn(methodTmpl, i));
            calls.append(PrimitiveInPatternsTestSH.fillInMax(callTmpl, i, true));
            ++i;
        }
        StringBuilder classX = new StringBuilder("public class X {\n");
        classX.append(methods.toString());
        classX.append("public static void main(String[] args) {\n");
        classX.append((CharSequence)calls);
        classX.append("}}\n");
        this.runConformTest(new String[]{"X.java", classX.toString()}, MAX_VALUES_STRING);
    }

    public void testIdentity_functionLhs() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static byte foo() {\n\t\tif (bar() instanceof byte) {\n\t\t\tbyte b = (byte) bar();\n\t\t\treturn b;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static byte bar() {\n\t\tbyte b = 1;\n\t\treturn b;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(X.foo());\n\t}\n}\n"}, "1");
    }

    public void testIdentityPattern_functionLhs() {
        StringBuilder methods = new StringBuilder();
        StringBuilder calls = new StringBuilder();
        String methodTmpl = "\tpublic static PRIM fooPRIM() {\n\t\tif (barPRIM() instanceof PRIM vv) {\n\t\t\treturn vv;\n\t\t}\n\t\treturn NEGVAL;\n\t}\n\tpublic static PRIM barPRIM() {\n\t\treturn VAL;\n\t}\n";
        String callTmpl = "\t\tSystem.out.print(X.fooPRIM());\n\t\tSystem.out.print('|');\n";
        int i = 0;
        while (i < PRIMITIVES.length) {
            methods.append(PrimitiveInPatternsTestSH.fillIn(methodTmpl, i));
            calls.append(PrimitiveInPatternsTestSH.fillIn(callTmpl, i));
            ++i;
        }
        StringBuilder classX = new StringBuilder("public class X {\n");
        classX.append(methods.toString());
        classX.append("public static void main(String[] args) {\n");
        classX.append((CharSequence)calls);
        classX.append("}}\n");
        this.runConformTest(new String[]{"X.java", classX.toString()}, "true|49|1|49|49|49|49.0|49.0|");
    }

    private void testWideningFrom(String from, int idx, boolean useMax, String expectedOut) {
        assert (from.equals(PRIMITIVES[idx])) : "mismatch between from and idx";
        StringBuilder methods = new StringBuilder();
        StringBuilder calls = new StringBuilder();
        String methodTmpl = "\tpublic static PRIM fooPRIM(FROM v) {\n\t\tif (v instanceof PRIM) {\n\t\t\tPRIM vv = (PRIM) v;\n\t\t\treturn vv;\n\t\t}\n\t\treturn NEGVAL;\n\t}\n";
        String callTmpl = "\t\tSystem.out.print(X.fooPRIM(v));\n\t\tSystem.out.print('|');\n";
        int i = idx + 1;
        while (i < PRIMITIVES.length) {
            if (IS_NUMERICAL[i]) {
                methods.append(PrimitiveInPatternsTestSH.fillIn(methodTmpl.replace("FROM", from), i));
                calls.append(PrimitiveInPatternsTestSH.fillIn(callTmpl, i));
            }
            ++i;
        }
        StringBuilder classX = new StringBuilder("public class X {\n");
        classX.append(methods.toString());
        classX.append("public static void main(String[] args) {\n");
        classX.append(PrimitiveInPatternsTestSH.fillInMax("PRIM v = VAL;\n", idx, useMax));
        classX.append((CharSequence)calls);
        classX.append("}}\n");
        this.runConformTest(new String[]{"X.java", classX.toString()}, expectedOut);
    }

    private void testWideningFrom_pattern(String from, int idx, boolean useMax, String expectedOut) {
        assert (from.equals(PRIMITIVES[idx])) : "mismatch between from and idx";
        StringBuilder methods = new StringBuilder();
        StringBuilder calls = new StringBuilder();
        String methodTmpl = "\tpublic static PRIM fooPRIM() {\n\t\tif (bar() instanceof PRIM vv) {\n\t\t\treturn vv;\n\t\t}\n\t\treturn NEGVAL;\n\t}\n";
        String methodBar = PrimitiveInPatternsTestSH.fillInMax("static PRIM bar() {\n\treturn VAL;\n}\n", idx, useMax);
        String callTmpl = "\t\tSystem.out.print(X.fooPRIM());\n\t\tSystem.out.print('|');\n";
        int i = idx + 1;
        while (i < PRIMITIVES.length) {
            if (IS_NUMERICAL[i]) {
                methods.append(PrimitiveInPatternsTestSH.fillIn(methodTmpl, i));
                calls.append(PrimitiveInPatternsTestSH.fillIn(callTmpl, i));
            }
            ++i;
        }
        StringBuilder classX = new StringBuilder("public class X {\n");
        classX.append(methods.toString());
        classX.append(methodBar);
        classX.append("public static void main(String[] args) {\n");
        classX.append((CharSequence)calls);
        classX.append("}}\n");
        this.runConformTest(new String[]{"X.java", classX.toString()}, expectedOut);
    }

    private void testWideningFrom_both(String prim, int idx, boolean useMax, String expectedOut) {
        this.testWideningFrom(prim, idx, useMax, expectedOut);
        this.testWideningFrom_pattern(prim, idx, useMax, expectedOut);
    }

    public void testWideningByte() {
        this.testWideningFrom_both("byte", 1, false, "49|49|49|49.0|49.0|");
        this.testWideningFrom_both("byte", 1, true, "127|127|127|127.0|127.0|");
    }

    public void testWideningChar() {
        this.testWideningFrom_both("char", 2, false, "49|49|49|49.0|49.0|");
        this.testWideningFrom_both("char", 2, true, "122|122|122|122.0|122.0|");
    }

    public void testWideningShort() {
        this.testWideningFrom_both("short", 3, false, "49|49|49.0|49.0|");
        this.testWideningFrom_both("short", 3, true, "32767|32767|32767.0|32767.0|");
    }

    public void testWideningInt() {
        this.testWideningFrom_both("int", 4, false, "49|49.0|49.0|");
        this.testWideningFrom_both("int", 4, true, "2147483647|-1.0|" + String.valueOf(2.147483647E9) + "|");
    }

    public void testWideningLong() {
        this.testWideningFrom_both("long", 5, false, "49.0|49.0|");
        this.testWideningFrom_both("long", 5, true, "-1.0|-1.0|");
    }

    public void testWideningFloat() {
        this.testWideningFrom_both("float", 6, false, "49.0|");
        this.testWideningFrom_both("float", 6, true, String.valueOf(3.4028234663852886E38) + "|");
    }

    private void testNarrowingFrom(String from, int idx, boolean useMax, String expectedOut) {
        assert (from.equals(PRIMITIVES[idx])) : "mismatch between from and idx";
        StringBuilder methods = new StringBuilder();
        StringBuilder calls = new StringBuilder();
        String methodTmpl = "\tpublic static PRIM fooPRIM(FROM v) {\n\t\tif (v instanceof PRIM) {\n\t\t\tPRIM vv = (PRIM) v;\n\t\t\treturn vv;\n\t\t}\n\t\treturn NEGVAL;\n\t}\n";
        String methodPrint = "static void print(Object o) {\n\tif (o instanceof Character && ((int)((char) o) > 127))\n\t\tSystem.out.print((int)((char) o)); // avoid char encoding issues\n\telse\n\t\tSystem.out.print(o);\n\tSystem.out.print('|');\n}\n";
        String callTmpl = "\t\tprint(X.fooPRIM(v));\n";
        int i = 1;
        while (i < idx) {
            methods.append(PrimitiveInPatternsTestSH.fillIn(methodTmpl.replace("FROM", from), i));
            calls.append(PrimitiveInPatternsTestSH.fillIn(callTmpl, i));
            ++i;
        }
        StringBuilder classX = new StringBuilder("public class X {\n");
        classX.append(methods.toString());
        classX.append(methodPrint);
        classX.append("public static void main(String[] args) {\n");
        classX.append(PrimitiveInPatternsTestSH.fillInMax("PRIM v = VAL;\n", idx, useMax));
        classX.append((CharSequence)calls);
        classX.append("}}\n");
        this.runConformTest(new String[]{"X.java", classX.toString()}, expectedOut);
    }

    private void testNarrowingFrom_pattern(String from, int idx, boolean useMax, String expectedOut) {
        assert (from.equals(PRIMITIVES[idx])) : "mismatch between from and idx";
        StringBuilder methods = new StringBuilder();
        StringBuilder calls = new StringBuilder();
        String methodTmpl = "\tpublic static PRIM fooPRIM() {\n\t\tif (bar() instanceof PRIM vv) {\n\t\t\treturn vv;\n\t\t}\n\t\treturn NEGVAL;\n\t}\n";
        String methodBar = PrimitiveInPatternsTestSH.fillInMax("static PRIM bar() {\n\treturn VAL;\n}\n", idx, useMax);
        String methodPrint = "static void print(Object o) {\n\tif (o instanceof Character && ((int)((char) o) > 127))\n\t\tSystem.out.print((int)((char) o)); // avoid char encoding issues\n\telse\n\t\tSystem.out.print(o);\n\tSystem.out.print('|');\n}\n";
        String callTmpl = "\t\tprint(X.fooPRIM());\n";
        int i = 1;
        while (i < idx) {
            methods.append(PrimitiveInPatternsTestSH.fillIn(methodTmpl, i));
            calls.append(PrimitiveInPatternsTestSH.fillIn(callTmpl, i));
            ++i;
        }
        StringBuilder classX = new StringBuilder("public class X {\n");
        classX.append(methods.toString());
        classX.append(methodBar);
        classX.append(methodPrint);
        classX.append("public static void main(String[] args) {\n");
        classX.append((CharSequence)calls);
        classX.append("}}\n");
        this.runConformTest(new String[]{"X.java", classX.toString()}, expectedOut);
    }

    private void testNarrowingFrom_both(String prim, int idx, boolean useMax, String expectedOut) {
        this.testNarrowingFrom(prim, idx, useMax, expectedOut);
        this.testNarrowingFrom_pattern(prim, idx, useMax, expectedOut);
    }

    public void testNarrowingDouble() {
        this.testNarrowingFrom_both("double", 7, false, "49|1|49|49|49|49.0|");
        this.testNarrowingFrom_both("double", 7, true, "-1|-|-1|-1|-1|-1.0|");
    }

    public void testNarrowingFloat() {
        this.testNarrowingFrom_both("float", 6, false, "49|1|49|49|49|");
        this.testNarrowingFrom_both("float", 6, true, "-1|-|-1|-1|-1|");
    }

    public void testNarrowingLong() {
        this.testNarrowingFrom_both("long", 5, false, "49|1|49|49|");
        this.testNarrowingFrom_both("long", 5, true, "-1|-|-1|-1|");
    }

    public void testNarrowingInt() {
        this.testNarrowingFrom_both("int", 4, false, "49|1|49|");
        this.testNarrowingFrom_both("int", 4, true, "-1|-|-1|");
    }

    public void testNarrowingShort() {
        this.testNarrowingFrom_both("short", 3, false, "49|1|");
        this.testNarrowingFrom_both("short", 3, true, "-1|32767|");
    }

    public void testNarrowingChar() {
        this.testNarrowingFrom_both("char", 2, false, "49|");
    }

    public void testNarrowingChar_various() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static char b2c(byte b) {\n\t\tif (b instanceof char) {\n\t\t\treturn (char) b;\n\t\t}\n\t\treturn '-';\n\t}\n\tpublic static char s2c(short s) {\n\t\tif (s instanceof char) {\n\t\t\treturn (char) s;\n\t\t}\n\t\treturn '-';\n\t}\n\tpublic static short c2s(char c) {\n\t\tif (c instanceof short) {\n\t\t\treturn (short) c;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static char b2c_pat(byte b) {\n\t\tif (b instanceof char v) {\n\t\t\treturn v;\n\t\t}\n\t\treturn '-';\n\t}\n\tpublic static char s2c_pat(short s) {\n\t\tif (s instanceof char v) {\n\t\t\treturn v;\n\t\t}\n\t\treturn '-';\n\t}\n\tpublic static short c2s_pat(char c) {\n\t\tif (c instanceof short v) {\n\t\t\treturn v;\n\t\t}\n\t\treturn -1;\n\t}\n\tpublic static void main(String[] args) {\n\t\tbyte b=49, bmax=Byte.MAX_VALUE;\n\t\tshort s=49, smax=Short.MAX_VALUE;\n\t\tchar c='1', cmax=Character.MAX_VALUE;\n\t\tprint(X.b2c(b));\n\t\tprint(X.s2c(s));\n\t\tprint(X.c2s(c));\n\t\tprint(X.b2c(bmax));\n\t\tprint(X.s2c(smax));\n\t\tprint(X.c2s(cmax));\n\t\tSystem.out.println();\n\t\tprint(X.b2c_pat(b));\n\t\tprint(X.s2c_pat(s));\n\t\tprint(X.c2s_pat(c));\n\t\tprint(X.b2c_pat(bmax));\n\t\tprint(X.s2c_pat(smax));\n\t\tprint(X.c2s_pat(cmax));\n\t}\n\tstatic void print(Object s) {\n\t\tif (s instanceof Character)\n\t\t\tSystem.out.print((int)((char) s)); // avoid char encoding issues\n\t\telse\n\t\t\tSystem.out.print(s);\n\t\tSystem.out.print('|');\n\t}\n}\n"}, "49|49|49|127|32767|-1|\n49|49|49|127|32767|-1|");
    }

    public void testBoxing() {
        StringBuilder methods = new StringBuilder();
        StringBuilder calls = new StringBuilder();
        String methodTmpl = "\tpublic static BOX PRIM2BOX(PRIM v) {\n\t\tif (v instanceof BOX) {\n\t\t\treturn (BOX) v;\n\t\t}\n\t\treturn NEGVAL;\n\t}\n";
        String callTmpl = "\t\tPRIM vPRIM = VAL;\n\t\tSystem.out.print(X.PRIM2BOX(vPRIM));\n\t\tSystem.out.print('|');\n";
        int i = 0;
        while (i < PRIMITIVES.length) {
            methods.append(PrimitiveInPatternsTestSH.fillIn(methodTmpl, i));
            calls.append(PrimitiveInPatternsTestSH.fillIn(callTmpl, i));
            ++i;
        }
        StringBuilder classX = new StringBuilder("public class X {\n");
        classX.append(methods.toString());
        classX.append("public static void main(String[] args) {\n");
        classX.append((CharSequence)calls);
        classX.append("}}\n");
        this.runConformTest(new String[]{"X.java", classX.toString()}, "true|49|1|49|49|49|49.0|49.0|");
    }

    public void testBoxing_pattern() {
        StringBuilder methods = new StringBuilder();
        StringBuilder calls = new StringBuilder();
        String methodTmpl = "\tpublic static BOX PRIM2BOX() {\n\t\tif (barPRIM() instanceof BOX v) {\n\t\t\treturn v;\n\t\t}\n\t\treturn NEGVAL;\n\t}\n\tstatic PRIM barPRIM() {\n\t\treturn VAL;\n\t}\n";
        String callTmpl = "\t\tSystem.out.print(X.PRIM2BOX());\n\t\tSystem.out.print('|');\n";
        int i = 0;
        while (i < PRIMITIVES.length) {
            methods.append(PrimitiveInPatternsTestSH.fillIn(methodTmpl, i));
            calls.append(PrimitiveInPatternsTestSH.fillIn(callTmpl, i));
            ++i;
        }
        StringBuilder classX = new StringBuilder("public class X {\n");
        classX.append(methods.toString());
        classX.append("public static void main(String[] args) {\n");
        classX.append((CharSequence)calls);
        classX.append("}}\n");
        this.runConformTest(new String[]{"X.java", classX.toString()}, "true|49|1|49|49|49|49.0|49.0|");
    }

    public void testUnboxing() {
        StringBuilder methods = new StringBuilder();
        StringBuilder calls = new StringBuilder();
        String methodTmpl = "\tpublic static PRIM BOX2PRIM(BOX v) {\n\t\tif (v instanceof PRIM) {\n\t\t\treturn (PRIM) v;\n\t\t}\n\t\treturn NEGVAL;\n\t}\n";
        String callTmpl = "\t\tBOX vBOX = VAL;\n\t\tSystem.out.print(X.BOX2PRIM(vBOX));\n\t\tSystem.out.print('|');\n";
        int i = 0;
        while (i < PRIMITIVES.length) {
            methods.append(PrimitiveInPatternsTestSH.fillIn(methodTmpl, i));
            calls.append(PrimitiveInPatternsTestSH.fillIn(callTmpl, i));
            ++i;
        }
        StringBuilder classX = new StringBuilder("public class X {\n");
        classX.append(methods.toString());
        classX.append("public static void main(String[] args) {\n");
        classX.append((CharSequence)calls);
        classX.append("}}\n");
        this.runConformTest(new String[]{"X.java", classX.toString()}, "true|49|1|49|49|49|49.0|49.0|");
    }

    public void testUnboxing_pattern() {
        StringBuilder methods = new StringBuilder();
        StringBuilder calls = new StringBuilder();
        String methodTmpl = "\tpublic static PRIM BOX2PRIM() {\n\t\tif (barBOX() instanceof PRIM v) {\n\t\t\treturn v;\n\t\t}\n\t\treturn NEGVAL;\n\t}\n\tstatic BOX barBOX() {\n\t\treturn VAL;\n\t}\n";
        String callTmpl = "\t\tSystem.out.print(X.BOX2PRIM());\n\t\tSystem.out.print('|');\n";
        int i = 0;
        while (i < PRIMITIVES.length) {
            methods.append(PrimitiveInPatternsTestSH.fillIn(methodTmpl, i));
            calls.append(PrimitiveInPatternsTestSH.fillIn(callTmpl, i));
            ++i;
        }
        StringBuilder classX = new StringBuilder("public class X {\n");
        classX.append(methods.toString());
        classX.append("public static void main(String[] args) {\n");
        classX.append((CharSequence)calls);
        classX.append("}}\n");
        this.runConformTest(new String[]{"X.java", classX.toString()}, "true|49|1|49|49|49|49.0|49.0|");
    }

    private void primitive2Comparable(String prim, int idx, String expectedOut) {
        Object methodTmpl = "\t@SuppressWarnings(\"rawtypes\")\n\tpublic static Comparable foo1(PRIM v) {\n\t\tif (v instanceof Comparable r) {\n\t\t\treturn r;\n\t\t}\n\t\treturn null;\n\t}\n\t@SuppressWarnings({\"rawtypes\", \"unchecked\" })\n\tpublic static Comparable<BOX> foo2(PRIM v) {\n\t\tif (v instanceof Comparable r) {\n\t\t\treturn r;\n\t\t}\n\t\treturn null;\n\t}\n\t@SuppressWarnings(\"unchecked\")\n\tpublic static Comparable<BOX> foo3(PRIM v) {\n\t\tif (v instanceof Comparable<BOX> r) {\n\t\t\treturn r;\n\t\t}\n\t\treturn null;\n\t}\n";
        Object callTmpl = "\t\tPRIM vPRIM = VAL;\n\t\tSystem.out.print(X.foo1(vPRIM));\n\t\tSystem.out.print('|');\n\t\tSystem.out.print(X.foo2(vPRIM));\n\t\tSystem.out.print('|');\n\t\tSystem.out.print(X.foo3(vPRIM));\n\t\tSystem.out.print('|');\n";
        if (IS_NUMERICAL[idx]) {
            methodTmpl = (String)methodTmpl + "\tpublic static Number foo4(PRIM v) {\n\t\tif (v instanceof Number r) {\n\t\t\treturn r;\n\t\t}\n\t\treturn null;\n\t}\n";
            callTmpl = (String)callTmpl + "\tSystem.out.print(X.foo4(vPRIM));\n\tSystem.out.print('|');\n";
        }
        StringBuilder classX = new StringBuilder("public class X {\n");
        classX.append(PrimitiveInPatternsTestSH.fillIn((String)methodTmpl, idx));
        classX.append("public static void main(String[] args) {\n");
        classX.append(PrimitiveInPatternsTestSH.fillIn((String)callTmpl, idx));
        classX.append("}}\n");
        this.runConformTest(new String[]{"X.java", classX.toString()}, expectedOut);
    }

    public void test2Comparable_boolean() {
        this.primitive2Comparable("boolean", 0, "true|true|true|");
    }

    public void test2Comparable_byte() {
        this.primitive2Comparable("byte", 1, "49|49|49|49|");
    }

    public void test2Comparable_char() {
        this.primitive2Comparable("char", 2, "1|1|1|");
    }

    public void test2Comparable_short() {
        this.primitive2Comparable("short", 3, "49|49|49|49|");
    }

    public void test2Comparable_int() {
        this.primitive2Comparable("int", 4, "49|49|49|49|");
    }

    public void test2Comparable_long() {
        this.primitive2Comparable("long", 5, "49|49|49|49|");
    }

    public void test2Comparable_float() {
        this.primitive2Comparable("float", 6, "49.0|49.0|49.0|49.0|");
    }

    public void test2Comparable_double() {
        this.primitive2Comparable("double", 7, "49.0|49.0|49.0|49.0|");
    }

    public void test2Number_NOK() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static Number foo1(boolean b) {\n\t\tif (b instanceof Number r) {\n\t\t\treturn r;\n\t\t}\n\t\treturn null;\n\t}\n\tpublic static Number foo2(char c) {\n\t\tif (c instanceof Number r) {\n\t\t\treturn r;\n\t\t}\n\t\treturn null;\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tif (b instanceof Number r) {\n\t    ^^^^^^^^^^^^^^^^^^^^^\nIncompatible conditional operand types boolean and Number\n----------\n2. ERROR in X.java (at line 9)\n\tif (c instanceof Number r) {\n\t    ^^^^^^^^^^^^^^^^^^^^^\nIncompatible conditional operand types char and Number\n----------\n");
    }

    public void testNonPrim001() {
        super.runConformTest(new String[]{"X.java", "class Y<T> {\n    public boolean foo(T t) {\n        if (t instanceof T) {\n            return false;\n        }\n        return true;\n    }\n}\n\npublic class X  {\n    public static void main(String argv[]) {\n    \tSystem.out.println(new Y<X>().foo(null));\n    }\n}\n"}, "true");
    }

    public void testPrimitivePatternInSwitch() {
        StringBuilder methods = new StringBuilder();
        StringBuilder calls = new StringBuilder();
        String methodTmpl = "\tpublic static PRIM switchPRIM(PRIM in) {\n\t\treturn switch (in) {\n\t\t\tcase MAX -> NEGVAL;\n\t\t\tcase PRIM v -> v;\n\t\t};\n\t}\n";
        String callTmpl = "\t\tPRIM vPRIM = VAL;\n\t\tSystem.out.print(X.switchPRIM(vPRIM));\n\t\tSystem.out.print('|');\n\t\tvPRIM = MAX;\n\t\tSystem.out.print(X.switchPRIM(vPRIM));\n\t\tSystem.out.print('|');\n";
        int i = 0;
        while (i < PRIMITIVES.length) {
            methods.append(PrimitiveInPatternsTestSH.fillIn(methodTmpl, i));
            calls.append(PrimitiveInPatternsTestSH.fillIn(callTmpl, i));
            ++i;
        }
        StringBuilder classX = new StringBuilder("public class X {\n");
        classX.append(methods.toString());
        classX.append("public static void main(String[] args) {\n");
        classX.append((CharSequence)calls);
        classX.append("}}\n");
        this.runConformTest(new String[]{"X.java", classX.toString()}, "false|false|49|-1|1|-|49|-1|49|-1|49|-1|49.0|-1.0|49.0|-1.0|");
    }

    public void testPrimitivePatternInSwitch_unbox() {
        StringBuilder methods = new StringBuilder();
        StringBuilder calls = new StringBuilder();
        String methodTmpl = "\tpublic static PRIM switchPRIM(BOX in) {\n\t\treturn switch (in) {\n\t\t\tcase MAX -> NEGVAL;\n\t\t\tcase PRIM v -> v;\n\t\t};\n\t}\n";
        String callTmpl = "\t\tBOX vBOX = VAL;\n\t\tSystem.out.print(X.switchPRIM(vBOX));\n\t\tSystem.out.print('|');\n\t\tvBOX = MAX;\n\t\tSystem.out.print(X.switchPRIM(vBOX));\n\t\tSystem.out.print('|');\n";
        int i = 0;
        while (i < PRIMITIVES.length) {
            methods.append(PrimitiveInPatternsTestSH.fillIn(methodTmpl, i));
            calls.append(PrimitiveInPatternsTestSH.fillIn(callTmpl, i));
            ++i;
        }
        StringBuilder classX = new StringBuilder("public class X {\n");
        classX.append(methods.toString());
        classX.append("public static void main(String[] args) {\n");
        classX.append((CharSequence)calls);
        classX.append("}}\n");
        this.runConformTest(new String[]{"X.java", classX.toString()}, "false|false|49|-1|1|-|49|-1|49|-1|49|-1|49.0|-1.0|49.0|-1.0|");
    }

    public void testPrimitivePatternInSwitch_narrowConst_NOK() {
        StringBuilder methods = new StringBuilder();
        StringBuilder calls = new StringBuilder();
        String methodTmpl = "\tpublic static PRIM switchPRIM(Object in) {\n\t\treturn switch (in) {\n\t\t\tcase MAX -> NEGVAL;\n\t\t\tdefault -> MAX;\n\t\t};\n\t}\n";
        String callTmpl = "\t\tBOX vBOX = VAL;\n\t\tSystem.out.print(X.switchPRIM(vBOX));\n\t\tSystem.out.print('|');\n\t\tvBOX = MAX;\n\t\tSystem.out.print(X.switchPRIM(vBOX));\n\t\tSystem.out.print('|');\n";
        int i = 0;
        while (i < PRIMITIVES.length) {
            methods.append(PrimitiveInPatternsTestSH.fillIn(methodTmpl, i));
            calls.append(PrimitiveInPatternsTestSH.fillIn(callTmpl, i));
            ++i;
        }
        StringBuilder classX = new StringBuilder("public class X {\n");
        classX.append(methods.toString());
        classX.append("public static void main(String[] args) {\n");
        classX.append((CharSequence)calls);
        classX.append("}}\n");
        this.runNegativeTest(new String[]{"X.java", classX.toString()}, "----------\n1. ERROR in X.java (at line 4)\n\tcase true -> false;\n\t     ^^^^\nCase constant of type boolean is incompatible with switch selector type Object\n----------\n2. ERROR in X.java (at line 10)\n\tcase Byte.MAX_VALUE -> -1;\n\t     ^^^^^^^^^^^^^^\nCase constant of type byte is incompatible with switch selector type Object\n----------\n3. ERROR in X.java (at line 16)\n\tcase 'z' -> '-';\n\t     ^^^\nCase constant of type char is incompatible with switch selector type Object\n----------\n4. ERROR in X.java (at line 22)\n\tcase Short.MAX_VALUE -> -1;\n\t     ^^^^^^^^^^^^^^^\nCase constant of type short is incompatible with switch selector type Object\n----------\n5. ERROR in X.java (at line 28)\n\tcase Integer.MAX_VALUE -> -1;\n\t     ^^^^^^^^^^^^^^^^^\nCase constant of type int is incompatible with switch selector type Object\n----------\n6. ERROR in X.java (at line 34)\n\tcase Long.MAX_VALUE -> -1L;\n\t     ^^^^^^^^^^^^^^\nCase constant of type long is incompatible with switch selector type Object\n----------\n7. ERROR in X.java (at line 40)\n\tcase Float.MAX_VALUE -> -1.0f;\n\t     ^^^^^^^^^^^^^^^\nCase constant of type float is incompatible with switch selector type Object\n----------\n8. ERROR in X.java (at line 46)\n\tcase Double.MAX_VALUE -> -1.0d;\n\t     ^^^^^^^^^^^^^^^^\nCase constant of type double is incompatible with switch selector type Object\n----------\n");
    }

    public void testPrimitivePatternInSwitch_narrowUnbox() {
        StringBuilder methods = new StringBuilder();
        StringBuilder calls = new StringBuilder();
        String methodTmpl = "\tpublic static PRIM switchPRIM(Object in) {\n\t\treturn switch (in) {\n\t\t\tcase PRIM v -> v;\n\t\t\tdefault -> NEGVAL;\n\t\t};\n\t}\n";
        String callTmpl = "\t\tBOX vBOX = VAL;\n\t\tSystem.out.print(X.switchPRIM(vBOX));\n\t\tSystem.out.print('|');\n\t\tSystem.out.print(X.switchPRIM(new Object()));\n\t\tSystem.out.print('|');\n";
        int i = 0;
        while (i < PRIMITIVES.length) {
            methods.append(PrimitiveInPatternsTestSH.fillIn(methodTmpl, i));
            calls.append(PrimitiveInPatternsTestSH.fillIn(callTmpl, i));
            ++i;
        }
        StringBuilder classX = new StringBuilder("public class X {\n");
        classX.append(methods.toString());
        classX.append("public static void main(String[] args) {\n");
        classX.append((CharSequence)calls);
        classX.append("}}\n");
        this.runConformTest(new String[]{"X.java", classX.toString()}, "true|false|49|-1|1|-|49|-1|49|-1|49|-1|49.0|-1.0|49.0|-1.0|");
    }

    private void testPrimitivePatternInSwitch_from_unboxAndNarrow_NOK(String from, int idx, String expectedError) {
        assert (from.equals(BOXES[idx])) : "mismatching from vs idx";
        StringBuilder methods = new StringBuilder();
        StringBuilder calls = new StringBuilder();
        String classTmpl = "public class X {\nMETHODS\n\tpublic static void main(String... args) {\n\t\tFROM vFROM= VAL;\nCALLS\n\t}\n}\n".replaceAll("FROM", from).replace("VAL", GOODVALUES[idx]);
        String methodTmpl = "\tpublic static PRIM switchPRIM(FROM in) {\n\t\treturn switch (in) {\n\t\t\tcase PRIM v -> v;\n\t\t\tdefault -> throw new RuntimeException();\n\t\t};\n\t}\n".replace("FROM", from);
        String callTmpl = "\t\tSystem.out.print(X.switchPRIM(vFROM));\n\t\tSystem.out.print('|');\n".replaceAll("FROM", from);
        int i = 1;
        while (i < idx) {
            if (IS_NUMERICAL[i]) {
                methods.append(PrimitiveInPatternsTestSH.fillIn(methodTmpl, i));
                calls.append(PrimitiveInPatternsTestSH.fillIn(callTmpl, i));
            }
            ++i;
        }
        String classX = classTmpl.replace("METHODS", methods.toString()).replaceAll("CALLS", calls.toString());
        this.runNegativeTest(new String[]{"X.java", classX}, expectedError);
    }

    public void testPrimitivePatternInSwitchShort_unboxAndNarrow_NOK() {
        this.testPrimitivePatternInSwitch_from_unboxAndNarrow_NOK("Short", 3, "----------\n1. ERROR in X.java (at line 4)\n\tcase byte v -> v;\n\t     ^^^^^^\nType mismatch: cannot convert from Short to byte\n----------\n");
    }

    public void testPrimitivePatternInSwitchInt_unboxAndNarrow_NOK() {
        this.testPrimitivePatternInSwitch_from_unboxAndNarrow_NOK("Integer", 4, "----------\n1. ERROR in X.java (at line 4)\n\tcase byte v -> v;\n\t     ^^^^^^\nType mismatch: cannot convert from Integer to byte\n----------\n2. ERROR in X.java (at line 10)\n\tcase short v -> v;\n\t     ^^^^^^^\nType mismatch: cannot convert from Integer to short\n----------\n");
    }

    public void testPrimitivePatternInSwitchLong_unboxAndNarrow_NOK() {
        this.testPrimitivePatternInSwitch_from_unboxAndNarrow_NOK("Long", 5, "----------\n1. ERROR in X.java (at line 4)\n\tcase byte v -> v;\n\t     ^^^^^^\nType mismatch: cannot convert from Long to byte\n----------\n2. ERROR in X.java (at line 10)\n\tcase short v -> v;\n\t     ^^^^^^^\nType mismatch: cannot convert from Long to short\n----------\n3. ERROR in X.java (at line 16)\n\tcase int v -> v;\n\t     ^^^^^\nType mismatch: cannot convert from Long to int\n----------\n");
    }

    public void testPrimitivePatternInSwitchFloat_unboxAndNarrow_NOK() {
        this.testPrimitivePatternInSwitch_from_unboxAndNarrow_NOK("Float", 6, "----------\n1. ERROR in X.java (at line 4)\n\tcase byte v -> v;\n\t     ^^^^^^\nType mismatch: cannot convert from Float to byte\n----------\n2. ERROR in X.java (at line 10)\n\tcase short v -> v;\n\t     ^^^^^^^\nType mismatch: cannot convert from Float to short\n----------\n3. ERROR in X.java (at line 16)\n\tcase int v -> v;\n\t     ^^^^^\nType mismatch: cannot convert from Float to int\n----------\n4. ERROR in X.java (at line 22)\n\tcase long v -> v;\n\t     ^^^^^^\nType mismatch: cannot convert from Float to long\n----------\n");
    }

    public void testPrimitivePatternInSwitchDouble_unboxAndNarrow_NOK() {
        this.testPrimitivePatternInSwitch_from_unboxAndNarrow_NOK("Double", 7, "----------\n1. ERROR in X.java (at line 4)\n\tcase byte v -> v;\n\t     ^^^^^^\nType mismatch: cannot convert from Double to byte\n----------\n2. ERROR in X.java (at line 10)\n\tcase short v -> v;\n\t     ^^^^^^^\nType mismatch: cannot convert from Double to short\n----------\n3. ERROR in X.java (at line 16)\n\tcase int v -> v;\n\t     ^^^^^\nType mismatch: cannot convert from Double to int\n----------\n4. ERROR in X.java (at line 22)\n\tcase long v -> v;\n\t     ^^^^^^\nType mismatch: cannot convert from Double to long\n----------\n5. ERROR in X.java (at line 28)\n\tcase float v -> v;\n\t     ^^^^^^^\nType mismatch: cannot convert from Double to float\n----------\n");
    }

    public void testPrimitivePatternInSwitch_Character_unboxAndNarrow_NOK() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tstatic int m1(Character ch) {\n\t\treturn switch(ch) {\n\t\t\tcase byte b -> b;\n\t\t\tcase short s -> s;\n\t\t\tcase char c -> c;\n\t\t};\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tcase byte b -> b;\n\t     ^^^^^^\nType mismatch: cannot convert from Character to byte\n----------\n2. ERROR in X.java (at line 5)\n\tcase short s -> s;\n\t     ^^^^^^^\nType mismatch: cannot convert from Character to short\n----------\n");
    }

    public void testPrimitivePatternInSwitch_Character_unboxAndWiden() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tstatic int mint(Character ch) {\n\t\treturn switch(ch) {\n\t\t\tcase int v -> v;\n\t\t};\n\t}\n\tstatic long mlong(Character ch) {\n\t\treturn switch(ch) {\n\t\t\tcase long v -> v;\n\t\t};\n\t}\n\tstatic float mfloat(Character ch) {\n\t\treturn switch(ch) {\n\t\t\tcase float v -> v;\n\t\t};\n\t}\n\tstatic double mdouble(Character ch) {\n\t\treturn switch(ch) {\n\t\t\tcase double v -> v;\n\t\t};\n\t}\n\tpublic static void main(String... args) {\n\t\tSystem.out.print(mint('a'));\n\t\tSystem.out.print('|');\n\t\tSystem.out.print(mlong('b'));\n\t\tSystem.out.print('|');\n\t\tSystem.out.print(mfloat('c'));\n\t\tSystem.out.print('|');\n\t\tSystem.out.print(mdouble('d'));\n\t}\n}\n"}, "97|98|99.0|100.0");
    }

    public void testPrimitivePatternInSwitch_widenUnbox() {
        this.runConformTest(new String[]{"X.java", "import java.util.Optional;\npublic class X {\n\tstatic <T extends Integer> int mInteger(T in) {\n\t\treturn switch (in) {\n\t\t\tcase int v -> v;\n\t\t\tdefault -> -1;\n\t\t};\n\t}\n\tstatic int mShort(Optional<? extends Short> in) {\n\t\treturn switch (in.get()) {\n\t\t\tcase int v -> v;\n\t\t\tdefault -> -1;\n\t\t};\n\t}\n\tpublic static void main(String... args) {\n\t\tSystem.out.print(mInteger(Integer.valueOf(1)));\n\t\tSystem.out.print(mShort(Optional.of(Short.valueOf((short) 2))));\n\t}\n}\n"}, "12");
    }

    void testInstanceof_widenUnbox(String fromBox, int idx, String expectedOuts) {
        String m1 = "static <T extends FROM> PRIM m1PRIM(T in) {\n\tif (in instanceof PRIM v) return v;\n\treturn NEGVAL;\n}\n".replace("FROM", fromBox);
        String m2 = "static PRIM m2PRIM(Optional<? extends FROM> in) {\n\tif (in.get() instanceof PRIM v) return v;\n\treturn NEGVAL;\n}\n".replace("FROM", fromBox);
        StringBuilder clazz = new StringBuilder();
        clazz.append("import java.util.Optional;\npublic class X {\n");
        StringBuilder main = new StringBuilder();
        main.append("public static void main(String... args) {\n");
        main.append("\tFROM v = FROM.valueOf((CAST) VAL);\n".replace("FROM", fromBox).replace("CAST", PRIMITIVES[idx]).replace("VAL", GOODVALUES[idx]));
        String call1Tmpl = "\tSystem.out.print(m1PRIM(v));\n".replace("FROM", fromBox);
        String call2Tmpl = "\tSystem.out.print(m2PRIM(Optional.of(v)));\n".replace("FROM", fromBox);
        int i = idx + 1;
        while (i < 8) {
            if (IS_NUMERICAL[i]) {
                clazz.append(PrimitiveInPatternsTestSH.fillIn(m1, i));
                clazz.append(PrimitiveInPatternsTestSH.fillIn(m2, i));
                main.append(PrimitiveInPatternsTestSH.fillIn(call1Tmpl, i));
                main.append("\tSystem.out.print('+');\n");
                main.append(PrimitiveInPatternsTestSH.fillIn(call2Tmpl, i));
                main.append("\tSystem.out.print('|');\n");
            }
            ++i;
        }
        clazz.append((CharSequence)main);
        clazz.append("\t}\n}\n");
        this.runConformTest(new String[]{"X.java", clazz.toString()}, expectedOuts);
    }

    public void testInstanceof_widenUnbox_Byte() {
        this.testInstanceof_widenUnbox("Byte", 1, "49+49|49+49|49+49|49.0+49.0|49.0+49.0|");
    }

    public void testInstanceof_widenUnbox_Short() {
        this.testInstanceof_widenUnbox("Short", 3, "49+49|49+49|49.0+49.0|49.0+49.0|");
    }

    public void testInstanceof_widenUnbox_Integer() {
        this.testInstanceof_widenUnbox("Integer", 4, "49+49|49.0+49.0|49.0+49.0|");
    }

    public void testInstanceof_widenUnbox_Long() {
        this.testInstanceof_widenUnbox("Long", 5, "49.0+49.0|49.0+49.0|");
    }

    public void testInstanceof_widenUnbox_Float() {
        this.testInstanceof_widenUnbox("Float", 6, "49.0+49.0|");
    }

    public void testInstanceof_widenUnboxWiden() {
        this.runConformTest(new String[]{"X.java", "import java.util.List;\nimport java.util.Collections;\npublic class X {\n\tstatic <T extends Short> void typeVariableSingle(T single) {\n\t\tint i1 = single;\n\t\tSystem.out.print(i1);\n\t\tif (single instanceof int i)\n\t\t\tSystem.out.print(i);\n\t\telse\n\t\t\tSystem.out.print('-');\n\t\tswitch (single) {\n\t\t\tcase int i -> System.out.print(i);\n\t\t\tdefault -> System.out.print('-');\n\t\t}\n\t\tSystem.out.println();\n\t}\n\tstatic <T extends Short> void typeVariableList(List<T> list) {\n\t\tint i1 = list.get(0);\n\t\tSystem.out.print(i1);\n\t\tif (list.get(0) instanceof int i)\n\t\t\tSystem.out.print(i);\n\t\telse\n\t\t\tSystem.out.print('-');\n\t\tswitch (list.get(0)) {\n\t\t\tcase int i -> System.out.print(i);\n\t\t\tdefault -> System.out.print('-');\n\t\t}\n\t\tSystem.out.println();\n\t}\n\tstatic void wildcard(List<? extends Short> list) {\n\t\tint i1 = list.get(0);\n\t\tSystem.out.print(i1);\n\t\tif (list.get(0) instanceof int i)\n\t\t\tSystem.out.print(i);\n\t\telse\n\t\t\tSystem.out.print('-');\n\t\tswitch (list.get(0)) {\n\t\t\tcase int i -> System.out.print(i);\n\t\t\tdefault -> System.out.print('-');\n\t\t}\n\t\tSystem.out.println();\n\t}\n\tpublic static void main(String... args) {\n\t\tShort s = 1;\n\t\ttypeVariableSingle(s);\n\t\ttypeVariableList(Collections.singletonList(s));\n\t\twildcard(Collections.singletonList(s));\n\t}\n}\n"}, "111\n111\n111");
    }

    public void testInstanceof_genericExpression() {
        this.runConformTest(new String[]{"X.java", "import java.util.List;\nimport java.util.Collections;\npublic class X {\n\tstatic int mInteger(List<Integer> in) {\n\t\tif (in.get(0) instanceof int v) // pattern is total, still the cast to Integer must be generated\n\t\t\treturn v;\n\t\treturn -1;\n\t}\n\tpublic static void main(String... args) {\n\t\tSystem.out.print(mInteger(Collections.singletonList(Integer.valueOf(1))));\n\t}\n}\n"}, "1");
    }

    public void testPrimitivePatternInSwitch_more() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static String switchbool(boolean in) {\n\t\t// generic test couldn't differentiate cases by output\n\t\treturn switch (in) {\n\t\t\tcase true -> \"true\";\n\t\t\tcase boolean v -> \"v=\"+String.valueOf(v);\n\t\t};\n\t}\n\tpublic static String switchfloatMoreCases(float f) {\n\t\treturn switch (f) {\n\t\t    case float v when v == 1.6 -> \"v=\"+String.valueOf(v);\n\t\t\tcase 1.0f -> \"1.0\";\n\t\t\tcase 1.5f -> \"1.5\";\n\t\t\tcase float v -> \"v=\"+String.valueOf(v);\n\t\t};\n\t}\n\tpublic static char switchByteToChar(byte b) {\n\t\treturn switch (b) {\n\t\t\tcase '1' -> 'A';\n\t\t\tcase char c -> c;\n\t\t\tdefault -> '_';\n\t\t};\n\t}\n\tpublic static void main(String... args) {\n\t\tSystem.out.print(switchbool(true));\n\t\tSystem.out.print(\"|\");\n\t\tSystem.out.print(switchbool(false));\n\t\tSystem.out.print(\"|\");\n\t\tSystem.out.print(switchfloatMoreCases(1.0f));\n\t\tSystem.out.print(\"|\");\n\t\tSystem.out.print(switchfloatMoreCases(1.5f));\n\t\tSystem.out.print(\"|\");\n\t\tSystem.out.print(switchfloatMoreCases(1.6f));\n\t\tSystem.out.print(\"|\");\n\t\tSystem.out.print(switchByteToChar((byte) 49));\n\t\tSystem.out.print(\"|\");\n\t\tSystem.out.print(switchByteToChar((byte) 50));\n\t\tSystem.out.print(\"|\");\n\t\tSystem.out.print(switchByteToChar((byte) -1));\n\t}\n}\n"}, "true|v=false|1.0|1.5|v=1.6|A|2|_");
    }

    public void testPrimitivePatternInSwitch_byteToChar_notExhaustive() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static char switchByteToChar(byte b) {\n\t\treturn switch (b) {\n\t\t\tcase '1' -> 'A';\n\t\t\tcase char c -> c;\n\t\t};\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\treturn switch (b) {\n\t               ^\nA switch expression should have a default case\n----------\n");
    }

    private void testNarrowingInSwitchFrom(String from, int idx, String expectedOut) {
        assert (from.equals(PRIMITIVES[idx])) : "mismatch between from and idx";
        String classTmpl = "public class X {\n\tpublic static RET doswitch(FROM v) {\n\t\treturn switch(v) {\nBODY\n\t\t};\n\t}\n\tstatic void print(Object o) {\n\t\tSystem.out.print(o);\n\t\tSystem.out.print('|');\n\t}\n\tpublic static void main(String[] args) {\nCALLS\n\t}\n}\n";
        String casesTmpl = "\t\t\tcase CONST -> VAL;\n\t\t\tcase PRIM vv -> VAL+vv;\n";
        String callsTmpl = "\t\tprint(X.doswitch((FROM)CONST));\n\t\tprint(X.doswitch((FROM)(CONST+CONST)));\n";
        StringBuilder cases = new StringBuilder();
        StringBuilder calls = new StringBuilder();
        int i = 0;
        while (i <= idx) {
            if (IS_NUMERICAL[i]) {
                String constVal = PrimitiveInPatternsTestSH.toConstantOfType(CONSTANTS[i], from);
                String val10 = String.valueOf(i * 10);
                cases.append(casesTmpl.replaceAll("PRIM", PRIMITIVES[i]).replace("CONST", constVal).replace("VAL", val10));
                calls.append(callsTmpl.replaceAll("FROM", from).replaceAll("CONST", constVal));
            }
            ++i;
        }
        String retType = idx <= 4 ? "int" : from;
        String classX = classTmpl.replace("FROM", from).replace("RET", retType).replace("BODY", cases.toString()).replace("CALLS", calls.toString());
        this.runConformTest(new String[]{"X.java", classX}, expectedOut);
    }

    public void testNarrowingInSwitchFromShort() {
        this.testNarrowingInSwitchFrom("short", 3, "10|12|30|630|");
    }

    public void testNarrowingInSwitchFromInt() {
        this.testNarrowingInSwitchFrom("int", 4, "10|12|30|630|40|80040|");
    }

    public void testNarrowingInSwitchFromLong() {
        this.testNarrowingInSwitchFrom("long", 5, "10|12|30|630|40|80040|50|10000000050|");
    }

    public void testNarrowingInSwitchFromFloat() {
        this.testNarrowingInSwitchFrom("float", 6, "10.0|12.0|30.0|630.0|40.0|80040.0|50.0|1.0E10|60.0|1.2E21|");
    }

    public void testNarrowingInSwitchFromDouble() {
        this.testNarrowingInSwitchFrom("double", 7, "10.0|12.0|30.0|630.0|40.0|80040.0|50.0|1.000000005E10|60.0|1.2E21|70.0|1.4E41|");
    }

    public void testSwitchOn_long_wrongSelector() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tint m1(long in) {\n\t\treturn switch(in) {\n\t\t\tcase 1 -> 1;\n\t\t\tcase 'a' -> 2;\n\t\t\tcase 3L -> 3;\n\t\t\tcase 4.0f -> 4;\n\t\t\tcase 5.0d -> 5;\n\t\t\tdefault -> -1;\n\t\t};\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tcase 1 -> 1;\n\t     ^\nCase constants in a switch on 'long' must have type 'long'\n----------\n2. ERROR in X.java (at line 5)\n\tcase 'a' -> 2;\n\t     ^^^\nCase constants in a switch on 'long' must have type 'long'\n----------\n3. ERROR in X.java (at line 7)\n\tcase 4.0f -> 4;\n\t     ^^^^\nCase constants in a switch on 'long' must have type 'long'\n----------\n4. ERROR in X.java (at line 8)\n\tcase 5.0d -> 5;\n\t     ^^^^\nCase constants in a switch on 'long' must have type 'long'\n----------\n");
    }

    public void testSwitchOn_Float_wrongSelector() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tint m1(Float in) {\n\t\treturn switch(in) {\n\t\t\tcase 1 -> 1;\n\t\t\tcase 'a' -> 2;\n\t\t\tcase 3L -> 3;\n\t\t\tcase 4.0f -> 4;\n\t\t\tcase 5.0d -> 5;\n\t\t\tdefault -> -1;\n\t\t};\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tcase 1 -> 1;\n\t     ^\nCase constants in a switch on 'Float' must have type 'float'\n----------\n2. ERROR in X.java (at line 5)\n\tcase 'a' -> 2;\n\t     ^^^\nCase constants in a switch on 'Float' must have type 'float'\n----------\n3. ERROR in X.java (at line 6)\n\tcase 3L -> 3;\n\t     ^^\nCase constants in a switch on 'Float' must have type 'float'\n----------\n4. ERROR in X.java (at line 8)\n\tcase 5.0d -> 5;\n\t     ^^^^\nCase constants in a switch on 'Float' must have type 'float'\n----------\n");
    }

    public void testSwitchOnBoxed_OK() {
        String classTmpl = "public class XBOX {\n\tstatic int m1(BOX in) {\n\t\treturn switch(in) {\n\t\t\tcase VAL -> 1;\n\t\t\tcase MAX -> 2;\n\t\t\tdefault -> -2;\n\t\t};\n\t}\n\tpublic static void main(String... args) {\nCALLS\n\t}\n}\n";
        String callsTmpl = "\t\tSystem.out.print(m1((PRIM)VAL));\n\t\tSystem.out.print(m1((PRIM)MAX));\n\t\tSystem.out.print(m1((PRIM)NEGVAL));\n";
        int i = 1;
        while (i < PRIMITIVES.length) {
            String calls = PrimitiveInPatternsTestSH.fillIn(callsTmpl, i);
            String classX = PrimitiveInPatternsTestSH.fillIn(classTmpl, i).replace("CALLS", calls);
            this.runConformTest_skipPreviewCheck(new String[]{"XBOX.java".replace("BOX", BOXES[i]), classX}, "12-2");
            ++i;
        }
    }

    public void testSwitchOn_Boolean_OK() {
        this.runConformTest_skipPreviewCheck(new String[]{"X.java", "public class X {\n\tstatic int m1(Boolean in) {\n\t\treturn switch(in) {\n\t\t\tcase true-> 1;\n\t\t\tdefault -> -1;\n\t\t};\n\t}\n\tpublic static void main(String... args) {\n\t\tSystem.out.print(m1(true));\n\t\tSystem.out.print(m1(false));\n\t}\n}\n"}, "1-1");
    }

    public void testDuplicateBoolCase() {
        this.runNegativeTest(new String[]{"XBoolean.java", "public class XBoolean {\n\tstatic int m1(Boolean in) {\n\t\treturn switch(in) {\n\t\t\tcase true -> 1;\n\t\t\tcase true -> 2;\n\t\t\tdefault -> -1;\n\t\t};\n\t}\n\tpublic static void main(String... args) {\n\t\tSystem.out.print(m1(true));\n\t\tSystem.out.print(m1(true));\n\t\tSystem.out.print(m1(false));\n\n\t}\n}\n"}, "----------\n1. ERROR in XBoolean.java (at line 5)\n\tcase true -> 2;\n\t     ^^^^\nDuplicate case\n----------\n");
    }

    public void testBooleanSwitchExhaustive_OK() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tstatic int m1(boolean b) {\n\t\treturn switch (b) {\n\t\t\tcase true -> 1;\n\t\t\tcase false -> 0;\n\t\t};\n\t}\n\tpublic static void main(String... args) {\n\t\tSystem.out.print(m1(true));\n\t\tSystem.out.print(m1(false));\n\t}\n}\n"}, "10");
    }

    public void testBooleanSwitchExhaustive_NOK_1() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tstatic int m1(boolean b) {\n\t\treturn switch (b) {\n\t\t\tcase true -> 1;\n\t\t};\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\treturn switch (b) {\n\t               ^\nA switch expression should have a default case\n----------\n");
    }

    public void testBooleanSwitchExhaustive_NOK_2() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tstatic int m1(boolean b) {\n\t\treturn switch (b) {\n\t\t\tcase true -> 1;\n\t\t\tcase false -> 2;\n\t\t\tdefault -> 3;\n\t\t};\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\treturn switch (b) {\n\t\t\tcase true -> 1;\n\t\t\tcase false -> 2;\n\t\t\tdefault -> 3;\n\t\t};\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nSwitch cannot have both boolean values and a default label\n----------\n");
    }

    public void testBooleanSwitchExhaustive_NOK_3() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic void foo(Boolean b) {\n\t\tfinal boolean TRUE = true;\n\t\tfinal boolean FALSE = false;\n\t\tswitch (b) {\n\t\t\tcase TRUE -> { break;}\n\t\t\tcase FALSE -> { break;}\n\t\t\tdefault -> { break;}\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tswitch (b) {\n\t\t\tcase TRUE -> { break;}\n\t\t\tcase FALSE -> { break;}\n\t\t\tdefault -> { break;}\n\t\t}\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nSwitch cannot have both boolean values and a default label\n----------\n");
    }

    public void testShortSwitchExhaustive_int_Number_Comparable() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tstatic int m1(short s) {\n\t\treturn switch (s) {\n\t\t\tcase 1 -> 0;\n\t\t\tcase int v -> v*2;\n\t\t};\n\t}\n\tstatic int m2(short s) {\n\t\treturn switch (s) {\n\t\t\tcase 1 -> 0;\n\t\t\tcase Number v -> v.intValue()*2;\n\t\t};\n\t}\n\tstatic int m3(short s) {\n\t\treturn switch (s) {\n\t\t\tcase 1 -> 0;\n\t\t\tcase Comparable<?> v -> humbug(v);\n\t\t};\n\t}\n\tstatic int humbug(Comparable<?> v) {\n\t\treturn 8;\n\t}\n\tpublic static void main(String... args) {\n\t\tSystem.out.print(m1((short) 1));\n\t\tSystem.out.print(m1((short) 4));\n\t\tSystem.out.print(m2((short) 1));\n\t\tSystem.out.print(m2((short) 4));\n\t\tSystem.out.print(m3((short) 1));\n\t\tSystem.out.print(m3((short) 4));\n\t}\n}\n"}, "080808");
    }

    public void testIntSwitchExhaustive_NOK() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tstatic float m1(Integer i) {\n\t\treturn switch(i) {\n\t\t\tcase 1 -> 1.0f;\n\t\t\tcase float f -> f;\n\t\t};\n\t}\n\tstatic float m2(int i) {\n\t\treturn switch(i) {\n\t\t\tcase 1 -> 1;\n\t\t\tcase float f -> f;\n\t\t};\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\treturn switch(i) {\n\t              ^\nA switch expression should have a default case\n----------\n2. ERROR in X.java (at line 9)\n\treturn switch(i) {\n\t              ^\nA switch expression should have a default case\n----------\n");
    }

    public void testIntSwitchExhaustive_OK() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tstatic double m1(Integer i) {\n\t\treturn switch(i) {\n\t\t\tcase 1 -> 1.0f;\n\t\t\tcase double d -> d;\n\t\t};\n\t}\n\tstatic double m2(int i) {\n\t\treturn switch(i) {\n\t\t\tcase 1 -> 1;\n\t\t\tcase double d -> d;\n\t\t};\n\t}\n\tpublic static void main(String... args) {\n\t\tSystem.out.print(m1(1));\n\t\tSystem.out.print('|');\n\t\tSystem.out.print(m1(3));\n\t\tSystem.out.print('|');\n\t\tSystem.out.print(m2(1));\n\t\tSystem.out.print('|');\n\t\tSystem.out.print(m2(3));\n\t}\n}\n"}, "1.0|3.0|1.0|3.0");
    }

    public void testLongSwitchExhaustive_NOK() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tstatic float m1(Long l) {\n\t\treturn switch(l) {\n\t\t\tcase 1L -> 1.0f;\n\t\t\tcase float f -> f;\n\t\t};\n\t}\n\tstatic double m2(long l) {\n\t\treturn switch(l) {\n\t\t\tcase 1L -> 1.0d;\n\t\t\tcase double d -> d;\n\t\t};\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\treturn switch(l) {\n\t              ^\nA switch expression should have a default case\n----------\n2. ERROR in X.java (at line 9)\n\treturn switch(l) {\n\t              ^\nA switch expression should have a default case\n----------\n");
    }

    public void testPrimitiveRecordComponent_narrow() {
        this.runConformTest(new String[]{"X.java", "record RforRecord(long x) {}\npublic class X  {\n\tpublic void foo() {\n\t\tif (new RforRecord(0L) instanceof RforRecord(int y)) {\n\t\t\tSystem.out.print(\"Yay\");\n\t\t}\n\t\tif (new RforRecord(5000000000L) instanceof RforRecord(int y)) {\n\t\t\tSystem.out.print(\"Nay\");\n\t\t} else {\n\t\t\tSystem.out.print(\"!\");\n\t\t}\n\t}\n\tpublic static void main(String... args) {\n\t\tnew X().foo();\n\t}\n}\n"}, "Yay!");
    }

    public void testPrimitiveRecordComponent_unbox() {
        this.runConformTest(new String[]{"X.java", "record RforRecord(Long x) {}\npublic class X  {\n\tpublic void foo() {\n\t\tif (new RforRecord(0L) instanceof RforRecord(long y)) {\n\t\t\tSystem.out.print(\"Yay\");\n\t\t}\n\t}\n\tpublic static void main(String... args) {\n\t\tnew X().foo();\n\t}\n}\n"}, "Yay");
    }

    public void testPrimitiveRecordComponent_unboxAndWiden() {
        this.runConformTest(new String[]{"X.java", "record RforRecord(Integer x) {}\npublic class X  {\n\tpublic void foo() {\n\t\tif (new RforRecord(0) instanceof RforRecord(long y)) {\n\t\t\tSystem.out.print(\"Yay\");\n\t\t}\n\t}\n\tpublic static void main(String... args) {\n\t\tnew X().foo();\n\t}\n}\n"}, "Yay");
    }

    public void testPrimitiveRecordComponent_narrowingAndUnboxing_nested() {
        this.runConformTest(new String[]{"X.java", "record Rec1(Rec2 r) {}\nrecord Rec2(Number x) {}\npublic class X  {\n\tpublic void foo() {\n\t\tif (new Rec1(new Rec2(Integer.valueOf(1))) instanceof Rec1(Rec2(int y))) {\n\t\t\tSystem.out.print(\"Yay\"+y);\n\t\t}\n\t\tif (new Rec1(new Rec2(Short.valueOf((short)1))) instanceof Rec1(Rec2(int y))) {\n\t\t\tSystem.out.print(\"Nay\");\n\t\t} else {\n\t\t\tSystem.out.print(\"!\");\n\t\t}\n\t}\n\tpublic static void main(String... args) {\n\t\tnew X().foo();\n\t}\n}\n"}, "Yay1!");
    }

    public void testCoversTypePlusDefault() {
        this.runConformTest(new String[]{"X.java", "public class X  {\n\tpublic static int foo(Integer myInt) {\n\t\treturn switch (myInt) {\n\t\t\tcase int i  -> i;\n\t\t\tdefault -> 0;\n\t\t};\n\t}\n\n\tpublic static void main(String argv[]) {\n\t\tInteger i = 100;\n\t\tSystem.out.println(X.foo(i) == i);\n\t}\n}\n"}, "true");
    }

    public void testUnconditionPlusDefault() {
        this.runNegativeTest(new String[]{"X.java", "public class X  {\n\tint foo1(int myInt) {\n\t\treturn switch (myInt) {\n\t\t\tcase int i  -> i;\n\t\t\tdefault -> 0; // conflict with preceding total pattern (unguarded and unconditional)\n\t\t};\n\t}\n\tint foo2(int myInt) {\n\t\treturn switch (myInt) { // swapped order of cases\n\t\t\tdefault -> 0;\n\t\t\tcase int i  -> i; // conflict with preceding default\n\t\t};\n\t}\n\tint foo3(int myInt) {\n\t\treturn switch (myInt) {\n\t\t\tdefault -> 0;\n\t\t\tcase int i  -> i; // conflict with preceding default\n\t\t\tcase short s -> s; // additionally dominated by int i\n\t\t};\n\t}\n\tint foo4(int myInt) {\n\t\treturn switch (myInt) {\n\t\t\tcase int i  -> i;\n\t\t\tcase short s -> s; // dominated by int i\n\t\t};\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tdefault -> 0; // conflict with preceding total pattern (unguarded and unconditional)\n\t^^^^^^^\nSwitch case cannot have both unconditional pattern and default label\n----------\n2. ERROR in X.java (at line 11)\n\tcase int i  -> i; // conflict with preceding default\n\t     ^^^^^\nThis case label is dominated by one of the preceding case labels\n----------\n3. ERROR in X.java (at line 17)\n\tcase int i  -> i; // conflict with preceding default\n\t     ^^^^^\nThis case label is dominated by one of the preceding case labels\n----------\n4. ERROR in X.java (at line 18)\n\tcase short s -> s; // additionally dominated by int i\n\t     ^^^^^^^\nThis case label is dominated by one of the preceding case labels\n----------\n5. ERROR in X.java (at line 24)\n\tcase short s -> s; // dominated by int i\n\t     ^^^^^^^\nThis case label is dominated by one of the preceding case labels\n----------\n");
    }

    public void testIncompatiblePrimitiveInInstanceof() {
        this.runNegativeTest(new String[]{"X.java", "public class X  {\n\tvoid foo() {\n\t\tif (this instanceof int i)\n\t\t\treturn;\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tif (this instanceof int i)\n\t    ^^^^^^^^^^^^^^^^^^^^^\nIncompatible conditional operand types X and int\n----------\n");
    }

    public void testGH3113_ok() {
        this.runConformTest(new String[]{"X.java", "record Record<T extends Integer>(T t) {}\npublic class X {\n\tpublic static <T extends Integer> double convert(Record<T> r) {\n\t\treturn switch (r) {\n\t\tcase Record(double d) -> d;\n\t\tdefault -> 2;\n\t\t};\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.print(convert(new Record(2)));\n\t}\n}\n"}, "2.0");
    }

    public void testIssue3265() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static String switchfloatMoreCases(float f) {\n\t\treturn switch (f) {\n\t\tcase 1.0f -> \"1.0\";\n\t\tcase 1.5f -> \"1.5\";\n\t\tdefault -> String.valueOf(f);\n\t\t};\n\t}\n\n\tpublic static void main(String... args) {\n\t\tSystem.out.print(switchfloatMoreCases(1.0f));\n\t\tSystem.out.print(\"|\");\n\t\tSystem.out.print(switchfloatMoreCases(1.5f));\n\t\tSystem.out.print(\"|\");\n\t\tSystem.out.print(switchfloatMoreCases(1.6f));\n\t\tSystem.out.print(\"|\");\n\t}\n}\n"}, "1.0|1.5|1.6|");
    }

    public void testIssue3265_2() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static String switchfloatMoreCases(float f) {\n\t\treturn switch (f) {\n\t\tcase 1.0f -> \"1.0\";\n\t\tcase 0.5f + 0.5f -> \"1.0\";\n\t\tdefault -> String.valueOf(f);\n\t\t};\n\t}\n\n\tpublic static void main(String... args) {\n\t\tSystem.out.print(switchfloatMoreCases(1.0f));\n\t\tSystem.out.print(\"|\");\n\t\tSystem.out.print(switchfloatMoreCases(1.5f));\n\t\tSystem.out.print(\"|\");\n\t\tSystem.out.print(switchfloatMoreCases(1.6f));\n\t\tSystem.out.print(\"|\");\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tcase 0.5f + 0.5f -> \"1.0\";\n\t     ^^^^^^^^^^^\nDuplicate case\n----------\n");
    }

    public void testIssue3337() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\n\tpublic static void main(String[] args) {\n\t\tBoolean b = true;\n\t\tswitch (b) {\n\t\t\tcase true -> System.out.println(1);\n\t\t\tcase false -> System.out.println(0);\n\t\t\tcase null, default -> System.out.println(\"Error\");\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\r\n\tswitch (b) {\n\t\t\tcase true -> System.out.println(1);\n\t\t\tcase false -> System.out.println(0);\n\t\t\tcase null, default -> System.out.println(\"Error\");\n\t\t}\r\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nSwitch cannot have both boolean values and a default label\n----------\n");
    }

    public void testJDK8348410_negative() {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.customOptions = this.getCompilerOptions(false);
        runner.testFiles = new String[]{"Test.java", " public class Test {\n\tpublic static void main(String[] args) {\n\t\tnew Test().d(true);\n\t}\n\n\tvoid d(Boolean b) {\n\t\tswitch (b) {\n\t\t\tcase true -> System.out.println(\"1\");\n\t\t\tcase false -> System.out.println(\"2\");\n\t\t};\n\t}\n}\n"};
        runner.expectedCompilerLog = "----------\n1. ERROR in Test.java (at line 7)\n\tswitch (b) {\n\t        ^\nAn enhanced switch statement should be exhaustive; a default label expected\n----------\n2. ERROR in Test.java (at line 8)\n\tcase true -> System.out.println(\"1\");\n\t     ^^^^\nCase constant of type boolean is incompatible with switch selector type Boolean\n----------\n3. ERROR in Test.java (at line 9)\n\tcase false -> System.out.println(\"2\");\n\t     ^^^^^\nCase constant of type boolean is incompatible with switch selector type Boolean\n----------\n";
        runner.javacTestOptions = AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacBug8348410;
        runner.runNegativeTest();
    }

    public void testJDK8348410_positive() {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.customOptions = this.getCompilerOptions(true);
        runner.testFiles = new String[]{"Test.java", " public class Test {\n\tpublic static void main(String[] args) {\n\t\tnew Test().d(true);\n\t}\n\n\tvoid d(Boolean b) {\n\t\tswitch (b) {\n\t\t\tcase true -> System.out.println(\"1\");\n\t\t\tcase false -> System.out.println(\"2\");\n\t\t};\n\t}\n}\n"};
        runner.vmArguments = VMARGS;
        runner.expectedOutputString = "1";
        runner.runConformTest();
    }

    public void testGH3128() {
        this.runConformTest(new String[]{"X.java", "class X {\n\tpublic void foo(Boolean boxed) {\n\t\tswitch (boxed) {\n\t\t\tcase boolean b -> { System.out.print(b); }\n\t\t\tdefault -> {}\n\t\t}\n\t}\n\tpublic static void main(String... args) {\n\t\tnew X().foo(true);\n\t}\n}\n"}, "true");
    }

    public void testJDK8348901() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tswitch (null) {\n\t\t\tcase null -> System.out.println(\"Null\");\n\t\t\tdefault-> System.out.println(\"Default\");\n\t\t}\n\t}\n}\n"}, "Null");
    }

    public void testGH3369_statement() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tswitch (main(null)) {\n\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tswitch (main(null)) {\n\t        ^^^^^^^^^^\nThis expression yields no value\n----------\n");
    }

    public void testGH3369_expression() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tint foo() {\n\t\treturn switch (bar()) {\n\t\t\tdefault -> 1;\n\t\t};\n\t}\n\tvoid bar() {}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\treturn switch (bar()) {\n\t               ^^^^^\nThis expression yields no value\n----------\n");
    }
}

