/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;

public class ProgrammingProblemsTest
extends AbstractRegressionTest {
    public ProgrammingProblemsTest(String name) {
        super(name);
    }

    public static Test suite() {
        return ProgrammingProblemsTest.buildAllCompliancesTestSuite(ProgrammingProblemsTest.testClass());
    }

    public static Class testClass() {
        return ProgrammingProblemsTest.class;
    }

    @Override
    protected Map getCompilerOptions() {
        Map<String, String> compilerOptions = super.getCompilerOptions();
        compilerOptions.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", "optimize out");
        return compilerOptions;
    }

    void runTest(String[] testFiles, String[] errorOptions, String[] warningOptions, String[] ignoreOptions, boolean expectingCompilerErrors, String expectedCompilerLog, String expectedOutputString, boolean forceExecution, String[] classLib, boolean shouldFlushOutputDirectory, String[] vmArguments, Map customOptions, ICompilerRequestor clientRequestor, boolean skipJavac) {
        HashMap<String, String> compilerOptions = customOptions;
        if (errorOptions != null || warningOptions != null || ignoreOptions != null) {
            int i;
            if (compilerOptions == null) {
                compilerOptions = new HashMap<String, String>();
            }
            if (errorOptions != null) {
                i = 0;
                while (i < errorOptions.length) {
                    compilerOptions.put(errorOptions[i], "error");
                    ++i;
                }
            }
            if (warningOptions != null) {
                i = 0;
                while (i < warningOptions.length) {
                    compilerOptions.put(warningOptions[i], "warning");
                    ++i;
                }
            }
            if (ignoreOptions != null) {
                i = 0;
                while (i < ignoreOptions.length) {
                    compilerOptions.put(ignoreOptions[i], "ignore");
                    ++i;
                }
            }
        }
        this.runTest(testFiles, expectingCompilerErrors, expectedCompilerLog, expectedOutputString, "", forceExecution, classLib, shouldFlushOutputDirectory, vmArguments, compilerOptions, clientRequestor, skipJavac);
    }

    public void test0001_unread_parameters() {
        this.runTest(new String[]{"X.java", "public class X {\n  public void foo(boolean b) {\n  }\n}\n"}, null, null, null, false, "", "", false, null, true, null, null, null, false);
    }

    public void test0002_unread_parameters() {
        this.runTest(new String[]{"X.java", "public class X {\n  public void foo(boolean b) {\n  }\n}\n"}, null, new String[]{"org.eclipse.jdt.core.compiler.problem.unusedParameter"}, null, false, "----------\n1. WARNING in X.java (at line 2)\n\tpublic void foo(boolean b) {\n\t                        ^\nThe value of the parameter b is not used\n----------\n", "", false, null, true, null, null, null, true);
    }

    public void test0003_unread_parameters() {
        HashMap<String, String> customOptions = new HashMap<String, String>();
        customOptions.put("org.eclipse.jdt.core.compiler.doc.comment.support", "enabled");
        this.runTest(new String[]{"X.java", "public class X {\n/** @param b mute warning **/\n  public void foo(boolean b) {\n  }\n}\n"}, null, new String[]{"org.eclipse.jdt.core.compiler.problem.unusedParameter"}, null, false, "", "", false, null, true, null, customOptions, null, true);
    }

    public void test0004_unread_parameters() {
        HashMap<String, String> customOptions = new HashMap<String, String>();
        customOptions.put("org.eclipse.jdt.core.compiler.doc.comment.support", "enabled");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedParameterIncludeDocCommentReference", "disabled");
        this.runTest(new String[]{"X.java", "public class X {\n/** @param b mute warning **/\n  public void foo(boolean b) {\n  }\n}\n"}, null, new String[]{"org.eclipse.jdt.core.compiler.problem.unusedParameter"}, null, false, "----------\n1. WARNING in X.java (at line 3)\n\tpublic void foo(boolean b) {\n\t                        ^\nThe value of the parameter b is not used\n----------\n", "", false, null, true, null, customOptions, null, true);
    }

    public void test0005_unread_parameters() {
        this.runTest(new String[]{"X.java", "public class X {\n@SuppressWarnings(\"unused\")\n  public void foo(boolean b) {\n  }\n@SuppressWarnings(\"all\")\n  public void foo(int i) {\n  }\n}\n"}, null, new String[]{"org.eclipse.jdt.core.compiler.problem.unusedParameter"}, null, false, "", "", false, null, true, null, null, null, true);
    }

    public void test0006_unread_parameters() {
        this.runTest(new String[]{"X.java", "public class X {\n  public void foo(boolean b) {\n  }\n}\n"}, new String[]{"org.eclipse.jdt.core.compiler.problem.unusedParameter"}, null, null, true, "----------\n1. ERROR in X.java (at line 2)\n\tpublic void foo(boolean b) {\n\t                        ^\nThe value of the parameter b is not used\n----------\n", "", false, null, true, null, null, null, true);
    }

    public void test0007_declared_thrown_checked_exceptions() {
        this.runTest(new String[]{"X.java", "import java.io.IOException;\npublic class X {\n  public void foo() throws IOException {\n  }\n}\n"}, null, null, null, false, "", "", false, null, true, null, null, null, false);
    }

    public void test0008_declared_thrown_checked_exceptions() {
        this.runTest(new String[]{"X.java", "import java.io.IOException;\npublic class X {\n  public void foo() throws IOException {\n  }\n}\n"}, null, new String[]{"org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownException"}, null, false, "----------\n1. WARNING in X.java (at line 3)\n\tpublic void foo() throws IOException {\n\t                         ^^^^^^^^^^^\nThe declared exception IOException is not actually thrown by the method foo() from type X\n----------\n", "", false, null, true, null, null, null, true);
    }

    public void test0009_declared_thrown_checked_exceptions() {
        HashMap<String, String> customOptions = new HashMap<String, String>();
        customOptions.put("org.eclipse.jdt.core.compiler.doc.comment.support", "enabled");
        this.runTest(new String[]{"X.java", "import java.io.IOException;\npublic class X {\n/** @throws IOException mute warning **/\n  public void foo() throws IOException {\n  }\n}\n"}, null, new String[]{"org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownException"}, null, false, "", "", false, null, true, null, customOptions, null, true);
    }

    public void test0010_declared_thrown_checked_exceptions() {
        HashMap<String, String> customOptions = new HashMap<String, String>();
        customOptions.put("org.eclipse.jdt.core.compiler.doc.comment.support", "enabled");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownExceptionIncludeDocCommentReference", "disabled");
        this.runTest(new String[]{"X.java", "import java.io.IOException;\npublic class X {\n/** @throws IOException mute warning **/\n  public void foo() throws IOException {\n  }\n}\n"}, null, new String[]{"org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownException"}, null, false, "----------\n1. WARNING in X.java (at line 4)\n\tpublic void foo() throws IOException {\n\t                         ^^^^^^^^^^^\nThe declared exception IOException is not actually thrown by the method foo() from type X\n----------\n", "", false, null, true, null, customOptions, null, true);
    }

    public void test0011_declared_thrown_checked_exceptions() {
        this.runTest(new String[]{"X.java", "import java.io.IOException;\npublic class X {\n@SuppressWarnings(\"all\")\n  public void foo() throws IOException {\n  }\n}\n"}, null, new String[]{"org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownException"}, null, false, "", "", false, null, true, null, null, null, true);
    }

    public void test0012_declared_thrown_checked_exceptions() {
        this.runTest(new String[]{"X.java", "import java.io.IOException;\npublic class X {\n  public void foo() throws IOException {\n  }\n}\n"}, new String[]{"org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownException"}, null, null, true, "----------\n1. ERROR in X.java (at line 3)\n\tpublic void foo() throws IOException {\n\t                         ^^^^^^^^^^^\nThe declared exception IOException is not actually thrown by the method foo() from type X\n----------\n", "", false, null, true, null, null, null, true);
    }

    public void test0013_declared_thrown_checked_exceptions() {
        HashMap<String, String> customOptions = new HashMap<String, String>();
        customOptions.put("org.eclipse.jdt.core.compiler.doc.comment.support", "enabled");
        this.runTest(new String[]{"X.java", "import java.io.IOException;\nimport java.io.EOFException;\npublic class X {\n/** @throws EOFException does not mute warning for IOException **/\n  public void foo() throws IOException {\n  }\n}\n"}, null, new String[]{"org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownException"}, null, false, "----------\n1. WARNING in X.java (at line 5)\n\tpublic void foo() throws IOException {\n\t                         ^^^^^^^^^^^\nThe declared exception IOException is not actually thrown by the method foo() from type X\n----------\n", "", false, null, true, null, customOptions, null, true);
    }

    public void test0014_declared_thrown_checked_exceptions_unread_parameters() {
        this.runTest(new String[]{"X.java", "import java.io.IOException;\npublic class X {\n  void foo(int unused) throws IOException {}\n}\n"}, new String[]{"org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownException"}, new String[]{"org.eclipse.jdt.core.compiler.problem.unusedParameter"}, null, true, "----------\n1. WARNING in X.java (at line 3)\n\tvoid foo(int unused) throws IOException {}\n\t             ^^^^^^\nThe value of the parameter unused is not used\n----------\n2. ERROR in X.java (at line 3)\n\tvoid foo(int unused) throws IOException {}\n\t                            ^^^^^^^^^^^\nThe declared exception IOException is not actually thrown by the method foo(int) from type X\n----------\n", "", false, null, true, null, null, null, true);
    }

    public void test0015_declared_thrown_checked_exceptions_unread_parameters() {
        this.runTest(new String[]{"X.java", "import java.io.IOException;\npublic class X {\n  void foo(int unused) throws IOException {}\n}\n"}, null, new String[]{"org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownException", "org.eclipse.jdt.core.compiler.problem.unusedParameter"}, null, false, "----------\n1. WARNING in X.java (at line 3)\n\tvoid foo(int unused) throws IOException {}\n\t             ^^^^^^\nThe value of the parameter unused is not used\n----------\n2. WARNING in X.java (at line 3)\n\tvoid foo(int unused) throws IOException {}\n\t                            ^^^^^^^^^^^\nThe declared exception IOException is not actually thrown by the method foo(int) from type X\n----------\n", "", false, null, true, null, null, null, true);
    }

    public void test0016_unread_parameters_constructor() {
        this.runTest(new String[]{"X.java", "public class X {\n  public X(boolean b) {\n  }\n}\n"}, new String[]{"org.eclipse.jdt.core.compiler.problem.unusedParameter"}, null, null, true, "----------\n1. ERROR in X.java (at line 2)\n\tpublic X(boolean b) {\n\t                 ^\nThe value of the parameter b is not used\n----------\n", "", false, null, true, null, null, null, true);
    }

    public void test0017_shadowing_package_visible_methods() {
        this.runTest(new String[]{"p/X.java", "package p;\npublic class X {\n  void foo() {\n  }\n}\n", "q/Y.java", "package q;\npublic class Y extends p.X {\n  void foo() {\n  }\n}\n"}, null, new String[]{"org.eclipse.jdt.core.compiler.problem.overridingPackageDefaultMethod"}, null, false, "----------\n1. WARNING in q\\Y.java (at line 3)\n\tvoid foo() {\n\t     ^^^^^\nThe method Y.foo() does not override the inherited method from X since it is private to a different package\n----------\n", "", false, null, true, null, null, new ICompilerRequestor(){

            public void acceptResult(CompilationResult result) {
                if (result.compilationUnit.getFileName()[0] == 'Y') {
                    ProgrammingProblemsTest.assertEquals((String)"unexpected problems count", (int)1, (int)result.problemCount);
                    ProgrammingProblemsTest.assertEquals((String)"unexpected category", (int)100, (int)result.problems[0].getCategoryID());
                }
            }
        }, true);
    }

    public void test0018_declared_thrown_unchecked_exceptions() {
        this.runTest(new String[]{"X.java", "public class X {\n  public void foo() throws ArithmeticException {\n  }\n}\n"}, null, null, null, false, "", "", false, null, true, null, null, null, true);
    }

    public void test0019_declared_thrown_unchecked_exceptions() {
        this.runTest(new String[]{"X.java", "public class X {\n  public void foo() throws RuntimeException {\n  }\n}\n"}, null, null, null, false, "", "", false, null, true, null, null, null, true);
    }

    public void test0020_declared_thrown_checked_exceptions() {
        this.runTest(new String[]{"X.java", "public class X {\n  public void foo() throws Exception {\n  }\n}\n"}, null, null, null, false, "", "", false, null, true, null, null, null, true);
    }

    public void test0021_declared_thrown_checked_exceptions() {
        this.runTest(new String[]{"X.java", "public class X {\n  public void foo() throws Throwable {\n  }\n}\n"}, null, null, null, false, "", "", false, null, true, null, null, null, true);
    }

    public void test0022_declared_thrown_unchecked_exceptions() {
        HashMap<String, String> customOptions = new HashMap<String, String>();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownExceptionExemptExceptionAndThrowable", "disabled");
        this.runTest(new String[]{"X.java", "public class X {\n  public void foo() throws ArithmeticException {\n  }\n}\n"}, null, new String[]{"org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownException"}, null, false, "", "", false, null, true, null, customOptions, null, true);
    }

    public void test0023_declared_thrown_unchecked_exceptions() {
        HashMap<String, String> customOptions = new HashMap<String, String>();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownExceptionExemptExceptionAndThrowable", "disabled");
        this.runTest(new String[]{"X.java", "public class X {\n  public void foo() throws Exception {\n  }\n}\n"}, null, new String[]{"org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownException"}, null, false, "----------\n1. WARNING in X.java (at line 2)\n\tpublic void foo() throws Exception {\n\t                         ^^^^^^^^^\nThe declared exception Exception is not actually thrown by the method foo() from type X\n----------\n", "", false, null, true, null, customOptions, null, true);
    }

    public void test0024_declared_thrown_unchecked_exceptions() {
        HashMap<String, String> customOptions = new HashMap<String, String>();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownExceptionExemptExceptionAndThrowable", "disabled");
        this.runTest(new String[]{"X.java", "public class X {\n  public void foo() throws RuntimeException {\n  }\n}\n"}, null, new String[]{"org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownException"}, null, false, "", "", false, null, true, null, customOptions, null, true);
    }

    public void test0025_declared_thrown_checked_exceptions() {
        HashMap<String, String> customOptions = new HashMap<String, String>();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownExceptionExemptExceptionAndThrowable", "disabled");
        this.runTest(new String[]{"X.java", "public class X {\n  public void foo() throws Exception {\n  }\n}\n"}, null, new String[]{"org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownException"}, null, false, "----------\n1. WARNING in X.java (at line 2)\n\tpublic void foo() throws Exception {\n\t                         ^^^^^^^^^\nThe declared exception Exception is not actually thrown by the method foo() from type X\n----------\n", "", false, null, true, null, customOptions, null, true);
    }

    public void test0026_declared_thrown_checked_exceptions() {
        HashMap<String, String> customOptions = new HashMap<String, String>();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownExceptionExemptExceptionAndThrowable", "disabled");
        this.runTest(new String[]{"X.java", "public class X {\n  public void foo() throws Throwable {\n  }\n}\n"}, null, new String[]{"org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownException"}, null, false, "----------\n1. WARNING in X.java (at line 2)\n\tpublic void foo() throws Throwable {\n\t                         ^^^^^^^^^\nThe declared exception Throwable is not actually thrown by the method foo() from type X\n----------\n", "", false, null, true, null, customOptions, null, true);
    }

    public void test0027_declared_thrown_unchecked_exceptions() {
        HashMap<String, String> customOptions = new HashMap<String, String>();
        customOptions.put("org.eclipse.jdt.core.compiler.doc.comment.support", "enabled");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownExceptionExemptExceptionAndThrowable", "disabled");
        this.runTest(new String[]{"X.java", "public class X {\n/** @throws Exception mute warning **/\n  public void foo() throws Exception {\n  }\n}\n"}, null, new String[]{"org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownException"}, null, false, "", "", false, null, true, null, customOptions, null, true);
    }

    public void test0028_declared_thrown_checked_exceptions() {
        HashMap<String, String> customOptions = new HashMap<String, String>();
        customOptions.put("org.eclipse.jdt.core.compiler.doc.comment.support", "enabled");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownExceptionIncludeDocCommentReference", "disabled");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownExceptionExemptExceptionAndThrowable", "disabled");
        this.runTest(new String[]{"X.java", "public class X {\n/** @throws Exception mute warning **/\n  public void foo() throws Exception {\n  }\n}\n"}, null, new String[]{"org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownException"}, null, false, "----------\n1. WARNING in X.java (at line 3)\n\tpublic void foo() throws Exception {\n\t                         ^^^^^^^^^\nThe declared exception Exception is not actually thrown by the method foo() from type X\n----------\n", "", false, null, true, null, customOptions, null, true);
    }

    public void test0029_declared_thrown_checked_exceptions() {
        HashMap<String, String> customOptions = new HashMap<String, String>();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownExceptionExemptExceptionAndThrowable", "disabled");
        this.runTest(new String[]{"X.java", "public class X {\n@SuppressWarnings(\"all\")\n  public void foo() throws Exception {\n  }\n}\n"}, null, new String[]{"org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownException"}, null, false, "", "", false, null, true, null, customOptions, null, true);
    }

    public void test0030_declared_thrown_checked_exceptions() {
        HashMap<String, String> customOptions = new HashMap<String, String>();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownExceptionExemptExceptionAndThrowable", "disabled");
        this.runTest(new String[]{"X.java", "public class X {\n  public void foo() throws Exception {\n  }\n}\n"}, new String[]{"org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownException"}, null, null, true, "----------\n1. ERROR in X.java (at line 2)\n\tpublic void foo() throws Exception {\n\t                         ^^^^^^^^^\nThe declared exception Exception is not actually thrown by the method foo() from type X\n----------\n", "", false, null, true, null, customOptions, null, true);
    }

    public void test0031_declared_thrown_checked_exceptions() {
        HashMap<String, String> customOptions = new HashMap<String, String>();
        customOptions.put("org.eclipse.jdt.core.compiler.doc.comment.support", "enabled");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownExceptionExemptExceptionAndThrowable", "disabled");
        this.runTest(new String[]{"X.java", "public class X {\n/** @throws Throwable does not mute warning for Exception **/\n  public void foo() throws Exception {\n  }\n}\n"}, null, new String[]{"org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownException"}, null, false, "----------\n1. WARNING in X.java (at line 3)\n\tpublic void foo() throws Exception {\n\t                         ^^^^^^^^^\nThe declared exception Exception is not actually thrown by the method foo() from type X\n----------\n", "", false, null, true, null, customOptions, null, true);
    }

    public void test0032_declared_thrown_checked_exceptions() {
        HashMap<String, String> customOptions = new HashMap<String, String>();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownExceptionExemptExceptionAndThrowable", "disabled");
        this.runTest(new String[]{"X.java", "public class X {\n  public void foo() throws Error {\n  }\n}\n"}, null, new String[]{"org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownException"}, null, false, "", "", false, null, true, null, customOptions, null, true);
    }

    public void test0033_declared_thrown_checked_exceptions() {
        HashMap<String, String> customOptions = new HashMap<String, String>();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownExceptionExemptExceptionAndThrowable", "disabled");
        this.runTest(new String[]{"X.java", "public class X {\n  public void foo() throws Exception {\n    if (bar()) {\n      throw new Exception();\n    }\n  }\n  boolean bar() {\n    return true;\n  }\n}\n"}, null, new String[]{"org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownException"}, null, false, "", "", false, null, true, null, customOptions, null, true);
    }

    public void test0034_declared_thrown_checked_exceptions() {
        HashMap<String, String> customOptions = new HashMap<String, String>();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownExceptionExemptExceptionAndThrowable", "disabled");
        this.runTest(new String[]{"X.java", "public class X {\n  public static final class MyError extends Error {\n    private static final long serialVersionUID = 1L;\n  }\n  public void foo() throws Throwable {\n    try {\n      bar();\n    } catch (MyError e) {\n    }\n  }\n  private void bar() {}\n}"}, null, new String[]{"org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownException"}, null, false, "----------\n1. WARNING in X.java (at line 5)\n\tpublic void foo() throws Throwable {\n\t                         ^^^^^^^^^\nThe declared exception Throwable is not actually thrown by the method foo() from type X\n----------\n", "", false, null, true, null, customOptions, null, true);
    }

    public void test0035_declared_thrown_checked_exceptions() {
        HashMap<String, String> customOptions = new HashMap<String, String>();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownExceptionExemptExceptionAndThrowable", "disabled");
        this.runTest(new String[]{"X.java", "public class X {\n  public static final class MyError extends Error {\n    private static final long serialVersionUID = 1L;\n  }\n  public void foo() throws Throwable {\n    throw new MyError();\n  }\n}"}, null, new String[]{"org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownException"}, null, false, "", "", false, null, true, null, customOptions, null, true);
    }

    public void test0036_declared_thrown_checked_exceptions() {
        this.runTest(new String[]{"X.java", "public class X {\n  public static class E1 extends Exception {\n    private static final long serialVersionUID = 1L;\n  }\n  public static class E2 extends E1 {\n    private static final long serialVersionUID = 1L;\n  }\n  public void foo() throws E1 {\n    throw new E2();\n  }\n}"}, null, new String[]{"org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownException"}, null, false, "", "", false, null, true, null, null, null, true);
    }

    public void test0037() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tboolean b1 = args == args;\n\t\tboolean b2 = args != args;\n\t\tboolean b3 = b1 == b1;\n\t\tboolean b4 = b1 != b1;\n\t\tboolean b5 = b1 && b1;\n\t\tboolean b6 = b1 || b1;\n\t\t\n\t\tboolean b7 = foo() == foo();\n\t\tboolean b8 = foo() != foo();\n\t\tboolean b9 = foo() && foo();\n\t\tboolean b10 = foo() || foo();\n\t}\n\tstatic boolean foo() { return true; }\n\tZork z;\n}\n"}, "----------\n1. WARNING in X.java (at line 3)\n\tboolean b1 = args == args;\n\t             ^^^^^^^^^^^^\nComparing identical expressions\n----------\n2. WARNING in X.java (at line 4)\n\tboolean b2 = args != args;\n\t             ^^^^^^^^^^^^\nComparing identical expressions\n----------\n3. WARNING in X.java (at line 5)\n\tboolean b3 = b1 == b1;\n\t             ^^^^^^^^\nComparing identical expressions\n----------\n4. WARNING in X.java (at line 6)\n\tboolean b4 = b1 != b1;\n\t             ^^^^^^^^\nComparing identical expressions\n----------\n5. WARNING in X.java (at line 7)\n\tboolean b5 = b1 && b1;\n\t             ^^^^^^^^\nComparing identical expressions\n----------\n6. WARNING in X.java (at line 8)\n\tboolean b6 = b1 || b1;\n\t             ^^^^^^^^\nComparing identical expressions\n----------\n7. ERROR in X.java (at line 16)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test0038() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tboolean b1 = 1 == 1;\n\t\tboolean b2 = 1 != 1;\n\t\tboolean b3 = 1 == 1.0;\n\t\tboolean b4 = 1 != 1.0;\n\t\tboolean b5 = 1 == 2;\n\t\tboolean b6 = 1 != 2;\n\t\tboolean b7 = 1 == 2.0;\n\t\tboolean b8 = 1 != 2.0;\n       final short s1 = 1;\n       final short s2 = 2;\n       boolean b9 = 1 == s1;\n       boolean b10 = 1 == s2;\n       boolean b91 = 1 != s1;\n       boolean b101 = 1 != s2;\n       final long l1 = 1;\n       final long l2 = 2;\n       boolean b11 = 1 == l1;\n       boolean b12 = 1 == l2;\n       boolean b111 = 1 != l1;\n       boolean b121 = 1 != l2;\n       boolean b13 = s1 == l1;\n       boolean b14 = s1 == l2;\n       boolean b15 = s1 != l1;\n       boolean b16 = s1 != l2;\n\t}\n\tZork z;\n}\n"}, "----------\n1. WARNING in X.java (at line 3)\n\tboolean b1 = 1 == 1;\n\t             ^^^^^^\nComparing identical expressions\n----------\n2. WARNING in X.java (at line 4)\n\tboolean b2 = 1 != 1;\n\t             ^^^^^^\nComparing identical expressions\n----------\n3. WARNING in X.java (at line 5)\n\tboolean b3 = 1 == 1.0;\n\t             ^^^^^^^^\nComparing identical expressions\n----------\n4. WARNING in X.java (at line 6)\n\tboolean b4 = 1 != 1.0;\n\t             ^^^^^^^^\nComparing identical expressions\n----------\n5. WARNING in X.java (at line 13)\n\tboolean b9 = 1 == s1;\n\t             ^^^^^^^\nComparing identical expressions\n----------\n6. WARNING in X.java (at line 15)\n\tboolean b91 = 1 != s1;\n\t              ^^^^^^^\nComparing identical expressions\n----------\n7. WARNING in X.java (at line 19)\n\tboolean b11 = 1 == l1;\n\t              ^^^^^^^\nComparing identical expressions\n----------\n8. WARNING in X.java (at line 21)\n\tboolean b111 = 1 != l1;\n\t               ^^^^^^^\nComparing identical expressions\n----------\n9. WARNING in X.java (at line 23)\n\tboolean b13 = s1 == l1;\n\t              ^^^^^^^^\nComparing identical expressions\n----------\n10. WARNING in X.java (at line 25)\n\tboolean b15 = s1 != l1;\n\t              ^^^^^^^^\nComparing identical expressions\n----------\n11. ERROR in X.java (at line 28)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test0039() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic void gain(String[] args) {\n\t\tboolean b1 = this == this;\n\t\tboolean b2 = this != this;\n\t\tboolean b3 = this != new X();\n\t\tboolean b4 = this == new X();\n\t}\n\tZork z;\n}\n"}, "----------\n1. WARNING in X.java (at line 3)\n\tboolean b1 = this == this;\n\t             ^^^^^^^^^^^^\nComparing identical expressions\n----------\n2. WARNING in X.java (at line 4)\n\tboolean b2 = this != this;\n\t             ^^^^^^^^^^^^\nComparing identical expressions\n----------\n3. ERROR in X.java (at line 8)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test0040() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    public static void main(String[] args) {\n        double var = Double.NaN;\n            if(var != var) {\n                  System.out.println(\"NaN\");\n            }\n            float varf = 10;\n            if(varf != varf) {\n            \tSystem.out.println(\"NaN\");\n            }\n   }\n\tZork z;\n}\n"}, "----------\n1. ERROR in X.java (at line 12)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test0041() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(1.0 == 1.0);\n\t\tSystem.out.println(1.0f == 1.0f);\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 3)\n\tSystem.out.println(1.0 == 1.0);\n\t                   ^^^^^^^^^^\nComparing identical expressions\n----------\n2. WARNING in X.java (at line 4)\n\tSystem.out.println(1.0f == 1.0f);\n\t                   ^^^^^^^^^^^^\nComparing identical expressions\n----------\n");
    }

    public void test0042() {
        this.runTest(new String[]{"Test.java", "public class Test {\n    public static void main(String[]  args) {\n        final String var = \"Hello\";\n        final int local = 10;\n        @ZAnn(var + local)\n        class X {}\n        new X();\n    }\n}\n@interface ZAnn {\n    String value();\n}\n"}, null, new String[]{"org.eclipse.jdt.core.compiler.problem.unusedLocal"}, null, false, "", "", false, null, true, null, null, null, true);
    }

    public void test0043() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n\tvoid foo(int i) {\n\t\tfoo((a));\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tfoo((a));\n\t     ^\na cannot be resolved to a variable\n----------\n");
    }

    public void test0044() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n   volatile int x;\n   int nvx;\n\tvoid foo(int i) {\n\t\tx = x;\n       nvx = nvx;\n\t}\n}"}, "----------\n1. WARNING in X.java (at line 6)\n\tnvx = nvx;\n\t^^^^^^^^^\nThe assignment to variable nvx has no effect\n----------\n");
    }

    public void test0045() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n   volatile int x = this.x;\n   int nvx = this.nvx;\n\tvoid foo(int i) {\n\t}\n}"}, "----------\n1. WARNING in X.java (at line 2)\n\tvolatile int x = this.x;\n\t             ^^^^^^^^^^\nThe assignment to variable x has no effect\n----------\n2. WARNING in X.java (at line 3)\n\tint nvx = this.nvx;\n\t    ^^^^^^^^^^^^^^\nThe assignment to variable nvx has no effect\n----------\n");
    }

    public void test0046() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", "warning");
        this.runNegativeTest(new String[]{"X.java", "class X {\n    int foo() {\n        int i=1;\n        boolean b=false;\n        b|=true;\n        int k = 2;\n        --k;\n        k+=3;\n        Integer j = 3;\n        j++;\n        i++;\n        return i++;\n    }\n}"}, "----------\n1. WARNING in X.java (at line 4)\n\tboolean b=false;\n\t        ^\nThe value of the local variable b is not used\n----------\n2. WARNING in X.java (at line 6)\n\tint k = 2;\n\t    ^\nThe value of the local variable k is not used\n----------\n", null, true, customOptions);
    }

    public void test0046_field() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", "warning");
        this.runNegativeTest(new String[]{"X.java", "class X {\n    private int i=1;\n    private boolean b=false;\n    private int k = 2;\n    private Integer j = 3;\n    int foo() {\n        b|=true;\n        --k;\n        k+=3;\n        j++;\n        return i++;\n    }\n}"}, "----------\n1. WARNING in X.java (at line 3)\n\tprivate boolean b=false;\n\t                ^\nThe value of the field X.b is not used\n----------\n2. WARNING in X.java (at line 4)\n\tprivate int k = 2;\n\t            ^\nThe value of the field X.k is not used\n----------\n", null, true, customOptions);
    }

    public void test0046_field_this_qualified() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", "warning");
        this.runNegativeTest(new String[]{"X.java", "class X {\n    private int i=1;\n    private boolean b=false;\n    private int k = 2;\n    private Integer j = 3;\n    int foo() {\n        this.b|=true;\n        --this.k;\n        getThis().k+=3;\n        this.j++;\n        return this.i++;\n    }\n    X getThis() { return this; }\n}"}, "----------\n1. WARNING in X.java (at line 3)\n\tprivate boolean b=false;\n\t                ^\nThe value of the field X.b is not used\n----------\n2. WARNING in X.java (at line 4)\n\tprivate int k = 2;\n\t            ^\nThe value of the field X.k is not used\n----------\n", null, true, customOptions);
    }

    public void test0046_field_qualified() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", "warning");
        this.runNegativeTest(new String[]{"X.java", "class X {\n    private int i=1;\n    private boolean b=false;\n    private int k = 2;\n    private Integer j = 3;\n    int foo(X that) {\n        that.b|=true;\n        --that.k;\n        that.k+=3;\n        that.j++;\n        that.i++;\n        return that.i++;\n    }\n}"}, "----------\n1. WARNING in X.java (at line 3)\n\tprivate boolean b=false;\n\t                ^\nThe value of the field X.b is not used\n----------\n2. WARNING in X.java (at line 4)\n\tprivate int k = 2;\n\t            ^\nThe value of the field X.k is not used\n----------\n", null, true, customOptions);
    }

    public void test0046_field_in_private_type() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", "warning");
        this.runNegativeTest(new String[]{"X.java", "class X {\n    private class Y {\n        int i=1;\n        public boolean b=false;\n        protected int k = 2;\n        Integer j = 3;\n    }\n    int foo(Y y) {\n        y.b|=true;\n        --y.k;\n        y.k+=3;\n        y.j++;\n        int result = y.i++;\n        y.i++;\n        return result;\n    }\n}"}, "----------\n1. WARNING in X.java (at line 4)\n\tpublic boolean b=false;\n\t               ^\nThe value of the field X.Y.b is not used\n----------\n2. WARNING in X.java (at line 5)\n\tprotected int k = 2;\n\t              ^\nThe value of the field X.Y.k is not used\n----------\n", null, true, customOptions);
    }

    public void test0047() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedParameter", "warning");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", "warning");
        this.runNegativeTest(new String[]{"X.java", "class X {\n    void foo(int param1, int param2, Integer param3) {\n        boolean b=false;\n        b|=true;\n        param1++;\n        {\n            int val=23;\n            param2 += val;\n        }\n        param3++;\n    }\n}"}, "----------\n1. WARNING in X.java (at line 2)\n\tvoid foo(int param1, int param2, Integer param3) {\n\t             ^^^^^^\nThe value of the parameter param1 is not used\n----------\n2. WARNING in X.java (at line 2)\n\tvoid foo(int param1, int param2, Integer param3) {\n\t                         ^^^^^^\nThe value of the parameter param2 is not used\n----------\n3. WARNING in X.java (at line 3)\n\tboolean b=false;\n\t        ^\nThe value of the local variable b is not used\n----------\n", null, true, customOptions);
    }

    public void test0048() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedParameter", "warning");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedParameterWhenImplementingAbstract", "disabled");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", "warning");
        this.runNegativeTest(new String[]{"X.java", "public class X extends A implements Y{\n   public void foo(int param1, int param2, Integer param3) {\n        boolean b=false;\n        b|=true;\n        param1++;\n        param2 += 1;\n        param3++;\n    }\n   public void foo(int param1, int param2) {\n        boolean b=false;\n        b|=true;\n        param1++;\n        param2 += 1;\n    }\n   public void bar(int param1, int param2, Integer param3) {\n        param1++;\n        param2 += 1;\n        param3++;\n    }\n}\ninterface Y{\n\tpublic void foo(int param1, int param2, Integer param3);}\nabstract class A{\n\tpublic abstract void bar(int param1, int param2, Integer param3);}\n"}, "----------\n1. WARNING in X.java (at line 3)\n\tboolean b=false;\n\t        ^\nThe value of the local variable b is not used\n----------\n2. WARNING in X.java (at line 9)\n\tpublic void foo(int param1, int param2) {\n\t                    ^^^^^^\nThe value of the parameter param1 is not used\n----------\n3. WARNING in X.java (at line 9)\n\tpublic void foo(int param1, int param2) {\n\t                                ^^^^^^\nThe value of the parameter param2 is not used\n----------\n4. WARNING in X.java (at line 10)\n\tboolean b=false;\n\t        ^\nThe value of the local variable b is not used\n----------\n", null, true, customOptions);
    }

    public void test0049() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedParameter", "warning");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedParameterWhenOverridingConcrete", "disabled");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", "warning");
        this.runNegativeTest(new String[]{"X.java", "public class X extends A {\n   public void foo(int param1, int param2, Integer param3) {\n        boolean b=false;\n        b|=true;\n        param1++;\n        param2 += 1;\n        param3++;\n    }\n   public void foo(int param1, Integer param3) {\n        param1++;\n        param3++;\n    }\n}\nclass A{\n   public void foo(int param1, int param2, Integer param3) {\n        param1 -=1;\n        param2--;\n        param3--;\n    }\n}\n"}, "----------\n1. WARNING in X.java (at line 3)\n\tboolean b=false;\n\t        ^\nThe value of the local variable b is not used\n----------\n2. WARNING in X.java (at line 9)\n\tpublic void foo(int param1, Integer param3) {\n\t                    ^^^^^^\nThe value of the parameter param1 is not used\n----------\n3. WARNING in X.java (at line 15)\n\tpublic void foo(int param1, int param2, Integer param3) {\n\t                    ^^^^^^\nThe value of the parameter param1 is not used\n----------\n4. WARNING in X.java (at line 15)\n\tpublic void foo(int param1, int param2, Integer param3) {\n\t                                ^^^^^^\nThe value of the parameter param2 is not used\n----------\n", null, true, customOptions);
    }

    public void test0050() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", "warning");
        this.runNegativeTest(new String[]{"X.java", "class X {\n    int foo() {\n        int i=1;\n\t\t if (false) {\n        \tboolean b=false;\n        \tb|=true;\n\t\t }\n        int k = 2;\n        --k;\n        k+=3;\n        Integer j = 3;\n        j++;\n        return i++;\n    }\n}"}, "----------\n1. WARNING in X.java (at line 4)\n\tif (false) {\n        \tboolean b=false;\n        \tb|=true;\n\t\t }\n\t           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nDead code\n----------\n2. WARNING in X.java (at line 8)\n\tint k = 2;\n\t    ^\nThe value of the local variable k is not used\n----------\n", null, true, customOptions);
    }

    public void test0051() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedParameter", "warning");
        this.runNegativeTest(new String[]{"X.java", "class X {\n    X(int abc) {\n        abc++;\n    }\n}"}, "----------\n1. WARNING in X.java (at line 2)\n\tX(int abc) {\n\t      ^^^\nThe value of the parameter abc is not used\n----------\n", null, true, customOptions);
    }

    public void test0052() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "error");
        this.runConformTest(new String[]{"X.java", "class X {\n    Y y = new Y();\n    private class Y {\n        int abc;\n        Y() {\n            abc++;\n        }\n    }\n    class Z extends Y {}\n}"}, "", null, true, null, customOptions, null);
    }

    public void test0052a() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.syntheticAccessEmulation", "ignore");
        this.runConformTest(new String[]{"Outer.java", "class Outer {\n    private class Inner1 {\n        int foo;\n    }\n    private class Inner2 extends Inner1 { }\n    class Inner3 extends Inner2 { }\n}\n"}, "", null, true, null, customOptions, null);
    }

    public void test0052b() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.syntheticAccessEmulation", "ignore");
        this.runConformTest(new String[]{"Outer.java", "class Outer {\n    private class Inner1 {\n        class Foo{}\n    }\n    private class Inner2 extends Inner1 { }\n    class Inner3 extends Inner2 { }\n}\n"}, "", null, true, null, customOptions, null);
    }

    public void test0053() throws Exception {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", "warning");
        this.runConformTest(new String[]{"X.java", "class X {\n    int foo() {\n        int i=1;\n        i++;\n        return 0;\n    }\n}"}, "", null, true, null, customOptions, null);
        String expectedOutput = "  // Method descriptor #15 ()I\n  // Stack: 1, Locals: 1\n  int foo();\n    0  iconst_0\n    1  ireturn\n      Line numbers:\n        [pc: 0, line: 5]\n      Local variable table:\n        [pc: 0, pc: 2] local: this index: 0 type: X\n";
        this.checkDisassembledClassFile(OUTPUT_DIR + File.separator + "X.class", "X", expectedOutput);
    }

    public void test0054() throws Exception {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", "error");
        this.runConformTest(new String[]{"X.java", "class X {\n    int foo() {\n        int i=1;\n        return i+=1;\n    }\n}"}, "", null, true, null, customOptions, null);
        String expectedOutput = "  // Method descriptor #15 ()I\n  // Stack: 1, Locals: 2\n  int foo();\n    0  iconst_1\n    1  istore_1 [i]\n    2  iinc 1 1 [i]\n    5  iload_1 [i]\n    6  ireturn\n      Line numbers:\n        [pc: 0, line: 3]\n        [pc: 2, line: 4]\n      Local variable table:\n        [pc: 0, pc: 7] local: this index: 0 type: X\n        [pc: 2, pc: 7] local: i index: 1 type: int\n";
        this.checkDisassembledClassFile(OUTPUT_DIR + File.separator + "X.class", "X", expectedOutput);
    }

    public void test0055() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "ignore");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", "warning");
        customOptions.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", "preserve");
        this.runNegativeTest(new String[]{"test1/E.java", "package test1;\npublic class E {\n    private void foo() {\n        int a= 10;\n        a++;\n        a--;\n        --a;\n        ++a;\n        for ( ; ; a++) {\n        }\n    }\n}"}, "----------\n1. WARNING in test1\\E.java (at line 4)\n\tint a= 10;\n\t    ^\nThe value of the local variable a is not used\n----------\n", null, true, customOptions);
    }

    public void test0056() throws Exception {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", "error");
        this.runConformTest(new String[]{"X.java", "public class X {\n    static int foo() {\n        int i = 2;\n        int j = 3;\n        return (i += j *= 3);\n    }\n    public static void main(String[] args) {\n        System.out.println(foo());\n    }\n}"}, "11", null, true, null, customOptions, null);
    }

    public void test0057() throws Exception {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", "ignore");
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static void main (String args[]) {\n        int i = 0;\n        i += 4 + foo();\n    }\n    public static int foo() {\n    \tSystem.out.println(\"OK\");\n    \treturn 0;\n    }\n}"}, "OK", null, true, null, customOptions, null);
    }

    public void _test0058() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", "warning");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    void foo(String m) {\n        final String message= m;\n        new Runnable() {\n            public void run() {\n                if (\"x\".equals(message)) {\n                    bug(); // undefined method\n                }\n            }\n        }.run();\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tbug(); // undefined method\n\t^^^\nThe method bug() is undefined for the type new Runnable(){}\n----------\n", null, true, customOptions);
    }

    public void test0059() throws Exception {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", "warning");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.deadCode", "warning");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    public static void main(String[] args) {\n    \tObject a = null;\n    \tif (a != null){\n        \tint j = 3;\n        \tj++;\n    \t}\n    \tSystem.out.println(\"OK\");\n    }\n}"}, "----------\n1. WARNING in X.java (at line 4)\n\tif (a != null){\n        \tint j = 3;\n        \tj++;\n    \t}\n\t              ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nDead code\n----------\n2. WARNING in X.java (at line 5)\n\tint j = 3;\n\t    ^\nThe value of the local variable j is not used\n----------\n", null, true, customOptions);
    }

    public void test0060() throws Exception {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.uninternedIdentityComparison", "enabled");
        this.runNegativeTest(new String[]{"org/eclipse/jdt/internal/compiler/lookup/X.java", "package org.eclipse.jdt.internal.compiler.lookup;\nclass TypeBinding {\n}\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tTypeBinding t1 = null, t2 = null;\n\t\tif (t1 == t2) { \n\t\t\tif (t2 == t1) {  //$IDENTITY-COMPARISON$\n\t\t\t\tif (t1 == t2) {\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n\tpublic static void gain(String[] args) {\n\t\tTypeBinding t1 = null, t2 = null;\n\t\tif (t1 == t2) { \n\t\t\tif (t2 == t1) {  //$IDENTITY-COMPARISON$\n\t\t\t\tif (t1 == t2) {\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n\tpublic static void vain(String[] args) {\n\t\tTypeBinding t1 = null, t2 = null;\n\t\t//$IDENTITY-COMPARISON$\n\t\t//$IDENTITY-COMPARISON$\n\t\t//$IDENTITY-COMPARISON$\n\t\tif (t1 == t2) { \n\t\t\tif (t2 == t1) {  //$IDENTITY-COMPARISON$\n\t\t\t\tif (t1 == t2) { //$IDENTITY-COMPARISON$\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n\tpublic static void cain(String[] args) {\n\t\tTypeBinding t1 = null, t2 = null;\n\t\tif (t1 == t2) { //$IDENTITY-COMPARISON$\n\t\t\tif (t2 == t1) {  //$IDENTITY-COMPARISON$\n\t\t\t\tif (t1 == t2) { //$IDENTITY-COMPARISON$\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in org\\eclipse\\jdt\\internal\\compiler\\lookup\\X.java (at line 7)\n\tif (t1 == t2) { \n\t    ^^^^^^^^\nThe uninterned types TypeBinding and TypeBinding should not be compared using ==/!= operators.\n----------\n2. ERROR in org\\eclipse\\jdt\\internal\\compiler\\lookup\\X.java (at line 9)\n\tif (t1 == t2) {\n\t    ^^^^^^^^\nThe uninterned types TypeBinding and TypeBinding should not be compared using ==/!= operators.\n----------\n3. ERROR in org\\eclipse\\jdt\\internal\\compiler\\lookup\\X.java (at line 16)\n\tif (t1 == t2) { \n\t    ^^^^^^^^\nThe uninterned types TypeBinding and TypeBinding should not be compared using ==/!= operators.\n----------\n4. ERROR in org\\eclipse\\jdt\\internal\\compiler\\lookup\\X.java (at line 18)\n\tif (t1 == t2) {\n\t    ^^^^^^^^\nThe uninterned types TypeBinding and TypeBinding should not be compared using ==/!= operators.\n----------\n5. ERROR in org\\eclipse\\jdt\\internal\\compiler\\lookup\\X.java (at line 28)\n\tif (t1 == t2) { \n\t    ^^^^^^^^\nThe uninterned types TypeBinding and TypeBinding should not be compared using ==/!= operators.\n----------\n", null, true, customOptions);
    }

    public void test0061() throws Exception {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.uninternedIdentityComparison", "enabled");
        this.runNegativeTest(new String[]{"org/eclipse/nonjdt/internal/compiler/lookup/X.java", "package org.eclipse.nonjdt.internal.compiler.lookup;\nclass TypeBinding {\n}\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tTypeBinding t1 = null, t2 = null;\n\t\tif (t1 == t2) { \n\t\t\tif (t2 == t1) {  //$IDENTITY-COMPARISON$\n\t\t\t\tif (t1 == t2) {\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n\tpublic static void gain(String[] args) {\n\t\tTypeBinding t1 = null, t2 = null;\n\t\tif (t1 == t2) { \n\t\t\tif (t2 == t1) {  //$IDENTITY-COMPARISON$\n\t\t\t\tif (t1 == t2) {\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n\tpublic static void vain(String[] args) {\n\t\tTypeBinding t1 = null, t2 = null;\n\t\t//$IDENTITY-COMPARISON$\n\t\t//$IDENTITY-COMPARISON$\n\t\t//$IDENTITY-COMPARISON$\n\t\tif (t1 == t2) { \n\t\t\tif (t2 == t1) {  //$IDENTITY-COMPARISON$\n\t\t\t\tif (t1 == t2) { //$IDENTITY-COMPARISON$\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n\tpublic static void cain(String[] args) {\n\t\tTypeBinding t1 = null, t2 = null;\n\t\tif (t1 == t2) { //$IDENTITY-COMPARISON$\n\t\t\tif (t2 == t1) {  //$IDENTITY-COMPARISON$\n\t\t\t\tif (t1 == t2) { //$IDENTITY-COMPARISON$\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n}\n"}, "", null, true, customOptions);
    }

    public void test0062() throws Exception {
        Map customOptions = this.getCompilerOptions();
        this.runNegativeTest(new String[]{"org/eclipse/jdt/internal/compiler/lookup/X.java", "package org.eclipse.jdt.internal.compiler.lookup;\nclass TypeBinding {\n}\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tTypeBinding t1 = null, t2 = null;\n\t\tif (t1 == t2) { \n\t\t\tif (t2 == t1) {  //$IDENTITY-COMPARISON$\n\t\t\t\tif (t1 == t2) {\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n\tpublic static void gain(String[] args) {\n\t\tTypeBinding t1 = null, t2 = null;\n\t\tif (t1 == t2) { \n\t\t\tif (t2 == t1) {  //$IDENTITY-COMPARISON$\n\t\t\t\tif (t1 == t2) {\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n\tpublic static void vain(String[] args) {\n\t\tTypeBinding t1 = null, t2 = null;\n\t\t//$IDENTITY-COMPARISON$\n\t\t//$IDENTITY-COMPARISON$\n\t\t//$IDENTITY-COMPARISON$\n\t\tif (t1 == t2) { \n\t\t\tif (t2 == t1) {  //$IDENTITY-COMPARISON$\n\t\t\t\tif (t1 == t2) { //$IDENTITY-COMPARISON$\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n\tpublic static void cain(String[] args) {\n\t\tTypeBinding t1 = null, t2 = null;\n\t\tif (t1 == t2) { //$IDENTITY-COMPARISON$\n\t\t\tif (t2 == t1) {  //$IDENTITY-COMPARISON$\n\t\t\t\tif (t1 == t2) { //$IDENTITY-COMPARISON$\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n}\n"}, "", null, true, customOptions);
    }

    public void test0063() throws Exception {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.uninternedIdentityComparison", "enabled");
        this.runNegativeTest(new String[]{"org/eclipse/jdt/core/dom/X.java", "package org.eclipse.jdt.core.dom;\ninterface ITypeBinding {\n}\nclass TypeBinding implements ITypeBinding {\n}\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tTypeBinding t1 = null, t2 = null;\n\t\tif (t1 == t2) { \n\t\t\tif (t2 == t1) {  //$IDENTITY-COMPARISON$\n\t\t\t\tif (t1 == t2) {\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n\tpublic static void gain(String[] args) {\n\t\tTypeBinding t1 = null, t2 = null;\n\t\tif (t1 == t2) { \n\t\t\tif (t2 == t1) {  //$IDENTITY-COMPARISON$\n\t\t\t\tif (t1 == t2) {\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n\tpublic static void vain(String[] args) {\n\t\tTypeBinding t1 = null, t2 = null;\n\t\t//$IDENTITY-COMPARISON$\n\t\t//$IDENTITY-COMPARISON$\n\t\t//$IDENTITY-COMPARISON$\n\t\tif (t1 == t2) { \n\t\t\tif (t2 == t1) {  //$IDENTITY-COMPARISON$\n\t\t\t\tif (t1 == t2) { //$IDENTITY-COMPARISON$\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n\tpublic static void cain(String[] args) {\n\t\tTypeBinding t1 = null, t2 = null;\n\t\tif (t1 == t2) { //$IDENTITY-COMPARISON$\n\t\t\tif (t2 == t1) {  //$IDENTITY-COMPARISON$\n\t\t\t\tif (t1 == t2) { //$IDENTITY-COMPARISON$\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in org\\eclipse\\jdt\\core\\dom\\X.java (at line 9)\n\tif (t1 == t2) { \n\t    ^^^^^^^^\nThe uninterned types TypeBinding and TypeBinding should not be compared using ==/!= operators.\n----------\n2. ERROR in org\\eclipse\\jdt\\core\\dom\\X.java (at line 11)\n\tif (t1 == t2) {\n\t    ^^^^^^^^\nThe uninterned types TypeBinding and TypeBinding should not be compared using ==/!= operators.\n----------\n3. ERROR in org\\eclipse\\jdt\\core\\dom\\X.java (at line 18)\n\tif (t1 == t2) { \n\t    ^^^^^^^^\nThe uninterned types TypeBinding and TypeBinding should not be compared using ==/!= operators.\n----------\n4. ERROR in org\\eclipse\\jdt\\core\\dom\\X.java (at line 20)\n\tif (t1 == t2) {\n\t    ^^^^^^^^\nThe uninterned types TypeBinding and TypeBinding should not be compared using ==/!= operators.\n----------\n5. ERROR in org\\eclipse\\jdt\\core\\dom\\X.java (at line 30)\n\tif (t1 == t2) { \n\t    ^^^^^^^^\nThe uninterned types TypeBinding and TypeBinding should not be compared using ==/!= operators.\n----------\n", null, true, customOptions);
    }

    public void testBug410218a() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\nclass X {\n  void test() {\n\tSet<Short> set = new HashSet<Short>();\n\tshort one = 1;\n\tset.add(one);\n\n\tif (set.contains(\"ONE\")) // bad\n\t\tset.remove(\"ONE\"); // bad\n\tif (set.contains(1)) // bad\n\t\tset.remove(1); // bad (tries to remove \"Integer 1\")\n\tSystem.out.println(set); // shows that the \"Short 1\" is still in!\n\n\tif (set.contains(one)) // ok\n\t\tset.remove(one); // ok\n\tif (set.contains(Short.valueOf(one))) // ok\n\t\tset.remove(Short.valueOf(one)); // ok\n\tSystem.out.println(set);\n  }\n}\n"}, "----------\n1. WARNING in X.java (at line 8)\n\tif (set.contains(\"ONE\")) // bad\n\t                 ^^^^^\nUnlikely argument type String for contains(Object) on a Collection<Short>\n----------\n2. WARNING in X.java (at line 9)\n\tset.remove(\"ONE\"); // bad\n\t           ^^^^^\nUnlikely argument type String for remove(Object) on a Collection<Short>\n----------\n3. WARNING in X.java (at line 10)\n\tif (set.contains(1)) // bad\n\t                 ^\nUnlikely argument type int for contains(Object) on a Collection<Short>\n----------\n4. WARNING in X.java (at line 11)\n\tset.remove(1); // bad (tries to remove \"Integer 1\")\n\t           ^\nUnlikely argument type int for remove(Object) on a Collection<Short>\n----------\n");
    }

    public void testBug410218b() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\nclass X {\n  <T> void test(Set<HashSet<T>> hss, TreeSet<T> ts, LinkedHashSet<T> lhs) {\n\tif (hss.contains(ts)) // bad\n\t\thss.remove(ts); // bad\n\tif (hss.contains((Set<T>)ts)) // ok\n\t\thss.remove((Set<T>)ts); // ok\n\tif (hss.contains(lhs)) // ok\n\t\thss.remove(lhs); // ok\n  }\n}\n"}, "----------\n1. WARNING in X.java (at line 4)\n\tif (hss.contains(ts)) // bad\n\t                 ^^\nUnlikely argument type TreeSet<T> for contains(Object) on a Collection<HashSet<T>>\n----------\n2. WARNING in X.java (at line 5)\n\thss.remove(ts); // bad\n\t           ^^\nUnlikely argument type TreeSet<T> for remove(Object) on a Collection<HashSet<T>>\n----------\n");
    }

    public void testBug410218b2() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unlikelyCollectionMethodArgumentTypeStrict", "enabled");
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\nclass X {\n  <T> void test(Set<HashSet<T>> hss, TreeSet<T> ts, LinkedHashSet<T> lhs) {\n\tif (hss.contains(ts)) // bad\n\t\thss.remove(ts); // bad\n\tif (hss.contains((Set<T>)ts)) // bad (because of strict check)\n\t\thss.remove((Set<T>)ts); // bad (because of strict check)\n\tif (hss.contains(lhs)) // ok\n\t\thss.remove(lhs); // ok\n  }\n}\n"}, "----------\n1. WARNING in X.java (at line 4)\n\tif (hss.contains(ts)) // bad\n\t                 ^^\nUnlikely argument type TreeSet<T> for contains(Object) on a Collection<HashSet<T>>\n----------\n2. WARNING in X.java (at line 5)\n\thss.remove(ts); // bad\n\t           ^^\nUnlikely argument type TreeSet<T> for remove(Object) on a Collection<HashSet<T>>\n----------\n3. WARNING in X.java (at line 6)\n\tif (hss.contains((Set<T>)ts)) // bad (because of strict check)\n\t                 ^^^^^^^^^^\nUnlikely argument type Set<T> for contains(Object) on a Collection<HashSet<T>>\n----------\n4. WARNING in X.java (at line 7)\n\thss.remove((Set<T>)ts); // bad (because of strict check)\n\t           ^^^^^^^^^^\nUnlikely argument type Set<T> for remove(Object) on a Collection<HashSet<T>>\n----------\n", null, true, customOptions);
    }

    public void testBug410218c() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\nclass X {\n  Number test(Map<? extends Number, Number> m, boolean f) {\n\tif (m.containsKey(\"ONE\")) // bad\n\t\tm.remove(\"ONE\"); // bad\n\tif (m.containsValue(\"ONE\")) // bad\n\t\tm.remove(\"ONE\"); // bad\n\tshort one = 1;\n\tif (m.containsKey(one)) // almost ok\n\t\tm.remove(one); // almost ok\n\tif (m.containsValue(Short.valueOf(one))) // ok\n\t\tm.remove(Short.valueOf(one)); // almost ok\n\tif (f)\n\t\treturn m.get(\"ONE\"); // bad\n\treturn m.get(one);\n // almost ok\n  }\n}\n"}, "----------\n1. WARNING in X.java (at line 4)\n\tif (m.containsKey(\"ONE\")) // bad\n\t                  ^^^^^\nUnlikely argument type String for containsKey(Object) on a Map<capture#1-of ? extends Number,Number>\n----------\n2. WARNING in X.java (at line 5)\n\tm.remove(\"ONE\"); // bad\n\t         ^^^^^\nUnlikely argument type String for remove(Object) on a Map<capture#2-of ? extends Number,Number>\n----------\n3. WARNING in X.java (at line 6)\n\tif (m.containsValue(\"ONE\")) // bad\n\t                    ^^^^^\nUnlikely argument type String for containsValue(Object) on a Map<capture#3-of ? extends Number,Number>\n----------\n4. WARNING in X.java (at line 7)\n\tm.remove(\"ONE\"); // bad\n\t         ^^^^^\nUnlikely argument type String for remove(Object) on a Map<capture#4-of ? extends Number,Number>\n----------\n5. WARNING in X.java (at line 14)\n\treturn m.get(\"ONE\"); // bad\n\t             ^^^^^\nUnlikely argument type String for get(Object) on a Map<capture#9-of ? extends Number,Number>\n----------\n");
    }

    public void testBug410218d() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unlikelyCollectionMethodArgumentType", "error");
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\ninterface NumberCollection extends Collection<Number> {}\nclass X {\n  void test(NumberCollection numbers, List<Integer> ints, Set<String> stringSet) {\n\tif (numbers.containsAll(ints)) // ok\n\t\tnumbers.removeAll(ints); // ok\n\telse\n\t\tnumbers.retainAll(ints); // ok\n\n\tnumbers.removeAll(stringSet); // bad\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 10)\n\tnumbers.removeAll(stringSet); // bad\n\t                  ^^^^^^^^^\nUnlikely argument type Set<String> for removeAll(Collection<?>) on a Collection<Number>\n----------\n", null, true, customOptions);
    }

    public void testBug410218e() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unlikelyCollectionMethodArgumentType", "warning");
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\nclass X {\n  int test1(List<Integer> ints, Object o) {\n\treturn ints.indexOf(\"ONE\"); // bad\n  }\n  @SuppressWarnings(\"unlikely-arg-type\")\n  int test2(List<Integer> ints, boolean f, Object o) {\n\tif (f)\n\t\treturn ints.indexOf(\"ONE\"); // bad but suppressed\n\treturn ints.indexOf(o); // supertype\n  }\n}\n"}, "----------\n1. WARNING in X.java (at line 4)\n\treturn ints.indexOf(\"ONE\"); // bad\n\t                    ^^^^^\nUnlikely argument type String for indexOf(Object) on a List<Integer>\n----------\n", null, true, customOptions);
    }

    public void testBug410218f() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unlikelyCollectionMethodArgumentType", "warning");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unlikelyEqualsArgumentType", "info");
        this.runNegativeTest(new String[]{"test/TestUnlikely.java", "package test;\n\nimport java.util.Collection;\nimport java.util.Iterator;\nimport java.util.List;\nimport java.util.Map;\nimport java.util.Objects;\nimport java.util.Set;\nimport java.util.function.BiPredicate;\nimport java.util.function.Predicate;\n\npublic class TestUnlikely {\n\tinterface Interface {\n\t}\n\n\tinterface OtherInterface {\n\t}\n\n\tstatic class NonFinal implements Interface {\n\t}\n\n\tstatic class Sub extends NonFinal implements OtherInterface {\n\t}\n\n\tstatic final class Final implements Interface {\n\t}\n\n\tvoid f1(List<Interface> c, Interface i, OtherInterface o, Final f, NonFinal nf, Sub s) {\n\t\tc.remove(i);\n\t\tc.remove(o); // warning: unrelated interface\n\t\tc.remove(f);\n\t\tc.remove(nf);\n\t\tc.remove(s);\n\t}\n\n\tvoid f2(List<OtherInterface> c, Interface i, OtherInterface o, Final f, NonFinal nf, Sub s) {\n\t\tc.remove(i); // warning: unrelated interface\n\t\tc.remove(o);\n\t\tc.remove(f); // warning: impossible\n\t\tc.remove(nf); // warning: castable, but not supertype\n\t\tc.remove(s);\n\t}\n\n\tvoid f3(List<Final> c, Interface i, OtherInterface o, Final f, NonFinal nf, Sub s) {\n\t\tc.remove(i); // supertype\n\t\tc.remove(o); // warning: impossible\n\t\tc.remove(f);\n\t\tc.remove(nf); // warning: impossible\n\t\tc.remove(s); // warning: impossible\n\t}\n\n\tvoid f4(List<NonFinal> c, Interface i, OtherInterface o, Final f, NonFinal nf, Sub s) {\n\t\tc.remove(i); // supertype\n\t\tc.remove(o); // warning: unrelated interface\n\t\tc.remove(f); // warning: impossible\n\t\tc.remove(nf);\n\t\tc.remove(s);\n\t}\n\n\tvoid f5(List<Sub> c, Interface i, OtherInterface o, Final f, NonFinal nf, Sub s) {\n\t\tc.remove(i); // supertype\n\t\tc.remove(o); // supertype\n\t\tc.remove(f); // warning: impossible\n\t\tc.remove(nf); // supertype\n\t\tc.remove(s);\n\t}\n\n\t<K, V> void map(Map<K, V> map, K key, V value) {\n\t\tmap.containsKey(key);\n\t\tmap.containsKey(value); // warning\n\t\tmap.containsValue(key); // warning\n\t\tmap.containsValue(value);\n\t}\n\n\tboolean wildcards(Collection<?> c, Iterable<?> s) {\n\t\tfor (Iterator<?> iterator = s.iterator(); iterator.hasNext();) {\n\t\t\tif (c.contains(iterator.next())) {\n\t\t\t\treturn true;\n\t\t\t}\n\t\t}\n\t\treturn false;\n\t}\n\n\t<T, U extends T> boolean relatedTypeVariables(Collection<T> c, Iterable<U> s) {\n\t\tfor (Iterator<?> iterator = s.iterator(); iterator.hasNext();) {\n\t\t\tif (c.contains(iterator.next())) {\n\t\t\t\treturn true;\n\t\t\t}\n\t\t}\n\t\treturn false;\n\t}\n\n\t<T, U> boolean unrelatedTypeVariables(Collection<T> c, Iterable<U> s) {\n\t\tfor (Iterator<U> iterator = s.iterator(); iterator.hasNext();) {\n\t\t\tif (c.contains(iterator.next())) { // warning\n\t\t\t\treturn true;\n\t\t\t}\n\t\t}\n\t\treturn false;\n\t}\n\n\tvoid all(List<NonFinal> c, Collection<Sub> s, Set<Final> other) {\n\t\tc.removeAll(s);\n\t\ts.removeAll(c);\n\t\tc.removeAll(other); // warning\n\t}\n\n\tvoid methodRef(Set<Interface> c, Interface i, OtherInterface o, Final f, NonFinal nf, Sub s) {\n\t\tPredicate<Interface> p1 = c::contains;\n\t\tBiPredicate<Collection<Interface>, Interface> bp1 = Collection<Interface>::contains;\n\t\tPredicate<OtherInterface> p2 = c::contains; // warning\n\t\tBiPredicate<Collection<Interface>, OtherInterface> bp2 = Collection<Interface>::contains; // warning\n\t\tp1.test(i);\n\t\tbp1.test(c, i);\n\t\tp2.test(o);\n\t\tbp2.test(c, o);\n\t}\n\n\tvoid equals(String s, Integer i, Number n) {\n\t\ts.equals(i); // info\n\t\ti.equals(s); // info\n\t\ti.equals(n);\n\t\tn.equals(i);\n\n\t\tPredicate<String> p1 = i::equals; // info\n\t\tp1.test(s);\n\n\t\tBiPredicate<String, Integer> bp2 = Object::equals; // info\n\t\tbp2.test(s, i);\n\n\t\tObjects.equals(s, i); // info\n\t\tObjects.equals(i, s); // info\n\t\tObjects.equals(n, i);\n\t\tObjects.equals(i, n);\n\n\t\tBiPredicate<String, Integer> bp3 = Objects::equals; // info\n\t\tbp3.test(s, i);\n\t}\n\n}\n"}, "----------\n1. WARNING in test\\TestUnlikely.java (at line 30)\n\tc.remove(o); // warning: unrelated interface\n\t         ^\nUnlikely argument type TestUnlikely.OtherInterface for remove(Object) on a Collection<TestUnlikely.Interface>\n----------\n2. WARNING in test\\TestUnlikely.java (at line 37)\n\tc.remove(i); // warning: unrelated interface\n\t         ^\nUnlikely argument type TestUnlikely.Interface for remove(Object) on a Collection<TestUnlikely.OtherInterface>\n----------\n3. WARNING in test\\TestUnlikely.java (at line 39)\n\tc.remove(f); // warning: impossible\n\t         ^\nUnlikely argument type TestUnlikely.Final for remove(Object) on a Collection<TestUnlikely.OtherInterface>\n----------\n4. WARNING in test\\TestUnlikely.java (at line 40)\n\tc.remove(nf); // warning: castable, but not supertype\n\t         ^^\nUnlikely argument type TestUnlikely.NonFinal for remove(Object) on a Collection<TestUnlikely.OtherInterface>\n----------\n5. WARNING in test\\TestUnlikely.java (at line 46)\n\tc.remove(o); // warning: impossible\n\t         ^\nUnlikely argument type TestUnlikely.OtherInterface for remove(Object) on a Collection<TestUnlikely.Final>\n----------\n6. WARNING in test\\TestUnlikely.java (at line 48)\n\tc.remove(nf); // warning: impossible\n\t         ^^\nUnlikely argument type TestUnlikely.NonFinal for remove(Object) on a Collection<TestUnlikely.Final>\n----------\n7. WARNING in test\\TestUnlikely.java (at line 49)\n\tc.remove(s); // warning: impossible\n\t         ^\nUnlikely argument type TestUnlikely.Sub for remove(Object) on a Collection<TestUnlikely.Final>\n----------\n8. WARNING in test\\TestUnlikely.java (at line 54)\n\tc.remove(o); // warning: unrelated interface\n\t         ^\nUnlikely argument type TestUnlikely.OtherInterface for remove(Object) on a Collection<TestUnlikely.NonFinal>\n----------\n9. WARNING in test\\TestUnlikely.java (at line 55)\n\tc.remove(f); // warning: impossible\n\t         ^\nUnlikely argument type TestUnlikely.Final for remove(Object) on a Collection<TestUnlikely.NonFinal>\n----------\n10. WARNING in test\\TestUnlikely.java (at line 63)\n\tc.remove(f); // warning: impossible\n\t         ^\nUnlikely argument type TestUnlikely.Final for remove(Object) on a Collection<TestUnlikely.Sub>\n----------\n11. WARNING in test\\TestUnlikely.java (at line 70)\n\tmap.containsKey(value); // warning\n\t                ^^^^^\nUnlikely argument type V for containsKey(Object) on a Map<K,V>\n----------\n12. WARNING in test\\TestUnlikely.java (at line 71)\n\tmap.containsValue(key); // warning\n\t                  ^^^\nUnlikely argument type K for containsValue(Object) on a Map<K,V>\n----------\n13. WARNING in test\\TestUnlikely.java (at line 95)\n\tif (c.contains(iterator.next())) { // warning\n\t               ^^^^^^^^^^^^^^^\nUnlikely argument type U for contains(Object) on a Collection<T>\n----------\n14. WARNING in test\\TestUnlikely.java (at line 105)\n\tc.removeAll(other); // warning\n\t            ^^^^^\nUnlikely argument type Set<TestUnlikely.Final> for removeAll(Collection<?>) on a Collection<TestUnlikely.NonFinal>\n----------\n15. WARNING in test\\TestUnlikely.java (at line 111)\n\tPredicate<OtherInterface> p2 = c::contains; // warning\n\t                               ^^^^^^^^^^^\nUnlikely argument type TestUnlikely.OtherInterface for contains(Object) on a Collection<TestUnlikely.Interface>\n----------\n16. WARNING in test\\TestUnlikely.java (at line 112)\n\tBiPredicate<Collection<Interface>, OtherInterface> bp2 = Collection<Interface>::contains; // warning\n\t                                                         ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nUnlikely argument type TestUnlikely.OtherInterface for contains(Object) on a Collection<TestUnlikely.Interface>\n----------\n17. INFO in test\\TestUnlikely.java (at line 120)\n\ts.equals(i); // info\n\t         ^\nUnlikely argument type for equals(): Integer seems to be unrelated to String\n----------\n18. INFO in test\\TestUnlikely.java (at line 121)\n\ti.equals(s); // info\n\t         ^\nUnlikely argument type for equals(): String seems to be unrelated to Integer\n----------\n19. INFO in test\\TestUnlikely.java (at line 125)\n\tPredicate<String> p1 = i::equals; // info\n\t                       ^^^^^^^^^\nUnlikely argument type for equals(): String seems to be unrelated to Integer\n----------\n20. INFO in test\\TestUnlikely.java (at line 128)\n\tBiPredicate<String, Integer> bp2 = Object::equals; // info\n\t                                   ^^^^^^^^^^^^^^\nUnlikely argument type for equals(): Integer seems to be unrelated to String\n----------\n21. INFO in test\\TestUnlikely.java (at line 131)\n\tObjects.equals(s, i); // info\n\t                  ^\nUnlikely argument type for equals(): Integer seems to be unrelated to String\n----------\n22. INFO in test\\TestUnlikely.java (at line 132)\n\tObjects.equals(i, s); // info\n\t                  ^\nUnlikely argument type for equals(): String seems to be unrelated to Integer\n----------\n23. INFO in test\\TestUnlikely.java (at line 136)\n\tBiPredicate<String, Integer> bp3 = Objects::equals; // info\n\t                                   ^^^^^^^^^^^^^^^\nUnlikely argument type for equals(): Integer seems to be unrelated to String\n----------\n", null, true, customOptions);
    }

    public void testBug514956a() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unlikelyCollectionMethodArgumentType", "warning");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unnecessaryTypeCheck", "error");
        this.runConformTest(new String[]{"Unlikely.java", "import java.util.Map;\n\ninterface MApplicationElement {}\ninterface EObject {}\npublic class Unlikely {\n\tvoid m(Map<MApplicationElement, MApplicationElement> map, EObject key) {\n\t\tmap.get((MApplicationElement)key);\n\t}\n}\n"}, customOptions);
    }

    public void testBug514956b() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unlikelyEqualsArgumentType", "warning");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unnecessaryTypeCheck", "error");
        this.runConformTest(new String[]{"Unlikely.java", "interface EObject {}\npublic class Unlikely {\n\tboolean m(EObject key) {\n\t\treturn this.equals((Unlikely)key);\n\t}\n}\n"}, customOptions);
    }

    public void testBug514956c() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unlikelyEqualsArgumentType", "warning");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unnecessaryTypeCheck", "error");
        this.runNegativeTest(new String[]{"Unlikely.java", "interface I1 {}\ninterface I2 {}\ninterface I3 {}\npublic class Unlikely implements I1 {\n\tboolean m1(I1 i1) {\n\t\treturn i1.equals((I1)this);\n\t}\n\tboolean m2(I1 i1, I2 i2) {\n\t\treturn i1.equals((I3)i2);\n\t}\n}\n"}, "----------\n1. ERROR in Unlikely.java (at line 6)\n\treturn i1.equals((I1)this);\n\t                 ^^^^^^^^\nUnnecessary cast from Unlikely to I1\n----------\n2. ERROR in Unlikely.java (at line 9)\n\treturn i1.equals((I3)i2);\n\t                 ^^^^^^\nUnnecessary cast from I2 to I3\n----------\n3. WARNING in Unlikely.java (at line 9)\n\treturn i1.equals((I3)i2);\n\t                 ^^^^^^\nUnlikely argument type for equals(): I3 seems to be unrelated to I1\n----------\n", null, false, customOptions);
    }

    public void testBug513310() {
        this.runConformTest(new String[]{"test/Test.java", "package test;\n\nimport java.util.List;\nimport java.util.Set;\n\npublic class Test {\n\tvoid f(List dependencyList, Set<Object> set) {\n\t\tdependencyList.removeAll(set);\n\t}\n}\n"});
    }

    public void testGH567() {
        if (this.complianceLevel < 0x410000L) {
            return;
        }
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", "warning");
        this.runNegativeTest(new String[]{"X.java", "class X {\n    record Point (int x, int y) {}\n    void foo(Object o) {\n        if (o instanceof String s) { int x; }\n        if (o instanceof Point (int xVal, int yVal)) {}\n        switch (o) {\n\t\t\t\t\tcase String c : \n\t\t\t\t\t\tbreak;\n\t\t\t\t\tdefault :\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t}        if (o instanceof String str) {  str.length();  }\n    }\n}"}, this.complianceLevel == 0x410000L ? "----------\n1. WARNING in X.java (at line 4)\n\tif (o instanceof String s) { int x; }\n\t                        ^\nThe value of the local variable s is not used\n----------\n2. WARNING in X.java (at line 4)\n\tif (o instanceof String s) { int x; }\n\t                                 ^\nThe value of the local variable x is not used\n----------\n" : "----------\n1. WARNING in X.java (at line 4)\n\tif (o instanceof String s) { int x; }\n\t                        ^\nThe value of the local variable s is not used\n----------\n2. WARNING in X.java (at line 4)\n\tif (o instanceof String s) { int x; }\n\t                                 ^\nThe value of the local variable x is not used\n----------\n3. WARNING in X.java (at line 5)\n\tif (o instanceof Point (int xVal, int yVal)) {}\n\t                            ^^^^\nThe value of the local variable xVal is not used\n----------\n4. WARNING in X.java (at line 5)\n\tif (o instanceof Point (int xVal, int yVal)) {}\n\t                                      ^^^^\nThe value of the local variable yVal is not used\n----------\n5. WARNING in X.java (at line 7)\n\tcase String c : \n\t            ^\nThe value of the local variable c is not used\n----------\n", null, true, customOptions);
    }

    public void testIssue3051() {
        if (this.complianceLevel < 0x420000L) {
            return;
        }
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", "warning");
        this.runNegativeTest(new String[]{"Unused.java", "public class Unused {\n\n    public static void main(String[] args) {\n        record R(int i, long l) {}\n        Object o = null;\n        if (o instanceof String s) {\n\n        }\n        R r = new R(1, 1);\n        switch (r) {\n        \tcase R(_, long lvar) -> {}\n        \tcase R scpatvar -> {}\n        }\n    }\n}\n"}, "----------\n1. WARNING in Unused.java (at line 6)\n\tif (o instanceof String s) {\n\t                        ^\nThe value of the local variable s is not used\n----------\n2. WARNING in Unused.java (at line 11)\n\tcase R(_, long lvar) -> {}\n\t               ^^^^\nThe value of the local variable lvar is not used\n----------\n3. WARNING in Unused.java (at line 12)\n\tcase R scpatvar -> {}\n\t       ^^^^^^^^\nThe value of the local variable scpatvar is not used\n----------\n", null, true, customOptions);
    }

    public void testIssue3051_2() {
        if (this.complianceLevel < 0x410000L) {
            return;
        }
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", "warning");
        this.runNegativeTest(new String[]{"Unused.java", "public class Unused {\n\n    public static void main(String[] args) {\n        record R(int i, long l, float f) {}\n        Object o = null;\n        if (o instanceof String s) {\n\n        }\n        R r = new R(1, 1, 1.0f);\n        switch (r) {\n        \tcase R(int ivar, long lvar, float fvar) -> {\n        \t\t\t\t\t\t\t\t\t\tSystem.out.println(ivar++);\n        \t\t\t\t\t\t\t\t\t\tlvar++;\n        \t\t\t\t\t\t\t\t}\n        \tcase R scpatvar -> {}\n        }\n    }\n}\n"}, this.complianceLevel == 0x410000L ? "----------\n1. WARNING in Unused.java (at line 6)\n\tif (o instanceof String s) {\n\t                        ^\nThe value of the local variable s is not used\n----------\n" : "----------\n1. WARNING in Unused.java (at line 6)\n\tif (o instanceof String s) {\n\t                        ^\nThe value of the local variable s is not used\n----------\n2. WARNING in Unused.java (at line 11)\n\tcase R(int ivar, long lvar, float fvar) -> {\n\t                      ^^^^\nThe value of the local variable lvar is not used\n----------\n3. WARNING in Unused.java (at line 11)\n\tcase R(int ivar, long lvar, float fvar) -> {\n\t                                  ^^^^\nThe value of the local variable fvar is not used\n----------\n4. WARNING in Unused.java (at line 15)\n\tcase R scpatvar -> {}\n\t       ^^^^^^^^\nThe value of the local variable scpatvar is not used\n----------\n", null, true, customOptions);
    }

    public void testIssue3054() {
        if (this.complianceLevel < 0x410000L) {
            return;
        }
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", "warning");
        if (this.complianceLevel > 0x410000L) {
            customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedExceptionParameter", "warning");
        }
        this.runNegativeTest(new String[]{"Unused.java", "import java.util.PriorityQueue;\nimport java.util.Queue;\nimport java.util.stream.Collectors;\nimport java.util.stream.Stream;\n\npublic class Unused {\n\tclass Order {}\n\tstatic class Resource implements AutoCloseable {\n\t\t@Override\n\t\tpublic void close() throws Exception {}\n\t}\n\n\tstatic int count(Iterable<Order> orders) {\n\t    int total = 0;\n\t    for (Order order : orders) // unused variable order\n\t        total++;\n\t    return total;\n\t}\n\n\tstatic void foo() {\n\t\tfor (int i = 0, se = sideEffect(); i < 10; i++) {  } // unused variable se\n\t}\n\n\tprivate static int sideEffect() {\n\t\tQueue<Integer> q = new PriorityQueue<>();\n\n\t\twhile (q.size() >= 3) {\n\t\t\tvar x = q.remove();\n\t\t\tvar y = q.remove(); // unused variable x\n\t\t\tvar z = q.remove(); // unused variable y\n\t\t\tif (x == 10) {\n\t\t\t}\n\t\t}\n\t\ttry {\n\n\t\t} catch (Exception e) { // unused variable e\n\n\t\t} catch (Throwable t) { // unused variable t\n\n\t\t}\n\n\t\ttry (var r = new Resource()) {    // unused variable r\n\n\t\t} catch (Exception e) {           // unused variable e\n\n\t\t}\n\n\t\tStream<String> stream = Stream.of(\"Hello\", \"World\");\n\t\tstream.collect(Collectors.toMap(String::toUpperCase, xyz -> \"NODATA\")); // unused variable xyz //$NON-NLS-1$\n\n\t\treturn 0;\n\t}\n}\n"}, this.complianceLevel == 0x410000L ? "----------\n1. WARNING in Unused.java (at line 15)\n\tfor (Order order : orders) // unused variable order\n\t           ^^^^^\nThe value of the local variable order is not used\n----------\n2. WARNING in Unused.java (at line 21)\n\tfor (int i = 0, se = sideEffect(); i < 10; i++) {  } // unused variable se\n\t                ^^\nThe value of the local variable se is not used\n----------\n3. WARNING in Unused.java (at line 29)\n\tvar y = q.remove(); // unused variable x\n\t    ^\nThe value of the local variable y is not used\n----------\n4. WARNING in Unused.java (at line 30)\n\tvar z = q.remove(); // unused variable y\n\t    ^\nThe value of the local variable z is not used\n----------\n" : "----------\n1. WARNING in Unused.java (at line 15)\n\tfor (Order order : orders) // unused variable order\n\t           ^^^^^\nThe value of the local variable order is not used\n----------\n2. WARNING in Unused.java (at line 21)\n\tfor (int i = 0, se = sideEffect(); i < 10; i++) {  } // unused variable se\n\t                ^^\nThe value of the local variable se is not used\n----------\n3. WARNING in Unused.java (at line 29)\n\tvar y = q.remove(); // unused variable x\n\t    ^\nThe value of the local variable y is not used\n----------\n4. WARNING in Unused.java (at line 30)\n\tvar z = q.remove(); // unused variable y\n\t    ^\nThe value of the local variable z is not used\n----------\n5. WARNING in Unused.java (at line 36)\n\t} catch (Exception e) { // unused variable e\n\t                   ^\nThe value of the exception parameter e is not used\n----------\n6. WARNING in Unused.java (at line 38)\n\t} catch (Throwable t) { // unused variable t\n\t                   ^\nThe value of the exception parameter t is not used\n----------\n7. WARNING in Unused.java (at line 42)\n\ttry (var r = new Resource()) {    // unused variable r\n\t         ^\nThe value of the local variable r is not used\n----------\n8. WARNING in Unused.java (at line 44)\n\t} catch (Exception e) {           // unused variable e\n\t                   ^\nThe value of the exception parameter e is not used\n----------\n9. WARNING in Unused.java (at line 49)\n\tstream.collect(Collectors.toMap(String::toUpperCase, xyz -> \"NODATA\")); // unused variable xyz //$NON-NLS-1$\n\t                                                     ^^^\nThe value of the lambda parameter xyz is not used\n----------\n", null, true, customOptions);
    }

    public void testIssue3054_2() {
        if (this.complianceLevel < 0x410000L) {
            return;
        }
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", "warning");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedLambdaParameter", "error");
        this.runNegativeTest(new String[]{"Unused.java", "import java.util.PriorityQueue;\nimport java.util.Queue;\nimport java.util.stream.Collectors;\nimport java.util.stream.Stream;\n\npublic class Unused {\n\tclass Order {}\n\tstatic class Resource implements AutoCloseable {\n\t\t@Override\n\t\tpublic void close() throws Exception {}\n\t}\n\n\tstatic int count(Iterable<Order> orders) {\n\t    int total = 0;\n\t    for (Order order : orders) // unused variable order\n\t        total++;\n\t    return total;\n\t}\n\n\tstatic void foo() {\n\t\tfor (int i = 0, se = sideEffect(); i < 10; i++) {  } // unused variable se\n\t}\n\n\tprivate static int sideEffect() {\n\t\tQueue<Integer> q = new PriorityQueue<>();\n\n\t\twhile (q.size() >= 3) {\n\t\t\tvar x = q.remove();\n\t\t\tvar y = q.remove(); // unused variable x\n\t\t\tvar z = q.remove(); // unused variable y\n\t\t\tif (x == 10) {\n\t\t\t}\n\t\t}\n\t\ttry {\n\n\t\t} catch (Exception e) { // unused variable e\n\n\t\t} catch (Throwable t) { // unused variable t\n\n\t\t}\n\n\t\ttry (var r = new Resource()) {    // unused variable r\n\n\t\t} catch (Exception e) {           // unused variable e\n\n\t\t}\n\n\t\tStream<String> stream = Stream.of(\"Hello\", \"World\");\n\t\tstream.collect(Collectors.toMap(String::toUpperCase, xyz -> \"NODATA\")); // unused variable xyz //$NON-NLS-1$\n\n\t\treturn 0;\n\t}\n}\n"}, this.complianceLevel == 0x410000L ? "----------\n1. WARNING in Unused.java (at line 15)\n\tfor (Order order : orders) // unused variable order\n\t           ^^^^^\nThe value of the local variable order is not used\n----------\n2. WARNING in Unused.java (at line 21)\n\tfor (int i = 0, se = sideEffect(); i < 10; i++) {  } // unused variable se\n\t                ^^\nThe value of the local variable se is not used\n----------\n3. WARNING in Unused.java (at line 29)\n\tvar y = q.remove(); // unused variable x\n\t    ^\nThe value of the local variable y is not used\n----------\n4. WARNING in Unused.java (at line 30)\n\tvar z = q.remove(); // unused variable y\n\t    ^\nThe value of the local variable z is not used\n----------\n" : "----------\n1. WARNING in Unused.java (at line 15)\n\tfor (Order order : orders) // unused variable order\n\t           ^^^^^\nThe value of the local variable order is not used\n----------\n2. WARNING in Unused.java (at line 21)\n\tfor (int i = 0, se = sideEffect(); i < 10; i++) {  } // unused variable se\n\t                ^^\nThe value of the local variable se is not used\n----------\n3. WARNING in Unused.java (at line 29)\n\tvar y = q.remove(); // unused variable x\n\t    ^\nThe value of the local variable y is not used\n----------\n4. WARNING in Unused.java (at line 30)\n\tvar z = q.remove(); // unused variable y\n\t    ^\nThe value of the local variable z is not used\n----------\n5. WARNING in Unused.java (at line 42)\n\ttry (var r = new Resource()) {    // unused variable r\n\t         ^\nThe value of the local variable r is not used\n----------\n6. ERROR in Unused.java (at line 49)\n\tstream.collect(Collectors.toMap(String::toUpperCase, xyz -> \"NODATA\")); // unused variable xyz //$NON-NLS-1$\n\t                                                     ^^^\nThe value of the lambda parameter xyz is not used\n----------\n", null, true, customOptions);
    }

    public void testIssue3054_3() {
        if (this.complianceLevel < 0x410000L) {
            return;
        }
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", "warning");
        this.runNegativeTest(new String[]{"Unused.java", "import java.util.PriorityQueue;\nimport java.util.Queue;\nimport java.util.stream.Collectors;\nimport java.util.stream.Stream;\n\npublic class Unused {\n\tclass Order {}\n\tstatic class Resource implements AutoCloseable {\n\t\t@Override\n\t\tpublic void close() throws Exception {}\n\t}\n\n\tstatic int count(Iterable<Order> orders) {\n\t    int total = 0;\n\t    for (Order order : orders) // unused variable order\n\t        total++;\n\t    return total;\n\t}\n\n\tstatic void foo() {\n\t\tfor (int i = 0, se = sideEffect(); i < 10; i++) {  } // unused variable se\n\t}\n\n\tprivate static int sideEffect() {\n\t\tQueue<Integer> q = new PriorityQueue<>();\n\n\t\twhile (q.size() >= 3) {\n\t\t\tvar x = q.remove();\n\t\t\tvar y = q.remove(); // unused variable x\n\t\t\tvar z = q.remove(); // unused variable y\n\t\t\tif (x == 10) {\n\t\t\t}\n\t\t}\n\t\ttry {\n\n\t\t} catch (Exception e) { // unused variable e\n\n\t\t} catch (Throwable t) { // unused variable t\n\n\t\t}\n\n\t\ttry (var r = new Resource()) {    // unused variable r\n\n\t\t} catch (Exception e) {           // unused variable e\n\n\t\t}\n\n\t\tStream<String> stream = Stream.of(\"Hello\", \"World\");\n\t\tstream.collect(Collectors.toMap(String::toUpperCase, xyz -> \"NODATA\")); // unused variable xyz //$NON-NLS-1$\n\n\t\treturn 0;\n\t}\n}\n"}, this.complianceLevel == 0x410000L ? "----------\n1. WARNING in Unused.java (at line 15)\n\tfor (Order order : orders) // unused variable order\n\t           ^^^^^\nThe value of the local variable order is not used\n----------\n2. WARNING in Unused.java (at line 21)\n\tfor (int i = 0, se = sideEffect(); i < 10; i++) {  } // unused variable se\n\t                ^^\nThe value of the local variable se is not used\n----------\n3. WARNING in Unused.java (at line 29)\n\tvar y = q.remove(); // unused variable x\n\t    ^\nThe value of the local variable y is not used\n----------\n4. WARNING in Unused.java (at line 30)\n\tvar z = q.remove(); // unused variable y\n\t    ^\nThe value of the local variable z is not used\n----------\n" : "----------\n1. WARNING in Unused.java (at line 15)\n\tfor (Order order : orders) // unused variable order\n\t           ^^^^^\nThe value of the local variable order is not used\n----------\n2. WARNING in Unused.java (at line 21)\n\tfor (int i = 0, se = sideEffect(); i < 10; i++) {  } // unused variable se\n\t                ^^\nThe value of the local variable se is not used\n----------\n3. WARNING in Unused.java (at line 29)\n\tvar y = q.remove(); // unused variable x\n\t    ^\nThe value of the local variable y is not used\n----------\n4. WARNING in Unused.java (at line 30)\n\tvar z = q.remove(); // unused variable y\n\t    ^\nThe value of the local variable z is not used\n----------\n5. WARNING in Unused.java (at line 42)\n\ttry (var r = new Resource()) {    // unused variable r\n\t         ^\nThe value of the local variable r is not used\n----------\n6. WARNING in Unused.java (at line 49)\n\tstream.collect(Collectors.toMap(String::toUpperCase, xyz -> \"NODATA\")); // unused variable xyz //$NON-NLS-1$\n\t                                                     ^^^\nThe value of the lambda parameter xyz is not used\n----------\n", null, true, customOptions);
    }

    public void testIssue3054_4() {
        if (this.complianceLevel < 0x420000L) {
            return;
        }
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", "warning");
        this.runNegativeTest(new String[]{"Unused.java", "import java.util.PriorityQueue;\nimport java.util.Queue;\nimport java.util.stream.Collectors;\nimport java.util.stream.Stream;\nimport java.util.Map;\npublic class Unused {\n\tclass Order {}\n\tstatic class Resource implements AutoCloseable {\n\t\t@Override\n\t\tpublic void close() throws Exception {}\n\t}\n\n\tstatic int count(Iterable<Order> orders) {\n\t    int total = 0;\n\t    for (Order order : orders) // unused variable order\n\t        total++;\n\t    return total;\n\t}\n\n\tstatic void foo() {\n\t\tfor (int i = 0, se = sideEffect(); i < 10; i++) {  } // unused variable se\n\t}\n\n\tprivate static int sideEffect() {\n\t\tQueue<Integer> q = new PriorityQueue<>();\n\n\t\twhile (q.size() >= 3) {\n\t\t\tvar x = q.remove();\n\t\t\tvar y = q.remove(); // unused variable x\n\t\t\tvar z = q.remove(); // unused variable y\n\t\t\tif (x == 10) {\n\t\t\t}\n\t\t}\n\t\ttry {\n\n\t\t} catch (Exception e) { // unused variable e\n\n\t\t} catch (Throwable t) { // unused variable t\n\n\t\t}\n\n\t\ttry (var r = new Resource()) {    // unused variable r\n\n\t\t} catch (Exception e) {           // unused variable e\n\n\t\t}\n\n\t\tStream<String> stream = Stream.of(\"Hello\", \"World\");\n\t\t@SuppressWarnings(\"unused\")\n\t\tMap<String, String> m = stream.collect(Collectors.toMap(String::toUpperCase, xyz -> \"NODATA\")); // unused variable xyz //$NON-NLS-1$\n\n\t\treturn 0;\n\t}\n}\n"}, "----------\n1. WARNING in Unused.java (at line 15)\n\tfor (Order order : orders) // unused variable order\n\t           ^^^^^\nThe value of the local variable order is not used\n----------\n2. WARNING in Unused.java (at line 21)\n\tfor (int i = 0, se = sideEffect(); i < 10; i++) {  } // unused variable se\n\t                ^^\nThe value of the local variable se is not used\n----------\n3. WARNING in Unused.java (at line 29)\n\tvar y = q.remove(); // unused variable x\n\t    ^\nThe value of the local variable y is not used\n----------\n4. WARNING in Unused.java (at line 30)\n\tvar z = q.remove(); // unused variable y\n\t    ^\nThe value of the local variable z is not used\n----------\n5. WARNING in Unused.java (at line 42)\n\ttry (var r = new Resource()) {    // unused variable r\n\t         ^\nThe value of the local variable r is not used\n----------\n", null, true, customOptions);
    }

    public void testIssue3054_5() {
        if (this.complianceLevel < 0x420000L) {
            return;
        }
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", "warning");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedExceptionParameter", "warning");
        this.runNegativeTest(new String[]{"Unused.java", "import java.util.PriorityQueue;\nimport java.util.Queue;\nimport java.util.stream.Collectors;\nimport java.util.stream.Stream;\nimport java.util.Map;\npublic class Unused {\n\tclass Order {}\n\tstatic class Resource implements AutoCloseable {\n\t\t@Override\n\t\tpublic void close() throws Exception {}\n\t}\n\n\tstatic int count(Iterable<Order> orders) {\n\t    int total = 0;\n\t    for (Order _ : orders) // unused variable order\n\t        total++;\n\t    return total;\n\t}\n\n\tstatic void foo() {\n\t\tfor (int i = 0, _ = sideEffect(); i < 10; i++) {  } // unused variable se\n\t}\n\n\tprivate static int sideEffect() {\n\t\tQueue<Integer> q = new PriorityQueue<>();\n\n\t\twhile (q.size() >= 3) {\n\t\t\tvar x = q.remove();\n\t\t\tvar _ = q.remove(); // unused variable x\n\t\t\tvar _ = q.remove(); // unused variable y\n\t\t\tif (x == 10) {\n\t\t\t}\n\t\t}\n\t\ttry {\n\n\t\t} catch (Exception _) { // unused variable e\n\n\t\t} catch (Throwable _) { // unused variable t\n\n\t\t}\n\n\t\ttry (var _ = new Resource()) {    // unused variable r\n\n\t\t} catch (Exception _) {           // unused variable e\n\n\t\t}\n\n\t\tStream<String> stream = Stream.of(\"Hello\", \"World\");\n\n\t\tMap<String, String> m = stream.collect(Collectors.toMap(String::toUpperCase, _ -> \"NODATA\")); // unused variable xyz //$NON-NLS-1$\n\n\t\treturn 0;\n\t}\n}\n"}, "----------\n1. WARNING in Unused.java (at line 50)\n\tMap<String, String> m = stream.collect(Collectors.toMap(String::toUpperCase, _ -> \"NODATA\")); // unused variable xyz //$NON-NLS-1$\n\t                    ^\nThe value of the local variable m is not used\n----------\n", null, true, customOptions);
    }

    public void testGH3660() {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.customOptions = this.getCompilerOptions();
        runner.customOptions.put("org.eclipse.jdt.core.compiler.problem.unlikelyEqualsArgumentType", "error");
        runner.testFiles = new String[]{"Snippet.java", "import java.util.HashMap;\nimport java.util.concurrent.ConcurrentHashMap;\n\npublic class Snippet {\n\tpublic static void main(String[] args) {\n\t\tHashMap<Integer, Integer> map1 = new HashMap<>();\n\t\tConcurrentHashMap<Integer, Integer> map2 = new ConcurrentHashMap<>();\n\t\tSystem.out.print(map1.equals(map2)); // true but unlikely-arg-type\n\t\tSystem.out.print(map2.equals(map1)); // true but unlikely-arg-type\n\t}\n}\n"};
        runner.expectedOutputString = "truetrue";
        runner.runConformTest();
    }

    public void testGH3870a() {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.customOptions = this.getCompilerOptions();
        runner.customOptions.put("org.eclipse.jdt.core.compiler.problem.unlikelyEqualsArgumentType", "warning");
        runner.testFiles = new String[]{"BadEquals.java", "@interface ExpectWarning {\n\tString value();\n}\n\npublic class BadEquals {\n    public static void main(String args[]) {\n        Object o[] = new Object[args.length];\n        String s[] = new String[args.length];\n        for (int i = 0; i < args.length; i++)\n            o[i] = s[i] = args[i];\n        test1(args, o, s);\n        test2(args, args, s); // modified to demonstrate success of comparison\n        test3(args, o, args); // modified to demonstrate success of comparison\n        test4(args, o, s);\n        test5(args, o, s);\n    }\n\n    @ExpectWarning(\"EC\")\n    public static void test1(String[] args, Object[] o, String[] s) {\n        if (args.equals(args)) // ECJ does not report comparing equal values\n            System.out.println(\"args.equals(args)\");\n    }\n\n    @ExpectWarning(\"EC\")\n    public static void test2(String[] args, Object[] o, String[] s) {\n\n        if (o.equals(args))\n            System.out.println(\"o.equals(args)\");\n    }\n\n    @ExpectWarning(\"EC\")\n    public static void test3(String[] args, Object[] o, String[] s) {\n\n        if (s.equals(args))\n            System.out.println(\"s.equals(args)\");\n    }\n\n    @ExpectWarning(\"EC\")\n    public static void test4(String[] args, Object[] o, String[] s) {\n\n        if (args.equals(\"test\")) // #41\n            System.out.println(\"FOund test\");\n    }\n\n    @ExpectWarning(\"EC\")\n    public static void test5(String[] args, Object[] o, String[] s) {\n        if (\"test\".equals(args)) // #47\n            System.out.println(\"Found test 2\");\n    }\n\n    @ExpectWarning(\"EC\")\n    public boolean b(int[] a, Object[] b) {\n        return a.equals(b); // #53\n    }\n\n    @ExpectWarning(\"EC\")\n    public boolean b(int[] a, long[] b) {\n        return a.equals(b); // #58\n    }\n\n    @ExpectWarning(\"EC\")\n    public boolean b(int[] a, String b) {\n        return a.equals(b); // #63\n    }\n\n    @ExpectWarning(\"EC\")\n    public boolean b(int[] a, int[][] b) {\n        return a.equals(b); // #68\n    }\n\n    @ExpectWarning(\"EC\")\n    public boolean b(int[] a, double[] b) {\n        return a.equals(b); // #73\n    }\n}\n"};
        runner.expectedCompilerLog = "----------\n1. WARNING in BadEquals.java (at line 41)\n\tif (args.equals(\"test\")) // #41\n\t                ^^^^^^\nUnlikely argument type for equals(): String seems to be unrelated to String[]\n----------\n2. WARNING in BadEquals.java (at line 47)\n\tif (\"test\".equals(args)) // #47\n\t                  ^^^^\nUnlikely argument type for equals(): String[] seems to be unrelated to String\n----------\n3. WARNING in BadEquals.java (at line 53)\n\treturn a.equals(b); // #53\n\t                ^\nUnlikely argument type for equals(): Object[] seems to be unrelated to int[]\n----------\n4. WARNING in BadEquals.java (at line 58)\n\treturn a.equals(b); // #58\n\t                ^\nUnlikely argument type for equals(): long[] seems to be unrelated to int[]\n----------\n5. WARNING in BadEquals.java (at line 63)\n\treturn a.equals(b); // #63\n\t                ^\nUnlikely argument type for equals(): String seems to be unrelated to int[]\n----------\n6. WARNING in BadEquals.java (at line 68)\n\treturn a.equals(b); // #68\n\t                ^\nUnlikely argument type for equals(): int[][] seems to be unrelated to int[]\n----------\n7. WARNING in BadEquals.java (at line 73)\n\treturn a.equals(b); // #73\n\t                ^\nUnlikely argument type for equals(): double[] seems to be unrelated to int[]\n----------\n";
        runner.expectedOutputString = "args.equals(args)\no.equals(args)\ns.equals(args)";
        runner.runConformTest();
    }

    public void testGH3870b() {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.testFiles = new String[]{"Dc.java", "public class Dc {\n\tpublic String state;\n}\n", "UPSDc.java", "import java.util.Objects;\n\npublic class UPSDc {\n\n\tboolean state;\n\n\t@Override\n\tpublic boolean equals(Object o) {\n\t\tif (o == this)\n\t\t\treturn true;\n\t\tif (!(o instanceof Dc)) {\n\t\t\treturn false;\n\t\t}\n\t\tDc dc = (Dc) o;\n\t\treturn Objects.equals(state, dc.state);\n\t}\n}\n"};
        runner.expectedCompilerLog = "----------\n1. INFO in UPSDc.java (at line 15)\n\treturn Objects.equals(state, dc.state);\n\t                             ^^^^^^^^\nUnlikely argument type for equals(): String seems to be unrelated to boolean\n----------\n";
        runner.runConformTest();
    }

    public void testIssue4065() {
        if (this.complianceLevel < 0x410000L) {
            return;
        }
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", "warning");
        this.runNegativeTest(new String[]{"InvalidDeadCodeWarning.java", "public class InvalidDeadCodeWarning {\n\n    public static void main(String[] args) {\n        try {\n            int xxx = 42;\n            new InvalidDeadCodeWarning(new MyRecord(null));\n        } catch (IllegalArgumentException e) {\n            System.out.println(e);\n        }\n\n        try {\n            new InvalidDeadCodeWarning(new MyRecord(\"  \"));\n        } catch (IllegalArgumentException e) {\n            System.out.println(e);\n        }\n\n        try {\n            new InvalidDeadCodeWarning(null);\n        } catch (IllegalArgumentException e) {\n            System.out.println(e);\n        }\n    }\n\n\n    record MyRecord(String value) {\n    }\n\n    final MyRecord myRecord;\n\n    InvalidDeadCodeWarning(MyRecord myRecord) {\n        this.myRecord = switch (myRecord) {\n            case MyRecord(var value) when value == null -> throw new IllegalArgumentException(\"myRecord contained null value\"); // \"Dead code\" warning\n            case MyRecord(var value) when value.isBlank() -> throw new IllegalArgumentException(\"myRecord contained blank value '\" + value + \"'\");\n            case null -> throw new IllegalArgumentException(\"myRecord was null\");\n            default -> myRecord;\n        };\n    }\n}\n\n"}, "----------\n1. WARNING in InvalidDeadCodeWarning.java (at line 5)\n\tint xxx = 42;\n\t    ^^^\nThe value of the local variable xxx is not used\n----------\n", null, true, customOptions);
    }
}

