/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import junit.framework.Test;
import org.eclipse.jdt.core.compiler.ITerminalSymbols;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;
import org.eclipse.jdt.internal.compiler.parser.Scanner;
import org.eclipse.jdt.internal.compiler.parser.TerminalToken;
import org.eclipse.jdt.internal.core.util.PublicScanner;

public class PublicScannerTest
extends AbstractRegressionTest {
    private Map<Integer, String> ttValueToName;
    private Map<String, TerminalToken> ttNameToValue;
    private TerminalToken[] ttFields;
    private Map<Integer, String> tsValueToName;
    private Map<String, Integer> tsNameToValue;
    private Field[] tsFields;
    private MyPublicScanner ps;
    static final Map<TerminalToken, TerminalToken> SYNTHETIC_REPLACE_TOKENS;
    static final List<TerminalToken> SYNTHETIC_SKIP_TOKENS;
    static final List<TerminalToken> MODULE_TOKENS;

    static {
        HashMap<TerminalToken, TerminalToken> map = new HashMap<TerminalToken, TerminalToken>();
        map.put(TerminalToken.TokenNameAT308DOTDOTDOT, TerminalToken.TokenNameAT);
        map.put(TerminalToken.TokenNameAT308, TerminalToken.TokenNameAT);
        map.put(TerminalToken.TokenNameCaseArrow, TerminalToken.TokenNameARROW);
        SYNTHETIC_REPLACE_TOKENS = Collections.unmodifiableMap(map);
        ArrayList<TerminalToken> list = new ArrayList<TerminalToken>();
        list.add(TerminalToken.TokenNameBeginCasePattern);
        list.add(TerminalToken.TokenNameBeginIntersectionCast);
        list.add(TerminalToken.TokenNameBeginLambda);
        list.add(TerminalToken.TokenNameBeginTypeArguments);
        list.add(TerminalToken.TokenNameElidedSemicolonAndRightBrace);
        list.add(TerminalToken.TokenNameInvalid);
        SYNTHETIC_SKIP_TOKENS = Collections.unmodifiableList(list);
        list = new ArrayList();
        list.add(TerminalToken.TokenNamemodule);
        list.add(TerminalToken.TokenNamerequires);
        list.add(TerminalToken.TokenNameexports);
        list.add(TerminalToken.TokenNameto);
        list.add(TerminalToken.TokenNameopen);
        list.add(TerminalToken.TokenNameopens);
        list.add(TerminalToken.TokenNameprovides);
        list.add(TerminalToken.TokenNamewith);
        list.add(TerminalToken.TokenNametransitive);
        list.add(TerminalToken.TokenNameuses);
        MODULE_TOKENS = Collections.unmodifiableList(list);
    }

    public PublicScannerTest(String name) {
        super(name);
    }

    public static Test suite() {
        return PublicScannerTest.buildAllCompliancesTestSuite(PublicScannerTest.testClass());
    }

    public static Class testClass() {
        return PublicScannerTest.class;
    }

    @Override
    protected void setUp() throws Exception {
        TerminalToken field;
        super.setUp();
        this.ttValueToName = new TreeMap<Integer, String>();
        this.ttNameToValue = new TreeMap<String, TerminalToken>();
        Object[] objectArray = this.ttFields = TerminalToken.values();
        int n = this.ttFields.length;
        int n2 = 0;
        while (n2 < n) {
            field = objectArray[n2];
            String fName = field.name();
            if (fName.equals("TokenNamesealed")) {
                fName = "TokenNameRestrictedIdentifiersealed";
            } else if (fName.equals("TokenNamepermits")) {
                fName = "TokenNameRestrictedIdentifierpermits";
            }
            this.ttValueToName.put(field.tokenNumber(), fName);
            this.ttNameToValue.put(fName, field);
            ++n2;
        }
        if (this.ttValueToName.size() != this.ttNameToValue.size()) {
            this.ttNameToValue.keySet().removeAll(this.ttValueToName.values());
            PublicScannerTest.fail((String)("TerminalToken constants use already defined values: " + String.valueOf(this.ttNameToValue.keySet())));
        }
        this.tsValueToName = new TreeMap<Integer, String>();
        this.tsNameToValue = new TreeMap<String, Integer>();
        this.tsFields = ITerminalSymbols.class.getFields();
        objectArray = this.tsFields;
        n = this.tsFields.length;
        n2 = 0;
        while (n2 < n) {
            field = objectArray[n2];
            this.tsValueToName.put(field.getInt(null), field.getName());
            this.tsNameToValue.put(field.getName(), field.getInt(null));
            ++n2;
        }
        if (this.tsValueToName.size() != this.tsNameToValue.size()) {
            this.tsNameToValue.keySet().removeAll(this.tsValueToName.values());
            PublicScannerTest.fail((String)("ITerminalSymbols constants use already defined values: " + String.valueOf(this.tsNameToValue.keySet())));
        }
        this.ps = new MyPublicScanner();
    }

    public void testGetNextToken() throws Exception {
        Set<Map.Entry<String, TerminalToken>> entrySet = this.ttNameToValue.entrySet();
        for (Map.Entry<String, TerminalToken> entry : entrySet) {
            this.ps.reset();
            String fieldName = entry.getKey();
            TerminalToken fieldValue = entry.getValue();
            if (MODULE_TOKENS.contains(fieldValue) || fieldValue == TerminalToken.TokenNameInvalid) continue;
            this.ps.setNextToken(fieldValue);
            int nextToken = -1;
            try {
                nextToken = this.ps.getNextToken();
            }
            catch (InvalidInputException e) {
                PublicScannerTest.fail((String)("Scanner.getNextToken() returns token unknown by PublicScanner: " + fieldName));
            }
            if (this.tsNameToValue.containsKey(fieldName)) {
                int actual = ITerminalSymbols.class.getField(fieldName).getInt(null);
                PublicScannerTest.assertEquals((String)("getNextToken() returns value not specified in ITerminalSymbols for token " + fieldName), (int)actual, (int)nextToken);
                PublicScannerTest.assertEquals((int)1, (int)this.ps.nextTokenCalls);
                continue;
            }
            TerminalToken value = TerminalToken.valueOf((String)fieldName);
            if (SYNTHETIC_SKIP_TOKENS.contains(value)) {
                PublicScannerTest.assertEquals((int)2, (int)this.ps.nextTokenCalls);
                continue;
            }
            PublicScannerTest.assertEquals((int)1, (int)this.ps.nextTokenCalls);
            TerminalToken target = SYNTHETIC_REPLACE_TOKENS.get(value);
            if (target == null) {
                PublicScannerTest.fail((String)("TerminalToken." + fieldName + " should be added to ITerminalSymbols or SYNTHETIC_*_TOKENS in PublicScannerTest*!"));
                continue;
            }
            String replaceName = this.ttValueToName.get(target.tokenNumber());
            Integer replaceValue = this.tsNameToValue.get(replaceName);
            PublicScannerTest.assertEquals((String)("getNextToken() returns unexpected value for " + fieldName), (int)nextToken, (int)replaceValue);
        }
    }

    public void testTokensAndSymbolsSync() throws Exception {
        Set<Map.Entry<String, Integer>> entrySet = this.tsNameToValue.entrySet();
        for (Map.Entry<String, Integer> entry : entrySet) {
            String fieldName = entry.getKey();
            if (this.ttNameToValue.containsKey(fieldName)) continue;
            PublicScannerTest.fail((String)("ITerminalSymbols." + fieldName + " does not exist in TerminalToken"));
        }
        Set<Map.Entry<String, TerminalToken>> ttEntrySet = this.ttNameToValue.entrySet();
        for (Map.Entry<String, TerminalToken> entry : ttEntrySet) {
            TerminalToken target;
            TerminalToken value;
            String fieldName = entry.getKey();
            if (this.tsNameToValue.containsKey(fieldName) || SYNTHETIC_SKIP_TOKENS.contains(value = entry.getValue()) || MODULE_TOKENS.contains(value) || (target = SYNTHETIC_REPLACE_TOKENS.get(value)) != null) continue;
            PublicScannerTest.fail((String)("TerminalToken." + fieldName + " should be added to ITerminalSymbols or SYNTHETIC_*_TOKENS in PublicScannerTest*!"));
        }
    }

    public static void main(String[] args) throws Exception {
        PublicScannerTest.printGeneratedSwitchForPublicScanner();
    }

    private static void printGeneratedSwitchForPublicScanner() throws Exception {
        TerminalToken[] ttValues;
        TreeMap<Integer, String> valueToName = new TreeMap<Integer, String>();
        TreeMap<String, Integer> nameToValue = new TreeMap<String, Integer>();
        TerminalToken[] terminalTokenArray = ttValues = TerminalToken.values();
        int n = ttValues.length;
        int n2 = 0;
        while (n2 < n) {
            TerminalToken field = terminalTokenArray[n2];
            valueToName.put(field.tokenNumber(), field.name());
            nameToValue.put(field.name(), field.tokenNumber());
            ++n2;
        }
        Field[] tsFields = ITerminalSymbols.class.getFields();
        Set ttNames = nameToValue.keySet();
        Set tsSet = Arrays.asList(tsFields).stream().map(Field::getName).collect(Collectors.toSet());
        StringBuilder sb = new StringBuilder();
        String ident = "\t\t\t";
        for (String ttName : ttNames) {
            if (tsSet.contains(ttName)) {
                sb.append(ident + "case TerminalToken." + ttName + " : nextToken = ITerminalSymbols." + ttName + "; break;\n");
                continue;
            }
            TerminalToken value = TerminalToken.valueOf((String)ttName);
            if (MODULE_TOKENS.contains(value)) continue;
            if (SYNTHETIC_SKIP_TOKENS.contains(value)) {
                sb.append(ident + "case TerminalToken." + ttName + " : nextToken = getNextToken(); break;\n");
                continue;
            }
            TerminalToken target = SYNTHETIC_REPLACE_TOKENS.get(value);
            if (target == null) {
                sb.append("// TODO: add constant " + ttName + " to ITerminalSymbols or update SYNTHETIC_*_TOKENS in PublicScannerTest!\n");
                sb.append("// case TerminalToken." + ttName + " : nextToken = ITerminalSymbols." + ttName + "; break;\n");
                continue;
            }
            String replaceName = target.name();
            sb.append(ident + "case TerminalToken." + ttName + " : nextToken = ITerminalSymbols." + replaceName + "; break;\n");
        }
        System.out.println(sb);
    }

    class MyPublicScanner
    extends PublicScanner {
        MyScanner delegate;
        int nextTokenCalls;
        boolean inNextCall;

        public MyPublicScanner() {
            super(false, false, false, 0x3D0000L, 0x3D0000L, null, null, true, true, true);
        }

        protected Scanner createScanner(boolean tokenizeComments, boolean tokenizeWhiteSpace, boolean checkNonExternalizedStringLiterals, long sourceLevel, long complianceLevel1, char[][] taskTags, char[][] taskPriorities, boolean isTaskCaseSensitive, boolean isPreviewEnabled) {
            MyScanner myScanner;
            this.delegate = myScanner = new MyScanner(tokenizeComments, tokenizeWhiteSpace, checkNonExternalizedStringLiterals, sourceLevel, complianceLevel1, taskTags, taskPriorities, isTaskCaseSensitive, isPreviewEnabled);
            return myScanner;
        }

        void setNextToken(TerminalToken next) {
            this.delegate.next = next;
        }

        void reset() {
            this.delegate.next = TerminalToken.TokenNameInvalid;
            this.nextTokenCalls = 0;
        }

        public int getNextToken() throws InvalidInputException {
            ++this.nextTokenCalls;
            if (this.inNextCall) {
                return this.delegate.next.tokenNumber();
            }
            this.inNextCall = true;
            try {
                int n = super.getNextToken();
                return n;
            }
            finally {
                this.inNextCall = false;
            }
        }
    }

    class MyScanner
    extends Scanner {
        TerminalToken next;

        public MyScanner(boolean tokenizeComments, boolean tokenizeWhiteSpace, boolean checkNonExternalizedStringLiterals, long sourceLevel, long complianceLevel, char[][] taskTags, char[][] taskPriorities, boolean isTaskCaseSensitive, boolean isPreviewEnabled) {
            super(tokenizeComments, tokenizeWhiteSpace, checkNonExternalizedStringLiterals, sourceLevel, complianceLevel, taskTags, taskPriorities, isTaskCaseSensitive, isPreviewEnabled);
            this.next = TerminalToken.TokenNameInvalid;
        }

        public TerminalToken getNextToken() throws InvalidInputException {
            return this.next;
        }
    }
}

