/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest9;
import org.eclipse.jdt.core.tests.compiler.regression.DefaultJavaRuntimeEnvironment;
import org.eclipse.jdt.core.tests.compiler.regression.InMemoryNameEnvironment9;
import org.eclipse.jdt.internal.compiler.batch.FileSystem;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;

public class RecordPatternProjectTest
extends AbstractRegressionTest9 {
    private static final AbstractRegressionTest.JavacTestOptions JAVAC_OPTIONS = new AbstractRegressionTest.JavacTestOptions("-source 21");
    private String extraLibPath;

    public static Class<?> testClass() {
        return RecordPatternProjectTest.class;
    }

    public static Test suite() {
        return RecordPatternProjectTest.buildMinimalComplianceTestSuite(RecordPatternProjectTest.testClass(), 262144);
    }

    public RecordPatternProjectTest(String testName) {
        super(testName);
    }

    protected Map<String, String> getCompilerOptions(boolean preview) {
        Map<String, String> defaultOptions = super.getCompilerOptions();
        defaultOptions.put("org.eclipse.jdt.core.compiler.compliance", "21");
        defaultOptions.put("org.eclipse.jdt.core.compiler.source", "21");
        defaultOptions.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "21");
        return defaultOptions;
    }

    @Override
    protected Map<String, String> getCompilerOptions() {
        return this.getCompilerOptions(false);
    }

    @Override
    protected String[] getDefaultClassPaths() {
        String[] libs = DefaultJavaRuntimeEnvironment.getDefaultClassPaths();
        if (this.extraLibPath != null) {
            String[] l = new String[libs.length + 1];
            System.arraycopy(libs, 0, l, 0, libs.length);
            l[libs.length] = this.extraLibPath;
            return l;
        }
        return libs;
    }

    @Override
    protected INameEnvironment getNameEnvironment(String[] testFiles, String[] classPaths, Map<String, String> options) {
        INameEnvironment[] classLibs;
        this.classpaths = classPaths == null ? this.getDefaultClassPaths() : classPaths;
        INameEnvironment[] iNameEnvironmentArray = classLibs = this.getClassLibs(false, options);
        int n = classLibs.length;
        int n2 = 0;
        while (n2 < n) {
            INameEnvironment nameEnvironment = iNameEnvironmentArray[n2];
            ((FileSystem)nameEnvironment).scanForModules(this.createParser());
            ++n2;
        }
        return new InMemoryNameEnvironment9(testFiles, this.moduleMap, classLibs);
    }

    @Override
    protected void runConformTest(String[] testFiles, String expectedOutput) {
        this.runConformTest(testFiles, expectedOutput, this.getCompilerOptions(false));
    }

    @Override
    protected void runConformTest(String[] testFiles, String expectedOutput, Map<String, String> customOptions) {
        if (!isJRE21Plus) {
            return;
        }
        this.runConformTest(testFiles, expectedOutput, customOptions, new String[0], JAVAC_OPTIONS);
    }

    @Override
    protected void runConformTest(String[] testFiles, String expectedOutputString, String[] classLibraries, boolean shouldFlushOutputDirectory, String[] vmArguments) {
        this.runTest(shouldFlushOutputDirectory, testFiles, classLibraries, null, false, null, false, null, false, vmArguments, expectedOutputString, null, AbstractRegressionTest.JavacTestOptions.DEFAULT);
    }

    protected void runNegativeTest(String[] testFiles, String expectedCompilerLog, String javacLog, String[] classLibraries, boolean shouldFlushOutputDirectory, Map<String, String> customOptions) {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.testFiles = testFiles;
        runner.expectedCompilerLog = expectedCompilerLog;
        runner.javacTestOptions = JAVAC_OPTIONS;
        runner.customOptions = customOptions;
        runner.expectedJavacOutputString = javacLog;
        runner.runNegativeTest();
    }

    public void testIssue2160() {
        this.runConformTest(new String[]{"bug/Interpreter.java", "package bug;\n\nimport java.util.Optional;\nimport java.util.List;\n\nimport bug.syntax.SyExpressionGetfield;\nimport bug.syntax.SyExpressionValue;\nimport bug.syntax.SyReferenceConstantSymbol;\nimport bug.syntax.SySymbol;\nimport bug.syntax.SySymbolField;\nimport bug.syntax.SyValue;\nimport bug.syntax.SyValueReferenceConstant;\nimport bug.syntax.SyDeclClassLit;\nimport bug.syntax.SyExpressionValue;\nimport bug.syntax.SyIntLit;\nimport bug.syntax.SyPrimitiveConstantInt;\nimport bug.syntax.SyProgramLit;\nimport bug.syntax.SyValuePrimitiveConstant;\n\npublic final class Interpreter {\n\tpublic void step(Configuration J) {\n\t\tvar e = J.syExpression();\n\t\tif (e instanceof SyExpressionGetfield syExpressionGetfield) {\n\t\t\tif (syExpressionGetfield instanceof SyExpressionGetfield(SyExpressionValue(SyValueReferenceConstant(SyReferenceConstantSymbol Y)), String f)) {\n\t\t\t\tfinal Optional<Objekt> maybeo = J.objectAt(Y);\n\t\t\t\tmaybeo.ifPresentOrElse(o -> {\n\t\t\t\t\t//final Optional<SyValue> maybev = o.get(f); //works\n\t\t\t\t\tfinal Optional<SyValue> maybev = o.get(syExpressionGetfield.fieldName()); //does not work\n\t\t\t\t\tmaybev.ifPresentOrElse(v -> {\n\t\t\t\t\t\tfreshSymbol(Y.sySymbol(), f);\n\t\t\t\t\t}, () -> {});\n\t\t\t\t}, () -> {});\n\t\t\t}\n\t\t}\n\t}\n\n\tprivate SySymbolField freshSymbol(SySymbol sySymbol, String fieldName) {\n\t\treturn null;\n\t}\n\n\tpublic static void main(String [] args) {\n\t\tvar C1 = new SyDeclClassLit(\"Object\", \"\", List.of(), List.of());\n\t\tvar e = new SyExpressionValue(new SyValuePrimitiveConstant(new SyPrimitiveConstantInt(new SyIntLit(0))));\n\t\tvar p = new SyProgramLit(List.of(C1), e);\n\t\tvar J = new Configuration(p);\n\t\tvar I = new Interpreter();\n\t\tI.step(J);\n\t\tSystem.out.println(\"Finished!\");\n\t}\n}\n", "bug/Configuration.java", "package bug;\n\nimport java.util.ArrayList;\nimport java.util.Collections;\nimport java.util.LinkedHashMap;\nimport java.util.List;\nimport java.util.Objects;\nimport java.util.Optional;\n\nimport bug.syntax.SyExpression;\nimport bug.syntax.SyLocLit;\nimport bug.syntax.SyProgram;\nimport bug.syntax.SyProgramLit;\nimport bug.syntax.SyReferenceConstant;\nimport bug.syntax.SyReferenceConstantLoc;\nimport bug.syntax.SyReferenceConstantSymbol;\nimport bug.syntax.SySymbol;\nimport bug.syntax.SyValue;\nimport bug.syntax.SyValueEq;\nimport bug.syntax.SyValueIte;\nimport bug.syntax.SyValueReferenceConstant;\nimport bug.syntax.SyValueUnassumed;\n\npublic final class Configuration {\n\tprivate final SyProgramLit syProgramLit;\n\tprivate final LinkedHashMap<SyReferenceConstant, Objekt> heap;\n\tprivate final ArrayList<SyValue> pathCondition;\n\tprivate SyExpression syExpression;\n\tprivate int nextLocId = 0;\n\n\tpublic Configuration(SyProgram syProgram) {\n\t\tswitch (syProgram) {\n\t\t\tcase SyProgramLit syProgramLit:\n\t\t\t\tthis.syProgramLit = syProgramLit;\n\t\t\t\tbreak;\n\t\t\tdefault: throw new AssertionError();\n\t\t}\n\t\tthis.heap = new LinkedHashMap<>();\n\t\tthis.pathCondition = new ArrayList<>();\n\t\tthis.syExpression = this.syProgramLit.syExpression();\n\t}\n\n\tpublic Configuration(Configuration other) {\n\t\tthis.syProgramLit = other.syProgramLit;\n\t\tthis.heap = new LinkedHashMap<>();\n\t\tfor (var e : other.heap.sequencedEntrySet()) {\n\t\t\tthis.heap.put(e.getKey(), new Objekt(e.getValue()));\n\t\t}\n\t\tthis.pathCondition = new ArrayList<>(other.pathCondition);\n\t\tthis.syExpression = other.syExpression;\n\t}\n\n\tpublic Optional<Objekt> objectAt(SyReferenceConstant syReferenceConstant) {\n\t\tObjects.requireNonNull(syReferenceConstant);\n\n\t\treturn Optional.ofNullable(this.heap.get(syReferenceConstant));\n\t}\n\n\tpublic SyReferenceConstantLoc addObjectConcrete(Objekt semObject) {\n\t\tObjects.requireNonNull(semObject);\n\n\t\tvar nextLoc = new SyReferenceConstantLoc(new SyLocLit(this.nextLocId++));\n\t\tthis.heap.put(nextLoc, semObject);\n\t\treturn nextLoc;\n\t}\n\n\tpublic void addObjectSymbolic(SySymbol sySymbol, Objekt semObject) {\n\t\tObjects.requireNonNull(sySymbol);\n\t\tObjects.requireNonNull(semObject);\n\n\t\tthis.heap.put(new SyReferenceConstantSymbol(sySymbol), semObject);\n\t}\n\n\tpublic SyProgramLit syProgramLit() {\n\t\treturn this.syProgramLit;\n\t}\n\n\tpublic SyExpression syExpression() {\n\t\treturn this.syExpression;\n\t}\n\n\n\tpublic void setSyExpression(SyExpression syExpression) {\n\t\tObjects.requireNonNull(syExpression);\n\n\t\tthis.syExpression = syExpression;\n\t}\n\n\n\tpublic List<SyValue> pathCondition() {\n\t\treturn Collections.unmodifiableList(this.pathCondition);\n\t}\n\n\tpublic boolean unresolved(SySymbol sySymbol) {\n\t\tObjects.requireNonNull(sySymbol);\n\n\t\treturn !this.heap.containsKey(new SyReferenceConstantSymbol(sySymbol));\n\t}\n\n\tpublic void addPathConditionClause(SyValue syValue) {\n\t\tObjects.requireNonNull(syValue);\n\n\t\tthis.pathCondition.add(syValue);\n\t}\n\n\tpublic SyValue assume(SySymbol accessor, String fieldName, SyValue fresh) {\n\t\tObjects.requireNonNull(accessor);\n\t\tObjects.requireNonNull(fieldName);\n\t\tObjects.requireNonNull(fresh);\n\n\t\tSyValue retVal = fresh;\n\t\tfor (var e : this.heap.sequencedEntrySet()) {\n\t\t\tif (e.getKey() instanceof SyReferenceConstantSymbol syReferenceConstantSymbol &&\n\t\t\t    !accessor.equals(syReferenceConstantSymbol.sySymbol())) {\n\t\t\t\tvar o = e.getValue();\n\t\t\t\tvar v = o.get(fieldName);\n\t\t\t\tif (v.isPresent() && !(v.get() instanceof SyValueUnassumed)) {\n\t\t\t\t\tretVal = new SyValueIte(new SyValueEq(new SyValueReferenceConstant(new SyReferenceConstantSymbol(accessor)), new SyValueReferenceConstant(syReferenceConstantSymbol)), v.get(), retVal);\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t\treturn retVal;\n\t}\n}\n", "bug/Objekt.java", "package bug;\n\nimport java.util.LinkedHashMap;\nimport java.util.Objects;\nimport java.util.Optional;\n\nimport bug.syntax.SyDeclClass;\nimport bug.syntax.SyDeclClassLit;\nimport bug.syntax.SyDeclVariable;\nimport bug.syntax.SyDeclVariableLit;\nimport bug.syntax.SyProgram;\nimport bug.syntax.SyProgramLit;\nimport bug.syntax.SyValue;\nimport bug.syntax.SyValueUnassumed;\n\npublic final class Objekt {\n\tprivate final SyProgramLit syProgramLit;\n\tprivate final LinkedHashMap<String, SyValue> memory;\n\tprivate String className;\n\n\tpublic Objekt(SyProgram syProgram, String className, boolean symbolic) {\n\t\tObjects.requireNonNull(syProgram);\n\t\tObjects.requireNonNull(className);\n\n\t\tswitch (syProgram) {\n\t\tcase SyProgramLit syProgramLit:\n\t\t\tthis.syProgramLit = syProgramLit;\n\t\t\tvar syDeclClassOptional = syProgramLit.cdecl(className);\n\t\t\tvar fields = syDeclClassOptional.map(c -> {\n\t\t\t\tswitch (c) {\n\t\t\t\tcase SyDeclClassLit syDeclClassLit:\n\t\t\t\t\treturn syDeclClassLit.fields();\n\t\t\t\tdefault: throw new AssertionError();\n\t\t\t\t}\n\t\t\t}).orElseThrow(() -> { throw new RuntimeException(\"Class \" + className + \" does not exist.\"); });\n\t\t\tthis.memory = new LinkedHashMap<>();\n\t\t\tthis.className = className;\n\t\t\tfor (SyDeclVariable syDeclVariable : fields) {\n\t\t\t\tswitch (syDeclVariable) {\n\t\t\t\tcase SyDeclVariableLit syDeclVariableLit:\n\t\t\t\t\tthis.memory.put(syDeclVariableLit.variableName(), (symbolic ? new SyValueUnassumed() : syDeclVariableLit.syType().ini()));\n\t\t\t\t\tbreak;\n\t\t\t\tdefault: throw new AssertionError();\n\t\t\t\t}\n\t\t\t}\n\t\t\tbreak;\n\t\tdefault: throw new AssertionError();\n\t\t}\n\t}\n\n\tpublic Objekt(Objekt other) {\n\t\tthis.syProgramLit = other.syProgramLit;\n\t\tthis.memory = new LinkedHashMap<>(other.memory);\n\t\tthis.className = other.className;\n\t}\n\n\tpublic Optional<SyValue> get(String fieldName) {\n\t\tObjects.requireNonNull(fieldName);\n\n\t\treturn Optional.ofNullable(this.memory.get(fieldName));\n\t}\n\n\tpublic void upd(String fieldName, SyValue syValue) {\n\t\tObjects.requireNonNull(fieldName);\n\t\tObjects.requireNonNull(syValue);\n\n\t\tif (this.memory.containsKey(fieldName)) {\n\t\t\tthis.memory.put(fieldName, syValue);\n\t\t} else {\n\t\t\tthrow new RuntimeException(\"Tried to modify nonexistent field \" + fieldName);\n\t\t}\n\t}\n\n\tpublic void refine(String subclassName) {\n\t\tObjects.requireNonNull(subclassName);\n\n\t\tfor (SyDeclClass syDeclClass : this.syProgramLit.classes()) {\n\t\t\tswitch (syDeclClass) {\n\t\t\tcase SyDeclClassLit syDeclClassLit:\n\t\t\t\tif (this.syProgramLit.isSubclass(syDeclClassLit.className(), this.className) &&\n\t\t\t\t    this.syProgramLit.isSubclass(subclassName, syDeclClassLit.className()) &&\n\t\t\t\t    !this.className.equals(syDeclClassLit.className())) {\n\t\t\t\t\tfor (SyDeclVariable syDeclVariable : syDeclClassLit.fields()) {\n\t\t\t\t\t\tswitch (syDeclVariable) {\n\t\t\t\t\t\tcase SyDeclVariableLit syDeclVariableLit:\n\t\t\t\t\t\t\tthis.memory.put(syDeclVariableLit.variableName(), new SyValueUnassumed());\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\tdefault: throw new AssertionError();\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\tdefault: throw new AssertionError();\n\t\t\t}\n\t\t}\n\t}\n}\n", "bug/syntax/SyBoolFalse.java", "package bug.syntax;\n\npublic record SyBoolFalse() implements SyBool {\n\n}\n", "bug/syntax/SyBool.java", "package bug.syntax;\n\npublic sealed interface SyBool permits SyBoolTrue, SyBoolFalse {\n\n}\n", "bug/syntax/SyBoolTrue.java", "package bug.syntax;\n\npublic record SyBoolTrue() implements SyBool {\n\n}\n", "bug/syntax/SyDeclClass.java", "package bug.syntax;\n\npublic sealed interface SyDeclClass permits SyDeclClassLit {\n\n}\n", "bug/syntax/SyDeclClassLit.java", "package bug.syntax;\n\nimport java.util.List;\nimport java.util.Objects;\nimport java.util.Optional;\n\npublic record SyDeclClassLit(String className, String superclassName, List<SyDeclVariable> fields, List<SyDeclMethod> methods) implements SyDeclClass {\n\tpublic SyDeclClassLit {\n\t\tObjects.requireNonNull(className);\n\t\tObjects.requireNonNull(superclassName);\n\t\tObjects.requireNonNull(fields);\n\t\tObjects.requireNonNull(methods);\n\t\tfor (SyDeclVariable field : fields) {\n\t\t\tObjects.requireNonNull(field);\n\t\t}\n\t\tfor (SyDeclMethod method : methods) {\n\t\t\tObjects.requireNonNull(method);\n\t\t}\n\t}\n\n\tpublic boolean hasField(String possibleFieldName) {\n\t\tObjects.requireNonNull(possibleFieldName);\n\n\t\tfor (SyDeclVariable field : this.fields) {\n\t\t\tswitch (field) {\n\t\t\tcase SyDeclVariableLit syDeclVariableLit:\n\t\t\t\tif (possibleFieldName.equals(syDeclVariableLit.variableName())) {\n\t\t\t\t\treturn true;\n\t\t\t\t}\n\t\t\t\tbreak;\n\t\t\tdefault: throw new AssertionError();\n\t\t\t}\n\t\t}\n\t\treturn false;\n\t}\n\n\tpublic boolean hasMethod(String possibleMethodName) {\n\t\tObjects.requireNonNull(possibleMethodName);\n\n\t\tfor (SyDeclMethod method : this.methods) {\n\t\t\tswitch (method) {\n\t\t\tcase SyDeclMethodLit syDeclMethodLit:\n\t\t\t\tif (possibleMethodName.equals(syDeclMethodLit.methodName())) {\n\t\t\t\t\treturn true;\n\t\t\t\t}\n\t\t\t\tbreak;\n\t\t\tdefault: throw new AssertionError();\n\t\t\t}\n\t\t}\n\t\treturn false;\n\t}\n\n\tpublic Optional<SyDeclVariable> fdecl(String possibleFieldName) {\n\t\tObjects.requireNonNull(possibleFieldName);\n\n\t\tfor (SyDeclVariable field : this.fields) {\n\t\t\tswitch (field) {\n\t\t\tcase SyDeclVariableLit syDeclVariableLit:\n\t\t\t\tif (possibleFieldName.equals(syDeclVariableLit.variableName())) {\n\t\t\t\t\treturn Optional.of(syDeclVariableLit);\n\t\t\t\t}\n\t\t\t\tbreak;\n\t\t\tdefault: throw new AssertionError();\n\t\t\t}\n\t\t}\n\t\treturn Optional.empty();\n\t}\n\n\tpublic Optional<SyDeclMethod> mdecl(String possibleMethodName) {\n\t\tObjects.requireNonNull(possibleMethodName);\n\n\t\tfor (SyDeclMethod method : this.methods) {\n\t\t\tswitch (method) {\n\t\t\tcase SyDeclMethodLit syDeclMethodLit:\n\t\t\t\tif (possibleMethodName.equals(syDeclMethodLit.methodName())) {\n\t\t\t\t\treturn Optional.of(syDeclMethodLit);\n\t\t\t\t}\n\t\t\t\tbreak;\n\t\t\tdefault: throw new AssertionError();\n\t\t\t}\n\t\t}\n\t\treturn Optional.empty();\n\t}\n}\n", "bug/syntax/SyDeclMethod.java", "package bug.syntax;\n\npublic sealed interface SyDeclMethod permits SyDeclMethodLit {\n\n}\n", "bug/syntax/SyDeclMethodLit.java", "package bug.syntax;\n\nimport java.util.Objects;\n\npublic record SyDeclMethodLit(SyType syType, String methodName, SyDeclVariable syDeclVariable, SyExpression syExpression) implements SyDeclMethod {\n\tpublic SyDeclMethodLit {\n\t\tObjects.requireNonNull(syType);\n\t\tObjects.requireNonNull(methodName);\n\t\tObjects.requireNonNull(syDeclVariable);\n\t\tObjects.requireNonNull(syExpression);\n\t}\n}\n", "bug/syntax/SyDeclVariable.java", "package bug.syntax;\n\npublic sealed interface SyDeclVariable permits SyDeclVariableLit {\n\n}\n", "bug/syntax/SyDeclVariableLit.java", "package bug.syntax;\n\nimport java.util.Objects;\n\npublic record SyDeclVariableLit(SyType syType, String variableName) implements SyDeclVariable {\n\tpublic SyDeclVariableLit {\n\t\tObjects.requireNonNull(syType);\n\t\tObjects.requireNonNull(variableName);\n\t}\n}\n", "bug/syntax/SyExpressionAdd.java", "package bug.syntax;\n\nimport java.util.Objects;\n\npublic record SyExpressionAdd(SyExpression syExpressionFirst, SyExpression syExpressionSecond) implements SyExpression {\n\tpublic SyExpressionAdd {\n\t\tObjects.requireNonNull(syExpressionFirst);\n\t\tObjects.requireNonNull(syExpressionSecond);\n\t}\n\n\t@Override\n\tpublic SyExpressionAdd replace(String variableName, SyExpression syExpression) {\n\t\tObjects.requireNonNull(variableName);\n\t\tObjects.requireNonNull(syExpression);\n\n\t\tvar syExpressionFirstNew = this.syExpressionFirst.replace(variableName, syExpression);\n\t\tvar syExpressionSecondNew = this.syExpressionSecond.replace(variableName, syExpression);\n\t\treturn new SyExpressionAdd(syExpressionFirstNew, syExpressionSecondNew);\n\t}\n}\n", "bug/syntax/SyExpressionAnd.java", "package bug.syntax;\n\nimport java.util.Objects;\n\npublic record SyExpressionAnd(SyExpression syExpressionFirst, SyExpression syExpressionSecond) implements SyExpression {\n\tpublic SyExpressionAnd {\n\t\tObjects.requireNonNull(syExpressionFirst);\n\t\tObjects.requireNonNull(syExpressionSecond);\n\t}\n\n\t@Override\n\tpublic SyExpressionAnd replace(String variableName, SyExpression syExpression) {\n\t\tObjects.requireNonNull(variableName);\n\t\tObjects.requireNonNull(syExpression);\n\n\t\tvar syExpressionFirstNew = this.syExpressionFirst.replace(variableName, syExpression);\n\t\tvar syExpressionSecondNew = this.syExpressionSecond.replace(variableName, syExpression);\n\t\treturn new SyExpressionAnd(syExpressionFirstNew, syExpressionSecondNew);\n\t}\n}\n", "bug/syntax/SyExpressionEq.java", "package bug.syntax;\n\nimport java.util.Objects;\n\npublic record SyExpressionEq(SyExpression syExpressionFirst, SyExpression syExpressionSecond) implements SyExpression {\n\tpublic SyExpressionEq {\n\t\tObjects.requireNonNull(syExpressionFirst);\n\t\tObjects.requireNonNull(syExpressionSecond);\n\t}\n\n\t@Override\n\tpublic SyExpressionEq replace(String variableName, SyExpression syExpression) {\n\t\tObjects.requireNonNull(variableName);\n\t\tObjects.requireNonNull(syExpression);\n\n\t\tvar syExpressionFirstNew = this.syExpressionFirst.replace(variableName, syExpression);\n\t\tvar syExpressionSecondNew = this.syExpressionSecond.replace(variableName, syExpression);\n\t\treturn new SyExpressionEq(syExpressionFirstNew, syExpressionSecondNew);\n\t}\n}\n", "bug/syntax/SyExpressionGetfield.java", "package bug.syntax;\n\nimport java.util.Objects;\n\npublic record SyExpressionGetfield(SyExpression syExpression, String fieldName) implements SyExpression {\n\tpublic SyExpressionGetfield {\n\t\tObjects.requireNonNull(syExpression);\n\t\tObjects.requireNonNull(fieldName);\n\t}\n\n\t@Override\n\tpublic SyExpressionGetfield replace(String variableName, SyExpression syExpression) {\n\t\tObjects.requireNonNull(variableName);\n\t\tObjects.requireNonNull(syExpression);\n\n\t\tvar syExpressionNew = this.syExpression.replace(variableName, syExpression);\n\t\treturn new SyExpressionGetfield(syExpressionNew, this.fieldName);\n\t}\n}\n", "bug/syntax/SyExpressionIf.java", "package bug.syntax;\n\nimport java.util.Objects;\n\npublic record SyExpressionIf(SyExpression syExpressionCond, SyExpression syExpressionThen, SyExpression syExpressionElse) implements SyExpression {\n\tpublic SyExpressionIf {\n\t\tObjects.requireNonNull(syExpressionCond);\n\t\tObjects.requireNonNull(syExpressionThen);\n\t\tObjects.requireNonNull(syExpressionElse);\n\t}\n\n\t@Override\n\tpublic SyExpressionIf replace(String variableName, SyExpression syExpression) {\n\t\tObjects.requireNonNull(variableName);\n\t\tObjects.requireNonNull(syExpression);\n\n\t\tvar syExpressionCondNew = this.syExpressionCond.replace(variableName, syExpression);\n\t\tvar syExpressionThenNew = this.syExpressionThen.replace(variableName, syExpression);\n\t\tvar syExpressionElseNew = this.syExpressionElse.replace(variableName, syExpression);\n\t\treturn new SyExpressionIf(syExpressionCondNew, syExpressionThenNew, syExpressionElseNew);\n\t}\n}\n", "bug/syntax/SyExpressionInstanceof.java", "package bug.syntax;\n\nimport java.util.Objects;\n\npublic record SyExpressionInstanceof(SyExpression syExpression, String className) implements SyExpression {\n\tpublic SyExpressionInstanceof {\n\t\tObjects.requireNonNull(syExpression);\n\t\tObjects.requireNonNull(className);\n\t}\n\n\t@Override\n\tpublic SyExpressionInstanceof replace(String variableName, SyExpression syExpression) {\n\t\tObjects.requireNonNull(variableName);\n\t\tObjects.requireNonNull(syExpression);\n\n\t\tvar syExpressionNew = this.syExpression.replace(variableName, syExpression);\n\t\treturn new SyExpressionInstanceof(syExpressionNew, this.className);\n\t}\n}\n", "bug/syntax/SyExpressionInvoke.java", "package bug.syntax;\n\nimport java.util.Objects;\n\npublic record SyExpressionInvoke(SyExpression syExpressionFirst, String methodName, SyExpression syExpressionSecond) implements SyExpression {\n\tpublic SyExpressionInvoke {\n\t\tObjects.requireNonNull(syExpressionFirst);\n\t\tObjects.requireNonNull(methodName);\n\t\tObjects.requireNonNull(syExpressionSecond);\n\t}\n\n\t@Override\n\tpublic SyExpressionInvoke replace(String variableName, SyExpression syExpression) {\n\t\tObjects.requireNonNull(variableName);\n\t\tObjects.requireNonNull(syExpression);\n\n\t\tvar syExpressionFirstNew = this.syExpressionFirst.replace(variableName, syExpression);\n\t\tvar syExpressionSecondNew = this.syExpressionSecond.replace(variableName, syExpression);\n\t\treturn new SyExpressionInvoke(syExpressionFirstNew, this.methodName, syExpressionSecondNew);\n\t}\n}\n", "bug/syntax/SyExpression.java", "package bug.syntax;\n\npublic sealed interface SyExpression permits SyExpressionVariable, SyExpressionValue, SyExpressionNew,\nSyExpressionGetfield, SyExpressionPutfield, SyExpressionLet, SyExpressionAdd, SyExpressionSub, SyExpressionLt,\nSyExpressionAnd, SyExpressionOr, SyExpressionNot, SyExpressionEq, SyExpressionInstanceof, SyExpressionIf,\nSyExpressionInvoke {\n\tpublic SyExpression replace(String variableName, SyExpression syExpression);\n}\n", "bug/syntax/SyExpressionLet.java", "package bug.syntax;\n\nimport java.util.Objects;\n\npublic record SyExpressionLet(String variableName, SyExpression syExpressionFirst, SyExpression syExpressionSecond) implements SyExpression {\n\tpublic SyExpressionLet {\n\t\tObjects.requireNonNull(variableName);\n\t\tObjects.requireNonNull(syExpressionFirst);\n\t\tObjects.requireNonNull(syExpressionSecond);\n\t}\n\n\t@Override\n\tpublic SyExpressionLet replace(String variableName, SyExpression syExpression) {\n\t\tObjects.requireNonNull(variableName);\n\t\tObjects.requireNonNull(syExpression);\n\n\t\tif (this.variableName.equals(variableName)) {\n\t\t\treturn this;\n\t\t} else {\n\t\t\tvar syExpressionFirstNew = this.syExpressionFirst.replace(variableName, syExpression);\n\t\t\tvar syExpressionSecondNew = this.syExpressionSecond.replace(variableName, syExpression);\n\t\t\treturn new SyExpressionLet(this.variableName, syExpressionFirstNew, syExpressionSecondNew);\n\t\t}\n\t}\n}\n", "bug/syntax/SyExpressionLt.java", "package bug.syntax;\n\nimport java.util.Objects;\n\npublic record SyExpressionLt(SyExpression syExpressionFirst, SyExpression syExpressionSecond) implements SyExpression {\n\tpublic SyExpressionLt {\n\t\tObjects.requireNonNull(syExpressionFirst);\n\t\tObjects.requireNonNull(syExpressionSecond);\n\t}\n\n\t@Override\n\tpublic SyExpressionLt replace(String variableName, SyExpression syExpression) {\n\t\tObjects.requireNonNull(variableName);\n\t\tObjects.requireNonNull(syExpression);\n\n\t\tvar syExpressionFirstNew = this.syExpressionFirst.replace(variableName, syExpression);\n\t\tvar syExpressionSecondNew = this.syExpressionSecond.replace(variableName, syExpression);\n\t\treturn new SyExpressionLt(syExpressionFirstNew, syExpressionSecondNew);\n\t}\n}\n", "bug/syntax/SyExpressionNew.java", "package bug.syntax;\n\nimport java.util.Objects;\n\npublic record SyExpressionNew(String className) implements SyExpression {\n\tpublic SyExpressionNew {\n\t\tObjects.requireNonNull(className);\n\t}\n\n\t@Override\n\tpublic SyExpressionNew replace(String variableName, SyExpression syExpression) {\n\t\tObjects.requireNonNull(variableName);\n\t\tObjects.requireNonNull(syExpression);\n\n\t\treturn this;\n\t}\n}\n", "bug/syntax/SyExpressionNot.java", "package bug.syntax;\n\nimport java.util.Objects;\n\npublic record SyExpressionNot(SyExpression syExpression) implements SyExpression {\n\tpublic SyExpressionNot {\n\t\tObjects.requireNonNull(syExpression);\n\t}\n\n\t@Override\n\tpublic SyExpressionNot replace(String variableName, SyExpression syExpression) {\n\t\tObjects.requireNonNull(variableName);\n\t\tObjects.requireNonNull(syExpression);\n\n\t\tvar syExpressionNew = this.syExpression.replace(variableName, syExpression);\n\t\treturn new SyExpressionNot(syExpressionNew);\n\t}\n}\n", "bug/syntax/SyExpressionOr.java", "package bug.syntax;\n\nimport java.util.Objects;\n\npublic record SyExpressionOr(SyExpression syExpressionFirst, SyExpression syExpressionSecond) implements SyExpression {\n\tpublic SyExpressionOr {\n\t\tObjects.requireNonNull(syExpressionFirst);\n\t\tObjects.requireNonNull(syExpressionSecond);\n\t}\n\n\t@Override\n\tpublic SyExpressionOr replace(String variableName, SyExpression syExpression) {\n\t\tObjects.requireNonNull(variableName);\n\t\tObjects.requireNonNull(syExpression);\n\n\t\tvar syExpressionFirstNew = this.syExpressionFirst.replace(variableName, syExpression);\n\t\tvar syExpressionSecondNew = this.syExpressionSecond.replace(variableName, syExpression);\n\t\treturn new SyExpressionOr(syExpressionFirstNew, syExpressionSecondNew);\n\t}\n}\n", "bug/syntax/SyExpressionPutfield.java", "package bug.syntax;\n\nimport java.util.Objects;\n\npublic record SyExpressionPutfield(SyExpression syExpressionFirst, String fieldName, SyExpression syExpressionSecond) implements SyExpression {\n\tpublic SyExpressionPutfield {\n\t\tObjects.requireNonNull(syExpressionFirst);\n\t\tObjects.requireNonNull(fieldName);\n\t\tObjects.requireNonNull(syExpressionSecond);\n\t}\n\n\t@Override\n\tpublic SyExpressionPutfield replace(String variableName, SyExpression syExpression) {\n\t\tObjects.requireNonNull(variableName);\n\t\tObjects.requireNonNull(syExpression);\n\n\t\tvar syExpressionFirstNew = this.syExpressionFirst.replace(variableName, syExpression);\n\t\tvar syExpressionSecondNew = this.syExpressionSecond.replace(variableName, syExpression);\n\t\treturn new SyExpressionPutfield(syExpressionFirstNew, this.fieldName, syExpressionSecondNew);\n\t}\n}\n", "bug/syntax/SyExpressionSub.java", "package bug.syntax;\n\nimport java.util.Objects;\n\npublic record SyExpressionSub(SyExpression syExpressionFirst, SyExpression syExpressionSecond) implements SyExpression {\n\tpublic SyExpressionSub {\n\t\tObjects.requireNonNull(syExpressionFirst);\n\t\tObjects.requireNonNull(syExpressionSecond);\n\t}\n\n\t@Override\n\tpublic SyExpressionSub replace(String variableName, SyExpression syExpression) {\n\t\tObjects.requireNonNull(variableName);\n\t\tObjects.requireNonNull(syExpression);\n\n\t\tvar syExpressionFirstNew = this.syExpressionFirst.replace(variableName, syExpression);\n\t\tvar syExpressionSecondNew = this.syExpressionSecond.replace(variableName, syExpression);\n\t\treturn new SyExpressionSub(syExpressionFirstNew, syExpressionSecondNew);\n\t}\n}\n", "bug/syntax/SyExpressionValue.java", "package bug.syntax;\n\nimport java.util.Objects;\n\npublic record SyExpressionValue(SyValue syValue) implements SyExpression {\n\tpublic SyExpressionValue {\n\t\tObjects.requireNonNull(syValue);\n\t}\n\n\t@Override\n\tpublic SyExpressionValue replace(String variableName, SyExpression syExpression) {\n\t\tObjects.requireNonNull(variableName);\n\t\tObjects.requireNonNull(syExpression);\n\n\t\treturn this;\n\t}\n}\n", "bug/syntax/SyExpressionVariable.java", "package bug.syntax;\n\nimport java.util.Objects;\n\npublic record SyExpressionVariable(String variableName) implements SyExpression {\n\tpublic SyExpressionVariable {\n\t\tObjects.requireNonNull(variableName);\n\t}\n\n\t@Override\n\tpublic SyExpression replace(String variableName, SyExpression syExpression) {\n\t\tObjects.requireNonNull(variableName);\n\t\tObjects.requireNonNull(syExpression);\n\n\t\tif (this.variableName.equals(variableName)) {\n\t\t\treturn syExpression;\n\t\t} else {\n\t\t\treturn this;\n\t\t}\n\t}\n}\n", "bug/syntax/SyInt.java", "package bug.syntax;\n\npublic sealed interface SyInt permits SyIntLit {\n\n}\n", "bug/syntax/SyIntLit.java", "package bug.syntax;\n\npublic record SyIntLit(int value) implements SyInt {\n\n}\n", "bug/syntax/SyLoc.java", "package bug.syntax;\n\npublic sealed interface SyLoc permits SyLocLit {\n\n}\n", "bug/syntax/SyLocLit.java", "package bug.syntax;\n\npublic record SyLocLit(int position) implements SyLoc {\n\n}\n", "bug/syntax/SyPrimitiveConstantBool.java", "package bug.syntax;\n\nimport java.util.Objects;\n\npublic record SyPrimitiveConstantBool(SyBool syBool) implements SyPrimitiveConstant {\n\tpublic SyPrimitiveConstantBool {\n\t\tObjects.requireNonNull(syBool);\n\t}\n}\n", "bug/syntax/SyPrimitiveConstantInt.java", "package bug.syntax;\n\nimport java.util.Objects;\n\npublic record SyPrimitiveConstantInt(SyInt syInt) implements SyPrimitiveConstant {\n\tpublic SyPrimitiveConstantInt {\n\t\tObjects.requireNonNull(syInt);\n\t}\n}\n", "bug/syntax/SyPrimitiveConstant.java", "package bug.syntax;\n\npublic sealed interface SyPrimitiveConstant permits SyPrimitiveConstantBool, SyPrimitiveConstantInt, SyPrimitiveConstantSymbol{\n\n}\n", "bug/syntax/SyPrimitiveConstantSymbol.java", "package bug.syntax;\n\nimport java.util.Objects;\n\npublic record SyPrimitiveConstantSymbol(SySymbol sySymbol) implements SyPrimitiveConstant {\n\tpublic SyPrimitiveConstantSymbol {\n\t\tObjects.requireNonNull(sySymbol);\n\t}\n}\n", "bug/syntax/SyProgram.java", "package bug.syntax;\n\npublic sealed interface SyProgram permits SyProgramLit {\n\n}\n", "bug/syntax/SyProgramLit.java", "package bug.syntax;\n\nimport java.lang.AssertionError;\nimport java.util.LinkedHashSet;\nimport java.util.List;\nimport java.util.Objects;\nimport java.util.Optional;\nimport java.util.Set;\n\npublic record SyProgramLit(List<SyDeclClass> classes, SyExpression syExpression) implements SyProgram {\n\tpublic SyProgramLit {\n\t\tObjects.requireNonNull(classes);\n\t\tObjects.requireNonNull(syExpression);\n\t\tfor (SyDeclClass syDeclClass : classes) {\n\t\t\tObjects.requireNonNull(syDeclClass);\n\t\t}\n\t}\n\n\tpublic boolean isSubclass(String possibleSubclassName, String possibleSuperclassName) {\n\t\tObjects.requireNonNull(possibleSubclassName);\n\t\tObjects.requireNonNull(possibleSuperclassName);\n\n\t\tfor (SyDeclClass syDeclClass : this.classes) {\n\t\t\tswitch (syDeclClass) {\n\t\t\tcase SyDeclClassLit syDeclClassLit:\n\t\t\t\tif (possibleSubclassName.equals(syDeclClassLit.className())) {\n\t\t\t\t\tif (possibleSuperclassName.equals(syDeclClassLit.superclassName())) {\n\t\t\t\t\t\treturn true;\n\t\t\t\t\t} else {\n\t\t\t\t\t\treturn isSubclass(syDeclClassLit.superclassName(), possibleSuperclassName);\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\tbreak;\n\t\t\tdefault: throw new AssertionError();\n\t\t\t}\n\t\t}\n\t\treturn false;\n\t}\n\n\tpublic boolean hasClass(String possibleClassName) {\n\t\tObjects.requireNonNull(possibleClassName);\n\n\t\tfor (SyDeclClass syDeclClass : this.classes) {\n\t\t\tswitch (syDeclClass) {\n\t\t\tcase SyDeclClassLit syDeclClassLit:\n\t\t\t\tif (possibleClassName.equals(syDeclClassLit.className())) {\n\t\t\t\t\treturn true;\n\t\t\t\t}\n\t\t\t\tbreak;\n\t\t\tdefault: throw new AssertionError();\n\t\t\t}\n\t\t}\n\t\treturn false;\n\t}\n\n\tpublic Optional<SyDeclClass> cdecl(String possibleClassName) {\n\t\tObjects.requireNonNull(possibleClassName);\n\n\t\tfor (SyDeclClass syDeclClass : this.classes) {\n\t\t\tswitch (syDeclClass) {\n\t\t\tcase SyDeclClassLit syDeclClassLit:\n\t\t\t\tif (possibleClassName.equals(syDeclClassLit.className())) {\n\t\t\t\t\treturn Optional.of(syDeclClassLit);\n\t\t\t\t}\n\t\t\t\tbreak;\n\t\t\tdefault: throw new AssertionError();\n\t\t\t}\n\t\t}\n\t\treturn Optional.empty();\n\t}\n\n\tpublic boolean seesMethod(String possibleMethodName, String possibleSubclassName, String possibleSuperclassName) {\n\t\tObjects.requireNonNull(possibleMethodName);\n\t\tObjects.requireNonNull(possibleSubclassName);\n\t\tObjects.requireNonNull(possibleSuperclassName);\n\n\t\treturn isSubclass(possibleSubclassName, possibleSuperclassName) &&\n\t\t       cdecl(possibleSuperclassName).map(c -> {\n\t\t\t\t\tswitch (c) {\n\t\t\t\t\tcase SyDeclClassLit syDeclClassLit:\n\t\t\t\t\t\treturn syDeclClassLit.hasMethod(possibleMethodName);\n\t\t\t\t\tdefault: throw new AssertionError();\n\t\t\t\t\t}\n\t\t       }).orElse(false) &&\n\t\t       this.classes.stream().allMatch(c -> {\n\t\t\t\t\tswitch (c) {\n\t\t\t\t\tcase SyDeclClassLit syDeclClassLit:\n\t\t\t\t\t\treturn possibleSubclassName.equals(syDeclClassLit.className()) ||\n\t\t\t\t\t\t       possibleSuperclassName.equals(syDeclClassLit.className()) ||\n\t\t\t\t\t\t       !isSubclass(syDeclClassLit.className(), possibleSuperclassName) ||\n\t\t\t\t\t\t       !isSubclass(possibleSubclassName, syDeclClassLit.className()) ||\n\t\t\t\t\t\t       !syDeclClassLit.hasMethod(possibleMethodName);\n\t\t\t\t\tdefault: throw new AssertionError();\n\t\t\t\t\t}\n\t\t       });\n\t}\n\n\tpublic boolean recvMethod(String possibleMethodName, String possibleSubclassName, String possibleSuperclassName) {\n\t\tObjects.requireNonNull(possibleMethodName);\n\t\tObjects.requireNonNull(possibleSubclassName);\n\t\tObjects.requireNonNull(possibleSuperclassName);\n\n\t\treturn (!possibleSubclassName.equals(possibleSuperclassName) &&\n\t\t       seesMethod(possibleMethodName, possibleSubclassName, possibleSuperclassName)) ||\n\t\t       (possibleSubclassName.equals(possibleSuperclassName) &&\n\t\t       cdecl(possibleSubclassName).map(c -> {\n                   switch (c) {\n                   case SyDeclClassLit syDeclClassLit:\n                       return syDeclClassLit.hasMethod(possibleMethodName);\n                   default: throw new AssertionError();\n                   }\n               }).orElse(false));\n\t}\n\n\tpublic Optional<SyDeclClass> methodProvider(String possibleMethodName, String possibleSubclassName) {\n\t\tObjects.requireNonNull(possibleMethodName);\n\t\tObjects.requireNonNull(possibleSubclassName);\n\n\t\tfor (SyDeclClass syDeclClass : this.classes) {\n\t\t\tswitch (syDeclClass) {\n\t\t\tcase SyDeclClassLit syDeclClassLit:\n\t\t\t\tif (recvMethod(possibleMethodName, possibleSubclassName, syDeclClassLit.className())) {\n\t\t\t\t\treturn Optional.of(syDeclClassLit);\n\t\t\t\t}\n\t\t\t\tbreak;\n\t\t\tdefault: throw new AssertionError();\n\t\t\t}\n\t\t}\n\t\treturn Optional.empty();\n\t}\n\n\tpublic Optional<SyDeclClass> classWithField(String possibleFieldName) {\n\t\tObjects.requireNonNull(possibleFieldName);\n\n\t\tfor (SyDeclClass syDeclClass : this.classes) {\n\t\t\tswitch (syDeclClass) {\n\t\t\tcase SyDeclClassLit syDeclClassLit:\n\t\t\t\tif (syDeclClassLit.hasField(possibleFieldName)) {\n\t\t\t\t\treturn Optional.of(syDeclClassLit);\n\t\t\t\t}\n\t\t\t\tbreak;\n\t\t\tdefault: throw new AssertionError();\n\t\t\t}\n\t\t}\n\t\treturn Optional.empty();\n\t}\n\n\tpublic Set<SyDeclClass> implementors(String possibleMethodName) {\n\t\tObjects.requireNonNull(possibleMethodName);\n\n\t\tfinal LinkedHashSet<SyDeclClass> retVal = new LinkedHashSet<>();\n\t\tfor (SyDeclClass syDeclClass : this.classes) {\n\t\t\tswitch (syDeclClass) {\n\t\t\tcase SyDeclClassLit syDeclClassLit:\n\t\t\t\tif (syDeclClassLit.hasMethod(possibleMethodName)) {\n\t\t\t\t\tretVal.add(syDeclClassLit);\n\t\t\t\t}\n\t\t\t\tbreak;\n\t\t\tdefault: throw new AssertionError();\n\t\t\t}\n\t\t}\n\t\treturn retVal;\n\t}\n\n\tpublic Set<SyDeclClass> overriders(String possibleMethodName, String possibleSuperclassName) {\n\t\tObjects.requireNonNull(possibleMethodName);\n\t\tObjects.requireNonNull(possibleSuperclassName);\n\n\t\tfinal LinkedHashSet<SyDeclClass> retVal = new LinkedHashSet<>();\n\t\tfor (SyDeclClass syDeclClass : this.classes) {\n\t\t\tswitch (syDeclClass) {\n\t\t\tcase SyDeclClassLit syDeclClassLit:\n\t\t\t\tif (seesMethod(possibleMethodName, syDeclClassLit.className(), possibleSuperclassName) &&\n\t\t\t\t    syDeclClassLit.hasMethod(possibleMethodName) &&\n\t\t\t\t    !possibleSuperclassName.equals(syDeclClassLit.className())) {\n\t\t\t\t\tretVal.add(syDeclClassLit);\n\t\t\t\t}\n\t\t\t\tbreak;\n\t\t\tdefault: throw new AssertionError();\n\t\t\t}\n\t\t}\n\t\treturn retVal;\n\t}\n}\n", "bug/syntax/SyReferenceConstant.java", "package bug.syntax;\n\npublic sealed interface SyReferenceConstant permits SyReferenceConstantNull, SyReferenceConstantLoc, SyReferenceConstantSymbol {\n\n}\n", "bug/syntax/SyReferenceConstantLoc.java", "package bug.syntax;\n\nimport java.util.Objects;\n\npublic record SyReferenceConstantLoc(SyLoc syLoc) implements SyReferenceConstant {\n\tpublic SyReferenceConstantLoc {\n\t\tObjects.requireNonNull(syLoc);\n\t}\n}\n", "bug/syntax/SyReferenceConstantNull.java", "package bug.syntax;\n\npublic record SyReferenceConstantNull() implements SyReferenceConstant {\n\n}\n", "bug/syntax/SyReferenceConstantSymbol.java", "package bug.syntax;\n\nimport java.util.Objects;\n\npublic record SyReferenceConstantSymbol(SySymbol sySymbol) implements SyReferenceConstant {\n\tpublic SyReferenceConstantSymbol {\n\t\tObjects.requireNonNull(sySymbol);\n\t}\n}\n", "bug/syntax/SySymbolExpression.java", "package bug.syntax;\n\npublic record SySymbolExpression(int id) implements SySymbol {\n\n}\n", "bug/syntax/SySymbolField.java", "package bug.syntax;\n\nimport java.util.List;\nimport java.util.Objects;\n\npublic record SySymbolField(int id, List<String> fieldNames) implements SySymbol {\n\tpublic SySymbolField {\n\t\tObjects.requireNonNull(fieldNames);\n\t\tfor (String fieldName : fieldNames) {\n\t\t\tObjects.requireNonNull(fieldName);\n\t\t}\n\t}\n}\n", "bug/syntax/SySymbol.java", "package bug.syntax;\n\npublic sealed interface SySymbol permits SySymbolExpression, SySymbolField {\n\n}\n", "bug/syntax/SyTypeBool.java", "package bug.syntax;\n\npublic record SyTypeBool() implements SyType {\n\t@Override\n\tpublic boolean isReference() {\n\t\treturn false;\n\t}\n\n\t@Override\n\tpublic SyValue ini() {\n\t\treturn new SyValuePrimitiveConstant(new SyPrimitiveConstantBool(new SyBoolFalse()));\n\t}\n}\n", "bug/syntax/SyTypeClass.java", "package bug.syntax;\n\nimport java.util.Objects;\n\npublic record SyTypeClass(String name) implements SyType {\n\tpublic SyTypeClass {\n\t\tObjects.requireNonNull(name);\n\t}\n\n\t@Override\n\tpublic boolean isReference() {\n\t\treturn true;\n\t}\n\n\t@Override\n\tpublic SyValue ini() {\n\t\treturn new SyValueReferenceConstant(new SyReferenceConstantNull());\n\t}\n}\n", "bug/syntax/SyTypeInt.java", "package bug.syntax;\n\npublic record SyTypeInt() implements SyType {\n\t@Override\n\tpublic boolean isReference() {\n\t\treturn false;\n\t}\n\n\t@Override\n\tpublic SyValue ini() {\n\t\treturn new SyValuePrimitiveConstant(new SyPrimitiveConstantInt(new SyIntLit(0)));\n\t}\n}\n", "bug/syntax/SyType.java", "package bug.syntax;\n\npublic sealed interface SyType permits SyTypeBool, SyTypeInt, SyTypeClass {\n\tpublic default boolean isPrimitive() { return !isReference(); }\n\tpublic boolean isReference();\n\tpublic SyValue ini();\n}\n", "bug/syntax/SyValueAdd.java", "package bug.syntax;\n\nimport java.util.Objects;\n\npublic record SyValueAdd(SyValue syValueFirst, SyValue syValueSecond) implements SyValue {\n\tpublic SyValueAdd {\n\t\tObjects.requireNonNull(syValueFirst);\n\t\tObjects.requireNonNull(syValueSecond);\n\t}\n\n\t@Override\n\tpublic boolean isReference() {\n\t\treturn false;\n\t}\n}\n", "bug/syntax/SyValueAnd.java", "package bug.syntax;\n\nimport java.util.Objects;\n\npublic record SyValueAnd(SyValue syValueFirst, SyValue syValueSecond) implements SyValue {\n\tpublic SyValueAnd {\n\t\tObjects.requireNonNull(syValueFirst);\n\t\tObjects.requireNonNull(syValueSecond);\n\t}\n\n\t@Override\n\tpublic boolean isReference() {\n\t\treturn false;\n\t}\n}\n", "bug/syntax/SyValueEq.java", "package bug.syntax;\n\nimport java.util.Objects;\n\npublic record SyValueEq(SyValue syValueFirst, SyValue syValueSecond) implements SyValue {\n\tpublic SyValueEq {\n\t\tObjects.requireNonNull(syValueFirst);\n\t\tObjects.requireNonNull(syValueSecond);\n\t}\n\n\t@Override\n\tpublic boolean isReference() {\n\t\treturn false;\n\t}\n}\n", "bug/syntax/SyValueFieldRel.java", "package bug.syntax;\n\nimport java.util.Objects;\n\npublic record SyValueFieldRel(SySymbol sySymbolFirst, String fieldName, SySymbol sySymbolSecond) implements SyValue {\n\tpublic SyValueFieldRel {\n\t\tObjects.requireNonNull(sySymbolFirst);\n\t\tObjects.requireNonNull(fieldName);\n\t\tObjects.requireNonNull(sySymbolSecond);\n\t}\n\n\t@Override\n\tpublic boolean isReference() {\n\t\treturn false;\n\t}\n}\n", "bug/syntax/SyValueIte.java", "package bug.syntax;\n\nimport java.util.Objects;\n\npublic record SyValueIte(SyValue syValueCond, SyValue syValueThen, SyValue syValueElse) implements SyValue {\n\tpublic SyValueIte {\n\t\tObjects.requireNonNull(syValueCond);\n\t\tObjects.requireNonNull(syValueThen);\n\t\tObjects.requireNonNull(syValueElse);\n\t}\n\n\t@Override\n\tpublic boolean isReference() {\n\t\treturn this.syValueThen.isReference();\n\t}\n}\n", "bug/syntax/SyValue.java", "package bug.syntax;\n\npublic sealed interface SyValue permits SyValueUnassumed, SyValuePrimitiveConstant, SyValueReferenceConstant,\nSyValueAdd, SyValueSub, SyValueLt, SyValueAnd, SyValueOr, SyValueNot, SyValueEq, SyValueSubtypeRel,\nSyValueFieldRel, SyValueIte {\n\tpublic default boolean isPrimitive() { return !isReference(); }\n\tpublic boolean isReference();\n}\n", "bug/syntax/SyValueLt.java", "package bug.syntax;\n\nimport java.util.Objects;\n\npublic record SyValueLt(SyValue syValueFirst, SyValue syValueSecond) implements SyValue {\n\tpublic SyValueLt {\n\t\tObjects.requireNonNull(syValueFirst);\n\t\tObjects.requireNonNull(syValueSecond);\n\t}\n\n\t@Override\n\tpublic boolean isReference() {\n\t\treturn false;\n\t}\n}\n", "bug/syntax/SyValueNot.java", "package bug.syntax;\n\nimport java.util.Objects;\n\npublic record SyValueNot(SyValue syValue) implements SyValue {\n\tpublic SyValueNot {\n\t\tObjects.requireNonNull(syValue);\n\t}\n\n\t@Override\n\tpublic boolean isReference() {\n\t\treturn false;\n\t}\n}\n", "bug/syntax/SyValueOr.java", "package bug.syntax;\n\nimport java.util.Objects;\n\npublic record SyValueOr(SyValue syValueFirst, SyValue syValueSecond) implements SyValue {\n\tpublic SyValueOr {\n\t\tObjects.requireNonNull(syValueFirst);\n\t\tObjects.requireNonNull(syValueSecond);\n\t}\n\n\t@Override\n\tpublic boolean isReference() {\n\t\treturn false;\n\t}\n}\n", "bug/syntax/SyValuePrimitiveConstant.java", "package bug.syntax;\n\nimport java.util.Objects;\n\npublic record SyValuePrimitiveConstant(SyPrimitiveConstant syPrimitiveConstant) implements SyValue {\n\tpublic SyValuePrimitiveConstant {\n\t\tObjects.requireNonNull(syPrimitiveConstant);\n\t}\n\n\t@Override\n\tpublic boolean isReference() {\n\t\treturn false;\n\t}\n}\n", "bug/syntax/SyValueReferenceConstant.java", "package bug.syntax;\n\nimport java.util.Objects;\n\npublic record SyValueReferenceConstant(SyReferenceConstant syReferenceConstant) implements SyValue {\n\tpublic SyValueReferenceConstant {\n\t\tObjects.requireNonNull(syReferenceConstant);\n\t}\n\n\t@Override\n\tpublic boolean isReference() {\n\t\treturn true;\n\t}\n}\n", "bug/syntax/SyValueSub.java", "package bug.syntax;\n\nimport java.util.Objects;\n\npublic record SyValueSub(SyValue syValueFirst, SyValue syValueSecond) implements SyValue {\n\tpublic SyValueSub {\n\t\tObjects.requireNonNull(syValueFirst);\n\t\tObjects.requireNonNull(syValueSecond);\n\t}\n\n\t@Override\n\tpublic boolean isReference() {\n\t\treturn false;\n\t}\n}\n", "bug/syntax/SyValueSubtypeRel.java", "package bug.syntax;\n\nimport java.util.Objects;\n\npublic record SyValueSubtypeRel(SyValue syValue, SyType syType) implements SyValue {\n\tpublic SyValueSubtypeRel {\n\t\tObjects.requireNonNull(syValue);\n\t\tObjects.requireNonNull(syType);\n\t}\n\n\t@Override\n\tpublic boolean isReference() {\n\t\treturn false;\n\t}\n}\n", "bug/syntax/SyValueUnassumed.java", "package bug.syntax;\n\npublic record SyValueUnassumed() implements SyValue {\n\t@Override\n\tpublic boolean isReference() {\n\t\treturn false; //imprecise, not meant to be used\n\t}\n}\n"}, "Finished!");
    }
}

