/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest9;
import org.eclipse.jdt.core.tests.compiler.regression.DefaultJavaRuntimeEnvironment;
import org.eclipse.jdt.core.tests.compiler.regression.InMemoryNameEnvironment9;
import org.eclipse.jdt.core.tests.util.Util;
import org.eclipse.jdt.internal.compiler.batch.FileSystem;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;

public class RecordPatternTest
extends AbstractRegressionTest9 {
    private static final AbstractRegressionTest.JavacTestOptions JAVAC_OPTIONS = new AbstractRegressionTest.JavacTestOptions("-source 21");
    private String extraLibPath;

    public static Class<?> testClass() {
        return RecordPatternTest.class;
    }

    public static Test suite() {
        return RecordPatternTest.buildMinimalComplianceTestSuite(RecordPatternTest.testClass(), 262144);
    }

    public RecordPatternTest(String testName) {
        super(testName);
    }

    protected Map<String, String> getCompilerOptions(boolean preview) {
        Map<String, String> defaultOptions = super.getCompilerOptions();
        defaultOptions.put("org.eclipse.jdt.core.compiler.compliance", "21");
        defaultOptions.put("org.eclipse.jdt.core.compiler.source", "21");
        defaultOptions.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "21");
        return defaultOptions;
    }

    @Override
    protected Map<String, String> getCompilerOptions() {
        return this.getCompilerOptions(false);
    }

    @Override
    protected String[] getDefaultClassPaths() {
        String[] libs = DefaultJavaRuntimeEnvironment.getDefaultClassPaths();
        if (this.extraLibPath != null) {
            String[] l = new String[libs.length + 1];
            System.arraycopy(libs, 0, l, 0, libs.length);
            l[libs.length] = this.extraLibPath;
            return l;
        }
        return libs;
    }

    @Override
    protected INameEnvironment getNameEnvironment(String[] testFiles, String[] classPaths, Map<String, String> options) {
        INameEnvironment[] classLibs;
        this.classpaths = classPaths == null ? this.getDefaultClassPaths() : classPaths;
        INameEnvironment[] iNameEnvironmentArray = classLibs = this.getClassLibs(false, options);
        int n = classLibs.length;
        int n2 = 0;
        while (n2 < n) {
            INameEnvironment nameEnvironment = iNameEnvironmentArray[n2];
            ((FileSystem)nameEnvironment).scanForModules(this.createParser());
            ++n2;
        }
        return new InMemoryNameEnvironment9(testFiles, this.moduleMap, classLibs);
    }

    @Override
    protected void runConformTest(String[] testFiles, String expectedOutput) {
        this.runConformTest(testFiles, expectedOutput, this.getCompilerOptions(false));
    }

    @Override
    protected void runConformTest(String[] testFiles, String expectedOutput, Map<String, String> customOptions) {
        if (!isJRE21Plus) {
            return;
        }
        this.runConformTest(testFiles, expectedOutput, customOptions, new String[0], JAVAC_OPTIONS);
    }

    @Override
    protected void runConformTest(String[] testFiles, String expectedOutputString, String[] classLibraries, boolean shouldFlushOutputDirectory, String[] vmArguments) {
        this.runTest(shouldFlushOutputDirectory, testFiles, classLibraries, null, false, null, false, null, false, vmArguments, expectedOutputString, null, AbstractRegressionTest.JavacTestOptions.DEFAULT);
    }

    protected void runNegativeTest(String[] testFiles, String expectedCompilerLog, String javacLog, String[] classLibraries, boolean shouldFlushOutputDirectory, Map<String, String> customOptions) {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.testFiles = testFiles;
        runner.expectedCompilerLog = expectedCompilerLog;
        runner.javacTestOptions = JAVAC_OPTIONS;
        runner.customOptions = customOptions;
        runner.expectedJavacOutputString = javacLog;
        runner.runNegativeTest();
    }

    public void test001() {
        Map<String, String> options = this.getCompilerOptions(false);
        this.runConformTest(new String[]{"X.java", "public class X {\n  static void print(Rectangle r) {\n    if (r instanceof Rectangle(ColoredPoint(Point(int x, int y), Color c),\n                               ColoredPoint lr) ) {\n        System.out.println(\"Upper-left corner:\");\n    }\n  }\n  public static void main(String[] obj) {\n    print(new Rectangle(new ColoredPoint(new Point(0, 0), Color.BLUE),\n                               new ColoredPoint(new Point(10, 15), Color.RED)));\n  }\n}\nrecord Point(int x, int y) {}\nenum Color { RED, GREEN, BLUE }\nrecord ColoredPoint(Point p, Color c) {}\nrecord Rectangle(ColoredPoint upperLeft, ColoredPoint lowerRight) {}"}, "Upper-left corner:", options);
    }

    public void test002() {
        this.runConformTest(new String[]{"X.java", "@SuppressWarnings(\"preview\")public class X {\n  public static void printLowerRight(Rectangle r) {\n    int res = switch(r) {\n       case Rectangle(ColoredPoint(Point(int x, int y), Color c),\n                               ColoredPoint lr)  -> {\n        \t\tyield 1;\n        }\n        default -> 0;\n    };\n    System.out.println(res);\n  }\n  public static void main(String[] args) {\n    printLowerRight(new Rectangle(new ColoredPoint(new Point(15, 5), Color.BLUE),\n        new ColoredPoint(new Point(30, 10), Color.RED)));\n  }\n}\nrecord Point(int x, int y) {}\nenum Color { RED, GREEN, BLUE }\nrecord ColoredPoint(Point p, Color c) {}\nrecord Rectangle(ColoredPoint upperLeft, ColoredPoint lowerRight) {}"}, "1");
    }

    public void test003() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  static void print(Rectangle r) {\n    if (r instanceof Rectangle(ColoredPoint(Point(int x, int y), Color c),\n                               ColoredPoint lr)) {\n        System.out.println(\"Upper-left corner: \" + r1);\n    }\n  }\n  public static void main(String[] obj) {\n    print(new Rectangle(new ColoredPoint(new Point(0, 0), Color.BLUE),\n    new ColoredPoint(new Point(10, 15), Color.RED)));\n  }\n}\nrecord Point(int x, int y) {}\nenum Color { RED, GREEN, BLUE }\nrecord ColoredPoint(Point p, Color c) {}\nrecord Rectangle(ColoredPoint upperLeft, ColoredPoint lowerRight) {}"}, "----------\n1. ERROR in X.java (at line 5)\n\tSystem.out.println(\"Upper-left corner: \" + r1);\n\t                                           ^^\nr1 cannot be resolved to a variable\n----------\n");
    }

    public void test004() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  static void print(Rectangle r) {\n    if (r instanceof Rectangle(ColoredPoint(Point(int x, int y), Color c),\n                               ColoredPoint lr)) {\n    }\n  }\n  public static void main(String[] obj) {\n    print(new Rectangle(new ColoredPoint(new PointTypo(0, 0), Color.BLUE),\n    new ColoredPoint(new Point(10, 15), Color.RED)));\n  }\n}\nrecord Point(int x, int y) {}\nenum Color { RED, GREEN, BLUE }\nrecord ColoredPoint(Point p, Color c) {}\nrecord Rectangle(ColoredPoint upperLeft, ColoredPoint lowerRight) {}"}, "----------\n1. ERROR in X.java (at line 8)\n\tprint(new Rectangle(new ColoredPoint(new PointTypo(0, 0), Color.BLUE),\n\t                                         ^^^^^^^^^\nPointTypo cannot be resolved to a type\n----------\n");
    }

    public void test005() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  static void print(Rectangle r) {\n    if (r instanceof Rectangle(ColoredPoint(Point(int i, int j), Color c),\n\t    \t\t\t\t\t\t\t\t\tColoredPoint lr)) {\n\t        System.out.println(\"Upper-left corner: \");\n\t    }\n  }\n}\nclass Point{}\nenum Color { RED, GREEN, BLUE }\nrecord ColoredPoint(Point p, Color c) {}\nrecord Rectangle(ColoredPoint upperLeft, ColoredPoint lowerRight) {}"}, "----------\n1. ERROR in X.java (at line 3)\n\tif (r instanceof Rectangle(ColoredPoint(Point(int i, int j), Color c),\n\t                                        ^^^^^\nOnly record types are permitted in a record pattern\n----------\n");
    }

    public void test006() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  static void print(Rectangle r) {\n    if (r instanceof Rectangle(ColoredPoint(Point(int i), Color c),\n\t    \t\t\t\t\t\t\t\t\tColoredPoint lr)) {\n\t        System.out.println(\"Upper-left corner: \");\n\t    }\n  }\n}\nrecord Point(int x, int y) {}\nenum Color { RED, GREEN, BLUE }\nrecord ColoredPoint(Point p, Color c) {}\nrecord Rectangle(ColoredPoint upperLeft, ColoredPoint lowerRight) {}"}, "----------\n1. ERROR in X.java (at line 3)\n\tif (r instanceof Rectangle(ColoredPoint(Point(int i), Color c),\n\t                                        ^^^^^^^^^^^^\nRecord pattern should match the signature of the record declaration\n----------\n");
    }

    public void test007() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  static void print(Rectangle r) {\n    if (r instanceof Rectangle(ColoredPoint(Point(String o1, String o2), Color c),\n\t    \t\t\t\t\t\t\t\t\tColoredPoint lr)) {\n\t        System.out.println(\"Upper-left corner: \" );\n\t    }\n  }\n}\nrecord Point(int x, int y) {}\nenum Color { RED, GREEN, BLUE }\nrecord ColoredPoint(Point p, Color c) {}\nrecord Rectangle(ColoredPoint upperLeft, ColoredPoint lowerRight) {}"}, "----------\n1. ERROR in X.java (at line 3)\n\tif (r instanceof Rectangle(ColoredPoint(Point(String o1, String o2), Color c),\n\t                                              ^^^^^^^^^\nRecord component with type int is not compatible with type String\n----------\n2. ERROR in X.java (at line 3)\n\tif (r instanceof Rectangle(ColoredPoint(Point(String o1, String o2), Color c),\n\t                                                         ^^^^^^^^^\nRecord component with type int is not compatible with type String\n----------\n");
    }

    public void test008() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  static void print(Rectangle r) {\n    if (r instanceof Rectangle(ColoredPoint(Point(int i, int j), Color c), ColoredPoint lr, Object obj)) {\n\t        System.out.println(\"Upper-left corner: \" );\n\t    }\n  }\n}\nrecord Point(int x, int y) {}\nenum Color { RED, GREEN, BLUE }\nrecord ColoredPoint(Point p, Color c) {}\nrecord Rectangle(ColoredPoint upperLeft, ColoredPoint lowerRight) {}"}, "----------\n1. ERROR in X.java (at line 3)\n\tif (r instanceof Rectangle(ColoredPoint(Point(int i, int j), Color c), ColoredPoint lr, Object obj)) {\n\t                 ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nRecord pattern should match the signature of the record declaration\n----------\n");
    }

    public void test009() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  static void print(Rectangle r) {\n    int res = switch(r) {\n       \tcase Rectangle c -> {\n\t\t\tyield 0;\n\t\t}\n\t\tcase Rectangle(ColoredPoint(Point(int x, int y), Color c),\n\t\t\t\tColoredPoint(Point(int x1, int y1), Color c1)) -> {\n\t\t\tyield 1;\n\t\t}\n    };\n    System.out.println(res);\n  }\n}\nrecord Point(int x, int y) {}\nenum Color { RED, GREEN, BLUE }\nrecord ColoredPoint(Point p, Color c) {}\nrecord Rectangle(ColoredPoint upperLeft, ColoredPoint lowerRight) {}"}, "----------\n1. ERROR in X.java (at line 7)\n\tcase Rectangle(ColoredPoint(Point(int x, int y), Color c),\n\t\t\t\tColoredPoint(Point(int x1, int y1), Color c1)) -> {\n\t     ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nThis case label is dominated by one of the preceding case labels\n----------\n");
    }

    public void test10() {
        this.runConformTest(new String[]{"X.java", "@SuppressWarnings(\"preview\")public class X {\n  public static void printLowerRight(Rectangle r) {\n    int res = switch(r) {\n       case Rectangle(ColoredPoint(Point(int x, int y), Color c),\n                               ColoredPoint lr)  -> {\n    \t\t\t\tSystem.out.println(\"x= \" + x);\n    \t\t\t\tSystem.out.println(\"y= \" + y);\n    \t\t\t\tSystem.out.println(\"lr= \" + lr);\n    \t\t\t\tSystem.out.println(\"lr.c()= \" + lr.c());\n    \t\t\t\tSystem.out.println(\"lr.p()= \" + lr.p());\n    \t\t\t\tSystem.out.println(\"lr.p().x()= \" + lr.p().x());\n    \t\t\t\tSystem.out.println(\"lr.p().y()= \" + lr.p().y());\n    \t\t\t\tSystem.out.println(\"c= \" + c);\n        \t\tyield x;\n        }\n        default -> 0;\n    };\n    System.out.println(\"Returns: \" + res);\n  }\n  public static void main(String[] args) {\n    printLowerRight(new Rectangle(new ColoredPoint(new Point(15, 5), Color.BLUE),\n        new ColoredPoint(new Point(30, 10), Color.RED)));\n  }\n}\nrecord Point(int x, int y) {}\nenum Color { RED, GREEN, BLUE }\nrecord ColoredPoint(Point p, Color c) {}\nrecord Rectangle(ColoredPoint upperLeft, ColoredPoint lowerRight) {}"}, "x= 15\ny= 5\nlr= ColoredPoint[p=Point[x=30, y=10], c=RED]\nlr.c()= RED\nlr.p()= Point[x=30, y=10]\nlr.p().x()= 30\nlr.p().y()= 10\nc= BLUE\nReturns: 15");
    }

    public void test11() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  static void print(Rectangle r) {\n    int res = switch(r) {\n\t\tcase Rectangle(ColoredPoint(Point(int x, int y), Color c),\n\t\t\t\tColoredPoint(Point(int x1, int y1), Color c1)) -> {\n\t\t\tyield 1;\n\t\t}\n\t\tdefault -> {yield x;}    };\n    System.out.println(res);\n  }\n}\nrecord Point(int x, int y) {}\nenum Color { RED, GREEN, BLUE }\nrecord ColoredPoint(Point p, Color c) {}\nrecord Rectangle(ColoredPoint upperLeft, ColoredPoint lowerRight) {}"}, "----------\n1. ERROR in X.java (at line 8)\n\tdefault -> {yield x;}    };\n\t                  ^\nx cannot be resolved to a variable\n----------\n");
    }

    public void test12() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  static void print(Rectangle r) {\n    int res = switch(r) {\n\t\tcase Rectangle(ColoredPoint(Point(int x, int y), Color c),\n\t\t\t\tColoredPoint(Point(int x1, int y1), Color c1)) -> {\n\t\t\tyield 1;\n\t\t}\n\t\tdefault -> {yield x1;}    };\n    System.out.println(res);\n  }\n}\nrecord Point(int x, int y) {}\nenum Color { RED, GREEN, BLUE }\nrecord ColoredPoint(Point p, Color c) {}\nrecord Rectangle(ColoredPoint upperLeft, ColoredPoint lowerRight) {}"}, "----------\n1. ERROR in X.java (at line 8)\n\tdefault -> {yield x1;}    };\n\t                  ^^\nx1 cannot be resolved to a variable\n----------\n");
    }

    public void test13() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  public static void printLowerRight(Rectangle r) {\n    int res = switch(r) {\n       case Rectangle(ColoredPoint(Point(int x, int y), Color c),\n                               ColoredPoint lr)  when x > 0 -> {\n        \t\tyield 1;\n        }\n       case Rectangle(ColoredPoint(Point(int x, int y), Color c),\n                               ColoredPoint lr)  when x <= 0 -> {\n        \t\tyield -1;\n        }\n        default -> 0;\n    };\n    System.out.println(\"Returns: \" + res);\n  }\n  public static void main(String[] args) {\n    printLowerRight(new Rectangle(new ColoredPoint(new Point(0, 0), Color.BLUE),\n        new ColoredPoint(new Point(30, 10), Color.RED)));\n    printLowerRight(new Rectangle(new ColoredPoint(new Point(5, 5), Color.BLUE),\n        new ColoredPoint(new Point(30, 10), Color.RED)));\n  }\n}\nrecord Point(int x, int y) {}\nenum Color { RED, GREEN, BLUE }\nrecord ColoredPoint(Point p, Color c) {}\nrecord Rectangle(ColoredPoint upperLeft, ColoredPoint lowerRight) {}"}, "Returns: -1\nReturns: 1");
    }

    public void test14() {
        this.runConformTest(new String[]{"X.java", "@SuppressWarnings(\"preview\")public class X {\n  public static void print(Record r) {\n    int res = switch(r) {\n       case Record(int x) -> x ;\n        default -> 0;\n    };\n    System.out.println(\"Returns: \" + res);\n  }\n  public static void main(String[] args) {\n    print(new Record(3));\n  }\n}\nrecord Record(int x) {}\n"}, "Returns: 3");
    }

    public void test15() {
        this.runConformTest(new String[]{"X.java", "@SuppressWarnings(\"preview\")public class X {\n\t @SuppressWarnings(\"preview\")\n\tpublic static void print(Pair p) {\n    if (p instanceof Pair(Teacher(Object n), Student(Object n1, Integer i)) ) {\n\t\t\t System.out.println(n1);\n\t\t } else {\n\t\t\t System.out.println(\"ELSE\");\n\t\t }\n  }\n  public static void main(String[] args) {\n    print(new Pair(new Teacher(\"123\"), new Student(\"abc\", 1)));\n  }\n}\nsealed interface Person permits Student, Teacher {\n    String name();\n}\n record Student(String name, Integer id) implements Person {}\n record Teacher(String name) implements Person {}\n record Pair(Person s, Person s1) {}\n"}, "abc");
    }

    public void test16() {
        this.runConformTest(new String[]{"X.java", "@SuppressWarnings(\"preview\")public class X {\n\t @SuppressWarnings(\"preview\")\n\tpublic static void print(Pair p) {\n    if (p instanceof Pair(Teacher(Object n), Student(Object n1, Integer i))) {\n\t\t\t System.out.println(\"IF\");\n\t\t } else {\n\t\t\t System.out.println(\"ELSE\");\n\t\t }\n  }\n  public static void main(String[] args) {\n    print(new Pair(new Student(\"abc\", 1), new Teacher(\"123\")));\n  }\n}\nsealed interface Person permits Student, Teacher {\n    String name();\n}\n record Student(String name, Integer id) implements Person {}\n record Teacher(String name) implements Person {}\n record Pair(Person s, Person s1) {}\n"}, "ELSE");
    }

    public void test17() {
        this.runConformTest(new String[]{"X.java", "@SuppressWarnings(\"preview\")public class X {\n\t @SuppressWarnings(\"preview\")\n\tpublic static void print(Pair p) {\n    if (p instanceof Pair(Teacher(Object n), Student(Object n1, Integer i))) {\n\t\t\t System.out.println(n1.getClass().getTypeName() + \":\" + n1 + \",\" + i);\n\t\t } else {\n\t\t\t System.out.println(\"ELSE\");\n\t\t }\n  }\n  public static void main(String[] args) {\n    print(new Pair(new Teacher(\"123\"), new Student(\"abc\", 10)));\n  }\n}\nsealed interface Person permits Student, Teacher {\n    String name();\n}\n record Student(String name, Integer id) implements Person {}\n record Teacher(String name) implements Person {}\n record Pair(Person s, Person s1) {}\n"}, "java.lang.String:abc,10");
    }

    public void test18() {
        this.runConformTest(new String[]{"X.java", "@SuppressWarnings(\"preview\")public class X {\n\t @SuppressWarnings(\"preview\")\n\tpublic static void print(Pair p) {\n    if (p instanceof Pair(Teacher(Object n), Student(Object n1, int i))) {\n\t\t\t System.out.println(n1.getClass().getTypeName() + \":\" + n1 + \",\" + i);\n\t\t } else {\n\t\t\t System.out.println(\"ELSE\");\n\t\t }\n  }\n  public static void main(String[] args) {\n    print(new Pair(new Teacher(\"123\"), new Student(\"abc\", 10)));\n  }\n}\nsealed interface Person permits Student, Teacher {\n    String name();\n}\n record Student(String name, int id) implements Person {}\n record Teacher(String name) implements Person {}\n record Pair(Person s, Person s1) {}\n"}, "java.lang.String:abc,10");
    }

    public void test19() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\t @SuppressWarnings(\"preview\")\n\tpublic static void print(Pair p) {\n\t\t int res1 = switch(p) {\n\t\t \tcase Pair(Student(Object n1, int i), Teacher(Object n)) -> {\n              \t   yield i;\n                 }\n\t\t \tdefault -> -1;\n\t\t };\n\t\t System.out.println(res1);\n  }\n\t public static void main(String[] args) {\n\t\tprint(new Pair( new Student(\"abc\", 15), new Teacher(\"123\")));\n\t\tprint(new Pair( new Teacher(\"123\"), new Student(\"abc\", 1)));\n\t}\n}\nsealed interface Person permits Student, Teacher {\n    String name();\n}\n record Student(String name, int id) implements Person {}\n record Teacher(String name) implements Person {}\n record Pair(Person s, Person s1) {}\n"}, "15\n-1");
    }

    public void test20() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\t @SuppressWarnings(\"preview\")\n\tpublic static void print(Object p) {\n\t\t int res1 = switch(p) {\n\t\t \tcase Pair(Student(Object n1, int i), Teacher(Object n)) -> {\n              \t   yield i;\n                 }\n\t\t \tdefault -> -1;\n\t\t };\n\t\t System.out.println(res1);\n  }\n\t public static void main(String[] args) {\n\t\tprint(new Pair( new Student(\"abc\", 15), new Teacher(\"123\")));\n\t\tprint(new Pair( new Teacher(\"123\"), new Student(\"abc\", 1)));\n\t}\n}\nsealed interface Person permits Student, Teacher {\n    String name();\n}\n record Student(String name, int id) implements Person {}\n record Teacher(String name) implements Person {}\n record Pair(Person s, Person s1) {}\n"}, "15\n-1");
    }

    public void test21() {
        this.runConformTest(new String[]{"X.java", "@SuppressWarnings(\"preview\")public class X {\n\t @SuppressWarnings(\"preview\")\n\tpublic static void print(Object p) {\n    if (p instanceof Pair(Student(Object n1, int i), Teacher(Object n))) {\n      System.out.println(i);\n    }\n  }\n\t public static void main(String[] args) {\n\t\tprint(new Pair( new Student(\"abc\", 15), new Teacher(\"123\")));\n\t\tprint(new Pair( new Teacher(\"123\"), new Student(\"abc\", 1)));\n\t}\n}\nsealed interface Person permits Student, Teacher {\n    String name();\n}\n record Student(String name, int id) implements Person {}\n record Teacher(String name) implements Person {}\n record Pair(Person s, Person s1) {}\n"}, "15");
    }

    public void test22() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  public static void printLowerRight(Rectangle r) {\n    int res = switch(r) {\n       case Rectangle(ColoredPoint(Point(int x, int y), Color c),\n                               ColoredPoint lr) when x > 1 -> {\n                            \t   System.out.println(\"one\");\n        \t\tyield x;\n        }\n       case Rectangle(ColoredPoint(Point(int x, int y), Color c),\n                               ColoredPoint lr) when x <= 0 -> {\n                            \t   System.out.println(\"two\");\t\n        \t\tyield x;\n        }\n        default -> 0;\n    };\n    System.out.println(\"Returns: \" + res);\n  }\n  public static void main(String[] args) {\n    printLowerRight(new Rectangle(new ColoredPoint(new Point(0, 0), Color.BLUE),\n        new ColoredPoint(new Point(30, 10), Color.RED)));\n    printLowerRight(new Rectangle(new ColoredPoint(new Point(5, 5), Color.BLUE),\n        new ColoredPoint(new Point(30, 10), Color.RED)));\n  }\n}\nrecord Point(int x, int y) {}\nenum Color { RED, GREEN, BLUE }\nrecord ColoredPoint(Point p, Color c) {}\nrecord Rectangle(ColoredPoint upperLeft, ColoredPoint lowerRight) {}"}, "two\nReturns: 0\none\nReturns: 5", this.getCompilerOptions(false), null, AbstractRegressionTest.JavacTestOptions.SKIP);
    }

    public void test23() {
        this.runConformTest(new String[]{"X.java", "@SuppressWarnings(\"preview\")public class X {\n  public static void printLowerRight(Rectangle r) {\n    int res = switch(r) {\n       case Rectangle(ColoredPoint(Point(int x, int y), Color c),\n                               ColoredPoint lr) when x > value() -> {\n                            \t   System.out.println(\"one\");\n        \t\tyield x;\n        }\n        default -> 0;\n    };\n    System.out.println(\"Returns: \" + res);\n  }\n  public static int value() {\n    return 0;\n  }\n  public static void main(String[] args) {\n    printLowerRight(new Rectangle(new ColoredPoint(new Point(0, 0), Color.BLUE),\n        new ColoredPoint(new Point(30, 10), Color.RED)));\n    printLowerRight(new Rectangle(new ColoredPoint(new Point(5, 5), Color.BLUE),\n        new ColoredPoint(new Point(30, 10), Color.RED)));\n  }\n}\nrecord Point(int x, int y) {}\nenum Color { RED, GREEN, BLUE }\nrecord ColoredPoint(Point p, Color c) {}\nrecord Rectangle(ColoredPoint upperLeft, ColoredPoint lowerRight) {}"}, "Returns: 0\none\nReturns: 5");
    }

    public void test24() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  @SuppressWarnings(\"preview\")\n  public static void printLowerRight(Object r) {\n    int res = switch(r) {\n       case Rectangle(ColoredPoint(Point(int x, int y), Color c),\n    \t\t   \t\t\t\tColoredPoint lr) when x >\n\t\t\t\t\t\t\t\t       switch(r) {\n\t\t\t\t\t\t\t\t       \t case Rectangle(ColoredPoint c1,  ColoredPoint lr1) -> 2;\n\t\t\t\t\t\t\t\t       \t default -> 3;\n\t\t\t\t\t\t\t\t       }\n\t\t\t\t\t\t\t\t       \t-> x;\n\t\t\t\t\t\t\t\t       default -> 0;\n    \t\t\t};\n    \t\t\tSystem.out.println(\"Returns: \" + res);\n  }\n  public static void main(String[] args) {\n    printLowerRight(new Rectangle(new ColoredPoint(new Point(0, 0), Color.BLUE),\n        new ColoredPoint(new Point(30, 10), Color.RED)));\n    printLowerRight(new Rectangle(new ColoredPoint(new Point(5, 5), Color.BLUE),\n        new ColoredPoint(new Point(30, 10), Color.RED)));\n  }\n}\nrecord Point(int x, int y) {}\nenum Color { RED, GREEN, BLUE }\nrecord ColoredPoint(Point p, Color c) {}\nrecord Rectangle(ColoredPoint upperLeft, ColoredPoint lowerRight) {}"}, "Returns: 0\nReturns: 5");
    }

    public void test24a() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  @SuppressWarnings(\"preview\")\n  public static void printLowerRight(Object r) {\n    \t  int x = 0;\n       if (r instanceof Rectangle(ColoredPoint c,  ColoredPoint lr) && x < switch(r) {\n    \t case Rectangle(ColoredPoint c1,  ColoredPoint lr1)  -> 2;\n    \t default -> 3;\n\t  }) {\n\t\t  System.out.println(\"IF\");\n\t  }\n  }\n  public static void main(String[] args) {\n    printLowerRight(new Rectangle(new ColoredPoint(new Point(0, 0), Color.BLUE),\n        new ColoredPoint(new Point(30, 10), Color.RED)));\n    printLowerRight(new Rectangle(new ColoredPoint(new Point(5, 5), Color.BLUE),\n        new ColoredPoint(new Point(30, 10), Color.RED)));\n  }\n}\nrecord Point(int x, int y) {}\nenum Color { RED, GREEN, BLUE }\nrecord ColoredPoint(Point p, Color c) {}\nrecord Rectangle(ColoredPoint upperLeft, ColoredPoint lowerRight) {}"}, "IF\nIF");
    }

    public void test25() {
        String currentWorkingDirectoryPath = System.getProperty("user.dir");
        this.extraLibPath = currentWorkingDirectoryPath + File.separator + "libtest25.jar";
        try {
            try {
                Util.createJar(new String[]{"p/RecordPattern1.java;\n", "package p;\npublic class RecordPattern1 {}\nrecord Point(int x, int y) {}\nenum Color {\n\tRED, GREEN, BLUE\n}\n", "p/ColoredPoint.java", "package p;\npublic record ColoredPoint(Point p, Color c) {}\n", "p/Rectangle.java", "package p;\npublic record Rectangle(ColoredPoint upperLeft, ColoredPoint lowerRight) {}\n"}, this.extraLibPath, "21");
                this.runConformTest(new String[]{"p/X.java", "package p;\npublic class X {\n\tpublic static void printLowerRight(Rectangle r) {\n\t\tint res = switch(r) {\n\t\tcase Rectangle(ColoredPoint(Point(int x, int y), Color c),\n\t\t\t\tColoredPoint lr)  -> {\n\t\t\t\t\tyield 1;\n\t\t\t\t}\n\t\t\t\tdefault -> 0;\n\t\t};\n\t\tSystem.out.println(res);\n\t}\n\tpublic static void main(String[] args) {\n\t\t\t    printLowerRight(new Rectangle(new ColoredPoint(new Point(15, 5), Color.BLUE),\n\t\t\t        new ColoredPoint(new Point(30, 10), Color.RED)));\n\t\t\t  }\n}\n"}, "1", this.getCompilerOptions(false), new String[0], AbstractRegressionTest.JavacTestOptions.SKIP);
            }
            catch (IOException e) {
                System.err.println("RecordPatternTest.test25() could not write to current working directory " + currentWorkingDirectoryPath);
                new File(this.extraLibPath).delete();
            }
        }
        finally {
            new File(this.extraLibPath).delete();
        }
    }

    public void test26() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  static void print(Rectangle r) {\n    \tif (r instanceof Rectangle(ColoredPoint(Point(int x, int y), Color c),\n\t\t\tColoredPoint lr) && x > (switch(r) {\n\t\t\t\t\t\t\t\t\t\tcase Rectangle(ColoredPoint(Point(int x, int y), Color c),\n\t\t\t\t\t\t\t\t\t\t\t\tColoredPoint lr) -> {\n\t\t\t\t\t\t\t\t\t\t\t\t\tyield 1;\n\t\t\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t\t\t\tdefault -> 0;\n\t\t\t\t\t\t\t\t\t\t\t\t})) {\n\t\tSystem.out.println(x);\n\t  }\n\t}\n}\nrecord Point(int x, int y) {}\nenum Color { RED, GREEN, BLUE }\nrecord ColoredPoint(Point p, Color c) {}\nrecord Rectangle(ColoredPoint upperLeft, ColoredPoint lowerRight) {}"}, "----------\n1. ERROR in X.java (at line 5)\n\tcase Rectangle(ColoredPoint(Point(int x, int y), Color c),\n\t                                      ^\nA pattern variable with the same name is already defined in the statement\n----------\n2. ERROR in X.java (at line 5)\n\tcase Rectangle(ColoredPoint(Point(int x, int y), Color c),\n\t                                             ^\nA pattern variable with the same name is already defined in the statement\n----------\n3. ERROR in X.java (at line 5)\n\tcase Rectangle(ColoredPoint(Point(int x, int y), Color c),\n\t                                                       ^\nA pattern variable with the same name is already defined in the statement\n----------\n4. ERROR in X.java (at line 6)\n\tColoredPoint lr) -> {\n\t             ^^\nA pattern variable with the same name is already defined in the statement\n");
    }

    public void test27() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  static void print(Rectangle r) {\n\tint res = switch(r) {\n\t\tcase Rectangle(ColoredPoint(Point(int x, int y), Color c), ColoredPoint lr) when lr instanceof ColoredPoint(Point(int x, int y), Color c) -> {\n\t\t\t\tyield 1;\n\t\t\t}\n\t\t\tdefault -> 0;\n\t};\n\t}\n}\nrecord Point(int x, int y) {}\nenum Color { RED, GREEN, BLUE }\nrecord ColoredPoint(Point p, Color c) {}\nrecord Rectangle(ColoredPoint upperLeft, ColoredPoint lowerRight) {}"}, "----------\n1. ERROR in X.java (at line 4)\n\tcase Rectangle(ColoredPoint(Point(int x, int y), Color c), ColoredPoint lr) when lr instanceof ColoredPoint(Point(int x, int y), Color c) -> {\n\t                                                                                                                      ^\nA pattern variable with the same name is already defined in the statement\n----------\n2. ERROR in X.java (at line 4)\n\tcase Rectangle(ColoredPoint(Point(int x, int y), Color c), ColoredPoint lr) when lr instanceof ColoredPoint(Point(int x, int y), Color c) -> {\n\t                                                                                                                             ^\nA pattern variable with the same name is already defined in the statement\n----------\n3. ERROR in X.java (at line 4)\n\tcase Rectangle(ColoredPoint(Point(int x, int y), Color c), ColoredPoint lr) when lr instanceof ColoredPoint(Point(int x, int y), Color c) -> {\n\t                                                                                                                                       ^\nA pattern variable with the same name is already defined in the statement\n----------\n4. ERROR in X.java (at line 4)\n\tcase Rectangle(ColoredPoint(Point(int x, int y), Color c), ColoredPoint lr) when lr instanceof ColoredPoint(Point(int x, int y), Color c) -> {\n\t                                                                                                                                       ^\nA pattern variable with the same name is already defined in the statement\n----------\n");
    }

    public void test28() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  static void print(Rectangle r) {\n    int res = switch(r) {\n\t\tcase Rectangle(ColoredPoint(Point(int x, int y), Color c), ColoredPoint lr) when (r instanceof  Rectangle(ColoredPoint(Point(int x1, int y1), Color c1),\n\t\t\t\tColoredPoint lr1)) -> {\n\t\t\t\tyield lr1.p().y();\n\t\t\t}\n\t\t\tdefault -> 0;\n     };\n   System.out.println(res);\n  }\n  public static void main(String[] args) {\n    print(new Rectangle(new ColoredPoint(new Point(1,1), Color.RED), new ColoredPoint(new Point(5,5), Color.RED)));\n  }\n}\nrecord Point(int x, int y) {}\nenum Color { RED, GREEN, BLUE }\nrecord ColoredPoint(Point p, Color c) {}\nrecord Rectangle(ColoredPoint upperLeft, ColoredPoint lowerRight) {}"}, "5");
    }

    public void test29() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t@SuppressWarnings(\"preview\")\n\tpublic void foo(Object o) {\n       int res = switch (o) {\n        case R r -> 1;\n        case R(int a) -> 0;\n        default -> -1;\n       };\n\t}\n}\nrecord R(int i) {}"}, "----------\n1. ERROR in X.java (at line 6)\n\tcase R(int a) -> 0;\n\t     ^^^^^^^^\nThis case label is dominated by one of the preceding case labels\n----------\n");
    }

    public void test30() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t@SuppressWarnings(\"preview\")\n\tpublic void foo(Object o) {\n       int res = switch (o) {\n        case R(int a) -> 1;\n        case R(int a) -> 0;\n        default -> -1;\n       };\n\t}\n}\nrecord R(int i) {}"}, "----------\n1. ERROR in X.java (at line 6)\n\tcase R(int a) -> 0;\n\t     ^^^^^^^^\nThis case label is dominated by one of the preceding case labels\n----------\n");
    }

    public void test31() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic boolean predicate() { return true; }\n\tpublic void foo(Object o) {\n       int res = switch (o) {\n        case R r when predicate() -> 1;\n        case R(int a) -> 0;\n        default -> -1;\n       };\n       System.out.println(res);\n\t}\n  public static void main(String[] args) {\n    (new X()).foo(new R(10));\n  }\n}\nrecord R(int i) {}"}, "1");
    }

    public void test31a() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic boolean predicate() { return false; }\n\tpublic void foo(Object o) {\n       int res = switch (o) {\n        case R r when predicate() -> 1;\n        case R(int a) -> 0;\n        default -> -1;\n       };\n       System.out.println(res);\n\t}\n  public static void main(String[] args) {\n    (new X()).foo(new R(10));\n  }\n}\nrecord R(int i) {}"}, "0");
    }

    public void test32() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic boolean predicate() { return true; }\n\tpublic void foo(Object o) {\n       int res = switch (o) {\n        case R(int a)  when predicate() -> 1;\n        case R(int a) -> 0;\n        default -> -1;\n       };\n       System.out.println(res);\n\t}\n  public static void main(String[] args) {\n    (new X()).foo(new R(10));\n  }\n}\nrecord R(int i) {}"}, "1");
    }

    public void test32a() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic boolean predicate() { return false; }\n\tpublic void foo(Object o) {\n       int res = switch (o) {\n        case R(int a)  when predicate() -> 1;\n        case R(int a) -> 0;\n        default -> -1;\n       };\n       System.out.println(res);\n\t}\n  public static void main(String[] args) {\n    (new X()).foo(new R(10));\n  }\n}\nrecord R(int i) {}"}, "0");
    }

    public void test33() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t@SuppressWarnings(\"preview\")\n\tpublic void foo(Object o) {\n       int res = switch (o) {\n        case R r -> 1;\n        case R(int a) -> 0;\n        default -> -1;\n       };\n\t}\n}\nrecord R(int i) {}"}, "----------\n1. ERROR in X.java (at line 6)\n\tcase R(int a) -> 0;\n\t     ^^^^^^^^\nThis case label is dominated by one of the preceding case labels\n----------\n");
    }

    public void test34() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t@SuppressWarnings(\"preview\")\n\tpublic void foo(Object o) {\n       int res = switch (o) {\n        case R(int a) -> 1;\n        case R(int a) -> 0;\n        default -> -1;\n       };\n\t}\n}\nrecord R(int i) {}"}, "----------\n1. ERROR in X.java (at line 6)\n\tcase R(int a) -> 0;\n\t     ^^^^^^^^\nThis case label is dominated by one of the preceding case labels\n----------\n");
    }

    public void test35() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t@SuppressWarnings(\"preview\")\n\tpublic void foo(Object o) {\n       int res = switch (o) {\n       case Pair(Teacher(Object n), Student(Object n1, Integer i)) -> 0;\n       case Pair(Teacher(Object n), Student(Object n1, Integer i)) -> 1;\n        default -> -1;\n       };\n       System.out.println(res);\n\t}\n\tpublic static void main(String[] args) {\n\t\t(new X()).foo(new Pair(new Teacher(\"123\"), new Student(\"abc\", 10)));\n\t}\n}\nrecord R(int i) {}\nsealed interface Person permits Student, Teacher {\n\tString name();\n}\nrecord Student(String name, Integer id) implements Person {}\nrecord Teacher(String name) implements Person {}\nrecord Pair(Person s, Person s1) {} "}, "----------\n1. ERROR in X.java (at line 6)\n\tcase Pair(Teacher(Object n), Student(Object n1, Integer i)) -> 1;\n\t     ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nThis case label is dominated by one of the preceding case labels\n----------\n");
    }

    public void test36() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t@SuppressWarnings(\"preview\")\n\tpublic void foo(Object o) {\n       int res = switch (o) {\n       case Pair(Teacher(Object n), Student(Object n1, Integer i)) -> 0;\n       case Pair(Teacher(Object n), Student(String n1, Integer i)) -> 1;\n        default -> -1;\n       };\n       System.out.println(res);\n\t}\n\tpublic static void main(String[] args) {\n\t\t(new X()).foo(new Pair(new Teacher(\"123\"), new Student(\"abc\", 10)));\n\t}\n}\nrecord R(int i) {}\nsealed interface Person permits Student, Teacher {\n\tString name();\n}\nrecord Student(String name, Integer id) implements Person {}\nrecord Teacher(String name) implements Person {}\nrecord Pair(Person s, Person s1) {} "}, "----------\n1. ERROR in X.java (at line 6)\n\tcase Pair(Teacher(Object n), Student(String n1, Integer i)) -> 1;\n\t     ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nThis case label is dominated by one of the preceding case labels\n----------\n");
    }

    public void test37() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\t@SuppressWarnings(\"preview\")\n\tpublic void foo(Object o) {\n       int res = switch (o) {\n       case Pair(Teacher(Object n), Student(String n1, Integer i)) -> 0;\n       case Pair(Teacher(Object n), Student(Object n1, Integer i)) -> 1;\n        default -> -1;\n       };\n       System.out.println(res);\n\t}\n\tpublic static void main(String[] args) {\n\t\t(new X()).foo(new Pair(new Teacher(\"123\"), new Student(\"abc\", 10)));\n\t}\n}\nrecord R(int i) {}\nsealed interface Person permits Student, Teacher {\n\tString name();\n}\nrecord Student(String name, Integer id) implements Person {}\nrecord Teacher(String name) implements Person {}\nrecord Pair(Person s, Person s1) {} "}, "0");
    }

    public void test38() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  static void print(Rectangle r) {\n    int res = switch(r) {\n\t\tcase Rectangle(ColoredPoint(Point(int x, int y), Color c), ColoredPoint lr) when (r instanceof  Rectangle(ColoredPoint(Point(int x1, int y1), Color c1),\n\t\t\t\tColoredPoint lr1)) -> {\n\t\t\t\tyield lr1.p().y();\n\t\t\t}\n\t\t\tdefault -> 0;\n     };\n   System.out.println(res);\n  }\n  public static void main(String[] args) {\n    print(new Rectangle(new ColoredPoint(null, Color.RED), new ColoredPoint(new Point(5,5), Color.RED)));\n  }\n}\nrecord Point(int x, int y) {}\nenum Color { RED, GREEN, BLUE }\nrecord ColoredPoint(Point p, Color c) {}\nrecord Rectangle(ColoredPoint upperLeft, ColoredPoint lowerRight) {}"}, "0");
    }

    public void test39() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  static void print(Rectangle r) {\n    int res = switch(r) {\n\t\tcase Rectangle(ColoredPoint(Point(int x, int y), Color c), ColoredPoint lr) when (r instanceof  Rectangle(ColoredPoint(Point(int x1, int y1), Color c1),\n\t\t\t\tColoredPoint lr1)) -> {\n\t\t\t\tyield lr1.p().y();\n\t\t\t}\n\t\t\tdefault -> 0;\n     };\n   System.out.println(res);\n  }\n  public static void main(String[] args) {\n    print(new Rectangle(null, null));\n  }\n}\nrecord Point(int x, int y) {}\nenum Color { RED, GREEN, BLUE }\nrecord ColoredPoint(Point p, Color c) {}\nrecord Rectangle(ColoredPoint upperLeft, ColoredPoint lowerRight) {}"}, "0");
    }

    public void test40() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  static void print(Rectangle r) {\n    int res = switch(r) {\n\t\tcase Rectangle(ColoredPoint(Point(int x, int y), Color c), ColoredPoint lr) when (r instanceof  Rectangle(ColoredPoint(Point(int x1, int y1), Color c1),\n\t\t\t\tColoredPoint lr1)) -> {\n\t\t\t\tyield lr1.p().y();\n\t\t\t}\n\t\t\tdefault -> 0;\n     };\n   System.out.println(res);\n  }\n  public static void main(String[] args) {\n    try {\n\t\t  print(null);\n\t  } catch(NullPointerException e) {\n\t\t  System.out.println(\"NPE with \" + e.toString());\n\t  }\n  }\n}\nrecord Point(int x, int y) {}\nenum Color { RED, GREEN, BLUE }\nrecord ColoredPoint(Point p, Color c) {}\nrecord Rectangle(ColoredPoint upperLeft, ColoredPoint lowerRight) {}"}, "NPE with java.lang.NullPointerException");
    }

    public void test41() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  @SuppressWarnings(\"preview\")\n  public static void printLowerRight(Object r) {\n    long res = switch(r) {\n       case Rectangle(ColoredPoint(Point(var x, long y), Color c), \n    \t\t   \t\t\t\tColoredPoint lr) when x > \n\t\t\t\t\t\t\t\t       switch(r) {\n\t\t\t\t\t\t\t\t       \t case Rectangle(ColoredPoint c1,  ColoredPoint lr1) -> 2;  \n\t\t\t\t\t\t\t\t       \t default -> 10;   \n\t\t\t\t\t\t\t\t       } \n\t\t\t\t\t\t\t\t       \t-> x + 10;  \n\t\t\t\t\t\t\t\t       default -> 0;     \n    \t\t\t};    \n    \t\t\tSystem.out.println(\"Returns: \" + res);\n  } \n  public static void main(String[] args) {\n\tprintLowerRight(new Rectangle(new ColoredPoint(new Point(2, 4), Color.GREEN), new ColoredPoint(new Point(5, 4), Color.GREEN))); \n  }\n}\nrecord Point(long x, long y) {}    \nenum Color { RED, GREEN, BLUE }\nrecord ColoredPoint(Point p, Color c) {} \nrecord Rectangle(ColoredPoint upperLeft, ColoredPoint lowerRight) {}"}, "Returns: 0");
    }

    public void test42() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  @SuppressWarnings(\"preview\")\n  public static void printLowerRight(Object r) {\n    long res = switch(r) {\n       case Rectangle(ColoredPoint(Point(var x, long y), Color c), \n    \t\t   \t\t\t\tColoredPoint lr) when x > \n\t\t\t\t\t\t\t\t       switch(r) {\n\t\t\t\t\t\t\t\t       \t case Rectangle(ColoredPoint c1,  var lr1)  -> lr1.p().x();\n\t\t\t\t\t\t\t\t       \t default -> 10;   \n\t\t\t\t\t\t\t\t       } \n\t\t\t\t\t\t\t\t       \t-> x + 10;  \n\t\t\t\t\t\t\t\t       default -> 0;     \n    \t\t\t};    \n    \t\t\tSystem.out.println(\"Returns: \" + res);\n  } \n  public static void main(String[] args) {\n\tprintLowerRight(new Rectangle(new ColoredPoint(new Point(10, 4), Color.GREEN), new ColoredPoint(new Point(5, 4), Color.GREEN))); \n  }\n}\nrecord Point(long x, long y) {}    \nenum Color { RED, GREEN, BLUE }\nrecord ColoredPoint(Point p, Color c) {} \nrecord Rectangle(ColoredPoint upperLeft, ColoredPoint lowerRight) {}"}, "Returns: 20");
    }

    public void test43() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  @SuppressWarnings(\"preview\")\n  public static void printLowerRight(Object r) {\n    long res = switch(r) {\n       case Rectangle(ColoredPoint(Point(var x, long y), Color c), \n    \t\t   \t\t\t\tColoredPoint lr) when x > \n\t\t\t\t\t\t\t\t       switch(r) {\n\t\t\t\t\t\t\t\t       \t case Rectangle(ColoredPoint c1,  ColoredPoint lr1)  -> 2;  \n\t\t\t\t\t\t\t\t       \t default -> 10;   \n\t\t\t\t\t\t\t\t       } \n\t\t\t\t\t\t\t\t       \t-> x + 10;  \n\t\t\t\t\t\t\t\t       default -> 0;     \n    \t\t\t};    \n    \t\t\tSystem.out.println(\"Returns: \" + res);\n  } \n  public static void main(String[] args) {\n\tprintLowerRight(new Rectangle(new ColoredPoint(new Point(2, 4), Color.GREEN), new ColoredPoint(new Point(5, 4), Color.GREEN))); \n  }\n}\nrecord Point(int x, int y) {}    \nenum Color { RED, GREEN, BLUE }\nrecord ColoredPoint(Point p, Color c) {} \nrecord Rectangle(ColoredPoint upperLeft, ColoredPoint lowerRight) {}"}, "----------\n1. ERROR in X.java (at line 5)\n\tcase Rectangle(ColoredPoint(Point(var x, long y), Color c), \n\t                                         ^^^^^^\nRecord component with type int is not compatible with type long\n----------\n");
    }

    public void test44() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  @SuppressWarnings(\"preview\")\n  public static void printLowerRight(Object r) {\n    long res = switch(r) {\n       case Rectangle(ColoredPoint(Point(var x, int y), Color c), \n    \t\t   \t\t\t\tColoredPoint lr) when x > \n\t\t\t\t\t\t\t\t       switch(r) {\n\t\t\t\t\t\t\t\t       \t case Rectangle(ColoredPoint c1,  ColoredPoint lr1)  -> 2;  \n\t\t\t\t\t\t\t\t       \t default -> 10;   \n\t\t\t\t\t\t\t\t       } \n\t\t\t\t\t\t\t\t       \t-> x + 10;  \n\t\t\t\t\t\t\t\t       default -> 0;     \n    \t\t\t};    \n    \t\t\tSystem.out.println(\"Returns: \" + res);\n  } \n  public static void main(String[] args) {\n\tprintLowerRight(new Rectangle(new ColoredPoint(new Point(2, 4), Color.GREEN), new ColoredPoint(new Point(5, 4), Color.GREEN))); \n  }\n}\nrecord Point(long x, long y) {}    \nenum Color { RED, GREEN, BLUE }\nrecord ColoredPoint(Point p, Color c) {} \nrecord Rectangle(ColoredPoint upperLeft, ColoredPoint lowerRight) {}"}, "----------\n1. ERROR in X.java (at line 5)\n\tcase Rectangle(ColoredPoint(Point(var x, int y), Color c), \n\t                                         ^^^^^\nRecord component with type long is not compatible with type int\n----------\n");
    }

    public void test45() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tstatic void print(Object r) {\n\t\tswitch (r) {\n\t\t\tcase Rectangle(var a, var b) when (r instanceof Rectangle(ColoredPoint upperLeft2, ColoredPoint lowerRight)):\n\t\t\t\tSystem.out.println(r);// error should not be reported here\n\t\t\tbreak;\n\t\t}\n\t}\n}\nrecord ColoredPoint() {}\nrecord Rectangle(ColoredPoint upperLeft, ColoredPoint lowerRight) {} "}, "----------\n1. ERROR in X.java (at line 3)\n\tswitch (r) {\n\t        ^\nAn enhanced switch statement should be exhaustive; a default label expected\n----------\n");
    }

    public void test46() {
        this.runConformTest(new String[]{"X.java", "  @SuppressWarnings(\"preview\")\npublic class X {\n  static void printGenericBoxString1(Box<Object> objectBox) {\n\t  if (objectBox instanceof Box<Object>(String s)) {\n\t\t  System.out.println(s); \n\t  }\n  }\nstatic void printGenericBoxString2(Box<String> stringBox) {\n    if (stringBox instanceof Box<String>(var s)) {\n      System.out.println(s);\n    }\n  }\npublic static void main(String[] args) {\n\tprintGenericBoxString1(new Box(\"Hello\"));\n\tObject o = new Integer(10);\n\tBox<Object> box = new Box(o);\n\tprintGenericBoxString1(box);\n}\n}\nrecord Box<T>(T t) {} "}, "Hello");
    }

    public void test47() {
        this.runNegativeTest(new String[]{"X.java", "  @SuppressWarnings(\"preview\")\npublic class X {\n  static void printGenericBoxString1(Box<Object> objectBox) {\n    if (objectBox instanceof Box<String>(String s)) {\n      System.out.println(s);\n    }\n  }\n  public static void main(String[] args) {}\n}\nrecord Box<T>(T t) {} "}, "----------\n1. ERROR in X.java (at line 4)\n\tif (objectBox instanceof Box<String>(String s)) {\n\t    ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nIncompatible conditional operand types Box<Object> and Box<String>\n----------\n");
    }

    public void test48() {
        this.runConformTest(new String[]{"X.java", "  @SuppressWarnings(\"preview\")\npublic class X {\n\tpublic static void main(String[] args) {\n\t\terroneousTest1(new Box<>(\"A\"));\n\t\terroneousTest2(new Box<>(\"B\"));\n\t}\n\tstatic void erroneousTest1(Box<Object> bo) {\n\t\tif (bo instanceof Box(var s)) {\n\t\t\tSystem.out.println(\"I'm a box of \" + s.getClass().getName());\n\t\t}\n\t}\n\tstatic void erroneousTest2(Box b) {\n\t\tif (b instanceof Box(var t)) {\n\t\t\tSystem.out.println(\"I'm a box of \" + t.getClass().getName());\n\t\t}\n\t}\n\trecord Box<T> (T t) {\n\t}\n}"}, "I'm a box of java.lang.String\nI'm a box of java.lang.String");
    }

    public void testIssue690_1() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic void foo(Object s) {\n\t\tswitch (s) {\n\t\t\tcase R(Integer i1, Double i1) -> {}\n\t\t\tcase OuterR(R(Integer i1, Double i2), R(Integer i2, Double i2)) -> {}\n\t\t\tdefault -> {}\n\t\t}\n\t}\n} \nrecord R(Integer i1, Double i2) {}\nrecord OuterR(R r1, R r2) {}"}, "----------\n1. ERROR in X.java (at line 4)\n\tcase R(Integer i1, Double i1) -> {}\n\t                          ^^\nA pattern variable with the same name is already defined in the statement\n----------\n2. ERROR in X.java (at line 5)\n\tcase OuterR(R(Integer i1, Double i2), R(Integer i2, Double i2)) -> {}\n\t                                                ^^\nA pattern variable with the same name is already defined in the statement\n----------\n3. ERROR in X.java (at line 5)\n\tcase OuterR(R(Integer i1, Double i2), R(Integer i2, Double i2)) -> {}\n\t                                                           ^^\nA pattern variable with the same name is already defined in the statement\n----------\n");
    }

    public void testIssue690_2() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic void foo(Object s) {\n\t\tif (s instanceof OuterR(R(Integer i1, Double i2), R(Integer i3, Double i4))) { \n\t\t\t\tSystem.out.println(\"IF\");\n\t\t}\n\t\tif (s instanceof OuterR(R(Integer i1, Double i2), R(Integer i1, Double i4))) { \n\t\t\t\tSystem.out.println(\"SECOND IF\");\n\t\t}\n\t}\n} \nrecord R(Integer i1, Double i2) {}\nrecord OuterR(R r1, R r2) {}"}, "----------\n1. ERROR in X.java (at line 6)\n\tif (s instanceof OuterR(R(Integer i1, Double i2), R(Integer i1, Double i4))) { \n\t                                                            ^^\nA pattern variable with the same name is already defined in the statement\n----------\n");
    }

    public void testIssue691_1() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic void foo(Number s) {\n\t\tswitch (s) {\n\t\t\tcase R(Integer i1, Integer i2) -> {}\n\t\t\tdefault -> {}\n\t\t}\n\t}\n\tpublic void foo(Object o) {\n\t\tswitch (o) {\n\t\t\tcase R(Number i1, Integer i2) -> {}\n\t\t\tdefault -> {}\n\t\t}\n\t}\n\tpublic void bar(Object o) {\n\t\tswitch (o) {\n\t\tcase R(Integer i1, Integer i2)-> {}\n\t\t\tdefault -> {}\n\t\t}\n\t}\n} \nrecord R(Integer i1, Integer i2) {}"}, "----------\n1. ERROR in X.java (at line 4)\n\tcase R(Integer i1, Integer i2) -> {}\n\t     ^^^^^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from Number to R\n----------\n");
    }

    public void testRemoveNamedRecordPatterns_001() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n public static void foo(Rectangle r) {\n   int res = switch (r) {\n     case Rectangle(int x, int y) r -> 1;\n     default -> 0;\n   };\n   System.out.println(res);\n }\n public static void main(String[] args) {\n   foo(new Rectangle(10, 20));\n }\n}\nrecord Rectangle(int x, int y) {\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\tcase Rectangle(int x, int y) r -> 1;\n\t                           ^\nSyntax error, insert \":\" to complete SwitchLabel\n----------\n2. ERROR in X.java (at line 4)\n\tcase Rectangle(int x, int y) r -> 1;\n\t                                  ^\nSyntax error, insert \"AssignmentOperator Expression\" to complete Expression\n----------\n");
    }

    public void testIssue2004() {
        this.runConformTest(new String[]{"X.java", "record A() {}\n\trecord R<T>(T t) {}\n\tpublic class X {\n\t    private static boolean foo(R<? super A> r) {\n\t       return switch(r) {\n\t            case R(var x) -> true;\n\t            default -> false;\n\t       };\n\t    }\n\t    public static void main(String argv[]) {\n\t       System.out.println(foo(new R<A>(null)));\n\t    }\n}\n"}, "true");
    }

    public void testRecordPatternTypeInference_001() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.function.UnaryOperator;\nrecord Mapper<T>(T in, T out) implements UnaryOperator<T> {\n    public T apply(T arg) { return in.equals(arg) ? out : null; }\n}\npublic class X {\n void test(UnaryOperator<? extends CharSequence> op) {\n     if (op instanceof Mapper(var in, var out)) {\n         boolean shorter = out.length() < in.length();\n     }\n } \n Zork();\n}"}, "----------\n1. ERROR in X.java (at line 11)\n\tZork();\n\t^^^^^^\nReturn type for the method is missing\n----------\n2. ERROR in X.java (at line 11)\n\tZork();\n\t^^^^^^\nThis method requires a body instead of a semicolon\n----------\n");
    }

    public void testGH1796() {
        this.runConformTest(new String[]{"X.java", "public record X(int i) {\n\n  public static void main(String[] args) {\n    new Printer().print(new X(42), new StringBuilder());\n  }\n\n  static final class Printer {\n\n    private void print(X e, StringBuilder buffer) {\n      if (e instanceof X(int i)) {\n          System.out.println(i);\n      }\n    }\n  }\n}\n"}, "42");
    }

    public void testRecordPatternTypeInference_002() {
        this.runConformTest(new String[]{"X.java", "import java.util.function.UnaryOperator;\nrecord Mapper<T>(T in) implements UnaryOperator<T> {\n    public T apply(T arg) { return in.equals(arg) ? in : null; }\n}\npublic class X {\n @SuppressWarnings(\"preview\")\n public static boolean test(UnaryOperator<? extends CharSequence> op) {\n     if (op instanceof Mapper(var in)) {\n         return in.length() > 0;\n     }\n   return false;\n }\n public static void main(String[] args) {\n   Mapper<CharSequence> op = new Mapper<>(new String(\"abcd\"));\n   System.out.println(test(op));\n }\n}"}, "true");
    }

    public void testRecordPatternTypeInference_003() {
        this.runConformTest(new String[]{"X.java", "  @SuppressWarnings(\"preview\")\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tfoo(new Box<>(\"B\"));\n\t}\n\tstatic void foo(Box b) {\n\t\tif (b instanceof Box(var t)) {\n\t\t\tSystem.out.println(\"I'm a box of \" + t.getClass().getName());\n\t\t}\n\t}\n\trecord Box<T> (T t) {\n\t}\n}"}, "I'm a box of java.lang.String");
    }

    public void testRecordPatternTypeInference_004() {
        this.runConformTest(new String[]{"X.java", "import java.util.ArrayList;\nimport java.util.List;\ninterface I {int a();}\nrecord RecB(int a) implements I {}\nrecord R<T>(T a) {}\npublic class X {\n    private static boolean test(List<R<? extends I>> list) {\n        if (list.get(0) instanceof R(var a))\n         return a.a() > 0;\n        return false;\n    }  \n    public static void main(String... args) {\n        List<R<? extends I>> list = new ArrayList<>();\n        list.add(new R<>(new RecB(2)));\n        System.out.println(test(list));\n    }\n}"}, "true");
    }

    public void testRecordPatternTypeInference_005() {
        this.runConformTest(new String[]{"X.java", "interface I {int a();}\nrecord RecB(int a) implements I {}\nrecord R<T>(T a) {}\npublic class X {\n    private static boolean test(R<? extends I> op) {\n        if (op instanceof R(var a)) {\n         return a.a() > 0;\n        }\n        return false;\n    }  \n    public static void main(String[] args) {\n        R<? extends I> op = new R<>(new RecB(2));\n        System.out.println(test(op));\n    }\n}"}, "true");
    }

    public void testRecordPatternTypeInference_006() {
        this.runConformTest(new String[]{"X.java", "public class X {\n     public static <P> boolean test(P p) {\n         if (p instanceof R(var a)) {\n              return a.len() > 0;\n         }\n         return false;\n     }\n     public static void main(String argv[]) {\n         System.out.println(test(new R<>(new Y())));\n     }\n}\nrecord R<T extends Y>(T a) {}\nclass Y {\n public int len() { return 10;}\n}"}, "true");
    }

    public void testRecordPatternTypeInference_007() {
        this.runConformTest(new String[]{"X.java", "interface I {\n   int a();\n}\nrecord R<T>(T a) {}\npublic class X {\n    public static boolean test(R<?> p) {\n        if (p instanceof R(var a)) {\n             return a instanceof I;\n        }\n        return false; \n    }\n    public static void main(String argv[]) {\n       System.out.println(test(new R<>((I) () -> 0)));\n    }\n}"}, "true");
    }

    public void testRecordPatternTypeInference_008() {
        this.runConformTest(new String[]{"X.java", "interface I {int a();}\nrecord R<T>(T a) {}\npublic class X {\n    public static boolean test(R<I> p) {\n        return switch (p) {\n            case R(var a) -> a instanceof I;\n            default ->  false;\n        };\n    }\n    public static void main(String argv[]) {\n       System.out.println(test(new R<>((I) () -> 0)));\n    }\n}"}, "true");
    }

    public void testRecordPatternTypeInference_009() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n   int a();\n}\nrecord R<T>(T a) {}\npublic class X {\n    private static boolean test(R<? extends I> p) {\n        if (p instanceof R(String a)) {\n             return a instanceof String;\n        }\n        return true;\n    }\n    public static void main(String argv[]) {\n        System.out.println(test(new R<>((I) () -> 0))); \n    }\n}"}, "----------\n1. ERROR in X.java (at line 7)\n\tif (p instanceof R(String a)) {\n\t                   ^^^^^^^^\nRecord component with type capture#2-of ? extends I is not compatible with type String\n----------\n");
    }

    public void testRecordPatternTypeInference_010() {
        this.runConformTest(new String[]{"X.java", "interface I {\n   int a();\n}\nrecord R<T>(T a) {}\npublic class X {\n    private static boolean test(R<?> p) {\n        if (p instanceof R(String a)) {\n             return a instanceof String;\n        }\n        return true;\n    }\n    public static void main(String argv[]) {\n        System.out.println(test(new R<>((I) () -> 0))); \n    }\n}"}, "true");
    }

    public void testRecordPatternTypeInference_011() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n   int a();\n}\n\nrecord R<T>(T a) {}\n\npublic class X {\n\n    private static boolean test(R<? extends I> p) {\n        if (p instanceof R<>(String a)) {\n             return a instanceof String;\n        }\n        return true;\n    }\n\n    public static void main(String argv[]) {\n        System.out.println(test(new R<>((I) () -> 0))); \n    }\n}"}, "----------\n1. ERROR in X.java (at line 10)\n\tif (p instanceof R<>(String a)) {\n\t                 ^\nIncorrect number of arguments for type R<T>; it cannot be parameterized with arguments <>\n----------\n");
    }

    public void testIssue900_1() {
        this.runConformTest(new String[]{"X.java", "class X {\n\trecord Box<T>(T t) {}\n\t// no issues\n\tstatic void test1(Box<String> bo) {\n\t\tif (bo instanceof Box<String>(var s)) {\n\t\t\tSystem.out.println(\"String \" + s);\n\t\t}\n\t}\n\t// no issues\n\tstatic void test2(Box<String> bo) {\n\t    if (bo instanceof Box(var s)) {    // Inferred to be Box<String>(var s)\n\t        System.out.println(\"String \" + s);\n\t    }\n\t}\n\t// \"Errors occurred during the build\": \"info cannot be null\"\n\tstatic void test3(Box<Box<String>> bo) {\n\t    if (bo instanceof Box<Box<String>>(Box(var s))) {        \n\t        System.out.println(\"String \" + s.getClass().toString());\n\t    }\n\t}    \n\t// \"Errors occurred during the build\": \"info cannot be null\"\n\tstatic void test4(Box<Box<String>> bo) {\n\t    if (bo instanceof Box(Box(var s))) {    \n\t        System.out.println(\"String \" + s);\n\t    }\n\t}\n\tpublic static void main(String[] args) {\n\t\tBox<Box<String>> bo = new Box(new Box(\"\"));\n\t\ttest3(bo);\n\t}\n}"}, "String class java.lang.String");
    }

    public void _testIssue900_2() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n\trecord Box<T, U>(T t1, U t2) {}\n\tstatic void test3(Box<Box<String, Integer>, Box<Integer, String>> bo) {\n\t    if (bo instanceof Box<Box<String, Integer>, Box<Integer, String>>(Box(String s1, String s2), Box b1)) {        \n\t        System.out.println(\"String \" + s1.getClass().toString());\n\t    }\n\t}    \n\tpublic static void main(String[] args) {\n\t\tBox<Box<String, Integer>, Box<Integer, String>> bo = new Box(new Box(\"\", Integer.valueOf(0)), new Box(Integer.valueOf(0), \"\"));  \n\t\ttest3(bo);\n\t}\n}"}, "");
    }

    public void testIssue900_3() {
        Map<String, String> options = this.getCompilerOptions(false);
        String old1 = options.get("org.eclipse.jdt.core.compiler.problem.rawTypeReference");
        String old2 = options.get("org.eclipse.jdt.core.compiler.problem.uncheckedTypeOperation");
        options.put("org.eclipse.jdt.core.compiler.problem.rawTypeReference", "ignore");
        options.put("org.eclipse.jdt.core.compiler.problem.uncheckedTypeOperation", "ignore");
        try {
            this.runNegativeTest(new String[]{"X.java", "class X {\n\trecord Box<T, U>(T t, U u) {}\n\tstatic void test3(Box<Box<String>> bo) {\n\t    if (bo instanceof Box<Box<String>>(Box(var s1, String s2), Box b1)) {        \n\t        System.out.println(\"String \" + s1.getClass().toString());\n\t    }\n\t}    \n\tpublic static void main(String[] args) {\n\t\tBox<Box<String, Integer>, Box<Integer, String>> bo = new Box(new Box(\"\", Integer.valueOf(0)), new Box(Integer.valueOf(0), \"\"));\n\t\ttest3(bo);\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tstatic void test3(Box<Box<String>> bo) {\n\t                      ^^^\nIncorrect number of arguments for type X.Box<T,U>; it cannot be parameterized with arguments <String>\n----------\n2. ERROR in X.java (at line 4)\n\tif (bo instanceof Box<Box<String>>(Box(var s1, String s2), Box b1)) {        \n\t                      ^^^\nIncorrect number of arguments for type X.Box<T,U>; it cannot be parameterized with arguments <String>\n----------\n3. ERROR in X.java (at line 10)\n\ttest3(bo);\n\t^^^^^\nThe method test3(X.Box<X.Box<String,Integer>,X.Box<Integer,String>>) is undefined for the type X\n----------\n", "", null, false, options);
        }
        finally {
            options.put("org.eclipse.jdt.core.compiler.problem.rawTypeReference", old1);
            options.put("org.eclipse.jdt.core.compiler.problem.uncheckedTypeOperation", old2);
        }
    }

    public void testRecordPatternMatchException_001() {
        this.runConformTest(new String[]{"X.java", "public class X  {\n\n    public record R(int x) {\n        public int x() {\n         return x < 10 ? 10/x : x;\n        }\n    }\n\n    @SuppressWarnings(\"preview\")\n private static int foo(Object o) {\n        int ret = -1;\n        try {\n            if (o instanceof R(int x)) {\n                ret = 100;\n            }\n        } catch (MatchException e) {\n            ret += 100;\n        }\n          return ret;\n    } \n    public static void main(String argv[]) { \n        System.out.println(X.foo(new R(0))); \n    } \n}"}, "99");
    }

    public void testRecordPatternMatchException_001_1() {
        this.runConformTest(new String[]{"X.java", "public class X  {\n\n    public record R(int x) {\n        public int x() {\n         return x < 10 ? 10/x : x;\n        }\n    }\n\n    @SuppressWarnings(\"preview\")\n private static int foo(Object o) {\n        int ret = -1;\n        try {\n            if (o instanceof R(int x)) {\n                ret = 100;\n            }\n            return 10;\n        } catch (MatchException e) {\n            ret += 100;\n        }\n          return ret;\n    } \n    public static void main(String argv[]) { \n        System.out.println(X.foo(new R(0))); \n    } \n}"}, "99");
    }

    public void testRecordPatternMatchException_002() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\n public record R1(int x) {\n }\n\n @SuppressWarnings(\"preview\")\n public static int bar(Object o) {\n   int res = 100;\n   if (o instanceof R1(int x)) {\n     res = x;\n   }\n     return res; \n }            \n\n public static void main(String argv[]) {\n   R1 r = new R1(0);\n   int result = bar(r);   \n   System.out.println(result);  \n }\n}"}, "0");
    }

    public void testRecordPatternMatchException_003() {
        this.runConformTest(new String[]{"X.java", "record R(int x) {}\n\npublic class X {\n\n @SuppressWarnings(\"preview\")\n private int foo(Object o) {\n   int ret = 10;\n   try {\n     if (o instanceof R(int x)) {\n       ret = x;\n     }\n   } catch (MatchException e) {\n     ret = -1;\n   }\n   return ret;\n }\n\n public static void main(String argv[]) {\n   int res = new X().foo(new R(100));\n   System.out.println(res);\n }\n}"}, "100");
    }

    public void testRecordPatternMatchException_004() {
        this.runConformTest(new String[]{"X.java", "record R(int x) {}\n\npublic class X {\n\n @SuppressWarnings(\"preview\")\n private static int foo(Object o) {\n   int ret = 10;\n   try {\n     if (o instanceof R(int x)) {\n       ret = x;\n     }\n   } catch (MatchException e) {\n     ret = -1;\n   }\n   return ret;\n }\n\n public static void main(String argv[]) {\n   int res = foo(new R(100));\n   System.out.println(res);\n }\n}"}, "100");
    }

    public void testRecordPatternMatchException_005() {
        this.runConformTest(new String[]{"X.java", " public class X {\n\n public record R1(int x) {}\n\n public record R2(int x) {}\n\n public static void main(String argv[]) {\n   R1 r = new R1(0);\n   try {\n     if (r instanceof R1(int x)) {\n       System.out.println(\"matched\");\n     }\n   } catch (MatchException e) {\n     System.out.println(\"caught exception\");\n   }\n\n   if (r instanceof R1(int x)) {\n     System.out.println(\"hello    \");\n   }\n\n   System.out.println(\"done\");\n }\n}"}, "matched\nhello    \ndone");
    }

    public void testRecordPatternMatchException_006() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\n public record R1(int x) {\n   public int x(){\n     return x < 10 ? 10 / x : x;\n   }\n }\n public record R2(R1 r1) {\n   \n }\n\n @SuppressWarnings(\"preview\")\n public static int bar(Object o) {\n   int res = 100;\n   if (o instanceof R2(R1 r1)) {\n     res = r1.x();\n   }\n   System.out.print(false);\n     return res; \n }            \n\n public static void main(String argv[]) {\n   R1 r = new R1(0);\n   int result = bar(r);   \n   System.out.println(result);  \n }      \n}"}, "false100");
    }

    public void testRecordPatternMatchException_007() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\n public record R1(int x) {\n }\n public record R2(R1 r1) {\n   \n }\n\n @SuppressWarnings(\"preview\")\n public static int bar(Object o) {\n   int res = 100;\n   if (o instanceof R2(R1 r1)) {\n     res = r1.x();\n   }\n     return res; \n }\n\n public static void main(String argv[]) {\n   R1 r = new R1(0);\n   int result = bar(r);   \n   System.out.println(result);  \n }      \n}"}, "100");
    }

    public void testRecordPatternMatchException_008() {
        this.runConformTest(new String[]{"X.java", "record R(Integer a) {\n    static R newRecord() {\n        return new R(5);\n    }\n}\n\npublic class X  {\n\n    @SuppressWarnings(\"preview\")\n       private int test(Object o) {\n        int ret = 0;\n        try {\n            switch (o) {\n                case R(Integer a) -> ret =  a;\n                default -> ret =  8;\n            }\n        } catch (MatchException ex) {\n            ret = -1;\n        }\n        return ret;\n    } \n\n    public static void main(String argv[]) {\n        X test = new X();\n        int res = test.test(R.newRecord());\n        System.out.println(res);\n} \n}"}, "5");
    }

    public void testRecordPatternMatchException_009() {
        this.runConformTest(new String[]{"X.java", "record R(Y s) {}\nclass Y{}\npublic class X  extends Y{\n\n    @SuppressWarnings({ \"preview\", \"unused\" })\n public boolean foo(R r) {\n        boolean ret = false; // keep this unused variable to see the error. \n        switch (r) {\n            case R(X s) : {\n             return true;\n            }\n            default : {\n                return false;\n            }\n        }\n    }  \n\n    public static void main(String argv[]) {\n        X x = new X();\n        System.out.println(x.foo(new R(x)));\n    }\n}"}, "true");
    }

    public void testIssue1224_1() {
        this.runNegativeTest(new String[]{"X.java", "interface I {}\nclass Class implements I {}\nrecord Record(I s) {}\npublic class X {\n @SuppressWarnings(\"preview\")\n    public static void foo(Record exp) {\n        switch (exp) {\n            case Record(Class s) -> {break;}\n        }\n    }\n}"}, "----------\n1. ERROR in X.java (at line 7)\n\tswitch (exp) {\n\t        ^^^\nAn enhanced switch statement should be exhaustive; a default label expected\n----------\n");
    }

    public void testIssue1224_2() {
        this.runConformTest(new String[]{"X.java", "interface I {}\nclass Class implements I {}\nrecord Record(I s) {}\npublic class X {\n @SuppressWarnings(\"preview\")\n  public static void foo(Record exp) {\n    switch (exp) {\n      case Record(I s) -> {break;}\n    }\n  }\n\tpublic static void main(String[] args) {\n\t\tfoo(new Record(new Class()));\n\t}\n}"}, "");
    }

    public void testIssue1224_3() {
        this.runNegativeTest(new String[]{"X.java", "interface I {}\nrecord Record(long l) {}\npublic class X {\n @SuppressWarnings(\"preview\")\n    public void foo(Record exp) {\n        switch (exp) {\n            case Record(int i) -> {break;}\n        }\n    }\n}"}, "----------\n1. ERROR in X.java (at line 6)\n\tswitch (exp) {\n\t        ^^^\nAn enhanced switch statement should be exhaustive; a default label expected\n----------\n2. ERROR in X.java (at line 7)\n\tcase Record(int i) -> {break;}\n\t            ^^^^^\nRecord component with type long is not compatible with type int\n----------\n");
    }

    public void testIssue1224_4() {
        this.runNegativeTest(new String[]{"X.java", "record Record<T>(Object o, T x){}\npublic class X {\n @SuppressWarnings(\"preview\")\n    public static void foo(Record<String> rec) {\n        switch (rec) {\n            case Record<String>(Object o, StringBuilder s) -> {break;}\n        }\n    }\n}"}, "----------\n1. ERROR in X.java (at line 5)\n\tswitch (rec) {\n\t        ^^^\nAn enhanced switch statement should be exhaustive; a default label expected\n----------\n2. ERROR in X.java (at line 6)\n\tcase Record<String>(Object o, StringBuilder s) -> {break;}\n\t                              ^^^^^^^^^^^^^^^\nRecord component with type String is not compatible with type StringBuilder\n----------\n");
    }

    public void testIssue1224_5() {
        this.runConformTest(new String[]{"X.java", "record Record<T>(Object o, T x){}\npublic class X {\n @SuppressWarnings(\"preview\")\n    public static void foo(Record<String> rec) {\n        switch (rec) {\n            case Record<String>(Object o, String s) -> {                System.out.println(s);                break;            }\n        }\n    }\n\tpublic static void main(String[] args) {\n\t\tfoo(new Record<String>(args, \"PASS\"));\n\t}\n}"}, "PASS");
    }

    public void testIssue1224_6() {
        this.runConformTest(new String[]{"X.java", "record Record(String s){}\npublic class X {\n @SuppressWarnings(\"preview\")\n    public static void foo(Record rec) {\n        switch (rec) {\n            case Record(String s) when true -> {                System.out.println(s);                break;            }\n            default -> {}        }\n    }\n\tpublic static void main(String[] args) {\n\t\tfoo(new Record(\"PASS\"));\n\t}\n}"}, "PASS");
    }

    public void testIssue1224_7() {
        this.runConformTest(new String[]{"X.java", "interface I<T> {\n    T a();\n}\nrecord Record<T>(T a, T b) implements I<T> {}\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tfoo(new Record(2, 3));\n\t}\n\tstatic void foo(I i) {\n        int res = 0;\n        switch (i) {\n            case Record(Integer a, Integer b) -> {\n                res = a + b;\n                break;\n            }\n            default -> {\n                res = 0;\n                break;\n            }\n        }\n\t\tSystem.out.println(res);\n    }\n}"}, "5");
    }

    public void testIssue1224_8() {
        this.runConformTest(new String[]{"X.java", "record Record(int a) {}\npublic class X {\n @SuppressWarnings(\"preview\")\n  public boolean foo(Record rec) {\n        boolean res = switch (rec) {\n            case Record(int a) : {\n                yield a == 0; \n            }\n        };\n        return res;\n    }\n    public static void main(String argv[]) {\n        X t = new X();\n        if (t.foo(new Record(0))) {\n            System.out.println(\"SUCCESS\");\n            return;\n        }\n        System.out.println(\"FAIL\");\n    }\n}"}, "SUCCESS");
    }

    public void testRecPatExhaust001() {
        this.runConformTest(new String[]{"X.java", "sealed interface I permits A, B, C {}\nfinal class A   implements I {}\nfinal class B   implements I {}\nfinal class C implements I {}\nrecord Box(I i) {}\n\n\npublic class X {\n\n @SuppressWarnings(\"preview\")\n public static int testExhaustiveRecordPatterns(Box box) {\n     return switch (box) {     // Exhaustive!\n         case Box(A a) -> 0;\n         case Box(B b) -> 1;\n         case Box(C c) -> 2;\n    };\n } \n \n    public static void main(String argv[]) {\n     Box b = new Box(new A());\n        System.out.println(testExhaustiveRecordPatterns(b));\n    }\n}"}, "0");
    }

    public void testRecPatExhaust002() {
        this.runNegativeTest(new String[]{"X.java", "sealed interface I permits A, B, C {}\nfinal class A   implements I {}\nfinal class B   implements I {}\nfinal class C implements I {}\nrecord Box(I i) {}\n\n\npublic class X {\n\n @SuppressWarnings(\"preview\")\n public static int testExhaustiveRecordPatterns(Box box) {\n     return switch (box) {     // Not Exhaustive!\n         case Box(A a) -> 0;\n         case Box(B b) -> 1;\n    };\n } \n \n    public static void main(String argv[]) {\n     Box b = new Box(new A());\n        System.out.println(testExhaustiveRecordPatterns(b));\n    }\n}"}, "----------\n1. ERROR in X.java (at line 12)\n\treturn switch (box) {     // Not Exhaustive!\n\t               ^^^\nA switch expression should have a default case\n----------\n");
    }

    public void testRecPatExhaust003() {
        this.runConformTest(new String[]{"X.java", "sealed interface I permits A, B, C {}\nfinal class A   implements I {}\nfinal class B   implements I {}\nfinal class C implements I {}\nsealed interface J permits D, E, F {}\nfinal class D   implements J {}\nfinal class E   implements J {}\nfinal class F implements J {}\nrecord Box(I i, J j) {}\n\n\npublic class X {\n\n @SuppressWarnings(\"preview\")\n public static int testExhaustiveRecordPatterns(Box box) {\n     return switch (box) {     // Not Exhaustive!\n         case Box(A a, D d) -> 0;\n         case Box(A a, E e) -> 10;\n         case Box(A a, F f) -> 20;\n         case Box(B b, D d) -> 1;\n         case Box(B b, E e) -> 11;\n         case Box(B b, F f) -> 21;\n         case Box(C c, D d) -> 2;\n         case Box(C c, E e) -> 12;\n         case Box(C c, F f) -> 22;\n    };\n } \n \n    public static void main(String argv[]) {\n     Box b = new Box(new A(), new D());\n        System.out.println(testExhaustiveRecordPatterns(b));\n    }\n}"}, "0");
    }

    public void testRecPatExhaust004() {
        this.runNegativeTest(new String[]{"X.java", "sealed interface I permits A, B, C {}\nfinal class A   implements I {}\nfinal class B   implements I {}\nfinal class C implements I {}\nsealed interface J permits D, E, F {}\nfinal class D   implements J {}\nfinal class E   implements J {}\nfinal class F implements J {}\nrecord Box(I i, J j) {}\n\n\npublic class X {\n\n @SuppressWarnings(\"preview\")\n public static int testExhaustiveRecordPatterns(Box box) {\n     return switch (box) {     // Not Exhaustive!\n         case Box(A a, D d) -> 0;\n         case Box(A a, E e) -> 0;\n         case Box(A a, F f) -> 0;\n         case Box(B b, D d) -> 1;\n         case Box(B b, E e) -> 1;\n         case Box(B b, F f) -> 1;\n         case Box(C c, D d) -> 2;\n         case Box(C c, F f) -> 2;\n    };\n } \n \n    public static void main(String argv[]) {\n     Box b = new Box(new A(), new D());\n        System.out.println(testExhaustiveRecordPatterns(b));\n    }\n}"}, "----------\n1. ERROR in X.java (at line 16)\n\treturn switch (box) {     // Not Exhaustive!\n\t               ^^^\nA switch expression should have a default case\n----------\n");
    }

    public void testRecPatExhaust005() {
        this.runConformTest(new String[]{"X.java", "sealed interface I permits A, B, C {}\nfinal class A   implements I {}\nfinal class B   implements I {}\nrecord C(int j) implements I {}  // Implicitly final\nrecord Box(I i) {}\n\n\npublic class X {\n\n @SuppressWarnings(\"preview\")\n public static int testExhaustiveRecordPatterns(Box box) {\n     return switch (box) {     // Exhaustive!\n         case Box(A a) -> 0;\n         case Box(B b) -> 1;\n         case Box(C c) -> 2;\n    };\n } \n \n    public static void main(String argv[]) {\n     Box b = new Box(new A());\n        System.out.println(testExhaustiveRecordPatterns(b));\n    }\n}"}, "0");
    }

    public void testRecPatExhaust006() {
        this.runNegativeTest(new String[]{"X.java", "sealed interface I permits A, B, C {}\nfinal class A   implements I {}\nfinal class B   implements I {}\nrecord C(int j) implements I {}  // Implicitly final\nrecord Box(I i) {}\n\npublic class X {\n\n @SuppressWarnings(\"preview\")\n public static int testExhaustiveRecordPatterns(Box box) {\n     return switch (box) {     // Not Exhaustive!\n         case Box(A a) -> 0;\n         case Box(B b) -> 1;\n    };\n } \n \n    public static void main(String argv[]) {\n     Box b = new Box(new A());\n        System.out.println(testExhaustiveRecordPatterns(b));\n    }\n}"}, "----------\n1. ERROR in X.java (at line 11)\n\treturn switch (box) {     // Not Exhaustive!\n\t               ^^^\nA switch expression should have a default case\n----------\n");
    }

    public void testRecPatExhaust007() {
        this.runNegativeTest(new String[]{"X.java", "sealed interface I permits A, B, C {}\nfinal class A   implements I {}\nfinal class B   implements I {}\nrecord C(int j) implements I {}  // Implicitly final\nrecord R(I i, I j) {}\n\n\npublic class X {\n\n @SuppressWarnings(\"preview\")\n private static int testNonExhaustiveRecordPatterns(R p) {\n     return switch (p) {     // Not Exhaustive!\n         case R(A a1, A a2) -> 0;\n         case R(B b1, B b2) -> 1;\n    };\n } \n    public static void main(String argv[]) {\n     R b = new R(new A(), new B());\n        System.out.println(testNonExhaustiveRecordPatterns(b));\n    }\n}"}, "----------\n1. ERROR in X.java (at line 12)\n\treturn switch (p) {     // Not Exhaustive!\n\t               ^\nA switch expression should have a default case\n----------\n");
    }

    public void testRecPatExhaust008() {
        this.runNegativeTest(new String[]{"X.java", "sealed interface I permits A, B, C {}\nfinal class A   implements I {}\nfinal class B   implements I {}\nrecord C(int j) implements I {}  // Implicitly final\nrecord R(I i, I j) {}\n\n\npublic class X {\n\n @SuppressWarnings(\"preview\")\n private static int testNonExhaustiveRecordPatterns(R p) {\n     return switch (p) {     // Not Exhaustive!\n         case R(A a1, A a2) -> 0;\n         case R(B b1, B b2) -> 1;\n         case R(C c1, C c2) -> 2;\n    };\n } \n    public static void main(String argv[]) {\n     R b = new R(new A(), new B());\n        System.out.println(testNonExhaustiveRecordPatterns(b));\n    }\n}"}, "----------\n1. ERROR in X.java (at line 12)\n\treturn switch (p) {     // Not Exhaustive!\n\t               ^\nA switch expression should have a default case\n----------\n");
    }

    public void testRecPatExhaust009() {
        this.runConformTest(new String[]{"X.java", "record Test<T>(Object o, T x) {}\n\npublic class X {\n @SuppressWarnings(\"preview\")\n static int testExhaustiveRecordPattern(Test<String> r) {\n   return switch (r) { // Exhaustive!\n   case Test<String>(Object o, String s) -> 0;\n   };\n }\n\n public static void main(String[] args) {\n   System.out.println(testExhaustiveRecordPattern(new Test<String>(args, null)));\n }\n}"}, "0");
    }

    public void testRecPatExhaust010() {
        this.runConformTest(new String[]{"X.java", "record R(Object t, Object u) {}\n\npublic class X {\n\n    public static int foo(R r) {\n        return \n          switch (r) {\n            case R(String x, Integer y) -> 1;\n            case R(Object x, Integer y) -> 2;\n            case R(Object x, Object y) -> 42;\n        };\n    }\n\n    public static void main(String argv[]) {\n     System.out.println(foo(new R(new String(), new Object())));\n    }\n}"}, "42");
    }

    public void testRecPatExhaust011() {
        this.runNegativeTest(new String[]{"X.java", "sealed interface I {}\n\nfinal class A implements I {}\nfinal class B implements I {}\n\nrecord R(I d) {}\n\npublic class X {\n\n    @SuppressWarnings(\"preview\")\n       public static int foo(R r) {\n        return switch (r) {\n            case R(A x) -> 1;\n        };\n    } \n\n    public static void main(String argv[]) {\n       System.out.println(X.foo(new R(new A())));\n    } \n}"}, "----------\n1. ERROR in X.java (at line 12)\n\treturn switch (r) {\n\t               ^\nA switch expression should have a default case\n----------\n");
    }

    public void testRecPatExhaust012() {
        this.runNegativeTest(new String[]{"X.java", "sealed class C {}\n\nfinal class A extends C {}\nfinal class B extends C {}\n\nrecord R(C c) {}\n\npublic class X {\n\n    @SuppressWarnings(\"preview\")\n       public static int foo(R r) {\n        return switch (r) {\n            case R(A x) -> 1;\n        };\n    } \n\n    public static void main(String argv[]) {\n       System.out.println(X.foo(new R(new A())));\n    } \n}"}, "----------\n1. ERROR in X.java (at line 12)\n\treturn switch (r) {\n\t               ^\nA switch expression should have a default case\n----------\n");
    }

    public void testRecPatExhaust013() {
        this.runNegativeTest(new String[]{"X.java", "sealed class C {}\n\nfinal class A extends C {}\nfinal class B extends C {}\n\nrecord R(C c) {}\n\npublic class X {\n\n    @SuppressWarnings(\"preview\")\n       public static int foo(R r) {\n        return switch (r) {\n            case R(A x) -> 1;\n            case R(B x) -> 1;\n        };\n    } \n\n    public static void main(String argv[]) {\n       System.out.println(X.foo(new R(new A())));\n    } \n}"}, "----------\n1. ERROR in X.java (at line 12)\n\treturn switch (r) {\n\t               ^\nA switch expression should have a default case\n----------\n");
    }

    public void testRecPatExhaust014() {
        this.runNegativeTest(new String[]{"X.java", "sealed interface I {}\nsealed class C {}\nfinal class A extends C implements I {}\nfinal class B extends C implements I {}\n\nrecord R(C c, I i){}\npublic class X { \n\n @SuppressWarnings(\"preview\")\n public static int foo(R r) {\n       return switch (r) {\n            case R(A x, A y) -> 1;\n            case R(A x, B y) -> 42;\n            case R(B x, A y)-> 3;\n            case R(B x, B y)-> 4;\n        };\n    }\n    public static void main(String argv[]) {\n     System.out.println(X.foo(new R(new A(), new B())));\n    }\n}"}, "----------\n1. ERROR in X.java (at line 11)\n\treturn switch (r) {\n\t               ^\nA switch expression should have a default case\n----------\n");
    }

    public void testRecPatExhaust015() {
        this.runConformTest(new String[]{"X.java", "sealed interface I {}\nsealed class C {}\nfinal class A extends C implements I {}\nfinal class B extends C implements I {}\n\nrecord R(C c, I i){}\npublic class X { \n\n    @SuppressWarnings(\"preview\")\n public static int foo(R r) {\n       return switch (r) {\n            case R(A x, A y) -> 1;\n            case R(A x, B y) -> 42;\n            case R(B x, A y) -> 3;\n            case R(B x, B y) -> 4;\n            case R(C x, A y) -> 5;\n            case R(C x, B y) -> 6;\n       };\n    }\n    public static void main(String argv[]) {\n     System.out.println(X.foo(new R(new A(), new B())));\n    }\n}"}, "42");
    }

    public void testRecPatExhaust016() {
        this.runConformTest(new String[]{"X.java", "sealed abstract class C permits A, B {}\nfinal class A extends C {}\nfinal class B extends C {}\nrecord R(C x, A y) {}\n\npublic class X {\n    public static int foo(R r) {\n        return switch (r) {\n            case R(A x, A y) -> 42;\n            case R(B y, A x) -> 2;\n        };\n    }\n\n    public static void main(String argv[]) {\n       System.out.println(X.foo(new R(new A(), new A())));\n    }\n}"}, "42");
    }

    public void testRecPatExhaust017() {
        this.runConformTest(new String[]{"X.java", "sealed interface I permits A, B {}\nsealed interface B extends I {}\n\nfinal class A implements I {}\n\nrecord R1() implements B {}\nrecord R2(I i) {}\n\npublic class X {\n\n    public static int foo(R2 r) {\n        return switch (r) {\n            case R2(A a) -> 42;\n            case R2(B a) -> 1;\n        };\n    }\n\n    public static void main(String argv[]) {\n        System.out.println(X.foo(new R2(new A())));;\n    }\n\n}"}, "42");
    }

    public void testRecPatExhaust018() {
        this.runNegativeTest(new String[]{"X.java", "sealed interface I permits A, B {}\nsealed interface B extends I {}\n\nfinal class A implements I {}\n\nrecord R1() implements B {}\nrecord R2(I i) {}\n\npublic class X {\n\n    public static int foo(R2 r) {\n        return switch (r) {\n            case R2(A a) -> 42;\n        };\n    }\n\n    public static void main(String argv[]) {\n        System.out.println(X.foo(new R2(new A())));;\n    }\n\n}"}, "----------\n1. ERROR in X.java (at line 12)\n\treturn switch (r) {\n\t               ^\nA switch expression should have a default case\n----------\n");
    }

    public void testRecordPatternTypeInference_012() {
        this.runConformTest(new String[]{"X.java", "interface I {}\nrecord R<T>(T t) {}\n\npublic final class X implements I {\n\n    private static boolean test(R<? extends I> r) {\n        if (r instanceof R(X x)) {\n             return (x instanceof X);\n        }\n        return true;\n    }\n\n    public static void main(String argv[]) {\n        System.out.println(test(new R<>(null)));\n    }\n}"}, "true");
    }

    public void testRecordPatternTypeInference_013() {
        this.runConformTest(new String[]{"X.java", "interface I {}\nrecord R<T>(T t) {}\n\npublic class X implements I {\n\n    private static boolean test(R<? extends I> r) {\n        if (r instanceof R(X x)) {\n             return (x instanceof X);\n        }\n        return true;\n    }\n\n    public static void main(String argv[]) {\n        System.out.println(test(new R<>(null)));\n    }\n}"}, "true");
    }

    public void testRecordPatternTypeInference_014() {
        this.runConformTest(new String[]{"X.java", "interface I {}\nrecord R<T>(T t) {}\n\npublic class X {\n\n    private static boolean test(R<? extends I> r) {\n        if (r instanceof R(X x)) {\n             return (x instanceof X);\n        }\n        return true;\n    }\n\n    public static void main(String argv[]) {\n        System.out.println(test(new R<>(null)));\n    }\n}"}, "true");
    }

    public void testRecordPatternTypeInference_015() {
        this.runNegativeTest(new String[]{"X.java", "interface I {}\nrecord R<T>(T t) {}\n\npublic final class X {\n\n    private static boolean test(R<? extends I> r) {\n        if (r instanceof R(X x)) {\n             return (x instanceof X);\n        }\n        return true;\n    }\n\n    public static void main(String argv[]) {\n        System.out.println(test(new R<>(null)));\n        Zork();\n    }\n}"}, "----------\n1. ERROR in X.java (at line 7)\n\tif (r instanceof R(X x)) {\n\t                   ^^^\nRecord component with type capture#2-of ? extends I is not compatible with type X\n----------\n2. ERROR in X.java (at line 15)\n\tZork();\n\t^^^^\nThe method Zork() is undefined for the type X\n----------\n");
    }

    public void testRecordPatternTypeInference_016() {
        this.runNegativeTest(new String[]{"X.java", "interface I {}\nrecord R<T>(T t) {}\n\npublic final class X {\n\n    private static boolean bar(R<? extends I> r) {\n       return switch(r) {\n               case R(X x) -> false;\n               default -> true;\n       };\n    } \n\n    public static void main(String argv[]) {\n        System.out.println(bar(new R<>(null)));\n        Zork();\n    }\n}"}, "----------\n1. ERROR in X.java (at line 8)\n\tcase R(X x) -> false;\n\t       ^^^\nRecord component with type capture#2-of ? extends I is not compatible with type X\n----------\n2. ERROR in X.java (at line 15)\n\tZork();\n\t^^^^\nThe method Zork() is undefined for the type X\n----------\n");
    }

    public void testIssue1328_1() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    public int foo(Object o) {\n        return switch (o) {\n            case String s when false -> 1;\n            case String s when true != true -> 2;\n            case String s when false == true -> 3;\n            case String s when 0 != 0 -> 3;\n            default -> 0;\n        };\n    }\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\tcase String s when false -> 1;\n\t                   ^^^^^\nA case label guard cannot have a constant expression with value as 'false'\n----------\n2. WARNING in X.java (at line 5)\n\tcase String s when true != true -> 2;\n\t                   ^^^^^^^^^^^^\nComparing identical expressions\n----------\n3. ERROR in X.java (at line 5)\n\tcase String s when true != true -> 2;\n\t                   ^^^^^^^^^^^^\nA case label guard cannot have a constant expression with value as 'false'\n----------\n4. ERROR in X.java (at line 6)\n\tcase String s when false == true -> 3;\n\t                   ^^^^^^^^^^^^^\nA case label guard cannot have a constant expression with value as 'false'\n----------\n5. WARNING in X.java (at line 7)\n\tcase String s when 0 != 0 -> 3;\n\t                   ^^^^^^\nComparing identical expressions\n----------\n6. ERROR in X.java (at line 7)\n\tcase String s when 0 != 0 -> 3;\n\t                   ^^^^^^\nA case label guard cannot have a constant expression with value as 'false'\n----------\n");
    }

    public void testIssue1328_2() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    public int foo(Character c) {\n        int result = 0;\n        switch (c) {\n            case Character p when p.equals(\"c\") -> {\n                result = 6;\n            }\n        };\n        return result;\n    }\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\tswitch (c) {\n\t        ^\nAn enhanced switch statement should be exhaustive; a default label expected\n----------\n");
    }

    public void testGH1792() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    private record R(Object o) {}\n    static void f(R [] rs) {\n        int i = 0;\n        while (rs[i++] instanceof R(String o)) {\n            System.out.println(o);\n        }\n    }\n    public static void main(String [] args) {\n    \tR [] rs = { new R(\"So\"), new R(\"far\"), new R(\"so\"), new R(\"good!\"), null };\n    \tf(rs);\n    }\n}\n"}, "So\nfar\nso\ngood!");
    }

    public void testIssue1336_1() {
        this.runConformTest(new String[]{"X.java", "record R<T> ( T t) {}\npublic final class X {\nprivate static boolean foo(R<?> r) {\n\tif (r instanceof R(String s)) {\n\t\treturn true;\n\t}\n\treturn false;\n}\n\npublic static void main(String argv[]) {\n\tSystem.out.println(foo(new R<>(new String(\"hello\"))));\n}\n\n}\n"});
    }

    public void testIssue1336_2() {
        this.runConformTest(new String[]{"X.java", "sealed interface I<TI> {}\nsealed interface J<TJ> {}\nclass A {}\nrecord R<TR>(TR t) implements I<TR>, J<TR>{}\n\npublic class X<TX extends I<? extends A> & J<? extends A>> {\n\n\tpublic boolean foo(TX t) {\n\t\treturn switch(t) {\n\t\t\tcase R(A a) -> true;\n\t\t\tdefault -> false;\n\t\t};\n\t}\n\n\tpublic static void main(String argv[]) {\n\t   System.out.println(new X<R<? extends A>>().foo(new R<>(new A())));\n\t}\n}\n"});
    }

    public void testIssue1732_01() {
        this.runNegativeTest(new String[]{"X.java", "record R(int x, int y) {}\n\npublic class X {\n\n\tpublic int foo(R r) {\n\t\treturn switch (r) {\n\t\t\tcase R() -> 0;\n\t\t};\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\treturn switch (r) {\n\t               ^\nA switch expression should have a default case\n----------\n2. ERROR in X.java (at line 7)\n\tcase R() -> 0;\n\t     ^^^\nRecord pattern should match the signature of the record declaration\n----------\n");
    }

    public void testIssue1732_02() {
        this.runNegativeTest(new String[]{"X.java", "record R(int x, int y) {}\n\npublic class X {\n\n\tpublic int foo(R r) {\n\t\treturn switch (r) {\n\t\t\tcase R(int x) -> 0;\n\t\t};\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\treturn switch (r) {\n\t               ^\nA switch expression should have a default case\n----------\n2. ERROR in X.java (at line 7)\n\tcase R(int x) -> 0;\n\t     ^^^^^^^^\nRecord pattern should match the signature of the record declaration\n----------\n");
    }

    public void testIssue1732_03() {
        this.runNegativeTest(new String[]{"X.java", "record R(int x, int y) {}\n\npublic class X {\n\n\tpublic int foo(R r) {\n\t\treturn switch (r) {\n\t\t\tcase R(int x, int y, int z) -> 0;\n\t\t};\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\treturn switch (r) {\n\t               ^\nA switch expression should have a default case\n----------\n2. ERROR in X.java (at line 7)\n\tcase R(int x, int y, int z) -> 0;\n\t     ^^^^^^^^^^^^^^^^^^^^^^\nRecord pattern should match the signature of the record declaration\n----------\n");
    }

    public void testGHI1788() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\n  final static class Entry<K,V> {\n    K key;\n    V value;\n\n    public Entry(K key, V value) {\n      this.key = key;\n      this.value = value;\n    }\n\n    public K key() { return key; }\n    public V value() { return value; }\n    public void value(V value) { this.value = value; }\n    @Override\n    public String toString() {\n    \treturn \"Key = \" + key + \" Value = \" + value;\n    }\n  }\n\n  sealed interface I<V> {}\n  record A<V>(V value) implements I<V> {}\n  record B<V>(V value) implements I<V> {}\n\n  private static <K, V> Entry<K,V> foo(Entry<K, I<V>> entry) {\n    return new Entry<>(entry.key(), switch (entry.value()) {\n      case A<V>(V value) -> {\n        entry.value(new B<>(value));\n        yield value;\n      }\n      case B<V>(V value) -> value;\n    });\n  }\n\n  public static void main(String[] args) {\n\t  Entry<String, I<String>> entry = new Entry<>(\"KEY\", new A<>(\"VALUE\"));\n\t  System.out.println(entry);\n\t  System.out.println(foo(entry));\n\t  System.out.println(entry);\n  }\n}\n"}, "Key = KEY Value = A[value=VALUE]\nKey = KEY Value = VALUE\nKey = KEY Value = B[value=VALUE]");
    }

    public void testGH1835_minimal() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\ttry {\n\t\t\tString s = switch (new Object()) {\n\t\t\tcase Integer i  -> \"i\";\n\t\t\tcase String y  -> \"y\";\n\t\t\tdefault -> {\n\t\t\t\ttry {\n\t\t\t\t\tthrow new Exception();\n\t\t\t\t} catch (Exception e) {\n\t\t\t\t\tthrow new RuntimeException(\"Expected\");\n\t\t\t\t}\n\t\t\t}\n\t\t\t};\n\t\t} catch (RuntimeException e) {\n\t\t\tSystem.out.print(\"Caught runtime Exception \");\n\t\t\tif (e.getMessage().equals(\"Expected\"))\n\t\t\t\tSystem.out.println (\"(expected)\");\n\t\t\telse\n\t\t\t \tSystem.out.println (\"(unexpected!!!)\");\n\t\t}\n\t}\n}\n"}, "Caught runtime Exception (expected)");
    }

    public void testGH1835() {
        this.runConformTest(new String[]{"Reproducer.java", "public class Reproducer {\n\n    public class DataX {\n        String data = \"DataX\";\n    }\n\n    public class DataY {\n        String data1 = \"DataY\";\n    }\n\n    record X(DataX data) {}\n    record Y(DataY data) {}\n\n    Reproducer() {\n        DataX dataX = new DataX();\n        DataY dataY = new DataY();\n        X x = new X(dataX);\n        Y y = new Y(dataY);\n\n        foo(x);\n        foo(y);\n        foo(null);\n        foo(\"\");\n    }\n\n    void foo(Object obj) {\n        String s = switch (obj) {\n            case X(var x) when x != null -> x.data;\n            case Y(var x) when x != null -> x.data1;\n            case null, default -> {\n                try {\n                    if (obj == null) yield \"switch on null\";\n                    throw new Exception();\n                } catch (Exception e) {\n                    yield \"default threw exception\";\n                }\n            }\n        };\n        System.out.println(\"s = \" + s);\n    }\n    public static void main(String[] args) {\n\t\tnew Reproducer();\n\t}\n\n}\n"}, "s = DataX\ns = DataY\ns = switch on null\ns = default threw exception");
    }

    public void testGH1796_full() {
        this.runConformTest(new String[]{"com/acme/Reproducer.java", "package com.acme;\n\nimport java.util.Objects;\n\nimport com.acme.Reproducer.Expression.ConstantExpression;\nimport com.acme.Reproducer.Expression.PlusExpression;\nimport com.acme.Reproducer.Expression.TimesExpression;\n\npublic class Reproducer {\n\n  public static void main(String[] args) {\n    SExpressionPrinter printer = new SExpressionPrinter21Record();\n    Expression twoPlusThree = new PlusExpression(new ConstantExpression(2), new ConstantExpression(3));\n    System.out.println(printer.print(twoPlusThree));\n  }\n\n  interface SExpressionPrinter {\n\n    String print(Expression e);\n\n  }\n\n  static final class SExpressionPrinter21Record implements SExpressionPrinter {\n\n    @Override\n    public String print(Expression e) {\n      Objects.requireNonNull(e);\n      StringBuilder buffer = new StringBuilder();\n      printTo(e, buffer);\n      return buffer.toString();\n    }\n\n    private void printTo(Expression e, StringBuilder buffer) {\n      if (e instanceof ConstantExpression(int i)) {\n        buffer.append(i);\n      } else {\n        buffer.append('(');\n        if (e instanceof PlusExpression(Expression a, Expression b)) {\n          buffer.append(\"+ \");\n          printTo(a, buffer);\n          buffer.append(' ');\n          printTo(b, buffer);\n        }\n        if (e instanceof TimesExpression(Expression a, Expression b)) {\n          buffer.append(\"* \");\n          printTo(a, buffer);\n          buffer.append(' ');\n          printTo(b, buffer);\n        }\n        buffer.append(')');\n      }\n    }\n  }\n\n  sealed interface Expression {\n\n    int evaluate();\n\n    record ConstantExpression(int i) implements Expression {\n\n      @Override\n      public int evaluate() {\n        return i;\n      }\n\n    }\n\n    record PlusExpression(Expression a, Expression b) implements Expression {\n\n      @Override\n      public int evaluate() {\n        return Math.addExact(a.evaluate(), b.evaluate());\n      }\n\n    }\n\n    record TimesExpression(Expression a, Expression b) implements Expression {\n\n      @Override\n      public int evaluate() {\n        return Math.multiplyExact(a.evaluate(), b.evaluate());\n      }\n\n    }\n\n  }\n\n}\n"}, "(+ 2 3)");
    }

    public void testGH1796_reporter_reduced() {
        this.runConformTest(new String[]{"com/acme/Reproducer.java", "package com.acme;\n\nimport com.acme.Reproducer.Expression.ConstantExpression;\n\npublic class Reproducer {\n\n  public static void main(String[] args) {\n    SExpressionPrinter printer = new SExpressionPrinter();\n    Expression constant = new ConstantExpression(2);\n    System.out.println(printer.print(constant));\n  }\n\n  static final class SExpressionPrinter {\n\n    public String print(Expression e) {\n      StringBuilder buffer = new StringBuilder();\n      printTo(e, buffer);\n      return buffer.toString();\n    }\n\n    private void printTo(Expression e, StringBuilder buffer) {\n      if (e instanceof ConstantExpression(int i)) {\n        buffer.append(i);\n      }\n    }\n  }\n\n  sealed interface Expression {\n\n    record ConstantExpression(int i) implements Expression {\n\n    }\n\n  }\n\n}\n"}, "2");
    }

    public void testGH1977_method() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\n\trecord R(int x) {\n\t\tpublic int x() {\n\t\t\treturn 100 / this.x;\n\t\t}\n\t}\n\n\tpublic static void main(String[] args) {\n\t\ttry {\n\t\t\tif (new R(0) instanceof R(int i)) {\n\t\t\t}\n\t\t} catch (Throwable t) {\n\t\t\tSystem.out.println(\"Caught: \" + t.getClass().getName());\n\t\t}\n\t\tif (new R(10) instanceof R(int i)) {\n\n\t\t}\n\t}\n}\n"}, "Caught: java.lang.MatchException");
    }

    public void testGH1977_instance_initializer() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\n\t{\n\t\tif (new R(0) instanceof R(int i)) {\n\n\t\t}\n\t}\n\n\trecord R(int x) {\n\t\tpublic int x() {\n\t\t\treturn 100 / this.x;\n\t\t}\n\t}\n\n\tpublic static void main(String[] args) {\n\t\ttry {\n\t\t\tnew X();\n\t\t} catch (MatchException me) {\n\t\t\tSystem.out.println(\"Caught MatchException\");\n\t\t}\n\t}\n}\n"}, "Caught MatchException");
    }

    public void testGH1977_instance_field() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\n\tboolean b = new R(0) instanceof R(int i);\n\n\trecord R(int x) {\n\t\tpublic int x() {\n\t\t\treturn 100 / this.x;\n\t\t}\n\t}\n\n\tpublic static void main(String[] args) {\n\t\ttry {\n\t\t\tnew X();\n\t\t} catch (MatchException me) {\n\t\t\tSystem.out.println(\"Caught MatchException\");\n\t\t}\n\t}\n}\n"}, "Caught MatchException");
    }

    public void testGH1977_constructor() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\n\tX() {\n\t\tif (new R(0) instanceof R(int i)) {\n\n\t\t}\n\t}\n\n\trecord R(int x) {\n\t\tpublic int x() {\n\t\t\treturn 100 / this.x;\n\t\t}\n\t}\n\n\tpublic static void main(String[] args) {\n\t\ttry {\n\t\t\tnew X();\n\t\t} catch (MatchException me) {\n\t\t\tSystem.out.println(\"Caught MatchException\");\n\t\t}\n\t}\n}\n"}, "Caught MatchException");
    }

    public void testGH1977_static_initializer() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\n\tclass Y {\n\t\tstatic {\n\t\t\tif (new R(0) instanceof R(int i)) {\n\n\t\t\t}\n\t\t}\n\t}\n\n\trecord R(int x) {\n\t\tpublic int x() {\n\t\t\treturn 100 / this.x;\n\t\t}\n\t}\n\n\tpublic static void main(String[] args) {\n\t\ttry {\n\t\t\tnew X().new Y();\n\t\t} catch (ExceptionInInitializerError me) {\n\t\t\tSystem.out.println(\"ExceptionInInitializerError caused by \" + me.getCause().getClass().getName());\n\t\t}\n\t}\n}\n"}, "ExceptionInInitializerError caused by java.lang.MatchException");
    }

    public void testGH1977_static_field() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\n\tclass Y {\n\t\tstatic boolean b = new R(0) instanceof R(int i);\n\t}\n\n\trecord R(int x) {\n\t\tpublic int x() {\n\t\t\treturn 100 / this.x;\n\t\t}\n\t}\n\n\tpublic static void main(String[] args) {\n\t\ttry {\n\t\t\tnew X().new Y();\n\t\t} catch (ExceptionInInitializerError me) {\n\t\t\tSystem.out.println(\"ExceptionInInitializerError caused by \" + me.getCause().getClass().getName());\n\t\t}\n\t}\n}\n"}, "ExceptionInInitializerError caused by java.lang.MatchException");
    }

    public void testIssue300() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\n\trecord Outer(Middle m1, Middle m2) {\n\n\t}\n\n\trecord Middle (Inner i1, Inner i2) {\n\n\t}\n\n\trecord Inner(String s, Long l, int k) {\n\n\t}\n\n\tpublic static void main(String[] args) {\n\t\tOuter o = new Outer(new Middle(new Inner(\"Hello\", 11L, 22), new Inner(\" World\", 22L, 44)), new Middle(new Inner(\" How is\", 33L, 66), new Inner(\" life?\", 44L, 88)));\n\t\tif (o instanceof Outer(Middle(Inner(String s1, Long l1, int i1), Inner(String s2, Long l2, int i2)), Middle(Inner(String s3, Long l3, int i3), Inner(String s4, Long l4, int i4)))) {\n\t\t\tSystem.out.println(s1 + s2 + s3 + s4);\n\t\t\tSystem.out.println(l1 + l2 + l3 + l4);\n\t\t\tSystem.out.println(i1 + i2 + i3 + i4);\n\t\t}\n\t}\n}\n"}, "Hello World How is life?\n110\n220");
    }

    public void testIssue1804() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\trecord Paper(int color) {}\n\trecord Box<T>(T a) {}\n\tpublic static void main(String argv[]) {\n\t\tfoo(null, null);\n\t}\n\tpublic static void foo(String abc, String def) {\n\t\tBox<?> p = new Box<>(new Paper(0));\n\t\tboolean b = false;\n\t\tswitch (p) {\n\t\t\tcase Box(Paper a) -> {\n\t\t\t\tb = true;\n\t\t\t\tbreak;\n\t\t\t}\n\t\t\tdefault -> {\n\t\t\t\tb = false;\n\t\t\t\tbreak;\n\t\t\t}\n\t\t}\n\t\tSystem.out.println(b);\n\t}\n}\n"}, "true");
    }

    public void testIssue1804_0() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\trecord Paper(int color) {}\n\trecord Box<T>(T a) {}\n\tpublic static void main(String[] args) {\n\t\tBox<?> b = new Box<>(null);\n\t\tboolean res = b instanceof Box(Paper a);\n\t\tif (res) {\n\t\t\tSystem.out.println(\"res is true\");\n\t\t} else {\n\t\t\tSystem.out.println(\"res is false\");\n\t\t}\n\t}\n}\n"}, "res is false");
    }

    public void testIssue1804_1() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\trecord Paper(int color) {}\n\trecord Box<T>(T a) {}\n\tpublic static void main(String[] args) {\n\t\tBox<?> b = new Box<>(new Paper(0));\n\t\tboolean res = b instanceof Box(Paper a);\n\t\tif (res) {\n\t\t\tSystem.out.println(\"res is true\");\n\t\t} else {\n\t\t\tSystem.out.println(\"res is false\");\n\t\t}\n\t}\n}\n"}, "res is true");
    }

    public void testIssue1804_2() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\trecord Paper(int color) {}\n\trecord Box<T>(T a) {}\n\tpublic static void main(String[] args) {\n\t\tBox<?> b = new Box<>(new Paper(0));\n\t\tboolean res = b instanceof Box(Paper a) && a == null;\n\t\tif (res) {\n\t\t\tSystem.out.println(\"res is true\");\n\t\t} else {\n\t\t\tSystem.out.println(\"res is false\");\n\t\t}\n\t}\n}\n"}, "res is false");
    }

    public void testIssue1804_3() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\trecord Paper(int color) {}\n\trecord Box<T>(T a) {}\n\tpublic static void main(String[] args) {\n\t\tBox b = new Box<>(null);\n\t\tSystem.out.println(b instanceof Box(Paper a));\n\t\tSystem.out.println(b instanceof Box(Object a));\n\t}\n}\n"}, "false\ntrue");
    }

    public void testIssue1804_4() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\trecord Paper(int color) {}\n\trecord Box<T>(T a) {}\n\tpublic static void main(String argv[]) {\n\t\tfoo(null, null);\n\t}\n\tpublic static void foo(String abc, String def) {\n\t\tBox<?> p = new Box<>(new Paper(0));\n\t\tboolean b = false;\n\t\tswitch (p) {\n\t\t\tcase Box(Paper a) -> {\n\t\t\t\tb = true;\n\t\t\t\tbreak;\n\t\t\t}\n\t\t\tdefault -> {\n\t\t\t\tb = false;\n\t\t\t\tbreak;\n\t\t\t}\n\t\t}\n\t\tSystem.out.println(b);\n\t}\n}\n"}, "true");
    }

    public void testIssue1804_5() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\trecord Paper(int color) {}\n\trecord Box<T>(T a) {}\n\tpublic static void main(String argv[]) {\n\t\tfoo(null, null);\n\t}\n\tpublic static void foo(String abc, String def) {\n\t\tBox<?> p = new Box<>(null);\n\t\tboolean b = false;\n\t\tswitch (p) {\n\t\t\tcase Box(Paper a) -> {\n\t\t\t\tb = true;\n\t\t\t\tbreak;\n\t\t\t}\n\t\t\tdefault -> {\n\t\t\t\tb = false;\n\t\t\t\tbreak;\n\t\t\t}\n\t\t}\n\t\tSystem.out.println(b);\n\t}\n}\n"}, "false");
    }

    public void testIssue1804_6() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\trecord Paper(int color) {}\n\trecord Box<T>(T a, T b) {}\n\tpublic static void main(String argv[]) {\n\t\tfoo(null, null);\n\t}\n\tpublic static void foo(String abc, String def) {\n\t\tBox<?> p = new Box<>(new Paper(0), new Paper(1));\n\t\tboolean c = false;\n\t\tswitch (p) {\n\t\t\tcase Box(Paper a, Paper b) -> {\n\t\t\t\tSystem.out.println(a.color);\n\t\t\t\tSystem.out.println(b.color);\n\t\t\t\tc = true;\n\t\t\t\tbreak;\n\t\t\t}\n\t\t\tdefault -> {\n\t\t\t\tc = false;\n\t\t\t\tbreak;\n\t\t\t}\n\t\t}\n\t\tSystem.out.println(c);\n\t}\n}\n"}, "0\n1\ntrue");
    }

    public void testIssue1804_7() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\trecord Paper(int color) {}\n\trecord Box<T>(T a) {}\n\tpublic static void main(String[] args) {\n\t\tBox<?> b = new Box<>(new Paper(0));\n\t\tboolean res = b instanceof Box box;\n\t\tif (res) {\n\t\t\tSystem.out.println(\"res is true\");\n\t\t} else {\n\t\t\tSystem.out.println(\"res is false\");\n\t\t}\n\t}\n}\n"}, "res is true");
    }

    public void testIssue1804_8() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\trecord Paper(int color) {}\n\trecord Box<T>(T a) {}\n\tpublic static void main(String[] args) {\n\t\tBox<?> b = new Box<>(new Paper(0));\n\t\tboolean res = b instanceof Box(Paper paper) && paper.color != 0;\n\t\tif (res) {\n\t\t\tSystem.out.println(\"res is true\");\n\t\t} else {\n\t\t\tSystem.out.println(\"res is false\");\n\t\t}\n\t}\n}\n"}, "res is false");
    }

    public void testIssue1804_9() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\trecord Paper(int color) {}\n\trecord Box<T>(T a) {}\n\tpublic static void main(String[] args) {\n\t\tboolean res = new Box<>(new Paper(0)) instanceof Box(Paper(int c));\n\t\tif (res) {\n\t\t\tSystem.out.println(\"res is true\");\n\t\t} else {\n\t\t\tSystem.out.println(\"res is false\");\n\t\t}\n\t}\n}\n"}, "res is true");
    }

    public void testIssue1804_10() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\trecord Paper(int color) {}\n\trecord Box<T>(T a) {}\n\tpublic static void main(String[] args) {\n\t\tboolean res = new Box<>(new Paper(0)) instanceof Box(Paper(int c)) && c == 0;\n\t\tif (res) {\n\t\t\tSystem.out.println(\"res is true\");\n\t\t} else {\n\t\t\tSystem.out.println(\"res is false\");\n\t\t}\n\t}\n}\n"}, "res is true");
    }

    public void testIssue1985() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\n\trecord R(int x) {\n\t\tpublic int x() {\n\t\t\treturn 100 / this.x;\n\t\t}\n\t}\n\n\tpublic static void main(String[] args) {\n\t\ttry {\n\t\t\tboolean b = new R(0) instanceof R(int i);\n\t\t} catch (Throwable t) {\n\t\t\tSystem.out.println(t.getClass().getName());\n\t\t}\n\t}\n}\n"}, "java.lang.MatchException");
    }

    public void testIssue1985_2() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\n\tboolean b = new R(0) instanceof R(int i);\n\trecord R(int x) {\n\t\tpublic int x() {\n\t\t\treturn 100 / this.x;\n\t\t}\n\t}\n\n\tpublic static void main(String[] args) {\n            try {\n        \tnew X();\n            } catch (Throwable t) {\n        \tSystem.out.println(t.getClass().getName());\n            }\n\t}\n}\n"}, "java.lang.MatchException");
    }

    public void testIssue2001() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\trecord R1(Long color) {}\n\trecord R2(short color) {}\n\n\tpublic static void main(String[] args) {\n\t\tObject o = new R1(10L);\n\t\tif (o instanceof R1(long d)) {\n\t\t\tSystem.out.println(d);\n\t\t}\n\t\tif (o instanceof R2(Short d)) {\n\t\t\tSystem.out.println(d);\n\t\t}\n\t\tif (o instanceof R2(int d)) {\n\t\t\tSystem.out.println(d);\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tif (o instanceof R1(long d)) {\n\t                    ^^^^^^\nRecord component with type Long is not compatible with type long\n----------\n2. ERROR in X.java (at line 10)\n\tif (o instanceof R2(Short d)) {\n\t                    ^^^^^^^\nRecord component with type short is not compatible with type Short\n----------\n3. ERROR in X.java (at line 13)\n\tif (o instanceof R2(int d)) {\n\t                    ^^^^^\nRecord component with type short is not compatible with type int\n----------\n");
    }

    public void testIssue1999() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unnecessaryTypeCheck", "error");
        this.runNegativeTest(true, new String[]{"X.java", "interface I {\n}\n\nfinal class A implements I {\n}\n\nfinal class B implements I {\n}\n\nrecord R(I x, I y) {\n}\n\npublic class X {\n\tpublic static boolean foo(R r) {\n\t\tif (r instanceof R(A a1, A a2))  // don't warn here.\n\t\t\treturn true;\n\t\tA a = null;\n\t\tif (a instanceof A) {} // warn here\n\t\tif (a instanceof A a1) {} // don't warn here\n\t\treturn false;\n\t}\n\n\tpublic static void main(String argv[]) {\n\t\tSystem.out.println(X.foo(new R(new A(), new A())));\n\t\tSystem.out.println(X.foo(new R(new A(), new B())));\n\t}\n}\n"}, null, options, "----------\n1. ERROR in X.java (at line 18)\n\tif (a instanceof A) {} // warn here\n\t    ^^^^^^^^^^^^^^\nThe expression of type A is already an instance of type A\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void testIssue2007() {
        this.runConformTest(new String[]{"X.java", "record R<T>(T t) {}\npublic class X<T> {\n    public boolean foo(R<T> r) {\n        return (r instanceof R<?>(X x));\n    }\n    public static void main(String argv[]) {\n    \tSystem.out.println(new X<>().foo(new R<>(new X())));\n    }\n}\n"}, "true");
    }

    public void testIssue2007_2() {
        this.runConformTest(new String[]{"X.java", "record R<T>(T t) {}\npublic class X<T> {\n    public boolean foo(R<T> r) {\n         return (r instanceof R<? extends T>(X x));\n    }\n    public static void main(String argv[]) {\n    \tSystem.out.println(new X<>().foo(new R<>(new X())));\n    }\n}\n"}, "true");
    }

    public void testIssue2007_3() {
        this.runConformTest(new String[]{"X.java", "record R<T>(T t) {}\npublic class X<T> {\n    public boolean foo(R<T> r) {\n    \treturn switch (r) {\n    \t\tcase R<?>(X x) -> true;\n    \t\tdefault -> false;\n    \t};\n    }\n    public static void main(String argv[]) {\n    \tSystem.out.println(new X<>().foo(new R<>(new X())));\n    }\n}\n"}, "true");
    }

    public void testIssue2007_4() {
        this.runConformTest(new String[]{"X.java", "record R<T>(T t) {}\npublic class X<T> {\n    public boolean foo(R<T> r) {\n    \treturn switch (r) {\n    \t\tcase R<? extends T>(X x) -> true;\n    \t\tdefault -> false;\n    \t};\n    }\n    public static void main(String argv[]) {\n    \tSystem.out.println(new X<>().foo(new R<>(new X())));\n    }\n}\n"}, "true");
    }

    public void testIssue2007_5() {
        this.runConformTest(new String[]{"X.java", "record R<T>(T t) {}\npublic class X<T> {\n    public boolean foo(R<T> r) {\n    \treturn switch (r) {\n    \t\tcase R<? extends T>(Integer i) -> true;\n    \t\tdefault -> false;\n    \t};\n    }\n    public static void main(String argv[]) {\n    \tSystem.out.println(new X<>().foo(new R<>(new X())));\n    }\n}\n"}, "false");
    }

    public void testIllegalFallThrough() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\trecord Point (int x, int y) {}\n\n  static void foo(Object o) {\n    switch (o) {\n      case Integer i_1: System.out.println(\"Integer\");\n      case Point(int a, int b) : System.out.println(\"String\");\n      default: System.out.println(\"Object\");\n    }\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tcase Point(int a, int b) : System.out.println(\"String\");\n\t^^^^^^^^^^^^^^^^^^^^^^^^\nIllegal fall-through to a pattern\n----------\n");
    }

    public void testIllegalModifiers() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\trecord Point (int x, int y) {}\n\n\tstatic void foo(Object o) {\n\t    if (o instanceof public String) {}   // javac error, ecj error\n\t    if (o instanceof public String s) {} // javac error, ecj error\n\t    if (o instanceof public Point(int a, final int b)) {} // javac error, ECJ - NO ERROR!\n\t    if (o instanceof Point(public int a, final int b)) {} // javac error, ecj error\n\n\t    if (o instanceof final String) {}  // javac error, ecj error\n\t    if (o instanceof final String s) {} // javac NO error, ecj NO error\n\t    if (o instanceof final Point(int a, int b)) {} // javac NO error, ecj NO error\n\n\t    switch (o) {\n\t      case public Point(int a, int b) : System.out.println(\"String\"); // javac error, ECJ: NO ERROR!\n\t      case public Object o1: System.out.println(\"Default\"); // both compilers error\n\t    }\n\t    switch (o) {\n\t      case final Point(int a, int b) : System.out.println(\"String\"); // NO ERROR in either\n\t      case final Object o2: System.out.println(\"Default\");\n\t    }\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tif (o instanceof public String) {}   // javac error, ecj error\n\t                 ^^^^^^^^^^^^^\nSyntax error, modifiers are not allowed here\n----------\n2. ERROR in X.java (at line 6)\n\tif (o instanceof public String s) {} // javac error, ecj error\n\t                               ^\nIllegal modifier for the pattern variable s; only final is permitted\n----------\n3. ERROR in X.java (at line 7)\n\tif (o instanceof public Point(int a, final int b)) {} // javac error, ECJ - NO ERROR!\n\t                 ^^^^^^\nSyntax error, modifiers are not allowed here\n----------\n4. ERROR in X.java (at line 8)\n\tif (o instanceof Point(public int a, final int b)) {} // javac error, ecj error\n\t                                  ^\nIllegal modifier for the pattern variable a; only final is permitted\n----------\n5. ERROR in X.java (at line 10)\n\tif (o instanceof final String) {}  // javac error, ecj error\n\t                 ^^^^^^^^^^^^\nSyntax error, modifiers are not allowed here\n----------\n6. ERROR in X.java (at line 12)\n\tif (o instanceof final Point(int a, int b)) {} // javac NO error, ecj NO error\n\t                 ^^^^^\nSyntax error, modifiers are not allowed here\n----------\n7. ERROR in X.java (at line 15)\n\tcase public Point(int a, int b) : System.out.println(\"String\"); // javac error, ECJ: NO ERROR!\n\t     ^^^^^^\nSyntax error, modifiers are not allowed here\n----------\n8. ERROR in X.java (at line 16)\n\tcase public Object o1: System.out.println(\"Default\"); // both compilers error\n\t                   ^^\nIllegal modifier for the pattern variable o1; only final is permitted\n----------\n9. ERROR in X.java (at line 19)\n\tcase final Point(int a, int b) : System.out.println(\"String\"); // NO ERROR in either\n\t     ^^^^^\nSyntax error, modifiers are not allowed here\n----------\n");
    }

    public void testIssue2119() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\trecord Point (int x, int y) {}\n\n\tstatic void foo(Object o) {\n\t\tif (o instanceof Point [](int x, int y)) {}\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tif (o instanceof Point [](int x, int y)) {}\n\t                 ^^^^^^^^^^^^^^^^^^^^^^\nA record pattern may not specify dimensions\n----------\n");
    }

    public void testIssue2119_2() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\trecord Point (int x, int y) {}\n\n\tstatic void foo(Object o) {\n\t\tif (o instanceof Point (int x, int y) []) {}\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tif (o instanceof Point (int x, int y) []) {}\n\t                                      ^^\nSyntax error on tokens, delete these tokens\n----------\n");
    }

    public void testIssue3066() {
        this.runNegativeTest(new String[]{"X.java", "public record X<T>(int x) {\n\tpublic static void main(String[] args) {\n\t\tObject o = new Object();\n\t\tswitch (o) {\n\t\tcase X<String>(int x):\n\t\tdefault:\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tcase X<String>(int x):\n\t     ^^^^^^^^^^^^^^^^\nType Object cannot be safely cast to X<String>\n----------\n");
    }

    public void testIssue3066_notApplicable() {
        this.runNegativeTest(new String[]{"X.java", "public record X(int x) {\n\tpublic static void main(String[] args) {\n\t\tjava.io.Serializable o = \"\";\n\t\tswitch (o) {\n\t\tcase X(int x):\n\t\tdefault:\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tcase X(int x):\n\t     ^^^^^^^^\nType mismatch: cannot convert from Serializable to X\n----------\n");
    }

    public void testIssue3173() {
        this.runConformTest(new String[]{"RecordPatternDemo.java", "public class RecordPatternDemo {\n    public static void main(String[] args) {\n        record Box<T>(T contents) { }\n\n        Box<Box<String>> doubleBoxed = new Box<>(new Box<>(\"Contents\"));\n        String unboxed = switch (doubleBoxed) {\n            case Box(Box(String s)) -> s;\n        };\n\n        System.out.println(unboxed);\n    }\n}\n"}, "Contents");
    }

    public void testIssue3173_2() {
        this.runConformTest(new String[]{"RecordPatternDemo.java", "public class RecordPatternDemo {\n    public static void main(String[] args) {\n        record Box<T>(T contents) { }\n\n        Box<Box<String>> doubleBoxed = new Box<>(new Box<>(\"Contents\"));\n        String unboxed = switch (doubleBoxed) {\n            case Box(Box(String s)) -> s;\n            default -> \"default\";\n        };\n\n        System.out.println(unboxed);\n    }\n}\n"}, "Contents");
    }

    public void testJEP440Example() {
        this.runNegativeTest(new String[]{"X.java", "class A {\n}\n\nclass B extends A {\n}\n\nsealed interface I permits C, D {\n}\n\nfinal class C implements I {\n}\n\nfinal class D implements I {\n}\n\nrecord Pair<T>(T x, T y) {\n}\n\npublic class X {\n\tstatic Pair<A> p1;\n\tstatic Pair<I> p2;\n\n\tpublic static void main(String[] args) {\n\t\t// As of Java 21\n\t\tswitch (p1) {                 // Error!\n\t\t    case Pair<A>(A a, B b) -> System.out.println();\n\t\t    case Pair<A>(B b, A a) -> System.out.println();\n\t\t}\n\n\t\tswitch (p2) {\n\t\t    case Pair<I>(I i, C c) -> System.out.println();\n\t\t    case Pair<I>(I i, D d) -> System.out.println();\n\t\t}\n\n\t\tswitch (p2) {\n\t\t    case Pair<I>(C c, I i) -> System.out.println();\n\t\t    case Pair<I>(D d, C c) -> System.out.println();\n\t\t    case Pair<I>(D d1, D d2) -> System.out.println();\n\t\t}\n\n\t\tswitch (p2) {                        // Error!\n\t    \tcase Pair<I>(C fst, D snd) -> System.out.println();\n\t    \tcase Pair<I>(D fst, C snd) -> System.out.println();\n\t    \tcase Pair<I>(I fst, C snd) -> System.out.println();\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 25)\n\tswitch (p1) {                 // Error!\n\t        ^^\nAn enhanced switch statement should be exhaustive; a default label expected\n----------\n2. ERROR in X.java (at line 41)\n\tswitch (p2) {                        // Error!\n\t        ^^\nAn enhanced switch statement should be exhaustive; a default label expected\n----------\n");
    }

    public void testRecordCoverage() {
        this.runConformTest(new String[]{"X.java", "sealed interface I permits A, B, C {\n}\n\nfinal class A implements I {\n}\n\nfinal class B implements I {\n}\n\nrecord C(int j) implements I {\n} // Implicitly final\n\nrecord Box(I i) {\n}\n\npublic class X {\n\tint testExhaustiveRecordPatterns(Box b) {\n\t\treturn switch (b) { // Exhaustive!\n\t\tcase Box(A aa) -> 0;\n\t\tcase Box(B bb) -> 1;\n\t\tcase Box(C cc) -> 2;\n\t\t};\n\t}\n\n\trecord IPair(I i, I j) {\n\t}\n\n\tint testExhaustiveRecordPatterns(IPair p) {\n\t\treturn switch (p) { // Exhaustive!\n\t\t\tcase IPair(A a1, A a2) -> 0;\n\t\t\tcase IPair(A a1, B b2) -> 1;\n\t\t\tcase IPair(A a1, C c3) -> 2;\n\n\t\t\tcase IPair(B b1, A b2) -> 3;\n\t\t\tcase IPair(B b1, B b2) -> 4;\n\t\t\tcase IPair(B b1, C b2) -> 5;\n\n\n\t\t\tcase IPair(C c1, A c2) -> 6;\n\t\t\tcase IPair(C c1, B c2) -> 7;\n\t\t\tcase IPair(C c1, C c2) -> 8;\n\t\t};\n\t}\n\tpublic static void main(String [] args) {\n\t\tX x = new X();\n\t\tSystem.out.print(x.testExhaustiveRecordPatterns(new Box(new A())));\n\t\tSystem.out.print(x.testExhaustiveRecordPatterns(new Box(new B())));\n\t\tSystem.out.print(x.testExhaustiveRecordPatterns(new Box(new C(42))));\n\t\tSystem.out.print(x.testExhaustiveRecordPatterns(new IPair(new A(), new A())));\n\t\tSystem.out.print(x.testExhaustiveRecordPatterns(new IPair(new A(), new B())));\n\t\tSystem.out.print(x.testExhaustiveRecordPatterns(new IPair(new A(), new C(42))));\n\t\tSystem.out.print(x.testExhaustiveRecordPatterns(new IPair(new B(), new A())));\n\t\tSystem.out.print(x.testExhaustiveRecordPatterns(new IPair(new B(), new B())));\n\t\tSystem.out.print(x.testExhaustiveRecordPatterns(new IPair(new B(), new C(42))));\n\t\tSystem.out.print(x.testExhaustiveRecordPatterns(new IPair(new C(42), new A())));\n\t\tSystem.out.print(x.testExhaustiveRecordPatterns(new IPair(new C(42), new B())));\n\t\tSystem.out.print(x.testExhaustiveRecordPatterns(new IPair(new C(42), new C(42))));\n\t}\n}\n"}, "012012345678");
    }

    public void testIssue4065() {
        this.runConformTest(new String[]{"InvalidDeadCodeWarning.java", "public class InvalidDeadCodeWarning {\n\n    public static void main(String[] args) {\n        try {\n            new InvalidDeadCodeWarning(new MyRecord(null));\n        } catch (IllegalArgumentException e) {\n            System.out.println(e);\n        }\n\n        try {\n            new InvalidDeadCodeWarning(new MyRecord(\"  \"));\n        } catch (IllegalArgumentException e) {\n            System.out.println(e);\n        }\n\n        try {\n            new InvalidDeadCodeWarning(null);\n        } catch (IllegalArgumentException e) {\n            System.out.println(e);\n        }\n    }\n\n\n    record MyRecord(String value) {\n    }\n\n    final MyRecord myRecord;\n\n    InvalidDeadCodeWarning(MyRecord myRecord) {\n        this.myRecord = switch (myRecord) {\n            case MyRecord(var value) when value == null -> throw new IllegalArgumentException(\"myRecord contained null value\"); // \"Dead code\" warning\n            case MyRecord(var value) when value.isBlank() -> throw new IllegalArgumentException(\"myRecord contained blank value '\" + value + \"'\");\n            case null -> throw new IllegalArgumentException(\"myRecord was null\");\n            default -> myRecord;\n        };\n    }\n}\n"}, "java.lang.IllegalArgumentException: myRecord contained null value\njava.lang.IllegalArgumentException: myRecord contained blank value '  '\njava.lang.IllegalArgumentException: myRecord was null");
    }

    public void testIssue4163() {
        this.runNegativeTest(new String[]{"X.java", "record R (String s) {\n\n}\n\npublic class X  {\n\tpublic static void main(String[] args) {\n\t\tObject o = new R(\"Hello\");\n\t\tif (o instanceof R(var [][][] s)) {  // you can use any number of [] pairs actually!\n\t\t\tSystem.out.println(\"R\");\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\tif (o instanceof R(var [][][] s)) {  // you can use any number of [] pairs actually!\n\t                   ^^^^^^^^^^\n'var' is not allowed as an element type of an array\n----------\n");
    }
}

