/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;
import org.eclipse.jdt.core.util.ClassFileBytesDisassembler;
import org.eclipse.jdt.core.util.ClassFormatException;
import org.eclipse.jdt.internal.compiler.util.Util;

public class RecordsRestrictedClassTest
extends AbstractRegressionTest {
    public static Class<?> testClass() {
        return RecordsRestrictedClassTest.class;
    }

    public static Test suite() {
        return RecordsRestrictedClassTest.buildMinimalComplianceTestSuite(RecordsRestrictedClassTest.testClass(), 8192);
    }

    public RecordsRestrictedClassTest(String testName) {
        super(testName);
    }

    @Override
    protected Map<String, String> getCompilerOptions() {
        Map<String, String> defaultOptions = super.getCompilerOptions();
        defaultOptions.put("org.eclipse.jdt.core.compiler.storeAnnotations", "enabled");
        return defaultOptions;
    }

    @Override
    protected void runConformTest(String[] testFiles, String expectedOutput) {
        this.runConformTest(testFiles, expectedOutput, this.getCompilerOptions());
    }

    @Override
    protected void runConformTest(String[] testFiles, String expectedOutput, Map<String, String> customOptions) {
        if (!isJRE16Plus) {
            return;
        }
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.testFiles = testFiles;
        runner.expectedOutputString = expectedOutput;
        runner.vmArguments = new String[]{"--enable-preview"};
        runner.customOptions = customOptions;
        runner.javacTestOptions = AbstractRegressionTest.JavacTestOptions.forRelease("16");
        runner.runConformTest();
    }

    @Override
    protected void runNegativeTest(String[] testFiles, String expectedCompilerLog) {
        if (!isJRE16Plus) {
            return;
        }
        this.runNegativeTest(testFiles, expectedCompilerLog, AbstractRegressionTest.JavacTestOptions.DEFAULT);
    }

    protected void runWarningTest(String[] testFiles, String expectedCompilerLog) {
        this.runWarningTest(testFiles, expectedCompilerLog, null);
    }

    protected void runWarningTest(String[] testFiles, String expectedCompilerLog, Map<String, String> customOptions) {
        this.runWarningTest(testFiles, expectedCompilerLog, customOptions, null);
    }

    protected void runWarningTest(String[] testFiles, String expectedCompilerLog, Map<String, String> customOptions, String javacAdditionalTestOptions) {
        if (!isJRE16Plus) {
            return;
        }
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.testFiles = testFiles;
        runner.expectedCompilerLog = expectedCompilerLog;
        runner.customOptions = customOptions;
        runner.vmArguments = new String[0];
        runner.javacTestOptions = javacAdditionalTestOptions == null ? AbstractRegressionTest.JavacTestOptions.forRelease("16") : AbstractRegressionTest.JavacTestOptions.forRelease("16", javacAdditionalTestOptions);
        runner.runWarningTest();
    }

    private void verifyOutputNegative(String result, String expectedOutput) {
        this.verifyOutput(result, expectedOutput, false);
    }

    private void verifyOutput(String result, String expectedOutput, boolean positive) {
        int index = result.indexOf(expectedOutput);
        if (positive) {
            if (index == -1 || expectedOutput.length() == 0) {
                System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(result, 3));
                System.out.println("...");
            }
            if (index == -1) {
                RecordsRestrictedClassTest.assertEquals("Wrong contents", expectedOutput, result);
            }
        } else if (index != -1) {
            RecordsRestrictedClassTest.assertEquals("Unexpected contents", "", result);
        }
    }

    private String getClassFileContents(String classFileName, int mode) throws IOException, ClassFormatException {
        File f = new File(OUTPUT_DIR + File.separator + classFileName);
        byte[] classFileBytes = Util.getFileByteContent((File)f);
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        String result = disassembler.disassemble(classFileBytes, "\n", mode);
        return result;
    }

    public void testBug550750_001() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\nrecord Point(int x, int y){\n}\n"}, "0");
    }

    public void testBug550750_002() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\nabstract record Point(int x, int y){\n}"}, "----------\n1. ERROR in X.java (at line 6)\n\tabstract record Point(int x, int y){\n\t                ^^^^^\nIllegal modifier for the record Point; only public, final and strictfp are permitted\n----------\n");
    }

    public void testBug550750_003() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\nfinal record Point(int x, int y){\n}\n"}, "0");
    }

    public void testBug550750_004() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\nfinal final record Point(int x, int y){\n}"}, "----------\n1. ERROR in X.java (at line 6)\n\tfinal final record Point(int x, int y){\n\t                   ^^^^^\nDuplicate modifier for the type Point\n----------\n");
    }

    public void testBug550750_005() {
        this.runConformTest(new String[]{"X.java", "class X {\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\nfinal record Point(int x, int y){\n}\n"}, "0");
    }

    public void testBug550750_006() {
        this.runNegativeTest(new String[]{"X.java", "public public record X(int x, int y){\n}"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic public record X(int x, int y){\n\t                     ^\nDuplicate modifier for the type X\n----------\n");
    }

    public void testBug550750_007() {
        this.runConformTest(new String[]{"X.java", "final record Point(int x, int y){\n  public void foo() {}\n}\npublic class X {\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\n"}, "0");
    }

    public void testBug550750_008() {
        this.runConformTest(new String[]{"X.java", "final record Point(int x, int y){\n  public Point {}\n}\npublic class X {\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\n"}, "0");
    }

    public void testBug550750_009() {
        this.runConformTest(new String[]{"X.java", "final record Point(int x, int y){\n  public Point {}\n  public void foo() {}\n}\npublic class X {\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}"}, "0");
    }

    public void testBug550750_010() {
        this.runConformTest(new String[]{"X.java", "class X {\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n  record Point(int x, int y){\n  }\n}\n"}, "0");
    }

    public void testBug550750_011() {
        this.runConformTest(new String[]{"X.java", "class X {\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n  static record Point(int x, int y){\n  }\n}\n"}, "0");
    }

    public void testBug550750_012() {
        this.runConformTest(new String[]{"X.java", "class X {\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\nrecord Point(int ... x){\n}\n"}, "0");
    }

    public void testBug550750_013() {
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.Target;\nimport java.lang.annotation.ElementType;\nrecord Point(@MyAnnotation int myInt, char myChar) {}\n @Target({ElementType.FIELD, ElementType.TYPE})\n @interface MyAnnotation {}\nclass X {\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\n"}, "0");
    }

    public void testBug550750_014() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\nrecord Point(int myInt, char myChar) {\n  public int myInt(){\n     return this.myInt;\n  }\n}\n"}, "0");
    }

    public void testBug550750_015() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\nrecord Point(int myInt, char myChar) implements I {\n  public int myInt(){\n     return this.myInt;\n  }\n}\ninterface I {}\n"}, "0");
    }

    public void testBug550750_016() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\nrecord Point(int myInt, char myChar) implements I {\n}\ninterface I {}\n"}, "0");
    }

    public void testBug550750_017() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\nrecord Point(int myInt, char myChar) implements I {\n  public Point(int myInt, char myChar){\n     this.myInt = myInt;\n     this.myChar = myChar;\n  }\n}\ninterface I {}\n"}, "0");
    }

    public void testBug550750_018() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\nrecord Point(int myInt, char myChar) implements I {\n  public Point(int myInt, char myChar){\n  }\n}\ninterface I {}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tpublic Point(int myInt, char myChar){\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nThe blank final field myChar may not have been initialized\n----------\n2. ERROR in X.java (at line 7)\n\tpublic Point(int myInt, char myChar){\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nThe blank final field myInt may not have been initialized\n----------\n");
    }

    public void testBug550750_019() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\nrecord Point(int myInt, char myChar) implements I {\n  private Point {\n     this.myInt = myInt;\n     this.myChar = myChar;\n  }\n}\ninterface I {}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tprivate Point {\n\t        ^^^^^\nCannot reduce the visibility of a canonical constructor Point from that of the record\n----------\n");
    }

    public void testBug550750_020() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\nrecord Point(int myInt, char myChar) implements I {\n  protected Point {\n     this.myInt = myInt;\n     this.myChar = myChar;\n  }\n}\ninterface I {}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\tthis.myInt = myInt;\n\t^^^^^^^^^^\nIllegal explicit assignment of a final field myInt in compact constructor\n----------\n2. ERROR in X.java (at line 9)\n\tthis.myChar = myChar;\n\t^^^^^^^^^^^\nIllegal explicit assignment of a final field myChar in compact constructor\n----------\n");
    }

    public void testBug550750_022() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\nrecord Point(int myInt, char myChar) implements I {\n  public Point {\n     this.myInt = myInt;\n     this.myChar = myChar;\n     return;\n  }\n}\ninterface I {}\n"}, "----------\n1. ERROR in X.java (at line 10)\n\treturn;\n\t^^^^^^^\nThe body of a compact constructor must not contain a return statement\n----------\n");
    }

    public void testBug550750_023() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\nrecord Point(int myInt, int finalize) implements I {\n  public Point {\n     this.myInt = myInt;\n  }\n}\ninterface I {}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\trecord Point(int myInt, int finalize) implements I {\n\t                            ^^^^^^^^\nIllegal component name finalize in record Point;\n----------\n");
    }

    public void testBug550750_024() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\nrecord Point(int myInt, int finalize, int myZ) implements I {\n  public Point {\n     this.myInt = myInt;\n     this.myZ = myZ;\n  }\n}\ninterface I {}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\trecord Point(int myInt, int finalize, int myZ) implements I {\n\t                            ^^^^^^^^\nIllegal component name finalize in record Point;\n----------\n");
    }

    public void testBug550750_025() {
        RecordsRestrictedClassTest.getPossibleComplianceLevels();
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\nrecord Point(int myInt, int myZ, int myZ) implements I {\n  public Point {\n     this.myInt = myInt;\n     this.myZ = myZ;\n  }\n}\ninterface I {}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\trecord Point(int myInt, int myZ, int myZ) implements I {\n\t                            ^^^\nDuplicate component myZ in record\n----------\n2. ERROR in X.java (at line 6)\n\trecord Point(int myInt, int myZ, int myZ) implements I {\n\t                                     ^^^\nDuplicate component myZ in record\n----------\n");
    }

    public void testBug550750_026() {
        RecordsRestrictedClassTest.getPossibleComplianceLevels();
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\nrecord Point(int myInt, int myInt, int myInt, int myZ) implements I {\n  public Point {\n     this.myInt = myInt;\n     this.myZ = myZ;\n  }\n}\ninterface I {}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\trecord Point(int myInt, int myInt, int myInt, int myZ) implements I {\n\t                 ^^^^^\nDuplicate component myInt in record\n----------\n2. ERROR in X.java (at line 6)\n\trecord Point(int myInt, int myInt, int myInt, int myZ) implements I {\n\t                            ^^^^^\nDuplicate component myInt in record\n----------\n3. ERROR in X.java (at line 6)\n\trecord Point(int myInt, int myInt, int myInt, int myZ) implements I {\n\t                                       ^^^^^\nDuplicate component myInt in record\n----------\n");
    }

    public void testBug550750_027() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\nrecord Point(int myInt, int myZ) implements I {\n  static final int z;\n  public Point {\n     this.myInt = myInt;\n     this.myZ = myZ;\n  }\n}\ninterface I {}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tstatic final int z;\n\t                 ^\nThe blank final field z may not have been initialized\n----------\n2. ERROR in X.java (at line 9)\n\tthis.myInt = myInt;\n\t^^^^^^^^^^\nIllegal explicit assignment of a final field myInt in compact constructor\n----------\n3. ERROR in X.java (at line 10)\n\tthis.myZ = myZ;\n\t^^^^^^^^\nIllegal explicit assignment of a final field myZ in compact constructor\n----------\n");
    }

    public void testBug550750_028() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\nrecord Point(int myInt, int myZ) implements I {\n  int z;\n  public Point {\n     this.myInt = myInt;\n     this.myZ = myZ;\n  }\n}\ninterface I {}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tint z;\n\t    ^\nInstance fields may not be declared in a record class\n----------\n");
    }

    public void testBug550750_029() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\nrecord Point(int myInt, int myZ) implements I {\n  public Point {\n     this.myInt = myInt;\n     this.myZ = myZ;\n  }\n  public native void foo();\n}\ninterface I {}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\tthis.myInt = myInt;\n\t^^^^^^^^^^\nIllegal explicit assignment of a final field myInt in compact constructor\n----------\n2. ERROR in X.java (at line 9)\n\tthis.myZ = myZ;\n\t^^^^^^^^\nIllegal explicit assignment of a final field myZ in compact constructor\n----------\n3. ERROR in X.java (at line 11)\n\tpublic native void foo();\n\t                   ^^^^^\nIllegal modifier native for method foo; native methods are not allowed in record\n----------\n");
    }

    public void testBug550750_030() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\nrecord Point(int myInt, int myZ) implements I {\n  {\n     System.out.println(0);\n  }\n}\ninterface I {}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\t{\n     System.out.println(0);\n  }\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nInstance Initializer is not allowed in a record declaration\n----------\n");
    }

    public void testBug550750_031() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\nrecord Point(int myInt, int myZ) implements I {\n  static {\n     System.out.println(0);\n  }\n}\ninterface I {}\n"}, "0");
    }

    public void testBug550750_032() {
        this.runNegativeTest(new String[]{"X.java", "class record {\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tclass record {\n\t      ^^^^^^\n'record' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 16\n----------\n");
    }

    public void testBug550750_033() {
        this.runNegativeTest(new String[]{"X.java", "class X<record> {\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tclass X<record> {\n\t        ^^^^^^\n'record' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 16\n----------\n");
    }

    public void testBug550750_034() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n  public <record> void foo(record args){}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tpublic <record> void foo(record args){}\n\t        ^^^^^^\n'record' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 16\n----------\n2. ERROR in X.java (at line 5)\n\tpublic <record> void foo(record args){}\n\t                         ^^^^^^\n'record' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 16\n----------\n");
    }

    public void testBug550750_035() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n  public void foo(record args){}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tpublic void foo(record args){}\n\t                ^^^^^^\n'record' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 16\n----------\n");
    }

    public void testBug550750_036() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n  public static void main(String[] args){\n     System.out.println(0);\n     I lambda = (record r) -> {};\n  }\n}\ninterface I {\n  public void apply(int i);\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tI lambda = (record r) -> {};\n\t           ^^^^^^^^^^^^^\nThis lambda expression refers to the missing type record\n----------\n2. ERROR in X.java (at line 4)\n\tI lambda = (record r) -> {};\n\t            ^^^^^^\n'record' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 16\n----------\n");
    }

    public void testBug550750_037() {
        this.runConformTest(new String[]{"X.java", "class X {\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\nrecord Point(){\n}\n"}, "0");
    }

    public void testBug550750_038() {
        this.runConformTest(new String[]{"X.java", "class X {\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\nrecord Point(){\n   public Point {}\n}\n"}, "0");
    }

    public void testBug550750_039() {
        this.runConformTest(new String[]{"X.java", "class X {\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\nrecord Point(){\n   public Point() {}\n}\n"}, "0");
    }

    public void testBug550750_040() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\nrecord Point(){\n   private int f;\n   public Point() {}\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tprivate int f;\n\t            ^\nInstance fields may not be declared in a record class\n----------\n");
    }

    public void testBug550750_041() {
        this.runConformTest(new String[]{"X.java", "class X {\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\nrecord Point(){\n   static int f;\n   public Point() {}\n}\n"}, "0");
    }

    public void testBug553152_001() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\nrecord Point(int myInt, int myZ) implements I {\n  public char myInt() {;\n     return 'c';\n  }\n  public int getmyInt() {;\n     return this.myInt;\n  }\n}\ninterface I {}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tpublic char myInt() {;\n\t       ^^^^\nIllegal return type of accessor; should be the same as the declared type int of the record component\n----------\n");
    }

    public void testBug553152_002() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\nrecord Point(Integer myInt, int myZ) implements I {\n  public java.lang.Integer myInt() {;\n     return this.myInt;\n  }\n}\ninterface I {}\n"}, "0");
    }

    public void testBug553152_003() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\nrecord Point(int myInt, int myZ) implements I {\n  public <T> int myInt() {;\n     return this.myInt;\n  }\n}\ninterface I {}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tpublic <T> int myInt() {;\n\t               ^^^^^^^\nThe accessor method must not be generic\n----------\n");
    }

    public void testBug553152_004() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\nrecord Point(int myInt, int myZ) implements I {\n  private int myInt() {;\n     return this.myInt;\n  }\n  /* package */ int myZ() {;\n     return this.myZ;\n  }\n}\ninterface I {}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tprivate int myInt() {;\n\t            ^^^^^^^\nThe accessor method must be declared public\n----------\n2. ERROR in X.java (at line 10)\n\t/* package */ int myZ() {;\n\t                  ^^^^^\nThe accessor method must be declared public\n----------\n");
    }

    public void testBug553152_005() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\nrecord Point(int myInt, int myZ) implements I {\n  public int myInt() throws Exception {;\n     return this.myInt;\n  }\n}\ninterface I {}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tpublic int myInt() throws Exception {;\n\t           ^^^^^^^^^^^^^^^^^^^^^^^^\nThrows clause not allowed for explicitly declared accessor method\n----------\n");
    }

    public void testBug553152_006() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\nrecord Point(Integer myInt, int myZ) implements I {\n  public Point(Integer myInt, int myZ) {\n     this.myInt = 0;\n     this.myZ = 0;\n  }\n}\ninterface I {}\n"}, "0");
    }

    public void testBug553152_007() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\nrecord Point(Integer myInt, int myZ) implements I {\n  public Point(Integer myInt, int myZ) {\n     this.myInt = 0;\n  }\n}\ninterface I {}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tpublic Point(Integer myInt, int myZ) {\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nThe blank final field myZ may not have been initialized\n----------\n");
    }

    public void testBug553152_008() {
        RecordsRestrictedClassTest.getPossibleComplianceLevels();
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\nrecord Point(Integer myInt, int myZ) implements I {\n  public Point {\n     this.myInt = 0;\n     this.myZ = 0;\n  }\n  public Point(Integer myInt, int myZ) {\n     this.myInt = 0;\n     this.myZ = 0;\n  }\n}\ninterface I {}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tpublic Point {\n\t       ^^^^^\nDuplicate method Point(Integer, int) in type Point\n----------\n2. ERROR in X.java (at line 8)\n\tthis.myInt = 0;\n\t^^^^^^^^^^\nIllegal explicit assignment of a final field myInt in compact constructor\n----------\n3. ERROR in X.java (at line 9)\n\tthis.myZ = 0;\n\t^^^^^^^^\nIllegal explicit assignment of a final field myZ in compact constructor\n----------\n4. ERROR in X.java (at line 11)\n\tpublic Point(Integer myInt, int myZ) {\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nDuplicate method Point(Integer, int) in type Point\n----------\n");
    }

    public void testBug553152_009() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\nrecord Point(Integer myInt, int myZ) implements I {\n  Point(Integer myInt, int myZ) {\n     this.myInt = 0;\n     this.myZ = 0;\n  }\n}\ninterface I {}\n"}, "0");
    }

    public void testBug553152_010() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\nrecord Point(Integer myInt, int myZ) implements I {\n  public <T> Point(Integer myInt, int myZ) {\n     this.myInt = 0;\n     this.myZ = 0;\n  }\n}\ninterface I {}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tpublic <T> Point(Integer myInt, int myZ) {\n\t           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nCanonical constructor Point of a record declaration should not be generic\n----------\n");
    }

    public void testBug553152_011() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\nrecord Point(Integer myInt, int myZ) implements I {\n  public Point(Integer myInt, int myZ) throws Exception {\n     this.myInt = 0;\n     this.myZ = 0;\n  }\n}\ninterface I {}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tpublic Point(Integer myInt, int myZ) throws Exception {\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nThrows clause not allowed for canonical constructor Point\n----------\n");
    }

    public void testBug553152_012() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\nrecord Point(Integer myInt, int myZ) implements I {\n  public Point {\n     this.myInt = 0;\n     this.myZ = 0;\n     return;\n  }\n}\ninterface I {}\n"}, "----------\n1. ERROR in X.java (at line 10)\n\treturn;\n\t^^^^^^^\nThe body of a compact constructor must not contain a return statement\n----------\n");
    }

    public void testBug553152_013() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\nrecord Point(Integer myInt, int myZ) implements I {\n  public Point(Integer myInt, int myZ) {\n     this.myInt = 0;\n     this.myZ = 0;\n     I i = () -> { return;};\n     Zork();\n  }\n  public void apply() {}\n}\ninterface I { void apply();}\n"}, "----------\n1. ERROR in X.java (at line 11)\n\tZork();\n\t^^^^\nThe method Zork() is undefined for the type Point\n----------\n");
    }

    public void testBug553152_014() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\nrecord Point(Integer myInt, int myZ) implements I {\n  public Point(Integer myInt, int myZ) {\n     super();\n     this.myInt = 0;\n     this.myZ = 0;\n  }\n}\ninterface I {}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\tsuper();\n\t^^^^^^^^\nThe body of a canonical constructor must not contain an explicit constructor call\n----------\n");
    }

    public void testBug553152_015() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\nrecord Point(Integer myInt, int myZ) implements I {\n  public Point(Integer myInt, int myZ) {\n     this.Point(0);\n     this.myInt = 0;\n     this.myZ = 0;\n  }\n  public Point(Integer myInt) {}\n}\ninterface I {}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\tthis.Point(0);\n\t     ^^^^^\nThe method Point(int) is undefined for the type Point\n----------\n2. ERROR in X.java (at line 12)\n\tpublic Point(Integer myInt) {}\n\t       ^^^^^^^^^^^^^^^^^^^^\nA non-canonical constructor must start with an explicit invocation to a constructor\n----------\n");
    }

    public void testBug553152_016() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\nrecord Point(Integer myInt, int myZ) implements I {\n  public Point {\n     super();\n     this.myInt = 0;\n     this.myZ = 0;\n  }\n}\ninterface I {}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\tsuper();\n\t^^^^^^^^\nThe body of a compact constructor must not contain an explicit constructor call\n----------\n");
    }

    public void testBug553152_017() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  public class Inner {\n    record Point(int myInt, char myChar) {}\n  }\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\n"}, "0");
    }

    public void testBug553152_018() {
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.Target;\nimport java.lang.annotation.ElementType;\nclass X {\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\nrecord Point(int myInt, char myChar) {}\n @Target({ElementType.FIELD, ElementType.TYPE})\n @interface MyAnnotation {}\n"}, "0");
    }

    public void testBug553152_019() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\nrecord Point(int myInt, int myZ) implements I {\n  public static int myInt() {;\n     return 0;\n  }\n}\ninterface I {}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tpublic static int myInt() {;\n\t                  ^^^^^^^\nThe accessor method must not be static\n----------\n");
    }

    public void testBug553153_002() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\nrecord Point(int myInt, char myChar) implements I {\n  public Point {\n\tthis.myInt = myInt;\n\tif (this.myInt > 0)  // conditional assignment\n\t\tthis.myChar = myChar;\n  }\n}\ninterface I {}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\tthis.myInt = myInt;\n\t^^^^^^^^^^\nIllegal explicit assignment of a final field myInt in compact constructor\n----------\n2. ERROR in X.java (at line 9)\n\tif (this.myInt > 0)  // conditional assignment\n\t         ^^^^^\nThe blank final field myInt may not have been initialized\n----------\n3. ERROR in X.java (at line 10)\n\tthis.myChar = myChar;\n\t^^^^^^^^^^^\nIllegal explicit assignment of a final field myChar in compact constructor\n----------\n");
    }

    public void testBug553153_003() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\nrecord Point(int myInt, char myChar) implements I {\n  static int f;\n  public Point {\n  }\n}\ninterface I {}\n"}, "0");
    }

    public void testBug553153_004() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\nrecord Point(int myInt, char myChar) implements I {\n  public Point(int myInt, char myChar) {\n\tthis.myInt = myInt;\n  }\n}\ninterface I {}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tpublic Point(int myInt, char myChar) {\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nThe blank final field myChar may not have been initialized\n----------\n");
    }

    public void testBug558069_001() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\nprivate record Point(){\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tprivate record Point(){\n\t               ^^^^^\nIllegal modifier for the record Point; only public, final and strictfp are permitted\n----------\n");
    }

    public void testBug558069_002() {
        this.runConformTest(new String[]{"X.java", "public class X {\nprivate record Point(){\n}\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\n"}, "0");
    }

    public void testBug558069_003() {
        this.runConformTest(new String[]{"X.java", "public class X {\nprivate record Point(int myInt){\n}\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\n"}, "0");
    }

    public void testBug558343_001() {
        this.runConformTest(new String[]{"X.java", "public class X {\nprivate record Point(int myInt){\n  @Override\n  public boolean equals(Object obj){\n     return false;\n  }\n}\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\n"}, "0");
    }

    public void testBug558343_002() {
        this.runConformTest(new String[]{"X.java", "public class X {\nprivate record Point(int myInt){\n  @Override\n  public int hashCode(){\n     return java.util.Arrays.hashCode(new int[]{Integer.valueOf(this.myInt).hashCode()});\n  }\n}\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\n"}, "0");
    }

    public void testBug558343_003() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\nrecord Point(int myInt){\n  @Override\n  public String toString(){\n     return \"Point@1\";\n  }\n}\n"}, "0");
    }

    public void testBug558343_004() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args){\n     System.out.println(new Point(0).myInt());\n  }\n}\nrecord Point(int myInt){\n  @Override\n  public String toString(){\n     return \"Point@1\";\n  }\n}\n"}, "0");
    }

    public void testBug558494_001() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args){\n     System.out.println(new Point(0).heyPinkCity());\n  }\n}\nrecord Point(int heyPinkCity){\n  @Override\n  public String toString(){\n     return \"Point@1\";\n  }\n}\n"}, "0");
        String expectedOutput = "Record: #Record\nComponents:\n  \n// Component descriptor #6 I\nint heyPinkCity;\n";
        this.verifyClassFile(expectedOutput, "Point.class", 4);
    }

    public void testBug558494_002() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args){\n     System.out.println(new Point().toString());\n  }\n}\nrecord Point(){\n  @Override\n  public String toString(){\n     return \"Point@1\";\n  }\n}\n"}, "Point@1");
        String expectedOutput = "Record: #Record\nComponents:\n  \n";
        this.verifyClassFile(expectedOutput, "Point.class", 4);
    }

    public void testBug558494_003() throws Exception {
        this.runConformTest(new String[]{"X.java", "record Forts(String...wonders){\n}\npublic class X {\n       public static void main(String[] args) {\n               Forts p = new Forts(new String[] {\"Amber\", \"Nahargarh\", \"Jaigarh\"});\n               if (!p.toString().startsWith(\"Forts[wonders=[Ljava.lang.String;@\"))\n                   System.out.println(\"Error\");\n       }\n}\n"}, "");
        String expectedOutput = "Record: #Record\nComponents:\n  \n";
        this.verifyClassFile(expectedOutput, "Forts.class", 4);
    }

    public void testBug558494_004() throws Exception {
        this.runConformTest(new String[]{"X.java", "record Forts(int x, String[] wonders){\n}\npublic class X {\n       public static void main(String[] args) {\n               Forts p = new Forts(3, new String[] {\"Amber\", \"Nahargarh\", \"Jaigarh\"});\n               if (!p.toString().startsWith(\"Forts[x=3, wonders=[Ljava.lang.String;@\"))\n                   System.out.println(\"Error\");\n       }\n}\n"}, "");
        String expectedOutput = "Record: #Record\nComponents:\n  \n// Component descriptor #6 I\nint x;\n// Component descriptor #8 [Ljava/lang/String;\njava.lang.String[] wonders;\n";
        this.verifyClassFile(expectedOutput, "Forts.class", 4);
    }

    public void testBug558764_001() {
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.Target;\nimport java.lang.annotation.ElementType;\nrecord Point(@MyAnnotation int myInt, char myChar) {}\n @Target({ElementType.FIELD})\n @interface MyAnnotation {}\nclass X {\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\n"}, "0");
    }

    public void testBug558764_002() {
        this.runNegativeTest(new String[]{"X.java", "import java.lang.annotation.Target;\nimport java.lang.annotation.ElementType;\nrecord Point(@MyAnnotation int myInt, char myChar) {}\n @Target({ElementType.TYPE})\n @interface MyAnnotation {}\nclass X {\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\trecord Point(@MyAnnotation int myInt, char myChar) {}\n\t             ^^^^^^^^^^^^^\nThe annotation @MyAnnotation is disallowed for this location\n----------\n");
    }

    public void testBug558764_003() {
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.Target;\nimport java.lang.annotation.ElementType;\nrecord Point(@MyAnnotation int myInt, char myChar) {}\n @Target({ElementType.RECORD_COMPONENT})\n @interface MyAnnotation {}\nclass X {\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\n"}, "0");
    }

    public void testBug558764_004() {
        this.runNegativeTest(new String[]{"X.java", "import java.lang.annotation.Target;\nimport java.lang.annotation.ElementType;\nrecord Point(@MyAnnotation int myInt, char myChar) {}\n @Target({ElementType.RECORD_COMPONENT})\n @interface MyAnnotation {}\nclass X {\n  public @MyAnnotation String f = \"hello\";\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tpublic @MyAnnotation String f = \"hello\";\n\t       ^^^^^^^^^^^^^\nThe annotation @MyAnnotation is disallowed for this location\n----------\n");
    }

    public void testBug553567_001() {
        this.runNegativeTest(new String[]{"X.java", "class X extends Record{\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tclass X extends Record{\n\t                ^^^^^^\nThe type X may not subclass Record explicitly\n----------\n");
    }

    public void testBug553567_002() {
        this.runConformTest(new String[]{"X.java", "class X {\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\nclass Record {\n}\n"}, "0");
    }

    public void testBug559281_001() {
        this.runNegativeTest(new String[]{"X.java", "record X(void k) {}"}, "----------\n1. ERROR in X.java (at line 1)\n\trecord X(void k) {}\n\t              ^\nvoid is an invalid type for the variable k\n----------\n");
    }

    public void testBug559281_002() {
        this.runNegativeTest(new String[]{"X.java", "record X(int clone, int wait) {}"}, "----------\n1. ERROR in X.java (at line 1)\n\trecord X(int clone, int wait) {}\n\t             ^^^^^\nIllegal component name clone in record X;\n----------\n2. ERROR in X.java (at line 1)\n\trecord X(int clone, int wait) {}\n\t                        ^^^^\nIllegal component name wait in record X;\n----------\n");
    }

    public void testBug559448_001() {
        this.runConformTest(new String[]{"X.java", "class X {\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\nrecord Point(int x, int... y){\n}\n"}, "0");
    }

    public void testBug559448_002() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\nrecord Point(int... x, int y){\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\trecord Point(int... x, int y){\n\t                    ^\nThe variable argument type int of the record Point must be the last parameter\n----------\n");
    }

    public void testBug559448_003() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\nrecord Point(int... x, int... y){\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\trecord Point(int... x, int... y){\n\t                    ^\nThe variable argument type int of the record Point must be the last parameter\n----------\n");
    }

    public void testBug559574_001() {
        this.runNegativeTest(new String[]{"X.java", "record X(int x, int XX3) {\n       public XX3  {}\n       public XX3(int x, int y, int z) {\n               this.x = x;\n               this.y = y;\n       }\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tpublic XX3  {}\n\t       ^^^\nReturn type for the method is missing\n----------\n2. ERROR in X.java (at line 3)\n\tpublic XX3(int x, int y, int z) {\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^\nReturn type for the method is missing\n----------\n3. WARNING in X.java (at line 3)\n\tpublic XX3(int x, int y, int z) {\n\t               ^\nThe parameter x is hiding a field from type X\n----------\n4. ERROR in X.java (at line 5)\n\tthis.y = y;\n\t     ^\ny cannot be resolved or is not a field\n----------\n");
    }

    public void testBug559992_001() {
        this.runNegativeTest(new String[]{"X.java", "record R() {\n  public R throws Exception {\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tpublic R throws Exception {\n\t       ^^^^^^^^^^^^^^^^^^\nThrows clause not allowed for canonical constructor R\n----------\n");
    }

    public void testBug559992_002() {
        this.runNegativeTest(new String[]{"X.java", "record R() {\n  public R() throws Exception {\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tpublic R() throws Exception {\n\t       ^^^^^^^^^^^^^^^^^^^^\nThrows clause not allowed for canonical constructor R\n----------\n");
    }

    public void testBug560256_001() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\nfinal protected record Point(int x, int y){\n}"}, "----------\n1. ERROR in X.java (at line 6)\n\tfinal protected record Point(int x, int y){\n\t                       ^^^^^\nIllegal modifier for the record Point; only public, final and strictfp are permitted\n----------\n");
    }

    public void testBug560256_002() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\nnative record Point(int x, int y){\n}"}, "----------\n1. ERROR in X.java (at line 6)\n\tnative record Point(int x, int y){\n\t              ^^^^^\nIllegal modifier for the record Point; only public, final and strictfp are permitted\n----------\n");
    }

    public void testBug560256_003() {
        this.runConformTest(new String[]{"X.java", "class X {\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n  class Inner {\n\t  record Point(int x, int y){}\n  }\n}"}, "0");
    }

    public void testBug560256_004() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n  static class Inner {\n\t  native record Point(int x, int y){}\n  }\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tnative record Point(int x, int y){}\n\t              ^^^^^\nIllegal modifier for the record Point; only public, private, protected, static, final and strictfp are permitted\n----------\n");
    }

    public void testBug560531_001() {
        this.runConformTest(new String[]{"X.java", "class X {\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\nrecord Point<T>(T t){\n}\n"}, "0");
    }

    public void testBug560531_002() {
        this.runConformTest(new String[]{"X.java", "class X {\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\nrecord R <T extends Integer, S extends String> (int x, T t, S s){\n}\n"}, "0");
    }

    public void testBug560569_001() throws Exception {
        this.runConformTest(new String[]{"X.java", "interface Rentable { int year(); }\nrecord Car(String model, int year) implements Rentable {\n  public Car {\n  }\n  public String toString() {\n    return model + \" \" + year;\n  }\n}\nrecord Camel(int year) implements Rentable { }\n\nclass X {\n       String model;\n       int year;\n       public String toString() {\n          return model + \" \" + year;\n       }\n       public static void main(String[] args) {\n               Car car = new Car(\"Maruti\", 2000);\n               System.out.println(car.hashCode() != 0);\n       }\n}\n"}, "true");
        String expectedOutput = this.complianceLevel < 0x350000L ? "  0 : # 69 invokestatic java/lang/runtime/ObjectMethods.bootstrap:(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/TypeDescriptor;Ljava/lang/Class;Ljava/lang/String;[Ljava/lang/invoke/MethodHandle;)Ljava/lang/Object;\n\tMethod arguments:\n\t\t#1 Car\n\t\t#70 model;year\n\t\t#72 REF_getField model:Ljava/lang/String;\n\t\t#73 REF_getField year:I\n" : "  1 : # 59 invokestatic java/lang/runtime/ObjectMethods.bootstrap:(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/TypeDescriptor;Ljava/lang/Class;Ljava/lang/String;[Ljava/lang/invoke/MethodHandle;)Ljava/lang/Object;\n\tMethod arguments:\n\t\t#1 Car\n\t\t#60 model;year\n\t\t#62 REF_getField model:Ljava/lang/String;\n\t\t#63 REF_getField year:I";
        this.verifyClassFile(expectedOutput, "Car.class", 4);
        expectedOutput = "  // Method descriptor #12 (Ljava/lang/String;I)V\n  // Stack: 2, Locals: 3\n  public Car(java.lang.String model, int year);\n     0  aload_0 [this]\n     1  invokespecial java.lang.Record() [14]\n     4  aload_0 [this]\n     5  aload_1 [model]\n     6  putfield Car.model : java.lang.String [17]\n     9  aload_0 [this]\n    10  iload_2 [year]\n    11  putfield Car.year : int [19]\n    14  return\n      Line numbers:\n        [pc: 0, line: 3]\n        [pc: 4, line: 4]\n      Local variable table:\n        [pc: 0, pc: 15] local: this index: 0 type: Car\n        [pc: 0, pc: 15] local: model index: 1 type: java.lang.String\n        [pc: 0, pc: 15] local: year index: 2 type: int\n      Method Parameters:\n        mandated model\n        mandated year\n  \n";
        this.verifyClassFile(expectedOutput, "Car.class", 4);
    }

    public void testBug560496_001() throws Exception {
        this.runConformTest(new String[]{"X.java", "record R () {} \nclass X {\n       public static void main(String[] args) {\n               System.out.println(new R().hashCode());\n       }\n}\n"}, "0");
        String expectedOutput = "public final int hashCode();\n";
        this.verifyClassFile(expectedOutput, "R.class", 4);
    }

    public void testBug560496_002() throws Exception {
        if (this.complianceLevel < 0x3D0000L) {
            return;
        }
        this.runConformTest(new String[]{"X.java", "strictfp record R () {} \nclass X {\n       public static void main(String[] args) {\n               System.out.println(new R().hashCode());\n       }\n}\n"}, "0");
        String expectedOutput = "public final int hashCode();\n";
        this.verifyClassFile(expectedOutput, "R.class", 4);
    }

    public void testBug560797_001() throws Exception {
        if (this.complianceLevel < 0x3D0000L) {
            return;
        }
        this.runConformTest(new String[]{"X.java", "strictfp record R (int x, int y) {} \nclass X {\n       public static void main(String[] args) {\n               System.out.println(new R(100, 200).hashCode() != 0);\n       }\n}\n"}, "true");
        String expectedOutput = "public int x();\n";
        this.verifyClassFile(expectedOutput, "R.class", 4);
    }

    public void testBug560797_002() throws Exception {
        if (this.complianceLevel < 0x3D0000L) {
            return;
        }
        this.runConformTest(new String[]{"X.java", "strictfp record R (int x, int y) { \npublic int x() { return this.x;}\n}\nclass X {\n       public static void main(String[] args) {\n               System.out.println(new R(100, 200).hashCode() != 0);\n       }\n}\n"}, "true");
        String expectedOutput = "public int x();\n";
        this.verifyClassFile(expectedOutput, "R.class", 4);
    }

    public void testBug560798_001() throws Exception {
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.Target;\nimport java.lang.annotation.ElementType;\n@Target({ElementType.PARAMETER})\n@interface MyAnnot {}\nrecord R(@MyAnnot()  int i, int j) {}\nclass X {\n       public static void main(String[] args) {\n           System.out.println(new R(100, 200).hashCode() != 0);\n       }\n}\n"}, "true");
    }

    public void testBug560798_002() {
        this.runNegativeTest(new String[]{"X.java", "import java.lang.annotation.Target;\nimport java.lang.annotation.ElementType;\n@Target({ElementType.ANNOTATION_TYPE, ElementType.CONSTRUCTOR, ElementType.LOCAL_VARIABLE,\n\tElementType.MODULE, ElementType.PACKAGE, ElementType.TYPE, ElementType.TYPE_PARAMETER})\n@interface MyAnnot {}\nrecord R(@MyAnnot()  int i, int j) {}\nclass X {\n       public static void main(String[] args) {\n       }\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\trecord R(@MyAnnot()  int i, int j) {}\n\t         ^^^^^^^^\nThe annotation @MyAnnot is disallowed for this location\n----------\n");
    }

    public void testBug560798_003() throws Exception {
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.Target;\nimport java.lang.annotation.ElementType;\n@Target({ElementType.METHOD})\n@interface MyAnnot {}\nrecord R(@MyAnnot()  int i, int j) {}\nclass X {\n       public static void main(String[] args) {\n           System.out.println(new R(100, 200).hashCode() != 0);\n       }\n}\n"}, "true");
    }

    public void testBug560798_004() throws Exception {
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.Target;\nimport java.lang.annotation.ElementType;\n@Target({ElementType.RECORD_COMPONENT})\n@interface MyAnnot {}\nrecord R(@MyAnnot()  int i, int j) {}\nclass X {\n       public static void main(String[] args) {\n           System.out.println(new R(100, 200).hashCode() != 0);\n       }\n}\n"}, "true");
    }

    public void testBug560798_005() throws Exception {
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.Target;\nimport java.lang.annotation.ElementType;\n@Target({ElementType.TYPE_USE})\n@interface MyAnnot {}\nrecord R(@MyAnnot()  int i, int j) {}\nclass X {\n       public static void main(String[] args) {\n           System.out.println(new R(100, 200).hashCode() != 0);\n       }\n}\n"}, "true");
    }

    public void testBug560893_001() {
        this.runConformTest(new String[]{"X.java", "interface I{\nrecord R(int x, int y) {}\n}\nclass X {\n       public static void main(String[] args) {\n           System.out.println(0);\n       }\n}\n"}, "0");
    }

    public void testBug560893_002() {
        this.runConformTest(new String[]{"X.java", "class X {\n       public static void main(String[] args) {\n           record R(int x, int y) {}\n           System.out.println(0);\n       }\n}\n"}, "0");
    }

    public void testBug560893_003() {
        this.runConformTest(new String[]{"X.java", "class X {\n       public static void main(String[] args) {\n           record R(int x, int y) {}\n           R r =  new R(100,200);\n           System.out.println(r.x());\n       }\n}\n"}, "100");
    }

    public void testBug560893_004() {
        this.runConformTest(new String[]{"X.java", "class X {\n       public static void main(String[] args) {\n           record R(int x, int y) {\n               static int i;\n       \t}\n           R r =  new R(100,200);\n           System.out.println(r.x());\n       }\n}\n"}, "100");
    }

    public void testBug560893_005() {
        this.runConformTest(new String[]{"X.java", "class X {\n       public static void main(String[] args) {\n           record R(int x, int y) {\n               static int i;\n               public void ff() {\n                \tint jj;\n       \t\t}\n               static int ii;\n       \t}\n           R r =  new R(100,200);\n           System.out.println(r.x());\n       }\n}\n"}, "100");
    }

    public void testBug560893_006() {
        this.runConformTest(new String[]{"X.java", "class X {\n       public static void main(String[] args) {\n           record R(int x, int y) {}\n           R r =  new R(100,200);\n           System.out.println(r.x());\n       }\n}\n"}, "100");
    }

    public void testBug560893_007() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n    static int si;\n    int nsi;\n\n    void m() {\n        int li;\n\n        record R(int r) {\n            void print() {\n                System.out.println(li);  // error, local variable\n                System.out.println(nsi); // error, non-static member\n                System.out.println(si);  // ok, static member of enclosing class\n            }\n        }\n        R r = new R(10);\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 10)\n\tSystem.out.println(li);  // error, local variable\n\t                   ^^\nCannot make a static reference to the non-static variable li\n----------\n2. ERROR in X.java (at line 11)\n\tSystem.out.println(nsi); // error, non-static member\n\t                   ^^^\nCannot make a static reference to the non-static field nsi\n----------\n");
    }

    public void testBug558718_001() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.source", "15");
        options.put("org.eclipse.jdt.core.compiler.problem.enablePreviewFeatures", "disabled");
        this.runNegativeTest(new String[]{"X.java", "record R() {}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\trecord R() {}\n\t^\nThe preview feature Implicitly Declared Classes and Instance Main Methods is only available with source level 24 and above\n----------\n2. ERROR in X.java (at line 1)\n\trecord R() {}\n\t^^^^^^\n'record' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 16\n----------\n3. ERROR in X.java (at line 1)\n\trecord R() {}\n\t^\nImplicitly declared class must have a candidate main method\n----------\n", null, true, options);
    }

    public void testBug56180_001() throws Exception {
        this.runConformTest(new String[]{"X.java", "record R () {} \nclass X {\n       public static void main(String[] args) {\n               System.out.println(new R().toString());\n       }\n}\n"}, "R[]");
        String expectedOutput = " public final java.lang.String toString();\n";
        this.verifyClassFile(expectedOutput, "R.class", 4);
    }

    public void testBug561528_001() {
        this.runConformTest(new String[]{"X.java", "class X {\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\ninterface Node<N> {}\n\nrecord R <N extends Node<?>> (N value){\n}\n"}, "0");
    }

    public void testBug561528_002() {
        this.runConformTest(new String[]{"X.java", "class X {\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\ninterface Node<N> {}\n\nrecord R <N extends Node<N>> (R<N> parent, N element){\n}\n"}, "0");
    }

    public void testBug561528_003() {
        this.runConformTest(new String[]{"X.java", "class X {\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\ninterface Node<N> {}\n\ninterface AB<N> {}\n\nrecord R <N extends Node<AB<N>>> (N value){\n}\n"}, "0");
    }

    public void testBug561528_004() {
        this.runConformTest(new String[]{"X.java", "class X {\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\ninterface Node<N> {}\n\ninterface AB<N> {}\n\ninterface CD<N> {}\n\nrecord R <N extends Node<AB<CD<N>>>> (N value){\n}\n"}, "0");
    }

    public void testBug561528_005() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\ninterface Node<N> {}\n\ninterface AB<N> {}\n\ninterface CD<N> {}\n\nrecord R <N extends Node<AB<CD<N>>>>> (N value){\n}\n"}, "----------\n1. ERROR in X.java (at line 12)\n\trecord R <N extends Node<AB<CD<N>>>>> (N value){\n\t                                ^^^\nSyntax error on token \">>>\", >> expected\n----------\n2. ERROR in X.java (at line 12)\n\trecord R <N extends Node<AB<CD<N>>>>> (N value){\n\t                                         ^^^^^\nInstance fields may not be declared in a record class\n----------\n", null, true);
    }

    public void testBug561778_001() throws IOException, ClassFormatException {
        this.runConformTest(new String[]{"XTest.java", "public class XTest{\n\tstatic <T> T test(X<T> box) {\n\t\treturn box.value(); /* */\n\t}\n   public static void main(String[] args) {\n       System.out.println(0);\n   }\n}\n", "X.java", "public record X<T>(T value) {\n}"}, "0");
        String expectedOutput = "  // Method descriptor #32 (Ljava/lang/Object;)V\n  // Signature: (TT;)V\n  // Stack: 2, Locals: 2\n  public X(java.lang.Object value);\n     0  aload_0 [this]\n     1  invokespecial java.lang.Record() [34]\n     4  aload_0 [this]\n     5  aload_1 [value]\n     6  putfield X.value : java.lang.Object [12]\n     9  return\n      Line numbers:\n        [pc: 0, line: 1]\n      Method Parameters:\n        value\n\n";
        this.verifyClassFile(expectedOutput, "X.class", 4);
        expectedOutput = "  // Method descriptor #9 ()Ljava/lang/Object;\n  // Signature: ()TT;\n  // Stack: 1, Locals: 1\n  public java.lang.Object value();\n";
        this.verifyClassFile(expectedOutput, "X.class", 4);
    }

    public void testBug561778_002() throws IOException, ClassFormatException {
        this.runConformTest(new String[]{"XTest.java", "public class XTest{\n\tstatic <T> Y<T> test(X<T> box) {\n\t\treturn box.value(); /* */\n\t}\n   public static void main(String[] args) {\n       System.out.println(0);\n   }\n}\n", "X.java", "public record X<T>(Y<T> value) {\n}\nclass Y<T> {\n}"}, "0");
        String expectedOutput = "  // Method descriptor #9 ()LY;\n  // Signature: ()LY<TT;>;\n  // Stack: 1, Locals: 1\n  public Y value();\n";
        this.verifyClassFile(expectedOutput, "X.class", 4);
    }

    public void testBug562219_001() {
        this.runConformTest(new String[]{"X.java", "public class X {\n       public static void main(String[] args) {\n               @SuppressWarnings(\"unused\")\n               class Y {\n                       class Z {\n                               record R() {\n                                       \n                               }\n                       }\n               }\n       }\n}\n"}, "");
    }

    public void testBug562219_002() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static void main(String[] args) {\n        @SuppressWarnings(\"unused\")\n        class Y {\n           record R() {}\n        }\n    }\n}\n"}, "");
    }

    public void test562250a() throws IOException, ClassFormatException {
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.*;\nimport java.lang.reflect.*;\n\nrecord Point(@Annot int a) {\n}\n@Retention(RetentionPolicy.RUNTIME)\n@interface Annot {\n}\npublic class X {\n\tpublic static void main(String[] args) throws Exception {\n\t\t\tClass<?> cls = Class.forName(\"Point\");\n\t\t\tRecordComponent[] recordComponents = cls.getRecordComponents();\n\t\t\tfor (RecordComponent recordComponent : recordComponents) {\n\t\t\t\tAnnotation[] annotations = recordComponent.getAnnotations();\n\t\t\t\tSystem.out.println(\"RecordComponents:\");\n\t\t\t\tfor (Annotation annot : annotations) {\n\t\t\t\t\tSystem.out.println(annot);\n\t\t\t\t}\n\t\t\t\tMethod accessor = recordComponent.getAccessor();\n\t\t\t\tSystem.out.println(\"Accessors:\");\n\t\t\t\tannotations =accessor.getAnnotations();\n\t\t\t\tfor (Annotation annot : annotations) {\n\t\t\t\t\tSystem.out.println(annot);\n\t\t\t\t}\n\t\t\t}\n\t}\n}"}, "RecordComponents:\n@Annot()\nAccessors:\n@Annot()");
    }

    public void test562250b() throws IOException, ClassFormatException {
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.*;\nimport java.lang.reflect.*;\n\nrecord Point(@Annot int a) {\n}\n@Target({ElementType.METHOD})\n@Retention(RetentionPolicy.RUNTIME)\n@interface Annot {\n}\npublic class X {\n\tpublic static void main(String[] args) throws Exception {\n\t\t\tClass<?> cls = Class.forName(\"Point\");\n\t\t\tRecordComponent[] recordComponents = cls.getRecordComponents();\n\t\t\tfor (RecordComponent recordComponent : recordComponents) {\n\t\t\t\tAnnotation[] annotations = recordComponent.getAnnotations();\n\t\t\t\tSystem.out.println(\"RecordComponents:\");\n\t\t\t\tfor (Annotation annot : annotations) {\n\t\t\t\t\tSystem.out.println(annot);\n\t\t\t\t}\n\t\t\t\tMethod accessor = recordComponent.getAccessor();\n\t\t\t\tSystem.out.println(\"Accessors:\");\n\t\t\t\tannotations =accessor.getAnnotations();\n\t\t\t\tfor (Annotation annot : annotations) {\n\t\t\t\t\tSystem.out.println(annot);\n\t\t\t\t}\n\t\t\t}\n\t}\n}"}, "RecordComponents:\nAccessors:\n@Annot()");
    }

    public void test562250c() throws IOException, ClassFormatException {
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.*;\nimport java.lang.reflect.*;\n\nrecord Point(@Annot int a) {\n}\n@Target({ElementType.FIELD})\n@Retention(RetentionPolicy.RUNTIME)\n@interface Annot {\n}\npublic class X {\n\tpublic static void main(String[] args) throws Exception {\n\t\t\tClass<?> cls = Class.forName(\"Point\");\n\t\t\tRecordComponent[] recordComponents = cls.getRecordComponents();\n\t\t\tfor (RecordComponent recordComponent : recordComponents) {\n\t\t\t\tAnnotation[] annotations = recordComponent.getAnnotations();\n\t\t\t\tSystem.out.println(\"RecordComponents:\");\n\t\t\t\tfor (Annotation annot : annotations) {\n\t\t\t\t\tSystem.out.println(annot);\n\t\t\t\t}\n\t\t\t\tMethod accessor = recordComponent.getAccessor();\n\t\t\t\tSystem.out.println(\"Accessors:\");\n\t\t\t\tannotations =accessor.getAnnotations();\n\t\t\t\tfor (Annotation annot : annotations) {\n\t\t\t\t\tSystem.out.println(annot);\n\t\t\t\t}\n\t\t\t}\n\t}\n}"}, "RecordComponents:\nAccessors:");
    }

    public void testBug562439_001() throws IOException, ClassFormatException {
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.ElementType;\nimport java.lang.annotation.Target;\n                          \npublic class X { \n  public static void main(String[] args){\n      Point p = new Point(100, 'a');\n      System.out.println(p.myInt());\n  } \n}\n\nrecord Point(@RC int myInt, char myChar) { \n}   \n\n@Target({ElementType.RECORD_COMPONENT})\n@interface RC {}\n"}, "100");
        String expectedOutput = "Record: #Record\nComponents:\n  \n// Component descriptor #6 I\nint myInt;\n  RuntimeInvisibleAnnotations: \n    #60 @RC(\n    )\n";
        this.verifyClassFile(expectedOutput, "Point.class", 4);
    }

    public void testBug562439_001_1() throws IOException, ClassFormatException {
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.Annotation;\nimport java.lang.annotation.ElementType;\nimport java.lang.annotation.Retention;\nimport java.lang.annotation.RetentionPolicy;\nimport java.lang.annotation.Target;\nimport java.lang.reflect.RecordComponent;\n\npublic class X {\n\n  public static void main(String[] args){\n      RecordComponent[] recordComponents = Point.class.getRecordComponents();\n      if (recordComponents.length != 2)\n    \t throw new AssertionError(\"Wrong number of components\");\n      Annotation[] annotations = recordComponents[0].getAnnotations();\n      if (annotations.length != 1)\n     \t throw new AssertionError(\"Wrong number of annotations\");\n      if (!annotations[0].toString().equals(\"@RC()\"))\n    \t  throw new AssertionError(\"Wrong annotation \" + annotations[0]);\n      annotations = recordComponents[1].getAnnotations();\n      if (annotations.length != 0)\n     \t throw new AssertionError(\"Wrong number of annotations\");\n    \t  System.out.println(\"All well!\");\n     }\n}\n\nrecord Point(@RC int myInt, char myChar) {\n}\n\n@Target({ElementType.RECORD_COMPONENT})\n@Retention(RetentionPolicy.RUNTIME)\n@interface RC {}\n"}, "All well!");
    }

    public void testBug562439_002() throws IOException, ClassFormatException {
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.ElementType;\nimport java.lang.annotation.Retention;\nimport java.lang.annotation.RetentionPolicy;\nimport java.lang.annotation.Target;\n                          \npublic class X { \n  public static void main(String[] args){\n         Point p = new Point(100, 'a');\n      System.out.println(p.myInt());\n  } \n}\n\nrecord Point(@RC int myInt, char myChar) { \n}   \n\n@Target({ElementType.RECORD_COMPONENT})\n@Retention(RetentionPolicy.RUNTIME)\n@interface RC {}\n"}, "100");
        String expectedOutput = "Record: #Record\nComponents:\n  \n// Component descriptor #6 I\nint myInt;\n  RuntimeVisibleAnnotations: \n    #60 @RC(\n    )\n";
        this.verifyClassFile(expectedOutput, "Point.class", 4);
    }

    public void testBug562439_003() throws IOException, ClassFormatException {
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.ElementType;\nimport java.lang.annotation.Target;\n                          \npublic class X { \n  public static void main(String[] args){\n         Point p = new Point(100, 'a');\n      System.out.println(p.myInt());\n  } \n}\n\nrecord Point(@RCF int myInt, char myChar) { \n}   \n@Target({ ElementType.RECORD_COMPONENT, ElementType.FIELD})\n@interface RCF {}\n"}, "100");
        String expectedOutput = "  // Field descriptor #6 I\n  private final int myInt;\n    RuntimeInvisibleAnnotations: \n      #8 @RCF(\n      )\n  \n";
        this.verifyClassFile(expectedOutput, "Point.class", 4);
        expectedOutput = "Record: #Record\nComponents:\n  \n// Component descriptor #6 I\nint myInt;\n  RuntimeInvisibleAnnotations: \n    #8 @RCF(\n    )\n";
        this.verifyClassFile(expectedOutput, "Point.class", 4);
    }

    public void testBug562439_004() throws IOException, ClassFormatException {
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.ElementType;\nimport java.lang.annotation.Retention;\nimport java.lang.annotation.RetentionPolicy;\nimport java.lang.annotation.Target;\n                          \npublic class X { \n  public static void main(String[] args){\n         Point p = new Point(100, 'a');\n      System.out.println(p.myInt());\n  } \n}\n\nrecord Point(@RCF int myInt, char myChar) { \n}   \n@Target({ ElementType.RECORD_COMPONENT, ElementType.FIELD})\n@Retention(RetentionPolicy.RUNTIME)\n@interface RCF {}\n"}, "100");
        String expectedOutput = "  // Field descriptor #6 I\n  private final int myInt;\n    RuntimeVisibleAnnotations: \n      #8 @RCF(\n      )\n  \n";
        this.verifyClassFile(expectedOutput, "Point.class", 4);
        expectedOutput = "Record: #Record\nComponents:\n  \n// Component descriptor #6 I\nint myInt;\n  RuntimeVisibleAnnotations: \n    #8 @RCF(\n    )\n";
        this.verifyClassFile(expectedOutput, "Point.class", 4);
    }

    public void testBug562439_005() throws IOException, ClassFormatException {
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.ElementType;\nimport java.lang.annotation.Target;\n                          \npublic class X { \n  public static void main(String[] args){\n         Point p = new Point(100, 'a');\n      System.out.println(p.myInt());\n  } \n}\n\nrecord Point(@RF int myInt, char myChar) { \n}   \n@Target({ElementType.FIELD})\n@interface RF {}\n"}, "100");
        String expectedOutput = "  // Field descriptor #6 I\n  private final int myInt;\n    RuntimeInvisibleAnnotations: \n      #8 @RF(\n      )\n  \n";
        this.verifyClassFile(expectedOutput, "Point.class", 4);
        expectedOutput = "Record: #Record\nComponents:\n  \n// Component descriptor #6 I\nint myInt;\n// Component descriptor #10 C\nchar myChar;\n";
        this.verifyClassFile(expectedOutput, "Point.class", 4);
    }

    public void testBug562439_006() throws IOException, ClassFormatException {
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.ElementType;\nimport java.lang.annotation.Retention;\nimport java.lang.annotation.RetentionPolicy;\nimport java.lang.annotation.Target;\n                          \npublic class X { \n  public static void main(String[] args){\n         Point p = new Point(100, 'a');\n      System.out.println(p.myInt());\n  } \n}\n\nrecord Point(@RF int myInt, char myChar) { \n}   \n@Target({ElementType.FIELD})\n@Retention(RetentionPolicy.RUNTIME)\n@interface RF {}\n"}, "100");
        String expectedOutput = "  // Field descriptor #6 I\n  private final int myInt;\n    RuntimeVisibleAnnotations: \n      #8 @RF(\n      )\n  \n";
        this.verifyClassFile(expectedOutput, "Point.class", 4);
        expectedOutput = "Record: #Record\nComponents:\n  \n// Component descriptor #6 I\nint myInt;\n// Component descriptor #10 C\nchar myChar;\n";
        this.verifyClassFile(expectedOutput, "Point.class", 4);
    }

    public void testBug562439_007() throws IOException, ClassFormatException {
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.ElementType;\nimport java.lang.annotation.Target;\n                          \npublic class X { \n  public static void main(String[] args){\n         Point p = new Point(100, 'a');\n      System.out.println(p.myInt());\n  } \n}\n\nrecord Point(@RCFU int myInt, char myChar) { \n}   \n@Target({ ElementType.RECORD_COMPONENT, ElementType.FIELD, ElementType.TYPE_USE})\n@interface RCFU {}\n"}, "100");
        String expectedOutput = "  // Field descriptor #6 I\n  private final int myInt;\n    RuntimeInvisibleAnnotations: \n      #8 @RCFU(\n      )\n    RuntimeInvisibleTypeAnnotations: \n      #8 @RCFU(\n        target type = 0x13 FIELD\n      )\n  \n";
        this.verifyClassFile(expectedOutput, "Point.class", 4);
        expectedOutput = "Record: #Record\nComponents:\n  \n// Component descriptor #6 I\nint myInt;\n  RuntimeInvisibleAnnotations: \n    #8 @RCFU(\n    )\n  RuntimeInvisibleTypeAnnotations: \n    #8 @RCFU(\n      target type = 0x13 FIELD\n    )\n";
        this.verifyClassFile(expectedOutput, "Point.class", 4);
    }

    public void testBug562439_008() throws IOException, ClassFormatException {
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.ElementType;\nimport java.lang.annotation.Retention;\nimport java.lang.annotation.RetentionPolicy;\nimport java.lang.annotation.Target;\n                          \npublic class X { \n  public static void main(String[] args){\n         Point p = new Point(100, 'a');\n      System.out.println(p.myInt());\n  } \n}\n\nrecord Point(@RCFU int myInt, char myChar) { \n}   \n@Target({ ElementType.RECORD_COMPONENT, ElementType.FIELD, ElementType.TYPE_USE})\n@Retention(RetentionPolicy.RUNTIME)\n@interface RCFU {}\n"}, "100");
        String expectedOutput = "  // Field descriptor #6 I\n  private final int myInt;\n    RuntimeVisibleAnnotations: \n      #8 @RCFU(\n      )\n    RuntimeVisibleTypeAnnotations: \n      #8 @RCFU(\n        target type = 0x13 FIELD\n      )\n  \n";
        this.verifyClassFile(expectedOutput, "Point.class", 4);
        expectedOutput = "Record: #Record\nComponents:\n  \n// Component descriptor #6 I\nint myInt;\n  RuntimeVisibleAnnotations: \n    #8 @RCFU(\n    )\n  RuntimeVisibleTypeAnnotations: \n    #8 @RCFU(\n      target type = 0x13 FIELD\n    )\n";
        this.verifyClassFile(expectedOutput, "Point.class", 4);
    }

    public void testBug562439_009() throws IOException, ClassFormatException {
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.ElementType;\nimport java.lang.annotation.Target;\n                          \npublic class X { \n  public static void main(String[] args){\n         Point p = new Point(100, 'a');\n      System.out.println(p.myInt());\n  } \n}\n\nrecord Point(@RCM int myInt, char myChar) { \n}   \n@Target({ ElementType.RECORD_COMPONENT, ElementType.METHOD})\n@interface RCM {}\n"}, "100");
        String expectedOutput = "  // Method descriptor #9 ()I\n  // Stack: 1, Locals: 1\n  public int myInt();\n    0  aload_0 [this]\n    1  getfield Point.myInt : int [13]\n    4  ireturn\n      Line numbers:\n        [pc: 0, line: 11]\n    RuntimeInvisibleAnnotations: \n      #11 @RCM(\n      )\n  \n";
        this.verifyClassFile(expectedOutput, "Point.class", 4);
        expectedOutput = "Record: #Record\nComponents:\n  \n// Component descriptor #6 I\nint myInt;\n  RuntimeInvisibleAnnotations: \n    #11 @RCM(\n    )\n// Component descriptor #8 C\nchar myChar;\n";
        this.verifyClassFile(expectedOutput, "Point.class", 4);
    }

    public void testBug562439_010() throws IOException, ClassFormatException {
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.ElementType;\nimport java.lang.annotation.Retention;\nimport java.lang.annotation.RetentionPolicy;\nimport java.lang.annotation.Target;\n                          \npublic class X { \n  public static void main(String[] args){\n         Point p = new Point(100, 'a');\n      System.out.println(p.myInt());\n  } \n}\n\nrecord Point(@RCM int myInt, char myChar) { \n}   \n@Target({ ElementType.RECORD_COMPONENT, ElementType.METHOD})\n@Retention(RetentionPolicy.RUNTIME)\n@interface RCM {}\n"}, "100");
        String expectedOutput = "  public int myInt();\n    0  aload_0 [this]\n    1  getfield Point.myInt : int [13]\n    4  ireturn\n      Line numbers:\n        [pc: 0, line: 13]\n    RuntimeVisibleAnnotations: \n      #11 @RCM(\n      )\n";
        this.verifyClassFile(expectedOutput, "Point.class", 4);
        expectedOutput = "Record: #Record\nComponents:\n  \n// Component descriptor #6 I\nint myInt;\n  RuntimeVisibleAnnotations: \n    #11 @RCM(\n    )\n// Component descriptor #8 C\nchar myChar;\n";
        this.verifyClassFile(expectedOutput, "Point.class", 4);
    }

    public void testBug562439_011() throws IOException, ClassFormatException {
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.ElementType;\nimport java.lang.annotation.Target;\n                          \npublic class X { \n  public static void main(String[] args){\n         Point p = new Point(100, 'a');\n      System.out.println(p.myInt());\n  } \n}\n\nrecord Point(@M int myInt, char myChar) { \n}   \n@Target({ElementType.METHOD})\n@interface M {}\n"}, "100");
        String expectedOutput = "  // Method descriptor #9 ()I\n  // Stack: 1, Locals: 1\n  public int myInt();\n    0  aload_0 [this]\n    1  getfield Point.myInt : int [13]\n    4  ireturn\n      Line numbers:\n        [pc: 0, line: 11]\n    RuntimeInvisibleAnnotations: \n      #11 @M(\n      )\n  \n";
        this.verifyClassFile(expectedOutput, "Point.class", 4);
        expectedOutput = "Record: #Record\nComponents:\n  \n// Component descriptor #6 I\nint myInt;\n// Component descriptor #8 C\nchar myChar;\n";
        this.verifyClassFile(expectedOutput, "Point.class", 4);
    }

    public void testBug562439_012() throws IOException, ClassFormatException {
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.ElementType;\nimport java.lang.annotation.Retention;\nimport java.lang.annotation.RetentionPolicy;\nimport java.lang.annotation.Target;\n                          \npublic class X { \n  public static void main(String[] args){\n         Point p = new Point(100, 'a');\n      System.out.println(p.myInt());\n  } \n}\n\nrecord Point(@M int myInt, char myChar) { \n}   \n@Target({ElementType.METHOD})\n@Retention(RetentionPolicy.RUNTIME)\n@interface M {}\n"}, "100");
        String expectedOutput = "  public int myInt();\n    0  aload_0 [this]\n    1  getfield Point.myInt : int [13]\n    4  ireturn\n      Line numbers:\n        [pc: 0, line: 13]\n    RuntimeVisibleAnnotations: \n      #11 @M(\n      )\n";
        this.verifyClassFile(expectedOutput, "Point.class", 4);
        expectedOutput = "Record: #Record\nComponents:\n  \n// Component descriptor #6 I\nint myInt;\n// Component descriptor #8 C\nchar myChar;\n";
        this.verifyClassFile(expectedOutput, "Point.class", 4);
    }

    public void testBug562439_013() throws IOException, ClassFormatException {
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.ElementType;\nimport java.lang.annotation.Target;\n                          \npublic class X { \n  public static void main(String[] args){\n         Point p = new Point(100, 'a');\n      System.out.println(p.myInt());\n  } \n}\n\nrecord Point(@RCMU int myInt, char myChar) { \n}   \n@Target({ ElementType.RECORD_COMPONENT, ElementType.METHOD, ElementType.TYPE_USE})\n@interface RCMU {}\n"}, "100");
        String expectedOutput = "  // Field descriptor #6 I\n  private final int myInt;\n    RuntimeInvisibleTypeAnnotations: \n      #8 @RCMU(\n        target type = 0x13 FIELD\n      )\n  \n";
        this.verifyClassFile(expectedOutput, "Point.class", 4);
        expectedOutput = "  // Method descriptor #11 ()I\n  // Stack: 1, Locals: 1\n  public int myInt();\n    0  aload_0 [this]\n    1  getfield Point.myInt : int [14]\n    4  ireturn\n      Line numbers:\n        [pc: 0, line: 11]\n    RuntimeInvisibleAnnotations: \n      #8 @RCMU(\n      )\n    RuntimeInvisibleTypeAnnotations: \n      #8 @RCMU(\n        target type = 0x14 METHOD_RETURN\n      )\n  \n";
        this.verifyClassFile(expectedOutput, "Point.class", 4);
        expectedOutput = "// Component descriptor #6 I\nint myInt;\n  RuntimeInvisibleAnnotations: \n    #8 @RCMU(\n    )\n  RuntimeInvisibleTypeAnnotations: \n    #8 @RCMU(\n      target type = 0x13 FIELD\n    )\n";
        this.verifyClassFile(expectedOutput, "Point.class", 4);
    }

    public void testBug562439_014() throws IOException, ClassFormatException {
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.ElementType;\nimport java.lang.annotation.Retention;\nimport java.lang.annotation.RetentionPolicy;\nimport java.lang.annotation.Target;\n                          \npublic class X { \n  public static void main(String[] args){\n         Point p = new Point(100, 'a');\n      System.out.println(p.myInt());\n  } \n}\n\nrecord Point(@RCMU int myInt, char myChar) { \n}   \n@Target({ ElementType.RECORD_COMPONENT, ElementType.METHOD, ElementType.TYPE_USE})\n@Retention(RetentionPolicy.RUNTIME)\n@interface RCMU {}\n"}, "100");
        String expectedOutput = "  // Field descriptor #6 I\n  private final int myInt;\n    RuntimeVisibleTypeAnnotations: \n      #8 @RCMU(\n        target type = 0x13 FIELD\n      )\n  \n";
        this.verifyClassFile(expectedOutput, "Point.class", 4);
        expectedOutput = "  // Method descriptor #11 ()I\n  // Stack: 1, Locals: 1\n  public int myInt();\n    0  aload_0 [this]\n    1  getfield Point.myInt : int [14]\n    4  ireturn\n      Line numbers:\n        [pc: 0, line: 13]\n    RuntimeVisibleAnnotations: \n      #8 @RCMU(\n      )\n";
        this.verifyClassFile(expectedOutput, "Point.class", 4);
        expectedOutput = "Record: #Record\nComponents:\n  \n// Component descriptor #6 I\nint myInt;\n  RuntimeVisibleAnnotations: \n    #8 @RCMU(\n    )\n  RuntimeVisibleTypeAnnotations: \n    #8 @RCMU(\n      target type = 0x13 FIELD\n    )\n";
        this.verifyClassFile(expectedOutput, "Point.class", 4);
    }

    public void testBug562439_015() throws IOException, ClassFormatException {
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.ElementType;\nimport java.lang.annotation.Target;\n                          \npublic class X { \n  public static void main(String[] args){\n      Point p = new Point(100, 'a');\n      System.out.println(p.myInt());\n  } \n}\n\nrecord Point(@T int myInt, char myChar) { \n}   \n\n@Target({ElementType.TYPE_USE})\n@interface T {}\n"}, "100");
        String expectedOutput = "  // Field descriptor #6 I\n  private final int myInt;\n    RuntimeInvisibleTypeAnnotations: \n      #8 @T(\n        target type = 0x13 FIELD\n      )\n  \n";
        this.verifyClassFile(expectedOutput, "Point.class", 4);
        expectedOutput = "  // Method descriptor #11 ()I\n  // Stack: 1, Locals: 1\n  public int myInt();\n    0  aload_0 [this]\n    1  getfield Point.myInt : int [13]\n    4  ireturn\n      Line numbers:\n        [pc: 0, line: 11]\n    RuntimeInvisibleTypeAnnotations: \n      #8 @T(\n        target type = 0x14 METHOD_RETURN\n      )\n  ";
        this.verifyClassFile(expectedOutput, "Point.class", 4);
        expectedOutput = "Record: #Record\nComponents:\n  \n// Component descriptor #6 I\nint myInt;\n  RuntimeInvisibleTypeAnnotations: \n    #8 @T(\n      target type = 0x13 FIELD\n    )\n";
        this.verifyClassFile(expectedOutput, "Point.class", 4);
        expectedOutput = "  Point(int myInt, char myChar);\n     0  aload_0 [this]\n     1  invokespecial java.lang.Record() [36]\n     4  aload_0 [this]\n     5  iload_1 [myInt]\n     6  putfield Point.myInt : int [13]\n     9  aload_0 [this]\n    10  iload_2 [myChar]\n    11  putfield Point.myChar : char [18]\n    14  return\n      Line numbers:\n        [pc: 0, line: 1]\n      Method Parameters:\n        myInt\n        myChar\n    RuntimeInvisibleTypeAnnotations: \n      #8 @T(\n        target type = 0x16 METHOD_FORMAL_PARAMETER\n        method parameter index = 0\n      )\n";
        this.verifyClassFile(expectedOutput, "Point.class", 4);
    }

    public void testBug562439_016() throws IOException, ClassFormatException {
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.ElementType;\nimport java.lang.annotation.Retention;\nimport java.lang.annotation.RetentionPolicy;\nimport java.lang.annotation.Target;\n                          \npublic class X { \n  public static void main(String[] args){\n         Point p = new Point(100, 'a');\n      System.out.println(p.myInt());\n  } \n}\n\nrecord Point(@T int myInt, char myChar) { \n}   \n\n@Target({ElementType.TYPE_USE})\n@Retention(RetentionPolicy.RUNTIME)\n@interface T {}\n"}, "100");
        String expectedOutput = "  // Field descriptor #6 I\n  private final int myInt;\n    RuntimeVisibleTypeAnnotations: \n      #8 @T(\n        target type = 0x13 FIELD\n      )\n  \n";
        this.verifyClassFile(expectedOutput, "Point.class", 4);
        expectedOutput = "  public int myInt();\n    0  aload_0 [this]\n    1  getfield Point.myInt : int [13]\n    4  ireturn\n      Line numbers:\n        [pc: 0, line: 13]\n    RuntimeVisibleTypeAnnotations: \n      #8 @T(\n        target type = 0x14 METHOD_RETURN\n      )\n  ";
        this.verifyClassFile(expectedOutput, "Point.class", 4);
        expectedOutput = "Record: #Record\nComponents:\n  \n// Component descriptor #6 I\nint myInt;\n  RuntimeVisibleTypeAnnotations: \n    #8 @T(\n      target type = 0x13 FIELD\n    )\n";
        this.verifyClassFile(expectedOutput, "Point.class", 4);
        expectedOutput = "  Point(int myInt, char myChar);\n     0  aload_0 [this]\n     1  invokespecial java.lang.Record() [36]\n     4  aload_0 [this]\n     5  iload_1 [myInt]\n     6  putfield Point.myInt : int [13]\n     9  aload_0 [this]\n    10  iload_2 [myChar]\n    11  putfield Point.myChar : char [18]\n    14  return\n      Line numbers:\n        [pc: 0, line: 1]\n      Method Parameters:\n        myInt\n        myChar\n    RuntimeVisibleTypeAnnotations: \n      #8 @T(\n        target type = 0x16 METHOD_FORMAL_PARAMETER\n        method parameter index = 0\n      )\n\n";
        this.verifyClassFile(expectedOutput, "Point.class", 4);
    }

    public void testBug562439_017() throws IOException, ClassFormatException {
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.ElementType;\nimport java.lang.annotation.Target;\n                          \npublic class X { \n  public static void main(String[] args){\n         Point p = new Point(100, 'a');\n      System.out.println(p.myInt());\n  } \n}\n\nrecord Point(@RCP int myInt, char myChar) { \n}   \n@Target({ ElementType.RECORD_COMPONENT, ElementType.PARAMETER})\n@interface RCP {}\n"}, "100");
        String expectedOutput = "  Point(int myInt, char myChar);\n     0  aload_0 [this]\n     1  invokespecial java.lang.Record() [36]\n     4  aload_0 [this]\n     5  iload_1 [myInt]\n     6  putfield Point.myInt : int [11]\n     9  aload_0 [this]\n    10  iload_2 [myChar]\n    11  putfield Point.myChar : char [16]\n    14  return\n      Line numbers:\n        [pc: 0, line: 1]\n      Method Parameters:\n        myInt\n        myChar\n    RuntimeInvisibleParameterAnnotations: \n      Number of annotations for parameter 0: 1\n        #35 @RCP(\n        )\n      Number of annotations for parameter 1: 0\n\n";
        this.verifyClassFile(expectedOutput, "Point.class", 4);
        expectedOutput = "Record: #Record\nComponents:\n  \n// Component descriptor #6 I\nint myInt;\n  RuntimeInvisibleAnnotations: \n    #35 @RCP(\n    )\n";
        this.verifyClassFile(expectedOutput, "Point.class", 4);
    }

    public void testBug562439_018() throws IOException, ClassFormatException {
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.ElementType;\nimport java.lang.annotation.Retention;\nimport java.lang.annotation.RetentionPolicy;\nimport java.lang.annotation.Target;\n                          \npublic class X { \n  public static void main(String[] args){\n         Point p = new Point(100, 'a');\n      System.out.println(p.myInt());\n  } \n}\n\nrecord Point(@RCP int myInt, char myChar) { \n}   \n@Target({ ElementType.RECORD_COMPONENT, ElementType.PARAMETER})\n@Retention(RetentionPolicy.RUNTIME)\n@interface RCP {}\n"}, "100");
        String expectedOutput = "  Point(int myInt, char myChar);\n     0  aload_0 [this]\n     1  invokespecial java.lang.Record() [36]\n     4  aload_0 [this]\n     5  iload_1 [myInt]\n     6  putfield Point.myInt : int [11]\n     9  aload_0 [this]\n    10  iload_2 [myChar]\n    11  putfield Point.myChar : char [16]\n    14  return\n      Line numbers:\n        [pc: 0, line: 1]\n      Method Parameters:\n        myInt\n        myChar\n    RuntimeVisibleParameterAnnotations: \n      Number of annotations for parameter 0: 1\n        #35 @RCP(\n        )\n      Number of annotations for parameter 1: 0\n\n";
        this.verifyClassFile(expectedOutput, "Point.class", 4);
        expectedOutput = "Record: #Record\nComponents:\n  \n// Component descriptor #6 I\nint myInt;\n  RuntimeVisibleAnnotations: \n    #35 @RCP(\n    )\n";
        this.verifyClassFile(expectedOutput, "Point.class", 4);
    }

    public void testBug562439_019() throws IOException, ClassFormatException {
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.ElementType;\nimport java.lang.annotation.Target;\n                          \npublic class X { \n  public static void main(String[] args){\n         Point p = new Point(100, 'a');\n      System.out.println(p.myInt());\n  } \n}\n\nrecord Point(@Annot int myInt, char myChar) { \n}   \n@interface Annot {}\n"}, "100");
        String expectedOutput = "  // Field descriptor #6 I\n  private final int myInt;\n    RuntimeInvisibleAnnotations: \n      #8 @Annot(\n      )\n  \n";
        this.verifyClassFile(expectedOutput, "Point.class", 4);
        expectedOutput = "  Point(int myInt, char myChar);\n     0  aload_0 [this]\n     1  invokespecial java.lang.Record() [37]\n     4  aload_0 [this]\n     5  iload_1 [myInt]\n     6  putfield Point.myInt : int [13]\n     9  aload_0 [this]\n    10  iload_2 [myChar]\n    11  putfield Point.myChar : char [18]\n    14  return\n      Line numbers:\n        [pc: 0, line: 1]\n      Method Parameters:\n        myInt\n        myChar\n    RuntimeInvisibleParameterAnnotations: \n      Number of annotations for parameter 0: 1\n        #8 @Annot(\n        )\n      Number of annotations for parameter 1: 0\n\n";
        this.verifyClassFile(expectedOutput, "Point.class", 4);
        expectedOutput = "  // Method descriptor #11 ()I\n  // Stack: 1, Locals: 1\n  public int myInt();\n    0  aload_0 [this]\n    1  getfield Point.myInt : int [13]\n    4  ireturn\n      Line numbers:\n        [pc: 0, line: 11]\n    RuntimeInvisibleAnnotations: \n      #8 @Annot(\n      )\n";
        this.verifyClassFile(expectedOutput, "Point.class", 4);
        expectedOutput = "Record: #Record\nComponents:\n  \n// Component descriptor #6 I\nint myInt;\n  RuntimeInvisibleAnnotations: \n    #8 @Annot(\n    )\n";
        this.verifyClassFile(expectedOutput, "Point.class", 4);
    }

    public void testBug562439_020() throws IOException, ClassFormatException {
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.ElementType;\nimport java.lang.annotation.Retention;\nimport java.lang.annotation.RetentionPolicy;\nimport java.lang.annotation.Target;\n                          \npublic class X { \n  public static void main(String[] args){\n         Point p = new Point(100, 'a');\n      System.out.println(p.myInt());\n  } \n}\n\nrecord Point(@Annot int myInt, char myChar) { \n}   \n@Target({ ElementType.RECORD_COMPONENT, ElementType.PARAMETER})\n@Retention(RetentionPolicy.RUNTIME)\n@interface Annot {}\n"}, "100");
        String expectedOutput = "  Point(int myInt, char myChar);\n     0  aload_0 [this]\n     1  invokespecial java.lang.Record() [36]\n     4  aload_0 [this]\n     5  iload_1 [myInt]\n     6  putfield Point.myInt : int [11]\n     9  aload_0 [this]\n    10  iload_2 [myChar]\n    11  putfield Point.myChar : char [16]\n    14  return\n      Line numbers:\n        [pc: 0, line: 1]\n      Method Parameters:\n        myInt\n        myChar\n    RuntimeVisibleParameterAnnotations: \n      Number of annotations for parameter 0: 1\n        #35 @Annot(\n        )\n      Number of annotations for parameter 1: 0\n\n";
        this.verifyClassFile(expectedOutput, "Point.class", 4);
        expectedOutput = "Record: #Record\nComponents:\n  \n// Component descriptor #6 I\nint myInt;\n  RuntimeVisibleAnnotations: \n    #35 @Annot(\n    )\n";
        this.verifyClassFile(expectedOutput, "Point.class", 4);
    }

    public void testBug563178_001() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\nrecord Point(final int x, int y){\n}"}, "----------\n1. ERROR in X.java (at line 6)\n\trecord Point(final int x, int y){\n\t                       ^\nA record component x cannot have modifiers\n----------\n");
    }

    public void testBug563183_001() {
        this.runConformTest(new String[]{"X.java", "public record X() {\n  public X() {}\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}"}, "0");
    }

    public void testBug563183_002() {
        this.runConformTest(new String[]{"X.java", "public record X() {\n  public X {}\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}"}, "0");
    }

    public void testBug563183_003() {
        this.runNegativeTest(new String[]{"X.java", "public record X() {\n  protected X() {}\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\tprotected X() {}\n\t          ^^^\nCannot reduce the visibility of a canonical constructor X from that of the record\n----------\n");
    }

    public void testBug563183_004() {
        this.runNegativeTest(new String[]{"X.java", "public record X() {\n  protected X {}\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\tprotected X {}\n\t          ^\nCannot reduce the visibility of a canonical constructor X from that of the record\n----------\n");
    }

    public void testBug563183_005() {
        this.runNegativeTest(new String[]{"X.java", "public record X() {\n  /*package */ X() {}\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\t/*package */ X() {}\n\t             ^^^\nCannot reduce the visibility of a canonical constructor X from that of the record\n----------\n");
    }

    public void testBug563183_006() {
        this.runNegativeTest(new String[]{"X.java", "public record X() {\n  /*package */ X {}\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\t/*package */ X {}\n\t             ^\nCannot reduce the visibility of a canonical constructor X from that of the record\n----------\n");
    }

    public void testBug563183_007() {
        this.runNegativeTest(new String[]{"X.java", "public record X() {\n  private X() {}\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\tprivate X() {}\n\t        ^^^\nCannot reduce the visibility of a canonical constructor X from that of the record\n----------\n");
    }

    public void testBug563183_008() {
        this.runNegativeTest(new String[]{"X.java", "public record X() {\n  private X {}\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\tprivate X {}\n\t        ^\nCannot reduce the visibility of a canonical constructor X from that of the record\n----------\n");
    }

    public void testBug563183_009() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  protected record R() {\n    public R() {}\n  }\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}"}, "0");
    }

    public void testBug563183_010() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  protected record R() {\n    public R {}\n  }\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}"}, "0");
    }

    public void testBug563183_011() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  protected record R() {\n    protected R() {}\n  }\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}"}, "0");
    }

    public void testBug563183_012() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  protected record R() {\n    protected R {}\n  }\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}"}, "0");
    }

    public void testBug563183_013() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  protected record R() {\n    /*package */ R() {}\n  }\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\t/*package */ R() {}\n\t             ^^^\nCannot reduce the visibility of a canonical constructor R from that of the record\n----------\n");
    }

    public void testBug563183_014() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  protected record R() {\n    /*package */ R {}\n  }\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\t/*package */ R {}\n\t             ^\nCannot reduce the visibility of a canonical constructor R from that of the record\n----------\n");
    }

    public void testBug563183_015() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  protected record R() {\n    private R() {}\n  }\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tprivate R() {}\n\t        ^^^\nCannot reduce the visibility of a canonical constructor R from that of the record\n----------\n");
    }

    public void testBug563183_016() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  protected record R() {\n    private R {}\n  }\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tprivate R {}\n\t        ^\nCannot reduce the visibility of a canonical constructor R from that of the record\n----------\n");
    }

    public void testBug563183_017() {
        this.runConformTest(new String[]{"X.java", "/*package */ record X() {\n  public X() {}\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}"}, "0");
    }

    public void testBug563183_018() {
        this.runConformTest(new String[]{"X.java", "/*package */ record X() {\n  public X {}\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}"}, "0");
    }

    public void testBug563183_019() {
        this.runConformTest(new String[]{"X.java", "record X() {\n  protected X() {}\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}"}, "0");
    }

    public void testBug563183_020() {
        this.runConformTest(new String[]{"X.java", "record X() {\n  protected X {}\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}"}, "0");
    }

    public void testBug563183_021() {
        this.runConformTest(new String[]{"X.java", " record X() {\n  /*package */ X() {}\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}"}, "0");
    }

    public void testBug563183_022() {
        this.runConformTest(new String[]{"X.java", " record X() {\n  /*package */ X {}\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}"}, "0");
    }

    public void testBug563183_023() {
        this.runNegativeTest(new String[]{"X.java", "record X() {\n  private X() {}\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\tprivate X() {}\n\t        ^^^\nCannot reduce the visibility of a canonical constructor X from that of the record\n----------\n");
    }

    public void testBug563183_024() {
        this.runNegativeTest(new String[]{"X.java", "record X() {\n  private X {}\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\tprivate X {}\n\t        ^\nCannot reduce the visibility of a canonical constructor X from that of the record\n----------\n");
    }

    public void testBug563183_025() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  private record R() {\n    public R() {}\n  }\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}"}, "0");
    }

    public void testBug563183_026() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  private record R() {\n    protected R {}\n  }\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}"}, "0");
    }

    public void testBug563183_027() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  private record R() {\n    /* package */ R() {}\n  }\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}"}, "0");
    }

    public void testBug563183_028() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  private record R() {\n    private R {}\n  }\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}"}, "0");
    }

    public void testBug563184_001() {
        this.runNegativeTest(new String[]{"X.java", "record X(int angel) {\n  X(int devil) {\n     this.angel = devil;\n  }\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\tX(int devil) {\n\t      ^^^^^\nIllegal parameter name devil in canonical constructor, expected angel, the corresponding component name\n----------\n");
    }

    public void testBug563184_002() {
        this.runConformTest(new String[]{"X.java", "record X(int myInt) {\n  X(int myInt) {\n     this.myInt = myInt;\n  }\n  X(int i, int j) {\n    this(i);\n  }\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}"}, "0");
    }

    public void testBug562637_001() {
        this.runConformTest(new String[]{"X.java", "public record X(int i) {\n    public X {\n            i = i/2;\n    }\n    public static void main(String[] args) {\n            System.out.println(new X(10).i());\n    }\n}"}, "5");
    }

    public void testBug563181_01() throws IOException, ClassFormatException {
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.ElementType;\nimport java.lang.annotation.Target;\npublic class X { \n  public static void main(String[] args){}\n}\nrecord Point(@RCMU int myInt, char myChar) { \n  public int myInt(){\n     return this.myInt;\n  }\n}   \n@Target({ ElementType.RECORD_COMPONENT, ElementType.METHOD, ElementType.TYPE_USE})\n@interface RCMU {}\n"}, "");
        String expectedOutput = "  // Method descriptor #11 ()I\n  // Stack: 1, Locals: 1\n  public int myInt();\n    0  aload_0 [this]\n    1  getfield Point.myInt : int [13]\n    4  ireturn\n      Line numbers:\n        [pc: 0, line: 8]\n      Local variable table:\n        [pc: 0, pc: 5] local: this index: 0 type: Point\n  \n";
        this.verifyClassFile(expectedOutput, "Point.class", 4);
    }

    public void testBug563181_02() throws IOException, ClassFormatException {
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.ElementType;\nimport java.lang.annotation.Target;\npublic class X { \n  public static void main(String[] args){}\n}\nrecord Point(@RCMU int myInt, char myChar) {\n  @RCMU public int myInt(){\n     return this.myInt;\n  }\n}\n@Target({ ElementType.RECORD_COMPONENT, ElementType.METHOD, ElementType.TYPE_USE})\n@interface RCMU {}\n"}, "");
        String expectedOutput = "  // Method descriptor #11 ()I\n  // Stack: 1, Locals: 1\n  public int myInt();\n    0  aload_0 [this]\n    1  getfield Point.myInt : int [14]\n    4  ireturn\n      Line numbers:\n        [pc: 0, line: 8]\n      Local variable table:\n        [pc: 0, pc: 5] local: this index: 0 type: Point\n    RuntimeInvisibleAnnotations: \n      #8 @RCMU(\n      )\n    RuntimeInvisibleTypeAnnotations: \n      #8 @RCMU(\n        target type = 0x14 METHOD_RETURN\n      )\n  \n";
        this.verifyClassFile(expectedOutput, "Point.class", 4);
    }

    public void testBug563181_03() throws IOException, ClassFormatException {
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.*;\npublic class X { \n  public static void main(String[] args){}\n}\nrecord Point(@TypeAnnot @SimpleAnnot int myInt, char myChar) {}\n@Target({ ElementType.RECORD_COMPONENT, ElementType.METHOD})\n@Retention(RetentionPolicy.RUNTIME)\n@interface SimpleAnnot {}\n@Target({ ElementType.RECORD_COMPONENT, ElementType.TYPE_USE})\n@Retention(RetentionPolicy.RUNTIME)\n@interface TypeAnnot {}\n"}, "");
        String expectedOutput = "  // Method descriptor #11 ()I\n  // Stack: 1, Locals: 1\n  public int myInt();\n    0  aload_0 [this]\n    1  getfield Point.myInt : int [15]\n    4  ireturn\n      Line numbers:\n        [pc: 0, line: 5]\n    RuntimeVisibleAnnotations: \n      #13 @SimpleAnnot(\n      )\n    RuntimeVisibleTypeAnnotations: \n      #8 @TypeAnnot(\n        target type = 0x14 METHOD_RETURN\n      )\n  \n";
        this.verifyClassFile(expectedOutput, "Point.class", 4);
    }

    public void testBug563181_04() throws IOException, ClassFormatException {
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.*;\npublic class X { \n  public static void main(String[] args){}\n}\nrecord Point(@TypeAnnot @SimpleAnnot int myInt, char myChar) {\n  @TypeAnnot @SimpleAnnot public int myInt(){\n     return this.myInt;\n  }\n}\n@Target({ ElementType.RECORD_COMPONENT, ElementType.METHOD})\n@Retention(RetentionPolicy.RUNTIME)\n@interface SimpleAnnot {}\n@Target({ ElementType.RECORD_COMPONENT, ElementType.TYPE_USE})\n@Retention(RetentionPolicy.RUNTIME)\n@interface TypeAnnot {}\n"}, "");
        String expectedOutput = " // Method descriptor #11 ()I\n  // Stack: 1, Locals: 1\n  public int myInt();\n    0  aload_0 [this]\n    1  getfield Point.myInt : int [15]\n    4  ireturn\n      Line numbers:\n        [pc: 0, line: 7]\n      Local variable table:\n        [pc: 0, pc: 5] local: this index: 0 type: Point\n    RuntimeVisibleAnnotations: \n      #13 @SimpleAnnot(\n      )\n    RuntimeVisibleTypeAnnotations: \n      #8 @TypeAnnot(\n        target type = 0x14 METHOD_RETURN\n      )\n  \n";
        this.verifyClassFile(expectedOutput, "Point.class", 4);
    }

    public void testBug565104_001() throws IOException, ClassFormatException {
        this.runConformTest(new String[]{"X.java", "public class X { \n  public record R() {}\n  public static void main(String[] args){}\n}\n"}, "");
        String expectedOutput = "  // Stack: 1, Locals: 1\n  public X$R();\n    0  aload_0 [this]\n";
        this.verifyClassFile(expectedOutput, "X$R.class", 4);
    }

    public void testBug565104_002() throws IOException, ClassFormatException {
        this.runConformTest(new String[]{"X.java", "public class X { \n  record R() {}\n  public static void main(String[] args){}\n}\n"}, "");
        String expectedOutput = "  // Stack: 1, Locals: 1\n  X$R();\n    0  aload_0 [this]\n";
        this.verifyClassFile(expectedOutput, "X$R.class", 4);
    }

    public void testBug565104_003() throws IOException, ClassFormatException {
        this.runConformTest(new String[]{"X.java", "public class X { \n  protected record R() {}\n  public static void main(String[] args){}\n}\n"}, "");
        String expectedOutput = "  // Stack: 1, Locals: 1\n  protected X$R();\n    0  aload_0 [this]\n";
        this.verifyClassFile(expectedOutput, "X$R.class", 4);
    }

    public void testBug565104_004() throws IOException, ClassFormatException {
        this.runConformTest(new String[]{"X.java", "public class X { \n  private record R() {}\n  public static void main(String[] args){}\n}\n"}, "");
        String expectedOutput = "  // Stack: 1, Locals: 1\n  private X$R();\n    0  aload_0 [this]\n";
        this.verifyClassFile(expectedOutput, "X$R.class", 4);
    }

    public void testBug564146_001() {
        this.runNegativeTest(new String[]{"X.java", "public record X(int i) {\n  public X() {\n    this.i = 10;\n  }\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\tpublic X() {\n\t       ^^^\nA non-canonical constructor must start with an explicit invocation to a constructor\n----------\n");
    }

    public void testBug564146_002() {
        this.runNegativeTest(new String[]{"X.java", "public record X(int i) {\n  public X() {\n    super();\n    this.i = 10;\n  }\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\tpublic X() {\n\t       ^^^\nA non-canonical constructor must start with an explicit invocation to a constructor\n----------\n");
    }

    public void testBug564146_003() {
        this.runNegativeTest(new String[]{"X.java", "public record X(int i) {\n  public X(int i) {\n    this.i = 10;\n    Zork();\n  }\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\tZork();\n\t^^^^\nThe method Zork() is undefined for the type X\n----------\n");
    }

    public void testBug564146_004() {
        this.runConformTest(new String[]{"X.java", "public record X(int i) {\n public X() {\n   this(10);\n }\n public static void main(String[] args) {\n   System.out.println(new X().i());\n }\n}"}, "10");
    }

    public void testBug564146_005() {
        this.runNegativeTest(new String[]{"X.java", "public record X() {\n public X(int i) {\n   this(10);\n }\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tthis(10);\n\t^^^^^^^^^\nRecursive constructor invocation X(int)\n----------\n");
    }

    public void testBug564146_006() {
        this.runNegativeTest(new String[]{"X.java", "public record X() {\n public X() {\n   this(10);\n }\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tthis(10);\n\t^^^^^^^^^\nThe body of a canonical constructor must not contain an explicit constructor call\n----------\n");
    }

    public void testBug564146_007() {
        this.runConformTest(new String[]{"X.java", "public record X(int i) {\n public X() {\n   this(10);\n }\n public X(int i, int k) {\n   this();\n }\n public static void main(String[] args) {\n   System.out.println(new X(2, 3).i());\n }\n}"}, "10");
    }

    public void testBug564672_001() {
        this.runNegativeTest(new String[]{"X.java", "class X extends record {\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\nclass record {}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tclass X extends record {\n\t                ^^^^^^\n'record' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 16\n----------\n2. ERROR in X.java (at line 6)\n\tclass record {}\n\t      ^^^^^^\n'record' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 16\n----------\n");
    }

    public void testBug564672_002() {
        this.runNegativeTest(new String[]{"X.java", "class X extends record {\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tclass X extends record {\n\t                ^^^^^^\n'record' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 16\n----------\n");
    }

    public void testBug564672_003() {
        this.runNegativeTest(new String[]{"X.java", "class X implements record {\n  public static void main(String[] args){\n     System.out.println(0);\n  }\ninterface record {}\n;}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tclass X implements record {\n\t                   ^^^^^^\n'record' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 16\n----------\n2. ERROR in X.java (at line 5)\n\tinterface record {}\n\t          ^^^^^^\n'record' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 16\n----------\n");
    }

    public void testBug564672_004() {
        this.runNegativeTest(new String[]{"X.java", "class X implements record {\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tclass X implements record {\n\t                   ^^^^^^\n'record' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 16\n----------\n");
    }

    public void testBug564672_005() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n  class Y extends record {\n  }\n  class record {}\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tclass Y extends record {\n\t                ^^^^^^\n'record' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 16\n----------\n2. ERROR in X.java (at line 4)\n\tclass record {}\n\t      ^^^^^^\n'record' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 16\n----------\n");
    }

    public void testBug564672_006() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n  class Y extends record {\n  }\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tclass Y extends record {\n\t                ^^^^^^\n'record' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 16\n----------\n");
    }

    public void testBug564672_007() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n  class Y implements record {\n  }\n  interface record {}\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tclass Y implements record {\n\t                   ^^^^^^\n'record' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 16\n----------\n2. ERROR in X.java (at line 4)\n\tinterface record {}\n\t          ^^^^^^\n'record' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 16\n----------\n");
    }

    public void testBug564672_008() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n  class Y implements record {\n  }\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tclass Y implements record {\n\t                   ^^^^^^\n'record' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 16\n----------\n");
    }

    public void testBug564672_009() {
        this.runNegativeTest(new String[]{"X.java", "interface Y extends record {\n}\ninterface record {}\nclass X {\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tinterface Y extends record {\n\t                    ^^^^^^\n'record' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 16\n----------\n2. ERROR in X.java (at line 3)\n\tinterface record {}\n\t          ^^^^^^\n'record' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 16\n----------\n");
    }

    public void testBug564672_010() {
        this.runNegativeTest(new String[]{"X.java", "interface Y extends record {\n}\nclass X {\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tinterface Y extends record {\n\t                    ^^^^^^\n'record' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 16\n----------\n");
    }

    public void testBug564672_011() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n  interface Y extends record {\n  }\n  interface record {}\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tinterface Y extends record {\n\t                    ^^^^^^\n'record' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 16\n----------\n2. ERROR in X.java (at line 4)\n\tinterface record {}\n\t          ^^^^^^\n'record' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 16\n----------\n");
    }

    public void testBug564672_012() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n  interface Y extends record {\n  }\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tinterface Y extends record {\n\t                    ^^^^^^\n'record' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 16\n----------\n");
    }

    public void testBug564672_013() {
        this.runNegativeTest(new String[]{"X.java", "interface X {\n  class Y extends record {\n  }\n  class record {}\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tclass Y extends record {\n\t                ^^^^^^\n'record' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 16\n----------\n2. ERROR in X.java (at line 4)\n\tclass record {}\n\t      ^^^^^^\n'record' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 16\n----------\n");
    }

    public void testBug564672_014() {
        this.runNegativeTest(new String[]{"X.java", "interface X {\n  class Y extends record {\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tclass Y extends record {\n\t                ^^^^^^\n'record' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 16\n----------\n");
    }

    public void testBug564672_015() {
        this.runNegativeTest(new String[]{"X.java", "interface X {\n  class Y implements record {\n  }\n  interface record {}\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tclass Y implements record {\n\t                   ^^^^^^\n'record' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 16\n----------\n2. ERROR in X.java (at line 4)\n\tinterface record {}\n\t          ^^^^^^\n'record' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 16\n----------\n");
    }

    public void testBug564672_016() {
        this.runNegativeTest(new String[]{"X.java", "interface X {\n  class Y implements record {\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tclass Y implements record {\n\t                   ^^^^^^\n'record' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 16\n----------\n");
    }

    public void testBug564672_017() {
        this.runNegativeTest(new String[]{"X.java", "interface X {\n  interface Y extends record {\n  }\n  interface record {}\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tinterface Y extends record {\n\t                    ^^^^^^\n'record' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 16\n----------\n2. ERROR in X.java (at line 4)\n\tinterface record {}\n\t          ^^^^^^\n'record' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 16\n----------\n");
    }

    public void testBug564672_018() {
        this.runNegativeTest(new String[]{"X.java", "interface X {\n  interface Y extends record {\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tinterface Y extends record {\n\t                    ^^^^^^\n'record' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 16\n----------\n");
    }

    public void testBug564672_019() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tstatic record a(int i, int j) {\n\t\trecord r=new record(i,j);\n\t\treturn r;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(0);\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\trecord r=new record(i,j);\n\t^^^^^^\n'record' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 16\n----------\n2. ERROR in X.java (at line 3)\n\trecord r=new record(i,j);\n\t       ^\nInstance fields may not be declared in a record class\n----------\n3. ERROR in X.java (at line 3)\n\trecord r=new record(i,j);\n\t             ^^^^^^\n'record' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 16\n----------\n4. ERROR in X.java (at line 4)\n\treturn r;\n\t^^^^^^\nSyntax error on token \"return\", byte expected\n----------\n");
    }

    public void testBug564672_020() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tclass record {};\n\tstatic record a(int i, int j) {\n\t\trecord r=new record();\n\t\treturn r;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(0);\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tclass record {};\n\t      ^^^^^^\n'record' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 16\n----------\n2. ERROR in X.java (at line 4)\n\trecord r=new record();\n\t^^^^^^\n'record' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 16\n----------\n3. ERROR in X.java (at line 4)\n\trecord r=new record();\n\t       ^\nInstance fields may not be declared in a record class\n----------\n4. ERROR in X.java (at line 4)\n\trecord r=new record();\n\t             ^^^^^^\n'record' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 16\n----------\n5. ERROR in X.java (at line 5)\n\treturn r;\n\t^^^^^^\nSyntax error on token \"return\", byte expected\n----------\n");
    }

    public void testBug564672_021() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tinterface IPoint {\n\t}\n\trecord Point(int x, int y) implements IPoint {}\n\tstatic IPoint a(int i, int j) {\n\t\tPoint record=new Point(i,j);\n\t\treturn record;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(a(5,10));\n\t}\n}\n"}, "Point[x=5, y=10]");
    }

    public void testBug564672_022() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\trecord R(int i){} \n\tinterface IPoint {\n\t\trecord a(int i) {\n       \tSystem.out.println(0);\n           return new R(i);\n\t\t}\n\t}\n\trecord Point(int x, int y) implements IPoint {}\n\tstatic IPoint a(int i, int j) {\n\t\tPoint record=new Point(i,j);\n\t\trecord.a(1);\n\t\treturn record;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(0);\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tSystem.out.println(0);\n\t          ^\nSyntax error on token \".\", @ expected after this token\n----------\n2. ERROR in X.java (at line 5)\n\tSystem.out.println(0);\n           return new R(i);\n\t                   ^^^^^^^^^^^^^^^^^^^^^\nSyntax error on tokens, delete these tokens\n----------\n3. ERROR in X.java (at line 6)\n\treturn new R(i);\n\t              ^\nSyntax error, insert \")\" to complete SingleMemberAnnotation\n----------\n4. ERROR in X.java (at line 6)\n\treturn new R(i);\n\t              ^\nSyntax error, insert \"SimpleName\" to complete QualifiedName\n----------\n5. ERROR in X.java (at line 6)\n\treturn new R(i);\n\t              ^\nSyntax error, insert \"Identifier (\" to complete MethodHeaderName\n----------\n6. ERROR in X.java (at line 6)\n\treturn new R(i);\n\t              ^\nSyntax error, insert \")\" to complete MethodDeclaration\n----------\n7. ERROR in X.java (at line 12)\n\trecord.a(1);\n\t       ^\nThe method a(int) is undefined for the type X.Point\n----------\n");
    }

    public void testBug564672_023() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tinterface IPoint {\n\t}\n\trecord Point(int x, int y) implements IPoint {}\n\tstatic IPoint a(int i, int j) throws record{\n\t\tPoint record=new Point(i,j);\n\t\treturn record;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(0);\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tstatic IPoint a(int i, int j) throws record{\n\t                                     ^^^^^^\n'record' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 16\n----------\n");
    }

    public void testBug564672_024() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tX() throws record {} \n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(0);\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tX() throws record {} \n\t           ^^^^^^\n'record' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 16\n----------\n");
    }

    public void testBug564672_025() {
        this.runNegativeTest(new String[]{"X.java", "interface X {\n\tint a() throws record; \n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tint a() throws record; \n\t               ^^^^^^\n'record' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 16\n----------\n");
    }

    public void testBug564672_026() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;public class X {\n\tList<record> R = new List<record>();\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(0);\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tList<record> R = new List<record>();\n\t     ^^^^^^\n'record' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 16\n----------\n2. ERROR in X.java (at line 2)\n\tList<record> R = new List<record>();\n\t                     ^^^^\nCannot instantiate the type List<record>\n----------\n3. ERROR in X.java (at line 2)\n\tList<record> R = new List<record>();\n\t                          ^^^^^^\n'record' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 16\n----------\n");
    }

    public void testBug564672_027() {
        this.runNegativeTest(new String[]{"X.java", "interface I<S> {\n\tvoid print(S arg);\n}\npublic class X implements I<record>{\n\tvoid print(record arg){\n\t\tSystem.out.println(arg);\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(0);\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tpublic class X implements I<record>{\n\t             ^\nThe type X must implement the inherited abstract method I<record>.print(record)\n----------\n2. ERROR in X.java (at line 4)\n\tpublic class X implements I<record>{\n\t                            ^^^^^^\n'record' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 16\n----------\n3. ERROR in X.java (at line 5)\n\tvoid print(record arg){\n\t           ^^^^^^\n'record' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 16\n----------\n");
    }

    public void testBug564672_028() {
        this.runNegativeTest(new String[]{"X.java", "class Y<record> {\n\tvoid equal(record R) {}\n}\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(0);\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tclass Y<record> {\n\t        ^^^^^^\n'record' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 16\n----------\n2. ERROR in X.java (at line 2)\n\tvoid equal(record R) {}\n\t           ^^^^^^\n'record' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 16\n----------\n");
    }

    public void testBug564672_029() {
        this.runNegativeTest(new String[]{"X.java", "class Y<record> {\n\tY(record R) {}\n}\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(0);\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tclass Y<record> {\n\t        ^^^^^^\n'record' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 16\n----------\n2. ERROR in X.java (at line 2)\n\tY(record R) {}\n\t  ^^^^^^\n'record' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 16\n----------\n");
    }

    public void testBug564672_030() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tstatic record i= 0;\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(0);\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tstatic record i= 0;\n\t       ^^^^^^\n'record' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 16\n----------\n");
    }

    public void testBug564672_031() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\trecord i=0;\n}\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(0);\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\trecord i=0;\n\t^^^^^^\n'record' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 16\n----------\n");
    }

    public void testBug564672_032() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tstatic int sum(record i, int param){\n\t\treturn 1;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(0);\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tstatic int sum(record i, int param){\n\t               ^^^^^^\n'record' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 16\n----------\n");
    }

    public void testBug564672_033() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tX(record i, int param){\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(0);\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tX(record i, int param){\n\t  ^^^^^^\n'record' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 16\n----------\n");
    }

    public void testBug564672_034() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tint sum(record i, int num);\n}\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(0);\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tint sum(record i, int num);\n\t        ^^^^^^\n'record' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 16\n----------\n");
    }

    public void testBug564672_035() {
        this.runConformTest(new String[]{"X.java", "interface Greetings {\n  void greet(String head, String tail);\n}\npublic class X {\n  public static void main(String[] args) {\n    Greetings g = (record, y) -> {\n      System.out.println(record + y);\n    };\n    g.greet(\"Hello, \", \"World!\");\n  }\n}\n"}, "Hello, World!");
    }

    public void testBug564672_036() {
        this.runNegativeTest(new String[]{"X.java", "class Y {\n\tint sum(record this, int i, int num) {}\n}\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(0);\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tint sum(record this, int i, int num) {}\n\t        ^^^^^^\n'record' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 16\n----------\n");
    }

    public void testBug564672_037() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tstatic record i;\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(0);\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tstatic record i;\n\t       ^^^^^^\n'record' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 16\n----------\n");
    }

    public void testBug564672_038() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tfor (record i = 0; i<10; i++) {\n\t\t\tSystem.out.println(0);\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tfor (record i = 0; i<10; i++) {\n\t     ^^^^^^\n'record' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 16\n----------\n");
    }

    public void testBug564672_039() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tint rec[] = {1,2,3,4,5,6,7,8,9};\n\t\tfor (record i: rec) {\n\t\t\tSystem.out.println(0);\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tfor (record i: rec) {\n\t     ^^^^^^\n'record' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 16\n----------\n2. ERROR in X.java (at line 4)\n\tfor (record i: rec) {\n\t               ^^^\nType mismatch: cannot convert from element type int to record\n----------\n");
    }

    public void testBug564672_040() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\ttry (record i = 0){\n\t\t}\n\t\tSystem.out.println(0);\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\ttry (record i = 0){\n\t     ^^^^^^\n'record' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 16\n----------\n");
    }

    public void testBug564672_041() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\ttry{\n\t\t}\n\t\tcatch (record e) {}\n\t\tSystem.out.println(0);\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tcatch (record e) {}\n\t       ^^^^^^\n'record' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 16\n----------\n");
    }

    public void testBug564672_042() {
        this.runNegativeTest(new String[]{"X.java", "record Point(record x, int i) { }\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(0);\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\trecord Point(record x, int i) { }\n\t             ^^^^^^\n'record' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 16\n----------\n");
    }

    public void testBug564672_043() {
        this.runNegativeTest(new String[]{"X.java", "class Point {\n\t<T> Point(T i) {\n\t}\n\tPoint (int i, int j) {\n\t\t<record> this(null);\n\t}\n}\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(0);\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\t<record> this(null);\n\t ^^^^^^\n'record' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 16\n----------\n2. ERROR in X.java (at line 5)\n\t<record> this(null);\n\t         ^^^^^^^^^^^\nThe constructor Point(record) refers to the missing type record\n----------\n");
    }

    public void testBug564672_044() {
        this.runNegativeTest(new String[]{"X.java", "class Point {\n\t<T> Point(T i) {\n\t}\n}\nclass PointEx extends Point {\n\tPointEx (int i, int j) {\n\t\t<record> super(null);\n\t}\n;}\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(0);\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\t<record> super(null);\n\t ^^^^^^\n'record' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 16\n----------\n2. ERROR in X.java (at line 7)\n\t<record> super(null);\n\t         ^^^^^^^^^^^^\nThe constructor Point(record) refers to the missing type record\n----------\n");
    }

    public void testBug564672_045() {
        this.runNegativeTest(new String[]{"X.java", "class Y {\n\tvoid m1() {} \n\tvoid m2() {\n\t\tthis.<record>m1();\t}\n}\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(0);\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tthis.<record>m1();\t}\n\t      ^^^^^^\n'record' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 16\n----------\n2. WARNING in X.java (at line 4)\n\tthis.<record>m1();\t}\n\t      ^^^^^^\nUnused type arguments for the non generic method m1() of type Y; it should not be parameterized with arguments <record>\n----------\n");
    }

    public void testBug564672_046() {
        this.runNegativeTest(new String[]{"X.java", "class Y{\n\tvoid a() {\n\t\tSystem.out.println(\"1\");\n\t}\n}\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tnew <record>Y().a();\n\t\tSystem.out.println(0);\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 8)\n\tnew <record>Y().a();\n\t     ^^^^^^\n'record' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 16\n----------\n2. WARNING in X.java (at line 8)\n\tnew <record>Y().a();\n\t     ^^^^^^\nUnused type arguments for the non generic constructor Y() of type Y; it should not be parameterized with arguments <record>\n----------\n");
    }

    public void testBug564672_047() {
        this.runNegativeTest(new String[]{"X.java", "interface Y{}\n\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tnew <record>Y() {\n\t\t\tvoid a() {\n\t\t\t\tSystem.out.println(\"1\");\n\t\t\t}\n\t\t}.a();\n\t\tSystem.out.println(0);\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 5)\n\tnew <record>Y() {\n\t     ^^^^^^\n'record' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 16\n----------\n2. WARNING in X.java (at line 5)\n\tnew <record>Y() {\n\t     ^^^^^^\nUnused type arguments for the non generic constructor Object() of type Object; it should not be parameterized with arguments <record>\n----------\n");
    }

    public void testBug564672_048() {
        this.runNegativeTest(new String[]{"X.java", "class Y{}\n\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tnew <record>Y() {\n\t\t\tvoid a() {\n\t\t\t\tSystem.out.println(\"1\");\n\t\t\t}\n\t\t}.a();\n\t\tSystem.out.println(0);\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 5)\n\tnew <record>Y() {\n\t     ^^^^^^\n'record' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 16\n----------\n2. WARNING in X.java (at line 5)\n\tnew <record>Y() {\n\t     ^^^^^^\nUnused type arguments for the non generic constructor Y() of type Y; it should not be parameterized with arguments <record>\n----------\n");
    }

    public void testBug564672_049() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\trecord[] y= new record[3]; \n\t\tSystem.out.println(0);\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\trecord[] y= new record[3]; \n\t^^^^^^^^\n'record' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 16\n----------\n2. ERROR in X.java (at line 3)\n\trecord[] y= new record[3]; \n\t                ^^^^^^\n'record' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 16\n----------\n");
    }

    public void testBug564672_050() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tString s=\"Hello\";\n\t\trecord y= (record)s; \n\t\tSystem.out.println(0);\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\trecord y= (record)s; \n\t^^^^^^\n'record' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 16\n----------\n2. ERROR in X.java (at line 4)\n\trecord y= (record)s; \n\t           ^^^^^^\n'record' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 16\n----------\n");
    }

    public void testBug564672_051() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tString s=\"Hello\";\n\t\tif (s instanceof record) { \n\t\t\tSystem.out.println(1);\n\t\t}\n\t\tSystem.out.println(0);\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\tif (s instanceof record) { \n\t                 ^^^^^^\n'record' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 16\n----------\n");
    }

    public void testBug564672_052() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.Arrays;\nimport java.util.List;\n\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tList<String> messages = Arrays.asList(\"hello\", \"java\", \"testers!\");\n\t\tmessages.forEach(record::length);\n\t\tSystem.out.println(0);\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 7)\n\tmessages.forEach(record::length);\n\t                 ^^^^^^\nrecord cannot be resolved\n----------\n");
    }

    public void testBug564672_053() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.Arrays;\nimport java.util.List;\n\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tList<String> messages = Arrays.asList(\"hello\", \"java\", \"testers!\");\n\t\tmessages.stream().map(record::new).toArray(record[]::new);\n\t\tSystem.out.println(0);\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 7)\n\tmessages.stream().map(record::new).toArray(record[]::new);\n\t                      ^^^^^^\nrecord cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 7)\n\tmessages.stream().map(record::new).toArray(record[]::new);\n\t                                           ^^^^^^^^\n'record' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 16\n----------\n");
    }

    public void testBug564672b_001() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.compliance", "15");
        options.put("org.eclipse.jdt.core.compiler.source", "15");
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "15");
        this.runConformTest(new String[]{"X.java", "class X extends record {\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\nclass record {}\n"}, "0", options);
    }

    public void testBug564672b_002() {
        this.runNegativeTest(new String[]{"X.java", "class X extends record {\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tclass X extends record {\n\t                ^^^^^^\n'record' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 16\n----------\n", null, true);
    }

    public void testBug564672b_003() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.compliance", "15");
        options.put("org.eclipse.jdt.core.compiler.source", "15");
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "15");
        this.runConformTest(new String[]{"X.java", "class X implements record {\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\ninterface record {}\n;"}, "0", options);
    }

    public void testBug564672b_004() {
        this.runNegativeTest(new String[]{"X.java", "class X implements record {\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tclass X implements record {\n\t                   ^^^^^^\n'record' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 16\n----------\n", null, true);
    }

    public void testBug564672b_005() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.compliance", "15");
        options.put("org.eclipse.jdt.core.compiler.source", "15");
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "15");
        this.runConformTest(new String[]{"X.java", "class X {\n  class Y extends record {\n  }\n  class record {}\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\n"}, "0", options);
    }

    public void testBug564672b_006() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n  class Y extends record {\n  }\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tclass Y extends record {\n\t                ^^^^^^\n'record' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 16\n----------\n", null, true);
    }

    public void testBug564672b_007() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.compliance", "15");
        options.put("org.eclipse.jdt.core.compiler.source", "15");
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "15");
        this.runConformTest(new String[]{"X.java", "class X {\n  class Y implements record {\n  }\n  interface record {}\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\n"}, "0", options);
    }

    public void testBug564672b_008() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n  class Y implements record {\n  }\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tclass Y implements record {\n\t                   ^^^^^^\n'record' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 16\n----------\n", null, true);
    }

    public void testBug564672b_009() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.compliance", "15");
        options.put("org.eclipse.jdt.core.compiler.source", "15");
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "15");
        this.runConformTest(new String[]{"X.java", "interface Y extends record {\n}\ninterface record {}\nclass X {\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\n"}, "0", options);
    }

    public void testBug564672b_010() {
        this.runNegativeTest(new String[]{"X.java", "interface Y extends record {\n}\nclass X {\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tinterface Y extends record {\n\t                    ^^^^^^\n'record' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 16\n----------\n", null, true);
    }

    public void testBug564672b_011() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.compliance", "15");
        options.put("org.eclipse.jdt.core.compiler.source", "15");
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "15");
        this.runConformTest(new String[]{"X.java", "class X {\n  interface Y extends record {\n  }\n  interface record {}\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\n"}, "0", options);
    }

    public void testBug564672b_012() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n  interface Y extends record {\n  }\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tinterface Y extends record {\n\t                    ^^^^^^\n'record' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 16\n----------\n", null, true);
    }

    public void testBug564672b_013() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.compliance", "15");
        options.put("org.eclipse.jdt.core.compiler.source", "15");
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "15");
        this.runConformTest(new String[]{"X.java", "interface Z {\n  class Y extends record {\n  }\n  class record {}\n}\nclass X {\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\n"}, "0", options);
    }

    public void testBug564672b_014() {
        this.runNegativeTest(new String[]{"X.java", "interface X {\n  class Y extends record {\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tclass Y extends record {\n\t                ^^^^^^\n'record' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 16\n----------\n", null, true);
    }

    public void testBug564672b_015() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.compliance", "15");
        options.put("org.eclipse.jdt.core.compiler.source", "15");
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "15");
        this.runConformTest(new String[]{"X.java", "interface Z {\n  class Y implements record {\n  }\n  interface record {}\n}\nclass X {\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\n"}, "0", options);
    }

    public void testBug564672b_016() {
        this.runNegativeTest(new String[]{"X.java", "interface X {\n  class Y implements record {\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tclass Y implements record {\n\t                   ^^^^^^\n'record' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 16\n----------\n", null, true);
    }

    public void testBug564672b_017() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.compliance", "15");
        options.put("org.eclipse.jdt.core.compiler.source", "15");
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "15");
        this.runConformTest(new String[]{"X.java", "interface Z {\n  interface Y extends record {\n  }\n  interface record {}\n}\nclass X {\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\n"}, "0", options);
    }

    public void testBug564672b_018() {
        this.runNegativeTest(new String[]{"X.java", "interface X {\n  interface Y extends record {\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tinterface Y extends record {\n\t                    ^^^^^^\n'record' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 16\n----------\n", null, true);
    }

    public void testBug564672b_019() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tstatic record a(int i, int j) {\n\t\trecord r=new record(i,j);\n\t\treturn r;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(0);\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\trecord r=new record(i,j);\n\t^^^^^^\n'record' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 16\n----------\n2. ERROR in X.java (at line 3)\n\trecord r=new record(i,j);\n\t       ^\nInstance fields may not be declared in a record class\n----------\n3. ERROR in X.java (at line 3)\n\trecord r=new record(i,j);\n\t             ^^^^^^\n'record' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 16\n----------\n4. ERROR in X.java (at line 4)\n\treturn r;\n\t^^^^^^\nSyntax error on token \"return\", byte expected\n----------\n", null, true);
    }

    public void testBug564672b_020() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.compliance", "15");
        options.put("org.eclipse.jdt.core.compiler.source", "15");
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "15");
        this.runConformTest(new String[]{"X.java", "public class X {\n\tclass record {}\n\n\tstatic record a(int i, int j) {\n\t\trecord r = new X().new record();\n\t\treturn r;\n\t}\n\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(0);\n\t}\n}"}, "0", options);
    }

    public void testBug564672b_021() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.compliance", "15");
        options.put("org.eclipse.jdt.core.compiler.source", "15");
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "15");
        this.runConformTest(new String[]{"X.java", "public class X {\n\tX() throws record {} \n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(0);\n\t}\n}\n\nclass record extends Exception {\n\tprivate static final long serialVersionUID = 1L;\n}"}, "0", options);
    }

    public void testBug564672b_022() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.compliance", "15");
        options.put("org.eclipse.jdt.core.compiler.source", "15");
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "15");
        this.runConformTest(new String[]{"X.java", "interface Y {\n\tint a() throws record;\n}\n\nclass X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(0);\n\t}\n}\n\nclass record extends Exception {\n\tprivate static final long serialVersionUID = 1L;\n}"}, "0", options);
    }

    public void testBug564672b_023() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.compliance", "15");
        options.put("org.eclipse.jdt.core.compiler.source", "15");
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "15");
        this.runConformTest(new String[]{"X.java", "import java.util.ArrayList;\nimport java.util.List;\npublic class X {\n\tList<record> R = new ArrayList<record>();\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(0);\n\t}\n}\nclass record{}"}, "0", options);
    }

    public void testBug564672b_024() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.compliance", "15");
        options.put("org.eclipse.jdt.core.compiler.source", "15");
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "15");
        this.runConformTest(new String[]{"X.java", "interface I<S> {\n\tvoid print(S arg);\n}\n\npublic class X implements I<record> {\n\tpublic void print(record arg) {\n\t\tSystem.out.println(arg);\n\t}\n\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(0);\n\t}\n}\nclass record {\n}"}, "0", options);
    }

    public void testBug564672b_025() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.compliance", "15");
        options.put("org.eclipse.jdt.core.compiler.source", "15");
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "15");
        this.runConformTest(new String[]{"X.java", "class Y<record> {\n\tvoid equal(record R) {}\n}\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(0);\n\t}\n}\n"}, "0", options);
    }

    public void testBug564672b_026() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.compliance", "15");
        options.put("org.eclipse.jdt.core.compiler.source", "15");
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "15");
        this.runConformTest(new String[]{"X.java", "class Y<record> {\n\tY(record R) {}\n}\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(0);\n\t}\n}\n"}, "0", options);
    }

    public void testBug564672b_027() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.compliance", "15");
        options.put("org.eclipse.jdt.core.compiler.source", "15");
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "15");
        this.runConformTest(new String[]{"X.java", "public class X {\n\tstatic record i;\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(0);\n\t}\n}\nclass record {}"}, "0", options);
    }

    public void testBug564672b_028() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.compliance", "15");
        options.put("org.eclipse.jdt.core.compiler.source", "15");
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "15");
        this.runConformTest(new String[]{"X.java", "interface I {\n\trecord i = new record(0);\n}\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(0);\n\t}\n}\nclass record {\n\tint i;\n\trecord (int i) {\n\t\tthis.i=i;\n\t}\n}"}, "0", options);
    }

    public void testBug564672b_029() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.compliance", "15");
        options.put("org.eclipse.jdt.core.compiler.source", "15");
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "15");
        this.runConformTest(new String[]{"X.java", "public class X {\n\tstatic int sum(record i, int param) {\n\t\treturn 1;\n\t}\n\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(0);\n\t}\n}\nclass record{}"}, "0", options);
    }

    public void testBug564672b_030() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.compliance", "15");
        options.put("org.eclipse.jdt.core.compiler.source", "15");
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "15");
        this.runConformTest(new String[]{"X.java", "public class X {\n\tX(record i, int param){\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(0);\n\t}\n}\nclass record{}"}, "0", options);
    }

    public void testBug564672b_031() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.compliance", "15");
        options.put("org.eclipse.jdt.core.compiler.source", "15");
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "15");
        this.runConformTest(new String[]{"X.java", "interface I {\n\tint sum(record i, int num);\n}\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(0);\n\t}\n}\nclass record{}"}, "0", options);
    }

    public void testBug564672b_032() {
        this.runConformTest(new String[]{"X.java", "interface Greetings {\n  void greet(String head, String tail);\n}\npublic class X {\n  public static void main(String[] args) {\n    Greetings g = (record, y) -> {\n      System.out.println(record + y);\n    };\n    g.greet(\"Hello, \", \"World!\");\n  }\n}\n"}, "Hello, World!");
    }

    public void testBug564672b_033() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.compliance", "15");
        options.put("org.eclipse.jdt.core.compiler.source", "15");
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "15");
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(0);\n\t}\n}\n\nclass record {\n\tint sum(record this, int i, int num) {\n\t\treturn 0;\n\t}\n}"}, "0", options);
    }

    public void testBug564672b_034() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tstatic Rec record;\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(0);\n\t}\n}\nclass Rec {}\n"}, "0");
    }

    public void testBug564672b_035() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.compliance", "15");
        options.put("org.eclipse.jdt.core.compiler.source", "15");
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "15");
        this.runConformTest(new String[]{"X.java", "import java.util.ArrayList;\nimport java.util.Iterator;\nimport java.util.List;\n\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tint rec[] = { 1, 2, 3, 4, 5, 6, 7, 8, 9 };\n\t\tString s=\"\";\n\t\tList <record> recList= new ArrayList<>();\n\t\tfor (int i:rec) {\n\t\t\trecList.add(new record(i));\n\t\t}\n\t\tfor (Iterator<record> i =recList.iterator(); i.hasNext();) {\n\t\t\ts=s+i.next()+\" \";\n\t\t}\n\t\tSystem.out.println(0);\n\t}\n}\n\nclass record {\n\tint i;\n\trecord (int i) {\n\t\tthis.i=i;\n\t}\n\tpublic String toString (){\n\t\treturn Integer.toString(i);\n\t}\n}"}, "0", options);
    }

    public void testBug564672b_036() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.compliance", "15");
        options.put("org.eclipse.jdt.core.compiler.source", "15");
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "15");
        this.runConformTest(new String[]{"X.java", "import java.util.ArrayList;\nimport java.util.List;\n\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tint rec[] = { 1, 2, 3, 4, 5, 6, 7, 8, 9 };\n\t\tString s=\"\";\n\t\tList <record> recList= new ArrayList<>();\n\t\tfor (int i:rec) {\n\t\t\trecList.add(new record(i));\n\t\t}\n\t\tfor (record i : recList) {\n\t\t\ts=s+i+\" \";\n\t\t}\n\t\tSystem.out.println(0);\n\t}\n}\n\nclass record {\n\tint i;\n\trecord (int i) {\n\t\tthis.i=i;\n\t}\n\tpublic String toString (){\n\t\treturn Integer.toString(i);\n\t}\n}\n"}, "0", options);
    }

    public void testBug564672b_037() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.compliance", "15");
        options.put("org.eclipse.jdt.core.compiler.source", "15");
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "15");
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\ttry (record i = new record (0)){\n\t\t} catch (Exception e) {\n\t\t\te.printStackTrace();\n\t\t}\n\t\tSystem.out.println(0);\n\t}\n}\nclass record implements AutoCloseable{\n\tint i;\n\trecord (int i) {\n\t\tthis.i=i;\n\t}\n\t@Override\n\tpublic void close() throws Exception {}\n}"}, "0", options);
    }

    public void testBug564672b_038() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.compliance", "15");
        options.put("org.eclipse.jdt.core.compiler.source", "15");
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "15");
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\ttry {\n\t\t\tthrow new record();\n\t\t} catch (record e) {\n\t\t\tSystem.out.println(\"0\");\n\t\t}\n\t}\n}\n\nclass record extends Exception {\n\tprivate static final long serialVersionUID = 1L;\n}"}, "0", options);
    }

    public void testBug564672b_039() {
        this.runNegativeTest(new String[]{"X.java", "record Point(record x, int i) { }\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(0);\n\t}\n}\nclass record {}"}, "----------\n1. ERROR in X.java (at line 1)\n\trecord Point(record x, int i) { }\n\t             ^^^^^^\n'record' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 16\n----------\n2. ERROR in X.java (at line 7)\n\tclass record {}\n\t      ^^^^^^\n'record' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 16\n----------\n", null, true);
    }

    public void testBug564672b_040() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.compliance", "15");
        options.put("org.eclipse.jdt.core.compiler.source", "15");
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "15");
        this.runConformTest(new String[]{"X.java", "class Point {\n\t<T> Point(T i) {\n\t}\n\tPoint (int i, int j) {\n\t\t<record> this(null);\n\t}\n}\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(0);\n\t}\n}\nclass record {}"}, "0", options);
    }

    public void testBug564672b_041() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.compliance", "15");
        options.put("org.eclipse.jdt.core.compiler.source", "15");
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "15");
        this.runConformTest(new String[]{"X.java", "class Point {\n\t<T> Point(T i) {\n\t}\n}\nclass PointEx extends Point {\n\tPointEx (int i, int j) {\n\t\t<record> super(null);\n\t}\n;}\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(0);\n\t}\n}\nclass record {}"}, "0", options);
    }

    public void testBug564672b_042() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.compliance", "15");
        options.put("org.eclipse.jdt.core.compiler.source", "15");
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "15");
        this.runConformTest(new String[]{"X.java", "class Y {\n\t<T> void m1() {} \n\tvoid m2() {\n\t\tthis.<record>m1();\t}\n}\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(0);\n\t}\n}\nclass record {}"}, "0", options);
    }

    public void testBug564672b_043() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.compliance", "15");
        options.put("org.eclipse.jdt.core.compiler.source", "15");
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "15");
        this.runConformTest(new String[]{"X.java", "class Y{\n\t<T> Y() {}\n\tvoid a() {\n\t\tSystem.out.println(\"1\");\n\t}\n}\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tnew <record>Y().a();\n\t}\n}\nclass record {}"}, "1", options);
    }

    public void testBug564672b_044() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.compliance", "15");
        options.put("org.eclipse.jdt.core.compiler.source", "15");
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "15");
        this.runConformTest(new String[]{"X.java", "interface Y{\n}\n\nclass Z implements Y {\n\t<T> Z() {\n\t\t\n\t}\n}\n\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tnew <record>Z() {\n\t\t\tvoid a() {\n\t\t\t\tSystem.out.println(\"1\");\n\t\t\t}\n\t\t}.a();\n\t}\n}\nclass record {}"}, "1", options);
    }

    public void testBug564672b_045() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.compliance", "15");
        options.put("org.eclipse.jdt.core.compiler.source", "15");
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "15");
        this.runConformTest(new String[]{"X.java", "class Y{\t<T> Y() {\n\t}}\n\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tnew <record>Y() {\n\t\t\tvoid a() {\n\t\t\t\tSystem.out.println(\"1\");\n\t\t\t}\n\t\t}.a();\n\t}\n}\nclass record {}"}, "1", options);
    }

    public void testBug564672b_046() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.compliance", "15");
        options.put("org.eclipse.jdt.core.compiler.source", "15");
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "15");
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\trecord[] y= new record[3]; \n\t\tSystem.out.println(0);\n\t}\n}class record {}"}, "0", options);
    }

    public void testBug564672b_047() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.compliance", "15");
        options.put("org.eclipse.jdt.core.compiler.source", "15");
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "15");
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tStrRec s = new StrRec(\"Hello\");\n\t\trecord y = (record) s;\n\t\tSystem.out.println(0);\n\t}\n}\n\nclass record {\n}\n\nclass StrRec extends record {\n\tString s;\n\n\tStrRec(String s) {\n\t\tthis.s = s;\n\t}\n}"}, "0", options);
    }

    public void testBug564672b_048() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.compliance", "15");
        options.put("org.eclipse.jdt.core.compiler.source", "15");
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "15");
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tStrRec s=new StrRec(\"Hello\");\n\t\tif (s instanceof record) { \n\t\t\tSystem.out.println(1);\n\t\t}\n\t}\n}\nclass record {}\n\nclass StrRec extends record {\n\tString s;\n\n\tStrRec(String s) {\n\t\tthis.s = s;\n\t}\n}"}, "1", options);
    }

    public void testBug564672b_049() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.compliance", "15");
        options.put("org.eclipse.jdt.core.compiler.source", "15");
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "15");
        this.runConformTest(new String[]{"X.java", "import java.util.Arrays;\nimport java.util.List;\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tList<String> messages = Arrays.asList(\"hello\", \"java\", \"testers!\");\n\t\t\n\t\tmessages.stream().map(record::new).toArray(record[]::new);;\n\t\tSystem.out.println(0);\n\t}\n}\nclass record {\n\tString s;\n\n\trecord(String s) {\n\t\tthis.s = s;\n\t}\n}"}, "0", options);
    }

    public void testBug565388_001() {
        if (this.complianceLevel < 0x3D0000L) {
            return;
        }
        this.runNegativeTest(new String[]{"X.java", "public non-sealed record X() {}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic non-sealed record X() {}\n\t                         ^\nIllegal modifier for the record X; only public, final and strictfp are permitted\n----------\n", null, true);
    }

    public void testBug565388_002() {
        if (this.complianceLevel < 0x3D0000L) {
            return;
        }
        this.runNegativeTest(new String[]{"X.java", "public sealed record X() {}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic sealed record X() {}\n\t                     ^\nIllegal modifier for the record X; only public, final and strictfp are permitted\n----------\n", null, true);
    }

    public void testBug565786_001() throws IOException, ClassFormatException {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static void main(String[] args) {\n        System.out.println(0);\n   }\n}\ninterface I {\n    record R() {}\n}"}, "0");
        String expectedOutput = "  // Method descriptor #24 ()V\n  // Stack: 1, Locals: 1\n  public I$R();\n";
        this.verifyClassFile(expectedOutput, "I$R.class", 4);
    }

    public void testBug563182_01() {
        Map<String, String> customOptions = this.getCompilerOptions();
        this.runNegativeTest(new String[]{"X.java", "class X<T> {\n\trecord Point<T> (T ... args) { // 1\n\t}\n   public static void main(String[] args) {}\n}\n"}, "----------\n1. WARNING in X.java (at line 2)\n\trecord Point<T> (T ... args) { // 1\n\t                       ^^^^\nType safety: Potential heap pollution via varargs parameter args\n----------\n", null, true, new String[]{"--enable-preview"}, customOptions);
    }

    public void testBug563182_02() {
        RecordsRestrictedClassTest.getPossibleComplianceLevels();
        Map<String, String> customOptions = this.getCompilerOptions();
        this.runNegativeTest(new String[]{"X.java", "class X<T> {\n\trecord Point<T> (T ... args) { // 1\n\t\tPoint(T ... args) { // 2\n\t\t\tthis.args = args;\n\t\t}\n\t}\n   public static void main(String[] args) {}\n}\n"}, "----------\n1. WARNING in X.java (at line 3)\n\tPoint(T ... args) { // 2\n\t            ^^^^\nType safety: Potential heap pollution via varargs parameter args\n----------\n", null, true, new String[]{"--enable-preview"}, customOptions);
    }

    public void testBug563182_03() {
        RecordsRestrictedClassTest.getPossibleComplianceLevels();
        Map<String, String> customOptions = this.getCompilerOptions();
        this.runNegativeTest(new String[]{"X.java", "class X<T> {\n\trecord Point<T> (T ... args) { // 1\n\t\t@SafeVarargs\n\t\tPoint(T ... args) { // 2\n\t\t\tthis.args = args;\n\t\t}\n\t}\n   public static void main(String[] args) {}\n}\n"}, "", null, true, new String[]{"--enable-preview"}, customOptions);
    }

    public void testBug563182_04() {
        Map<String, String> customOptions = this.getCompilerOptions();
        this.runNegativeTest(new String[]{"X.java", "class X<T> {\n\trecord Point<T> (T ... args) { // 1\n\t\tPoint { // 2\n\t\t}\n\t}\n   public static void main(String[] args) {}\n}\n"}, "----------\n1. WARNING in X.java (at line 2)\n\trecord Point<T> (T ... args) { // 1\n\t                       ^^^^\nType safety: Potential heap pollution via varargs parameter args\n----------\n", null, true, new String[]{"--enable-preview"}, customOptions);
    }

    public void testBug563182_05() {
        RecordsRestrictedClassTest.getPossibleComplianceLevels();
        Map<String, String> customOptions = this.getCompilerOptions();
        this.runNegativeTest(new String[]{"X.java", "class X<T> {\n\trecord Point<T> (T ... args) { // 1\n\t\t@SafeVarargs\n\t\tPoint { // 2\n\t\t}\n\t}\n   public static void main(String[] args) {}\n}\n"}, "", null, true, new String[]{"--enable-preview"}, customOptions);
    }

    public void testBug563182_06() {
        Map<String, String> customOptions = this.getCompilerOptions();
        this.runNegativeTest(new String[]{"X.java", "class X<T> {\n\trecord Point<T> (T ... args) { // 1\n\t\t@SafeVarargs\n\t\tPoint (String s, T ... t) {\n\t\t\tthis(t);\n\t\t}\n\t}\n   public static void main(String[] args) {}\n}\n"}, "----------\n1. WARNING in X.java (at line 2)\n\trecord Point<T> (T ... args) { // 1\n\t                       ^^^^\nType safety: Potential heap pollution via varargs parameter args\n----------\n", null, true, new String[]{"--enable-preview"}, customOptions);
    }

    public void testBug563182_07() {
        Map<String, String> customOptions = this.getCompilerOptions();
        this.runNegativeTest(new String[]{"X.java", "class X<T> {\n\trecord Point<T> (T ... args) { // 1\n\t\tPoint (String s, T ... t) {\n\t\t\tthis(t);\n\t\t}\n\t}\n   public static void main(String[] args) {}\n}\n"}, "----------\n1. WARNING in X.java (at line 2)\n\trecord Point<T> (T ... args) { // 1\n\t                       ^^^^\nType safety: Potential heap pollution via varargs parameter args\n----------\n2. WARNING in X.java (at line 3)\n\tPoint (String s, T ... t) {\n\t                       ^\nType safety: Potential heap pollution via varargs parameter t\n----------\n", null, true, new String[]{"--enable-preview"}, customOptions);
    }

    public void testBug563186_01() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  private record Point(int myInt){\n  \t @Override\n  \t public int myInt(){\n      return this.myInt;\n    }\n  }\n    public static void main(String[] args) {\n        System.out.println(0);\n   }\n}\n"}, "0");
    }

    public void testBug563186_02() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  private record Point(int myInt){\n  \t public int myInt(){\n      return this.myInt;\n    }\n  }\n    public static void main(String[] args) {\n        System.out.println(0);\n   }\n}\n"}, "0");
    }

    public void testBug563186_03() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  private record Point(int myInt){\n  \t @Override\n  \t public int myInt(int i){\n      return this.myInt;\n    }\n  }\n    public static void main(String[] args) {\n        System.out.println(0);\n   }\n}\n"}, "----------\n1. WARNING in X.java (at line 2)\n\tprivate record Point(int myInt){\n\t               ^^^^^\nThe type X.Point is never used locally\n----------\n2. ERROR in X.java (at line 4)\n\tpublic int myInt(int i){\n\t           ^^^^^^^^^^^^\nThe method myInt(int) of type X.Point must override or implement a supertype method\n----------\n", null, true);
    }

    public void testBug563186_04() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  private record Point(int myInt){\n  \t public int myInt(int i){\n      return this.myInt;\n    }\n  }\n    public static void main(String[] args) {\n        System.out.println(0);\n   }\n}\n"}, "0");
    }

    public void testBug565732_01() {
        this.runNegativeTest(new String[]{"X.java", "public record X {\n} "}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic record X {\n\t              ^\nSyntax error, insert \"RecordHeader\" to complete RecordHeaderPart\n----------\n", null, true);
    }

    public void testBug565732_02() {
        this.runNegativeTest(new String[]{"X.java", "public record X<T> {\n} "}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic record X<T> {\n\t                 ^\nSyntax error, insert \"RecordHeader\" to complete RecordHeaderPart\n----------\n", null, true);
    }

    public void testBug565732_03() {
        this.runConformTest(new String[]{"X.java", "public record X() {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(X.class.getSuperclass().getName());\n\t}\n}"}, "java.lang.Record");
    }

    public void testBug565732_04() {
        this.runConformTest(new String[]{"X.java", "public record X<T>() {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(X.class.getSuperclass().getName());\n\t}\n}"}, "java.lang.Record");
    }

    public void testBug565732_05() {
        this.runConformTest(new String[]{"X.java", "public record X<T>() {\n\tpublic static void main(String[] args) {\n\t\trecord();\n\t}\n\tpublic static void record() {\n\t\tSystem.out.println(\"record()\");\n\t}\n}"}, "record()");
    }

    public void testBug565732_06() {
        this.runConformTest(new String[]{"X.java", "public record X<T>() {\n\tpublic static void main(String[] args) {\n\t\tboolean flag = true;\n\t\trecord: {\n\t\t\tif (flag) {\n\t\t\t\tSystem.out.println(\"record:\");\n\t\t\t\tflag = false;\n\t\t\t\tbreak record;\n\t\t\t}\n\t\t}\n\t}\n}"}, "record:");
    }

    public void testBug565732_07() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\trecord R {};\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\trecord R {};\n\t       ^\nSyntax error, insert \"RecordHeader\" to complete RecordHeaderPart\n----------\n", null, true);
    }

    public void testBug565732_08() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(R.class.getSuperclass().getName());\n\t}\n\trecord R() {};\n}"}, "java.lang.Record");
    }

    public void testBug565830_01() {
        this.runConformTest(new String[]{"X.java", "class X {\n    void bar() throws Exception {\n        record Bar(int x) implements java.io.Serializable {\n            void printMyFields() {\n                for (var field : this.getClass().getDeclaredFields()) {\n                    System.out.println(field);\n                }\n            }\n        }\n        var bar = new Bar(1);\n        bar.printMyFields();\n        new java.io.ObjectOutputStream(java.io.OutputStream.nullOutputStream()).writeObject(bar);\n    }\n    public static void main(String[] args) throws Exception {\n        new X().bar();\n    }\n}"}, "private final int X$1Bar.x");
    }

    public void testBug566063_001() {
        this.runConformTest(new String[]{"X.java", "class X {\n    void bar() throws Exception {\n        enum E {\n               ONE,\n               TWO\n        }\n        interface I {}\n        record Bar(E x) implements I{}\n        E e = new Bar(E.ONE).x();\n        System.out.println(e);\n    }\n    public static void main(String[] args) throws Exception {\n       new X().bar();\n    }\n}"}, "ONE");
    }

    public void testBug566063_002() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n    void bar() throws Exception {\n        static enum E {\n               ONE,\n               TWO\n        }\n        interface I {}\n        record Bar(E x) implements I{}\n        E e = new Bar(E.ONE).x();\n        System.out.println(e);\n    }\n    public static void main(String[] args) throws Exception {\n       new X().bar();\n    }\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tstatic enum E {\n\t            ^\nIllegal modifier for local enum E; no explicit modifier is permitted\n----------\n", null, true);
    }

    public void testBug566063_003() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n    void bar() throws Exception {\n        static enum E {\n               ONE,\n               TWO\n        }\n        static interface I {}\n        static record Bar(E x) implements I{}\n        E e = new Bar(E.ONE).x();\n        System.out.println(e);\n    }\n    public static void main(String[] args) throws Exception {\n       new X().bar();\n    }\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tstatic enum E {\n\t            ^\nIllegal modifier for local enum E; no explicit modifier is permitted\n----------\n2. ERROR in X.java (at line 7)\n\tstatic interface I {}\n\t                 ^\nIllegal modifier for the local interface I; abstract and strictfp are the only modifiers allowed explicitly \n----------\n3. ERROR in X.java (at line 8)\n\tstatic record Bar(E x) implements I{}\n\t              ^^^\nA local class or interface Bar is implicitly static; cannot have explicit static declaration\n----------\n", null, true);
    }

    public void testBug566063_004() {
        this.runConformTest(new String[]{"X.java", "class X {\n    void bar() throws Exception {\n        enum E {\n               ONE,\n               TWO\n        }\n\t\t interface I {}\n        record Bar(E x) implements I{}\n        E e = new Bar(E.ONE).x();\n        System.out.println(e);\n    }\n    public static void main(String[] args) throws Exception {\n       new X().bar();\n    }\n}"}, "ONE");
    }

    public void testBug566418_001() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unnecessaryTypeCheck", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.unusedWarningToken", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.suppressOptionalErrors", "enabled");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n static void foo() {\n   record R() {\n     static int create(int lo) {\n       return lo;\n     }\n   }\n   System.out.println(R.create(0));\n   }\n   Zork();\n}"}, "----------\n1. ERROR in X.java (at line 10)\n\tZork();\n\t^^^^^^\nReturn type for the method is missing\n----------\n2. ERROR in X.java (at line 10)\n\tZork();\n\t^^^^^^\nThis method requires a body instead of a semicolon\n----------\n", null, true, options);
    }

    public void testBug565787_01() {
        this.runConformTest(new String[]{"X.java", "public record X(String s)   {\n    public X  {\n        s.codePoints()\n        .forEach(cp -> System.out.println((java.util.function.Predicate<String>) \"\"::equals));\n    }\n    public static void main(String[] args) {\n        X a = new X(\"\");\n        a.equals(a);\n    }\n}"}, "");
    }

    public void testBug566554_01() {
        this.runConformTest(new String[]{"Main.java", "public class Main {\n\tpublic static void main(String[] args) {\n\t\tfinal Margin margins = new Margin(0);\n\t\tSystem.out.println(margins.left()); \n\t}\n}\nrecord Margin(int left) {\n\tpublic Margin left(int value) {\n\t\treturn new Margin(value);\n\t}\n\tpublic String toString() {\n\t\treturn \"Margin[left=\" + this.left + \"]\";\n\t}\n}"}, "0");
    }

    public void testBug566554_02() {
        this.runConformTest(new String[]{"Main.java", "public class Main {\n\tpublic static void main(String[] args) {\n\t\tfinal Margin margins = new Margin(0);\n\t\tSystem.out.println(margins.left()); \n\t}\n}\nrecord Margin(int left) {\n\tpublic Margin left(int value) {\n\t\treturn new Margin(value);\n\t}\n\tpublic int left() {\n\t\treturn this.left;\n\t}\n\tpublic String toString() {\n\t\treturn \"Margin[left=\" + this.left + \"]\";\n\t}\n}"}, "0");
    }

    public void testBug566554_03() {
        this.runConformTest(new String[]{"Main.java", "public class Main {\n\tpublic static void main(String[] args) {\n\t\tfinal Margin margins = new Margin(0);\n\t\tSystem.out.println(margins.left(0)); \n\t}\n}\nrecord Margin(int left) {\n\tpublic Margin left(int value) {\n\t\treturn new Margin(value);\n\t}\n\tpublic int left() {\n\t\treturn this.left;\n\t}\n\tpublic String toString() {\n\t\treturn \"Margin[left=\" + this.left + \"]\";\n\t}\n}"}, "Margin[left=0]");
    }

    public void testBug566554_04() {
        this.runNegativeTest(new String[]{"Main.java", "public class Main {\n\tpublic static void main(String[] args) {\n\t\tfinal Margin margins = new Margin(0);\n\t\tint l = margins.left(0); \n\t}\n}\nrecord Margin(int left) {\n\tpublic Margin left(int value) {\n\t\treturn new Margin(value);\n\t}\n\tpublic int left() {\n\t\treturn this.left;\n\t}\n}"}, "----------\n1. ERROR in Main.java (at line 4)\n\tint l = margins.left(0); \n\t        ^^^^^^^^^^^^^^^\nType mismatch: cannot convert from Margin to int\n----------\n");
    }

    public void testBug567731_001() {
        if (this.complianceLevel < 0x3D0000L) {
            return;
        }
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  non-sealed record R() {}\n  public static void main(String[] args) {\n\t  sealed record B() { }  \n  }}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tnon-sealed record R() {}\n\t                  ^\nIllegal modifier for the record R; only public, private, protected, static, final and strictfp are permitted\n----------\n2. ERROR in X.java (at line 4)\n\tsealed record B() { }  \n\t              ^\nIllegal modifier for the local record B; only final and strictfp are permitted\n----------\n", null, true);
    }

    public void testBug567731_002() {
        if (this.complianceLevel < 0x3D0000L) {
            return;
        }
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  sealed record R1() {}\n  public static void main(String[] args) {\n\t  non-sealed record R2() { }  \n  }}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tsealed record R1() {}\n\t              ^^\nIllegal modifier for the record R1; only public, private, protected, static, final and strictfp are permitted\n----------\n2. ERROR in X.java (at line 4)\n\tnon-sealed record R2() { }  \n\t                  ^^\nIllegal modifier for the local record R2; only final and strictfp are permitted\n----------\n", null, true);
    }

    public void testBug566846_1() {
        if (this.complianceLevel < 0x440000L) {
            return;
        }
        this.runNegativeTest(new String[]{"X.java", "public record X;\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic record X;\n\t^\nImplicitly Declared Classes and Instance Main Methods is a preview feature and disabled by default. Use --enable-preview to enable\n----------\n2. ERROR in X.java (at line 1)\n\tpublic record X;\n\t^\nImplicitly declared class must have a candidate main method\n----------\n3. ERROR in X.java (at line 1)\n\tpublic record X;\n\t       ^^^^^^\n'record' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 16\n----------\n", null, true);
    }

    public void testBug566846_2() {
        if (this.complianceLevel < 0x440000L) {
            return;
        }
        this.runNegativeTest(new String[]{"X.java", "public class X {\n} \nrecord R1;\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X {\n\t^\nImplicitly Declared Classes and Instance Main Methods is a preview feature and disabled by default. Use --enable-preview to enable\n----------\n2. ERROR in X.java (at line 1)\n\tpublic class X {\n\t^\nImplicitly declared class must have a candidate main method\n----------\n3. ERROR in X.java (at line 3)\n\trecord R1;\n\t^^^^^^\n'record' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 16\n----------\n", null, true);
    }

    public void testBug561199_001() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.missingSerialVersion", "error");
        this.runNegativeTest(new String[]{"R.java", "record R() implements java.io.Serializable {}\n", "X.java", "class X implements java.io.Serializable {}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tclass X implements java.io.Serializable {}\n\t      ^\nThe serializable class X does not declare a static final serialVersionUID field of type long\n----------\n", null, true, new String[]{"--enable-preview"}, options);
    }

    public void testBug568922_001() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n public static void main(String[] args) {\n   record R() {\n     R  {\n       super();\n       System.out.println(\"helo\");\n     }\n   }\n   new R();\n }\n}"}, "----------\n1. ERROR in X.java (at line 5)\n\tsuper();\n\t^^^^^^^^\nThe body of a compact constructor must not contain an explicit constructor call\n----------\n", null, true);
    }

    public void testBug568922_002() {
        this.runConformTest(new String[]{"X.java", "public class X {\n public static void main(String[] args) {\n   record R() {\n     R  {\n       System.out.println(\"helo\");\n     }\n   }\n   new R();\n }\n}"}, "helo");
    }

    public void testBug570243_001() {
        this.runConformTest(new String[]{"X.java", "import java.lang.reflect.Parameter;\n  \npublic record X(int myCompOne) {\n       public static void main(String[] x1) {\n        try {\n            Parameter param = Class.forName(\"X\").getConstructors()[0].getParameters()[0];\n               System.out.println(param.getType().getSimpleName()+\" \"+ param.getName());\n        } catch(ClassNotFoundException e) {\n               // do nothing\n        }\n       }\n}"}, "int myCompOne");
    }

    public void testBug570243_002() {
        this.runConformTest(new String[]{"X.java", "import java.lang.reflect.Parameter;\n  \npublic record X(int myCompOne, char myCompChar) {\n       public static void main(String[] x1) {\n        try {\n            Parameter[] params = Class.forName(\"X\").getConstructors()[0].getParameters();\n            for (Parameter param : params)\n               System.out.println(param.getType().getSimpleName()+\" \"+ param.getName());\n        } catch(ClassNotFoundException e) {\n               // do nothing\n        }\n       }\n}"}, "int myCompOne\nchar myCompChar");
    }

    public void testBug570243_003() {
        this.runConformTest(new String[]{"X.java", "import java.lang.reflect.Parameter;\n  \npublic record X(int myCompOne, char ...myCompChar) {\n       public static void main(String[] x1) {\n        try {\n            Parameter[] params = Class.forName(\"X\").getConstructors()[0].getParameters();\n            for (Parameter param : params)\n               System.out.println(param.getType().getSimpleName()+\" \"+ param.getName());\n        } catch(ClassNotFoundException e) {\n               // do nothing\n        }\n       }\n}"}, "int myCompOne\nchar[] myCompChar");
    }

    public void testBug570230_001() {
        this.runNegativeTest(new String[]{"X.java", "public record X(int marr[]) {}"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic record X(int marr[]) {}\n\t                    ^^^^\nExtended dimensions are illegal for a record component\n----------\n");
    }

    public void testBug571015_001() {
        this.runNegativeTest(new String[]{"X.java", "record R() {\n       R(I<T> ... t) {}\n}\ninterface I{}"}, "----------\n1. ERROR in X.java (at line 2)\n\tR(I<T> ... t) {}\n\t  ^\nThe type I is not generic; it cannot be parameterized with arguments <T>\n----------\n2. ERROR in X.java (at line 2)\n\tR(I<T> ... t) {}\n\t    ^\nT cannot be resolved to a type\n----------\n");
    }

    public void testBug571015_002() {
        this.runNegativeTest(new String[]{"X.java", "record R() {\n       R(I<X> ... t) {}\n}\ninterface I<T>{}\nclass X{}"}, "----------\n1. ERROR in X.java (at line 2)\n\tR(I<X> ... t) {}\n\t^^^^^^^^^^^^^\nA non-canonical constructor must start with an explicit invocation to a constructor\n----------\n2. WARNING in X.java (at line 2)\n\tR(I<X> ... t) {}\n\t           ^\nType safety: Potential heap pollution via varargs parameter t\n----------\n");
    }

    public void testBug571038_1() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\n public static void main(String[] args) {\n   System.out.println(\"hello\");\n }\n}\nrecord MyRecord<T> (MyIntf<T>... t) {\n\tpublic MyRecord(MyIntf<T>... t) {\n\t\tthis.t = null;\n\t}\n}\ninterface MyIntf<T> {}\n"}, "hello");
        String expectedOutput = "  // Method descriptor #25 ()[LMyIntf;\n  // Signature: ()[LMyIntf<TT;>;\n  // Stack: 1, Locals: 1\n  public MyIntf[] t();\n";
        this.verifyClassFile(expectedOutput, "MyRecord.class", 4);
    }

    public void testBug571038_2() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\n public static void main(String[] args) {\n   System.out.println(\"hello\");\n }\n}\nrecord MyRecord<T> (MyIntf<T>... t) {\n\t@SafeVarargs\n\tpublic MyRecord(MyIntf<T>... t) {\n\t\tthis.t = null;\n\t}\n}\ninterface MyIntf<T> {}\n"}, "hello");
        String expectedOutput = "  // Method descriptor #27 ()[LMyIntf;\n  // Signature: ()[LMyIntf<TT;>;\n  // Stack: 1, Locals: 1\n  public MyIntf[] t();\n";
        this.verifyClassFile(expectedOutput, "MyRecord.class", 4);
    }

    public void testBug571038_3() throws Exception {
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.*;\npublic class X {\n public static void main(String[] args) {\n   System.out.println(\"hello\");\n }\n}\nrecord MyRecord<T> (MyIntf<T>... t) {\n\t@SafeVarargs\n\tpublic MyRecord(@MyAnnot MyIntf<T>... t) {\n\t\tthis.t = null;\n\t}\n}\ninterface MyIntf<T> {}\n@Retention(RetentionPolicy.RUNTIME)\n@interface MyAnnot {}\n"}, "hello");
        String expectedOutput = "  // Method descriptor #29 ()[LMyIntf;\n  // Signature: ()[LMyIntf<TT;>;\n  // Stack: 1, Locals: 1\n  public MyIntf[] t();\n";
        this.verifyClassFile(expectedOutput, "MyRecord.class", 4);
    }

    public void testBug571038_4() throws Exception {
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.*;\npublic class X {\n public static void main(String[] args) {\n   System.out.println(\"hello\");\n }\n}\nrecord MyRecord<T> (MyIntf<T>... t) {\n\t@SafeVarargs\n\tpublic MyRecord(MyIntf<@MyAnnot T>... t) {\n\t\tthis.t = null;\n\t}\n}\ninterface MyIntf<T> {}\n@Retention(RetentionPolicy.RUNTIME)\n@java.lang.annotation.Target(ElementType.TYPE_USE)\n@interface MyAnnot {}\n"}, "hello");
        String expectedOutput = "  // Method descriptor #29 ()[LMyIntf;\n  // Signature: ()[LMyIntf<TT;>;\n  // Stack: 1, Locals: 1\n  public MyIntf[] t();\n";
        this.verifyClassFile(expectedOutput, "MyRecord.class", 4);
    }

    public void testBug571454() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    public static void main(String argv[]) {\n       R rec = new R(3);\n\t\tif (rec.x() == 3) {\n\t\t\t// do nothing\n\t\t}\n    }\n}\n", "R.java", "record R(int x) {\n       R {\n               super();\n       }\n}"}, "----------\n1. ERROR in R.java (at line 3)\n\tsuper();\n\t^^^^^^^^\nThe body of a compact constructor must not contain an explicit constructor call\n----------\n");
    }

    public void testBug570399_001() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\n public static void main(String[] args) {\n    R r1 = new R( 2, 3); // Wrong error: The constructor MyRecord(int, int) is undefined\n    R r2 = new R();      // works\n    int total = r1.x()+r2.x()+r1.y()+r2.y();\n    System.out.println(\"Hi\"+total);\n  }\n}", "R.java", "public record R(int x, int y) {\n    R() {\n        this(0, 0);\n    }\n}"}, "Hi5");
    }

    public void testBug570399_002() throws Exception {
        this.runConformTest(new String[]{"X.java", "record R(int x) {\n}\npublic class X {\n public static void main(String[] args) {\n    R r2 = new R(5);      // works\n    int total = r2.x();\n    System.out.println(\"Hi\"+total);\n  }\n}"}, "Hi5");
    }

    public void testBug571141_1() {
        this.runConformTest(new String[]{"X.java", "public class X {\n public static void main(String[] args) {\n   System.out.println(\"helo\");\n }\n}\nrecord MyRecord(boolean equals){\n    public boolean equals() {\n        return equals;\n    }\n}"}, "helo");
    }

    public void testBug571141_2() {
        this.runConformTest(new String[]{"X.java", "public class X {\n public static void main(String[] args) {\n   System.out.println(\"helo\");\n }\n}\nrecord MyRecord(boolean equals){\n    public boolean equals() {\n        return equals;\n    }\n    public boolean equals(Object obj) {\n      return equals;\n    } \n}"}, "helo");
    }

    public void testBug571141_3() throws IOException, ClassFormatException {
        this.runConformTest(new String[]{"X.java", "public class X {\n public static void main(String[] args) {\n   System.out.println(\"helo\");\n }\n}\nrecord MyRecord(boolean b){\n    public boolean equals(Object other) {\n        return true;\n    }\n}"}, "helo");
        String unExpectedOutput = "  public final boolean equals(java.lang.Object arg0);\n    0  aload_0 [this]\n    1  aload_1 [arg0]\n    2  invokedynamic 0 equals(MyRecord, java.lang.Object) : boolean [35]\n    7  ireturn\n";
        String rFile = this.getClassFileContents("MyRecord.class", 4);
        this.verifyOutputNegative(rFile, unExpectedOutput);
    }

    public void testBugLazyCanon_001() throws IOException, ClassFormatException {
        this.runConformTest(new String[]{"X.java", "record X(int xyz, int y2k) {\n public X(int xyz, int y2k) {\n     this.xyz = xyz;\n     this.y2k = y2k;\n   }\n public static void main(String[] args) {\n   System.out.println(new X(33,1).xyz());\n }\n}"}, "33");
    }

    public void testBugLazyCanon_002() throws IOException, ClassFormatException {
        this.runConformTest(new String[]{"X.java", "record X(int xyz, int y2k) {\n public static void main(String[] args) {\n   System.out.println(new X(33,1).xyz());\n }\n}"}, "33");
    }

    public void testBugLazyCanon_003() throws IOException, ClassFormatException {
        this.runConformTest(new String[]{"X.java", "class X {\n  record Point (int  args) {\n    Point (String s, int t) {\n      this(t);\n    }\n  }\n   public static void main(String[] args) {\n    System.out.println(new X.Point(null, 33).args());\n    \n   }\n}"}, "33");
    }

    public void testBugLazyCanon_004() throws IOException, ClassFormatException {
        this.runConformTest(new String[]{"X.java", "record X<T> (T args) {\n public static void main(String[] args) {\n   System.out.println(new X<Integer>(100).args());\n   \n }\n}"}, "100");
    }

    public void testBugLazyCanon_005() throws IOException, ClassFormatException {
        this.runConformTest(new String[]{"X.java", "record X<T> (T args) {\n X(String s, T t) {\n   this(t);\n }\n public static void main(String[] args) {\n   System.out.println(100);\n   \n }\n}"}, "100");
    }

    public void testBugLazyCanon_006() throws IOException, ClassFormatException {
        this.runConformTest(new String[]{"X.java", "record X<T> (T args) {\n X(String s, T t) {\n   this(t);\n }\n public static void main(String[] args) {\n   System.out.println(new X<Integer>(100).args());\n   \n }\n}"}, "100");
    }

    public void testBug571765_001() {
        if (this.complianceLevel < 0x440000L) {
            return;
        }
        this.runNegativeTest(new String[]{"module-info.java", "public record R() {}\n"}, "----------\n1. ERROR in module-info.java (at line 1)\n\tpublic record R() {}\n\t^\nImplicitly Declared Classes and Instance Main Methods is a preview feature and disabled by default. Use --enable-preview to enable\n----------\n2. ERROR in module-info.java (at line 1)\n\tpublic record R() {}\n\t^\nImplicitly declared class must have a candidate main method\n----------\n3. ERROR in module-info.java (at line 1)\n\tpublic record R() {}\n\t       ^^^^^^\n'record' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 16\n----------\n");
    }

    public void testBug571905_01() throws Exception {
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.*;\nrecord X( int @MyAnnot [] j) {\n public static void main(String[] args) {\n   System.out.println(\"helo\");\n }\n}\n@Target({ElementType.TYPE_USE})\n@Retention(RetentionPolicy.RUNTIME)\n@interface MyAnnot {}\n"}, "helo");
        String expectedOutput = "  \n  // Method descriptor #49 ([I)V\n  // Stack: 2, Locals: 2\n  X(int[] j);\n     0  aload_0 [this]\n     1  invokespecial java.lang.Record() [50]\n     4  aload_0 [this]\n     5  aload_1 [j]\n     6  putfield X.j : int[] [31]\n     9  return\n      Line numbers:\n        [pc: 0, line: 1]\n      Method Parameters:\n        j\n    RuntimeVisibleTypeAnnotations: \n      #8 @MyAnnot(\n        target type = 0x16 METHOD_FORMAL_PARAMETER\n        method parameter index = 0\n      )\n";
        this.verifyClassFile(expectedOutput, "X.class", 4);
        expectedOutput = "  public int[] j();\n    0  aload_0 [this]\n    1  getfield X.j : int[] [31]\n    4  areturn\n      Line numbers:\n        [pc: 0, line: 2]\n    RuntimeVisibleTypeAnnotations: \n      #8 @MyAnnot(\n        target type = 0x14 METHOD_RETURN\n      )\n";
        this.verifyClassFile(expectedOutput, "X.class", 4);
    }

    public void testBug571905_02() throws Exception {
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.*;\nrecord X( int @MyAnnot ... j) {\n public static void main(String[] args) {\n   System.out.println(\"helo\");\n }\n}\n@Target({ElementType.TYPE_USE})\n@Retention(RetentionPolicy.RUNTIME)\n@interface MyAnnot {}\n"}, "helo");
        String expectedOutput = "  \n  // Method descriptor #49 ([I)V\n  // Stack: 2, Locals: 2\n  X(int... j);\n     0  aload_0 [this]\n     1  invokespecial java.lang.Record() [50]\n     4  aload_0 [this]\n     5  aload_1 [j]\n     6  putfield X.j : int[] [31]\n     9  return\n      Line numbers:\n        [pc: 0, line: 1]\n      Method Parameters:\n        j\n    RuntimeVisibleTypeAnnotations: \n      #8 @MyAnnot(\n        target type = 0x16 METHOD_FORMAL_PARAMETER\n        method parameter index = 0\n      )\n";
        this.verifyClassFile(expectedOutput, "X.class", 4);
        expectedOutput = "  public int[] j();\n    0  aload_0 [this]\n    1  getfield X.j : int[] [31]\n    4  areturn\n      Line numbers:\n        [pc: 0, line: 2]\n    RuntimeVisibleTypeAnnotations: \n      #8 @MyAnnot(\n        target type = 0x14 METHOD_RETURN\n      )\n";
        this.verifyClassFile(expectedOutput, "X.class", 4);
    }

    public void testBug572204_001() {
        this.runNegativeTest(new String[]{"R.java", "record R (@SafeVarargs String... s) {}\n"}, "----------\n1. ERROR in R.java (at line 1)\n\trecord R (@SafeVarargs String... s) {}\n\t                                 ^\n@SafeVarargs annotation cannot be applied to record component without explicit accessor method s\n----------\n");
    }

    public void testBug572204_002() {
        this.runConformTest(new String[]{"R.java", "record R (@SafeVarargs String... s) {\n public static void main(String[] args) {\n   System.out.println(\"helo\");\n }\n public String[] s() {\n  return this.s;\n }\n}\n"}, "helo");
    }

    public void testBug572204_003() {
        this.runNegativeTest(new String[]{"R.java", "record R (@SafeVarargs String... s) {\n public static void main(String[] args) {\n   System.out.println(\"helo\");\n }\n R (@SafeVarargs String... s) {\n   this.s=s;\n }\n}\n"}, "----------\n1. ERROR in R.java (at line 1)\n\trecord R (@SafeVarargs String... s) {\n\t                                 ^\n@SafeVarargs annotation cannot be applied to record component without explicit accessor method s\n----------\n2. ERROR in R.java (at line 5)\n\tR (@SafeVarargs String... s) {\n\t   ^^^^^^^^^^^^\nThe annotation @SafeVarargs is disallowed for this location\n----------\n");
    }

    public void testBug572204_004() {
        this.runNegativeTest(new String[]{"R.java", "record R (@SafeVarargs String... s) {\n public static void main(String[] args) {\n   System.out.println(\"helo\");\n }\n R (@SafeVarargs String... s) {\n   this.s=s;\n }\n public String[] s() {\n  return this.s;\n }\n}\n"}, "----------\n1. ERROR in R.java (at line 5)\n\tR (@SafeVarargs String... s) {\n\t   ^^^^^^^^^^^^\nThe annotation @SafeVarargs is disallowed for this location\n----------\n");
    }

    public void testBug572204_005() {
        this.runNegativeTest(new String[]{"R.java", "record R (@SafeVarargs String... s) {\n@SafeVarargs R (String... s) {\n   this.s = s;\n }\n}\n"}, "----------\n1. ERROR in R.java (at line 1)\n\trecord R (@SafeVarargs String... s) {\n\t                                 ^\n@SafeVarargs annotation cannot be applied to record component without explicit accessor method s\n----------\n");
    }

    public void testBug572204_006() {
        this.runConformTest(new String[]{"R.java", "record R (@SafeVarargs String... s) {\n public static void main(String[] args) {\n   System.out.println(\"helo\");\n }\n@SafeVarargs R (String... s) {\n   this.s = s;\n }\n public String[] s() {\n  return this.s;\n }\n}\n"}, "helo");
    }

    public void testBug572204_007() throws Exception {
        this.runConformTest(new String[]{"R.java", "import java.lang.annotation.*;\n@Target(ElementType.PARAMETER) \n@Retention(RetentionPolicy.RUNTIME)\n@interface I {}\r\nrecord R(@I String... s) {\n public static void main(String[] args) {\n   System.out.println(\"helo\");\n }\n}\n"}, "helo");
        String expectedOutput = "  \n  // Method descriptor #8 ([Ljava/lang/String;)V\n  // Stack: 2, Locals: 2\n  R(java.lang.String... s);\n     0  aload_0 [this]\n     1  invokespecial java.lang.Record() [48]\n     4  aload_0 [this]\n     5  aload_1 [s]\n     6  putfield R.s : java.lang.String[] [28]\n     9  return\n      Line numbers:\n        [pc: 0, line: 1]\n      Method Parameters:\n        s\n    RuntimeVisibleParameterAnnotations: \n      Number of annotations for parameter 0: 1\n        #47 @I(\n        )\n";
        this.verifyClassFile(expectedOutput, "R.class", 4);
        expectedOutput = "  \n  // Method descriptor #27 ()[Ljava/lang/String;\n  // Stack: 1, Locals: 1\n  public java.lang.String[] s();\n    0  aload_0 [this]\n    1  getfield R.s : java.lang.String[] [28]\n    4  areturn\n      Line numbers:\n        [pc: 0, line: 5]\n";
        this.verifyClassFile(expectedOutput, "R.class", 4);
    }

    public void testBug572934_001() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.localVariableHiding", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.specialParameterHidingField", "enabled");
        this.runConformTest(new String[]{"X.java", "public record X(int param) {\n\tpublic X(int param) {\n\t\tthis.param = param;\n\t}\n\tpublic static void main(String[] args) {\n\t\tX abc= new X(10);\n\t\tSystem.out.println(abc.param());\n\t}\n}\n"}, "10", options);
        options.put("org.eclipse.jdt.core.compiler.problem.localVariableHiding", "ignore");
        options.put("org.eclipse.jdt.core.compiler.problem.specialParameterHidingField", "disabled");
    }

    public void testBug572934_002() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.localVariableHiding", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.specialParameterHidingField", "enabled");
        this.runNegativeTest(new String[]{"X.java", "public record X(int param) {\n\tpublic X(int param) {\n\t\tthis.param = param;\n\t}\n\tpublic void main(int param) {\n\t\tSystem.out.println(param);\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tpublic void main(int param) {\n\t                     ^^^^^\nThe parameter param is hiding a field from type X\n----------\n", null, true, options);
        options.put("org.eclipse.jdt.core.compiler.problem.localVariableHiding", "ignore");
        options.put("org.eclipse.jdt.core.compiler.problem.specialParameterHidingField", "disabled");
    }

    public void testBug572934_003() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.localVariableHiding", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.specialParameterHidingField", "enabled");
        this.runNegativeTest(new String[]{"X.java", "public record X(int param) {\n\tpublic X(int param) {\n\t\tthis.param = param;\n\t}\tpublic void setParam(int param) {\n\t\t\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\t}\tpublic void setParam(int param) {\n\t \t                         ^^^^^\nThe parameter param is hiding a field from type X\n----------\n", null, true, options);
        options.put("org.eclipse.jdt.core.compiler.problem.localVariableHiding", "ignore");
        options.put("org.eclipse.jdt.core.compiler.problem.specialParameterHidingField", "disabled");
    }

    public void testBug573195_001() throws Exception {
        RecordsRestrictedClassTest.getPossibleComplianceLevels();
        this.runConformTest(new String[]{"X.java", "public class X {\n    protected record R(int i) {\n        public R(int i, int j) {\n            this(i);\n        }\n    }\n    public static void main(String[] args) {\n   R r = new R(1, 2);\n   System.out.println(r.i());\n }\n}"}, "1");
        String expectedOutput = "  // Method descriptor #12 (I)V\n  // Stack: 2, Locals: 2\n  protected X$R(int i);\n     0  aload_0 [this]\n     1  invokespecial java.lang.Record() [36]\n     4  aload_0 [this]\n     5  iload_1 [i]\n     6  putfield X$R.i : int [20]\n     9  return\n";
        this.verifyClassFile(expectedOutput, "X$R.class", 4);
    }

    public void testBug574284_001() throws Exception {
        RecordsRestrictedClassTest.getPossibleComplianceLevels();
        this.runConformTest(new String[]{"X.java", "public class X {\n\n    public static void main(String[] args) {\n        new X.Rec(false); // fails\n        new X.Rec(false, new int[0]);\n        System.out.println(0);\n    }\n\n    record Rec(boolean isHidden, int... indexes) {\n        Rec(int... indexes) {\n            this(false, indexes);\n        }\n    }\n}"}, "0");
        String expectedOutput = "  // Method descriptor #14 (Z[I)V\n  // Stack: 2, Locals: 3\n  X$Rec(boolean isHidden, int... indexes);\n     0  aload_0 [this]\n     1  invokespecial java.lang.Record() [41]\n     4  aload_0 [this]\n     5  iload_1 [isHidden]\n     6  putfield X$Rec.isHidden : boolean [21]\n     9  aload_0 [this]\n    10  aload_2 [indexes]\n    11  putfield X$Rec.indexes : int[] [24]\n    14  return\n";
        this.verifyClassFile(expectedOutput, "X$Rec.class", 4);
    }

    public void testBug574284_002() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\n    public static void main(String[] args) {\n        new X.Rec(false); // fails\n        new X.Rec(false, new int[0]);\n        System.out.println(0);\n    }\n\n    record Rec(boolean isHidden, int... indexes) {\n    }\n}"}, "0");
    }

    public void testBug574282_001() {
        this.runConformTest(new String[]{"X.java", "record Rec(String name) {\n\n    Rec() {\n        this(\"\");\n    }\n\n    @Override\n    public boolean equals(Object obj) {\n        return false;\n    }\n}\npublic class X {\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\n"}, "0");
    }

    public void testBug576519_001() {
        this.runNegativeTest(new String[]{"X.java", "class X extends Point{\n  public X(int x, int y){\n     \n  }\n}\nrecord Point(int x, int y){\n}"}, "----------\n1. ERROR in X.java (at line 1)\n\tclass X extends Point{\n\t                ^^^^^\nThe record Point cannot be the superclass of X; a record is final and cannot be extended\n----------\n");
    }

    public void testBug577251_001() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n  record Entry<T> (int value, Entry<T> entry) {\n     Entry(int value, Entry entry) { // Entry is a raw type here\n  }\n}\n}"}, "----------\n1. WARNING in X.java (at line 3)\n\tEntry(int value, Entry entry) { // Entry is a raw type here\n\t                 ^^^^^\nX.Entry is a raw type. References to generic type X.Entry<T> should be parameterized\n----------\n2. ERROR in X.java (at line 3)\n\tEntry(int value, Entry entry) { // Entry is a raw type here\n\t                 ^^^^^\nType or arity incompatibility in argument X.Entry of canonical constructor in record class\n----------\n");
    }

    public void testBug576806_001() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.undocumentedEmptyBlock", "error");
        this.runNegativeTest(false, new AbstractRegressionTest.JavacTestOptions("Xlint:empty"), new String[]{"X.java", "public class X {\n  public static void main(String[] args){\n  }\n}\nrecord Empty(){\n}\nrecord DocumentedEmpty(){\n  // intentionally empty\n}\nrecord Point(int x, int y){\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\tpublic static void main(String[] args){\n  }\n\t                                      ^^^^^\nEmpty block should be documented\n----------\n", null, false, options);
    }

    public void testIssue365_001() throws Exception {
        RecordsRestrictedClassTest.getPossibleComplianceLevels();
        this.runConformTest(new String[]{"A.java", "import java.util.Collections;\nimport java.util.List;\npublic record A(List<String> names) {\n    public A(String name) {\n        this(Collections.singletonList(name));\n    }\n    public static void main(String[] args) {\n        System.out.println(0);\n    }}\n"}, "0");
        String expectedOutput = "  // Method descriptor #20 (Ljava/util/List;)V\n  // Signature: (Ljava/util/List<Ljava/lang/String;>;)V\n  // Stack: 2, Locals: 2\n  public A(java.util.List names);\n     0  aload_0 [this]\n     1  invokespecial java.lang.Record() [64]\n     4  aload_0 [this]\n     5  aload_1 [names]\n     6  putfield A.names : java.util.List [46]\n     9  return\n";
        this.verifyClassFile(expectedOutput, "A.class", 4);
    }

    public void testRecordConstructorWithExceptionGh487() throws Exception {
        RecordsRestrictedClassTest.getPossibleComplianceLevels();
        this.runConformTest(true, new String[]{"X.java", "public record X(String s) {\n    public X {\n        throw new RuntimeException();\n    }\n    public static void main(String[] args) throws Exception {\n        new X(\"\");\n    }\n}\n"}, "", "", "java.lang.RuntimeException\n\tat X.<init>(X.java:3)\n\tat X.main(X.java:6)\n", AbstractRegressionTest.JavacTestOptions.forRelease("16"));
        String expectedOutput = "  // Method descriptor #8 (Ljava/lang/String;)V\n  // Stack: 2, Locals: 2\n  public X(java.lang.String s);\n     0  aload_0 [this]\n     1  invokespecial java.lang.Record() [10]\n     4  new java.lang.RuntimeException [13]\n     7  dup\n     8  invokespecial java.lang.RuntimeException() [15]\n    11  athrow\n";
        this.verifyClassFile(expectedOutput, "X.class", 4);
    }

    public void testGH1092() throws Exception {
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.*;\nimport java.lang.annotation.Target;\nimport java.util.List;\nimport java.lang.reflect.AnnotatedParameterizedType;\n\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.RUNTIME)\n@interface Ann {\n}\n\nrecord Record(\n    @Ann\n    List<@Ann String> list\n) {\n}\n\npublic class X {\n\n\tstatic void assertDoesNotThrow(Runnable exe, String message) {\n\t\texe.run();\n\t}\n\t\n    public static void main(String [] args) throws Exception {\n        AnnotatedParameterizedType listField = (AnnotatedParameterizedType) Record.class.getDeclaredMethod(\"list\").getAnnotatedReturnType();\n        assertDoesNotThrow(listField::getAnnotatedActualTypeArguments, \"Should not throw duplicate annotation exception.\");\n    }\n}\n"}, "");
        String expectedOutput = "  // Field descriptor #6 Ljava/util/List;\n  // Signature: Ljava/util/List<Ljava/lang/String;>;\n  private final java.util.List list;\n    RuntimeVisibleTypeAnnotations: \n      #10 @Ann(\n        target type = 0x13 FIELD\n      )\n      #10 @Ann(\n        target type = 0x13 FIELD\n        location = [TYPE_ARGUMENT(0)]\n      )\n  \n";
        this.verifyClassFile(expectedOutput, "Record.class", 4);
        expectedOutput = "  // Method descriptor #34 (Ljava/util/List;)V\n  // Signature: (Ljava/util/List<Ljava/lang/String;>;)V\n  // Stack: 2, Locals: 2\n  Record(java.util.List list);\n     0  aload_0 [this]\n     1  invokespecial java.lang.Record() [36]\n     4  aload_0 [this]\n     5  aload_1 [list]\n     6  putfield Record.list : java.util.List [14]\n     9  return\n      Line numbers:\n        [pc: 0, line: 1]\n      Method Parameters:\n        list\n    RuntimeVisibleTypeAnnotations: \n      #10 @Ann(\n        target type = 0x16 METHOD_FORMAL_PARAMETER\n        method parameter index = 0\n      )\n      #10 @Ann(\n        target type = 0x16 METHOD_FORMAL_PARAMETER\n        method parameter index = 0\n        location = [TYPE_ARGUMENT(0)]\n      )\n\n";
        this.verifyClassFile(expectedOutput, "Record.class", 4);
        expectedOutput = "  // Method descriptor #11 ()Ljava/util/List;\n  // Signature: ()Ljava/util/List<Ljava/lang/String;>;\n  // Stack: 1, Locals: 1\n  public java.util.List list();\n    0  aload_0 [this]\n    1  getfield Record.list : java.util.List [14]\n    4  areturn\n      Line numbers:\n        [pc: 0, line: 13]\n    RuntimeVisibleTypeAnnotations: \n      #10 @Ann(\n        target type = 0x14 METHOD_RETURN\n      )\n      #10 @Ann(\n        target type = 0x14 METHOD_RETURN\n        location = [TYPE_ARGUMENT(0)]\n      )\n  \n";
        this.verifyClassFile(expectedOutput, "Record.class", 4);
        expectedOutput = "// Component descriptor #6 Ljava/util/List;\n// Signature: Ljava/util/List<Ljava/lang/String;>;\njava.util.List list;\n  RuntimeVisibleTypeAnnotations: \n    #10 @Ann(\n      target type = 0x13 FIELD\n    )\n    #10 @Ann(\n      target type = 0x13 FIELD\n      location = [TYPE_ARGUMENT(0)]\n    )\n";
        this.verifyClassFile(expectedOutput, "Record.class", 4);
    }

    public void testBug576719() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.parameterAssignment", "error");
        this.runNegativeTest(true, new String[]{"Rational.java", "public record Rational(int num, int denom) {\n    public Rational {\n        int gcd = gcd(num, denom);\n        num /= gcd;\n        denom /= gcd;\n    }\n    \n    private static int gcd(int a, int b) {\n        a = 10;\n        throw new UnsupportedOperationException();\n    }\n}\n"}, null, options, "----------\n1. ERROR in Rational.java (at line 9)\n\ta = 10;\n\t^\nThe parameter a should not be assigned\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void testGH1258() {
        this.runConformTest(new String[]{"Main.java", "public class Main {\n\tpublic static void main(String[] args) {\n\tMyRecord test = new MyRecord(0, 0);\n\tSystem.out.println(test.field1());\n\t}\n}\n\n@Deprecated(since = MyRecord.STATIC_VALUE)\nrecord MyRecord(int field1, int field2) {\n\tpublic static final String STATIC_VALUE = \"test\";\n}\n"});
    }

    public void testIssue1218_001() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T> {\n record R(T x);\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\trecord R(T x);\n\t         ^\nCannot make a static reference to the non-static type T\n----------\n2. ERROR in X.java (at line 2)\n\trecord R(T x);\n\t            ^\nSyntax error, insert \"ClassBody\" to complete ClassBodyDeclarations\n----------\n");
    }

    public void testIssue1641_001() {
        if (!isJRE17Plus) {
            return;
        }
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.compliance", "17");
        options.put("org.eclipse.jdt.core.compiler.source", "17");
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "17");
        this.runNegativeTest(new String[]{"X.java", "record InterfaceInRecord() {\n    sealed interface I {\n        enum Empty implements I {\n            INSTANCE;\n        }\n        record Single(double value) implements I {\n        }\n    }\n}\n\tclass X {\n\tvoid foo() {\n\t\tZork();\n\t}\n}\n\n"}, "----------\n1. ERROR in X.java (at line 12)\n\tZork();\n\t^^^^\nThe method Zork() is undefined for the type X\n----------\n", null, true, options);
    }

    public void testIssue1641_002() {
        if (!isJRE17Plus) {
            return;
        }
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.compliance", "17");
        options.put("org.eclipse.jdt.core.compiler.source", "17");
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "17");
        this.runNegativeTest(new String[]{"X.java", "\trecord InterfaceInRecord() {\n\t    sealed interface I  {\n\t        final class C implements I {\n\t        }\n\t    }\n\t}\n\tclass X {\n\t\tvoid foo() {\n\t\t\tZork();\n\t\t}\n\t}\n\n"}, "----------\n1. ERROR in X.java (at line 9)\n\tZork();\n\t^^^^\nThe method Zork() is undefined for the type X\n----------\n", null, true, options);
    }

    public void testIssue1641_003() {
        if (!isJRE17Plus) {
            return;
        }
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.compliance", "17");
        options.put("org.eclipse.jdt.core.compiler.source", "17");
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "17");
        this.runNegativeTest(new String[]{"X.java", "enum InterfaceInEnum {\n      \tINSTANCE;\n\tsealed interface I  {\n      \tfinal class C implements I {}\n\t}\n\tfinal class D implements I {}\n\tfinal class E implements InterfaceInEnum.I {}\n}\nclass X {\n\tvoid foo() {\n\t\tZork();\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 11)\n\tZork();\n\t^^^^\nThe method Zork() is undefined for the type X\n----------\n", null, true, options);
    }

    public void testIssue1641_004() {
        if (!isJRE17Plus) {
            return;
        }
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.compliance", "17");
        options.put("org.eclipse.jdt.core.compiler.source", "17");
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "17");
        this.runNegativeTest(new String[]{"X.java", "enum InterfaceInEnum {\n      \tINSTANCE;\n\tsealed interface I  {\n      \tfinal class C implements I {}\n\t}\n\tfinal class D implements I {}\n}\nclass X {\n\tvoid foo() {\n\t\tZork();\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 10)\n\tZork();\n\t^^^^\nThe method Zork() is undefined for the type X\n----------\n", null, true, options);
    }

    public void testIssue1641_005() {
        if (!isJRE17Plus) {
            return;
        }
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.compliance", "17");
        options.put("org.eclipse.jdt.core.compiler.source", "17");
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "17");
        this.runNegativeTest(new String[]{"X.java", "interface I  {\n\tenum E {\n\t\tFirst {}\n\t};\n}\nclass X {\n\tvoid foo() {\n\t\tZork();\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\tZork();\n\t^^^^\nThe method Zork() is undefined for the type X\n----------\n", null, true, options);
    }

    public void testIssue1641_006() {
        if (!isJRE17Plus) {
            return;
        }
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.compliance", "17");
        options.put("org.eclipse.jdt.core.compiler.source", "17");
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "17");
        this.runNegativeTest(new String[]{"X.java", "interface I  {\n\tenum E {\n\t\tFirst {\n\t\t\t@SuppressWarnings(\"unused\")\n\t\t\tenum F {\n\t\t\t\tFirstOne {\n\t\t\t\t\tinterface J {\n\t\t\t\t\t\tenum G {\n\t\t\t\t\t\t\tFirstTwo {}\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t};\n\t\t}\n\t};\n}\nclass X {\n\tvoid foo() {\n\t\tZork();\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 19)\n\tZork();\n\t^^^^\nThe method Zork() is undefined for the type X\n----------\n", null, true, options);
    }

    public void testGH1806() {
        this.runConformTest(new String[]{"MyRecord.java", "public record MyRecord(int a) {\n\n\tpublic static void main(String[] args) {\n\t\tvar ctor = MyRecord.class.getConstructors()[0];\n\t\tSystem.out.println(ctor.getParameters()[0].isImplicit());\n\t}\n\n\tpublic MyRecord {\n\n\t}\n\n}\n"}, "true");
    }

    public void testGH1939() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\n    interface Foo {}\n\n    interface A {\n        <T extends Foo> Class<T> clazz() ;\n    }\n\n    record AA<T extends Foo>( Class<T> clazz ) implements A {}\n\n    public static void main(String [] args) {\n        System.out.println(\"OK!\");\n    }\n}\n"}, "OK!");
    }

    public void testIssue3745() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    public static void main(String[] args) {}\n    record R(int x,) {}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\trecord R(int x,) {}\n\t              ^\nSyntax error on token \",\", SingleVariableDeclarator expected after this token\n----------\n");
    }

    public void testIssue3745_full() {
        this.runNegativeTest(new String[]{"X.java", "package test;\n\npublic class Test {\n\n    private static final PathReplacement[] REPLACEMENTS = {\n            new PathReplacement(\"\", \"\"),\n    };\n\n    public static void main(String[] args) {\n\n    }\n\n    private record PathReplacement(String absolutePathPrefix, String bazelPath) {}\n\n    private record BuildProperties(\n            int resourceDirsToSkip,\n    ) {}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tpublic class Test {\n\t             ^^^^\nThe public type Test must be defined in its own file\n----------\n2. ERROR in X.java (at line 16)\n\tint resourceDirsToSkip,\n\t                      ^\nSyntax error on token \",\", SingleVariableDeclarator expected after this token\n----------\n");
    }

    public void testBug3504_1() {
        this.runNegativeTest(new String[]{"X.java", "\tclass X {\n\t       public static void main(String[] args) {\n\t           record R(int x) {\n\t           \t\tstatic {\n\t                \tstatic int i = 0;\n\t          \t\t}\n\t        \t}\n\t        \tR r =  new R(100);\n\t        \tSystem.out.println(r.x());\n\t    \t}\n\t}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tstatic int i = 0;\n\t           ^\nIllegal modifier for the variable i; only final is permitted\n----------\n");
    }

    public void testPR3675() {
        this.runNegativeTest(new String[]{"X.java", "\tclass X {\n\t       record Y() {}\n\t       X {}\n\t}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tX {}\n\t^\nA compact constructor is allowed only in record classes\n----------\n");
    }

    public void testPR3675_2() {
        this.runNegativeTest(new String[]{"X.java", "\tpublic record X() {\n\t       class Y {}\n\t       X {}\n\t}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tX {}\n\t^\nCannot reduce the visibility of a canonical constructor X from that of the record\n----------\n");
    }

    public void testGH3891() {
        this.runNegativeTest(new String[]{"Test.java", "public class Test {\n\t{\n\t\tsuper();\n\t}\n}\n"}, "----------\n1. ERROR in Test.java (at line 3)\n\tsuper();\n\t^^^^^^^^\nConstructor call must be the first statement in a constructor\n----------\n");
    }

    public void testGH3891_preview() {
        if (this.complianceLevel < 0x440000L) {
            return;
        }
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.customOptions = this.getCompilerOptions();
        runner.customOptions.put("org.eclipse.jdt.core.compiler.problem.enablePreviewFeatures", "enabled");
        runner.testFiles = new String[]{"Test.java", "public class Test {\n\t{\n\t\tsuper();\n\t}\n}\n"};
        runner.expectedCompilerLog = "----------\n1. ERROR in Test.java (at line 3)\n\tsuper();\n\t^^^^^^^^\nConstructor call must be the first statement in a constructor\n----------\n";
        runner.runNegativeTest();
    }

    public void testIssue3904() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unusedParameter", "error");
        this.runNegativeTest(new String[]{"X.java", "class X {\n\tpublic static void main(String[] args) {\n\t\tPair p = new Pair(\"4\", \"2\");\n\t\tSystem.out.println(p.fTag() + p.fContent());\n\t}\n\tpublic record Pair(String fTag, String fContent) {}\n   public void foo(int unused) {\n   }\n   public record Person(String name, int age) {\n       public Person(String name, int age) {\n           this.name = null; this.age = 0;\n       }\n   }\n   public record Point (int x, int y) {\n       public Point {}\n   }\n\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tpublic void foo(int unused) {\n\t                    ^^^^^^\nThe value of the parameter unused is not used\n----------\n2. ERROR in X.java (at line 10)\n\tpublic Person(String name, int age) {\n\t                     ^^^^\nThe value of the parameter name is not used\n----------\n3. ERROR in X.java (at line 10)\n\tpublic Person(String name, int age) {\n\t                               ^^^\nThe value of the parameter age is not used\n----------\n", null, true, options);
    }

    public void testAnnotationsOnConstructor() {
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.*;\nimport java.lang.reflect.*;\n\n@Retention(RetentionPolicy.RUNTIME)\n@Target(ElementType.PARAMETER)\n@interface ParameterAnnot {\n}\n\npublic record X(@ParameterAnnot int x) {\n\n\tpublic static void main(String[] args) {\n\t\ttry {\n\t\t\tClass<?> c = X.class;\n\t\t\tConstructor<?> constructor = c.getConstructor(int.class);\n\t\t\tAnnotation[][] paramAnnotations = constructor.getParameterAnnotations();\n\t\t\tParameter[] parameters = constructor.getParameters();\n\n\t\t\tfor (int i = 0; i < parameters.length; i++) {\n\t\t\t\tSystem.out.print(\"Parameter \" + parameters[i].getName() + \": \");\n\t\t\t\tif (paramAnnotations[i] == null || paramAnnotations[i].length == 0) {\n\t\t\t\t\tSystem.out.println(\" No Annotations!\");\n\t\t\t\t} else {\n\t\t\t\t\tfor (Annotation annotation : paramAnnotations[i]) {\n\t\t\t\t\t\tif (annotation instanceof ParameterAnnot) {\n\t\t\t\t\t\t\tSystem.out.println(\"Found Parameter annotation\");\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t} catch (NoSuchMethodException e) {\n\t\t\te.printStackTrace();\n\t\t}\n\t}\n\n}\n"}, "Parameter x: Found Parameter annotation");
    }

    public void testAnnotationsOnConstructor_2() {
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.*;\nimport java.lang.reflect.*;\n\n@Retention(RetentionPolicy.RUNTIME)\n@Target(ElementType.PARAMETER)\n@interface ParameterAnnot {\n}\n\npublic record X(@ParameterAnnot int x) {\n\n    public X {\n    }\n\n\tpublic static void main(String[] args) {\n\t\ttry {\n\t\t\tClass<?> c = X.class;\n\t\t\tConstructor<?> constructor = c.getConstructor(int.class);\n\t\t\tAnnotation[][] paramAnnotations = constructor.getParameterAnnotations();\n\t\t\tParameter[] parameters = constructor.getParameters();\n\n\t\t\tfor (int i = 0; i < parameters.length; i++) {\n\t\t\t\tSystem.out.print(\"Parameter \" + parameters[i].getName() + \": \");\n\t\t\t\tif (paramAnnotations[i] == null || paramAnnotations[i].length == 0) {\n\t\t\t\t\tSystem.out.println(\" No Annotations!\");\n\t\t\t\t} else {\n\t\t\t\t\tfor (Annotation annotation : paramAnnotations[i]) {\n\t\t\t\t\t\tif (annotation instanceof ParameterAnnot) {\n\t\t\t\t\t\t\tSystem.out.println(\"Found Parameter annotation\");\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t} catch (NoSuchMethodException e) {\n\t\t\te.printStackTrace();\n\t\t}\n\t}\n\n}\n"}, "Parameter x: Found Parameter annotation");
    }

    public void testAnnotationsOnConstructor_3() {
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.*;\nimport java.lang.reflect.*;\n\n@Retention(RetentionPolicy.RUNTIME)\n@Target(ElementType.PARAMETER)\n@interface ParameterAnnot {\n}\n\npublic record X(@ParameterAnnot int x) {\n\n    public X (int x) {\n    \tthis.x = x;\n    }\n\n\tpublic static void main(String[] args) {\n\t\ttry {\n\t\t\tClass<?> c = X.class;\n\t\t\tConstructor<?> constructor = c.getConstructor(int.class);\n\t\t\tAnnotation[][] paramAnnotations = constructor.getParameterAnnotations();\n\t\t\tParameter[] parameters = constructor.getParameters();\n\n\t\t\tfor (int i = 0; i < parameters.length; i++) {\n\t\t\t\tSystem.out.print(\"Parameter \" + parameters[i].getName() + \": \");\n\t\t\t\tif (paramAnnotations[i] == null || paramAnnotations[i].length == 0) {\n\t\t\t\t\tSystem.out.println(\" No Annotations!\");\n\t\t\t\t} else {\n\t\t\t\t\tfor (Annotation annotation : paramAnnotations[i]) {\n\t\t\t\t\t\tif (annotation instanceof ParameterAnnot) {\n\t\t\t\t\t\t\tSystem.out.println(\"Found Parameter annotation\");\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t} catch (NoSuchMethodException e) {\n\t\t\te.printStackTrace();\n\t\t}\n\t}\n\n}\n"}, "Parameter x:  No Annotations!");
    }

    public void testAnnotationsOnConstructor_4() {
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.*;\nimport java.lang.reflect.*;\n\n@Retention(RetentionPolicy.RUNTIME)\n@Target(ElementType.PARAMETER)\n@interface ParameterAnnot {\n}\n\npublic record X(@ParameterAnnot int x) {\n\n    public X (@ParameterAnnot int x) {\n    \tthis.x = x;\n    }\n\n\tpublic static void main(String[] args) {\n\t\ttry {\n\t\t\tClass<?> c = X.class;\n\t\t\tConstructor<?> constructor = c.getConstructor(int.class);\n\t\t\tAnnotation[][] paramAnnotations = constructor.getParameterAnnotations();\n\t\t\tParameter[] parameters = constructor.getParameters();\n\n\t\t\tfor (int i = 0; i < parameters.length; i++) {\n\t\t\t\tSystem.out.print(\"Parameter \" + parameters[i].getName() + \": \");\n\t\t\t\tif (paramAnnotations[i] == null || paramAnnotations[i].length == 0) {\n\t\t\t\t\tSystem.out.println(\" No Annotations!\");\n\t\t\t\t} else {\n\t\t\t\t\tfor (Annotation annotation : paramAnnotations[i]) {\n\t\t\t\t\t\tif (annotation instanceof ParameterAnnot) {\n\t\t\t\t\t\t\tSystem.out.println(\"Found Parameter annotation\");\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t} catch (NoSuchMethodException e) {\n\t\t\te.printStackTrace();\n\t\t}\n\t}\n\n}\n"}, "Parameter x: Found Parameter annotation");
    }

    public void testIssue3664() {
        this.runNegativeTest(new String[]{"X.java", "record R(int x) {\n\n\tR {\n\n\t}\n\n\tR {\n\n\t}\n\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tR {\n\t^\nDuplicate method R(int) in type R\n----------\n2. ERROR in X.java (at line 7)\n\tR {\n\t^\nDuplicate method R(int) in type R\n----------\n");
    }

    public void testIssue3662() {
        this.runNegativeTest(new String[]{"Y.java", "public protected  record Y() {\n\n}\n"}, "----------\n1. ERROR in Y.java (at line 1)\n\tpublic protected  record Y() {\n\t                         ^\nIllegal modifier for the record Y; only public, final and strictfp are permitted\n----------\n");
    }

    public void testIssue3927() {
        this.runConformTest(new String[]{"Test.java", "import java.util.Arrays;\nimport java.util.List;\n\nimport snippet.*;\n\npublic class Test {\n\tList<ElementAtZoom<ImageData>> loadFromByteStream(int fileZoom, int targetZoom) {\n\t\treturn Arrays.stream(loadFromByteStream()).map(d -> new ElementAtZoom<>(d, fileZoom)).toList();\n\t}\n\tImageData[] loadFromByteStream() {\n\t\treturn null;\n\t}\n\tpublic static void main(String [] args) {\n\t\tSystem.out.println(\"Ok!\");\n\t}\n}\n", "ElementAtZoom.java", "package snippet;\n\npublic record ElementAtZoom<T>(T element, int zoom) {\n\tpublic ElementAtZoom {\n\t}\n}\n", "ImageData.java", "package snippet;\npublic interface ImageData {\n}\n"}, "Ok!");
    }

    public void testIssue3927_2() {
        this.runConformTest(new String[]{"Test.java", "import java.util.Arrays;\nimport java.util.List;\n\nimport snippet.*;\n\npublic class Test {\n\tList<ElementAtZoom<ImageData>> loadFromByteStream(int fileZoom, int targetZoom) {\n\t\treturn Arrays.stream(loadFromByteStream()).map(d -> new ElementAtZoom<>(d, fileZoom)).toList();\n\t}\n\tImageData[] loadFromByteStream() {\n\t\treturn null;\n\t}\n\tpublic static void main(String [] args) {\n\t\tSystem.out.println(\"Ok!\");\n\t}\n}\n", "ElementAtZoom.java", "package snippet;\n\npublic record ElementAtZoom<T>(T element, int zoom) {\n}\n", "ImageData.java", "package snippet;\npublic interface ImageData {\n}\n"}, "Ok!");
    }

    public void testIssue3927_3() {
        this.runNegativeTest(new String[]{"Test.java", "import java.util.Arrays;\nimport java.util.List;\n\nimport snippet.*;\n\npublic class Test {\n\tList<ElementAtZoom<ImageData>> loadFromByteStream(int fileZoom, int targetZoom) {\n\t\treturn Arrays.stream(loadFromByteStream()).map(d -> new ElementAtZoom<>(d, \"wrong-argument-type\")).toList();\n\t}\n\tImageData[] loadFromByteStream() {\n\t\treturn null;\n\t}\n\tpublic static void main(String [] args) {\n\t\tSystem.out.println(\"Ok!\");\n\t}\n}\n", "ElementAtZoom.java", "package snippet;\n\npublic record ElementAtZoom<T>(T element, int zoom) {\n}\n", "ImageData.java", "package snippet;\npublic interface ImageData {\n}\n"}, "----------\n1. ERROR in Test.java (at line 8)\n\treturn Arrays.stream(loadFromByteStream()).map(d -> new ElementAtZoom<>(d, \"wrong-argument-type\")).toList();\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from List<Object> to List<ElementAtZoom<ImageData>>\n----------\n2. ERROR in Test.java (at line 8)\n\treturn Arrays.stream(loadFromByteStream()).map(d -> new ElementAtZoom<>(d, \"wrong-argument-type\")).toList();\n\t                                                    ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nCannot infer type arguments for ElementAtZoom<>\n----------\n");
    }

    public void testSafeVarargs() {
        this.runNegativeTest(new String[]{"X.java", "public record X (@SafeVarargs int ... x) {\n}\n"}, "----------\n1. ERROR in X.java (at line 1)\r\n\tpublic record X (@SafeVarargs int ... x) {\r\n\t                                      ^\n@SafeVarargs annotation cannot be applied to record component without explicit accessor method x\n----------\n");
        this.runConformTest(new String[]{"X.java", "public record X (@SafeVarargs int ... x) {\n    public int [] x() {\n    \treturn this.x;\n    }\n    public static void main(String [] args) {\n    \tSystem.out.println(\"Ok!\");\n   \t}\n}\n"}, "Ok!");
    }

    public void testUnderscoreName() {
        if (this.complianceLevel < 0x410000L) {
            return;
        }
        this.runNegativeTest(new String[]{"X.java", "public record X (int _) {\n}\n"}, this.complianceLevel < 0x420000L ? "----------\n1. ERROR in X.java (at line 1)\n\tpublic record X (int _) {\n\t                     ^\n'_' is a keyword from source level 9 onwards, cannot be used as identifier\n----------\n" : "----------\n1. ERROR in X.java (at line 1)\n\tpublic record X (int _) {\n\t                     ^\nAs of release 22, '_' is only allowed to declare unnamed patterns, local variables, exception parameters or lambda parameters\n----------\n");
    }

    public void testCompactConstuctorTypeAnnotations() {
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.*;\nimport java.lang.reflect.*;\n\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.RUNTIME)\n@interface MyTypeAnno {\n    String value();\n}\n\npublic record X(@MyTypeAnno(\"constructor param\") int x) {\n\n    // Constructor with a type annotation on its parameter\n    public X {\n        // no-op\n    }\n\n    public static void main(String[] args) throws Exception {\n        // Get the Constructor object for X(int)\n        Constructor<X> constructor = X.class.getConstructor(int.class);\n\n        // Get annotated types of the parameters\n        AnnotatedType[] annotatedParams = constructor.getAnnotatedParameterTypes();\n\n        // Print each annotation on each parameter\n        for (int i = 0; i < annotatedParams.length; i++) {\n            System.out.println(\"Constructor parameter \" + i + \" annotations:\");\n            for (Annotation annotation : annotatedParams[i].getAnnotations()) {\n                System.out.println(\"  \" + annotation);\n            }\n        }\n    }\n}\n"}, "Constructor parameter 0 annotations:\n  @MyTypeAnno(\"constructor param\")");
    }

    public void testIssue3951() throws Exception {
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.Annotation;\nimport java.util.List;\n\npublic record X (List<Class<? extends Annotation>> classes) {\n\tpublic X {\n\n\t}\n\n\tpublic static void main(String [] args) {\n\t\tSystem.out.println(\"Ok!\");\n\t}\n}\n"}, "Ok!");
        String expectedOutput = "  // Method descriptor #10 (Ljava/util/List;)V\n  // Signature: (Ljava/util/List<Ljava/lang/Class<+Ljava/lang/annotation/Annotation;>;>;)V\n  // Stack: 2, Locals: 2\n  public X(java.util.List classes);\n     0  aload_0 [this]\n     1  invokespecial java.lang.Record() [13]\n     4  aload_0 [this]\n     5  aload_1 [classes]\n     6  putfield X.classes : java.util.List [16]\n     9  return\n      Line numbers:\n        [pc: 0, line: 5]\n        [pc: 4, line: 7]\n      Local variable table:\n        [pc: 0, pc: 10] local: this index: 0 type: X\n        [pc: 0, pc: 10] local: classes index: 1 type: java.util.List\n      Local variable type table:\n        [pc: 0, pc: 10] local: classes index: 1 type: java.util.List<java.lang.Class<? extends java.lang.annotation.Annotation>>\n      Method Parameters:\n        mandated classes\n";
        this.verifyClassFile(expectedOutput, "X.class", 4);
    }

    public void testIssue3957() {
        Map<String, String> customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.missingOverrideAnnotation", "error");
        this.runNegativeTest(true, new String[]{"X.java", "public record X(int x) {\n    public int x() {\n        return this.x;\n       }\n}\n"}, null, customOptions, "----------\n1. ERROR in X.java (at line 2)\n\tpublic int x() {\n\t           ^^^\nThe component accessor method x() of record class X should be tagged with @Override\n----------\n", AbstractRegressionTest.JavacTestOptions.SKIP);
    }

    public void testIssue3663() {
        this.runNegativeTest(new String[]{"X.java", "record R(int ... x) {\n\n\tR(int [] x) {\n\t\tthis.x = x;\n\t}\n\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tR(int [] x) {\n\t  ^^^^^^\nType or arity incompatibility in argument int[] of canonical constructor in record class\n----------\n");
        this.runNegativeTest(new String[]{"X.java", "record R(int [] x) {\n\n\tR(int ... x) {\n\t\tthis.x = x;\n\t}\n\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tR(int ... x) {\n\t  ^^^^^^^\nType or arity incompatibility in argument int[] of canonical constructor in record class\n----------\n");
    }

    public void testIssue4015() {
        this.runConformTest(new String[]{"X.java", "import java.util.function.Supplier;\n\npublic class X {\n\n\tpublic String method() {\n\n\t\trecord ARecord() {\n\t\t\tpublic static ARecord of() {\n\t\t\t\treturn new ARecord();\n\t\t\t}\n\t\t}\n\n\t\tARecord ar = ARecord.of();\n\t\treturn ar.toString();\n\t}\n\n\tpublic static Supplier<Object> test() {\n\t\tclass A {}\n\t\treturn () -> new A();\n\t}\n\n    public static void main(String [] args) {\n        System.out.println(new X().method());\n    }\n}\n"}, "ARecord[]");
    }

    public void testIssue4015_2() {
        this.runConformTest(new String[]{"X.java", "import java.util.function.Supplier;\n\npublic class X {\n\n\tpublic static String staticMethod() {\n\n\t\trecord ARecord() {\n\t\t\tpublic static ARecord of() {\n\t\t\t\treturn new ARecord();\n\t\t\t}\n\t\t}\n\n\t\tARecord ar = ARecord.of();\n\t\treturn ar.toString();\n\t}\n\n\tpublic static Supplier<Object> test() {\n\t\tclass A {}\n\t\treturn () -> new A();\n\t}\n\n    public static void main(String [] args) {\n        System.out.println(staticMethod());\n    }\n}\n"}, "ARecord[]");
    }

    public void testIssue4015_3() {
        this.runConformTest(new String[]{"X.java", "import java.util.function.Supplier;\n\npublic class X {\n\n\tinterface I {}\n\n\tpublic String method() {\n\n\t\trecord ARecord() implements I {\n\t\t\tpublic static ARecord of() {\n\t\t\t\tSupplier<I> si = ARecord::new;\n\t\t\t\treturn (ARecord) si.get();\n\t\t\t}\n\t\t}\n\t\treturn ARecord.of().toString();\n\t}\n\n\tpublic static void main(String [] args) {\n        System.out.println(new X().method());\n    }\n}\n"}, "ARecord[]");
    }

    public void testIssue4015_4() {
        this.runConformTest(new String[]{"X.java", "import java.util.function.Supplier;\n\npublic class X {\n\n\tinterface I {}\n\n\tpublic static String staticMethod() {\n\n\t\trecord ARecord() implements I {\n\t\t\tpublic static ARecord of() {\n\t\t\t\tSupplier<I> si = ARecord::new;\n\t\t\t\treturn (ARecord) si.get();\n\t\t\t}\n\t\t}\n\t\treturn ARecord.of().toString();\n\t}\n\n\tpublic static void main(String [] args) {\n        System.out.println(staticMethod());\n    }\n}\n"}, "ARecord[]");
    }

    public void testIssue4025() {
        this.runConformTest(new String[]{"X.java", "public record X(boolean equals)  {\n    public boolean equals() {\n        return equals;\n    }\n\n    public static void main(String argv[]) {\n        System.out.println(\"Ok!\");\n    }\n}\n"}, "Ok!");
    }

    public void testIssue4094() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static void main(String [] args) {\n        System.out.println(ClassB.B);\n    }\n}\n", "ClassB.java", "import java.util.List;\nimport java.util.function.Predicate;\n\n\npublic class ClassB {\n\n  private final Predicate<RecordA> predicate;\n\n  public static final ClassB B = new ClassB(recordA -> recordA.test.isEmpty());\n\n  public ClassB(Predicate<RecordA> predicate) {\n    this.predicate = predicate;\n  }\n\n  public String toString() {\n  \t  return \"ClassB instance\";\n  }\n\n  record RecordA(List<Object> test, Integer i) {\n  }\n}\n"}, "ClassB instance");
    }

    public void testIssue4106() {
        Map<String, String> customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.missingOverrideAnnotation", "error");
        this.runNegativeTest(true, new String[]{"X.java", "public record X(String withoutOverride, String withOverride) {\n\n  public String withoutOverride() {\n    return withoutOverride;\n  }\n\n  @Override\n  public String withOverride() {\n    return withOverride;\n  }\n}\n"}, null, customOptions, "----------\n1. ERROR in X.java (at line 3)\n\tpublic String withoutOverride() {\n\t              ^^^^^^^^^^^^^^^^^\nThe component accessor method withoutOverride() of record class X should be tagged with @Override\n----------\n", AbstractRegressionTest.JavacTestOptions.SKIP);
    }

    public void testIssue4118() {
        this.runConformTest(new String[]{"RecordCompactWithReader.java", "import java.io.Reader;\nimport java.time.Instant;\nimport java.util.Objects;\n\npublic record RecordCompactWithReader(Instant modified, Reader reader) {\n    public RecordCompactWithReader {\n        Objects.requireNonNull(modified);\n        Objects.requireNonNull(reader);\n    }\n    public static void main(String [] args) {\n    \tSystem.out.println(\"OK!\");\n    }\n}\n"}, "OK!");
    }

    public void testIssue4070() {
        this.runConformTest(new String[]{"Config.java", "import java.net.URI;\nimport java.net.http.HttpClient;\nimport java.util.Objects;\n\npublic record Config(HttpClient httpClient, URI base, String defaultContentType) {\n\n\t  @SuppressWarnings(\"resource\")\n\t  public Config {\n\t    Objects.requireNonNull(httpClient, \"httpClient\");\n\t  }\n\n\t  public static void main(String [] args) {\n    \tSystem.out.println(\"OK!\");\n    }\n}\n"}, "OK!");
    }

    public void testIssue4146() {
        this.runNegativeTest(new String[]{"Segment.java", "package repro;\n\nimport com.fasterxml.jackson.annotation.JsonInclude;\nimport com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;\n\npublic record Segment(@JacksonXmlProperty(isAttribute = true) String id,\n                      String source,\n                      @JsonInclude(JsonInclude.Include.NON_NULL) String target) {\n\n}\n"}, "----------\n1. ERROR in Segment.java (at line 3)\r\n\timport com.fasterxml.jackson.annotation.JsonInclude;\r\n\t       ^^^^^^^^^^^^^\nThe import com.fasterxml cannot be resolved\n----------\n2. ERROR in Segment.java (at line 4)\r\n\timport com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;\r\n\t       ^^^^^^^^^^^^^\nThe import com.fasterxml cannot be resolved\n----------\n3. ERROR in Segment.java (at line 6)\r\n\tpublic record Segment(@JacksonXmlProperty(isAttribute = true) String id,\r\n\t                       ^^^^^^^^^^^^^^^^^^\nJacksonXmlProperty cannot be resolved to a type\n----------\n4. ERROR in Segment.java (at line 8)\r\n\t@JsonInclude(JsonInclude.Include.NON_NULL) String target) {\r\n\t ^^^^^^^^^^^\nJsonInclude cannot be resolved to a type\n----------\n5. ERROR in Segment.java (at line 8)\r\n\t@JsonInclude(JsonInclude.Include.NON_NULL) String target) {\r\n\t             ^^^^^^^^^^^\nJsonInclude cannot be resolved to a variable\n----------\n");
    }

    public void testIssue4146_2() {
        this.runNegativeTest(new String[]{"Segment.java", "package repro;\n\nimport com.fasterxml.jackson.annotation.JsonInclude;\nimport com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;\n\npublic record Segment(@JacksonXmlProperty(isAttribute = true) String id,\n                      @JsonInclude(JsonInclude.Include.NON_NULL) String target,\n                      String source) {\n\n}\n"}, "----------\n1. ERROR in Segment.java (at line 3)\n\timport com.fasterxml.jackson.annotation.JsonInclude;\n\t       ^^^^^^^^^^^^^\nThe import com.fasterxml cannot be resolved\n----------\n2. ERROR in Segment.java (at line 4)\n\timport com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;\n\t       ^^^^^^^^^^^^^\nThe import com.fasterxml cannot be resolved\n----------\n3. ERROR in Segment.java (at line 6)\n\tpublic record Segment(@JacksonXmlProperty(isAttribute = true) String id,\n\t                       ^^^^^^^^^^^^^^^^^^\nJacksonXmlProperty cannot be resolved to a type\n----------\n4. ERROR in Segment.java (at line 7)\n\t@JsonInclude(JsonInclude.Include.NON_NULL) String target,\n\t ^^^^^^^^^^^\nJsonInclude cannot be resolved to a type\n----------\n5. ERROR in Segment.java (at line 7)\n\t@JsonInclude(JsonInclude.Include.NON_NULL) String target,\n\t             ^^^^^^^^^^^\nJsonInclude cannot be resolved to a variable\n----------\n");
    }

    public void testIssue4146_3() throws Exception {
        this.runConformTest(new String[]{"Segment.java", "import jackson.stuff.JacksonXmlProperty;\nimport jackson.stuff.JsonInclude;\n\npublic record Segment(@JacksonXmlProperty(isAttribute = true) String id,\n                      String source,\n                      @JsonInclude(JsonInclude.Include.NON_NULL) String target) {\n\n\tpublic static void main(String [] args) {\n\t\tSystem.out.println(\"OK!\");\n\t}\n}\n", "jackson/stuff/JacksonXmlProperty.java", "package jackson.stuff;\nimport java.lang.annotation.ElementType;\nimport java.lang.annotation.Retention;\nimport java.lang.annotation.RetentionPolicy;\nimport java.lang.annotation.Target;\n\n@Target({ElementType.ANNOTATION_TYPE, ElementType.FIELD, ElementType.METHOD, ElementType.PARAMETER})\n@Retention(RetentionPolicy.RUNTIME)\npublic @interface JacksonXmlProperty {\n    boolean isAttribute() default false;\n}\n", "jackson/stuff/JsonInclude.java", "package jackson.stuff;\n\nimport java.lang.annotation.ElementType;\nimport java.lang.annotation.Target;\n\n@Target({ElementType.METHOD, ElementType.FIELD, ElementType.TYPE, ElementType.PARAMETER})\n@JacksonAnnotation\npublic @interface JsonInclude {\n    public enum Include {\n    \tALWAYS,\n        NON_NULL;\n    }\n    public Include value() default Include.ALWAYS;\n}\n", "jackson/stuff/JacksonAnnotation.java", "package jackson.stuff;\n\nimport java.lang.annotation.ElementType;\nimport java.lang.annotation.Retention;\nimport java.lang.annotation.RetentionPolicy;\nimport java.lang.annotation.Target;\n\n@Target({ElementType.ANNOTATION_TYPE})\n@Retention(RetentionPolicy.RUNTIME)\npublic @interface JacksonAnnotation {\n\n}\n"}, "OK!");
        String expectedOutput = "  // Field descriptor #6 Ljava/lang/String;\n  private final java.lang.String id;\n    RuntimeVisibleAnnotations: \n      #8 @jackson.stuff.JacksonXmlProperty(\n        #9 isAttribute=true (constant type)\n      )\n  \n  // Field descriptor #6 Ljava/lang/String;\n  private final java.lang.String source;\n  \n  // Field descriptor #6 Ljava/lang/String;\n  private final java.lang.String target;\n    RuntimeInvisibleAnnotations: \n      #14 @jackson.stuff.JsonInclude(\n        #15 value=jackson.stuff.JsonInclude.Include.NON_NULL(enum type #16.#17)\n      )\n";
        this.verifyClassFile(expectedOutput, "Segment.class", 4);
        expectedOutput = "  // Method descriptor #39 ()Ljava/lang/String;\n  // Stack: 1, Locals: 1\n  public java.lang.String id();\n    0  aload_0 [this]\n    1  getfield Segment.id : java.lang.String [40]\n    4  areturn\n      Line numbers:\n        [pc: 0, line: 4]\n    RuntimeVisibleAnnotations: \n      #8 @jackson.stuff.JacksonXmlProperty(\n        #9 isAttribute=true (constant type)\n      )\n  \n  // Method descriptor #39 ()Ljava/lang/String;\n  // Stack: 1, Locals: 1\n  public java.lang.String source();\n    0  aload_0 [this]\n    1  getfield Segment.source : java.lang.String [42]\n    4  areturn\n      Line numbers:\n        [pc: 0, line: 5]\n  \n  // Method descriptor #39 ()Ljava/lang/String;\n  // Stack: 1, Locals: 1\n  public java.lang.String target();\n    0  aload_0 [this]\n    1  getfield Segment.target : java.lang.String [44]\n    4  areturn\n      Line numbers:\n        [pc: 0, line: 6]\n    RuntimeInvisibleAnnotations: \n      #14 @jackson.stuff.JsonInclude(\n        #15 value=jackson.stuff.JsonInclude.Include.NON_NULL(enum type #16.#17)\n      )\n  \n";
        this.verifyClassFile(expectedOutput, "Segment.class", 4);
        expectedOutput = "  // Method descriptor #61 (Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V\n  // Stack: 2, Locals: 4\n  public Segment(java.lang.String id, java.lang.String source, java.lang.String target);\n     0  aload_0 [this]\n     1  invokespecial java.lang.Record() [64]\n     4  aload_0 [this]\n     5  aload_1 [id]\n     6  putfield Segment.id : java.lang.String [40]\n     9  aload_0 [this]\n    10  aload_2 [source]\n    11  putfield Segment.source : java.lang.String [42]\n    14  aload_0 [this]\n    15  aload_3 [target]\n    16  putfield Segment.target : java.lang.String [44]\n    19  return\n      Line numbers:\n        [pc: 0, line: 1]\n      Method Parameters:\n        id\n        source\n        target\n    RuntimeVisibleParameterAnnotations: \n      Number of annotations for parameter 0: 1\n        #8 @jackson.stuff.JacksonXmlProperty(\n          #9 isAttribute=true (constant type)\n        )\n      Number of annotations for parameter 1: 0\n      Number of annotations for parameter 2: 0\n    RuntimeInvisibleParameterAnnotations: \n      Number of annotations for parameter 0: 0\n      Number of annotations for parameter 1: 0\n      Number of annotations for parameter 2: 1\n        #14 @jackson.stuff.JsonInclude(\n          #15 value=jackson.stuff.JsonInclude.Include.NON_NULL(enum type #16.#17)\n        )\n\n";
        this.verifyClassFile(expectedOutput, "Segment.class", 4);
    }

    public void testIssue4290() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public Object a() {\n        return new Object() {\n            static record A(Object  a, Object b) {}\n        };\n    }\n    public static void main(String[] args) {\n\t\tSystem.out.println(\"OK\");\n\t}\n}\n"}, "OK");
    }
}

