/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.util.Util;

public class Requestor
implements ICompilerRequestor {
    public boolean hasErrors = false;
    public String outputPath;
    private final boolean forceOutputGeneration;
    public Hashtable expectedProblems = new Hashtable();
    public String problemLog = "";
    public ICompilerRequestor clientRequestor;
    public boolean showCategory = false;
    public boolean showWarningToken = false;

    public Requestor(boolean forceOutputGeneration, ICompilerRequestor clientRequestor, boolean showCategory, boolean showWarningToken) {
        this.forceOutputGeneration = forceOutputGeneration;
        this.clientRequestor = clientRequestor;
        this.showCategory = showCategory;
        this.showWarningToken = showWarningToken;
    }

    public void acceptResult(CompilationResult compilationResult) {
        this.hasErrors |= compilationResult.hasErrors();
        this.problemLog = String.valueOf(this.problemLog) + org.eclipse.jdt.core.tests.util.Util.getProblemLog(compilationResult, this.showCategory, this.showWarningToken);
        this.outputClassFiles(compilationResult);
        if (this.clientRequestor != null) {
            this.clientRequestor.acceptResult(compilationResult);
        }
    }

    protected void outputClassFiles(CompilationResult unitResult) {
        if (unitResult != null && (!unitResult.hasErrors() || this.forceOutputGeneration)) {
            ClassFile[] classFiles = unitResult.getClassFiles();
            if (this.outputPath != null) {
                int i = 0;
                int fileCount = classFiles.length;
                while (i < fileCount) {
                    ClassFile classFile = classFiles[i];
                    String relativeName = new String(classFile.fileName()).replace('/', File.separatorChar) + ".class";
                    try {
                        Util.writeToDisk((boolean)true, (String)this.outputPath, (String)relativeName, (ClassFile)classFile);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    ++i;
                }
            }
        }
    }
}

