/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.io.File;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.jdt.core.tests.compiler.regression.ResourceLeakTests;
import org.eclipse.jdt.core.tests.util.Util;

public class ResourceLeakAnnotatedTests
extends ResourceLeakTests {
    public static final int INHERITED_DEPTH = 1;
    protected static final String OWNING_JAVA = "org/eclipse/jdt/annotation/Owning.java";
    protected static final String OWNING_CONTENT = "package org.eclipse.jdt.annotation;\nimport java.lang.annotation.*;\n@Target({ElementType.TYPE, ElementType.PARAMETER, ElementType.METHOD, ElementType.FIELD, ElementType.TYPE_USE})\npublic @interface Owning {}\n";
    protected static final String NOTOWNING_JAVA = "org/eclipse/jdt/annotation/NotOwning.java";
    protected static final String NOTOWNING_CONTENT = "package org.eclipse.jdt.annotation;\nimport java.lang.annotation.*;\n@Target({ElementType.TYPE, ElementType.PARAMETER, ElementType.METHOD, ElementType.FIELD})\npublic @interface NotOwning {}\n";

    static {
        TESTS_NAMES = null;
    }

    public ResourceLeakAnnotatedTests(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(ResourceLeakAnnotatedTests.class.getName());
        ResourceLeakAnnotatedTests.buildMinimalComplianceTestSuite(32, 1, suite, ResourceLeakAnnotatedTests.class);
        return suite;
    }

    @Override
    protected Map<String, String> getCompilerOptions() {
        Map<String, String> options = super.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.annotation.resourceanalysis", "enabled");
        options.put("org.eclipse.jdt.core.compiler.problem.insufficientResourceAnalysis", "ignore");
        options.put("org.eclipse.jdt.core.compiler.problem.incompatibleOwningContract", "error");
        return options;
    }

    @Override
    protected String potentialLeakOrCloseNotShown(String resourceName) {
        return "Mandatory close of resource '" + resourceName + "' has not been shown\n";
    }

    @Override
    protected String potentialLeakOrCloseNotShownAtExit(String resourceName) {
        String suffix = resourceName.startsWith("<unassigned Closeable") ? "\n" : " at this location\n";
        return "Mandatory close of resource '" + resourceName + "' has not been shown" + suffix;
    }

    @Override
    protected String potentialOrDefiniteLeak(String string) {
        return "Resource leak: '" + string + "' is never closed\n";
    }

    @Override
    protected String fieldDeclPrefix() {
        return "@org.eclipse.jdt.annotation.Owning ";
    }

    @Override
    protected void runConformTest(String[] testFiles, String expectedOutput, Map<String, String> customOptions) {
        testFiles = this.addAnnotationSources(testFiles);
        super.runConformTest(testFiles, expectedOutput, customOptions);
    }

    @Override
    protected void runLeakTest(String[] testFiles, String expectedCompileError, Map options) {
        testFiles = this.addAnnotationSources(testFiles);
        super.runLeakTest(testFiles, expectedCompileError, options);
    }

    private void runLeakTestWithAnnotations(String[] testFiles, String expectedProblems, Map<String, String> options) {
        this.runLeakTestWithAnnotations(testFiles, expectedProblems, options, true);
    }

    private void runLeakTestWithAnnotations(String[] testFiles, String expectedProblems, Map<String, String> options, boolean shouldFlushOutputDirectory) {
        if (options == null) {
            options = this.getCompilerOptions();
        }
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.explicitlyClosedAutoCloseable", "info");
        if (options.get("org.eclipse.jdt.core.compiler.problem.insufficientResourceAnalysis").equals("ignore")) {
            options.put("org.eclipse.jdt.core.compiler.problem.insufficientResourceAnalysis", "info");
        }
        testFiles = this.addAnnotationSources(testFiles);
        this.runLeakTest(testFiles, expectedProblems, options, shouldFlushOutputDirectory);
    }

    private String[] addAnnotationSources(String[] testFiles) {
        int length = testFiles.length;
        String[] stringArray = testFiles;
        testFiles = new String[length + 4];
        System.arraycopy(stringArray, 0, testFiles, 0, length);
        testFiles[length + 0] = OWNING_JAVA;
        testFiles[length + 1] = OWNING_CONTENT;
        testFiles[length + 2] = NOTOWNING_JAVA;
        testFiles[length + 3] = NOTOWNING_CONTENT;
        return testFiles;
    }

    @Override
    protected String getTest056e_log() {
        return "----------\n2. ERROR in X.java (at line 11)\n\tFileReader reader = getReader(\"somefile\");\n\t           ^^^^^^\nResource leak: 'reader' is never closed\n----------\n";
    }

    @Override
    protected String getTest056y_log() {
        return "----------\n1. WARNING in X.java (at line 4)\n\tfinal FileReader reader31 = new FileReader(\"file\");\n\t                 ^^^^^^^^\nMandatory close of resource 'reader31' has not been shown\n----------\n2. WARNING in X.java (at line 17)\n\tfinal FileReader reader23 = new FileReader(\"file\");\n\t                 ^^^^^^^^\nPotential resource leak: 'reader23' may not be closed\n----------\n";
    }

    @Override
    protected String getTest061l2_log() {
        return "----------\n1. ERROR in xy\\Leaks.java (at line 10)\n\tFileInputStream fileInputStream= new FileInputStream(name);\n\t                ^^^^^^^^^^^^^^^\nMandatory close of resource 'fileInputStream' has not been shown\n----------\n2. ERROR in xy\\Leaks.java (at line 18)\n\tthis(new FileInputStream(\"default\")); // potential problem\n\t     ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nMandatory close of resource '<unassigned Closeable value>' has not been shown\n----------\n3. ERROR in xy\\Leaks.java (at line 25)\n\tFileInputStream fileInputStream= new FileInputStream(name);\n\t                ^^^^^^^^^^^^^^^\nMandatory close of resource 'fileInputStream' has not been shown\n----------\n";
    }

    @Override
    protected String getTest063c_log() {
        return "----------\n1. ERROR in X.java (at line 8)\n\tBufferedInputStream bis = new BufferedInputStream(s);\n\t                    ^^^\nMandatory close of resource 'bis' has not been shown\n----------\n";
    }

    @Override
    protected String getTestBug440282_log() {
        return "----------\n1. ERROR in ResourceLeakFalseNegative.java (at line 36)\n\tfinal FileInputStream in = new FileInputStream(\"/dev/null\");\n\t                      ^^\nResource leak: 'in' is never closed\n----------\n2. ERROR in ResourceLeakFalseNegative.java (at line 39)\n\treturn new Foo(reader).read();\n\t       ^^^^^^^^^^^^^^^\nResource leak: '<unassigned Closeable value>' is never closed\n----------\n";
    }

    @Override
    String getBug561334_log() {
        return "----------\n1. INFO in Foo.java (at line 18)\n\tfoo = new Foo(\"Hello, world!\");\n\t      ^^^^^^^^^^^^^^^^^^^^^^^^\nMandatory close of resource '<unassigned Closeable value>' has not been shown\n----------\n2. WARNING in Foo.java (at line 21)\n\tSystem.out.println(getFoo().thing);\n\t                   ^^^^^^^^\nResource leak: '<unassigned Closeable value>' is never closed\n----------\n";
    }

    public void testBug411098_comment19_annotated() {
        this.runLeakTestWithAnnotations(new String[]{"A.java", "import java.io.PrintWriter;\nimport org.eclipse.jdt.annotation.Owning;\npublic class A implements AutoCloseable {\n\t@Owning PrintWriter fWriter;\n\tboolean useField = false;\n\tpublic void close() {\n\t\tPrintWriter bug= useField ? fWriter : null;\n\t\tSystem.out.println(bug);\n\t}\n}"}, "----------\n1. ERROR in A.java (at line 6)\n\tpublic void close() {\n\t            ^^^^^^^\nMandatory close of resource 'this.fWriter' has not been shown\n----------\n", null);
    }

    public void testBug440282_annotated() {
        this.runLeakTestWithAnnotations(new String[]{"ResourceLeakFalseNegative.java", "import java.io.*;\n\nimport org.eclipse.jdt.annotation.*;\n\npublic final class ResourceLeakFalseNegative {\n\n  private static final class Foo implements AutoCloseable {\n    @Owning final InputStreamReader reader;\n\n    Foo(@Owning final InputStreamReader reader) {\n      this.reader = reader;\n    }\n    \n    public int read() throws IOException {\n      return reader.read();\n    }\n\n    public void close() throws IOException {\n      reader.close();\n    }\n  }\n\n  private static final class Bar {\n    final int read;\n\n    Bar(final InputStreamReader reader) throws IOException {\n      read = reader.read();\n    }\n    \n    public int read() {\n      return read;\n    }\n  }\n\n  public final static int foo() throws IOException {\n    final FileInputStream in = new FileInputStream(\"/dev/null\");\n    final InputStreamReader reader = new InputStreamReader(in);\n    try {\n      return new Foo(reader).read();\n    } finally {\n      // even though Foo is not closed, no potential resource leak is reported.\n    }\n  }\n\n  public final static int bar() throws IOException {\n    final FileInputStream in = new FileInputStream(\"/dev/null\");\n    final InputStreamReader reader = new InputStreamReader(in);\n    try {\n      final Bar bar = new Bar(reader);\n      return bar.read();\n    } finally {\n      // Removing the close correctly reports potential resource leak as a warning,\n      // because Bar does not implement AutoCloseable.\n      reader.close();\n    }\n  }\n\n  public static void main(String[] args) throws IOException {\n    for (;;) {\n      foo();\n      bar();\n    }\n  }\n}\n"}, "----------\n1. ERROR in ResourceLeakFalseNegative.java (at line 39)\n\treturn new Foo(reader).read();\n\t       ^^^^^^^^^^^^^^^\nResource leak: '<unassigned Closeable value>' is never closed\n----------\n2. INFO in ResourceLeakFalseNegative.java (at line 46)\n\tfinal FileInputStream in = new FileInputStream(\"/dev/null\");\n\t                      ^^\nResource 'in' should be managed by try-with-resource\n----------\n3. INFO in ResourceLeakFalseNegative.java (at line 47)\n\tfinal InputStreamReader reader = new InputStreamReader(in);\n\t                        ^^^^^^\nResource 'reader' should be managed by try-with-resource\n----------\n", null);
    }

    public void testOwningField_NOK1() {
        this.runLeakTestWithAnnotations(new String[]{"A.java", "import java.io.PrintWriter;\nimport org.eclipse.jdt.annotation.Owning;\nimport org.eclipse.jdt.annotation.NotOwning;\npublic class A implements AutoCloseable {\n\t@Owning PrintWriter fWriter;\n\tPrintWriter fOther;\n\tboolean useField = false;\n\tA(@Owning PrintWriter writer1, @Owning PrintWriter writer2) {\n\t\tfWriter = writer1; // OK\n\t\tfOther = writer2; // not sufficient\n\t}\n\tpublic void close() {\n\t\tPrintWriter bug= useField ? fWriter : null;\n\t\tprintln(bug);\n\t\tnew A(null, null).fWriter.close(); // closing fWriter of other instance is no good!\n\t}\n\tvoid println(@NotOwning AutoCloseable rc) { System.out.println(rc); }\n}\n"}, "----------\n1. INFO in A.java (at line 6)\n\tPrintWriter fOther;\n\t            ^^^^^^\nIt is recommended to mark resource fields as '@Owning' to ensure proper closing\n----------\n2. ERROR in A.java (at line 8)\n\tA(@Owning PrintWriter writer1, @Owning PrintWriter writer2) {\n\t                                                   ^^^^^^^\nMandatory close of resource 'writer2' has not been shown\n----------\n3. ERROR in A.java (at line 12)\n\tpublic void close() {\n\t            ^^^^^^^\nResource leak: 'this.fWriter' is never closed\n----------\n4. ERROR in A.java (at line 15)\n\tnew A(null, null).fWriter.close(); // closing fWriter of other instance is no good!\n\t^^^^^^^^^^^^^^^^^\nResource leak: '<unassigned Closeable value>' is never closed\n----------\n", null);
    }

    public void testOwningField_NOK2() {
        this.runLeakTestWithAnnotations(new String[]{"A.java", "import java.io.PrintWriter;\nimport org.eclipse.jdt.annotation.Owning;\nclass ASuper implements AutoCloseable {\n\tpublic void close() { /* nothing */ }\n}\npublic class A extends ASuper {\n\t@Owning PrintWriter fWriter;\n\tPrintWriter fOther;\n\tboolean useField = false;\n\tA(@Owning PrintWriter writer1, @Owning PrintWriter writer2) {\n\t\tfWriter = writer1; // OK\n\t\tfOther = writer2; // not sufficient\n\t}\n}\n"}, "----------\n1. INFO in A.java (at line 7)\n\t@Owning PrintWriter fWriter;\n\t                    ^^^^^^^\nClass with resource fields tagged as '@Owning' should implement 'close()'\n----------\n2. INFO in A.java (at line 8)\n\tPrintWriter fOther;\n\t            ^^^^^^\nIt is recommended to mark resource fields as '@Owning' to ensure proper closing\n----------\n3. ERROR in A.java (at line 10)\n\tA(@Owning PrintWriter writer1, @Owning PrintWriter writer2) {\n\t                                                   ^^^^^^^\nMandatory close of resource 'writer2' has not been shown\n----------\n", null);
    }

    public void testOwningField_binaryField_lazyInit() {
        this.runLeakTestWithAnnotations(new String[]{"A.java", "import java.io.PrintWriter;\nimport org.eclipse.jdt.annotation.Owning;\npublic abstract class A implements AutoCloseable {\n\t@Owning PrintWriter fWriter;\n\tPrintWriter fOther;\n\tboolean useField = false;\n}\n"}, "----------\n1. INFO in A.java (at line 4)\n\t@Owning PrintWriter fWriter;\n\t                    ^^^^^^^\nClass with resource fields tagged as '@Owning' should implement 'close()'\n----------\n2. INFO in A.java (at line 5)\n\tPrintWriter fOther;\n\t            ^^^^^^\nIt is recommended to mark resource fields as '@Owning' to ensure proper closing\n----------\n", null);
        this.runLeakTestWithAnnotations(new String[]{"AImpl.java", "import java.io.PrintWriter;\nimport org.eclipse.jdt.annotation.Owning;\npublic class AImpl extends A {\n\tvoid init(@Owning PrintWriter writer1, @Owning PrintWriter writer2) {\n\t\tfWriter = writer1; // OK\n\t\tfOther = writer2; // not sufficient\n\t}\n\tpublic void close() {\n\t\t// not closing any fields\n\t}\n}\n"}, "----------\n1. ERROR in AImpl.java (at line 4)\n\tvoid init(@Owning PrintWriter writer1, @Owning PrintWriter writer2) {\n\t                                                           ^^^^^^^\nMandatory close of resource 'writer2' has not been shown\n----------\n2. ERROR in AImpl.java (at line 8)\n\tpublic void close() {\n\t            ^^^^^^^\nResource leak: 'this.fWriter' is never closed\n----------\n", null, false);
    }

    public void testOwningField_binaryField_lazyInit2() {
        this.runLeakTestWithAnnotations(new String[]{"A.java", "import java.io.PrintWriter;\nimport org.eclipse.jdt.annotation.Owning;\npublic class A implements AutoCloseable {\n\t@Owning PrintWriter fWriter;\n\tPrintWriter fOther;\n\tboolean useField = false;\n\tpublic void close() {\n\t\tif (fWriter != null)\n\t\t\tfWriter.close();\n\t}\n}\n"}, "----------\n1. INFO in A.java (at line 5)\n\tPrintWriter fOther;\n\t            ^^^^^^\nIt is recommended to mark resource fields as '@Owning' to ensure proper closing\n----------\n", null);
        this.runLeakTestWithAnnotations(new String[]{"AImpl.java", "import java.io.PrintWriter;\nimport org.eclipse.jdt.annotation.Owning;\npublic class AImpl extends A {\n\tboolean should = false;\n\tvoid init(@Owning PrintWriter writer1, @Owning PrintWriter writer2) {\n\t\tfWriter = writer1; // OK\n\t\tfOther = writer2; // not sufficient\n\t}\n\tpublic void close() {\n\t\tif (should)\n\t\t\tsuper.close();\n\t}\n}\n"}, "----------\n1. ERROR in AImpl.java (at line 5)\n\tvoid init(@Owning PrintWriter writer1, @Owning PrintWriter writer2) {\n\t                                                           ^^^^^^^\nMandatory close of resource 'writer2' has not been shown\n----------\n2. ERROR in AImpl.java (at line 9)\n\tpublic void close() {\n\t            ^^^^^^^\nPotential resource leak: 'this.fWriter' may not be closed\n----------\n", null, false);
    }

    public void testOwningField_OK() {
        this.runLeakTestWithAnnotations(new String[]{"A.java", "import java.io.PrintWriter;\nimport org.eclipse.jdt.annotation.Owning;\nimport org.eclipse.jdt.annotation.NotOwning;\npublic class A implements AutoCloseable {\n\t@Owning PrintWriter fWriter;\n\t@Owning PrintWriter fOther;\n\tboolean useField = false;\n\tA(@Owning PrintWriter writer1, @Owning PrintWriter writer2) {\n\t\tfWriter = writer1;\n\t\tthis.fOther = writer2;\n\t}\n\tpublic void close() {\n\t\tfWriter.close();\n\t\tthis.fOther.close();\n\t}\n\tvoid println(@NotOwning AutoCloseable rc) { System.out.println(rc); }\n}\n"}, "", null);
    }

    public void testSharedField() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.insufficientResourceAnalysis", "warning");
        this.runLeakTestWithAnnotations(new String[]{"A.java", "import java.io.PrintWriter;\nimport org.eclipse.jdt.annotation.Owning;\nimport org.eclipse.jdt.annotation.NotOwning;\npublic class A {\n\t@NotOwning PrintWriter fWriter;\n\tPrintWriter fOther;\n\t@Owning PrintWriter fProper;\n\tboolean useField = false;\n\tA(@Owning PrintWriter writer1, PrintWriter writer2, @Owning PrintWriter writer3) {\n\t\tfWriter = writer1;\n\t\tfOther = writer2;\n\t\tfProper = writer3;\n\t}\n}\n"}, "----------\n1. WARNING in A.java (at line 6)\n\tPrintWriter fOther;\n\t            ^^^^^^\nIt is recommended to mark resource fields as '@Owning' to ensure proper closing\n----------\n2. WARNING in A.java (at line 7)\n\t@Owning PrintWriter fProper;\n\t                    ^^^^^^^\nClass with resource fields tagged as '@Owning' should implement AutoCloseable\n----------\n3. ERROR in A.java (at line 9)\n\tA(@Owning PrintWriter writer1, PrintWriter writer2, @Owning PrintWriter writer3) {\n\t                      ^^^^^^^\nResource leak: 'writer1' is never closed\n----------\n", options);
    }

    public void testOwning_receiving_parameter() {
        if (this.complianceLevel < 0x350000L) {
            return;
        }
        this.runLeakTestWithAnnotations(new String[]{"X.java", "import org.eclipse.jdt.annotation.Owning;\npublic class X {\n\tvoid nok(@Owning AutoCloseable c) {\n\t\tSystem.out.print(1);\n\t}\n\tvoid ok(@Owning AutoCloseable c) throws Exception {\n\t\ttry (c) {\n\t\t\tSystem.out.print(2);\n\t\t};\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tvoid nok(@Owning AutoCloseable c) {\n\t                               ^\nResource leak: 'c' is never closed\n----------\n", null);
    }

    public void testOwning_sending() {
        if (this.complianceLevel < 0x350000L) {
            return;
        }
        this.runLeakTestWithAnnotations(new String[]{"X.java", "import org.eclipse.jdt.annotation.Owning;\nclass Rc implements AutoCloseable {\n\t@Override public void close() {}\n}\npublic class X {\n\tvoid consume(@Owning Rc rc1) {\n\t\ttry (rc1) {\n\t\t\tSystem.out.print(2);\n\t\t};\n\t}\n\tvoid nok() {\n\t\tRc rc2 = new Rc();\n\t\tSystem.out.print(rc2);\n\t}\n\tvoid unsafe(boolean f) {\n\t\tRc rc3 = new Rc();\n\t\tif (f)\n\t\t\tconsume(rc3);\n\t}\n\tvoid leakAtReturn(boolean f) {\n\t\tRc rc4 = new Rc();\n\t\tif (f)\n\t\t\treturn;\n\t\tconsume(rc4);\n\t}\n\tvoid ok(boolean f) {\n\t\tRc rc5 = new Rc();\n\t\tif (f)\n\t\t\tconsume(rc5);\n\t\telse\n\t\t\trc5.close();\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 12)\n\tRc rc2 = new Rc();\n\t   ^^^\nMandatory close of resource 'rc2' has not been shown\n----------\n2. ERROR in X.java (at line 16)\n\tRc rc3 = new Rc();\n\t   ^^^\nPotential resource leak: 'rc3' may not be closed\n----------\n3. ERROR in X.java (at line 23)\n\treturn;\n\t^^^^^^^\nResource leak: 'rc4' is not closed at this location\n----------\n", null);
    }

    public void testOwning_sending_toBinary() {
        if (this.complianceLevel < 0x350000L) {
            return;
        }
        this.runLeakTestWithAnnotations(new String[]{"p/Consume.java", "package p;\nimport org.eclipse.jdt.annotation.Owning;\npublic class Consume {\n\tpublic void consume(@Owning AutoCloseable rc1) {\n\t\ttry (rc1) {\n\t\t\tSystem.out.print(2);\n\t\t} catch (Exception e) {\n\t\t\t// nothing\n\t\t}\n\t}\n}\n"}, "", null);
        this.runLeakTestWithAnnotations(new String[]{"X.java", "class Rc implements AutoCloseable {\n\t@Override public void close() {}\n}\npublic class X {\n\tp.Consume consumer;\n\n\tvoid unsafe(boolean f) {\n\t\tRc rc3 = new Rc();\n\t\tif (f)\n\t\t\tconsumer.consume(rc3);\n\t}\n\tvoid leakAtReturn(boolean f) {\n\t\tRc rc4 = new Rc();\n\t\tif (f)\n\t\t\treturn;\n\t\tconsumer.consume(rc4);\n\t}\n\tvoid ok(boolean f) {\n\t\tRc rc5 = new Rc();\n\t\tif (f)\n\t\t\tconsumer.consume(rc5);\n\t\telse\n\t\t\trc5.close();\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\tRc rc3 = new Rc();\n\t   ^^^\nPotential resource leak: 'rc3' may not be closed\n----------\n2. ERROR in X.java (at line 15)\n\treturn;\n\t^^^^^^^\nResource leak: 'rc4' is not closed at this location\n----------\n", null, false);
    }

    public void testOwning_receiving_from_call() {
        this.runLeakTestWithAnnotations(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\nimport java.io.*;\npublic class X {\n\tvoid err() {\n\t\tAutoCloseable rc1 = provideOwned();\n\t\tif (rc1 == null) System.out.print(\"null\");\n\t}\n\tvoid warn() {\n\t\tAutoCloseable rc2 = provideShared(); // not responsible\n\t\tif (rc2 == null) System.out.print(\"null\");\n\t}\n\tvoid err_without_local() {\n\t\tif (provideOwned() == null) System.out.print(\"null\");\n\t}\n\tString err_wrapped() {\n\t\tBufferedInputStream bis = new BufferedInputStream(provideOwned());\n\t\treturn bis.toString();\n\t}\n\tvoid ok() throws Exception {\n\t\ttry (AutoCloseable c = provideOwned()) {\n\t\t\tSystem.out.print(2);\n\t\t};\n\t}\n\t@NotOwning AutoCloseable provideShared() {\n\t\treturn null;\n\t}\n\t@Owning InputStream provideOwned() {\n\t\treturn null;\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tAutoCloseable rc1 = provideOwned();\n\t              ^^^\nResource leak: 'rc1' is never closed\n----------\n2. ERROR in X.java (at line 13)\n\tif (provideOwned() == null) System.out.print(\"null\");\n\t    ^^^^^^^^^^^^^^\nResource leak: '<unassigned Closeable value>' is never closed\n----------\n3. ERROR in X.java (at line 16)\n\tBufferedInputStream bis = new BufferedInputStream(provideOwned());\n\t                    ^^^\nResource leak: 'bis' is never closed\n----------\n", null);
    }

    public void testOwning_receiving_from_binaryCall() {
        this.runLeakTestWithAnnotations(new String[]{"p/Produce.java", "package p;\nimport org.eclipse.jdt.annotation.*;\nimport java.io.*;\npublic class Produce {\n\tpublic @NotOwning AutoCloseable provideShared() {\n\t\treturn null;\n\t}\n\tpublic @Owning InputStream provideOwned() {\n\t\treturn null;\n\t}\n}\n"}, "", null);
        this.runLeakTestWithAnnotations(new String[]{"X.java", "import java.io.*;\npublic class X {\n\tp.Produce producer;\n\tvoid err() {\n\t\tAutoCloseable rc1 = producer.provideOwned();\n\t\tif (rc1 == null) System.out.print(\"null\");\n\t}\n\tvoid warn() {\n\t\tAutoCloseable rc2 = producer.provideShared();\n\t\tif (rc2 == null) System.out.print(\"null\");\n\t}\n\tvoid err_without_local() {\n\t\tif (producer.provideOwned() == null) System.out.print(\"null\");\n\t}\n\tString err_wrapped() {\n\t\tBufferedInputStream bis = new BufferedInputStream(producer.provideOwned());\n\t\treturn bis.toString();\n\t}\n\tvoid ok() throws Exception {\n\t\ttry (AutoCloseable c = producer.provideOwned()) {\n\t\t\tSystem.out.print(2);\n\t\t};\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tAutoCloseable rc1 = producer.provideOwned();\n\t              ^^^\nResource leak: 'rc1' is never closed\n----------\n2. ERROR in X.java (at line 13)\n\tif (producer.provideOwned() == null) System.out.print(\"null\");\n\t    ^^^^^^^^^^^^^^^^^^^^^^^\nResource leak: '<unassigned Closeable value>' is never closed\n----------\n3. ERROR in X.java (at line 16)\n\tBufferedInputStream bis = new BufferedInputStream(producer.provideOwned());\n\t                    ^^^\nResource leak: 'bis' is never closed\n----------\n", null, false);
    }

    public void testOwning_return() {
        this.runLeakTestWithAnnotations(new String[]{"X.java", "import java.io.*;\nimport org.eclipse.jdt.annotation.Owning;\npublic class X {\n\t@Owning AutoCloseable ok(String fn) throws IOException {\n\t\treturn new FileInputStream(fn);\n\t}\n\t@Owning AutoCloseable somePath(String fn) throws IOException {\n\t\tFileInputStream fis = new FileInputStream(fn);\n\t\tif (fn.length() > 1)\n\t\t\treturn fis;\n\t\treturn null;\n\t}\n\t@Owning AutoCloseable mixed(String fn) throws IOException {\n\t\tFileInputStream fis = new FileInputStream(fn);\n\t\tif (fn.length() > 1)\n\t\t\treturn new FileInputStream(fn);\n\t\treturn fis;\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 11)\n\treturn null;\n\t^^^^^^^^^^^^\nMandatory close of resource 'fis' has not been shown at this location\n----------\n2. ERROR in X.java (at line 16)\n\treturn new FileInputStream(fn);\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nMandatory close of resource 'fis' has not been shown at this location\n----------\n", null);
    }

    public void testUnannotated_return() {
        this.runLeakTestWithAnnotations(new String[]{"X.java", "import java.io.*;\npublic class X {\n\tAutoCloseable varReturn(String fn) throws IOException {\n\t\tFileInputStream fis = new FileInputStream(fn);\n\t\treturn fis;\n\t}\n\tAutoCloseable unassignedReturn(String fn) throws IOException {\n\t\treturn new FileInputStream(fn);\n\t}\n\tAutoCloseable passThrough(AutoCloseable rc) {\n\t\treturn rc; // silent, since caller did not delegate responsibility to us\n\t}\n}\n"}, "----------\n1. INFO in X.java (at line 5)\n\treturn fis;\n\t^^^^^^^^^^^\nEnclosing method should be tagged as '@Owning' to pass the responsibility for the returned resource to the caller\n----------\n2. INFO in X.java (at line 8)\n\treturn new FileInputStream(fn);\n\t       ^^^^^^^^^^^^^^^^^^^^^^^\nEnclosing method should be tagged as '@Owning' to pass the responsibility for the returned resource to the caller\n----------\n", null);
    }

    public void testNotOwning_return() {
        this.runLeakTestWithAnnotations(new String[]{"X.java", "import java.io.*;\nimport org.eclipse.jdt.annotation.*;\npublic class X {\n\t@NotOwning AutoCloseable nok(String fn) throws IOException {\n\t\treturn new FileInputStream(fn);\n\t}\n\t@NotOwning AutoCloseable somePath(String fn) throws IOException {\n\t\tFileInputStream fis = new FileInputStream(fn);\n\t\tif (fn.length() > 1)\n\t\t\treturn fis;\n\t\treturn null;\n\t}\n\t@NotOwning AutoCloseable mixed(String fn) throws IOException {\n\t\tFileInputStream fis = new FileInputStream(fn);\n\t\tif (fn.length() > 1)\n\t\t\treturn new FileInputStream(fn);\n\t\treturn fis;\n\t}\n\t@NotOwning AutoCloseable passThrough(@NotOwning AutoCloseable resource, boolean flag) {\n\t\tif (flag)\n\t\t\treturn resource;\n\t\treturn null;\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\treturn new FileInputStream(fn);\n\t       ^^^^^^^^^^^^^^^^^^^^^^^\nResource leak: '<unassigned Closeable value>' is never closed\n----------\n2. ERROR in X.java (at line 8)\n\tFileInputStream fis = new FileInputStream(fn);\n\t                ^^^\nResource leak: 'fis' is never closed\n----------\n3. ERROR in X.java (at line 14)\n\tFileInputStream fis = new FileInputStream(fn);\n\t                ^^^\nResource leak: 'fis' is never closed\n----------\n4. ERROR in X.java (at line 16)\n\treturn new FileInputStream(fn);\n\t       ^^^^^^^^^^^^^^^^^^^^^^^\nResource leak: '<unassigned Closeable value>' is never closed\n----------\n", null);
    }

    public void testNotOwningCloseableClass() {
        this.runLeakTestWithAnnotations(new String[]{"p/A.java", "package p;\nimport org.eclipse.jdt.annotation.NotOwning;\npublic @NotOwning class A implements AutoCloseable {\n\tpublic void close() { /* nothing */ }\n}\n", "X.java", "import p.A;\npublic class X {\n\tvoid test() {\n\t\tnew A();\n\t}\n}\n"}, "", null);
    }

    public void testNotOwningCloseableClass_binary() {
        this.runLeakTestWithAnnotations(new String[]{"p/A.java", "package p;\nimport org.eclipse.jdt.annotation.NotOwning;\npublic @NotOwning class A implements AutoCloseable {\n\tpublic void close() { /* nothing */ }\n}\n"}, "", null);
        this.runLeakTestWithAnnotations(new String[]{"X.java", "import p.A;\npublic class X {\n\tvoid test() {\n\t\tnew A();\n\t}\n}\n"}, "", null, false);
    }

    public void testInheritance() {
        this.runLeakTestWithAnnotations(new String[]{"Super.java", "import org.eclipse.jdt.annotation.*;\npublic class Super implements AutoCloseable {\n\t@Owning AutoCloseable f1;\n\t@Owning AutoCloseable f3;\n\t@Owning AutoCloseable ok1(@Owning AutoCloseable rc1, @NotOwning AutoCloseable rc2) {\n\t\treturn rc1;\n\t}\n\tAutoCloseable nok1(@Owning AutoCloseable rc1, AutoCloseable rc2, @Owning AutoCloseable rc3) {\n\t\tthis.f1 = rc1;\n\t\tthis.f3 = rc3;\n\t\treturn rc2;\n\t}\n\tpublic void close() throws Exception {\n\t\tthis.f1.close();\n\t\tif (this.f3 != null)\n\t\t\tthis.f3.close();\n\t}\n}\n", "Sub.java", "import org.eclipse.jdt.annotation.*;\npublic class Sub extends Super {\n\t@Override @Owning AutoCloseable ok1(@Owning AutoCloseable rc1, @NotOwning AutoCloseable rc2) {\n\t\treturn rc1;\n\t}\n\t@Override @Owning AutoCloseable nok1(AutoCloseable rc1, @NotOwning AutoCloseable rc2, @NotOwning AutoCloseable rc3) {\n\t\treturn rc1;\n\t}\n}\n"}, "----------\n1. ERROR in Sub.java (at line 6)\n\t@Override @Owning AutoCloseable nok1(AutoCloseable rc1, @NotOwning AutoCloseable rc2, @NotOwning AutoCloseable rc3) {\n\t          ^^^^^^^\nUnsafe redefinition, super method is not tagged as '@Owning'\n----------\n2. ERROR in Sub.java (at line 6)\n\t@Override @Owning AutoCloseable nok1(AutoCloseable rc1, @NotOwning AutoCloseable rc2, @NotOwning AutoCloseable rc3) {\n\t                                                   ^^^\nUnsafe redefinition, super method tagged this parameter as '@Owning'\n----------\n3. ERROR in Sub.java (at line 6)\n\t@Override @Owning AutoCloseable nok1(AutoCloseable rc1, @NotOwning AutoCloseable rc2, @NotOwning AutoCloseable rc3) {\n\t                                                                                                               ^^^\nUnsafe redefinition, super method tagged this parameter as '@Owning'\n----------\n", null);
    }

    public void testCustomWrapperResource() {
        this.runLeakTestWithAnnotations(new String[]{"p1/C.java", "package p1;\nimport org.eclipse.jdt.annotation.*;\nimport java.io.*;\npublic class C implements AutoCloseable {\n\t@Owning InputStream fInput;\n\tpublic C(@Owning InputStream input) {\n\t\tthis.fInput = input;\n\t}\n\tpublic void close() throws Exception {\n\t\tthis.fInput.close();\n\t}\n\tstatic void test1(@Owning InputStream input) {\n\t\tC c = new C(input);\n\t}\n\tstatic void test2(@Owning InputStream input) throws Exception {\n\t\tC c = new C(input);\n\t\tinput.close(); // now C is resource-less\n\t}\n\tstatic void test3(String name) throws Exception {\n\t\tFileInputStream fis = new FileInputStream(name);\n\t\tC c = new C(fis);\n\t\tif (name == null)\n\t\t\tfis.close();\n\t}\n}\n"}, "----------\n1. ERROR in p1\\C.java (at line 13)\n\tC c = new C(input);\n\t  ^\nResource leak: 'c' is never closed\n----------\n2. INFO in p1\\C.java (at line 16)\n\tC c = new C(input);\n\t  ^\nResource 'c' should be managed by try-with-resource\n----------\n3. ERROR in p1\\C.java (at line 21)\n\tC c = new C(fis);\n\t  ^\nPotential resource leak: 'c' may not be closed\n----------\n", null);
    }

    public void testCustomWrapperResource_binary() {
        this.runLeakTestWithAnnotations(new String[]{"p1/C.java", "package p1;\nimport org.eclipse.jdt.annotation.*;\nimport java.io.*;\npublic class C implements AutoCloseable {\n\t@Owning InputStream fInput;\n\tpublic C(@Owning InputStream input) {\n\t\tthis.fInput = input;\n\t}\n\tpublic void close() throws Exception {\n\t\tthis.fInput.close();\n\t}\n}\n"}, "", null);
        this.runLeakTestWithAnnotations(new String[]{"D.java", "import java.io.*;\nimport p1.C;\nclass D {\n\tvoid test3(String name) throws Exception {\n\t\tFileInputStream fis = new FileInputStream(name);\n\t\tC c = new C(fis);\n\t\tif (name == null)\n\t\t\tfis.close();\n\t}\n}\n"}, "----------\n1. ERROR in D.java (at line 6)\n\tC c = new C(fis);\n\t  ^\nPotential resource leak: 'c' may not be closed\n----------\n", null, false);
    }

    public void testSubclassingWrapperResource() {
        this.runLeakTestWithAnnotations(new String[]{"p1/C.java", "package p1;\nimport org.eclipse.jdt.annotation.*;\nimport java.io.*;\npublic class C extends BufferedInputStream {\n\tpublic C(@Owning InputStream input) {\n\t\tsuper(input); // should not complain, super param is implicilty @Owning\n\t}\n\tstatic void test1(@Owning InputStream input) {\n\t\tC c = new C(input);\n\t}\n\tstatic void test2(@Owning InputStream input) throws Exception {\n\t\tC c = new C(input);\n\t\tinput.close(); // now C is resource-less\n\t}\n\tstatic void test3(String name) throws Exception {\n\t\tFileInputStream fis = new FileInputStream(name);\n\t\tC c = new C(fis);\n\t\tif (name == null)\n\t\t\tfis.close();\n\t}\n}\n"}, "----------\n1. ERROR in p1\\C.java (at line 9)\n\tC c = new C(input);\n\t  ^\nResource leak: 'c' is never closed\n----------\n2. INFO in p1\\C.java (at line 12)\n\tC c = new C(input);\n\t  ^\nResource 'c' should be managed by try-with-resource\n----------\n3. ERROR in p1\\C.java (at line 17)\n\tC c = new C(fis);\n\t  ^\nPotential resource leak: 'c' may not be closed\n----------\n", null);
    }

    public void testWrappingTwoResources() {
        this.runLeakTestWithAnnotations(new String[]{"X.java", "import java.io.*;\nimport org.eclipse.jdt.annotation.*;\npublic class X implements AutoCloseable {\n\tprivate final @Owning DataInputStream fDataIn;\n\tprivate final @Owning DataOutputStream fDataOut;\n\tpublic X(@Owning InputStream in, @Owning OutputStream out) {\n\t\tfDataIn = new DataInputStream(new BufferedInputStream(in));\n\t\tfDataOut = new DataOutputStream(new BufferedOutputStream(out));\n\t}\n\tpublic void close() throws IOException {\n\t\tfDataIn.close();\n\t\tfDataOut.close();\n\t}\n}\n"}, "", null);
    }

    public void testConsumingMethod_nok() {
        this.runLeakTestWithAnnotations(new String[]{"F.java", "import org.eclipse.jdt.annotation.*;\npublic class F implements AutoCloseable {\n\t@Owning AutoCloseable rc1;\n\t@Owning AutoCloseable rc2;\n\tpublic void close() throws Exception { consume(); }\n\tpublic void consume(@Owning F this) throws Exception {\n\t\trc1.close();\n\t}\n}\n"}, "----------\n1. ERROR in F.java (at line 6)\n\tpublic void consume(@Owning F this) throws Exception {\n\t            ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nResource leak: 'this.rc2' is never closed\n----------\n", null);
    }

    public void testConsumingMethodUse() {
        this.runLeakTestWithAnnotations(new String[]{"F.java", "import org.eclipse.jdt.annotation.*;\npublic class F implements AutoCloseable {\n\tpublic void close() {}\n\tpublic void consume(@Owning F this) {\n\t}\n\tstatic void test() {\n\t\tF f = new F();\n\t\tf.consume();\n\t}\n}\n"}, "----------\n1. INFO in F.java (at line 7)\n\tF f = new F();\n\t  ^\nResource 'f' should be managed by try-with-resource\n----------\n", null);
    }

    public void testConsumingMethodUse_binary() {
        this.runLeakTestWithAnnotations(new String[]{"p1/F.java", "package p1;\nimport org.eclipse.jdt.annotation.*;\npublic class F implements AutoCloseable {\n\tpublic void close() {}\n\tpublic void consume(@Owning F this) {\n\t}\n}\n"}, "", null);
        this.runLeakTestWithAnnotations(new String[]{"Test.java", "import p1.F;\npublic class Test {\n\tstatic void test() {\n\t\tF f = new F();\n\t\tf.consume();\n\t}\n}\n"}, "----------\n1. INFO in Test.java (at line 4)\n\tF f = new F();\n\t  ^\nResource 'f' should be managed by try-with-resource\n----------\n", null, false);
    }

    public void testGH2207_2() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.explicitlyClosedAutoCloseable", "error");
        this.runLeakTestWithAnnotations(new String[]{"ResourceLeakTest.java", "import org.eclipse.jdt.annotation.Owning;\n\nclass RC implements AutoCloseable {\n\tpublic void close() {}\n}\ninterface ResourceProducer {\n\t@Owning RC newResource();\n}\npublic class ResourceLeakTest {\n\n\tpublic void test() {\n\t\tconsumerOK(() -> new RC());\n\t}\n\tvoid consumerOK(ResourceProducer producer) {\n\t\ttry (RC ac = producer.newResource()) {\n\t\t\tSystem.out.println(ac);\n\t\t}\n\t}\n\tvoid consumerNOK(ResourceProducer producer) {\n\t\tRC ac = producer.newResource();\n\t}\n}\n"}, "----------\n1. ERROR in ResourceLeakTest.java (at line 20)\n\tRC ac = producer.newResource();\n\t   ^^\nResource leak: 'ac' is never closed\n----------\n", options);
    }

    public void testGH2207_3() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.explicitlyClosedAutoCloseable", "error");
        this.runLeakTestWithAnnotations(new String[]{"ResourceLeakTest.java", "import org.eclipse.jdt.annotation.NotOwning;\n\nclass RC implements AutoCloseable {\n\tpublic void close() {}\n}\ninterface ResourceProducer {\n\t@NotOwning RC newResource();\n}\npublic class ResourceLeakTest {\n\n\tpublic void test(@NotOwning RC rcParm) {\n\t\tconsumer(() -> new RC());\n\t\tconsumer(() -> rcParm);\n\t}\n\tvoid consumer(ResourceProducer producer) {\n\t\tRC ac = producer.newResource();\n\t}\n}\n"}, "----------\n1. ERROR in ResourceLeakTest.java (at line 12)\n\tconsumer(() -> new RC());\n\t               ^^^^^^^^\nResource leak: '<unassigned Closeable value>' is never closed\n----------\n", options);
    }

    public void testGH2207_4() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.explicitlyClosedAutoCloseable", "error");
        this.runLeakTestWithAnnotations(new String[]{"ResourceLeakTest.java", "import org.eclipse.jdt.annotation.NotOwning;\n\nclass RC implements AutoCloseable {\n\tpublic void close() {}\n}\ninterface ResourceProducer {\n\t@NotOwning RC newResource();\n}\npublic class ResourceLeakTest {\n\n\tpublic void test(@NotOwning RC rcParm) {\n\t\tconsumer(() -> new RC());\n\t\tconsumer(() -> rcParm);\n\t}\n\tvoid consumer(ResourceProducer producer) {\n\t\tRC ac = producer.newResource();\n\t}\n}\n"}, "----------\n1. ERROR in ResourceLeakTest.java (at line 12)\n\tconsumer(() -> new RC());\n\t               ^^^^^^^^\nResource leak: '<unassigned Closeable value>' is never closed\n----------\n", options);
    }

    public void testGH2161_staticBlock() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.explicitlyClosedAutoCloseable", "error");
        this.runLeakTestWithAnnotations(new String[]{"ClassWithStatics.java", "import org.eclipse.jdt.annotation.*;\nclass RC implements AutoCloseable {\n\tpublic void close() {}\n}\npublic class ClassWithStatics {\n\n\tprivate static AutoCloseable f1;\n\tprotected static @Owning AutoCloseable f2;\n\tpublic static @NotOwning AutoCloseable f3;\n\tstatic @SuppressWarnings(\"resource\") @Owning AutoCloseable fSilent;\n\n\tstatic {\n\t\tf1 = new RC();\n\t\tSystem.out.print(f1); // avoid unused warning\n\t\tf2 = new RC();\n\t\tf3 = new RC();\n\t\tfSilent = new RC();\n\t}\n}\n"}, "----------\n1. INFO in ClassWithStatics.java (at line 7)\n\tprivate static AutoCloseable f1;\n\t                             ^^\nIt is not recommended to hold a resource in a static field\n----------\n2. INFO in ClassWithStatics.java (at line 8)\n\tprotected static @Owning AutoCloseable f2;\n\t                                       ^^\nIt is not recommended to hold a resource in a static field\n----------\n3. INFO in ClassWithStatics.java (at line 9)\n\tpublic static @NotOwning AutoCloseable f3;\n\t                                       ^^\nIt is not recommended to hold a resource in a static field\n----------\n4. ERROR in ClassWithStatics.java (at line 13)\n\tf1 = new RC();\n\t     ^^^^^^^^\nMandatory close of resource '<unassigned Closeable value>' has not been shown\n----------\n5. ERROR in ClassWithStatics.java (at line 16)\n\tf3 = new RC();\n\t     ^^^^^^^^\nResource leak: '<unassigned Closeable value>' is never closed\n----------\n", options);
    }

    public void testGH2161_initializers() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.explicitlyClosedAutoCloseable", "error");
        this.runLeakTestWithAnnotations(new String[]{"ClassWithStatics.java", "import org.eclipse.jdt.annotation.*;\nimport java.io.StringWriter;\nclass RC implements AutoCloseable {\n\tpublic void close() {}\n}\npublic class ClassWithStatics {\n\n\tprivate static AutoCloseable f1 = new RC();\n\tprotected static @Owning AutoCloseable f2 = new RC();\n\tpublic static @NotOwning AutoCloseable f3 = new RC();\n\tstatic @SuppressWarnings(\"resource\") @Owning AutoCloseable fSilent = new RC();\n\tstatic StringWriter sw = new StringWriter(); // no reason to complain: white listed\n\n\tstatic {\n\t\tSystem.out.print(f1); // avoid unused warning :)\n\t}\n}\n"}, "----------\n1. INFO in ClassWithStatics.java (at line 8)\n\tprivate static AutoCloseable f1 = new RC();\n\t                             ^^\nIt is not recommended to hold a resource in a static field\n----------\n2. INFO in ClassWithStatics.java (at line 9)\n\tprotected static @Owning AutoCloseable f2 = new RC();\n\t                                       ^^\nIt is not recommended to hold a resource in a static field\n----------\n3. INFO in ClassWithStatics.java (at line 10)\n\tpublic static @NotOwning AutoCloseable f3 = new RC();\n\t                                       ^^\nIt is not recommended to hold a resource in a static field\n----------\n", options);
    }

    public void testGH2635() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.explicitlyClosedAutoCloseable", "error");
        this.runLeakTestWithAnnotations(new String[]{"owning_test/OwningTest.java", "package owning_test;\n\nimport java.io.FileInputStream;\nimport java.io.FileNotFoundException;\nimport java.io.IOException;\nimport java.io.InputStream;\n\nimport org.eclipse.jdt.annotation.Owning;\n\npublic class OwningTest implements AutoCloseable {\n\n\t@Owning\n\tprivate InputStream fileInputStream;\n\n\t@SuppressWarnings(\"unused\")\n\tprivate NotOwningTest cacheUser;\n\n\tpublic void initialise() throws FileNotFoundException {\n\t  fileInputStream = new FileInputStream(\"test.txt\");\n\t  cacheUser = new NotOwningTest(fileInputStream);\n\t}\n\n\t@Override\n\tpublic void close() throws IOException {\n\t\tfileInputStream.close();\n\t}\n\n}\n", "owning_test/NotOwningTest.java", "package owning_test;\n\nimport java.io.InputStream;\n\nimport org.eclipse.jdt.annotation.NotOwning;\n\npublic class NotOwningTest {\n\n\t// If get a warning here - \"It is recommended to mark resource fields as '@Owning' to ensure proper closing\"\n\t@NotOwning\n\tprivate InputStream cacheInputStream;\n\n\tNotOwningTest(InputStream aCacheInputStream) {\n\t\tcacheInputStream = aCacheInputStream;\n\t}\n\n}\n"}, "", options);
    }

    public void testGH3278_OK() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        this.runLeakTestWithAnnotations(new String[]{"annotated/TestNotOwning.java", "package annotated;\n\nimport java.io.Closeable;\nimport java.io.IOException;\nimport java.util.ArrayList;\nimport java.util.List;\n\nimport org.eclipse.jdt.annotation.NotOwning;\nimport org.eclipse.jdt.annotation.Owning;\n\npublic class TestNotOwning implements Closeable {\n    private final List<Closeable> toClose = new ArrayList<>();\n\n    @NotOwning\n    public <T extends Closeable> T register(@Owning\n    T closeable) throws IOException {\n        closeable.close();\n        return closeable;\n    }\n\n    @Override\n    public void close() throws IOException {\n        for (Closeable closeable : toClose) {\n            closeable.close(); // Ignore error handling for this demonstration\n        }\n    }\n\n\tpublic static void client() throws IOException {\n\t\ttry (TestNotOwning t = new TestNotOwning()) {\n\t\t\tCloseable a = () -> {} ; // produces warning\n\t\t\tCloseable b = t.register(() -> {} ); // produces no warning\n\t\t\tassert a != null;\n\t\t\tassert b != null;\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in annotated\\TestNotOwning.java (at line 30)\n\tCloseable a = () -> {} ; // produces warning\n\t          ^\nResource leak: 'a' is never closed\n----------\n", options);
    }

    public void testGH3278_missingAnnotations() {
        this.runLeakTestWithAnnotations(new String[]{"annotated/TestNotOwning.java", "package annotated;\n\nimport java.io.Closeable;\nimport java.io.IOException;\nimport java.util.ArrayList;\nimport java.util.List;\n\nimport org.eclipse.jdt.annotation.NotOwning;\nimport org.eclipse.jdt.annotation.Owning;\n\npublic class TestNotOwning implements Closeable {\n\tprivate final List<Closeable> toClose = new ArrayList<>();\n\n\t@NotOwning\n\tpublic <T extends Closeable> T register(@Owning\n\tT closeable) throws IOException {\n\t\tcloseable.close();\n\t\treturn closeable;\n\t}\n\n\t@Override\n\tpublic void close() throws IOException {\n\t\tfor (Closeable closeable : toClose) {\n\t\t\tcloseable.close(); // Ignore error handling for this demonstration\n\t\t}\n\t}\n}\n"}, "", this.getCompilerOptions());
        Util.delete(new File(OUTPUT_DIR, "org/eclipse/jdt/annotation/Owning.class".replace('/', File.separatorChar)));
        Util.delete(new File(OUTPUT_DIR, "org/eclipse/jdt/annotation/NotOwning.class".replace('/', File.separatorChar)));
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.annotation.resourceanalysis", "enabled");
        this.runLeakTest(new String[]{"client/TestingAnnotated.java", "package client;\n\nimport java.io.Closeable;\nimport java.io.IOException;\n\nimport annotated.TestNotOwning;\n\npublic class TestingAnnotated {\n\n\tpublic static void client() throws IOException {\n\t\ttry (TestNotOwning t = new TestNotOwning()) {\n\t\t\tCloseable a = () -> {} ; // produces warning\n\t\t\tCloseable b = t.register(() -> {} ); // produces no warning\n\t\t\tassert a != null;\n\t\t\tassert b != null;\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in client\\TestingAnnotated.java (at line 12)\n\tCloseable a = () -> {} ; // produces warning\n\t          ^\nResource leak: 'a' is never closed\n----------\n", options, false);
    }
}

