/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;

public class RuntimeTests
extends AbstractRegressionTest {
    public RuntimeTests(String name) {
        super(name);
    }

    public static Test suite() {
        return RuntimeTests.buildAllCompliancesTestSuite(RuntimeTests.testClass());
    }

    public static Class testClass() {
        return RuntimeTests.class;
    }

    public void _test0001_memory_exhaustion() {
        this.runTest(new String[]{"X.java", "public class X {\n  public static void main(String args[]) {\n    try {      Y y = new Y(Integer.MAX_VALUE);\n    }    catch (OutOfMemoryError e) {\n      System.out.println(\"SUCCESS\");\n      return;\n    }\n    System.out.println(\"FAILURE\");\n  }\n}\nclass Y {\n  long storage[];\n  Y(int itemsNb) {\n    storage = new long[itemsNb];\n  }\n}\n"}, false, "", "SUCCESS", null, false, null, true, null, null, null, true);
    }

    public void test0500_synchronization() {
        this.runConformTest(new String[]{"X.java", "public class X {\nstatic public void main (String args[]) {\n  new Lock().implicitLock();\n}\n}\nclass Lock extends Thread {\n  byte step = 0;\n  void logStep(String start) {\n    System.out.println(start + \" \" + this.step); //$NON-NLS-1$\n  }\n  public void run() {\n    for (int i = 1; i < 3; i++) {\n      logStep(\"explicit lock\"); //$NON-NLS-1$\n      synchronized (this) {\n        this.step++;\n        notify();\n        while(this.step < 2 * i) {\n          try {\n            wait();\n          } catch (InterruptedException e) {\n            System.out.println(\"EXCEPTION\"); //$NON-NLS-1$\n          }\n        }\n      }\n    }\n  }\n  synchronized void implicitLock() {\n      this.start();\n      for (int i = 0; i < 2; i++) {\n        while (this.step < 1 + i * 2) {\n          try {\n            wait();\n          } catch (InterruptedException e) {\n            System.out.println(\"EXCEPTION\"); //$NON-NLS-1$\n          }\n        }\n        logStep(\"implicit lock\"); //$NON-NLS-1$\n        this.step++;\n        notify();\n      }\n      return;\n  }\n}\n"}, "explicit lock 0\nimplicit lock 1\nexplicit lock 2\nimplicit lock 3");
    }

    public void test0600_reflection() {
        this.runConformTest(true, new String[]{"X.java", "import java.lang.reflect.*;\nimport p.*;\npublic class X {\nstatic public void main (String args[]) {\n  Y y = new Y();\n  try {\n    Method foo = Y.class.getMethod(\"foo\", (Class []) null);\n    y.foo();\n    foo.invoke(y, (Object []) null);\n  } catch (NoSuchMethodException e) {\n      //ignore\n  } catch (InvocationTargetException e) {\n      //ignore\n  } catch (IllegalAccessException e) {\n    System.out.print(\"FAILURE: IllegalAccessException\");\n  }\n}\n}", "p/Y.java", "package p;\npublic class Y extends Z {\n  /* empty */\n}\n", "p/Z.java", "package p;\nclass Z {\n  public void foo() {\n  System.out.println(\"SUCCESS\"); //$NON-NLS-1$\n  }\n}\n"}, "", "SUCCESS\nSUCCESS", "", AbstractRegressionTest.JavacTestOptions.EclipseJustification.EclipseBug126712);
    }

    public void test0601_reflection() {
        this.runConformTest(new String[]{"X.java", "import java.lang.reflect.*;\nimport p.*;\npublic class X {\nstatic public void main (String args[]) {\n  Y y = new Y();\n  try {\n    Field f = Y.class.getField(\"m\");\n    System.out.println(y.m);\n    System.out.println(f.get(y));\n  } catch (NoSuchFieldException e) {\n      //ignore\n  } catch (IllegalAccessException e) {\n    System.out.print(\"FAILURE: IllegalAccessException\");\n  }\n}\n}", "p/Y.java", "package p;\npublic class Y extends Z {\n  /* empty */\n}\n", "p/Z.java", "package p;\nclass Z {\n  public String m = \"SUCCESS\";\n}\n"}, "SUCCESS\nFAILURE: IllegalAccessException");
    }

    public void test1000_partial_rebuild() {
        this.runConformTest(new String[]{"X.java", "public class X {\nstatic public void main(String args[]) {\n  Z.go();\n}\n}\n", "Z.java", "public class Z {\nstatic public void go() {\n  int flag = 0;\n  try {\n    new Y().random();\n    flag = 1;\n  }\n  catch (NoSuchMethodError e) {\n    flag = 2;\n  }\n  catch (Throwable t) {\n    flag = 3;\n  }\n  System.out.println(flag);\n}\n}\n", "Y.java", "public class Y {\njava.util.Random generator = new java.util.Random();public byte random() {\n  return (byte) (generator.nextInt() % Byte.MAX_VALUE);\n}\n}\n"}, "1");
        this.runConformTest(new String[]{"X.java", "public class X {\nstatic public void main(String args[]) {\n  Z.go();\n}\n}\n", "Y.java", "public class Y {\njava.util.Random generator = new java.util.Random();public int random() {\n  return generator.nextInt();\n}\n}\n"}, "2", null, false, null);
    }

    public void test1001_partial_rebuild() {
        this.runConformTest(new String[]{"X.java", "public class X {\nstatic public void main(String args[]) {\n  Z.go();\n}\n}\n", "Z.java", "public class Z {\nstatic public void go() {\n  byte flag = 0;\n  try {\n    new Y().random(flag);\n    flag = 1;\n  }\n  catch (NoSuchMethodError e) {\n    flag = 2;\n  }\n  catch (Throwable t) {\n    flag = 3;\n  }\n  System.out.println(flag);\n}\n}\n", "Y.java", "public class Y {\npublic int random(byte seed) {\n  return seed++;\n}\n}\n"}, "1");
        this.runConformTest(new String[]{"X.java", "public class X {\nstatic public void main(String args[]) {\n  Z.go();\n}\n}\n", "Y.java", "public class Y {\npublic int random(int seed) {\n  return seed++;\n}\n}\n"}, "2", null, false, null);
    }

    public void test1002_partial_rebuild() {
        this.runConformTest(new String[]{"X.java", "public class X {\nstatic public void main(String args[]) {\n  new Z().go();\n}\n}\n", "Z.java", "public class Z extends p.Y {\n  class ZInner extends YInner {\n    // empty\n  }\npublic void go() {\n  byte flag = 0;\n  try {\n    new ZInner().foo();\n    flag = 1;\n  }\n  catch (IllegalAccessError e) {\n    flag = 2;\n  }\n  catch (Throwable t) {\n    flag = 3;\n  }\n  System.out.println(flag);\n}\n}\n", "p/Y.java", "package p;\npublic class Y {\n  public class YInner {\n    public void foo() {\n      return;\n    }\n  }\n}\n"}, "1");
        this.runConformTest(false, new String[]{"X.java", "public class X {\nstatic public void main(String args[]) {\n  new Z().go();\n}\n}\n", "p/Y.java", "package p;\npublic class Y {\n  public class YInner {\n    void foo() {\n      return;\n    }\n  }\n}\n"}, "", "2", "", AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacBugFixed_6_10);
    }

    public void test1003_partial_rebuild() {
        this.runConformTest(new String[]{"X.java", "public class X {\nstatic public void main(String args[]) {\n  new Z().go();\n}\n}\n", "Z.java", "public class Z extends p.Y {\n  class ZInner extends YInner {\n    // empty\n  }\npublic void go() {\n  byte flag = 0;\n  try {\n    new ZInner().foo();\n    flag = 1;\n  }\n  catch (IllegalAccessError e) {\n    flag = 2;\n  }\n  catch (Throwable t) {\n    flag = 3;\n  }\n  System.out.println(flag);\n}\n}\n", "p/Y.java", "package p;\npublic class Y {\n  public class YInner {\n    public void foo() {\n      return;\n    }\n  }\n}\n"}, "1");
        this.runConformTest(false, new String[]{"X.java", "public class X {\nstatic public void main(String args[]) {\n  new Z().go();\n}\n}\n", "p/Y.java", "package p;\npublic class Y {\n  public class YInner {\n    protected void foo() {\n      return;\n    }\n  }\n}\n"}, "", "2", "", AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacBugFixed_6_10);
    }

    public void test1004_partial_rebuild() {
        this.runConformTest(new String[]{"p1/Z.java", "package p1; \npublic class Z {\t\n\tpublic static void main(String[] arguments) { \n\t\tY y = new Y();\t\n\t\tSystem.out.print(y.field);\t\n\t\tSystem.out.print(y.staticField);\t\n\t\tSystem.out.print(y.method());\t\n\t\tSystem.out.println(y.staticMethod());\t\n\t} \n} \n", "p1/X.java", "package p1; \npublic class X { \n\tpublic String field = \"X.field-\";\t\n\tpublic static String staticField = \"X.staticField-\";\t\n\tpublic String method(){ return \"X.method()-\";\t}\t\n\tpublic static String staticMethod(){ return \"X.staticMethod()-\";\t}\t\n} \n", "p1/Y.java", "package p1; \npublic class Y extends X { \n} \n"}, "X.field-X.staticField-X.method()-X.staticMethod()-");
        String expectedOutput = "Y.field-Y.staticField-Y.method()-Y.staticMethod()-";
        this.runConformTest(new String[]{"p1/Y.java", "package p1; \npublic class Y extends X { \n\tpublic static void main(String[] arguments) { \n\t\tZ.main(arguments);\t\n\t}\t\n\tpublic String field = \"Y.field-\";\t\n\tpublic static String staticField = \"Y.staticField-\";\t\n\tpublic String method(){ return \"Y.method()-\";\t}\t\n\tpublic static String staticMethod(){ return \"Y.staticMethod()-\";\t}\t\n} \n"}, expectedOutput, null, false, null);
    }
}

