/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import junit.framework.Test;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.IScanner;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileConstants;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.parser.Scanner;
import org.eclipse.jdt.internal.compiler.parser.TerminalToken;

public class ScannerTest
extends AbstractRegressionTest {
    public ScannerTest(String name) {
        super(name);
    }

    public static Test suite() {
        return ScannerTest.buildAllCompliancesTestSuite(ScannerTest.testClass());
    }

    public static Class testClass() {
        return ScannerTest.class;
    }

    public void test001() {
        String sourceA001 = "\\u003b";
        IScanner scanner = ToolFactory.createScanner((boolean)false, (boolean)true, (boolean)false, (boolean)false);
        scanner.setSource(sourceA001.toCharArray());
        int token = 0;
        try {
            token = scanner.getNextToken();
        }
        catch (InvalidInputException e) {
            ScannerTest.assertTrue((boolean)false);
        }
        ScannerTest.assertEquals((String)"Wrong token type", (int)64, (int)token);
    }

    public void test002() {
        String sourceA002 = "// tests\n  ";
        IScanner scanner = ToolFactory.createScanner((boolean)false, (boolean)true, (boolean)false, (boolean)false);
        scanner.setSource(sourceA002.toCharArray());
        int token = 0;
        try {
            token = scanner.getNextToken();
            ScannerTest.assertEquals((String)"Wrong token type", (int)1000, (int)token);
            ScannerTest.assertEquals((String)"Wrong size", (int)2, (int)scanner.getCurrentTokenSource().length);
            token = scanner.getNextToken();
            ScannerTest.assertEquals((String)"Wrong token type", (int)158, (int)token);
        }
        catch (InvalidInputException e) {
            ScannerTest.assertTrue((boolean)false);
        }
    }

    public void test003() {
        String sourceA003 = "// tests\n  ";
        IScanner scanner = ToolFactory.createScanner((boolean)true, (boolean)true, (boolean)false, (boolean)false);
        scanner.setSource(sourceA003.toCharArray());
        int token = 0;
        try {
            token = scanner.getNextToken();
            ScannerTest.assertEquals((String)"Wrong token type", (int)1001, (int)token);
            token = scanner.getNextToken();
            ScannerTest.assertEquals((String)"Wrong token type", (int)1000, (int)token);
            ScannerTest.assertEquals((String)"Wrong size", (int)2, (int)scanner.getCurrentTokenSource().length);
            token = scanner.getNextToken();
            ScannerTest.assertEquals((String)"Wrong token type", (int)158, (int)token);
        }
        catch (InvalidInputException e) {
            ScannerTest.assertTrue((boolean)false);
        }
    }

    public void test004() {
        String source = "01e0f";
        IScanner scanner = ToolFactory.createScanner((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        scanner.setSource(source.toCharArray());
        int token = 0;
        try {
            token = scanner.getNextToken();
            ScannerTest.assertEquals((String)"Wrong token type", (int)42, (int)token);
        }
        catch (InvalidInputException e) {
            ScannerTest.assertTrue((boolean)false);
        }
    }

    public void test005() {
        StringBuilder buf = new StringBuilder();
        buf.append("\"Hello\"");
        String str = buf.toString();
        IScanner scanner = ToolFactory.createScanner((boolean)true, (boolean)false, (boolean)false, (boolean)false);
        scanner.setSource(str.toCharArray());
        scanner.resetTo(0, str.length() - 1);
        int token = 0;
        try {
            token = scanner.getNextToken();
            ScannerTest.assertEquals((String)"Wrong token type", (int)45, (int)token);
            token = scanner.getNextToken();
            ScannerTest.assertEquals((String)"Wrong token type", (int)158, (int)token);
        }
        catch (InvalidInputException e) {
            ScannerTest.assertTrue((boolean)false);
        }
    }

    public void test006() {
        IScanner scanner = ToolFactory.createScanner((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        try {
            scanner.setSource(null);
        }
        catch (NullPointerException e) {
            ScannerTest.assertTrue((boolean)false);
        }
    }

    public void test007() {
        IScanner scanner = ToolFactory.createScanner((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        char[] source = "int i = 0;".toCharArray();
        scanner.setSource(source);
        scanner.resetTo(source.length + 50, source.length - 1);
        int token = -1;
        try {
            token = scanner.getNextToken();
        }
        catch (InvalidInputException e) {
            ScannerTest.assertTrue((boolean)false);
        }
        ScannerTest.assertEquals((String)"Expecting EOF", (int)158, (int)token);
    }

    public void test008() {
        IScanner scanner = ToolFactory.createScanner((boolean)false, (boolean)false, (boolean)false, (String)CompilerOptions.getFirstSupportedJavaVersion());
        char[] source = "0x11aa.aap-3333f".toCharArray();
        scanner.setSource(source);
        scanner.resetTo(0, source.length - 1);
        int token = -1;
        try {
            token = scanner.getNextToken();
            ScannerTest.assertEquals((String)"Wrong token", (int)42, (int)token);
            token = scanner.getNextToken();
        }
        catch (InvalidInputException e) {
            ScannerTest.assertTrue((boolean)false);
        }
        ScannerTest.assertEquals((String)"Expecting EOF", (int)158, (int)token);
    }

    public void test009() {
        IScanner scanner = ToolFactory.createScanner((boolean)false, (boolean)false, (boolean)false, (String)CompilerOptions.getFirstSupportedJavaVersion());
        char[] source = "0x11aa.aap-3333f".toCharArray();
        scanner.setSource(source);
        scanner.resetTo(0, source.length - 1);
        try {
            scanner.getNextToken();
        }
        catch (InvalidInputException e) {
            ScannerTest.assertEquals("Wrong message", "Illegal_Hexa_Literal", e.getMessage());
        }
    }

    public void test010() {
        IScanner scanner = ToolFactory.createScanner((boolean)false, (boolean)false, (boolean)false, (String)CompilerOptions.getFirstSupportedJavaVersion());
        char[] source = "0x11aa.aap-3333f".toCharArray();
        scanner.setSource(source);
        scanner.resetTo(0, source.length - 1);
        int counter = 0;
        try {
            while (scanner.getNextToken() != 158) {
                ++counter;
            }
        }
        catch (InvalidInputException e) {
            ScannerTest.assertTrue((boolean)false);
        }
        ScannerTest.assertEquals((String)"Wrong number of tokens", (int)1, (int)counter);
    }

    public void test011() {
        IScanner scanner = ToolFactory.createScanner((boolean)false, (boolean)false, (boolean)false, (String)CompilerOptions.getFirstSupportedJavaVersion());
        char[] source = "0x.aap-3333f".toCharArray();
        scanner.setSource(source);
        scanner.resetTo(0, source.length - 1);
        int counter = 0;
        try {
            while (scanner.getNextToken() != 158) {
                ++counter;
            }
        }
        catch (InvalidInputException e) {
            ScannerTest.assertTrue((boolean)false);
        }
        ScannerTest.assertEquals((String)"Wrong number of tokens", (int)1, (int)counter);
    }

    public void test012() {
        IScanner scanner = ToolFactory.createScanner((boolean)false, (boolean)false, (boolean)false, (String)CompilerOptions.getFirstSupportedJavaVersion());
        char[] source = "0xaap3f".toCharArray();
        scanner.setSource(source);
        scanner.resetTo(0, source.length - 1);
        int counter = 0;
        try {
            while (scanner.getNextToken() != 158) {
                ++counter;
            }
        }
        catch (InvalidInputException e) {
            ScannerTest.assertTrue((boolean)false);
        }
        ScannerTest.assertEquals((String)"Wrong number of tokens", (int)1, (int)counter);
    }

    public void test013() {
        IScanner scanner = ToolFactory.createScanner((boolean)false, (boolean)false, (boolean)false, (String)CompilerOptions.getFirstSupportedJavaVersion());
        char[] source = "0xaapaf".toCharArray();
        scanner.setSource(source);
        scanner.resetTo(0, source.length - 1);
        try {
            while (scanner.getNextToken() != 158) {
            }
        }
        catch (InvalidInputException e) {
            ScannerTest.assertTrue((boolean)true);
            return;
        }
        ScannerTest.assertTrue((boolean)false);
    }

    public void test014() {
        IScanner scanner = ToolFactory.createScanner((boolean)false, (boolean)false, (boolean)false, (String)CompilerOptions.getFirstSupportedJavaVersion());
        char[] source = "0xaap.1f".toCharArray();
        scanner.setSource(source);
        scanner.resetTo(0, source.length - 1);
        try {
            while (scanner.getNextToken() != 158) {
            }
        }
        catch (InvalidInputException e) {
            ScannerTest.assertTrue((boolean)true);
            return;
        }
        ScannerTest.assertTrue((boolean)false);
    }

    public void test015() {
        IScanner scanner = ToolFactory.createScanner((boolean)false, (boolean)false, (boolean)false, (String)CompilerOptions.getFirstSupportedJavaVersion());
        char[] source = "0xaa.p1f".toCharArray();
        scanner.setSource(source);
        scanner.resetTo(0, source.length - 1);
        int counter = 0;
        try {
            while (scanner.getNextToken() != 158) {
                ++counter;
            }
        }
        catch (InvalidInputException e) {
            ScannerTest.assertTrue((boolean)false);
        }
        ScannerTest.assertEquals((String)"Wrong number of tokens", (int)1, (int)counter);
    }

    public void test016() {
        IScanner scanner = ToolFactory.createScanner((boolean)false, (boolean)false, (boolean)false, (String)CompilerOptions.getFirstSupportedJavaVersion());
        char[] source = "0xaa.p1F".toCharArray();
        scanner.setSource(source);
        scanner.resetTo(0, source.length - 1);
        int counter = 0;
        try {
            while (scanner.getNextToken() != 158) {
                ++counter;
            }
        }
        catch (InvalidInputException e) {
            ScannerTest.assertTrue((boolean)false);
        }
        ScannerTest.assertEquals((String)"Wrong number of tokens", (int)1, (int)counter);
    }

    public void test017() {
        IScanner scanner = ToolFactory.createScanner((boolean)false, (boolean)false, (boolean)false, (String)CompilerOptions.getFirstSupportedJavaVersion());
        char[] source = "0xaa.p1D".toCharArray();
        scanner.setSource(source);
        scanner.resetTo(0, source.length - 1);
        int counter = 0;
        try {
            while (scanner.getNextToken() != 158) {
                ++counter;
            }
        }
        catch (InvalidInputException e) {
            ScannerTest.assertTrue((boolean)false);
        }
        ScannerTest.assertEquals((String)"Wrong number of tokens", (int)1, (int)counter);
    }

    public void test018() {
        IScanner scanner = ToolFactory.createScanner((boolean)false, (boolean)false, (boolean)false, (String)CompilerOptions.getFirstSupportedJavaVersion());
        char[] source = "0xaa.p1d".toCharArray();
        scanner.setSource(source);
        scanner.resetTo(0, source.length - 1);
        int counter = 0;
        try {
            while (scanner.getNextToken() != 158) {
                ++counter;
            }
        }
        catch (InvalidInputException e) {
            ScannerTest.assertTrue((boolean)false);
        }
        ScannerTest.assertEquals((String)"Wrong number of tokens", (int)1, (int)counter);
    }

    public void test019() {
        IScanner scanner = ToolFactory.createScanner((boolean)false, (boolean)false, (boolean)false, (String)CompilerOptions.getFirstSupportedJavaVersion());
        char[] source = "0x".toCharArray();
        scanner.setSource(source);
        scanner.resetTo(0, source.length - 1);
        try {
            while (scanner.getNextToken() != 158) {
            }
        }
        catch (InvalidInputException e) {
            ScannerTest.assertTrue((boolean)true);
            return;
        }
        ScannerTest.assertTrue((boolean)false);
    }

    public void test020() {
        IScanner scanner = ToolFactory.createScanner((boolean)false, (boolean)false, (boolean)false, (String)CompilerOptions.getFirstSupportedJavaVersion());
        char[] source = "0x".toCharArray();
        scanner.setSource(source);
        scanner.resetTo(0, source.length - 1);
        try {
            while (scanner.getNextToken() != 158) {
            }
        }
        catch (InvalidInputException e) {
            ScannerTest.assertTrue((boolean)true);
            return;
        }
        ScannerTest.assertTrue((boolean)false);
    }

    public void test021() {
        IScanner scanner = ToolFactory.createScanner((boolean)false, (boolean)false, (boolean)false, (String)CompilerOptions.getFirstSupportedJavaVersion());
        char[] source = "0x1".toCharArray();
        scanner.setSource(source);
        scanner.resetTo(0, source.length - 1);
        int counter = 0;
        try {
            while (scanner.getNextToken() != 158) {
                ++counter;
            }
        }
        catch (InvalidInputException e) {
            ScannerTest.assertTrue((boolean)false);
        }
        ScannerTest.assertEquals((String)"Wrong number of tokens", (int)1, (int)counter);
    }

    public void test022() {
        IScanner scanner = ToolFactory.createScanner((boolean)false, (boolean)false, (boolean)false, (String)CompilerOptions.getFirstSupportedJavaVersion());
        char[] source = "0x1".toCharArray();
        scanner.setSource(source);
        scanner.resetTo(0, source.length - 1);
        int counter = 0;
        try {
            while (scanner.getNextToken() != 158) {
                ++counter;
            }
        }
        catch (InvalidInputException e) {
            ScannerTest.assertTrue((boolean)false);
        }
        ScannerTest.assertEquals((String)"Wrong number of tokens", (int)1, (int)counter);
    }

    public void test023() {
        IScanner scanner = ToolFactory.createScanner((boolean)false, (boolean)false, (boolean)false, (String)CompilerOptions.getFirstSupportedJavaVersion());
        char[] source = "0x.p-2".toCharArray();
        scanner.setSource(source);
        scanner.resetTo(0, source.length - 1);
        try {
            while (scanner.getNextToken() != 158) {
            }
            ScannerTest.assertTrue((boolean)false);
        }
        catch (InvalidInputException e) {
            ScannerTest.assertTrue((boolean)true);
        }
    }

    public void test024() {
        IScanner scanner = ToolFactory.createScanner((boolean)false, (boolean)false, (boolean)true, (String)CompilerOptions.getFirstSupportedJavaVersion());
        char[] source = "public class X {\n\n}".toCharArray();
        scanner.setSource(source);
        int counter = 0;
        try {
            while (scanner.getNextToken() != 158) {
                ++counter;
            }
        }
        catch (InvalidInputException invalidInputException) {
            // empty catch block
        }
        ScannerTest.assertEquals((String)"wrong number of tokens", (int)5, (int)counter);
        int[] lineEnds = scanner.getLineEnds();
        ScannerTest.assertNotNull((String)"No line ends", (Object)lineEnds);
        ScannerTest.assertEquals((String)"wrong length", (int)2, (int)lineEnds.length);
        source = "public class X {}".toCharArray();
        scanner.setSource(source);
        lineEnds = scanner.getLineEnds();
        ScannerTest.assertNotNull((String)"No line ends", (Object)lineEnds);
        ScannerTest.assertEquals((String)"wrong length", (int)0, (int)lineEnds.length);
        counter = 0;
        try {
            while (scanner.getNextToken() != 158) {
                ++counter;
            }
        }
        catch (InvalidInputException invalidInputException) {
            // empty catch block
        }
        ScannerTest.assertEquals((String)"wrong number of tokens", (int)5, (int)counter);
        lineEnds = scanner.getLineEnds();
        ScannerTest.assertNotNull((String)"No line ends", (Object)lineEnds);
        ScannerTest.assertEquals((String)"wrong length", (int)0, (int)lineEnds.length);
    }

    public void test025() {
        IScanner scanner = ToolFactory.createScanner((boolean)true, (boolean)true, (boolean)false, (boolean)true);
        scanner.setSource("String\r\nwith\r\nmany\r\nmany\r\nline\r\nbreaks".toCharArray());
        try {
            while (scanner.getNextToken() != 158) {
            }
        }
        catch (InvalidInputException e) {
            ScannerTest.assertTrue((boolean)false);
        }
        ScannerTest.assertEquals((String)"Wrong size", (int)5, (int)scanner.getLineEnds().length);
        scanner.setSource("No line breaks here".toCharArray());
        ScannerTest.assertEquals((String)"Wrong size", (int)0, (int)scanner.getLineEnds().length);
    }

    public void test026() {
        IScanner scanner = ToolFactory.createScanner((boolean)false, (boolean)false, (boolean)false, (String)CompilerOptions.getFirstSupportedJavaVersion());
        char[] source = "0x.p-2".toCharArray();
        scanner.setSource(source);
        scanner.resetTo(0, source.length - 1);
        try {
            while (scanner.getNextToken() != 158) {
            }
            ScannerTest.assertTrue((boolean)false);
        }
        catch (InvalidInputException e) {
            ScannerTest.assertTrue((boolean)true);
        }
    }

    public void test027() {
        char[] source = "class Test {\n  char  C = \"\\u005Cn\";\n}".toCharArray();
        Scanner scanner = new Scanner(false, false, false, 0x340000L, null, null, false);
        scanner.setSource(source);
        scanner.resetTo(0, source.length - 1);
        try {
            TerminalToken token;
            StringBuilder buffer = new StringBuilder();
            while ((token = scanner.getNextToken()) != TerminalToken.TokenNameEOF) {
                try {
                    switch (token) {
                        case TokenNameEOF: {
                            break;
                        }
                        default: {
                            buffer.append(scanner.getCurrentTokenSource());
                            break;
                        }
                    }
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    e.printStackTrace();
                }
            }
            ScannerTest.assertEquals("Wrong contents", "classTest{charC=\"\n\";}", String.valueOf(buffer));
        }
        catch (InvalidInputException e) {
            ScannerTest.assertTrue((boolean)false);
        }
    }

    public void test028() {
        char[] source = "class Test {\n  char  C = '\\u005Cn';\n}".toCharArray();
        Scanner scanner = new Scanner(false, false, false, 0x340000L, null, null, false);
        scanner.setSource(source);
        scanner.resetTo(0, source.length - 1);
        try {
            TerminalToken token;
            StringBuilder buffer = new StringBuilder();
            while ((token = scanner.getNextToken()) != TerminalToken.TokenNameEOF) {
                try {
                    switch (token) {
                        case TokenNameStringLiteral: {
                            buffer.append(new String(scanner.getCurrentTokenSourceString()));
                            break;
                        }
                        case TokenNameEOF: {
                            break;
                        }
                        default: {
                            buffer.append(scanner.getCurrentTokenSource());
                            break;
                        }
                    }
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    e.printStackTrace();
                }
            }
            ScannerTest.assertEquals("Wrong contents", "classTest{charC='\\n';}", String.valueOf(buffer));
        }
        catch (InvalidInputException e) {
            ScannerTest.assertTrue((boolean)false);
        }
    }

    public void test029() {
        char[] source = "class Test {\n  char  C = \"\\n\";\n}".toCharArray();
        Scanner scanner = new Scanner(false, false, false, 0x340000L, null, null, false);
        scanner.setSource(source);
        scanner.resetTo(0, source.length - 1);
        try {
            TerminalToken token;
            StringBuilder buffer = new StringBuilder();
            while ((token = scanner.getNextToken()) != TerminalToken.TokenNameEOF) {
                try {
                    switch (token) {
                        case TokenNameEOF: {
                            break;
                        }
                        default: {
                            buffer.append(scanner.getCurrentTokenSource());
                            break;
                        }
                    }
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    e.printStackTrace();
                }
            }
            ScannerTest.assertEquals("Wrong contents", "classTest{charC=\"\n\";}", String.valueOf(buffer));
        }
        catch (InvalidInputException e) {
            ScannerTest.assertTrue((boolean)false);
        }
    }

    public void test030() {
        this.runConformTest(new String[]{"Test.java", "public class Test {\n  static String C = \"\\n\";\n  \n  public static void main(String[] args) {\n  \tSystem.out.print(C.length());\n  \tSystem.out.print(C.charAt(0) == '\\n');\n  }\n}"}, "1true");
    }

    public void test031() {
        this.runConformTest(new String[]{"Test.java", "public class Test {\n  static String C = \"\\u005Cn\";\n  \n  public static void main(String[] args) {\n  \tSystem.out.print(C.length());\n  \tSystem.out.print(C.charAt(0) == '\\n');\n  }\n}"}, "1true");
    }

    public void test032() {
        this.runConformTest(new String[]{"Test.java", "public class Test {\n  static char C = '\\u005Cn';\n  \n  public static void main(String[] args) {\n  \tSystem.out.print(C == '\\n');\n  }\n}"}, "true");
    }

    public void test033() {
        this.runConformTest(new String[]{"Test.java", "public class Test {\n  static char C = \\u0027\\u005Cn\\u0027;\n  \n  public static void main(String[] args) {\n  \tSystem.out.print(C == '\\n');\n  }\n}"}, "true");
    }

    public void test034() {
        this.runConformTest(new String[]{"Test.java", "public class Test {\n  static String C = \"C\\n\\u0043\";\n  \n  public static void main(String[] args) {\n  \tSystem.out.print(C.length());\n  \tSystem.out.print(C.charAt(1) == '\\n');\n  }\n}"}, "3true");
    }

    public void test035() {
        this.runConformTest(new String[]{"Test.java", "\\u0070\\u0075\\u0062\\u006c\\u0069\\u0063\\u0020\\u0063\\u006c\\u0061\\u0073\\u0073\\u0020\\u0054\\u0065\\u0073\\u0074\\u0020\\u007b\\u000A\n\\u0020\\u0020\\u0073\\u0074\\u0061\\u0074\\u0069\\u0063\\u0020\\u0053\\u0074\\u0072\\u0069\\u006e\\u0067\\u0020\\u0043\\u0020\\u003d\\u0020\\u0022\\u005c\\u006e\\u0022\\u003b\\u000A\n\\u0020\\u0020\\u000A\n\\u0020\\u0020\\u0070\\u0075\\u0062\\u006c\\u0069\\u0063\\u0020\\u0073\\u0074\\u0061\\u0074\\u0069\\u0063\\u0020\\u0076\\u006f\\u0069\\u0064\\u0020\\u006d\\u0061\\u0069\\u006e\\u0028\\u0053\\u0074\\u0072\\u0069\\u006e\\u0067\\u005b\\u005d\\u0020\\u0061\\u0072\\u0067\\u0073\\u0029\\u0020\\u007b\\u000A\n\\u0020\\u0020\\u0009\\u0053\\u0079\\u0073\\u0074\\u0065\\u006d\\u002e\\u006f\\u0075\\u0074\\u002e\\u0070\\u0072\\u0069\\u006e\\u0074\\u0028\\u0043\\u002e\\u006c\\u0065\\u006e\\u0067\\u0074\\u0068\\u0028\\u0029\\u0029\\u003b\\u000A\n\\u0020\\u0020\\u0009\\u0053\\u0079\\u0073\\u0074\\u0065\\u006d\\u002e\\u006f\\u0075\\u0074\\u002e\\u0070\\u0072\\u0069\\u006e\\u0074\\u0028\\u0043\\u002e\\u0063\\u0068\\u0061\\u0072\\u0041\\u0074\\u0028\\u0030\\u0029\\u0020\\u003d\\u003d\\u0020\\u0027\\u005c\\u006e\\u0027\\u0029\\u003b\\u000A\n\\u0020\\u0020\\u007d\\u0020\\u0009\\u000A\n\\u007d"}, "1true");
    }

    public void test036() {
        try {
            IScanner s = ToolFactory.createScanner((boolean)true, (boolean)true, (boolean)true, (String)CompilerOptions.getFirstSupportedJavaVersion(), (String)CompilerOptions.getFirstSupportedJavaVersion());
            char[] source = new char[]{';', ' '};
            s.setSource(source);
            s.resetTo(0, 0);
            int token = s.getNextToken();
            ScannerTest.assertEquals((String)"Wrong token", (int)64, (int)token);
            char[] tokenSource = s.getCurrentTokenSource();
            ScannerTest.assertEquals((String)"wront size", (int)1, (int)tokenSource.length);
            ScannerTest.assertEquals((String)"Wrong character", (char)';', (char)tokenSource[0]);
            token = s.getNextToken();
            ScannerTest.assertEquals((String)"Wrong token", (int)158, (int)token);
        }
        catch (InvalidInputException e) {
            ScannerTest.assertTrue((String)"Should not happen", (boolean)false);
        }
    }

    public void test037() {
        try {
            IScanner s = ToolFactory.createScanner((boolean)true, (boolean)true, (boolean)true, (String)CompilerOptions.getFirstSupportedJavaVersion(), (String)CompilerOptions.getFirstSupportedJavaVersion());
            char[] source = new char[]{';', ' '};
            s.setSource(source);
            int token = s.getNextToken();
            ScannerTest.assertEquals((String)"Wrong token", (int)64, (int)token);
            char[] tokenSource = s.getCurrentTokenSource();
            ScannerTest.assertEquals((String)"wront size", (int)1, (int)tokenSource.length);
            ScannerTest.assertEquals((String)"Wrong character", (char)';', (char)tokenSource[0]);
            token = s.getNextToken();
            tokenSource = s.getCurrentTokenSource();
            ScannerTest.assertEquals((String)"wront size", (int)1, (int)tokenSource.length);
            ScannerTest.assertEquals((String)"Wrong character", (char)' ', (char)tokenSource[0]);
            ScannerTest.assertEquals((String)"Wrong token", (int)1000, (int)token);
            token = s.getNextToken();
            ScannerTest.assertEquals((String)"Wrong token", (int)158, (int)token);
        }
        catch (InvalidInputException e) {
            ScannerTest.assertTrue((String)"Should not happen", (boolean)false);
        }
    }

    public void test038() {
        try {
            IScanner s = ToolFactory.createScanner((boolean)true, (boolean)true, (boolean)true, (String)CompilerOptions.getFirstSupportedJavaVersion(), (String)CompilerOptions.getFirstSupportedJavaVersion());
            char[] source = new char[]{';', ' '};
            s.setSource(source);
            s.resetTo(0, 1);
            int token = s.getNextToken();
            ScannerTest.assertEquals((String)"Wrong token", (int)64, (int)token);
            char[] tokenSource = s.getCurrentTokenSource();
            ScannerTest.assertEquals((String)"wront size", (int)1, (int)tokenSource.length);
            ScannerTest.assertEquals((String)"Wrong character", (char)';', (char)tokenSource[0]);
            token = s.getNextToken();
            ScannerTest.assertEquals((String)"Wrong token", (int)1000, (int)token);
            tokenSource = s.getCurrentTokenSource();
            ScannerTest.assertEquals((String)"wront size", (int)1, (int)tokenSource.length);
            ScannerTest.assertEquals((String)"Wrong character", (char)' ', (char)tokenSource[0]);
            token = s.getNextToken();
            ScannerTest.assertEquals((String)"Wrong token", (int)158, (int)token);
        }
        catch (InvalidInputException e) {
            ScannerTest.assertTrue((String)"Should not happen", (boolean)false);
        }
    }

    public void test039() {
        try {
            IScanner s = ToolFactory.createScanner((boolean)true, (boolean)true, (boolean)true, (String)CompilerOptions.getFirstSupportedJavaVersion(), (String)CompilerOptions.getFirstSupportedJavaVersion());
            char[] source = new char[]{';', ' '};
            s.setSource(source);
            s.resetTo(1, 1);
            int token = s.getNextToken();
            ScannerTest.assertEquals((String)"Wrong token", (int)1000, (int)token);
            char[] tokenSource = s.getCurrentTokenSource();
            ScannerTest.assertEquals((String)"wront size", (int)1, (int)tokenSource.length);
            ScannerTest.assertEquals((String)"Wrong character", (char)' ', (char)tokenSource[0]);
            token = s.getNextToken();
            ScannerTest.assertEquals((String)"Wrong token", (int)158, (int)token);
        }
        catch (InvalidInputException e) {
            ScannerTest.assertTrue((String)"Should not happen", (boolean)false);
        }
    }

    public void test040() {
        try {
            IScanner s = ToolFactory.createScanner((boolean)true, (boolean)true, (boolean)true, (String)CompilerOptions.getFirstSupportedJavaVersion(), (String)CompilerOptions.getFirstSupportedJavaVersion());
            char[] source = new char[]{';', ' '};
            s.setSource(source);
            s.resetTo(2, 1);
            int token = s.getNextToken();
            ScannerTest.assertEquals((String)"Wrong token", (int)158, (int)token);
        }
        catch (InvalidInputException e) {
            ScannerTest.assertTrue((String)"Should not happen", (boolean)false);
        }
    }

    public void test041() {
        try {
            IScanner s = ToolFactory.createScanner((boolean)true, (boolean)true, (boolean)true, (String)CompilerOptions.getFirstSupportedJavaVersion(), (String)CompilerOptions.getFirstSupportedJavaVersion());
            char[] source = "\\u003B\\u0020".toCharArray();
            ScannerTest.assertEquals((String)"wrong size", (int)12, (int)source.length);
            s.setSource(source);
            s.resetTo(0, 5);
            int token = s.getNextToken();
            ScannerTest.assertEquals((String)"Wrong token", (int)64, (int)token);
            char[] tokenSource = s.getRawTokenSource();
            ScannerTest.assertEquals((String)"wront size", (int)6, (int)tokenSource.length);
            ScannerTest.assertEquals("Wrong character", "\\u003B", new String(tokenSource));
            token = s.getNextToken();
            ScannerTest.assertEquals((String)"Wrong token", (int)158, (int)token);
        }
        catch (InvalidInputException e) {
            ScannerTest.assertTrue((String)"Should not happen", (boolean)false);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void test042() {
        IScanner scanner = ToolFactory.createScanner((boolean)true, (boolean)true, (boolean)true, (String)CompilerOptions.getFirstSupportedJavaVersion(), (String)CompilerOptions.getFirstSupportedJavaVersion());
        char[] source = "\"a\\u000D\"".toCharArray();
        scanner.setSource(source);
        StringBuilder buffer = new StringBuilder();
        try {
            block7: while (true) {
                int token;
                if ((token = scanner.getNextToken()) == 158) {
                    ScannerTest.assertTrue((String)"Should have failed", (boolean)false);
                    return;
                }
                try {
                    switch (token) {
                        case 158: {
                            continue block7;
                        }
                    }
                    buffer.append(scanner.getCurrentTokenSource());
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (InvalidInputException e) {
            buffer.append(scanner.getRawTokenSource());
            ScannerTest.assertEquals("Unexpected contents", "\"a\\u000D\"", String.valueOf(buffer));
            ScannerTest.assertEquals("Wrong exception", "Invalid_Char_In_String", e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void test043() {
        IScanner scanner = ToolFactory.createScanner((boolean)true, (boolean)true, (boolean)true, (String)CompilerOptions.getFirstSupportedJavaVersion(), (String)CompilerOptions.getFirstSupportedJavaVersion());
        char[] source = "\"\\u004Ca\\u000D\"".toCharArray();
        scanner.setSource(source);
        StringBuilder buffer = new StringBuilder();
        try {
            block7: while (true) {
                int token;
                if ((token = scanner.getNextToken()) == 158) {
                    ScannerTest.assertTrue((String)"Should have failed", (boolean)false);
                    return;
                }
                try {
                    switch (token) {
                        case 158: {
                            continue block7;
                        }
                    }
                    buffer.append(scanner.getCurrentTokenSource());
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (InvalidInputException e) {
            buffer.append(scanner.getRawTokenSource());
            ScannerTest.assertEquals("Unexpected contents", "\"\\u004Ca\\u000D\"", String.valueOf(buffer));
            ScannerTest.assertEquals("Wrong exception", "Invalid_Char_In_String", e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void test044() {
        IScanner scanner = ToolFactory.createScanner((boolean)true, (boolean)true, (boolean)true, (String)CompilerOptions.getFirstSupportedJavaVersion(), (String)CompilerOptions.getFirstSupportedJavaVersion());
        char[] source = "\"\\u004Ca\\u000D\\u0022".toCharArray();
        scanner.setSource(source);
        StringBuilder buffer = new StringBuilder();
        try {
            block7: while (true) {
                int token;
                if ((token = scanner.getNextToken()) == 158) {
                    ScannerTest.assertTrue((String)"Should have failed", (boolean)false);
                    return;
                }
                try {
                    switch (token) {
                        case 158: {
                            continue block7;
                        }
                    }
                    buffer.append(scanner.getCurrentTokenSource());
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (InvalidInputException e) {
            buffer.append(scanner.getRawTokenSource());
            ScannerTest.assertEquals("Unexpected contents", "\"\\u004Ca\\u000D\\u0022", String.valueOf(buffer));
            ScannerTest.assertEquals("Wrong exception", "Invalid_Char_In_String", e.getMessage());
        }
    }

    public void test045() {
        this.runConformTest(new String[]{"_X.java", "import java.lang.reflect.Field;\npublic class _X {\n\tpublic static void main(String[] args) {\n\t\tString i\\u0000;\n\t\tString i\\u0001;\n\t\tString i\\u0002;\n\t\tString i\\u0003;\n\t\tString i\\u0004;\n\t\tString i\\u0005;\n\t\tString i\\u0006;\n\t\tString i\\u0007;\n\t\tString i\\u0008;\n\t\tString i\\u000e;\n\t\tString i\\u000f;\n\t\tString i\\u0010;\n\t\tString i\\u0011;\n\t\tString i\\u0012;\n\t\tString i\\u0013;\n\t\tString i\\u0014;\n\t\tString i\\u0015;\n\t\tString i\\u0016;\n\t\tString i\\u0017;\n\t\tString i\\u0018;\n\t\tString i\\u0019;\n\t\tString i\\u001a;\n\t\tString i\\u001b;\n\t\tString i\\u007f;\n\t\tSystem.out.print(\"SUCCESS\");\n\t}\n}"}, "SUCCESS");
    }

    public void test046() {
        IScanner scanner = ToolFactory.createScanner((boolean)true, (boolean)true, (boolean)true, (String)JavaCore.getOption((String)"org.eclipse.jdt.core.compiler.source"), (String)JavaCore.getOption((String)"org.eclipse.jdt.core.compiler.compliance"));
        char[] source = "{\r\n\t}".toCharArray();
        scanner.setSource(source);
        scanner.resetTo(1, 3);
        try {
            ScannerTest.assertEquals((String)"Wrong token", (int)1000, (int)scanner.getNextToken());
            ScannerTest.assertEquals("Wrong source", "\r\n\t", new String(scanner.getCurrentTokenSource()));
            ScannerTest.assertEquals((String)"Wrong token", (int)158, (int)scanner.getNextToken());
        }
        catch (InvalidInputException e) {
            ScannerTest.assertTrue((String)"Wrong exception", (boolean)false);
        }
    }

    public void test047() {
        IScanner scanner = ToolFactory.createScanner((boolean)true, (boolean)true, (boolean)true, (String)JavaCore.getOption((String)"org.eclipse.jdt.core.compiler.source"), (String)JavaCore.getOption((String)"org.eclipse.jdt.core.compiler.compliance"));
        char[] source = "// a comment, longer than the offset".toCharArray();
        scanner.setSource(source);
        scanner.resetTo(0, 5);
        try {
            ScannerTest.assertEquals((String)"Wrong token", (int)1001, (int)scanner.getNextToken());
            ScannerTest.assertEquals("Wrong source", "// a c", new String(scanner.getCurrentTokenSource()));
            ScannerTest.assertEquals((String)"Wrong token", (int)158, (int)scanner.getNextToken());
        }
        catch (InvalidInputException e) {
            ScannerTest.assertTrue((String)"Wrong exception", (boolean)false);
        }
    }

    public void test048() {
        IScanner scanner = ToolFactory.createScanner((boolean)true, (boolean)true, (boolean)true, (String)JavaCore.getOption((String)"org.eclipse.jdt.core.compiler.source"), (String)JavaCore.getOption((String)"org.eclipse.jdt.core.compiler.compliance"));
        char[] source = "/*a comment, longer\n than the\noffset*/".toCharArray();
        scanner.setSource(source);
        scanner.resetTo(0, 5);
        try {
            ScannerTest.assertEquals((String)"Wrong token", (int)1002, (int)scanner.getNextToken());
            ScannerTest.assertTrue((String)"Should fail with InvalidInputException", (boolean)false);
        }
        catch (InvalidInputException e) {
            ScannerTest.assertEquals("Wrong source", "/*a co", new String(scanner.getCurrentTokenSource()));
        }
    }

    public void test049() {
        IScanner scanner = ToolFactory.createScanner((boolean)true, (boolean)true, (boolean)true, (String)JavaCore.getOption((String)"org.eclipse.jdt.core.compiler.source"), (String)JavaCore.getOption((String)"org.eclipse.jdt.core.compiler.compliance"));
        char[] source = "/*a coabstract, longer\n than the\noffset*/".toCharArray();
        scanner.setSource(source);
        scanner.resetTo(6, 13);
        try {
            ScannerTest.assertEquals((String)"Wrong token", (int)98, (int)scanner.getNextToken());
            ScannerTest.assertEquals("Wrong source", "abstract", new String(scanner.getCurrentTokenSource()));
            ScannerTest.assertEquals((String)"Wrong token", (int)158, (int)scanner.getNextToken());
        }
        catch (InvalidInputException e) {
            ScannerTest.assertTrue((String)"Wrong exception", (boolean)false);
        }
    }

    public void test050() {
        IScanner scanner = ToolFactory.createScanner((boolean)true, (boolean)true, (boolean)true, (String)JavaCore.getOption((String)"org.eclipse.jdt.core.compiler.source"), (String)JavaCore.getOption((String)"org.eclipse.jdt.core.compiler.compliance"));
        char[] source = "\"a comment, longer\\n than the\\noffset \"".toCharArray();
        scanner.setSource(source);
        scanner.resetTo(0, 5);
        try {
            ScannerTest.assertEquals((String)"Wrong token", (int)45, (int)scanner.getNextToken());
            ScannerTest.assertTrue((String)"Should fail with InvalidInputException", (boolean)false);
        }
        catch (InvalidInputException e) {
            ScannerTest.assertEquals("Wrong source", "\"a com", new String(scanner.getCurrentTokenSource()));
        }
    }

    public void test051() {
        IScanner scanner = ToolFactory.createScanner((boolean)true, (boolean)true, (boolean)true, (String)JavaCore.getOption((String)"org.eclipse.jdt.core.compiler.source"), (String)JavaCore.getOption((String)"org.eclipse.jdt.core.compiler.compliance"));
        char[] source = "\"a co\\u00E9mment, longer\\n than the\\noffset \"".toCharArray();
        scanner.setSource(source);
        scanner.resetTo(0, 5);
        try {
            ScannerTest.assertEquals((String)"Wrong token", (int)45, (int)scanner.getNextToken());
            ScannerTest.assertTrue((String)"Should fail with InvalidInputException", (boolean)false);
        }
        catch (InvalidInputException e) {
            ScannerTest.assertEquals("Wrong source", "\"a co\\", new String(scanner.getCurrentTokenSource()));
        }
    }

    public void test052() {
        IScanner scanner = ToolFactory.createScanner((boolean)true, (boolean)true, (boolean)true, (String)JavaCore.getOption((String)"org.eclipse.jdt.core.compiler.source"), (String)JavaCore.getOption((String)"org.eclipse.jdt.core.compiler.compliance"));
        char[] source = "\"\\u00E9mment, longer\\n than the\\noffset \"".toCharArray();
        scanner.setSource(source);
        scanner.resetTo(0, 5);
        try {
            ScannerTest.assertEquals((String)"Wrong token", (int)45, (int)scanner.getNextToken());
            ScannerTest.assertTrue((String)"Should fail with InvalidInputException", (boolean)false);
        }
        catch (InvalidInputException e) {
            ScannerTest.assertEquals("Wrong source", "\"\\u00E", new String(scanner.getCurrentTokenSource()));
        }
    }

    public void test053() {
        IScanner scanner = ToolFactory.createScanner((boolean)true, (boolean)true, (boolean)true, (String)CompilerOptions.getFirstSupportedJavaVersion(), (String)CompilerOptions.getFirstSupportedJavaVersion());
        char[] source = "elnu".toCharArray();
        scanner.setSource(source);
        scanner.resetTo(0, source.length - 1);
        try {
            ScannerTest.assertEquals((String)"Wrong token", (int)5, (int)scanner.getNextToken());
        }
        catch (InvalidInputException e) {
            ScannerTest.assertTrue((String)"Should not fail with InvalidInputException", (boolean)false);
        }
    }

    public void test055() {
        IScanner scanner = ToolFactory.createScanner((boolean)false, (boolean)false, (boolean)false, (String)CompilerOptions.getFirstSupportedJavaVersion(), (String)CompilerOptions.getFirstSupportedJavaVersion());
        char[] source = "class X {\n\tpublic static void main(String[] args) {\n\t\tString \ud804\udc09 = \"Brahmi\";\n\t\tSystem.out.println(\ud804\udc09);\n\t}\n}".toCharArray();
        scanner.setSource(source);
        scanner.resetTo(0, source.length - 1);
        try {
            int token;
            while ((token = scanner.getNextToken()) != 158) {
                ScannerTest.assertFalse((String)"found error token", (token == 309 ? 1 : 0) != 0);
            }
        }
        catch (InvalidInputException e) {
            ScannerTest.assertTrue((boolean)false);
        }
    }

    public void test057() {
        IScanner scanner = ToolFactory.createScanner((boolean)false, (boolean)false, (boolean)false, (String)CompilerOptions.getFirstSupportedJavaVersion(), (String)CompilerOptions.getFirstSupportedJavaVersion());
        char[] source = "class X {\n\tpublic static void main(String[] args) {\n\t\tString \u20b9 = \"Rupee symbol\";\n\t\tSystem.out.println(\u20b9);\n\t}\n}".toCharArray();
        scanner.setSource(source);
        scanner.resetTo(0, source.length - 1);
        try {
            int token;
            while ((token = scanner.getNextToken()) != 158) {
                ScannerTest.assertFalse((String)"found error token", (token == 309 ? 1 : 0) != 0);
            }
        }
        catch (InvalidInputException e) {
            ScannerTest.assertTrue((boolean)false);
        }
    }

    public void test058() {
        String source = "public class X {\n\tvoid foo() {\n\t\tint a\\u1369b;\n\t}\n}";
        this.runNegativeTest(new String[]{"X.java", source}, "----------\n1. ERROR in X.java (at line 3)\n\tint a\\u1369b;\n\t     ^^^^^^\nSyntax error on token \"Invalid Character\", = expected\n----------\n");
    }

    public void test059() {
        String source = "public class X {\n\tvoid foo() {\n\t\tint a\\u200B;\n\t}\n}";
        this.runConformTest(new String[]{"X.java", source}, "");
    }

    public void test060() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static final String ERROR = \"\\u000\u216b\";\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\tpublic static final String ERROR = \"\\u000\u216b\";\n\t                                    ^^^^^^\nInvalid unicode\n----------\n");
    }

    public void test061() {
        IScanner scanner = ToolFactory.createScanner((boolean)true, (boolean)true, (boolean)true, (String)CompilerOptions.getFirstSupportedJavaVersion(), (String)CompilerOptions.getFirstSupportedJavaVersion());
        char[] source = "case 1:\nsynchronized (someLock){}\n//$FALL-THROUGH$\ncase 2:".toCharArray();
        scanner.setSource(source);
        scanner.resetTo(0, source.length - 1);
        try {
            ScannerTest.assertEquals((String)"Wrong token", (int)211, (int)scanner.getNextToken());
            ScannerTest.assertEquals((String)"Wrong token", (int)1000, (int)scanner.getNextToken());
            ScannerTest.assertEquals((String)"Wrong token", (int)40, (int)scanner.getNextToken());
            ScannerTest.assertEquals((String)"Wrong token", (int)154, (int)scanner.getNextToken());
            ScannerTest.assertEquals((String)"Wrong token", (int)1000, (int)scanner.getNextToken());
            ScannerTest.assertEquals((String)"Wrong token", (int)85, (int)scanner.getNextToken());
            ScannerTest.assertEquals((String)"Wrong token", (int)1000, (int)scanner.getNextToken());
            ScannerTest.assertEquals((String)"Wrong token", (int)7, (int)scanner.getNextToken());
            ScannerTest.assertEquals((String)"Wrong token", (int)5, (int)scanner.getNextToken());
            ScannerTest.assertEquals((String)"Wrong token", (int)86, (int)scanner.getNextToken());
            ScannerTest.assertEquals((String)"Wrong token", (int)110, (int)scanner.getNextToken());
            ScannerTest.assertEquals((String)"Wrong token", (int)95, (int)scanner.getNextToken());
            ScannerTest.assertEquals((String)"Wrong token", (int)1000, (int)scanner.getNextToken());
            ScannerTest.assertEquals((String)"Wrong token", (int)1001, (int)scanner.getNextToken());
            ScannerTest.assertEquals((String)"Wrong token", (int)211, (int)scanner.getNextToken());
            ScannerTest.assertEquals((String)"Wrong token", (int)1000, (int)scanner.getNextToken());
            ScannerTest.assertEquals((String)"Wrong token", (int)40, (int)scanner.getNextToken());
            ScannerTest.assertEquals((String)"Wrong token", (int)154, (int)scanner.getNextToken());
        }
        catch (InvalidInputException e) {
            ScannerTest.assertTrue((String)"Should not fail with InvalidInputException", (boolean)false);
        }
    }

    public void test062() {
        IScanner scanner = ToolFactory.createScanner((boolean)false, (boolean)false, (boolean)false, (String)CompilerOptions.getFirstSupportedJavaVersion());
        char[] source = "->".toCharArray();
        scanner.setSource(source);
        scanner.resetTo(0, source.length - 1);
        int token = 0;
        try {
            token = scanner.getNextToken();
        }
        catch (InvalidInputException invalidInputException) {
            // empty catch block
        }
        ScannerTest.assertEquals((String)"Expecting ->", (int)405, (int)token);
    }

    public void test063() {
        IScanner scanner = ToolFactory.createScanner((boolean)false, (boolean)false, (boolean)false, (String)CompilerOptions.getFirstSupportedJavaVersion());
        char[] source = "::".toCharArray();
        scanner.setSource(source);
        scanner.resetTo(0, source.length - 1);
        int token = 0;
        try {
            token = scanner.getNextToken();
        }
        catch (InvalidInputException invalidInputException) {
            // empty catch block
        }
        ScannerTest.assertEquals((String)"Expecting ::", (int)406, (int)token);
    }

    public void test064() {
        String source = "public enum X {\n\tHello\\u205fworld;\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(Hello\\u205fworld);\n\t\tSystem.out.println(Character.isJavaIdentifierPart('\\u205f')); // false\n\t}\n}";
        this.runNegativeTest(new String[]{"X.java", source}, "----------\n1. ERROR in X.java (at line 2)\n\tHello\\u205fworld;\n\t     ^^^^^^\nSyntax error on token \"Invalid Character\", , expected\n----------\n2. ERROR in X.java (at line 4)\n\tSystem.out.println(Hello\\u205fworld);\n\t                        ^^^^^^\nSyntax error on token \"Invalid Character\", invalid AssignmentOperator\n----------\n");
    }

    public void test065() {
        String source = "public class X {\n\tdouble d = 0XP00;\n}";
        this.runNegativeTest(new String[]{"X.java", source}, "----------\n1. ERROR in X.java (at line 2)\n\tdouble d = 0XP00;\n\t           ^^^\nInvalid hex literal number\n----------\n");
    }

    public void test066() {
        String source = "public class X {\n\tdouble d = 0X.p02d;\n}";
        this.runNegativeTest(new String[]{"X.java", source}, "----------\n1. ERROR in X.java (at line 2)\n\tdouble d = 0X.p02d;\n\t           ^^^\nInvalid hex literal number\n----------\n");
    }

    public void test067() {
        String source = "public class X {\n\tfloat f = 0Xp02f;\n}";
        this.runNegativeTest(new String[]{"X.java", source}, "----------\n1. ERROR in X.java (at line 2)\n\tfloat f = 0Xp02f;\n\t          ^^^\nInvalid hex literal number\n----------\n");
    }

    public void test068() {
        String source = "public class X {\n\tfloat f = 0X0p02f;\n}";
        this.runConformTest(new String[]{"X.java", source});
    }

    public void testBug531716_001_since_13() {
        char[] source = "class X {\n  String  s = \"\"\"This is the new String\"\"\";\n}".toCharArray();
        Scanner scanner = new Scanner(false, false, false, ClassFileConstants.getLatestJDKLevel(), null, null, false);
        scanner.setSource(source);
        scanner.resetTo(0, source.length - 1);
        try {
            TerminalToken token;
            StringBuilder buffer = new StringBuilder();
            while ((token = scanner.getNextToken()) != TerminalToken.TokenNameEOF) {
                try {
                    switch (token) {
                        case TokenNameTextBlock: {
                            buffer.append(new String(scanner.getCurrentTextBlock()));
                            break;
                        }
                        case TokenNameStringLiteral: {
                            break;
                        }
                        case TokenNameEOF: {
                            break;
                        }
                    }
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    e.printStackTrace();
                }
            }
            ScannerTest.assertEquals("Wrong contents", "", String.valueOf(buffer));
        }
        catch (InvalidInputException e) {
            ScannerTest.assertTrue((boolean)false);
        }
    }

    public void testBug531716_001_since_13_1() {
        char[] source = "class X {\n  String  s = \"\"\"\nThis is the new String\"\"\";\n}".toCharArray();
        Scanner scanner = new Scanner(false, false, false, ClassFileConstants.getLatestJDKLevel(), null, null, false);
        scanner.previewEnabled = true;
        scanner.setSource(source);
        scanner.resetTo(0, source.length - 1);
        try {
            TerminalToken token;
            StringBuilder buffer = new StringBuilder();
            while ((token = scanner.getNextToken()) != TerminalToken.TokenNameEOF) {
                try {
                    switch (token) {
                        case TokenNameTextBlock: {
                            buffer.append(new String(scanner.getCurrentTextBlock()));
                            break;
                        }
                        case TokenNameStringLiteral: {
                            break;
                        }
                        case TokenNameEOF: {
                            break;
                        }
                    }
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    e.printStackTrace();
                }
            }
            ScannerTest.assertEquals("Wrong contents", "This is the new String", String.valueOf(buffer));
        }
        catch (InvalidInputException e) {
            ScannerTest.assertTrue((boolean)false);
        }
    }

    public void testBug422760() {
        String sourceA001 = "\\u0660";
        IScanner scanner = ToolFactory.createScanner((boolean)false, (boolean)true, (boolean)false, (boolean)false);
        scanner.setSource(sourceA001.toCharArray());
        int token = 0;
        try {
            token = scanner.getNextToken();
        }
        catch (InvalidInputException e) {
            ScannerTest.assertTrue((boolean)false);
        }
        ScannerTest.assertEquals((String)"Wrong token type", (int)40, (int)token);
    }

    public void testBug575556_at_14() {
        char[] source = "\"Hello\\sworld\"".toCharArray();
        Scanner scanner = new Scanner(false, false, false, 0x3A0000L, null, null, false);
        scanner.setSource(source);
        scanner.resetTo(0, source.length - 1);
        try {
            scanner.getNextToken();
            ScannerTest.fail((String)"Should have rejected \\s");
        }
        catch (InvalidInputException e) {
            ScannerTest.assertEquals("Invalid_Escape", e.getMessage());
        }
    }

    public void testBug575556_at_15() {
        char[] source = "\"Hello\\sworld\"".toCharArray();
        Scanner scanner = new Scanner(false, false, false, 0x3B0000L, null, null, false);
        scanner.setSource(source);
        scanner.resetTo(0, source.length - 1);
        try {
            TerminalToken token = scanner.getNextToken();
            ScannerTest.assertEquals((Object)TerminalToken.TokenNameStringLiteral, (Object)token);
            ScannerTest.assertEquals("Unexpected string literal content", "Hello world", scanner.getCurrentStringLiteral());
        }
        catch (InvalidInputException e) {
            ScannerTest.fail((String)"Should have accepted \\s");
        }
    }

    public void testIssue2338_001_since_14() {
        char[] source = "class X {\n  String  s = \"\"\"\nThis is the new\\\n String\"\"\";\n}".toCharArray();
        Scanner scanner = new Scanner(false, false, false, 68L, null, null, false);
        scanner.previewEnabled = true;
        scanner.recordLineSeparator = true;
        scanner.setSource(source);
        scanner.resetTo(0, source.length - 1);
        try {
            TerminalToken token;
            StringBuilder buffer = new StringBuilder();
            while ((token = scanner.getNextToken()) != TerminalToken.TokenNameEOF) {
                try {
                    switch (token) {
                        case TokenNameTextBlock: {
                            buffer.append(new String(scanner.getCurrentTextBlock()));
                            break;
                        }
                        case TokenNameStringLiteral: {
                            break;
                        }
                        case TokenNameEOF: {
                            break;
                        }
                    }
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    e.printStackTrace();
                }
            }
            ScannerTest.assertEquals("Wrong contents", "This is the new String", String.valueOf(buffer));
            ScannerTest.assertEquals((String)"Missing line end for continuation", (int)44, (int)scanner.lineEnds[2]);
        }
        catch (InvalidInputException e) {
            ScannerTest.assertTrue((boolean)false);
        }
    }

    public void testIssue3666_001_since_14() {
        char[] source = "class X {\n  String  s = \"\"\"\nThis is the new String\\\n\"\"\";\n}".toCharArray();
        Scanner scanner = new Scanner(false, false, false, 68L, null, null, false);
        scanner.previewEnabled = true;
        scanner.recordLineSeparator = true;
        scanner.setSource(source);
        scanner.resetTo(0, source.length - 1);
        try {
            TerminalToken token;
            StringBuilder buffer = new StringBuilder();
            while ((token = scanner.getNextToken()) != TerminalToken.TokenNameEOF) {
                try {
                    switch (token) {
                        case TokenNameTextBlock: {
                            buffer.append(new String(scanner.getCurrentTextBlock()));
                            break;
                        }
                        case TokenNameStringLiteral: {
                            break;
                        }
                        case TokenNameEOF: {
                            break;
                        }
                    }
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    e.printStackTrace();
                }
            }
            ScannerTest.assertEquals("Wrong contents", "This is the new String", String.valueOf(buffer));
            ScannerTest.assertEquals((String)"Missing line end for continuation", (int)51, (int)scanner.lineEnds[2]);
        }
        catch (InvalidInputException e) {
            ScannerTest.assertTrue((boolean)false);
        }
    }

    public void testSealed() {
        char[] source = "sealed class X { }".toCharArray();
        IScanner scanner = ToolFactory.createScanner((boolean)false, (boolean)true, (boolean)false, (String)"17", (String)"17", (boolean)false);
        scanner.setSource(source);
        scanner.resetTo(0, source.length - 1);
        try {
            int token = scanner.getNextToken();
            ScannerTest.assertEquals((String)"Wrong token", (int)412, (int)token);
        }
        catch (InvalidInputException e) {
            ScannerTest.assertTrue((boolean)false);
        }
    }

    public void testPermits() {
        char[] source = "sealed class X permits Y { }".toCharArray();
        IScanner scanner = ToolFactory.createScanner((boolean)false, (boolean)true, (boolean)false, (String)"17", (String)"17", (boolean)false);
        scanner.setSource(source);
        scanner.resetTo(0, source.length - 1);
        try {
            int token;
            while ((token = scanner.getNextToken()) != 158) {
                switch (token) {
                    case 5: 
                    case 165: 
                    case 412: 
                    case 1000: {
                        break;
                    }
                    case 410: {
                        return;
                    }
                    default: {
                        ScannerTest.fail((String)("Unexpected token " + token));
                    }
                }
            }
            ScannerTest.fail((String)"TokenNameRestrictedIdentifierpermits was not detected");
        }
        catch (InvalidInputException e) {
            ScannerTest.assertTrue((boolean)false);
        }
    }

    public void testNonSealed() {
        char[] source = "non-sealed class X { }".toCharArray();
        IScanner scanner = ToolFactory.createScanner((boolean)false, (boolean)true, (boolean)false, (String)"17", (String)"17", (boolean)false);
        scanner.setSource(source);
        scanner.resetTo(0, source.length - 1);
        try {
            int token = scanner.getNextToken();
            ScannerTest.assertEquals((String)"Wrong token", (int)414, (int)token);
        }
        catch (InvalidInputException e) {
            ScannerTest.assertTrue((boolean)false);
        }
    }

    public void testNonSealedNOK() {
        char[] source = "non-sealed class X { }".toCharArray();
        IScanner scanner = ToolFactory.createScanner((boolean)false, (boolean)true, (boolean)false, (String)"15", (String)"15", (boolean)false);
        scanner.setSource(source);
        scanner.resetTo(0, source.length - 1);
        try {
            int token = scanner.getNextToken();
            ScannerTest.assertEquals((String)"Wrong token", (int)5, (int)token);
        }
        catch (InvalidInputException e) {
            ScannerTest.assertTrue((boolean)false);
        }
    }

    public void testRestrictedIdentifierYield() {
        char[] source = "class X {\n\tint m(int i) {\n\t\treturn switch (i) { case 0 -> { yield 13; } default -> 0 }\n\t}\n}\n".toCharArray();
        IScanner scanner = ToolFactory.createScanner((boolean)false, (boolean)true, (boolean)false, (String)"17", (String)"17", (boolean)false);
        scanner.setSource(source);
        scanner.resetTo(0, source.length - 1);
        try {
            int token;
            while ((token = scanner.getNextToken()) != 158) {
                switch (token) {
                    case 5: 
                    case 7: 
                    case 23: 
                    case 40: 
                    case 86: 
                    case 110: 
                    case 124: 
                    case 125: 
                    case 165: 
                    case 211: 
                    case 405: 
                    case 1000: {
                        break;
                    }
                    case 409: {
                        return;
                    }
                    default: {
                        ScannerTest.fail((String)("Unexpected token " + token));
                    }
                }
            }
            ScannerTest.fail((String)"TokenNameRestrictedIdentifierYield was not detected");
        }
        catch (InvalidInputException e) {
            ScannerTest.assertTrue((boolean)false);
        }
    }

    public void testYieldNOK() {
        String source = "class X {\n\tint m(int i) {\n\t\treturn switch (i) { case 0 -> { yield 13; } default -> 0 }\n\t}\n}\n";
        IScanner scanner = ToolFactory.createScanner((boolean)false, (boolean)true, (boolean)false, (String)"15", (String)"15", (boolean)false);
        scanner.setSource(source.toCharArray());
        scanner.resetTo(source.indexOf("yield") - 1, source.length() - 1);
        try {
            int token;
            while ((token = scanner.getNextToken()) != 158) {
                switch (token) {
                    case 5: 
                    case 40: 
                    case 1000: {
                        break;
                    }
                    case 64: {
                        return;
                    }
                    default: {
                        ScannerTest.fail((String)("Unexpected token " + token));
                    }
                }
            }
            ScannerTest.fail((String)"TokenNameSEMICOLON was not detected");
        }
        catch (InvalidInputException e) {
            ScannerTest.assertTrue((boolean)false);
        }
    }

    public void testRecord() {
        char[] source = "record Point {int x, int y}".toCharArray();
        IScanner scanner = ToolFactory.createScanner((boolean)false, (boolean)true, (boolean)false, (String)"16", (String)"16", (boolean)false);
        scanner.setSource(source);
        scanner.resetTo(0, source.length - 1);
        try {
            int token = scanner.getNextToken();
            ScannerTest.assertEquals((String)"Wrong token", (int)411, (int)token);
        }
        catch (InvalidInputException e) {
            ScannerTest.assertTrue((boolean)false);
        }
    }

    public void testAt308() {
        char[] source = "class X<@Marker T> { }".toCharArray();
        IScanner scanner = ToolFactory.createScanner((boolean)false, (boolean)true, (boolean)false, (String)"17", (String)"17", (boolean)false);
        scanner.setSource(source);
        scanner.resetTo(0, source.length - 1);
        try {
            int token;
            while ((token = scanner.getNextToken()) != 158) {
                switch (token) {
                    case 5: 
                    case 69: 
                    case 165: 
                    case 1000: {
                        break;
                    }
                    case 401: {
                        return;
                    }
                    default: {
                        ScannerTest.fail((String)("Unexpected token " + token));
                    }
                }
            }
            ScannerTest.fail((String)"TokenNameAT was not detected");
        }
        catch (InvalidInputException e) {
            ScannerTest.assertTrue((boolean)false);
        }
    }

    public void testModule() {
        String source = "open module m1 {\n\trequires p1.m2;\n\trequires transitive p1.m3;\n\texports p2;\n}\n";
        IScanner scanner = ToolFactory.createScanner((boolean)false, (boolean)true, (boolean)false, (String)"9", (String)"9", (boolean)false);
        scanner.setSource(source.toCharArray());
        scanner.resetTo(0, source.length() - 1);
        try {
            int token;
            while ((token = scanner.getNextToken()) != 158) {
                switch (token) {
                    case 5: 
                    case 6: 
                    case 64: 
                    case 95: 
                    case 110: 
                    case 1000: {
                        break;
                    }
                    default: {
                        ScannerTest.fail((String)("Unexpected token " + token));
                    }
                }
            }
        }
        catch (InvalidInputException e) {
            ScannerTest.assertTrue((boolean)false);
        }
    }

    public void testWhenKO() {
        String source = "public void foo(Object obj) {\n switch(obj) {\n case String s when s.length() > 0 -> {}\n}\n}";
        IScanner scanner = ToolFactory.createScanner((boolean)false, (boolean)true, (boolean)false, (String)"19", (String)"19", (boolean)false);
        scanner.setSource(source.toCharArray());
        scanner.resetTo(source.indexOf("when") - 1, source.length() - 1);
        try {
            int token;
            while ((token = scanner.getNextToken()) != 158) {
                switch (token) {
                    case 1000: {
                        break;
                    }
                    case 5: {
                        return;
                    }
                    default: {
                        ScannerTest.fail((String)("Unexpected token " + token));
                    }
                }
            }
            ScannerTest.fail((String)"TokenNameRestrictedIdentifierYield was not detected");
        }
        catch (InvalidInputException e) {
            ScannerTest.assertTrue((boolean)false);
        }
    }

    public void testWhenAsIdentifier() {
        String source = "public void when(Object when) {\n\tPredicate<Object> condition = o -> when(o);\n\tSomeClass.when(condition).when();\n\tSomeClass./*comment*/when(condition,/*comment*/when(false)). when(true);\n}";
        IScanner scanner = ToolFactory.createScanner((boolean)true, (boolean)true, (boolean)true, (String)"19", (String)"19", (boolean)true);
        scanner.setSource(source.toCharArray());
        try {
            int token;
            while ((token = scanner.getNextToken()) != 158) {
                if (token != 415) continue;
                ScannerTest.fail((String)"TokenNameRestrictedIdentifierWhen must not be detected");
            }
        }
        catch (InvalidInputException e) {
            ScannerTest.assertTrue((boolean)false);
        }
    }

    public void testTerminalTokensAPIs() {
        char[][] ids = new char[][]{"when".toCharArray(), "record".toCharArray(), "sealed".toCharArray(), "permits".toCharArray(), "yield".toCharArray()};
        TerminalToken[] reskw = new TerminalToken[]{TerminalToken.TokenNameRestrictedIdentifierWhen, TerminalToken.TokenNameRestrictedIdentifierrecord, TerminalToken.TokenNameRestrictedIdentifiersealed, TerminalToken.TokenNameRestrictedIdentifierpermits, TerminalToken.TokenNameRestrictedIdentifierYield};
        int i = -1;
        char[][] cArrayArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            char[] id = cArrayArray[n2];
            TerminalToken t = TerminalToken.getRestrictedKeyword((char[])id);
            ScannerTest.assertTrue((t != TerminalToken.TokenNameNotAToken ? 1 : 0) != 0);
            ScannerTest.assertTrue((boolean)TerminalToken.isRestrictedKeyword((TerminalToken)t));
            ScannerTest.assertTrue((t == reskw[++i] ? 1 : 0) != 0);
            ++n2;
        }
        ScannerTest.assertTrue((TerminalToken.getRestrictedKeyword((char[])"When".toCharArray()) == TerminalToken.TokenNameNotAToken ? 1 : 0) != 0);
        ScannerTest.assertTrue((TerminalToken.getRestrictedKeyword((char[])"blah".toCharArray()) == TerminalToken.TokenNameNotAToken ? 1 : 0) != 0);
    }
}

