/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import junit.framework.Test;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest9;
import org.eclipse.jdt.core.tests.util.Util;
import org.eclipse.jdt.core.util.ClassFormatException;

public class SealedTypesTests
extends AbstractRegressionTest9 {
    public static Class<?> testClass() {
        return SealedTypesTests.class;
    }

    public static Test suite() {
        return SealedTypesTests.buildMinimalComplianceTestSuite(SealedTypesTests.testClass(), 16384);
    }

    public SealedTypesTests(String testName) {
        super(testName);
    }

    @Override
    protected void setUp() throws Exception {
        this.runJavacOptIn = true;
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        this.runJavacOptIn = false;
    }

    @Override
    protected Map<String, String> getCompilerOptions() {
        Map<String, String> defaultOptions = super.getCompilerOptions();
        defaultOptions.put("org.eclipse.jdt.core.compiler.storeAnnotations", "enabled");
        return defaultOptions;
    }

    @Override
    protected void runConformTest(String[] testFiles, String expectedOutput) {
        this.runConformTest(testFiles, expectedOutput, this.getCompilerOptions());
    }

    @Override
    protected void runConformTest(String[] testFiles, String expectedOutput, Map<String, String> customOptions) {
        Runner runner = new Runner();
        runner.testFiles = testFiles;
        runner.expectedOutputString = expectedOutput;
        runner.customOptions = customOptions;
        runner.runConformTest();
    }

    @Override
    protected void runNegativeTest(String[] testFiles, String expectedCompilerLog) {
        this.runNegativeTest(testFiles, expectedCompilerLog, AbstractRegressionTest.JavacTestOptions.DEFAULT);
    }

    protected void runWarningTest(String[] testFiles, String expectedCompilerLog) {
        this.runWarningTest(testFiles, expectedCompilerLog, (Map<String, String>)null);
    }

    protected void runWarningTest(String[] testFiles, String expectedCompilerLog, Map<String, String> customOptions) {
        Runner runner = new Runner();
        runner.testFiles = testFiles;
        runner.expectedCompilerLog = expectedCompilerLog;
        runner.customOptions = customOptions;
        runner.runWarningTest();
    }

    protected void runWarningTest(String[] testFiles, String expectedCompilerLog, String expectedOutput) {
        Runner runner = new Runner();
        runner.testFiles = testFiles;
        runner.expectedCompilerLog = expectedCompilerLog;
        runner.expectedOutputString = expectedOutput;
        runner.customOptions = this.getCompilerOptions();
        runner.runWarningTest();
    }

    public void testBug563430_001() {
        this.runConformTest(new String[]{"X.java", "sealed class Y permits X{}\nnon-sealed class X extends Y {\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\n"}, "0");
    }

    public void testBug563430_001a() {
        this.runConformTest(new String[]{"X.java", "non-sealed class X extends Y {\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\n", "Y.java", "sealed class Y permits X{}\n"}, "0");
    }

    public void testBug563430_002() {
        this.runConformTest(new String[]{"X.java", "sealed interface I extends SI{}\nnon-sealed class X implements SI{\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\nsealed interface SI permits X, I{}\nnon-sealed interface I2 extends I{}\n"}, "0");
    }

    public void testBug562715_001() {
        this.runConformTest(new String[]{"X.java", "sealed class X permits Y {\n  public static void main(String[] args){\n     System.out.println(100);\n  }\n}\nnon-sealed class Y extends X {\n}\n"}, "100");
    }

    public void testBug562715_002() {
        this.runConformTest(new String[]{"X.java", "public sealed class X {\n  public static void main(String[] args){\n     int sealed = 100;\n     System.out.println(sealed);\n  }\n}\nnon-sealed class Y extends X {\n}\n"}, "100");
    }

    public void testBug562715_003() {
        this.runConformTest(new String[]{"X.java", "sealed public class X {\n  public static void main(String[] args){\n     System.out.println(100);\n  }\n}\nnon-sealed class Y extends X {\n}\n"}, "100");
    }

    public void testBug562715_004() {
        this.runConformTest(new String[]{"X.java", "sealed interface I {}\nsealed public class X<T> {\n  public static void main(String[] args){\n     System.out.println(100);\n  }\n}\nnon-sealed class Y<T> extends X<T> {\n}\nnon-sealed interface I2 extends I {}\n"}, "100");
    }

    public void testBug562715_004a() {
        this.runConformTest(new String[]{"X.java", "sealed public class X<T> {\n  public static void main(String[] args){\n     System.out.println(100);\n  }\n}\nnon-sealed class Y extends X {\n}\n"}, "100");
    }

    public void testBug562715_005() {
        this.runNegativeTest(new String[]{"X.java", "sealed public sealed class X {\n  public static void main(String[] args){\n     System.out.println(100);\n  }\n}"}, "----------\n1. ERROR in X.java (at line 1)\n\tsealed public sealed class X {\n\t                           ^\nDuplicate modifier for the type X\n----------\n2. ERROR in X.java (at line 1)\n\tsealed public sealed class X {\n\t                           ^\nSealed type X lacks a permits clause and no type from the same compilation unit declares X as its direct supertype\n----------\n");
    }

    public void testBug562715_006() {
        this.runNegativeTest(new String[]{"X.java", "public sealed class X {\n  public static sealed void main(String[] args){\n     System.out.println(100);\n  }\n}"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic sealed class X {\n\t                    ^\nSealed type X lacks a permits clause and no type from the same compilation unit declares X as its direct supertype\n----------\n2. ERROR in X.java (at line 2)\n\tpublic static sealed void main(String[] args){\n\t              ^^^^^^\nSyntax error on token \"sealed\", static expected\n----------\n");
    }

    public void testBug562715_007() {
        this.runConformTest(new String[]{"X.java", "sealed @MyAnnot public class X {\n  public static void main(String[] args){\n     System.out.println(100);\n  }\n}\n@interface MyAnnot {}\nnon-sealed class Y extends X{}"}, "100");
    }

    public void testBug562715_008() {
        this.runConformTest(new String[]{"X.java", "sealed class X permits Y {\n  public static void main(String[] args){\n     System.out.println(100);\n  }\n}\nsealed class Y extends X {}\nfinal class Z extends Y {}\n"}, "100");
    }

    public void testBug562715_009() {
        this.runConformTest(new String[]{"X.java", "sealed class X permits Y,Z {\n  public static void main(String[] args){\n     System.out.println(100);\n  }\n}\nsealed class Y extends X {}\nfinal class Z extends X {}\nfinal class Y2 extends Y {}\n"}, "100");
    }

    public void testBug562715_010() {
        this.runNegativeTest(new String[]{"X.java", "public sealed class X permits {\n  public static void main(String[] args){\n     System.out.println(100);\n  }\n}"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic sealed class X permits {\n\t                    ^\nSealed type X lacks a permits clause and no type from the same compilation unit declares X as its direct supertype\n----------\n2. ERROR in X.java (at line 1)\n\tpublic sealed class X permits {\n\t                      ^^^^^^^\nSyntax error on token \"permits\", { expected\n----------\n3. ERROR in X.java (at line 1)\n\tpublic sealed class X permits {\n\t                              ^\nSyntax error, insert \"}\" to complete Block\n----------\n");
    }

    public void testBug562715_011() {
        this.runNegativeTest(new String[]{"X.java", "sealed enum Natural {ONE, TWO}\npublic sealed class X {\n  public static sealed void main(String[] args){\n     System.out.println(100);\n  }\n}"}, "----------\n1. ERROR in X.java (at line 1)\n\tsealed enum Natural {ONE, TWO}\n\t            ^^^^^^^\nIllegal modifier for the enum Natural; only public is permitted\n----------\n2. ERROR in X.java (at line 2)\n\tpublic sealed class X {\n\t                    ^\nSealed type X lacks a permits clause and no type from the same compilation unit declares X as its direct supertype\n----------\n3. ERROR in X.java (at line 3)\n\tpublic static sealed void main(String[] args){\n\t              ^^^^^^\nSyntax error on token \"sealed\", static expected\n----------\n");
    }

    public void testBug562715_xxx() {
        this.runNegativeTest(new String[]{"X.java", "sealed record R() {}\npublic sealed class X {\n  public static sealed void main(String[] args){\n     System.out.println(100);\n  }\n}"}, "----------\n1. ERROR in X.java (at line 1)\n\tsealed record R() {}\n\t              ^\nIllegal modifier for the record R; only public, final and strictfp are permitted\n----------\n2. ERROR in X.java (at line 2)\n\tpublic sealed class X {\n\t                    ^\nSealed type X lacks a permits clause and no type from the same compilation unit declares X as its direct supertype\n----------\n3. ERROR in X.java (at line 3)\n\tpublic static sealed void main(String[] args){\n\t              ^^^^^^\nSyntax error on token \"sealed\", static expected\n----------\n");
    }

    public void testBug563806_001() {
        this.runNegativeTest(new String[]{"X.java", "public sealed class X permits Y, Z{\n}\nclass Y {}\nclass Z {}"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic sealed class X permits Y, Z{\n\t                              ^\nPermitted type Y does not declare X as a direct supertype\n----------\n2. ERROR in X.java (at line 1)\n\tpublic sealed class X permits Y, Z{\n\t                                 ^\nPermitted type Z does not declare X as a direct supertype\n----------\n");
    }

    public void testBug563806_002() {
        this.runNegativeTest(new String[]{"p1/X.java", "package p1;\npublic sealed class X permits Y{\n}\nclass Y {}\nclass Z extends X{}", "p1/A.java", "package p1;\npublic sealed class A extends X{}"}, "----------\n1. ERROR in p1\\X.java (at line 2)\n\tpublic sealed class X permits Y{\n\t                              ^\nPermitted type Y does not declare p1.X as a direct supertype\n----------\n2. ERROR in p1\\X.java (at line 5)\n\tclass Z extends X{}\n\t      ^\nThe class Z with a sealed direct supertype X should be declared either final, sealed, or non-sealed\n----------\n3. ERROR in p1\\X.java (at line 5)\n\tclass Z extends X{}\n\t                ^\nThe class Z cannot extend the class X as it is not a permitted subtype of X\n----------\n----------\n1. ERROR in p1\\A.java (at line 2)\n\tpublic sealed class A extends X{}\n\t                    ^\nSealed type A lacks a permits clause and no type from the same compilation unit declares A as its direct supertype\n----------\n2. ERROR in p1\\A.java (at line 2)\n\tpublic sealed class A extends X{}\n\t                              ^\nThe class A cannot extend the class X as it is not a permitted subtype of X\n----------\n");
    }

    public void testBug563806_003() {
        this.runNegativeTest(new String[]{"X.java", "public sealed interface X permits Y, Z{\n}\nclass Y implements X{}\nclass Z {}"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic sealed interface X permits Y, Z{\n\t                                     ^\nPermitted type Z does not declare X as direct super interface \n----------\n2. ERROR in X.java (at line 3)\n\tclass Y implements X{}\n\t      ^\nThe class Y with a sealed direct supertype X should be declared either final, sealed, or non-sealed\n----------\n");
    }

    public void testBug563806_004() {
        this.runNegativeTest(new String[]{"p1/X.java", "package p1;\npublic sealed interface X permits Y, Z, Q{\n}\nclass Y implements X{}\ninterface Z {}"}, "----------\n1. ERROR in p1\\X.java (at line 2)\n\tpublic sealed interface X permits Y, Z, Q{\n\t                                     ^\nPermitted type Z does not declare p1.X as direct super interface \n----------\n2. ERROR in p1\\X.java (at line 2)\n\tpublic sealed interface X permits Y, Z, Q{\n\t                                        ^\nQ cannot be resolved to a type\n----------\n3. ERROR in p1\\X.java (at line 4)\n\tclass Y implements X{}\n\t      ^\nThe class Y with a sealed direct supertype X should be declared either final, sealed, or non-sealed\n----------\n");
    }

    public void testBug563806_005() {
        this.runNegativeTest(new String[]{"X.java", "public sealed class X permits Y, Y{\n}\nclass Y extends X {}"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic sealed class X permits Y, Y{\n\t                                 ^\nDuplicate permitted type Y\n----------\n2. ERROR in X.java (at line 3)\n\tclass Y extends X {}\n\t      ^\nThe class Y with a sealed direct supertype X should be declared either final, sealed, or non-sealed\n----------\n");
    }

    public void testBug563806_006() {
        this.runNegativeTest(new String[]{"p1/X.java", "package p1;\npublic sealed class X permits Y, p1.Y{\n}\nclass Y extends X {}"}, "----------\n1. ERROR in p1\\X.java (at line 2)\n\tpublic sealed class X permits Y, p1.Y{\n\t                                 ^^^^\nDuplicate permitted type Y\n----------\n2. ERROR in p1\\X.java (at line 4)\n\tclass Y extends X {}\n\t      ^\nThe class Y with a sealed direct supertype X should be declared either final, sealed, or non-sealed\n----------\n");
    }

    public void testBug563806_007() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n}\nnon-sealed class Y extends X {}"}, "----------\n1. ERROR in X.java (at line 3)\n\tnon-sealed class Y extends X {}\n\t                 ^\nThe non-sealed class Y must have a sealed direct supertype\n----------\n");
    }

    public void testBug563806_008() {
        this.runNegativeTest(new String[]{"p1/X.java", "package p1;\npublic sealed interface X permits Y {\n}\nclass Y implements X{}\n", "p2/Y.java", "package p2;\nnon-sealed public interface Y {}"}, "----------\n1. ERROR in p1\\X.java (at line 4)\n\tclass Y implements X{}\n\t      ^\nThe class Y with a sealed direct supertype X should be declared either final, sealed, or non-sealed\n----------\n----------\n1. ERROR in p2\\Y.java (at line 2)\n\tnon-sealed public interface Y {}\n\t                            ^\nThe non-sealed interface Y must have a sealed direct superinterface\n----------\n");
    }

    public void testBug563806_009() {
        this.runConformTest(new String[]{"X.java", "public sealed class X {\n  public static void main(String[] args){\n     System.out.println(100);\n  }\n}\nfinal class Y extends X {}"}, "100");
    }

    public void testBug563806_010() {
        this.runNegativeTest(new String[]{"p1/X.java", "package p1;\npublic sealed class X permits Y {\n}\nfinal class Y extends X{}\n", "p2/Y.java", "package p2;\npublic final class Y extends p1.X{}"}, "----------\n1. ERROR in p2\\Y.java (at line 2)\n\tpublic final class Y extends p1.X{}\n\t                             ^^^^\nThe class Y cannot extend the class X as it is not a permitted subtype of X\n----------\n");
    }

    public void testBug563806_011() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args) { \n    System.out.println(\"0\");\n  }\n}\nsealed interface Y {\n}\nfinal class Z implements Y {}"}, "0");
    }

    public void testBug563806_012() {
        this.runNegativeTest(new String[]{"p1/X.java", "package p1;\npublic sealed interface X permits Y {\n}\nfinal class Y implements X{}\n", "p2/Y.java", "package p2;\npublic final class Y implements p1.X{}"}, "----------\n1. ERROR in p2\\Y.java (at line 2)\n\tpublic final class Y implements p1.X{}\n\t                                ^^^^\nThe type Y that implements the sealed interface X should be a permitted subtype of X\n----------\n");
    }

    public void testBug563806_013() {
        this.runNegativeTest(new String[]{"X.java", "public sealed interface X {\n}\ninterface Y extends X {}"}, "----------\n1. ERROR in X.java (at line 3)\n\tinterface Y extends X {}\n\t          ^\nThe interface Y with a sealed direct superinterface X should be declared either sealed or non-sealed\n----------\n");
    }

    public void testBug563806_014() {
        this.runNegativeTest(new String[]{"p1/X.java", "package p1;\npublic sealed interface X permits Y {\n}\ninterface Y extends X{}\n", "p2/Y.java", "package p2;\npublic interface Y extends p1.X{}"}, "----------\n1. ERROR in p1\\X.java (at line 4)\n\tinterface Y extends X{}\n\t          ^\nThe interface Y with a sealed direct superinterface X should be declared either sealed or non-sealed\n----------\n----------\n1. ERROR in p2\\Y.java (at line 2)\n\tpublic interface Y extends p1.X{}\n\t                 ^\nThe interface Y with a sealed direct superinterface X should be declared either sealed or non-sealed\n----------\n2. ERROR in p2\\Y.java (at line 2)\n\tpublic interface Y extends p1.X{}\n\t                           ^^^^\nThe type Y that extends the sealed interface X should be a permitted subtype of X\n----------\n");
    }

    public void testBug563806_015() {
        this.runNegativeTest(new String[]{"X.java", "public class X permits Y{\n}\nfinal class Y extends X {}"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X permits Y{\n\t             ^\nA type declaration X that has a permits clause should have a sealed modifier\n----------\n");
    }

    public void testBug563806_016() {
        this.runNegativeTest(new String[]{"p1/X.java", "package p1;\npublic class X permits Y {\n}\nfinal class Y extends X{}\n"}, "----------\n1. ERROR in p1\\X.java (at line 2)\n\tpublic class X permits Y {\n\t             ^\nA type declaration X that has a permits clause should have a sealed modifier\n----------\n");
    }

    public void testBug563806_017() {
        this.runNegativeTest(new String[]{"X.java", "public interface X permits Y{\n}\nfinal class Y implements X {}"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic interface X permits Y{\n\t                 ^\nA type declaration X that has a permits clause should have a sealed modifier\n----------\n");
    }

    public void testBug563806_018() {
        this.runNegativeTest(new String[]{"p1/X.java", "package p1;\npublic interface X permits Y {\n}\nfinal class Y implements X{}\n"}, "----------\n1. ERROR in p1\\X.java (at line 2)\n\tpublic interface X permits Y {\n\t                 ^\nA type declaration X that has a permits clause should have a sealed modifier\n----------\n");
    }

    public void testBug563806_019() {
        this.runNegativeTest(new String[]{"p1/X.java", "package p1;\npublic sealed class X permits Y, p2.Y {\n}\nfinal class Y extends X{}\n", "p2/Y.java", "package p2;\npublic final class Y extends p1.X{}"}, "----------\n1. ERROR in p1\\X.java (at line 2)\n\tpublic sealed class X permits Y, p2.Y {\n\t                                 ^^^^\nPermitted type Y in an unnamed module should be declared in the same package p1 of declaring type X\n----------\n");
    }

    public void testBug563806_020() {
        this.runNegativeTest(new String[]{"p1/X.java", "package p1;\npublic sealed interface X permits Y, p2.Y {\n}\nfinal class Y implements X{}\n", "p2/Y.java", "package p2;\npublic final class Y implements p1.X{}"}, "----------\n1. ERROR in p1\\X.java (at line 2)\n\tpublic sealed interface X permits Y, p2.Y {\n\t                                     ^^^^\nPermitted type Y in an unnamed module should be declared in the same package p1 of declaring type X\n----------\n");
    }

    public void testBug563806_021() {
        this.runNegativeTest(new String[]{"p1/X.java", "package p1;\npublic sealed interface X permits Y, p2.Y {\n}\nnon-sealed interface Y extends X{}\n", "p2/Y.java", "package p2;\npublic non-sealed interface Y extends p1.X{}"}, "----------\n1. ERROR in p1\\X.java (at line 2)\n\tpublic sealed interface X permits Y, p2.Y {\n\t                                     ^^^^\nPermitted type Y in an unnamed module should be declared in the same package p1 of declaring type X\n----------\n");
    }

    public void testBug563806_022() {
        this.associateToModule("mod.one", "p1/X.java");
        this.associateToModule("mod.two", "p2/Y.java");
        Runner runner = new Runner();
        runner.testFiles = new String[]{"mod.one/module-info.java", "module mod.one {\nrequires mod.two;\n}\n", "mod.two/module-info.java", "module mod.two {\nexports p2;\n}\n", "p1/X.java", "package p1;\npublic sealed class X permits Y, p2.Y {\n}\nfinal class Y extends X{}\n", "p2/Y.java", "package p2;\npublic final class Y {}"};
        runner.expectedCompilerLog = "----------\n1. ERROR in p1\\X.java (at line 2)\n\tpublic sealed class X permits Y, p2.Y {\n\t                                 ^^^^\nPermitted type Y in a named module mod.one should be declared in the same module mod.one of declaring type X\n----------\n2. ERROR in p1\\X.java (at line 2)\n\tpublic sealed class X permits Y, p2.Y {\n\t                                 ^^^^\nPermitted type Y does not declare p1.X as a direct supertype\n----------\n";
        runner.runNegativeTest();
    }

    public void testBug563806_023() {
        this.associateToModule("mod.one", "p1/X.java");
        this.associateToModule("mod.two", "p2/Y.java");
        Runner runner = new Runner();
        runner.testFiles = new String[]{"mod.one/module-info.java", "module mod.one {\nrequires mod.two;\n}\n", "mod.two/module-info.java", "module mod.two {\nexports p2;\n}\n", "p1/X.java", "package p1;\npublic sealed interface X permits Y, p2.Y {\n}\nfinal class Y implements X{}\n", "p2/Y.java", "package p2;\npublic final class Y {}"};
        runner.expectedCompilerLog = "----------\n1. ERROR in p1\\X.java (at line 2)\n\tpublic sealed interface X permits Y, p2.Y {\n\t                                     ^^^^\nPermitted type Y in a named module mod.one should be declared in the same module mod.one of declaring type X\n----------\n2. ERROR in p1\\X.java (at line 2)\n\tpublic sealed interface X permits Y, p2.Y {\n\t                                     ^^^^\nPermitted type Y does not declare p1.X as direct super interface \n----------\n";
        runner.runNegativeTest();
    }

    public void testBug563806_024() {
        this.associateToModule("mod.one", "p1/X.java");
        this.associateToModule("mod.two", "p2/Y.java");
        Runner runner = new Runner();
        runner.testFiles = new String[]{"mod.one/module-info.java", "module mod.one {\nrequires mod.two;\n}\n", "mod.two/module-info.java", "module mod.two {\nexports p2;\n}\n", "p1/X.java", "package p1;\npublic sealed interface X permits Y, p2.Y {\n}\nnon-sealed interface Y extends X{}\n", "p2/Y.java", "package p2;\npublic interface Y {}"};
        runner.expectedCompilerLog = "----------\n1. ERROR in p1\\X.java (at line 2)\n\tpublic sealed interface X permits Y, p2.Y {\n\t                                     ^^^^\nPermitted type Y in a named module mod.one should be declared in the same module mod.one of declaring type X\n----------\n2. ERROR in p1\\X.java (at line 2)\n\tpublic sealed interface X permits Y, p2.Y {\n\t                                     ^^^^\nPermitted type Y does not declare p1.X as direct super interface \n----------\n";
        runner.runNegativeTest();
    }

    public void testBug563806_025() {
        this.associateToModule("mod.one", "p1/X.java");
        this.associateToModule("mod.one", "p2/Y.java");
        Runner runner = new Runner();
        runner.testFiles = new String[]{"mod.one/module-info.java", "module mod.one {\n}\n", "p1/X.java", "package p1;\npublic sealed class X permits Y, p2.Y {\n}\nfinal class Y extends X{}\n", "p2/Y.java", "package p2;\npublic final class Y extends p1.X{}"};
        runner.runConformTest();
    }

    public void testBug563806_026() {
        this.associateToModule("mod.one", "p1/X.java", "p2/Y.java");
        Runner runner = new Runner();
        runner.testFiles = new String[]{"mod.one/module-info.java", "module mod.one {\n}\n", "p1/X.java", "package p1;\npublic sealed interface X permits Y, p2.Y {\n}\nfinal class Y implements X{}\n", "p2/Y.java", "package p2;\npublic final class Y implements p1.X{}"};
        runner.runConformTest();
    }

    public void testBug563806_027() {
        this.associateToModule("mod.one", "p1/X.java");
        this.associateToModule("mod.one", "p2/Y.java");
        Runner runner = new Runner();
        runner.testFiles = new String[]{"mod.one/module-info.java", "module mod.one {\n}\n", "p1/X.java", "package p1;\npublic sealed interface X permits Y, p2.Y {\n}\nnon-sealed interface Y extends X{}\n", "p2/Y.java", "package p2;\npublic non-sealed interface Y extends p1.X {}"};
        runner.runConformTest();
    }

    public void testBug563806_028() {
        this.runNegativeTest(new String[]{"p1/X.java", "package p1;\npublic non-sealed enum X {\n}\n"}, "----------\n1. ERROR in p1\\X.java (at line 2)\n\tpublic non-sealed enum X {\n\t                       ^\nIllegal modifier for the enum X; only public is permitted\n----------\n");
    }

    public void testBug563806_029() {
        this.runNegativeTest(new String[]{"p1/X.java", "package p1;\npublic sealed enum X {\n}\n"}, "----------\n1. ERROR in p1\\X.java (at line 2)\n\tpublic sealed enum X {\n\t                   ^\nIllegal modifier for the enum X; only public is permitted\n----------\n");
    }

    public void testBug563806_030() {
        this.runNegativeTest(new String[]{"p1/X.java", "package p1;\npublic class X {\nstatic sealed enum Y {}\n}\n"}, "----------\n1. ERROR in p1\\X.java (at line 3)\n\tstatic sealed enum Y {}\n\t                   ^\nIllegal modifier for the member enum Y; only public, protected, private & static are permitted\n----------\n");
    }

    public void testBug563806_031() {
        this.runNegativeTest(new String[]{"p1/X.java", "package p1;\npublic class X {\nstatic non-sealed enum Y {}\n}\n"}, "----------\n1. ERROR in p1\\X.java (at line 3)\n\tstatic non-sealed enum Y {}\n\t                       ^\nIllegal modifier for the member enum Y; only public, protected, private & static are permitted\n----------\n");
    }

    public void testBug563806_032() {
        this.runNegativeTest(new String[]{"p1/X.java", "package p1;\npublic sealed non-sealed interface X {\n}\n"}, "----------\n1. ERROR in p1\\X.java (at line 2)\n\tpublic sealed non-sealed interface X {\n\t                                   ^\nThe type X may have only one modifier out of sealed, non-sealed, and final\n----------\n2. ERROR in p1\\X.java (at line 2)\n\tpublic sealed non-sealed interface X {\n\t                                   ^\nSealed type X lacks a permits clause and no type from the same compilation unit declares X as its direct supertype\n----------\n");
    }

    public void testBug563806_033() {
        this.runNegativeTest(new String[]{"p1/X.java", "package p1;\npublic sealed  @interface X {\n}\n"}, "----------\n1. ERROR in p1\\X.java (at line 2)\n\tpublic sealed  @interface X {\n\t       ^^^^^^\nSyntax error on token \"sealed\", static expected\n----------\n");
    }

    public void testBug563806_034() {
        this.runNegativeTest(new String[]{"p1/X.java", "package p1;\npublic  non-sealed @interface X {\n}\n"}, "----------\n1. ERROR in p1\\X.java (at line 1)\n\tpackage p1;\n\t^^^^^^^^^^^\nSyntax error on token(s), misplaced construct(s)\n----------\n2. ERROR in p1\\X.java (at line 2)\n\tpublic  non-sealed @interface X {\n\t        ^^^^^^^^^^\nSyntax error on tokens, delete these tokens\n----------\n");
    }

    public void testBug563806_035() {
        this.runNegativeTest(new String[]{"p1/X.java", "package p1;\npublic  non-sealed interface X {\n}\n"}, "----------\n1. ERROR in p1\\X.java (at line 2)\n\tpublic  non-sealed interface X {\n\t                             ^\nThe non-sealed interface X must have a sealed direct superinterface\n----------\n");
    }

    public void testBug563806_036() {
        this.runNegativeTest(new String[]{"p1/X.java", "package p1;\npublic  class X {\n  public void foo() {\n    sealed class Y{}\n  }\n}\n"}, "----------\n1. ERROR in p1\\X.java (at line 4)\n\tsealed class Y{}\n\t             ^\nIllegal modifier for the local class Y; only abstract or final is permitted\n----------\n");
    }

    public void testBug563806_037() {
        this.runNegativeTest(new String[]{"p1/X.java", "package p1;\npublic  class X {\n  public void foo() {\n    non-sealed class Y{}\n  }\n}\n"}, "----------\n1. ERROR in p1\\X.java (at line 4)\n\tnon-sealed class Y{}\n\t                 ^\nIllegal modifier for the local class Y; only abstract or final is permitted\n----------\n");
    }

    public void testBug563806_038() {
        this.runNegativeTest(new String[]{"p1/X.java", "package p1;\npublic  class X {\n  public void foo() {\n    non-sealed sealed class Y{}\n  }\n}\n"}, "----------\n1. ERROR in p1\\X.java (at line 4)\n\tnon-sealed sealed class Y{}\n\t                        ^\nThe type Y may have only one modifier out of sealed, non-sealed, and final\n----------\n2. ERROR in p1\\X.java (at line 4)\n\tnon-sealed sealed class Y{}\n\t                        ^\nIllegal modifier for the local class Y; only abstract or final is permitted\n----------\n");
    }

    public void testBug563806_039() {
        this.runNegativeTest(new String[]{"p1/X.java", "package p1;\nsealed class A{}\npublic  class X {\n  public void foo() {\n    class Y extends A{}\n  }\n}\n"}, "----------\n1. ERROR in p1\\X.java (at line 2)\n\tsealed class A{}\n\t             ^\nSealed type A lacks a permits clause and no type from the same compilation unit declares A as its direct supertype\n----------\n2. ERROR in p1\\X.java (at line 5)\n\tclass Y extends A{}\n\t                ^\nThe local type Y may not have a sealed supertype A\n----------\n");
    }

    public void testBug564191_001() throws IOException, ClassFormatException {
        this.runConformTest(new String[]{"p1/X.java", "package p1;\nsealed class X permits Y, Z{\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\nfinal class Y extends X{}\nfinal class Z extends X{}\n"}, "0");
        String expectedOutput = "PermittedSubclasses:\n   #33 p1/Y,\n   #35 p1/Z\n}";
        this.verifyClassFile(expectedOutput, "p1/X.class", 4);
    }

    public void testBug564190_1() throws IOException, ClassFormatException {
        this.runConformTest(new String[]{"p1/X.java", "package p1;\nsealed class X {\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\nfinal class Y extends X{}\nfinal class Z extends X{}\n"}, "0");
        String expectedOutput = "PermittedSubclasses:\n   #33 p1/Y,\n   #35 p1/Z\n}";
        this.verifyClassFile(expectedOutput, "p1/X.class", 4);
    }

    public void testBug564190_2() throws IOException, ClassFormatException {
        this.runConformTest(new String[]{"p1/X.java", "package p1;\nsealed class X {\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n  final class Y extends X{}\n  final class Z extends X{}\n}"}, "0");
        String expectedOutput = "PermittedSubclasses:\n   #33 p1/X$Y,\n   #35 p1/X$Z\n}";
        this.verifyClassFile(expectedOutput, "p1/X.class", 4);
    }

    public void testBug564190_3() throws IOException, ClassFormatException {
        this.runConformTest(new String[]{"p1/X.java", "package p1;\nsealed class X {\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n  non-sealed class Y extends X{}\n  non-sealed class Z extends X{}\n}"}, "0");
        String expectedOutput = "PermittedSubclasses:\n   #33 p1/X$Y,\n   #35 p1/X$Z\n}";
        this.verifyClassFile(expectedOutput, "p1/X.class", 4);
    }

    public void testBug564190_4() throws IOException, ClassFormatException {
        this.runNegativeTest(new String[]{"p1/X.java", "package p1;\nsealed class X  {\n\tclass Y extends X {}\n\tfinal class Z extends Y {}\n}"}, "----------\n1. ERROR in p1\\X.java (at line 3)\n\tclass Y extends X {}\n\t      ^\nThe class Y with a sealed direct supertype X should be declared either final, sealed, or non-sealed\n----------\n");
    }

    public void testBug564190_5() throws IOException, ClassFormatException {
        this.runNegativeTest(new String[]{"p1/X.java", "package p1;\nsealed class X {\n\tsealed class Y extends X {}\n\tfinal class Z {}\n}"}, "----------\n1. ERROR in p1\\X.java (at line 3)\n\tsealed class Y extends X {}\n\t             ^\nSealed type Y lacks a permits clause and no type from the same compilation unit declares Y as its direct supertype\n----------\n");
    }

    public void testBug564190_6() throws IOException, ClassFormatException {
        this.runNegativeTest(new String[]{"p1/X.java", "package p1;\nsealed class X  {\n\tsealed class Y extends X permits Z {}\n\tfinal class Z {}\n}"}, "----------\n1. ERROR in p1\\X.java (at line 3)\n\tsealed class Y extends X permits Z {}\n\t                                 ^\nPermitted type Z does not declare p1.X.Y as a direct supertype\n----------\n");
    }

    public void testBug564190_7() throws IOException, ClassFormatException {
        this.runNegativeTest(new String[]{"p1/X.java", "package p1;\nsealed interface SI {}"}, "----------\n1. ERROR in p1\\X.java (at line 2)\n\tsealed interface SI {}\n\t                 ^^\nSealed type SI lacks a permits clause and no type from the same compilation unit declares SI as its direct supertype\n----------\n");
    }

    public void testBug564450_001() throws IOException, ClassFormatException {
        this.runNegativeTest(new String[]{"p1/X.java", "package p1;\nsealed class X permits Y{\n}", "p1/Y.java", "package p1;\nclass Y extends X {\n}"}, "----------\n1. ERROR in p1\\Y.java (at line 2)\n\tclass Y extends X {\n\t      ^\nThe class Y with a sealed direct supertype X should be declared either final, sealed, or non-sealed\n----------\n");
    }

    public void testBug564047_001() throws CoreException, IOException {
        String outputDirectory = Util.getOutputDirectory();
        String lib1Path = outputDirectory + File.separator + "lib1.jar";
        try {
            try {
                Util.createJar(new String[]{"p/Y.java", "package p;\npublic sealed class Y permits Z{}", "p/Z.java", "package p;\npublic final class Z extends Y{}"}, lib1Path, "17", false);
                String[] libs = this.getDefaultClassPaths();
                int len = libs.length;
                String[] stringArray = libs;
                libs = new String[len + 1];
                System.arraycopy(stringArray, 0, libs, 0, len);
                libs[len] = lib1Path;
                this.runNegativeTest(new String[]{"src/p/X.java", "package p;\npublic class X extends Y {\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}"}, "----------\n1. ERROR in src\\p\\X.java (at line 2)\n\tpublic class X extends Y {\n\t             ^\nThe class X with a sealed direct supertype Y should be declared either final, sealed, or non-sealed\n----------\n2. ERROR in src\\p\\X.java (at line 2)\n\tpublic class X extends Y {\n\t                       ^\nThe class X cannot extend the class Y as it is not a permitted subtype of Y\n----------\n", libs, true);
            }
            catch (IOException e) {
                System.err.println("could not write to current working directory ");
                new File(lib1Path).delete();
            }
        }
        finally {
            new File(lib1Path).delete();
        }
    }

    public void testBug564492_001() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args){\n     new Y(){};\n  }\n}\nsealed class Y{}\nfinal class Z extends Y {\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tnew Y(){};\n\t    ^\nAn anonymous class cannot subclass a sealed type Y\n----------\n");
    }

    public void testBug564492_002() {
        this.runNegativeTest(new String[]{"X.java", "public class X  {\n   public static void main(String[] args) {\n        IY y = new IY(){};\n   }\n}\nsealed interface I {}\nsealed interface IY extends I {}\nfinal class Z implements IY{}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tIY y = new IY(){};\n\t           ^^\nAn anonymous class cannot subclass a sealed type IY\n----------\n");
    }

    public void testBug564492_003() {
        this.runNegativeTest(new String[]{"X.java", "public sealed class X permits A.Y {\n       public static void main(String[] args) {\n               new A.Y() {};\n       }\n}\n \nclass A {\n       static sealed class Y extends X permits Z {}\n       final class Z extends Y{}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tnew A.Y() {};\n\t    ^^^\nAn anonymous class cannot subclass a sealed type A.Y\n----------\n");
    }

    public void testBug564492_004() {
        this.runNegativeTest(new String[]{"X.java", "public  class X {\n       public static void main(String[] args) {\n               new A.IY() {};\n       }\n}\n \nclass A {\n       sealed interface I permits IY{}\n       sealed interface IY extends I permits Z {}\n       final class Z implements IY{}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tnew A.IY() {};\n\t    ^^^^\nAn anonymous class cannot subclass a sealed type A.IY\n----------\n");
    }

    public void testBug564498_1() throws IOException, ClassFormatException {
        this.runConformTest(new String[]{"p1/X.java", "package p1;\npublic sealed class X permits A.Y {\n\tpublic static void main(String[] args) {}\n}\nclass A {\n\tsealed class Y extends X {\n\t\tfinal class SubInnerY extends Y {}\n\t} \n\tfinal class Z extends Y {}\n}"}, "");
        String expectedOutput = "PermittedSubclasses:\n   #24 p1/A$Y$SubInnerY,\n   #26 p1/A$Z\n}";
        this.verifyClassFile(expectedOutput, "p1/A$Y.class", 4);
        expectedOutput = "PermittedSubclasses:\n   #21 p1/A$Y\n";
        this.verifyClassFile(expectedOutput, "p1/X.class", 4);
    }

    public void testBug564498_2() throws IOException, ClassFormatException {
        this.runConformTest(new String[]{"p1/X.java", "package p1;\npublic sealed class X permits A.Y {\n\tpublic static void main(String[] args) {}\n}\nclass A {\n\tsealed class Y extends X {} \n\tfinal class Z extends Y {}\n   final class SubY extends Y {}}"}, "");
        String expectedOutput = "PermittedSubclasses:\n   #22 p1/A$SubY,\n   #24 p1/A$Z\n}";
        this.verifyClassFile(expectedOutput, "p1/A$Y.class", 4);
        expectedOutput = "PermittedSubclasses:\n   #21 p1/A$Y\n";
        this.verifyClassFile(expectedOutput, "p1/X.class", 4);
    }

    public void testBug564498_3() throws IOException, ClassFormatException {
        this.runConformTest(new String[]{"p1/X.java", "package p1;\npublic sealed class X permits A.Y {\n\tpublic static void main(String[] args) {}\n}\nclass A {\n\tsealed class Y extends X {\n\t\tfinal class SubInnerY extends Y {}\n\t} \n\tfinal class Z extends Y {}\n   final class SubY extends Y {}}"}, "");
        String expectedOutput = "PermittedSubclasses:\n   #24 p1/A$SubY,\n   #26 p1/A$Y$SubInnerY,\n   #28 p1/A$Z\n";
        this.verifyClassFile(expectedOutput, "p1/A$Y.class", 4);
    }

    public void testBug564498_4() throws IOException, ClassFormatException {
        this.runConformTest(new String[]{"p1/X.java", "package p1;\npublic sealed class X permits A.Y {\n\tpublic static void main(String[] args) {}\n}\nclass A {\n\tsealed class Y extends X permits Y.SubInnerY {\n\t\tfinal class SubInnerY extends Y {}\n\t} \n}"}, "");
        String expectedOutput = "PermittedSubclasses:\n   #24 p1/A$Y$SubInnerY\n";
        this.verifyClassFile(expectedOutput, "p1/A$Y.class", 4);
    }

    public void testBug564498_5() throws IOException, ClassFormatException {
        this.runNegativeTest(new String[]{"p1/X.java", "package p1;\npublic sealed class X permits A.Y {\n\tpublic static void main(String[] args) {}\n}\nclass A {\n\tsealed class Y extends X permits SubInnerY {\n\t\tfinal class SubInnerY extends Y {}\n\t} \n}"}, "----------\n1. ERROR in p1\\X.java (at line 6)\n\tsealed class Y extends X permits SubInnerY {\n\t                                 ^^^^^^^^^\nSubInnerY cannot be resolved to a type\n----------\n2. ERROR in p1\\X.java (at line 7)\n\tfinal class SubInnerY extends Y {}\n\t                              ^\nThe class SubInnerY cannot extend the class A.Y as it is not a permitted subtype of A.Y\n----------\n");
    }

    public void testBug564498_6() throws IOException, ClassFormatException {
        this.runConformTest(new String[]{"p1/X.java", "package p1;\nimport p1.Y.Z;\npublic class X {\n\tpublic static void main(String[] args) {}\n}\nsealed class Y permits Z {\n\tfinal class Z extends Y {}\n}"}, "");
    }

    public void testBug564613_001() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\n       public boolean permits( String s ) {\n               return true;\n       }\n       public static void main(String[] args) {\n               boolean b = new X().permits(\"hello\");\n               System.out.println(b ? \"Hello\" : \"World\");\n       }\n}"}, "Hello");
    }

    public void testBug564613_002() {
        this.runNegativeTest(new String[]{"X.java", "public sealed class X permits permits Y, Z {}\nfinal class Y extends X{}\nfinal class Z extends X{}"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic sealed class X permits permits Y, Z {}\n\t                      ^^^^^^^\nSyntax error on token \"permits\", delete this token\n----------\n");
    }

    public void testBug564638_001() {
        this.runNegativeTest(new String[]{"X.java", "class permits {\n  void foo() {\n    Zork();\n  }\n}"}, "----------\n1. ERROR in X.java (at line 1)\n\tclass permits {\n\t      ^^^^^^^\n'permits' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n2. ERROR in X.java (at line 3)\n\tZork();\n\t^^^^\nThe method Zork() is undefined for the type permits\n----------\n", null, true);
    }

    public void testBug564638_002() {
        this.runNegativeTest(new String[]{"X.java", "class permits {\n  void foo() {\n    Zork();\n  }\n}"}, "----------\n1. ERROR in X.java (at line 1)\n\tclass permits {\n\t      ^^^^^^^\n'permits' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n2. ERROR in X.java (at line 3)\n\tZork();\n\t^^^^\nThe method Zork() is undefined for the type permits\n----------\n");
    }

    public void testBug564638_003() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n  permits p;\n  void foo() {\n    Zork();\n  }\n}", "permits.java", "public class permits {\n}"}, "----------\n----------\n1. ERROR in X.java (at line 2)\n\tpermits p;\n\t^^^^^^^\n'permits' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n2. ERROR in X.java (at line 4)\n\tZork();\n\t^^^^\nThe method Zork() is undefined for the type X\n----------\n----------\n1. ERROR in permits.java (at line 1)\n\tpublic class permits {\n\t             ^^^^^^^\n'permits' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n", null, true);
    }

    public void testBug564638_004() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n  permits p;\n  void foo() {\n    Zork();\n  }\n}", "permits.java", "public class permits {\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\tpermits p;\n\t^^^^^^^\n'permits' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n2. ERROR in X.java (at line 4)\n\tZork();\n\t^^^^\nThe method Zork() is undefined for the type X\n----------\n----------\n1. ERROR in permits.java (at line 1)\n\tpublic class permits {\n\t             ^^^^^^^\n'permits' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n");
    }

    public void testBug564638_005() {
        this.runNegativeTest(new String[]{"X.java", "class X<permits> {\n  void foo() {\n    Zork();\n  }\n}"}, "----------\n1. ERROR in X.java (at line 1)\n\tclass X<permits> {\n\t        ^^^^^^^\n'permits' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n2. ERROR in X.java (at line 3)\n\tZork();\n\t^^^^\nThe method Zork() is undefined for the type X<permits>\n----------\n", null, true);
    }

    public void testBug564638_006() {
        this.runNegativeTest(new String[]{"X.java", "class X<permits> {\n  void foo() {\n    Zork();\n  }\n}"}, "----------\n1. ERROR in X.java (at line 1)\n\tclass X<permits> {\n\t        ^^^^^^^\n'permits' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n2. ERROR in X.java (at line 3)\n\tZork();\n\t^^^^\nThe method Zork() is undefined for the type X<permits>\n----------\n");
    }

    public void testBug564638_007() {
        this.runNegativeTest(new String[]{"X.java", "class X extends permits {\n  void foo() {\n    Zork();\n  }\n}\nclass permits {\n}"}, "----------\n1. ERROR in X.java (at line 1)\n\tclass X extends permits {\n\t                ^^^^^^^\n'permits' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n2. ERROR in X.java (at line 3)\n\tZork();\n\t^^^^\nThe method Zork() is undefined for the type X\n----------\n3. ERROR in X.java (at line 6)\n\tclass permits {\n\t      ^^^^^^^\n'permits' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n");
    }

    public void testBug564638_008() {
        this.runNegativeTest(new String[]{"X.java", "class X extends permits {\n  void foo() {\n    Zork();\n  }\n}\nclass permits {\n}"}, "----------\n1. ERROR in X.java (at line 1)\n\tclass X extends permits {\n\t                ^^^^^^^\n'permits' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n2. ERROR in X.java (at line 3)\n\tZork();\n\t^^^^\nThe method Zork() is undefined for the type X\n----------\n3. ERROR in X.java (at line 6)\n\tclass permits {\n\t      ^^^^^^^\n'permits' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n", null, true);
    }

    public void testBug564638_009() {
        this.runNegativeTest(new String[]{"X.java", "class X implements permits {\n  void foo() {\n    Zork();\n  }\n}\ninterface permits {\n}"}, "----------\n1. ERROR in X.java (at line 1)\n\tclass X implements permits {\n\t                   ^^^^^^^\n'permits' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n2. ERROR in X.java (at line 3)\n\tZork();\n\t^^^^\nThe method Zork() is undefined for the type X\n----------\n3. ERROR in X.java (at line 6)\n\tinterface permits {\n\t          ^^^^^^^\n'permits' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n");
    }

    public void testBug564638_010() {
        this.runNegativeTest(new String[]{"X.java", "class X implements permits {\n  void foo() {\n    Zork();\n  }\n}\ninterface permits {\n}"}, "----------\n1. ERROR in X.java (at line 1)\n\tclass X implements permits {\n\t                   ^^^^^^^\n'permits' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n2. ERROR in X.java (at line 3)\n\tZork();\n\t^^^^\nThe method Zork() is undefined for the type X\n----------\n3. ERROR in X.java (at line 6)\n\tinterface permits {\n\t          ^^^^^^^\n'permits' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n", null, true);
    }

    public void testBug564638_011() {
        this.runNegativeTest(new String[]{"X.java", "interface X extends permits {\n  default void foo() {\n    Zork();\n  }\n}\ninterface permits {\n}"}, "----------\n1. ERROR in X.java (at line 1)\n\tinterface X extends permits {\n\t                    ^^^^^^^\n'permits' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n2. ERROR in X.java (at line 3)\n\tZork();\n\t^^^^\nThe method Zork() is undefined for the type X\n----------\n3. ERROR in X.java (at line 6)\n\tinterface permits {\n\t          ^^^^^^^\n'permits' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n");
    }

    public void testBug564638_012() {
        this.runNegativeTest(new String[]{"X.java", "interface X extends permits {\n  default void foo() {\n    Zork();\n  }\n}\ninterface permits {\n}"}, "----------\n1. ERROR in X.java (at line 1)\n\tinterface X extends permits {\n\t                    ^^^^^^^\n'permits' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n2. ERROR in X.java (at line 3)\n\tZork();\n\t^^^^\nThe method Zork() is undefined for the type X\n----------\n3. ERROR in X.java (at line 6)\n\tinterface permits {\n\t          ^^^^^^^\n'permits' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n", null, true);
    }

    public void testBug564638_013() {
        this.runNegativeTest(new String[]{"X.java", "class X extends {\n  permits foo() {\n    Zork();\n    return null;\n  }\n}"}, "----------\n1. ERROR in X.java (at line 1)\n\tclass X extends {\n\t        ^^^^^^^\nSyntax error on token \"extends\", Type expected after this token\n----------\n2. ERROR in X.java (at line 2)\n\tpermits foo() {\n\t^^^^^^^\n'permits' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n3. ERROR in X.java (at line 3)\n\tZork();\n\t^^^^\nThe method Zork() is undefined for the type X\n----------\n");
    }

    public void testBug564638_014() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n  permits foo() {\n    Zork();\n    return null;\n  }\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\tpermits foo() {\n\t^^^^^^^\n'permits' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n3. ERROR in X.java (at line 3)\n\tZork();\n\t^^^^\nThe method Zork() is undefined for the type X\n----------\n", null, true);
    }

    public void testBug564638_015() {
        this.runNegativeTest(new String[]{"X.java", "class X  {\n  void foo() throws permits{\n    Zork();\n  }\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\tvoid foo() throws permits{\n\t                  ^^^^^^^\n'permits' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n2. ERROR in X.java (at line 3)\n\tZork();\n\t^^^^\nThe method Zork() is undefined for the type X\n----------\n");
    }

    public void testBug564638_016() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n  void foo() throws permits{\n    Zork();\n  }\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\tvoid foo() throws permits{\n\t                  ^^^^^^^\n'permits' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n3. ERROR in X.java (at line 3)\n\tZork();\n\t^^^^\nThe method Zork() is undefined for the type X\n----------\n", null, true);
    }

    public void testBug564638_017() {
        this.runNegativeTest(new String[]{"X.java", "class X <T extends permits> {\n  <T> void foo(T extends permits) {\n    Zork();\n  }\n}"}, "----------\n1. ERROR in X.java (at line 1)\n\tclass X <T extends permits> {\n\t                   ^^^^^^^\n'permits' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n2. ERROR in X.java (at line 1)\n\tclass X <T extends permits> {\n\t                            ^\nSyntax error, insert \"}\" to complete ClassBody\n----------\n3. WARNING in X.java (at line 2)\n\t<T> void foo(T extends permits) {\n\t ^\nThe type parameter T is hiding the type T\n----------\n4. ERROR in X.java (at line 2)\n\t<T> void foo(T extends permits) {\n\t               ^^^^^^^\nSyntax error on token \"extends\", delete this token\n----------\n5. ERROR in X.java (at line 5)\n\t}\n\t^\nSyntax error on token \"}\", delete this token\n----------\n");
    }

    public void testBug564638_018() {
        this.runNegativeTest(new String[]{"X.java", "class X <T extends permits>{\n  <T> void foo(T extends permits) {\n    Zork();\n  }\n}"}, "----------\n1. ERROR in X.java (at line 1)\n\tclass X <T extends permits>{\n\t                   ^^^^^^^\n'permits' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n3. ERROR in X.java (at line 1)\n\tclass X <T extends permits>{\n\t                           ^\nSyntax error, insert \"}\" to complete ClassBody\n----------\n4. WARNING in X.java (at line 2)\n\t<T> void foo(T extends permits) {\n\t ^\nThe type parameter T is hiding the type T\n----------\n5. ERROR in X.java (at line 2)\n\t<T> void foo(T extends permits) {\n\t               ^^^^^^^\nSyntax error on token \"extends\", delete this token\n----------\n6. ERROR in X.java (at line 5)\n\t}\n\t^\nSyntax error on token \"}\", delete this token\n----------\n", null, true);
    }

    public void testBug564638_019() {
        this.runNegativeTest(new String[]{"X.java", "enum X {\n  ONE(1);\n  private final permits p;\n  X(int p) {\n    Zork();\n  }\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tprivate final permits p;\n\t              ^^^^^^^\n'permits' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n2. ERROR in X.java (at line 5)\n\tZork();\n\t^^^^\nThe method Zork() is undefined for the type X\n----------\n");
    }

    public void testBug564638_020() {
        this.runNegativeTest(new String[]{"X.java", "enum X {\n  ONE(1);\n  private final permits p;\n  X(int p) {\n    Zork();\n  }\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tprivate final permits p;\n\t              ^^^^^^^\n'permits' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n3. ERROR in X.java (at line 5)\n\tZork();\n\t^^^^\nThe method Zork() is undefined for the type X\n----------\n", null, true);
    }

    public void testBug564638_021() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n  public static void main(String[] args) {\n    I i = (permits p)-> {};\n  }\n}\ninterface I {\n  void apply(Object o);\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tI i = (permits p)-> {};\n\t      ^^^^^^^^^^^^^\nThis lambda expression refers to the missing type permits\n----------\n2. ERROR in X.java (at line 3)\n\tI i = (permits p)-> {};\n\t       ^^^^^^^\n'permits' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n");
    }

    public void testBug564638_022() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n  public static void main(String[] args) {\n    I i = (permits p)-> {};\n    Zork();\n  }\n}\ninterface I {\n  void apply(Object o);\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tI i = (permits p)-> {};\n\t      ^^^^^^^^^^^^^\nThis lambda expression refers to the missing type permits\n----------\n2. ERROR in X.java (at line 3)\n\tI i = (permits p)-> {};\n\t       ^^^^^^^\n'permits' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n4. ERROR in X.java (at line 4)\n\tZork();\n\t^^^^\nThe method Zork() is undefined for the type X\n----------\n", null, true);
    }

    public void testBug564638_023() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n  public void foo(permits this) {}\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\tpublic void foo(permits this) {}\n\t                ^^^^^^^\n'permits' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n");
    }

    public void testBug564638_024() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n  public void foo(permits this) {}\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\tpublic void foo(permits this) {}\n\t                ^^^^^^^\n'permits' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n", null, true);
    }

    public void testBug564638_025() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n  public void foo(permits this) {}\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\tpublic void foo(permits this) {}\n\t                ^^^^^^^\n'permits' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n");
    }

    public void testBug564638_026() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n  public void foo(permits this) {}\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\tpublic void foo(permits this) {}\n\t                ^^^^^^^\n'permits' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n", null, true);
    }

    public void testBug564638_027() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n  class permits {\n     public void foo(permits this) {}\n  }\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\tclass permits {\n\t      ^^^^^^^\n'permits' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n2. ERROR in X.java (at line 3)\n\tpublic void foo(permits this) {}\n\t                ^^^^^^^\n'permits' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n");
    }

    public void testBug564638_028() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n  class permits {\n     public void foo(permits this) {}\n  }\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\tclass permits {\n\t      ^^^^^^^\n'permits' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n2. ERROR in X.java (at line 3)\n\tpublic void foo(permits this) {}\n\t                ^^^^^^^\n'permits' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n", null, true);
    }

    public void testBug564638_029() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n  public static void main(String[] args) {\n    permits p;\n    Zork();\n  }\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tpermits p;\n\t^^^^^^^\n'permits' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n2. ERROR in X.java (at line 4)\n\tZork();\n\t^^^^\nThe method Zork() is undefined for the type X\n----------\n");
    }

    public void testBug564638_030() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n  public static void main(String[] args) {\n    permits p;\n    Zork();\n  }\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tpermits p;\n\t^^^^^^^\n'permits' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n3. ERROR in X.java (at line 4)\n\tZork();\n\t^^^^\nThe method Zork() is undefined for the type X\n----------\n", null, true);
    }

    public void testBug564638_031() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n  public static void main(String[] args) {\n    for (permits i = 0; i < 10; ++i) {} \n  }\n  void foo() {\n    Zork();\n  }\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tfor (permits i = 0; i < 10; ++i) {} \n\t     ^^^^^^^\n'permits' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n2. ERROR in X.java (at line 6)\n\tZork();\n\t^^^^\nThe method Zork() is undefined for the type X\n----------\n");
    }

    public void testBug564638_032() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n  public static void main(String[] args) {\n    for (permits i = 0; i < 10; ++i) {} \n  }\n  void foo() {\n    Zork();\n  }\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tfor (permits i = 0; i < 10; ++i) {} \n\t     ^^^^^^^\n'permits' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n3. ERROR in X.java (at line 6)\n\tZork();\n\t^^^^\nThe method Zork() is undefined for the type X\n----------\n", null, true);
    }

    public void testBug564638_033() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n  public static void main(permits[] args) {\n    for (permits p : args) {} \n  }\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\tpublic static void main(permits[] args) {\n\t                        ^^^^^^^^^\n'permits' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n2. ERROR in X.java (at line 3)\n\tfor (permits p : args) {} \n\t     ^^^^^^^\n'permits' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n");
    }

    public void testBug564638_034() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n  public static void main(permits[] args) {\n    for (permits p : args) {} \n  }\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\tpublic static void main(permits[] args) {\n\t                        ^^^^^^^^^\n'permits' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n3. ERROR in X.java (at line 3)\n\tfor (permits p : args) {} \n\t     ^^^^^^^\n'permits' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n", null, true);
    }

    public void testBug564638_035() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n       public static void main(String[] args) {\n               try (permits y = new Y()) {\n                       \n               } catch (Exception e) {\n                       e.printStackTrace();\n               } finally {\n                       \n               }\n       }\n}\nclass Y implements AutoCloseable {\n       @Override\n       public void close() throws Exception {}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\ttry (permits y = new Y()) {\n\t     ^^^^^^^\n'permits' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n");
    }

    public void testBug564638_036() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n       public static void main(String[] args) {\n               try (permits y = new Y()) {\n                       \n               } catch (Exception e) {\n                       e.printStackTrace();\n               } finally {\n                       \n               }\n       }\n}\nclass Y implements AutoCloseable {\n       @Override\n       public void close() throws Exception {}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\ttry (permits y = new Y()) {\n\t     ^^^^^^^\n'permits' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n", null, true);
    }

    public void testBug564638_037() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n       public static void main(String[] args) {\n               try (Y y = new Y()) {\n                       \n               } catch (permits e) {\n                       e.printStackTrace();\n               } finally {\n                       \n               }\n       }\n}\nclass Y implements AutoCloseable {\n       @Override\n       public void close() throws Exception {}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\t} catch (permits e) {\n\t         ^^^^^^^\n'permits' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n");
    }

    public void testBug564638_038() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n       public static void main(String[] args) {\n               try (Y y = new Y()) {\n                       \n               } catch (permits e) {\n                       e.printStackTrace();\n               } finally {\n                       \n               }\n       }\n}\nclass Y implements AutoCloseable {\n       @Override\n       public void close() throws Exception {}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\t} catch (permits e) {\n\t         ^^^^^^^\n'permits' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n", null, true);
    }

    public void testBug564638_039() {
        this.runNegativeTest(new String[]{"X.java", "record X(permits p) {\n}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\trecord X(permits p) {\n\t         ^^^^^^^\n'permits' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n");
    }

    public void testBug564638_040() {
        this.runNegativeTest(new String[]{"X.java", "record X(permits p) {\n}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\trecord X(permits p) {\n\t         ^^^^^^^\n'permits' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n", null, true);
    }

    public void testBug564638_041() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n       public <T> X(T t) {}\n       \n       public X(int t, char c) {\n               <permits>this(t);\n       }\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\t<permits>this(t);\n\t ^^^^^^^\n'permits' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n2. ERROR in X.java (at line 5)\n\t<permits>this(t);\n\t         ^^^^^^^^\nThe constructor X(permits) refers to the missing type permits\n----------\n");
    }

    public void testBug564638_042() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n       public <T> X(T t) {}\n       \n       public X(int t, char c) {\n               <permits>this(t);\n       }\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\t<permits>this(t);\n\t ^^^^^^^\n'permits' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n3. ERROR in X.java (at line 5)\n\t<permits>this(t);\n\t         ^^^^^^^^\nThe constructor X(permits) refers to the missing type permits\n----------\n", null, true);
    }

    public void testBug564638_043() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n       public <T> X(T t) {}\n       \n       public X(int t, char c) {\n           new <permits>X(t).foo();\n       }\n       public void foo() {}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tnew <permits>X(t).foo();\n\t^^^^^^^^^^^^^^^^^\nThe constructor X(permits) refers to the missing type permits\n----------\n2. ERROR in X.java (at line 5)\n\tnew <permits>X(t).foo();\n\t     ^^^^^^^\n'permits' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n");
    }

    public void testBug564638_044() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n       public <T> X(T t) {}\n       \n       public X(int t, char c) {\n           new <permits>X(t).foo();\n       }\n       public void foo() {}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tnew <permits>X(t).foo();\n\t^^^^^^^^^^^^^^^^^\nThe constructor X(permits) refers to the missing type permits\n----------\n2. ERROR in X.java (at line 5)\n\tnew <permits>X(t).foo();\n\t     ^^^^^^^\n'permits' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n", null, true);
    }

    public void testBug564638_045() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n       public <T> void foo(T t) {}\n       \n       public X() {\n               X x = new X();\n               x.<permits>foo(0);\n       }\n}"}, "----------\n1. ERROR in X.java (at line 6)\n\tx.<permits>foo(0);\n\t   ^^^^^^^\n'permits' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n2. ERROR in X.java (at line 6)\n\tx.<permits>foo(0);\n\t           ^^^\nThe method foo(permits) from the type X refers to the missing type permits\n----------\n");
    }

    public void testBug564638_046() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n       public <T> void foo(T t) {}\n       \n       public X() {\n               X x = new X();\n               x.<permits>foo(0);\n       }\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tx.<permits>foo(0);\n\t   ^^^^^^^\n'permits' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n3. ERROR in X.java (at line 6)\n\tx.<permits>foo(0);\n\t           ^^^\nThe method foo(permits) from the type X refers to the missing type permits\n----------\n", null, true);
    }

    public void testBug564638_047() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n       public <T> void foo(T t) {}\n       \n       public X() {\n               X x = new permits();\n       }\n}"}, "----------\n1. ERROR in X.java (at line 5)\n\tX x = new permits();\n\t          ^^^^^^^\n'permits' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n");
    }

    public void testBug564638_048() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n       public <T> void foo(T t) {}\n       \n       public X() {\n               X x = new permits();\n       }\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tX x = new permits();\n\t          ^^^^^^^\n'permits' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n", null, true);
    }

    public void testBug564638_049() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n       public X() {\n               new permits() {\n                       @Override\n                       void foo() {}\n               }.foo();\n       }\n}\nabstract class permits {\n       abstract void foo();\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tnew permits() {\n\t    ^^^^^^^\n'permits' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n2. ERROR in X.java (at line 9)\n\tabstract class permits {\n\t               ^^^^^^^\n'permits' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n");
    }

    public void testBug564638_050() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n    public X() {\n       new permits() {\n          @Override\n          void foo() {\n            Zork();\n          }\n       }.foo();\n       }\n}\nabstract class permits {\n       abstract void foo();\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tnew permits() {\n\t    ^^^^^^^\n'permits' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n2. ERROR in X.java (at line 6)\n\tZork();\n\t^^^^\nThe method Zork() is undefined for the type new permits(){}\n----------\n3. ERROR in X.java (at line 11)\n\tabstract class permits {\n\t               ^^^^^^^\n'permits' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n", null, true);
    }

    public void testBug564638_051() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n  public X() {\n    Object[] p = new permits[10];\n  }\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tObject[] p = new permits[10];\n\t                 ^^^^^^^\n'permits' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n");
    }

    public void testBug564638_052() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n  public X() {\n    Object[] p = new permits[10];\n  }\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tObject[] p = new permits[10];\n\t                 ^^^^^^^\n'permits' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n", null, true);
    }

    public void testBug564638_053() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n public static void main(String[] args) {\n   new X().foo((permits) null);\n }\n private void foo(permits o) {}\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tnew X().foo((permits) null);\n\t        ^^^\nThe method foo(permits) from the type X refers to the missing type permits\n----------\n2. ERROR in X.java (at line 3)\n\tnew X().foo((permits) null);\n\t             ^^^^^^^\n'permits' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n3. ERROR in X.java (at line 5)\n\tprivate void foo(permits o) {}\n\t                 ^^^^^^^\n'permits' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n");
    }

    public void testBug564638_054() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n public static void main(String[] args) {\n   new X().foo((permits) null);\n }\n private void foo(permits o) {}\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tnew X().foo((permits) null);\n\t        ^^^\nThe method foo(permits) from the type X refers to the missing type permits\n----------\n2. ERROR in X.java (at line 3)\n\tnew X().foo((permits) null);\n\t             ^^^^^^^\n'permits' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n4. ERROR in X.java (at line 5)\n\tprivate void foo(permits o) {}\n\t                 ^^^^^^^\n'permits' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n", null, true);
    }

    public void testBug564638_055() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n private void foo(Object o) {\n   if (o instanceof permits) {}\n }\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tif (o instanceof permits) {}\n\t                 ^^^^^^^\n'permits' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n");
    }

    public void testBug564638_056() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n private void foo(Object o) {\n   if (o instanceof permits) {}\n }\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tif (o instanceof permits) {}\n\t                 ^^^^^^^\n'permits' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n", null, true);
    }

    public void testBug564638_057() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n public static void main(String[] args) {\n   @SuppressWarnings(\"unused\")\n   I i = permits :: new;\n   Zork();\n }\n}\nclass permits{}\ninterface I {\n Object gen();\n}"}, "----------\n1. ERROR in X.java (at line 5)\n\tZork();\n\t^^^^\nThe method Zork() is undefined for the type X\n----------\n2. ERROR in X.java (at line 8)\n\tclass permits{}\n\t      ^^^^^^^\n'permits' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n");
    }

    public void testBug564638_058() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n public static void main(String[] args) {\n   @SuppressWarnings(\"unused\")\n   I i = permits :: new;\n   Zork();\n }\n}\nclass permits{}\ninterface I {\n Object gen();\n}"}, "----------\n1. ERROR in X.java (at line 5)\n\tZork();\n\t^^^^\nThe method Zork() is undefined for the type X\n----------\n2. ERROR in X.java (at line 8)\n\tclass permits{}\n\t      ^^^^^^^\n'permits' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n", null, true);
    }

    public void testBug564638b_001() {
        this.runNegativeTest(new String[]{"X.java", "class sealed {\n  void foo() {\n    Zork();\n  }\n}"}, "----------\n1. ERROR in X.java (at line 1)\n\tclass sealed {\n\t      ^^^^^^\n'sealed' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n2. ERROR in X.java (at line 3)\n\tZork();\n\t^^^^\nThe method Zork() is undefined for the type sealed\n----------\n", null, true);
    }

    public void testBug564638b_002() {
        this.runNegativeTest(new String[]{"X.java", "class sealed {\n  void foo() {\n    Zork();\n  }\n}"}, "----------\n1. ERROR in X.java (at line 1)\n\tclass sealed {\n\t      ^^^^^^\n'sealed' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n2. ERROR in X.java (at line 3)\n\tZork();\n\t^^^^\nThe method Zork() is undefined for the type sealed\n----------\n");
    }

    public void testBug564638b_003() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n  sealed p;\n  void foo() {\n    Zork();\n  }\n}", "sealed.java", "public class sealed {\n}"}, "----------\n----------\n1. ERROR in X.java (at line 2)\n\tsealed p;\n\t^^^^^^\n'sealed' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n2. ERROR in X.java (at line 4)\n\tZork();\n\t^^^^\nThe method Zork() is undefined for the type X\n----------\n----------\n1. ERROR in sealed.java (at line 1)\n\tpublic class sealed {\n\t             ^^^^^^\n'sealed' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n", null, true);
    }

    public void testBug564638b_004() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n  sealed p;\n  void foo() {\n    Zork();\n  }\n}", "sealed.java", "public class sealed {\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\tsealed p;\n\t^^^^^^\n'sealed' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n2. ERROR in X.java (at line 4)\n\tZork();\n\t^^^^\nThe method Zork() is undefined for the type X\n----------\n----------\n1. ERROR in sealed.java (at line 1)\n\tpublic class sealed {\n\t             ^^^^^^\n'sealed' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n");
    }

    public void testBug564638b_005() {
        this.runNegativeTest(new String[]{"X.java", "class X<sealed> {\n  void foo() {\n    Zork();\n  }\n}"}, "----------\n1. ERROR in X.java (at line 1)\n\tclass X<sealed> {\n\t        ^^^^^^\n'sealed' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n2. ERROR in X.java (at line 3)\n\tZork();\n\t^^^^\nThe method Zork() is undefined for the type X<sealed>\n----------\n", null, true);
    }

    public void testBug564638b_006() {
        this.runNegativeTest(new String[]{"X.java", "class X<sealed> {\n  void foo() {\n    Zork();\n  }\n}"}, "----------\n1. ERROR in X.java (at line 1)\n\tclass X<sealed> {\n\t        ^^^^^^\n'sealed' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n2. ERROR in X.java (at line 3)\n\tZork();\n\t^^^^\nThe method Zork() is undefined for the type X<sealed>\n----------\n");
    }

    public void testBug564638b_007() {
        this.runNegativeTest(new String[]{"X.java", "class X extends sealed {\n  void foo() {\n    Zork();\n  }\n}\nclass sealed {\n}"}, "----------\n1. ERROR in X.java (at line 1)\n\tclass X extends sealed {\n\t                ^^^^^^\n'sealed' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n2. ERROR in X.java (at line 3)\n\tZork();\n\t^^^^\nThe method Zork() is undefined for the type X\n----------\n3. ERROR in X.java (at line 6)\n\tclass sealed {\n\t      ^^^^^^\n'sealed' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n");
    }

    public void testBug564638b_008() {
        this.runNegativeTest(new String[]{"X.java", "class X extends sealed {\n  void foo() {\n    Zork();\n  }\n}\nclass sealed {\n}"}, "----------\n1. ERROR in X.java (at line 1)\n\tclass X extends sealed {\n\t                ^^^^^^\n'sealed' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n2. ERROR in X.java (at line 3)\n\tZork();\n\t^^^^\nThe method Zork() is undefined for the type X\n----------\n3. ERROR in X.java (at line 6)\n\tclass sealed {\n\t      ^^^^^^\n'sealed' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n", null, true);
    }

    public void testBug564638b_009() {
        this.runNegativeTest(new String[]{"X.java", "class X implements sealed {\n  void foo() {\n    Zork();\n  }\n}\ninterface sealed {\n}"}, "----------\n1. ERROR in X.java (at line 1)\n\tclass X implements sealed {\n\t                   ^^^^^^\n'sealed' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n2. ERROR in X.java (at line 3)\n\tZork();\n\t^^^^\nThe method Zork() is undefined for the type X\n----------\n3. ERROR in X.java (at line 6)\n\tinterface sealed {\n\t          ^^^^^^\n'sealed' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n");
    }

    public void testBug564638b_010() {
        this.runNegativeTest(new String[]{"X.java", "class X implements sealed {\n  void foo() {\n    Zork();\n  }\n}\ninterface sealed {\n}"}, "----------\n1. ERROR in X.java (at line 1)\n\tclass X implements sealed {\n\t                   ^^^^^^\n'sealed' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n2. ERROR in X.java (at line 3)\n\tZork();\n\t^^^^\nThe method Zork() is undefined for the type X\n----------\n3. ERROR in X.java (at line 6)\n\tinterface sealed {\n\t          ^^^^^^\n'sealed' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n", null, true);
    }

    public void testBug564638b_011() {
        this.runNegativeTest(new String[]{"X.java", "interface X extends sealed {\n  default void foo() {\n    Zork();\n  }\n}\ninterface sealed {\n}"}, "----------\n1. ERROR in X.java (at line 1)\n\tinterface X extends sealed {\n\t                    ^^^^^^\n'sealed' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n2. ERROR in X.java (at line 3)\n\tZork();\n\t^^^^\nThe method Zork() is undefined for the type X\n----------\n3. ERROR in X.java (at line 6)\n\tinterface sealed {\n\t          ^^^^^^\n'sealed' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n");
    }

    public void testBug564638b_012() {
        this.runNegativeTest(new String[]{"X.java", "interface X extends sealed {\n  default void foo() {\n    Zork();\n  }\n}\ninterface sealed {\n}"}, "----------\n1. ERROR in X.java (at line 1)\n\tinterface X extends sealed {\n\t                    ^^^^^^\n'sealed' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n2. ERROR in X.java (at line 3)\n\tZork();\n\t^^^^\nThe method Zork() is undefined for the type X\n----------\n3. ERROR in X.java (at line 6)\n\tinterface sealed {\n\t          ^^^^^^\n'sealed' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n", null, true);
    }

    public void testBug564638b_013() {
        this.runNegativeTest(new String[]{"X.java", "class X extends {\n  sealed foo() {\n    Zork();\n    return null;\n  }\n}"}, "----------\n1. ERROR in X.java (at line 1)\n\tclass X extends {\n\t        ^^^^^^^\nSyntax error on token \"extends\", Type expected after this token\n----------\n2. ERROR in X.java (at line 2)\n\tsealed foo() {\n\t^^^^^^\n'sealed' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n3. ERROR in X.java (at line 3)\n\tZork();\n\t^^^^\nThe method Zork() is undefined for the type X\n----------\n");
    }

    public void testBug564638b_014() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n  sealed foo() {\n    Zork();\n    return null;\n  }\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\tsealed foo() {\n\t^^^^^^\n'sealed' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n3. ERROR in X.java (at line 3)\n\tZork();\n\t^^^^\nThe method Zork() is undefined for the type X\n----------\n", null, true);
    }

    public void testBug564638b_015() {
        this.runNegativeTest(new String[]{"X.java", "class X  {\n  void foo() throws sealed{\n    Zork();\n  }\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\tvoid foo() throws sealed{\n\t                  ^^^^^^\n'sealed' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n2. ERROR in X.java (at line 3)\n\tZork();\n\t^^^^\nThe method Zork() is undefined for the type X\n----------\n");
    }

    public void testBug564638b_016() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n  void foo() throws sealed{\n    Zork();\n  }\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\tvoid foo() throws sealed{\n\t                  ^^^^^^\n'sealed' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n3. ERROR in X.java (at line 3)\n\tZork();\n\t^^^^\nThe method Zork() is undefined for the type X\n----------\n", null, true);
    }

    public void testBug564638b_017() {
        this.runNegativeTest(new String[]{"X.java", "class X <T extends sealed> {\n  <T> void foo(T extends sealed) {\n    Zork();\n  }\n}"}, "----------\n1. ERROR in X.java (at line 1)\n\tclass X <T extends sealed> {\n\t                   ^^^^^^\n'sealed' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n2. ERROR in X.java (at line 1)\n\tclass X <T extends sealed> {\n\t                           ^\nSyntax error, insert \"}\" to complete ClassBody\n----------\n3. WARNING in X.java (at line 2)\n\t<T> void foo(T extends sealed) {\n\t ^\nThe type parameter T is hiding the type T\n----------\n4. ERROR in X.java (at line 2)\n\t<T> void foo(T extends sealed) {\n\t               ^^^^^^^\nSyntax error on token \"extends\", delete this token\n----------\n5. ERROR in X.java (at line 5)\n\t}\n\t^\nSyntax error on token \"}\", delete this token\n----------\n");
    }

    public void testBug564638b_018() {
        this.runNegativeTest(new String[]{"X.java", "class X <T extends sealed>{\n  <T> void foo(T extends sealed) {\n    Zork();\n  }\n}"}, "----------\n1. ERROR in X.java (at line 1)\n\tclass X <T extends sealed>{\n\t                   ^^^^^^\n'sealed' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n3. ERROR in X.java (at line 1)\n\tclass X <T extends sealed>{\n\t                          ^\nSyntax error, insert \"}\" to complete ClassBody\n----------\n4. WARNING in X.java (at line 2)\n\t<T> void foo(T extends sealed) {\n\t ^\nThe type parameter T is hiding the type T\n----------\n5. ERROR in X.java (at line 2)\n\t<T> void foo(T extends sealed) {\n\t               ^^^^^^^\nSyntax error on token \"extends\", delete this token\n----------\n6. ERROR in X.java (at line 5)\n\t}\n\t^\nSyntax error on token \"}\", delete this token\n----------\n", null, true);
    }

    public void testBug564638b_019() {
        this.runNegativeTest(new String[]{"X.java", "enum X {\n  ONE(1);\n  private final sealed p;\n  X(int p) {\n    Zork();\n  }\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tprivate final sealed p;\n\t              ^^^^^^\n'sealed' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n2. ERROR in X.java (at line 5)\n\tZork();\n\t^^^^\nThe method Zork() is undefined for the type X\n----------\n");
    }

    public void testBug564638b_020() {
        this.runNegativeTest(new String[]{"X.java", "enum X {\n  ONE(1);\n  private final sealed p;\n  X(int p) {\n    Zork();\n  }\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tprivate final sealed p;\n\t              ^^^^^^\n'sealed' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n3. ERROR in X.java (at line 5)\n\tZork();\n\t^^^^\nThe method Zork() is undefined for the type X\n----------\n", null, true);
    }

    public void testBug564638b_021() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n  public static void main(String[] args) {\n    I i = (sealed p)-> {};\n  }\n}\ninterface I {\n  void apply(Object o);\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tI i = (sealed p)-> {};\n\t      ^^^^^^^^^^^^\nThis lambda expression refers to the missing type sealed\n----------\n2. ERROR in X.java (at line 3)\n\tI i = (sealed p)-> {};\n\t       ^^^^^^\n'sealed' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n");
    }

    public void testBug564638b_022() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n  public static void main(String[] args) {\n    I i = (sealed p)-> {};\n    Zork();\n  }\n}\ninterface I {\n  void apply(Object o);\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tI i = (sealed p)-> {};\n\t      ^^^^^^^^^^^^\nThis lambda expression refers to the missing type sealed\n----------\n2. ERROR in X.java (at line 3)\n\tI i = (sealed p)-> {};\n\t       ^^^^^^\n'sealed' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n4. ERROR in X.java (at line 4)\n\tZork();\n\t^^^^\nThe method Zork() is undefined for the type X\n----------\n", null, true);
    }

    public void testBug564638b_023() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n  public void foo(sealed this) {}\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\tpublic void foo(sealed this) {}\n\t                ^^^^^^\n'sealed' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n");
    }

    public void testBug564638b_024() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n  public void foo(sealed this) {}\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\tpublic void foo(sealed this) {}\n\t                ^^^^^^\n'sealed' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n", null, true);
    }

    public void testBug564638b_025() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n  public void foo(sealed this) {}\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\tpublic void foo(sealed this) {}\n\t                ^^^^^^\n'sealed' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n");
    }

    public void testBug564638b_026() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n  public void foo(sealed this) {}\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\tpublic void foo(sealed this) {}\n\t                ^^^^^^\n'sealed' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n", null, true);
    }

    public void testBug564638b_027() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n  class sealed {\n     public void foo(sealed this) {}\n  }\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\tclass sealed {\n\t      ^^^^^^\n'sealed' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n2. ERROR in X.java (at line 3)\n\tpublic void foo(sealed this) {}\n\t                ^^^^^^\n'sealed' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n");
    }

    public void testBug564638b_028() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n  class sealed {\n     public void foo(sealed this) {}\n  }\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\tclass sealed {\n\t      ^^^^^^\n'sealed' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n2. ERROR in X.java (at line 3)\n\tpublic void foo(sealed this) {}\n\t                ^^^^^^\n'sealed' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n", null, true);
    }

    public void testBug564638b_029() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n  public static void main(String[] args) {\n    sealed p;\n    Zork();\n  }\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tsealed p;\n\t^^^^^^\n'sealed' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n2. ERROR in X.java (at line 4)\n\tZork();\n\t^^^^\nThe method Zork() is undefined for the type X\n----------\n");
    }

    public void testBug564638b_030() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n  public static void main(String[] args) {\n    sealed p;\n    Zork();\n  }\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tsealed p;\n\t^^^^^^\n'sealed' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n3. ERROR in X.java (at line 4)\n\tZork();\n\t^^^^\nThe method Zork() is undefined for the type X\n----------\n", null, true);
    }

    public void testBug564638b_031() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n  public static void main(String[] args) {\n    for (sealed i = 0; i < 10; ++i) {} \n  }\n  void foo() {\n    Zork();\n  }\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tfor (sealed i = 0; i < 10; ++i) {} \n\t     ^^^^^^\n'sealed' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n2. ERROR in X.java (at line 6)\n\tZork();\n\t^^^^\nThe method Zork() is undefined for the type X\n----------\n");
    }

    public void testBug564638b_032() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n  public static void main(String[] args) {\n    for (sealed i = 0; i < 10; ++i) {} \n  }\n  void foo() {\n    Zork();\n  }\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tfor (sealed i = 0; i < 10; ++i) {} \n\t     ^^^^^^\n'sealed' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n3. ERROR in X.java (at line 6)\n\tZork();\n\t^^^^\nThe method Zork() is undefined for the type X\n----------\n", null, true);
    }

    public void testBug564638b_033() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n  public static void main(sealed[] args) {\n    for (sealed p : args) {} \n  }\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\tpublic static void main(sealed[] args) {\n\t                        ^^^^^^^^\n'sealed' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n2. ERROR in X.java (at line 3)\n\tfor (sealed p : args) {} \n\t     ^^^^^^\n'sealed' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n");
    }

    public void testBug564638b_034() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n  public static void main(sealed[] args) {\n    for (sealed p : args) {} \n  }\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\tpublic static void main(sealed[] args) {\n\t                        ^^^^^^^^\n'sealed' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n3. ERROR in X.java (at line 3)\n\tfor (sealed p : args) {} \n\t     ^^^^^^\n'sealed' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n", null, true);
    }

    public void testBug564638b_035() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n       public static void main(String[] args) {\n               try (sealed y = new Y()) {\n                       \n               } catch (Exception e) {\n                       e.printStackTrace();\n               } finally {\n                       \n               }\n       }\n}\nclass Y implements AutoCloseable {\n       @Override\n       public void close() throws Exception {}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\ttry (sealed y = new Y()) {\n\t     ^^^^^^\n'sealed' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n");
    }

    public void testBug564638b_036() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n       public static void main(String[] args) {\n               try (sealed y = new Y()) {\n                       \n               } catch (Exception e) {\n                       e.printStackTrace();\n               } finally {\n                       \n               }\n       }\n}\nclass Y implements AutoCloseable {\n       @Override\n       public void close() throws Exception {}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\ttry (sealed y = new Y()) {\n\t     ^^^^^^\n'sealed' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n", null, true);
    }

    public void testBug564638b_037() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n       public static void main(String[] args) {\n               try (Y y = new Y()) {\n                       \n               } catch (sealed e) {\n                       e.printStackTrace();\n               } finally {\n                       \n               }\n       }\n}\nclass Y implements AutoCloseable {\n       @Override\n       public void close() throws Exception {}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\t} catch (sealed e) {\n\t         ^^^^^^\n'sealed' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n");
    }

    public void testBug564638b_038() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n       public static void main(String[] args) {\n               try (Y y = new Y()) {\n                       \n               } catch (sealed e) {\n                       e.printStackTrace();\n               } finally {\n                       \n               }\n       }\n}\nclass Y implements AutoCloseable {\n       @Override\n       public void close() throws Exception {}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\t} catch (sealed e) {\n\t         ^^^^^^\n'sealed' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n", null, true);
    }

    public void testBug564638b_039() {
        this.runNegativeTest(new String[]{"X.java", "record X(sealed p) {\n}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\trecord X(sealed p) {\n\t         ^^^^^^\n'sealed' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n");
    }

    public void testBug564638b_040() {
        this.runNegativeTest(new String[]{"X.java", "record X(sealed p) {\n}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\trecord X(sealed p) {\n\t         ^^^^^^\n'sealed' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n", null, true);
    }

    public void testBug564638b_041() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n       public <T> X(T t) {}\n       \n       public X(int t, char c) {\n               <sealed>this(t);\n       }\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\t<sealed>this(t);\n\t ^^^^^^\n'sealed' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n2. ERROR in X.java (at line 5)\n\t<sealed>this(t);\n\t        ^^^^^^^^\nThe constructor X(sealed) refers to the missing type sealed\n----------\n");
    }

    public void testBug564638b_042() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n       public <T> X(T t) {}\n       \n       public X(int t, char c) {\n               <sealed>this(t);\n       }\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\t<sealed>this(t);\n\t ^^^^^^\n'sealed' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n3. ERROR in X.java (at line 5)\n\t<sealed>this(t);\n\t        ^^^^^^^^\nThe constructor X(sealed) refers to the missing type sealed\n----------\n", null, true);
    }

    public void testBug564638b_043() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n       public <T> X(T t) {}\n       \n       public X(int t, char c) {\n           new <sealed>X(t).foo();\n       }\n       public void foo() {}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tnew <sealed>X(t).foo();\n\t^^^^^^^^^^^^^^^^\nThe constructor X(sealed) refers to the missing type sealed\n----------\n2. ERROR in X.java (at line 5)\n\tnew <sealed>X(t).foo();\n\t     ^^^^^^\n'sealed' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n");
    }

    public void testBug564638b_044() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n       public <T> X(T t) {}\n       \n       public X(int t, char c) {\n           new <sealed>X(t).foo();\n       }\n       public void foo() {}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tnew <sealed>X(t).foo();\n\t^^^^^^^^^^^^^^^^\nThe constructor X(sealed) refers to the missing type sealed\n----------\n2. ERROR in X.java (at line 5)\n\tnew <sealed>X(t).foo();\n\t     ^^^^^^\n'sealed' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n", null, true);
    }

    public void testBug564638b_045() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n       public <T> void foo(T t) {}\n       \n       public X() {\n               X x = new X();\n               x.<sealed>foo(0);\n       }\n}"}, "----------\n1. ERROR in X.java (at line 6)\n\tx.<sealed>foo(0);\n\t   ^^^^^^\n'sealed' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n2. ERROR in X.java (at line 6)\n\tx.<sealed>foo(0);\n\t          ^^^\nThe method foo(sealed) from the type X refers to the missing type sealed\n----------\n");
    }

    public void testBug564638b_046() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n       public <T> void foo(T t) {}\n       \n       public X() {\n               X x = new X();\n               x.<sealed>foo(0);\n       }\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tx.<sealed>foo(0);\n\t   ^^^^^^\n'sealed' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n3. ERROR in X.java (at line 6)\n\tx.<sealed>foo(0);\n\t          ^^^\nThe method foo(sealed) from the type X refers to the missing type sealed\n----------\n", null, true);
    }

    public void testBug564638b_047() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n       public <T> void foo(T t) {}\n       \n       public X() {\n               X x = new sealed();\n       }\n}"}, "----------\n1. ERROR in X.java (at line 5)\n\tX x = new sealed();\n\t          ^^^^^^\n'sealed' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n");
    }

    public void testBug564638b_048() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n       public <T> void foo(T t) {}\n       \n       public X() {\n               X x = new sealed();\n       }\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tX x = new sealed();\n\t          ^^^^^^\n'sealed' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n", null, true);
    }

    public void testBug564638b_049() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n       public X() {\n               new sealed() {\n                       @Override\n                       void foo() {}\n               }.foo();\n       }\n}\nabstract class sealed {\n       abstract void foo();\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tnew sealed() {\n\t    ^^^^^^\n'sealed' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n2. ERROR in X.java (at line 9)\n\tabstract class sealed {\n\t               ^^^^^^\n'sealed' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n");
    }

    public void testBug564638b_050() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n    public X() {\n       new sealed() {\n          @Override\n          void foo() {\n            Zork();\n          }\n       }.foo();\n       }\n}\nabstract class sealed {\n       abstract void foo();\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tnew sealed() {\n\t    ^^^^^^\n'sealed' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n2. ERROR in X.java (at line 6)\n\tZork();\n\t^^^^\nThe method Zork() is undefined for the type new sealed(){}\n----------\n3. ERROR in X.java (at line 11)\n\tabstract class sealed {\n\t               ^^^^^^\n'sealed' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n", null, true);
    }

    public void testBug564638b_051() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n  public X() {\n    Object[] p = new sealed[10];\n  }\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tObject[] p = new sealed[10];\n\t                 ^^^^^^\n'sealed' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n");
    }

    public void testBug564638b_052() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n  public X() {\n    Object[] p = new sealed[10];\n  }\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tObject[] p = new sealed[10];\n\t                 ^^^^^^\n'sealed' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n", null, true);
    }

    public void testBug564638b_053() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n public static void main(String[] args) {\n   new X().foo((sealed) null);\n }\n private void foo(sealed o) {}\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tnew X().foo((sealed) null);\n\t        ^^^\nThe method foo(sealed) from the type X refers to the missing type sealed\n----------\n2. ERROR in X.java (at line 3)\n\tnew X().foo((sealed) null);\n\t             ^^^^^^\n'sealed' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n3. ERROR in X.java (at line 5)\n\tprivate void foo(sealed o) {}\n\t                 ^^^^^^\n'sealed' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n");
    }

    public void testBug564638b_054() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n public static void main(String[] args) {\n   new X().foo((sealed) null);\n }\n private void foo(sealed o) {}\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tnew X().foo((sealed) null);\n\t        ^^^\nThe method foo(sealed) from the type X refers to the missing type sealed\n----------\n2. ERROR in X.java (at line 3)\n\tnew X().foo((sealed) null);\n\t             ^^^^^^\n'sealed' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n4. ERROR in X.java (at line 5)\n\tprivate void foo(sealed o) {}\n\t                 ^^^^^^\n'sealed' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n", null, true);
    }

    public void testBug564638b_055() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n private void foo(Object o) {\n   if (o instanceof sealed) {}\n }\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tif (o instanceof sealed) {}\n\t                 ^^^^^^\n'sealed' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n");
    }

    public void testBug564638b_056() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n private void foo(Object o) {\n   if (o instanceof sealed) {}\n }\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tif (o instanceof sealed) {}\n\t                 ^^^^^^\n'sealed' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n", null, true);
    }

    public void testBug564638b_057() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n public static void main(String[] args) {\n   @SuppressWarnings(\"unused\")\n   I i = sealed :: new;\n   Zork();\n }\n}\nclass sealed{}\ninterface I {\n Object gen();\n}"}, "----------\n1. ERROR in X.java (at line 5)\n\tZork();\n\t^^^^\nThe method Zork() is undefined for the type X\n----------\n2. ERROR in X.java (at line 8)\n\tclass sealed{}\n\t      ^^^^^^\n'sealed' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n");
    }

    public void testBug564638b_058() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n public static void main(String[] args) {\n   @SuppressWarnings(\"unused\")\n   I i = sealed :: new;\n   Zork();\n }\n}\nclass sealed{}\ninterface I {\n Object gen();\n}"}, "----------\n1. ERROR in X.java (at line 5)\n\tZork();\n\t^^^^\nThe method Zork() is undefined for the type X\n----------\n2. ERROR in X.java (at line 8)\n\tclass sealed{}\n\t      ^^^^^^\n'sealed' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 17\n----------\n", null, true);
    }

    public void testBug565561_001() throws IOException, ClassFormatException {
        this.runConformTest(new String[]{"X.java", "public sealed class X permits Outer.Inner {\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\nclass Outer{\n   final class Inner extends X{}\n}"}, "0");
        String expectedOutput = "  Inner classes:\n    [inner class info: #33 Outer$Inner, outer class info: #36 Outer\n     inner name: #38 Inner, accessflags: 16 final]\n\nPermittedSubclasses:\n   #33 Outer$Inner\n}";
        this.verifyClassFile(expectedOutput, "X.class", 4);
    }

    public void testBug565116_001() throws IOException, ClassFormatException {
        this.runConformTest(new String[]{"permits/X.java", "package permits;\nclass X {\n  public static void main(String[] args) {\n    X x = new permits.X();\n  }\n}"}, "");
    }

    public void testBug565638_001() throws IOException, ClassFormatException {
        this.runConformTest(new String[]{"X.java", "sealed class X {\n  public static void main(String[] args) {\n    System.out.println(0);\n  }\n}\nfinal class Outer {\n    final class Inner extends X{\n  }\n}"}, "0");
    }

    public void testBug565782_001() throws IOException, ClassFormatException {
        this.runConformTest(new String[]{"X.java", "sealed interface I permits X {}\nenum X implements I {\n    ONE {};\n    public static void main(String[] args) {\n        System.out.println(0);\n   }\n}"}, "0");
        String expectedOutput = "PermittedSubclasses:\n   #14 X$1\n}";
        this.verifyClassFile(expectedOutput, "X.class", 4);
    }

    public void testBug565782_002() throws IOException, ClassFormatException {
        this.runConformTest(new String[]{"X.java", "sealed interface I permits X {}\npublic enum X implements I {\n    ONE ;\n    public static void main(String[] args) {\n        System.out.println(0);\n   }\n}"}, "0");
        String expectedOutput = "public final enum X implements I {\n";
        this.verifyClassFile(expectedOutput, "X.class", 4);
    }

    public void testBug565782_003() throws IOException, ClassFormatException {
        this.runConformTest(new String[]{"X.java", "sealed interface I {}\nenum X implements I {\n    ONE {};\n    public static void main(String[] args) {\n        System.out.println(0);\n   }\n}"}, "0");
        String expectedOutput = "PermittedSubclasses:\n   #14 X$1\n}";
        this.verifyClassFile(expectedOutput, "X.class", 4);
    }

    public void testBug565782_004() throws IOException, ClassFormatException {
        this.runConformTest(new String[]{"X.java", "sealed interface I {}\nclass X {\n\tenum E implements I {\n   \tONE {};\n\t}\n   public static void main(String[] args) {\n      \tSystem.out.println(0);\n   }\n}"}, "0");
        String expectedOutput = "PermittedSubclasses:\n   #14 X$E$1\n}";
        this.verifyClassFile(expectedOutput, "X$E.class", 4);
    }

    public void testBug565782_005() throws IOException, ClassFormatException {
        this.runConformTest(new String[]{"X.java", "sealed interface I permits X {}\nenum X implements I {\n    ONE {},\n    TWO {},\n    THREE {};\n    public static void main(String[] args) {\n        System.out.println(0);\n   }\n}"}, "0");
        String expectedOutput = "PermittedSubclasses:\n   #16 X$1,\n   #25 X$2,\n   #31 X$3\n}";
        this.verifyClassFile(expectedOutput, "X.class", 4);
    }

    public void testBug565847_001() {
        this.runNegativeTest(new String[]{"X.java", "public sealed class X  permits Y {Zork();\n}\nfinal class  Y extends X{}\nsealed interface I{}\nfinal class Z implements I{}"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic sealed class X  permits Y {Zork();\n\t                                  ^^^^^^\nReturn type for the method is missing\n----------\n2. ERROR in X.java (at line 1)\n\tpublic sealed class X  permits Y {Zork();\n\t                                  ^^^^^^\nThis method requires a body instead of a semicolon\n----------\n", null, true);
    }

    public void testBug566979_001() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n    public sealed void main(String[] args){ }\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tpublic sealed void main(String[] args){ }\n\t       ^^^^^^\nSyntax error on token \"sealed\", static expected\n----------\n", null, true);
    }

    public void testBug566979_002() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n    public sealed void main(String[] args){ }\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tpublic sealed void main(String[] args){ }\n\t       ^^^^^^\nSyntax error on token \"sealed\", static expected\n----------\n", null, true);
    }

    public void testBug566980_001() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n    public permits void main(String[] args){ }\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tpublic permits void main(String[] args){ }\n\t               ^^^^\nSyntax error on token \"void\", delete this token\n----------\n", null, true);
    }

    public void testBug566980_002() {
        Map<String, String> options = this.getCompilerOptions();
        this.runNegativeTest(new String[]{"X.java", "class X {\n    public permits void main(String[] args){ }\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tpublic permits void main(String[] args){ }\n\t               ^^^^\nSyntax error on token \"void\", delete this token\n----------\n", null, true, options);
    }

    public void testBug566846_001() {
        Map<String, String> options = this.getCompilerOptions();
        String error = this.complianceLevel < 0x440000L ? "The preview feature Implicitly Declared Classes and Instance Main Methods is only available with source level 24 and above\n" : "Implicitly Declared Classes and Instance Main Methods is a preview feature and disabled by default. Use --enable-preview to enable\n";
        this.runNegativeTest(new String[]{"X.java", "record X;\n"}, "----------\n1. ERROR in X.java (at line 1)\n\trecord X;\n\t^\n" + error + "----------\n2. ERROR in X.java (at line 1)\n\trecord X;\n\t^^^^^^\n'record' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 16\n----------\n3. ERROR in X.java (at line 1)\n\trecord X;\n\t^\nImplicitly declared class must have a candidate main method\n----------\n", null, true, options);
    }

    public void testBug568428_001() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n    public void foo() {\n        sealed interface I {}\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tsealed interface I {}\n\t                 ^\nIllegal modifier for the local interface I; abstract and strictfp are the only modifiers allowed explicitly \n----------\n");
    }

    public void testBug568428_002() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n    public void foo() {\n        non-sealed interface I {}\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tnon-sealed interface I {}\n\t                     ^\nIllegal modifier for the local interface I; abstract and strictfp are the only modifiers allowed explicitly \n----------\n");
    }

    public void testBug568514_001() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n    public void foo() {\n        sealed enum I {}\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tsealed enum I {}\n\t            ^\nIllegal modifier for local enum I; no explicit modifier is permitted\n----------\n");
    }

    public void testBug568514_002() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n    public void foo() {\n        non-sealed enum I {}\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tnon-sealed enum I {}\n\t                ^\nIllegal modifier for local enum I; no explicit modifier is permitted\n----------\n");
    }

    public void testBug568758_001() {
        this.runNegativeTest(new String[]{"X.java", "public sealed interface X{}\n", "Y.java", "public final class Y implements X{}"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic sealed interface X{}\n\t                        ^\nSealed type X lacks a permits clause and no type from the same compilation unit declares X as its direct supertype\n----------\n----------\n1. ERROR in Y.java (at line 1)\n\tpublic final class Y implements X{}\n\t                                ^\nThe type Y that implements the sealed interface X should be a permitted subtype of X\n----------\n");
    }

    public void testBug569522_001() throws IOException, ClassFormatException {
        this.runConformTest(new String[]{"X.java", "public class X {\n  sealed interface Foo<T> permits Bar { }\n  final class Bar<T> implements Foo<T> { }\n  public static void main(String[] args) {\n       System.out.println(\"\");\n  }\n}"}, "");
    }

    public void testBug569522_002() throws IOException, ClassFormatException {
        this.runConformTest(new String[]{"X.java", "public class X {\n  sealed class Foo<T> permits Bar { }\n  final class Bar<T> extends Foo<T> { }\n  public static void main(String[] args) {\n       System.out.println(\"\");\n  }\n}"}, "");
    }

    public void testBug570359_001() throws IOException, ClassFormatException {
        this.runConformTest(new String[]{"X.java", "import java.lang.reflect.Modifier;\n\nsealed interface I {\n void foo();\n}\n\nclass Y {\n enum E implements I {\n   ONE() {\n     public void foo() {\n     }\n   };\n }\n}\n\npublic class X {\n public static void main(String argv[]) {\n   Class<? extends Y.E> c = Y.E.ONE.getClass();\n   System.out.println(c != null ? (c.getModifiers() & Modifier.FINAL) != 0 : false);\n }\n}"}, "true");
        String expectedOutput = "final enum Y$E$1 {\n";
        this.verifyClassFile(expectedOutput, "Y$E$1.class", 4);
        expectedOutput = "  Inner classes:\n    [inner class info: #3 Y$E, outer class info: #20 Y\n     inner name: #22 E, accessflags: 17416 abstract static],\n    [inner class info: #1 Y$E$1, outer class info: #0\n     inner name: #0, accessflags: 16400 final]\n  Enclosing Method: #3  #0 Y$E\n";
        this.verifyClassFile(expectedOutput, "Y$E$1.class", 4);
    }

    public void testBug568854_001() {
        this.runNegativeTest(new String[]{"X.java", " public class X {\n   sealed interface Foo permits A {}\n   record A() implements Foo {}\n   record B() implements Foo {}\n }"}, "----------\n1. ERROR in X.java (at line 4)\n\trecord B() implements Foo {}\n\t                      ^^^\nThe type B that implements the sealed interface X.Foo should be a permitted subtype of X.Foo\n----------\n");
    }

    public void testBug568854_002() {
        this.runNegativeTest(new String[]{"X.java", " sealed interface Foo permits X.A {}\n public class X {\n   record A() implements Foo {}\n   record B() implements Foo {}\n }"}, "----------\n1. ERROR in X.java (at line 4)\n\trecord B() implements Foo {}\n\t                      ^^^\nThe type B that implements the sealed interface Foo should be a permitted subtype of Foo\n----------\n");
    }

    public void testBug568854_003() {
        this.runNegativeTest(new String[]{"X.java", " sealed interface Foo permits A {}\n record A() implements Foo {}\n record B() implements Foo {}\n public class X {\n }"}, "----------\n1. ERROR in X.java (at line 3)\n\trecord B() implements Foo {}\n\t                      ^^^\nThe type B that implements the sealed interface Foo should be a permitted subtype of Foo\n----------\n");
    }

    public void testBug568854_004() {
        this.runNegativeTest(new String[]{"X.java", " public class X {\n   sealed interface Foo permits A {}\n   class A implements Foo {}\n   final class B implements Foo {}\n }"}, "----------\n1. ERROR in X.java (at line 3)\n\tclass A implements Foo {}\n\t      ^\nThe class A with a sealed direct supertype X.Foo should be declared either final, sealed, or non-sealed\n----------\n2. ERROR in X.java (at line 4)\n\tfinal class B implements Foo {}\n\t                         ^^^\nThe type B that implements the sealed interface X.Foo should be a permitted subtype of X.Foo\n----------\n");
    }

    public void testBug568854_005() {
        this.runNegativeTest(new String[]{"X.java", " sealed interface Foo permits X.A {}\n public class X {\n   class A implements Foo {}\n   final class B implements Foo {}\n }"}, "----------\n1. ERROR in X.java (at line 3)\n\tclass A implements Foo {}\n\t      ^\nThe class A with a sealed direct supertype Foo should be declared either final, sealed, or non-sealed\n----------\n2. ERROR in X.java (at line 4)\n\tfinal class B implements Foo {}\n\t                         ^^^\nThe type B that implements the sealed interface Foo should be a permitted subtype of Foo\n----------\n");
    }

    public void testBug568854_006() {
        this.runNegativeTest(new String[]{"X.java", " sealed interface Foo permits A {}\n class A implements Foo {}\n final class B implements Foo {}\n public class X {\n }"}, "----------\n1. ERROR in X.java (at line 2)\n\tclass A implements Foo {}\n\t      ^\nThe class A with a sealed direct supertype Foo should be declared either final, sealed, or non-sealed\n----------\n2. ERROR in X.java (at line 3)\n\tfinal class B implements Foo {}\n\t                         ^^^\nThe type B that implements the sealed interface Foo should be a permitted subtype of Foo\n----------\n");
    }

    public void testBug568854_007() {
        this.runNegativeTest(new String[]{"X.java", "sealed interface I permits A {}\nfinal class A implements I {}\nenum B {\n   ONE {\n     class Y implements I {}\n   }\n}\npublic class    X {\n public static void main(String[] args) {\n   class Z implements I{}\n }\n}"}, "----------\n1. ERROR in X.java (at line 5)\n\tclass Y implements I {}\n\t                   ^\nThe local type Y may not have a sealed supertype I\n----------\n2. ERROR in X.java (at line 10)\n\tclass Z implements I{}\n\t                   ^\nThe local type Z may not have a sealed supertype I\n----------\n");
    }

    public void testBug568854_008() {
        this.runNegativeTest(new String[]{"X.java", "sealed interface I permits X.A {}\npublic class    X {\nfinal class A implements I {}\nenum B {\n   ONE {\n     class Y implements I {}\n   }\n}\n public static void main(String[] args) {\n   class Z implements I{}\n }\n}"}, "----------\n1. ERROR in X.java (at line 6)\n\tclass Y implements I {}\n\t                   ^\nThe local type Y may not have a sealed supertype I\n----------\n2. ERROR in X.java (at line 10)\n\tclass Z implements I{}\n\t                   ^\nThe local type Z may not have a sealed supertype I\n----------\n");
    }

    public void testBug571332_001() {
        this.runNegativeTest(new String[]{"X.java", "sealed interface I {\n       void foo();\n}\nnon-sealed interface I1 extends I {}\npublic class X {\n    public static void main(String argv[]) {\n        I lambda = () -> {};\n    }\n}"}, "----------\n1. ERROR in X.java (at line 7)\n\tI lambda = () -> {};\n\t           ^^^^^\nThe target type of this expression must be a functional interface\n----------\n");
    }

    public void testBug570605_001() {
        this.runNegativeTest(new String[]{"X.java", "sealed class Y {}\nnon-sealed class Z extends Y {}\npublic class X {\n public void foo() {\n        record R()  {\n            class L extends Y {}\n        }\n    }\n}"}, "----------\n1. ERROR in X.java (at line 6)\n\tclass L extends Y {}\n\t                ^\nThe local type L may not have a sealed supertype Y\n----------\n");
    }

    public void testBug570218_001() {
        this.runConformTest(new String[]{"X.java", "interface I {}\nsealed class A permits X {}\nfinal class X extends A implements I { \n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\n"}, "0");
    }

    public void testBug570218_002() {
        this.runConformTest(new String[]{"X.java", "sealed interface I permits X{}\nclass A  {}\nfinal class X extends A implements I { \n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\n"}, "0");
    }

    public void testBug572205_001() {
        this.runNegativeTest(new String[]{"X.java", "public class X{\n  public static void main(String[] args) {\n\t class Circle implements Shape{}\n  }\n  sealed interface Shape {}\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tclass Circle implements Shape{}\n\t                        ^^^^^\nThe local type Circle may not have a sealed supertype X.Shape\n----------\n2. ERROR in X.java (at line 5)\n\tsealed interface Shape {}\n\t                 ^^^^^\nSealed type Shape lacks a permits clause and no type from the same compilation unit declares Shape as its direct supertype\n----------\n");
    }

    public void testBug573450_001() {
        this.runConformTest(new String[]{"X.java", "sealed interface Foo permits Foo.Bar {\n\tinterface Interface {}\n\trecord Bar() implements Foo, Interface { }\n}\npublic class X { \n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}"}, "0");
    }

    public void testBug573450_002() {
        this.runConformTest(new String[]{"X.java", "interface Interface {}\nsealed interface Foo extends Interface permits Foo.Bar {\n\trecord Bar() implements Foo, Interface {}\n}\npublic class X { \n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}"}, "0");
    }

    public void testBug573450_003() {
        this.runNegativeTest(new String[]{"X.java", "sealed interface Interface extends Foo{}\nsealed interface Foo extends Interface permits Foo.Bar, Interface {\n\trecord Bar() implements Foo, Interface {} \n}"}, "----------\n1. ERROR in X.java (at line 1)\n\tsealed interface Interface extends Foo{}\n\t                 ^^^^^^^^^\nThe hierarchy of the type Interface is inconsistent\n----------\n2. ERROR in X.java (at line 2)\n\tsealed interface Foo extends Interface permits Foo.Bar, Interface {\n\t                             ^^^^^^^^^\nCycle detected: a cycle exists in the type hierarchy between Foo and Interface\n----------\n3. ERROR in X.java (at line 3)\n\trecord Bar() implements Foo, Interface {} \n\t       ^^^\nThe hierarchy of the type Bar is inconsistent\n----------\n");
    }

    public void testBug573450_004() {
        this.runConformTest(new String[]{"X.java", "public sealed class X permits X.Y {\n\tfinal class Y extends X {}\n\tpublic static void main(String[] args){\n\t\tSystem.out.println(0);\n\t}\n}"}, "0");
    }

    public void testBug573450_005() {
        this.runNegativeTest(new String[]{"X.java", "public sealed class X permits Y {\n\tfinal class Y extends X {}\n}"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic sealed class X permits Y {\n\t                              ^\nY cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 2)\n\tfinal class Y extends X {}\n\t                      ^\nThe class Y cannot extend the class X as it is not a permitted subtype of X\n----------\n");
    }

    public void testBug578619_1() {
        this.runConformTest(new String[]{"Bug578619.java", "public class Bug578619 {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(\"Hola\");\n\t}\n}\nsealed interface I1 permits I2, I3 {}\nnon-sealed interface I2 extends I1 {}\nnon-sealed interface I3 extends I2, I1 {}"}, "Hola");
    }

    public void testBug578619_2() {
        this.runNegativeTest(new String[]{"Bug578619.java", "public class Bug578619 {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(\"Hola\");\n\t}\n}\nsealed interface I1 permits I2, I3 {}\nnon-sealed interface I2 extends I1 {}\nnon-sealed interface I3 extends I2 {}"}, "----------\n1. ERROR in Bug578619.java (at line 6)\n\tsealed interface I1 permits I2, I3 {}\n\t                                ^^\nPermitted type I3 does not declare I1 as direct super interface \n----------\n2. ERROR in Bug578619.java (at line 8)\n\tnon-sealed interface I3 extends I2 {}\n\t                     ^^\nThe non-sealed interface I3 must have a sealed direct superinterface\n----------\n");
    }

    public void testBug576378() {
        this.runNegativeTest(new String[]{"X.java", "sealed interface I permits J {}\r\nrecord J<T>() implements I {}\npublic class X {\n    public static void main(String [] args) {\n        J j; K k;\n    }\n}\n"}, "----------\n1. WARNING in X.java (at line 5)\n\tJ j; K k;\n\t^\nJ is a raw type. References to generic type J<T> should be parameterized\n----------\n2. ERROR in X.java (at line 5)\n\tJ j; K k;\n\t     ^\nK cannot be resolved to a type\n----------\n");
    }

    public void testBug576378_2() {
        this.runNegativeTest(new String[]{"X.java", "sealed interface I permits J<Object> {}\r\nrecord J<T>() implements I {}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tsealed interface I permits J<Object> {}\n\t                             ^^^^^^\nType arguments are not allowed here\n----------\n");
    }

    public void testBug576378_3() {
        this.runNegativeTest(new String[]{"X.java", "sealed interface I permits J<Object>.K<String> {}\r\nfinal class J<T> {\n    final class K<P> implements I {}\n}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tsealed interface I permits J<Object>.K<String> {}\n\t                             ^^^^^^\nType arguments are not allowed here\n----------\n2. ERROR in X.java (at line 1)\n\tsealed interface I permits J<Object>.K<String> {}\n\t                                       ^^^^^^\nType arguments are not allowed here\n----------\n");
    }

    public void testBug576378_4() {
        this.runNegativeTest(new String[]{"X.java", "sealed interface I permits J.K<String> {}\r\nfinal class J<T> {\n    final static class K<P> implements I {}\n}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tsealed interface I permits J.K<String> {}\n\t                               ^^^^^^\nType arguments are not allowed here\n----------\n");
    }

    public void testIssue2093() {
        this.runConformTest(new String[]{"X.java", "record Bar() implements TheA.FooOrBar {\n}\n\nrecord Foo() implements TheA.FooOrBar {\n}\n\nsealed interface Base permits TheA, TheB {\n}\n\nrecord TheA() implements Base {\n\tpublic sealed interface FooOrBar permits Foo, Bar {\n\t}\n}\n\nrecord TheB<T extends TheA.FooOrBar>() implements Base {\n}\npublic class X {\n    public static void main(String [] args) {\n        System.out.println(\"Compiled and ran fine!\");\n       }\n      }\n"}, "Compiled and ran fine!");
    }

    public void testBug576471() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic sealed interface I permits IA, C1, C2 {}\n\tpublic sealed interface IA extends I permits A {}\n\tpublic abstract sealed class A implements IA permits C1, C2 {}\n\tpublic final class C1 extends A implements I {}\n\tpublic final class C2 extends A implements I {}\n\tpublic static void main(String [] args) {\n        System.out.println(\"Compiled and ran fine!\");\n       }\n}\n"}, "Compiled and ran fine!");
    }

    public void testIssue1808() {
        this.runNegativeTest(new String[]{"X.java", "public sealed interface X permits B {\n    record B(int data) {}\n    public static void main(String [] args) {\n        System.out.println(\"Compiled and ran fine!\");\n       }\n}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic sealed interface X permits B {\n\t                                  ^\nB cannot be resolved to a type\n");
    }

    public void testIssue1808_1() {
        this.runNegativeTest(new String[]{"X.java", "public sealed interface X permits B {\n    record B(int data) implements X {}\n    public static void main(String [] args) {\n        System.out.println(\"Compiled and ran fine!\");\n       }\n}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic sealed interface X permits B {\n\t                                  ^\nB cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 2)\n\trecord B(int data) implements X {}\n\t                              ^\nThe type B that implements the sealed interface X should be a permitted subtype of X\n----------\n");
    }

    public void testIssue1808_2() {
        this.runConformTest(new String[]{"X.java", "public sealed interface X permits X.B {\n    record B(int data)  implements X {}\n    public static void main(String [] args) {\n        System.out.println(\"Compiled and ran fine!\");\n       }\n}\n"}, "Compiled and ran fine!");
    }

    public void testIssue1808_3() {
        this.runWarningTest(new String[]{"foo/X.java", "package foo;\nimport foo.X.B;\npublic sealed interface X permits B {\n    record B(int data) implements X {}\n    public static void main(String [] args) {\n        System.out.println(\"Compiled and ran fine!\");\n       }\n}\n"}, "", "Compiled and ran fine!");
    }

    public void testIssue1808_4() {
        Runner runner = new Runner();
        runner.testFiles = new String[]{"foo/X.java", "package foo;\nimport foo.X.B;\npublic sealed interface X permits X.B {\n    record B(int data) implements X {}\n    public static void main(String [] args) {\n        System.out.println(\"Compiled and ran fine!\");\n       }\n}\n"};
        runner.expectedCompilerLog = "----------\n1. WARNING in foo\\X.java (at line 2)\n\timport foo.X.B;\n\t       ^^^^^^^\nThe import foo.X.B is never used\n----------\n";
        runner.expectedOutputString = "Compiled and ran fine!";
        runner.javacTestOptions = AbstractRegressionTest.JavacTestOptions.Excuse.EclipseHasSomeMoreWarnings;
        runner.runWarningTest();
    }

    public void testIssue2595_0() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n}\n\nfinal class C {\n}\n\npublic class X {\n\tvoid test(C c) {\n\t\tif (c instanceof I) // Compile-time error!\n\t\t\tSystem.out.println(\"It's an I\");\n\t}\n\tvoid test(I i) {\n\t\tif (i instanceof C) // Compile-time error!\n\t\t\tSystem.out.println(\"It's a C\");\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\tif (c instanceof I) // Compile-time error!\n\t    ^^^^^^^^^^^^^^\nIncompatible conditional operand types C and I\n----------\n2. ERROR in X.java (at line 13)\n\tif (i instanceof C) // Compile-time error!\n\t    ^^^^^^^^^^^^^^\nIncompatible conditional operand types I and C\n----------\n");
    }

    public void testIssue2595_1() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tinterface I {\n\t}\n\n\tsealed class C permits D {\n\t}\n\n\tfinal class D extends C {\n\t}\n\n\tvoid test(C c) {\n\t\tif (c instanceof I) // Compile-time error!\n\t\t\tSystem.out.println(\"It's an I\");\n\t}\n\n\tvoid test(I i) {\n\t\tif (i instanceof C) // Compile-time error!\n\t\t\tSystem.out.println(\"It's a C\");\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 12)\n\tif (c instanceof I) // Compile-time error!\n\t    ^^^^^^^^^^^^^^\nIncompatible conditional operand types X.C and X.I\n----------\n2. ERROR in X.java (at line 17)\n\tif (i instanceof C) // Compile-time error!\n\t    ^^^^^^^^^^^^^^\nIncompatible conditional operand types X.I and X.C\n----------\n");
    }

    public void testIssue2595_2() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tinterface I {}\n\tsealed class C permits D, E {}\n\tnon-sealed class D extends C {}\n\tfinal class E extends C {}\n    class F extends D implements I {}\n\n\tvoid test (C c) {\n\t    if (c instanceof I)\n\t        System.out.println(\"It's an I\");\n\t}\n\n\tvoid test (I i) {\n\t    if (i instanceof C)\n\t        System.out.println(\"It's a C\");\n\t}\n\n    public static void main(String [] args) {\n        new X().test(((C) new X().new F()));\n        new X().test(((I) new X().new F()));\n    }\n}\n"}, "It's an I\nIt's a C");
    }

    public void testIssue2595_3() {
        this.runNegativeTest(new String[]{"X.java", "sealed interface Intf permits PermittedA {}\nfinal class PermittedA implements Intf {}\ninterface Standalone {}\npublic class X {\n    public Intf foo(Standalone st) {\n    \treturn (Intf) st;\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\r\n\treturn (Intf) st;\r\n\t       ^^^^^^^^^\nCannot cast from Standalone to Intf\n----------\n");
    }

    public void testIssue2667() {
        this.runWarningTest(new String[]{"Either.java", "import java.util.NoSuchElementException;\n\npublic sealed interface Either<L,R> {\n\n    L getLeft();\n    R getRight();\n\n    record Left<L, R>(L error) implements Either<L, R> {\n        @Override\n        public L getLeft() {\n            return error;\n        }\n        @Override\n        public R getRight() {\n            throw new NoSuchElementException();\n        }\n    }\n\n    record Right<L, R>(R value) implements Either<L, R> {\n        @Override\n        public L getLeft() {\n            throw new NoSuchElementException();\n        }\n        @Override\n        public R getRight() {\n            return value;\n        }\n    }\n\n    public static void main(String[] args) {\n        Object o = new Left<String, Integer>(\"boo\");\n        var either = (Either<String, Integer>) o;\n        System.out.println(either.getLeft());\n    }\n}\n"}, "----------\n1. WARNING in Either.java (at line 32)\n\tvar either = (Either<String, Integer>) o;\n\t             ^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: Unchecked cast from Object to Either<String,Integer>\n----------\n", "boo");
    }

    public void testIssue2672() {
        this.runNegativeTest(new String[]{"test/IShape.java", "package test;\n\npublic sealed interface IShape permits Circle {\\n}\nclass Circle {\n}\n"}, "----------\n1. ERROR in test\\IShape.java (at line 3)\n\tpublic sealed interface IShape permits Circle {\\n}\n\t                                       ^^^^^^\nPermitted type Circle does not declare test.IShape as direct super interface \n----------\n2. ERROR in test\\IShape.java (at line 3)\n\tpublic sealed interface IShape permits Circle {\\n}\n\t                                               ^^\nSyntax error on tokens, delete these tokens\n----------\n");
    }

    public void testIssue2654() {
        this.runNegativeTest(new String[]{"X.java", "non-sealed public class X {\n\tint foo(int non, int sealed) {\n\t\treturn non-sealed;\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tnon-sealed public class X {\n\t                        ^\nThe non-sealed class X must have a sealed direct supertype\n----------\n");
    }

    public void testIssue2654_2() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tstatic int foo(int non, int sealed) {\n\t\treturn non-sealed;\n\t}\n    public static void main(String [] args) {\n        System.out.println(foo(142, 100));\n    }\n}\n"}, "42");
    }

    public void testIssue2707() {
        this.runNegativeTest(new String[]{"X.java", "public sealed class X permits Y {\n}\n\nsealed non-sealed class Y extends X permits K {}\n\nfinal class K extends Y {}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tsealed non-sealed class Y extends X permits K {}\n\t                        ^\nThe type Y may have only one modifier out of sealed, non-sealed, and final\n----------\n");
    }

    public void testIssue2707_2() {
        this.runNegativeTest(new String[]{"X.java", "public sealed class X permits Y {\n}\n\nfinal non-sealed class Y extends X  {}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tfinal non-sealed class Y extends X  {}\n\t                       ^\nThe type Y may have only one modifier out of sealed, non-sealed, and final\n----------\n");
    }

    public void testIssue2707_3() {
        this.runNegativeTest(new String[]{"X.java", "public final sealed class X permits Y {\n}\n\nfinal non-sealed class Y extends X  {}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic final sealed class X permits Y {\n\t                          ^\nThe type X may have only one modifier out of sealed, non-sealed, and final\n----------\n2. ERROR in X.java (at line 4)\n\tfinal non-sealed class Y extends X  {}\n\t                       ^\nThe type Y may have only one modifier out of sealed, non-sealed, and final\n----------\n");
    }

    public void testIssue3100() {
        this.runNegativeTest(new String[]{"X.java", "public sealed non-sealed interface X {}\nfinal class Y implements X  {}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic sealed non-sealed interface X {}\n\t                                   ^\nThe type X may have only one modifier out of sealed, non-sealed, and final\n----------\n");
    }

    public void testIssue3144() {
        this.runNegativeTest(new String[]{"I.java", "@FunctionalInterface\npublic sealed interface I { void doit(); }\nfinal class Y implements I  { public void doit() {} }\n"}, "----------\n1. ERROR in I.java (at line 2)\n\tpublic sealed interface I { void doit(); }\n\t                        ^\nA functional interface may not be declared sealed\n----------\n");
    }

    public void testIssue3039() {
        this.runNegativeTest(new String[]{"X.java", "public sealed class X permits X.C {\n    private final static class C extends X implements I {}\n}\n\nsealed interface I permits X.C {}\nrecord R(X.C xc, R.C rc) {\n    private class C {}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tsealed interface I permits X.C {}\n\t                           ^^^\nThe type X.C is not visible\n----------\n2. ERROR in X.java (at line 6)\n\trecord R(X.C xc, R.C rc) {\n\t         ^^^\nThe type X.C is not visible\n----------\n");
    }

    public void testIssue3121() {
        this.runNegativeTest(new String[]{"X.java", "interface SuperInt {}\n\nabstract sealed class Maybe<N extends Number> {\n\tfinal class Maybe1 extends Maybe<Long> {}\n\tfinal class Maybe2 extends Maybe<Long> implements SuperInt {}\n}\n\n\nabstract sealed class SurelyNot<N extends Number> {\n\tfinal class SurelyNot1 extends SurelyNot<Long> {}\n\tfinal class SurelyNot2 extends SurelyNot<Long> {}\n}\n\nabstract sealed class SurelyYes<N extends Number> {\n\tfinal class SurelyYes1 extends SurelyYes<Long> implements SuperInt {}\n\tfinal class SurelyYes2 extends SurelyYes<Long> implements SuperInt {}\n}\n\nclass Test {\n\n\tvoid testMaybe(Maybe<?> maybe, SurelyNot<?> surelyNot, SurelyYes<?> surelyYes) {\n\t\tif (maybe == null || surelyNot == null || surelyYes == null) return;\n\t\tif (maybe instanceof SuperInt sup) {}\n\t\tif (surelyNot instanceof SuperInt sup) {}\n\t\tif (surelyYes instanceof SuperInt sup) {}\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 24)\n\tif (surelyNot instanceof SuperInt sup) {}\n\t    ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nIncompatible conditional operand types SurelyNot<capture#5-of ?> and SuperInt\n----------\n");
    }

    public void testIssue3121_2() {
        this.runNegativeTest(new String[]{"X.java", "interface SuperInt {}\n\nclass Outer<T> {\n\tabstract sealed class Maybe<N extends Number> {\n\t\tfinal class Maybe1 extends Maybe<Long> {}\n\t}\n}\n\nclass Test {\n\n\tvoid testMaybe(Outer<String>.Maybe<?> maybe) {\n\t\tif (maybe instanceof SuperInt sup) {}\n\t\treturn null;\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 12)\n\tif (maybe instanceof SuperInt sup) {}\n\t    ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nIncompatible conditional operand types Outer<String>.Maybe<capture#1-of ?> and SuperInt\n----------\n2. ERROR in X.java (at line 13)\n\treturn null;\n\t^^^^^^^^^^^^\nVoid methods cannot return a value\n----------\n");
    }

    public void testIssue3121_2_1() {
        this.runNegativeTest(new String[]{"X.java", "interface SuperInt {}\n\nclass Outer<T> {\n\tabstract sealed class Maybe<N extends Number> {\n\t\tfinal class Maybe1 extends Maybe<Long> implements SuperInt {}\n\t}\n}\n\nclass Test {\n\n\tvoid testMaybe(Outer<String>.Maybe<?> maybe) {\n\t\tif (maybe instanceof SuperInt sup) {}\n\t\treturn null;\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 13)\n\treturn null;\n\t^^^^^^^^^^^^\nVoid methods cannot return a value\n----------\n");
    }

    public void testIssue3121_3() {
        this.runNegativeTest(new String[]{"X.java", "interface SuperInt {}\n\nclass Outer<T> {\n\tabstract sealed class Maybe<N extends Number> {\n\t\tfinal class Maybe1 extends Outer<Test>.Maybe<Long> {}\n\t}\n}\n\nclass Test {\n\n\tvoid testMaybe(Outer<Test>.Maybe<?> maybe) {\n\t\tif (maybe == null) return;\n\t\tif (maybe instanceof SuperInt sup) {}\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 13)\n\tif (maybe instanceof SuperInt sup) {}\n\t    ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nIncompatible conditional operand types Outer<Test>.Maybe<capture#2-of ?> and SuperInt\n----------\n");
    }

    public void testIssue3121_4() {
        this.runNegativeTest(new String[]{"X.java", "interface SuperInt {}\n\nclass Outer<T> {\n\tabstract sealed class Maybe<N extends Number> {\n\t\tfinal class Maybe1 extends Outer<Test>.Maybe<Long> implements SuperInt {}\n\t}\n}\n\nclass Test {\n\n\tvoid testMaybe(Outer<Test>.Maybe<?> maybe) {\n\t\tif (maybe == null) return;\n\t\tif (maybe instanceof SuperInt sup) {}\n\t\treturn null;\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 14)\n\treturn null;\n\t^^^^^^^^^^^^\nVoid methods cannot return a value\n----------\n");
    }

    public void testIssue3121_5() {
        this.runNegativeTest(new String[]{"X.java", "interface SuperInt {}\n\nclass Outer<T> {\n\tabstract sealed class Maybe<N extends Number> {\n\t\tfinal class Maybe1 extends Outer<Test>.Maybe<Long> implements SuperInt {}\n\t}\n}\n\nclass Test {\n\n\tvoid testMaybe(Outer<String>.Maybe<?> maybe) {\n\t\tif (maybe == null) return;\n\t\tif (maybe instanceof SuperInt sup) {}\n\t\treturn null;\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 13)\n\tif (maybe instanceof SuperInt sup) {}\n\t    ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nIncompatible conditional operand types Outer<String>.Maybe<capture#2-of ?> and SuperInt\n----------\n2. ERROR in X.java (at line 14)\n\treturn null;\n\t^^^^^^^^^^^^\nVoid methods cannot return a value\n----------\n");
    }

    public void testIssue3007() {
        this.runNegativeTest(new String[]{"X.java", "public sealed class X extends Y<String> permits Y {\n\tint yield () {\n\t\treturn this.yield();\n\t}\n}\n\nsealed class Y<T> extends X permits X, Z {\n\n}\n\nfinal class Z extends Y<String> {}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic sealed class X extends Y<String> permits Y {\n\t                    ^\nThe hierarchy of the type X is inconsistent\n----------\n2. ERROR in X.java (at line 7)\n\tsealed class Y<T> extends X permits X, Z {\n\t                          ^\nCycle detected: a cycle exists in the type hierarchy between Y<T> and X\n----------\n3. ERROR in X.java (at line 11)\n\tfinal class Z extends Y<String> {}\n\t            ^\nThe hierarchy of the type Z is inconsistent\n----------\n");
    }

    public void testIssue3007_2() {
        this.runNegativeTest(new String[]{"X.java", "public class X extends Y<String> {\n\tint yield () {\n\t\treturn this.yield();\n\t}\n}\n\nclass Y<T> extends X {\n\n}\n\nfinal class Z extends Y<String> {}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X extends Y<String> {\n\t             ^\nThe hierarchy of the type X is inconsistent\n----------\n2. ERROR in X.java (at line 7)\n\tclass Y<T> extends X {\n\t                   ^\nCycle detected: a cycle exists in the type hierarchy between Y<T> and X\n----------\n3. ERROR in X.java (at line 11)\n\tfinal class Z extends Y<String> {}\n\t            ^\nThe hierarchy of the type Z is inconsistent\n----------\n");
    }

    public void testIssue2709() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    sealed interface I permits C1 {}\n    non-sealed class C1 implements I {}\n    class C2 extends C1 {}\n    class C3 {}\n    {\n        I i;\n        i = (I) (C1) null;\n        i = (I) (C2) null;\n        i = (I) (C3) null;\n        i = (C2) (C3) null;\n        i = (C1) (C3) null;\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 10)\n\ti = (I) (C3) null;\n\t    ^^^^^^^^^^^^^\nCannot cast from X.C3 to X.I\n----------\n2. ERROR in X.java (at line 11)\n\ti = (C2) (C3) null;\n\t    ^^^^^^^^^^^^^^\nCannot cast from X.C3 to X.C2\n----------\n3. ERROR in X.java (at line 12)\n\ti = (C1) (C3) null;\n\t    ^^^^^^^^^^^^^^\nCannot cast from X.C3 to X.C1\n----------\n");
    }

    public void testJDK8343306() {
        Runner runner = new Runner();
        runner.testFiles = new String[]{"X1.java", "public class X1 {\n    sealed interface I permits C1 {}\n    non-sealed class C1 implements I {}\n    class C2 extends C1 {}\n    class C3 {}\n    I m2(int s, C3 c3) {\n        return switch (s) {\n            case 0 -> (I) c3;\n            default -> null;\n        };\n    }\n}\n"};
        runner.expectedCompilerLog = "----------\n1. ERROR in X1.java (at line 8)\n\tcase 0 -> (I) c3;\n\t          ^^^^^^\nCannot cast from X1.C3 to X1.I\n----------\n";
        runner.javacTestOptions = AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacBug8343306;
        runner.runNegativeTest();
    }

    class Runner
    extends AbstractRegressionTest.Runner {
        Runner() {
            this.vmArguments = new String[0];
            this.javacTestOptions = AbstractRegressionTest.JavacTestOptions.DEFAULT;
        }
    }
}

