/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;

public class SerialVersionUIDTests
extends AbstractRegressionTest {
    public SerialVersionUIDTests(String name) {
        super(name);
    }

    public static Test suite() {
        return SerialVersionUIDTests.buildAllCompliancesTestSuite(SerialVersionUIDTests.testClass());
    }

    public static Class testClass() {
        return SerialVersionUIDTests.class;
    }

    @Override
    protected Map getCompilerOptions() {
        Map<String, String> options = super.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.missingSerialVersion", "error");
        return options;
    }

    public void test001() {
        this.runConformTest(new String[]{"X.java", "import java.io.Serializable;\n\npublic class X implements Serializable {\n\tprivate void readObject(java.io.ObjectInputStream stream) throws java.io.IOException {}\n\tprivate void writeObject(java.io.ObjectOutputStream stream) throws java.io.IOException {}\n}"}, "");
    }

    public void test002() {
        this.runConformTest(new String[]{"X.java", "public class X implements java.io.Externalizable {\n\tpublic void writeExternal(java.io.ObjectOutput out) throws java.io.IOException {}\n\tpublic void readExternal(java.io.ObjectInput in) throws java.io.IOException, ClassNotFoundException {}\n}"}, "");
    }

    public void test003() {
        this.runNegativeTest(new String[]{"X.java", "public class X implements java.io.Serializable {\n\tprivate void writeObject(java.io.ObjectOutputStream stream) throws java.io.IOException {}\n}"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X implements java.io.Serializable {\n\t             ^\nThe serializable class X does not declare a static final serialVersionUID field of type long\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test004() {
        this.runNegativeTest(new String[]{"X.java", "public class X implements java.io.Serializable {\n\tprivate void readObject(java.io.ObjectInputStream stream) throws java.io.IOException {}\n}"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X implements java.io.Serializable {\n\t             ^\nThe serializable class X does not declare a static final serialVersionUID field of type long\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test005() {
        this.runNegativeTest(new String[]{"X.java", "public class X implements java.io.Serializable {\n}"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X implements java.io.Serializable {\n\t             ^\nThe serializable class X does not declare a static final serialVersionUID field of type long\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test006() {
        this.runConformTest(new String[]{"X.java", "public class X implements java.io.Serializable {\n\tObject writeReplace() throws java.io.ObjectStreamException { return null;}\n}"}, "");
    }

    public void test007() {
        this.runNegativeTest(new String[]{"X.java", "abstract class A implements java.io.Serializable {}\npublic class X extends A {}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tabstract class A implements java.io.Serializable {}\n\t               ^\nThe serializable class A does not declare a static final serialVersionUID field of type long\n----------\n2. ERROR in X.java (at line 2)\n\tpublic class X extends A {}\n\t             ^\nThe serializable class X does not declare a static final serialVersionUID field of type long\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void _test008() {
        this.runConformTest(new String[]{"X.java", "public class X extends javax.rmi.CORBA.Stub {\n\tpublic String[] _ids() { return null; }\n}"}, "");
    }

    public void _test009() {
        this.runConformTest(new String[]{"X.java", "public class X extends Y {\n\tpublic String[] _ids() { return null; }\n}", "Y.java", "public abstract class Y extends javax.rmi.CORBA.Stub {\n}"}, "");
    }

    public void _test010() {
        this.runConformTest(new String[]{"X.java", "public class X extends Y {\n\tpublic String[] _ids() { return null; }\n}", "Y.java", "public abstract class Y extends Z {\n}", "Z.java", "public abstract class Z extends javax.rmi.CORBA.Stub {\n}"}, "");
    }

    public void test011() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "error");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tprivate static final long serialVersionUID = 1L;\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\tprivate static final long serialVersionUID = 1L;\n\t                          ^^^^^^^^^^^^^^^^\nThe value of the field X.serialVersionUID is not used\n----------\n", null, true, options);
    }

    public void test012() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "error");
        this.runNegativeTest(new String[]{"X.java", "public class X<T> {\n\tprivate static final long serialVersionUID = 1L;\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\tprivate static final long serialVersionUID = 1L;\n\t                          ^^^^^^^^^^^^^^^^\nThe value of the field X<T>.serialVersionUID is not used\n----------\n", null, true, options);
    }

    public void test013() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "error");
        this.runNegativeTest(new String[]{"X.java", "public class X<T> {\n\tprivate static final long serialPersistentFields = 1L;\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\tprivate static final long serialPersistentFields = 1L;\n\t                          ^^^^^^^^^^^^^^^^^^^^^^\nThe value of the field X<T>.serialPersistentFields is not used\n----------\n", null, true, options);
    }

    public void test014() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "error");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tprivate static final long serialPersistentFields = 1L;\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\tprivate static final long serialPersistentFields = 1L;\n\t                          ^^^^^^^^^^^^^^^^^^^^^^\nThe value of the field X.serialPersistentFields is not used\n----------\n", null, true, options);
    }

    public void test015() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "error");
        this.runNegativeTest(new String[]{"X.java", "import java.io.ObjectStreamField;\npublic class X<T> implements java.io.Serializable {\n\tprivate static final long serialVersionUID = 1L;\n\tprivate final static ObjectStreamField[] serialPersistentFields = null;\n\tprivate int i;\n}"}, "----------\n1. ERROR in X.java (at line 5)\n\tprivate int i;\n\t            ^\nThe value of the field X<T>.i is not used\n----------\n", null, true, options);
    }

    public void test016() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "error");
        this.runNegativeTest(new String[]{"X.java", "import java.io.ObjectStreamField;\npublic class X implements java.io.Serializable {\n\tprivate static final long serialVersionUID = 1L;\n\tprivate final static ObjectStreamField[] serialPersistentFields = null;\n\tprivate int i;\n}"}, "----------\n1. ERROR in X.java (at line 5)\n\tprivate int i;\n\t            ^\nThe value of the field X.i is not used\n----------\n", null, true, options);
    }
}

