/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.io.File;
import java.lang.reflect.Modifier;
import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;
import org.eclipse.jdt.core.util.IBootstrapMethodsEntry;
import org.eclipse.jdt.core.util.IClassFileAttribute;
import org.eclipse.jdt.core.util.IClassFileReader;
import org.eclipse.jdt.core.util.IConstantPool;
import org.eclipse.jdt.core.util.IConstantPoolEntry;
import org.eclipse.jdt.core.util.IConstantPoolEntry2;
import org.eclipse.jdt.core.util.IMethodInfo;
import org.eclipse.jdt.internal.core.util.BootstrapMethodsAttribute;

public class SerializableLambdaTest
extends AbstractRegressionTest {
    public static final String RUNNER_CLASS = "public class Y {\n  public static void main(String[]args) {\n    com.foo.X.main(args);\n  }\n}";
    private static final String HELPER_CLASS = "package util;\nimport java.io.*;\npublic class Helper {\npublic static void print(Object o ) {System.err.println(o);}\nstatic byte[][] data;\n\npublic static void write(Object o) { write(0,o); }\npublic static void write(int i, Object o) {\n    if (data==null) data=new byte[10][];\n    try {\n        ByteArrayOutputStream baos = new ByteArrayOutputStream();\n        ObjectOutputStream oos = new ObjectOutputStream(baos);\n        oos.writeObject(o);\n        oos.flush();\n        oos.close();\n        data[i] = baos.toByteArray();\n    } catch (Exception e) {\n    }\n}\n\npublic static Object read() { return read(0); }\npublic static Object read(int i) {\n    try {\n        ByteArrayInputStream bais = new ByteArrayInputStream(data[i]);\n        ObjectInputStream ois = new ObjectInputStream(bais);\n        Object o = ois.readObject();\n        ois.close();\n        return o;\n    } catch (Exception e) {\n    }\n    return null;\n}\n}\n";

    public static Class testClass() {
        return SerializableLambdaTest.class;
    }

    public static Test suite() {
        return SerializableLambdaTest.buildMinimalComplianceTestSuite(SerializableLambdaTest.testClass(), 32);
    }

    public SerializableLambdaTest(String testName) {
        super(testName);
    }

    @Override
    protected Map getCompilerOptions() {
        Map<String, String> defaultOptions = super.getCompilerOptions();
        defaultOptions.put("org.eclipse.jdt.core.compiler.compliance", "1.8");
        defaultOptions.put("org.eclipse.jdt.core.compiler.source", "1.8");
        defaultOptions.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.8");
        return defaultOptions;
    }

    public void test001_simple() throws Exception {
        this.runConformTest(new String[]{"X.java", "import java.io.*;\npublic class X {\n    interface Foo extends Serializable { int m(); }\n\n    public static void main(String[] args) {\n        Foo f1 = null;\n        f1 = () -> 3;\n        util.Helper.write(f1);\n        f1 = (Foo)util.Helper.read();\n        System.out.println(f1.m());\n    }\n}\n", "Helper.java", HELPER_CLASS}, "3", null, true, new String[]{"-Ddummy"});
        String expectedOutput = "0: invokestatic java/lang/invoke/LambdaMetafactory.altMetafactory:(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;[Ljava/lang/Object;)Ljava/lang/invoke/CallSite;\n  Method arguments:\n    ()I\n    invokestatic X.lambda$0:()I\n    ()I\n    1\n";
        String data = this.printBootstrapMethodsAttribute(OUTPUT_DIR + File.separator + "X.class");
        this.checkExpected(expectedOutput, data);
    }

    public void test002_simpleNonSerializable() throws Exception {
        this.runConformTest(new String[]{"X.java", "import java.io.*;\npublic class X {\n    interface Foo { int m(); }\n\n    public static void main(String[] args) {\n        Foo f1 = null;\n        f1 = () -> 3;\n        System.out.println(f1.m());\n    }\n}\n", "Helper.java", HELPER_CLASS}, "3");
        String expectedOutput = "0: invokestatic java/lang/invoke/LambdaMetafactory.metafactory:(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodHandle;Ljava/lang/invoke/MethodType;)Ljava/lang/invoke/CallSite;\n  Method arguments:\n    ()I\n    invokestatic X.lambda$0:()I\n    ()I\n";
        String data = this.printBootstrapMethodsAttribute(OUTPUT_DIR + File.separator + "X.class");
        this.checkExpected(expectedOutput, data);
    }

    public void test003_twoSerializedLambdas() throws Exception {
        this.runConformTest(new String[]{"X.java", "import java.io.*;\npublic class X {\n    interface Foo extends Serializable { int m(); }\n\n    public static void main(String[] args) {\n        Foo f1 = null, f2 = null;\n        f1 = () -> 33;\n        f2 = () -> 99;\n        util.Helper.write(0,f1);\n        util.Helper.write(1,f2);\n        f2 = (Foo)util.Helper.read(1);\n        f1 = (Foo)util.Helper.read(0);\n        System.out.println(f1.m());\n        System.out.println(f2.m());\n    }\n}\n", "Helper.java", HELPER_CLASS}, "33\n99", null, true, new String[]{"-Ddummy"});
        String expectedOutput = "0: invokestatic java/lang/invoke/LambdaMetafactory.altMetafactory:(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;[Ljava/lang/Object;)Ljava/lang/invoke/CallSite;\n  Method arguments:\n    ()I\n    invokestatic X.lambda$0:()I\n    ()I\n    1\n1: invokestatic java/lang/invoke/LambdaMetafactory.altMetafactory:(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;[Ljava/lang/Object;)Ljava/lang/invoke/CallSite;\n  Method arguments:\n    ()I\n    invokestatic X.lambda$1:()I\n    ()I\n    1\n";
        String data = this.printBootstrapMethodsAttribute(OUTPUT_DIR + File.separator + "X.class");
        this.checkExpected(expectedOutput, data);
    }

    public void test004_lambdaWithParameterInPackage() throws Exception {
        this.runConformTest(new String[]{"Y.java", RUNNER_CLASS, "X.java", "package com.foo;\nimport java.io.*;\npublic class X {\n    interface Foo extends Serializable { int m(int i); }\n\n    public static void main(String[] args) {\n        Foo f1 = null, f2 = null;\n        f1 = (i) -> i*2;\n        util.Helper.write(f1);\n        f1 = (Foo)util.Helper.read();\n        System.out.println(f1.m(4));\n    }\n}\n", "Helper.java", HELPER_CLASS}, "8", null, true, new String[]{"-Ddummy"});
        String expectedOutput = "0: invokestatic java/lang/invoke/LambdaMetafactory.altMetafactory:(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;[Ljava/lang/Object;)Ljava/lang/invoke/CallSite;\n  Method arguments:\n    (I)I\n    invokestatic com/foo/X.lambda$0:(I)I\n    (I)I\n    1\n";
        String data = this.printBootstrapMethodsAttribute(OUTPUT_DIR + File.separator + "com" + File.separator + "foo" + File.separator + "X.class");
        this.checkExpected(expectedOutput, data);
    }

    public void test005_capturingVariableLambdaWithParameterInPackage() throws Exception {
        this.runConformTest(new String[]{"Y.java", RUNNER_CLASS, "X.java", "package com.foo;\nimport java.io.*;\npublic class X {\n    interface Foo extends Serializable { int m(int i); }\n\n    public static void main(String[] args) {\n        Foo f1 = null;\n        int multiplier = 3;\n        f1 = (i) -> i * multiplier;\n        util.Helper.write(f1);\n        f1 = (Foo)util.Helper.read();\n        System.out.println(f1.m(4));\n    }\n}\n", "Helper.java", HELPER_CLASS}, "12", null, true, new String[]{"-Ddummy"});
        String expectedOutput = "0: invokestatic java/lang/invoke/LambdaMetafactory.altMetafactory:(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;[Ljava/lang/Object;)Ljava/lang/invoke/CallSite;\n  Method arguments:\n    (I)I\n    invokestatic com/foo/X.lambda$0:(II)I\n    (I)I\n    1\n";
        String data = this.printBootstrapMethodsAttribute(OUTPUT_DIR + File.separator + "com" + File.separator + "foo" + File.separator + "X.class");
        this.checkExpected(expectedOutput, data);
    }

    public void test006_capturingVariableLambdaWithParameterInPackage() throws Exception {
        this.runConformTest(new String[]{"Y.java", RUNNER_CLASS, "X.java", "package com.foo;\nimport java.io.*;\npublic class X {\n    interface Foo extends Serializable { int m(String n); }\n\n    public static void main(String[] args) {\n        Foo f1 = null;\n        int multiplier = 3;\n        f1 = (n) -> Integer.valueOf(n) * multiplier;\n        util.Helper.write(f1);\n        f1 = (Foo)util.Helper.read();\n        System.out.println(f1.m(\"33\"));\n    }\n}\n", "Helper.java", HELPER_CLASS}, "99", null, true, new String[]{"-Ddummy"});
        String expectedOutput = "0: invokestatic java/lang/invoke/LambdaMetafactory.altMetafactory:(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;[Ljava/lang/Object;)Ljava/lang/invoke/CallSite;\n  Method arguments:\n    (Ljava/lang/String;)I\n    invokestatic com/foo/X.lambda$0:(ILjava/lang/String;)I\n    (Ljava/lang/String;)I\n    1\n";
        String data = this.printBootstrapMethodsAttribute(OUTPUT_DIR + File.separator + "com" + File.separator + "foo" + File.separator + "X.class");
        this.checkExpected(expectedOutput, data);
    }

    public void xtest007_capturingFieldLambdaWithParameterInPackage() throws Exception {
        this.runConformTest(new String[]{"Y.java", RUNNER_CLASS, "X.java", "package com.foo;\nimport java.io.*;\npublic class X {\n    int multiplier = 3;\n    interface Foo extends Serializable { int m(int i); }\n\n    public static void main(String[] args) {\n      new X().run();\n    }\n    public void run() {\n        Foo f1 = null;\n        f1 = (i) -> i * this.multiplier;\n        util.Helper.write(f1);\n        f1 = (Foo)util.Helper.read();\n        System.out.println(f1.m(4));\n    }\n}\n", "Helper.java", HELPER_CLASS}, "12", null, true, new String[]{"-Ddummy"});
        String expectedOutput = "0: invokestatic java/lang/invoke/LambdaMetafactory.altMetafactory:(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;[Ljava/lang/Object;)Ljava/lang/invoke/CallSite;\n  Method arguments:\n    (I)I\n    invokestatic com/foo/X.lambda$0:(II)I\n    (I)I\n    1\n";
        String data = this.printBootstrapMethodsAttribute(OUTPUT_DIR + File.separator + "com" + File.separator + "foo" + File.separator + "X.class");
        this.checkExpected(expectedOutput, data);
    }

    public void test008_capturingTwoVariableLambdaWithParameterInPackage() throws Exception {
        this.runConformTest(new String[]{"Y.java", RUNNER_CLASS, "X.java", "package com.foo;\nimport java.io.*;\npublic class X {\n    interface Foo extends Serializable { float m(int i, float f); }\n\n    public static void main(String[] args) {\n      new X().run();\n    }\n    public void run() {\n        Foo f1 = null;\n        f1 = (i,f) -> ((float)i) * f;\n        util.Helper.write(f1);\n        f1 = (Foo)util.Helper.read();\n        System.out.println(f1.m(3,4.0f));\n    }\n}\n", "Helper.java", HELPER_CLASS}, "12.0", null, true, new String[]{"-Ddummy"});
        String expectedOutput = "0: invokestatic java/lang/invoke/LambdaMetafactory.altMetafactory:(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;[Ljava/lang/Object;)Ljava/lang/invoke/CallSite;\n  Method arguments:\n    (IF)F\n    invokestatic com/foo/X.lambda$0:(IF)F\n    (IF)F\n    1\n";
        String data = this.printBootstrapMethodsAttribute(OUTPUT_DIR + File.separator + "com" + File.separator + "foo" + File.separator + "X.class");
        this.checkExpected(expectedOutput, data);
    }

    public void test009_capturingTwoSlotVariablesLambdaWithParameterInPackage() throws Exception {
        this.runConformTest(new String[]{"Y.java", RUNNER_CLASS, "X.java", "package com.foo;\nimport java.io.*;\npublic class X {\n    interface Foo extends Serializable { double m(int i, long l); }\n\n    public static void main(String[] args) {\n      new X().run();\n    }\n    public void run() {\n        Foo f1 = null;\n        f1 = (i,l) -> (double)(i*l);\n        util.Helper.write(f1);\n        f1 = (Foo)util.Helper.read();\n        System.out.println(f1.m(3,40L));\n    }\n}\n", "Helper.java", HELPER_CLASS}, "120.0", null, true, new String[]{"-Ddummy"});
        String expectedOutput = "0: invokestatic java/lang/invoke/LambdaMetafactory.altMetafactory:(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;[Ljava/lang/Object;)Ljava/lang/invoke/CallSite;\n  Method arguments:\n    (IJ)D\n    invokestatic com/foo/X.lambda$0:(IJ)D\n    (IJ)D\n    1\n";
        String data = this.printBootstrapMethodsAttribute(OUTPUT_DIR + File.separator + "com" + File.separator + "foo" + File.separator + "X.class");
        this.checkExpected(expectedOutput, data);
    }

    public void test010_VarargsLambdaExpression() throws Exception {
        this.runConformTest(new String[]{"Y.java", RUNNER_CLASS, "X.java", "package com.foo;\nimport java.io.*;\npublic class X {\n    interface Foo extends Serializable { String m(String... ss); }\n\n    public static void main(String[] args) {\n      new X().run();\n    }\n    public void run() {\n        Foo f1 = null;\n        f1 = (strings) -> strings[0]+strings[1];\n        util.Helper.write(f1);\n        f1 = (Foo)util.Helper.read();\n        System.out.println(f1.m(\"abc\",\"def\"));\n    }\n}\n", "Helper.java", HELPER_CLASS}, "abcdef", null, true, new String[]{"-Ddummy"});
        String expectedOutput = "0: invokestatic java/lang/invoke/LambdaMetafactory.altMetafactory:(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;[Ljava/lang/Object;)Ljava/lang/invoke/CallSite;\n  Method arguments:\n    ([Ljava/lang/String;)Ljava/lang/String;\n    invokestatic com/foo/X.lambda$0:([Ljava/lang/String;)Ljava/lang/String;\n    ([Ljava/lang/String;)Ljava/lang/String;\n    1\n";
        String data = this.printBootstrapMethodsAttribute(OUTPUT_DIR + File.separator + "com" + File.separator + "foo" + File.separator + "X.class");
        this.checkExpected(expectedOutput, data);
    }

    public void xtest011_CapturingInstance() throws Exception {
        this.runConformTest(new String[]{"Y.java", RUNNER_CLASS, "X.java", "package com.foo;\nimport java.io.*;\npublic class X {\n    interface Foo extends Serializable { String m(); }\n\n    String fieldValue = \"hello\";\n    public static void main(String[] args) {\n      new X().run();\n    }\n    public void run() {\n        Foo f1 = null;\n        f1 = () -> this.fieldValue;\n        util.Helper.write(f1);\n        f1 = (Foo)util.Helper.read();\n        System.out.println(f1.m());\n    }\n}\n", "Helper.java", HELPER_CLASS}, "abcdef", null, true, new String[]{"-Ddummy"});
        String expectedOutput = "0: invokestatic java/lang/invoke/LambdaMetafactory.altMetafactory:(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;[Ljava/lang/Object;)Ljava/lang/invoke/CallSite;\n  Method arguments:\n    ([Ljava/lang/String;)Ljava/lang/String;\n    invokestatic com/foo/X.lambda$0:([Ljava/lang/String;)Ljava/lang/String;\n    ([Ljava/lang/String;)Ljava/lang/String;\n    1\n";
        String data = this.printBootstrapMethodsAttribute(OUTPUT_DIR + File.separator + "com" + File.separator + "foo" + File.separator + "X.class");
        this.checkExpected(expectedOutput, data);
    }

    public void test012_intersectionCast() throws Exception {
        this.runConformTest(new String[]{"X.java", "import java.io.*;\npublic class X {\n    interface Foo extends Serializable { int m(); }\n    interface Marker {}\n\n    public static void main(String[] args) {\n        Foo f1 = null;\n        f1 = (Foo & Marker) () -> 3;\n        System.out.println(\"isMarker?\"+(f1 instanceof Marker));\n        util.Helper.write(f1);\n        f1 = (Foo)util.Helper.read();\n        System.out.println(f1.m());\n        System.out.println(\"isMarker?\"+(f1 instanceof Marker));\n    }\n}\n", "Helper.java", HELPER_CLASS}, "isMarker?true\n3\nisMarker?true", null, true, new String[]{"-Ddummy"});
        String expectedOutput = "0: invokestatic java/lang/invoke/LambdaMetafactory.altMetafactory:(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;[Ljava/lang/Object;)Ljava/lang/invoke/CallSite;\n  Method arguments:\n    ()I\n    invokestatic X.lambda$0:()I\n    ()I\n    3\n    1\n    X$Marker\n";
        String data = this.printBootstrapMethodsAttribute(OUTPUT_DIR + File.separator + "X.class");
        this.checkExpected(expectedOutput, data);
    }

    public void test013_intersectionCast() throws Exception {
        this.runConformTest(new String[]{"X.java", "import java.io.*;\ninterface Goo {}\npublic class X {\n    interface Foo extends Serializable { int m(); }\n    interface Marker {}\n\n    public static void main(String[] args) {\n        Foo f1 = null;\n        f1 = (Foo & Goo & Serializable & Marker) () -> 3;\n        System.out.println(\"isMarker?\"+(f1 instanceof Marker));\n        System.out.println(\"isGoo?\"+(f1 instanceof Goo));\n        System.out.println(\"isSerializable?\"+(f1 instanceof Serializable));\n        util.Helper.write(f1);\n        f1 = (Foo)util.Helper.read();\n        System.out.println(f1.m());\n        System.out.println(\"isMarker?\"+(f1 instanceof Marker));\n        System.out.println(\"isGoo?\"+(f1 instanceof Goo));\n        System.out.println(\"isSerializable?\"+(f1 instanceof Serializable));\n    }\n}\n", "Helper.java", HELPER_CLASS}, "isMarker?true\nisGoo?true\nisSerializable?true\n3\nisMarker?true\nisGoo?true\nisSerializable?true", null, true, new String[]{"-Ddummy"});
        String expectedOutput = "0: invokestatic java/lang/invoke/LambdaMetafactory.altMetafactory:(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;[Ljava/lang/Object;)Ljava/lang/invoke/CallSite;\n  Method arguments:\n    ()I\n    invokestatic X.lambda$0:()I\n    ()I\n    3\n    2\n    Goo\n    X$Marker\n";
        String data = this.printBootstrapMethodsAttribute(OUTPUT_DIR + File.separator + "X.class");
        this.checkExpected(expectedOutput, data);
    }

    public void test014_intersectionCastAndNotSerializable() throws Exception {
        this.runConformTest(new String[]{"X.java", "import java.io.*;\ninterface Goo {}\npublic class X {\n    interface Foo { int m(); }\n    interface Marker {}\n\n    public static void main(String[] args) {\n        Foo f1 = null;\n        f1 = (Foo & Goo & Marker) () -> 3;\n        System.out.println(\"isMarker?\"+(f1 instanceof Marker));\n        System.out.println(\"isGoo?\"+(f1 instanceof Goo));\n        System.out.println(\"isSerializable?\"+(f1 instanceof Serializable));\n        System.out.println(f1.m());\n    }\n}\n", "Helper.java", HELPER_CLASS}, "isMarker?true\nisGoo?true\nisSerializable?false\n3", null, true, new String[]{"-Ddummy"});
        String expectedOutput = "0: invokestatic java/lang/invoke/LambdaMetafactory.altMetafactory:(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;[Ljava/lang/Object;)Ljava/lang/invoke/CallSite;\n  Method arguments:\n    ()I\n    invokestatic X.lambda$0:()I\n    ()I\n    2\n    2\n    Goo\n    X$Marker\n";
        String data = this.printBootstrapMethodsAttribute(OUTPUT_DIR + File.separator + "X.class");
        this.checkExpected(expectedOutput, data);
    }

    public void test015_serializableViaIntersectionCast() throws Exception {
        this.runConformTest(new String[]{"X.java", "import java.io.*;\ninterface Goo {}\npublic class X {\n    interface Foo { int m(); }\n    interface Marker {}\n\n    public static void main(String[] args) {\n        Foo f1 = null;\n        f1 = (Foo & Goo & Serializable & Marker) () -> 3;\n        System.out.println(\"isMarker?\"+(f1 instanceof Marker));\n        System.out.println(\"isGoo?\"+(f1 instanceof Goo));\n        System.out.println(\"isSerializable?\"+(f1 instanceof Serializable));\n        util.Helper.write(f1);\n        f1 = (Foo)util.Helper.read();\n        System.out.println(f1.m());\n        System.out.println(\"isMarker?\"+(f1 instanceof Marker));\n        System.out.println(\"isGoo?\"+(f1 instanceof Goo));\n        System.out.println(\"isSerializable?\"+(f1 instanceof Serializable));\n    }\n}\n", "Helper.java", HELPER_CLASS}, "isMarker?true\nisGoo?true\nisSerializable?true\n3\nisMarker?true\nisGoo?true\nisSerializable?true", null, true, new String[]{"-Ddummy"});
        String expectedOutput = "0: invokestatic java/lang/invoke/LambdaMetafactory.altMetafactory:(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;[Ljava/lang/Object;)Ljava/lang/invoke/CallSite;\n  Method arguments:\n    ()I\n    invokestatic X.lambda$0:()I\n    ()I\n    3\n    2\n    Goo\n    X$Marker\n";
        String data = this.printBootstrapMethodsAttribute(OUTPUT_DIR + File.separator + "X.class");
        this.checkExpected(expectedOutput, data);
    }

    public void test016_bug424211() throws Exception {
        this.runConformTest(new String[]{"X.java", "import java.io.Serializable;\npublic class X {\n\tpublic static void main(String argv[]) throws Exception {\n\t\tAutoCloseable one = ((Serializable & AutoCloseable) (() -> {}));\n\t\tone.close();\n\t}\n}"}, "", null, true, new String[]{"-Ddummy"});
        String expectedOutput = "0: invokestatic java/lang/invoke/LambdaMetafactory.altMetafactory:(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;[Ljava/lang/Object;)Ljava/lang/invoke/CallSite;\n  Method arguments:\n    ()V\n    invokestatic X.lambda$0:()V\n    ()V\n    1\n";
        String data = this.printBootstrapMethodsAttribute(OUTPUT_DIR + File.separator + "X.class");
        this.checkExpected(expectedOutput, data);
    }

    public void test017_bug424211() throws Exception {
        this.runConformTest(new String[]{"X.java", "import java.io.Serializable;\npublic class X {\n\tpublic static void main(String argv[]) throws Exception {\n\t\tAutoCloseable one = ((AutoCloseable & Serializable) (() -> {}));\n\t\tone.close();\n\t}\n}"}, "", null, true, new String[]{"-Ddummy"});
        String expectedOutput = "0: invokestatic java/lang/invoke/LambdaMetafactory.altMetafactory:(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;[Ljava/lang/Object;)Ljava/lang/invoke/CallSite;\n  Method arguments:\n    ()V\n    invokestatic X.lambda$0:()V\n    ()V\n    1\n";
        String data = this.printBootstrapMethodsAttribute(OUTPUT_DIR + File.separator + "X.class");
        this.checkExpected(expectedOutput, data);
    }

    public void test018_bug424211() throws Exception {
        this.runConformTest(new String[]{"X.java", "import java.io.Serializable;\ninterface Marker {}\npublic class X {\n\tpublic static void main(String argv[]) throws Exception {\n\t\tAutoCloseable one = ((Marker & AutoCloseable) (() -> {}));\n\t\tone.close();\n\t}\n}"}, "", null, true, new String[]{"-Ddummy"});
        String expectedOutput = "0: invokestatic java/lang/invoke/LambdaMetafactory.altMetafactory:(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;[Ljava/lang/Object;)Ljava/lang/invoke/CallSite;\n  Method arguments:\n    ()V\n    invokestatic X.lambda$0:()V\n    ()V\n    2\n    1\n    Marker\n";
        String data = this.printBootstrapMethodsAttribute(OUTPUT_DIR + File.separator + "X.class");
        this.checkExpected(expectedOutput, data);
    }

    public void test019_bug424211() throws Exception {
        this.runConformTest(new String[]{"X.java", "import java.io.Serializable;\ninterface SAM {int m();}\npublic class X {\n\tpublic static void main(String argv[]) throws Exception {\n\t\tSAM one = ((Serializable & SAM) (() -> 3));\n        System.out.println(one.m());\n        util.Helper.write(one);\n        one = (SAM)util.Helper.read();\n        System.out.println(one.m());\n\t}\n}", "Helper.java", HELPER_CLASS}, "3\n3", null, true, new String[]{"-Ddummy"});
        String expectedOutput = "0: invokestatic java/lang/invoke/LambdaMetafactory.altMetafactory:(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;[Ljava/lang/Object;)Ljava/lang/invoke/CallSite;\n  Method arguments:\n    ()I\n    invokestatic X.lambda$0:()I\n    ()I\n    1\n";
        String data = this.printBootstrapMethodsAttribute(OUTPUT_DIR + File.separator + "X.class");
        this.checkExpected(expectedOutput, data);
    }

    public void test020_lambdaNames() throws Exception {
        this.runConformTest(new String[]{"X.java", "import java.io.Serializable;\ninterface Foo {int m();}\ninterface FooN extends Serializable {int m();}\npublic class X {\n\tpublic static void main(String argv[]) throws Exception {\n\t\tAutoCloseable one = () -> {};\n       new X().m();\n       one.close();\n\t}\n   public void m() { Foo f = () -> 3; System.out.println(f.m());}\n   public void n() { FooN f = () -> 3; System.out.println(f.m());}\n}"}, "3", null, true, new String[]{"-Ddummy"});
        String expectedOutput = "  private static synthetic void lambda$0() throws java.lang.Exception;\n";
        this.checkDisassembledClassFile(OUTPUT_DIR + File.separator + "X.class", "X", expectedOutput, 4);
        expectedOutput = "  private static synthetic int lambda$1();\n";
        this.checkDisassembledClassFile(OUTPUT_DIR + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test021_lambdaNamesVariants() throws Exception {
        this.runConformTest(new String[]{"X.java", "import java.io.Serializable;\ninterface Foo {int m();}\ninterface FooSer extends Serializable {int m();}\ninterface FooI {int m(int i);}\ninterface FooSerI extends Serializable {int m(int i);}\npublic class X {\n\n   Foo instanceField = () -> 1;\n   FooSer instanceFieldSer = () -> 2;\n   static Foo staticField = () -> 3;\n   static FooSer staticFieldSer = () -> 4;\n   FooI instanceFieldI = (i) -> 5;\n   FooSerI instanceFieldSerI = (i) -> 6;\n\n\tpublic static void main(String argv[]) throws Exception {\n     int x = 4;\n     Foo a = () -> 1;\n     FooSer b = () -> 2;\n     FooI c = (i) -> 3;\n     FooSerI d = (i) -> 4;\n     Foo e = () -> x;\n     FooSer f = () -> x+1;\n     FooI g = (i) -> x+2;\n     FooSerI h = (i) -> x+3;\n\t}\n}"}, "", null, true, new String[]{"-Ddummy"});
        String expectedOutput = "static lambda$2()I\nstatic lambda$3()I\nstatic lambda$0()I\nstatic lambda$1()I\nstatic lambda$4(I)I\nstatic lambda$5(I)I\nstatic lambda$6()I\nstatic lambda$7()I\nstatic lambda$8(I)I\nstatic lambda$9(I)I\nstatic lambda$10(I)I\nstatic lambda$11(I)I\nstatic lambda$12(II)I\nstatic lambda$13(II)I\n";
        String actualOutput = this.printLambdaMethods(OUTPUT_DIR + File.separator + "X.class");
        if (!actualOutput.equals(expectedOutput)) {
            this.printIt(actualOutput);
            SerializableLambdaTest.assertEquals(expectedOutput, actualOutput);
        }
    }

    public void test022_nestedLambdas() throws Exception {
        this.runConformTest(new String[]{"X.java", "import java.io.Serializable;\ninterface Foo extends Serializable {int m();}\npublic class X {\n\tpublic static void main(String argv[]) throws Exception {\n\t\tFoo f = () -> { return ((Foo)()->33).m();};\n       System.out.println(f.m());\n       util.Helper.write(f);\n       f = (Foo)util.Helper.read();\n       System.out.println(f.m());\n\t}\n}", "Helper.java", HELPER_CLASS}, "33\n33", null, true, new String[]{"-Ddummy"});
        String expectedOutput = "0: invokestatic java/lang/invoke/LambdaMetafactory.altMetafactory:(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;[Ljava/lang/Object;)Ljava/lang/invoke/CallSite;\n  Method arguments:\n    ()I\n    invokestatic X.lambda$0:()I\n    ()I\n    1\n1: invokestatic java/lang/invoke/LambdaMetafactory.altMetafactory:(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;[Ljava/lang/Object;)Ljava/lang/invoke/CallSite;\n  Method arguments:\n    ()I\n    invokestatic X.lambda$1:()I\n    ()I\n    1\n";
        String data = this.printBootstrapMethodsAttribute(OUTPUT_DIR + File.separator + "X.class");
        this.checkExpected(expectedOutput, data);
    }

    public void test023_lambdasInOtherPlaces_Field() throws Exception {
        this.runConformTest(new String[]{"X.java", "import java.io.Serializable;\ninterface Foo extends Serializable {int m();}\npublic class X {\n   Foo f = () -> 99;\n\tpublic static void main(String argv[]) throws Exception {\n     new X().run();\n   }\n   public void run() {\n       System.out.println(f.m());\n       util.Helper.write(f);\n       f = (Foo)util.Helper.read();\n       System.out.println(f.m());\n\t}\n}", "Helper.java", HELPER_CLASS}, "99\n99", null, true, new String[]{"-Ddummy"});
        String expectedOutput = "0: invokestatic java/lang/invoke/LambdaMetafactory.altMetafactory:(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;[Ljava/lang/Object;)Ljava/lang/invoke/CallSite;\n  Method arguments:\n    ()I\n    invokestatic X.lambda$0:()I\n    ()I\n    1\n";
        String data = this.printBootstrapMethodsAttribute(OUTPUT_DIR + File.separator + "X.class");
        this.checkExpected(expectedOutput, data);
    }

    public void test024_lambdasInOtherPlaces_MethodParameter() throws Exception {
        this.runConformTest(new String[]{"X.java", "import java.io.Serializable;\ninterface Foo extends Serializable {int m();}\npublic class X {\n\tpublic static void main(String argv[]) throws Exception {\n       new X().run(()->33);\n   }\n   public void run(Foo f) {\n       System.out.println(f.m());\n       util.Helper.write(f);\n       f = (Foo)util.Helper.read();\n       System.out.println(f.m());\n\t}\n}", "Helper.java", HELPER_CLASS}, "33\n33", null, true, new String[]{"-Ddummy"});
        String expectedOutput = "0: invokestatic java/lang/invoke/LambdaMetafactory.altMetafactory:(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;[Ljava/lang/Object;)Ljava/lang/invoke/CallSite;\n  Method arguments:\n    ()I\n    invokestatic X.lambda$0:()I\n    ()I\n    1\n";
        String data = this.printBootstrapMethodsAttribute(OUTPUT_DIR + File.separator + "X.class");
        this.checkExpected(expectedOutput, data);
    }

    public void test025_lambdasWithGenericInferencing() throws Exception {
        this.runConformTest(new String[]{"X.java", "import java.io.Serializable;\nimport java.util.function.*;\npublic class X {\n\tpublic static void main(String argv[]) throws Exception {\n       new X().run();\n   }\n   public void run() {\n       IntFunction<Integer> times3 = (IntFunction<Integer> & Serializable) (triple) -> 3 * triple;\n       System.out.println(times3.apply(4));\n       util.Helper.write(times3);\n       times3 = (IntFunction<Integer>)util.Helper.read();\n       System.out.println(times3.apply(4));\n\t}\n}", "Helper.java", HELPER_CLASS}, "12\n12", null, true, new String[]{"-Ddummy"});
        String expectedOutput = "0: invokestatic java/lang/invoke/LambdaMetafactory.altMetafactory:(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;[Ljava/lang/Object;)Ljava/lang/invoke/CallSite;\n  Method arguments:\n    (I)Ljava/lang/Object;\n    invokestatic X.lambda$0:(I)Ljava/lang/Integer;\n    (I)Ljava/lang/Integer;\n    1\n";
        String data = this.printBootstrapMethodsAttribute(OUTPUT_DIR + File.separator + "X.class");
        this.checkExpected(expectedOutput, data);
    }

    public void test026_lambdasInOtherPlaces_Clinit() throws Exception {
        this.runConformTest(new String[]{"X.java", "import java.io.Serializable;\ninterface Foo extends Serializable {int m();}\npublic class X {\n   static {\n     Foo f = () -> 99;\n   }\n\tpublic static void main(String argv[]) throws Exception {\n     new X().run();\n   }\n   public void run() {\n       Foo f = ()->99;\n       System.out.println(f.m());\n       util.Helper.write(f);\n       f = (Foo)util.Helper.read();\n       System.out.println(f.m());\n\t}\n}", "Helper.java", HELPER_CLASS}, "99\n99", null, true, new String[]{"-Ddummy"});
        String expectedOutput = "0: invokestatic java/lang/invoke/LambdaMetafactory.altMetafactory:(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;[Ljava/lang/Object;)Ljava/lang/invoke/CallSite;\n  Method arguments:\n    ()I\n    invokestatic X.lambda$0:()I\n    ()I\n    1\n1: invokestatic java/lang/invoke/LambdaMetafactory.altMetafactory:(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;[Ljava/lang/Object;)Ljava/lang/invoke/CallSite;\n  Method arguments:\n    ()I\n    invokestatic X.lambda$1:()I\n    ()I\n    1\n";
        String data = this.printBootstrapMethodsAttribute(OUTPUT_DIR + File.separator + "X.class");
        this.checkExpected(expectedOutput, data);
    }

    public void test449467() throws Exception {
        this.runConformTest(new String[]{"TestClass.java", "import java.io.ByteArrayInputStream;\nimport java.io.ByteArrayOutputStream;\nimport java.io.ObjectInputStream;\nimport java.io.ObjectOutputStream;\nimport java.io.Serializable;\n\npublic class TestClass implements Serializable {\n  String msg = \"HEY!\";\n  OtherClass other;\n\n  public TestClass(StringBuilder sb) {\n    other = new OtherClass() {\n      {\n        other2 = new OtherClass2((Runnable & Serializable) () -> {\n          sb.length();\n          say();\n        });\n      }\n    };\n  }\n\n  public void say() {\n    System.out.println(msg);\n  }\n\n  public static void main(String[] args) throws Exception {\n    ByteArrayOutputStream buffer = new ByteArrayOutputStream();\n    try (ObjectOutputStream out = new ObjectOutputStream(buffer)) {\n      out.writeObject(new TestClass(new StringBuilder()));\n    }\n    try (ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()))) {\n      TestClass s = (TestClass) in.readObject();\n      s.say();\n    }\n  }\n}\n\nclass OtherClass implements Serializable {\n  OtherClass2 other2;\n}\n\nclass OtherClass2 implements Serializable {\n  Runnable runnable;\n\n  public OtherClass2(Runnable runnable) {\n    this.runnable = runnable;\n  }\n}\n"}, "HEY!", null, true, new String[]{"-Ddummy"});
    }

    public void test449467_2() throws Exception {
        this.runConformTest(new String[]{"com/foo/TestClass.java", "package com.foo;\nimport java.io.ByteArrayInputStream;\nimport java.io.ByteArrayOutputStream;\nimport java.io.ObjectInputStream;\nimport java.io.ObjectOutputStream;\nimport java.io.Serializable;\npublic class TestClass implements Serializable {\n  String msg = \"HEY!\";\n  OtherClass other;\n\n  public TestClass(StringBuilder sb) {\n    other = new OtherClass() {\n      {\n        other2 = new OtherClass2((Runnable & Serializable) () -> {\n          sb.length();\n          say();\n        });\n      }\n    };\n  }\n\n  public void say() {\n    System.out.println(msg);\n  }\n\n  public static void main(String[] args) throws Exception {\n    ByteArrayOutputStream buffer = new ByteArrayOutputStream();\n    try (ObjectOutputStream out = new ObjectOutputStream(buffer)) {\n      out.writeObject(new TestClass(new StringBuilder()));\n    }\n    try (ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()))) {\n      TestClass s = (TestClass) in.readObject();\n      s.say();\n    }\n  }\n}\n\nclass OtherClass implements Serializable {\n  OtherClass2 other2;\n}\n\nclass OtherClass2 implements Serializable {\n  Runnable runnable;\n\n  public OtherClass2(Runnable runnable) {\n    this.runnable = runnable;\n  }\n}\n"}, "HEY!", null, true, new String[]{"-Ddummy"});
    }

    public void test428552() throws Exception {
        this.runConformTest(new String[]{"X.java", "import java.io.*;\npublic class X {\n\tinterface Example extends Serializable {\n\t\tString convert(X o);\n\t}\n\tpublic static void main(String[] args) throws IOException {\n\t\tExample e=X::toString;\n       util.Helper.write(e);\n       e = (Example)util.Helper.read();\n       System.out.println(e.convert(new X()));\n\t}\n   public String toString() {\n       return \"XItIs\";\n   }\n}\n", "Helper.java", HELPER_CLASS}, "XItIs", null, true, new String[]{"-Ddummy"});
    }

    public void test428642() throws Exception {
        this.runConformTest(new String[]{"QuickSerializedLambdaTest.java", "import java.io.*;\nimport java.util.function.IntConsumer;\n\npublic class QuickSerializedLambdaTest {\n\tinterface X extends IntConsumer,Serializable{}\n\tpublic static void main(String[] args) throws IOException, ClassNotFoundException {\n\t\tX x2 = System::exit; // method reference\n\t\tByteArrayOutputStream debug=new ByteArrayOutputStream();\n\t\ttry(ObjectOutputStream oo=new ObjectOutputStream(debug))\n\t\t{\n\t\t\too.writeObject(x2);\n\t\t}\n\t\ttry(ObjectInputStream oi=new ObjectInputStream(new ByteArrayInputStream(debug.toByteArray())))\n\t\t{\n\t\t\tX x=(X)oi.readObject();\n\t\t\tx.accept(0);// shall exit\n\t\t}\n\t\tthrow new AssertionError(\"should not reach this point\");\n\t}\n}\n", "Helper.java", "public class Helper {\n  public static String tostring(java.lang.invoke.SerializedLambda sl) {\n    return sl.toString();\n  }\n}"}, "", null, true, new String[]{"-Ddummy"});
    }

    public void test428642_2() throws Exception {
        this.runConformTest(new String[]{"Helper.java", "public class Helper {\n  public static String tostring(java.lang.invoke.SerializedLambda sl) {\n    return sl.toString();\n  }\n  public static void main(String[]argv) throws Exception {\n    foo.QuickSerializedLambdaTest.main(argv);\n  }\n}", "QuickSerializedLambdaTest.java", "package foo;\nimport java.io.*;\nimport java.util.function.IntConsumer;\n\npublic class QuickSerializedLambdaTest {\n\tinterface X extends IntConsumer,Serializable{}\n\tpublic static void main(String[] args) throws IOException, ClassNotFoundException {\n\t\tX x1 = i -> System.out.println(i);// lambda expression\n\t\tX x2 = System::exit; // method reference\n\t\tByteArrayOutputStream debug=new ByteArrayOutputStream();\n\t\ttry(ObjectOutputStream oo=new ObjectOutputStream(debug))\n\t\t{\n\t\t\too.writeObject(x1);\n\t\t\too.writeObject(x2);\n\t\t}\n\t\ttry(ObjectInputStream oi=new ObjectInputStream(new ByteArrayInputStream(debug.toByteArray())))\n\t\t{\n\t\t\tX x=(X)oi.readObject();\n\t\t\tx.accept(42);// shall print \"42\"\n\t\t\tx=(X)oi.readObject();\n\t\t\tx.accept(0);// shall exit\n\t\t}\n\t\tthrow new AssertionError(\"should not reach this point\");\n\t}\n}\n"}, "42", null, true, new String[]{"-Ddummy"});
    }

    public void test429112() throws Exception {
        this.runConformTest(new String[]{"X.java", "import java.io.*;\nimport java.util.function.IntFunction;\npublic class X {\n  interface IF extends IntFunction<Object>, Serializable {}\n  public static void main(String[] args) throws IOException, ClassNotFoundException {\n    IF factory=String[]::new;\n    Object o = factory.apply(1234);\n\t\tByteArrayOutputStream debug=new ByteArrayOutputStream();\n\t\ttry(ObjectOutputStream oo=new ObjectOutputStream(debug))\n\t\t{\n\t\t\too.writeObject(factory);\n\t\t}\n\t\ttry(ObjectInputStream oi=new ObjectInputStream(new ByteArrayInputStream(debug.toByteArray())))\n\t\t{\n\t\t\tIF x = (IF)oi.readObject();\n\t\t\tObject p = x.apply(1234);\n           System.out.println(p.getClass());\n           String [] sa = (String []) p;\n           System.out.println(sa.length);\n\t\t}\n\t}\n}\n"}, "class [Ljava.lang.String;\n1234", null, true, new String[]{"-Ddummy"});
    }

    public void test439889() throws Exception {
        this.runConformTest(new String[]{"SerializationTest.java", "import java.io.*;\n\npublic class SerializationTest implements Serializable {\n\tinterface SerializableRunnable extends Runnable, Serializable {\n\t}\n\n\tSerializableRunnable runnable;\n\n\tpublic SerializationTest() {\n\t\tfinal SerializationTest self = this;\n\t\t// runnable = () -> self.doSomething();\n\t\trunnable = () -> this.doSomething();\n       }\n\n\tpublic void doSomething() {\n\t\tSystem.out.println(\"Hello,world!\");\n\t}\n\n\tpublic static void main(String[] args) throws Exception {\n\t\tfinal ByteArrayOutputStream buffer = new ByteArrayOutputStream();\n\t\ttry (ObjectOutputStream out = new ObjectOutputStream(buffer) ) {\n\t\t\tout.writeObject(new SerializationTest());\n\t\t}\n\t\ttry (ObjectInputStream in = new ObjectInputStream( new ByteArrayInputStream(buffer.toByteArray()))) {\n\t\t\tfinal SerializationTest s = (SerializationTest) in.readObject();\n\t\t\ts.doSomething();\n\t\t}\n\t}\n}\n"}, "Hello,world!", null, true, new String[]{"-Ddummy"});
    }

    public void test439889_2() throws Exception {
        this.runConformTest(new String[]{"SerializationTest.java", "import java.io.*;\n\npublic class SerializationTest implements Serializable {\n\tinterface SerializableRunnable extends Runnable, Serializable {\n\t}\n\n\tSerializableRunnable runnable;\n\n\tpublic SerializationTest() {\n\t\tfinal SerializationTest self = this;\n\t\trunnable = () -> self.doSomething();\n\t\t// runnable = () -> this.doSomething();\n       }\n\n\tpublic void doSomething() {\n\t\tSystem.out.println(\"Hello,world!\");\n\t}\n\n\tpublic static void main(String[] args) throws Exception {\n\t\tfinal ByteArrayOutputStream buffer = new ByteArrayOutputStream();\n\t\ttry (ObjectOutputStream out = new ObjectOutputStream(buffer) ) {\n\t\t\tout.writeObject(new SerializationTest());\n\t\t}\n\t\ttry (ObjectInputStream in = new ObjectInputStream( new ByteArrayInputStream(buffer.toByteArray()))) {\n\t\t\tfinal SerializationTest s = (SerializationTest) in.readObject();\n\t\t\ts.doSomething();\n\t\t}\n\t}\n}\n"}, "Hello,world!", null, true, new String[]{"-Ddummy"});
    }

    public void testNestedLambdas_442416() throws Exception {
        this.runConformTest(new String[]{"Foo.java", "import java.io.*;\npublic class Foo {\n   static byte[] toSer(Object o) {\n       try {\n\t\t\tfinal ByteArrayOutputStream buffer = new ByteArrayOutputStream();\n\t\t\ttry (ObjectOutputStream out = new ObjectOutputStream(buffer) ) {\n\t\t\t\tout.writeObject(o);\n\t\t\t}\n\t\t\treturn buffer.toByteArray();\n       } catch (Exception e) {e.printStackTrace();return null;}\n   }\n   static Object fromSer(byte[] bs) {\n       try {\n\t\t\ttry (ObjectInputStream in = new ObjectInputStream( new ByteArrayInputStream(bs))) {\n\t\t\t\tfinal Object s = in.readObject();\n\t\t\t\treturn s;\n\t\t\t}\n       } catch (Exception e) {e.printStackTrace();return null;}\n   }\n\tpublic static void main(String[] args) throws Exception {\n       Runnable nested1,nested2;\n\t\tRunnable lambda0 = (java.io.Serializable & Runnable) () -> {\n\t\t\tRunnable lambda1 = (java.io.Serializable & Runnable) () -> {\n\t\t\t\tRunnable lambda2 = (java.io.Serializable & Runnable) () -> {\n\t\t\t\t\tSystem.out.println(\"Hello,world!\");\n\t\t\t\t};\n       \t\tbyte[] bs = toSer(lambda2);\n\t\t\t\tRunnable r = (Runnable)fromSer(bs);\n       \t\tr.run();\n\t\t\t};\n       \tbyte[] bs = toSer(lambda1);\n\t\t\tRunnable r = (Runnable)fromSer(bs);\n       \tr.run();\n\t\t};\n       byte[] bs = toSer(lambda0);\n\t\tRunnable r = (Runnable)fromSer(bs);\n       r.run();\n\t}\n}\n"}, "Hello,world!", null, true, new String[]{"-Ddummy"});
    }

    public void testBindingThis_442418() throws Exception {
        this.runConformTest(new String[]{"Foo.java", "import java.io.*;\npublic class Foo implements Serializable {\n   static byte[] toSer(Object o) {\n       try {\n\t\t\tfinal ByteArrayOutputStream buffer = new ByteArrayOutputStream();\n\t\t\ttry (ObjectOutputStream out = new ObjectOutputStream(buffer) ) {\n\t\t\t\tout.writeObject(o);\n\t\t\t}\n\t\t\treturn buffer.toByteArray();\n\t\t} catch (Exception e) {e.printStackTrace();return null;}\n\t}\n\tstatic Object fromSer(byte[] bs) {\n\ttry {\n\t\t\ttry (ObjectInputStream in = new ObjectInputStream( new ByteArrayInputStream(bs))) {\n\t\t\t\tfinal Object s = in.readObject();\n\t\t\t\treturn s;\n\t\t\t}\n       } catch (Exception e) {e.printStackTrace();return null;}\n   }\n\t\tvoid m(int i) {\n\t\t\tSystem.out.println(i);\n\t\t}\n\t\tvoid n(int i) {\n\t\t\tRunnable lambda = (java.io.Serializable & Runnable) () -> { this.m(i); };\n\t\t\tbyte[] bs = toSer(lambda);\n\t\t\tRunnable r = (Runnable)fromSer(bs);\n\t\t\tr.run();\n\t\t}\n\tpublic static void main(String[] args) throws Exception {\n\t\tnew Foo().n(42);\n\t}\n}\n"}, "42", null, true, new String[]{"-Ddummy"});
    }

    public void testbug479119() {
        String[] stringArray;
        String[] stringArray2 = new String[]{"Testbed.java", "import java.io.ObjectStreamClass;\nimport java.io.Serializable;\nimport java.lang.invoke.SerializedLambda;\nimport java.lang.reflect.Method;\nimport java.util.function.IntFunction;\nimport java.util.stream.Stream;\npublic class Testbed {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(getMethod(Testbed::foo).equals(getMethod(Testbed::foo)));\n\t}\n\tprivate static void foo() { }\n\tstatic interface MethodRef extends Runnable, Serializable { }\n\tprivate static Method getMethod(MethodRef methodRef) {\n\t\ttry {\n\t\t\tfinal Method invokeWriteReplaceMethod = ObjectStreamClass.class.getDeclaredMethod(\"invokeWriteReplace\", Object.class);\n\t\t\tinvokeWriteReplaceMethod.setAccessible(true);\n\t\t\tfinal SerializedLambda l = (SerializedLambda)invokeWriteReplaceMethod.invoke(\n\t\t\t\t\tObjectStreamClass.lookupAny(methodRef.getClass()),\n\t\t\t\t\tmethodRef\n\t\t\t\t);\n\t\t\tSystem.out.println(\"Looking for \" + l.getImplClass() + \".\" + l.getImplMethodName());\n\t\t\tfinal Method[] methods = Stream.of(Class.forName(l.getImplClass()).getDeclaredMethods()).\n\t\t\t\tfilter(m -> m.getName().equals(l.getImplMethodName())).\n\t\t\t\ttoArray(Method[]::new);\n\t\t\tif(methods.length != 1) throw new AssertionError(\"TODO: check signature\");\n\t\t\treturn methods[0];\n\t\t} catch(Exception e) {\n\t\t\tthrow new RuntimeException(e);\n\t\t}\n\t}\n}\n"};
        if (isJRE9Plus) {
            String[] stringArray3 = new String[2];
            stringArray3[0] = "--add-opens";
            stringArray = stringArray3;
            stringArray3[1] = "java.base/java.io=ALL-UNNAMED";
        } else {
            String[] stringArray4 = new String[1];
            stringArray = stringArray4;
            stringArray4[0] = "-Ddummy";
        }
        this.runConformTest(stringArray2, "Looking for Testbed.foo\nLooking for Testbed.foo\ntrue", null, true, stringArray);
        String bootstrapEntries = this.printBootstrapMethodsAttribute(OUTPUT_DIR + File.separator + "Testbed.class");
        String expectedOutput = "0: invokestatic java/lang/invoke/LambdaMetafactory.altMetafactory:(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;[Ljava/lang/Object;)Ljava/lang/invoke/CallSite;\n  Method arguments:\n    ()V\n    invokestatic Testbed.foo:()V\n    ()V\n    1\n1: invokestatic java/lang/invoke/LambdaMetafactory.metafactory:(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodHandle;Ljava/lang/invoke/MethodType;)Ljava/lang/invoke/CallSite;\n  Method arguments:\n    (Ljava/lang/Object;)Z\n    invokestatic Testbed.lambda$2:(Ljava/lang/invoke/SerializedLambda;Ljava/lang/reflect/Method;)Z\n    (Ljava/lang/reflect/Method;)Z\n2: invokestatic java/lang/invoke/LambdaMetafactory.metafactory:(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodHandle;Ljava/lang/invoke/MethodType;)Ljava/lang/invoke/CallSite;\n  Method arguments:\n    (I)Ljava/lang/Object;\n    invokestatic Testbed.lambda$3:(I)[Ljava/lang/reflect/Method;\n    (I)[Ljava/lang/reflect/Method;\n";
        this.checkExpected(expectedOutput, bootstrapEntries);
    }

    public void testbug479119a() {
        String[] stringArray;
        String[] stringArray2 = new String[]{"Testbed.java", "import java.io.ObjectStreamClass;\nimport java.io.Serializable;\nimport java.lang.invoke.SerializedLambda;\nimport java.lang.reflect.Constructor;\nimport java.lang.reflect.Executable;\nimport java.lang.reflect.Method;\nimport java.util.function.IntFunction;\nimport java.util.stream.Stream;\npublic class Testbed {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(getMethod(Testbed::foo).equals(getMethod(Testbed::foo)));\n\t\tSystem.out.println(getMethod(new Foo()::method).equals(getMethod(new Bar()::method)));\n\t\tSystem.out.println(getMethod(MethodRefImpl::new).equals(getMethod(MethodRefImpl::new)));\n\t}\n\tstatic class MethodRefImpl implements MethodRef {\n\t\t@Override\n\t\tpublic void run() {}\n\t}\n\tpublic static class Base {\n        public void method () {}\n    }\n    public static class Foo extends Base {}\n    public static class Bar extends Base {}\n\tprivate static void foo() { }\n\tstatic interface MethodRef extends Runnable, Serializable { }\n\tprivate static Executable getMethod(MethodRef methodRef) {\n\t\ttry {\n\t\t\tfinal Method invokeWriteReplaceMethod = ObjectStreamClass.class.getDeclaredMethod(\"invokeWriteReplace\", Object.class);\n\t\t\tinvokeWriteReplaceMethod.setAccessible(true);\n\t\t\tfinal SerializedLambda l = (SerializedLambda)invokeWriteReplaceMethod.invoke(\n\t\t\t\t\tObjectStreamClass.lookupAny(methodRef.getClass()),\n\t\t\t\t\tmethodRef\n\t\t\t\t);\n\t\t\tSystem.out.println(\"Looking for \" + l.getImplClass() + \".\" + l.getImplMethodName());\n\t\t\tboolean isConstructor = l.getImplMethodName().indexOf(\"<init>\") >= 0;\n\t\t\tfinal Executable[] methods = Stream.of(isConstructor ? Class.forName(l.getImplClass()).getDeclaredConstructors() : Class.forName(l.getImplClass()).getDeclaredMethods()).\n\t\t\t\tfilter(m -> m.getName().equals(isConstructor ? l.getImplClass() : l.getImplMethodName())).\n\t\t\t\ttoArray(isConstructor ? Constructor[]::new : Method[]::new);\n\t\t\tif(methods.length != 1) throw new AssertionError(\"TODO: check signature\");\n\t\t\treturn methods[0];\n\t\t} catch(Exception e) {\n\t\t\tthrow new RuntimeException(e);\n\t\t}\n\t}\n}\n"};
        if (isJRE9Plus) {
            String[] stringArray3 = new String[2];
            stringArray3[0] = "--add-opens";
            stringArray = stringArray3;
            stringArray3[1] = "java.base/java.io=ALL-UNNAMED";
        } else {
            String[] stringArray4 = new String[1];
            stringArray = stringArray4;
            stringArray4[0] = "-Ddummy";
        }
        this.runConformTest(stringArray2, "Looking for Testbed.foo\nLooking for Testbed.foo\ntrue\nLooking for Testbed$Base.method\nLooking for Testbed$Base.method\ntrue\nLooking for Testbed$MethodRefImpl.<init>\nLooking for Testbed$MethodRefImpl.<init>\ntrue", null, true, stringArray);
    }

    public void testbug479119b() {
        this.runConformTest(new String[]{"X.java", "import java.io.ByteArrayInputStream;\nimport java.io.ByteArrayOutputStream;\nimport java.io.IOException;\nimport java.io.ObjectInputStream;\nimport java.io.ObjectOutputStream;\nimport java.io.Serializable;\npublic class X {\n    public static interface Consumer<T> extends Serializable {\n        void accept(T t);\n    }\n    public static class Foo {\n    \tpublic void method () {\n        \tSystem.out.println(\"Foo\");\n        }\n    }\n    public static class Bar {\n    \tpublic void method () {\n        \tSystem.out.println(\"Bar\");\n        }\n    }\n    public static void main (String[] args) throws IOException, ClassNotFoundException {\n        Consumer<Foo> foo = Foo::method;\n        Consumer<Bar> bar = Bar::method;\n        Consumer<Foo> baz = (b) -> {b.method();};\n        ByteArrayOutputStream debug=new ByteArrayOutputStream();\n\t\ttry(ObjectOutputStream oo=new ObjectOutputStream(debug)) {\n\t\t\too.writeObject(bar);\n\t\t}\n\t\ttry(ObjectInputStream oi=new ObjectInputStream(new ByteArrayInputStream(debug.toByteArray()))) {\n\t\t\tConsumer<Bar> x = (Consumer)oi.readObject();\n\t\t\tx.accept(new Bar());\n\t\t}\n\t\tdebug.reset();\n\t\ttry(ObjectOutputStream oo=new ObjectOutputStream(debug)) {\n\t\t\too.writeObject(foo);\n\t\t}\n\t\ttry(ObjectInputStream oi=new ObjectInputStream(new ByteArrayInputStream(debug.toByteArray()))) {\n\t\t\tConsumer<Foo> x = (Consumer)oi.readObject();\n\t\t\tx.accept(new Foo());\n\t\t}\n    }\n}\n"}, "Bar\nFoo", null, true, new String[]{"-Ddummy"});
    }

    public void testbug479119_comment20() {
        this.runConformTest(new String[]{"Testbed.java", "import java.io.ByteArrayInputStream;\nimport java.io.ByteArrayOutputStream;\nimport java.io.IOException;\nimport java.io.ObjectInputStream;\nimport java.io.ObjectOutputStream;\nimport java.io.Serializable;\ninterface FI extends Serializable{\n\tvoid run(Testbed args);\n}\ninterface IF extends Serializable{\n\tvoid run();\n}\npublic class Testbed implements Serializable{\n\tString f;\n\tTestbed(String str) {\n\t\tf = str;\n\t}\n\tvoid test() throws IOException, ClassNotFoundException {\n\t\taccept(Testbed::foo);\n\t\taccept(this::foo);\t\t\n\t}\n\tvoid foo() {\n\t\tSystem.out.println(this.f);\n\t}\n\tvoid accept(FI fi) {\n\t\tfi.run(this);\n\t}\n\tvoid accept(IF i) {\n\t\ti.run();\n\t}\n\tpublic static void main(String[] args) throws ClassNotFoundException, IOException {\n\t\tTestbed t = new Testbed(\"IF\");\n\t\tTestbed t2 = new Testbed(\"FI\");\n\t\tIF i = t::foo;\n\t\tFI f = Testbed::foo;\n\t\tByteArrayOutputStream debug=new ByteArrayOutputStream();\n\t\ttry(ObjectOutputStream oo=new ObjectOutputStream(debug))\n\t\t{\n\t\t\too.writeObject(i);\n\t\t}\n\t\ttry(ObjectInputStream oi=new ObjectInputStream(new ByteArrayInputStream(debug.toByteArray())))\n\t\t{\n\t\t\tIF x = (IF)oi.readObject();\n\t\t\tt.accept(x);\n\t\t}\n\t\tdebug=new ByteArrayOutputStream();\n\t\ttry(ObjectOutputStream oo=new ObjectOutputStream(debug))\n\t\t{\n\t\t\too.writeObject(f);\n\t\t}\n\t\ttry(ObjectInputStream oi=new ObjectInputStream(new ByteArrayInputStream(debug.toByteArray())))\n\t\t{\n\t\t\tFI x = (FI)oi.readObject();\n\t\t\tt2.accept(x);\n\t\t}\n\t}\n}"}, "IF\nFI", null, true, new String[]{"-Ddummy"});
    }

    public void testbug485333() {
        this.runConformTest(new String[]{"Test.java", "import java.io.ByteArrayInputStream;\nimport java.io.ByteArrayOutputStream;\nimport java.io.ObjectInputStream;\nimport java.io.ObjectOutputStream;\nimport java.io.Serializable;\ninterface Func<T> extends Serializable {\n  T get();\n}\nclass Impl implements Serializable {\n  int val = 0;\n  public int next() {\n    val += 1;\n    return val;\n  }\n}\npublic class Test {\n  final Impl impl = new Impl();\n  final Func<Integer> func = (Func<Integer> & Cloneable)impl::next;\n  public void test() throws Throwable {\n    byte[] bytes = write(func);//25\n    Func<Integer> func = read(bytes);\n    System.out.println(func.get());\n  }\n  public static void main(String[] args) throws Throwable {\n\tnew Test().test();\n}\n  @SuppressWarnings(\"unchecked\")\n  private static Func<Integer> read(byte[] bytes) throws Exception {\n    ByteArrayInputStream bis = new ByteArrayInputStream(bytes);\n    try (ObjectInputStream ois = new ObjectInputStream(bis)) {\n      return (Func<Integer>) ois.readObject();\n    }\n  }\n  private static byte[] write(Func<Integer> func) throws Exception {\n    ByteArrayOutputStream bos = new ByteArrayOutputStream();\n    System.out.println(func.get());\n    try (ObjectOutputStream oos = new ObjectOutputStream(bos)) {\n      oos.writeObject(func);//42\n    }\n    return bos.toByteArray();\n  }\n}"}, "1\n2", null, true, new String[]{"-Ddummy"});
    }

    public void testbug494487() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.debug.localVariable", "do not generate");
        this.runConformTest(new String[]{"Test.java", "import java.io.IOException;\nimport java.io.Serializable;\npublic class Test {\n  class AnException extends Exception {\n  }\n  class Asd {\n    public Asd(String asd) { data = asd; }\n    private final String data;\n    @Override\n    public String toString() {\n      return data;\n    }\n  }\n  public interface Test1 extends Serializable {\n    void test() throws IOException;\n  }\n  public interface Test2 {\n    void test() throws AnException;\n  }\n  public void test1( Test1 test ) {\n    try {\n      test.test();\n    } catch( IOException e ) {\n      e.printStackTrace();\n    }\n  }\n  public void test2( Test2 test ) {\n    try {\n      test.test();\n    } catch( AnException e ) {\n      System.out.println( e );\n    }\n  }\n  public void lambdas() {\n    test1( () -> System.out.println( \"test a\" ) );\n    test1( () -> System.out.println( \"test b\" ) );\n    test2( () -> System.out.println( \"test c\" ) );\n    test2( () -> System.out.println( \"test d\" ) );\n  }\n  public void print( CharSequence a, String b, long c ) {\n    System.out.println( a );\n    System.out.println( b );\n    System.out.println( c );\n  }\n  public void filler() {\n    System.out.println( \"Now we need to get this class file closer to 3000 bytes boundary\" );\n    filler1();\n    filler2();\n    filler3();\n    filler4();\n    filler5();\n    filler6();\n    filler7();\n    filler8();\n    filler9();\n    filler10();\n    filler11();\n    filler12();\n    filler13();\n    filler14();\n    filler15();\n    filler16();\n    filler17();\n    filler18();\n    filler19();\n    filler20();\n    filler21();\n    filler22();\n    filler23();\n    filler24();\n    filler25();\n    filler26();\n    filler27();\n    filler28();\n    print( \"a\", \"b\", System.currentTimeMillis() );\n    print( \"a\", \"b\", System.currentTimeMillis() );\n    print( \"a\", \"b\", System.currentTimeMillis() );\n    print( \"a\", \"b\", System.currentTimeMillis() );\n    print( \"a\", \"b\", System.currentTimeMillis() );\n    print( \"a\", \"b\", System.currentTimeMillis() );\n  }\n  private void filler28() {\n    print( \"a\", \"b\", System.currentTimeMillis() );\n  }\n  private void filler27() {\n    print( \"a\", \"b\", System.currentTimeMillis() );\n  }\n  private void filler26() {\n    print( \"a\", \"b\", System.currentTimeMillis() );\n  }\n  private void filler25() {\n    print( \"a\", \"b\", System.currentTimeMillis() );\n  }\n  private void filler24() {\n    print( \"a\", \"b\", System.currentTimeMillis() );\n  }\n  private void filler23() {\n    print( \"a\", \"b\", System.currentTimeMillis() );\n  }\n  private void filler22() {\n    print( \"a\", \"b\", System.currentTimeMillis() );\n  }\n  private void filler21() {\n    print( \"a\", \"b\", System.currentTimeMillis() );\n  }\n  private void filler20() {\n    print( \"a\", \"b\", System.currentTimeMillis() );\n  }\n  private void filler19() {\n    print( \"a\", \"b\", System.currentTimeMillis() );\n  }\n  private void filler18() {\n    print( \"a\", \"b\", System.currentTimeMillis() );\n  }\n  private void filler17() {\n    print( \"a\", \"b\", System.currentTimeMillis() );\n  }\n  private void filler16() {\n    print( \"a\", \"b\", System.currentTimeMillis() );\n  }\n  private void filler15() {\n    print( \"a\", \"b\", System.currentTimeMillis() );\n  }\n  private void filler14() {\n    print( \"a\", \"b\", System.currentTimeMillis() );\n  }\n  private void filler13() {\n    print( \"a\", \"b\", System.currentTimeMillis() );\n  }\n  private void filler12() {\n    print( \"a\", \"b\", System.currentTimeMillis() );\n  }\n  private void filler11() {\n    print( \"a\", \"b\", System.currentTimeMillis() );\n  }\n  private void filler10() {\n    print( \"a\", \"b\", System.currentTimeMillis() );\n  }\n  private void filler9() {\n    print( \"a\", \"b\", System.currentTimeMillis() );\n  }\n  private void filler8() {\n    print( \"a\", \"b\", System.currentTimeMillis() );\n  }\n  private void filler7() {\n    print( \"a\", \"b\", System.currentTimeMillis() );\n  }\n  private void filler6() {\n    print( \"a\", \"b\", System.currentTimeMillis() );\n  }\n  private void filler5() {\n    print( c.toString(), d.toString(), System.currentTimeMillis() );\n  }\n  private void filler4() {\n    print( a.toString(), b.toString(), System.currentTimeMillis() );\n  }\n  private void filler3() {\n    print( \"a\", System.getenv( \"asd\" ), System.currentTimeMillis() );\n  }\n  private void filler2() {\n    print( \"a\", System.lineSeparator(), System.currentTimeMillis() );\n  }\n  private void filler1() {\n    print( \"a\", \"b\", System.currentTimeMillis() );\n  }\n  private final Asd a = new Asd(\"a\");\n  private final Asd b = new Asd(\"b\");\n  private final Asd c = new Asd(\"c\");\n  private final Asd d = new Asd(\"d\");\n}\n"}, options);
    }

    public void testbug497879() {
        this.runConformTest(new String[]{"LambdaSerializationTest.java", "import java.io.ByteArrayInputStream;\nimport java.io.ByteArrayOutputStream;\nimport java.io.IOException;\nimport java.io.ObjectInputStream;\nimport java.io.ObjectOutputStream;\nimport java.io.Serializable;\nimport java.util.ArrayList;\nimport java.util.List;\nimport java.util.function.Supplier;\npublic class LambdaSerializationTest {\n    interface SerializableSupplier<T> extends Supplier<T>, Serializable {}\n    public static void constructorReferenceSerialization() throws IOException, ClassNotFoundException {\n        SerializableSupplier<List<?>> function = ArrayList::new; //Collections::emptyList;\n        Object result = serializeDeserialize(function);\n        Class<?>[] infs = result.getClass().getInterfaces();\n        for(int i = 0; i < infs.length; i++) {\n            System.out.println(infs[i]);\n        }\n    }\n    private static Object serializeDeserialize(Object obj) throws IOException, ClassNotFoundException {\n        try (\n            ByteArrayOutputStream buffer = new ByteArrayOutputStream(); //\n            ObjectOutputStream output = new ObjectOutputStream(buffer)) {\n            output.writeObject(obj);\n            try (ObjectInputStream input = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()))) {\n                return input.readObject();\n            }\n        }\n    }\n    public static void main(String[] args) {\n\t\ttry {\n\t\t\tLambdaSerializationTest.constructorReferenceSerialization();\n\t\t} catch (ClassNotFoundException | IOException e) {\n\t\t\t// TODO Auto-generated catch block\n\t\t\te.printStackTrace();\n\t\t}\n\t}\n}"}, "interface LambdaSerializationTest$SerializableSupplier", null, true, new String[]{"-Ddummy"});
    }

    public void testbug497879a() {
        this.runConformTest(new String[]{"LambdaSerializationTest.java", "import java.io.ByteArrayInputStream;\nimport java.io.ByteArrayOutputStream;\nimport java.io.IOException;\nimport java.io.ObjectInputStream;\nimport java.io.ObjectOutputStream;\nimport java.io.Serializable;\nimport java.util.ArrayList;\nimport java.util.List;\nimport java.util.function.Supplier;\npublic class LambdaSerializationTest {\n    interface SerializableSupplier<T> extends Supplier<T>, Serializable {}\n    static class Junk {\n    \tprivate Junk() {}\n    }\n    public static void constructorReferenceSerialization() throws IOException, ClassNotFoundException {\n        SerializableSupplier<Junk> function = Junk::new;\n        Object result = serializeDeserialize(function);\n        Class<?>[] infs = result.getClass().getInterfaces();\n        for(int i = 0; i < infs.length; i++) {\n            System.out.println(infs[i]);\n        }\n    }\n    private static Object serializeDeserialize(Object obj) throws IOException, ClassNotFoundException {\n        try (\n            ByteArrayOutputStream buffer = new ByteArrayOutputStream(); //\n            ObjectOutputStream output = new ObjectOutputStream(buffer)) {\n            output.writeObject(obj);\n            try (ObjectInputStream input = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()))) {\n                return input.readObject();\n            }\n        }\n    }\n    public static void main(String[] args) {\n\t\ttry {\n\t\t\tLambdaSerializationTest.constructorReferenceSerialization();\n\t\t} catch (ClassNotFoundException | IOException e) {\n\t\t\t// TODO Auto-generated catch block\n\t\t\te.printStackTrace();\n\t\t}\n\t}\n}"}, "interface LambdaSerializationTest$SerializableSupplier", null, true, new String[]{"-Ddummy"});
    }

    public void testbug497879b() {
        this.runConformTest(new String[]{"LambdaSerializationTest.java", "import java.io.ByteArrayInputStream;\nimport java.io.ByteArrayOutputStream;\nimport java.io.IOException;\nimport java.io.ObjectInputStream;\nimport java.io.ObjectOutputStream;\nimport java.io.Serializable;\nimport java.util.ArrayList;\nimport java.util.List;\nimport java.util.function.Supplier;\npublic class LambdaSerializationTest {\n    interface SerializableSupplier<T> extends Serializable {\n        T get(int count);\n    }\n    public static void constructorReferenceSerialization() throws IOException, ClassNotFoundException {\n        SerializableSupplier<List[]> function = ArrayList[]::new;\n        Object result = serializeDeserialize(function);\n        Class<?>[] infs = result.getClass().getInterfaces();\n        for(int i = 0; i < infs.length; i++) {\n            System.out.println(infs[i]);\n        }\n    }\n    private static Object serializeDeserialize(Object obj) throws IOException, ClassNotFoundException {\n        try (\n            ByteArrayOutputStream buffer = new ByteArrayOutputStream(); //\n            ObjectOutputStream output = new ObjectOutputStream(buffer)) {\n            output.writeObject(obj);\n            try (ObjectInputStream input = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()))) {\n                return input.readObject();\n            }\n        }\n    }\n    public static void main(String[] args) {\n\t\ttry {\n\t\t\tLambdaSerializationTest.constructorReferenceSerialization();\n\t\t} catch (ClassNotFoundException | IOException e) {\n\t\t\t// TODO Auto-generated catch block\n\t\t\te.printStackTrace();\n\t\t}\n\t}\n}"}, "interface LambdaSerializationTest$SerializableSupplier", null, true, new String[]{"-Ddummy"});
    }

    public void testbug503118() {
        this.runConformTest(new String[]{"lambdabug/App.java", "package lambdabug;\nimport java.io.ByteArrayInputStream;\nimport java.io.ByteArrayOutputStream;\nimport java.io.ObjectInputStream;\nimport java.io.ObjectOutputStream;\nimport java.io.Serializable;\nimport java.util.function.Function;\npublic class App {\n\tpublic static interface SerialFunction<T, R> extends Function<T, R>, Serializable {\n\t}\n\tpublic static interface TestInterface extends Serializable {\n\t\tpublic Integer method(Integer i);\n\t}\n\tpublic static class TestClass implements TestInterface {\n\t\tprivate static final long serialVersionUID = 1L;\n\t\t@Override\n\t\tpublic Integer method(Integer i) {\n\t\t\treturn i;\n\t\t}\n\t}\n\tpublic static void main(String[] args) throws Exception {\n\t\tTestInterface testService = getService();\n\t\tSerialFunction<Integer, Integer> sf = testService::method;\n\t\tByteArrayOutputStream bos = new ByteArrayOutputStream();\n\t\tnew ObjectOutputStream(bos).writeObject(sf);\n\t\tObject o = new ObjectInputStream(new ByteArrayInputStream(bos.toByteArray())).readObject();\n\t\tSystem.out.println(o.getClass().getInterfaces()[0]);\n\t}\n\tprivate static TestInterface getService() {\n\t\treturn new TestClass();\n\t}\n}\n"}, "interface lambdabug.App$SerialFunction", null, true, new String[]{"-Ddummy"});
    }

    public void testbug507011() {
        this.runConformTest(new String[]{"VerifyErrorDerived.java", "import java.io.Serializable;\nimport java.util.function.Function;\npublic class VerifyErrorDerived extends VerifyErrorBase {\n\tpublic static void main(String [] args) {\n\t\tSystem.out.println(\"hello world\");\n\t}\n\tpublic int derivedMethod(String param) {\n\t\tSerializableFunction<String, Integer> f = super::baseMethod;\n\t\treturn f.apply(param);\n\t}\n}\ninterface SerializableFunction<T, R> extends Function<T, R>, Serializable {}", "VerifyErrorBase.java", "public class VerifyErrorBase {\n\tpublic int baseMethod(String param) {\n\t\treturn 7;\n\t}\n}\n"}, "hello world", null, true, new String[]{"-Ddummy"});
    }

    public void testbug509782() {
        this.runConformTest(new String[]{"compilertest/BaseType.java", "package compilertest;\nimport java.io.ByteArrayInputStream;\nimport java.io.ByteArrayOutputStream;\nimport java.io.ObjectInputStream;\nimport java.io.ObjectOutputStream;\nimport java.io.Serializable;\nimport compilertest.sub.SubType;\npublic class BaseType implements Serializable {\n    protected void doSomething() {\n    }\n    public static void main(String[] args) throws Exception {\n        SubType instance = new SubType();\n        ByteArrayOutputStream bs = new ByteArrayOutputStream();\n        ObjectOutputStream out = new ObjectOutputStream(bs);\n        out.writeObject(instance);\n        byte[] data = bs.toByteArray();\n        ObjectInputStream in = new ObjectInputStream(\n                new ByteArrayInputStream(data));\n        in.readObject();\n        System.out.println(\"Done\");\n    }\n}", "compilertest/sub/SubType.java", "package compilertest.sub;\nimport java.io.Serializable;\nimport compilertest.BaseType;\npublic class SubType extends BaseType {\n    Runnable task = (Runnable & Serializable) this::doSomething;\n}\n"}, "Done", null, true, new String[]{"-Ddummy"});
    }

    public void testbug566155() {
        this.runConformTest(new String[]{"OuterClass.java", "import java.io.*;\nimport java.util.function.Supplier;\n\npublic class OuterClass implements Serializable {\n\n    private static final long serialVersionUID = 5390565572939096897L;\n    public Supplier<OuterClass.InnerClass> supplier;\n\n    @SuppressWarnings(\"unchecked\")\n    public OuterClass() {\n        this.supplier = (Supplier<OuterClass.InnerClass> & Serializable) InnerClass::new;\n    }\n\n    public class InnerClass implements Serializable {\n        private static final long serialVersionUID = 2478179807896338433L;\n \t   public InnerClass() {\n        }\n    }\n\n}\n"}, "");
        String expectedOutput = "lambda$1()LOuterClass$InnerClass;\n";
        String data = this.printLambdaMethods(OUTPUT_DIR + File.separator + "OuterClass.class");
        this.checkExpected(expectedOutput, data);
    }

    public void testbugGH155() {
        this.runConformTest(new String[]{"TestSerializableLambda.java", "import java.io.*;\nimport java.util.function.Function;\n\npublic class TestSerializableLambda {\n\tprivate static Object serializeDeserialize(Object obj) throws IOException, ClassNotFoundException {\n\t\ttry (\n\t\t\tByteArrayOutputStream buffer = new ByteArrayOutputStream(); //\n\t\t\tObjectOutputStream output = new ObjectOutputStream(buffer)) {\n\t\t\toutput.writeObject(obj);\n\t\t\ttry (ObjectInputStream input = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()))) {\n\t\t\t\treturn input.readObject();\n\t\t\t}\n\t\t}\n\t}\n\tpublic static void main(String[] args) {\n\t\ttry {\n\t\t\tSerializableHolder<LambdaProvider<Long>> r = new SerializableHolder<>();\n\t\t\tserializeDeserialize(r);\n\t\t\tSystem.out.println(\"OK\");\n\t\t} catch (ClassNotFoundException | IOException e) {\n\t\t\t// TODO Auto-generated catch block\n\t\t\te.printStackTrace();\n\t\t}\n\t}\n\t\n\tpublic static class SerializableHolder<E extends LambdaProvider<?>> implements Serializable {\n\t\tprivate static final long serialVersionUID = -2775595600924717218L;\n\t\tprivate Function<E, ?> idExpression;\n\n\t\tpublic SerializableHolder() {\n\t\t\tthis.idExpression = (Serializable & Function<E, ?>) LambdaProvider::getId;\n\t\t}\n\t}\n\n\tpublic static class LambdaProvider<I extends Comparable<I>> {\n\t\tpublic I getId() {\n\t\t\treturn null;\n\t\t}\n\t}\n}"}, "OK");
    }

    private void checkExpected(String expected, String actual) {
        if (!expected.equals(actual)) {
            this.printIt(actual);
        }
        SerializableLambdaTest.assertEquals(expected, actual);
    }

    private void printIt(String text) {
        Object quotedText = text;
        if (!((String)quotedText).startsWith("\"")) {
            quotedText = "\"" + ((String)quotedText).replaceAll("\n", "\\\\n\"+\n\"");
            quotedText = ((String)quotedText).substring(0, ((String)quotedText).length() - 3);
        }
        System.out.println((String)quotedText);
    }

    private String printBootstrapMethodsAttribute(String filepath) {
        IClassFileReader cfr = ToolFactory.createDefaultClassFileReader((String)filepath, (int)17);
        BootstrapMethodsAttribute bootstrapMethodsAttribute = null;
        IClassFileAttribute[] attrs = cfr.getAttributes();
        int i = 0;
        int max = attrs.length;
        while (i < max) {
            if (new String(attrs[i].getAttributeName()).equals("BootstrapMethods")) {
                bootstrapMethodsAttribute = (BootstrapMethodsAttribute)attrs[i];
            }
            ++i;
        }
        if (bootstrapMethodsAttribute == null) {
            return "";
        }
        IConstantPool cp = cfr.getConstantPool();
        StringBuilder sb = new StringBuilder();
        int bmaLength = bootstrapMethodsAttribute.getBootstrapMethodsLength();
        int i2 = 0;
        while (i2 < bmaLength) {
            IBootstrapMethodsEntry entry = bootstrapMethodsAttribute.getBootstrapMethods()[i2];
            int mr = entry.getBootstrapMethodReference();
            IConstantPoolEntry2 icpe = (IConstantPoolEntry2)cfr.getConstantPool().decodeEntry(mr);
            sb.append(i2).append(": ").append(this.formatReferenceKind(icpe.getReferenceKind()));
            sb.append(" ").append(this.format(cp, icpe.getReferenceIndex()));
            sb.append("\n");
            int[] args = entry.getBootstrapArguments();
            sb.append("  Method arguments:\n");
            int a = 0;
            while (a < args.length) {
                sb.append("    ").append(this.format(cp, args[a])).append("\n");
                ++a;
            }
            ++i2;
        }
        return sb.toString();
    }

    private String printLambdaMethods(String filepath) {
        IClassFileReader cfr = ToolFactory.createDefaultClassFileReader((String)filepath, (int)3);
        IMethodInfo[] methodInfos = cfr.getMethodInfos();
        StringBuilder buf = new StringBuilder();
        int i = 0;
        int max = methodInfos.length;
        while (i < max) {
            IMethodInfo methodInfo = methodInfos[i];
            if (new String(methodInfo.getName()).startsWith("lambda")) {
                int accessFlags = methodInfo.getAccessFlags();
                if (Modifier.isStatic(accessFlags)) {
                    buf.append("static ");
                }
                buf.append(methodInfo.getName());
                buf.append(methodInfo.getDescriptor());
                buf.append("\n");
            }
            ++i;
        }
        return buf.toString();
    }

    String formatReferenceKind(int kind) {
        switch (kind) {
            case 6: {
                return "invokestatic";
            }
        }
        throw new IllegalStateException("nyi for " + kind);
    }

    String format(IConstantPool cp, int entryNumber) {
        IConstantPoolEntry entry = cp.decodeEntry(entryNumber);
        if (entry == null) {
            return "null";
        }
        switch (entry.getKind()) {
            case 3: {
                return Integer.toString(entry.getIntegerValue());
            }
            case 1: {
                return new String(entry.getUtf8Value());
            }
            case 10: {
                return new String(entry.getClassName()) + "." + new String(entry.getMethodName()) + ":" + new String(entry.getMethodDescriptor());
            }
            case 15: {
                IConstantPoolEntry2 entry2 = (IConstantPoolEntry2)entry;
                return this.formatReferenceKind(entry2.getReferenceKind()) + " " + this.format(cp, entry2.getReferenceIndex());
            }
            case 16: {
                return this.format(cp, ((IConstantPoolEntry2)entry).getDescriptorIndex());
            }
            case 7: {
                return new String(entry.getClassInfoName());
            }
        }
        throw new IllegalStateException("nyi for " + entry.getKind());
    }
}

