/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractComparableTest;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;

public class StaticImportTest
extends AbstractComparableTest {
    public StaticImportTest(String name) {
        super(name);
    }

    public static Test suite() {
        return StaticImportTest.buildComparableTestSuite(StaticImportTest.testClass());
    }

    public static Class testClass() {
        return StaticImportTest.class;
    }

    public void test001() {
        this.runConformTest(new String[]{"X.java", "import static java.lang.Math.*;\nimport static java.lang.Math.PI;\npublic class X { double pi = abs(PI); }\n"}, "");
    }

    public void test002() {
        this.runConformTest(new String[]{"p/X.java", "package p;\nimport static p2.Y.*;\nimport static p2.Z.Zint;\nimport static p2.Z.ZMember;\npublic class X {\n\tint x = y(1);\n\tint y = Yint;\n\tint z = Zint;\n\tvoid m1(YMember m) {}\n\tvoid m2(ZMember m) {}\n}\n", "p2/Y.java", "package p2;\npublic class Y {\n\tpublic static int Yint = 1;\n\tpublic static int y(int y) { return y; }\n\tpublic static class YMember {}\n}\n", "p2/Z.java", "package p2;\npublic class Z {\n\tpublic static int Zint = 1;\n\tpublic static class ZMember {}\n}\n"}, "");
    }

    public void test003() {
        this.runConformTest(new String[]{"p/X.java", "package p;\nimport static p2.Y.*;\nimport static p2.Z.Zint;\nimport static p2.Z.ZMember;\npublic class X {\n\tint x = y(1);\n\tint y = Yint;\n\tint z = Zint;\n\tvoid m1(YMember m) {}\n\tvoid m2(ZMember m) {}\n}\n", "p2/YY.java", "package p2;\npublic class YY {\n\tpublic static int Yint = 1;\n\tpublic static int y(int y) { return y; }\n\tpublic static class YMember {}\n}\n", "p2/Y.java", "package p2;\npublic class Y extends YY {}\n", "p2/ZZ.java", "package p2;\npublic class ZZ {\n\tpublic static int Zint = 1;\n\tpublic static class ZMember {}\n}\n", "p2/Z.java", "package p2;\npublic class Z extends ZZ {}\n"}, "");
        this.runConformTest(new String[]{"X.java", "import static p.A.C;\npublic class X { int i = C; }\n", "p/A.java", "package p;\npublic class A extends B implements I {}\nclass B implements I {}\n", "p/I.java", "package p;\npublic interface I { public static int C = 1; }\n"}, "");
        this.runConformTest(new String[]{"X.java", "import static p.A.C;\npublic class X { \n\tint i = C; \n\tint j = p.A.C; \n}\n", "p/A.java", "package p;\npublic class A implements I {}\ninterface I { public static int C = 1; }\n"}, AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacBugFixed_6_10);
    }

    public void test004() {
        this.runNegativeTest(new String[]{"p/X.java", "package p;\nimport static p2.Y.*;\nimport static p2.Z.Zint;\nimport static p2.Z.ZMember;\npublic class X {\n\tint x = y(1);\n\tint y = Yint;\n\tint z = Zint;\n\tvoid m1(YMember m) {}\n\tvoid m2(ZMember m) {}\n}\n", "p2/Y.java", "package p2;\npublic class Y {\n\tpublic int Yint = 1;\n\tpublic int y(int y) { return y; }\n\tpublic class YMember {}\n}\n", "p2/Z.java", "package p2;\npublic class Z {\n\tpublic int Zint = 1;\n\tpublic class ZMember {}\n}\n"}, "----------\n1. ERROR in p\\X.java (at line 3)\n\timport static p2.Z.Zint;\n\t              ^^^^^^^^^\nThe import p2.Z.Zint cannot be resolved\n----------\n2. ERROR in p\\X.java (at line 4)\n\timport static p2.Z.ZMember;\n\t              ^^^^^^^^^^^^\nThe import p2.Z.ZMember cannot be resolved\n----------\n3. ERROR in p\\X.java (at line 6)\n\tint x = y(1);\n\t        ^\nThe method y(int) is undefined for the type X\n----------\n4. ERROR in p\\X.java (at line 7)\n\tint y = Yint;\n\t        ^^^^\nYint cannot be resolved to a variable\n----------\n5. ERROR in p\\X.java (at line 8)\n\tint z = Zint;\n\t        ^^^^\nZint cannot be resolved to a variable\n----------\n6. ERROR in p\\X.java (at line 9)\n\tvoid m1(YMember m) {}\n\t        ^^^^^^^\nYMember cannot be resolved to a type\n----------\n7. ERROR in p\\X.java (at line 10)\n\tvoid m2(ZMember m) {}\n\t        ^^^^^^^\nZMember cannot be resolved to a type\n----------\n");
    }

    public void test005() {
        this.runNegativeTest(new String[]{"p/X.java", "package p;\nimport static p2.Y.*;\nimport static p2.Z.Zint;\nimport static p2.Z.ZMember;\npublic class X {\n\tint x = y(1);\n\tint y = Yint;\n\tint z = Zint;\n\tvoid m1(YMember m) {}\n\tvoid m2(ZMember m) {}\n}\n", "p2/Y.java", "package p2;\npublic class Y {\n\tstatic int Yint = 1;\n\tstatic int y(int y) { return y; }\n\tstatic class YMember {}\n}\n", "p2/Z.java", "package p2;\npublic class Z {\n\tstatic int Zint = 1;\n\tstatic class ZMember {}\n}\n"}, "----------\n1. ERROR in p\\X.java (at line 3)\n\timport static p2.Z.Zint;\n\t              ^^^^^^^^^\nThe field Z.p2.Z.Zint is not visible\n----------\n2. ERROR in p\\X.java (at line 4)\n\timport static p2.Z.ZMember;\n\t              ^^^^^^^^^^^^\nThe type p2.Z.ZMember is not visible\n----------\n3. ERROR in p\\X.java (at line 6)\n\tint x = y(1);\n\t        ^\nThe method y(int) from the type Y is not visible\n----------\n4. ERROR in p\\X.java (at line 7)\n\tint y = Yint;\n\t        ^^^^\nThe field Y.Yint is not visible\n----------\n5. ERROR in p\\X.java (at line 8)\n\tint z = Zint;\n\t        ^^^^\nZint cannot be resolved to a variable\n----------\n6. ERROR in p\\X.java (at line 9)\n\tvoid m1(YMember m) {}\n\t        ^^^^^^^\nThe type YMember is not visible\n----------\n7. ERROR in p\\X.java (at line 10)\n\tvoid m2(ZMember m) {}\n\t        ^^^^^^^\nZMember cannot be resolved to a type\n----------\n");
    }

    public void test006() {
        this.runNegativeTest(new String[]{"p/X.java", "package p;\nimport static p2.Z.ZStatic;\nimport static p2.Z.ZNonStatic;\nimport p2.Z.ZNonStatic;\npublic class X {\n\tvoid m2(ZStatic m) {}\n\tvoid m3(ZNonStatic m) {}\n}\n", "p2/Z.java", "package p2;\npublic class Z {\n\tpublic static class ZStatic {}\n\tpublic class ZNonStatic {}\n}\n"}, "----------\n1. ERROR in p\\X.java (at line 3)\n\timport static p2.Z.ZNonStatic;\n\t              ^^^^^^^^^^^^^^^\nThe import p2.Z.ZNonStatic cannot be resolved\n----------\n");
    }

    public void test007() {
        this.runConformTest(new String[]{"p/X.java", "package p;\nimport static p2.Z.ZFieldOverMember;\npublic class X {\n\tint z = ZFieldOverMember;\n}\n", "p2/Z.java", "package p2;\npublic class Z {\n\tpublic static int ZFieldOverMember = 1;\n\tpublic class ZFieldOverMember {}\n}\n"}, "");
    }

    public void test008() {
        this.runNegativeTest(new String[]{"p/X.java", "package p;\nimport static java.lang.System;\npublic class X {}\n"}, "----------\n1. ERROR in p\\X.java (at line 2)\n\timport static java.lang.System;\n\t              ^^^^^^^^^^^^^^^^\nThe static import java.lang.System must be a field or member type\n----------\n");
    }

    public void test009() {
        this.runNegativeTest(new String[]{"p/X.java", "package p;\nimport static java.lang.reflect.Method.*;\npublic class X {Method m;}\n"}, "----------\n1. ERROR in p\\X.java (at line 3)\n\tpublic class X {Method m;}\n\t                ^^^^^^\nMethod cannot be resolved to a type\n----------\n");
    }

    public void test010() {
        this.runNegativeTest(new String[]{"X.java", "import static java.lang.System.*;\npublic class X {\n\tvoid foo() { arraycopy(); }\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tvoid foo() { arraycopy(); }\n\t             ^^^^^^^^^\nThe method arraycopy(Object, int, Object, int, int) in the type System is not applicable for the arguments ()\n----------\n");
    }

    public void test011() {
        this.runNegativeTest(new String[]{"X.java", "import static p.Y.*;\npublic class X extends p.Z {}\nclass XX extends M.N {}\nclass XXX extends M.Missing {}\n", "p/YY.java", "package p;\npublic class YY {\n\tpublic static class M {\n\t\tpublic static class N {}\n\t}\n}\n", "p/Y.java", "package p;\npublic class Y extends YY {}\n", "p/Z.java", "package p;\npublic class Z {}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tclass XXX extends M.Missing {}\n\t                  ^^^^^^^^^\nM.Missing cannot be resolved to a type\n----------\n");
    }

    public void test012() {
        this.runConformTest(new String[]{"X.java", "import static java.lang.Math.*;\npublic class X {\n\tpublic static void main(String[] s) {\n\t\tSystem.out.println(max(1, 2));\n\t}\n}\n"}, "2");
        this.runConformTest(new String[]{"X.java", "import static java.lang.Math.max;\npublic class X {\n\tpublic static void main(String[] s) {\n\t\tSystem.out.println(max(1, 3));\n\t}\n}\n"}, "3");
        this.runConformTest(new String[]{"X.java", "import static p1.C.F;\nimport p2.*;\npublic class X implements F {\tint i = F();}\n", "p1/C.java", "package p1;\npublic class C {\n\tpublic static int F() { return 0; }\n}\n", "p2/F.java", "package p2;\npublic interface F {}\n"}, "");
    }

    public void test013() {
        this.runNegativeTest(new String[]{"X.java", "import static p.Y.ZZ;\nimport static p.Z.ZZ.WW;\nimport static p.Z.Zz.WW;\nimport static p.Z.Zz.*;\nimport static p.Z.Zz.Zzz;\nimport static p.Y.Zz;\nimport static p.Z.Zz.WW.*;\nimport p.Y.ZZ;\nimport static p.Y.ZZ.*;\nimport static p.Y.ZZ.WW;\nimport static p.Y.ZZ.WW.*;\nimport static p.Y.ZZ.ZZZ;\nimport static p.Y.ZZ.WW.WWW;\npublic class X {\n\tint i = Zzz + Zzzz;\n\tZZ z;\n\tWW w;\n}\n", "p/Y.java", "package p;\npublic class Y extends Z {}\n", "p/Z.java", "package p;\npublic class Z {\n\tpublic class Zz extends W { public static final int Zzz = 0; public static final int Zzzz = 1; }\n\tpublic static class ZZ extends W { public static final int ZZZ = 0; }\n}\n", "p/W.java", "package p;\npublic class W {\n\tpublic static class WW { public static final int WWW = 0; }\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\timport static p.Y.Zz;\n\t              ^^^^^^\nThe import p.Y.Zz cannot be resolved\n----------\n2. ERROR in X.java (at line 7)\n\timport static p.Z.Zz.WW.*;\n\t              ^^^^^^^^^\nThe import p.Z.Zz.WW cannot be resolved\n----------\n3. ERROR in X.java (at line 8)\n\timport p.Y.ZZ;\n\t       ^^^^^^\nThe import p.Y.ZZ cannot be resolved\n----------\n4. ERROR in X.java (at line 9)\n\timport static p.Y.ZZ.*;\n\t              ^^^^^^\nThe import p.Y.ZZ cannot be resolved\n----------\n5. ERROR in X.java (at line 10)\n\timport static p.Y.ZZ.WW;\n\t              ^^^^^^\nThe import p.Y.ZZ cannot be resolved\n----------\n6. ERROR in X.java (at line 11)\n\timport static p.Y.ZZ.WW.*;\n\t              ^^^^^^\nThe import p.Y.ZZ cannot be resolved\n----------\n7. ERROR in X.java (at line 12)\n\timport static p.Y.ZZ.ZZZ;\n\t              ^^^^^^\nThe import p.Y.ZZ cannot be resolved\n----------\n8. ERROR in X.java (at line 13)\n\timport static p.Y.ZZ.WW.WWW;\n\t              ^^^^^^\nThe import p.Y.ZZ cannot be resolved\n----------\n");
    }

    public void test014() {
        this.runConformTest(new String[]{"X.java", "import static p.Z.ZZ.ZZZ;\npublic class X {}\n", "p/Z.java", "package p;\npublic class Z {\n\tpublic class ZZ { public static final  int ZZZ = 0; }\n}\n"}, "");
    }

    public void test015() {
        this.runConformTest(new String[]{"X.java", "import p.Z.*;\nimport static p.Z.*;\npublic class X { int i = COUNT; }\n", "p/Z.java", "package p;\npublic class Z {\n\tpublic static final  int COUNT = 0;\n}\n"}, "");
        this.runConformTest(new String[]{"X.java", "import static p.Z.*;\nimport p.Z.*;\npublic class X { int i = COUNT; }\n", "p/Z.java", "package p;\npublic class Z {\n\tpublic static final  int COUNT = 0;\n}\n"}, "");
    }

    public void test016() {
        this.runNegativeTest(new String[]{"X.java", "import static java.lang.*;\npublic class X {}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\timport static java.lang.*;\n\t              ^^^^^^^^^\nOnly a type can be imported. java.lang resolves to a package\n----------\n");
    }

    public void test017() {
        this.runConformTest(new String[]{"bug/A.java", "package bug;\nimport static bug.C.*;\npublic class A {\n   private B b;\n}\n", "bug/B.java", "package bug;\nimport static bug.C.*;\npublic class B {\n}\n", "bug/C.java", "package bug;\npublic class C {\n   private B b;\n}\n"}, "");
    }

    public void test018() {
        this.runNegativeTest(new String[]{"bug/A.java", "package bug;\nimport static bug.C.*;\npublic class A {\n   private B b2 = b;\n}\n", "bug/B.java", "package bug;\nimport static bug.C.*;\npublic class B {\n}\n", "bug/C.java", "package bug;\npublic class C {\n   private static B b;\n}\n"}, "----------\n1. ERROR in bug\\A.java (at line 4)\n\tprivate B b2 = b;\n\t               ^\nThe field C.b is not visible\n----------\n----------\n1. WARNING in bug\\B.java (at line 2)\n\timport static bug.C.*;\n\t              ^^^^^\nThe import bug.C is never used\n----------\n----------\n1. WARNING in bug\\C.java (at line 3)\n\tprivate static B b;\n\t                 ^\nThe value of the field C.b is not used\n----------\n");
    }

    public void test019() {
        this.runNegativeTest(new String[]{"X.java", "import static java.lang.Math.PI;\n\npublic class X {\n  boolean PI;\n  Zork z;\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test020() {
        this.runNegativeTest(new String[]{"X.java", "import static java.lang.Math.round;\npublic class X {\n  void foo() { cos(0); }\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tvoid foo() { cos(0); }\n\t             ^^^\nThe method cos(int) is undefined for the type X\n----------\n");
    }

    public void test021() {
        this.runConformTest(new String[]{"X.java", "import static p.B.foo;\npublic class X {\n  void test() { foo(); }\n}\n", "p/A.java", "package p;\npublic class A { public static void foo() {} }\n", "p/B.java", "package p;\npublic class B extends A { }\n"}, "");
        this.runNegativeTest(new String[]{"X.java", "import static p.B.foo;\npublic class X {\n  void test() { foo(); }\n}\n", "p/A.java", "package p;\npublic class A { public void foo() {} }\n", "p/B.java", "package p;\npublic class B extends A { static void foo(int i) {} }\n"}, "----------\n1. ERROR in X.java (at line 1)\n\timport static p.B.foo;\n\t              ^^^^^^^\nThe import p.B.foo cannot be resolved\n----------\n2. ERROR in X.java (at line 3)\n\tvoid test() { foo(); }\n\t              ^^^\nThe method foo() is undefined for the type X\n----------\n");
    }

    public void test022() {
        this.runConformTest(new String[]{"X.java", "import static p.A.F;\nimport static p.B.F;\npublic class X {\n\tint i = F;\n}\n", "p/A.java", "package p;\npublic class A { public static class F {} }\n", "p/B.java", "package p;\npublic class B { public static int F = 2; }\n"}, "");
        this.runConformTest(new String[]{"X.java", "import static p.A.F;\nimport static p.B.F;\npublic class X {\n\tint i = F + F();\n}\n", "p/A.java", "package p;\npublic class A { public static int F() { return 1; } }\n", "p/B.java", "package p;\npublic class B { public static int F = 2; }\n"}, "");
        this.runConformTest(new String[]{"X.java", "import static p.A.F;\nimport static p.B.F;\npublic class X {\n\tint i = F;\n}\n", "p/A.java", "package p;\npublic class A { public static int F = 1; }\n", "p/B.java", "package p;\npublic class B extends A {}\n"}, "");
        this.runNegativeTest(new String[]{"X.java", "import static p.A.F;\nimport static p.B.F;\npublic class X {\n\tint i = F;\n}\n", "p/A.java", "package p;\npublic class A { public static int F = 1; }\n", "p/B.java", "package p;\npublic class B { public static int F = 2; }\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tint i = F;\n\t        ^\nThe field F is ambiguous\n----------\n");
    }

    public void test023() {
        this.runConformTest(new String[]{"X.java", "import static p.A.C;\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.print(C);\n\t\tSystem.out.print(C());\n\t}\n}\n", "p/A.java", "package p;\npublic class A {\n\tpublic static int C = 1;\n\tpublic static int C() { return C + 3; }\n}\n"}, "14");
        this.runConformTest(new String[]{"X.java", "import static p.A.C;\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.print(C);\n\t\tSystem.out.print(C());\n\t}\n}\n", "p/A.java", "package p;\npublic class A extends B {\n\tpublic static int C() { return C + 3; }\n}\n", "p/B.java", "package p;\npublic class B {\n\tpublic static int C = 1;\n}\n"}, "14");
    }

    public void test024() {
        this.runNegativeTest(new String[]{"p/B.java", "package p;\nimport static p.A.m;\nimport static p2.C.m;\nclass A { static void m() {} }\npublic class B { public static void main(String[] args) { m(); } }\n", "p2/C.java", "package p2;\npublic class C { public static void m() {} }\n"}, "----------\n1. ERROR in p\\B.java (at line 5)\n\tpublic class B { public static void main(String[] args) { m(); } }\n\t                                                          ^\nThe method m() is ambiguous for the type B\n----------\n");
        this.runConformTest(new String[]{"p/X.java", "package p;\nimport static p.A.m;\nimport static p.B.m;\npublic class X { void test() { m(); } }\nclass B extends A {}\n", "p/A.java", "package p;\npublic class A { public static int m() { return 0; } }\n"}, "");
    }

    public void test025() {
        this.runConformTest(new String[]{"X.java", "import static java.lang.Math.*;\npublic class X {\n\tpublic static void main(String[] s) {\n\t\tSystem.out.print(max(PI, 4));\n\t\tnew Runnable() {\n\t\t\tpublic void run() {\n\t\t\t\tSystem.out.println(max(PI, 5));\n\t\t\t}\n\t\t}.run();\n\t}\n}\n"}, "4.05.0");
    }

    public void test026() {
        this.runConformTest(new String[]{"X.java", "public class X extends Y { static void test() { java.lang.String.valueOf(0); } }\nclass Y { private String java; }\n"}, "");
    }

    public void test027() {
        this.runNegativeTest(new String[]{"X.java", "import static p.ST.foo;\npublic class X {\n\t\n\tfoo bar;\n}\n", "p/ST.java", "package p; \npublic class ST {\n\tpublic static int foo;\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tfoo bar;\n\t^^^\nfoo cannot be resolved to a type\n----------\n");
    }

    public void test028() {
        this.runConformTest(new String[]{"p1/Z.java", "package p1;\npublic class Z {\n\tpublic interface I {\n\t}\n}\n", "q/Y.java", "package q;\nimport static p.X.I;\nimport static p1.Z.I;\npublic class Y implements I {\n}\n", "p/X.java", "package p;\npublic enum X {\n\tI, J, K\n}\n"}, "");
        this.runConformTest(new String[]{"q/Y.java", "package q;\nimport static p.X.I;\nimport static p1.Z.I;\npublic class Y implements I {\n}\n"}, "", null, false, null);
    }

    public void test029() {
        this.runNegativeTest(new String[]{"p1/A.java", "package p1;\nimport static p2.C.B;\npublic class A extends B {\n\tvoid test() {\t\tint i = B();\n\t\tB b = null;\n\t\tb.fooB();\n\t\tb.fooC();\n\t\tfooC();\n\t}\n}\n", "p1/B.java", "package p1;\npublic class B {\n\tpublic void fooB() {}\n}\n", "p2/C.java", "package p2;\npublic class C {\n\tpublic static class B { public void fooC() {} }\n\tpublic static int B() { return 0; }\n}\n"}, "----------\n1. ERROR in p1\\A.java (at line 6)\n\tb.fooB();\n\t  ^^^^\nThe method fooB() is undefined for the type C.B\n----------\n");
    }

    public void test030() {
        this.runNegativeTest(new String[]{"p2/Test.java", "package p2;\nimport static p1.A.*;\npublic class Test {\n\tInner1 i; // not found\n\tInner2 j;\n}\n", "p1/A.java", "package p1;\npublic class A {\n\tpublic class Inner1 {}\n\tpublic static class Inner2 {}\n}\n"}, "----------\n1. ERROR in p2\\Test.java (at line 4)\n\tInner1 i; // not found\n\t^^^^^^\nInner1 cannot be resolved to a type\n----------\n");
        this.runConformTest(new String[]{"p2/Test.java", "package p2;\nimport p1.A.*;\nimport static p1.A.*;\nimport static p1.A.*;\npublic class Test {\n\tInner1 i;\n\tInner2 j;\n}\n", "p1/A.java", "package p1;\npublic class A {\n\tpublic class Inner1 {}\n\tpublic static class Inner2 {}\n}\n"}, "");
    }

    public void test031() {
        this.runNegativeTest(new String[]{"PointRadius.java", "import static java.lang.Math.sqrt;\n\npublic class PointRadius {\n\n\tpublic static void main(String[] args) {\n\t\tdouble radius = 0;\n\t\tradius = sqrt(pondArea / Math.PI);\n\n\t}\n}\n"}, "----------\n1. ERROR in PointRadius.java (at line 7)\n\tradius = sqrt(pondArea / Math.PI);\n\t              ^^^^^^^^\npondArea cannot be resolved to a variable\n----------\n");
    }

    public void test032() {
        this.runConformTest(new String[]{"X.java", "import static p.A.*;\nimport static p.B.*;\npublic class X {\n\tpublic static void main(String[] args) {foo();}\n}\n", "p/A.java", "package p;public class A {\n\tpublic static void foo() {System.out.print(false);}\n}\n", "p/B.java", "package p;public class B extends A {\n\tpublic static void foo() {System.out.print(true);}\n}\n"}, "true");
    }

    public void test032b() {
        this.runNegativeTest(new String[]{"X2.java", "import static p2.A.*;\nimport static p2.B.*;\npublic class X2 { void test() {foo();} }\n", "p2/A.java", "package p2;public class A {\n\tpublic static void foo() {}\n}\n", "p2/B.java", "package p2;public class B {\n\tpublic static void foo() {}\n}\n"}, "----------\n1. ERROR in X2.java (at line 3)\n\tpublic class X2 { void test() {foo();} }\n\t                               ^^^\nThe method foo() is ambiguous for the type X2\n----------\n");
    }

    public void test032c() {
        this.runConformTest(new String[]{"X3.java", "import static p3.A.*;\nimport static p3.B.foo;\npublic class X3 {\n\tpublic static void main(String[] args) {foo();}\n}\n", "p3/A.java", "package p3;public class A {\n\tpublic static void foo() {System.out.print(false);}\n}\n", "p3/B.java", "package p3;public class B {\n\tpublic static void foo() {System.out.print(true);}\n}\n"}, "true");
    }

    public void test032d() {
        this.runConformTest(new String[]{"X4.java", "import static p4.A.foo;\nimport static p4.B.*;\npublic class X4 {\n\tpublic static void main(String[] args) {foo();}\n}\n", "p4/A.java", "package p4;public class A {\n\tpublic static void foo() {System.out.print(true);}\n}\n", "p4/B.java", "package p4;public class B extends A {\n\tpublic static void foo() {System.out.print(false);}\n}\n"}, "true");
    }

    public void test033() {
        this.runConformTest(new String[]{"X.java", "import static p.A.*;\nimport static p.B.*;\npublic class X {\n\tpublic static void main(String[] args) {foo(\"aa\");}\n}\n", "p/A.java", "package p;public class A {\n\tpublic static <U> void foo(U u) {System.out.print(false);}\n}\n", "p/B.java", "package p;public class B extends A {\n\tpublic static <V> void foo(String s) {System.out.print(true);}\n}\n"}, "true");
    }

    public void test033b() {
        this.runConformTest(new String[]{"X2.java", "import static p2.A.*;\nimport static p2.B.*;\npublic class X2 {\n\tpublic static void main(String[] args) {foo(\"aa\");}\n}\n", "p2/A.java", "package p2;public class A {\n\tpublic static <U> void foo(String s) {System.out.print(true);}\n}\n", "p2/B.java", "package p2;public class B extends A {\n\tpublic static <V> void foo(V v) {System.out.print(false);}\n}\n"}, "true");
    }

    public void test034() {
        this.runConformTest(new String[]{"test/AbstractTest.java", "package test;\npublic abstract class AbstractTest<Z> {\n  \n  public abstract MyEnum m(Z z);\n  \n  public enum MyEnum {\n    A,B\n  }\n}\n", "test/X.java", "package test;\nimport static test.AbstractTest.MyEnum.*;\npublic class X extends AbstractTest<String> {\n  @Override public MyEnum m(String s) {\n    return A;\n  }\n}\n"}, "");
    }

    public void test035() {
        this.runConformTest(new String[]{"Bug.java", "import static java.lang.String.format;\npublic class Bug extends p.TestCase {\n\tpublic static void main(String[] args) {\n\t\tString msg = \"test\";\n\t\tSystem.out.print(format(msg));\n\t\tSystem.out.print(format(msg, 1, 2));\n\t}\n}\n", "p/TestCase.java", "package p;\npublic class TestCase {\n\tstatic String format(String message, Object expected, Object actual) {return null;}\n}\n"}, "testtest");
        this.runNegativeTest(new String[]{"C.java", "class A {\n\tstatic class B { void foo(Object o, String s) {} }\n\tvoid foo(int i) {}\n}\nclass C extends A.B {\n\tvoid test() { foo(1); }\n}\n"}, "----------\n1. ERROR in C.java (at line 6)\n\tvoid test() { foo(1); }\n\t              ^^^\nThe method foo(Object, String) in the type A.B is not applicable for the arguments (int)\n----------\n");
        this.runNegativeTest(new String[]{"A.java", "public class A {\n  void foo(int i, long j) {}\n  class B {\n    void foo() { foo(1, 1); }\n  }\n}"}, "----------\n1. ERROR in A.java (at line 4)\n\tvoid foo() { foo(1, 1); }\n\t             ^^^\nThe method foo() in the type A.B is not applicable for the arguments (int, int)\n----------\n");
    }

    public void test036() {
        this.runNegativeTest(new String[]{"X.java", "import static p.A.CONSTANT_I;\nimport static p.A.CONSTANT_B;\npublic class X {\n  static int i = p.A.CONSTANT_I;\n  static int j = p.A.CONSTANT_B;\n  static int m = CONSTANT_I;\n  static int n = CONSTANT_B;\n}", "p/A.java", "package p;\npublic class A extends B implements I {}\ninterface I { int CONSTANT_I = 1; }\nclass B { int CONSTANT_B = 1; }"}, "----------\n1. ERROR in X.java (at line 2)\n\timport static p.A.CONSTANT_B;\n\t              ^^^^^^^^^^^^^^\nThe field B.p.A.CONSTANT_B is not visible\n----------\n2. ERROR in X.java (at line 5)\n\tstatic int j = p.A.CONSTANT_B;\n\t                   ^^^^^^^^^^\nThe field B.CONSTANT_B is not visible\n----------\n3. ERROR in X.java (at line 7)\n\tstatic int n = CONSTANT_B;\n\t               ^^^^^^^^^^\nCONSTANT_B cannot be resolved to a variable\n----------\n");
    }

    public void test037() {
        this.runConformTest(new String[]{"X.java", "import static p.A.CONSTANT_I;\nimport static p.A.CONSTANT_B;\npublic class X {\n  static int i = p.A.CONSTANT_I;\n  static int j = p.A.CONSTANT_B;\n  static int m = CONSTANT_I;\n  static int n = CONSTANT_B;\n}", "p/A.java", "package p;\npublic class A extends B implements I {}\ninterface I { int CONSTANT_I = 1; }\nclass B { public static int CONSTANT_B = 1; }"}, AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacBugFixed_6_10);
    }

    public void test038() {
        this.runNegativeTest(new String[]{"X.java", "import static p.A.foo_I;\nimport static p.A.foo_B;\npublic class X {\n  static int i = p.A.foo_I();\n  static int j = p.A.foo_B();\n  static int m = foo_I();\n  static int n = foo_B();\n}", "p/A.java", "package p;\npublic abstract class A extends B implements I {}\ninterface I { int foo_I(); }\nclass B { int foo_B() { return 2;} }"}, "----------\n1. ERROR in X.java (at line 1)\n\timport static p.A.foo_I;\n\t              ^^^^^^^^^\nThe import p.A.foo_I cannot be resolved\n----------\n2. ERROR in X.java (at line 2)\n\timport static p.A.foo_B;\n\t              ^^^^^^^^^\nThe import p.A.foo_B cannot be resolved\n----------\n3. ERROR in X.java (at line 4)\n\tstatic int i = p.A.foo_I();\n\t               ^^^^^^^^^^^\nCannot make a static reference to the non-static method foo_I() from the type I\n----------\n4. ERROR in X.java (at line 5)\n\tstatic int j = p.A.foo_B();\n\t                   ^^^^^\nThe method foo_B() from the type B is not visible\n----------\n5. ERROR in X.java (at line 6)\n\tstatic int m = foo_I();\n\t               ^^^^^\nThe method foo_I() is undefined for the type X\n----------\n6. ERROR in X.java (at line 7)\n\tstatic int n = foo_B();\n\t               ^^^^^\nThe method foo_B() is undefined for the type X\n----------\n");
    }

    public void test039() {
        this.runNegativeTest(new String[]{"X.java", "import static p.A.foo_I;\nimport static p.A.foo_B;\npublic class X {\n  static int i = p.A.foo_I();\n  static int j = p.A.foo_B();\n  static int m = foo_I();\n  static int n = foo_B();\n}", "p/A.java", "package p;\npublic abstract class A extends B implements I {}\ninterface I { int foo_I(); }\nclass B { public static int foo_B() { return 2;} }"}, "----------\n1. ERROR in X.java (at line 1)\n\timport static p.A.foo_I;\n\t              ^^^^^^^^^\nThe import p.A.foo_I cannot be resolved\n----------\n2. ERROR in X.java (at line 4)\n\tstatic int i = p.A.foo_I();\n\t               ^^^^^^^^^^^\nCannot make a static reference to the non-static method foo_I() from the type I\n----------\n3. ERROR in X.java (at line 6)\n\tstatic int m = foo_I();\n\t               ^^^^^\nThe method foo_I() is undefined for the type X\n----------\n");
    }

    public void test040() {
        this.runConformTest(new String[]{"p1/Z.java", "package p1;\npublic class Z {\n\tpublic interface I {\n\t}\n}\n", "q/Y.java", "package q;\nimport static p.X.foo;\nimport static p1.Z.I;\npublic class Y implements I {\n}\n", "p/X.java", "package p;\npublic class X {\n\tpublic static void foo() {}\n}\n"}, "");
        this.runConformTest(new String[]{"q/Y.java", "package q;\nimport static p.X.foo;\nimport static p1.Z.I;\npublic class Y implements I {\n}\n"}, "", null, false, null);
    }

    public void test041() {
        this.runConformTest(true, new String[]{"Test.java", "import static p.I.*;\nimport static p.J.*;\npublic class Test {\n\tint i = Constant;\n}\n", "p/I.java", "package p;\npublic interface I { static int Constant = 1; }\n", "p/J.java", "package p;\npublic interface J extends I {}\n"}, "----------\n1. WARNING in Test.java (at line 2)\n\timport static p.J.*;\n\t              ^^^\nThe import p.J is never used\n----------\n", null, null, AbstractRegressionTest.JavacTestOptions.Excuse.EclipseHasSomeMoreWarnings);
    }

    public void test042() {
        this.runNegativeTest(new String[]{"ImportTest.java", "import static p.ArrayTest.toString2;\npublic class ImportTest extends SuperTest {\n\tpublic static void main(String[] args) { printArgs(1, 2, 3, 4, 5); }\n\tstatic void printArgs(Object... args) { toString2(args); }\n}\nclass SuperTest {\n\tstatic void toString2() {}\n}\n", "p/ArrayTest.java", "package p;\npublic class ArrayTest {\n\tpublic static void toString2(String[] args) {}\n}\n"}, "----------\n1. ERROR in ImportTest.java (at line 4)\n\tstatic void printArgs(Object... args) { toString2(args); }\n\t                                        ^^^^^^^^^\nThe method toString2() in the type SuperTest is not applicable for the arguments (Object[])\n----------\n");
        this.runNegativeTest(new String[]{"ImportTest.java", "import static java.util.Arrays.toString;\npublic class ImportTest {\n\tpublic static void main(String[] args) { printArgs(1, 2, 3, 4, 5); }\n\tstatic void printArgs(Object... args) { toString(args); }\n}\n"}, "----------\n1. ERROR in ImportTest.java (at line 4)\n\tstatic void printArgs(Object... args) { toString(args); }\n\t                                        ^^^^^^^^\nThe method toString() in the type Object is not applicable for the arguments (Object[])\n----------\n");
    }

    public void test042b() {
        this.runConformTest(new String[]{"ImportTest.java", "import static p.DefinesFoo.foo;\npublic class ImportTest extends SuperImportTest {\n\tvoid test() { foo(\"fails?\"); }\n}\nclass SuperImportTest {\n\tprivate void foo() {}\n}\n", "p/DefinesFoo.java", "package p;\npublic class DefinesFoo {\n\tpublic static void foo(String s) {}\n}\n"}, "");
    }

    public void test043() {
        this.runConformTest(new String[]{"B.java", "import static java.lang.String.format;\npublic class B extends p.A {\n\tvoid test() { format(\"fails?\"); }\n\tvoid test2() { format(\"fails?\", null); }\n\tvoid test3() { format(\"fails?\", null, null); }\n\tvoid test4() { format(\"fails?\", null, null, null); }\n}\n", "p/A.java", "package p;\npublic class A {\n\tstatic String format(String message, Object expected, Object actual) { return null; }\n}\n"}, "");
    }

    public void test044() {
        this.runConformTest(new String[]{"p/X.java", "package p;\nimport static p.X.B.E;\nimport static p.X.B.*;\n\npublic class X {\n  public static class Y {\n    public enum E { FOO; }\n    public static Object E() { return null; }\n    public enum F { FOO; }\n    public static Object F() { return null; }\n  }\n  public static class B extends Y {}\n  Object f1 = E.FOO;\n  Object f2 = E();\n  Object f3 = F.FOO;\n  Object f4 = F();\n}\n"}, "");
    }

    public void test045() {
        this.runNegativeTest(new String[]{"X.java", "import static test.Y.arrayList;\npublic class X { static void arrayList(int x) { arrayList(); } }\n", "test/Y.java", "package test;\npublic class Y { public static void arrayList() {} }\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tpublic class X { static void arrayList(int x) { arrayList(); } }\n\t                                                ^^^^^^^^^\nThe method arrayList(int) in the type X is not applicable for the arguments ()\n----------\n");
    }

    public void test045b() {
        this.runNegativeTest(new String[]{"test/One.java", "package test;\npublic class One { public static void arrayList(String s) {} }\n", "test/Two.java", "package test;\npublic class Two { public void arrayList(int i) {} }\n", "test/Three.java", "package test;\nimport static test.One.arrayList;\npublic class Three extends Two { public static void test(String s) { arrayList(s); } }\n"}, "----------\n1. ERROR in test\\Three.java (at line 3)\n\tpublic class Three extends Two { public static void test(String s) { arrayList(s); } }\n\t                                                                     ^^^^^^^^^\nThe method arrayList(int) in the type Two is not applicable for the arguments (String)\n----------\n");
        this.runNegativeTest(new String[]{"test/One.java", "package test;\npublic class One { public static void arrayList(String s) {} }\n", "test/Two.java", "package test;\npublic class Two { public static void arrayList(int i) {} }\n", "test/Three.java", "package test;\nimport static test.One.arrayList;\npublic class Three extends Two { public static void test(String s) { arrayList(s); } }\n"}, "----------\n1. ERROR in test\\Three.java (at line 3)\n\tpublic class Three extends Two { public static void test(String s) { arrayList(s); } }\n\t                                                                     ^^^^^^^^^\nThe method arrayList(int) in the type Two is not applicable for the arguments (String)\n----------\n");
    }

    public void test046() {
        this.runNegativeTest(new String[]{"error/Exporter.java", "package error;\npublic class Exporter {\n  public static String getName(Class<?> c) {\n    return null;\n  }\n}", "error/Importer.java", "package error;\nimport static error.Exporter.getName;\npublic class Importer extends Base {\n  public void testSomething() {\n    getName();\n    getName(Importer.class);\n  }\n}", "error/Base.java", "package error;\npublic class Base {\n  public String getName() {\n    return \"name\";\n  }\n}"}, "----------\n1. ERROR in error\\Importer.java (at line 6)\n\tgetName(Importer.class);\n\t^^^^^^^\nThe method getName() in the type Base is not applicable for the arguments (Class<Importer>)\n----------\n");
    }

    public void test047() {
        this.runNegativeTest(new String[]{"sample/X.java", "package sample;\nimport static sample.X.TestEnum.V1;\nimport static sample.X.TestEnum.V2;\n\npublic class X<T> {\n        public static enum TestEnum {\n                V1,\n                V2\n        }\n\n        public void test(final TestEnum value) {\n                switch (value) {\n                        case V1:\n                        case V2:\n                }\n        }\n\n        public void ref() {\n               final TestEnum v1 = TestEnum.V1;\n               final TestEnum v2 = TestEnum.V2;\n\t\t\t\tint i;\n\t\t\t\ti++;\n        }\n}"}, "----------\n1. WARNING in sample\\X.java (at line 2)\n\timport static sample.X.TestEnum.V1;\n\t              ^^^^^^^^^^^^^^^^^^^^\nThe import sample.X.TestEnum.V1 is never used\n----------\n2. WARNING in sample\\X.java (at line 3)\n\timport static sample.X.TestEnum.V2;\n\t              ^^^^^^^^^^^^^^^^^^^^\nThe import sample.X.TestEnum.V2 is never used\n----------\n3. ERROR in sample\\X.java (at line 22)\n\ti++;\n\t^\nThe local variable i may not have been initialized\n----------\n");
    }

    public void test048() {
        this.runNegativeTest(new String[]{"sample/X.java", "package sample;\nimport static sample.X.TestEnum.*;\n\npublic class X<T> {\n        public static enum TestEnum {\n                V1,\n                V2\n        }\n\n        public void test(final TestEnum value) {\n                switch (value) {\n                        case V1:\n                        case V2:\n                }\n        }\n\n        public void ref() {\n               final TestEnum v1 = TestEnum.V1;\n               final TestEnum v2 = TestEnum.V2;\n\t\t\t\tint i;\n\t\t\t\ti++;\n        }\n}"}, "----------\n1. WARNING in sample\\X.java (at line 2)\n\timport static sample.X.TestEnum.*;\n\t              ^^^^^^^^^^^^^^^^^\nThe import sample.X.TestEnum is never used\n----------\n2. ERROR in sample\\X.java (at line 21)\n\ti++;\n\t^\nThe local variable i may not have been initialized\n----------\n");
    }

    public void test049() {
        this.runNegativeTest(new String[]{"sample/X.java", "package sample;\nimport static sample.X.*;\npublic class X {\n\tpublic class Member {}\n\tpublic void ref() {\n\t\tint i;\n\t\ti++;\n\t}\n}"}, "----------\n1. WARNING in sample\\X.java (at line 2)\n\timport static sample.X.*;\n\t              ^^^^^^^^\nThe import sample.X is never used\n----------\n2. ERROR in sample\\X.java (at line 7)\n\ti++;\n\t^\nThe local variable i may not have been initialized\n----------\n");
    }

    public void test050() {
        this.runConformTest(new String[]{"p/A.java", "package p;\nimport static p.B.bar3;\npublic class A { int a = bar3; }", "p/B.java", "package p;\nimport static p.Util.someStaticMethod;\npublic class B {\n\tstatic final int bar = someStaticMethod();\n\tstatic final int bar2 = someStaticMethod();\n\tstatic final int bar3 = someStaticMethod();\n}", "p/C.java", "package p;\nimport static p.B.bar;\npublic class C { int c = bar; }", "p/Util.java", "package p;\nclass Util { static int someStaticMethod() { return 0; } }"}, "");
    }

    public void test051() {
        this.runConformTest(new String[]{"p/X.java", "package p;\nimport static r.Y.Z;\nimport q.*;\npublic class X<T> extends Z<T> {\n   Z<T> getZ() { return null; } \n\tvoid bar() {\n\t\tSystem.out.println(getZ().value);\n\t}\n}\n", "q/Z.java", "package q;\nimport r.Y;\npublic class Z<T> extends Y<T> {\n}\n", "r/Y.java", "package r;\npublic class Y<T> {\n\tpublic static String foo;\n\tpublic String value;\n\tpublic static String Z;\n}\n"}, "");
    }

    public void test052() {
        this.runConformTest(new String[]{"p/X.java", "package p;\nimport static r.Y.*;\nimport q.*;\npublic class X<T> extends Z<T> {\n   Z<T> getZ() { return null; } \n\tvoid bar() {\n\t\tSystem.out.println(getZ().value);\n\t}\n}\n", "q/Z.java", "package q;\nimport r.Y;\npublic class Z<T> extends Y<T> {\n}\n", "r/Y.java", "package r;\npublic class Y<T> {\n\tpublic static String foo;\n\tpublic String value;\n\tpublic static String Z;\n}\n"}, "");
    }

    public void test053() {
        this.runConformTest(new String[]{"p/X.java", "package p;\nimport static q.Y.foo;\npublic class X extends Z {\n   Z getZ() { return null; } \n\tvoid bar() {\n\t\tSystem.out.println(getZ().value);\n\t}\n}\n", "p/Z.java", "package p;\nimport q.Y;\npublic class Z extends Y {\n}\n", "q/Y.java", "package q;\npublic class Y {\n\tpublic static int foo;\n\tpublic int value;\n}\n"}, "");
    }

    public void test055() {
        this.runConformTest(new String[]{"p/X.java", "package p;\nimport static r.Y.Z;\nimport q.*;\nimport r.*;\npublic class X<T> extends Z<T> {\n   V<T> getV() { return null; } \n\tvoid bar() {\n\t\tSystem.out.println(getV().value);\n\t}\n}\n", "q/Z.java", "package q;\nimport r.Y;\npublic class Z<T> extends Y<T> {\n}\n", "r/Y.java", "package r;\npublic class Y<T> extends V<T>{\n\tpublic static class Z<U> {}\n}\n", "r/V.java", "package r;\npublic class V<T> {\n\tpublic Runnable value;\n}\n"}, "");
    }

    public void test056() {
        this.runNegativeTest(new String[]{"p/X.java", "package p;\nimport static r.Y.Z;\nimport q.*;\npublic class X extends Z {\n   Z getZ() { return null; } \n\tvoid bar() {\n\t\tSystem.out.println(getZ().value);\n\t}\n}\n", "q/Z.java", "package q;\nimport r.Y;\npublic class Z extends Y {\n}\n", "r/Y.java", "package r;\npublic class Y extends V{\n\tpublic static class Z {}\n}\n", "r/V.java", "package r;\npublic class V {\n\tpublic Runnable value;\n}\n"}, "----------\n1. ERROR in p\\X.java (at line 7)\n\tSystem.out.println(getZ().value);\n\t                          ^^^^^\nvalue cannot be resolved or is not a field\n----------\n");
    }

    public void test057() {
        this.runNegativeTest(new String[]{"p/X.java", "package p;\nimport static r.Y.Z;\nimport q.*;\npublic class X<T> extends Z<T> {\n   Z<T> getZ() { return null; } \n\tvoid bar() {\n\t\tSystem.out.println(getZ().value);\n\t}\n}\n", "q/Z.java", "package q;\nimport r.Y;\npublic class Z<T> extends Y<T> {\n}\n", "r/Y.java", "package r;\npublic class Y<T> extends V<T>{\n\tpublic static class Z {}\n}\n", "r/V.java", "package r;\npublic class V<T> {\n\tpublic Runnable value;\n}\n"}, "----------\n1. ERROR in p\\X.java (at line 4)\n\tpublic class X<T> extends Z<T> {\n\t                          ^\nThe type Y.Z is not generic; it cannot be parameterized with arguments <T>\n----------\n2. ERROR in p\\X.java (at line 5)\n\tZ<T> getZ() { return null; } \n\t^\nThe type Y.Z is not generic; it cannot be parameterized with arguments <T>\n----------\n3. ERROR in p\\X.java (at line 7)\n\tSystem.out.println(getZ().value);\n\t                   ^^^^\nThe method getZ() is undefined for the type X<T>\n----------\n");
    }

    public void test058() {
        this.runConformTest(new String[]{"p/X.java", "package p;\nimport static p.A.a;\npublic class X {\n   void foo(W w) { a(w).a(w); }\n}\n", "p/A.java", "package p;\npublic class A {\n   public static A a(W... w) { return null; }\n   public A a(W w) { return null; }\n}\n", "p/W.java", "package p;\npublic class W {}\n"}, "");
    }

    public void test059() {
        this.runConformTest(new String[]{"p/X.java", "package p;\nimport static q.A.a;\npublic class X {\n}\n", "q/A.java", "package q;\ninterface I {\n\tString a = \"\";\n}\nclass B {\n\tpublic static String a;\n}\npublic class A extends B implements I{\n}\n"}, "");
    }

    public void test060() {
        this.runConformTest(new String[]{"p/X.java", "package p;\nimport static q.A.a;\npublic class X {\n}\n", "q/A.java", "package q;\ninterface I {\n\tString a(Object o);\n}\nclass B {\n\tpublic static void a(){}\n}\npublic abstract class A extends B implements I{\n}\n"}, "");
    }

    public void test061() {
        this.runConformTest(true, new String[]{"p/X.java", "package p;\nimport static q.A.a;\npublic class X {\n}\n", "q/A.java", "package q;\ninterface I {\n\tString a = \"\";\n}\ninterface B {\n\tString a = \"2\";\n}\npublic class A implements B, I {\n}\n"}, null, "", null, AbstractRegressionTest.JavacTestOptions.DEFAULT);
    }

    public void test062() {
        this.runNegativeTest(new String[]{"p/X.java", "package p;\nimport static q.A.a;\npublic class X {\n}\n", "q/A.java", "package q;\ninterface I {\n\tString a(Object o);\n}\ninterface B {\n\tvoid a();\n}\npublic abstract class A implements B, I{\n}\n"}, "----------\n1. ERROR in p\\X.java (at line 2)\n\timport static q.A.a;\n\t              ^^^^^\nThe import q.A.a cannot be resolved\n----------\n");
    }

    public void test063() {
        this.runNegativeTest(new String[]{"p/X.java", "package p;\nimport static q.A.a;\nimport static q.A.b;\npublic class X {\n\tvoid test() {\n\t\tSystem.out.println(a);\n\t\tSystem.out.println(b);\n\t\tSystem.out.println(b(1));\n\t}\n}\n", "q/A.java", "package q;\ninterface I {\n\tString a = \"1\";\n\tString b = \"2\";\n}\ninterface J {\n\tString a = \"3\";\n}\nclass B {\n\tpublic static String a = \"4\";\n\tpublic static String b = \"5\";\n\tpublic static String b(int i) { return \"6\"; }\n}\npublic class A extends B implements J, I {}\n"}, "----------\n1. ERROR in p\\X.java (at line 6)\n\tSystem.out.println(a);\n\t                   ^\nThe field a is ambiguous\n----------\n2. ERROR in p\\X.java (at line 7)\n\tSystem.out.println(b);\n\t                   ^\nThe field b is ambiguous\n----------\n", AbstractRegressionTest.JavacTestOptions.DEFAULT);
    }

    public void test064() {
        this.runNegativeTest(new String[]{"p1/X.java", "package p1;\nimport static p2.A.M;\npublic class X {\n\tM m;\n}\n", "p2/A.java", "package p2;\ninterface I { class M {} }\nclass B { public static class M {} }\npublic class A extends B implements I {}\n"}, "----------\n1. ERROR in p1\\X.java (at line 4)\n\tM m;\n\t^\nThe type M is ambiguous\n----------\n", AbstractRegressionTest.JavacTestOptions.DEFAULT);
    }

    public void test065() {
        this.runConformTest(new String[]{"X.java", "import static p.I.E.C;\n\nclass C {}\nclass B<T> {}\npublic class X extends B<C>{\n}", "p/I.java", "package p;\n\npublic interface I <T extends Object> {\n\tenum E { C }\n}"}, "");
    }

    public void test066() {
        this.runConformTest(new String[]{"X.java", "import static p.I.E.C;\n\nclass C {}\nclass B<T> {}\npublic class X extends B<C>{\n}", "p/I.java", "package p;\n\npublic interface I <T extends Object> {\n\tenum E { ; public static void C(){} }\n}"}, "");
    }

    public void test067() {
        this.runNegativeTest(new String[]{"X.java", "import static p.I.E.C;\n\nclass C {}\nclass B<T> {}\npublic class X extends B<C>{\n}", "p/I.java", "package p;\n\npublic interface I <T extends Object> {\n\tenum E { ; static void C(){} }\n}"}, "----------\n1. ERROR in X.java (at line 1)\n\timport static p.I.E.C;\n\t              ^^^^^^^\nThe import p.I.E.C cannot be resolved\n----------\n");
    }

    public void test068() {
        this.runConformTest(new String[]{"X.java", "import static p.I.E.C;\nclass C {}\nclass B<T> {}\npublic class X extends B<C>{\n\tstatic void test() { int i = C; }\n}", "p/I.java", "package p;\npublic interface I<T extends Object> {\n\tpublic static class E extends F {}\n\tpublic static class F { public static int C; }\n}"}, "");
    }

    public void test069() {
        this.runConformTest(new String[]{"X.java", "import static p.I.E.C;\nclass C {}\nclass B<T> {}\npublic class X extends B<C>{\n\tstatic void test() { C(); }\n}", "p/I.java", "package p;\npublic interface I<T extends Object> {\n\tpublic static class E extends F {}\n\tpublic static class F { public static void C() {} }\n}"}, "");
    }

    public void test070() {
        this.runConformTest(new String[]{"node/Test.java", "package node;\npublic class Test {\n        public static void node() {}\n}\n", "node2/Test2.java", "package node2;\nimport static node.Test.node;\npublic class Test2 {\n}\n"}, "");
    }

    public void test071() {
        this.runNegativeTest(new String[]{"node/Test/node.java", "package node.Test;\npublic class node {\n}\n", "node/Test.java", "package node;\npublic class Test {\n        public static void node() {}\n}\n", "node2/Test2.java", "package node2;\nimport node.Test;\nimport static Test.node;\npublic class Test2 {\n}\n"}, "----------\n1. ERROR in node\\Test.java (at line 2)\n\tpublic class Test {\n\t             ^^^^\nThe type Test collides with a package\n----------\n----------\n1. ERROR in node2\\Test2.java (at line 3)\n\timport static Test.node;\n\t              ^^^^\nThe import Test cannot be resolved\n----------\n");
    }

    public void test072() {
        this.runNegativeTest(new String[]{"p1/A.java", "package p1;\nimport static p2.C.B;\npublic class A extends B {\n\tvoid test() {\t\tint i = B;\n\t\tB b = null;\n\t\tint v1 = b.fooB;\n\t\tint v2 = b.fooC;\n\t\tint v3 = fooC;\n\t}\n}\n", "p1/B.java", "package p1;\npublic class B {\n\tpublic int fooB;\n}\n", "p2/C.java", "package p2;\npublic class C {\n\tpublic static class B { public int fooC; }\n\tpublic static int B;\n}\n"}, "----------\n1. ERROR in p1\\A.java (at line 6)\n\tint v1 = b.fooB;\n\t           ^^^^\nfooB cannot be resolved or is not a field\n----------\n");
    }

    public void test073() {
        this.runNegativeTest(new String[]{"test/Outer.java", "package test;\nimport static test.Outer.Inner.VALUE;\npublic class Outer {\n    int i = VALUE;\n    int i2 = Inner.VALUE;\n    static class Inner {\n        private static final int VALUE = 0;\n    }\n}\n"}, "----------\n1. ERROR in test\\Outer.java (at line 2)\n\timport static test.Outer.Inner.VALUE;\n\t              ^^^^^^^^^^^^^^^^^^^^^^\nThe field Outer.Inner.test.Outer.Inner.VALUE is not visible\n----------\n2. ERROR in test\\Outer.java (at line 4)\n\tint i = VALUE;\n\t        ^^^^^\nVALUE cannot be resolved to a variable\n----------\n");
    }

    public void test074() {
        this.runConformTest(new String[]{"test/Outer.java", "package test;\nimport static test.Outer.Inner.*;\npublic class Outer {\n    int i = VALUE;\n    int i2 = Inner.VALUE;\n    static class Inner {\n        private static final int VALUE = 0;\n    }\n}\n"}, "");
    }

    public void test075() {
        this.runNegativeTest(new String[]{"A/A.java", "package A;\nimport B.B.C1;\nimport static B.B.C1;\npublic abstract class A {\n\tprotected void A1(Object task) {\n\t\tC1 c = C1(task);\n\t}\n}\n", "B/B.java", "package B;\nfinal public class B {\n\tprivate B() {}\n\tpublic static class C1 {}\n\tpublic static C1 C1(Object o) {\n\t\treturn new C1();\n\t}\n}\n"}, "");
    }

    public void test076() {
        this.runConformTest(new String[]{"A/A.java", "package A;\nimport B.B.C1;\nimport static B.B.C1;\npublic class A {\n\tprotected void A1(Object task) {\n\t\tC1 c1;\n\t\tint c = C1(task);\n\t}\n}\n", "B/B.java", "package B;\nfinal public class B {\n\tprivate B() {}\n\tpublic class C1 {}\n\tpublic static int C1(Object o) {\n\t\treturn 1;\n\t}\n}\n"}, "");
    }

    public void test077() {
        this.runConformTest(new String[]{"p1/X.java", "package p1;\nimport p2.A;\nimport static p2.A.C;\nimport static p1.B.C;\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tfoo();\n\t}\n\tpublic static void foo() {\n\t\tif (C.CONST == 1) {\n\t\t\tSystem.out.println(\"SUCCESS\");\n\t\t\treturn;\n\t\t}\n\t\tSystem.out.println(\"FAILED\");\n\t}\n}\nclass B extends A {}", "p2/A.java", "package p2;\npublic class A {\n\tpublic static class C {\n\t\tpublic static int CONST = 1;\n\t}\n}"}, "SUCCESS");
    }

    public void test078() {
        this.runNegativeTest(new String[]{"A/A.java", "package A;\nimport static B.B.C1;\nimport B.B.C1;\npublic abstract class A {\n\tprotected void A1(Object task) {\n\t\tC1 c = C1(task);\n\t}\n}\n", "B/B.java", "package B;\nfinal public class B {\n\tprivate B() {}\n\tpublic static class C1 {}\n\tpublic static C1 C1(Object o) {\n\t\treturn new C1();\n\t}\n}\n"}, "----------\n1. ERROR in A\\A.java (at line 3)\n\timport B.B.C1;\n\t       ^^^^^^\nThe import B.B.C1 collides with another import statement\n----------\n");
    }

    public void test079() {
        this.runNegativeTest(new String[]{"A/A.java", "package A;\nimport static B.B.C1;\nimport B.B.C1;\npublic abstract class A {\n\tprotected void A1(C1 c) {\n\t}\n}\n", "B/B.java", "package B;\nfinal public class B {\n\tpublic static class C1 {}\n}\n"}, "----------\n1. WARNING in A\\A.java (at line 2)\n\timport static B.B.C1;\n\t              ^^^^^^\nThe import B.B.C1 is never used\n----------\n");
    }

    public void test080() {
        this.runNegativeTest(new String[]{"a/B.java", "package a;\npublic class B {}", "external/Lib.java", "package external;\npublic class Lib {\n\tpublic static void m() {}\n}", "a/B/C.java", "package a.B;\nimport static external.Lib.m;\npublic class C {\n\tpublic void main() {\n\t\tm();\n\t}\n}"}, "----------\n1. ERROR in a\\B\\C.java (at line 1)\n\tpackage a.B;\n\t        ^^^\nThe package a.B collides with a type\n----------\n");
    }

    public void test081() {
        this.runConformTest(new String[]{"Test.java", "import static p1.Bar.B;\nimport p3.Foo.*;\npublic class Test {\n\tpublic static void main(String [] args){\n\t\tnew Test().beginTest();\t}\n\tpublic void beginTest(){\n\t\tSystem.out.print(\"1 + 1 =  \");\n\t\tif(alwaysTrue()) System.out.println(\"2\");\n\t\telse System.out.println(\"3\"); \t}\n\tpublic boolean alwaysTrue(){\n\t\tString myB   =        B.class.getCanonicalName();;\n\t\tString realB = p1.Bar.B.class.getCanonicalName();;\n\t\tB();\n\t\treturn myB.equals(realB);\n\t}\n}\n", "p1/Bar.java", "package p1;\npublic class Bar{\n\tpublic static class B{}\n\tfinal public static String B = new String(\"random\");\n\tpublic static void B(){}\n}\n", "p3/Foo.java", "package p3;\npublic class Foo {\n\tpublic class B{\n\t\tpublic int a;\n\t}\n}\n"}, "1 + 1 =  2");
    }

    public void test082() {
        this.runNegativeTest(new String[]{"p1/Bar.java", "package p1;\npublic class Bar{\n\tpublic static class B{}\n\tfinal public static String B = new String(\"random\");\n\tpublic static void B(){}\n}\n", "p3/Foo.java", "package p3;\npublic class Foo {\n\tpublic class B{\n\t\tpublic int a;\n\t}\n}\n", "p2/Test.java", "package p2;\nimport static p1.Bar.B;\nimport p3.Foo.*;\npublic class Test {\n\tpublic static void main(String [] args){\n\t\tnew Test().beginTest();\t}\n\tpublic void beginTest(){\n\t\tSystem.out.print(\"1 + 1 =  \");\n\t\tif(alwaysTrue()) System.out.println(\"2\");\n\t\telse System.out.println(\"3\"); \t}\n\tpublic boolean alwaysTrue(){\n\t\tB b = null;\n\t\tString realB = B;\n\t\tB();\n\t\tint abc = b.a;\n;\t}\n}\n"}, "----------\n1. ERROR in p2\\Test.java (at line 15)\n\tint abc = b.a;\n\t            ^\na cannot be resolved or is not a field\n----------\n");
    }

    public void test083() {
        this.runConformTest(new String[]{"Test.java", "import static p1.Bar.B;\nimport p3.Foo.*;\npublic class Test {\n\tpublic static void main(String [] args){\n\t\tnew Test().test2();\t}\n\tpublic void test2(){\n\t\tSystem.out.println(B.toString());\n\t\tSystem.out.println(p1.Bar.B.toString());\n\t\tSystem.out.println(B.class.getCanonicalName().toString());\n\t\tSystem.out.println(p1.Bar.B.class.getCanonicalName().toString());\t}\n}\n", "p1/Bar.java", "package p1;\npublic class Bar{\n\tpublic static class B{}\n\tfinal public static String B = new String(\"random\");\n\tpublic static void B(){}\n}\n", "p3/Foo.java", "package p3;\npublic class Foo {\n\tpublic class B{\n\t\tpublic int a;\n\t}\n}\n"}, "random\nrandom\np1.Bar.B\np1.Bar.B");
    }

    public void test084() {
        this.runConformTest(new String[]{"Test.java", "import static p1.Bar.B;\nimport p3.Foo.*;\npublic class Test {\n\tpublic static void main(String [] args){\n\t\tnew Test().test2();\t}\n\tpublic void test2(){\n\t\tSystem.out.println(B.class.getCanonicalName().toString());\n\t\tSystem.out.println(p1.Bar.B.class.getCanonicalName().toString());\t}\n}\n", "p1/Bar.java", "package p1;\npublic class Bar extends SuperBar{\n\tpublic static class B{}\n\tpublic static void B(){}\n}\n", "p1/SuperBar.java", "package p1;\npublic class SuperBar {\n\tfinal public static String B = new String(\"random\");\n}\n", "p3/Foo.java", "package p3;\npublic class Foo {\n\tpublic class B{\n\t\tpublic int a;\n\t}\n}\n"}, "p1.Bar.B\np1.Bar.B");
    }

    public void test085() {
        this.runNegativeTest(new String[]{"Test.java", "import static p1.Bar.B;\nimport static p3.Foo.B;\npublic class Test {\n\tpublic static void main(String [] args){\n\t\tnew Test().test2();\t}\n\tpublic void test2(){\n\t\tSystem.out.println(B.class.getCanonicalName().toString());\n\t\tSystem.out.println(p1.Bar.B.class.getCanonicalName().toString());\t}\n}\n", "p1/Bar.java", "package p1;\npublic class Bar{\n\tpublic static class B{}\n\tpublic static String B = new String(\"random\");\n}\n", "p3/Foo.java", "package p3;\npublic class Foo {\n\tpublic static class B{\n\t}\n}\n"}, "----------\n1. ERROR in Test.java (at line 7)\n\tSystem.out.println(B.class.getCanonicalName().toString());\n\t                   ^\nThe type B is ambiguous\n----------\n");
    }

    public void test085a() {
        this.runNegativeTest(new String[]{"Test.java", "import static p1.Bar.B;\nimport static p3.Foo.B;\npublic class Test {\n\tpublic static void main(String [] args){\n\t\tnew Test().test2();\t}\n\tpublic void test2(){\n\t\tSystem.out.println(B.class.getCanonicalName().toString());\n\t\tSystem.out.println(p1.Bar.B.class.getCanonicalName().toString());\t}\n}\n", "p1/Bar.java", "package p1;\npublic class Bar extends SuperBar{\n\tpublic static void B(){}\n}\n", "p1/SuperBar.java", "package p1;\npublic class SuperBar {\n\tpublic static class B{}\n\tfinal public static String B = new String(\"random\");\n}\n", "p3/Foo.java", "package p3;\npublic class Foo {\n\tpublic static class B{\n\t}\n}\n"}, "----------\n1. ERROR in Test.java (at line 2)\n\timport static p3.Foo.B;\n\t              ^^^^^^^^\nThe import p3.Foo.B collides with another import statement\n----------\n");
    }

    public void test085b() {
        this.runNegativeTest(new String[]{"Test.java", "import static p1.Bar.B;\nimport p3.Foo.B;\npublic class Test {\n\tpublic static void main(String [] args){\n\t\tnew Test().test2();\t}\n\tpublic void test2(){\n\t\tSystem.out.println(B.class.getCanonicalName().toString());\n\t\tSystem.out.println(p1.Bar.B.class.getCanonicalName().toString());\t}\n}\n", "p1/Bar.java", "package p1;\npublic class Bar{\n\tpublic static class B{}\n\tpublic static String B = new String(\"random\");\n}\n", "p3/Foo.java", "package p3;\npublic class Foo {\n\tpublic class B{\n\t}\n}\n"}, "----------\n1. ERROR in Test.java (at line 2)\n\timport p3.Foo.B;\n\t       ^^^^^^^^\nThe import p3.Foo.B collides with another import statement\n----------\n");
    }

    public void test085c() {
        this.runNegativeTest(new String[]{"Test.java", "import static p1.Bar.B;\npublic class Test {\n\tpublic static void main(String [] args){\n\t\tnew Test().test2();\t}\n\tpublic void test2(){\n\t\tSystem.out.println(B.class.getCanonicalName().toString());\n\t\tSystem.out.println(p1.Bar.B.class.getCanonicalName().toString());\t}\n}\nclass B{\n}\n", "p1/Bar.java", "package p1;\npublic class Bar{\n\tpublic static class B{}\n\tpublic static String B = new String(\"random\");\n}\n"}, "----------\n1. ERROR in Test.java (at line 1)\n\timport static p1.Bar.B;\n\t              ^^^^^^^^\nThe import p1.Bar.B conflicts with a type defined in the same file\n----------\n");
    }

    public void test086() {
        this.runConformTest(new String[]{"Test.java", "import static p1.Bar.B;\nimport static p3.Foo.*;\npublic class Test {\n\tpublic static void main(String [] args){\n\t\tnew Test().test2();\t}\n\tpublic void test2(){\n       B();\n\t\tSystem.out.println(B.toString());\n\t}\n}\n", "p1/Bar.java", "package p1;\npublic class Bar{\n\tpublic static void B(){ System.out.println(\"Bar's method B\");}\n\tpublic static String B = new String(\"Bar's field B\");\n}\n", "p3/Foo.java", "package p3;\npublic class Foo {\n\tpublic static void B(){ System.out.println(\"Foo's method B\");}\n\tpublic static String B = new String(\"Foo's field B\");\n}\n"}, "Bar's method B\nBar's field B");
    }

    public void testBug401271() {
        this.runNegativeTest(new String[]{"a/b/c/a.java", "package a.b.c;\npublic class a {}\n", "a/b/c/C.java", "package a.b.c;\npublic class C {\n\tpublic static final int a = 3;\n}\n", "x/y/R.java", "package x.y;\nimport static a.b.c.C.a;\n//import a.b.c.a;\n\npublic class R { \n\ta b; \n\tchar h = a; \n}"}, "----------\n1. ERROR in x\\y\\R.java (at line 6)\n\ta b; \n\t^\na cannot be resolved to a type\n----------\n");
    }

    public void test426544() {
        this.runNegativeTest(new String[]{"p/X.java", "package p;\npublic class X {\n    public static int f;\n    public static class C {}\n    public static class I {}\n}\n", "q/X.java", "package q;\npublic class X {\n    public static int f;\n    public static class C {}\n    public static class I {}\n}\n", "X.java", "import static p.X.f;\nimport static q.X.f;\nimport static p.X.C;\nimport static p.X.I;\nimport static q.X.C;\nimport static q.X.I;\npublic class X { \n    { f = 0; }\n    { C c = null; }\n    { I i = null; }\n}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\t{ f = 0; }\n\t  ^\nThe field f is ambiguous\n----------\n2. ERROR in X.java (at line 9)\n\t{ C c = null; }\n\t  ^\nThe type C is ambiguous\n----------\n3. ERROR in X.java (at line 10)\n\t{ I i = null; }\n\t  ^\nThe type I is ambiguous\n----------\n");
    }

    public void testBug479287() {
        this.runConformTest(new String[]{"joetest/GenericsIssue.java", "package joetest;\nimport static joetest.GenericsIssueCollaborator.takesAnything;\nimport java.util.Collection;\nimport java.util.Collections;\npublic class GenericsIssue {\n\tprivate void oddCompileError() {\n\t\ttakesAnything(returnThings(\"works without wildcard in return value\"));\n\t\tGenericsIssueCollaborator.takesAnything(returnThingsWildcard(\"works without static import\"));\n\t\ttakesAnything(returnThingsWildcard(\"doesn't work with static import\"));\n\t}\n\tprivate <T> Collection<T> returnThings(T thing) {\n\t\treturn Collections.singleton(thing);\n\t}\n\t\t\n\tprivate <T> Collection<? extends T> returnThingsWildcard(T toReturn) {\n\t\treturn Collections.singleton(toReturn);\n\t}\n}", "joetest/GenericsIssueCollaborator.java", "package joetest;\npublic class GenericsIssueCollaborator {\n\tpublic static <T> void takesAnything(T thing) {\n\t\tSystem.out.println(\"TOOK IT: \" + thing);\n\t}\n}"});
    }

    public void testBug442580() {
        this.runConformTest(new String[]{"a/A.java", "package a;\n\npublic class A {\n\tpublic static void foo() {\n\t\tSystem.out.println(\"A.foo\");\n\t}\n}", "b/B.java", "package b;\n\npublic class B {\n\tpublic static void foo() {\n\t\tSystem.out.println(\"B.foo\");\n\t}\n}", "Test.java", "import static a.A.*;\nimport static b.B.*;\nimport static b.B.foo;\n\npublic class Test {\n\tpublic static void main(String[] args) {\n\t\tfoo();\n\t}\n}"});
    }

    public void testBug520874a() {
        if (this.complianceLevel <= 0x340000L) {
            return;
        }
        this.runNegativeTest(new String[]{"p/X.java", "package p;\nimport static p.A1.Outer.*;\nimport static p.A1.AnotherOuter.Inner;\npublic class X {}\nclass A1 {\n\tstatic class Outer<T extends Inner> {\n\t\tprivate static interface Inner {}\n    }\n\tstatic class AnotherOuter {\n\t\tprivate static class Inner {}\n\t}\n}\n"}, "----------\n1. ERROR in p\\X.java (at line 3)\n\timport static p.A1.AnotherOuter.Inner;\n\t              ^^^^^^^^^^^^^^^^^^^^^^^\nThe type p.A1.AnotherOuter.Inner is not visible\n----------\n2. ERROR in p\\X.java (at line 6)\n\tstatic class Outer<T extends Inner> {\n\t                             ^^^^^\nThe type Inner is not visible\n----------\n");
    }

    public void testBug520874b() {
        if (this.complianceLevel <= 0x340000L) {
            return;
        }
        this.runNegativeTest(new String[]{"p/X.java", "package p;\nimport p.A1.Outer.*;\npublic class X {}\nclass A1 {\n\tstatic class Outer<T extends Inner> {\n\t\tprivate static interface Inner {}\n    }\n}\n"}, "----------\n1. ERROR in p\\X.java (at line 5)\n\tstatic class Outer<T extends Inner> {\n\t                             ^^^^^\nThe type Inner is not visible\n----------\n");
    }

    public void testBug520874c() {
        if (this.complianceLevel <= 0x340000L) {
            return;
        }
        this.runNegativeTest(new String[]{"p/X.java", "package p;\nimport static p.A1.Outer.Inner;\nimport static p.A1.AnotherOuter.Inner;\npublic class X {}\nclass A1 {\n\tstatic class Outer<T extends Inner> {\n\t\tprivate static interface Inner {}\n    }\n\tstatic class AnotherOuter<T extends Inner> {\n\t\tprivate static class Inner {}\n\t}\n}\n"}, "----------\n1. ERROR in p\\X.java (at line 2)\n\timport static p.A1.Outer.Inner;\n\t              ^^^^^^^^^^^^^^^^\nThe type p.A1.Outer.Inner is not visible\n----------\n2. ERROR in p\\X.java (at line 3)\n\timport static p.A1.AnotherOuter.Inner;\n\t              ^^^^^^^^^^^^^^^^^^^^^^^\nThe type p.A1.AnotherOuter.Inner is not visible\n----------\n3. ERROR in p\\X.java (at line 6)\n\tstatic class Outer<T extends Inner> {\n\t                             ^^^^^\nInner cannot be resolved to a type\n----------\n4. ERROR in p\\X.java (at line 9)\n\tstatic class AnotherOuter<T extends Inner> {\n\t                                    ^^^^^\nInner cannot be resolved to a type\n----------\n");
    }

    public void testBug520874d() {
        if (this.complianceLevel <= 0x340000L) {
            return;
        }
        this.runNegativeTest(new String[]{"p/X.java", "package p;\nimport static p.A.B.Inner;\nimport p.Bar.Inner;\npublic class X {}\nclass A {\n    static class B extends Bar {}\n}\n", "p/Bar.java", "package p;\npublic class Bar {;\n\tpublic static class Inner {}\n}\n"}, "----------\n1. WARNING in p\\X.java (at line 2)\n\timport static p.A.B.Inner;\n\t              ^^^^^^^^^^^\nThe import p.A.B.Inner is never used\n----------\n2. WARNING in p\\X.java (at line 3)\n\timport p.Bar.Inner;\n\t       ^^^^^^^^^^^\nThe import p.Bar.Inner is never used\n----------\n");
    }

    public void testBug520874e() {
        if (this.complianceLevel <= 0x340000L) {
            return;
        }
        this.runNegativeTest(new String[]{"p/X.java", "package p;\nimport static p.A.B.Inner;\nimport p.Bar.*;\npublic class X {}\nclass A {\n    static class B extends Bar {}\n}\n", "p/Bar.java", "package p;\npublic class Bar {;\n\tpublic static class Inner {}\n}\n"}, "----------\n1. WARNING in p\\X.java (at line 2)\n\timport static p.A.B.Inner;\n\t              ^^^^^^^^^^^\nThe import p.A.B.Inner is never used\n----------\n2. WARNING in p\\X.java (at line 3)\n\timport p.Bar.*;\n\t       ^^^^^\nThe import p.Bar is never used\n----------\n");
    }

    public void testGH809_field_a() {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.testFiles = new String[]{"p2/Client.java", "package p2;\nimport static p1.Sub.*;\npublic class Client {\n\tpublic static void main(String... args) {\n\t\tSystem.out.println(ONE);\n\t}\n}\n", "p1/Super.java", "package p1;\nclass Super {\n\tpublic static int ONE = 1;\n}\n", "p1/Sub.java", "package p1;\npublic class Sub extends Super {}\n"};
        runner.expectedOutputString = "1";
        runner.runConformTest();
    }

    public void testGH809_field_b() {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.testFiles = new String[]{"p2/Client.java", "package p2;\nimport static p1.Sub.ONE;\npublic class Client {\n\tpublic static void main(String... args) {\n\t\tSystem.out.println(ONE);\n\t}\n}\n", "p1/Super.java", "package p1;\nclass Super {\n\tpublic static int ONE = 1;\n}\n", "p1/Sub.java", "package p1;\npublic class Sub extends Super {}\n"};
        runner.expectedOutputString = "1";
        runner.runConformTest();
    }

    public void testGH809_field_c() {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.testFiles = new String[]{"p2/Client.java", "package p2;\nimport p1.Sub;\npublic class Client {\n\tpublic static void main(String... args) {\n\t\tSystem.out.println(Sub.ONE);\n\t}\n}\n", "p1/Super.java", "package p1;\nclass Super {\n\tpublic static int ONE = 1;\n}\n", "p1/Sub.java", "package p1;\npublic class Sub extends Super {}\n"};
        runner.expectedOutputString = "1";
        runner.runConformTest();
    }

    public void testGH809_method_a() {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.testFiles = new String[]{"p2/Client.java", "package p2;\nimport static p1.Sub.*;\npublic class Client {\n\tpublic static void main(String... args) {\n\t\tSystem.out.println(ONE());\n\t}\n}\n", "p1/Super.java", "package p1;\nclass Super {\n\tpublic static int ONE() { return 1; }\n}\n", "p1/Sub.java", "package p1;\npublic class Sub extends Super {}\n"};
        runner.expectedOutputString = "1";
        runner.runConformTest();
    }

    public void testGH809_method_b() {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.testFiles = new String[]{"p2/Client.java", "package p2;\nimport static p1.Sub.ONE;\npublic class Client {\n\tpublic static void main(String... args) {\n\t\tSystem.out.println(ONE());\n\t}\n}\n", "p1/Super.java", "package p1;\nclass Super {\n\tpublic static int ONE() { return 1; }\n}\n", "p1/Sub.java", "package p1;\npublic class Sub extends Super {}\n"};
        runner.expectedOutputString = "1";
        runner.runConformTest();
    }

    public void testGH809_method_c() {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.testFiles = new String[]{"p2/Client.java", "package p2;\nimport p1.Sub;\npublic class Client {\n\tpublic static void main(String... args) {\n\t\tSystem.out.println(Sub.ONE());\n\t}\n}\n", "p1/Super.java", "package p1;\nclass Super {\n\tpublic static int ONE() { return 1; }\n}\n", "p1/Sub.java", "package p1;\npublic class Sub extends Super {}\n"};
        runner.expectedOutputString = "1";
        runner.runConformTest();
    }
}

