/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.io.IOException;
import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest9;
import org.eclipse.jdt.core.tests.compiler.regression.DefaultJavaRuntimeEnvironment;
import org.eclipse.jdt.core.tests.compiler.regression.InMemoryNameEnvironment9;
import org.eclipse.jdt.core.tests.util.PreviewTest;
import org.eclipse.jdt.core.util.ClassFormatException;
import org.eclipse.jdt.internal.compiler.batch.FileSystem;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;

@PreviewTest
public class SuperAfterStatementsTest
extends AbstractRegressionTest9 {
    private static final AbstractRegressionTest.JavacTestOptions JAVAC_OPTIONS = new AbstractRegressionTest.JavacTestOptions("--enable-preview -source 24");
    private static final String[] VMARGS = new String[]{"--enable-preview"};
    private String extraLibPath;

    public static Class<?> testClass() {
        return SuperAfterStatementsTest.class;
    }

    public static Test suite() {
        return SuperAfterStatementsTest.buildMinimalComplianceTestSuite(SuperAfterStatementsTest.testClass(), 0x200000);
    }

    public SuperAfterStatementsTest(String testName) {
        super(testName);
    }

    @Override
    protected void setUp() throws Exception {
        this.runJavacOptIn = true;
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        this.runJavacOptIn = false;
    }

    protected Map<String, String> getCompilerOptions(boolean preview) {
        Map<String, String> defaultOptions = super.getCompilerOptions();
        defaultOptions.put("org.eclipse.jdt.core.compiler.compliance", "24");
        defaultOptions.put("org.eclipse.jdt.core.compiler.source", "24");
        defaultOptions.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "24");
        defaultOptions.put("org.eclipse.jdt.core.compiler.problem.enablePreviewFeatures", preview ? "enabled" : "disabled");
        defaultOptions.put("org.eclipse.jdt.core.compiler.problem.reportPreviewFeatures", "warning");
        return defaultOptions;
    }

    @Override
    protected Map<String, String> getCompilerOptions() {
        return this.getCompilerOptions(false);
    }

    @Override
    protected String[] getDefaultClassPaths() {
        String[] libs = DefaultJavaRuntimeEnvironment.getDefaultClassPaths();
        if (this.extraLibPath != null) {
            String[] l = new String[libs.length + 1];
            System.arraycopy(libs, 0, l, 0, libs.length);
            l[libs.length] = this.extraLibPath;
            return l;
        }
        return libs;
    }

    @Override
    protected INameEnvironment getNameEnvironment(String[] testFiles, String[] classPaths, Map<String, String> options) {
        INameEnvironment[] classLibs;
        this.classpaths = classPaths == null ? this.getDefaultClassPaths() : classPaths;
        INameEnvironment[] iNameEnvironmentArray = classLibs = this.getClassLibs(false, options);
        int n = classLibs.length;
        int n2 = 0;
        while (n2 < n) {
            INameEnvironment nameEnvironment = iNameEnvironmentArray[n2];
            ((FileSystem)nameEnvironment).scanForModules(this.createParser());
            ++n2;
        }
        return new InMemoryNameEnvironment9(testFiles, this.moduleMap, classLibs);
    }

    @Override
    protected void runConformTest(String[] testFiles, String expectedOutput) {
        this.runConformTest(testFiles, expectedOutput, this.getCompilerOptions(true), VMARGS, JAVAC_OPTIONS);
    }

    @Override
    protected void runConformTest(String[] testFiles, String expectedOutput, Map<String, String> customOptions) {
        if (!isJRE22Plus) {
            return;
        }
        this.runConformTest(testFiles, expectedOutput, customOptions, VMARGS, JAVAC_OPTIONS);
    }

    @Override
    protected void runNegativeTest(String[] testFiles, String expectedCompilerLog) {
        Map<String, String> customOptions = this.getCompilerOptions(true);
        Runner runner = new Runner();
        runner.testFiles = testFiles;
        runner.expectedCompilerLog = expectedCompilerLog;
        runner.javacTestOptions = JAVAC_OPTIONS;
        runner.customOptions = customOptions;
        runner.expectedJavacOutputString = null;
        runner.runNegativeTest();
    }

    public void test001() {
        this.runNegativeTest(new String[]{"X.java", "class Y {\n\tpublic int v;\n\tY(int v) {\n\t\tthis.v = v;\n\t}\n}\npublic class X extends Y {\n\n    public X(int value) {\n        if (value <= 0)\n            throw new IllegalArgumentException(\"non-positive value\");\n        super(value);\n    }\n    public static void main(String[] args) {\n\t\tSystem.out.println(new X(100).v);\n\t\tZork();\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 12)\n\tsuper(value);\n\t^^^^^^^^^^^^^\nYou are using a preview language feature that may or may not be supported in a future release\n----------\n2. ERROR in X.java (at line 16)\n\tZork();\n\t^^^^\nThe method Zork() is undefined for the type X\n----------\n");
    }

    public void test002() {
        this.runConformTest(new String[]{"X.java", "\tclass Y {\n\t\tpublic int v;\n\t\tY(int v) {\n\t\t\tthis.v = v;\n\t\t}\n\t}\n\t@SuppressWarnings(\"preview\")\n\tpublic class X extends Y {\n\n\t    public X(int value) {\n\t        if (value <= 0)\n\t            throw new IllegalArgumentException(\"non-positive value\");\n\t        super(value);\n\t    }\n\t    public static void main(String[] args) {\n\t\t\tX x = new X(100);\n\t\t\tSystem.out.println(x.v);\n\t\t}\n\t}\n"}, "100");
    }

    public void test003() {
        this.runConformTest(new String[]{"X.java", "\tclass Y {\n\t\tpublic int v;\n\t\tY(int v) {\n\t\t\tthis.v = v;\n\t\t}\n\t}\n\t@SuppressWarnings(\"preview\")\n\tpublic class X extends Y {\n\n\t    public X(int value) {\n\t        if (value <= 0)\n\t            throw new IllegalArgumentException(\"non-positive value\");\n\t        super(value);\n\t    }\n\t    public static void main(String[] args) {\n\t\t\tX x = new X(100);\n\t\t\tSystem.out.println(x.v);\n\t\t}\n\t}\n"}, "100");
    }

    public void test004() {
        this.runConformTest(new String[]{"X.java", "\tclass Y {\n\t\tpublic int[] vArr;\n\t\tY(int[] vArr) {\n\t\t\tthis.vArr = new int[vArr.length];\n\t\t\tfor (int i = 0, l = vArr.length; i < l; ++i) {\n\t\t\t\tthis.vArr[i] = vArr[i];\n\t\t\t}\n\t\t}\n\t}\n\tpublic class X extends Y {\n\n\t\tpublic X(int v) {\n\t        var iVal = Integer.valueOf(v);\n\t        if (iVal == 0)\n\t            throw new IllegalArgumentException(\"0 not allowed\");\n\t        final int[] vArray = switch (iVal) {\n\t            case 1 -> new int[] { 1, 2, 3, 4};\n\t            case 2 -> new int[] { 2,3,4};\n\t            default -> new int[] {100, 200};\n\t        };\n\t        super(vArray);\n\t    }\n\t    public static void main(String[] args) {\n\t\t\tX x = new X(100);\n\t\t\tSystem.out.println(x.vArr[0]);\n\t\t\tX x2 = new X(1);\n\t\t\tSystem.out.println(x2.vArr[0]);\n\t\t}\n\t}\n"}, "100\n1");
    }

    public void test005() {
        this.runConformTest(new String[]{"X.java", "\tclass Y {\n\t\tpublic int[] vArr;\n\t\tprivate F f1;\n\t\tprivate F f2;\n\n\t\tY(F f1, F f2) {\n\t\t\tthis.f1 = f1;\n\t\t\tthis.f2 = f2;\n\t\t}\n\t}\n\tclass F {}\n\tpublic class X extends Y {\n\t\tpublic int i;\n\t\tpublic X(int i) {\n\t        var f = new F();\n\t        super(f, f);\n\t        this.i = i;\n\t    }\n\t    public static void main(String[] args) {\n\t\t\tX x = new X(100);\n\t\t\tSystem.out.println(x.i);\n\t\t\tX x2 = new X(1);\n\t\t\tSystem.out.println(x2.i);\n\t\t}\n\t}\n"}, "100\n1");
    }

    public void test006() {
        this.runNegativeTest(new String[]{"X.java", "\tclass A {\n\t    int i;\n\t    A() {\n\t        this.i++;                   // Error\n\t        this.hashCode();            // Error\n\t        System.out.print(this);     // Error\n\t        super();\n\t    }\n\t}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tthis.i++;                   // Error\n\t^^^^^^\nCannot read field i in an early construction context\n----------\n2. ERROR in X.java (at line 5)\n\tthis.hashCode();            // Error\n\t^^^^\nCannot use 'this' in an early construction context\n----------\n3. ERROR in X.java (at line 6)\n\tSystem.out.print(this);     // Error\n\t                 ^^^^\nCannot use 'this' in an early construction context\n----------\n4. WARNING in X.java (at line 7)\n\tsuper();\n\t^^^^^^^^\nYou are using a preview language feature that may or may not be supported in a future release\n----------\n");
    }

    public void test007() {
        this.runNegativeTest(new String[]{"X.java", "\tclass D {\n\t    int i;\n\t}\n\tclass E extends D {\n\t    E() {\n\t        super.i++;                  // Error\n\t        super();\n\t    }\n\t}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tsuper.i++;                  // Error\n\t^^^^^\nCannot use 'super' in an early construction context (except in a simple field assignment)\n----------\n2. WARNING in X.java (at line 7)\n\tsuper();\n\t^^^^^^^^\nYou are using a preview language feature that may or may not be supported in a future release\n----------\n");
    }

    public void test007b() {
        Runner runner = new Runner();
        runner.testFiles = new String[]{"X.java", "\tclass D {\n\t\tint i;\n\t}\n\tclass X {\n\t\tX() {\n\t\t\tclass E extends D {\n\t\t\t\tE() {\n\t\t\t\t\tsuper.i++;\n\t\t\t\t}\n\t\t\t}\n\t\t\tSystem.out.print(new E().i);\n\t\t\tsuper();\n\t\t}\n\t\tpublic static void main(String... args) {\n\t\t\tnew X();\n\t\t}\n\t}\n"};
        runner.expectedOutputString = "1";
        runner.runConformTest();
    }

    public void test007c() {
        Runner runner = new Runner(false);
        runner.testFiles = new String[]{"X.java", "\tclass X {\n\t\tX() {\n\t\t\tclass E {\n\t\t\t    void m() {\n\t\t\t        System.out.print(X.this);\n\t\t\t    }\n\t\t\t}\n\t\t\tsuper();\n\t\t\tnew E();\n\t\t}\n\t}\n"};
        runner.expectedCompilerLog = "----------\n1. ERROR in X.java (at line 5)\n\tSystem.out.print(X.this);\n\t                 ^^^^^^\nCannot use 'X.this' in an early construction context\n----------\n";
        runner.runNegativeTest();
    }

    public void test007d() {
        Runner runner = new Runner(false);
        runner.testFiles = new String[]{"X.java", "\tclass X {\n\t\tX() {\n\t\t\tclass E {\n\t\t\t\tE() {\n\t\t\t\t\tthis.i = new Inner();\n\t\t\t\t\tthis.i.j++;\n\t\t\t\t}\n\t\t\t\tclass Inner {\n\t\t\t\t\tint j = 3;;\n\t\t\t\t\tvoid m() {\n\t\t\t\t\t\tE.this.i = this;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\tInner i;\n\t\t\t}\n\t\t\tsuper();\n\t\t\tSystem.out.print(new E().i.j);\n\t\t}\n\t\tpublic static void main(String... args) {\n\t\t\tnew X();\n\t\t}\n\t}\n"};
        runner.expectedOutputString = "4";
        runner.runConformTest();
    }

    public void test008() {
        this.runNegativeTest(new String[]{"X.java", "\tclass A {\n\t    int i;\n\t    A() {\n\t        i++;                        // Error\n\t        hashCode();                 // Error\n\t        super();\n\t    }\n\t}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\ti++;                        // Error\n\t^\nCannot read field i in an early construction context\n----------\n2. ERROR in X.java (at line 5)\n\thashCode();                 // Error\n\t^^^^^^^^^^\nCannot invoke method hashCode() in an early construction context\n----------\n3. WARNING in X.java (at line 6)\n\tsuper();\n\t^^^^^^^^\nYou are using a preview language feature that may or may not be supported in a future release\n----------\n");
    }

    public void test008_OK() {
        this.runConformTest(new String[]{"A.java", "\tclass A {\n\t\tA() {\n\t\t\tclass Local {\n\t\t\t\tint i;\n\t\t\t\tint getI() { return i; }\n\t\t\t\tLocal() {\n\t\t\t\t\ti++;\n\t\t\t\t\tSystem.out.print(getI());\n\t\t\t\t}\n\t\t\t}\n\t\t\tnew Local();\n\t\t\tsuper();\n\t\t}\n\t\tpublic static void main(String... args) {\n\t\t\tnew A();\n\t\t}\n\t}\n"}, "1");
    }

    public void test009_NOK() {
        this.runNegativeTest(new String[]{"B.java", "\tclass B {\n\t    class C {\n\t        int c;\n\t        C() {\n\t            C.this.c++;             // Error - same instance\n\t            super();\n\t        }\n\t    }\n\t}\n"}, "----------\n1. ERROR in B.java (at line 5)\n\tC.this.c++;             // Error - same instance\n\t^^^^^^^^\nCannot read field c in an early construction context\n----------\n2. WARNING in B.java (at line 6)\n\tsuper();\n\t^^^^^^^^\nYou are using a preview language feature that may or may not be supported in a future release\n----------\n");
    }

    public void test009_OK() {
        this.runConformTest(new String[]{"B.java", "\tclass B {\n\t    int b;\n\t    class C {\n\t        C() {\n\t            B.this.b++;             // Allowed - enclosing instance\n\t            super();\n\t        }\n\t    }\n\t    public static void main(String... args) {\n\t    \tB b = new B();\n\t    \tC c = b.new C();\n\t    \tSystem.out.print(b.b);\n\t    }\n\t}\n"}, "1");
    }

    public void test010() {
        this.runConformTest(new String[]{"X.java", "\tclass X {\n\t    void hello() {\n\t        System.out.println(\"Hello\");\n\t    }\n\t    class Inner {\n\t        Inner() {\n\t            hello();                // Allowed - enclosing instance method\n\t            super();\n\t        }\n\t    }\n\t    public static void main(String[] args) {\n\t\t\tnew X().new Inner();\n\t\t}\n\t}\n"}, "Hello");
    }

    public void test011() {
        this.runNegativeTest(new String[]{"X.java", "\tclass Outer {\n\t    class Inner {}\n\t    Outer() {\n\t        new Inner(); // Error - 'this' is enclosing instance\n\t        super();\n\t    }\n\t}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tnew Inner(); // Error - 'this' is enclosing instance\n\t^^^^^^^^^^^\nCannot instantiate class Outer.Inner in an early construction context of class Outer\n----------\n2. WARNING in X.java (at line 5)\n\tsuper();\n\t^^^^^^^^\nYou are using a preview language feature that may or may not be supported in a future release\n----------\n");
    }

    public void test011_inherited() {
        this.runNegativeTest(new String[]{"X.java", "\tclass Super {\n\t    class Inner {}\n\t}\n\tclass Outer extends Super {\n\t    Outer() {\n\t        new Inner(); // Error - 'this' is enclosing instance\n\t        super();\n\t    }\n\t}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tnew Inner(); // Error - 'this' is enclosing instance\n\t^^^^^^^^^^^\nCannot instantiate class Super.Inner in an early construction context of class Outer\n----------\n2. WARNING in X.java (at line 7)\n\tsuper();\n\t^^^^^^^^\nYou are using a preview language feature that may or may not be supported in a future release\n----------\n");
    }

    public void test011_nested() {
        this.runConformTest(new String[]{"Outer.java", "\tclass Outer {\n\t\tOuter() {\n\t\t\tclass Local {\n\t\t\t\tclass Inner { }\n\t\t\t\tLocal() {\n\t\t\t\t\tObject o = new Inner(); // No Error - enclosing Local is not in early construction\n\t\t\t\t\tSystem.out.print(o.getClass().getName());\n\t\t\t\t}\n\t\t\t};\n\t\t\tLocal l = new Local();\n\t\t\tLocal.Inner i = l.new Inner();\n\t\t\tsuper();\n\t\t}\n\t\tpublic static void main(String... args) {\n\t\t\tnew Outer();\n\t\t}\n\t}\n"}, "Outer$1Local$Inner");
    }

    public void test012() {
        this.runNegativeTest(new String[]{"X.java", "\tclass X {\n\t    class S {}\n\t    X() {\n\t        var tmp = new S() { };      // Error\n\t        super();\n\t    }\n\t}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tvar tmp = new S() { };      // Error\n\t          ^^^^^^^^^^^\nCannot instantiate class new X.S(){} in an early construction context of class X\n----------\n2. WARNING in X.java (at line 5)\n\tsuper();\n\t^^^^^^^^\nYou are using a preview language feature that may or may not be supported in a future release\n----------\n");
    }

    public void test013() {
        this.runConformTest(new String[]{"X.java", "\tclass X {\n\t    X() {\n\t        S tmp = new S(){};    // OK\n\t        super();\n\t    }\n\t    public static void main(String[] args) {\n\t\t\tSystem.out.println(\"hello\");\n\t\t}\n\t}\n\tclass S {}\n"}, "hello");
    }

    public void test014() {
        this.runConformTest(new String[]{"X.java", "\tclass X {\n\t    static class S {}\n\t    X() {\n\t        S tmp = new S() { };    // OK\n\t        super();\n\t    }\n\t    public static void main(String[] args) {\n\t\t\tSystem.out.println(\"hello\");\n\t\t}\n\t}\n"}, "hello");
    }

    public void test015() {
        this.runConformTest(new String[]{"X.java", "\tclass X {\n\t    static class S {}\n\t    X() {\n\t        var tmp = new S() { };    // OK\n\t        super();\n\t    }\n\t    public static void main(String[] args) {\n\t\t\tSystem.out.println(\"hello\");\n\t\t}\n\t}\n"}, "hello");
    }

    public void test016() {
        this.runConformTest(new String[]{"X.java", "\tclass X {\n\t    class S {}\n\t    class U {\n\t        U() {\n\t            var tmp = new S() { };  // Allowed\n\t            super();\n\t        }\n\t    }\n\t    public static void main(String[] args) {\n\t\t\tSystem.out.println(\"hello\");\n\t\t}\n\t}\n"}, "hello");
    }

    public void test017() {
        this.runConformTest(new String[]{"X.java", "\tclass Y{\n\t\tpublic int i;\n\t\tY(int i){\n\t\t\tthis.i = i;\n\t\t}\n\t}\n\tpublic class X extends Y{\n\t\tpublic X(int i) {\n\t\t\tsuper(i);\n\t        return;\n\t    }\n\t    public static void main(String[] args) {\n\t\t\tX x = new X(100);\n\t\t\tSystem.out.println(x.i);\n\t\t}\n\t}\n"}, "100");
    }

    public void test018() {
        this.runNegativeTest(new String[]{"X.java", "\tclass Y{\n\t\tpublic int i;\n\t\tY(int i){\n\t\t\tthis.i = i;\n\t\t}\n\t}\n\tpublic class X extends Y{\n\t\tpublic X(int i) {\n\t\t\tsuper(i);\n\t        return 0; // Error - return not allowed here\n\t    }\n\t    public static void main(String[] args) {\n\t\t\tX x = new X(100);\n\t\t\tSystem.out.println(x.i);\n\t\t}\n\t}\n"}, "----------\n1. ERROR in X.java (at line 10)\n\treturn 0; // Error - return not allowed here\n\t^^^^^^^^^\nVoid methods cannot return a value\n----------\n");
    }

    public void test019() {
        this.runNegativeTest(new String[]{"X.java", "\tclass Y{\n\t\tpublic int i;\n\t\tY(int i){\n\t\t\tthis.i = i;\n\t\t}\n\t}\n\tpublic class X extends Y{\n\t\tpublic X(int i) {\n\t        return; // Error - return not allowed here\n\t\t\tsuper(i);\n\t    }\n\t    public static void main(String[] args) {\n\t\t\tX x = new X(100);\n\t\t\tSystem.out.println(x.i);\n\t\t}\n\t}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\treturn; // Error - return not allowed here\n\t^^^^^^^\nreturn; statement not allowed in an early construction context\n----------\n2. WARNING in X.java (at line 10)\n\tsuper(i);\n\t^^^^^^^^^\nYou are using a preview language feature that may or may not be supported in a future release\n----------\n");
    }

    public void test020() {
        this.runNegativeTest(new String[]{"X.java", "\tpublic class X {\n\t\tpublic int i;\n\t\tpublic X(int i) {\n\t        return; // Error - return not allowed here\n\t\t\tthis(i, 0);\n\t    }\n\t\tpublic X(int i, int j) {\n\t\t\tthis.i = i + j;\n\t    }\n\t    public static void main(String[] args) {\n\t\t\tX x = new X(100);\n\t\t\tSystem.out.println(x.i);\n\t\t}\n\t}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\treturn; // Error - return not allowed here\n\t^^^^^^^\nreturn; statement not allowed in an early construction context\n----------\n2. WARNING in X.java (at line 5)\n\tthis(i, 0);\n\t^^^^^^^^^^^\nYou are using a preview language feature that may or may not be supported in a future release\n----------\n");
    }

    public void test021() {
        this.runConformTest(new String[]{"X.java", "\tclass Y{\n\t\tpublic int i;\n\t\tY(int i){\n\t\t\tthis.i = i;\n\t\t}\n\t}\n\tpublic class X extends Y{\n\t\tpublic X(int i) {\n\t\t\tif (i < 0)\n\t\t\t\tthrow new IllegalArgumentException();\n\t\t\tsuper(i);\n\t    }\n\t    public static void main(String[] args) {\n\t\t\tX x = new X(100);\n\t\t\tSystem.out.println(x.i);\n\t\t}\n\t}\n"}, "100");
    }

    public void test022() {
        this.runConformTest(new String[]{"X.java", "\tclass Y{\n\t\tpublic int i;\n\t\tY(int i){\n\t\t\tthis.i = i;\n\t\t}\n\t}\n\tpublic class X extends Y{\n\t\tpublic X(int i) {\n\t\t\tif (i < 0)\n\t\t\t\tthrow new IllegalArgumentException();\n\t\t\tsuper(i);\n\t    }\n\t    public static void main(String[] args) {\n\t    \ttry {\n\t    \t\tX x = new X(-1);\n\t    \t} catch (IllegalArgumentException e) {\n\t    \t\tSystem.out.println(\"hello\");\n\t    \t}\n\t\t}\n\t}\n"}, "hello");
    }

    public void test023() {
        this.runConformTest(new String[]{"X.java", "\tclass B {\n\t\tB(Object o) {}\n\t }\n\tclass X<T> extends B {\n\t    X(Z<?> z) {\n\t        super((T)z.get(0));      // Allowed - refers to 'T' but not 'this'\n\t    }\n\t    public static void main(String[] args) {\n\t\t\tSystem.out.println(\"hello\");\n\t\t}\n\t}\n\tclass Z<T> {\n\t\tT get(int i) {\n\t\t\treturn null;\n\t\t}\n\t}\n"}, "hello");
    }

    public void test024() {
        this.runNegativeTest(new String[]{"X.java", "\tclass A{\n\t    public int i;\n\t    A(int i) {\n\t        this.i = i;\n\t    }\n\t}\n\n\tpublic class X{\n\t    A a = new A(0);\n\t    public boolean b;\n\t    X(int i) {\n\t    \tint j = a.i;\n\t    \tthis.b = j == 0;\n\t        super();\n\t    }\n\t    public static void main(String[] argv) {\n\t    \tSystem.out.println(new X(0).b);\n\t    }\n\t}\n"}, "----------\n1. ERROR in X.java (at line 12)\n\tint j = a.i;\n\t        ^\nCannot read field a in an early construction context\n----------\n2. WARNING in X.java (at line 13)\n\tthis.b = j == 0;\n\t^^^^^^\nYou are using a preview language feature that may or may not be supported in a future release\n----------\n3. WARNING in X.java (at line 14)\n\tsuper();\n\t^^^^^^^^\nYou are using a preview language feature that may or may not be supported in a future release\n----------\n");
    }

    public void test025() {
        this.runNegativeTest(new String[]{"X.java", "\tclass B {\n\t\tB(Object o) {}\n\t }\n\tpublic class X<T> extends B {\n    \tX() {\n       \t\tsuper(this); // Error - refers to 'this'\n  \t\t\t}\n\t}\n\tclass Z<T> {\n\t\tT get(int i) {\n\t\t\treturn null;\n\t\t}\n\t}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tsuper(this); // Error - refers to 'this'\n\t      ^^^^\nCannot use 'this' in an early construction context\n----------\n");
    }

    public void test026() {
        this.runNegativeTest(new String[]{"X.java", "\tclass Y {}\n\tinterface I {\n\t  String tos();\n\t }\n\tpublic class X {\n\t\tint i;\n\t\tpublic X(int i) {\n\t\t\tI tos = super::toString;\n\t\t\tthis(i, 0);\n\t    }\n\t\tpublic X(int i, int j) {\n\t\t\tthis.i = i + j;\n\t    }\n\t    public static void main(String[] args) {\n\t\t\tX x = new X(100);\n\t\t\tSystem.out.println(x.i);\n\t\t}\n\t}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\tI tos = super::toString;\n\t        ^^^^^\nCannot use 'super' in an early construction context\n----------\n2. WARNING in X.java (at line 9)\n\tthis(i, 0);\n\t^^^^^^^^^^^\nYou are using a preview language feature that may or may not be supported in a future release\n----------\n");
    }

    public void test027() {
        this.runNegativeTest(new String[]{"X.java", "\tclass A{\n\t    public int i;\n\t    A(int i) {\n\t        this.i = i;\n\t    }\n\t\tpublic int getI() { return this.i; }\n\t}\n\n\tpublic class X{\n\t    A a = new A(0);\n\t    public boolean b;\n\t    X(int i) {\n\t    \tint j = a.getI();\n\t    \tthis.b = j == 0;\n\t        super();\n\t    }\n\t    public static void main(String[] argv) {\n\t    \tSystem.out.println(new X(0).b);\n\t    }\n\t}\n"}, "----------\n1. ERROR in X.java (at line 13)\n\tint j = a.getI();\n\t        ^\nCannot read field a in an early construction context\n----------\n2. WARNING in X.java (at line 14)\n\tthis.b = j == 0;\n\t^^^^^^\nYou are using a preview language feature that may or may not be supported in a future release\n----------\n3. WARNING in X.java (at line 15)\n\tsuper();\n\t^^^^^^^^\nYou are using a preview language feature that may or may not be supported in a future release\n----------\n");
    }

    public void test028() {
        this.runNegativeTest(new String[]{"X.java", "\tinterface I {\n\t    default int getI() { return 0; }\n\t}\n\tinterface J extends I {}\n\tpublic class X implements J {\n\t\tint i;\n\t    X() {\n\t        int j = J.super.getI();\n\t        super();\n\t    }\n\t    X(int i) {\n\t    \tthis.i = i;\n\t    }\n\t    public static void main(String argv[]) {\n\t    \tSystem.out.println(new X(0).getI() == 0);\n\t    }\n\t}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\tint j = J.super.getI();\n\t        ^^^^^^^\nCannot use 'J.super' in an early construction context\n----------\n2. WARNING in X.java (at line 9)\n\tsuper();\n\t^^^^^^^^\nYou are using a preview language feature that may or may not be supported in a future release\n----------\n");
    }

    public void test029() {
        this.runNegativeTest(new String[]{"X.java", "\tinterface I {\n\t    default int getI() { return 0; }\n\t}\n\tinterface J extends I {}\n\tpublic class X implements J {\n\t\tint i;\n\t    X() {\n\t        int j = J.super.getI();\n\t        this(j);\n\t    }\n\t    X(int i) {\n\t    \tthis.i = i;\n\t    }\n\t    public static void main(String argv[]) {\n\t    \tSystem.out.println(new X(0).getI() == 0);\n\t    }\n\t}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\tint j = J.super.getI();\n\t        ^^^^^^^\nCannot use 'J.super' in an early construction context\n----------\n2. WARNING in X.java (at line 9)\n\tthis(j);\n\t^^^^^^^^\nYou are using a preview language feature that may or may not be supported in a future release\n----------\n");
    }

    public void test030() {
        this.runConformTest(new String[]{"X.java", "\tpublic class X {\n\t    int v = 0;\n\t    public boolean foo() {\n\t        class Inner {\n\t            int getV() {\n\t                return v;\n\t            }\n\t        }\n\t        return new Inner(){}.getV() == v;\n\t    }\n\t    public static void main(String args[]) {\n\t    \tSystem.out.println(new X().foo());\n\t    }\n\t}\n"}, "true");
    }

    public void test032() {
        this.runConformTest(new String[]{"X.java", "\tabstract class Y {\n\t\tpublic abstract int getI();\n\t}\n\tpublic class X {\n\t\tpublic int i;\n\t    X() {\n\t         new Y() {\n\t            public int getI() {\n\t                return 0;\n\t            }\n\t        }.getI();\n\t        super();\n\t    }\n\t   public static void main(String argv[]) {\n\t\t   System.out.println(new X().i);\n\t    }\n\t}\n"}, "0");
    }

    public void test033() {
        this.runNegativeTest(new String[]{"X.java", "\tclass Y {\n\t\tpublic Y() {}\n\t\tpublic Y(int i){}\n\t}\n\tclass X extends Y {\n\t\tpublic boolean b;;\n\t\tpublic X(int i){}\n\t    \tpublic X (boolean b) {\n\t          super();\n\t          this(0);\n\t          this.b = b;\n\t    }\n\t    public static void main(String argv[]) {\n\t        System.out.println(new X(true).b);\n\t    }\n\t}\n"}, "----------\n1. ERROR in X.java (at line 10)\n\tthis(0);\n\t^^^^^^^^\nConstructor cannot have more than one explicit constructor call\n----------\n");
    }

    public void test034() {
        this.runNegativeTest(new String[]{"X.java", "\tclass Y {\n\t\tpublic Y(int i){}\n\t}\n\tclass X extends Y {\n\t\tpublic boolean b;;\n\t\tpublic X(int i){}\n\t    \tpublic X (boolean b) {\n\t          super();\n\t          this(0);\n\t          this.b = b;\n\t    }\n\t    public static void main(String argv[]) {\n\t        System.out.println(new X(true).b);\n\t    }\n\t}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tpublic X(int i){}\n\t       ^^^^^^^^\nImplicit super constructor Y() is undefined. Must explicitly invoke another constructor\n----------\n2. ERROR in X.java (at line 8)\n\tsuper();\n\t^^^^^^^^\nThe constructor Y() is undefined\n----------\n3. ERROR in X.java (at line 9)\n\tthis(0);\n\t^^^^^^^^\nConstructor cannot have more than one explicit constructor call\n----------\n");
    }

    public void test035() {
        this.runNegativeTest(new String[]{"X.java", "\tclass Y {\n\t\tpublic Y(int i){}\n\t}\n\tclass X extends Y {\n\t\tpublic boolean b;;\n\t\tpublic X(int i){ super(i);}\n\t    \tpublic X (boolean b) {\n\t          super();\n\t          this(0);\n\t          this.b = b;\n\t    }\n\t    public static void main(String argv[]) {\n\t        System.out.println(new X(true).b);\n\t    }\n\t}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\tsuper();\n\t^^^^^^^^\nThe constructor Y() is undefined\n----------\n2. ERROR in X.java (at line 9)\n\tthis(0);\n\t^^^^^^^^\nConstructor cannot have more than one explicit constructor call\n----------\n");
    }

    public void test036() {
        this.runNegativeTest(new String[]{"X.java", "\tclass Y { }\n\tclass X extends Y {\n\t        public boolean b;;\n\t        public X(){}\n\t        public X (boolean b) {\n\t          super();\n\t          this();\n\t          this.b = b;\n\t    }\n\t    public static void main(String argv[]) {\n\t        System.out.println(new X(true).b);\n\t    }\n\t}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tthis();\n\t^^^^^^^\nConstructor cannot have more than one explicit constructor call\n----------\n");
    }

    public void test037() {
        this.runConformTest(new String[]{"X.java", "interface I {\n    void foo();\n}\npublic class X {\n    public static boolean b;\n    static class Y { boolean b = true;}\n    X() {}\n    X(boolean b) {\n        I l = () -> {\n            X.b = new Y() {\n                public boolean b() {\n                    return this.b;\n                }\n            }.b();\n        };\n        l.foo();\n        super();\n    }\n\n    public static void main(String argv[]) {\n    \tnew X(true);\n        System.out.println(X.b);\n    }\n}\n"}, "true");
    }

    public void test038() {
        this.runConformTest(new String[]{"X.java", "\tinterface I {\n\t\tvoid foo();\n\t}\n\n\tpublic class X {\n\t\tpublic static boolean b;\n\n\t\tstatic class Y {\n\t\t\tboolean b = true;\n\t\t}\n\t\tX() {}\n\t\tX(boolean b) {\n\t\t\tI l = () -> {\n\t\t\t\tX.b = new Y() {\n\t\t\t\t\tpublic boolean b() {\n\t\t\t\t\t\treturn this.b;\n\t\t\t\t\t}\n\t\t\t\t}.b();\n\t\t\t\tSystem.out.println(switch (42) {\n\t\t\t\tdefault -> {\n\t\t\t\t\ttry {\n\t\t\t\t\t\tyield 42;\n\t\t\t\t\t} finally {\n\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\t});\n\t\t\t};\n\t\t\tl.foo();\n\t\t\tsuper();\n\t\t}\n\n\t\tpublic static void main(String argv[]) {\n\t\t\tnew X(true);\n\t\t\tSystem.out.println(X.b);\n\t\t}\n\t}\n"}, "42\ntrue");
    }

    public void test039() {
        this.runConformTest(new String[]{"X.java", "\tinterface I {\n\t\tvoid foo();\n\t}\n\n\tpublic class X {\n\t\tpublic static boolean b;\n\n\t\tstatic class Y {\n\t\t\tboolean b = true;\n\t\t}\n\t\tX() {}\n\t\tX(boolean b) {\n\t\t\tI l = () -> {\n\t\t\t\tX.b = new Y() {\n\t\t\t\t\tpublic boolean b() {\n\t\t\t\t\t\treturn this.b;\n\t\t\t\t\t}\n\t\t\t\t}.b();\n\t\t\t\tSystem.out.println(switch (42) {\n\t\t\t\tdefault -> {\n\t\t\t\t\ttry {\n\t\t\t\t\t\tyield 42;\n\t\t\t\t\t} finally {\n\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\t});\n\t\t\t};\n\t\t\tl.foo();\n\t\t\tsuper();\n\t\t}\n\n\t\tpublic static void main(String argv[]) {\n\t\t\tnew X(true);\n\t\t\tSystem.out.println(X.b);\n\t\t}\n\t}\n"}, "42\ntrue");
    }

    public void test040() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.enablePreviewFeatures", "disabled");
        this.runNegativeTest(new String[]{"X.java", "\tclass Y {\n\t\tpublic int v;\n\t\tY(int v) {\n\t\t\tthis.v = v;\n\t\t}\n\t}\n\t@SuppressWarnings(\"preview\")\n\tpublic class X extends Y {\n\t    public X(int value) {\n\t        if (value <= 0)\n\t            throw new IllegalArgumentException(\"non-positive value\");\n\t        super(value);\n\t    }\n\t}\n"}, "----------\n1. ERROR in X.java (at line 12)\n\tsuper(value);\n\t^^^^^^^^^^^^^\nFlexible Constructor Bodies is a preview feature and disabled by default. Use --enable-preview to enable\n----------\n", null, true, options);
    }

    public void testGH2467() {
        Runner runner = new Runner(false);
        runner.testFiles = new String[]{"Test3.java", "class Super {}\npublic class Test3 extends Super {\n\tTest3(Test3 other) {\n\t\tother.foo(); // bogus error:\n\t\tfoo(); // error is correct\n\t\tsuper();\n\t}\n\tvoid foo() {}\n}\n"};
        runner.expectedCompilerLog = "----------\n1. ERROR in Test3.java (at line 5)\n\tfoo(); // error is correct\n\t^^^^^\nCannot invoke method foo() in an early construction context\n----------\n";
        runner.runNegativeTest();
    }

    public void testOuterConstruction_1() {
        Runner runner = new Runner(false);
        runner.testFiles = new String[]{"Test.java", "public class Test {\n\tTest() {\n\t\tclass Local {\n\t\t\tLocal() {\n\t\t\t\tfoo(this);\n\t\t\t}\n\t\t};\n\t\tsuper();\n\t\tnew Local();\n\t}\n\tvoid foo(Object r) { System.out.print(r.getClass().getName()); }\n\tpublic static void main(String... args) {\n\t\tnew Test();\n\t}\n}\n"};
        runner.expectedCompilerLog = "----------\n1. ERROR in Test.java (at line 5)\n\tfoo(this);\n\t^^^^^^^^^\nCannot invoke method foo() in an early construction context\n----------\n";
        runner.runNegativeTest();
    }

    public void testOuterConstruction_2() {
        Runner runner = new Runner(false);
        runner.testFiles = new String[]{"Test.java", "public class Test {\n\tstatic class Inner {\n\t\tInner() {\n\t\t\tfoo(this);\n\t\t}\n\t};\n\tTest() {\n\t\tnew Inner();\n\t\tsuper();\n\t}\n\tstatic void foo(Object r) { System.out.print(r.getClass().getName()); }\n\tpublic static void main(String... args) {\n\t\tnew Test();\n\t}\n}\n"};
        runner.expectedOutputString = "Test$Inner";
        runner.runConformTest();
    }

    public void testFieldAssignedInSuperArgument_OK() {
        Runner runner = new Runner(false);
        runner.testFiles = new String[]{"Test.java", "class Super {\n\tSuper (int i) {}\n}\npublic class Test extends Super {\n\tint i;\n\tTest(int n) {\n\t\tsuper(i=n);\t\t\t\t// old syntax, single name reference\n\t}\n\tTest(int n, boolean f) {\n\t\tsuper(this.i=n);\t\t// old syntax, this-qualified field reference\n\t}\n\tTest(int n, int m) {\n\t\tint s = n+m;\n\t\tsuper(i=s);\t\t\t\t// new syntax, single name reference\n\t}\n\tTest(int n, int m, boolean f) {\n\t\tint s = n+m;\n\t\tsuper(this.i=s);\t\t// new syntax, this-qualified field reference\n\t}\n\tpublic static void main(String... args) {\n\t\tSystem.out.print(new Test(3).i);\n\t\tSystem.out.print(new Test(4, true).i);\n\t\tSystem.out.print(new Test(2,3).i);\n\t\tSystem.out.print(new Test(3,3, true).i);\n\t}\n}\n"};
        runner.expectedOutputString = "3456";
        runner.runConformTest();
    }

    public void testFieldAssignedInSuperArgument_NOK_superclass() {
        Runner runner = new Runner(false);
        runner.testFiles = new String[]{"Test.java", "class Super {\n\tint i;\n\tSuper (int i) {}\n}\npublic class Test extends Super {\n\tTest(int n) {\n\t\tsuper(i=n);\t\t\t\t// old syntax, single name reference\n\t}\n\tTest(int n, boolean f) {\n\t\tsuper(this.i=n);\t\t// old syntax, this-qualified field reference\n\t}\n\tTest(int n, int m) {\n\t\tint s = n+m;\n\t\tsuper(i=s);\t\t\t\t// new syntax, single name reference\n\t}\n\tTest(int n, int m, boolean f) {\n\t\tint s = n+m;\n\t\tsuper(this.i=s);\t\t// new syntax, this-qualified field reference\n\t}\n\tpublic static void main(String... args) {\n\t\tSystem.out.print(new Test(3).i);\n\t\tSystem.out.print(new Test(4, true).i);\n\t\tSystem.out.print(new Test(2,3).i);\n\t\tSystem.out.print(new Test(3,3, true).i);\n\t}\n}\n"};
        runner.expectedCompilerLog = "----------\n1. ERROR in Test.java (at line 7)\n\tsuper(i=n);\t\t\t\t// old syntax, single name reference\n\t      ^\nCannot assign field 'i' from class 'Super' in an early construction context\n----------\n2. ERROR in Test.java (at line 10)\n\tsuper(this.i=n);\t\t// old syntax, this-qualified field reference\n\t      ^^^^^^\nCannot assign field 'i' from class 'Super' in an early construction context\n----------\n3. ERROR in Test.java (at line 14)\n\tsuper(i=s);\t\t\t\t// new syntax, single name reference\n\t      ^\nCannot assign field 'i' from class 'Super' in an early construction context\n----------\n4. ERROR in Test.java (at line 18)\n\tsuper(this.i=s);\t\t// new syntax, this-qualified field reference\n\t      ^^^^^^\nCannot assign field 'i' from class 'Super' in an early construction context\n----------\n";
        runner.runNegativeTest();
    }

    public void testFieldAssignedInSuperArgument_NOK_hasInitializer() {
        Runner runner = new Runner(false);
        runner.testFiles = new String[]{"Test.java", "class Super {\n\tSuper (int i) {}\n}\npublic class Test extends Super {\n\tint i = 3;\n\tTest(int n) {\n\t\tsuper(i=n);\t\t\t\t// old syntax, single name reference\n\t}\n\tTest(int n, boolean f) {\n\t\tsuper(this.i=n);\t\t// old syntax, this-qualified field reference\n\t}\n\tTest(int n, int m) {\n\t\tint s = n+m;\n\t\tsuper(i=s);\t\t\t\t// new syntax, single name reference\n\t}\n\tTest(int n, int m, boolean f) {\n\t\tint s = n+m;\n\t\tsuper(this.i=s);\t\t// new syntax, this-qualified field reference\n\t}\n\tpublic static void main(String... args) {\n\t\tSystem.out.print(new Test(3).i);\n\t\tSystem.out.print(new Test(4, true).i);\n\t\tSystem.out.print(new Test(2,3).i);\n\t\tSystem.out.print(new Test(3,3, true).i);\n\t}\n}\n"};
        runner.expectedCompilerLog = "----------\n1. ERROR in Test.java (at line 7)\n\tsuper(i=n);\t\t\t\t// old syntax, single name reference\n\t      ^\nCannot assign field 'i' in an early construction context, because it has an initializer\n----------\n2. ERROR in Test.java (at line 10)\n\tsuper(this.i=n);\t\t// old syntax, this-qualified field reference\n\t      ^^^^^^\nCannot assign field 'i' in an early construction context, because it has an initializer\n----------\n3. ERROR in Test.java (at line 14)\n\tsuper(i=s);\t\t\t\t// new syntax, single name reference\n\t      ^\nCannot assign field 'i' in an early construction context, because it has an initializer\n----------\n4. ERROR in Test.java (at line 18)\n\tsuper(this.i=s);\t\t// new syntax, this-qualified field reference\n\t      ^^^^^^\nCannot assign field 'i' in an early construction context, because it has an initializer\n----------\n";
        runner.runNegativeTest();
    }

    public void testFieldAssignedInSuperArgument_notEnabled() {
        Runner runner = new Runner();
        runner.customOptions = this.getCompilerOptions();
        runner.customOptions.put("org.eclipse.jdt.core.compiler.problem.reportPreviewFeatures", "ignore");
        runner.javacTestOptions = AbstractRegressionTest.JavacTestOptions.DEFAULT;
        runner.testFiles = new String[]{"Test.java", "class Super {\n\tSuper (int i) {}\n}\npublic class Test extends Super {\n\tint i;\n\tTest(int n) {\n\t\tsuper(i=n);\t\t\t\t// old syntax, single name reference\n\t}\n\tTest(int n, boolean f) {\n\t\tsuper(this.i=n);\t\t// old syntax, this-qualified field reference\n\t}\n\tTest(int n, int m) {\n\t\tint s = n+m;\n\t\tsuper(i=s);\t\t\t\t// new syntax, single name reference\n\t}\n\tTest(int n, int m, boolean f) {\n\t\tint s = n+m;\n\t\tsuper(this.i=s);\t\t// new syntax, this-qualified field reference\n\t}\n}\n"};
        runner.expectedCompilerLog = "----------\n1. ERROR in Test.java (at line 7)\n\tsuper(i=n);\t\t\t\t// old syntax, single name reference\n\t      ^\nFlexible Constructor Bodies is a preview feature and disabled by default. Use --enable-preview to enable\n----------\n2. ERROR in Test.java (at line 10)\n\tsuper(this.i=n);\t\t// old syntax, this-qualified field reference\n\t      ^^^^^^\nFlexible Constructor Bodies is a preview feature and disabled by default. Use --enable-preview to enable\n----------\n3. ERROR in Test.java (at line 14)\n\tsuper(i=s);\t\t\t\t// new syntax, single name reference\n\t^^^^^^^^^^^\nFlexible Constructor Bodies is a preview feature and disabled by default. Use --enable-preview to enable\n----------\n4. ERROR in Test.java (at line 14)\n\tsuper(i=s);\t\t\t\t// new syntax, single name reference\n\t      ^\nFlexible Constructor Bodies is a preview feature and disabled by default. Use --enable-preview to enable\n----------\n5. ERROR in Test.java (at line 18)\n\tsuper(this.i=s);\t\t// new syntax, this-qualified field reference\n\t^^^^^^^^^^^^^^^^\nFlexible Constructor Bodies is a preview feature and disabled by default. Use --enable-preview to enable\n----------\n6. ERROR in Test.java (at line 18)\n\tsuper(this.i=s);\t\t// new syntax, this-qualified field reference\n\t      ^^^^^^\nFlexible Constructor Bodies is a preview feature and disabled by default. Use --enable-preview to enable\n----------\n";
        runner.runNegativeTest();
    }

    public void testFieldCompoundAssignedInSuperArgument() {
        Runner runner = new Runner(false);
        runner.testFiles = new String[]{"Test.java", "class Super {\n\tSuper (int i) {}\n}\npublic class Test extends Super {\n\tint i;\n\tTest(int n) {\n\t\tsuper(i+=n);\t\t\t// old syntax, single name reference\n\t}\n\tTest(int n, boolean f) {\n\t\tsuper(this.i-=n);\t\t// old syntax, this-qualified field reference\n\t}\n\tTest(int n, int m) {\n\t\tint s = n+m;\n\t\tsuper(i*=s);\t\t\t// new syntax, single name reference\n\t}\n\tTest(int n, int m, boolean f) {\n\t\tint s = n+m;\n\t\tsuper(this.i/=s);\t\t// new syntax, this-qualified field reference\n\t}\n}\n"};
        runner.expectedCompilerLog = "----------\n1. ERROR in Test.java (at line 7)\n\tsuper(i+=n);\t\t\t// old syntax, single name reference\n\t      ^\nCannot read field i in an early construction context\n----------\n2. ERROR in Test.java (at line 10)\n\tsuper(this.i-=n);\t\t// old syntax, this-qualified field reference\n\t      ^^^^^^\nCannot read field i in an early construction context\n----------\n3. ERROR in Test.java (at line 14)\n\tsuper(i*=s);\t\t\t// new syntax, single name reference\n\t      ^\nCannot read field i in an early construction context\n----------\n4. ERROR in Test.java (at line 18)\n\tsuper(this.i/=s);\t\t// new syntax, this-qualified field reference\n\t      ^^^^^^\nCannot read field i in an early construction context\n----------\n";
        runner.runNegativeTest();
    }

    public void testFieldReadInSuperArgument() {
        Runner runner = new Runner(false);
        runner.testFiles = new String[]{"Test.java", "class Super {\n\tSuper (int i) {}\n}\npublic class Test extends Super {\n\tint i;\n\tTest() {\n\t\tsuper(i);\n\t}\n\tTest(boolean f) {\n\t\tSystem.out.print(f);\n\t\tsuper(i);\n\t}\n\tTest(String s) {\n\t\tsuper(this.i);\n\t}\n\tTest(String s, boolean f) {\n\t\tSystem.out.print(f);\n\t\tsuper(this.i);\n\t}\n}\n"};
        runner.expectedCompilerLog = "----------\n1. ERROR in Test.java (at line 7)\n\tsuper(i);\n\t      ^\nCannot read field i in an early construction context\n----------\n2. ERROR in Test.java (at line 11)\n\tsuper(i);\n\t      ^\nCannot read field i in an early construction context\n----------\n3. ERROR in Test.java (at line 14)\n\tsuper(this.i);\n\t      ^^^^^^\nCannot read field i in an early construction context\n----------\n4. ERROR in Test.java (at line 18)\n\tsuper(this.i);\n\t      ^^^^^^\nCannot read field i in an early construction context\n----------\n";
        runner.runNegativeTest();
    }

    public void testBug564263() {
        Runner runner = new Runner();
        runner.testFiles = new String[]{"Test.java", "import java.util.function.Supplier;\n\npublic class Test {\n\tprivate String message;\n\n\tpublic class LambaError {\n\t\tpublic LambaError(Supplier<String> message) {\n\t\t\tSystem.out.print(message.get());\n\t\t}\n\t}\n\n\tpublic class Broken extends LambaError {\n\t\tpublic Broken(String message) {\n\t\t\tsuper(() -> Test.this.message);\n\t\t}\n\t}\n\tvoid test() {\n\t\tthis.message = \"OK\";\n\t\tnew Broken(\"NOK\");\n\t}\n\tpublic static void main(String... args) {\n\t\tnew Test().test();\n\t}\n}\n"};
        runner.expectedOutputString = "OK";
        runner.runConformTest();
    }

    public void testComplexNesting_OK() {
        Runner runner = new Runner();
        runner.testFiles = new String[]{"C1.java", "class C1 {\n\tString f1 = \"f1\";\n    C1() {\n        super();\n        class C2 { // not early for C1\n            C2() {\n                class C3 { // early for C2\n                \tString f3 = \"f3\";\n                    C3() {\n                        super();\n                        class C4 { // not early for C3\n                        \tC4() {\n                            \tSystem.out.print(f3);\n                            \tSystem.out.print(f1);\n                           \t}\n                        }\n                        new C4();\n                    }\n                }\n                super();\n                new C3();\n            }\n        }\n        new C2();\n    }\n       public static void main(String... args) {\n       \tnew C1();\n       }\n}\n"};
        runner.vmArguments = VMARGS;
        runner.javacTestOptions = JAVAC_OPTIONS;
        runner.expectedOutputString = "f3f1";
        runner.runConformTest();
    }

    public void testComplexNesting_NOK() {
        Runner runner = new Runner();
        runner.testFiles = new String[]{"C1.java", "class C1 {\n    C1() {\n        super();\n        class C2 { // not early for C1\n        \tString f2 = \"f2\";\n            C2() {\n                class C3 { // early for C2\n                    C3() {\n                        super();\n                        class C4 { // not early for C3\n                        \tC4() {\n                        \t\tSystem.out.print(f2);\n                           \t}\n                        }\n                        new C4();\n                    }\n                }\n                super();\n                new C3();\n            }\n        }\n        new C2();\n    }\n}\n"};
        runner.expectedCompilerLog = "----------\n1. ERROR in C1.java (at line 12)\n\tSystem.out.print(f2);\n\t                 ^^\nCannot read field f2 in an early construction context\n----------\n2. WARNING in C1.java (at line 18)\n\tsuper();\n\t^^^^^^^^\nYou are using a preview language feature that may or may not be supported in a future release\n----------\n";
        runner.runNegativeTest();
    }

    public void testDuplicateCalls() {
        Runner runner = new Runner(false);
        runner.testFiles = new String[]{"X.java", "\tclass X {\n\t\tX() {\n\t\t\tSystem.out.println();\n\t\t\tsuper();\n\t\t\tsuper(); // illegal\n\t\t}\n\t}\n"};
        runner.expectedCompilerLog = "----------\n1. ERROR in X.java (at line 5)\n\tsuper(); // illegal\n\t^^^^^^^^\nConstructor cannot have more than one explicit constructor call\n----------\n";
        runner.runNegativeTest();
    }

    public void testGH2464() {
        Runner runner = new Runner(false);
        runner.testFiles = new String[]{"Test.java", "public class Test {\n\tString name = \"Test\";\n\tTest() {\n\t\tRunnable r = new Runnable() {\n\t\t\t@Override\n\t\t\tpublic void run() {\n\t\t\t\tSystem.out.println(Test.this);\n\t\t\t\tSystem.out.println(name);\n\t\t\t}\n\t\t};\n\t\tr.run();\n\t\tsuper();\n\t}\n\tpublic static void main(String[] args) {\n\t\tnew Test();\n\t}\n}\n"};
        runner.expectedCompilerLog = "----------\n1. ERROR in Test.java (at line 7)\n\tSystem.out.println(Test.this);\n\t                   ^^^^^^^^^\nCannot use 'Test.this' in an early construction context\n----------\n2. ERROR in Test.java (at line 8)\n\tSystem.out.println(name);\n\t                   ^^^^\nCannot read field name in an early construction context\n----------\n";
        runner.runNegativeTest();
    }

    public void testGH2468() {
        Runner runner = new Runner(false);
        runner.testFiles = new String[]{"TestFlow.java", "public class TestFlow {\n\tTestFlow() {}\n\tTestFlow(boolean f) {\n\t\tif (f)\n\t\t\tsuper();\n\t\telse\n\t\t\tthis();\n\t}\n}\n"};
        runner.expectedCompilerLog = "----------\n1. ERROR in TestFlow.java (at line 5)\n\tsuper();\n\t^^^^^^^^\nConstructor call is not allowed here\n----------\n2. ERROR in TestFlow.java (at line 7)\n\tthis();\n\t^^^^^^^\nConstructor call is not allowed here\n----------\n";
        runner.runNegativeTest();
    }

    public void testGH2466() {
        Runner runner = new Runner(false);
        runner.testFiles = new String[]{"TestFlow.java", "public class TestFlow {\n\tTestFlow() {}\n\tTestFlow(boolean f) {\n\t\tif (f)\n\t\t\tsuper();\n\t\tthis();\n\t}\n}\n"};
        runner.expectedCompilerLog = "----------\n1. ERROR in TestFlow.java (at line 5)\n\tsuper();\n\t^^^^^^^^\nConstructor call is not allowed here\n----------\n";
        runner.runNegativeTest();
    }

    public void testGH3094() {
        Runner runner = new Runner(false);
        runner.testFiles = new String[]{"X.java", "public class X {\n\tclass Nested extends X1 {\n\t\tX1 xy;\n\t\tclass DeeplyNested extends NestedInX1 {\n\t\t\tDeeplyNested(float f) {\n\t\t\t\tNested.super.x1.super(); // Error here\n\t\t\t}\n\t\t}\n\t}\n\tpublic static void main(String... args) {\n\t\tNested nest = new X().new Nested();\n\t\tnest.x1 = new X1();\n\t\tnest.new DeeplyNested(1.1f);\n\t}\n}\nclass X1 {\n\tX1 x1;\n\tclass NestedInX1 {}\n}\n"};
        runner.runConformTest();
    }

    public void testGH3094_2() {
        Runner runner = new Runner(false);
        runner.testFiles = new String[]{"X.java", "public class X {\n\tclass Nested extends X1 {\n\t\tX1 xy;\n\t\tclass DeeplyNested extends NestedInX1 {\n\t\t\tDeeplyNested(float f) {\n\t\t\t\tNested.this.x1.super();\n\t\t\t}\n\t\t}\n\t}\n\tpublic static void main(String... args) {\n\t\tNested nest = new X().new Nested();\n\t\tnest.x1 = new X1();\n\t\tnest.new DeeplyNested(1.1f);\n\t}\n}\nclass X1 {\n\tX1 x1;\n\tclass NestedInX1 {}\n}\n"};
        runner.runConformTest();
    }

    public void testGH3094_3() {
        Runner runner = new Runner(false);
        runner.testFiles = new String[]{"X.java", "public class X {\n\tclass Nested extends X1 {\n\t\tX1 xy;\n\t\tNested() {\n\t\t\tclass DeeplyNested extends NestedInX1 {\n\t\t\t\tDeeplyNested(float f) {\n\t\t\t\t\tNested.this.x1.super();\n\t\t\t\t}\n\t\t\t}\n\t\t\tsuper();\n\t\t}\n\t}\n}\nclass X1 {\n\tX1 x1;\n\tclass NestedInX1 {}\n}\n"};
        runner.expectedCompilerLog = "----------\n1. WARNING in X.java (at line 5)\n\tclass DeeplyNested extends NestedInX1 {\n\t      ^^^^^^^^^^^^\nThe type DeeplyNested is never used locally\n----------\n2. ERROR in X.java (at line 7)\n\tNested.this.x1.super();\n\t^^^^^^^^^^^^^^\nCannot read field x1 in an early construction context\n----------\n";
        runner.runNegativeTest();
    }

    public void testGH3132() {
        Runner runner = new Runner();
        runner.testFiles = new String[]{"X.java", "public class X {\n\tclass Nested {\n\t\tNested(Object o) {}\n\t}\n\tclass AnotherNested extends Nested {\n\t\tAnotherNested() {\n\t\t\tsuper(new Object() { // Cannot instantiate class new Object(){} in an early construction context of class X.AnotherNested\n\t\t\t});\n\t\t}\n\t}\n\tpublic static void main(String... args) {\n\t\tnew X().new AnotherNested();\n\t}\n}\n"};
        runner.runConformTest();
    }

    public void testGH3132_2() {
        Runner runner = new Runner();
        runner.testFiles = new String[]{"X.java", "class O {} // demonstrates the the bug was not specific to j.l.Object\npublic class X {\n\tclass Nested extends O {\n\t\tNested(Object o) {}\n\t}\n\tclass AnotherNested extends Nested {\n\t\tAnotherNested() {\n\t\t\tsuper(new O() {\n\t\t\t});\n\t\t}\n\t}\n\tpublic static void main(String... args) {\n\t\tnew X().new AnotherNested();\n\t}\n}\n"};
        runner.runConformTest();
    }

    public void testGH3153() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  public static void main(String[] argv) {\n    class Inner {\n      Inner() {\n        class Local {}\n        new Local() {}; // Error: No enclosing instance of the type X is accessible in scope\n        super();\n      }\n    }\n    new Inner();\n  }\n}\n"}, "");
    }

    public void testLocalAccesToOuter() {
        this.runConformTest(new String[]{"Outer.java", "import java.util.function.Supplier;\n@SuppressWarnings(\"unused\")\nclass Outer {\n\tvoid m() {\n\t\tSystem.out.print(\"m\");\n\t}\n\tclass Inner {\n\t\tInner() {\n\t\t\tclass Foo {\n\t\t\t\tvoid g() {\n\t\t\t\t\tm();\n\t\t\t\t}\n\t\t\t}\n\t\t\tsuper();\n\t\t\tnew Foo().g();\n\t\t}\n\t}\n\tpublic static void main(String... args) {\n\t\tnew Outer().new Inner();\n\t}\n}\n"}, "m");
    }

    public void testCtorRef_staticContext() {
        this.runNegativeTest(new String[]{"Outer.java", "import java.util.function.Supplier;\nclass Outer {\n\tclass Inner {\n\t\tInner() {\n\t\t\tclass Foo {\n\t\t\t\tvoid g() {\n\t\t\t\t\tSystem.out.print(\"g\");\n\t\t\t\t}\n\t\t\t}\n\t\t\tsuper();\n\t\t\tclass Bar {\n\t\t\t\tstatic void p() {\n\t\t\t\t\tnew Foo().g();\n\t\t\t\t}\n\t\t\t\tstatic void r() {\n\t\t\t\t\tSupplier<Foo> sfoo = Foo::new;\n\t\t\t\t\tsfoo.get().g();\n\t\t\t\t}\n\t\t\t};\n\t\t\tBar.r();\n\t\t}\n\t}\n\tpublic static void main(String... args) {\n\t\tnew Outer().new Inner();\n\t}\n}\n"}, "----------\n1. WARNING in Outer.java (at line 10)\n\tsuper();\n\t^^^^^^^^\nYou are using a preview language feature that may or may not be supported in a future release\n----------\n2. ERROR in Outer.java (at line 13)\n\tnew Foo().g();\n\t^^^^^^^^^\nCannot instantiate local class 'Foo' in a static context\n----------\n3. ERROR in Outer.java (at line 16)\n\tSupplier<Foo> sfoo = Foo::new;\n\t                     ^^^^^^^^\nCannot instantiate local class 'Foo' in a static context\n----------\n");
    }

    public void testCtorRef_nonStatic() {
        this.runConformTest(new String[]{"Outer.java", "import java.util.function.Supplier;\nclass Outer {\n\tclass Inner {\n\t\tInner() {\n\t\t\tclass Foo {\n\t\t\t\tvoid g() {\n\t\t\t\t\tSystem.out.print(\"g\");\n\t\t\t\t}\n\t\t\t}\n\t\t\tsuper();\n\t\t\tclass Bar {\n\t\t\t\tvoid p() {\n\t\t\t\t\tnew Foo().g();\n\t\t\t\t}\n\t\t\t\tvoid r() {\n\t\t\t\t\tSupplier<Foo> sfoo = Foo::new;\n\t\t\t\t\tsfoo.get().g();\n\t\t\t\t}\n\t\t\t};\n\t\t\tnew Bar().r();\n\t\t}\n\t}\n\tpublic static void main(String... args) {\n\t\tnew Outer().new Inner();\n\t}\n}\n"}, "g");
    }

    public void testGH3188() {
        this.runConformTest(new String[]{"EarlyLocalCtorRef.java", "import java.util.function.Supplier;\nclass EarlyLocalCtorRef {\n    EarlyLocalCtorRef() {\n        class InnerLocal { }\n        this(InnerLocal::new);\n    }\n    EarlyLocalCtorRef(Supplier<Object> s) {\n    }\n    public static void main(String... args0) {\n    \tnew EarlyLocalCtorRef();\n    }\n}\n"}, "");
    }

    public void testGH3194_reopen() {
        this.runConformTest(new String[]{"X.java", "sealed interface A permits X {}\npublic final  class X implements A {\n\tint a = 1;\n\tclass One {\n\t\tint b = 2;\n\t\tclass Two {\n\t\t\tint c = 3;\n\t\t\tclass Three {\n\t\t\t\tint r = a + b + c;\n\t\t\t}\n\t\t}\n\t}\n\tpublic static void main(String argv[]) {\n\t\tX x = new X();\n\t\tOne.Two.Three ci = x.new One().new Two().new Three(); // No enclosing instance of type X is accessible. Must qualify the allocation...\n\t\tSystem.out.println(ci.r);\n\t}\n}\n"});
    }

    public void testGH3116() {
        Runner runner = new Runner();
        runner.testFiles = new String[]{"X.java", "class X {\n\tfinal int final_field;\n\tint x;\n\t{ x = final_field; } // Error: The blank final field final_field may not have been initialized\n\tX() {\n\t\tfinal_field = -1;\n\t\tsuper();\n\t}\n\tpublic static void main(String... args) {\n\t\tSystem.out.print(new X().x);\n\t}\n}\n"};
        runner.expectedOutputString = "-1";
        runner.runConformTest();
    }

    public void testGH3115() {
        Runner runner = new Runner();
        runner.testFiles = new String[]{"X.java", "public class X {\n\tpublic static void main(String argv[]) {\n\t\tX test = new X();\n\t}\n\tX() {\n\t\tclass InnerLocal {}\n\t\tjava.util.function.IntSupplier foo = () -> {\n\t\t\tnew InnerLocal() {}; // This is trouble\n\t\t\treturn 0;\n\t\t};\n\t\tsuper();\n\t}\n}\n"};
        runner.runConformTest();
    }

    public void test406614() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tint doit();\n}\n@SuppressWarnings(\"preview\")\npublic class X {\n\tint f;\n\tX() {\n\t}\n\tX(byte b) {\n\t\tI i = () -> this.f;\n\t\tthis();\n\t}\n\tX(short s) {\n\t\tI i = () -> this.g();\n\t\tthis();\n\t}\n\tX (int x) {\n\t\tI i = () -> f;\n\t    this();\n\t}\n\tX (long x) {\n\t\tI i = () -> g();\n\t    this();\n\t}\n\tint g() {\n\t\treturn 0;\n\t}\n\tclass Member {\n\t\tMember() {}\n\t\tMember(byte b) {\n\t\t\tI i = () -> X.this.f;\n\t\t\tthis();\n\t\t}\n\t\tMember(short s) {\n\t\t\tI i = () -> X.this.g();\n\t\t\tthis();\n\t\t}\n\t\tMember(int x) {\n\t\t\tI i = () -> f;\n\t\t    this();\n\t\t}\n\t\tMember(long x) {\n\t\t\tI i = () -> g();\n\t\t    this();\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 10)\n\tI i = () -> this.f;\n\t            ^^^^^^\nCannot read field f in an early construction context\n----------\n2. ERROR in X.java (at line 14)\n\tI i = () -> this.g();\n\t            ^^^^\nCannot use 'this' in an early construction context\n----------\n3. ERROR in X.java (at line 18)\n\tI i = () -> f;\n\t            ^\nCannot read field f in an early construction context\n----------\n4. ERROR in X.java (at line 22)\n\tI i = () -> g();\n\t            ^^^\nCannot invoke method g() in an early construction context\n----------\n");
    }

    public void test406614_member() throws IOException, ClassFormatException {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tint doit();\n}\n@SuppressWarnings(\"preview\")\npublic class X {\n\tint f;\n\tint g() {\n\t\treturn 0;\n\t}\n\tclass Member {\n\t\tMember() {}\n\t\tMember(byte b) {\n\t\t\tI i = () -> X.this.f;\n\t\t\tthis();\n\t\t}\n\t\tMember(short s) {\n\t\t\tI i = () -> X.this.g();\n\t\t\tthis();\n\t\t}\n\t\tMember(int x) {\n\t\t\tI i = () -> f;\n\t\t    this();\n\t\t}\n\t\tMember(long x) {\n\t\t\tI i = () -> g();\n\t\t    this();\n\t\t}\n\t}\n\tpublic static void main(String... args) {\n\t\tnew X().new Member((byte)13);\n\t}\n}\n"}, "");
        this.verifyClassFile("version 24 : 68.65535", "X.class", 4);
    }

    public void testFieldAssignment_OK() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tfinal String s;\n\tX(String s0) {\n\t\ts = s0;\n\t\tsuper();\n\t}\n\tX() {\n\t\ts = \"\";\n\t\tsuper();\n\t}\n\tpublic static void main(String... args) {\n\t\tSystem.out.print(new X(\"OK\").s);\n\t}\n}\n"}, "OK");
    }

    public void testFieldAssignmentNotAlways_NOK() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tfinal String s;\n\tX(String s0) {\n\t\ts = s0;\n\t\tsuper();\n\t}\n\tX() {\n\t}\n\tpublic static void main(String... args) {\n\t\tSystem.out.print(new X(\"OK\").s);\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 4)\n\ts = s0;\n\t^\nYou are using a preview language feature that may or may not be supported in a future release\n----------\n2. WARNING in X.java (at line 5)\n\tsuper();\n\t^^^^^^^^\nYou are using a preview language feature that may or may not be supported in a future release\n----------\n3. ERROR in X.java (at line 7)\n\tX() {\n\t^^^\nThe blank final field s may not have been initialized\n----------\n");
    }

    public void testFieldAssignmentInLambda_NOK() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tString s;\n\tX(String s0) {\n\t\ts = s0;\n\t\tsuper();\n\t}\n\tX() {\n\t\tRunnable r = () -> s = \"\";\n\t\tsuper();\n\t}\n\tpublic static void main(String... args) {\n\t\tSystem.out.print(new X(\"OK\").s);\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 4)\n\ts = s0;\n\t^\nYou are using a preview language feature that may or may not be supported in a future release\n----------\n2. WARNING in X.java (at line 5)\n\tsuper();\n\t^^^^^^^^\nYou are using a preview language feature that may or may not be supported in a future release\n----------\n3. ERROR in X.java (at line 8)\n\tRunnable r = () -> s = \"\";\n\t                   ^\nCannot assign field 's' inside a lambda expression within an early construction context of class X\n----------\n4. WARNING in X.java (at line 9)\n\tsuper();\n\t^^^^^^^^\nYou are using a preview language feature that may or may not be supported in a future release\n----------\n");
    }

    public void testFieldAssignmentInLocal_NOK() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tString s;\n\tX(String s0) {\n\t\ts = s0;\n\t\tsuper();\n\t}\n\tX() {\n\t\tRunnable r = new Runnable() {\n\t\t\tpublic void run() { s = \"Anonymous\"; };\n\t\t};\n\t\tclass Local {\n\t\t\t{\n\t\t\t\ts = \"Local\";\n\t\t\t}\n\t\t}\n\t\tsuper();\n\t}\n\tpublic static void main(String... args) {\n\t\tSystem.out.print(new X(\"OK\").s);\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 4)\n\ts = s0;\n\t^\nYou are using a preview language feature that may or may not be supported in a future release\n----------\n2. WARNING in X.java (at line 5)\n\tsuper();\n\t^^^^^^^^\nYou are using a preview language feature that may or may not be supported in a future release\n----------\n3. ERROR in X.java (at line 9)\n\tpublic void run() { s = \"Anonymous\"; };\n\t                    ^\nCannot assign field 's' from class 'X' in an early construction context\n----------\n4. ERROR in X.java (at line 13)\n\ts = \"Local\";\n\t^\nCannot assign field 's' from class 'X' in an early construction context\n----------\n5. WARNING in X.java (at line 16)\n\tsuper();\n\t^^^^^^^^\nYou are using a preview language feature that may or may not be supported in a future release\n----------\n");
    }

    public void testJDK8322882() throws Exception {
        this.runNegativeTest(new String[]{"TestUseTree2.java", " public class TestUseTree2 {\n\tpublic static void main(String[] args) {\n\t\tString i = \"111\";\n\t\tclass TestUseTree2_ROOT {\n\t\t\t// ctor arg i\n\t\t\tvoid f() {\n\t\t\t\tSystem.out.println(i);\n\t\t\t}\n\t\t}\n\n\t\tclass TestUseTree2_ROOT1 {\n\t\t\t// clinit args: i?\n\t\t\t// should be prohibited to use `new TestUseTree2_ROOT()` in a static context\n\t\t\tstatic TestUseTree2_ROOT r = new TestUseTree2_ROOT();\n\t\t}\n\n\t\tTestUseTree2_ROOT1.r.f();\n\t}\n}\n"}, "----------\n1. ERROR in TestUseTree2.java (at line 14)\n\tstatic TestUseTree2_ROOT r = new TestUseTree2_ROOT();\n\t                             ^^^^^^^^^^^^^^^^^^^^^^^\nCannot instantiate local class 'TestUseTree2_ROOT' in a static context\n----------\n");
    }

    public void testGH3654() throws Exception {
        this.runConformTest(new String[]{"LambdaOuterCapture.java", " public class LambdaOuterCapture {\n\n\tpublic class Inner {\n\n\t\tpublic Inner() {\n\t\t\tRunnable r = () -> System.out.println(LambdaOuterCapture.this);\n\t\t\tthis(r);\n\t\t}\n\n\t\tpublic Inner(Runnable r) {\n\t\t}\n\t}\n\n\tpublic static void main(String[] args) {\n\t\tnew LambdaOuterCapture().new Inner();\n\t}\n}\n"}, "");
    }

    public void testGH3655() {
        this.runConformTest(new String[]{"Test1.java", "public class Test1 {\n\tclass Inner {\n\t\tInner() {\n\t\t\tthis(() -> new Object() { { Test1.this.print(); } });\n\t\t}\n\t\tInner(Runnable r) {\n\t\t\tr.run();\n\t\t}\n\t}\n\tvoid print() {\n\t\tSystem.out.print(3);\n\t}\n\tpublic static void main(String... args) {\n\t\tnew Test1().new Inner();\n\t}\n}\n"}, "3");
    }

    public void testGH3653() {
        this.runConformTest(new String[]{"Outer.java", "class Outer { // bug\n\tinterface A { }\n\n\tclass Inner {\n\t   Inner() {\n\t\t  this(() -> {\n\t\t\t\tclass Local {\n\t\t\t\t\tvoid g() {\n\t\t\t\t\t\tm();\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\tnew Object() {\n\t\t\t\t\tvoid k() { new Local().g(); }\n\t\t\t\t}.k();\n\t\t\t});\n\t\t}\n\n\t\tInner(Runnable tr) {\n\t\t\ttr.run();\n\t\t}\n\t}\n\n\tvoid m() {\n\t\tSystem.out.println(\"Hello\");\n\t}\n\n\tpublic static void main(String[] args) {\n\t\tnew Outer().new Inner();\n\t}\n}\n"}, "Hello");
    }

    public void testGH3652() {
        this.runConformTest(new String[]{"Outer.java", "class Outer {\n\tinterface A {\n\t\tvoid run();\n\t}\n\tinterface B {\n\t\tvoid run();\n\t}\n\n\tclass Inner1 {\n\t\tInner1() {\n\t\t\tthis(new A() {\n\t\t\t\tclass Inner2 {\n\t\t\t\t\tInner2() {\n\t\t\t\t\t\tthis(new B() {\n\t\t\t\t\t\t\tpublic void run() {\n\t\t\t\t\t\t\t\tm();\n\t\t\t\t\t\t\t\tg();\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t});\n\t\t\t\t\t}\n\n\t\t\t\t\tInner2(B o) {\n\t\t\t\t\t\to.run();\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tpublic void run() {\n\t\t\t\t\tnew Inner2();\n\t\t\t\t}\n\n\t\t\t\tvoid m() { System.out.print(getClass().getName() + \".m() \"); }\n\t\t\t});\n\t\t}\n\n\t\tInner1(A o) { o.run(); }\n\t}\n\tvoid g() { System.out.print(getClass().getName() +\".g()\"); }\n\n\tpublic static void main(String[] args) {\n\t\tnew Outer().new Inner1();\n\t}\n}\n"}, "Outer$Inner1$1.m() Outer.g()");
    }

    public void testGH3687a() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic void main(String[] args) {\n\t\tSystem.out.println(foo() != 0);\n\t}\n\tstatic int foo() {\n\t\tclass Local {\n\t\t\tint value = 0;\n\t\t\tclass Local2 {\n\t\t\t\tpublic static int bar() {\n\t\t\t\t\treturn new Local().value;\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t\treturn Local.Local2.bar();\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 10)\n\treturn new Local().value;\n\t       ^^^^^^^^^^^\nCannot instantiate local class 'Local' in a static context\n----------\n");
    }

    public void testGH3687b() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\t@SuppressWarnings(\"unused\")\n\tstatic int INT_FIELD = new Object() {\n\t\tclass Local {\n\t\t\tint value = 10;\n\t\t\tclass Local2 {\n\t\t\t\tpublic int bar() {\n\t\t\t\t\tint v = new Local().value;\n\t\t\t\t\tSystem.out.print(v);\n\t\t\t\t\treturn v;\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t\tint l = new Local().new Local2().bar();\n\t}.hashCode();\n\tpublic static void main(String... args) {\n\t\tint h = INT_FIELD / 2;\n\t}\n}\n"}, "10");
    }

    public void testGH3700() {
        this.runConformTest(new String[]{"Main.java", "interface Foo {\n\tvoid foo();\n}\n\npublic class Main {\n\tstatic int check = 0;\n\n\tclass Test {\n\t\tTest() {}\n\t\tTest(int a) {\n\t\t\tclass InnerLocal {\n\t\t\t\tint a = 1;\n\t\t\t}\n\t\t\tFoo lmb = () -> {\n\t\t\t\tMain.check = new InnerLocal() {\n\t\t\t\t\t\tpublic int a() {\n\t\t\t\t\t\t\treturn this.a;\n\t\t\t\t\t\t}\n\t\t\t\t\t}.a();\n\t\t\t};\n\t\t\tlmb.foo();\n\t\t\tthis();\n\t\t}\n\t}\n\tpublic static void main(String... args) {\n\t\tnew Main().new Test(3);\n\t\tSystem.out.print(check);\n\t}\n}\n"}, "1");
    }

    public void testGH3748a() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tfinal int fin1, fin2;\n\t{\n\t\tfin1 = 0;\n\t\tfin2 = 1;\n\t}\n\tX() {\n\t\tint abc = 0; // Commenting out this line brings out the error\n\t\tthis(fin1 = 10);\n\t\tfin2 = 11;\n\t}\n\tX(int x) {}\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tfin1 = 0;\n\t^^^^\nThe final field fin1 may already have been assigned\n----------\n2. WARNING in X.java (at line 9)\n\tthis(fin1 = 10);\n\t^^^^^^^^^^^^^^^^\nYou are using a preview language feature that may or may not be supported in a future release\n----------\n3. WARNING in X.java (at line 9)\n\tthis(fin1 = 10);\n\t     ^^^^\nYou are using a preview language feature that may or may not be supported in a future release\n----------\n4. ERROR in X.java (at line 10)\n\tfin2 = 11;\n\t^^^^\nThe final field fin2 may already have been assigned\n----------\n");
    }

    public void testGH3748b() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tfinal int fin1;\n\tfinal int fin2;\n\t{\n\t\tfin1 = 0;\n\t\tfin2 = 1;\n\t}\n\tX() {\n\t\tthis(fin1 = 10);\n\t\tfin2 = 11;\n\t}\n\tX(int x) {}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tfin1 = 0;\n\t^^^^\nThe final field fin1 may already have been assigned\n----------\n2. WARNING in X.java (at line 9)\n\tthis(fin1 = 10);\n\t     ^^^^\nYou are using a preview language feature that may or may not be supported in a future release\n----------\n3. ERROR in X.java (at line 10)\n\tfin2 = 11;\n\t^^^^\nThe final field fin2 may already have been assigned\n----------\n");
    }

    public void testGH3687c() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.function.IntSupplier;\n@SuppressWarnings(\"unused\")\npublic class X {\n\tpublic static void main(String argv[]) {\n\t\tclass Parent {\n\t\t\tint value;\n\t\t\tParent(int i) {\n\t\t\t\tthis.value = i;\n\t\t\t}\n\t\t}\n\t\tclass Outer {\n\t\t\tstatic IntSupplier supplier = () -> {\n\t\t\t\tclass InnerLocal extends Parent {\n\t\t\t\t\tInnerLocal() {\n\t\t\t\t\t\tsuper(10);\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\treturn new InnerLocal().value;\n\t\t\t};\n\t\t}\n\t\tSystem.out.println(Outer.supplier.getAsInt());\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 15)\n\tsuper(10);\n\t^^^^^^^^^^\nCannot instantiate local class 'Parent' in a static context\n----------\n");
    }

    public void testGH3687d() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.function.IntSupplier;\nimport java.util.function.Predicate;\n@SuppressWarnings(\"unused\")\npublic class X {\n\tpublic static void main(String argv[]) {\n\t\tPredicate<Integer> condition = (Integer param) -> {\n\t\t\tclass Parent {\n\t\t\t\tint value;\n\t\t\t\tParent(int i) {\n\t\t\t\t\tvalue = i;\n\t\t\t\t}\n\t\t\t}\n\t\t\tclass Outer {\n\t\t\t\tstatic {\n\t\t\t\t\tclass Inner extends Parent {\n\t\t\t\t\t\tInner(int i) {\n\t\t\t\t\t\t\tsuper(i);\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t\treturn param <= 10;\n\t\t};\n\t\tSystem.out.println(condition.test(10));\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 17)\n\tsuper(i);\n\t^^^^^^^^^\nCannot instantiate local class 'Parent' in a static context\n----------\n");
    }

    public void testGH3687e() {
        this.runNegativeTest(new String[]{"X.java", "import java.io.PrintStream;\nimport java.util.function.Predicate;\n@SuppressWarnings(\"unused\")\npublic class X {\n\tstatic {\n\t\tclass SuperClass {}\n\t\tclass Outer {\n\t\t\tstatic int a;\n\t\t\tstatic Predicate<Object> test = (o) -> new SuperClass() {\n\t\t\t\tpublic boolean test() {\n\t\t\t\t\treturn true;\n\t\t\t\t}\n\t\t\t}.test();\n\t\t}\n\t}\n\tpublic static void main(String argv[]) {\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 9)\n\tstatic Predicate<Object> test = (o) -> new SuperClass() {\n\t                                           ^^^^^^^^^^^^\nCannot instantiate local class 'SuperClass' in a static context\n----------\n");
    }

    public void testGH3753() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tstatic int value = 0;\n\tpublic static void main(String[] argv) {\n\t\tclass Local {\n\t\t\tclass Inner {}\n\t\t\tLocal(int a) {\n\t\t\t\tX.value = new Inner() { // This is reported by Javac\n\t\t\t\t\tpublic int foo() {\n\t\t\t\t\t\treturn 1;\n\t\t\t\t\t}\n\t\t\t\t}.foo();\n\t\t\t\tsuper();\n\t\t\t}\n\t\t}\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 4)\n\tclass Local {\n\t      ^^^^^\nThe type Local is never used locally\n----------\n2. ERROR in X.java (at line 7)\n\tX.value = new Inner() { // This is reported by Javac\n\t          ^^^^^^^^^^^\nNo enclosing instance of type Local is accessible. Must qualify the allocation with an enclosing instance of type Local (e.g. x.new A() where x is an instance of Local).\n----------\n3. WARNING in X.java (at line 12)\n\tsuper();\n\t^^^^^^^^\nYou are using a preview language feature that may or may not be supported in a future release\n----------\n");
    }

    public void testGH3844() {
        this.runConformTest(new String[]{"SubClass.java", "class Base {\n  public Base(long n) {\n  }\n}\n\nclass SubClass extends Base {\n  private final String anyFinalWithInitializer = \"init\";\n\n  public SubClass() {\n    super(System.currentTimeMillis());\n  }\n  public static void main(String... args) {\n    SubClass s = new SubClass();\n    System.out.print(s.anyFinalWithInitializer);\n  }\n}\n"}, "init");
    }

    class Runner
    extends AbstractRegressionTest.Runner {
        public Runner(boolean reportPreview) {
            this();
            this.customOptions.put("org.eclipse.jdt.core.compiler.problem.reportPreviewFeatures", reportPreview ? "warning" : "ignore");
        }

        public Runner() {
            this.vmArguments = VMARGS;
            this.javacTestOptions = JAVAC_OPTIONS;
            this.customOptions = SuperAfterStatementsTest.this.getCompilerOptions();
            this.customOptions.put("org.eclipse.jdt.core.compiler.problem.enablePreviewFeatures", "enabled");
        }
    }
}

