/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.io.File;
import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractBatchCompilerTest;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;

public class SuppressWarningsTest
extends AbstractBatchCompilerTest {
    public SuppressWarningsTest(String name) {
        super(name);
    }

    public static Test suite() {
        return SuppressWarningsTest.buildMinimalComplianceTestSuite(SuppressWarningsTest.testClass(), 32);
    }

    public static Class testClass() {
        return SuppressWarningsTest.class;
    }

    @Override
    protected Map getCompilerOptions() {
        Map<String, String> options = super.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.suppressWarnings", "enabled");
        options.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "warning");
        options.put("org.eclipse.jdt.core.compiler.problem.autoboxing", "warning");
        return options;
    }

    public void testSimpleSuppressWarnings() {
        String firstSupportedVersion = CompilerOptions.getFirstSupportedJavaVersion();
        this.runTest(true, new String[]{"p/SuppressTest.java", "package p;\npublic class SuppressTest {\n@SuppressWarnings(\"boxing\")\npublic Long get(long l) {\n  Long result = l * 2;\n  return result;\n}\n}\n"}, "\"" + OUTPUT_DIR + File.separator + "p/SuppressTest.java\" -warn:+unused -warn:+boxing  -" + firstSupportedVersion + " -g -preserveAllLocals -d \"" + OUTPUT_DIR + "\" ", "", "", true, null);
    }

    public void testNestedSuppressWarnings() {
        String firstSupportedVersion = CompilerOptions.getFirstSupportedJavaVersion();
        this.runTest(true, new String[]{"p/SuppressTest.java", "package p;\n@SuppressWarnings(\"unused\")\npublic class SuppressTest {\nprivate String unused=\"testUnused\";\n@SuppressWarnings(\"boxing\")\npublic Long get(long l) {\n  Long result = l * 2;\n  return result;\n}\n}\n"}, "\"" + OUTPUT_DIR + File.separator + "p/SuppressTest.java\" -warn:+unused -warn:+boxing  -" + firstSupportedVersion + " -g -preserveAllLocals -d \"" + OUTPUT_DIR + "\" ", "", "", true, null);
    }

    public void testUnrelatedSuppressWarnings() {
        String firstSupportedVersion = CompilerOptions.getFirstSupportedJavaVersion();
        this.runTest(true, new String[]{"p/SuppressTest.java", "package p;\n@SuppressWarnings(\"unused\")\npublic class SuppressTest {\nprivate String unused=\"testUnused\";\npublic Long get(long l) {\n  Long result = l * 2;\n  return result;\n}\n}\n"}, "\"" + OUTPUT_DIR + File.separator + "p/SuppressTest.java\" -warn:+unused -warn:+boxing  -" + firstSupportedVersion + " -g -preserveAllLocals -d \"" + OUTPUT_DIR + "\" ", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/p/SuppressTest.java (at line 6)\n\tLong result = l * 2;\n\t              ^^^^^\nThe expression of type long is boxed into Long\n----------\n1 problem (1 warning)\n", true, null);
    }
}

