/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;

public class SwitchExpressionsYieldTest
extends AbstractRegressionTest {
    public static Class<?> testClass() {
        return SwitchExpressionsYieldTest.class;
    }

    public static Test suite() {
        return SwitchExpressionsYieldTest.buildMinimalComplianceTestSuite(SwitchExpressionsYieldTest.testClass(), 2048);
    }

    public SwitchExpressionsYieldTest(String testName) {
        super(testName);
    }

    @Override
    protected void runConformTest(String[] testFiles, String expectedOutput) {
        this.runConformTest(testFiles, expectedOutput, (Map)this.getCompilerOptions());
    }

    protected void runConformTest(String[] testFiles, String expectedOutput, Map customOptions) {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.testFiles = testFiles;
        runner.expectedOutputString = expectedOutput;
        runner.customOptions = customOptions;
        runner.javacTestOptions = AbstractRegressionTest.JavacTestOptions.forRelease("14");
        runner.runConformTest();
    }

    @Override
    protected void runNegativeTest(String[] testFiles, String expectedCompilerLog) {
        this.runNegativeTest(testFiles, expectedCompilerLog, AbstractRegressionTest.JavacTestOptions.forRelease("14"));
    }

    protected void runWarningTest(String[] testFiles, String expectedCompilerLog) {
        this.runWarningTest(testFiles, expectedCompilerLog, null);
    }

    protected void runWarningTest(String[] testFiles, String expectedCompilerLog, Map<String, String> customOptions) {
        this.runWarningTest(testFiles, expectedCompilerLog, customOptions, null);
    }

    protected void runWarningTest(String[] testFiles, String expectedCompilerLog, Map<String, String> customOptions, String javacAdditionalTestOptions) {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.testFiles = testFiles;
        runner.expectedCompilerLog = expectedCompilerLog;
        runner.customOptions = customOptions;
        runner.javacTestOptions = javacAdditionalTestOptions == null ? AbstractRegressionTest.JavacTestOptions.forRelease("14") : AbstractRegressionTest.JavacTestOptions.forRelease("14", javacAdditionalTestOptions);
        runner.runWarningTest();
    }

    public void testBug544073_000() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\n\tpublic static int yield() {\n\t\treturn 1;\n\t}\n\tpublic static int foo(int val) {\n\t\tint k = switch (val) {\n\t\tcase 1 -> { yield 1; }\n\t\tdefault -> { yield 2; }\n\t\t};\n\t\treturn k;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(X.foo(1));\n\t}\n}\n"}, "1");
    }

    public void testBug544073_001() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tstatic int twice(int i) {\n\t\tint tw = switch (i) {\n\t\t\tcase 0 -> i * 0;\n\t\t\tcase 1 -> 2;\n\t\t\tdefault -> 3;\n\t\t};\n\t\treturn tw;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.print(twice(3));\n\t}\n}\n"}, "3");
    }

    public void testBug544073_002() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tstatic int twice(int i) throws Exception {\n\t\tint tw = switch (i) {\n\t\t\tcase 0 -> 0;\n\t\t\tcase 1 -> { \n\t\t\t\tSystem.out.println(\"do_not_print\");\n\t\t\t\tyield 1;\n\t\t\t} \n\t\t\tcase 3 -> throw new Exception();\n\t\t\tdefault -> throw new Exception();\n\t\t};\n\t\treturn tw;\n\t}\n\tpublic static void main(String[] args) {\n\t\ttry {\n\t\t    try {\n\t\t\t\tSystem.out.print(twice(3));\n\t\t\t} catch (Exception e) {\n\t\t\t\tSystem.out.print(\"Got Exception - expected\");\n\t\t\t}\n\t\t} catch (Exception e) {\n\t\tSystem.out.print(\"Got Exception\");\n\t\t}\n\t}\n}\n"}, "Got Exception - expected");
    }

    public void testBug544073_003() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args) {\n    twice(1);\n  }\n\tpublic static int twice(int i) {\n\t\tint tw = switch (i) {\n\t\t};\n\t\treturn tw;\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tint tw = switch (i) {\n\t\t};\n\t         ^^^^^^^^^^^^^^^^\nA switch expression should have at least one result expression\n----------\n2. ERROR in X.java (at line 6)\n\tint tw = switch (i) {\n\t                 ^\nA switch expression should have a default case\n----------\n");
    }

    public void testBug544073_004() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args) {\n    twice(1);\n  }\n\tpublic static int twice(int i) {\n\t\tint tw = switch (i) {\n\t\t\tcase 0 -> 0;\n\t\t\tcase 1 -> { \n\t\t\t\tSystem.out.println(\"heel\");\n\t\t\t\tyield 1;\n\t\t\t} \n\t\t\tcase \"hello\" -> throw new java.io.IOException(\"hello\");\n\t\t\tdefault -> throw new java.io.IOException(\"world\");\n\t\t};\n\t\treturn tw;\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 12)\n\tcase \"hello\" -> throw new java.io.IOException(\"hello\");\n\t     ^^^^^^^\nCase constant of type String is incompatible with switch selector type int\n----------\n");
    }

    public void testBug544073_005() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args) {\n    twice(1);\n  }\n\tpublic static int twice(int i) {\n\t\tint tw = switch (i) {\n\t\t\tcase 0 -> 0;\n\t\t\tcase 1 -> { \n\t\t\t\tSystem.out.println(\"heel\");\n\t\t\t\tyield 1;\n\t\t\t} \n\t\t    case 2 -> 2;\n\t\t};\n\t\treturn tw;\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tint tw = switch (i) {\n\t                 ^\nA switch expression should have a default case\n----------\n");
    }

    public void testBug544073_006() {
        this.runNegativeTest(new String[]{"X.java", "import java.io.IOException;\npublic class X {\n  public static void main(String[] args) {\n  }\n\tpublic static int twice(int i) {\n\t\tint tw = switch (i) {\n\t\t\tcase 0 -> 0;\n\t\t\tcase 1 -> { \n\t\t\t\tSystem.out.println(\"heel\");\n\t\t\t\tyield 1;\n\t\t\t} \n\t\t//\tcase 2 -> 2;\n\t\t\tcase \"hello\" -> throw new IOException(\"hello\");\n\t\t};\n\t\treturn tw;\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tint tw = switch (i) {\n\t                 ^\nA switch expression should have a default case\n----------\n2. ERROR in X.java (at line 13)\n\tcase \"hello\" -> throw new IOException(\"hello\");\n\t     ^^^^^^^\nCase constant of type String is incompatible with switch selector type int\n----------\n");
    }

    public void testBug544073_007() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tstatic int foo(int i) {\n\t\tint tw = \n\t\tswitch (i) {\n\t\t\tcase 1 -> \n\t\t\t {\n \t\t\t\tint z = 100;\n \t\t\t\tyield z;\n\t\t\t}\n\t\t\tdefault -> {\n\t\t\t\tyield 12;\n\t\t\t}\n\t\t};\n\t\treturn tw;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.print(foo(1));\n\t}\n}\n"}, "100");
    }

    public void testBug544073_009() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\n\tpublic static void bar(int  i) {\n\t\tswitch (i) {\n\t\tcase 1 -> System.out.println(\"hello\");\n\t\tdefault -> System.out.println(\"DEFAULT\");\n\t\t}\n\t}\n\tpublic static void main(String[] args) {\n\t\tbar(1);\n\t}\n}\n"}, "hello");
    }

    public void testBug544073_010() {
        String[] testFiles = new String[]{"X.java", "public class X {\n\tstatic int twice(int i) {\n\t\tswitch (i) {\n\t\t\tcase 0 -> i * 0;\n\t\t\tcase 1 -> 2;\n\t\t\tdefault -> 3;\n\t\t}\n\t\treturn 0;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.print(twice(3));\n\t}\n}\n"};
        String expectedProblemLog = "----------\n1. ERROR in X.java (at line 4)\n\tcase 0 -> i * 0;\n\t          ^^^^^\nInvalid expression as statement\n----------\n2. ERROR in X.java (at line 5)\n\tcase 1 -> 2;\n\t          ^\nInvalid expression as statement\n----------\n3. ERROR in X.java (at line 6)\n\tdefault -> 3;\n\t           ^\nInvalid expression as statement\n----------\n";
        this.runNegativeTest(testFiles, expectedProblemLog);
    }

    public void testBug544073_011() {
        String[] testFiles = new String[]{"X.java", "public class X {\n\tstatic int twice(int i) {\n\t\tswitch (i) {\n\t\t\tdefault -> 3;\n\t\t}\n\t\treturn 0;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.print(twice(3));\n\t}\n}\n"};
        String expectedProblemLog = "----------\n1. ERROR in X.java (at line 4)\n\tdefault -> 3;\n\t           ^\nInvalid expression as statement\n----------\n";
        this.runNegativeTest(testFiles, expectedProblemLog);
    }

    public void testBug544073_012() {
        String[] testFiles = new String[]{"X.java", "public class X {\n\n\tstatic int twice(int i) {\n\t\tswitch (i) {\n\t\t\tdefault -> 3;\n\t\t}\n\t\treturn 0;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.print(twice(3));\n\t}\n}\n"};
        String expectedProblemLog = "----------\n1. ERROR in X.java (at line 5)\n\tdefault -> 3;\n\t           ^\nInvalid expression as statement\n----------\n";
        this.runNegativeTest(testFiles, expectedProblemLog);
    }

    public void testBug544073_013() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.enablePreviewFeatures", "enabled");
        options.put("org.eclipse.jdt.core.compiler.problem.reportPreviewFeatures", "warning");
        String release = options.get("org.eclipse.jdt.core.compiler.release");
        options.put("org.eclipse.jdt.core.compiler.source", "11");
        try {
            String[] testFiles = new String[]{"X.java", "public class X {\n\tstatic int twice(int i) {\n\t\tswitch (i) {\n\t\t\tdefault -> 3;\n\t\t}\n\t\treturn 0;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.print(twice(3));\n\t}\n}\n"};
            String expectedProblemLog = "----------\n1. ERROR in X.java (at line 0)\n\tpublic class X {\n\t^\nPreview features enabled at an invalid source release level 11, preview can be enabled only at source level " + AbstractRegressionTest.PREVIEW_ALLOWED_LEVEL + "\n----------\n";
            this.runNegativeTest(testFiles, expectedProblemLog, null, true, options);
        }
        finally {
            options.put("org.eclipse.jdt.core.compiler.source", release);
        }
    }

    public void testBug544073_014() {
        String[] testFiles = new String[]{"X.java", "public class X {\n\tpublic static int foo(int i) {\n\t\tint v;\n\t\tint t = switch (i) {\n\t\tcase 0 : {\n\t\t\tyield 0;\n\t\t}\n\t\tdefault :v = 2;\n\t\t};\n\t\treturn t;\n\t}\n\t\n\tpublic boolean bar() {\n\t\treturn true;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(foo(3));\n\t}\n}\n"};
        String expectedProblemLog = "----------\n1. ERROR in X.java (at line 8)\n\tdefault :v = 2;\n\t            ^^\nA switch labeled block in a switch expression must yield a value or throw an an exception\n----------\n";
        this.runNegativeTest(testFiles, expectedProblemLog);
    }

    public void testBug544073_015() {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.customOptions = this.getCompilerOptions();
        runner.testFiles = new String[]{"X.java", "public class X {\n\tvoid test(int i) {\n\t\tSystem.out.println(switch (i) {\n\t\t\tcase 1 -> \"one\";\n\t\t\tdefault -> null;\n\t\t}.toLowerCase());\n\t}\n\tpublic static void main(String[] args) {\n\t\tnew X().test(1);\n\t}\n}\n"};
        runner.expectedCompilerLog = "----------\n1. ERROR in X.java (at line 6)\n\t}.toLowerCase());\n\t ^\nSyntax error on token \".\", , expected\n----------\n";
        runner.runNegativeTest();
    }

    public void testBug544073_016() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static int foo(Day day) {\n\n\t\tvar len= switch (day) {\n\t\t\tcase SUNDAY-> 6;\n\t\t\tdefault -> 10;\n\t\t};\n\n\t\treturn len;\n\t}\n\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(foo(Day.SUNDAY));\n\t}\n}\nenum Day {\n\tMONDAY, TUESDAY, WEDNESDAY, THURSDAY, FRIDAY, SATURDAY, SUNDAY;\n}\n"}, "6");
    }

    public void testBug544073_017() {
        String[] testFiles = new String[]{"X.java", "public class X {\npublic static void bar(Day day) {\n\t\tswitch (day) {\n\t\tcase SATURDAY, SUNDAY: \n\t\t\tSystem.out.println(Day.SUNDAY);\n\t\t\tbreak;\n\t\tcase MONDAY : System.out.println(Day.MONDAY);\n\t\t\t\t\tbreak;\n\t\t}\n\t}\tpublic static void main(String[] args) {\n\t\tbar(Day.SATURDAY);\n\t}\n}\nenum Day { SATURDAY, SUNDAY, MONDAY;}"};
        String expectedProblemLog = "SUNDAY";
        this.runConformTest(testFiles, expectedProblemLog);
    }

    public void testBug544073_018() {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.testFiles = new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t}\npublic static void bar(Day day) {\n\t\tswitch (day) {\n\t\tcase SATURDAY, SUNDAY: \n\t\t\tSystem.out.println(Day.SUNDAY);\n\t\t\tbreak;\n\t\tcase MONDAY : System.out.println(Day.MONDAY);\n\t\t\t\t\tbreak;\n\t\t}\n\t}}\nenum Day { SATURDAY, SUNDAY, MONDAY, TUESDAY;}"};
        runner.expectedCompilerLog = "----------\n1. WARNING in X.java (at line 5)\n\tswitch (day) {\n\t        ^^^\nThe enum constant TUESDAY needs a corresponding case label in this enum switch on Day\n----------\n";
        runner.javacTestOptions = AbstractRegressionTest.JavacTestOptions.Excuse.EclipseHasSomeMoreWarnings;
        runner.runWarningTest();
    }

    public void testBug544073_019() {
        String[] testFiles = new String[]{"X.java", "public class X {\npublic static void bar(Day day) {\n\t\tswitch (day) {\n\t\tcase SATURDAY, SUNDAY: \n\t\t\tSystem.out.println(Day.SUNDAY);\n\t\t\tbreak;\n\t\tcase SUNDAY : System.out.println(Day.SUNDAY);\n\t\t\t\t\tbreak;\n\t\t}\n\t}\tpublic static void main(String[] args) {\n\t\tbar(Day.SATURDAY);\n\t}\n}\nenum Day { SATURDAY, SUNDAY, MONDAY;}"};
        String expectedProblemLog = "----------\n1. ERROR in X.java (at line 7)\n\tcase SUNDAY : System.out.println(Day.SUNDAY);\n\t     ^^^^^^\nDuplicate case\n----------\n";
        this.runNegativeTest(testFiles, expectedProblemLog);
    }

    public void testBug544073_020() {
        String[] testFiles = new String[]{"X.java", "public class X {\npublic static void bar(Day day) {\n\t\tswitch (day) {\n\t\tcase SATURDAY, SUNDAY: \n\t\t\tSystem.out.println(Day.SUNDAY);\n\t\t\tbreak;\n\t\tcase SUNDAY, SATURDAY : \n\t\t\tSystem.out.println(Day.SUNDAY);\n\t\t\tbreak;\n\t\t}\n\t}}\nenum Day { SATURDAY, SUNDAY, MONDAY;}"};
        String expectedProblemLog = "----------\n1. WARNING in X.java (at line 3)\n\tswitch (day) {\n\t        ^^^\nThe enum constant MONDAY needs a corresponding case label in this enum switch on Day\n----------\n2. ERROR in X.java (at line 7)\n\tcase SUNDAY, SATURDAY : \n\t     ^^^^^^\nDuplicate case\n----------\n3. ERROR in X.java (at line 7)\n\tcase SUNDAY, SATURDAY : \n\t             ^^^^^^^^\nDuplicate case\n----------\n";
        this.runNegativeTest(testFiles, expectedProblemLog);
    }

    public void testBug544073_021() {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.testFiles = new String[]{"X.java", "public class X {\npublic static void bar(Day day) {\n\t\tswitch (day) {\n\t\tcase SATURDAY, SUNDAY: \n\t\t\tSystem.out.println(Day.SUNDAY);\n\t\t\tbreak;\n\t\tcase TUESDAY : System.out.println(Day.SUNDAY);\n\t\t\t\t\tbreak;\n\t\t}\n\t}\tpublic static void main(String[] args) {\n\t\tbar(Day.SATURDAY);\n\t}\n}\nenum Day { SATURDAY, SUNDAY, MONDAY, TUESDAY;}"};
        runner.expectedCompilerLog = "----------\n1. WARNING in X.java (at line 3)\n\tswitch (day) {\n\t        ^^^\nThe enum constant MONDAY needs a corresponding case label in this enum switch on Day\n----------\n";
        runner.javacTestOptions = AbstractRegressionTest.JavacTestOptions.Excuse.EclipseHasSomeMoreWarnings;
        runner.runWarningTest();
    }

    public void testBug544073_022() {
        String[] testFiles = new String[]{"X.java", "public class X {\npublic static void bar(Day day) {\n\t\tswitch (day) {\n\t\tcase SATURDAY, SUNDAY: \n\t\t\tSystem.out.println(day);\n\t\t\tbreak;\n\t\tcase MONDAY : System.out.println(0);\n\t\t\t\t\tbreak;\n\t\t}\n\t}\tpublic static void main(String[] args) {\n\t\tbar(Day.SATURDAY);\n\t\tbar(Day.MONDAY);\n\t\tbar(Day.SUNDAY);\n\t}\n}\nenum Day { SATURDAY, SUNDAY, MONDAY;}"};
        String expectedProblemLog = "SATURDAY\n0\nSUNDAY";
        this.runConformTest(testFiles, expectedProblemLog);
    }

    public void testBug544073_023() {
        String[] testFiles = new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tbar(\"a\");\n\t\tbar(\"b\");\n\t\tbar(\"c\");\n\t\tbar(\"d\");\n\t}\n\tpublic static void bar(String s) {\n\t\tswitch(s) {\n\t\tcase \"a\":\n\t\tcase \"b\":\n\t\t\tSystem.out.println(\"A/B\");\n\t\t\tbreak;\n\t\tcase \"c\":\n\t\t\tSystem.out.println(\"C\");\n\t\t\tbreak;\n\t\tdefault:\n\t\t\tSystem.out.println(\"NA\");\n\t\t}\n\t}\n}"};
        String expectedProblemLog = "A/B\nA/B\nC\nNA";
        this.runConformTest(testFiles, expectedProblemLog);
    }

    public void testBug544073_024() {
        String[] testFiles = new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tbar(\"a\");\n\t\tbar(\"b\");\n\t\tbar(\"c\");\n\t\tbar(\"d\");\n\t}\n\tpublic static void bar(String s) {\n\t\tswitch(s) {\n\t\tcase \"a\", \"b\":\n\t\t\tSystem.out.println(\"A/B\");\n\t\t\tbreak;\n\t\tcase \"c\":\n\t\t\tSystem.out.println(\"C\");\n\t\t\tbreak;\n\t\tdefault:\n\t\t\tSystem.out.println(\"NA\");\n\t\t}\n\t}\n}"};
        String expectedProblemLog = "A/B\nA/B\nC\nNA";
        this.runConformTest(testFiles, expectedProblemLog);
    }

    public void testBug544073_025() {
        String[] testFiles = new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tbar(\"FB\");\n\t\tbar(\"Ea\");\n\t\tbar(\"c\");\n\t\tbar(\"D\");\n\t}\n\tpublic static void bar(String s) {\n\t\tswitch(s) {\n\t\tcase \"FB\", \"c\":\n\t\t\tSystem.out.println(\"A\");\n\t\t\tbreak;\n\t\tcase \"Ea\":\n\t\t\tSystem.out.println(\"B\");\n\t\t\tbreak;\n\t\tdefault:\n\t\t\tSystem.out.println(\"NA\");\n\t\t}\n\t}\n}"};
        String expectedProblemLog = "A\nB\nA\nNA";
        this.runConformTest(testFiles, expectedProblemLog);
    }

    public void testBug544073_026() {
        String[] testFiles = new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tbar(1);\n\t\tbar(2);\n\t\tbar(3);\n\t\tbar(4);\n\t\tbar(5);\n\t}\n\tpublic static void bar(int i) {\n\t\tswitch (i) {\n\t\tcase 1, 3: \n\t\t\tSystem.out.println(\"Odd\");\n\t\t\tbreak;\n\t\tcase 2, 4: \n\t\t\tSystem.out.println(\"Even\");\n\t\t\tbreak;\n\t\tdefault:\n\t\t\tSystem.out.println(\"Out of range\");\n\t\t}\n\t}\n}"};
        String expectedProblemLog = "Odd\nEven\nOdd\nEven\nOut of range";
        this.runConformTest(testFiles, expectedProblemLog);
    }

    public void testBug544073_027() {
        String[] testFiles = new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t}\n\tpublic static void bar(int i) {\n\t\tswitch (i) {\n\t\tcase 1, 3: \n\t\t\tSystem.out.println(\"Odd\");\n\t\t\tbreak;\n\t\tcase \"2\": \n\t\t\tSystem.out.println(\"Even\");\n\t\t\tbreak;\n\t\tdefault:\n\t\t\t\tSystem.out.println(\"Out of range\");\n\t\t}\n\t}\n}"};
        String expectedProblemLog = "----------\n1. ERROR in X.java (at line 9)\n\tcase \"2\": \n\t     ^^^\nCase constant of type String is incompatible with switch selector type int\n----------\n";
        this.runNegativeTest(testFiles, expectedProblemLog);
    }

    public void testBug544073_028() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.fallthroughCase", "warning");
        String[] testFiles = new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t}\n\tpublic static void bar(int i) {\n\t\tswitch (i) {\n\t\tcase 1, 3: \n\t\t\tSystem.out.println(\"Odd\");\n\t\tcase 2, 4: \n\t\t\tSystem.out.println(\"Even\");\n\t\t\tbreak;\n\t\tdefault:\n\t\t\t\tSystem.out.println(\"Out of range\");\n\t\t}\n\t}\n}"};
        String expectedProblemLog = "----------\n1. WARNING in X.java (at line 8)\n\tcase 2, 4: \n\t^^^^^^^^^\nSwitch case may be entered by falling through previous case. If intended, add a new comment //$FALL-THROUGH$ on the line above\n----------\n";
        this.runWarningTest(testFiles, expectedProblemLog, options, "-Xlint:fallthrough");
    }

    public void testBug544073_029() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.missingDefaultCase", "warning");
        String[] testFiles = new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t}\n\tpublic static void bar(int i) {\n\t\tswitch (i) {\n\t\tcase 1, 3: \n\t\t\tSystem.out.println(\"Odd\");\n\t\tcase 2, 4: \n\t\t\tSystem.out.println(\"Even\");\n\t\t}\n\t}\n}"};
        String expectedProblemLog = "----------\n1. WARNING in X.java (at line 5)\n\tswitch (i) {\n\t        ^\nThe switch statement should have a default case\n----------\n";
        this.runWarningTest(testFiles, expectedProblemLog, options);
    }

    public void testBug544073_030() {
        String[] testFiles = new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t}\n\tpublic static void bar(int i) {\n\t\tswitch (i) {\n\t\tcase 1, 3: \n\t\t\tSystem.out.println(\"Odd\");\n\t\tcase 3, 4: \n\t\t\tSystem.out.println(\"Odd\");\n\t\t}\n\t}\n}"};
        String expectedProblemLog = "----------\n1. ERROR in X.java (at line 8)\n\tcase 3, 4: \n\t     ^\nDuplicate case\n----------\n";
        this.runNegativeTest(testFiles, expectedProblemLog);
    }

    public void testBug544073_031() {
        String[] testFiles = new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t}\n\tpublic static void bar(String s) {\n\t\tswitch (s) {\n\t\tcase \"a\", \"b\": \n\t\t\tSystem.out.println(\"Odd\");\n\t\tcase \"b\", \"c\": \n\t\t\tSystem.out.println(\"Odd\");\n\t\t}\n\t}\n}"};
        String expectedProblemLog = "----------\n1. ERROR in X.java (at line 8)\n\tcase \"b\", \"c\": \n\t     ^^^\nDuplicate case\n----------\n";
        this.runNegativeTest(testFiles, expectedProblemLog);
    }

    public void testBug544073_032() {
        if (this.complianceLevel >= 0x410000L) {
            return;
        }
        String[] testFiles = new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t}\n\tpublic static void bar(Num s) {\n\t\tswitch (s) {\n\t\tcase ONE, Num.TWO: \n\t\t\tSystem.out.println(\"Odd\");\n\t\t}\n\t}\n}\nenum Num { ONE, TWO}\n"};
        String expectedProblemLog = "----------\n1. ERROR in X.java (at line 6)\n\tcase ONE, Num.TWO: \n\t          ^^^^^^^\nThe qualified case label Num.TWO must be replaced with the unqualified enum constant TWO\n----------\n";
        this.runNegativeTest(testFiles, expectedProblemLog);
    }

    public void testBug544073_033() {
        String[] testFiles = new String[]{"X.java", "public class X {\n\tpublic void bar(int s) {\n\t\tint j = switch (s) {\n\t\t\tcase 1, 2, 3 -> (s+1);\n\t\t\tdefault -> j;\n\t\t};\n\t}\n}\n"};
        String expectedProblemLog = "----------\n1. ERROR in X.java (at line 5)\n\tdefault -> j;\n\t           ^\nThe local variable j may not have been initialized\n----------\n";
        this.runNegativeTest(testFiles, expectedProblemLog);
    }

    public void testBug544073_034() {
        String[] testFiles = new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t}\n\tpublic void bar(int s) {\n\t\tint j = 0;\t\tj = switch (s) {\n\t\t\tcase 1, 2, 3 -> (s+1);\n\t\t\tdefault -> j;\n\t\t};\n\t}\n}\n"};
        this.runConformTest(testFiles, "");
    }

    public void testBug544073_035() {
        this.runNegativeTest(new String[]{"X.java", "import java.io.IOException;\n\npublic class X {\n\tpublic static int foo(int i) throws IOException {\n\t\tint t = switch (i) {\n\t\tcase 0 : {\n\t\t\tyield 0;\n\t\t}\n\t\tcase 2 : {\n\t\t\tbreak;\n\t\t}\n\t\tdefault : yield 10;\n\t\t};\n\t\treturn t;\n\t}\n\t\n\tpublic boolean bar() {\n\t\treturn true;\n\t}\n\tpublic static void main(String[] args) {\n\t\ttry {\n\t\t\tSystem.out.println(foo(3));\n\t\t} catch (IOException e) {\n\t\t\t// TODO Auto-generated catch block\n\t\t\te.printStackTrace();\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 10)\n\tbreak;\n\t^^^^^^\nBreaking out of switch expressions not permitted\n----------\n");
    }

    public void testBug544073_036() {
        String[] testFiles = new String[]{"X.java", "public class X {\n\n\tpublic static void bar(int  i) {\n\t\ti = switch (i+0) {\n\t\t\tdefault: System.out.println(0);\n\t\t}; \t}\n}"};
        String expectedProblemLog = "----------\n1. ERROR in X.java (at line 4)\n\ti = switch (i+0) {\n\t\t\tdefault: System.out.println(0);\n\t\t}; \t}\n\t    ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nA switch expression should have at least one result expression\n----------\n";
        this.runNegativeTest(testFiles, expectedProblemLog);
    }

    public void testBug544073_037() {
        String[] testFiles = new String[]{"X.java", "public class X {\n\tvoid test(int i) {\n\t\tneed(switch (i) {\n\t\t\tcase 1 -> \"\";\n\t\t\tdefault -> i == 3 ? null : \"\";\n\t\t}); \n\t}\n\tvoid need(String s) {\n\t\tSystem.out.println(s.toLowerCase());\n\t}\n\tpublic static void main(String[] args) {\n\t\tnew X().need(\"Hello World\");\n\t}\n}\n"};
        String expectedOutput = "hello world";
        this.runConformTest(testFiles, expectedOutput);
    }

    public void testBug544073_038() {
        String[] testFiles = new String[]{"X.java", "public class X {\n\tvoid test(int i) {\n\t\tneed(switch (i) {\n\t\t\tcase 1: yield \"\";\n\t\t\tdefault: yield i == 3 ? null : \"\";\n\t\t}); \n\t}\n\tvoid need(String s) {\n\t\tSystem.out.println(s.toLowerCase());\n\t}\n\tpublic static void main(String[] args) {\n\t\tnew X().need(\"Hello World\");\n\t}\n}\n"};
        String expectedOutput = "hello world";
        this.runConformTest(testFiles, expectedOutput);
    }

    public void testBug544073_039() {
        String[] testFiles = new String[]{"X.java", "interface I0 { void i(); }\ninterface I1 extends I0 {}\ninterface I2 extends I0 {}\npublic class X {\n\tI1 n1() { return null; }\n\t<I extends I2> I n2() { return null; }\n\t<M> M m(M m) { return m; }\n\tvoid test(int i, boolean b) {\n\t\tm(switch (i) {\n\t\t\tcase 1 -> n1();\n\t\t\tdefault -> b ? n1() : n2();\n\t\t}).i(); \n\t}\n\tpublic static void main(String[] args) {\n\t\ttry {\n\t\t\tnew X().test(1, true);\n\t\t} catch (NullPointerException e) {\n\t\t\tSystem.out.println(\"NPE as expected\");\n\t\t}\n\t}\n}\n"};
        String expectedOutput = "NPE as expected";
        this.runConformTest(testFiles, expectedOutput);
    }

    public void testBug544073_040() {
        String[] testFiles = new String[]{"X.java", "import java.util.function.Supplier;\ninterface I0 { void i(); }\ninterface I1 extends I0 {}\ninterface I2 extends I0 {}\npublic class X {\n\tI1 n1() { return null; }\n\t<I extends I2> I n2() { return null; }\n\t<M> M m(Supplier<M> m) { return m.get(); }\n\tvoid test(int i, boolean b) {\n\t\tm(switch (i) {\n\t\t\tcase 1 -> this::n1;\n\t\t\tdefault -> this::n2;\n\t\t}).i(); \n\t}\n\tpublic static void main(String[] args) {\n\t\ttry {\n\t\t\tnew X().test(1, true);\n\t\t} catch (NullPointerException e) {\n\t\t\tSystem.out.println(\"NPE as expected\");\n\t\t}\n\t}\n}\n"};
        String expectedOutput = "NPE as expected";
        this.runConformTest(testFiles, expectedOutput);
    }

    public void testBug544073_041() {
        String[] testFiles = new String[]{"X.java", "public class X {\n\t\tvoid test(int i) {\n\t\tneed(switch (i) {\n\t\t\tcase 1 -> 1.0f;\n\t\t\tdefault -> i == 3 ? 3 : 5.0d;\n\t\t}); \n\t}\n\t<N extends Number> void need(N s) {\n\t\tSystem.out.println(s.toString());\n\t}\n\tpublic static void main(String[] args) {\n\t\tnew X().need(3);\n\t}\n}\n"};
        String expectedOutput = "3";
        this.runConformTest(testFiles, expectedOutput);
    }

    public void testBug544073_042() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tstatic int twice(int i) throws Exception {\n\t\tswitch (i) {\n\t\t\tcase 0 -> System.out.println(\"hellow\");\n\t\t\tcase 1 -> foo();\n\t\t\tdefault -> throw new Exception();\n\t\t};\n\t\treturn 0;\n\t}\n\n\tstatic int foo() {\n\t\tSystem.out.println(\"inside foo\");\n\t\treturn 1;\n\t}\n\n\tpublic static void main(String[] args) {\n\t\ttry {\n\t\t\tSystem.out.print(twice(1));\n\t\t} catch (Exception e) {\n\t\t\tSystem.out.print(\"Got Exception\");\n\t\t}\n\t}\n}"}, "inside foo\n0");
    }

    public void testBug544073_043() {
        this.runConformTest(new String[]{"X.java", "enum SomeDays {\n\tMon, Wed, Fri\n}\n\npublic class X {\n\tint testEnum(boolean b) {\n\t\tSomeDays day = b ? SomeDays.Mon : null;\n\t\treturn switch(day) {\n\t\t\tcase Mon -> 1;\n\t\t\tcase Wed -> 2;\n\t\t\tcase Fri -> 3;\n\t\t};\n\t}\n\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(new X().testEnum(true));\n\t}\n}\n"}, "1");
    }

    public void testBug544073_044() {
        String[] testFiles = new String[]{"X.java", "public class X {\n\tstatic int foo(int i) {\n\t\tswitch (i) {\n\t\t\tdefault -> 3; // should flag an error\n\t\t\t\n\t\t};\n\t\treturn 0;\n\t}\n\tpublic static void main(String[] args) {\n\t\tfoo(1);\n\t}\n}\n"};
        String expectedProblemLog = "----------\n1. ERROR in X.java (at line 4)\n\tdefault -> 3; // should flag an error\n\t           ^\nInvalid expression as statement\n----------\n";
        this.runNegativeTest(testFiles, expectedProblemLog);
    }

    public void testBug544073_045() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic void foo(int i) {\n\t\tint j = switch (i) {\n\t\t\tcase 1 -> i;\n\t\t\tdefault -> i;\n\t\t};\n\t\tSystem.out.println(j);\n\t}\n\t\n\tpublic static void main(String[] args) {\n\t\tnew X().foo(1);\n\t}\n}"}, "1");
    }

    public void testBug544073_046() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic void foo(int i) {\n\t\tlong j = switch (i) {\n\t\t\tcase 1 -> 10L;\n\t\t\tdefault -> 20L;\n\t\t};\n\t\tSystem.out.println(j);\n\t}\n\t\n\tpublic static void main(String[] args) {\n\t\tnew X().foo(1);\n\t}\n}"}, "10");
    }

    public void testBug544073_047() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic int foo(String s) throws Exception {\n\t\tint i = switch (s) {\n\t\t\tcase \"hello\" -> 1;\n\t\t\tdefault -> throw new Exception();\n\t\t};\n\t\treturn i;\n\t}\n\n\tpublic static void main(String[] argv) {\n\t\ttry {\n\t\t\tSystem.out.print(new X().foo(\"hello\"));\n\t\t} catch (Exception e) {\n\t\t\t//\n\t\t}\n\t}\n}"}, "1");
    }

    public void testBug544073_048() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    public void foo(Day day) {\n    \tvar today = 1;\n    \ttoday =  switch (day) {\n    \t\t      case SATURDAY,SUNDAY :\n    \t\t         today=1;\n    \t\t         yield today;\n    \t\t      case MONDAY,TUESDAY,WEDNESDAY,THURSDAY :\n    \t\t\t today=2;\n    \t\t\t yield today;\n    \t\t};\n    }\n    public static void main(String argv[]) {\n    \tnew X().foo(Day.FRIDAY);\n    }\n}\n\nenum Day {\n\tSUNDAY,\n\tMONDAY,\n\tTUESDAY,\n\tWEDNESDAY,\n\tTHURSDAY,\n\tFRIDAY,\n\tSATURDAY\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\ttoday =  switch (day) {\n\t                 ^^^\nA Switch expression should cover all possible values\n----------\n");
    }

    public void testBug544073_049() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public void foo(int i ) {\n        boolean b = switch (i) {\n            case 0 -> i == 1;\n            default -> true;\n        };\n        System.out.println( b ? \" true\" : \"false\");\n    }\n    public static void main(String[] argv) {\n    \tnew X().foo(0);\n    }\n}"}, "false");
    }

    public void testBug544073_050() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public void foo(String s) {\n        try {\n            int i = switch (s) {\n                case \"hello\" -> 0;\n                default -> 2;\n            };\n        } finally {\n        \tSystem.out.println(s);\n        }\n    }\n    public static void main(String argv[]) {\n    \tnew X().foo(\"hello\");\n    }\n}"}, "hello");
    }

    public void testBug544073_051() {
        Map<String, String> customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", "optimize out");
        this.runConformTest(new String[]{"X.java", "public class X {\n    public void foo(String s) {\n        try {\n            int i = switch (s) {\n                case \"hello\" -> 0;\n                default -> 2;\n            };\n        } finally {\n        \tSystem.out.println(s);\n        }\n    }\n    public static void main(String argv[]) {\n    \tnew X().foo(\"hello\");\n    }\n}"}, "hello");
    }

    public void testBug544073_052() {
        Map<String, String> customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", "optimize out");
        this.runConformTest(new String[]{"X.java", "public class X {\n    public void foo(String s) {\n        try {\n            long l = switch (s) {\n                case \"hello\" -> 0;\n                default -> 2;\n            };\n        } finally {\n        \tSystem.out.println(s);\n        }\n    }\n    public static void main(String argv[]) {\n    \tnew X().foo(\"hello\");\n    }\n}"}, "hello");
    }

    public void testBug544073_053() {
        Map<String, String> customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", "optimize out");
        this.runConformTest(new String[]{"X.java", "public class X {\n    public int foo(int i)  {\n        int j = (switch (i) {\n            case 1 -> 1;\n            default -> 2;\n        });\n        return j;\n    }\n    public static void main(String[] argv) {\n    \tnew X().foo(1);\n    }\n}\n"}, "", (Map)customOptions);
    }

    public void testBug544073_054() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tenum MyEnum {\n\t\tFIRST;\n\t}\n\n\tpublic void foo(MyEnum myEnum) {\n\t\tint i = switch (myEnum) {\n\t\t\tcase FIRST ->  1;\n\t\t};\n\t\t\tSystem.out.println( \"i:\" + i);\n\t}\n\n\tpublic static void main(String argv[]) {\n\t\tnew X().foo(MyEnum.FIRST);\n\t}\n}"}, "i:1");
    }

    public void testBug544073_055() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tenum MyEnum {\n\t\tFIRST;\n\t}\n\n\tpublic void foo(MyEnum myEnum) {\n\t\tint i = switch (myEnum) {\n\t\t\tcase FIRST ->  1;\n\t\t\tdefault ->  0;\n\t\t};\n\t\t\tSystem.out.println( \"i:\" + i);\n\t}\n\n\tpublic static void main(String argv[]) {\n\t\tnew X().foo(MyEnum.FIRST);\n\t}\n}"}, "i:1");
    }

    public void testBug544073_056() {
        String[] testFiles = new String[]{"X.java", "public class X {\n    public int foo(int i) {\n    \tvar v = switch(i) {\n    \tcase 0 -> x;\n    \tdefault -> 1;\n    \t};\n    \treturn v;\n    }\n    public static void main(String[] argv) {\n       System.out.println(new X().foo(0));\n    }\n}"};
        String expectedProblemLog = "----------\n1. ERROR in X.java (at line 4)\n\tcase 0 -> x;\n\t          ^\nx cannot be resolved to a variable\n----------\n2. ERROR in X.java (at line 7)\n\treturn v;\n\t       ^\nType mismatch: cannot convert from Object to int\n----------\n";
        this.runNegativeTest(testFiles, expectedProblemLog);
    }

    public void testBug544073_057() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic int foo(int i) {\n    \tint v = switch(i) {\n    \tcase 0 -> switch(i) {\n    \t\t\tcase 0 -> 0;\n    \t\t\tdefault -> 1;\n    \t\t};\n    \tdefault -> 1;\n    \t};\n    \treturn v;\n    }\n    public static void main(String[] argv) {\n       System.out.println(new X().foo(0));\n    }\n}"}, "0");
    }

    public void testBug544073_058() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public int foo(int i) {\n    \tint v = switch(switch(i) {\n        \t\tdefault -> 1;\n        \t\t}) {\n        \tdefault -> 1;\n        };\n       return v;\n    }\n\n    public static void main(String[] argv) {\n       System.out.println(new X().foo(0));\n    }\n}\n"}, "1");
    }

    public void testBug544073_059() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static int foo(int i) {\n\t\tboolean v = switch (i) {\n\t\t\tcase 1: i = 10; yield true;\n\t\t\tdefault: yield false;\n\t\t};\n\t\treturn v ? 0 : 1;\n\t}\n\tpublic static void main(String[] argv) {\n\t\tSystem.out.println(X.foo(0));\n\t}\n}"}, "1");
    }

    public void testBug544073_060() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static int foo(int i) {\n\t\tboolean v = switch (i) {\n\t\t\tcase 1: i++; yield true;\n\t\t\tdefault: yield false;\n\t\t};\n\t\treturn v ? 0 : 1;\n\t}\n\tpublic static void main(String[] argv) {\n\t\tSystem.out.println(X.foo(1));\n\t}\n}"}, "0");
    }

    public void testBug544073_061() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static int foo(int i) {\n\t\tboolean v = switch (i) {\n\t\t\tcase 1: i+= 10; yield true;\n\t\t\tdefault: yield false;\n\t\t};\n\t\treturn v ? 0 : 1;\n\t}\n\tpublic static void main(String[] argv) {\n\t\tSystem.out.println(X.foo(1));\n\t}\n}"}, "0");
    }

    public void testBug544073_062() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static int foo(int i) {\n\t\tboolean v = switch (i) {\n\t\t\tcase 1: switch(i) {case 4: break;}; yield true;\n\t\t\tdefault: yield false;\n\t\t};\n\t\treturn v ? 0 : 1;\n\t}\n\tpublic static void main(String[] argv) {\n\t\tSystem.out.println(X.foo(1));\n\t}\n}"}, "0");
    }

    public void testBug544073_063() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static int foo(int i) {\n\t\tboolean v = switch (i) {\n\t\t\tcase 1: foo(5); yield true;\n\t\t\tdefault: yield false;\n\t\t};\n\t\treturn v ? 0 : 1;\n\t}\n\tpublic static void main(String[] argv) {\n\t\tSystem.out.println(X.foo(1));\n\t}\n}"}, "0");
    }

    public void testBug544073_064() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public int foo(int i) {\n\tboolean v = switch (i) {\n        case 1:\n        \tswitch (i) {\n        \t\tcase 1 : i = 10;\n        \t\t\tbreak;\n        \t\tdefault :\n        \t\t\ti = 2;\n        \t\t\tbreak;\n        \t\t}\n        yield true;\n        default: yield false;\n    };\n    return v ? 0 : 1;\n    }\n\n    public static void main(String[] argv) {\n       System.out.println(new X().foo(0));\n    }\n}\n"}, "1");
    }

    public void testBug544073_065() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic int foo(int i) {\n\t\tint v =\n\t\t\tswitch(switch(i) {\n\t\t\t\t\tcase 0 -> { yield 2; }\n\t\t\t\t\tdefault -> { yield 3; }\n\t\t\t\t}) {\n\t\t\tcase 0 -> { yield 0; }\n\t\t\tdefault -> { yield 1; }\n\t\t};\n\treturn v == 1 ? v : 0;\n\t}\n\tpublic static void main(String[] argv) {\n\t\tSystem.out.println(new X().foo(0));\n\t}\n}"}, "1");
    }

    public void testBug544073_066() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic int foo(int i) {\n    \tint k = 10;\n    \tswitch (i) {\n    \t\tcase 0 -> { k = 0;}\n    \t\tdefault -> k = -1;\n    \t}\n        return k;\n    }\n    public static void main(String[] argv) {\n        System.out.println(new X().foo(0) == 0 ? \"Success\" : \"Failure\");\n    }\n\n}\n"}, "Success");
    }

    public void testBug544073_067() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void foo(Day day) {\n\t\tswitch (day) {\n\t\tcase MONDAY, FRIDAY -> System.out.println(Day.SUNDAY);\n\t\tcase TUESDAY                -> System.out.println(7);\n\t\tcase THURSDAY, SATURDAY     -> System.out.println(8);\n\t\tcase WEDNESDAY              -> System.out.println(9);\n\t\tdefault -> {}\n\t\t}     \n\t}\n\tpublic static void main(String[] args) {\n\t\tX.foo(Day.WEDNESDAY);\n\t}\n}\n\nenum Day {\n\tMONDAY, TUESDAY, WEDNESDAY, THURSDAY, FRIDAY, SATURDAY, SUNDAY;\n}\n"}, "9");
    }

    public void testBug544073_068() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void foo (int i) {\n\t\tint v = switch (i) {\n\t\t\tcase 60, 600: yield 6;\n\t\t\tcase 70: yield 7;\n\t\t\tcase 80: yield 8;\n\t\t\tcase 90, 900: yield 9;\n\t\t\tdefault: yield 0;\n\t\t};\n\t\tSystem.out.println(v);\n\t}\n\tpublic static void main(String[] args) {\n\t\tX.foo(10);\n\t}\n}\n"}, "0");
    }

    public void testBug513766_01() {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.testFiles = new String[]{"X.java", "public class X {\n\n    public void foo(int i) {\n    \tif (switch(i) { default -> magic(); })\n            System.out.println(\"true\");\n        if (magic())\n            System.out.println(\"true, too\");\n    }\n    <T> T magic() { return null; }\n}\n"};
        runner.expectedCompilerLog = "----------\n1. ERROR in X.java (at line 4)\n\tif (switch(i) { default -> magic(); })\n\t    ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from Object to boolean\n----------\n2. ERROR in X.java (at line 6)\n\tif (magic())\n\t    ^^^^^^^\nType mismatch: cannot convert from Object to boolean\n----------\n";
        runner.javacTestOptions = AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacBug8179483_switchExpression;
        runner.runNegativeTest();
    }

    public void testBug544073_070() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\n\tpublic static int foo(int i) throws MyException {\n    \tint v = switch (i) {\n    \t\tdefault -> throw new MyException();\n    \t};\n        return v;\n    }\n    public static void main(String argv[]) {\n    \ttry {\n\t\t\tSystem.out.println(X.foo(1));\n\t\t} catch (MyException e) {\n\t\t\tSystem.out.println(\"Exception thrown as expected\");\n\t\t}\n\t}\n}\nclass MyException extends Exception {\n\tprivate static final long serialVersionUID = 3461899582505930473L;\t\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tint v = switch (i) {\n    \t\tdefault -> throw new MyException();\n    \t};\n\t        ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nA switch expression should have at least one result expression\n----------\n");
    }

    public void testBug544073_071() {
        String message = "----------\n1. WARNING in X.java (at line 5)\n\tcase \"ABC\", (false ? (String) \"c\" : (String) \"d\") : break;\n\t                     ^^^^^^^^^^^^\nDead code\n----------\n";
        this.runWarningTest(new String[]{"X.java", "public class X {\n  public static void main(String [] args) {\n  \t String arg = \"ABD\";\n    switch(arg) {\n      case \"ABC\", (false ? (String) \"c\" : (String) \"d\") : break;\n\t }\n  }\n}\n"}, message, this.getCompilerOptions(), "-Xlint:preview");
    }

    public void testBug544073_072() {
        String message = "----------\n1. WARNING in X.java (at line 5)\n\tcase \"ABC\", (false ? (String) \"c\" : (String) \"d\") : break;\n\t                     ^^^^^^^^^^^^\nDead code\n----------\n";
        this.runWarningTest(new String[]{"X.java", "public class X {\n  public static void main(String [] args) {\n  \t String arg = \"ABD\";\n    switch(arg) {\n      case \"ABC\", (false ? (String) \"c\" : (String) \"d\") : break;\n\t }\n  }\n}\n"}, message);
    }

    public void testBug544073_074() {
        this.runConformTest(new String[]{"X.java", "public enum X {\n    A, B; \n    public static void main(String[] args) {\n         X myEnum = X.A;\n         int o;\n         switch(myEnum) {\n             case A -> o = 5;\n             case B -> o = 10;\n             default -> o = 0;\n         }\n         System.out.println(o);\n     }\n}\n"}, "5");
    }

    public void testBug544073_075() {
        this.runConformTest(new String[]{"X.java", "public enum X {\n    A, B;\n     \n    public static void main(String[] args) {\n         X myEnum = X.A;\n         int o;\n         var f = switch(myEnum) {\n             case A -> o = 5;\n             case B -> o = 10;\n         };\n         System.out.println(o);\n     }\n} \n"}, "5");
    }

    public void testBug544073_076() {
        this.runNegativeTest(new String[]{"X.java", "\npublic class X {\n\n\n\tpublic static int foo() {\n\tfor (int i = 0; i < 1; ++i) {\n\t\t\tint k = switch (i) {\n\t\t\t\tcase 0:\n\t\t\t\t\tyield 1;\n\t\t\t\tdefault:\n\t\t\t\t\tcontinue;\n\t\t\t};\n\t\t\tSystem.out.println(k);\n\t\t}\n\t\treturn 1;\n\t}\n\tpublic static void main(String[] args) {\n\t\tX.foo();\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 11)\n\tcontinue;\n\t^^^^^^^^^\nContinue out of switch expressions not permitted\n----------\n2. ERROR in X.java (at line 11)\n\tcontinue;\n\t       ^^\nA switch labeled block in a switch expression must yield a value or throw an an exception\n----------\n");
    }

    public void testBug544073_077() {
        this.runNegativeTest(new String[]{"X.java", "\npublic class X {\n\n\n\tpublic static int foo() {\n\tfor (int i = 0; i < 1; ++i) {\n\t\t\tint k = switch (i) {\n\t\t\t\tcase 0:\n\t\t\t\t\tyield 1;\n\t\t\t\tdefault:\n\t\t\t\t\treturn 2;\n\t\t\t};\n\t\t\tSystem.out.println(k);\n\t\t}\n\t\treturn 100;\n\t}\n\tpublic static void main(String[] args) {\n\t\tX.foo();\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 11)\n\treturn 2;\n\t^^^^^^^^^\nReturn within switch expressions not permitted\n----------\n");
    }

    public void testBug544073_078() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo(Day day) {\n\t\tswitch (day) {\n\t\tcase SATURDAY, SUNDAY, SUNDAY:\n\t\t\tSystem.out.println(\"Weekend\");\n\t\tcase MONDAY:\n\t\t\tSystem.out.println(\"Weekday\");\n\t\tdefault: \n\t\t}\n\t}\n}\n\nenum Day {\n\tMONDAY, TUESDAY, WEDNESDAY, THURSDAY, FRIDAY, SATURDAY, SUNDAY;\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\tcase SATURDAY, SUNDAY, SUNDAY:\n\t                       ^^^^^^\nDuplicate case\n----------\n");
    }

    public void testBug544073_079() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo(Day day) {\n\t\tswitch (day) {\n\t\tcase SATURDAY, SUNDAY, MONDAY:\n\t\t\tSystem.out.println(\"Weekend\");\n\t\tcase MONDAY, SUNDAY:\n\t\t\tSystem.out.println(\"Weekday\");\n\t\tdefault: \n\t\t}\n\t}\n}\n\nenum Day {\n\tMONDAY, TUESDAY, WEDNESDAY, THURSDAY, FRIDAY, SATURDAY, SUNDAY;\n}"}, "----------\n1. ERROR in X.java (at line 6)\n\tcase MONDAY, SUNDAY:\n\t     ^^^^^^\nDuplicate case\n----------\n2. ERROR in X.java (at line 6)\n\tcase MONDAY, SUNDAY:\n\t             ^^^^^^\nDuplicate case\n----------\n");
    }

    public void testBug544073_80() {
        this.runConformTest(new String[]{"X.java", "\npublic class X {\n\n\tpublic static int yield() {\n\t\treturn 1;\n\t}\n\tpublic static int foo(int val) {\n\t\treturn bar (switch (val) {\n\t\tcase 1 : { yield val == 1 ? 2 : 3; }\n\t\tdefault : { yield 2; }\n\t\t});\n\t}\n\tpublic static int bar(int val) {\n\t\treturn val;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(X.foo(1));\n\t}\n}\n"}, "2");
    }

    public void testBug544073_81() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\n\n\tpublic static int foo(int val) {\n\t\tint k = switch (val) {\n\t\tcase 1 : { break 1; }\n\t\tdefault : { break 2; }\n\t\t};\n\t\treturn k;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(X.foo(1));\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tcase 1 : { break 1; }\n\t                 ^\nSyntax error on token \"1\", delete this token\n----------\n2. ERROR in X.java (at line 7)\n\tdefault : { break 2; }\n\t                  ^\nSyntax error on token \"2\", delete this token\n----------\n");
    }

    public void testIssue2323() {
        if (this.complianceLevel < 0x3A0000L) {
            return;
        }
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void f() {\n\t\tint[] array = null;\n\t\t(array = new int[1])[0] = 42;\n\t}\n\tpublic static int g() {\n\t\tint[] array = null;\n\t\tSystem.out.println(switch(10) {\n\t\tdefault -> {\n\t\t\ttry {\n\t\t\t\tyield 42;\n\t\t\t} finally {\n\n\t\t\t}\n\t\t}\n\t});\n\t\treturn (array = new int[1])[0];\n\t}\n}\n"}, "");
    }

    public void testBug547891_01() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void yield() {}\n\tpublic static void main(String[] args) {\n\t\tyield();\n\t\tX.yield();\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tyield();\n\t^^^^^^^\nrestricted identifier yield not allowed here - method calls need to be qualified\n----------\n");
    }

    public void testBug547891_02() {
        String[] testFiles = new String[]{"X.java", "public class X {\n\tpublic static void yield() {}\n\tpublic static void main(String[] args) {\n\t\tyield();\n\t}\n\tpublic static void bar() {\n\t\tZork();\n\t}\n}\n"};
        String expectedProblemLog = "----------\n1. ERROR in X.java (at line 4)\n\tyield();\n\t^^^^^^^\nrestricted identifier yield not allowed here - method calls need to be qualified\n----------\n2. ERROR in X.java (at line 7)\n\tZork();\n\t^^^^\nThe method Zork() is undefined for the type X\n----------\n";
        this.runNegativeTest(testFiles, expectedProblemLog);
    }

    public void testBug547891_03() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tyield 1;\n\t}\n}\nclass yield {\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tyield 1;\n\t^^^^^\nSyntax error on token \"yield\", AssignmentOperator expected after this token\n----------\n2. ERROR in X.java (at line 6)\n\tclass yield {\n\t      ^^^^^\n'yield' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 14\n----------\n");
    }

    public void testBug547891_04() {
        String[] testFiles = new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tyield 1;\n\t\tZork();\n\t}\n}\nclass yield {\n}\n"};
        String expectedProblemLog = "----------\n1. ERROR in X.java (at line 3)\n\tyield 1;\n\t^^^^^\nSyntax error on token \"yield\", AssignmentOperator expected after this token\n----------\n2. ERROR in X.java (at line 7)\n\tclass yield {\n\t      ^^^^^\n'yield' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 14\n----------\n";
        this.runNegativeTest(testFiles, expectedProblemLog);
    }

    public void testBug547891_05() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tyield y;\n\t}\n}\nclass yield {\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tyield y;\n\t^^^^^\n'yield' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 14\n----------\n2. ERROR in X.java (at line 6)\n\tclass yield {\n\t      ^^^^^\n'yield' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 14\n----------\n");
    }

    public void testBug547891_06() {
        String[] testFiles = new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tyield y;\n\t\tZork();\n\t}\n}\nclass yield {\n}\n"};
        String expectedProblemLog = "----------\n1. ERROR in X.java (at line 3)\n\tyield y;\n\t^^^^^\n'yield' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 14\n----------\n2. ERROR in X.java (at line 4)\n\tZork();\n\t^^^^\nThe method Zork() is undefined for the type X\n----------\n3. ERROR in X.java (at line 7)\n\tclass yield {\n\t      ^^^^^\n'yield' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 14\n----------\n";
        this.runNegativeTest(testFiles, expectedProblemLog);
    }

    public void testBug547891_07() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tyield y = null;\n\t}\n}\nclass yield {\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tyield y = null;\n\t^^^^^\n'yield' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 14\n----------\n2. ERROR in X.java (at line 6)\n\tclass yield {\n\t      ^^^^^\n'yield' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 14\n----------\n");
    }

    public void testBug547891_08() {
        String[] testFiles = new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tyield y = null;\n\t\tZork();\n\t}\n}\nclass yield {\n}\n"};
        String expectedProblemLog = "----------\n1. ERROR in X.java (at line 3)\n\tyield y = null;\n\t^^^^^\n'yield' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 14\n----------\n2. ERROR in X.java (at line 4)\n\tZork();\n\t^^^^\nThe method Zork() is undefined for the type X\n----------\n3. ERROR in X.java (at line 7)\n\tclass yield {\n\t      ^^^^^\n'yield' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 14\n----------\n";
        this.runNegativeTest(testFiles, expectedProblemLog);
    }

    public void testBug547891_09() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t}\n}\nclass yield {\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tclass yield {\n\t      ^^^^^\n'yield' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 14\n----------\n");
    }

    public void testBug547891_10() {
        String[] testFiles = new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tZork();\n\t}\n}\nclass yield {\n}\n"};
        String expectedProblemLog = "----------\n1. ERROR in X.java (at line 3)\n\tZork();\n\t^^^^\nThe method Zork() is undefined for the type X\n----------\n2. ERROR in X.java (at line 6)\n\tclass yield {\n\t      ^^^^^\n'yield' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 14\n----------\n";
        this.runNegativeTest(testFiles, expectedProblemLog);
    }

    public void testBug547891_11() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tnew yield();\n\t}\n}\nclass yield {\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tnew yield();\n\t    ^^^^^\n'yield' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 14\n----------\n2. ERROR in X.java (at line 6)\n\tclass yield {\n\t      ^^^^^\n'yield' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 14\n----------\n");
    }

    public void testBug547891_12() {
        String[] testFiles = new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tnew yield();\n\t\tZork();\n\t}\n}\nclass yield {\n}\n"};
        String expectedProblemLog = "----------\n1. ERROR in X.java (at line 3)\n\tnew yield();\n\t    ^^^^^\n'yield' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 14\n----------\n2. ERROR in X.java (at line 4)\n\tZork();\n\t^^^^\nThe method Zork() is undefined for the type X\n----------\n3. ERROR in X.java (at line 7)\n\tclass yield {\n\t      ^^^^^\n'yield' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 14\n----------\n";
        this.runNegativeTest(testFiles, expectedProblemLog);
    }

    public void testBug547891_13() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tyield[] y;\n\t}\n}\nclass yield {\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tyield[] y;\n\t^^^^^^^\n'yield' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 14\n----------\n2. ERROR in X.java (at line 6)\n\tclass yield {\n\t      ^^^^^\n'yield' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 14\n----------\n");
    }

    public void testBug547891_14() {
        String[] testFiles = new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tyield[] y;\n\t\tZork();\n\t}\n}\nclass yield {\n}\n"};
        String expectedProblemLog = "----------\n1. ERROR in X.java (at line 3)\n\tyield[] y;\n\t^^^^^^^\n'yield' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 14\n----------\n2. ERROR in X.java (at line 4)\n\tZork();\n\t^^^^\nThe method Zork() is undefined for the type X\n----------\n3. ERROR in X.java (at line 7)\n\tclass yield {\n\t      ^^^^^\n'yield' is not a valid type name; it is a restricted identifier and not allowed as a type identifier in Java 14\n----------\n";
        this.runNegativeTest(testFiles, expectedProblemLog);
    }

    public void testBug547891_15() {
        String message = "----------\n1. ERROR in X.java (at line 6)\n\tcase 1 -> yield();\n\t          ^^^^^^^\nrestricted identifier yield not allowed here - method calls need to be qualified\n----------\n2. ERROR in X.java (at line 8)\n\tcase 3 -> {yield yield();}\n\t                 ^^^^^^^\nrestricted identifier yield not allowed here - method calls need to be qualified\n----------\n3. ERROR in X.java (at line 10)\n\tdefault -> { yield yield();}\n\t                   ^^^^^^^\nrestricted identifier yield not allowed here - method calls need to be qualified\n----------\n";
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\n\t\n\tpublic static int foo(int i) {\n\t\tint r = switch(i) {\n\t\t\tcase 1 -> yield();\n\t\t\tcase 2 -> X.yield();\n\t\t\tcase 3 -> {yield yield();}\n\t\t\tcase 4 -> {yield X.yield();}\n\t\t\tdefault -> { yield yield();}\n\t\t};\n\t\treturn r;\n\t}\n\tpublic static int yield() {\n\t\treturn 0;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(X.foo(0));\n\t}\n}\n"}, message);
    }

    public void testBug547891_16() {
        String message = "----------\n1. ERROR in X.java (at line 9)\n\tcase 3 -> {yield yield();}\n\t                 ^^^^^^^\nrestricted identifier yield not allowed here - method calls need to be qualified\n----------\n2. ERROR in X.java (at line 11)\n\tdefault -> { yield yield();}\n\t                   ^^^^^^^\nrestricted identifier yield not allowed here - method calls need to be qualified\n----------\n";
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\n\t\n\tpublic  int foo(int i) {\n\t\tX x = new X();\n\t\tint r = switch(i) {\n\t\t\tcase 1 -> this.yield();\n\t\t\tcase 2 -> x.new Y().yield();\n\t\t\tcase 3 -> {yield yield();}\n\t\t\tcase 4 -> {yield new X().yield() + x.new Y().yield();}\n\t\t\tdefault -> { yield yield();}\n\t\t};\n\t\treturn r;\n\t}\n\tpublic  int yield() {\n\t\treturn 0;\n\t}\n\tclass Y {\n\t\tpublic  int yield() {\n\t\t\treturn 0;\n\t\t}\t\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(new X().foo(0));\n\t}\n}\n"}, message);
    }

    public void testBug547891_17() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\n\t\n\tpublic  static int foo(int i) {\n\t\tint yield = 100;\n\t\tint r = switch(i) {\n\t\t\tdefault -> yield - 1;\n\t\t};\n\t\treturn r;\n\t}\n\tpublic  int yield() {\n\t\treturn 0;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(X.foo(0));\n\t}\n}"}, "99");
    }

    public void testBug547891_18() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\n\t\n\tpublic  static int foo(int i) {\n\t\tint yield = 100;\n\t\tint r = switch(i) {\n\t\t\tdefault -> {yield - 1;}\n\t\t};\n\t\treturn r;\n\t}\n\tpublic  int yield() {\n\t\treturn 0;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(X.foo(0));\n\t}\n}"}, "-1");
    }

    public void testBug547891_19() {
        this.runConformTest(new String[]{"X.java", "public class X {\n   static int yield = 100;\n\n\t\n\tpublic  static int foo(int i) {\n\t\tint r = switch(i) {\n\t\t\tdefault -> yield - 1;\n\t\t};\n\t\treturn r;\n\t}\n\tpublic  int yield() {\n\t\treturn 0;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(X.foo(0));\n\t}\n}"}, "99");
    }

    public void testBug547891_20() {
        this.runConformTest(new String[]{"X.java", "public class X {\n   static int yield = 100;\n\n\t\n\tpublic  static int foo(int i) {\n\t\tint r = switch(i) {\n\t\t\tdefault -> {yield - 1;}\n\t\t};\n\t\treturn r;\n\t}\n\tpublic  int yield() {\n\t\treturn 0;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(X.foo(0));\n\t}\n}"}, "-1");
    }

    public void testBug547891_21() {
        String message = "----------\n1. ERROR in X.java (at line 7)\n\tdefault -> yield - 1;\n\t           ^^^^^\nCannot make a static reference to the non-static field yield\n----------\n";
        this.runNegativeTest(new String[]{"X.java", "public class X {\n   int yield = 100;\n\n\t\n\tpublic  static int foo(int i) {\n\t\tint r = switch(i) {\n\t\t\tdefault -> yield - 1;\n\t\t};\n\t\treturn r;\n\t}\n\tpublic  int yield() {\n\t\treturn 0;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(X.foo(0));\n\t}\n}"}, message);
    }

    public void testBug547891_22() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\n\tstatic int yield = 100;\n\t\n\tpublic  static int foo(int i) {\n\tint r = switch(i) {\n\t\t\tdefault -> X.yield();\n\t\t};\n\t\treturn r;\n\t}\n\tpublic static  int yield() {\n\t\tyield: while (X.yield == 100) {\n\t\t\tyield = 256;\n\t\t\tbreak yield;\n\t\t}\n\t\treturn yield;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(X.foo(0));\n\t}\n}\n"}, "256");
    }

    public void testBug547891_23() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\n\tstatic int yield =100 ;\n\t\n\tpublic  static int foo(int i) {\n\tint r = switch(i) {\n\t\t\tdefault -> X.yield();\n\t\t};\n\t\treturn r;\n\t}\n\tpublic static  int yield() {\n\t\tint yield = 500 ;\n\t\tyield: while (yield == 500) {\n\t\t\tyield = 1024;\n\t\t\tbreak yield;\n\t\t}\n\t\treturn yield;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(X.foo(0));\n\t}\n}\n"}, "1024");
    }

    public void testBug547891_24() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\n\t\n\tpublic  static int foo(int i) {\n\t\tint yield = 100;\n\t\tint r = switch(i) {\n\t\t\tdefault -> {yield yield + 1;}\n\t\t};\n\t\treturn r;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(X.foo(0));\n\t}\n}"}, "101");
    }

    public void testBug547891_25() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\n\t\n\tpublic  static int foo(int i) {\n\t\tint yield = 100;\n\t\tint r = switch(i) {\n\t\t\tdefault -> {yield yield + yield + yield * yield;}\n\t\t};\n\t\treturn r;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(X.foo(0));\n\t}\n}"}, "10200");
    }

    public void testBug547891_26() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\n\t\n\tpublic  static int foo(int i) {\n\t\tint yield = 100;\n\t\tint r = switch(i) {\n\t\t\tdefault -> {yield + yield + yield + yield * yield;}\n\t\t};\n\t\treturn r;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(X.foo(0));\n\t}\n}"}, "10200");
    }

    public void testBug547891_27() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\n\t\n\tpublic  static int foo(int i) {\n\t\tint yield = 100;\n\t\tint r = switch(i) {\n\t\t\tdefault ->0 + yield + 10;\n\t\t};\n\t\treturn r;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(X.foo(0));\n\t}\n}"}, "110");
    }

    public void testBug547891_28() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\t\n\tpublic  static int foo(int i) {\n\t\tint yield = 100;\n\t\tint r = switch(i) {\n\t\t\t case 0 : yield 100;\n\t\t\t case 1 : yield yield;\n\t\t\t default: yield 0;\n\t\t};\n\t\treturn r;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(X.foo(0));\n\t}\n}"}, "100");
    }

    public void testBug547891_29() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\t\n\tpublic  static int foo(int i) {\n\t\tint yield = 100;\n\t\tint r = switch(i) {\n\t\t\t case 0 : yield 100;\n\t\t\t case 1 : yield yield;\n\t\t\t default: yield 0;\n\t\t};\n\t\treturn r > 100 ? yield + 1 : yield + 200;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(X.foo(0));\n\t}\n}"}, "300");
    }

    public void testBug550354_01() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  \n  public static int foo(int i) throws Exception {\n    int v = switch (i) {\n        default ->  {if (i > 0) yield 1;\n        else yield 2;}\n    };\n    return v;\n  }\n  public static void main(String argv[]) throws Exception {\n    System.out.println(X.foo(1));\n  }\n}"}, "1");
    }

    public void testBug548418_01() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  @SuppressWarnings({\"unused\" })\n  public static void main(String[] args) {\n\tint day =10;\n    int i = switch (day) {\n      default -> {\n        for(int j = 0; j < 3; j++) {\n        \tyield 99;\n        }\n        yield 0;\n      }\n    };\n    System.out.println(i);\n  }\n}\n"}, "99");
    }

    public void testBug550853_01() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  \n  public static int foo(int i) throws Exception {\n    int v = switch (i) {\n        default : {yield switch (i) {\n        \t\tdefault -> { yield 0; } \n        \t\t};\n        \t}\n    };\n    return v;\n  }\n  public static void main(String argv[]) throws Exception {\n    System.out.println(X.foo(1));\n  }\n}\n"}, "0");
    }

    public void testBug550861_01() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  \n  public static void foo(int i) throws Exception {\n\t  System.out.println(switch(0) {\n\t  default -> {\n\t    do yield 1; while(false);\n\t  }\n\t  });\n  }\n  public static void main(String argv[]) throws Exception {\n\t  X.foo(1);\n  }\n}\n"}, "1");
    }

    public void testBug551030a() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t@SuppressWarnings(\"nls\")\n\tstatic final String MONDAY = \"MONDAY\";\n\tpublic static void main(String[] args) {\n\t\tint num = switch (day) {\n\t\tcase MONDAY: \n\t\t\t// Nothing\n\t\tdefault:\n\t\t\tyield \";     \n\t\t}; \n\t}\n}"}, "----------\n1. ERROR in X.java (at line 9)\n\tyield \";     \n\t      ^^^^^^^\nString literal is not properly closed by a double-quote\n----------\n");
    }

    public void testBug551030b() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t@SuppressWarnings(\"nls\")\n\tstatic final String MONDAY = \"MONDAY\";\n\tpublic static void main(String[] args) {\n\t\tint num = switch (day) {\n\t\tcase MONDAY: \n\t\t\t// Nothing\n\t\tdefault:\n\t\t\tyield \"\"\";     \n\t\t}; \n\t}\n}"}, "----------\n1. ERROR in X.java (at line 9)\n\tyield \"\"\";     \n\t        ^^^^^^^\nString literal is not properly closed by a double-quote\n----------\n");
    }

    public void testBug544943() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\t\n\tpublic static int foo(int i) throws MyException {\n\t\tint v = -1;\n\t\ttry {\n\t\t\tv = switch (i) {\n\t\t\t\tcase 0 -> switch(i) {\n\t\t\t\t\t\t\tcase 0 -> 1;\n\t\t\t\t\t\t\tdefault -> throw new MyException();\n\t\t\t\t\t\t  };\n\t\t\t\tdefault -> 1;\n\t\t\t};\n\t\t} finally {\n\t\t\t// do nothing\n\t\t}\n\t\treturn v;\n\t} \n\tpublic static void main(String argv[]) {\n\t\ttry {\n\t\t\tSystem.out.println(X.foo(0));\n\t\t} catch (MyException e) {\n\t\t\te.printStackTrace();\n\t\t}\n\t}\n}\nclass MyException extends Exception {\n\tprivate static final long serialVersionUID = 3461899582505930473L;\t\n}"}, "1");
    }

    public void testBug544943_2() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\t\n\tpublic static int foo(int i) throws Exception {\n\t\tint v = switch (i) {\n\t\t\tcase 0 -> switch (i) {\n\t\t\t\tcase 0 -> 0;\n\t\t\t\tdefault-> throw new Exception();\n\t\t\t\tcase 3 -> 3;\n\t\t\t\tcase 2 -> throw new Exception();\n\t\t\t\t};\n\t\t\tdefault -> 0;\n\t\t};\n\t\treturn v;\n\t}\n\tpublic static void main(String argv[]) throws Exception {\n\t\tSystem.out.println(X.foo(1));\n\t}\n}"}, "0");
    }

    public void testBug552764_001() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.source", "13");
        String[] testFiles = new String[]{"X.java", "public class X {\n\tstatic int twice(int i) {\n\t\tswitch (i) {\n\t\t\tdefault -> 3;\n\t\t}\n\t\treturn 0;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.print(twice(3));\n\t}\n}\n"};
        String expectedProblemLog = "----------\n1. ERROR in X.java (at line 4)\n\tdefault -> 3;\n\t^^^^^^^\nArrow in case statement supported from Java 14 onwards only\n----------\n2. ERROR in X.java (at line 4)\n\tdefault -> 3;\n\t           ^\nInvalid expression as statement\n----------\n";
        this.runNegativeTest(testFiles, expectedProblemLog, null, true, options);
    }

    public void testBug552764_002() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.source", "13");
        String[] testFiles = new String[]{"X.java", "public class X {\n\tstatic int twice(int i) {\n\t\treturn switch (i) {\n\t\t\tdefault -> 3;\n\t\t};\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.print(twice(3));\n\t}\n}\n"};
        String expectedProblemLog = "----------\n1. ERROR in X.java (at line 3)\n\treturn switch (i) {\n\t\t\tdefault -> 3;\n\t\t};\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nSwitch Expressions are supported from Java 14 onwards only\n----------\n2. ERROR in X.java (at line 4)\n\tdefault -> 3;\n\t^^^^^^^\nArrow in case statement supported from Java 14 onwards only\n----------\n";
        this.runNegativeTest(testFiles, expectedProblemLog, null, true, options);
    }

    public void testBug552764_003() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.source", "13");
        String[] testFiles = new String[]{"X.java", "public class X {\n\tstatic int twice(int i) {\n\t\tswitch (i) {\n\t\t\tcase 1, 2 : break;\n\t\t\tdefault : break;\n\t\t}\n\t\treturn 0;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.print(twice(3));\n\t}\n}\n"};
        String expectedProblemLog = "----------\n1. ERROR in X.java (at line 4)\n\tcase 1, 2 : break;\n\t^^^^^^^^^\nMulti-constant case labels supported from Java 14 onwards only\n----------\n";
        this.runNegativeTest(testFiles, expectedProblemLog, null, true, options);
    }

    public void testBug558067_001() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    public int foo(int i, int e) {\n               LABEL: while (i == 0) {\n            i = switch (e) {\n                case 0 : {\n                    for (;;) {\n                        break LABEL; // NO error flagged\n                    }\n                    yield 1;\n                }\n                default : yield 2;\n            };\n        }\n    return i;\n    }\n    public static void main(String argv[]) {\n        new X().foo(0, 1);\n     }\n}\n"}, "----------\n1. WARNING in X.java (at line 3)\n\tLABEL: while (i == 0) {\n\t^^^^^\nThe label LABEL is never explicitly referenced\n----------\n2. ERROR in X.java (at line 7)\n\tbreak LABEL; // NO error flagged\n\t^^^^^^^^^^^^\nBreaking out of switch expressions not permitted\n----------\n3. ERROR in X.java (at line 9)\n\tyield 1;\n\t^^^^^^^^\nUnreachable code\n----------\n");
    }

    public void testBug558067_002() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    public int foo(int i, int e) {\n   TOP:System.out.println(\"hello\");\n          int x = switch(i) {\n       case 0:\n               LABEL: while (i == 0) {\n            i = switch (e) {\n                case 0 : {\n                    for (;;) {\n                        break LABEL;\n                    }\n                    yield 1;\n                }\n                default : yield 2;\n            };\n        }\n       case 2: for(;;) break TOP;\n       default: yield 0;\n       };\n    return i;\n    }\n    public static void main(String argv[]) {\n        new X().foo(0, 1);\n     }\n} \n"}, "----------\n1. WARNING in X.java (at line 3)\n\tTOP:System.out.println(\"hello\");\n\t^^^\nThe label TOP is never explicitly referenced\n----------\n2. WARNING in X.java (at line 6)\n\tLABEL: while (i == 0) {\n\t^^^^^\nThe label LABEL is never explicitly referenced\n----------\n3. ERROR in X.java (at line 10)\n\tbreak LABEL;\n\t^^^^^^^^^^^^\nBreaking out of switch expressions not permitted\n----------\n4. ERROR in X.java (at line 12)\n\tyield 1;\n\t^^^^^^^^\nUnreachable code\n----------\n5. ERROR in X.java (at line 17)\n\tcase 2: for(;;) break TOP;\n\t                ^^^^^^^^^^\nBreaking out of switch expressions not permitted\n----------\n");
    }

    public void testBug558067_003() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    public int foo(int i, int e) {\n               LABEL: while (i == 0) {\n            i = switch (e) {\n                case 0 : {\n                    for (;;) {\n                        continue LABEL;\n                    }\n                    yield 1;\n                }\n                default : yield 2;\n            };\n        }\n    return i;\n    }\n    public static void main(String argv[]) {\n        new X().foo(0, 1);\n     }\n}\n"}, "----------\n1. WARNING in X.java (at line 3)\n\tLABEL: while (i == 0) {\n\t^^^^^\nThe label LABEL is never explicitly referenced\n----------\n2. ERROR in X.java (at line 7)\n\tcontinue LABEL;\n\t^^^^^^^^^^^^^^^\nContinue out of switch expressions not permitted\n----------\n3. ERROR in X.java (at line 9)\n\tyield 1;\n\t^^^^^^^^\nUnreachable code\n----------\n");
    }

    public void testBug558067_004() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    public int foo(int i, int e) {\n               LABEL: while (i == 0) {\n            i = switch (e) {\n                case 0 : {\n                    switch(e) {\n                      case 0 : {\n                          break LABEL;\n                      }\n                    }\n                    yield 1;\n                }\n                default : yield 2;\n            };\n        }\n    return i;\n    }\n    public static void main(String argv[]) {\n        new X().foo(0, 1);\n     }\n}\n"}, "----------\n1. WARNING in X.java (at line 3)\n\tLABEL: while (i == 0) {\n\t^^^^^\nThe label LABEL is never explicitly referenced\n----------\n2. ERROR in X.java (at line 8)\n\tbreak LABEL;\n\t^^^^^^^^^^^^\nBreaking out of switch expressions not permitted\n----------\n");
    }

    public void testBug558067_005() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    public int foo(int i, int e) {\n               LABEL: while (i == 0) {\n            i = switch (e) {\n                case 0 : {\n                    switch(e) {\n                      case 0 : {\n                          continue LABEL;\n                      }\n                    }\n                    yield 1;\n                }\n                default : yield 2;\n            };\n        }\n    return i;\n    }\n    public static void main(String argv[]) {\n        new X().foo(0, 1);\n     }\n}\n"}, "----------\n1. WARNING in X.java (at line 3)\n\tLABEL: while (i == 0) {\n\t^^^^^\nThe label LABEL is never explicitly referenced\n----------\n2. ERROR in X.java (at line 8)\n\tcontinue LABEL;\n\t^^^^^^^^^^^^^^^\nContinue out of switch expressions not permitted\n----------\n");
    }

    public void testConversion1() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\t public static int i = 0;\n\t private static String typeName(byte arg){ return \"byte\"; }\n    private static String typeName(char arg){ return \"char\"; }\n    private static String typeName(short arg){ return \"short\"; }\n    private static String typeName(int arg){ return \"int\"; }\n    private static String typeName(float arg){ return \"float\"; }\n    private static String typeName(long arg){ return \"long\"; }\n    private static String typeName(double arg){ return \"double\"; }\n    private static String typeName(String arg){ return \"String\"; }\n\t\tpublic static void main(String[] args) {\n\t\t byte v1 = (byte)0;\n        char v2 = ' ';\n        var v = switch(i+1){\n                    case 1 -> v2;\n                    case 5 -> v1;\n                    default -> v2;\n        };\n        System.out.print(typeName(v));\n\t}\n}\n"}, "int");
    }

    public void testConversion2() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\t public static int i = 0;\n\t private static String typeName(byte arg){ return \"byte\"; }\n    private static String typeName(char arg){ return \"char\"; }\n    private static String typeName(short arg){ return \"short\"; }\n    private static String typeName(int arg){ return \"int\"; }\n    private static String typeName(float arg){ return \"float\"; }\n    private static String typeName(long arg){ return \"long\"; }\n    private static String typeName(double arg){ return \"double\"; }\n    private static String typeName(String arg){ return \"String\"; }\n\t\tpublic static void main(String[] args) {\n\t\t long v1 = 0L;\n        double v2 = 0.;\n        var v = switch(i+1){\n                    case 1 -> v2;\n                    case 5 -> v1;\n                    default -> v2;\n        };\n        System.out.print(typeName(v));\n\t}\n}\n"}, "double");
    }

    public void testConversion3() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\t public static int i = 0;\n\t private static String typeName(byte arg){ return \"byte\"; }\n    private static String typeName(char arg){ return \"char\"; }\n    private static String typeName(short arg){ return \"short\"; }\n    private static String typeName(int arg){ return \"int\"; }\n    private static String typeName(float arg){ return \"float\"; }\n    private static String typeName(long arg){ return \"long\"; }\n    private static String typeName(double arg){ return \"double\"; }\n    private static String typeName(String arg){ return \"String\"; }\n\t\tpublic static void main(String[] args) {\n\t\t long v1 = 0L;\n        float v2 = 0.f;\n        var v = switch(i+1){\n                    case 1 -> v2;\n                    case 5 -> v1;\n                    default -> v2;\n        };\n        System.out.print(typeName(v));\n\t}\n}\n"}, "float");
    }

    public void testConversion4() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\t public static int i = 0;\n\t private static String typeName(byte arg){ return \"byte\"; }\n    private static String typeName(char arg){ return \"char\"; }\n    private static String typeName(short arg){ return \"short\"; }\n    private static String typeName(int arg){ return \"int\"; }\n    private static String typeName(float arg){ return \"float\"; }\n    private static String typeName(long arg){ return \"long\"; }\n    private static String typeName(double arg){ return \"double\"; }\n    private static String typeName(String arg){ return \"String\"; }\n\t\tpublic static void main(String[] args) {\n\t\t short v1 = 0;\n        char v2 = ' ';\n        var v = switch(i+1){\n                    case 1 -> v2;\n                    case 5 -> v1;\n                    default -> v2;\n        };\n        System.out.print(typeName(v));\n\t}\n}\n"}, "int");
    }

    public void testConversion5() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\t public static int i = 0;\n    private static String typeName(char arg){ return \"char\"; }\n    private static String typeName(int arg){ return \"int\"; }\n    private static String typeName(float arg){ return \"float\"; }\n    private static String typeName(long arg){ return \"long\"; }\n    private static String typeName(double arg){ return \"double\"; }\n    private static String typeName(String arg){ return \"String\"; }\n\t\tpublic static void main(String[] args) {\n\t\t char v1 = 'a';\n        var v = switch(i+1){\n                    case 1 -> 200;\n                    case 5 -> v1;\n                    default -> v1;\n        };\n        System.out.print(typeName(v));\n\t}\n}\n"}, "char");
    }

    public void testBug545567_1() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    @SuppressWarnings({\"finally\"})\n\tpublic static void main(String[] args) {\n    \tint t = switch (0) {\n        default -> {\n            try {\n                yield 1;\n            }\n            finally {\n                yield 3;\n            }\n        }\n     };\n     System.out.println(t);\n    }\n}\n\n"}, "3");
    }

    public void testBug545567_2() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    @SuppressWarnings({ \"finally\"})\n\tpublic static void main(String[] args) {\n    \tfloat t = switch (0) {\n        default -> {\n            try {\n                yield 1;\n            }\n            finally {\n                yield 3;\n            }\n        }\n     };\n     System.out.println(t);\n    }\n}\n\n"}, "3.0");
    }

    public void testBug545567_3() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    @SuppressWarnings({ \"finally\"})\n\tpublic static void main(String[] args) {\n    \tString t = switch (0) {\n        default -> {\n            try {\n                yield \"one\";\n            }\n            finally {\n                yield \"three\";\n            }\n        }\n     };\n     System.out.println(t);\n    }\n}\n\n"}, "three");
    }

    public void testBug545567_4() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    @SuppressWarnings({\"finally\" })\n\tpublic static void main(String[] args) {\n    \tString t = switch (0) {\n        default -> {\n            try {\n                yield \"one\";\n            }\n            catch (Exception ex) {\n                yield \"two\";\n            }\n            finally {\n                yield \"three\";\n            }\n        }\n     };\n     System.out.println(t);\n    }\n}\n\n"}, "three");
    }

    public void testBug545567_5() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    @SuppressWarnings({ \"finally\" })\n\tpublic static void main(String[] args) {\n    \tString t = switch (0) {\n        default -> {\n            try {\n                yield \"one\";\n            }\n            catch (Exception ex) {\n            }\n            yield \"zero\";\n        }\n     };\n     System.out.print(t);\n    }\n}\n\n"}, "one");
    }

    public void testBug545567_5_1() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public String toString() { return \"some X\"; }\n    public static void main(String[] args) {\n    \tString t = switch (0) {\n        default -> {\n            try {\n                yield new X().toString();\n            }\n            catch (Exception ex) {\n            }\n            yield \"zero\";\n        }\n     };\n     System.out.print(t);\n    }\n\n    static int foo() {\n    \ttry {\n    \t\treturn 42;\n    \t} catch (Exception ex) {\n\n    \t}\n    \treturn -1;\n    }\n}\n"}, "some X");
    }

    public void testBug545567_6() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    @SuppressWarnings({ \"finally\"})\n\tpublic static void main(String[] args) {\n    \t(new X()).foo(switch (0) {\n        default -> {\n            try {\n                yield \"one\";\n            }\n            finally {\n            \tyield \"zero\";\n            }\n        }\n     });\n    }\n     public void foo (String str) {\n     \tSystem.out.print(str);\n    }\n}\n\n"}, "zero");
    }

    public void testBug545567_7() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    @SuppressWarnings({ \"finally\"})\n\tpublic static void main(String[] args) {\n    \tSystem.out.print(switch (0) {\n        default -> {\n            try {\n                yield \"one\";\n            }\n            finally {\n            \tyield \"zero\";\n            }\n        }\n     });\n    }\n}\n\n"}, "zero");
    }

    public void testBug545567_8() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    @SuppressWarnings({ \"finally\"})\n\tpublic static void main(String[] args) {\n    \tSystem.out.print(switch (0) {\n        default -> {\n            try {\n                yield 1;\n            }\n            catch (Exception ex) {\n                yield 2;\n            }\n            finally {\n                yield 3;\n            }\n        }\n     });\n    }\n}\n\n"}, "3");
    }

    public void testBug545567_9() {
        this.runConformTest(new String[]{"X.java", "public class X {\n       public static void main(String[] args) {\n       new X().foo(args);\n    }\n    @SuppressWarnings({ \"finally\" })\n       public void foo(String[] args) {\n       int t = switch (0) {\n        default -> {\n             try {\n                yield 1;\n            }\n            catch (Exception ex) {\n                yield 2; \n            }\n            finally {\n                yield 3;\n            }\n        }       \n     };\n       t += switch (0) {\n    default -> {\n         try {\n            yield 1;\n        }\n        catch (Exception ex) {\n            yield 2; \n        }\n        finally {\n            yield 3;\n        }\n    }       \n };\n     System.out.println(t);\n    } \n}\n"}, "6");
    }

    public void testBug545567_10() {
        this.runConformTest(new String[]{"X.java", "public class X {\n       public static void main(String[] args) {\n       new X().foo(args);\n    }\n    @SuppressWarnings({ \"finally\" })\n       public void foo(String[] args) {\n       int k = 0;\n       int t = switch (0) {\n        default -> {\n             try {\n                k = switch (0) {\n                   default -> {\n                        try {\n                           yield 10;\n                       }\n                       catch (Exception ex) {\n                           yield 20; \n                       }\n                       finally {\n                           yield 30;\n                       }\n                   }       \n                };\n            }\n            catch (Exception ex) {\n                yield 2; \n            }\n            finally {\n                yield 3;\n            }\n        }       \n     };\n     System.out.println(t + k);\n    } \n}\n"}, "33");
    }

    public void testBug545567_11() {
        this.runConformTest(new String[]{"X.java", "public class X {\n       public static void main(String[] args) {\n       new X().foo(args);\n    }\n    @SuppressWarnings({ \"finally\" })\n       public void foo(String[] args) {\n       int k = 0;\n       int t = switch (0) {\n        default -> {\n             try {\n                k = switch (0) {\n                   default -> {\n                        try {\n                           yield 10;\n                       }\n                       catch (Exception ex) {\n                           yield 20; \n                       }\n                   }       \n                };\n            }\n            catch (Exception ex) {\n                yield 2; \n            }\n            finally {\n                yield 3;\n            }\n        }       \n     };\n     System.out.println(t + k);\n    } \n}\n"}, "13");
    }

    public void testBug545567_12() {
        this.runConformTest(new String[]{"X.java", "public class X {\n       public static void main(String[] args) {\n       new X().foo(args);\n    }\n    @SuppressWarnings({ \"finally\" })\n       public void foo(String[] args) {\n       int k = 0;\n       int t = switch (0) {\n        default -> {\n             try {\n                k = switch (0) {\n                   default -> {\n                        try {\n                           yield 10;\n                       }\n                       catch (Exception ex) {\n                           yield 20; \n                       }\n                       finally {\n                           yield 30;\n                       }\n                   }       \n                };\n            }\n            finally {\n                yield 3;\n            }\n        }       \n     };\n     System.out.println(t + k);\n    } \n}\n"}, "33");
    }

    public void testBug545567_13() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    @SuppressWarnings({ \"finally\" })\n       public static void main(String[] args) {\n        System.out.println(switch (1) {\n        case 0 -> {yield 100;}\n           default -> {  \n                try {\n                   yield 1;\n               }\n               catch (Exception ex) {\n                   yield 2;\n                }\n               finally {\n                   yield 3; \n               }\n           }  \n        } + switch (10) {\n        case 0 -> {yield 1024;}\n        default -> {  \n             try {\n                yield 10;\n            }\n            catch (Exception ex) {\n                yield 20;\n             }\n            finally {\n                yield 30; \n            }\n        }  \n     });  \n    }\n}\n"}, "33");
    }

    public void testBug545567_14() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    @SuppressWarnings({ \"finally\" })\n       public static void main(String[] args) {\n        System.out.println(switch (1) {\n        case 0 -> {yield 100;}\n           default -> {  \n                try {\n                   yield 1;\n               }\n               catch (Exception ex) {\n                   yield 2;\n                }\n               finally {\n                 yield switch (10) {\n                   case 0 -> {yield 1024;}\n                   default -> {  \n                        try {\n                           yield 10;\n                       }\n                       catch (Exception ex) {\n                           yield 20;\n                        }\n                       finally {\n                           yield 30; \n                       }\n                   }  \n                };               }\n           }  \n        });  \n    }\n}\n"}, "30");
    }

    public void testBug545567_15() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    @SuppressWarnings({ \"finally\" })\n       public static void main(String[] args) {\n        System.out.println(switch (1) {\n        case 0 -> {yield 100;}\n           default -> {  \n                try {\n                       yield 1;\n               }\n               catch (Exception ex) {\n                   yield 2;\n                }\n               finally {\n                   System.out.println(switch (1) {\n                    default -> {yield 100;}});\n                  yield 1;\n                }\n           }  \n        });  \n    }\n}\n"}, "100\n1");
    }

    public void testBug545567_16() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    @SuppressWarnings({ \"finally\" })\n       public static void main(String[] args) {\n        System.out.println(switch (1) {\n        case 0 -> {yield 100;}\n           default -> {   \n                try {\n                    yield switch (10) {\n                    case 0 -> {yield 1024;}\n                    default -> {   \n                         try {\n                            yield 10; \n                        }   \n                        catch (Exception ex) {\n                            yield 20; \n                         }   \n                        finally {\n                            yield 30; \n                        }   \n                    }   \n                 };                 \n               }   \n               catch (Exception ex) {\n                   yield 2;\n                }   \n               finally {\n                 yield 3;               }   \n           }   \n        });  \n    }   \n}\n"}, "3");
    }

    public void testBug545567_17() {
        this.runConformTest(new String[]{"X.java", "public class X { \n    @SuppressWarnings({ \"finally\" })\n       public static void main(String[] args) {\n        System.out.println(switch (1) {\n        case 0 -> {yield 100;}\n           default -> {   \n                try {\n                    System.out.println( switch (10) {\n                    case 0 -> {yield 1024;}\n                    default -> {   \n                         try {\n                            yield 10; \n                        }   \n                        catch (Exception ex) {\n                            yield 20; \n                         }    \n                        finally {\n                            yield 30; \n                        }   \n                    }   \n                 }); \n                   yield 1;   \n               }   \n               catch (Exception ex) {\n                   yield 2;\n                }   \n               finally {\n                 yield 3;               }   \n           }   \n        });  \n    }   \n}\n"}, "30\n3");
    }

    public void testBug545567_18() {
        this.runConformTest(new String[]{"X.java", "public class X { \n       public static void main(String[] args) {\n       new X().foo(args);\n    }   \n    @SuppressWarnings({ \"finally\" })\n       public void foo(String[] args) {\n       int t = 0;\n       t += switch (200) {\n       case 0 -> {yield 100;}\n        default -> {\n             try {\n                yield 1;\n            }   \n            catch (Exception ex) {\n                yield 2;  \n            }   \n            finally {\n                yield 3;\n            }   \n        }\n     };\n     System.out.println(t);\n    }   \n}\n"}, "3");
    }

    public void testBug545567_19() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    @SuppressWarnings({ \"finally\" })\n       public static void main(String[] args) {\n        System.out.println(switch (1) {\n           default -> {   \n                try {  \n                    yield switch (10) {\n                    default -> {   \n                         try {\n                            yield 10; \n                        }   \n                        catch (Exception ex) {\n                            yield 20; \n                         }   \n                        finally {\n                            yield 30; \n                         }   \n                    }   \n                 };                 \n               }   \n               catch (Exception ex) {\n                   yield 2;\n                }   \n               finally {\n                 yield 3;               }     \n           }   \n        });   \n    }   \n} \n\n"}, "3");
    }

    public void testBug545567_20() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    @SuppressWarnings({ \"finally\" })\n       public static void main(String[] args) {\n        System.out.println(switch (1) {\n           default -> {   \n                try(Y y = new Y();) { \n                       yield  1;\n                }\n               catch (Exception ex) {\n                   yield 2;\n                }   \n               finally {\n                 yield 3;\n               }\n           }\n        });\n    }\n} \nclass Y implements AutoCloseable {\n       @Override\n       public void close() throws Exception {\n               // do nothing\n       }\n}\n"}, "3");
    }

    public void testBug545567_21() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    @SuppressWarnings({ \"finally\" })\n       public static void main(String[] args) {\n        System.out.println(switch (1) {\n           default -> {   \n                try(Y y = new Y();) { \n                       yield  10;\n                }\n               catch (Exception ex) {\n                }   \n                 yield 3;\n           }\n        });\n    }\n} \nclass Y implements AutoCloseable {\n       @Override\n       public void close() throws Exception {\n               // do nothing\n       }\n}\n"}, "10");
    }

    public void _testBug545567_22() {
        this.runConformTest(new String[]{"X.java", "public class X {\n       @SuppressWarnings({ \"finally\" })\n       public static void main(String[] args) {\n               int argslength = args.length;\n               int t = switch (1) {\n                       case 0 -> {\n                               yield 100;\n                       }\n                       default -> {\n                               try (Y y = new Y();){\n                                               if (argslength < 1)\n                                               yield 10;\n                                               else\n                                                       yield 12;\n                               } catch (Exception ex) {\n                                       yield 2;\n                               } finally {\n                                       yield 3;\n                               }\n                       }\n               };   \n               System.out.println(t);\n       }\n}\n      \nclass Y implements AutoCloseable {\n       @Override\n       public void close() throws Exception {\n               // do nothing\n       } \n}\n"}, "3");
    }

    public void testBug545567_23() {
        this.runConformTest(new String[]{"X.java", "public class X {\n       @SuppressWarnings({ \"finally\" })\n       public static void main(String[] args) {\n               int t = switch (1) {\n                       case 0 -> {\n                               yield 100;\n                       }\n                       default -> {\n                               try {\n                                       throw new Exception();\n                               } catch (Exception ex) {\n                                       yield 2;\n                               } finally {\n                                       yield 3;\n                               }\n                       }\n               };   \n               System.out.println(t);\n       }\n}\n      \nclass Y implements AutoCloseable {\n       @Override\n       public void close() throws Exception {\n               // do nothing\n       } \n}\n"}, "3");
    }

    public void testBug545567_24() {
        this.runConformTest(new String[]{"X.java", "public class X {\n public static void main(String[] args) {\n   new X().foo();\n }\n @SuppressWarnings({ \"finally\" })\n public  void foo() {\n   int t = switch (1) {\n     case 0 -> {\n       yield bar(100);\n     }\n     default -> {\n       final Y y2 = new Y();\n       try (Y y = new Y(); y2){\n           yield bar(10);\n       } catch (Exception ex) {\n         yield bar(2);\n       } finally {\n         yield bar(3);\n       }\n     }\n   };   \n   System.out.println(t);\n }\n public int bar(int i) {\n   return i;\n }\n}\n\nclass Y implements AutoCloseable {\n @Override\n public void close() throws Exception {\n   // do nothing\n }\n}"}, "3");
    }

    public void testBug545567_25() {
        this.runConformTest(new String[]{"X.java", "public class X {\n public static void main(String[] args) {\n   new X().foo();\n }\n @SuppressWarnings({ \"finally\" })\n public  void foo() {\n   int t = switch (1) {\n     case 0 -> {\n       yield bar(100);\n     }\n     default -> {\n       final Y y2 = new Y();\n       try (Y y = new Y(); y2){\n           yield new X().bar(10);\n       } catch (Exception ex) {\n         yield bar(2);\n       } finally {\n         yield new X().bar(3);\n       }\n     }\n   };   \n   System.out.println(t);\n }\n public int bar(int i) {\n   return i;\n }\n}\n\nclass Y implements AutoCloseable {\n @Override\n public void close() throws Exception {\n   // do nothing\n }\n}"}, "3");
    }

    public void testBug571929_normal() {
        this.runConformTest(new String[]{"X.java", "public class X {\n public static void main(String[] args) {\n   System.out.println(foo(\"a\"));\n }\n private static boolean foo(String s) {\n  bar(0L);\n  return switch (s) {\n    case \"a\" -> {\n      try {\n        yield true;\n      } finally {\n      }\n    }\n    default -> false;\n  };\n }\n private static void bar(long l) {}\n}"}, "true");
    }

    public void testBug571929_lambda() {
        this.runConformTest(new String[]{"X.java", "public class X {\n public static void main(String[] args) {\n   System.out.println(foo(\"a\"));\n }\n static long m = 0L;\n private static boolean foo(String s) {\n  long l = m;\n  // capture l\n  Runnable r = () -> bar(l);\n  return switch (s) {\n    case \"a\" -> {\n      try {\n        yield true;\n      } finally {\n      }\n    }\n    default -> false;\n  };\n }\n private static void bar(long l) {}\n}"}, "true");
    }

    public void testBug561762_001() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n       public static void main(String[] args) {\n               new X().foo(1);\n       }\n       @SuppressWarnings({ \"finally\" })\n       public  void foo(int i) {\n               int t = switch (1) { \n                       case 0 -> {\n                               yield 0;\n                       }\n                       default -> {\n                               I lam2 = (x) ->  {\n                                               yield 2000;\n                               };\n                               yield 1;\n                       }\n               };\n               System.out.println(t);\n       }\n}\ninterface I {\n       public int apply(int i);\n}\n"}, "----------\n1. ERROR in X.java (at line 13)\n\tyield 2000;\n\t^^^^^^^^^^^\nyield outside of switch expression\n----------\n");
    }

    public void testBug561766_001() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    @SuppressWarnings({ \"finally\" })\n       public static void main(String[] args) {\n        System.out.println(switch (1) {\n        case 0 -> {yield switch(0) {}\n        } \n           default -> {\n                  yield 3;\n           }\n        });\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tcase 0 -> {yield switch(0) {}\n\t                            ^\nSyntax error, insert \";\" to complete BlockStatements\n----------\n");
    }

    public void testBug561766_002() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    @SuppressWarnings({ \"finally\" })\n       public static void main(String[] args) {\n        System.out.println(switch (1) {\n        case 0 -> {yield 100;}\n           default -> {  \n                try {\n                       yield switch(0) {\n               }\n               catch (Exception ex) {\n                   yield 2;\n                }\n               finally {\n                  yield 3;\n                }\n           }  \n        });  \n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\t}\n\t^\nSyntax error, insert \";\" to complete YieldStatement\n----------\n2. ERROR in X.java (at line 9)\n\t}\n\t^\nSyntax error, insert \"}\" to complete Block\n----------\n3. ERROR in X.java (at line 18)\n\t}\n\t^\nSyntax error on token \"}\", delete this token\n----------\n4. ERROR in X.java (at line 19)\n\t}\n\t^\nSyntax error, insert \"}\" to complete ClassBody\n----------\n");
    }

    public void testBug562129() {
        if (this.complianceLevel < 0x3A0000L) {
            return;
        }
        this.runNegativeTest(new String[]{"SwitchExpressionError.java", "class SwitchExpressionError {\n\n    static boolean howMany(int k) {\n        return false || switch (k) {\n            case 1 -> true;\n            case 2 -> Boolean.FALSE;\n            case 3 -> r;\n        };\n    }\n\n}\n"}, "----------\n1. ERROR in SwitchExpressionError.java (at line 4)\n\treturn false || switch (k) {\n\t                        ^\nA switch expression should have a default case\n----------\n2. ERROR in SwitchExpressionError.java (at line 7)\n\tcase 3 -> r;\n\t          ^\nr cannot be resolved to a variable\n----------\n");
    }

    public void testBug572121() {
        Map<String, String> compilerOptions = this.getCompilerOptions();
        compilerOptions.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", "disabled");
        this.runConformTest(new String[]{"X.java", "public class X {\n private void foo(int i) {\n }\n\n private static void bar() {\n }\n\n public static void main(String[] args) {\n  if (f) {\n   Object o = switch (j) {\n    default -> {\n     try {\n      bar();\n     } catch (Throwable e) {\n     }\n     yield null;\n    }\n   };\n  }\n  int i = 0;\n  x.foo(i++);\n }\n\n private static boolean f = true;\n private static int j;\n private static X x = new X();\n}"}, "", (Map)compilerOptions);
    }

    public void testBug562198_001() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    int a[] = {1, 2, 3};\n    public int foo() {\n        return switch (0) {\n               case 0 -> {\n                       yield a[0];\n               }\n            default -> {\n                try {\n                    // do nothing\n                } finally {\n                    // do nothing\n                }\n                yield 0;\n            }\n        };\n    }\n    public static void main(String[] args) {\n               System.out.println(new X().foo());\n       }\n}\n"}, "1");
    }

    public void testBug562728_001() {
        this.runConformTest(new String[]{"X.java", "public class X {\n       static public void main (String[] args) {\n               int a = 0x21;\n               int b = 0xff;\n               switch (a) {\n               case 0x21 -> {\n                       switch (b) {\n                       default -> System.out.println(\"default\");\n                       }\n               }\n               case 0x3b -> System.out.println(\"3b <- WTH?\");\n               }\n       }\n}\n"}, "default");
    }

    public void testBug562728_002() {
        this.runConformTest(new String[]{"X.java", "public class X {\n static public void main (String[] args) {\n   int a = 0x21;\n   int b = 0xff;\n   switch (a) {\n     case 0x21 -> {\n       switch (b) {\n         default -> System.out.println(\"default\");\n       }\n       return;\n     }\n     case 0x3b -> System.out.println(\"3b <- WTH?\");\n   }\n }\n}\n"}, "default");
    }

    public void testBug562728_003() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n static public void main (String[] args) throws Exception {\n   int a = 0x21;\n   int b = 0xff;\n   switch (a) {\n     case 0x21 -> {\n       switch (b) {\n         default -> throw new Exception();\n       }\n       return; \n     }\n     case 0x3b -> System.out.println(\"3b <- WTH?\");\n   }\n }\n}\n"}, "----------\n1. ERROR in X.java (at line 10)\n\treturn; \n\t^^^^^^^\nUnreachable code\n----------\n");
    }

    public void testBug562728_004() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n       static public void main (String[] args) throws Exception {\n               int a = 0x21;\n               int b = 0xff;\n               Zork();\n               switch (a) {\n               case 0x21 -> {\n                       switch (b) {\n                       default -> {\n                               for (;;) {\n                                       if (b > 1)\n                                       throw new Exception();\n                               }\n                       }\n                       }\n               }\n               case 0x3b -> System.out.println(\"3b <- WTH?\");\n               }\n       }\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tZork();\n\t^^^^\nThe method Zork() is undefined for the type X\n----------\n");
    }

    public void testBug562728_005() {
        this.runNegativeTest(new String[]{"X.java", "public class X {                        \n        public static int foo(int i) {  \n                int v;                  \n                int t = switch (i) {    \n                case 0 : {              \n                        yield 0;        \n                }                       \n                case 2 :v = 2;\n                default :v = 2;\n                };                      \n                return t;               \n        }                               \n                                        \n        public boolean bar() {          \n                return true;            \n        }\n        public static void main(String[] args) {\n                System.out.println(foo(3));\n        }                               \n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\tdefault :v = 2;\n\t            ^^\nA switch labeled block in a switch expression must yield a value or throw an an exception\n----------\n");
    }

    public void testBug562728_006() {
        this.runNegativeTest(new String[]{"X.java", "public class X {                        \n        public static int foo(int i) {  \n                int v;                  \n                int t = switch (i) {    \n                case 0 -> {              \n                        yield 0;        \n                }                       \n                case 2 ->{v = 2;}\n                default ->{v = 2;}\n                };                      \n                return t;               \n        }                               \n                                        \n        public boolean bar() {          \n                return true;            \n        }\n        public static void main(String[] args) {\n                System.out.println(foo(3));\n        }                               \n}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\tcase 2 ->{v = 2;}\n\t               ^^\nA switch labeled block in a switch expression must yield a value or throw an an exception\n----------\n2. ERROR in X.java (at line 9)\n\tdefault ->{v = 2;}\n\t                ^^\nA switch labeled block in a switch expression must yield a value or throw an an exception\n----------\n");
    }

    public void testBug562728_007() {
        this.runNegativeTest(new String[]{"X.java", "public class X {                        \n        public static int foo(int i) {  \n                int v;                  \n                int t = switch (i) {    \n                case 0 -> {              \n                     return 1;\n                }                       \n                default ->100;\n                };                      \n                return t;               \n        }                               \n                                        \n        public boolean bar() {          \n                return true;            \n        }\n        public static void main(String[] args) {\n                System.out.println(foo(3));\n        }                               \n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\treturn 1;\n\t^^^^^^^^^\nReturn within switch expressions not permitted\n----------\n");
    }

    public void testBug563023_001() {
        this.runConformTest(new String[]{"X.java", "public class X { \n static public int foo(int a, int b){\n   int t = switch (a) {\n     default -> {\n       switch (b) {\n            default -> {\n              yield 0;\n            }\n       }      \n     }\n   };\n   return t;\n }\n public static void main(String[] args) {\n   System.out.println(X.foo(0, 0));\n }\n}\n"}, "0");
    }

    public void testBug563023_002() {
        this.runNegativeTest(new String[]{"X.java", "public class X { \n static public int foo(int a, int b){\n   int t = switch (a) {\n     default -> {\n       switch (b) {\n            case 0 -> {\n              break;\n            }\n            default -> {\n              yield 0;\n            }\n       }      \n     }\n   };\n   return t;\n }\n public static void main(String[] args) {\n   System.out.println(X.foo(0, 0));\n }\n}\n"}, "----------\n1. ERROR in X.java (at line 13)\n\t}\n\t^^\nA switch labeled block in a switch expression must yield a value or throw an an exception\n----------\n");
    }

    public void testBug563023_003() {
        this.runNegativeTest(new String[]{"X.java", "public class X { \n static public int foo(int a, int b){\n   int t = switch (a) {\n     default -> {\n       switch (b) {\n            case 0 -> {\n              yield 0;\n            }\n       }      \n     }\n   };\n   return t;\n }\n public static void main(String[] args) {\n   System.out.println(X.foo(0, 0));\n }\n}\n"}, "----------\n1. ERROR in X.java (at line 10)\n\t}\n\t^^\nA switch labeled block in a switch expression must yield a value or throw an an exception\n----------\n");
    }

    public void testBug563023_004() {
        this.runNegativeTest(new String[]{"X.java", "public class X { \n static public int foo(int a, int b){\n   int t = switch (a) {\n     default -> {\n       switch (b) {\n            case 0 -> {\n              break;\n            }\n            default -> yield 0;\n       }      \n     }\n   };\n   return t;\n }\n public static void main(String[] args) {\n   System.out.println(X.foo(0, 0));\n }\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\tdefault -> yield 0;\n\t                 ^\nSyntax error on token \"0\", delete this token\n----------\n");
    }

    public void testBug563023_005() {
        this.runNegativeTest(new String[]{"X.java", "public class X { \n static public int foo(int a, int b){\n   int t = switch (a) {\n     default -> {\n       switch (b) {\n            case 0 -> {\n              break;\n            }\n            default ->{ yield 0;}\n       }      \n     }\n   };\n   return t;\n }\n public static void main(String[] args) {\n   System.out.println(X.foo(0, 0));\n }\n}\n"}, "----------\n1. ERROR in X.java (at line 11)\n\t}\n\t^^\nA switch labeled block in a switch expression must yield a value or throw an an exception\n----------\n");
    }

    public void testBug563023_006() {
        this.runConformTest(new String[]{"X.java", "public class X { \n static public int foo(MyEnum a, MyEnum b){\n   int t = switch (a) {\n     default -> {\n       switch (b) {\n       case ONE -> { \n              yield 0;\n            }\n       default -> {yield 1;}\n       }      \n     }\n   };\n   return t;\n }\n public static void main(String[] args) {\n   System.out.println(X.foo(MyEnum.ONE, MyEnum.TWO));\n }\n} \nenum MyEnum {\n ONE,\n TWO\n}\n"}, "1");
    }

    public void testBug563023_007() {
        this.runNegativeTest(new String[]{"X.java", "public class X { \n static public int foo(MyEnum a, MyEnum b){\n   int t = switch (a) {\n     default -> {\n       switch (b) {\n       case ONE -> { \n              yield 0;\n            }\n       }      \n     }\n   };\n   return t;\n }\n public static void main(String[] args) {\n   System.out.println(X.foo(MyEnum.ONE, MyEnum.TWO));\n }\n} \nenum MyEnum {\n ONE,\n TWO\n}\n"}, "----------\n1. WARNING in X.java (at line 5)\n\tswitch (b) {\n\t        ^\nThe enum constant TWO needs a corresponding case label in this enum switch on MyEnum\n----------\n2. ERROR in X.java (at line 10)\n\t}\n\t^^\nA switch labeled block in a switch expression must yield a value or throw an an exception\n----------\n");
    }

    public void testBug563147_001() {
        this.runConformTest(new String[]{"X.java", "interface I {\n public int apply();\n}\npublic class X { \n static public int foo(int a){\n   int t = switch (a) {\n     default -> {\n       I lambda = () -> { return 0;};\n       yield lambda.apply();\n     }\n   };\n   return t;\n }\n public static void main(String[] args) {\n   System.out.println(X.foo(1));\n }\n} \n"}, "0");
    }

    public void testBug563147_002() {
        this.runConformTest(new String[]{"X.java", "interface FI {\n  public int foo();\n}\npublic class X {\n  public int field = 0;\n  public int test() {\n   var v = switch (field) {\n     case 0 -> {\n       yield ((FI  ) () -> {\n         int i = 0;\n         while (true) {\n           i++;\n           if (i == 7) {\n             break;\n           }\n         }\n         return i;\n       });   \n     }\n     default -> {\n       yield null;\n     }\n   }; \n   return 0;\n  }\n  public static void main(String[] args) {\n int t = new X().test();\n System.out.println(t);\n}\n}\n"}, "0");
    }

    public void testBug563147_003() {
        this.runNegativeTest(new String[]{"X.java", "interface FI {\n  public int foo();\n}\npublic class X {\n  public int field = 0;\n  public int test() {\n   var v = switch (field) {\n     case 0 -> {\n       yield ((F  ) () -> {\n         int i = 0;\n         while (true) {\n           i++;\n           if (i == 7) {\n             break;\n           }\n         }\n         return i;\n       });   \n     }\n     default -> {\n       yield null;\n     }\n   }; \n   return 0;\n  }\n  public static void main(String[] args) {\n int t = new X().test();\n System.out.println(t);\n}\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\tyield ((F  ) () -> {\n\t        ^\nF cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 9)\n\tyield ((F  ) () -> {\n\t             ^^^^^\nThe target type of this expression must be a functional interface\n----------\n");
    }

    public void testBug565156_001() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  public int test() {\n    return switch (0) {\n      default -> {\n        try {\n          yield 0;\n        }\n        catch (RuntimeException e) {\n          throw e;\n        }\n      }\n    };\n  }    \n  public static void main(String[] args) {\n       int i = new X().test();\n       System.out.println(i);\n }\n}\n"}, "0");
    }

    public void testBug565156_002() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  public int test() {\n    return switch (0) {\n      default -> {\n        try {\n          yield 0;\n        }\n        finally {\n          //do nothing\n        }\n      }\n    };\n  }    \n  public static void main(String[] args) {\n       int i = new X().test();\n       System.out.println(i);\n }\n}\n"}, "0");
    }

    public void testBug565156_003() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  public int test() {\n    return switch (0) {\n      default -> {\n        try {\n          yield 0;\n        }\n        finally {\n          int i = 20;          yield 20;        }\n      }\n    };\n  }    \n  public static void main(String[] args) {\n       int i = new X().test();\n       System.out.println(i);\n }\n}\n"}, "20");
    }

    public void testBug565156_004() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  public int test()  {\n    return switch (0) {\n      default -> {\n        try {\n          yield switch (0) {\n          default -> {\n              try {\n                yield 100;\n              }\n              finally {\n                   yield 200;       \n               }\n            }\n          };\n        }\n        finally {\n             yield 20;\n         }\n      }\n    };\n  }\n  public static void main(String[] args){\n       int i = new X().test();\n       System.out.println(i);\n  }\n}"}, "20");
    }

    public void testBug565156_005() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  public int test()  {\n    return switch (0) {\n      default -> {\n        try {\n          yield switch (0) {\n          default -> {\n              try {\n                yield 100;\n              }\n              finally {\n                   // do nothing\n               }\n            }\n          };\n        }\n        finally {\n           // do nothing\n         }\n      }\n    };\n  }\n  public static void main(String[] args){\n       int i = new X().test();\n       System.out.println(i);\n  }\n}"}, "100");
    }

    public void testBug565156_006() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static void main(String[] args) {\n            new X().foo(args);\n    }\n\n  @SuppressWarnings({ \"finally\" })\n  public void foo(String[] args) {\n     int t = switch (0) {\n     default -> {\n        try {\n            if (args == null)\n            yield 1;\n            else if (args.length ==2)\n                    yield 2; \n            else if (args.length == 4)\n                    yield 4;\n            else yield 5; \n        } finally {\n                yield 3; \n        }\n     }\n     }; \n     t = switch (100) {\n     default -> {\n             try {\n                     yield 10;\n             } finally {\n             }\n     }  \n     };      \n     System.out.println(t);\n  }\n}"}, "10");
    }

    public void testBug565156_007() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static void main(String[] args) {\n            new X().foo(args);\n    }\n\n  @SuppressWarnings({ \"finally\" })\n  public void foo(String[] args) {\n     int t = switch (0) {\n     case 101 -> {yield 101;}\n     default -> {\n        try {\n            if (args == null)\n            yield 1;\n            else if (args.length ==2)\n                    yield 2; \n            else if (args.length == 4)\n                    yield 4;\n            else yield 5; \n        } finally {\n                yield 3; \n        }\n     }\n     }; \n     t = switch (100) {\n     default -> {\n             try {\n                     yield 10;\n             } finally {\n             }\n     }  \n     };      \n     System.out.println(t);\n  }\n}"}, "10");
    }

    public void testBug547193_001() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args) {\n    System.out.println(switch (0) {default -> {\n      try {\n        yield 1;\n      } catch (Exception ex) {\n        yield 2;\n      }\n    }});\n  }\n}"}, "1");
    }

    public void testBug565844_01() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public final static int j = 5;\n    public static void main(String argv[]) {\n    \tboolean b = \n    \t\t\tswitch (j) {\n    \t\t\t\tcase j != 1 ? 2 : 3 ->  true;\n    \t\t\t\tdefault -> false;\n    \t\t\t}; \n    \tSystem.out.println(b);\n    }\n}"}, "false");
    }

    public void testBug565844_02() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public final static int j = 2;\n    public static void main(String argv[]) {\n    \tboolean b = \n    \t\t\tswitch (j) {\n    \t\t\t\tcase j != 1 ? 2 : (j == 2 ? 4 : 5) ->  true;\n    \t\t\t\tdefault -> false;\n    \t\t\t}; \n    \tSystem.out.println(b);\n    }\n}"}, "true");
    }

    public void testBug565844_03() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public final static int j = 5;\n    public static void main(String argv[]) {\n    \tboolean b = \n    \t\t\tswitch (j) {\n    \t\t\t\tcase j != 1 ? 2 : 3 ->  {\n    \t\t\t\t\t\tyield true;\n    \t\t\t\t\t}\n    \t\t\t\tdefault -> { yield false;}\n    \t\t\t}; \n    \tSystem.out.println(b);\n    }\n}"}, "false");
    }

    public void testBug565844_04() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public final static int j = 5;\n    public static void main(String argv[]) {\n    \tboolean b = \n    \t\t\tswitch (j) {\n    \t\t\t\tcase j != 1 ? 2 : 3 :  {\n    \t\t\t\t\t\tyield true;\n    \t\t\t\t\t}\n    \t\t\t\tdefault : { yield false;}\n    \t\t\t}; \n    \tSystem.out.println(b);\n    }\n}"}, "false");
    }

    public void testBug565844_05() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    public static int j = 5;\n    public static void main(String argv[]) {\n    \tboolean b = \n    \t\t\tswitch (j) {\n    \t\t\t\tcase j != 1 ? 2 : 3 ->  {\n    \t\t\t\t\t\tyield true;\n    \t\t\t\t\t}\n    \t\t\t\tdefault -> { yield false;}\n    \t\t\t}; \n    \tSystem.out.println(b);\n    }\n}"}, "----------\n1. ERROR in X.java (at line 6)\n\tcase j != 1 ? 2 : 3 ->  {\n\t     ^^^^^^^^^^^^^^\ncase expressions must be constant expressions\n----------\n");
    }

    public void testBug565844_06() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public final static int j = 5;\n    public static void main(String argv[]) {\n    \tboolean b = \n    \t\t\tswitch (j) {\n    \t\t\t\tcase j != 1 ? ( j != 1 ? 2: 3 ) : 3 -> false;\n    \t\t\t\tdefault -> false;\n    \t\t\t}; \n    \tSystem.out.println(b);\n    }\n}"}, "false");
    }

    public void testBug565844_07() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\n       void foo() {\n               Object value2 = switch(1) {\n                       case AAABBB -> 1;\n                               (I)()->();\n                       default -> 0;\n               };\n       }\n}\ninterface I {\n       void apply();\n}"}, "----------\n1. ERROR in X.java (at line 5)\n\tcase AAABBB -> 1;\n\t                ^\nSyntax error on token \";\", [ expected\n----------\n2. ERROR in X.java (at line 6)\n\t(I)()->();\n\t  ^^^^^\nSyntax error on token(s), misplaced construct(s)\n----------\n3. ERROR in X.java (at line 6)\n\t(I)()->();\n\t        ^\nSyntax error, insert \")\" to complete Expression\n----------\n4. ERROR in X.java (at line 6)\n\t(I)()->();\n\t        ^\nSyntax error, insert \"]\" to complete ArrayAccess\n----------\n5. ERROR in X.java (at line 6)\n\t(I)()->();\n\t        ^\nSyntax error, insert \":\" to complete SwitchLabel\n----------\n");
    }

    public void _testBug565844SwitchConst_07() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public final static int j = 5;\n    public static void main(String argv[]) {\n    \tboolean b = \n    \t\t\tswitch (j) {\n    \t\t\t\tcase switch(1) {default -> 2;} -> false;\n    \t\t\t\tdefault -> false;\n    \t\t\t}; \n    \tSystem.out.println(b);\n    }\n}"}, "false");
    }

    public void _testBug565844SwitchConst_08() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public final static int j = 5;\n    public static void main(String argv[]) {\n    \tboolean b = \n    \t\t\tswitch (j) {\n    \t\t\t\tcase switch(1) {case 1 -> 2; default -> 0;} -> false;\n    \t\t\t\tdefault -> false;\n    \t\t\t}; \n    \tSystem.out.println(b);\n    }\n}"}, "false");
    }

    public void _testBug565844SwitchConst_09() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public final static int j = 5;\n    public static void main(String argv[]) {\n    \tboolean b = \n    \t\t\tswitch (j) {\n    \t\t\t\tcase switch(1) {default -> 2;}, switch(2) {default -> 3;}  -> false;\n    \t\t\t\tdefault -> false;\n    \t\t\t}; \n    \tSystem.out.println(b);\n    }\n}"}, "false");
    }

    public void _testBug565844SwitchConst_10() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public final static int j = 5;\n    public static void main(String argv[]) {\n    \tboolean b = \n    \t\t\tswitch (j) {\n    \t\t\t\tcase switch(1) {case 1 -> 2; default -> 0;}, \t\t\t\t\t\t\tswitch(2) {case 1 -> 3; default -> 4;}  -> false;\n    \t\t\t\tdefault -> false;\n    \t\t\t}; \n    \tSystem.out.println(b);\n    }\n}"}, "false");
    }

    public void testBug566125_01() {
        this.runConformTest(new String[]{"X.java", "public class X  {\n\tpublic static void main(String[] args) {\n\t\tnew X().bar(0);\n\t}\n    @SuppressWarnings(\"deprecation\")\n    public void bar(int i) {\n\t\tboolean b = foo( switch(i+1) {\n\t    \tcase 0 -> new Short((short)0);\n\t    \tcase 2 -> new Double(2.0d);\n\t    \tdefault -> new Integer((short)6);\n    \t});\n    \tSystem.out.println(b);\n    }\n    boolean foo(short data){ return false; }\n    boolean foo(byte data){ return false; }\n    boolean foo(int data){ return false; }\n    boolean foo(float data){ return false; }\n    boolean foo(long data){ return false; }\n    boolean foo(double data){ return true; }\n}"}, "true");
    }

    public void testBug566125_02() {
        this.runConformTest(new String[]{"X.java", "public class X  {\n\tpublic static void main(String[] args) {\n\t\tnew X().bar(0);\n\t}\n    @SuppressWarnings(\"deprecation\")\n    public void bar(int i) {\n\t\tboolean b = foo( switch(i+1) {\n\t    \tcase 0 : yield new Short((short)0);\n\t    \tcase 2 : yield new Double(2.0d);\n\t    \tdefault : yield new Integer((short)6);\n    \t});\n    \tSystem.out.println(b);\n    }\n    boolean foo(short data){ return false; }\n    boolean foo(byte data){ return false; }\n    boolean foo(int data){ return false; }\n    boolean foo(float data){ return false; }\n    boolean foo(long data){ return false; }\n    boolean foo(double data){ return true; }\n}"}, "true");
    }

    public void testBug566125_03() {
        this.runConformTest(new String[]{"X.java", "public class X  {\n\tpublic static void main(String[] args) {\n\t\tnew X().bar(0);\n\t}\n    @SuppressWarnings(\"deprecation\")\n    public void bar(int i) {\n\t\tboolean b = foo( switch(i+1) {\n\t    \tcase 0 -> new Short((short)0);\n\t    \tcase 2 -> 2.0d;\n\t    \tdefault -> new Integer((short)6);\n    \t});\n    \tSystem.out.println(b);\n    }\n    boolean foo(short data){ return false; }\n    boolean foo(byte data){ return false; }\n    boolean foo(int data){ return false; }\n    boolean foo(float data){ return false; }\n    boolean foo(long data){ return false; }\n    boolean foo(double data){ return true; }\n}"}, "true");
    }

    public void testBug566125_04() {
        this.runConformTest(new String[]{"X.java", "public class X  {\n\tpublic static void main(String[] args) {\n\t\tnew X().bar(0);\n\t}\n    @SuppressWarnings(\"deprecation\")\n    public void bar(int i) {\n\t\tboolean b = foo( switch(i+1) {\n\t    \tcase 0 -> new Integer((short)0);\n\t    \tdefault -> 2l;\n    \t});\n    \tSystem.out.println(b);\n    }\n\tboolean foo(int data){ return false; }\n    boolean foo(long data){ return true; }\n}"}, "true");
    }

    public void testBug566125_05() {
        this.runConformTest(new String[]{"X.java", "public class X  {\n\tpublic static void main(String[] args) {\n\t\tnew X().bar(0);\n\t}\n    @SuppressWarnings(\"deprecation\")\n    public void bar(int i) {\n\t\tboolean b = foo(\n    \t\t\t\tswitch(i%2)  {\n    \t\t\t\t\tcase 1 -> switch(i) {\n    \t\t\t\t\t\t\t\tcase 1 -> new Byte((byte)1);\n    \t\t\t\t\t\t\t\tcase 3 -> new Float(3);\n    \t\t\t\t\t\t\t\tcase 5 -> new Long(5);\n    \t\t\t\t\t\t\t\tdefault -> new Short((short)6);\n    \t\t\t\t\t\t\t}; \n    \t\t\t\t\tdefault -> switch(i) {\n\t\t\t\t\t\t\t\t\tcase 0 -> new Integer((byte)2);\n\t\t\t\t\t\t\t\t\tcase 2 -> new Double(4);\n\t\t\t\t\t\t\t\t\tcase 4 -> new Long(6);\n\t\t\t\t\t\t\t\t\tdefault -> new Short((short)8);\n    \t\t\t\t\t\t\t};\n    \t\t\t\t}\n    \t\t\t);\n    \tSystem.out.println(b);\n    }\n    boolean foo(short data){ return false; }\n    boolean foo(byte data){ return false; }\n    boolean foo(int data){ return false; }\n    boolean foo(float data){ return false; }\n    boolean foo(long data){ return false; }\n    boolean foo(double data){ return true; }\n}"}, "true");
    }

    public void testBug566125_06() {
        this.runNegativeTest(new String[]{"X.java", "public class X  {\n\tpublic static void main(String[] args) {\n\t\tnew X().bar(0);\n\t}\n    @SuppressWarnings(\"deprecation\")\n    public void bar(int i) {\n\t\tboolean b = foo( switch(i+1) {\n\t    \tcase 0 -> Short.valueOf((short)0);\n\t    \tdefault -> Double.valueOf(2.0d);\n    \t});\n    \tSystem.out.println(b);\n    }\n    boolean foo(short data){ return false; }\n    boolean foo(byte data){ return false; }\n    boolean foo(int data){ return false; }\n    boolean foo(float data){ return false; }\n    boolean foo(long data){ return false; }\n}"}, "----------\n1. ERROR in X.java (at line 7)\n\tboolean b = foo( switch(i+1) {\n\t            ^^^\nThe method foo(short) in the type X is not applicable for the arguments (switch ((i + 1)) { ... })\n----------\n2. ERROR in X.java (at line 9)\n\tdefault -> Double.valueOf(2.0d);\n\t           ^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from Double to short\n----------\n");
    }

    public void testBug566125_07() {
        this.runNegativeTest(new String[]{"X.java", "public class X  {\n\tpublic static void main(String[] args) {\n\t\tnew X().bar(0);\n\t}\n    @SuppressWarnings(\"deprecation\")\n    public void bar(int i) {\n\t\tboolean b = foo( switch(i+1) {\n\t    \tcase 0 -> Short.valueOf((short)0);\n\t    \tdefault -> 2.0d;\n    \t});\n    \tSystem.out.println(b);\n    }\n    boolean foo(short data){ return false; }\n    boolean foo(byte data){ return false; }\n    boolean foo(int data){ return false; }\n    boolean foo(float data){ return false; }\n    boolean foo(long data){ return false; }\n}"}, "----------\n1. ERROR in X.java (at line 7)\n\tboolean b = foo( switch(i+1) {\n\t            ^^^\nThe method foo(short) in the type X is not applicable for the arguments (switch ((i + 1)) { ... })\n----------\n2. ERROR in X.java (at line 9)\n\tdefault -> 2.0d;\n\t           ^^^^\nType mismatch: cannot convert from double to short\n----------\n");
    }

    public void testBug566125_08() {
        this.runNegativeTest(new String[]{"X.java", "public class X  {\n\tpublic static void main(String[] args) {\n\t\tnew X().bar(0);\n\t}\n    @SuppressWarnings(\"deprecation\")\n    public void bar(int i) {\n\t\tboolean b = foo( switch(i+1) {\n\t    \tcase 0 : yield Short.valueOf((short)0);\n\t    \tdefault : yield 2.0d;\n    \t});\n    \tSystem.out.println(b);\n    }\n    boolean foo(short data){ return false; }\n    boolean foo(byte data){ return false; }\n    boolean foo(int data){ return false; }\n    boolean foo(float data){ return false; }\n    boolean foo(long data){ return false; }\n}"}, "----------\n1. ERROR in X.java (at line 7)\n\tboolean b = foo( switch(i+1) {\n\t            ^^^\nThe method foo(short) in the type X is not applicable for the arguments (switch ((i + 1)) { ... })\n----------\n2. ERROR in X.java (at line 9)\n\tdefault : yield 2.0d;\n\t                ^^^^\nType mismatch: cannot convert from double to short\n----------\n");
    }

    public void testBug567112_001() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.ArrayList;\n\npublic class X {\n    public void foo() {\n        new ArrayList<>().stream().filter(p -> p != null)\n        switch (\"\") {\n        case \"\":\n        }\n    }\n}"}, "----------\n1. ERROR in X.java (at line 5)\n\tnew ArrayList<>().stream().filter(p -> p != null)\n\t                                            ^^^^^\nSyntax error on tokens, delete these tokens\n----------\n2. ERROR in X.java (at line 8)\n\t}\n\t^\nSyntax error, insert \")\" to complete Expression\n----------\n3. ERROR in X.java (at line 8)\n\t}\n\t^\nSyntax error, insert \";\" to complete BlockStatements\n----------\n");
    }

    public void testBug571833_01() {
        this.runConformTest(new String[]{"X.java", "public class X {\n private static int foo(int a) {\n   int b = (int) switch (a) {\n     case 1 -> 1.0;\n     default -> 0;\n   };\n   return b;\n }\n\n public static void main(String[] args) {\n   int b = foo(2);\n   System.out.println(b);\n }\n}"}, "0");
    }

    public void testBug572382() {
        this.runConformTest(new String[]{"X.java", "import java.lang.invoke.MethodHandle;\n\npublic class X {\n\n\tObject triggerBug(MethodHandle method) throws Throwable {\n\t\treturn switch (0) {\n\t\tcase 0 -> method.invoke(\"name\");\n\t\tdefault -> null;\n\t\t};\n\t}\n}\n"}, (String)null);
    }

    public void testBug576026() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tenum E { A }\n\tstatic class C {\n\t\tE e = E.A;\n\t}\n\tpublic static void main(String[] args) {\n\t\tC c = new C();\n\t\tswitch (c.e) {\n\t\tcase A -> {\n\t\t\tSystem.out.println(\"Success\");\n\t\t}\n\t\tdefault -> System.out.println(\"Wrong\");\n\t\t}\n\t}\n}"}, "Success");
    }

    public void testBug576861_001() {
        this.runConformTest(new String[]{"X.java", "import java.util.Comparator;\n\npublic class X {\n public static void foo(Comparator<? super Long> comparator) {}\n\n public static void main(String[] args) {\n   int someSwitchCondition = 10;\n   X.foo(switch (someSwitchCondition) {\n   case 10 -> Comparator.comparingLong(Long::longValue);\n   default -> throw new IllegalArgumentException(\"Unsupported\");\n });\n   System.out.println(\"hello\");\n }\n}"}, "hello");
    }

    public void testBug577220_001() {
        this.runNegativeTest(new String[]{"module-info.java", "public class X {\n void main(Integer i) {\n   Object a = switch (i) {\n   default -> {\n     yield i.toString();\n   }\n   }\n }\n}"}, "----------\n1. ERROR in module-info.java (at line 1)\n\tpublic class X {\n\t             ^\nThe public type X must be defined in its own file\n----------\n2. ERROR in module-info.java (at line 5)\n\tyield i.toString();\n\t       ^\nSyntax error on token \".\", ; expected\n----------\n3. ERROR in module-info.java (at line 7)\n\t}\n\t^\nSyntax error, insert \";\" to complete BlockStatements\n----------\n");
    }

    public void testIssue966_001() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    private static final String SOME_CONSTANT = \"PASS\";\n    public static void main(String[] args) {\n        switch (\"\") {\n            case (SOME_CONSTANT) -> {}\n            default -> {}\n        }\n        System.out.println(SOME_CONSTANT);\n    }\n}"}, "PASS");
    }

    public void testGHIssue53() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tinterface I {\n\t\tvoid foo();\n\t}\n\tpublic static String string = \"a\";\n\n\tpublic static void main(String[] args) {\n\t\tloop: for (;;) {\n\t\t\tSystem.out.println(\"In loop before switch\");\n\t\t\t\n\t\t\tint result = 123 + switch (string) {\n\t\t\tcase \"a\" -> {\n\t\t\t\tif (string == null)\n\t\t\t\t\tcontinue; // incorrectly compiles in JDT\n\t\t\t\telse \n\t\t\t\t\tcontinue loop; // correctly flagged as error (\"Continue out of switch\n\t\t\t\t// expressions not permitted\")\n\t\t\t\t// javac (correctly) outputs \"error: attempt to continue out of a switch\n\t\t\t\t// expression\" for both continue statements\n\t\t\t\tyield 789;\n\t\t\t}\n\t\t\tdefault -> 456;\n\t\t\t};\n\t\t\tSystem.out.println(\"After switch. result: \" + result);\n\t\t}\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 8)\n\tloop: for (;;) {\n\t^^^^\nThe label loop is never explicitly referenced\n----------\n2. ERROR in X.java (at line 14)\n\tcontinue; // incorrectly compiles in JDT\n\t^^^^^^^^^\nContinue out of switch expressions not permitted\n----------\n3. ERROR in X.java (at line 16)\n\tcontinue loop; // correctly flagged as error (\"Continue out of switch\n\t^^^^^^^^^^^^^^\nContinue out of switch expressions not permitted\n----------\n");
    }

    public void testGH520() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid test(int i) {\n\t\tfoo(switch (i) {\n\t\t\tcase 0 -> m.call();\n\t\t\tdefault -> null;\n\t\t});\n\t}\n\t<T> void foo(T t) { }\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tfoo(switch (i) {\n\t^^^\nThe method foo(T) in the type X is not applicable for the arguments (switch (i) { ... })\n----------\n2. ERROR in X.java (at line 4)\n\tcase 0 -> m.call();\n\t          ^\nm cannot be resolved\n----------\n");
    }

    public void testGHI1394() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.codegen.useStringConcatFactory", "enabled");
        this.runConformTest(new String[]{"X.java", "public class X {\n\tprotected static int switchWithYield() {\n\t\tString myStringNumber = \"1\";\n\t\treturn switch (myStringNumber) {\n\t\tcase \"1\" -> {\n\t\t\ttry {\n\t\t\t\tyield Integer.parseInt(myStringNumber);\n\t\t\t} catch (NumberFormatException e) {\n\t\t\t\tthrow new RuntimeException(\"Failed parsing number\", e); //$NON-NLS-1$\n\t\t\t}\n\t\t}\n\t\tdefault -> throw new IllegalArgumentException(\"Unexpected value: \" + myStringNumber);\n\t\t};\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(switchWithYield());\n\t}\n} "}, "1", (Map)options);
    }

    public void testGHI1394_2() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.codegen.useStringConcatFactory", "enabled");
        this.runConformTest(new String[]{"X.java", "public class X {\n\tstatic String myStringNumber = \"1\";\n\tprotected static int switchWithYield() {\n\t\treturn switch (myStringNumber) {\n\t\tcase \"10\" -> {\n\t\t\ttry {\n\t\t\t\tyield Integer.parseInt(myStringNumber);\n\t\t\t} catch (NumberFormatException e) {\n\t\t\t\tthrow new RuntimeException(\"Failed parsing number\", e); //$NON-NLS-1$\n\t\t\t}\n\t\t}\n\t\tdefault -> throw new IllegalArgumentException(\"Unexpected value: \" + myStringNumber);\n\t\t};\n\t}\n\tpublic static void main(String[] args) {\n     try {\n\t\t    System.out.println(switchWithYield());\n     } catch(IllegalArgumentException iae) {\n         if (!iae.getMessage().equals(\"Unexpected value: \" + myStringNumber))\n             throw iae;\n     }\n     System.out.println(\"Done\");\n\t}\n} "}, "Done", (Map)options);
    }

    public void testGHI1394_min() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.codegen.useStringConcatFactory", "enabled");
        this.runConformTest(new String[]{"X.java", "public class X {\n\tstatic int foo() {\n\t\tint x = 1;\n\t\treturn switch (x) {\n\t\tcase 1 -> {\n\t\t\ttry {\n\t\t\t\tyield x;\n\t\t\t} finally  {\n\t\t\t\t\n\t\t\t}\n\t\t}\n\t\tdefault -> throw new RuntimeException(\"\" + x + \" \".toLowerCase());\n\t\t};\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(foo());\n\t}\n}\n"}, "1", (Map)options);
    }

    public void testGHI1727() {
        if (this.complianceLevel < 0x410000L) {
            return;
        }
        this.runConformTest(new String[]{"X.java", "class X {\n\tprivate Object foo(Object value) {\n\t\treturn switch (value) {\n\t\t\tcase String string -> {\n\t\t\t\ttry {\n\t\t\t\t\tyield string;\n\t\t\t\t} catch (IllegalArgumentException exception) {\n\t\t\t\t\tyield string;\n\t\t\t\t}\n\t\t\t}\n\t\t\tdefault -> throw new IllegalArgumentException(\"Argument of type \" + value.getClass());\n\t\t};\n\t}\n}\n"}, "");
    }

    public void testGHI1686() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\n\tpublic String demo(String input) {\n\t\treturn switch (input) {\n\t\t\tcase \"red\" -> {\n\t\t\t\tsynchronized (this) {\n\t\t\t\t\tyield \"apple\";\n\t\t\t\t}\n\t\t\t}\n\t\t\tdefault -> {\n\t\t\t\ttry {\n\t\t\t\t\tyield \"banana\";\n\t\t\t\t}\n\t\t\t\tcatch (Exception ex) {\n\t\t\t\t\tthrow new IllegalStateException(ex);\n\t\t\t    }\n\t\t    }\n\t    };\n    }\n}\n"}, "");
    }

    public void testGHI1686_works() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\n\tpublic String demo(String input) {\n\t\treturn switch (input) {\n\t\t\tcase \"red\" -> {\n\t\t\t\tsynchronized (this) {\n\t\t\t\t\tyield \"apple\";\n\t\t\t\t}\n\t\t\t}\n\t\t\tdefault -> {\n\t\t\t\tyield \"banana\";\n\t\t    }\n\t    };\n    }\n}\n"}, "");
    }

    public void testGHI1767() {
        if (this.complianceLevel < 0x410000L) {
            return;
        }
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static enum TestEnum {\n\t\tE1,\n\t\tE2,\n\t\tE3\n\t}\n\n\tpublic static void main(String[] theArgs) {\n\t\tSystem.out.println(\"Test case 1\");\n\t\tnew X().test1SwitchWithNull(TestEnum.E1);\n\t\tnew X().test1SwitchWithNull(TestEnum.E2);\n\t\tnew X().test1SwitchWithNull((TestEnum) null);\n\n\t\tSystem.out.println(\"Test case 2\");\n\t\tnew X().test2SwitchWithNull(TestEnum.E1);\n\t\tnew X().test2SwitchWithNull(TestEnum.E2);\n\t\tnew X().test2SwitchWithNull((TestEnum) null);\n\n\t\tSystem.out.println(\"Test case 3\");\n\t\tnew X().test3SwitchWithNull(TestEnum.E1);\n\t\tnew X().test3SwitchWithNull(TestEnum.E2);\n\t\tnew X().test3SwitchWithNull((TestEnum) null);\n\t}\n\n\tprivate void test1SwitchWithNull(TestEnum theEnum) {\n\t\tswitch (theEnum) {\n\t\t\tcase TestEnum e when e == TestEnum.E1 -> System.out.println(e);\n\t\t\tcase null -> System.out.println(\"Enum: null\");\n\t\t\tdefault -> System.out.println(\"Enum: default\");\n\t\t}\n\t}\n\n\tprivate void test2SwitchWithNull(TestEnum theEnum) {\n\t\tswitch (theEnum) {\n\t\t\tcase TestEnum e -> System.out.println(e);\n\t\t\tcase null -> System.out.println(\"Enum: null\");\n\t\t}\n\t}\n\n\tprivate void test3SwitchWithNull(TestEnum theEnum) {\n\t\tswitch (theEnum) {\n\t\t\tcase TestEnum.E1 -> System.out.println(theEnum);\n\t\t\tcase null -> System.out.println(\"Enum: null\");\n\t\t\tdefault -> System.out.println(\"Enum: default -> \" + theEnum);\n\t\t}\n\t}\n}\n"}, "Test case 1\nE1\nEnum: default\nEnum: null\nTest case 2\nE1\nE2\nEnum: null\nTest case 3\nE1\nEnum: default -> E2\nEnum: null");
    }

    public void testGHI1767_minimal() {
        if (this.complianceLevel < 0x410000L) {
            return;
        }
        this.runConformTest(new String[]{"X.java", "public class X {\n\tenum E {\n\t\tE\n\t}\n\n\tpublic static void main(String[] args) {\n\t\tE e = null;\n\t\tswitch(e) {\n\t\tcase E.E -> {}\n\t\tcase null -> {}\n\t\t}\n\t}\n}\n"}, "");
    }

    public void testGHI1820() {
        if (this.complianceLevel < 0x3C0000L) {
            return;
        }
        this.runConformTest(new String[]{"X.java", "public class X {\n\tstatic String method(Object element, int columnIndex) {\n\t\treturn element instanceof String data ?\n\t\t\tswitch (columnIndex) {\n\t\t\t\tcase 0 -> data;\n\t\t\t\tcase 1 -> data.toUpperCase();\n\t\t\t\tdefault -> \"Done\";\n\t\t\t} : \"\";\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(method(\"Blah\", 0));\n\t\tSystem.out.println(method(\"Blah\", 1));\n\t\tSystem.out.println(method(\"Blah\", 10));\n\t}\n}\n"}, "Blah\nBLAH\nDone");
    }

    public void testGHI1820_2() {
        if (this.complianceLevel < 0x3C0000L) {
            return;
        }
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tstatic String method(Object element, int columnIndex) {\n\t\treturn element instanceof String data ? \"\" :\n\t\t\tswitch (columnIndex) {\n\t\t\t\tcase 0 -> data;\n\t\t\t\tcase 1 -> data.toUpperCase();\n\t\t\t\tdefault -> \"\";\n\t\t\t};\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(method(\"Blah\", 1));\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tcase 0 -> data;\n\t          ^^^^\ndata cannot be resolved to a variable\n----------\n2. ERROR in X.java (at line 6)\n\tcase 1 -> data.toUpperCase();\n\t          ^^^^\ndata cannot be resolved\n----------\n");
    }

    public void testGHI1820_3() {
        if (this.complianceLevel < 0x3C0000L) {
            return;
        }
        this.runConformTest(new String[]{"X.java", "public class X {\n\tstatic String method(Object element, int columnIndex) {\n\t\treturn element instanceof String data ?\n\t\t\tswitch (columnIndex) {\n\t\t\t\tcase 0 -> { yield data; }\n\t\t\t\tcase 1 -> data.toUpperCase();\n\t\t\t\tdefault -> \"\";\n\t\t\t} : \"\";\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(method(\"Blah\", 1));\n\t}\n}\n"}, "BLAH");
    }

    public void testGHI1820_4() {
        if (this.complianceLevel < 0x3C0000L) {
            return;
        }
        this.runConformTest(new String[]{"X.java", "public class X {\n\tstatic String method(Object element, int columnIndex) {\n\t\treturn !(element instanceof String data) ? \"\" :\n\t\t\tswitch (columnIndex) {\n\t\t\t\tcase 0 -> data;\n\t\t\t\tcase 1 -> data.toUpperCase();\n\t\t\t\tdefault -> \"Done\";\n\t\t\t};\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(method(\"Blah\", 0));\n\t\tSystem.out.println(method(\"Blah\", 1));\n\t\tSystem.out.println(method(\"Blah\", 10));\n\t}\n}\n"}, "Blah\nBLAH\nDone");
    }

    public void testGHI1820_5() {
        if (this.complianceLevel < 0x3C0000L) {
            return;
        }
        this.runConformTest(new String[]{"X.java", "public class X {\n\tstatic String method(Object element, int columnIndex) {\n\t\tif (element instanceof String string) {\n\t\t\treturn element instanceof String data ?\n\t\t\t\tswitch (columnIndex) {\n\t\t\t\t\tcase 0 -> data;\n\t\t\t\t\tcase 1 -> string.toUpperCase();\n\t\t\t\t\tdefault -> \"Done\";\n\t\t\t\t} : \"\";\n\t\t}\n\t\treturn null;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(method(\"Blah\", 0));\n\t\tSystem.out.println(method(\"Blah\", 1));\n\t\tSystem.out.println(method(\"Blah\", 10));\n\t}\n}\n"}, "Blah\nBLAH\nDone");
    }

    public void testGH377() {
        if (this.complianceLevel < 0x3C0000L) {
            return;
        }
        this.runConformTest(new String[]{"X.java", "public class X {\n\n  enum TestEnum {\n    A, B;\n  }\n\n  @SuppressWarnings(\"unused\")\n  private int switcher(final TestEnum e) throws Exception {\n    return switch (e) {\n      case A -> 0;\n      case B -> {\n        try {\n          yield 1;\n        } finally {\n          throwingFn();\n        }\n      }\n    };\n  }\n\n  private void throwingFn() throws Exception {}\n\n  public static void main(String [] args) throws Exception {\n\t  System.out.println(\"Switcher :\" + new X().switcher(TestEnum.A));\n\t  System.out.println(\"Switcher :\" + new X().switcher(TestEnum.B));\n  }\n   }\n"}, "Switcher :0\nSwitcher :1");
    }

    public void testIssue2231() {
        if (this.complianceLevel < 0x410000L) {
            return;
        }
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void foo(String... ss) {\n\t\tSystem.out.println(\"Entry = \" + switch(ss) {\n\t\t\t\t\t\t\t\t\t\t\tcase null -> \"None\";\n\t\t\t\t\t\t\t\t\t\t\tcase String [] s when s.length == 0 -> \"none\";\n\t\t\t\t\t\t\t\t\t\t\tdefault ->  {\n\t\t\t\t\t\t\t\t\t\t\t\ttry {\n\t\t\t\t\t\t\t\t\t\t\t\t\tyield ss[0];\n\t\t\t\t\t\t\t\t\t\t\t\t} finally {\n\n\t\t\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t\t\t}\n\t\t});\n\t}\n\n\tpublic static void main(String[] args) {\n\t\tfoo(\"Hello\");\n\t}\n}\n"}, "Entry = Hello");
    }

    public void testIssue2231_2() {
        if (this.complianceLevel < 0x410000L) {
            return;
        }
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void foo(String [] ss) {\n\t\tSystem.out.println(\"Entry = \" + switch(ss) {\n\t\t\t\t\t\t\t\t\t\t\tcase null -> \"None\";\n\t\t\t\t\t\t\t\t\t\t\tcase String [] s when s.length == 0 -> \"none\";\n\t\t\t\t\t\t\t\t\t\t\tdefault ->  {\n\t\t\t\t\t\t\t\t\t\t\t\ttry {\n\t\t\t\t\t\t\t\t\t\t\t\t\tyield ss[0];\n\t\t\t\t\t\t\t\t\t\t\t\t} finally {\n\n\t\t\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t\t\t}\n\t\t});\n\t}\n\n\tpublic static void main(String[] args) {\n\t\tfoo(new String [] { \"Hello\" });\n\t}\n}\n"}, "Entry = Hello");
    }

    public void testIssue2228() {
        if (this.complianceLevel < 0x410000L) {
            return;
        }
        this.runConformTest(new String[]{"X.java", "public class X {\n\tint k;\n\tvoid foo() {\n\t\tnew X() {\n\t\t\t{\n\t\t\t\tSystem.out.println (\"Switch Expr = \" +  switch (X.this.k) {\n\t\t\t\tdefault -> {\n\t\t\t\t\ttry {\n\t\t\t\t\t\tyield throwing();\n\t\t\t\t\t} catch (NumberFormatException nfe) {\n\t\t\t\t\t\tyield 10;\n\t\t\t\t\t}\n\t\t\t\t\tfinally {\n\t\t\t\t\t\tSystem.out.println(\"Finally\");\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t});\n\t\t\t}\n\n\t\t\tprivate Object throwing() {\n\t\t\t\tthrow new NumberFormatException();\n\t\t\t}\n\t\t};\n\t}\n\n\tpublic static void main(String[] args) {\n\t\tnew X().foo();\n\t}\n}\n"}, "Finally\nSwitch Expr = 10");
    }

    public void testIssue2228_2() {
        if (this.complianceLevel < 0x410000L) {
            return;
        }
        this.runConformTest(new String[]{"X.java", "public class X {\n\tint k;\n\tvoid foo() {\n\t\tint fooLocal = 10;\n\t\tclass Local {\n\t\t\tLocal() {\n\t\t\t\tSystem.out.println(\"Switch result = \" + switch(X.this.k) {\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tdefault -> {\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\ttry {\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tSystem.out.println(\"Try\");\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tyield 10;\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t} catch (Exception e) {\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tSystem.out.println(\"Catch\");\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tyield 20;\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t} finally {\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tSystem.out.println(\"Finally\");\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t});\n\t\t\t}\n\t\t}\n\t\tnew Local();\n\t}\n\tpublic static void main(String[] args) {\n\t\tnew X().foo();\n\t}\n}\n"}, "Try\nFinally\nSwitch result = 10");
    }

    public void testIssue2228_3() {
        if (this.complianceLevel < 0x410000L) {
            return;
        }
        this.runConformTest(new String[]{"X.java", "public class X {\n\n\tint k;\n\n\t{\n\t\tSystem.out.println (\"Switch Expr = \" +  switch (k) {\n\t\tdefault -> {\n\t\t\ttry {\n\t\t\t\tyield throwing();\n\t\t\t} catch (NumberFormatException nfe) {\n\t\t\t\tyield 10;\n\t\t\t}\n\t\t\tfinally {\n\t\t\t\tSystem.out.println(\"Finally\");\n\t\t\t}\n\t\t}\n\t});\n\t}\n\tprivate Object throwing() {\n\t\tthrow new NumberFormatException();\n\t}\n\tpublic static void main(String[] args) {\n\t\tnew X();\n\t}\n}\n"}, "Finally\nSwitch Expr = 10");
    }

    public void testIssue2228_4() {
        if (this.complianceLevel < 0x410000L) {
            return;
        }
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\targs = new String [] { \"one\" , \"two\"};\n\t\tSystem.out.println(switch (args) {\n\t\t\tcase null ->  0;\n\t\t\tdefault -> switch(args.length) {\n\t\t\t\t\t\t\tcase 0 -> 0;\n\t\t\t\t\t\t\tcase 1 -> \"One\";\n\t\t\t\t\t\t\tdefault -> new X();\n\t\t\t\t\t\t};\n\t\t\t});\n\t}\n\tpublic String toString() {\n\t\treturn \"some X()\";\n\t}\n}\n"}, "some X()");
    }

    public void testIssue2228_5() {
        if (this.complianceLevel < 0x410000L) {
            return;
        }
        this.runConformTest(new String[]{"X.java", "public class X {\n\tint k;\n\tvoid foo() {\n\t\tString val = \"123\";\n\t\tnew X() {\n\t\t\t{\n\t\t\t\tSystem.out.println (\"Switch Expr = \" +  switch (X.this.k) {\n\t\t\t\tdefault -> {\n\t\t\t\t\ttry {\n\t\t\t\t\t\tyield throwing();\n\t\t\t\t\t} catch (NumberFormatException nfe) {\n\t\t\t\t\t\tyield val;\n\t\t\t\t\t}\n\t\t\t\t\tfinally {\n\t\t\t\t\t\tSystem.out.println(\"Finally\");\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t});\n\t\t\t}\n\n\t\t\tprivate Object throwing() {\n\t\t\t\tthrow new NumberFormatException();\n\t\t\t}\n\t\t};\n\t}\n\n\tpublic static void main(String[] args) {\n\t\tnew X().foo();\n\t}\n}\n"}, "Finally\nSwitch Expr = 123");
    }

    public void testIssue2228_6() {
        if (this.complianceLevel < 0x410000L) {
            return;
        }
        this.runConformTest(new String[]{"X.java", "public class X {\n\n\tstatic int k;\n\n\tstatic {\n\t\tSystem.out.println (\"Switch Expr = \" +  switch (k) {\n\t\tdefault -> {\n\t\t\ttry {\n\t\t\t\tyield throwing();\n\t\t\t} catch (NumberFormatException nfe) {\n\t\t\t\tyield 10;\n\t\t\t}\n\t\t\tfinally {\n\t\t\t\tSystem.out.println(\"Finally\");\n\t\t\t}\n\t\t}\n\t});\n\t}\n\tprivate static Object throwing() {\n\t\tthrow new NumberFormatException();\n\t}\n\tpublic static void main(String[] args) {\n\t\tnew X();\n\t}\n}\n"}, "Finally\nSwitch Expr = 10");
    }

    public void testIssue2233() {
        if (this.complianceLevel < 0x3C0000L) {
            return;
        }
        this.runConformTest(new String[]{"X.java", "public enum X {\n\tPARAMETER, FIELD, METHOD;\n\tX() {\n\t\tSystem.out.println(switch (this) {\n\t\t\t\t\t\t\t\tdefault -> {\n\t\t\t\t\t\t\t\t\ttry {\n\t\t\t\t\t\t\t\t\t\tyield 10;\n\t\t\t\t\t\t\t\t\t} finally {\n\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t});\n\t}\n\n    public static void notmain(String [] args) {\n        X x = PARAMETER;\n        System.out.println(x);\n    }\n}\n"}, "");
    }

    public void testIssue2322() {
        if (this.complianceLevel < 0x3A0000L) {
            return;
        }
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String [] args) {\n    int lineCount = 10;\n    long time = 1000;\n    print((int) (lineCount * 10000.0 / time));\n    print((double) (lineCount * 10000.0 / time));\n    System.out.println(switch(lineCount) {\n        default -> {\n    \ttry {\n    \t\tyield \"OK\";\n    \t} finally {\n\n    \t}\n        }\n    });\n  }\n  static void print(double d) {}\n}\n"}, "OK");
    }

    public void testIssue2335() {
        if (this.complianceLevel < 0x3A0000L) {
            return;
        }
        this.runConformTest(new String[]{"X.java", "public final class X {\n\n  public void show() {\n\n    int size1 = 1;\n    int size2 = 2;\n    int size3 = 3;\n\n    short[][][] array = new short[size1][size2][size3];\n\n    for (int i = 0; i < size1; i++) {\n      for (int j = 0; j < size2; j++) {\n        boolean on = false;\n        for (int k = 0; k < size3; k++) {\n          array[i][j][k] = on ? (short) 1 : (short) 0;\n        }\n      }\n    }\n    System.out.println(switch(42) {\n    \tdefault -> {\n    \t\ttry {\n    \t\t\tyield 42;\n    \t\t} finally {\n\n    \t\t}\n    \t}\n    });\n\n  }\n\n  public static void main(String[] args) {\n    new X().show();\n  }\n}\n"}, "42");
    }

    public void testIssue2335_min() {
        if (this.complianceLevel < 0x3A0000L) {
            return;
        }
        this.runConformTest(new String[]{"X.java", "public final class X {\n  public static void main(String[] args) {\n\t   short[] array = new short[10];\n\n\t    for (int i = 0; i < 10; i++) {\n\t        boolean on = false;\n\t          array[i] = on ? (short) 1 : (short) 0;\n\t    }\n\t    System.out.println(switch(42) {\n\t    \tdefault -> {\n\t    \t\ttry {\n\t    \t\t\tyield 42;\n\t    \t\t} finally {\n\n\t    \t\t}\n\t    \t}\n\t    });\n  }\n}\n"}, "42");
    }

    public void testIssue2335_other() {
        if (this.complianceLevel < 0x3A0000L) {
            return;
        }
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(switch (1) {\n\t\tdefault -> {\n\t\t\ttry {\n\t\t\t\tSystem.out.println(switch (10) { default -> { try { yield 10; } finally {} } });\n\t\t\t} finally {}\n\t\t\tyield 1;\n\t\t}\n\t\t});\n\t}\n\tX() {}\n}\n"}, "10\n1");
    }

    public void testIssue2349() {
        if (this.complianceLevel < 0x3A0000L) {
            return;
        }
        this.runConformTest(new String[]{"X.java", "interface I {\n\tint doit();\n}\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tI i = () -> {\n\t\t\treturn 10 + switch (10) {\n\t\t\t\tdefault -> { try { yield 32; } catch (NullPointerException npe) { yield -10; } }\n\t\t};\n\t\t};\n\t\tSystem.out.println(i.doit());\n\t}\n}\n"}, "42");
    }

    public void testIssue2360() {
        if (this.complianceLevel < 0x3A0000L) {
            return;
        }
        this.runConformTest(new String[]{"X.java", "interface I {\n\tvoid foo(int p, int q);\n}\npublic class X {\n   int f;\n\tvoid foo(int a) {\n       int loc = 10;\n\t\tI i = (int p, int q)  -> {\n           I i2 = new I() { public void foo(int f, int p0) {};};\n           System.out.println(10 + switch (10) {\n\t\t\tdefault -> { try { yield 32; } catch (NullPointerException npe) { yield -10; } }});\n\t\t\tSystem.out.println(10 + switch (loc) {\n\t\t\tdefault -> { try { yield 0; } catch (NullPointerException npe) { yield -10; } }});\n\t\t\tSystem.out.println(10 + switch (p) {\n\t\t\tdefault -> { try { yield p; } catch (NullPointerException npe) { yield -10; } }});\n\t\t\tSystem.out.println(10 + switch (q) {\n\t\t\tdefault -> { try { yield q; } catch (NullPointerException npe) { yield -10; } }});\n\t\t};\n\t\ti.foo(10,  20);\n\t}\n\n\tpublic static void main(String[] args) {\n\t\tnew X().foo(42);\n\t}\n}\n"}, "42\n10\n20\n30");
    }

    public void testIssue2360_2() {
        if (this.complianceLevel < 0x3A0000L) {
            return;
        }
        this.runConformTest(new String[]{"X.java", "interface I {\n\tvoid foo(int p, int q);\n}\npublic class X {\n   int f;\n\tvoid foo(int a) {\n       int loc;\n\t\tI i = (int p, int q)  -> {\n           I i2 = new I() { public void foo(int f, int p0) {};};\n           System.out.println(10 + switch (10) {\n\t\t\tdefault -> { try { yield 32; } catch (NullPointerException npe) { yield -10; } }});\n\t\t};\n\t\ti.foo(10,  20);\n\t}\n\n\tpublic static void main(String[] args) {\n\t\tnew X().foo(42);\n\t}\n}\n"}, "42");
    }

    public void testIssue2363() {
        if (this.complianceLevel < 0x3A0000L) {
            return;
        }
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String argv[]) {\n\t\tSystem.out.println(void.class == Void.TYPE);\n\t\tSystem.out.println(switch(42) {\n    \tdefault -> {\n    \t\ttry {\n    \t\t\tyield 42;\n    \t\t} finally {\n\n    \t\t}\n    \t}\n    });\n\n\t}\n}\n"}, "true\n42");
    }

    public void testIssue2366() {
        if (this.complianceLevel < 0x3A0000L) {
            return;
        }
        this.runConformTest(new String[]{"X.java", "public class X {\n  public X() {\n    super();\n  }\n  public static void foo() {\n    X z;\n    while (((z = getObject()) != null))      {\n        z.bar();\n      }\n    System.out.println(switch(42) {\n\t  default -> {\n\t\ttry {\n\t\t\tyield 42;\n\t\t} finally {\n\n\t\t}\n\t  }\n    });\n  }\n  public void bar() {\n  }\n  public static X getObject() {\n    return null;\n  }\n  public static void main(String[] args) {\n    new X().foo();\n  }\n}\n"}, "42");
    }

    public void testIssue2382() {
        if (this.complianceLevel < 0x3A0000L) {
            return;
        }
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\n  public static void main(String[] args) {\n    double d = 3;\n\n    double r = switch (d) {\n      case 1.0 -> 0.2;\n      case 2.0 -> 0.5;\n      case 8.0 -> 2;\n      case 9.0 -> 3;\n      default -> 3;\n    };\n    System.out.println(r);\n  }\n\n  X() {}\n\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tdouble r = switch (d) {\n\t                   ^\nCannot switch on a value of type double. Only convertible int values, strings or enum variables are permitted\n----------\n");
    }

    public void testIssue2382_2() {
        if (this.complianceLevel < 0x3A0000L) {
            return;
        }
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\n  public static void main(String[] args) {\n    long d = 3;\n\n    double r = switch (d) {\n      case 1.0 -> 0.2;\n      case 2.0 -> 0.5;\n      case 8.0 -> 2;\n      case 9.0 -> 3;\n      default -> 3;\n    };\n    System.out.println(r);\n  }\n\n  X() {}\n\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tdouble r = switch (d) {\n\t                   ^\nCannot switch on a value of type long. Only convertible int values, strings or enum variables are permitted\n----------\n");
    }

    public void testIssue2382_3() {
        if (this.complianceLevel < 0x3A0000L) {
            return;
        }
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\n  public static void main(String[] args) {\n    float d = 3;\n\n    double r = switch (d) {\n      case 1.0 -> 0.2;\n      case 2.0 -> 0.5;\n      case 8.0 -> 2;\n      case 9.0 -> 3;\n      default -> 3;\n    };\n    System.out.println(r);\n  }\n\n  X() {}\n\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tdouble r = switch (d) {\n\t                   ^\nCannot switch on a value of type float. Only convertible int values, strings or enum variables are permitted\n----------\n");
    }

    public void testIssue2382_4() {
        if (this.complianceLevel < 0x3A0000L) {
            return;
        }
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\n  public static void main(String[] args) {\n    boolean d = true;\n\n    double r = switch (d) {\n      default -> 3;\n    };\n    System.out.println(r);\n  }\n\n  X() {}\n\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tdouble r = switch (d) {\n\t                   ^\nCannot switch on a value of type boolean. Only convertible int values, strings or enum variables are permitted\n----------\n");
    }

    public void testIssue2382_5() {
        if (this.complianceLevel < 0x3A0000L) {
            return;
        }
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\n  public static void main(String[] args) {\n    double d = 3;\n\n    switch (d) {\n      case 1.0 -> System.out.println(d);\n    };\n\n  }\n\n  X() {}\n\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tswitch (d) {\n\t        ^\nCannot switch on a value of type double. Only convertible int values, strings or enum variables are permitted\n----------\n");
    }

    public void testIssue2382_6() {
        if (this.complianceLevel < 0x3A0000L) {
            return;
        }
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\n              static void foo() {}\n  public static void main(String[] args) {\n    double d = 3;\n\n    switch (foo()) {\n      case 1.0 -> System.out.println(d);\n    };\n\n  }\n\n  X() {}\n\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tswitch (foo()) {\n\t        ^^^^^\nThis expression yields no value\n----------\n");
    }

    public void testIssue2382_7() {
        if (this.complianceLevel < 0x3A0000L) {
            return;
        }
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\n              static void foo() {}\n  public static void main(String[] args) {\n    double d = 3;\n\n    switch (null) {\n      case null -> System.out.println(d);\n    };\n\n  }\n\n  X() {}\n\n}\n"}, this.complianceLevel < 0x410000L ? "----------\n1. ERROR in X.java (at line 7)\n\tswitch (null) {\n\t        ^^^^\nCannot switch on a value of type null. Only convertible int values, strings or enum variables are permitted\n----------\n2. ERROR in X.java (at line 8)\n\tcase null -> System.out.println(d);\n\t     ^^^^\nThe Java feature 'Pattern Matching in Switch' is only available with source level 21 and above\n----------\n" : "----------\n1. ERROR in X.java (at line 7)\n\tswitch (null) {\n\t        ^^^^\nAn enhanced switch statement should be exhaustive; a default label expected\n----------\n");
    }

    public void testIssue2382_8() {
        if (this.complianceLevel < 0x410000L) {
            return;
        }
        this.runConformTest(new String[]{"X.java", "public class X {\n\n              static void foo() {}\n  public static void main(String[] args) {\n    double d = 3;\n\n    switch (null) {\n      case null -> System.out.println(d);\n      default -> System.out.println(\"Default\");\n    };\n\n  }\n\n  X() {}\n\n}\n"}, "3.0");
    }

    public void testIssue2382_9() {
        if (this.complianceLevel < 0x3A0000L) {
            return;
        }
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\n              static void foo() {}\n  public static void main(String[] args) {\n    double d = 3;\n\n    switch (foo()) {\n      case null -> System.out.println(d);\n    };\n\n  }\n\n  X() {}\n\n}\n"}, this.complianceLevel < 0x410000L ? "----------\n1. ERROR in X.java (at line 7)\n\tswitch (foo()) {\n\t        ^^^^^\nThis expression yields no value\n----------\n2. ERROR in X.java (at line 8)\n\tcase null -> System.out.println(d);\n\t     ^^^^\nThe Java feature 'Pattern Matching in Switch' is only available with source level 21 and above\n----------\n" : "----------\n1. ERROR in X.java (at line 7)\n\tswitch (foo()) {\n\t        ^^^^^\nThis expression yields no value\n----------\n2. ERROR in X.java (at line 7)\n\tswitch (foo()) {\n\t        ^^^^^\nAn enhanced switch statement should be exhaustive; a default label expected\n----------\n");
    }

    public void testIssue2387() {
        if (this.complianceLevel < 0x3A0000L) {
            return;
        }
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tstatic class Y {}\n\tvoid foo() {\n\t\tnew X().new Y(){};\n\t\tSystem.out.println(switch (42) {\n\t\tdefault -> {\n\t\t\ttry {\n\t\t\t\tyield 42;\n\t\t\t} finally {\n\n\t\t\t}\n\t\t}\n\t\t});\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tnew X().new Y(){};\n\t^^^^^^^\nIllegal enclosing instance specification for type X.Y\n----------\n");
    }

    public void testIssue2423() {
        if (this.complianceLevel < 0x3A0000L) {
            return;
        }
        this.runConformTest(new String[]{"X.java", "public class X {\n\tstatic String getString(int i) {\n\t\tSystem.out.println(switch (42) {\n\t\tdefault -> {\n\t\t\ttry {\n\t\t\t\tyield 42;\n\t\t\t} finally {\n\n\t\t\t}\n\t\t}\n\t\t});\n\t\treturn new String[] { \"Hello\", \"World\" }[i];\n\t}\n\tpublic static void main(String [] args) {\n\t\tSystem.out.println(getString(0));\n\t}\n}\n"}, "42\nHello");
    }

    public void testIssue2447() {
        if (this.complianceLevel < 0x3A0000L) {
            return;
        }
        this.runConformTest(new String[]{"X.java", "public class X {\n\n\tstatic void foo(long l) {\n\n\t}\n\tpublic static void main(String[] args) {\n\t\tlong [] larray = { 10 };\n\n\t\tfoo(larray[0] = 10);\n\t\tSystem.out.println(switch (42) {\n\t\tdefault -> {\n\t\t\ttry {\n\t\t\t\tyield 42;\n\t\t\t} finally {\n\n\t\t\t}\n\t\t}\n\t\t});\n\t}\n}\n"}, "42");
    }

    public void testIssue2451() {
        if (this.complianceLevel < 0x3A0000L) {
            return;
        }
        this.runConformTest(new String[]{"X.java", "import java.util.HashMap;\nimport java.util.Map;\n\npublic class X {\n\n\tstatic void foo(long l) {\n\n\t}\n\n\tprivate static Map<String, Long> getLevelMapTable() {\n\t\tMap<String, Long> t = new HashMap<>();\n\t\tt.put(null, 0l);\n\n\n\t\tSystem.out.println(switch (42) {\n\t\tdefault -> {\n\t\t\ttry {\n\t\t\t\tyield 42;\n\t\t\t} finally {\n\n\t\t\t}\n\t\t}\n\t\t});\n\t\treturn null;\n\t}\n\n\tpublic static void main(String[] args) {\n\t\tgetLevelMapTable();\n\t}\n}\n"}, "42");
    }

    public void testIssue2453() {
        if (this.complianceLevel < 0x3A0000L) {
            return;
        }
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(double.class);\n\t\tSystem.out.println(switch (42) {\n\t\tdefault -> {\n\t\t\ttry {\n\t\t\t\tyield 42;\n\t\t\t} finally {\n\n\t\t\t}\n\t\t}\n\t\t});\n\t}\n}\n"}, "double\n42");
    }

    public void testIssue2455() {
        if (this.complianceLevel < 0x3A0000L) {
            return;
        }
        this.runConformTest(new String[]{"X.java", "public class X {\n\tstatic void foo(String s, int i) {\n\t\tSystem.out.println(\"String = \" + s + \" int = \" + i);\n\t}\n\tpublic static void main(String[] args) {\n\n\t\tfoo(\"Hello\", switch (42) {\n\t\tdefault -> {\n\t\t\ttry {\n\t\t\t\tyield 42;\n\t\t\t} finally {\n\n\t\t\t}\n\t\t}\n\t\t});\n\t}\n}\n"}, "String = Hello int = 42");
    }

    public void testIssue2485() {
        if (this.complianceLevel < 0x3A0000L) {
            return;
        }
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static int convertOpcode(int from, int to) {\n        return switch (from) {\n            case 42 ->\n                   switch (to) {\n                       case 42 -> 42;\n                       default -> throw new UnsupportedOperationException();\n                   };\n            default -> throw new UnsupportedOperationException();\n        };\n    }\n    public static void main(String [] args) {\n        System.out.println(\"With 42 & 42 = \" + convertOpcode(42, 42));\n       }\n}\n"}, "With 42 & 42 = 42");
    }

    public void testIssue2476() {
        if (this.complianceLevel < 0x3A0000L) {
            return;
        }
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tboolean b = args != null;\n\t\tfoo(X[].class, b ? switch (42) {\n\t\tdefault -> {\n\t\t\ttry {\n\t\t\t\tyield 42;\n\t\t\t} finally {\n\n\t\t\t}\n\t\t}\n\t\t} : 10);\n\t}\n\n\tstatic void foo(Class<?> c, int v) {\n\t\tSystem.out.println(c);\n\t\tSystem.out.println(v);\n\t}\n}\n"}, "class [LX;\n42");
    }

    public void testMixingCaseStyles() {
        if (this.complianceLevel < 0x3A0000L) {
            return;
        }
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\t int i = switch(args.length) {\n\t\t\t case 2: yield 2;\n\t\t\t default -> 1;\n\t\t\t case 1 : yield 2;\n\t\t };\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tdefault -> 1;\n\t^^^^^^^\nMixing of '->' and ':' case statement styles is not allowed within a switch\n----------\n");
    }

    public void testIssue3205() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tvoid foo();\n}\n\ninterface J {\n\tvoid foo();\n}\n\npublic class X implements I, J {\n\n\tpublic void foo() {\n\t}\n\n\tstatic void doit() {}\n\n\tpublic static void foo(Object o, J j) {\n\t\tSystem.out.println(\"Object\");\n\t}\n\n\tpublic static void foo(String s, I i) {\n\t\tSystem.out.println(s);\n\t}\n\n\tpublic static void main(String[] args) {\n\n\t\t// Compiles with both ECJ and javac\n\t\tfoo(\"OK\", () -> {});\n\n\t\t// Compiles with both ECJ and javac\n\t\tfoo(\"OK\", args == null ? () -> {} : () -> {});\n\n\t\t// Compiles with both ECJ and javac\n\t\tfoo(\"OK\", X::doit);\n\n\t\t// Rejected by both ECJ and javac.\n\t\t//foo(\"OK\", new X());\n\n\t\t// Rejected by javac, accepted by ECJ.\n\t\tfoo(\"OK\", switch (0) {\n\t\t\t\t\t \tcase 0 -> () -> {};\n\t\t\t\t\t \tdefault -> () -> {};\n\t\t});\n\t}\n}\n"}, "OK\nOK\nOK\nOK");
    }

    public void testIssue3205_2() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tvoid foo();\n}\n\ninterface J {\n\tvoid foo();\n}\n\npublic class X implements I, J {\n\n\tpublic void foo() {\n\t}\n\n\tstatic void doit() {}\n\n\tpublic static void foo(Object o, J j) {\n\t\tSystem.out.println(\"Object\");\n\t}\n\n\tpublic static void foo(String s, I i) {\n\t\tSystem.out.println(s);\n\t}\n\n\tpublic static void main(String[] args) {\n\n\t\t// Compiles with both ECJ and javac\n\t\tfoo(\"OK\", () -> {});\n\n\t\t// Compiles with both ECJ and javac\n\t\tfoo(\"OK\", args == null ? () -> {} : () -> {});\n\n\t\t// Compiles with both ECJ and javac\n\t\tfoo(\"OK\", X::doit);\n\n\t\t// Rejected by both ECJ and javac.\n\t\tfoo(\"OK\", new X());\n\n\t\t// Rejected by javac, accepted by ECJ.\n\t\tfoo(\"OK\", switch (0) {\n\t\t\t\t\t \tcase 0 -> () -> {};\n\t\t\t\t\t \tdefault -> () -> {};\n\t\t});\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 36)\n\tfoo(\"OK\", new X());\n\t^^^\nThe method foo(Object, J) is ambiguous for the type X\n----------\n");
    }

    public void testBug542559_0012() {
        this.runConformTest(new String[]{"X.java", "import java.util.function.Supplier;\ninterface I0 { void i(); }\ninterface I1 extends I0 {}\ninterface I2 extends I0 {}\npublic class X {\n\tI1 n1() { return null; }\n\t<I extends I2> I n2() { return null; }\n\n\tvoid test(int i, boolean b) {\n\t\tm(switch (i) {\n\t\t\tcase 1 -> this::n1;\n\t\t\tdefault -> this::n2;\n\t\t}).i();\n\t}\n\n\t<M> M m(Supplier<M> m) { return m.get(); }\n\n\tpublic static void main(String[] args) {\n\t\ttry {\n\t\t\tnew X().test(1, true);\n\t\t} catch (NullPointerException e) {\n\t\t\tSystem.out.println(\"NPE as expected!\");\n\t\t}\n\t}\n}\n"}, "NPE as expected!");
    }

    public void _testBug545567_22_minimal() {
        this.runConformTest(new String[]{"X.java", "public class X implements AutoCloseable {\n   public static void main(String[] args) {\n       int t = switch (1) {\n               default -> {\n                   try (X x = new X()) {\n                       if (args.length < 1)\n                    \t   yield 10;\n                       else\n                           yield 12;\n                       } finally {\n                            yield 3;\n                       }\n               }\n       };\n       System.out.println(t);\n   }\n\n   public void close() throws Exception {}\n}\n"}, "3");
    }

    public void testConditionalSwitchLabel() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static void main(String[] args) {\n        var foo = switch (10) {\n            case (10 > 20 ? 10 :  10) : yield \"special\" ;\n            default : yield \"default value\";\n        };\n        System.out.println(foo);\n    }\n\n}\n"}, "special");
    }

    public void testIssue3283() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static int var = 0;\n\tpublic static void main(String argv[]) {\n        int j = switch(var){\n        case 0: yield (0 + 42); // If this is removed, there's a different error\n        case 1: // If I remove this line, the error goes away\n        case 2: yield 1; // multiple errors\n        default:\n          throw new IllegalArgumentException(\"Unexpected value: \" + var);\n    };\n    System.out.println(\"Yield = \" + j);\n    }\n}\n"}, "Yield = 42");
    }

    public void testBug566124() {
        this.runConformTest(new String[]{"X.java", "public class X  {\n    @SuppressWarnings(\"deprecation\")\n    public void bar(int i) {\n\tboolean isNumeric = foo( switch(i+1) {\n\t   case 0 -> new Short((short)0);\n\t   case 2 -> new Double(2.0d);\n\t   default -> new Integer((short)6);\n    \t});\n    \tSystem.out.println(isNumeric);\n    }\n    boolean foo(short data){ return false; }\n    boolean foo(byte data){ return false; }\n    boolean foo(int data){ return false; }\n    boolean foo(float data){ return false; }\n    boolean foo(long data){ return false; }\n    boolean foo(double data){ return true; }\n\n    public static void main(String[] args) {\n\t\tX x = new X();\n\t\tx.bar(-1);\n\t}\n}\n"}, "true");
    }

    public void testIssue3481() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    int a = switch(0) {\n        default -> {\n            yield ~1;\n        }\n    };\n    int b = switch(0) {\n        default -> {\n            int x = 0;\n            yield ~x;\n        }\n    };\n    int c = switch (0) {\n        case 0 -> {\n            yield ~2;\n        }\n        default -> 1;\n    };\n\n    {\n        System.out.println(\"a = \" + a + \" b = \" + b + \" c = \" + c);\n    }\n\n    public static void main(String [] args) {\n        new X();\n    }\n}\n"}, "a = -2 b = -1 c = -3");
    }

    public void testIssue3554() {
        if (this.complianceLevel < 0x410000L) {
            return;
        }
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\n\tsealed interface Index {\n\n\t\tenum TimeIndex implements Index {\n\t\t\tSECONDS;\n\t\t}\n\t}\n\n\tpublic class AbstractLine<S extends Index> {}\n\n\tpublic class AbstractTimeLine extends AbstractLine<X.Index.TimeIndex> {}\n\n\t@SuppressWarnings(\"unchecked\")\n\tpublic static <S extends Index> AbstractLine<S> create(int id, S index, int owner) {\n\t\treturn (AbstractLine<S>) switch (index) {\n\t\t\tcase X.Index.TimeIndex tindex when tindex == X.Index.TimeIndex.SECONDS -> new AbstractTimeLine();\n\t\t\tdefault -> new AbstractLine<>(state().newId(), index, owner);\n\t\t};\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 18)\n\tdefault -> new AbstractLine<>(state().newId(), index, owner);\n\t                              ^^^^^\nThe method state() is undefined for the type X\n----------\n");
    }

    public void testIssue3920() {
        this.runConformTest(new String[]{"X.java", "import java.util.List;\nimport java.util.stream.Collectors;\n\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tvar l = List.of(\"A\",\"B\");\n\t\tint i = 12;\n\t\tvar t = switch(i) {\n\t\tcase 1 -> l.stream().collect(Collectors.joining(\" \"));\n\t\tdefault -> \"Fixed!\";\n\t\t};\n\t\tSystem.out.println(t);\n\t}\n}\n"}, "Fixed!");
    }

    public void testIssue4113() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static void main(String[] args) {\n        try {\n            int length = ((Object[]) null).length;\n           } catch (NullPointerException npe) {\n               System.out.println(\"NPE!\");\n           }\n    }\n}\n"}, "NPE!");
    }

    public void testIssue4165() {
        this.runConformTest(new String[]{"X.java", "interface I {\n    int foo(int x);\n}\n\npublic class X {\n\n    static int foo(int x) {\n        return x;\n    }\n\n\tpublic static void main(String [] args) {\n\n\t\tfor (int integer : new Integer[] { 0, 1 }) {\n\t\t\tI b = switch (integer) {\n\t\t\t\tcase 0 -> X::foo;\n\t\t\t\tdefault ->  (int i) -> 42;\n\t\t\t};\n\t\t\tSystem.out.println(b.foo(100));\n\t\t}\n\t}\n}\n"}, "100\n42");
    }

    public void testIssue4165_2() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n    int foo(int x);\n}\n\npublic class X {\n\n    static int foo(int x) {\n        return x;\n    }\n\n\tpublic static void main(String [] args) {\n\n\t\tfor (int integer : new Integer[] { 0, 1 }) {\n\t\t\tvar b = switch (integer) {\n\t\t\t\tcase 0 -> X::foo;\n\t\t\t\tdefault ->  (int i) -> 42;\n\t\t\t};\n\t\t\tSystem.out.println(b.foo(100));\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 15)\r\n\tcase 0 -> X::foo;\r\n\t          ^^^^^^\nThe target type of this expression must be a functional interface\n----------\n2. ERROR in X.java (at line 16)\r\n\tdefault ->  (int i) -> 42;\r\n\t            ^^^^^^^^^^^^^\nThe target type of this expression must be a functional interface\n----------\n3. ERROR in X.java (at line 18)\r\n\tSystem.out.println(b.foo(100));\r\n\t                     ^^^\nThe method foo(int) is undefined for the type Object\n----------\n");
    }
}

