/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest9;

public class SwitchPatternTest
extends AbstractRegressionTest9 {
    private static String previewLevel = "23";

    public static Class<?> testClass() {
        return SwitchPatternTest.class;
    }

    public static Test suite() {
        return SwitchPatternTest.buildMinimalComplianceTestSuite(SwitchPatternTest.testClass(), 262144);
    }

    public SwitchPatternTest(String testName) {
        super(testName);
    }

    @Override
    protected Map<String, String> getCompilerOptions() {
        Map<String, String> defaultOptions = super.getCompilerOptions();
        defaultOptions.put("org.eclipse.jdt.core.compiler.problem.enablePreviewFeatures", "disabled");
        defaultOptions.put("org.eclipse.jdt.core.compiler.problem.reportPreviewFeatures", "ignore");
        defaultOptions.put("org.eclipse.jdt.core.compiler.storeAnnotations", "enabled");
        return defaultOptions;
    }

    @Override
    protected void runConformTest(String[] testFiles, String expectedOutput) {
        this.runConformTest(testFiles, expectedOutput, "", this.getCompilerOptions());
    }

    @Override
    protected void runConformTest(String[] testFiles, String expectedOutput, Map<String, String> customOptions) {
        this.runConformTest(testFiles, expectedOutput, "", customOptions);
    }

    protected void runConformTest(String[] testFiles, String expectedOutput, String errorOutput) {
        this.runConformTest(testFiles, expectedOutput, errorOutput, this.getCompilerOptions());
    }

    protected void runConformTest(String[] testFiles, String expectedOutput, String expectedErrorOutput, Map<String, String> customOptions) {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.testFiles = testFiles;
        runner.expectedOutputString = expectedOutput;
        runner.expectedErrorString = expectedErrorOutput;
        runner.vmArguments = new String[]{"--enable-preview"};
        runner.customOptions = customOptions;
        runner.runConformTest();
    }

    @Override
    protected void runNegativeTest(String[] testFiles, String expectedCompilerLog) {
        this.runNegativeTest(testFiles, expectedCompilerLog, "");
    }

    protected void runNegativeTest(String[] testFiles, String expectedCompilerLog, String javacLog) {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.testFiles = testFiles;
        runner.expectedCompilerLog = expectedCompilerLog;
        runner.expectedJavacOutputString = expectedCompilerLog;
        runner.vmArguments = null;
        runner.customOptions = this.getCompilerOptions();
        runner.runNegativeTest();
        this.runNegativeTest(testFiles, expectedCompilerLog, AbstractRegressionTest.JavacTestOptions.forReleaseWithPreview(previewLevel));
    }

    protected void runWarningTest(String[] testFiles, String expectedCompilerLog) {
        this.runWarningTest(testFiles, expectedCompilerLog, null);
    }

    protected void runWarningTest(String[] testFiles, String expectedCompilerLog, Map<String, String> customOptions) {
        this.runWarningTest(testFiles, expectedCompilerLog, customOptions, null);
    }

    protected void runWarningTest(String[] testFiles, String expectedCompilerLog, Map<String, String> customOptions, String javacAdditionalTestOptions) {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.testFiles = testFiles;
        runner.expectedCompilerLog = expectedCompilerLog;
        runner.customOptions = customOptions;
        runner.vmArguments = new String[0];
        runner.runWarningTest();
    }

    public void testIssue57_001() {
        this.runConformTest(new String[]{"X.java", "public class X {\n private static void foo(Object o) {\n   switch (o) {\n     case Integer i     -> System.out.println(\"String:\");\n     case String s     -> System.out.println(\"String: Hello World!\");\n     default       -> System.out.println(\"Object\");\n   }\n }\n public static void main(String[] args) {\n   foo(\"Hello World\");\n }\n}"}, "String: Hello World!");
    }

    public void testIssue57_002() {
        this.runConformTest(new String[]{"X.java", "public class X {\n private static void foo(Object o) {\n   switch (o) {\n     case Integer i when i > 10    -> System.out.println(\"Integer: greater than 10\");\n     case String  s   -> System.out.println(\"String: Hello World!\");\n     default       -> System.out.println(\"Object\");\n   }\n }\n public static void main(String[] args) {\n   foo(12);\n }\n}"}, "Integer: greater than 10");
    }

    public void testBug573516_002() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n private static void foo(Object o) {\n   switch (o) {\n     case String s     -> System.out.println(\"String:\");\n     default       -> System.out.println(\"Object\");\n   }\n }\n public static void main(String[] args) {\n   foo(\"Hello World\");\n   Zork();\n }\n}"}, "----------\n1. ERROR in X.java (at line 10)\n\tZork();\n\t^^^^\nThe method Zork() is undefined for the type X\n----------\n");
    }

    public void testBug573516_003() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n private static void foo(Object o) {\n   switch (o) {\n     case String s  : System.out.println(\"String:\"); break;\n     case Integer i  : System.out.println(\"Integer:\");break;\n     default       : System.out.println(\"Object\");break;\n   }\n }\n public static void main(String[] args) {\n   foo(\"Hello World\");\n   Zork();\n }\n}"}, "----------\n1. ERROR in X.java (at line 11)\n\tZork();\n\t^^^^\nThe method Zork() is undefined for the type X\n----------\n");
    }

    public void testBug573516_004() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n private static void foo(Object o) {\n   switch (o) {\n     case Integer t when t > 0 -> System.out.println(\"Integer && t > 0\");\n     default       -> System.out.println(\"Object\");\n   }\n }\n public static void main(String[] args) {\n   foo(\"Hello World\");\n   Zork();\n }\n}"}, "----------\n1. ERROR in X.java (at line 10)\n\tZork();\n\t^^^^\nThe method Zork() is undefined for the type X\n----------\n");
    }

    public void testBug573516_005() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n private static void foo(Object o) {\n   switch (o) {\n     case Integer t, String s, X x : System.out.println(\"Integer, String or X\");\n     default : System.out.println(\"Object\");\n   }\n }\n public static void main(String[] args) {\n   foo(\"Hello World\");\n   Zork();\n }\n}\nclass Y {}"}, "----------\n1. ERROR in X.java (at line 4)\n\tcase Integer t, String s, X x : System.out.println(\"Integer, String or X\");\n\t             ^\nNamed pattern variables are not allowed here\n----------\n2. ERROR in X.java (at line 4)\n\tcase Integer t, String s, X x : System.out.println(\"Integer, String or X\");\n\t                       ^\nNamed pattern variables are not allowed here\n----------\n3. ERROR in X.java (at line 4)\n\tcase Integer t, String s, X x : System.out.println(\"Integer, String or X\");\n\t                            ^\nNamed pattern variables are not allowed here\n----------\n4. ERROR in X.java (at line 10)\n\tZork();\n\t^^^^\nThe method Zork() is undefined for the type X\n----------\n");
    }

    public void testBug573516_006() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n private static void foo(Object o) {\n   switch (o) {\n     case Integer t, String s when s.length > 0, X x when x.hashCode() > 10 : System.out.println(\"Integer, String or X\");\n     default : System.out.println(\"Object\");\n   }\n }\n public static void main(String[] args) {\n   foo(\"Hello World\");\n   Zork();\n }\n}\nclass Y {}"}, "----------\n1. ERROR in X.java (at line 4)\n\tcase Integer t, String s when s.length > 0, X x when x.hashCode() > 10 : System.out.println(\"Integer, String or X\");\n\t             ^\nNamed pattern variables are not allowed here\n----------\n2. ERROR in X.java (at line 4)\n\tcase Integer t, String s when s.length > 0, X x when x.hashCode() > 10 : System.out.println(\"Integer, String or X\");\n\t                       ^\nNamed pattern variables are not allowed here\n----------\n3. ERROR in X.java (at line 4)\n\tcase Integer t, String s when s.length > 0, X x when x.hashCode() > 10 : System.out.println(\"Integer, String or X\");\n\t                         ^^^^^^^^^^^^^^^^^\nSyntax error on token(s), misplaced construct(s)\n----------\n4. ERROR in X.java (at line 4)\n\tcase Integer t, String s when s.length > 0, X x when x.hashCode() > 10 : System.out.println(\"Integer, String or X\");\n\t                                              ^\nNamed pattern variables are not allowed here\n----------\n5. ERROR in X.java (at line 4)\n\tcase Integer t, String s when s.length > 0, X x when x.hashCode() > 10 : System.out.println(\"Integer, String or X\");\n\t                                                     ^\nx cannot be resolved\n----------\n6. ERROR in X.java (at line 10)\n\tZork();\n\t^^^^\nThe method Zork() is undefined for the type X\n----------\n");
    }

    public void testBug573516_007() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n private static void foo(Object o) {\n   switch (o) {\n     case Integer t, String : System.out.println(\"Error should be flagged for String\");\n     default : System.out.println(\"Object\");\n   }\n }\n public static void main(String[] args) {\n   foo(\"Hello World\");\n   Zork();\n }\n}\nclass Y {}"}, "----------\n1. ERROR in X.java (at line 4)\n\tcase Integer t, String : System.out.println(\"Error should be flagged for String\");\n\t                ^^^^^^\nCannot mix pattern with other case labels\n----------\n2. ERROR in X.java (at line 4)\n\tcase Integer t, String : System.out.println(\"Error should be flagged for String\");\n\t                ^^^^^^\nString cannot be resolved to a variable\n----------\n3. ERROR in X.java (at line 10)\n\tZork();\n\t^^^^\nThe method Zork() is undefined for the type X\n----------\n");
    }

    public void testBug573516_008() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n private static void foo(Object o) {\n   switch (o.hashCode()) {\n     case Integer t, String : System.out.println(\"Error should be flagged for Integer and String\");\n     default : System.out.println(\"Object\");\n   }\n }\n public static void main(String[] args) {\n   foo(\"Hello World\");\n   Zork();\n }\n}\nclass Y {}"}, "----------\n1. ERROR in X.java (at line 4)\n\tcase Integer t, String : System.out.println(\"Error should be flagged for Integer and String\");\n\t     ^^^^^^^^^\nType mismatch: cannot convert from int to Integer\n----------\n2. ERROR in X.java (at line 4)\n\tcase Integer t, String : System.out.println(\"Error should be flagged for Integer and String\");\n\t                ^^^^^^\nCannot mix pattern with other case labels\n----------\n3. ERROR in X.java (at line 4)\n\tcase Integer t, String : System.out.println(\"Error should be flagged for Integer and String\");\n\t                ^^^^^^\nString cannot be resolved to a variable\n----------\n4. ERROR in X.java (at line 10)\n\tZork();\n\t^^^^\nThe method Zork() is undefined for the type X\n----------\n");
    }

    public void testBug573516_009() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n private static void foo(Object o) {\n   switch (o.hashCode()) {\n     case null, default : System.out.println(\"Default\");\n     default : System.out.println(\"Object\");\n   }\n }\n public static void main(String[] args) {\n   foo(\"Hello World\");\n   Zork();\n }\n}\nclass Y {}"}, "----------\n1. ERROR in X.java (at line 4)\n\tcase null, default : System.out.println(\"Default\");\n\t     ^^^^\nCase constant of type null is incompatible with switch selector type int\n----------\n2. ERROR in X.java (at line 5)\n\tdefault : System.out.println(\"Object\");\n\t^^^^^^^\nThe default case is already defined\n----------\n3. ERROR in X.java (at line 10)\n\tZork();\n\t^^^^\nThe method Zork() is undefined for the type X\n----------\n");
    }

    public void testBug573516_010() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n private static void foo(Object o) {\n   switch (o.hashCode()) {\n     case String s, default : System.out.println(\"Error should be flagged for String and default\");\n     default : System.out.println(\"Object\");\n   }\n }\n public static void main(String[] args) {\n   foo(\"Hello World\");\n   Zork();\n }\n}\nclass Y {}"}, "----------\n1. ERROR in X.java (at line 4)\n\tcase String s, default : System.out.println(\"Error should be flagged for String and default\");\n\t     ^^^^^^^^\nType mismatch: cannot convert from int to String\n----------\n2. ERROR in X.java (at line 4)\n\tcase String s, default : System.out.println(\"Error should be flagged for String and default\");\n\t               ^^^^^^^\nCannot mix pattern with other case labels\n----------\n3. ERROR in X.java (at line 4)\n\tcase String s, default : System.out.println(\"Error should be flagged for String and default\");\n\t               ^^^^^^^\nA 'default' can occur after 'case' only as a second case label expression and that too only if 'null' precedes  in 'case null, default' \n----------\n4. ERROR in X.java (at line 5)\n\tdefault : System.out.println(\"Object\");\n\t^^^^^^^\nThe default case is already defined\n----------\n5. ERROR in X.java (at line 10)\n\tZork();\n\t^^^^\nThe method Zork() is undefined for the type X\n----------\n");
    }

    public void testBug573516_011() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n private static void foo(Object o) {\n   switch (o.hashCode()) {\n     case var s : System.out.println(\"Error should be ANY_PATTERN\");\n     default : System.out.println(\"Object\");\n   }\n }\n public static void main(String[] args) {\n   foo(\"Hello World\");\n   Zork();\n }\n}\nclass Y {}"}, "----------\n1. ERROR in X.java (at line 4)\n\tcase var s : System.out.println(\"Error should be ANY_PATTERN\");\n\t     ^^^\n'var' is not allowed here\n----------\n2. ERROR in X.java (at line 10)\n\tZork();\n\t^^^^\nThe method Zork() is undefined for the type X\n----------\n");
    }

    public void testBug574228_001() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n private static void foo(Object o) {\n   switch (o) {\n     case 1: System.out.println(\"Integer\"); break;\n     default : System.out.println(\"Object\");\n   }\n }\n   public static void main(String[] args) {\n   foo(\"Hello World\");\n     Zork();\n }\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\tcase 1: System.out.println(\"Integer\"); break;\n\t     ^\nCase constant of type int is incompatible with switch selector type Object\n----------\n2. ERROR in X.java (at line 10)\n\tZork();\n\t^^^^\nThe method Zork() is undefined for the type X\n----------\n");
    }

    public void testBug573936_01() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n private static void foo(Object o) {\n   switch (o) {\n     case Integer I: \n       System.out.println(\"Integer\"); \n       System.out.println(I); \n     case String s when s.length()>1: \n       System.out.println(\"String s && s.length()>1\"); \n       System.out.println(s); \n       break;// error no fallthrough allowed in pattern\n     case X x:\n       System.out.println(\"X\"); \n       System.out.println(x);\n       break;\n     default : System.out.println(\"Object\"); \n   }\n }   \n   public static void main(String[] args) {\n   foo(\"Hello World!\");\n     foo(\"H\");\n   foo(bar());\n }\n   public static Object bar() { return new Object();}\n}"}, "----------\n1. ERROR in X.java (at line 7)\n\tcase String s when s.length()>1: \n\t^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nIllegal fall-through to a pattern\n----------\n");
    }

    public void testBug573939_01() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n private static void foo(Object o) {\n   switch (o) {\n     case Integer s : System.out.println(\"Integer\");\n     case String s1: System.out.println(\"String \");\n     default : System.out.println(\"Object\");\n   }\n }\n public static void main(String[] args) {\n   foo(\"Hello World\");\n   Zork();\n }\n}\nclass Y {}"}, "----------\n1. ERROR in X.java (at line 5)\n\tcase String s1: System.out.println(\"String \");\n\t^^^^^^^^^^^^^^\nIllegal fall-through to a pattern\n----------\n2. ERROR in X.java (at line 11)\n\tZork();\n\t^^^^\nThe method Zork() is undefined for the type X\n----------\n");
    }

    public void testBug573939_02() {
        this.runConformTest(new String[]{"X.java", "public class X {\n private static void foo(Object o) {\n   switch (o) {\n     case Integer I: System.out.println(\"Integer\"); break;\n     case String s when s.length()>1: System.out.println(\"String > 1\"); break;\n     case String s1: System.out.println(\"String\"); break;\n     case X x: System.out.println(\"X\"); break;\n     default : System.out.println(\"Object\");\n   }\n }\n   public static void main(String[] args) {\n   foo(\"Hello World!\");\n   foo(\"H\");\n   foo(bar());\n }\n   public static Object bar() { return new Object();}\n}"}, "String > 1\nString\nObject");
    }

    public void testBug573939_03() {
        this.runConformTest(new String[]{"X.java", "public class X {\n private static void foo(Object o) {\n   switch (o) {\n     case Integer I: \n       System.out.println(\"Integer\"); \n       System.out.println(I); \n       break; \n     case String s when s.length()>1: \n       System.out.println(\"String s when s.length()>1\"); \n       System.out.println(s); \n       break;\n     case String s1: \n       System.out.println(\"String\"); \n       System.out.println(s1);\n       break; \n     case X x:\n       System.out.println(\"X\"); \n       System.out.println(x);\n       break;\n     default : System.out.println(\"Object\"); \n   }\n }   \n   public static void main(String[] args) {\n   foo(\"Hello World!\");\n     foo(\"H\");\n   foo(bar());\n }\n   public static Object bar() { return new Object();}\n}"}, "String s when s.length()>1\nHello World!\nString\nH\nObject");
    }

    public void testBug573939_03b() {
        this.runConformTest(new String[]{"X.java", "public class X {\n private static void foo(Object o) {\n   switch (o) {\n     case Integer I: \n       System.out.println(\"Integer\"); \n       System.out.println(I); \n       break; \n     case String s when s.length()>1: \n       System.out.println(\"String s when s.length()>1\"); \n       System.out.println(s); \n       break;\n     case String s: \n       System.out.println(\"String\"); \n       System.out.println(s);\n       break; \n     case X x:\n       System.out.println(\"X\"); \n       System.out.println(x);\n       break;\n     default : System.out.println(\"Object\"); \n   }\n }   \n   public static void main(String[] args) {\n   foo(\"Hello World!\");\n     foo(\"H\");\n   foo(bar());\n }\n   public static Object bar() { return new Object();}\n}"}, "String s when s.length()>1\nHello World!\nString\nH\nObject");
    }

    public void test045() {
        this.runNegativeTest(new String[]{"X.java", "public abstract class X {\n  public static void main(String[] args) {\n    switch (args.length) {\n      case 1:\n        final int j = 1;\n      case 2:\n        switch (5) {\n          case j:\n        }\n    }\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\tcase j:\n\t     ^\nThe local variable j may not have been initialized\n----------\n");
    }

    public void testBug574525_01() {
        this.runConformTest(new String[]{"X.java", "public class X {\n private static void foo(Object o) {\n   switch (o) {\n     case Integer I: \n       System.out.println(\"Integer\"); \n       System.out.println(I); \n       break; \n     case null:\n       System.out.println(\"NULL\"); \n       break;\n     default : System.out.println(\"Object\"); \n   }\n }   \n   public static void main(String[] args) {\n     foo(null);\n }\n}"}, "NULL");
    }

    public void testBug574525_02() {
        this.runConformTest(new String[]{"X.java", "public class X {\n private static void foo(Object o) {\n   switch (o) {\n     case Integer I: \n       System.out.println(\"Integer\"); \n       System.out.println(I); \n       break; \n     case String s when s.length()>1: \n       System.out.println(\"String s when s.length()>1\"); \n       System.out.println(s); \n       break;\n     case String s1: \n       System.out.println(\"String\"); \n       System.out.println(s1);\n       break; \n     case X x:\n       System.out.println(\"X\"); \n       System.out.println(x);\n       break;\n     case null:\n       System.out.println(\"NULL\"); \n       break;\n     default : System.out.println(\"Object\"); \n   }\n }   \n   public static void main(String[] args) {\n   foo(\"Hello World!\");\n   foo(null);\n   foo(bar());\n }\n   public static Object bar() { return new Object();}\n}"}, "String s when s.length()>1\nHello World!\nNULL\nObject");
    }

    public void testBug574525_03() {
        this.runConformTest(new String[]{"X.java", "public class X {\n private static void foo(Integer o) {\n   switch (o) {\n     case 10: \n       System.out.println(\"Integer\"); \n       System.out.println(o); \n       break; \n     case null:\n       System.out.println(\"NULL\"); \n       break;\n     default : System.out.println(o); \n   }\n }   \n   public static void main(String[] args) {\n     foo(0);\n }\n}"}, "0");
    }

    public void testBug574525_04() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n private static void foo(int o) {\n   switch (o) {\n     case 10: \n       System.out.println(\"Integer\"); \n       System.out.println(o); \n       break; \n     case null:\n       System.out.println(\"NULL\"); \n       break;\n     default : System.out.println(o); \n   }\n }   \n   public static void main(String[] args) {\n     foo(0);\n }\n}"}, "----------\n1. ERROR in X.java (at line 8)\n\tcase null:\n\t     ^^^^\nCase constant of type null is incompatible with switch selector type int\n----------\n");
    }

    public void testBug574538_01() {
        this.runConformTest(new String[]{"X.java", "public class X {\n public static void main(String[] args) {\n   foo(Integer.valueOf(11));\n   foo(Integer.valueOf(9));\n }\n\n private static void foo(Object o) {\n   switch (o) {\n   case Integer i when i>10:\n     System.out.println(\"Greater than 10:\" + o);\n     break;\n   case Integer j when j>0:\n     System.out.println(\"Greater than 0:\" + o);\n     break;\n   default:\n     System.out.println(\"Object\" + o);\n   }\n }\n}"}, "Greater than 10:11\nGreater than 0:9");
    }

    public void testBug574538_02() {
        this.runConformTest(new String[]{"X.java", "public class X {\n public static void main(String[] args) {\n   foo1(Integer.valueOf(10));\n   foo1(Integer.valueOf(11));\n   foo1(\"Hello World!\");\n }\n\n private static void foo1(Object o) {\n   switch (o) {\n   case Integer i when i>10 -> System.out.println(\"Greater than 10:\");\n   case String s when s.equals(\"ff\") -> System.out.println(\"String:\" + s);\n   default -> System.out.println(\"Object:\" + o);\n   }\n }\n}"}, "Object:10\nGreater than 10:\nObject:Hello World!");
    }

    public void testBug574549_01() {
        this.runConformTest(new String[]{"X.java", "public class X {\n public static void main(String[] args) {\n   foo(\"Hello World!\");\n }\n\n private static void foo(Object o) {\n   switch (o) {\n    case null, default:\n     System.out.println(\"Object: \" + o);\n   }\n }\n}"}, "Object: Hello World!");
    }

    public void testBug574549_02() {
        this.runConformTest(new String[]{"X.java", "public class X {\n public static void main(String[] args) {\n   foo(Integer.valueOf(11));\n   foo(Integer.valueOf(9));\n   foo(\"Hello World!\");\n }\n\n private static void foo(Object o) {\n   switch (o) {\n   case Integer i when i>10:\n     System.out.println(\"Greater than 10:\" + o);\n     break;\n   case Integer j when j>0:\n     System.out.println(\"Greater than 0:\" + o);\n     break;\n   case null,default:\n     System.out.println(\"Give Me Some SunShine:\" + o);\n   }\n }\n}"}, "Greater than 10:11\nGreater than 0:9\nGive Me Some SunShine:Hello World!");
    }

    public void testBug574549_03() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n public static void main(String[] args) {\n   foo(\"Hello World!\");\n }\n\n private static void foo(Object o) {\n   switch (o) {\n   case Integer i :\n     System.out.println(\"Integer:\" + o);\n     break;\n   case null, default:\n     System.out.println(\"Object\" + o);\n   case null, default:\n     System.out.println(\"Give me Some Sunshine\" + o);\n   }\n }\n}"}, "----------\n1. ERROR in X.java (at line 13)\n\tcase null, default:\n\t     ^^^^\nThis case label is dominated by one of the preceding case labels\n----------\n2. ERROR in X.java (at line 13)\n\tcase null, default:\n\t     ^^^^\nDuplicate case\n----------\n3. ERROR in X.java (at line 13)\n\tcase null, default:\n\t           ^^^^^^^\nThe default case is already defined\n----------\n");
    }

    public void testBug574549_04() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n public static void main(String[] args) {\n   foo(\"Hello World!\");\n }\n\n private static void foo(Object o) {\n   switch (o) {\n   case Integer i :\n     System.out.println(\"Integer:\" + o);\n     break;\n   case default:\n     System.out.println(\"Object\" + o);\n   default:\n     System.out.println(\"Give me Some Sunshine\" + o);\n   }\n }\n}"}, "----------\n1. ERROR in X.java (at line 11)\n\tcase default:\n\t     ^^^^^^^\nA 'default' can occur after 'case' only as a second case label expression and that too only if 'null' precedes  in 'case null, default' \n----------\n2. ERROR in X.java (at line 13)\n\tdefault:\n\t^^^^^^^\nThe default case is already defined\n----------\n");
    }

    public void testBug573937_1() {
        Map<String, String> options = this.getCompilerOptions();
        String opt = options.get("org.eclipse.jdt.core.compiler.codegen.unusedLocal");
        try {
            options.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", "disabled");
            this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(\"Hello\");\n\t}\n\tpublic static void foo(Object o) {\n\t\tswitch (o) {\n\t\t\tcase String s:\n\t\t\t\tbreak;\n\t\t\tdefault:\n\t\t\t\tbreak;\n\t\t}\n\t}\n}"}, "Hello", options);
        }
        finally {
            options.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", opt);
        }
    }

    public void testBug573937_2() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void foo(Object o) {\n\t\tswitch (o) {\n\t\t\tcase String s:\n\t\t\t\tSystem.out.println(s);\n\t\t\t\tbreak;\n\t\t\tcase Integer i:\n\t\t\t\tSystem.out.println(s);\n\t\t\tdefault:\n\t\t\t\tbreak;\n\t\t}\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 8)\n\tSystem.out.println(s);\n\t                   ^\ns cannot be resolved to a variable\n----------\n");
    }

    public void testBug573937_3() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void foo(Object o) {\n\t\tswitch (o) {\n\t\t\tcase String s:\n\t\t\t\tSystem.out.println(s);\n\t\t\tcase Integer i:\n\t\t\t\tSystem.out.println(s);\n\t\t\tdefault:\n\t\t\t\tSystem.out.println(s);\n\t\t\t\tbreak;\n\t\t}\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 7)\n\tSystem.out.println(s);\n\t                   ^\ns cannot be resolved to a variable\n----------\n2. ERROR in X.java (at line 9)\n\tSystem.out.println(s);\n\t                   ^\ns cannot be resolved to a variable\n----------\n");
    }

    public void testBug573937_4() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void foo(Object o) {\n\t\tswitch (o) {\n\t\t\tcase String s:\n\t\t\t\tString s = null;\n\t\t\t\tSystem.out.println(s);\n\t\t\t\tbreak;\n\t\t\tdefault:\n\t\t\t\tbreak;\n\t\t}\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 5)\n\tString s = null;\n\t       ^\nA pattern variable with the same name is already defined in the statement\n----------\n");
    }

    public void testBug573937_5() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void foo(Object o) {\n\t\tswitch (o) {\n\t\t\tcase String s:\n\t\t\t\tSystem.out.println(s);\n\t\t\t\tbreak;\n\t\t\tdefault:\n\t\t\t\tString s = null;\n\t\t\t\tbreak;\n\t\t}\n\t}\n\tpublic static void main(String[] args) {\n\t\tfoo(\"hello\");\n\t}\n}"}, "hello");
    }

    public void testBug573937_6() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void foo(Object o) {\n\t\tswitch (o) {\n\t\t\tcase String o:\n\t\t\t\tSystem.out.println(o);\n\t\t\t\tbreak;\n\t\t\tdefault:\n\t\t\t\tbreak;\n\t\t}\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\tcase String o:\n\t            ^\nDuplicate local variable o\n----------\n");
    }

    public void testBug573937_7() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void foo(Object o) {\n\t\tswitch (o) {\n\t\t\tcase String s1:\n\t\t\t\tif (o instanceof String s1) {\n\t\t\t\t\tSystem.out.println(s1);\n\t\t\t\t}\n\t\t\t\tbreak;\n\t\t\tdefault:\n\t\t\t\tbreak;\n\t\t}\n\t}\n} "}, "----------\n1. ERROR in X.java (at line 5)\n\tif (o instanceof String s1) {\n\t                        ^^\nA pattern variable with the same name is already defined in the statement\n----------\n");
    }

    public void testBug573937_8() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void foo(Object o) {\n\t\tswitch (o) {\n\t\t\tcase String s1:\n\t\t\t\tSystem.out.println(s1.length());\n\t\t\t\tbreak;\n\t\t\tcase Integer s1:\n\t\t\t\tSystem.out.println(s1.length());\n\t\t\t\tbreak;\n\t\t\tdefault:\n\t\t\t\tbreak;\n\t\t}\n\t}\n} "}, "----------\n1. ERROR in X.java (at line 8)\n\tSystem.out.println(s1.length());\n\t                      ^^^^^^\nThe method length() is undefined for the type Integer\n----------\n");
    }

    public void testBug573937_9() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void foo(Object o) {\n\t\tswitch (o) {\n\t\t\tcase Integer i1:\n\t\t\t\tbreak;\n\t\t\tcase String s1 when s1.length() > i1:\n\t\t\t\t\tSystem.out.println(s1.length());\n\t\t\t\tbreak;\n\t\t\tdefault:\n\t\t\t\tbreak;\n\t\t}\n\t}\n} "}, "----------\n1. ERROR in X.java (at line 6)\n\tcase String s1 when s1.length() > i1:\n\t                                  ^^\ni1 cannot be resolved to a variable\n----------\n");
    }

    public void testBug573937_10() {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.testFiles = new String[]{"X.java", "public class X {\n@SuppressWarnings(\"null\")\tpublic static void foo(Object o) {\n\t  try {\n\t\tswitch (o) {\n\t\t\tcase String s1 when s1.length() == 0:\n\t\t\t\t\tbreak;\t\t\tcase String s1:\n\t\t\t\t\ts1 = null;\n\t\t\t\t\tSystem.out.println(s1.length());\n\t\t\t\tbreak;\n\t\t\tdefault:\n\t\t\t\tbreak;\n\t\t}\n\t  } catch(Exception e) {\n    System.out.println(e.getMessage());\n\t  };\n\t}\n\tpublic static void main(String[] args) {\n\t\tfoo(\"hello\");\n\t}\n}"};
        runner.expectedOutputString = "Cannot invoke \"String.length()\" because \"s1\" is null";
        runner.expectedJavacOutputString = "Cannot invoke \"String.length()\" because \"<local4>\" is null";
        runner.vmArguments = new String[]{"--enable-preview"};
        runner.customOptions = this.getCompilerOptions();
        runner.javacTestOptions = AbstractRegressionTest.JavacTestOptions.forReleaseWithPreview(previewLevel);
        runner.runConformTest();
    }

    public void testBug573937_11() {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.testFiles = new String[]{"X.java", "public class X {\n\tpublic static void foo(Object o) throws Exception {\n\t\tswitch (o) {\n\t\t\tcase String s1:\n\t\t\t\tthrow new Exception(s1);\n\t\t\tdefault:\n\t\t\t\tbreak;\n\t\t}\n\t}\n\tpublic static void main(String[] args) throws Exception {\n\t\ttry {\n\t\t  foo(\"hello\");\n\t\t} catch(Exception e) {\n\t\t  e.printStackTrace(System.out);\n\t\t};\n\t}\n} "};
        runner.expectedOutputString = "java.lang.Exception: hello\n\tat X.foo(X.java:5)\n\tat X.main(X.java:12)";
        runner.expectedJavacOutputString = "java.lang.Exception: hello\n\tat X.foo(X.java:5)\n\tat X.main(X.java:12)";
        runner.vmArguments = new String[]{"--enable-preview"};
        runner.customOptions = this.getCompilerOptions();
        runner.javacTestOptions = AbstractRegressionTest.JavacTestOptions.forReleaseWithPreview(previewLevel);
        runner.runConformTest();
    }

    public void testBug574612_1() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void foo(Object o) {\n\t\tint len = 2;\n\t\tswitch (o) {\n\t\tcase String o1 when o1.length() > len:\n\t\t\tlen = 0;\n\t\tbreak;\n\t\tdefault:\n\t\t\tbreak;\n\t\t}\n\t}\n} "}, "----------\n1. ERROR in X.java (at line 6)\n\tlen = 0;\n\t^^^\nLocal variable len is required to be final or effectively final based on its usage\n----------\n");
    }

    public void testBug574612_2() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void foo(Object o) {\n\t\tint len = 2;\n\t\tswitch (o) {\n\t\tcase String o1 when len < o1.length():\n\t\t\tlen = 0;\n\t\tbreak;\n\t\tdefault:\n\t\t\tbreak;\n\t\t}\n\t}\n} "}, "----------\n1. ERROR in X.java (at line 6)\n\tlen = 0;\n\t^^^\nLocal variable len is required to be final or effectively final based on its usage\n----------\n");
    }

    public void testBug574612_3() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void foo(Object o) {\n\t\tfinal int len = 2;\n\t\tswitch (o) {\n\t\tcase String o1 when len < o1.length():\n\t\t\tlen = 0;\n\t\tbreak;\n\t\tdefault:\n\t\t\tbreak;\n\t\t}\n\t}\n} "}, "----------\n1. ERROR in X.java (at line 6)\n\tlen = 0;\n\t^^^\nThe final local variable len cannot be assigned. It must be blank and not using a compound assignment\n----------\n");
    }

    public void testBug574612_4() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void foo(Object o) {\n\t\tint len = 2;\n\t\tswitch (o) {\n\t\tcase String o1 when len < o1.length():\n\t\t\tSystem.out.println(o1);\n\t\tbreak;\n\t\tdefault:\n\t\t\tbreak;\n\t\t}\n\t}\n\tpublic static void main(String[] args) throws Exception {\n\t\tfoo(\"hello\");\n\t}\n} "}, "hello");
    }

    public void testBug574719_001() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n public static int foo(Integer o) {\n   int k = 0;\n   switch (o) {\n     case 0, default   : k = 1;\n   }\n   return k;\n } \n public static void main(String[] args) {\n   System.out.println(foo(100 ));\n }\n}"}, "----------\n1. ERROR in X.java (at line 5)\n\tcase 0, default   : k = 1;\n\t        ^^^^^^^\nA 'default' can occur after 'case' only as a second case label expression and that too only if 'null' precedes  in 'case null, default' \n----------\n");
    }

    public void testBug574719_006() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n public static int foo(Integer o) {\n   int k = 0;\n   switch (o) {\n     case 0  : k = 2; break;\n     case 1, default, default   : k = 1;\n   }\n   return k;\n } \n public static void main(String[] args) {\n   System.out.println(foo(100));\n   System.out.println(foo(0));\n }\n}"}, "----------\n1. ERROR in X.java (at line 6)\n\tcase 1, default, default   : k = 1;\n\t        ^^^^^^^\nA 'default' can occur after 'case' only as a second case label expression and that too only if 'null' precedes  in 'case null, default' \n----------\n2. ERROR in X.java (at line 6)\n\tcase 1, default, default   : k = 1;\n\t                 ^^^^^^^\nThe default case is already defined\n----------\n3. ERROR in X.java (at line 6)\n\tcase 1, default, default   : k = 1;\n\t                 ^^^^^^^\nA 'default' can occur after 'case' only as a second case label expression and that too only if 'null' precedes  in 'case null, default' \n----------\n");
    }

    public void testBug574561_001() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n public static int foo(Integer o) {\n   int k = 0;\n   switch (o) {\n     default, default  : k = 2; break;\n   }\n   return k;\n } \n public static void main(String[] args) {\n   System.out.println(foo(100));\n   System.out.println(foo(0));\n }\n}"}, "----------\n1. ERROR in X.java (at line 5)\n\tdefault, default  : k = 2; break;\n\t       ^\nSyntax error on token \",\", : expected\n----------\n");
    }

    public void testBug574561_002() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n public static int foo(Integer o) {\n   int k = 0;\n   switch (o) {\n     case default, 1, default   : k = 1;\n   }\n   return k;\n } \n public static void main(String[] args) {\n   System.out.println(foo(100));\n   System.out.println(foo(0));\n }\n}"}, "----------\n1. ERROR in X.java (at line 5)\n\tcase default, 1, default   : k = 1;\n\t     ^^^^^^^\nA 'default' can occur after 'case' only as a second case label expression and that too only if 'null' precedes  in 'case null, default' \n----------\n2. ERROR in X.java (at line 5)\n\tcase default, 1, default   : k = 1;\n\t                 ^^^^^^^\nThe default case is already defined\n----------\n3. ERROR in X.java (at line 5)\n\tcase default, 1, default   : k = 1;\n\t                 ^^^^^^^\nA 'default' can occur after 'case' only as a second case label expression and that too only if 'null' precedes  in 'case null, default' \n----------\n");
    }

    public void testBug574561_003() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n public static int foo(Integer o) {\n   int k = 0;\n   switch (o) {\n     case default, 1, default   : k = 1;\n   }\n   return k;\n } \n public static void main(String[] args) {\n   System.out.println(foo(100));\n   System.out.println(foo(0));\n }\n}"}, "----------\n1. ERROR in X.java (at line 5)\n\tcase default, 1, default   : k = 1;\n\t     ^^^^^^^\nA 'default' can occur after 'case' only as a second case label expression and that too only if 'null' precedes  in 'case null, default' \n----------\n2. ERROR in X.java (at line 5)\n\tcase default, 1, default   : k = 1;\n\t                 ^^^^^^^\nThe default case is already defined\n----------\n3. ERROR in X.java (at line 5)\n\tcase default, 1, default   : k = 1;\n\t                 ^^^^^^^\nA 'default' can occur after 'case' only as a second case label expression and that too only if 'null' precedes  in 'case null, default' \n----------\n");
    }

    public void testBug574793_001() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n public static void main(String[] args) {}\n private static void foo1(int o) {\n   switch (o) {\n     case null  -> System.out.println(\"null\");\n     case 20  -> System.out.println(\"20\");\n   }\n }\n private static void foo(Object o) {\n   switch (o) {\n   case \"F\"  :\n     break;\n   case 2 :\n     break;\n   default:\n     break;\n   }\n }\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\tswitch (o) {\n\t        ^\nAn enhanced switch statement should be exhaustive; a default label expected\n----------\n2. ERROR in X.java (at line 5)\n\tcase null  -> System.out.println(\"null\");\n\t     ^^^^\nCase constant of type null is incompatible with switch selector type int\n----------\n3. ERROR in X.java (at line 11)\n\tcase \"F\"  :\n\t     ^^^\nCase constant of type String is incompatible with switch selector type Object\n----------\n4. ERROR in X.java (at line 13)\n\tcase 2 :\n\t     ^\nCase constant of type int is incompatible with switch selector type Object\n----------\n");
    }

    public void testBug574559_001() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n public static void main(String[] args) {}\n public static void foo1(Integer o) {\n   switch (o) {\n     case 1, Integer i  -> System.out.println(o);\n   }\n }\n}"}, "----------\n1. ERROR in X.java (at line 5)\n\tcase 1, Integer i  -> System.out.println(o);\n\t        ^^^^^^^^^\nCannot mix pattern with other case labels\n----------\n");
    }

    public void testBug574559_002() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n public static void main(String[] args) {}\n private static void foo1(Integer o) {\n   switch (o) {\n     case  Integer i, 30  -> System.out.println(o);\n   }\n }\n}"}, "----------\n1. ERROR in X.java (at line 5)\n\tcase  Integer i, 30  -> System.out.println(o);\n\t                 ^^\nCannot mix pattern with other case labels\n----------\n2. ERROR in X.java (at line 5)\n\tcase  Integer i, 30  -> System.out.println(o);\n\t                 ^^\nThis case label is dominated by one of the preceding case labels\n----------\n");
    }

    public void testBug573940_1() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\npublic void foo(Number n) {\n\tswitch (n) {\n\tcase Integer i :\n\t\tSystem.out.println(i);\n\tcase Float f :\n\t\tSystem.out.println(f);\n\tcase Object o : break;\n\t}\n}\n}"}, "----------\n1. ERROR in X.java (at line 6)\n\tcase Float f :\n\t^^^^^^^^^^^^\nIllegal fall-through to a pattern\n----------\n2. ERROR in X.java (at line 8)\n\tcase Object o : break;\n\t^^^^^^^^^^^^^\nIllegal fall-through to a pattern\n----------\n");
    }

    public void testBug573940_2() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\npublic void foo(Number n) {\n\tswitch (n) {\n\tcase Integer i :\n\tcase Float f :\n\t\tSystem.out.println(f);\n     break;\n\tdefault : break;\n\t}\n}\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\tcase Integer i :\n\t^^^^^^^^^^^^^^\nIllegal fall-through from a case label pattern\n----------\n2. ERROR in X.java (at line 5)\n\tcase Float f :\n\t^^^^^^^^^^^^\nIllegal fall-through to a pattern\n----------\n");
    }

    public void testBug573940_2a() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\npublic void foo(Number n) {\n\tswitch (n) {\n\tdefault :\n\tcase Float f :\n\t\tSystem.out.println(f);\n     break;\n\t}\n}\n}"}, "----------\n1. ERROR in X.java (at line 5)\n\tcase Float f :\n\t     ^^^^^^^\nThis case label is dominated by one of the preceding case labels\n----------\n");
    }

    public void testBug573940_3() {
        this.runConformTest(new String[]{"X.java", "public class X {\npublic static void foo(Number n) {\n\t\tswitch (n) {\n\t\tcase Integer i :\n\t\t\tSystem.out.println(i);\n\t\tdefault:\n\t\t\tSystem.out.println(\"null\");\n\t\t}\n\t}\npublic static void main(String[] args) {\n\t\tfoo(Integer.valueOf(5));\n\t}\n}"}, "5\nnull");
    }

    public void testBug573940_4() {
        this.runConformTest(new String[]{"X.java", "public class X {\npublic static void foo(Number n) {\n\t\tswitch (n) {\n\t\tcase Integer i :\n\t\t\tthrow new IllegalArgumentException();\n\t\tdefault:\n\t\t\tSystem.out.println(\"null\");\n\t\t}\n\t}\npublic static void main(String[] args) {\n\t\ttry{\n\t\t\tfoo(Integer.valueOf(5));\n\t\t} catch(Exception e) {\n\t\t \te.printStackTrace(System.out);\n\t\t}\n\t}\n}"}, "java.lang.IllegalArgumentException\n\tat X.foo(X.java:5)\n\tat X.main(X.java:12)");
    }

    public void testBug573940_5() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void foo(Number n) {\n\t\tint j = \n\t\t\tswitch (n) {\n\t\t\tcase Integer i -> {\n\t\t\t}\n\t\t\tdefault -> {\n\t\t\t\tyield 1;\n\t\t\t}\n\t\t};\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 6)\n\t}\n\t^^\nA switch labeled block in a switch expression must yield a value or throw an an exception\n----------\n");
    }

    public void testBug574564_001() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n public static void main(String[] args) {\n   foo(new String(\"Hello\"));\n }\n private static void foo(Object o) {\n   switch (o) {\n     case var i  -> System.out.println(0);\n     default -> System.out.println(o);\n   }\n }\n}"}, "----------\n1. ERROR in X.java (at line 7)\n\tcase var i  -> System.out.println(0);\n\t     ^^^\n'var' is not allowed here\n----------\n");
    }

    public void testBug574564_002() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n public static void main(String[] args) {\n   foo(new String(\"Hello\"));\n }\n private static void foo(Object o) {\n   switch (o) {\n     case var i, var j, var k  -> System.out.println(0);\n     default -> System.out.println(o);\n   }\n }\n}"}, "----------\n1. ERROR in X.java (at line 7)\n\tcase var i, var j, var k  -> System.out.println(0);\n\t     ^^^\n'var' is not allowed here\n----------\n2. ERROR in X.java (at line 7)\n\tcase var i, var j, var k  -> System.out.println(0);\n\t         ^\nNamed pattern variables are not allowed here\n----------\n3. ERROR in X.java (at line 7)\n\tcase var i, var j, var k  -> System.out.println(0);\n\t            ^^^\n'var' is not allowed here\n----------\n4. ERROR in X.java (at line 7)\n\tcase var i, var j, var k  -> System.out.println(0);\n\t                ^\nNamed pattern variables are not allowed here\n----------\n5. ERROR in X.java (at line 7)\n\tcase var i, var j, var k  -> System.out.println(0);\n\t                   ^^^\n'var' is not allowed here\n----------\n6. ERROR in X.java (at line 7)\n\tcase var i, var j, var k  -> System.out.println(0);\n\t                       ^\nNamed pattern variables are not allowed here\n----------\n");
    }

    public void testBug574564_003() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n public static void main(String[] args) {\n   foo(10);\n }\n private static void foo(Integer o) {\n   switch (o) {\n     case var i, 10  -> System.out.println(0);\n     default -> System.out.println(o);\n   }\n }\n}"}, "----------\n1. ERROR in X.java (at line 7)\n\tcase var i, 10  -> System.out.println(0);\n\t     ^^^\n'var' is not allowed here\n----------\n2. ERROR in X.java (at line 7)\n\tcase var i, 10  -> System.out.println(0);\n\t            ^^\nCannot mix pattern with other case labels\n----------\n");
    }

    public void testBug574564_004() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n public static void main(String[] args) {\n   foo(10);\n }\n private static void foo(Integer o) {\n   switch (o) {\n     case var i, 10, var k  -> System.out.println(0);\n     default -> System.out.println(o);\n   }\n }\n}"}, "----------\n1. ERROR in X.java (at line 7)\n\tcase var i, 10, var k  -> System.out.println(0);\n\t     ^^^\n'var' is not allowed here\n----------\n2. ERROR in X.java (at line 7)\n\tcase var i, 10, var k  -> System.out.println(0);\n\t            ^^\nCannot mix pattern with other case labels\n----------\n3. ERROR in X.java (at line 7)\n\tcase var i, 10, var k  -> System.out.println(0);\n\t                ^^^^^\nCannot mix pattern with other case labels\n----------\n4. ERROR in X.java (at line 7)\n\tcase var i, 10, var k  -> System.out.println(0);\n\t                ^^^\n'var' is not allowed here\n----------\n");
    }

    public void testBug574564_005() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n public static void main(String[] args) {\n   foo(10);\n }\n private static void foo(Integer o) {\n   switch (o) {\n     case  10, null, var k  -> System.out.println(0);\n     default -> System.out.println(o);\n   }\n }\n}"}, "----------\n1. ERROR in X.java (at line 7)\n\tcase  10, null, var k  -> System.out.println(0);\n\t          ^^^^\nA null case label has to be either the only expression in a case label or the first expression followed only by a default\n----------\n2. ERROR in X.java (at line 7)\n\tcase  10, null, var k  -> System.out.println(0);\n\t                ^^^^^\nCannot mix pattern with other case labels\n----------\n3. ERROR in X.java (at line 7)\n\tcase  10, null, var k  -> System.out.println(0);\n\t                ^^^\n'var' is not allowed here\n----------\n");
    }

    public void testBug574564_006() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n public static void main(String[] args) {\n   foo(10);\n }\n private static void foo(Integer o) {\n   switch (o) {\n     case  default, var k  -> System.out.println(0);\n     default -> System.out.println(o);\n   }\n }\n}"}, "----------\n1. ERROR in X.java (at line 7)\n\tcase  default, var k  -> System.out.println(0);\n\t      ^^^^^^^\nA 'default' can occur after 'case' only as a second case label expression and that too only if 'null' precedes  in 'case null, default' \n----------\n2. ERROR in X.java (at line 7)\n\tcase  default, var k  -> System.out.println(0);\n\t               ^^^\n'var' is not allowed here\n----------\n3. ERROR in X.java (at line 7)\n\tcase  default, var k  -> System.out.println(0);\n\t               ^^^^^\nCannot mix pattern with other case labels\n----------\n4. ERROR in X.java (at line 8)\n\tdefault -> System.out.println(o);\n\t^^^^^^^\nThe default case is already defined\n----------\n");
    }

    public void testBug574564_007() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n public static void main(String[] args) {\n   foo(10);\n }\n private static void foo(Integer o) {\n   switch (o) {\n     case  default, default, var k  -> System.out.println(0);\n     default -> System.out.println(o);\n   }\n }\n}"}, "----------\n1. ERROR in X.java (at line 7)\n\tcase  default, default, var k  -> System.out.println(0);\n\t      ^^^^^^^\nA 'default' can occur after 'case' only as a second case label expression and that too only if 'null' precedes  in 'case null, default' \n----------\n2. ERROR in X.java (at line 7)\n\tcase  default, default, var k  -> System.out.println(0);\n\t               ^^^^^^^\nThe default case is already defined\n----------\n3. ERROR in X.java (at line 7)\n\tcase  default, default, var k  -> System.out.println(0);\n\t               ^^^^^^^\nA 'default' can occur after 'case' only as a second case label expression and that too only if 'null' precedes  in 'case null, default' \n----------\n4. ERROR in X.java (at line 7)\n\tcase  default, default, var k  -> System.out.println(0);\n\t                        ^^^\n'var' is not allowed here\n----------\n5. ERROR in X.java (at line 7)\n\tcase  default, default, var k  -> System.out.println(0);\n\t                        ^^^^^\nCannot mix pattern with other case labels\n----------\n6. ERROR in X.java (at line 8)\n\tdefault -> System.out.println(o);\n\t^^^^^^^\nThe default case is already defined\n----------\n");
    }

    public void testBug574564_008() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n public static void main(String[] args) {\n   foo(10);\n }\n private static void foo(Integer o) {\n   switch (o) {\n     case  default, 1, var k  -> System.out.println(0);\n     default -> System.out.println(o);\n   }\n }\n}"}, "----------\n1. ERROR in X.java (at line 7)\n\tcase  default, 1, var k  -> System.out.println(0);\n\t      ^^^^^^^\nA 'default' can occur after 'case' only as a second case label expression and that too only if 'null' precedes  in 'case null, default' \n----------\n2. ERROR in X.java (at line 7)\n\tcase  default, 1, var k  -> System.out.println(0);\n\t                  ^^^\n'var' is not allowed here\n----------\n3. ERROR in X.java (at line 7)\n\tcase  default, 1, var k  -> System.out.println(0);\n\t                  ^^^^^\nCannot mix pattern with other case labels\n----------\n4. ERROR in X.java (at line 8)\n\tdefault -> System.out.println(o);\n\t^^^^^^^\nThe default case is already defined\n----------\n");
    }

    public void testBug574564_009() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n private static void foo(Object o) {\n   switch (o) {\n     case String s, default, Integer i  -> System.out.println(0);\n   }\n }\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\tcase String s, default, Integer i  -> System.out.println(0);\n\t               ^^^^^^^\nCannot mix pattern with other case labels\n----------\n2. ERROR in X.java (at line 4)\n\tcase String s, default, Integer i  -> System.out.println(0);\n\t               ^^^^^^^\nA 'default' can occur after 'case' only as a second case label expression and that too only if 'null' precedes  in 'case null, default' \n----------\n3. ERROR in X.java (at line 4)\n\tcase String s, default, Integer i  -> System.out.println(0);\n\t                        ^^^^^^^^^\nCannot mix pattern with other case labels\n----------\n4. ERROR in X.java (at line 4)\n\tcase String s, default, Integer i  -> System.out.println(0);\n\t                        ^^^^^^^^^\nThis case label is dominated by one of the preceding case labels\n----------\n");
    }

    public void testBug574564_010() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.compliance", "20");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n private static void foo(Object o) {\n   switch (o) {\n     case String s, default, Integer i  -> System.out.println(0);\n   }\n }\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\tcase String s, default, Integer i  -> System.out.println(0);\n\t               ^^^^^^^\nCannot mix pattern with other case labels\n----------\n2. ERROR in X.java (at line 4)\n\tcase String s, default, Integer i  -> System.out.println(0);\n\t               ^^^^^^^\nA 'default' can occur after 'case' only as a second case label expression and that too only if 'null' precedes  in 'case null, default' \n----------\n3. ERROR in X.java (at line 4)\n\tcase String s, default, Integer i  -> System.out.println(0);\n\t                        ^^^^^^^^^\nCannot mix pattern with other case labels\n----------\n4. ERROR in X.java (at line 4)\n\tcase String s, default, Integer i  -> System.out.println(0);\n\t                        ^^^^^^^^^\nThis case label is dominated by one of the preceding case labels\n----------\n", null, true, options);
    }

    public void testBug574564_013() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n private static void foo(Object o) {\n   switch (o) {\n     case default, default -> System.out.println(0);\n   }\n }\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\tcase default, default -> System.out.println(0);\n\t     ^^^^^^^\nA 'default' can occur after 'case' only as a second case label expression and that too only if 'null' precedes  in 'case null, default' \n----------\n2. ERROR in X.java (at line 4)\n\tcase default, default -> System.out.println(0);\n\t              ^^^^^^^\nThe default case is already defined\n----------\n3. ERROR in X.java (at line 4)\n\tcase default, default -> System.out.println(0);\n\t              ^^^^^^^\nA 'default' can occur after 'case' only as a second case label expression and that too only if 'null' precedes  in 'case null, default' \n----------\n");
    }

    public void testBug574563_001() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n public static void main(String[] args) {}\n private static void foo1(Integer o) {\n   switch (o) {\n     case null, null  -> System.out.println(o);\n     default  -> System.out.println(o);\n   }\n }\n}"}, "----------\n1. ERROR in X.java (at line 5)\n\tcase null, null  -> System.out.println(o);\n\t           ^^^^\nDuplicate case\n----------\n");
    }

    public void testBug574563_002() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n public static void foo(Object o) {\n   switch (o) {\n     case null, Integer i  -> System.out.println(0);\n     default -> System.out.println(o);\n   }\n }\n public static void bar(Object o) {\n   Zork();\n }\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\tcase null, Integer i  -> System.out.println(0);\n\t           ^^^^^^^^^\nCannot mix pattern with other case labels\n----------\n2. ERROR in X.java (at line 9)\n\tZork();\n\t^^^^\nThe method Zork() is undefined for the type X\n----------\n");
    }

    public void testBug574563_003() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n private static void foo(Object o) {\n   switch (o) {\n     case Integer i, null  -> System.out.println(0);\n     default -> System.out.println(o);\n   }\n   Zork();\n }\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\tcase Integer i, null  -> System.out.println(0);\n\t                ^^^^\nCannot mix pattern with other case labels\n----------\n2. ERROR in X.java (at line 4)\n\tcase Integer i, null  -> System.out.println(0);\n\t                ^^^^\nA null case label has to be either the only expression in a case label or the first expression followed only by a default\n----------\n3. ERROR in X.java (at line 7)\n\tZork();\n\t^^^^\nThe method Zork() is undefined for the type X\n----------\n");
    }

    public void testBug574563_004() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n private static void foo(Object o) {\n   switch (o) {\n     case null, Integer i when i > 10 -> System.out.println(0);\n     default -> System.out.println(o);\n   }\n   Zork();\n }\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\tcase null, Integer i when i > 10 -> System.out.println(0);\n\t           ^^^^^^^^^^^^^^^^^^^^^\nCannot mix pattern with other case labels\n----------\n2. ERROR in X.java (at line 7)\n\tZork();\n\t^^^^\nThe method Zork() is undefined for the type X\n----------\n");
    }

    public void testBug574563_005() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n private static void foo(Object o) {\n   switch (o) {\n     case Integer i when i > 10, null  -> System.out.println(0);\n     default -> System.out.println(o);\n   }\n   Zork();\n }\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\tcase Integer i when i > 10, null  -> System.out.println(0);\n\t                            ^^^^\nCannot mix pattern with other case labels\n----------\n2. ERROR in X.java (at line 4)\n\tcase Integer i when i > 10, null  -> System.out.println(0);\n\t                            ^^^^\nA null case label has to be either the only expression in a case label or the first expression followed only by a default\n----------\n3. ERROR in X.java (at line 7)\n\tZork();\n\t^^^^\nThe method Zork() is undefined for the type X\n----------\n");
    }

    public void testBug575030_01() {
        this.runConformTest(new String[]{"X.java", "public class X {\n public static void main(String[] args) {\n   foo(\"Hello World!\");\n }\n\n private static void foo(String o) {\n   switch (o) {\n     case String s -> System.out.println(s);\n   }\n }\n}"}, "Hello World!");
    }

    public void testBug574614_001() {
        this.runConformTest(new String[]{"X.java", "public class X {\n public static void main(String[] args) {\n   foo(Long.valueOf(10));\n }\n private static void foo(Object o) {\n   String s1 = \" Hello \";\n   String s2 = \"World!\";\n   switch (o) {\n     case Integer I when I > 10: break;\n      case X J: break;\n      case String s : break;\n      default:\n       s1 = new StringBuilder(String.valueOf(s1)).append(String.valueOf(s2)).toString();\n       System.out.println(s1);\n       break; \n   }\n }\n}"}, "Hello World!");
    }

    public void testBug574614_002() {
        this.runConformTest(new String[]{"X.java", "public class X {\n public static void main(String[] args) {\n   foo(Long.valueOf(0));\n }\n private static void foo(Object o) {\n   switch (o) {\n     case Integer I:\n       break;\n      case String s :\n       break;\n      case X J:\n       break;\n      default:\n       String s1 = \"Hello \";\n       String s2 = \"World!\";\n       s1 = s1 +s2; \n       System.out.println(s1);\n       break;\n   }\n } \n}"}, "Hello World!");
    }

    public void testBug573921_1() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n private static void foo(Object o) {\n\t\tswitch(o) {\n\t\t\tcase CharSequence cs ->\n\t\t\tSystem.out.println(\"A sequence of length \" + cs.length());\n\t\t\tcase String s when s.length() > 0 -> \n\t\t\tSystem.out.println(\"A string: \" + s);\n\t\t\tdefault -> {\n\t\t\t\tbreak;\n\t\t\t} \n\t\t}\n }\n}"}, "----------\n1. ERROR in X.java (at line 6)\n\tcase String s when s.length() > 0 -> \n\t     ^^^^^^^^\nThis case label is dominated by one of the preceding case labels\n----------\n");
    }

    public void testBug573921_2() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n private static void foo(Object o) {\n\t\tswitch(o) {\n\t\t\tcase CharSequence cs:\n\t\t\t\tSystem.out.println(\"A sequence of length \" + cs.length());\n\t\t\t\tbreak;\n\t\t\tcase String s:\n\t\t\t\tSystem.out.println(\"A string: \" + s);\n\t\t\t\tbreak;\n\t\t\tdefault: \n\t\t\t\tbreak;\n\t\t}\n }\n}"}, "----------\n1. ERROR in X.java (at line 7)\n\tcase String s:\n\t     ^^^^^^^^\nThis case label is dominated by one of the preceding case labels\n----------\n");
    }

    public void testBug573921_3() {
        this.runConformTest(new String[]{"X.java", "public class X {\n public static void main(String[] args) {\n   foo(\"Hello!\");\n }\n private static void foo(Object o) {\n\t\tswitch(o) {\n\t\t\tcase String s:\n\t\t\t\tSystem.out.println(\"String:\" + s);\n\t\t\t\tbreak;\n\t\t\tcase CharSequence cs:\n\t\t\t\tSystem.out.println(\"A CS:\" + cs);\n\t\t\t\tbreak;\n\t\t\tdefault: \n\t\t\t\tbreak;\n\t\t}\n }\n}"}, "String:Hello!");
    }

    public void testBug573921_4() {
        this.runConformTest(new String[]{"X.java", "public class X {\n public static void main(String[] args) {\n   foo(new StringBuffer(\"Hello!\"));\n }\n private static void foo(Object o) {\n\t\tswitch(o) {\n\t\t\tcase String s:\n\t\t\t\tSystem.out.println(\"String:\" + s);\n\t\t\t\tbreak;\n\t\t\tcase CharSequence cs:\n\t\t\t\tSystem.out.println(\"A CS:\" + cs.toString());\n\t\t\t\tbreak;\n\t\t\tdefault: \n\t\t\t\tbreak;\n\t\t}\n }\n}"}, "A CS:Hello!");
    }

    public void testBug573921_5() {
        this.runConformTest(new String[]{"X.java", "public class X {\n public static void main(String[] args) {\n   foo(\"Hello\");\n }\n private static void foo(Object o) {\n\t\tswitch(o) {\n\t\tcase String s when s.length() < 5 :\n\t\t\tSystem.out.println(\"1:\" + s);\n\t\t\tbreak;\n\t\tcase String s when s.length() == 5:\n\t\t\tSystem.out.println(\"2:\" + s);\n\t\t\tbreak;\n\t\tdefault : System.out.println(\"Object\");\n\t}\n }\n}"}, "2:Hello");
    }

    public void testBug573921_6() {
        this.runConformTest(new String[]{"X.java", "public class X {\n public static void main(String[] args) {\n   foo(\"\");\n }\n private static void foo(Object o) {\n\t\tswitch(o) {\n\t\tcase String s when s.length() < 5 :\n\t\t\tSystem.out.println(\"1:\" + s);\n\t\t\tbreak;\n\t\tcase String s when s.length() == 5:\n\t\t\tSystem.out.println(\"2:\" + s);\n\t\t\tbreak;\n\t\tdefault : System.out.println(\"Object\");\n\t}\n }\n}"}, "1:");
    }

    public void testBug573921_7() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\npublic class X {\n @SuppressWarnings(\"rawtypes\")\n private static void foo(Object o) {\n\t\tswitch(o) {\n\t\tcase List cs:\n\t\t\tSystem.out.println(\"A sequence of length \" + cs.size());\n\t\t\tbreak;\n\t\tcase List<String> s: \n\t\t\tSystem.out.println(\"A string: \" + s);\n\t\t\tbreak;\n\t\t}  }\n}"}, "----------\n1. ERROR in X.java (at line 5)\n\tswitch(o) {\n\t       ^\nAn enhanced switch statement should be exhaustive; a default label expected\n----------\n2. ERROR in X.java (at line 9)\n\tcase List<String> s: \n\t     ^^^^^^^^^^^^^^\nType Object cannot be safely cast to List<String>\n----------\n");
    }

    public void testBug573921_8() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\npublic class X {\n @SuppressWarnings(\"rawtypes\")\n private static void foo(Object o) {\n\t\tswitch(o.hashCode()) {\n\t\tcase String s:\n\t\t\tbreak;\n\t\tdefault: \n\t\t\tbreak;\n\t\t}  }\n}"}, "----------\n1. ERROR in X.java (at line 6)\n\tcase String s:\n\t     ^^^^^^^^\nType mismatch: cannot convert from int to String\n----------\n");
    }

    public void testBug573921_9() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\npublic class X {\n @SuppressWarnings(\"rawtypes\")\n private static void foo(Object o) {\n\t\tswitch(o) {\n\t\tcase Object o1:\n\t\t\tbreak;\n\t\tdefault: \n\t\t\tbreak;\n\t\t}  }\n}"}, "----------\n1. ERROR in X.java (at line 8)\n\tdefault: \n\t^^^^^^^\nSwitch case cannot have both unconditional pattern and default label\n----------\n");
    }

    public void testBug573921_10() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\npublic class X {\n @SuppressWarnings(\"rawtypes\")\n private static void foo(List<String> o) {\n\t\tswitch(o) {\n\t\tcase List o1:\n\t\t\tbreak;\n\t\tdefault: \n\t\t\tbreak;\n\t\t}  }\n}"}, "----------\n1. ERROR in X.java (at line 8)\n\tdefault: \n\t^^^^^^^\nSwitch case cannot have both unconditional pattern and default label\n----------\n");
    }

    public void testBug573921_11() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\npublic class X {\n @SuppressWarnings(\"rawtypes\")\n private static void foo(String s) {\n\t\tswitch(s) {\n\t\tcase CharSequence cs:\n\t\t\tbreak;\n\t\tdefault: \n\t\t\tbreak;\n\t\t}  }\n}"}, "----------\n1. ERROR in X.java (at line 8)\n\tdefault: \n\t^^^^^^^\nSwitch case cannot have both unconditional pattern and default label\n----------\n");
    }

    public void testBug575049_001() {
        this.runConformTest(new String[]{"X.java", "sealed interface I permits A,B,C {}\nfinal class A implements I {}\nfinal class B implements I {}\nrecord C(int j) implements I {} // Implicitly final\npublic class X {\n static int testSealedCoverage(I i) {\n   return switch (i) {\n   case A a -> 0;\n   case B b -> 1;\n   case C c -> 2; // No default required!\n   default -> 3;\n   };\n }\n public static void main(String[] args) {\n   A a = new A();\n   System.out.println(testSealedCoverage(a));\n }\n}"}, "0");
    }

    public void testBug575049_002() {
        this.runConformTest(new String[]{"X.java", "sealed interface I permits A,B,C {}\nfinal class A implements I {}\nfinal class B implements I {}\nrecord C(int j) implements I {} // Implicitly final\npublic class X {\n static int testSealedCoverage(I i) {\n   return switch (i) {\n   case A a -> 0;\n   case B b -> 1;\n   case C c -> 2; // No default required!\n   };\n }\n public static void main(String[] args) {\n   A a = new A();\n   System.out.println(testSealedCoverage(a));\n }\n}"}, "0");
    }

    public void testBug575049_003() {
        this.runConformTest(new String[]{"X.java", "sealed interface I permits A,B,C {}\nfinal class A implements I {}\nfinal class B implements I {}\nrecord C(int j) implements I {} // Implicitly final\npublic class X {\n static int testSealedCoverage(I i) {\n   return switch (i) {\n   case A a -> 0;\n   case B b -> 1;\n   default -> 2; // No default required!\n   };\n }\n public static void main(String[] args) {\n   A a = new A();\n   System.out.println(testSealedCoverage(a));\n }\n}"}, "0");
    }

    public void testBug575049_004() {
        this.runNegativeTest(new String[]{"X.java", "sealed interface I permits A,B,C {}\nfinal class A implements I {}\nfinal class B implements I {}\nrecord C(int j) implements I {} // Implicitly final\npublic class X {\n static int testSealedCoverage(I i) {\n   return switch (i) {\n   case A a -> 0;\n   case B b -> 1;\n   };\n }\n public static void main(String[] args) {\n   A a = new A();\n   System.out.println(testSealedCoverage(a));\n }\n}"}, "----------\n1. ERROR in X.java (at line 7)\n\treturn switch (i) {\n\t               ^\nA switch expression should have a default case\n----------\n");
    }

    public void testBug575048_01() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n static int foo(Integer i) {\n   return switch (i) {\n     default -> 2;\n     case Integer i1 -> 0;\n   };\n }\n public static void main(String[] args) {\n   System.out.println(foo(1));\n }\n}"}, "----------\n1. ERROR in X.java (at line 5)\n\tcase Integer i1 -> 0;\n\t     ^^^^^^^^^^\nThis case label is dominated by one of the preceding case labels\n----------\n");
    }

    public void testBug575053_001() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic void foo(String o) {\n\t\tswitch (o) {\n\t\t  case String s when s.length() > 0  -> {}\n\t\t  default -> {}\n\t\t} \n\t}\n\tpublic static void main(String[] args) {\n\t\ttry{\n\t\t  (new X()).foo(null);\n\t\t} catch(Exception e) {\n\t\t \tSystem.out.println(\"Null Pointer Exception Thrown\");\n\t\t}\n\t}\n}"}, "Null Pointer Exception Thrown");
    }

    public void testBug575053_002() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic void foo(Object o) {\n\t\tswitch (o) {\n\t\t  case String s -> {}\n\t\t  default -> {}\n\t\t} \n\t}\n\tpublic static void main(String[] args) {\n\t\ttry{\n\t\t  (new X()).foo(null);\n\t\t} catch(Exception t) {\n\t\t \tSystem.err.println(\"Null Pointer Exception Thrown\");\n\t\t}\n\t}\n}"}, "", "Null Pointer Exception Thrown");
    }

    public void testBug575249_01() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static int foo(Object o) {\n\t\treturn switch (o) {\n\t\t  case (String s) : yield 0;\n\t\t  default : yield 1;\n\t\t};\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(foo(\"Hello\"));\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\tcase (String s) : yield 0;\n\t             ^\nSyntax error on token \"s\", delete this token\n----------\n2. ERROR in X.java (at line 4)\n\tcase (String s) : yield 0;\n\t                  ^^^^^\nSyntax error on token \"yield\", AssignmentOperator expected after this token\n----------\n");
    }

    public void testBug575249_02() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static int foo(Object o) {\n\t\treturn switch (o) {\n\t\t  case String s when s.length() < 10 : yield 0;\n\t\t  default : yield 1;\n\t\t};\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(foo(\"Hello\"));\n\t}\n}"}, "0");
    }

    public void testBug575249_03() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static int foo(Object o) {\n\t\treturn switch (o) {\n\t\t  case (String s) -> 0;\n\t\t  default -> 1;\n\t\t};\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(foo(\"Hello\"));\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\tcase (String s) -> 0;\n\t^^^^\nSyntax error on token \"case\", ( expected after this token\n----------\n2. ERROR in X.java (at line 4)\n\tcase (String s) -> 0;\n\t                   ^\nSyntax error, insert \":\" to complete SwitchLabel\n----------\n");
    }

    public void testBug575249_04() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static int foo(Object o) {\n\t\treturn switch (o) {\n\t\t  case String s when s.length() < 10 -> 0;\n\t\t  default -> 1;\n\t\t};\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(foo(\"Hello\"));\n\t}\n}"}, "0");
    }

    public void testBug575241_01() {
        this.runConformTest(new String[]{"X.java", "public class X {\n static int foo(Integer i) {\n   return switch (i) {\n     case Integer i1 -> 0;\n   };\n }\n public static void main(String[] args) {\n   System.out.println(foo(1));\n }\n}"}, "0");
    }

    public void testBug575241_02() {
        this.runConformTest(new String[]{"X.java", "public class X {\n static int foo(Integer i) {\n   return switch (i) {\n     case Object o -> 0;\n   };\n }\n public static void main(String[] args) {\n   System.out.println(foo(1));\n }\n}"}, "0");
    }

    public void testBug575241_03() {
        this.runConformTest(new String[]{"X.java", "public class X {\n static int foo(Object myVar) {\n   return switch (myVar) {\n     case null  -> 0;\n     case Integer o -> 1;\n     case Object obj ->2;\n   };\n }\n public static void main(String[] args) {\n   System.out.println(foo(Integer.valueOf(0)));\n   System.out.println(foo(null));\n }\n}"}, "1\n0");
    }

    public void testBug575241_04() {
        this.runConformTest(new String[]{"X.java", "public class X {\n static int foo(Object myVar) {\n   return switch (myVar) {\n     case Integer o -> 1;\n     case Object obj ->2;\n   };\n }\n public static void main(String[] args) {\n   System.out.println(foo(Integer.valueOf(0)));\n   try {\n   foo(null);\n   } catch (NullPointerException e) {\n     System.out.println(\"NPE\");\n   }\n }\n}"}, "1\nNPE");
    }

    public void testBug575241_05() {
        this.runConformTest(new String[]{"X.java", "public class X {\n static void foo(Integer myVar) {\n    switch (myVar) {\n     case  null  -> System.out.println(100);\n     case Integer o -> System.out.println(o);\n   };\n }\n public static void main(String[] args) {\n   foo(Integer.valueOf(0));\n   try {\n   foo(null);\n   } catch (NullPointerException e) {\n     System.out.println(\"NPE\");\n   }\n }\n}"}, "0\n100");
    }

    public void testBug575241_06() {
        this.runConformTest(new String[]{"X.java", "public class X {\n static void foo(Integer myVar) {\n    switch (myVar) {\n     case Integer o -> System.out.println(o);\n   };\n }\n public static void main(String[] args) {\n   foo(Integer.valueOf(0));\n   try {\n   foo(null);\n   } catch (NullPointerException e) {\n     System.out.println(\"NPE\");\n   }\n }\n}"}, "0\nNPE");
    }

    public void testBug575241_07() {
        this.runConformTest(new String[]{"X.java", "public class X {\n static void foo(String myVar) {\n    switch (myVar) {\n     case  null  -> System.out.println(100);\n     case String o -> System.out.println(o);\n   };\n }\n public static void main(String[] args) {\n   foo(\"Hello\");\n   foo(null);\n }\n}"}, "Hello\n100");
    }

    public void testBug575241_08() {
        this.runConformTest(new String[]{"X.java", "public class X {\n static void foo(String myVar) {\n    switch (myVar) {\n     case String o -> System.out.println(o);\n   };\n }\n public static void main(String[] args) {\n   foo(\"Hello\");\n   try {\n   foo(null);\n   } catch (NullPointerException e) {\n     System.out.println(\"NPE\");\n   }\n }\n}"}, "Hello\nNPE");
    }

    public void testBug575356_01() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n static void foo(Integer myVar) {\n    switch (myVar) {\n     case default -> System.out.println(\"hello\");\n   };   \n }   \n\n public static  void main(String[] args) {\n   foo(Integer.valueOf(10)); \n } \n}"}, "----------\n1. ERROR in X.java (at line 4)\n\tcase default -> System.out.println(\"hello\");\n\t     ^^^^^^^\nA 'default' can occur after 'case' only as a second case label expression and that too only if 'null' precedes  in 'case null, default' \n----------\n");
    }

    public void testBug575356_02() {
        this.runConformTest(new String[]{"X.java", "public class X {\n static void foo(Integer myVar) {\n    switch (myVar) {\n     case null, default -> System.out.println(\"hello\");\n   };   \n }   \n\n public static  void main(String[] args) {\n   foo(Integer.valueOf(10)); \n } \n}"}, "hello");
    }

    public void testBug575356_03() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n static void foo(Integer myVar) {\n    switch (myVar) {\n     case default, null -> System.out.println(\"hello\");\n   };   \n }   \n\n public static  void main(String[] args) {\n   foo(Integer.valueOf(10)); \n } \n}"}, "----------\n1. ERROR in X.java (at line 4)\n\tcase default, null -> System.out.println(\"hello\");\n\t     ^^^^^^^\nA 'default' can occur after 'case' only as a second case label expression and that too only if 'null' precedes  in 'case null, default' \n----------\n2. ERROR in X.java (at line 4)\n\tcase default, null -> System.out.println(\"hello\");\n\t              ^^^^\nA null case label has to be either the only expression in a case label or the first expression followed only by a default\n----------\n3. ERROR in X.java (at line 4)\n\tcase default, null -> System.out.println(\"hello\");\n\t              ^^^^\nThis case label is dominated by one of the preceding case labels\n----------\n");
    }

    public void testBug575356_04() {
        this.runConformTest(new String[]{"X.java", "public class X {\nprivate static void foo(Object o) {\n   switch (o) {\n    case Integer i ->\n      System.out.println(\"Integer:\"+ i );\n    case null, default -> System.out.println(o.toString() );\n   }\n}\n\n public static  void main(String[] args) {\n   foo(Integer.valueOf(10)); \n   foo(new String(\"Hello\")); \n } \n}"}, "Integer:10\nHello");
    }

    public void testBug575052_001() {
        this.runConformTest(new String[]{"X.java", "public class X {\n static void foo(Object o) {\n   switch (o) {\n   case String s -> System.out.println(s);\n   default -> System.out.println(0);\n   };\n }\n public static void main(String[] args) {\n   foo(\"Hello\");\n }\n}"}, "Hello");
    }

    public void testBug575052_002() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n static void foo(Object o) {\n   switch (o) {\n   \tcase String s -> System.out.println(s);\n   };\n }\n public static void main(String[] args) {\n   foo(\"Hello\");\n }\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tswitch (o) {\n\t        ^\nAn enhanced switch statement should be exhaustive; a default label expected\n----------\n");
    }

    public void testBug575052_003() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n static int foo(Object o) {\n   switch (o) {\n   \tcase null -> System.out.println(0);\n   };\n }\n public static void main(String[] args) {\n   foo(\"Hello\");\n }\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tswitch (o) {\n\t        ^\nAn enhanced switch statement should be exhaustive; a default label expected\n----------\n");
    }

    public void testBug575052_004() {
        this.runConformTest(new String[]{"X.java", "public class X {\n private static int foo(int i) {\n   switch (i) {\n   case 1:\n     break;\n   }\n   return 0;\n }\n public static void main(String[] args) {\n   System.out.println(X.foo(0));\n }\n}"}, "0");
    }

    public void testBug575050_001() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n static int foo(Object o) {\n   return switch (o) {\n   \tcase String s -> 0;\n   };\n }\n public static void main(String[] args) {\n   foo(\"Hello\");\n }\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\treturn switch (o) {\n\t               ^\nA switch expression should have a default case\n----------\n");
    }

    public void testBug575050_002() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n static int  foo(Object o) {\n   return switch (o) {\n   \tcase null -> 0;\n   };\n }\n public static void main(String[] args) {\n   foo(\"Hello\");\n }\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\treturn switch (o) {\n\t               ^\nA switch expression should have a default case\n----------\n");
    }

    public void testBug575047_01() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n static int foo(Integer i) {\n   return switch (i) {\n     case Integer i1 -> 0;\n     case null -> 2;\n   };\n   Zork();\n }\n}"}, "----------\n1. ERROR in X.java (at line 7)\n\tZork();\n\t^^^^\nThe method Zork() is undefined for the type X\n----------\n");
    }

    public void testBug575047_02() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n static int foo(Integer i) {\n   return switch (i) {\n     case Integer i1 -> i1;\n     case 0 -> 0;\n   };\n }\n}"}, "----------\n1. ERROR in X.java (at line 5)\n\tcase 0 -> 0;\n\t     ^\nThis case label is dominated by one of the preceding case labels\n----------\n");
    }

    public void testBug575047_03() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n static void foo(Color c) {\n   switch (c) {\n\t\t\tcase Color c1 : \n\t\t\t\tbreak;\n\t\t\tcase Blue :\n\t\t\t\tbreak;\n\t\t}\n }\nenum Color { Blue, Red; }\n}"}, "----------\n1. ERROR in X.java (at line 6)\n\tcase Blue :\n\t     ^^^^\nThis case label is dominated by one of the preceding case labels\n----------\n");
    }

    public void testBug575047_04() {
        this.runConformTest(new String[]{"X.java", "public class X {\n static int foo(Integer i) {\n   return switch (i) {\n     case null -> 2;\n     case Integer i1 -> 0;\n   };\n }\n public static void main(String[] args) {\n   System.out.println(foo(null));\n   System.out.println(foo(Integer.valueOf(0)));\n }\n}"}, "2\n0");
    }

    public void testBug575047_05() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n static void foo(float c) {\n   switch (c) {\n\t\t\tcase 0 : \n\t\t\t\tbreak;\n\t\t\tdefault :\n\t\t}\n }\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tswitch (c) {\n\t        ^\nCannot switch on a value of type float. Only convertible int values, strings or enum variables are permitted\n----------\n");
    }

    public void testBug575047_06() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n static int foo(String o) {\n    return switch (o) {\n\t\t     case String s when s.length() > 0 -> 3;\n\t\t     case String s1 -> 1;\n\t\t     case String s -> -1;\n\t\t   };\n }\n}"}, "----------\n1. ERROR in X.java (at line 6)\n\tcase String s -> -1;\n\t     ^^^^^^^^\nThis case label is dominated by one of the preceding case labels\n----------\n");
    }

    public void testBug575047_07() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n static void foo(Number i) {\n\t    switch (i) {\n\t\t case Integer j, \"\":\n\t\t\t System.out.println(0);\n\t\t default:\n\t   }\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\tcase Integer j, \"\":\n\t                ^^\nCannot mix pattern with other case labels\n----------\n2. ERROR in X.java (at line 4)\n\tcase Integer j, \"\":\n\t                ^^\nCase constant of type String is incompatible with switch selector type Number\n----------\n");
    }

    public void testBug575047_08() {
        this.runConformTest(new String[]{"X.java", "public class X {\n static int foo(Integer i) {\n   return switch (i) {\n     case 0 -> 0;\n     case Integer i1 -> i1;\n   };\n }\n public static void main(String[] args) {\n   System.out.println(foo(3));\n   System.out.println(foo(0));\n }\n}"}, "3\n0");
    }

    public void testBug575047_09() {
        this.runConformTest(new String[]{"X.java", "public class X {\n \tstatic int foo(String i) {\n\t\treturn switch (i) {\n\t     case \"\" -> 0;\n\t     case String s -> -1;\n\t   };\n\t}\n public static void main(String[] args) {\n   System.out.println(foo(\"\"));\n   System.out.println(foo(\"abc\"));\n }\n}"}, "0\n-1");
    }

    public void testBug575047_10() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tstatic String foo(Object o) {\n\t   return switch (o) {\n\t\t case String i when i.length() == 0 -> \"empty\";\n\t     case String i when i.length() > 0 -> \"zero+\";\n\t     case Color s -> s.toString();\n\t\t default -> \"unknown\";\n\t   };\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(foo(\"abc\"));\n\t\tSystem.out.println(foo(\"\"));\n\t\tSystem.out.println(Color.Blue);\n\t\tSystem.out.println(foo(args));\n\t}\n} \nenum Color {\n\tBlue, Red; \n}"}, "zero+\nempty\nBlue\nunknown");
    }

    public void testBug575047_11() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tstatic String foo(Color o) {\n\t\treturn switch (o) {\n\t     case Red -> \"Const:Red\";\n\t     case Color s -> s.toString();\n\t   };\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(foo(Color.Red));\n\t\tSystem.out.println(foo(Color.Blue));\n\t}\n} \nenum Color {\n\tBlue, Red; \n}"}, "Const:Red\nBlue");
    }

    public void testBug575047_12() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tstatic String foo(Color o) {\n\t\treturn switch (o) {\n\t     case Red -> \"Red\";\n\t     case Color s when s == Color.Blue  -> s.toString();\n\t     case Color s -> s.toString();\n\t   };\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(Color.Red);\n\t\tSystem.out.println(Color.Blue);\n\t}\n} \nenum Color {\n\tBlue, Red; \n}"}, "Red\nBlue");
    }

    public void testBug575047_13() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tstatic String foo(Color o) {\n\t\treturn switch (o) {\n\t     case Color s when s == Color.Blue  -> s.toString();\n\t     case Red -> \"Red\";\n\t     case null -> \"\";\n\t   };\n\t}\n} \nenum Color {\n\tBlue, Red; \n}"}, "----------\n1. ERROR in X.java (at line 3)\n\treturn switch (o) {\n\t               ^\nA Switch expression should cover all possible values\n----------\n");
    }

    public void testBug575047_14() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tstatic String foo(Color o) {\n\t\treturn switch (o) {\n\t     case Color s when s == Color.Blue  -> s.toString();\n\t     case Red -> \"Red\";\n\t   };\n\t}\n} \nenum Color {\n\tBlue, Red; \n}"}, "----------\n1. ERROR in X.java (at line 3)\n\treturn switch (o) {\n\t               ^\nA Switch expression should cover all possible values\n----------\n");
    }

    public void testBug575047_15() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tstatic void foo(Integer o) {\n\t\tswitch (o) {\n\t\t  case 1: break;\n\t\t  case Integer s when s == 2:\n\t\t\t  System.out.println(s);break;\n\t\t  case null, default:\n\t\t\t  System.out.println(\"null/default\");\n\t\t}\n\t}\n\tpublic static  void main(String[] args) {\n\t\tfoo(null);\n\t}\n}"}, "null/default");
    }

    public void testBug575360_001() {
        this.runConformTest(new String[]{"X.java", "public class X {\n static void foo(String myVar) { // String\n    switch (myVar) {\n     case null, default : System.out.println(\"hello\");\n   };   \n }\n public static  void main(String[] args) { \n   foo(new String(\"Hello\")); \n }\n}"}, "hello");
    }

    public void testBug575055_001() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic int foo(CharSequence c) {\n\t\treturn switch (c) {\n\t\t   case CharSequence c1 when (c instanceof String c1 && c1.length() > 0) -> 0;\n\t\t   default -> 0;\n\t\t};\n\t}}"}, "----------\n1. ERROR in X.java (at line 4)\n\tcase CharSequence c1 when (c instanceof String c1 && c1.length() > 0) -> 0;\n\t                                               ^^\nA pattern variable with the same name is already defined in the statement\n----------\n");
    }

    public void testBug575051_1() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic void foo(Object o) {\n\t  try{\n\t\tswitch (o) {\n\t\t  default:\n\t\t\t  break;\n\t\t  case String s :\n\t\t\t  System.out.println(s);\n\t\t} \n\t  } catch(Exception t) {\n\t\t t.printStackTrace(System.out);\n\t  }\n\t}\n\tpublic static void main(String[] args) {\n\t\t  (new X()).foo(null);\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 7)\n\tcase String s :\n\t     ^^^^^^^^\nThis case label is dominated by one of the preceding case labels\n----------\n");
    }

    public void testBug575051_2() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic void foo(Object o) {\n\t\tswitch (o) {\n\t\t  case String s :\n\t\t\t  System.out.println(s);\n\t\t\t\t//$FALL-THROUGH$\n\t\t  case null:\n\t\t\t  break;\n\t\t  default : \n\t\t\t\t  break;\n\t\t}\n\t}\n\tpublic static void main(String[] args) {\n\t\t(new X()).foo(null);\n\t}\n}"}, "");
    }

    public void testBug575571_1() {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.customOptions = this.getCompilerOptions();
        runner.customOptions.put("org.eclipse.jdt.core.compiler.problem.missingDefaultCase", "warning");
        runner.testFiles = new String[]{"X.java", "public class X {\n       public void foo(Color o) {\n               switch (o) {\n                 case Blue:\n                       break;\n               }\n       }\n       public static void main(String[] args) {}\n}\nenum Color {   Blue;  }\n"};
        runner.expectedCompilerLog = "----------\n1. WARNING in X.java (at line 3)\n\tswitch (o) {\n\t        ^\nThe switch over the enum type Color should have a default case\n----------\n";
        runner.javacTestOptions = AbstractRegressionTest.JavacTestOptions.Excuse.EclipseHasSomeMoreWarnings;
        runner.runWarningTest();
    }

    public void testBug575571_2() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic void foo(Color o) {\n\t\tswitch (o) {\n\t\t  case Blue:\n\t\t  case Color c:\n\t\t\tbreak;\n\t\t}\n\t}\n\tpublic static void main(String[] args) {}\n}\nenum Color {\tBlue, Red;  }\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tcase Color c:\n\t^^^^^^^^^^^^\nIllegal fall-through to a pattern\n----------\n");
    }

    public void testBug575714_01() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n static Object foo(Object o) {\n   switch (o) {\n       case Object __ -> throw new AssertionError(); \n   }\n }\n public static void main(String[] args) {\n   Zork();\n }\n}"}, "----------\n1. ERROR in X.java (at line 8)\n\tZork();\n\t^^^^\nThe method Zork() is undefined for the type X\n----------\n");
    }

    public void testBug575714_02() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n static Object foo(Object o) {\n   switch (o) {\n       case Object __ -> System.out.println(\"Hello\"); \n   }\n }\n public static void main(String[] args) {\n   X.foo(new X());\n }\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\tstatic Object foo(Object o) {\n\t              ^^^^^^^^^^^^^\nThis method must return a result of type Object\n----------\n");
    }

    public void testBug575714_03() {
        this.runConformTest(new String[]{"X.java", "class X {\n static Object foo(Object o) {\n   switch (o) {\n       case Object __ -> System.out.println(\"Hello\"); \n   }\n   return null;\n }\n public static void main(String[] args) {\n   X.foo(new X());\n }\n}"}, "Hello");
    }

    public void testBug575714_04() {
        this.runConformTest(new String[]{"X.java", "class X {\n static Object foo(Object o) throws Exception {\n   switch (o) {\n       case Object __ -> throw new Exception(); \n   }\n }\n public static void main(String[] args) {\n   try {\n     X.foo(new X());\n   } catch (Exception e) {\n     System.out.println(\"Hello\");\n   }\n }\n}"}, "Hello");
    }

    public void testBug575687_1() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tstatic void number(Number i) {\n\t\tswitch (i) {\n\t\t\tcase Integer i2, 4.5:\n\t\t\tcase 4.3: System.out.println();\n\t\t\tdefault: System.out.println(\"nothing\");\n\t\t}\n\t}\n\tpublic static void main(String[] args) {}\n}\nenum Color {\tBlue, Red;  }\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tcase Integer i2, 4.5:\n\t                 ^^^\nCannot mix pattern with other case labels\n----------\n2. ERROR in X.java (at line 4)\n\tcase Integer i2, 4.5:\n\t                 ^^^\nCase constant of type double is incompatible with switch selector type Number\n----------\n3. ERROR in X.java (at line 5)\n\tcase 4.3: System.out.println();\n\t     ^^^\nCase constant of type double is incompatible with switch selector type Number\n----------\n");
    }

    public void testBug575686_1() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid m(Object o) {\n\t\tswitch (o) {\n\t\t\tcase Integer i1, String s1 ->\n\t\t\t\tSystem.out.print(s1);\n\t\t\tdefault -> System.out.print(\"default\");\n\t\t\tcase Number n, null ->\n\t\t\t\tSystem.out.print(o);\n\t\t\tcase null, Class c ->\n\t\t\t\tSystem.out.print(o);\n\t\t}\n\t}\n\tpublic static void main(String[] args) {}\n}\nenum Color {\tBlue, Red;  }\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tcase Integer i1, String s1 ->\n\t             ^^\nNamed pattern variables are not allowed here\n----------\n2. ERROR in X.java (at line 4)\n\tcase Integer i1, String s1 ->\n\t                        ^^\nNamed pattern variables are not allowed here\n----------\n3. ERROR in X.java (at line 5)\n\tSystem.out.print(s1);\n\t                 ^^\ns1 cannot be resolved to a variable\n----------\n4. ERROR in X.java (at line 7)\n\tcase Number n, null ->\n\t     ^^^^^^^^\nThis case label is dominated by one of the preceding case labels\n----------\n5. ERROR in X.java (at line 7)\n\tcase Number n, null ->\n\t               ^^^^\nCannot mix pattern with other case labels\n----------\n6. ERROR in X.java (at line 7)\n\tcase Number n, null ->\n\t               ^^^^\nA null case label has to be either the only expression in a case label or the first expression followed only by a default\n----------\n7. ERROR in X.java (at line 7)\n\tcase Number n, null ->\n\t               ^^^^\nThis case label is dominated by one of the preceding case labels\n----------\n8. ERROR in X.java (at line 9)\n\tcase null, Class c ->\n\t     ^^^^\nThis case label is dominated by one of the preceding case labels\n----------\n9. ERROR in X.java (at line 9)\n\tcase null, Class c ->\n\t     ^^^^\nDuplicate case\n----------\n10. ERROR in X.java (at line 9)\n\tcase null, Class c ->\n\t           ^^^^^^^\nCannot mix pattern with other case labels\n----------\n11. WARNING in X.java (at line 9)\n\tcase null, Class c ->\n\t           ^^^^^\nClass is a raw type. References to generic type Class<T> should be parameterized\n----------\n12. ERROR in X.java (at line 9)\n\tcase null, Class c ->\n\t           ^^^^^^^\nThis case label is dominated by one of the preceding case labels\n----------\n");
    }

    public void testBug575738_001() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tprivate static void foo(Object o) {\n\t   switch (o.hashCode()) {\n\t     case int t: System.out.println(\"Integer\"); \n\t     default : System.out.println(\"Object\"); \n\t   }\n\t}\n\tpublic static void main(String[] args) { \n\t\tfoo(\"Hello World\");\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\tcase int t: System.out.println(\"Integer\"); \n\t     ^^^^^\nUnexpected type int, expected class or array type\n----------\n");
    }

    public void testBug575738_002() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tprivate static void foo(Object o) {\n\t   switch (o.hashCode()) {\n\t     case Integer t: System.out.println(\"Integer\"); \n\t     default : System.out.println(\"Object\"); \n\t   }\n\t}\n\tpublic static void main(String[] args) { \n\t\tfoo(\"Hello World\");\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\tcase Integer t: System.out.println(\"Integer\"); \n\t     ^^^^^^^^^\nType mismatch: cannot convert from int to Integer\n----------\n");
    }

    public void testBug576075_001() throws Exception {
        this.runConformTest(new String[]{"p/Rec.java", "package p;\nimport p.Rec.MyInterface.MyClass1;\nimport p.Rec.MyInterface.MyClass2;\npublic record Rec(MyInterface c) {\n\tpublic static sealed interface MyInterface permits MyClass1, MyClass2 {\n\t\tpublic static final class MyClass1 implements MyInterface { }\n        public static final class MyClass2 implements MyInterface { }\n    }\n    public boolean bla() {\n        return switch (c) {\n            case MyClass1 mc1 -> true;\n            case MyClass2 mc2 -> false;\n        };\n    }\n    public static void main(String[] args) {\n        new Rec(new MyClass1()).hashCode();\n        System.out.println(\"works\");\n    }\n}\n"}, "works");
        String expectedOutput = "Bootstrap methods:\n  0 : # 95 invokestatic java/lang/runtime/SwitchBootstraps.typeSwitch:(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;[Ljava/lang/Object;)Ljava/lang/invoke/CallSite;\n\tMethod arguments:\n\t\t#22 p/Rec$MyInterface$MyClass1\n\t\t#24 p/Rec$MyInterface$MyClass2,\n  1 : # 102 invokestatic java/lang/runtime/ObjectMethods.bootstrap:(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/TypeDescriptor;Ljava/lang/Class;Ljava/lang/String;[Ljava/lang/invoke/MethodHandle;)Ljava/lang/Object;\n\tMethod arguments:\n\t\t#1 p/Rec\n\t\t#103 c\n\t\t#104 REF_getField c:Lp/Rec$MyInterface;";
        this.verifyClassFile(expectedOutput, "p/Rec.class", 4);
    }

    public void testBug576785_001() {
        this.runConformTest(new String[]{"X.java", "sealed interface J<X> permits D, E {}\nfinal class D implements J<String> {}\nfinal class E<X> implements J<X> {}\n\npublic class X {\n       static int testExhaustive2(J<Integer> ji) {\n               return switch (ji) { // Exhaustive!\n               case E<Integer> e -> 42;\n               };\n       }\n       public static void main(String[] args) {\n               J<Integer> ji = new E<>();\n               System.out.println(X.testExhaustive2(ji));\n       }\n}"}, "42");
    }

    public void testBug576785_002() {
        this.runNegativeTest(new String[]{"X.java", "@SuppressWarnings(\"rawtypes\")\nsealed interface J<T> permits D, E, F {}\nfinal class D implements J<String> {}\nfinal class E<T> implements J<T> {}\nfinal class F<T> implements J<T> {}\n\npublic class X {\n static int testExhaustive2(J<Integer> ji) {\n   return switch (ji) { // Exhaustive!\n   case E<Integer> e -> 42;\n   };\n }\n public static void main(String[] args) {\n   J<Integer> ji = new E<>();\n   System.out.println(X.testExhaustive2(ji));\n   Zork();\n }\n}"}, "----------\n1. ERROR in X.java (at line 9)\n\treturn switch (ji) { // Exhaustive!\n\t               ^^\nA switch expression should have a default case\n----------\n2. ERROR in X.java (at line 16)\n\tZork();\n\t^^^^\nThe method Zork() is undefined for the type X\n----------\n");
    }

    public void testBug576830_001() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n static void foo(Object o) {\n   switch (o) {\n   };\n }\n public static void main(String[] args) {\n   foo(\"Hello\");\n }\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tswitch (o) {\n\t        ^\nAn enhanced switch statement should be exhaustive; a default label expected\n----------\n");
    }

    public void testBug578107_001() {
        this.runNegativeTest(new String[]{"X.java", "sealed class C permits D {}\nfinal class D extends C {}\npublic class X {\n       static  void foo(C ji) {\n                switch (ji) { // non-exhaustive\n                  case D d : System.out.println(\"D\"); break;\n               }; \n       } \n       public static void main(String[] args) {\n               X.foo(new D());\n               Zork();\n       }\n}"}, "----------\n1. ERROR in X.java (at line 5)\n\tswitch (ji) { // non-exhaustive\n\t        ^^\nAn enhanced switch statement should be exhaustive; a default label expected\n----------\n2. ERROR in X.java (at line 11)\n\tZork();\n\t^^^^\nThe method Zork() is undefined for the type X\n----------\n");
    }

    public void testBug578107_002() {
        this.runNegativeTest(new String[]{"X.java", "abstract sealed class C permits D {}\nfinal class D extends C {}\npublic class X {\n       static  void foo(C ji) {\n                switch (ji) { // non-exhaustive\n                  case D d : System.out.println(\"D\"); break;\n               }; \n       } \n       public static void main(String[] args) {\n               X.foo(new D());\n               Zork();\n       }\n}"}, "----------\n1. ERROR in X.java (at line 11)\n\tZork();\n\t^^^^\nThe method Zork() is undefined for the type X\n----------\n");
    }

    public void testBug578107_003() {
        this.runNegativeTest(new String[]{"X.java", "sealed interface C permits D {}\nfinal class D implements C {}\npublic class X {\n       static  void foo(C ji) {\n                switch (ji) { // non-exhaustive\n                  case D d : System.out.println(\"D\"); break;\n               }; \n       } \n       public static void main(String[] args) {\n               X.foo(new D());\n               Zork();\n       }\n}"}, "----------\n1. ERROR in X.java (at line 11)\n\tZork();\n\t^^^^\nThe method Zork() is undefined for the type X\n----------\n");
    }

    public void testBug578108_001() {
        this.runNegativeTest(new String[]{"X.java", "sealed abstract class C permits D {}\nfinal class D extends C {}\npublic class X {\n static <T extends C> void foo(T  ji) {\n    switch (ji) { // exhaustive because C is sealed and abstract\n      case D d : System.out.println(\"D\"); break;\n   }; \n } \n public static void main(String[] args) {\n   X.foo(new D());\n   Zork();\n }\n}"}, "----------\n1. ERROR in X.java (at line 11)\n\tZork();\n\t^^^^\nThe method Zork() is undefined for the type X\n----------\n");
    }

    public void testBug578108_002() {
        this.runNegativeTest(new String[]{"X.java", "sealed interface C permits D {}\nfinal class D implements C {}\npublic class X {\n static <T extends C> void foo(T  ji) {\n    switch (ji) { // exhaustive because C is sealed and abstract\n      case D d : System.out.println(\"D\"); break;\n   }; \n } \n public static void main(String[] args) {\n   X.foo(new D());\n   Zork();\n }\n}"}, "----------\n1. ERROR in X.java (at line 11)\n\tZork();\n\t^^^^\nThe method Zork() is undefined for the type X\n----------\n");
    }

    public void testBug578143_001() {
        this.runConformTest(new String[]{"X.java", "public class X {\n static  int foo(Object o) {\n   return switch (o) { \n      case X x when true -> 0;\n      default -> 1;\n   }; \n } \n public static void main(String[] args) {\n   System.out.println(X.foo(new X()));\n   System.out.println(X.foo(new Object()));\n }\n}"}, "0\n1");
    }

    public void testBug578143_002() {
        this.runConformTest(new String[]{"X.java", "public class X {\n public static void main(String[] args) {\n     Boolean input = false;\n     int result = switch(input) {\n       case Boolean p when true -> 1;\n     };\n     System.out.println(result);\n }\n}"}, "1");
    }

    public void testBug578402() {
        this.runConformTest(new String[]{"X.java", "public class X  {\nenum Color{BLUE, RED, YELLOW;}\n    public static void run(Color c) {\n        switch(c) {\n                case BLUE -> {\n                    System.out.println(\"BLUE\");\n                }\n                case RED -> {\n                    System.out.println(\"RED\");\n                }\n                case Object o -> {\n                    System.out.println(o.toString());\n                }\n            }\n    }\tpublic static void main(String[] args) {\n\t\trun(Color.RED);\n\t\trun(Color.BLUE);\n\t}\n}"}, "RED\nBLUE");
    }

    public void testBug578402_2() {
        this.runConformTest(new String[]{"X.java", "public class X  {\nstatic final String CONST = \"abc\";\n    public static void main(String args[]) {\n        System.out.println(run());\n    }\n    public static int run() {\n        String s = \"abc\";\n        int a = -1;\n        switch (s) {\n            case CONST -> {\n                a = 2;\n                break;\n            }\n            case null -> {\n                a = 0;\n                break; \n            }\n            default -> {\n            \ta = 1;\n            }\n        }\n        return a;\n    }\n}"}, "2");
    }

    public void testBug578402_3() {
        this.runConformTest(new String[]{"X.java", "public class X  {\nstatic final String CONST = \"abc\";\n    public static void main(String args[]) {\n        System.out.println(run());\n    }\n    public static int run() {\n        String s = \"abc\";\n        int a = -1;\n        switch (s) {\n            case CONST -> {\n                a = 2;\n                break;\n            }\n            case String s1 -> {\n                a = 0;\n                break; \n            }\n        }\n        return a;\n    }\n}"}, "2");
    }

    public void testBug578241_1() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static void foo(Object obj, int x) {\n    \tswitch (obj) {\n    \t\tcase String s when (switch (x) {\n\t\t\t\t\tcase 1 -> { yield true; }\n\t\t\t\t\tdefault -> { yield false; }\n   \t \t\t\t\t\t\t\t\t\t})\t\n   \t \t\t \t\t\t-> {\n   \t \t\t \t\t\t\tSystem.out.println(\"true\");\n   \t \t\t \t\t\t}\n\t\t\t\t\t\n   \t \t\t default -> {\n   \t \t\t\tSystem.out.println(\"false\");\n   \t \t\t }\n    \t}\t\n    }\n    public static void main(String[] args) {\n\t\tfoo(\"abc\", 1);\n\t}\n}"}, "true");
    }

    private String getTestCaseForBug578504(String caseConstant) {
        return "public class X {\n    public Object literal = \"a\";\n\tpublic boolean foo() {\n        String s = switch(literal) {\n            " + caseConstant + "                yield \"a\";\n            }\n            default -> { \n                yield \"b\";\n            }\n        }; \n        return s.equals(\"a\");\n    }\n    public static void main(String[] argv) {\n    \tX c = new X();\n    \tSystem.out.println(c.foo());\n    }\n}";
    }

    public void testBug578504_1() {
        this.runConformTest(new String[]{"X.java", this.getTestCaseForBug578504("case String a when (a.equals(\"a\") && a != null)  -> { \n")}, "true");
    }

    public void testBug578504_2() {
        this.runConformTest(new String[]{"X.java", this.getTestCaseForBug578504("case CharSequence a when (a instanceof String ss && (ss == null && ss != null))  -> {\n")}, "false");
    }

    public void testBug578504_3() {
        this.runConformTest(new String[]{"X.java", this.getTestCaseForBug578504("case CharSequence a when (a instanceof String ss && ss != null) && ss != null  -> {\n")}, "true");
    }

    public void testBug578504_6() {
        this.runConformTest(new String[]{"X.java", this.getTestCaseForBug578504("case CharSequence a when (a instanceof String ss && a instanceof String sss) && ss == sss  -> {\n")}, "true");
    }

    public void testBug578504_7() {
        this.runConformTest(new String[]{"X.java", this.getTestCaseForBug578504("case CharSequence a when (a instanceof String ss && a instanceof String sss) && ss != sss  -> {\n")}, "false");
    }

    public void testBug578553_1() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tstatic Long foo(Number n) {\n\t\treturn switch (n) {\n\t     case (Long l) when l.toString().equals(\"0\") -> {\n\t    \t yield ++l;\n\t     }\n\t\tdefault -> throw new IllegalArgumentException();\n\t   };\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(foo(0L));\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\tcase (Long l) when l.toString().equals(\"0\") -> {\n\t           ^\nSyntax error on token \"l\", delete this token\n----------\n2. ERROR in X.java (at line 4)\n\tcase (Long l) when l.toString().equals(\"0\") -> {\n\t              ^^^^\nSyntax error, insert \":: IdentifierOrNew\" to complete ReferenceExpression\n----------\n3. ERROR in X.java (at line 4)\n\tcase (Long l) when l.toString().equals(\"0\") -> {\n\t              ^^^^\nSyntax error, insert \":\" to complete SwitchLabel\n----------\n4. ERROR in X.java (at line 4)\n\tcase (Long l) when l.toString().equals(\"0\") -> {\n\t                                            ^^\nSyntax error on token \"->\", ; expected\n----------\n");
    }

    public void testBug578553_2() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tstatic Long foo(Number n) {  \n\t\treturn switch (n) { \n\t     case (Long l) when l.toString().equals(\"0\") -> {\n\t    \t yield switch(l) {\n\t    \t case Long l1 when l1.toString().equals(l1.toString()) -> {\n\t    \t \tyield ++l + ++l1;\n\t    \t }\n\t\t\tdefault -> throw new IllegalArgumentException(\"Unexpected value: \" + l);\n\t    \t };\n\t     }\n\t\tdefault -> throw new IllegalArgumentException();\n\t   };\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(foo(0L));\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\tcase (Long l) when l.toString().equals(\"0\") -> {\n\t           ^\nSyntax error on token \"l\", delete this token\n----------\n2. ERROR in X.java (at line 4)\n\tcase (Long l) when l.toString().equals(\"0\") -> {\n\t              ^^^^\nSyntax error, insert \":: IdentifierOrNew\" to complete ReferenceExpression\n----------\n3. ERROR in X.java (at line 4)\n\tcase (Long l) when l.toString().equals(\"0\") -> {\n\t              ^^^^\nSyntax error, insert \":\" to complete SwitchLabel\n----------\n4. ERROR in X.java (at line 4)\n\tcase (Long l) when l.toString().equals(\"0\") -> {\n\t                                            ^^\nSyntax error on token \"->\", ; expected\n----------\n5. ERROR in X.java (at line 6)\n\tcase Long l1 when l1.toString().equals(l1.toString()) -> {\n\t             ^^^^\nSyntax error on token \"when\", -> expected\n----------\n6. ERROR in X.java (at line 6)\n\tcase Long l1 when l1.toString().equals(l1.toString()) -> {\n\t                  ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nSyntax error on tokens, TypeElidedUnnamedFormalParameter expected instead\n----------\n7. ERROR in X.java (at line 8)\n\t}\n\t^\nSyntax error, insert \";\" to complete SwitchRule\n----------\n");
    }

    public void testBug578553_3() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tstatic Long foo(Number n) {  \n\t\treturn switch (n) { \n\t     case (Long l) when l.toString().equals(\"0\") -> {\n\t    \t yield switch(l) {\n\t    \t case Long l1 when l.toString().equals(l1.toString()) -> {\n\t    \t \tyield ++l + ++l1;\n\t    \t }\n\t\t\tdefault -> throw new IllegalArgumentException(\"Unexpected value: \" + l);\n\t    \t };\n\t     }\n\t\tdefault -> throw new IllegalArgumentException();\n\t   };\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\tcase (Long l) when l.toString().equals(\"0\") -> {\n\t           ^\nSyntax error on token \"l\", delete this token\n----------\n2. ERROR in X.java (at line 4)\n\tcase (Long l) when l.toString().equals(\"0\") -> {\n\t              ^^^^\nSyntax error, insert \":: IdentifierOrNew\" to complete ReferenceExpression\n----------\n3. ERROR in X.java (at line 4)\n\tcase (Long l) when l.toString().equals(\"0\") -> {\n\t              ^^^^\nSyntax error, insert \":\" to complete SwitchLabel\n----------\n4. ERROR in X.java (at line 4)\n\tcase (Long l) when l.toString().equals(\"0\") -> {\n\t                                            ^^\nSyntax error on token \"->\", ; expected\n----------\n5. ERROR in X.java (at line 6)\n\tcase Long l1 when l.toString().equals(l1.toString()) -> {\n\t             ^^^^\nSyntax error on token \"when\", -> expected\n----------\n6. ERROR in X.java (at line 6)\n\tcase Long l1 when l.toString().equals(l1.toString()) -> {\n\t                  ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nSyntax error on tokens, TypeElidedUnnamedFormalParameter expected instead\n----------\n7. ERROR in X.java (at line 8)\n\t}\n\t^\nSyntax error, insert \";\" to complete SwitchRule\n----------\n");
    }

    public void testBug578553_4() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tstatic Long foo(Number n) {  \n\tint i = 0;\n\treturn switch(n) {\n\t  case Long l when (1 == switch(l) {\n\t\t//case \n\t\t\tdefault -> {  \n\t\t\t\tyield (i++);\n\t\t\t} \n\t\t}) -> 1L; \n\t  default -> throw new IllegalArgumentException(\"Unexpected value: \" + n);\n\t  };\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 8)\n\tyield (i++);\n\t       ^\nLocal variable i referenced from a guard must be final or effectively final\n----------\n");
    }

    public void testBug578553_5() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tstatic Long foo(Number n) {  \n\tint i = 0;\n\treturn switch(n) {\n\t  case Long l when (1 == switch(l) {\n\t\t//case \n\t\t\tdefault -> {  \n\t\t\t\tyield ++i;\n\t\t\t} \n\t\t}) -> 1L; \n\t  default -> throw new IllegalArgumentException(\"Unexpected value: \" + n);\n\t  };\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 8)\n\tyield ++i;\n\t        ^\nLocal variable i referenced from a guard must be final or effectively final\n----------\n");
    }

    public void testBug578553_6() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tstatic Long foo(Number n) {  \n\tint i = 0;\n\treturn switch(n) {\n\t  case Long l when (1 == switch(l) {\n\t\t//case \n\t\t\tdefault -> {  \n\t\t\t\tyield (i=i+1);\n\t\t\t} \n\t\t}) -> 1L; \n\t  default -> throw new IllegalArgumentException(\"Unexpected value: \" + n);\n\t  };\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 8)\n\tyield (i=i+1);\n\t       ^\nLocal variable i referenced from a guard must be final or effectively final\n----------\n");
    }

    public void testBug578553_7() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n static int bar() { return 1; }\n\tstatic Long foo(Number n) {  \n\tint i = 0;\n\treturn switch(n) {\n\t  case Long l when (1 == switch(l) {\n\t\t//case \n\t\t\tdefault -> {  \n\t\t\t\tyield (i = bar());\n\t\t\t} \n\t\t}) -> 1L; \n\t  default -> throw new IllegalArgumentException(\"Unexpected value: \" + n);\n\t  };\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 9)\n\tyield (i = bar());\n\t       ^\nLocal variable i referenced from a guard must be final or effectively final\n----------\n");
    }

    public void testBug578568_1() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static int foo(Number arg0) {\n        int result = 0;\n        result = \n         switch (arg0) {\n            case Object p -> {\n                switch (arg0) {\n                     case Number p1 -> {\n                        yield 1;\n                    }\n                }\n            }\n        }; \n        return result;\n    }\n public static void main(String[] args) {\n    \tSystem.out.println(foo(0L));\n\t}}"}, "1");
    }

    public void testBug578568_2() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static int foo(Number arg0) {\n        return switch (arg0) {\n            case Object p : {\n                switch (arg0) {\n                     case Number p1 : {\n                        yield 1;\n                    }\n                }\n            }\n        }; \n    }\n public static void main(String[] args) {\n    \tSystem.out.println(foo(0L));\n\t}}"}, "1");
    }

    public void testBug578568_3() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static int foo(Object arg0) {\n        return switch (arg0) {\n            case Object p : {\n                switch (arg0) {\n                    case Number p1 : {\n                        yield 1;\n                    }\n                    default: {\n                    }                }\n            }\n        }; \n }\n}"}, "----------\n1. ERROR in X.java (at line 11)\n\t}\n\t^^\nA switch labeled block in a switch expression must yield a value or throw an an exception\n----------\n");
    }

    public void testBug578416() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static int testMethod(I i) {\n       return switch (i) {\n            case I p1 when (p1 instanceof C p2) : {\n                yield p2.value(); // Error here\n            }\n            case I p3 : {\n                yield p3.value(); // No error here\n            }\n        };\n    }\n    interface I {\n        public int value();\n    }\n    class C implements I {\n    \t@Override\n    \tpublic int value() {\n    \t\treturn 0;\n    \t}\n    }\n    public static void main(String[] args) {\n    \tI i = new I() {\n    \t\tpublic int value() {\n    \t\t\treturn 10;\n    \t\t} \n    \t}; \n    \tSystem.out.println(testMethod(i));\n    \tSystem.out.println(testMethod(new X().new C()));\n\t}}\n"}, "10\n0");
    }

    public void testBug578416_1() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static int testMethod(I i) {\n       return switch (i) {\n            case I p1 when (p1 instanceof C p2) : {\n                yield p2.value();\n            }\n            case I p3 : {\n                yield p3.value();\n            }\n        };\n    }\n    interface I {\n        public int value();\n    }\n    class C implements I {\n    \t@Override\n    \tpublic int value() {\n    \t\treturn 0;\n    \t}\n    }\n    public static void main(String[] args) {\n    \tI i = new I() {\n    \t\tpublic int value() {\n    \t\t\treturn 10;\n    \t\t} \n    \t}; \n    \tSystem.out.println(testMethod(i));\n    \tSystem.out.println(testMethod(new X().new C()));\n\t}}\n"}, "10\n0");
    }

    public void testBug578416_2() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static int foo(Object o) {\n       return switch (o) {\n            case Number n when (n instanceof Integer i) : {\n                yield n.intValue() + i; // Error here\n            }\n            case Number n2 : {\n                yield n2.intValue();\n            }\n            default : {\n                yield -1;\n            }\n        };\n    }\n    public static void main(String[] args) {\n    \tSystem.out.println(foo(new Integer(10)));\n    \tSystem.out.println(foo(new Integer(5)));\n    \tSystem.out.println(foo(new Long(5L)));\n    \tSystem.out.println(foo(new Float(0)));\n\t}}\n"}, "20\n10\n5\n0");
    }

    public void testBug578416_3() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static int foo(Object o) {\n       return switch (o) {\n            case Number n when (n instanceof Integer i && i.equals(10)) : {\n                yield n.intValue() + i; // Error here\n            }\n            case Number n2 : {\n                yield n2.intValue();\n            }\n            default : {\n                yield -1;\n            }\n        };\n    }\n    public static void main(String[] args) {\n    \tSystem.out.println(foo(new Integer(10)));\n    \tSystem.out.println(foo(new Integer(5)));\n    \tSystem.out.println(foo(new Long(5L)));\n    \tSystem.out.println(foo(new Float(0)));\n\t}}\n"}, "20\n5\n5\n0");
    }

    public void testBug578635_1() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static boolean foo(Integer n) {\n    \treturn switch (n) {\n\t    \tcase Integer x when x.equals(10) -> {\n\t    \t\tyield true;\n\t    \t}\n\t    \tcase Comparable y -> {\n\t    \t\tyield false;\n\t    \t}\n    \t};\n    }\n    public static void main(String[] argv) {\n    \tSystem.out.println(foo(Integer.valueOf(0)));\n    \tSystem.out.println(foo(Integer.valueOf(10)));\n    }\n}"}, "false\ntrue");
    }

    public void testBug578635_2() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n   @SuppressWarnings({ \"rawtypes\" })\n\tpublic static boolean foo(Integer n) {\n    \treturn switch (n) {\n\t    \tcase Integer x when x.equals(10) -> {\n\t    \t\tyield true;\n\t    \t}\n\t    \tcase Comparable y -> {\n\t    \t\tyield false;\n\t    \t}\n\t    \tdefault -> {\n\t    \t\tyield false;\n\t    \t}\n    \t};\n    }\n    public static void main(String[] argv) {\n    \tSystem.out.println(foo(Integer.valueOf(0)));\n    \tSystem.out.println(foo(Integer.valueOf(10)));\n    }\n}"}, "----------\n1. ERROR in X.java (at line 11)\n\tdefault -> {\n\t^^^^^^^\nSwitch case cannot have both unconditional pattern and default label\n----------\n");
    }

    public void testBug578635_3() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n   @SuppressWarnings({ \"rawtypes\" })\n\tpublic static boolean foo(Integer n) {\n    \treturn switch (n) {\n\t    \tcase Integer x when x.equals(10) -> {\n\t    \t\tyield true;\n\t    \t}\n\t    \tcase Comparable y -> {\n\t    \t\tyield false;\n\t    \t}\n\t    \tdefault -> {\n\t    \t\tyield false;\n\t    \t}\n    \t};\n    }\n    public static void main(String[] argv) {\n    \tSystem.out.println(foo(Integer.valueOf(0)));\n    \tSystem.out.println(foo(Integer.valueOf(10)));\n    }\n}"}, "----------\n1. ERROR in X.java (at line 11)\n\tdefault -> {\n\t^^^^^^^\nSwitch case cannot have both unconditional pattern and default label\n----------\n");
    }

    public void testBug578417_1() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    static final String CONSTANT = \"abc\";\n    static String CON2 = \"abc\";\n    public static int foo() {\n        int res = 0;\n        switch (CON2) {\n            case CONSTANT -> {\n                res = 1;\n                break;\n            }\n            case String s -> {\n                res = 2;\n                break;\n            }\n        }\n        return res;\n    }\n    public static void main(String argv[]) {\n    \tSystem.out.println(foo()); \n    }\n}"}, "1");
    }

    public void testBug578132_001() {
        this.runConformTest(new String[]{"X.java", "public class X {\n static  int foo(Object o, boolean b) {\n   return switch (o) { \n      case X x when b -> 0; // compilation error\n      default -> 1;\n   }; \n } \n public static void main(String[] args) {\n   System.out.println(X.foo(new X(), true));\n   System.out.println(X.foo(new Object(), true));\n }\n}"}, "0\n1");
    }

    public void test576788_1() {
        this.runConformTest(new String[]{"X.java", "public class X {\n     public static void foo1(Object o) {\n    \tboolean b = switch (o) {\n    \t\tcase String s -> {\n    \t\t\tyield s == null;\n    \t\t}\n    \t\tcase null -> {\n    \t\t\tyield true;\n    \t\t}\n    \t\tdefault -> true;\n    \t};\n    \tSystem.out.println(b);\n    } \n    public static void main(String[] argv) {\n    \tfoo1(null);\n    \tfoo1(\"abc\");\n    }\n}"}, "true\nfalse");
    }

    public void testBug577374_001() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    sealed interface A {}\n    sealed interface B1 extends A {}\n    sealed interface B2 extends A {}\n    sealed interface C extends A {}\n    final class D1 implements B1, C {}\n    final class D2 implements B2, C {}\n    \n    public static int test(A arg) {\n        return switch (arg) {\n            case B1 b1 -> 1;\n            case B2 b2 -> 2;\n        };\n    }\n    public static void main(String[] args) {\n   X.D1 d1 = new X().new D1();\n   System.out.println(X.test(d1));\n }\n}"}, "1");
    }

    public void testBug579355_001() {
        this.runConformTest(new String[]{"X.java", "public class X {\n       static void constantLabelMustAppearBeforePattern(Integer o) {\n               switch (o) {\n               case -1, 1 -> System.out.println(\"special case:\" + o);\n               case Integer i when i > 0 -> System.out.println(\"positive integer: \" + o);\n               case Integer i -> System.out.println(\"other integer: \" + o);\n               }\n       }\n\n       public static void main(String[] args) {\n               X.constantLabelMustAppearBeforePattern(-10);\n               X.constantLabelMustAppearBeforePattern(-1);\n               X.constantLabelMustAppearBeforePattern(0);\n               X.constantLabelMustAppearBeforePattern(1);\n               X.constantLabelMustAppearBeforePattern(10);\n       } \n}"}, "other integer: -10\nspecial case:-1\nother integer: 0\nspecial case:1\npositive integer: 10");
    }

    public void testBug579355_002() {
        this.runConformTest(new String[]{"X.java", "public class X {\n       static void constantLabelMustAppearBeforePattern(Integer o) {\n               switch (o) {\n               case -1, 1 -> System.out.println(\"special case:\" + o);\n               case null -> System.out.println(\"null\");\n               case Integer i when i > 0 -> System.out.println(\"positive integer: \" + o);\n               case Integer i -> System.out.println(\"other integer: \" + o);\n               }\n       }\n\n       public static void main(String[] args) {\n               X.constantLabelMustAppearBeforePattern(-10);\n               X.constantLabelMustAppearBeforePattern(-1);\n               X.constantLabelMustAppearBeforePattern(0);\n               X.constantLabelMustAppearBeforePattern(1);\n               X.constantLabelMustAppearBeforePattern(10);\n               X.constantLabelMustAppearBeforePattern(null);\n       } \n}"}, "other integer: -10\nspecial case:-1\nother integer: 0\nspecial case:1\npositive integer: 10\nnull");
    }

    public void testBug579355_004() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static Color color = Color.BLUE;\n    public static void main(String args[]) {\n        Color c; \n        var result = switch(color){\n                case BLUE ->  (c = color) == Color.BLUE;\n                case RED, GREEN ->  (c = color) + \"text\";\n                case YELLOW ->  new String((c = color) + \"text\");\n                default ->  (c = color);\n                };\n        if (result != null && c == Color.BLUE) {\n        \tSystem.out.println(\"Pass\");\n        } else {\n        \tSystem.out.println(\"Fail\");\n        }\n    } \n}\nenum Color{BLUE, RED, GREEN, YELLOW;}"}, "Pass");
    }

    public void testBug579355_005() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public int foo(Character c) {\n        int result = 0;\n        result = switch (c) {\n            case Character c1 -> 1;\n            case (short)1 -> 5;\n        };\n        return result;\n    }\n    public static void main(String args[]) {\n    \tX x = new X();\n    \tif (x.foo('\\u0001') == 1) {\n            System.out.println(\"Pass\");\n        } else {\n        \tSystem.out.println(\"Fail\");\n        }\n    }\n}"}, "Pass");
    }

    public void testIssue449_001() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args) {\n    Object obj = null;\n    var a = switch (obj) {\n        case null -> 1;\n        default   -> 2;\n    };\n    System.out.println(a);\n  }\n}"}, "1");
    }

    public void testIssue554_001() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args) {\n    String obj = null;\n    var a = switch (obj) {\n        case null -> 1;\n        default   -> 2;\n    };\n    System.out.println(a);\n  }\n}"}, "1");
    }

    public void testIssue_556_001() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n     public static void foo1(String o) {\n    \tboolean b = switch (o) {\n    \t\tcase \"abc\", null -> {\n    \t\t\tyield false;\n    \t\t}\n    \t\tdefault -> true;\n    \t};\n    \tSystem.out.println(b);\n    } \n    public static void main(String[] argv) {\n    \tfoo1(null);\n    \tfoo1(\"abc\");\n    }\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\tcase \"abc\", null -> {\n\t            ^^^^\nA null case label has to be either the only expression in a case label or the first expression followed only by a default\n----------\n");
    }

    public void testIssue_556_002() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n public static void main(String[] args) {\n   foo(\"Hello World!\");\n }\n\n private static void foo(Object o) {\n   switch (o) {\n    case default:\n     System.out.println(\"Object: \" + o);\n   }\n }\n}"}, "----------\n1. ERROR in X.java (at line 8)\n\tcase default:\n\t     ^^^^^^^\nA 'default' can occur after 'case' only as a second case label expression and that too only if 'null' precedes  in 'case null, default' \n----------\n");
    }

    public void testIssue_556_003() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n public static void main(String[] args) {\n   foo(Integer.valueOf(11));\n   foo(Integer.valueOf(9));\n   foo(\"Hello World!\");\n }\n\n private static void foo(Object o) {\n   switch (o) {\n   case Integer i when i>10:\n     System.out.println(\"Greater than 10:\" + o);\n     break;\n   case Integer j when j>0:\n     System.out.println(\"Greater than 0:\" + o);\n     break;\n   case default:\n     System.out.println(\"Give Me Some SunShine:\" + o);\n   }\n }\n}"}, "----------\n1. ERROR in X.java (at line 16)\n\tcase default:\n\t     ^^^^^^^\nA 'default' can occur after 'case' only as a second case label expression and that too only if 'null' precedes  in 'case null, default' \n----------\n");
    }

    public void testIssue_556_004() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n public static void main(String[] args) {\n   foo(\"Hello World!\");\n }\n\n private static void foo(Object o) {\n   switch (o) {\n   case Integer i :\n     System.out.println(\"Integer:\" + o);\n     break;\n   case default:\n     System.out.println(\"Object\" + o);\n   case default:\n     System.out.println(\"Give me Some Sunshine\" + o);\n   }\n }\n}"}, "----------\n1. ERROR in X.java (at line 11)\n\tcase default:\n\t     ^^^^^^^\nA 'default' can occur after 'case' only as a second case label expression and that too only if 'null' precedes  in 'case null, default' \n----------\n2. ERROR in X.java (at line 13)\n\tcase default:\n\t^^^^^^^^^^^^\nThe default case is already defined\n----------\n3. ERROR in X.java (at line 13)\n\tcase default:\n\t     ^^^^^^^\nA 'default' can occur after 'case' only as a second case label expression and that too only if 'null' precedes  in 'case null, default' \n----------\n");
    }

    public void testIssue_556_005() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n private static void foo(Object o) {\n   switch (o.hashCode()) {\n     case default : System.out.println(\"Default\");\n     default : System.out.println(\"Object\");\n   }\n }\n public static void main(String[] args) {\n   foo(\"Hello World\");\n   Zork();\n }\n}\nclass Y {}"}, "----------\n1. ERROR in X.java (at line 4)\n\tcase default : System.out.println(\"Default\");\n\t     ^^^^^^^\nA 'default' can occur after 'case' only as a second case label expression and that too only if 'null' precedes  in 'case null, default' \n----------\n2. ERROR in X.java (at line 5)\n\tdefault : System.out.println(\"Object\");\n\t^^^^^^^\nThe default case is already defined\n----------\n3. ERROR in X.java (at line 10)\n\tZork();\n\t^^^^\nThe method Zork() is undefined for the type X\n----------\n");
    }

    public void testIssue_556_006() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n public static int foo(Integer o) {\n   int k = 0;\n   switch (o) {\n     case 0, default   : k = 1;\n   }\n   return k;\n } \n public static void main(String[] args) {\n   System.out.println(foo(100 ));\n }\n}"}, "----------\n1. ERROR in X.java (at line 5)\n\tcase 0, default   : k = 1;\n\t        ^^^^^^^\nA 'default' can occur after 'case' only as a second case label expression and that too only if 'null' precedes  in 'case null, default' \n----------\n");
    }

    public void testIssue_556_007() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n public static int foo(Integer o) {\n   int k = 0;\n   switch (o) {\n     case 0, default, 1   : k = 1;\n   }\n   return k;\n } \n public static void main(String[] args) {\n   System.out.println(foo(100 ));\n }\n}"}, "----------\n1. ERROR in X.java (at line 5)\n\tcase 0, default, 1   : k = 1;\n\t        ^^^^^^^\nA 'default' can occur after 'case' only as a second case label expression and that too only if 'null' precedes  in 'case null, default' \n----------\n");
    }

    public void testIssue_556_008() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic void foo(Object o) {\n\t  try{\n\t\tswitch (o) {\n\t\t  default:\n\t\t\t  break;\n\t\t  case String s :\n\t\t\t  System.out.println(10);\n\t\t\t  break;\n\t\t  case String s when (s.length() == 10):\n\t\t\t  System.out.println(s);\n\t\t} \n\t  } catch(Exception t) {\n\t\t t.printStackTrace(System.out);\n\t  }\n\t}\n\tpublic static void main(String[] args) {\n\t\t  (new X()).foo(null);\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 7)\n\tcase String s :\n\t     ^^^^^^^^\nThis case label is dominated by one of the preceding case labels\n----------\n2. ERROR in X.java (at line 10)\n\tcase String s when (s.length() == 10):\n\t     ^^^^^^^^\nThis case label is dominated by one of the preceding case labels\n----------\n");
    }

    public void testIssue_556_009() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic void foo(Object o) {\n\t  try{\n\t\tswitch (o) {\n\t\t  case null, default:\n\t\t\t  break;\n\t\t  case String s :\n\t\t\t  System.out.println(s);\n\t\t} \n\t  } catch(Exception t) {\n\t\t t.printStackTrace(System.out);\n\t  }\n\t}\n\tpublic static void main(String[] args) {\n\t\t  (new X()).foo(null);\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 7)\n\tcase String s :\n\t     ^^^^^^^^\nThis case label is dominated by one of the preceding case labels\n----------\n");
    }

    public void testIssue658() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String argv[]) {\n\t\t(new X()).foo(\"abc\");\n\t}\n\tpublic void foo(String s) {\n\t\tint v = 0;\n\t\tBoolean b1 = Boolean.valueOf(true);\n\t\tswitch (s) {\n\t\t\tcase String obj when b1 -> v = 1;\n\t\t\tdefault -> v = 0;\n\t\t}\n\t\tSystem.out.println(v);\n\t\tBoolean b2 = Boolean.valueOf(false);\n\t\tswitch (s) {\n\t\t\tcase String obj when b2 -> v = 1;\n\t\t\tdefault -> v = 0;\n\t\t}\n\t\tSystem.out.println(v);\n\t}\n}"}, "1\n0");
    }

    public void testIssue711_1() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\npublic class X {\npublic static void foo(List<Number> l) {\n\tswitch (l) {\n\t    case ArrayList<Number> al -> \n\t        System.out.println(\"An ArrayList of Number\");\n\t    case ArrayList<? extends Number> aln -> // Error - dominated case label\n\t        System.out.println(\"An ArrayList of Number\");\n\t    default -> \n\t        System.out.println(\"A List\");\n\t}\n}\n}"}, "----------\n1. ERROR in X.java (at line 7)\n\tcase ArrayList<? extends Number> aln -> // Error - dominated case label\n\t     ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nThis case label is dominated by one of the preceding case labels\n----------\n");
    }

    public void testIssue711_2() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\npublic class X {\npublic static void foo(List<Number> l) {\n\tswitch (l) {\n\t    case ArrayList<? extends Number> aln ->\n\t        System.out.println(\"An ArrayList of Number\");\n\t    case ArrayList<Number> al ->  // Error - dominated case label\n\t        System.out.println(\"An ArrayList of Number\");\n\t    default -> \n\t        System.out.println(\"A List\");\n\t}\n}\n}"}, "----------\n1. ERROR in X.java (at line 7)\n\tcase ArrayList<Number> al ->  // Error - dominated case label\n\t     ^^^^^^^^^^^^^^^^^^^^\nThis case label is dominated by one of the preceding case labels\n----------\n");
    }

    public void testIssue742_1() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\npublic class X {\npublic static void foo(Integer n) {\n  switch (n) {\n    case Integer i when true -> // Allowed but why write this?\n        System.out.println(\"An integer\"); \n    case Integer i ->                     // Error - dominated case label\n        System.out.println(\"An integer\"); \n  }\n}\n}"}, "----------\n1. ERROR in X.java (at line 7)\n\tcase Integer i ->                     // Error - dominated case label\n\t     ^^^^^^^^^\nThis case label is dominated by one of the preceding case labels\n----------\n");
    }

    public void testIssue742_2() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\npublic class X {\npublic static void foo(Integer n) {\n  switch (n) {\n    case Integer i -> // Allowed but why write this?\n        System.out.println(\"An integer\"); \n    case Integer i when true ->                     // Error - dominated case label\n        System.out.println(\"An integer\"); \n  }\n}\n}"}, "----------\n1. ERROR in X.java (at line 7)\n\tcase Integer i when true ->                     // Error - dominated case label\n\t     ^^^^^^^^^\nThis case label is dominated by one of the preceding case labels\n----------\n");
    }

    public void testIssue712_001() {
        this.runConformTest(new String[]{"X.java", "public class X {\n       \n       public static void main(String[] args) {\n               Object o = \"Hello World\";\n               foo(o);\n       }\n       public static void foo(Object o) {\n         switch (o) {\n           case String s:\n               System.out.println(s);        // No break!\n           case R():\n               System.out.println(\"It's either an R or a string\"); // Allowed\n               break;\n           default:\n         }\n       }\n\n}\n\nrecord R() {} \nrecord S() {}\n"}, "Hello World\nIt's either an R or a string");
    }

    public void testIssue712_002() {
        this.runConformTest(new String[]{"X.java", "public class X {\n \n public static void main(String[] args) {\n   Object o = new R();\n   foo(o);\n }\n public static void foo(Object o) {\n   switch (o) {\n     case R():\n     case S():                         // Multiple case labels!\n         System.out.println(\"Either R or an S\");\n         break;\n     default:\n }\n }\n\n}\n\nrecord R() {}\nrecord S() {}\n"}, "Either R or an S");
    }

    public void testIssue712_003() {
        this.runConformTest(new String[]{"X.java", "public class X {\n \n public static void main(String[] args) {\n   Object o = null;\n   foo(o);\n }\n public static void foo(Object o) {\n   switch (o) {\n     case null:\n     case R():                         // Multiple case labels!\n         System.out.println(\"Either null or an R\");\n         break;\n     default:\n }\n }\n}\n\nrecord R() {}\nrecord S() {}"}, "Either null or an R");
    }

    public void testIssue712_004() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n \n public static void foo(Object o) {\n   switch (o) {\n     case Integer i :\n     case R():                         // Multiple case labels!\n         System.out.println(\"R Only\");\n     default:\n   }\n }\n}\n \nrecord R() {}"}, "----------\n1. ERROR in X.java (at line 5)\n\tcase Integer i :\n\t^^^^^^^^^^^^^^\nIllegal fall-through from a case label pattern\n----------\n");
    }

    public void testIssueDefaultDominance_001() {
        this.runNegativeTest(new String[]{"X.java", " public class X {\n \n public static void foo(Object o) {\n   switch (o) {\n   case Float f: System.out.println(\"integer\"); break;\n   default: System.out.println(\"default\"); break;\n   case Integer i: System.out.println(\"integer\"); break;\n   }      \n }\n}"}, "----------\n1. ERROR in X.java (at line 7)\n\tcase Integer i: System.out.println(\"integer\"); break;\n\t     ^^^^^^^^^\nThis case label is dominated by one of the preceding case labels\n----------\n");
    }

    public void testIssueDefaultDominance_002() {
        this.runNegativeTest(new String[]{"X.java", " public class X {\n \n public static void foo(Object o) {\n   switch (o) {\n   default: System.out.println(\"default\"); break;\n   case Integer i: System.out.println(\"integer\"); break;\n   }      \n }\n}"}, "----------\n1. ERROR in X.java (at line 6)\n\tcase Integer i: System.out.println(\"integer\"); break;\n\t     ^^^^^^^^^\nThis case label is dominated by one of the preceding case labels\n----------\n");
    }

    public void testIssueDefaultDominance_003() {
        this.runNegativeTest(new String[]{"X.java", " public class X {\n \n public static void foo(Object o) {\n   switch (o) {\n   default: System.out.println(\"default\"); break;\n   case null: System.out.println(\"null\"); break;\n   }      \n }\n}"}, "----------\n1. ERROR in X.java (at line 6)\n\tcase null: System.out.println(\"null\"); break;\n\t     ^^^^\nThis case label is dominated by one of the preceding case labels\n----------\n");
    }

    public void testIssueDefaultDominance_004() {
        this.runNegativeTest(new String[]{"X.java", " public class X {\n \n public static void foo(Object o) {\n   switch (o) {\n   case Float f: System.out.println(\"integer\"); break;\n   default: System.out.println(\"default\"); break;\n   case null: System.out.println(\"null\"); break;\n   }      \n }\n}"}, "----------\n1. ERROR in X.java (at line 7)\n\tcase null: System.out.println(\"null\"); break;\n\t     ^^^^\nThis case label is dominated by one of the preceding case labels\n----------\n");
    }

    public void testIssue919() {
        this.runNegativeTest(new String[]{"X.java", " public class X {\n   static void defaultCanAppearBeforePattern(Integer i) {\n\t  switch (i) {\n\t  case null -> System.out.println(\"value unavailable: \" + i);\n\t  case -1, 1 -> System.out.println(\"absolute value 1: \" + i);\n\t  default -> System.out.println(\"other integer: \" + i);\n\t  case Integer value when value > 0 -> System.out.println(\"positive integer: \" + i);\n\t  }\n  }\n  static void defaultCanAppearBeforeNull(Integer i) {\n\t  switch (i) {\n\t  case -1, 1 -> System.out.println(\"absolute value 1: \" + i);\n\t  default -> System.out.println(\"other integer: \" + i);\n\t  case null -> System.out.println(\"value unavailable: \" + i);\n\t  case Integer value when value > 0 -> System.out.println(\"positive integer: \" + i);\n\t  }\n  }\n  static void defaultCanAppearBeforeConstantLabel(Integer i) {\n\t  switch (i) {\n\t  case null -> System.out.println(\"value unavailable: \" + i);\n\t  default -> System.out.println(\"other integer: \" + i);\n\t  case -1, 1 -> System.out.println(\"absolute value 1: \" + i);\n\t  case Integer value when value > 0 -> System.out.println(\"positive integer: \" + i);\n\t  }\n  }\n}"}, "----------\n1. ERROR in X.java (at line 7)\n\tcase Integer value when value > 0 -> System.out.println(\"positive integer: \" + i);\n\t     ^^^^^^^^^^^^^\nThis case label is dominated by one of the preceding case labels\n----------\n2. ERROR in X.java (at line 14)\n\tcase null -> System.out.println(\"value unavailable: \" + i);\n\t     ^^^^\nThis case label is dominated by one of the preceding case labels\n----------\n3. ERROR in X.java (at line 15)\n\tcase Integer value when value > 0 -> System.out.println(\"positive integer: \" + i);\n\t     ^^^^^^^^^^^^^\nThis case label is dominated by one of the preceding case labels\n----------\n4. ERROR in X.java (at line 23)\n\tcase Integer value when value > 0 -> System.out.println(\"positive integer: \" + i);\n\t     ^^^^^^^^^^^^^\nThis case label is dominated by one of the preceding case labels\n----------\n");
    }

    public void testIssue1126a() {
        this.runConformTest(new String[]{"X.java", "public class X {\n \tstatic int foo(String i) {\n\t\treturn switch (i) {\n\t     case \"abc\" -> 0;\n\t     case \"abcd\" -> 1;\n\t     case String s -> -1;\n\t   };\n\t}\n public static void main(String[] args) {\n   System.out.println(foo(\"abcd\"));\n   System.out.println(foo(\"abc\"));\n }\n}"}, "1\n0");
    }

    public void testIssue1126b() {
        this.runConformTest(new String[]{"X.java", "public class X {\n \tstatic int foo(String i) {\n\t\treturn switch (i) {\n\t     case \"FB\" -> 0;\n\t     case \"Ea\" -> 1;\n\t     case String s -> -1;\n\t   };\n\t}\n public static void main(String[] args) {\n   System.out.println(foo(\"Ea\"));\n   System.out.println(foo(\"FB\"));\n }\n}"}, "1\n0");
    }

    public void testIssue587_001() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  sealed interface I<T> permits A, B {}\n  final static class A<T> implements I<String> {}\n  final static class B<Y> implements I<Y> {}\n\n  static int testGenericSealedExhaustive(I<Integer> i) {\n    return switch (i) {\n      // Exhaustive as no A case possible!\n      case B<Integer> bi -> 42;\n    };\n  }\n  public static void main(String[] args) {\n       System.out.println(testGenericSealedExhaustive(new B<Integer>()));\n  }\n}"}, "42");
    }

    public void testIssueExhaustiveness_001() {
        this.runConformTest(new String[]{"X.java", "public class X {\n public static void main(String argv[]) {\n   System.out.println(foo());\n }\n\n public static int foo() {\n   return switch (I.getIC()) {\n     case IC c -> 42;\n   };\n }\n}\n\nsealed interface I<T> permits IC {\n public static I getIC() {\n   return new IC(){};\n }\n}\n\nnon-sealed interface IC<T> extends I {}"}, "42");
    }

    public void testIssueExhaustiveness_002() {
        this.runConformTest(new String[]{"X.java", "record R(int i) {}\npublic class X {\n\n    public static int foo(R exp) {\n        return switch (exp) {\n            case R r -> 42;\n        };\n    }\n    public static void main(String argv[]) {\n       System.out.println(foo(new R(10)));\n    }\n}"}, "42");
    }

    public void testIssueExhaustiveness_003() {
        this.runConformTest(new String[]{"X.java", "record R(X x) {}\npublic class X {\n\n    public static int foo(R exp) {\n        return switch (exp) {\n            case R(Object o) -> 42;\n        };\n    }\n    public static void main(String argv[]) {\n       System.out.println(foo(new R(new X())));\n    }\n}"}, "42");
    }

    public void testIssueExhaustiveness_004() {
        this.runNegativeTest(new String[]{"X.java", "sealed interface I permits A, J {}\nsealed interface J extends I {}\n\nfinal class A implements I {}\nfinal record R() implements J {}\n\npublic class X {\n\n    public static int foo(I i) {\n        return switch (i) {\n            case A a -> 0;\n        };\n    }\n\n    public static void main(String argv[]) {\n       Zork();\n    }\n}"}, "----------\n1. ERROR in X.java (at line 10)\n\treturn switch (i) {\n\t               ^\nA switch expression should have a default case\n----------\n2. ERROR in X.java (at line 16)\n\tZork();\n\t^^^^\nThe method Zork() is undefined for the type X\n----------\n");
    }

    public void testIssueExhaustiveness_005() {
        this.runConformTest(new String[]{"X.java", "sealed interface I {}\nfinal class A implements I {}\n\nrecord R<T extends I>(T x, T  y) {}\n\npublic class X {\n    public static int foo(R r) {\n       return  switch (r) {\n            case R(A a1, A a2) -> 0;\n        };\n    }\n\n    @SuppressWarnings(\"unchecked\")\n       public static void main(String argv[]) {\n       System.out.println(X.foo(new R(new A(), new A())));\n    }\n}"}, "0");
    }

    public void testIssue1250_1() {
        if (this.complianceLevel < 0x410000L) {
            return;
        }
        this.runConformTest(new String[]{"X.java", "enum E {\n\tA1, A2;\n}\npublic class X {\n\tpublic static void foo(E e) {\n\t\tswitch (e) {\n\t\t\tcase E.A1 -> {\n\t\t\t\tSystem.out.println(\"A1\");\n\t\t\t}\n\t\t\tcase E.A2 -> {\n\t\t\t\tSystem.out.println(\"A2\");\n\t\t\t}\n\t\t}\n\t}\n\tpublic static void main(String[] args) {\n\t\tfoo(E.A1);\n\t}\n}"}, "A1");
    }

    public void testIssue1250_2() {
        if (this.complianceLevel < 0x410000L) {
            return;
        }
        this.runConformTest(new String[]{"X.java", "enum E {\n\tA1, A2;\n\tenum InnerE {\n\t\tB1, B2;\n\t}\n}\npublic class X {\n\tpublic static void foo(E.InnerE e) {\n\t\tswitch (e) {\n\t\t\tcase E.InnerE.B1 -> {\n\t\t\t\tSystem.out.println(\"B1\"); //$NON-NLS-1$\n\t\t\t} \n\t\t\tdefault -> {}\n\t\t}\n\t}\n\tpublic static void main(String[] args) { \n\t\tfoo(E.InnerE.B1);\n\t}\n}"}, "B1");
    }

    public void testIssue1250_3() {
        if (this.complianceLevel < 0x410000L) {
            return;
        }
        this.runNegativeTest(new String[]{"X.java", "enum E {\n\tA1, A2;\n\tenum InnerE {\n\t\tB1, B2;\n\t}\n}\npublic class X {\n\tpublic static void foo(E.InnerE e) {\n\t\tswitch (e) {\n\t\t\tcase E.A1 -> {\n\t\t\t\tSystem.out.println(\"B1\"); //$NON-NLS-1$\n\t\t\t} \n\t\t\tdefault -> {}\n\t\t}\n\t}\n\tpublic static void main(String[] args) { \n\t\tfoo(E.InnerE.B1);\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 10)\n\tcase E.A1 -> {\n\t     ^^^^\nCase constant of type E is incompatible with switch selector type E.InnerE\n----------\n");
    }

    public void testIssue1250_4() {
        if (this.complianceLevel < 0x410000L) {
            return;
        }
        this.runConformTest(new String[]{"X.java", "interface I {}\nenum E implements I {\n\tA0, A1, A2, A3, A4;\n}\npublic class X {\n\tpublic String testMethod(I exp) {\n\t\tString res = \"\";\n\t\tswitch (exp) {\n\t\t\tcase E.A0 -> {\n\t\t\t\tres = \"const A0\";\n\t\t\t\tbreak;\n\t\t\t}\n\t\t\tcase E.A1 -> {\n\t\t\t\tres = \"const A1\";\n\t\t\t\tbreak;\n\t\t\t}\n\t\t\tcase E.A2 -> {\n\t\t\t\tres = \"const A2\";\n\t\t\t\tbreak;\n\t\t\t}\n\t\t\tcase E.A3 -> {\n\t\t\t\tres = \"const A3\";\n\t\t\t\tbreak;\n\t\t\t}\n\t\t\tcase E.A4 -> {\n\t\t\t\tres = \"const A4\";\n\t\t\t\tbreak;\n\t\t\t}\n\t\t\tdefault -> {\n\t\t\t\tres = \"default\";\n\t\t\t}\n\t\t}\n\t\treturn res;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println((new X()).testMethod(E.A2));\n\t\tSystem.out.println((new X()).testMethod(E.A3));\n\t\tSystem.out.println((new X()).testMethod(E.A4));\n\t\tSystem.out.println((new X()).testMethod(E.A0));\n\t\tSystem.out.println((new X()).testMethod(E.A1));\n\t\tSystem.out.println((new X()).testMethod(new I() {\n\t\t}));\n\t}\n}"}, "const A2\nconst A3\nconst A4\nconst A0\nconst A1\ndefault");
    }

    public void testIssue1250_5() {
        if (this.complianceLevel < 0x410000L) {
            return;
        }
        this.runConformTest(new String[]{"X.java", "interface I {\n}\nenum E implements I {\n\tA0, A1, A2, A3, A4;\n}\nenum E1 implements I {\n\tB0, B1;\n}\npublic class X {\n\tpublic String foo(I exp) {\n\t\tString res = \"\";\n\t\tswitch (exp) {\n\t\t\tcase E.A0 -> {\n\t\t\t\tres = \"const A0\";\n\t\t\t\tbreak;\n\t\t\t}\n\t\t\tcase E.A1 -> {\n\t\t\t\tres = \"const A1\";\n\t\t\t\tbreak;\n\t\t\t}\n\t\t\tcase E1.B0 -> {\n\t\t\t\tres = \"const B0\";\n\t\t\t\tbreak;\n\t\t\t}\n\t\t\tcase E e -> {\n\t\t\t\tres = e.toString();\n\t\t\t}\n\t\t\tcase E1 e1 -> {\n\t\t\t\tres = e1.toString();\n\t\t\t}\n\t\t\tdefault -> {\n\t\t\t\tres = \"default\";\n\t\t\t}\n\t\t}\n\t\treturn res;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println((new X()).foo(E.A0));\n\t\tSystem.out.println((new X()).foo(E.A1));\n\t\tSystem.out.println((new X()).foo(E.A2));\n\t\tSystem.out.println((new X()).foo(E1.B0));\n\t\tSystem.out.println((new X()).foo(E1.B1));\n\t\tSystem.out.println((new X()).foo(new I() {\n\t\t}));\n\t}\n}"}, "const A0\nconst A1\nA2\nconst B0\nB1\ndefault");
    }

    public void testIssue1250_6() {
        if (this.complianceLevel < 0x410000L) {
            return;
        }
        this.runConformTest(new String[]{"X.java", "interface I {\n}\nenum XEnum {\n    A, B;\n    interface I {}\n    enum E implements I {\n        A0, A1;\n    }\n}\npublic class X {\n    public String foo(XEnum.I exp) {\n        String res = \"\";\n        switch (exp) {\n            case XEnum.E.A0 -> {\n                res = \"A0\";\n                break;\n            }\n            case XEnum.E.A1 -> {\n                res = \"A1\";\n                break;\n            }\n            default -> {\n                res = \"Ad\";\n            }\n        }\n        return res;\n    }\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println((new X()).foo(XEnum.E.A1));\n\t}\n}"}, "A1");
    }

    public void testIssue1250_7() {
        if (this.complianceLevel < 0x410000L) {
            return;
        }
        this.runConformTest(new String[]{"X.java", "interface I {\n    interface InnerI {}\n    enum E implements InnerI {\n        A0, A1;\n    }\n}\npublic class X {\n    public String foo(I.InnerI exp) {\n        String res = \"\";\n        res = switch (exp) {\n            case I.E.A0 -> {\n                yield \"A0\";\n            }\n            case I.E.A1 -> {\n                yield \"A1\";\n            }\n            default -> {\n                yield \"Ad\";\n            }\n        };\n        return res;\n    }\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println((new X()).foo(I.E.A1));\n\t}\n}"}, "A1");
    }

    public void testIssue1250_8() {
        if (this.complianceLevel < 0x410000L) {
            return;
        }
        this.runConformTest(new String[]{"p/q/X.java", "package p.q;\ninterface I {\n}\nenum E implements I {\n\tA0, A1, A2, A3, A4;\n}\nenum E1 implements I {\n\tB0, B1;\n}\npublic class X {\n\tpublic String foo(I exp) {\n\t\tString res = \"\";\n\t\tswitch (exp) {\n\t\t\tcase E.A0 -> {\n\t\t\t\tres = \"const A0\";\n\t\t\t\tbreak;\n\t\t\t}\n\t\t\tcase E.A1 -> {\n\t\t\t\tres = \"const A1\";\n\t\t\t\tbreak;\n\t\t\t}\n\t\t\tcase E1.B0 -> {\n\t\t\t\tres = \"const B0\";\n\t\t\t\tbreak;\n\t\t\t}\n\t\t\tcase E e -> {\n\t\t\t\tres = e.toString();\n\t\t\t}\n\t\t\tcase E1 e1 -> {\n\t\t\t\tres = e1.toString();\n\t\t\t}\n\t\t\tdefault -> {\n\t\t\t\tres = \"default\";\n\t\t\t}\n\t\t}\n\t\treturn res;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println((new X()).foo(E.A0));\n\t\tSystem.out.println((new X()).foo(E.A1));\n\t\tSystem.out.println((new X()).foo(E.A2));\n\t\tSystem.out.println((new X()).foo(E1.B0));\n\t\tSystem.out.println((new X()).foo(E1.B1));\n\t\tSystem.out.println((new X()).foo(new I() {\n\t\t}));\n\t}\n}"}, "const A0\nconst A1\nA2\nconst B0\nB1\ndefault");
    }

    public void testIssue1351_1() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void foo() {\n\t\tObject o = new String(\"\");\n\t\tint len = 2;\n\t\tswitch (o) {\n\t\tcase String o1 when ((String) o).length() == o1.length() :\n\t\t\to = null;\n\t\t\to1 = null;\n\t\t\tbreak;\n\t\tdefault:\n\t\t\tbreak;\n\t\t}\n\t}\n} "}, "----------\n1. ERROR in X.java (at line 7)\n\to = null;\n\t^\nLocal variable o is required to be final or effectively final based on its usage\n----------\n2. ERROR in X.java (at line 8)\n\to1 = null;\n\t^^\nLocal variable o1 is required to be final or effectively final based on its usage\n----------\n");
    }

    public void testIssue1351_2() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void foo() {\n\t\tObject o = new String(\"\");\n\t\tint len = 2;\n\t\tswitch (o) {\n\t\tcase String o1 when o1.length() == ((String) o).length():\n\t\t\to = null;\n\t\t\to1 = null;\n\t\t\tbreak;\n\t\tdefault:\n\t\t\tbreak;\n\t\t}\n\t}\n} "}, "----------\n1. ERROR in X.java (at line 7)\n\to = null;\n\t^\nLocal variable o is required to be final or effectively final based on its usage\n----------\n2. ERROR in X.java (at line 8)\n\to1 = null;\n\t^^\nLocal variable o1 is required to be final or effectively final based on its usage\n----------\n");
    }

    public void testIssue1351_3() {
        this.runNegativeTest(new String[]{"X.java", "class C {\n\tint v;\n\tpublic int value() { return this.v;\n}\n}\npublic class X {\n\tpublic void foo(C c) {\n\t\tswitch (c) {\n\t\tcase C c1 when c1.v == c1.value():\n\t\t\tc1 = null;\n\t\t\tbreak;\n\t\tdefault:\n\t\t\tbreak;\n\t\t}\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 10)\n\tc1 = null;\n\t^^\nLocal variable c1 is required to be final or effectively final based on its usage\n----------\n");
    }

    public void testIssue1351_3a() {
        this.runNegativeTest(new String[]{"X.java", "class C {\n\tint v;\n\tpublic int value() { return this.v;\n}\n}\npublic class X {\n\tpublic void foo(C c) {\n\t\tswitch (c) {\n\t\tcase C c1 when c1.value() == c1.v:\n\t\t\tc1 = null;\n\t\t\tbreak;\n\t\tdefault:\n\t\t\tbreak;\n\t\t}\n\t}\n} "}, "----------\n1. ERROR in X.java (at line 10)\n\tc1 = null;\n\t^^\nLocal variable c1 is required to be final or effectively final based on its usage\n----------\n");
    }

    public void testIssue1351_3b() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tint v = 0;\n\tpublic default int val() {\n\t\treturn v;\n\t}\n}\npublic class X {\n\tpublic void foo(I intf) {\n\t\tswitch (intf) {\n\t\tcase I i1 when i1.v > i1.val():\n\t\t\ti1 = null;\n\t\t\tbreak;\n\t\tdefault:\n\t\t\tbreak;\n\t\t}\n\t}\n} "}, "----------\n1. WARNING in X.java (at line 10)\n\tcase I i1 when i1.v > i1.val():\n\t                  ^\nThe static field I.v should be accessed in a static way\n----------\n2. ERROR in X.java (at line 11)\n\ti1 = null;\n\t^^\nLocal variable i1 is required to be final or effectively final based on its usage\n----------\n");
    }

    public void testIssue1351_3c() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tint v = 1;\n\tpublic default int val() {\n\t\treturn 0;\n\t}\n}\npublic class X {\n\tpublic void foo(I intf) {\n\t\tswitch (intf) {\n\t\tcase I i1 when I.v > i1.val():\n\t\t\ti1 = null;\n\t\t\tbreak;\n\t\tdefault:\n\t\t\tbreak;\n\t\t}\n\t}\n} "}, "----------\n1. ERROR in X.java (at line 11)\n\ti1 = null;\n\t^^\nLocal variable i1 is required to be final or effectively final based on its usage\n----------\n");
    }

    public void testIssue1351_4() {
        this.runNegativeTest(new String[]{"X.java", "class C {\n\tint v;\n\tpublic int value() { return this.v;\n}\n}\npublic class X {\n\tC c0;\n\tpublic void foo(C c) {\n\t\tswitch (c) {\n\t\tcase C c1 when c0.v == c0.value():\n\t\t\tc0 = null;\n\t\t\tbreak;\n\t\t}\n\t}\n} "}, "----------\n1. ERROR in X.java (at line 9)\n\tswitch (c) {\n\t        ^\nAn enhanced switch statement should be exhaustive; a default label expected\n----------\n");
    }

    public void testIssue1351_5() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void foo() {\n\t\tInteger in = 0;\n\t\tswitch (in) {\n\t\t    case Integer i ->\n\t\t        System.out.println(\"Boxed\");\n\t\t    case 95 ->\n\t\t        System.out.println(\"Literal!\");\n\t\t}\n\t}\n} "}, "----------\n1. ERROR in X.java (at line 7)\n\tcase 95 ->\n\t     ^^\nThis case label is dominated by one of the preceding case labels\n----------\n");
    }

    public void testIssue1351_6() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tstatic String foo(Color o) {\n\t\treturn switch (o) {\n\t     case Color s when true  -> s.toString();\n\t     case Red -> \"Red\";\n\t     case null -> \"\";\n\t   };\n\t}\n} \nenum Color {\n\tRed; \n}"}, "----------\n1. ERROR in X.java (at line 5)\n\tcase Red -> \"Red\";\n\t     ^^^\nThis case label is dominated by one of the preceding case labels\n----------\n");
    }

    public void testIssue1351_7() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic int foo(Byte exp) {\n\t\tint res = 0;\n\t\tswitch (exp) {\n\t\t\tcase Byte p when p.equals(exp), (byte) 0 -> {\n\t\t\t\tres = 6;\n\t\t\t\tbreak;\n\t\t\t}\n\t\t\tdefault -> {}\n\t\t}\n\t\treturn res;\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 5)\n\tcase Byte p when p.equals(exp), (byte) 0 -> {\n\t                                ^^^^^^^^\nCannot mix pattern with other case labels\n----------\n");
    }

    public void testIssue1351_8() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic int foo(Byte exp) {\n\t\tint res = 0;\n\t\tswitch (exp) {\n\t\t\tcase (byte) 0, Byte p when p.equals(exp) -> {\n\t\t\t\tres = 6;\n\t\t\t\tbreak;\n\t\t\t}\n\t\t\tdefault -> {}\n\t\t}\n\t\treturn res;\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 5)\n\tcase (byte) 0, Byte p when p.equals(exp) -> {\n\t               ^^^^^^^^^^^^^^^^^^^^^^^^^\nCannot mix pattern with other case labels\n----------\n");
    }

    public void testIssue1351_9() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic int foo(Byte exp) {\n\t\tint res = 0;\n\t\tswitch (exp) {\n\t\t\tcase (byte) 0, (byte) 10, Byte p when p.equals(exp) -> {\n\t\t\t\tres = 6;\n\t\t\t\tbreak;\n\t\t\t}\n\t\t\tdefault -> {}\n\t\t}\n\t\treturn res;\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 5)\n\tcase (byte) 0, (byte) 10, Byte p when p.equals(exp) -> {\n\t                          ^^^^^^^^^^^^^^^^^^^^^^^^^\nCannot mix pattern with other case labels\n----------\n");
    }

    public void testIssue1351_10() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic int foo(Byte exp) {\n\t\tint res = 0;\n\t\tswitch (exp) {\n\t\t\tcase Byte p when p.equals(exp), null -> {\n\t\t\t\tres = 6;\n\t\t\t\tbreak;\n\t\t\t}\n\t\t\tdefault -> {}\n\t\t}\n\t\treturn res;\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 5)\n\tcase Byte p when p.equals(exp), null -> {\n\t                                ^^^^\nCannot mix pattern with other case labels\n----------\n2. ERROR in X.java (at line 5)\n\tcase Byte p when p.equals(exp), null -> {\n\t                                ^^^^\nA null case label has to be either the only expression in a case label or the first expression followed only by a default\n----------\n");
    }

    public void testIssue1351_11() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic int foo(Byte exp) {\n\t\tint res = 0;\n\t\tswitch (exp) {\n\t\t\tcase Byte p when p.equals(exp), default -> {\n\t\t\t\tres = 6;\n\t\t\t\tbreak;\n\t\t\t}\n\t\t}\n\t\treturn res;\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 5)\n\tcase Byte p when p.equals(exp), default -> {\n\t                                ^^^^^^^\nCannot mix pattern with other case labels\n----------\n2. ERROR in X.java (at line 5)\n\tcase Byte p when p.equals(exp), default -> {\n\t                                ^^^^^^^\nA 'default' can occur after 'case' only as a second case label expression and that too only if 'null' precedes  in 'case null, default' \n----------\n");
    }

    public void testDisambiguatedRestrictedIdentifierWhenAsFirstMethodInvokation() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String argv[]) {\n\t\twhen(\"Pass\");\n\t}\n\tstatic void when(String arg) {\n\t\tSystem.out.println(arg);\n\t}\n}"}, "Pass");
    }

    public void testDisambiguatedRestrictedIdentifierWhenAsFirstVariableDeclaration() {
        this.runConformTest(new String[]{"when.java", "public class when {\n\tpublic static void main(String argv[]) {\n\t\twhen x = new when();\n\t\tSystem.out.println(x);\n\t}\n\tpublic String toString() {\n\t\treturn \"Pass\";\n\t}\n}"}, "Pass");
    }

    public void testDisambiguatedRestrictedIdentifierWhenAsTypeInACase() {
        this.runConformTest(new String[]{"when.java", "public class when {\n\tpublic String toString() {\n\t\treturn switch((Object) this) {\n\t\t\tcase when x -> \"Pass\";\n\t\t\tdefault -> \"Fail\";\n\t\t};\n\t}\n\tpublic static void main(String argv[]) {\n\t\tSystem.out.println(new when());\n\t}\n}"}, "Pass");
    }

    public void testDisambiguatedRestrictedIdentifierWhenAfterAParenthesis() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String argv[]) {\n\t\tSystem.out.println( (Boolean) when(true) );\n\t}\n\tstatic Object when(Object arg) {\n\t\treturn arg;\n\t}\n}"}, "true");
    }

    public void testValidCodeWithVeryAmbiguousUsageOfWhen() {
        this.runConformTest(new String[]{"when.java", "class when {\n  boolean when = true;\n  static boolean when(when arg) {\n    return switch(arg) {\n      case when when when when.when && when.when(null) -> when.when;\n      case null -> true;\n      default -> false;\n    };\n  }\n  public static void main(String[] args) {\n    System.out.println(when(new when()));\n  }\n}"}, "true");
    }

    public void testIssue1466_01() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\n\t  private static String foo(Integer i) {\n\t    return switch (i) {\n\t      case null -> \"null\";\n\t      case Integer value when value > 0 -> value.toString();\n\t      default -> i.toString();\n\t    };\n\t  }\n\n\t  public static void main(String[] args) {\n\t    System.out.println(foo(0));\n\t  }\n\t}\n\n"}, "0");
    }

    public void testIssue1466_02() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args) {\n    constantLabelMustAppearBeforePatternInteger(-1);\n    constantLabelMustAppearBeforePatternInteger(0);\n    constantLabelMustAppearBeforePatternInteger(42);\n    constantLabelMustAppearBeforePatternInteger(-99);\n    constantLabelMustAppearBeforePatternInteger(Integer.valueOf(123));\n    constantLabelMustAppearBeforePatternInteger(null);\n  }\n  static String constantLabelMustAppearBeforePatternInteger(Integer i) {\n    switch (i) {\n      case null -> System.out.println(\"value unavailable: \" + i);\n      case -1, 1 -> System.out.println(\"absolute value 1: \" + i);\n      case Integer value when value > 0 -> System.out.println(\"positive integer: \" + i);\n      default -> System.out.println(\"other integer: \" + i);\n    }\n    return i == null ? \"null\" : i.toString();\n  }\n}\n\n"}, "absolute value 1: -1\nother integer: 0\npositive integer: 42\nother integer: -99\npositive integer: 123\nvalue unavailable: null");
    }

    public void testIssue1767() {
        this.runConformTest(new String[]{"X.java", "public class X {\n   public static void main(String[] args) {\n\t   Integer o = null;\n\t   switch (o) {\n\t     case null:\n\t       System.out.println(\"NULL\");\n\t       break;\n\t     default : System.out.println(o);\n\t   }\n   }\n}\n"}, "NULL");
    }

    public void testIssue277() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  enum Color { RED, BLACK }\n\n  public static void main(String[] args) {\n    Color color = null;\n    switch (color) {\n      case null -> System.out.println(\"NULL\");\n      case RED -> System.out.println(\"RED\");\n      case BLACK -> System.out.println(\"BLACK\");\n    }\n  }\n}\n"}, "NULL");
    }

    public void testIssue277_original() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  enum Color { RED, BLACK }\n\n  public static void main(String[] args) {\n    Color color = Color.RED;\n    switch (color) {\n      case null -> throw null;\n      case RED -> System.out.println(\"RED\");\n      case BLACK -> System.out.println(\"BLACK\");\n    }\n  }\n}\n"}, "RED");
    }

    public void testIssue554() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    public static void main(String[] args) {\n        MyEnum val = null;\n        switch (val) {\n        case null:\n            System.out.println(\"val is null\");\n            break;\n        }\n    }\n}\nenum MyEnum {\n    a\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tswitch (val) {\n\t        ^^^\nAn enhanced switch statement should be exhaustive; a default label expected\n----------\n");
    }

    public void testGHI113() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\n\tinterface Shape {\n\t\tpublic double calculateArea();\n\t}\n\n\trecord Triangle(int base, int height) implements Shape {\n\n\t\t@Override\n\t\tpublic double calculateArea() {\n\t\t\treturn (0.5 * base * height);\n\t\t}\n\n\t}\n\n\trecord Square(int side) implements Shape {\n\n\t\t@Override\n\t\tpublic double calculateArea() {\n\t\t\treturn (side * side);\n\t\t}\n\n\t}\n\n\tstatic String evaluate(Shape s) {\n\t\treturn switch(s) {\n\t\t\tcase null ->\n\t\t\t\t\"NULL\";\n\t\t\tcase Triangle T when (T.calculateArea() > 100) ->\n\t\t\t    \"Large Triangle : \" + T.calculateArea();\n\t\t\tcase Triangle T ->\n\t\t\t    \"Small Triangle : \" + T.calculateArea();\n\t\t\tdefault ->\n\t\t\t    \"shape : \" + s.calculateArea();\n\t\t};\n\t}\n\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(evaluate(new Triangle(10, 10)));\n\t\tSystem.out.println(evaluate(new Triangle(20, 20)));\n\t\tSystem.out.println(evaluate(new Square(10)));\n\t\tSystem.out.println(evaluate(null));\n\t}\n}\n"}, "Small Triangle : 50.0\nLarge Triangle : 200.0\nshape : 100.0\nNULL");
    }

    public void testGH1853() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static void main(String[] args) {\n\t\tObject o = new Object();\n\t\tswitch (o) {\n\t\tcase String s :\n\t\t\tif (!(o instanceof String str))\n\t\t\t\tthrow new RuntimeException();\n\t\tcase null :\n\t\t\tif (!(o instanceof String str))\n\t\t\t\tthrow new RuntimeException();\n\t\tdefault:\n            System.out.println(\"Default\");\n\t\t}\n\t}\n}\n"}, "Default");
    }

    public void testGHI1856() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\n\tpublic class Data {\n\t    String name;\n\t}\n\n\trecord WrapperRec(ExhaustiveSwitch.Data data) {}\n\n\n\tpublic static void main(String[] args) {\n\t    switch (new Object()) {\n\t        case WrapperRec(var data) when data.name.isEmpty() -> { }\n\t        default -> {}\n\t    }\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\trecord WrapperRec(ExhaustiveSwitch.Data data) {}\n\t                  ^^^^^^^^^^^^^^^^\nExhaustiveSwitch cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 12)\n\tcase WrapperRec(var data) when data.name.isEmpty() -> { }\n\t                ^^^^^^^^\nData cannot be resolved to a type\n----------\n");
    }

    public void testGHI1856_2() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\n\tpublic class Data {\n\t    String name;\n\t}\n\n\trecord WrapperRec(ExhaustiveSwitch.Data data) {}\n\n\n\tpublic static void main(String[] args) {\n\t    switch (new Object()) {\n\t        case WrapperRec(ExhaustiveSwitch.Data data) when data.name.isEmpty() -> { }\n\t        default -> {}\n\t    }\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\trecord WrapperRec(ExhaustiveSwitch.Data data) {}\n\t                  ^^^^^^^^^^^^^^^^\nExhaustiveSwitch cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 12)\n\tcase WrapperRec(ExhaustiveSwitch.Data data) when data.name.isEmpty() -> { }\n\t                ^^^^^^^^^^^^^^^^\nExhaustiveSwitch cannot be resolved to a type\n----------\n");
    }

    public void testGH1955() {
        this.runNegativeTest(new String[]{"X.java", "sealed interface I<T> {}\nrecord R<T extends A<B>>(T t) implements I<T> {}\npublic class X {\n    @SuppressWarnings(\"rawtypes\")\n\tpublic static <T extends I> int foo(T t) {\n        return switch(t) {\n            case R(A<? extends B> p) -> 0;\n            case R(var varp) -> 1;\n        };\n    }\n}\nclass A<T> {}\nabstract class B {}\nclass C extends B {}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\tcase R(var varp) -> 1;\n\t     ^^^^^^^^^^^\nThis case label is dominated by one of the preceding case labels\n----------\n");
    }

    public void testIssue773() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tObject o = null;\n\t\tfoo(new R());\n\t\tfoo(new S());\n\t}\n\t@SuppressWarnings(\"preview\")\n\tpublic static void foo(Object o) {\n\t\tswitch (o) {\n\t\t    case R():                         // Multiple case labels!\n\t\t        System.out.println(\"R Only\");\n\t\t    case S():                         // Multiple case labels!\n\t\t        System.out.println(\"Either S or an R\");\n\t\t        break;\n\t\t    default:\n\t\t}\n\t}\n}\n\nrecord R() {}\nrecord S() {}\n"}, "R Only\nEither S or an R\nEither S or an R");
        String expectedOutput = "  // Method descriptor #22 (Ljava/lang/Object;)V\n  // Stack: 2, Locals: 2\n  public static void foo(java.lang.Object o);\n     0  aload_0 [o]\n     1  dup\n     2  invokestatic java.util.Objects.requireNonNull(java.lang.Object) : java.lang.Object [30]\n     5  pop\n     6  astore_1\n     7  aload_1\n     8  iconst_0\n     9  invokedynamic 0 typeSwitch(java.lang.Object, int) : int [36]\n    14  tableswitch default: 52\n          case 0: 36\n          case 1: 44\n    36  getstatic java.lang.System.out : java.io.PrintStream [40]\n    39  ldc <String \"R Only\"> [46]\n    41  invokevirtual java.io.PrintStream.println(java.lang.String) : void [48]\n    44  getstatic java.lang.System.out : java.io.PrintStream [40]\n    47  ldc <String \"Either S or an R\"> [54]\n    49  invokevirtual java.io.PrintStream.println(java.lang.String) : void [48]\n    52  return\n";
        this.verifyClassFile(expectedOutput, "X.class", 4);
    }

    public void testIssue773_2() throws Exception {
        this.runConformTest(new String[]{"X.java", "interface I {}\n\nrecord R (I i, I  j) {}\n\nclass A implements I {}\nclass B implements I {}\n\npublic class X {\n\n\tstatic int swtch(Object o) {\n\t\treturn switch (o) {\n\t\t\tcase R(A a1, A a2) -> 1;\n\t\t\tcase R(B b1, B b2) -> 2;\n\t\t\tcase Object obj -> 3;\n\t\t};\n\t}\n\tpublic static void main(String argv[]) {\n\t\tObject o = new R(new A(), new A());\n\t\tSystem.out.print(swtch(o));\n\t\to = new R(new B(), new B());\n\t\tSystem.out.print(swtch(o));\n\t\to = new R(new I() {}, new I() {});\n\t\tSystem.out.println(swtch(o));\n\t}\n}\n"}, "123");
    }

    public void testIssue773_3() throws Exception {
        this.runConformTest(new String[]{"X.java", "interface I {}\n\nrecord R (I i, I  j) {}\n\nclass A implements I {}\nclass B implements I {}\n\npublic class X {\n\n\tstatic int swtch(Object o) {\n\t\treturn switch (o) {\n\t\t\tcase R(A a1, A a2) when o == null -> 1;\n\t\t\tcase R(B b1, B b2) when o == null -> 2;\n\t\t\tcase Object obj -> 3;\n\t\t};\n\t}\n\tpublic static void main(String argv[]) {\n\t\tObject o = new R(new A(), new A());\n\t\tSystem.out.print(swtch(o));\n\t\to = new R(new B(), new B());\n\t\tSystem.out.print(swtch(o));\n\t\to = new R(new I() {}, new I() {});\n\t\tSystem.out.println(swtch(o));\n\t}\n}\n"}, "333");
    }

    public void testIssue773_4() throws Exception {
        this.runConformTest(new String[]{"X.java", "interface I {}\n\nrecord R (I i, I  j) {}\n\nclass A implements I {}\nclass B implements I {}\n\npublic class X {\n\n\tstatic int swtch(Object o) {\n\t\treturn switch (o) {\n\t\t\tcase R(A a1, A a2) when o != null -> 1;\n\t\t\tcase R(B b1, B b2) when o != null -> 2;\n\t\t\tcase Object obj -> 3;\n\t\t};\n\t}\n\tpublic static void main(String argv[]) {\n\t\tObject o = new R(new A(), new A());\n\t\tSystem.out.print(swtch(o));\n\t\to = new R(new B(), new B());\n\t\tSystem.out.print(swtch(o));\n\t\to = new R(new I() {}, new I() {});\n\t\tSystem.out.println(swtch(o));\n\t}\n}\n"}, "123");
    }

    public void testIssue773_5() throws Exception {
        this.runConformTest(new String[]{"X.java", "interface I {}\n\nrecord R (I i, I  j) {}\n\nclass A implements I {}\nclass B implements I {}\n\npublic class X {\n\n\tstatic int swtch(Object o) {\n\t\treturn switch (o) {\n\t\t\tcase R(A a1, A a2) when o != null -> 1;\n\t\t\tcase R(B b1, B b2) when o == null -> 2;\n\t\t\tcase Object obj -> 3;\n\t\t};\n\t}\n\tpublic static void main(String argv[]) {\n\t\tObject o = new R(new A(), new A());\n\t\tSystem.out.print(swtch(o));\n\t\to = new R(new B(), new B());\n\t\tSystem.out.print(swtch(o));\n\t\to = new R(new I() {}, new I() {});\n\t\tSystem.out.println(swtch(o));\n\t}\n}\n"}, "133");
    }

    public void testIssue773_6() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\n   record CoffeeBreak() {}\n       public int recharge(CoffeeBreak c) {\n           int energyLevel = 0;\n           switch (c) {\n               case CoffeeBreak( ) -> {\n                   energyLevel = 3;\n               }\n               default->{\n                   energyLevel = -3;\n               }\n           }\n           return energyLevel;\n       }\n       public static void main(String argv[]) {\n           X t = new X();\n           CoffeeBreak c = new CoffeeBreak();\n           if (t.recharge(c) == 3) {\n        \t   System.out.println(\"OK!\");\n           } else {\n        \t   System.out.println(\"!OK!\");\n           }\n       }\n}\n"}, "OK!");
    }

    public void testIssue2053() throws Exception {
        this.runConformTest(new String[]{"X.java", "interface I {}\n\nrecord R (I i, I  j) {}\n\nclass A implements I {}\nclass B implements I {}\n\npublic class X {\n\n\tstatic int swtch(Object o) {\n\t\treturn switch (o) {\n\t\t\tcase R(A a1, A a2) when true -> 1;\n\t\t\tcase R(B b1, B b2) when o != null -> 2;\n\t\t\tcase Object obj -> 3;\n\t\t};\n\t}\n\tpublic static void main(String argv[]) {\n\t\tObject o = new R(new A(), new A());\n\t\tSystem.out.print(swtch(o));\n\t\to = new R(new B(), new B());\n\t\tSystem.out.print(swtch(o));\n\t\to = new R(new I() {}, new I() {});\n\t\tSystem.out.println(swtch(o));\n\t}\n}\n"}, "123");
    }

    public void testIssue2053_2() throws Exception {
        this.runConformTest(new String[]{"X.java", "interface I {}\n\nrecord R (I i, I  j) {}\n\nclass A implements I {}\nclass B implements I {}\n\npublic class X {\n\n\tstatic int swtch(Object o) {\n\t\treturn switch (o) {\n\t\t\tcase R(A a1, A a2) when true -> 1;\n\t\t\tcase R(B b1, B b2) when o == null -> 2;\n\t\t\tcase Object obj -> 3;\n\t\t};\n\t}\n\tpublic static void main(String argv[]) {\n\t\tObject o = new R(new A(), new A());\n\t\tSystem.out.print(swtch(o));\n\t\to = new R(new B(), new B());\n\t\tSystem.out.print(swtch(o));\n\t\to = new R(new I() {}, new I() {});\n\t\tSystem.out.println(swtch(o));\n\t}\n}\n"}, "133");
    }

    public void testIssue2077() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static void main(String [] args) {\n        new X().foo(\"Hello \", 1);\n    }\n    public void foo(Object obj, int x) {\n        int y = 10;\n        y = 20;\n        y = 30;\n        switch (obj) {\n         case String s when switch (x) {\n                    case 1 -> { int y1 = 10; y1 = 30; yield y1!=20; }\n                    default -> { yield false; }\n                }\n                 -> {\n                    System.out.println(s + \"OK\");\n                    if (y == 0)\n                    \tSystem.out.println(s + \"OK\");\n                 }\n\n         default -> {}\n        }\n    }\n}\n"}, "Hello OK");
    }

    public void testIssue2077_2() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    public static void main(String [] args) {\n        new X().foo(\"Hello \", 1);\n    }\n    public void foo(Object obj, int x) {\n        int y = 10;\n        y = 20;\n        y = 30;\n        switch (obj) {\n         case String s when switch (x) {\n                    case 1 -> { int y1 = 10; y1 = 30; yield 30 != y1; }\n                    default -> { yield false; }\n                } && y != 0\n                 -> {\n                    System.out.println(s + \"OK\");\n                    if (y == 0)\n                    \tSystem.out.println(s + \"OK\");\n                 }\n\n         default -> {}\n        }\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\ty = 20;\n\t^\nLocal variable y is required to be final or effectively final based on its usage\n----------\n2. ERROR in X.java (at line 8)\n\ty = 30;\n\t^\nLocal variable y is required to be final or effectively final based on its usage\n----------\n3. ERROR in X.java (at line 13)\n\t} && y != 0\n\t     ^\nLocal variable y referenced from a guard must be final or effectively final\n----------\n");
    }

    public void testIssue2077_3() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    public static void main(String [] args) {\n        new X().foo(\"Hello \", 1);\n    }\n    public void foo(Object obj, int x) {\n        int y = 10;\n        y = 20;\n        y = 30;\n        switch (obj) {\n         case String s when switch (x) {\n                    case 1 -> { int y1 = 10; y1 = 30; yield y != y1; }\n                    default -> { yield false; }\n                } && y != 0\n                 -> {\n                    System.out.println(s + \"OK\");\n                    if (y == 0)\n                    \tSystem.out.println(s + \"OK\");\n                 }\n\n         default -> {}\n        }\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\ty = 20;\n\t^\nLocal variable y is required to be final or effectively final based on its usage\n----------\n2. ERROR in X.java (at line 8)\n\ty = 30;\n\t^\nLocal variable y is required to be final or effectively final based on its usage\n----------\n3. ERROR in X.java (at line 11)\n\tcase 1 -> { int y1 = 10; y1 = 30; yield y != y1; }\n\t                                        ^\nLocal variable y referenced from a guard must be final or effectively final\n----------\n4. ERROR in X.java (at line 13)\n\t} && y != 0\n\t     ^\nLocal variable y referenced from a guard must be final or effectively final\n----------\n");
    }

    public void testIssue2318() {
        Map<String, String> options = this.getCompilerOptions();
        String tpf = options.get("org.eclipse.jdt.core.compiler.codegen.targetPlatform");
        try {
            options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.8");
            String[] sourceFiles = new String[]{"X.java", "public class X {\n\tpublic static void main(String [] args) {\n\t\tint i = 123;\n\t\tSystem.out.println(\"\" + switch (args) {\n\t\t\tcase null -> { try {\n\t\t\t\t\t\t\tthrow new NullPointerException(\"Value in position \"+ i +\" must not be null\");\n\t\t\t\t\t\t} finally {\n\t\t\t\t\t\t\tyield \"exception\";\n\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\tdefault -> \"Hello\";\n\t\t});\n\t}\n}\n"};
            this.runConformTest(sourceFiles, "Hello", options);
        }
        finally {
            options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", tpf);
        }
    }

    public void testIssue2319() {
        Map<String, String> options = this.getCompilerOptions();
        String uscf = options.get("org.eclipse.jdt.core.compiler.codegen.useStringConcatFactory");
        try {
            options.put("org.eclipse.jdt.core.compiler.codegen.useStringConcatFactory", "disabled");
            String[] sourceFiles = new String[]{"X.java", "public class X {\n\tpublic static void main(String [] args) {\n\t\tint i = 123;\n\t\tSystem.out.println(\"\" + switch (args) {\n\t\t\tcase null -> { try {\n\t\t\t\t\t\t\tthrow new NullPointerException(\"Value in position \"+ i +\" must not be null\");\n\t\t\t\t\t\t} finally {\n\t\t\t\t\t\t\tyield \"exception\";\n\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\tdefault -> \"Hello\";\n\t\t});\n\t}\n}\n"};
            this.runConformTest(sourceFiles, "Hello", options);
        }
        finally {
            options.put("org.eclipse.jdt.core.compiler.codegen.useStringConcatFactory", uscf);
        }
    }

    public void testIssue2503() {
        this.runNegativeTest(new String[]{"X.java", "sealed interface I permits A, J {}\n\nfinal class A implements I {}\n\nfinal class J implements I {}\n\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(switch((I) new J()) {\n\t\t\t\tcase A a -> \"a\";\n\t\t});\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\tSystem.out.println(switch((I) new J()) {\n\t                          ^^^^^^^^^^^\nA switch expression should have a default case\n----------\n");
    }

    public void testIssue2503_2() {
        this.runNegativeTest(new String[]{"X.java", "sealed interface I permits A, J {}\n\nfinal class A implements I {}\n\nnon-sealed interface J extends I {}\n\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(switch((I) new J() {}) {\n\t\t\t\tcase A a -> \"a\";\n\t\t});\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\tSystem.out.println(switch((I) new J() {}) {\n\t                          ^^^^^^^^^^^^^^\nA switch expression should have a default case\n----------\n");
    }

    public void testIssue2503_3() {
        this.runNegativeTest(new String[]{"X.java", "sealed interface Outer permits Inner, Foo {}\nsealed interface Inner extends Outer {\n\tpublic static record A() implements Inner {}\n\tpublic static record B() implements Inner {}\n}\nnon-sealed interface Foo extends Outer {}\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tOuter element = new FooImpl();\n\n\t\tString test = switch(element) {\n\t\tcase Inner.A a -> \"a\";\n\t\tcase Inner.B b -> \"b\";\n\t\t};\n\n\t\tSystem.out.println(test);\n\t}\n\n\tprivate static record FooImpl() implements Foo {}\n}\n"}, "----------\n1. ERROR in X.java (at line 11)\n\tString test = switch(element) {\n\t                     ^^^^^^^\nA switch expression should have a default case\n----------\n");
    }

    public void testIssue2508() {
        this.runNegativeTest(new String[]{"X.java", "sealed interface I permits A, B {}\n\nfinal class A implements I {}\nfinal class B implements I {}\n\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(switch((I) new B()) {\n\t\t\t\tcase A a -> \"a\";\n\t\t\t\tcase B b when args == null -> \"b\";\n\t\t});\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\tSystem.out.println(switch((I) new B()) {\n\t                          ^^^^^^^^^^^\nA switch expression should have a default case\n----------\n");
    }

    public void testIssue2508_2() {
        this.runConformTest(new String[]{"X.java", "sealed interface I permits A, B {}\n\nfinal class A implements I {}\nfinal class B implements I {}\n\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(switch((I) new B()) {\n\t\t\t\tcase A a -> \"a\";\n\t\t\t\tcase B b when args == null -> \"b1\";\n\t\t\t\tcase B b when args == null -> \"b2\";\n\t\t\t\tcase B b -> \"!b\";\n\t\t});\n\t}\n}\n"}, "!b");
    }

    public void testIssue2508_3() {
        this.runConformTest(new String[]{"X.java", "sealed interface I permits A, B {}\n\nfinal class A implements I {}\nfinal class B implements I {}\n\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(switch((I) new B()) {\n\t\t\t\tcase A a -> \"a\";\n\t\t\t\tcase B b when args != null -> \"b1\";\n\t\t\t\tcase B b when args != null -> \"b2\";\n\t\t\t\tcase B b -> \"!b\";\n\t\t});\n\t}\n}\n"}, "b1");
    }

    public void testIssue2513() {
        this.runConformTest(new String[]{"X.java", "sealed interface SyDeclClass permits SyDeclClassLit {\n\n}\n\nrecord SyDeclClassLit() implements SyDeclClass {}\n\n\npublic class X {\n\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(\"Start\");\n\t\tSyDeclClass sdc = new SyDeclClassLit();\n\t\tswitch (sdc) {\n\t\t\tcase SyDeclClassLit C:\n\t\t\t\t// omit;\n\t\t}\n\t\tSystem.out.println(\"Stop\");\n\t}\n\n}\n"}, "Start\nStop");
    }

    public void testIssue2582() {
        this.runConformTest(new String[]{"X.java", "enum Foo {\n        FOO, BAR;\n    }\n\npublic class X {\n    public void dispatch(final Foo foo) {\n        switch (foo)  {\n            // forces JEP-441 exhaustiveness\n            case null -> throw new NullPointerException(\"null foo\");\n            case FOO -> foo();\n            case BAR -> bar();\n        }\n    }\n\n    private void foo() {\n    \tSystem.out.println(\"Foo\");\n    }\n\n    private void bar() {\n    \tSystem.out.println(\"Bar\");\n    }\n    public static void main(String[] args) {\n    \tnew X().dispatch(Foo.FOO);\n    \tnew X().dispatch(Foo.BAR);\n    \ttry {\n    \tnew X().dispatch(null);\n    \t} catch (NullPointerException npe) {\n    \t\tSystem.out.println(\"Null\");\n    \t}\n\t}\n}\n\n"}, "Foo\nBar\nNull");
    }

    public void testIssue2582b() {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.customOptions = this.getCompilerOptions();
        runner.customOptions.put("org.eclipse.jdt.core.compiler.problem.missingDefaultCase", "warning");
        runner.testFiles = new String[]{"X.java", "enum Foo {\n        FOO, BAR;\n    }\npublic class X {\n    public void dispatch(final Foo foo) {\n        switch (foo)  {\n            // forces JEP-441 exhaustiveness\n            case null -> throw new NullPointerException(\"null foo\");\n            case FOO -> foo();\n            case BAR -> bar();\n        }\n    }\n    private void foo() {\n    \tSystem.out.println(\"Foo\");\n    }\n    private void bar() {\n    \tSystem.out.println(\"Bar\");\n    }\n    public static void main(String[] args) {\n    \tnew X().dispatch(Foo.FOO);\n    \tnew X().dispatch(Foo.BAR);\n    \ttry {\n    \tnew X().dispatch(null);\n    \t} catch (NullPointerException npe) {\n    \t\tSystem.out.println(\"Null\");\n    \t}\n\t}\n}\n"};
        runner.expectedOutputString = "Foo\nBar\nNull";
        runner.runConformTest();
    }

    public void testIssue2582c() {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.customOptions = this.getCompilerOptions();
        runner.customOptions.put("org.eclipse.jdt.core.compiler.problem.missingDefaultCase", "error");
        runner.customOptions.put("org.eclipse.jdt.core.compiler.problem.missingEnumCaseDespiteDefault", "enabled");
        runner.customOptions.put("org.eclipse.jdt.core.compiler.problem.incompleteEnumSwitch", "warning");
        runner.testFiles = new String[]{"X.java", "enum NUM { ONE, TWO, THREE; }\n\npublic class X {\n\tvoid old(NUM n) {\n\t\tswitch (n) { // The switch over the enum type NUM should have a default case\n\t\t\tcase ONE, TWO, THREE:\n\t\t\t\tSystem.out.println(\"known\");\n\t\t}\n\t\tswitch (n) {\n\t\t\tcase ONE, TWO, THREE:\n\t\t\t\tSystem.out.println(\"known\");\n\t\t\tdefault:\n\t\t\t\tSystem.out.println(\"safety\");\n\t\t}\n\t\tswitch (n) { // The enum constant THREE should have a corresponding case label in this enum switch on NUM. To suppress this problem, add a comment //$CASES-OMITTED$ on the line above the 'default:'\n\t\t\tcase ONE, TWO:\n\t\t\t\tSystem.out.println(\"known\");\n\t\t\t\tbreak;\n\t\t\tdefault:\n\t\t\t\tSystem.out.println(\"other\");\n\t\t}\n\t\tswitch (n) {\n\t\t\tcase ONE, TWO:\n\t\t\t\tSystem.out.println(\"known\");\n\t\t\t\tbreak;\n\t\t\t//$CASES-OMITTED$\n\t\t\tdefault:\n\t\t\t\tSystem.out.println(\"other\");\n\t\t}\n\t}\n\tvoid newStyle(NUM n) {\n\t\tswitch (n) {  // The switch over the enum type NUM should have a default case\n\t\t\tcase ONE, TWO, THREE ->\n\t\t\t\tSystem.out.println(\"known\");\n\t\t}\n\t\tswitch (n) {\n\t\t\tcase ONE, TWO, THREE ->\n\t\t\t\tSystem.out.println(\"known\");\n\t\t\tdefault ->\n\t\t\t\tSystem.out.println(\"safety\");\n\t\t}\n\t\tswitch (n) { // The enum constant THREE should have a corresponding case label in this enum switch on NUM. To suppress this problem, add a comment $CASES-OMITTED$ on the line above the 'default:'\n\t\t\tcase ONE, TWO ->\n\t\t\t\tSystem.out.println(\"known\");\n\t\t\tdefault ->\n\t\t\t\tSystem.out.println(\"other\");\n\t\t}\n\t\tswitch (n) {\n\t\t\tcase ONE, TWO ->\n\t\t\t\tSystem.out.println(\"known\");\n\t\t\t//$CASES-OMITTED$\n\t\t\tdefault ->\n\t\t\t\tSystem.out.println(\"other\");\n\t\t}\n\t}\n}\n"};
        runner.expectedCompilerLog = "----------\n1. ERROR in X.java (at line 5)\n\tswitch (n) { // The switch over the enum type NUM should have a default case\n\t        ^\nThe switch over the enum type NUM should have a default case\n----------\n2. WARNING in X.java (at line 15)\n\tswitch (n) { // The enum constant THREE should have a corresponding case label in this enum switch on NUM. To suppress this problem, add a comment //$CASES-OMITTED$ on the line above the 'default:'\n\t        ^\nThe enum constant THREE should have a corresponding case label in this enum switch on NUM. To suppress this problem, add a comment //$CASES-OMITTED$ on the line above the 'default:'\n----------\n3. ERROR in X.java (at line 32)\n\tswitch (n) {  // The switch over the enum type NUM should have a default case\n\t        ^\nThe switch over the enum type NUM should have a default case\n----------\n4. WARNING in X.java (at line 42)\n\tswitch (n) { // The enum constant THREE should have a corresponding case label in this enum switch on NUM. To suppress this problem, add a comment $CASES-OMITTED$ on the line above the 'default:'\n\t        ^\nThe enum constant THREE should have a corresponding case label in this enum switch on NUM. To suppress this problem, add a comment //$CASES-OMITTED$ on the line above the 'default:'\n----------\n";
        runner.javacTestOptions = AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError;
        runner.runNegativeTest();
    }

    public void testIssue2714() {
        this.runConformTest(new String[]{"X.java", "public interface X {\n\n  static <T extends AbstractSealedClass> Integer get(T object) {\n    return switch (object) {\n      case ClassB ignored -> 42;\n    };\n  }\n\n  public abstract sealed class AbstractSealedClass permits ClassB {\n  }\n\n  public final class ClassB extends AbstractSealedClass {\n  }\n\n  public static void main(String[] args) {\n   System.out.println(get(new ClassB()));\n  }\n}\n"}, "42");
    }

    public void testIssue2870() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\n\tenum EnumError {\n\t\tTEST(0);\n\n\t\tprivate int value;\n\n\t\tprivate EnumError(int value) {\n\t\t\tthis.value = value;\n\t\t}\n\n\t\tpublic int getValue() {\n\t\t\treturn this.value;\n\t\t}\n\t}\n\n\tpublic static void main(String[] args) {\n\t\tint bouh = 0;\n\t\tswitch(bouh) {\n\t\tcase EnumError.TEST.getValue() :\n\t\t\tbreak;\n\t\t}\n\t}\n\n}\n"}, "----------\n1. ERROR in X.java (at line 19)\r\n\tswitch(bouh) {\r\n\t       ^^^^\nAn enhanced switch statement should be exhaustive; a default label expected\n----------\n2. ERROR in X.java (at line 20)\r\n\tcase EnumError.TEST.getValue() :\r\n\t     ^^^^^^^^^^^^^^\nEnumError.TEST cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 20)\r\n\tcase EnumError.TEST.getValue() :\r\n\t     ^^^^^^^^^^^^^^^^^^^^^^^\nOnly record types are permitted in a record pattern\n----------\n");
    }

    public void testIssue3009() {
        this.runConformTest(new String[]{"X.java", "public sealed interface X<T> permits X.Y {\n\n\tdefault Object foo() {\n\t\treturn switch (this) {\n\t\t\t\t\tcase X<T> x -> \"OK!\";\n\t\t\t   };\n\t}\n\n\tsealed class Y<T> implements X<T> permits Y.Z {\n\t\tstatic final class Z<T> extends Y<T> {}\n\t}\n\n    public static void main(String [] args) {\n        System.out.println(new Y<String>().foo());\n    }\n}\n"}, "OK!");
    }

    public void testIssue3009_2() {
        this.runConformTest(new String[]{"Editable.java", "import java.util.Objects;\nimport java.util.Optional;\nimport java.util.function.Consumer;\nimport java.util.function.Supplier;\n\npublic sealed interface Editable<T> permits Editable.NotEdited, Editable.Edited {\n\n  public static void main(String [] args) {\n        System.out.println(\"OK!\");\n     }\n\n  static <T> Editable<T> notEdited() {\n    return (Editable<T>) NotEdited.NOT_EDITED;\n  }\n\n  static <T> Editable<T> emptyValue() {\n    return (Editable<T>) Edited.EditedWithoutValue.NO_VALUE;\n  }\n\n  static <T> Editable<T> of(T value) {\n    return new Edited.EditedWithValue<>(value);\n  }\n\n  static <T> Editable<T> ofNullable(T value) {\n    if (value == null) {\n      return emptyValue();\n    }\n\n    return new Edited.EditedWithValue<>(value);\n  }\n\n  default boolean isEdited() {\n    return this instanceof Editable.Edited<T>;\n  }\n\n  default boolean isNotEdited() {\n    return this instanceof Editable.NotEdited<T>;\n  }\n\n  default Optional<T> editedValue() {\n    return switch (this) {\n      case Edited<T> edited -> Optional.of(edited).flatMap(Edited::value);\n      case NotEdited<T> ignored -> Optional.empty();\n    };\n  }\n\n  boolean hasNotChanged(T otherValue);\n\n  Optional<T> or(Supplier<Optional<T>> supplier);\n\n  void ifEdited(Consumer<Optional<T>> action);\n\n  final class NotEdited<T> implements Editable<T> {\n\n    private static final Editable<?> NOT_EDITED = new NotEdited<>();\n\n    private NotEdited() {\n    }\n\n    @Override\n    public boolean hasNotChanged(T otherValue) {\n      return true;\n    }\n\n    @Override\n    public Optional<T> or(Supplier<Optional<T>> supplier) {\n      Objects.requireNonNull(supplier);\n\n      return supplier.get();\n    }\n\n    @Override\n    public void ifEdited(Consumer<Optional<T>> action) {\n      // Nothing to do\n    }\n  }\n\n  abstract sealed class Edited<T> implements Editable<T> permits Edited.EditedWithoutValue, Edited.EditedWithValue {\n\n    protected abstract Optional<T> value();\n\n    @Override\n    public void ifEdited(Consumer<Optional<T>> action) {\n      Objects.requireNonNull(action);\n\n      action.accept(value());\n    }\n\n    @Override\n    public Optional<T> or(Supplier<Optional<T>> supplier) {\n      return value();\n    }\n\n    static final class EditedWithoutValue<T> extends Edited<T> {\n\n      private static final Edited<?> NO_VALUE = new EditedWithoutValue<>();\n\n      private EditedWithoutValue() {\n      }\n\n      @Override\n      protected Optional<T> value() {\n        return Optional.empty();\n      }\n\n      @Override\n      public boolean hasNotChanged(T otherValue) {\n        return otherValue == null;\n      }\n    }\n\n    static final class EditedWithValue<T> extends Edited<T> {\n\n      private final T value;\n\n      private EditedWithValue(T value) {\n        this.value = Objects.requireNonNull(value);\n      }\n\n      @Override\n      protected Optional<T> value() {\n        return Optional.of(value);\n      }\n\n      @Override\n      public boolean hasNotChanged(T otherValue) {\n        return Objects.equals(value, otherValue);\n      }\n    }\n  }\n}\n"}, "OK!");
    }

    public void testIssue3009_3() {
        this.runConformTest(new String[]{"X.java", "sealed interface J<T, U> permits D, E, F, G, H {}\nfinal class D implements J<String, Integer> {}\nfinal class E<T, U> implements J<U, T> {}\nfinal class F<T, U> implements J<String, U> {}\nfinal class G<T, U> implements J<T, U> {}\nfinal class H<T, U> implements J<Integer, U> {}\n\npublic class X {\n static int testExhaustive2(J<Integer, X> ji) {\n   return switch (ji) { // Exhaustive!\n   case E<X, Integer> e -> 42;\n   case G<Integer, X> e -> 420;\n   case H<?, X> e -> 4200;\n   };\n }\n public static void main(String[] args) {\n   J<Integer, X> ji = new E<>();\n   System.out.println(X.testExhaustive2(ji));\n   ji = new G<>();\n   System.out.println(X.testExhaustive2(ji));\n   ji = new H<>();\n   System.out.println(X.testExhaustive2(ji));\n }\n}\n"}, "42\n420\n4200");
    }

    public void testIssue3009_4() {
        this.runNegativeTest(new String[]{"X.java", "sealed interface J<T, U> permits D, E, F, G, H {}\nfinal class D implements J<String, Integer> {}\nfinal class E<T, U> implements J<U, T> {}\nfinal class F<T, U> implements J<String, U> {}\nfinal class G<T, U> implements J<T, U> {}\nfinal class H<T, U> implements J<Integer, U> {}\n\npublic class X {\n static int testExhaustive2(J<Integer, X> ji) {\n   return switch (ji) { // Exhaustive!\n   case E<X, Integer> e -> 42;\n   case G<Integer, X> e -> 420;\n   case H<Integer, X> e -> 4200;\n   };\n }\n public static void main(String[] args) {\n   J<Integer, X> ji = new E<>();\n   System.out.println(X.testExhaustive2(ji));\n   ji = new G<>();\n   System.out.println(X.testExhaustive2(ji));\n   ji = new H<>();\n   System.out.println(X.testExhaustive2(ji));\n }\n}\n"}, "----------\n1. ERROR in X.java (at line 13)\r\n\tcase H<Integer, X> e -> 4200;\r\n\t     ^^^^^^^^^^^^^^^\nType J<Integer,X> cannot be safely cast to H<Integer,X>\n----------\n");
    }

    public void testIssue3009_5() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\n\tclass O<T> {\n\t\tclass M<U> {\n\t\t\tclass I<K> {\n\t\t\t\tabstract sealed class J<V1, V2> permits S {}\n\t\t\t}\n\t\t}\n\t}\n\n\tfinal class S<T1, T2, T3, T4, T5> extends O<T1>.M<T2>.I<T3>.J<T4, T5> {\n\t\tS(O<T1>.M<T2>.I<T3> ei) {\n\t\t\tei.super();\n\t\t}\n\t}\n\n\tstatic int testExhaustive(O<Short>.M<Integer>.I<Long>.J<Integer, X> ji) {\n\t   return switch (ji) { // Exhaustive!\n\t   case S<Short, Integer, Long, Integer, X> e -> 42;\n\t   };\n\t}\n\n\tpublic static void main(String[] args) {\n\t   System.out.println(X.testExhaustive(new X().new S<Short, Integer, Long, Integer, X>(new X().new O<Short>().new M<Integer>().new I<Long>())));\n\t}\n}\n"}, "42");
    }

    public void testIssue3009_6() {
        this.runConformTest(new String[]{"X.java", "abstract sealed class J<T1, T2> permits X.S {}\n\npublic class X<T> {\n\n\tfinal class S<U> extends J<T, U> {}\n\n int testExhaustive(J<Integer, String> ji) {\n   return switch (ji) { // Exhaustive!\n   \tcase X<Integer>.S<String> e -> 420;\n   };\n }\n public static void main(String[] args) {\n   X<Integer>.S<String> xs = null;\n   System.out.println(new X<Integer>().testExhaustive(new X<Integer>().new S<String>()));\n }\n}\n"}, "420");
    }

    public void testIssue3009_7() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\n\tclass O<T> {\n\t\tclass M<U> {\n\t\t\tclass I<K> {\n\t\t\t\tabstract sealed class J<V1, V2> permits W.NG.I.S {\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n\n\tclass W<T1> {\n\t\tclass NG {\n\t\t\tclass I<T2> {\n\t\t\t\tfinal class S<T3, T4, T5> extends O<T1>.M<T2>.I<T3>.J<T4, T5> {\n\t\t\t\t\tS(O<T1>.M<T2>.I<T3> ei) {\n\t\t\t\t\t\tei.super();\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n\n\tstatic int testExhaustive(O<Short>.M<Integer>.I<Long>.J<Integer, X> ji) {\n\t\treturn switch (ji) { // Exhaustive!\n\t\tcase W<Short>.NG.I<Integer>.S<Long, Integer, X> e -> 42;\n\t\t};\n\t}\n\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(X.testExhaustive(new X().new W<Short>().new NG().new I<Integer>().new S<Long, Integer, X>(\n\t\t\t\tnew X().new O<Short>().new M<Integer>().new I<Long>())));\n\t\tO<Short>.M<Integer>.I<Long>.J<Integer, X> ji = (W<Short>.NG.I<Integer>.S<Long, Integer, X>) null;\n\t}\n}\n"}, "42");
    }

    public void testIssue3031() {
        this.runNegativeTest(new String[]{"X.java", "abstract sealed class J<T1, T2> permits X.S, A {}\n\nfinal class A extends J<Integer, String> {}\n\npublic class X<T> {\n\n\tfinal class S<U> extends J<T, U> {}\n\n int testExhaustive(J<Integer, String> ji) {\n   return switch (ji) { // Exhaustive!\n     case A a -> 42;\n   //case X<Integer>.S<String> e -> 42;\n   };\n }\n public static void main(String[] args) {\n   X<Integer>.S<String> xs = null;\n   System.out.println(new X<Integer>().testExhaustive(new X<Integer>().new S<String>()));\n }\n}\n"}, "----------\n1. ERROR in X.java (at line 10)\n\treturn switch (ji) { // Exhaustive!\n\t               ^^\nA switch expression should have a default case\n----------\n");
    }

    public void testIssue3031_2() {
        this.runConformTest(new String[]{"X.java", "abstract sealed class J<T1, T2> permits X.S, A {}\n\nfinal class A extends J<Integer, String> {}\n\npublic class X<T> {\n\n\tfinal class S<U> extends J<T, U> {}\n\n int testExhaustive(J<Integer, String> ji) {\n   return switch (ji) { // Exhaustive!\n     case A a -> 42;\n     case X<Integer>.S<String> e -> 4200;\n   };\n }\n public static void main(String[] args) {\n   X<Integer>.S<String> xs = null;\n   System.out.println(new X<Integer>().testExhaustive(new X<Integer>().new S<String>()));\n }\n}\n"}, "4200");
    }

    public void testIssue2719() {
        this.runConformTest(new String[]{"X.java", "public interface X {\n\n  static <T extends Object & AbstractSealedInterface> Integer get(T object) {\n      return switch (object) {\n          case ClassC ignored -> 4200;\n      };\n  }\n\n  public abstract sealed interface AbstractSealedInterface permits InterfaceB {\n  }\n\n  public sealed interface InterfaceB extends AbstractSealedInterface permits ClassC {\n  }\n\n  final class ClassC implements InterfaceB {}\n\n  public static void main(String[] args) {\n      System.out.println(get(new ClassC()));\n  }\n}\n"}, "4200");
    }

    public void testIssue2719_2() {
        this.runConformTest(new String[]{"X.java", "public interface X {\n\n    static <T extends Object & I1 & I2> Integer get(T object) {\n      return switch (object) {\n        case AB ignored -> 42;\n        case BA ignored -> 420;\n      };\n    }\n\n    public abstract sealed interface I1 permits A, AB, BA {\n    }\n\n    public abstract sealed interface I2 permits B, AB, BA {\n    }\n\n\n    final class A implements I1 {}\n    final class B implements I2 {}\n    final class AB implements I1, I2 {}\n    final class BA implements I1, I2 {}\n\n    public static void main(String[] args) {\n        System.out.println(get(new AB()));\n        System.out.println(get(new BA()));\n    }\n}\n"}, "42\n420");
    }

    public void testIssue1735() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n\t\tvoid foo(I<X> ix) {\n\t\t\tswitch(ix) {\n\t\t\tcase A<Y> ay -> System.out.println();\n\t\t\tcase B<X> bx -> System.out.println();\n\t\t\t}\n\t\t}\n}\nclass Y extends X {}\nclass Z extends X {}\n\nsealed interface I<T> permits A, B {\n}\n\nfinal class B<T> implements I<X> {\n}\n\n\nfinal class A<T> implements I<X> {\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tcase A<Y> ay -> System.out.println();\n\t     ^^^^^^^\nType I<X> cannot be safely cast to A<Y>\n----------\n2. ERROR in X.java (at line 5)\n\tcase B<X> bx -> System.out.println();\n\t     ^^^^^^^\nType I<X> cannot be safely cast to B<X>\n----------\n");
    }

    public void testIssue3035() {
        this.runNegativeTest(new String[]{"X.java", "abstract sealed class J<T1, T2> permits X.S, A {\n}\n\nfinal class A extends J<Integer, String> {\n}\n\npublic class X {\n\n\tsealed class S<T, U> extends J<T, U> permits SS {\n\t}\n\n\tfinal class SS<T, U> extends S<U, T> {}\n\n\tint testExhaustive(J<Integer, String> ji) {\n\t\treturn switch (ji) { // Exhaustive!\n\t\tcase A a -> 42;\n\t\tcase S<Integer, String> e -> 4200;\n\t\tcase SS<String, Integer> e -> 420;\n\t\t};\n\t}\n\n\tpublic static void main(String[] args) {\n\t\tS<Integer, String> xs = null;\n\t\tSystem.out.println(new X().testExhaustive(new X().new S<Integer, String>()));\n\t\tJ<Integer, String> ji = new X().new SS<String, Integer>();\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 18)\n\tcase SS<String, Integer> e -> 420;\n\t     ^^^^^^^^^^^^^^^^^^^^^\nThis case label is dominated by one of the preceding case labels\n----------\n");
    }

    public void testIssue2720() {
        this.runConformTest(new String[]{"X.java", "sealed interface I {\n\n\tenum E implements I {\n\t\tA, B, C;\n\t}\n}\n\npublic class X {\n\n\tstatic void d(I i) {\n\t\tswitch (i) { // error: An enhanced switch statement should be exhaustive; a default label expected\n\t\t\tcase I.E.A -> { System.out.println(\"I.E.A\"); }\n\t\t\tcase I.E.B -> { System.out.println(\"I.E.B\"); }\n\t\t\tcase I.E.C -> { System.out.println(\"I.E.C\"); }\n\t\t}\n\t}\n\n\tpublic static void main(String [] args) {\n\t\td(I.E.A);\n\t\td(I.E.B);\n\t\td(I.E.C);\n\t}\n}\n"}, "I.E.A\nI.E.B\nI.E.C");
    }

    public void testIssue2720_2() {
        this.runNegativeTest(new String[]{"X.java", "sealed interface I {\n\n\tenum E implements I {\n\t\tA, B, C;\n\t}\n\n\tenum K implements I {\n\t    D, E, F;\n\t}\n}\n\nclass Test {\n\n\tvoid d(I i) {\n\t\tswitch (i) {\n\t\t\tcase I.E.A -> {}\n\t\t\tcase I.E.B -> {}\n\t\t\tcase I.E.C -> {}\n            case I.K k -> {}\n\t\t}\n\t\tswitch (i) {\n\t\t\tcase I.E.A -> {}\n\t\t\tcase I.E.B -> {}\n\t\t\tcase I.E.C -> {}\n            default -> {}\n\t\t}\n\t\tswitch (i) {\n\t\t\tcase I.E.A -> {}\n\t\t\tcase I.E.B -> {}\n\t\t\tcase I.E.C -> {}\n\t\t\tcase I.K.D -> {}\n\t\t\tcase I.K.E -> {}\n\t\t\tcase I.K.F -> {}\n            default -> {}\n\t\t}\n\t\tswitch (i) {\n\t\t\tcase I.E.A -> {}\n\t\t\tcase I.E.B -> {}\n\t\t\tcase I.E.C -> {}\n\t\t\tcase I.K.D -> {}\n\t\t\tcase I.K.E -> {}\n            default -> {}\n\t\t}\n\t\tswitch (i) {\n\t\t\tcase I.E.A -> {}\n\t\t\tcase I.E.B -> {}\n\t\t\tcase I.E.C -> {}\n\t\t\tcase I.K.D -> {}\n\t\t\tcase I.K.E -> {}\n\t\t}\n\t\tswitch (i) {\n\t\t\tcase I.E.A -> {}\n\t\t\tcase I.E.B -> {}\n\t\t\tcase I.E.C -> {}\n\t\t\tcase I.K.D -> {}\n\t\t\tcase I.K.E -> {}\n\t\t\tcase I.K.F -> {}\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 44)\n\tswitch (i) {\n\t        ^\nAn enhanced switch statement should be exhaustive; a default label expected\n----------\n");
    }

    public void testIssue2720_3() {
        this.runConformTest(new String[]{"X.java", "sealed interface I {\n\n\tenum E implements I {\n\t\tA, B, C;\n\t}\n\n\tenum K implements I {\n\t    D, E, F;\n\t}\n}\n\npublic class X {\n\n\tstatic void d(I i) {\n\t\tswitch (i) {\n\t\t\tcase I.E.A -> { System.out.println(\"I.E.A\"); }\n\t\t\tcase I.E.B -> { System.out.println(\"I.E.B\"); }\n\t\t\tcase I.E.C -> { System.out.println(\"I.E.C\"); }\n\t\t\tcase I.K.D -> { System.out.println(\"I.K.D\"); }\n\t\t\tcase I.K.E -> { System.out.println(\"I.K.E\"); }\n\t\t\tcase I.K.F -> { System.out.println(\"I.K.F\"); }\n\t\t}\n\t}\n\n\tpublic static void main(String [] args) {\n\t\td(I.E.A);\n\t\td(I.E.B);\n\t\td(I.E.C);\n\t\td(I.K.D);\n\t\td(I.K.E);\n\t\td(I.K.F);\n\t}\n}\n"}, "I.E.A\nI.E.B\nI.E.C\nI.K.D\nI.K.E\nI.K.F");
    }

    public void testIssue3096() {
        this.runConformTest(new String[]{"X.java", "public sealed interface X permits X.R {\n\trecord R(String s) implements X {\n\t}\n\n\tpublic static void add(X x) {\n\t\tswitch (x) {\n\t\tcase R r:\n\t\t\tif (r.s == null) {\n\t\t\t\tthrow new NullPointerException();\n\t\t\t}\n\t\t}\n\t}\n\n\tpublic static void main(String[] args) {\n\t\tadd(new R(\"bar\"));\n\t}\n}\n"}, "");
    }

    public void testIssue3096_2() {
        this.runConformTest(new String[]{"X.java", "public sealed interface X permits X.R {\n\trecord R(String s) implements X {\n\t}\n\n\tpublic static void add(X x) {\n\t\tswitch (x) {\n\t\tcase R r:\n\t\t\tif (r.s == null) {\n\t\t\t\tthrow new NullPointerException();\n\t\t\t}\n\t\t\tbreak;\n\t\t}\n\t}\n\n\tpublic static void main(String[] args) {\n\t\tadd(new R(\"bar\"));\n\t}\n}\n"}, "");
    }

    public void testIssue3096_3() {
        this.runConformTest(new String[]{"X.java", "public sealed interface X permits X.R {\n\trecord R(String s) implements X {\n\t}\n\n\tpublic static void add(X x) {\n\t\tswitch (x) {\n\t\tcase R r:\n\t\t\tif (r.s == null) {\n\t\t\t\tthrow new NullPointerException();\n\t\t\t}\n\t\t\tSystem.out.println(\"R\");\n\t\t}\n\t}\n\n\tpublic static void main(String[] args) {\n\t\tadd(new R(\"bar\"));\n\t}\n}\n"}, "R");
    }

    public void testIssue3096_4() {
        this.runConformTest(new String[]{"X.java", "public sealed interface X permits X.R {\n\trecord R(String s) implements X {\n\t}\n\n\tpublic static void add(X x) {\n\t\tswitch (x) {\n\t\tcase R r:\n\t\t\tif (r.s == null) {\n\t\t\t\tthrow new NullPointerException();\n\t\t\t}\n\t\t\tSystem.out.println(\"R\");\n\t\t\tbreak;\n\t\t}\n\t}\n\n\tpublic static void main(String[] args) {\n\t\tadd(new R(\"bar\"));\n\t}\n}\n"}, "R");
    }

    public void testIssue3096_full() {
        this.runConformTest(new String[]{"EclipseBugFallThroughSwitch.java", "public class EclipseBugFallThroughSwitch {\n  sealed interface I permits A, B {}\n  record A(String s) implements I {}\n  record B(String s) implements I {}\n\n  public void add(I i) {\n    switch (i) {\n    case A a:\n      break;\n    case B b:\n      if (b.s == null) {\n        throw new NullPointerException();\n      }\n      //break;  // this fix the issue\n    }\n  }\n\n  public static void main(String[] args) {\n    var container = new EclipseBugFallThroughSwitch();\n    container.add(new B(\"bar\"));\n\n    // Exception in thread \"main\" java.lang.MatchException\n    // at EclipseBugFallThroughSwitch.add(EclipseBugFallThroughSwitch.java:9)\n    // at EclipseBugFallThroughSwitch.main(EclipseBugFallThroughSwitch.java:25)\n  }\n}\n"}, "");
    }

    public void testIssue3135() {
        this.runConformTest(new String[]{"X.java", "public class X {\n        public static void main(String[] args) {\n            int i = 3;\n            int[] arr = { 42, 2, 3 };\n            System.out.println((switch (i) {\n                case 3 -> arr;\n                default -> null; // Replacing null with a non-null value can avoid this issue.\n            })[0]);\n        }\n}\n"}, "42");
    }

    public void testIssue3039_2() {
        this.runNegativeTest(new String[]{"X.java", "public interface X {\n\n  static <T extends Object & I2> Integer get(T object) {\n    return switch (object) {\n      case A ignored -> 42;\n      default -> 42;\n    };\n  }\n\n  public abstract sealed interface I2 permits , AB {\n  }\n\n\n  final class AB implements I2 {}\n\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tcase A ignored -> 42;\n\t     ^\nA cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 10)\n\tpublic abstract sealed interface I2 permits , AB {\n\t                                 ^^\nSyntax error on token \"I2\", permits expected after this token\n----------\n");
    }

    public void testNoFallThrough() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tswitch (\"Hello\") {\n\t\t\tcase \"Hello\" -> {\n\t\t\t\tSystem.out.println(\"Hello Block!\");\n\t\t\t}\n\t\t\tcase \"World\" -> {\n\t\t\t\tSystem.out.println(\"World Block!\");\n\t\t\t}\n\t\t\tdefault -> {\n\t\t\t\tSystem.out.println(\"Default Block\");\n\t\t\t}\n\t\t}\n\t}\n}\n"}, "Hello Block!");
    }

    public void testIssue3169() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tstatic void foo(Object o) {\n\t    switch (o) {\n\t        case Character c, Integer i:                 // Compile-time error\n\t            break;\n\t        default:\n\t        \tbreak;\n\t    }\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tcase Character c, Integer i:                 // Compile-time error\n\t               ^\nNamed pattern variables are not allowed here\n----------\n2. ERROR in X.java (at line 4)\n\tcase Character c, Integer i:                 // Compile-time error\n\t                          ^\nNamed pattern variables are not allowed here\n----------\n");
    }

    public void testEnumLocalCase() {
        this.runNegativeTest(new String[]{"X.java", "public enum X {\n\tA, B, C;\n}\n\nclass A {\n\tprivate void foo(X x) {\n\t    final X v = null;\n\t\tswitch (x) {\n\t\t\tcase v:\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\tcase v:\n\t     ^\nv cannot be resolved or is not a field\n----------\n");
    }

    public void testEnumLocalCase_2() {
        this.runNegativeTest(new String[]{"X.java", "public sealed interface X {\n\tenum E implements X {\n\t\tE1, E2;\n\t}\n\tpublic static void main(String[] args) {\n\t\tE e = null;\n\t\tswitch ((X) null) {\n\t\t\tcase e -> System.out.println();\n\t\t\tcase E.E2 -> System.out.println();\n\t\t\tdefault -> System.out.println();\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\tcase e -> System.out.println();\n\t     ^\ncase expressions must be constant expressions\n----------\n");
    }

    public void testEnumLocalCase_3() {
        this.runNegativeTest(new String[]{"X.java", "public sealed interface X {\n\tenum E implements X {\n\t\tE1, E2;\n\t}\n    public static final E e = E.E1;\n\tpublic static void main(String[] args) {\n\t\tswitch ((X) null) {\n\t\t\tcase e -> System.out.println();\n\t\t\tcase E.E2 -> System.out.println();\n\t\t\tdefault -> System.out.println();\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\tcase e -> System.out.println();\n\t     ^\nThe field X.e cannot be referenced from an enum case label; only enum constants can be used in enum switch\n----------\n");
    }

    public void testIssue3334() {
        this.runConformTest(new String[]{"X.java", "public sealed interface X {\n\tpublic static void main(String[] args) {\n        bar(E1.ONE);\n        bar(E1.TWO);\n        bar(E2.ONE);\n        bar(E2.TWO);\n\t}\n\tpublic static void bar(X x) {\n\t\tswitch (x) {\n\t\tcase E1.ONE:\n\t\t\tSystem.out.println(\"E1.ONE\");\n\t\tcase E1.TWO:\n\t\t\tSystem.out.println(\"E1.TWO\");\n\t\tcase E2.ONE:\n\t\t\tSystem.out.println(\"E2.ONE\");\n\t\tcase E2.TWO:\n\t\t\tSystem.out.println(\"E2.TWO\");\n\t\t}\n\t}\n}\nenum E1 implements X { ONE, TWO}\nenum E2 implements X { ONE, TWO}\n"}, "E1.ONE\nE1.TWO\nE2.ONE\nE2.TWO\nE1.TWO\nE2.ONE\nE2.TWO\nE2.ONE\nE2.TWO\nE2.TWO");
    }

    public void testIssue3335() {
        this.runNegativeTest(new String[]{"X.java", "public sealed interface X {\n\n\trecord R(X x) {}\n\n\tfinal  class C1 implements X {}\n\tfinal class C2 implements X {}\n\n\tpublic static void main(String[] args) {\n        bar(new R(new C1()));\n\t}\n\tpublic static void bar(R r) {\n\t\tswitch (r) {\n\t\tcase R(C1 c1) when c1 == null  -> System.out.println();\n\t\tcase R(C2 c1) -> System.out.println();\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 12)\n\tswitch (r) {\n\t        ^\nAn enhanced switch statement should be exhaustive; a default label expected\n----------\n");
    }

    public void testIssue3339() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tInteger i = 42;\n\t\tswitch (i) {\n\t\t\tcase 2 -> System.out.println(2);\n\t\t\tcase Integer ii when ii == 13 -> System.out.println(\"13\");\n\t\t\tcase 13 -> System.out.println(13);\n\t\t\tcase 14 -> System.out.println(14);\n\t\t\tdefault -> System.out.println(\"Default\");\n\t\t}\n\t}\n}\n"}, "Default");
    }

    public void testIssue3344() {
        this.runConformTest(new String[]{"Main.java", "import static p.A.A1;\nimport static p.A.A2;\nimport static p.B.B1;\nimport static p.B.B2;\n\nimport java.util.Arrays;\nimport java.util.stream.Stream;\n\nimport p.X;\nimport p.A;\nimport p.B;\n\npublic class Main {\n\n\tpublic static void main(String[] args) {\n\t\tStream.concat(Arrays.stream(A.values()), Arrays.stream(B.values())).forEach(\n\t\t\tx -> { System.out.printf(\"%s -> %s, %s\\n\", x, bad_switch(x), good_switch(x)); }\n\t\t);\n\t}\n\n    static String bad_switch(X x) {\n        return switch (x) {\n            case A1 -> \"A1\";\n            case A2 -> \"A2\";\n            case B1 -> \"B1\";\n            case B2 -> \"B2\";\n            default -> \"unknown\";\n        };\n    }\n\n    static String good_switch(X x) {\n        return switch (x) {\n            case A.A1 -> \"A1\";\n            case A.A2 -> \"A2\";\n            case B.B1 -> \"B1\";\n            case B.B2 -> \"B2\";\n            default -> \"unknown\";\n        };\n    }\n}\n", "p/A.java", "package p;\n\npublic enum A implements X {\n\tA1,\n\tA2,\n}\n", "p/B.java", "package p;\n\npublic enum B implements X {\n\tB1,\n\tB2\n}\n", "p/X.java", "package p;\n\npublic interface X {\n}\n"}, "A1 -> A1, A1\nA2 -> A2, A2\nB1 -> B1, B1\nB2 -> B2, B2");
    }

    public void testIssue3395() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n                       for (String s : new String [] { \"World\", \"Check\", \"Hello\", \"Null\", \"Default\" }) {\n                              String sel = s.equals(\"Null\") ? null : s;\n\t\t\tswitch (sel) {\n\t\t\t\tcase \"World\" -> System.out.print(\"World\");\n\t\t\t\tcase String str when s.equals(\"Check\") -> System.out.print(\"Check\");\n\t\t\t\tcase \"Hello\" -> System.out.print(\"Hello\");\n\t\t\t\tcase null -> System.out.print(\"Null\");\n\t\t\t\tdefault -> System.out.print(\"Default\");\n\t\t\t}\n\t\t\tSystem.out.print(\"--\");\n\t\t}\n\t\tSystem.out.println(\"\");\n                          for (String s : new String [] { \"Default\", \"Null\", \"Hello\", \"Check\", \"World\" }) {\n                              String sel = s.equals(\"Null\") ? null : s;\n\t\t\tswitch (sel) {\n\t\t\t\tcase \"World\" -> System.out.print(\"World\");\n\t\t\t\tcase String str when s.equals(\"Check\") -> System.out.print(\"Check\");\n\t\t\t\tcase \"Hello\" -> System.out.print(\"Hello\");\n\t\t\t\tcase null -> System.out.print(\"Null\");\n\t\t\t\tdefault -> System.out.print(\"Default\");\n\t\t\t}\n\t\t\tSystem.out.print(\"--\");\n\t\t}\n\t\tSystem.out.println(\"\");\n\t}\n}\n"}, "World--Check--Hello--Null--Default--\nDefault--Null--Hello--Check--World--");
    }

    public void testIssue3447() throws Exception {
        this.runConformTest(new String[]{"X.java", "enum E {\n\tA,\n\tB,\n}\n\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tE e = E.A;\n\t\tswitch (e) {\n\t\t\tcase A :    System.out.println(\"A\");\n\t\t\t\t\t    break;\n\t\t\tcase B:     System.out.println(\"B\");\n\t\t\t            break;\n\t\t\tcase null : System.out.println(\"null\");\n\t\t\t\t\t\tbreak;\n\t\t}\n\t}\n}\n"}, "A");
        String expectedOutput = "8  invokedynamic 0 enumSwitch(E, int) : int [22]\n";
        String unexpectedOutput = "static synthetic int[] $SWITCH_TABLE$E();\n";
        SwitchPatternTest.verifyClassFile(expectedOutput, unexpectedOutput, "X.class", 4);
    }

    public void testIssue3559() throws Exception {
        if (this.complianceLevel > 0x430000L) {
            return;
        }
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\n\tpublic static void main(String[] args) {\n\t\tnew X().d(true);\n\t}\n\n\tvoid d(Boolean b) {\n\t\tswitch (b) {\n\t\t\tcase true  -> System.out.println(\"1\");\n\t\t\tcase false -> System.out.println(\"2\");\n\t\t};\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\tswitch (b) {\n\t        ^\nAn enhanced switch statement should be exhaustive; a default label expected\n----------\n2. ERROR in X.java (at line 9)\n\tcase true  -> System.out.println(\"1\");\n\t     ^^^^\nCase constant of type boolean is incompatible with switch selector type Boolean\n----------\n3. ERROR in X.java (at line 10)\n\tcase false -> System.out.println(\"2\");\n\t     ^^^^^\nCase constant of type boolean is incompatible with switch selector type Boolean\n----------\n");
    }

    public void testIssue3812() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public final class X {\n\tpublic static void main(String[] args) {\n\t\tfor (int i = 0; i < 10; i++) {\n\t\t\tif (false) {\n\t\t\t\tswitch (args) {\n\t\t\t\tcase Object o when i == 3: break;\n\t\t\t\tdefault : break;\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tfor (int i = 0; i < 10; i++) {\n\t                        ^\nLocal variable i is required to be final or effectively final based on its usage\n----------\n2. WARNING in X.java (at line 4)\n\tif (false) {\n\t\t\t\tswitch (args) {\n\t\t\t\tcase Object o when i == 3: break;\n\t\t\t\tdefault : break;\n\t\t\t\t}\n\t\t\t}\n\t           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nDead code\n----------\n");
    }

    public void testIssue3840() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tint i;\n\t\tswitch (args) {\n\t\tcase Object o when (i = 10) == 10: break;\n\t\tdefault : break;\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tcase Object o when (i = 10) == 10: break;\n\t                    ^\nLocal variable i referenced from a guard must be final or effectively final\n----------\n");
    }

    public void testIssue3840_2() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tfinal int i;\n\t\tswitch (args) {\n\t\tcase Object o when (i = 10) == 10: break;\n\t\tdefault : break;\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tcase Object o when (i = 10) == 10: break;\n\t                    ^\nThe final local variable i cannot be assigned, since it is defined in an enclosing type\n----------\n");
    }

    public void testIssue3465() throws Exception {
        this.runConformTest(new String[]{"X.java", "import static java.util.stream.IntStream.rangeClosed;\n\npublic interface X {\n  static String fizzbuzz(int i) {\n    return switch((Integer) i) {\n      case Integer v when v % 15 == 0 -> \"FizzBuzz\";\n      case Integer v when v % 5 == 0 -> \"Buzz\";\n      case Integer v when v % 3 == 0 -> \"Fizz\";\n      case Integer v -> \"\" + v;\n    };\n  }\n\n  static void main(String[] args) {\n    rangeClosed(1, 100).mapToObj(i -> fizzbuzz(i)).forEach(System.out::println);\n  }\n}\n"}, "1\n2\nFizz\n4\nBuzz\nFizz\n7\n8\nFizz\nBuzz\n11\nFizz\n13\n14\nFizzBuzz\n16\n17\nFizz\n19\nBuzz\nFizz\n22\n23\nFizz\nBuzz\n26\nFizz\n28\n29\nFizzBuzz\n31\n32\nFizz\n34\nBuzz\nFizz\n37\n38\nFizz\nBuzz\n41\nFizz\n43\n44\nFizzBuzz\n46\n47\nFizz\n49\nBuzz\nFizz\n52\n53\nFizz\nBuzz\n56\nFizz\n58\n59\nFizzBuzz\n61\n62\nFizz\n64\nBuzz\nFizz\n67\n68\nFizz\nBuzz\n71\nFizz\n73\n74\nFizzBuzz\n76\n77\nFizz\n79\nBuzz\nFizz\n82\n83\nFizz\nBuzz\n86\nFizz\n88\n89\nFizzBuzz\n91\n92\nFizz\n94\nBuzz\nFizz\n97\n98\nFizz\nBuzz");
        String expectedOutput = "public static java.lang.String fizzbuzz(int i);\n";
        String unexpectedOutput = "checkcast";
        SwitchPatternTest.verifyClassFile(expectedOutput, unexpectedOutput, "X.class", 4);
    }

    public void testIssue4256() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\n  public static enum Any {\n    One, Two, Three;\n  }\n\n  public static void main(final String[] args) {\n    final Any any = Any.Three;\n    switch (any) {\n      case One -> System.out.println(\"ONE\");\n      case Two -> System.out.println(\"TWO\");\n      case null, Three -> System.out.println(\"THREE\");\n    }\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 12)\n\tcase null, Three -> System.out.println(\"THREE\");\n\t           ^^^^^\nA null case label has to be either the only expression in a case label or the first expression followed only by a default\n----------\n");
    }
}

