/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractBatchCompilerTest;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;

public class SwitchPatternTest22
extends AbstractBatchCompilerTest {
    public static Test suite() {
        return SwitchPatternTest22.buildMinimalComplianceTestSuite(SwitchPatternTest22.class, 524288);
    }

    public SwitchPatternTest22(String name) {
        super(name);
    }

    @Override
    protected Map<String, String> getCompilerOptions() {
        CompilerOptions compilerOptions = new CompilerOptions(super.getCompilerOptions());
        return compilerOptions.getMap();
    }

    @Override
    public void runConformTest(String[] files, String expectedOutput) {
        super.runConformTest(files, expectedOutput, null, null);
    }

    @Override
    protected void runConformTest(String[] testFiles, String expectedOutput, Map<String, String> customOptions) {
        this.runConformTest(testFiles, expectedOutput, "", customOptions);
    }

    protected void runConformTest(String[] testFiles, String expectedOutput, String errorOutput) {
        this.runConformTest(testFiles, expectedOutput, errorOutput, this.getCompilerOptions());
    }

    protected void runConformTest(String[] testFiles, String expectedOutput, String expectedErrorOutput, Map<String, String> customOptions) {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.testFiles = testFiles;
        runner.expectedOutputString = expectedOutput;
        runner.expectedErrorString = expectedErrorOutput;
        runner.vmArguments = new String[]{"--enable-preview"};
        runner.customOptions = customOptions;
        runner.runConformTest();
    }

    public void testListOfPatterns_000() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\n\tpublic static void main(String... args) {\n\t\tObject o = new Pantaloon(new Melon(), 12);\n\t\tswitch (o) {\n\t\tcase Pantaloon(Chartreuse _, int _), Pantaloon(Melon _, int _) : System.out.println(\"success\"); break;\n\t\tdefault: System.out.println(\"failure\"); break;\n\t\t}\n\t}\n\n\tstatic sealed abstract class Flavour permits Chartreuse, Orange, Licorice, Melon { }\n\tstatic final class Chartreuse extends Flavour {}\n\tstatic final class Orange extends Flavour {}\n\tstatic final class Licorice extends Flavour {}\n\tstatic final class Melon extends Flavour {}\n\tstatic record Pantaloon(Flavour flavour, int i) {}\n\n}\n"}, "success");
    }

    public void testListOfPatterns_001() {
        this.runConformTest(new String[]{"X.java", "public class X {\n                      record Point(int x, int y) {}\n\tpublic static void main(String... args) {\n\t\tObject o = new Pantaloon(new Chartreuse(), 12);\n\t\tswitch (o) {\n\t\tcase Point(_, _), Pantaloon(Chartreuse _, int _), Pantaloon(Melon _, int _) : System.out.println(\"success\"); break;\n\t\tdefault: System.out.println(\"failure\"); break;\n\t\t}\n\t}\n\n\tstatic sealed abstract class Flavour permits Chartreuse, Orange, Licorice, Melon { }\n\tstatic final class Chartreuse extends Flavour {}\n\tstatic final class Orange extends Flavour {}\n\tstatic final class Licorice extends Flavour {}\n\tstatic final class Melon extends Flavour {}\n\tstatic record Pantaloon(Flavour flavour, int i) {}\n\n}\n"}, "success");
    }

    public void testListOfPatterns_002() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\n\tpublic static void main(String... args) {\n\t\tObject o = new Pantaloon(new Licorice(), 12);\n\t\tswitch (o) {\n\t\tcase Pantaloon(Chartreuse _, int _), Pantaloon(Melon _, int _) : System.out.println(\"success\"); break;\n\t\tdefault: System.out.println(\"failure\"); break;\n\t\t}\n\t}\n\n\tstatic sealed abstract class Flavour permits Chartreuse, Orange, Licorice, Melon { }\n\tstatic final class Chartreuse extends Flavour {}\n\tstatic final class Orange extends Flavour {}\n\tstatic final class Licorice extends Flavour {}\n\tstatic final class Melon extends Flavour {}\n\tstatic record Pantaloon(Flavour flavour, int i) {}\n\n}\n"}, "failure");
    }

    public void testListOfPatterns_003() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\n\tpublic static void main(String... args) {\n\t\tObject o = new Pantaloon(new Melon(), 12);\n\t\tswitch (o) {\n\t\tcase Pantaloon(Chartreuse _, int _), Pantaloon(Melon _, int _) when 1 == 1 && 2 == 2: System.out.println(\"success\"); break;\n\t\tdefault: System.out.println(\"failure\"); break;\n\t\t}\n\t}\n\n\tstatic sealed abstract class Flavour permits Chartreuse, Orange, Licorice, Melon { }\n\tstatic final class Chartreuse extends Flavour {}\n\tstatic final class Orange extends Flavour {}\n\tstatic final class Licorice extends Flavour {}\n\tstatic final class Melon extends Flavour {}\n\tstatic record Pantaloon(Flavour flavour, int i) {}\n\n}\n"}, "success");
    }

    public void testListOfPatterns_004() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\n\tpublic static void main(String... args) {\n\t\tObject o = new Pantaloon(new Chartreuse(), 12);\n\t\tswitch (o) {\n\t\tcase Pantaloon(Chartreuse _, int _), Pantaloon(Melon _, int _) when 1 == 1 && 2 == 2 : System.out.println(\"success\"); break;\n\t\tdefault: System.out.println(\"failure\"); break;\n\t\t}\n\t}\n\n\tstatic sealed abstract class Flavour permits Chartreuse, Orange, Licorice, Melon { }\n\tstatic final class Chartreuse extends Flavour {}\n\tstatic final class Orange extends Flavour {}\n\tstatic final class Licorice extends Flavour {}\n\tstatic final class Melon extends Flavour {}\n\tstatic record Pantaloon(Flavour flavour, int i) {}\n\n}\n"}, "success");
    }

    public void testListOfPatterns_005() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\n\tpublic static void main(String... args) {\n\t\tObject o = new Pantaloon(new Licorice(), 12);\n\t\tswitch (o) {\n\t\tcase Pantaloon(Chartreuse _, int _), Pantaloon(Melon _, int _) when 1 == 1 && 2 == 2 : System.out.println(\"success\"); break;\n\t\tdefault: System.out.println(\"failure\"); break;\n\t\t}\n\t}\n\n\tstatic sealed abstract class Flavour permits Chartreuse, Orange, Licorice, Melon { }\n\tstatic final class Chartreuse extends Flavour {}\n\tstatic final class Orange extends Flavour {}\n\tstatic final class Licorice extends Flavour {}\n\tstatic final class Melon extends Flavour {}\n\tstatic record Pantaloon(Flavour flavour, int i) {}\n\n}\n"}, "failure");
    }

    public void testListOfPatterns_006() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\n\tpublic static void main(String... args) {\n\t\tString myString = \"asdf\";\n\t\tObject o = new Pantaloon(new Melon(), 12);\n\t\tswitch (o) {\n\t\tcase Pantaloon(Chartreuse _, int _), Pantaloon(Melon _, int _) when myString.length() == 4: System.out.println(\"success\"); break;\n\t\tdefault: System.out.println(\"failure\"); break;\n\t\t}\n\t}\n\n\tstatic sealed abstract class Flavour permits Chartreuse, Orange, Licorice, Melon { }\n\tstatic final class Chartreuse extends Flavour {}\n\tstatic final class Orange extends Flavour {}\n\tstatic final class Licorice extends Flavour {}\n\tstatic final class Melon extends Flavour {}\n\tstatic record Pantaloon(Flavour flavour, int i) {}\n\n}\n"}, "success");
    }

    public void testListOfPatterns_007() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\n\tpublic static void main(String... args) {\n\t\tString myString = \"asdf\";\n\t\tObject o = new Pantaloon(new Chartreuse(), 12);\n\t\tswitch (o) {\n\t\tcase Pantaloon(Chartreuse _, int _), Pantaloon(Melon _, int _) when myString.length() == 4: System.out.println(\"success\"); break;\n\t\tdefault: System.out.println(\"failure\"); break;\n\t\t}\n\t}\n\n\tstatic sealed abstract class Flavour permits Chartreuse, Orange, Licorice, Melon { }\n\tstatic final class Chartreuse extends Flavour {}\n\tstatic final class Orange extends Flavour {}\n\tstatic final class Licorice extends Flavour {}\n\tstatic final class Melon extends Flavour {}\n\tstatic record Pantaloon(Flavour flavour, int i) {}\n\n}\n"}, "success");
    }

    public void testListOfPatterns_008() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\n\tpublic static void main(String... args) {\n\t\tString myString = \"asdf\";\n\t\tObject o = new Pantaloon(new Licorice(), 12);\n\t\tswitch (o) {\n\t\tcase Pantaloon(Chartreuse _, int _), Pantaloon(Melon _, int _) when myString.length() == 4: System.out.println(\"success\"); break;\n\t\tdefault: System.out.println(\"failure\"); break;\n\t\t}\n\t}\n\n\tstatic sealed abstract class Flavour permits Chartreuse, Orange, Licorice, Melon { }\n\tstatic final class Chartreuse extends Flavour {}\n\tstatic final class Orange extends Flavour {}\n\tstatic final class Licorice extends Flavour {}\n\tstatic final class Melon extends Flavour {}\n\tstatic record Pantaloon(Flavour flavour, int i) {}\n\n}\n"}, "failure");
    }

    public void testTwoCasesWithRecordPatternsShouldNotDominateRegression() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\n\tpublic static void main(String... args) {\n\t\tObject o = new Pantaloon(new Chartreuse(), 12);\n\t\tswitch (o) {\n\t\tcase Pantaloon(Chartreuse _, int i) when true: System.out.println(\"success \" + i); break;\n\t\tcase Pantaloon(Melon _, int i) when true : System.out.println(\"success \" + i); break;\n\t\tdefault: System.out.println(\"failure\"); break;\n\t\t}\n\t}\n\n\tstatic sealed abstract class Flavour permits Chartreuse, Orange, Licorice, Melon { }\n\tstatic final class Chartreuse extends Flavour {}\n\tstatic final class Orange extends Flavour {}\n\tstatic final class Licorice extends Flavour {}\n\tstatic final class Melon extends Flavour {}\n\tstatic record Pantaloon(Flavour flavour, int i) {}\n\n}\n"}, "success 12");
    }

    public void testWhenAtWrongPlace() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  static void foo(Object o) {\n    switch (o) {\n      case String s when s != null, Integer i when i == 3, X x when x != null : System.out.println(\"Integer\");\n      default: System.out.println(\"Object\");\n    }\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tcase String s when s != null, Integer i when i == 3, X x when x != null : System.out.println(\"Integer\");\n\t            ^\nNamed pattern variables are not allowed here\n----------\n2. ERROR in X.java (at line 4)\n\tcase String s when s != null, Integer i when i == 3, X x when x != null : System.out.println(\"Integer\");\n\t              ^^^^^^^^^^^^^^\nSyntax error on token(s), misplaced construct(s)\n----------\n3. ERROR in X.java (at line 4)\n\tcase String s when s != null, Integer i when i == 3, X x when x != null : System.out.println(\"Integer\");\n\t                                      ^\nNamed pattern variables are not allowed here\n----------\n4. ERROR in X.java (at line 4)\n\tcase String s when s != null, Integer i when i == 3, X x when x != null : System.out.println(\"Integer\");\n\t                                        ^^^^^^^^^^^\nSyntax error on token(s), misplaced construct(s)\n----------\n5. ERROR in X.java (at line 4)\n\tcase String s when s != null, Integer i when i == 3, X x when x != null : System.out.println(\"Integer\");\n\t                                                       ^\nNamed pattern variables are not allowed here\n----------\n6. ERROR in X.java (at line 4)\n\tcase String s when s != null, Integer i when i == 3, X x when x != null : System.out.println(\"Integer\");\n\t                                                              ^\nx cannot be resolved to a variable\n----------\n");
    }

    public void testIllegalFallThrough() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  static void foo(Object o) {\n    switch (o) {\n      case String s, Integer i, X x when o != null : System.out.println(\"Integer\");\n      default: System.out.println(\"Object\");\n    }\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tcase String s, Integer i, X x when o != null : System.out.println(\"Integer\");\n\t            ^\nNamed pattern variables are not allowed here\n----------\n2. ERROR in X.java (at line 4)\n\tcase String s, Integer i, X x when o != null : System.out.println(\"Integer\");\n\t                       ^\nNamed pattern variables are not allowed here\n----------\n3. ERROR in X.java (at line 4)\n\tcase String s, Integer i, X x when o != null : System.out.println(\"Integer\");\n\t                            ^\nNamed pattern variables are not allowed here\n----------\n");
    }

    public void testInternalDomination_this() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  static void foo(Object o) {\n    switch (o) {\n    //  case Number _ : System.out.println(\"A Number\");\n      case Object _, Integer _, X _ when o != null : System.out.println(\"Integer\");\n      default: System.out.println(\"Object\");\n    }\n  }\n  public static void main(String [] args) {\n  \tfoo(\"\");\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\r\n\tcase Object _, Integer _, X _ when o != null : System.out.println(\"Integer\");\r\n\t               ^^^^^^^^^\nThis case label is dominated by one of the preceding case labels\n----------\n2. ERROR in X.java (at line 5)\r\n\tcase Object _, Integer _, X _ when o != null : System.out.println(\"Integer\");\r\n\t                          ^^^\nThis case label is dominated by one of the preceding case labels\n----------\n");
    }

    public void testInternalDomination_2() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  static void foo(Object o) {\n    switch (o) {\n    //  case Number _ : System.out.println(\"A Number\");\n      case Object _, Integer _, X _ when true : System.out.println(\"Integer\");\n      default: System.out.println(\"Object\");\n    }\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tcase Object _, Integer _, X _ when true : System.out.println(\"Integer\");\n\t               ^^^^^^^^^\nThis case label is dominated by one of the preceding case labels\n----------\n2. ERROR in X.java (at line 5)\n\tcase Object _, Integer _, X _ when true : System.out.println(\"Integer\");\n\t                          ^^^\nThis case label is dominated by one of the preceding case labels\n----------\n3. ERROR in X.java (at line 6)\n\tdefault: System.out.println(\"Object\");\n\t^^^^^^^\nSwitch case cannot have both unconditional pattern and default label\n----------\n");
    }

    public void testInternalDomination_3() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  static void foo(Object o) {\n    switch (o) {\n    //  case Number _ : System.out.println(\"A Number\");\n      case Object _, Integer _, X _  : System.out.println(\"Integer\");\n      default: System.out.println(\"Object\");\n    }\n  }\n  public static void main(String [] args) {\n  \tfoo(\"\");\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tcase Object _, Integer _, X _  : System.out.println(\"Integer\");\n\t               ^^^^^^^^^\nThis case label is dominated by one of the preceding case labels\n----------\n2. ERROR in X.java (at line 5)\n\tcase Object _, Integer _, X _  : System.out.println(\"Integer\");\n\t                          ^^^\nThis case label is dominated by one of the preceding case labels\n----------\n3. ERROR in X.java (at line 6)\n\tdefault: System.out.println(\"Object\");\n\t^^^^^^^\nSwitch case cannot have both unconditional pattern and default label\n----------\n");
    }

    public void testExternalDomination() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  static void foo(Object o) {\n    switch (o) {\n      case Number _ : System.out.println(\"A Number\");\n      case Integer _, String _  : System.out.println(\"Integer\");\n      default: System.out.println(\"Object\");\n    }\n  }\n  public static void main(String [] args) {\n  \tfoo(\"\");\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tcase Integer _, String _  : System.out.println(\"Integer\");\n\t     ^^^^^^^^^\nThis case label is dominated by one of the preceding case labels\n----------\n");
    }

    public void testExternalDomination_2() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  static void foo(Object o) {\n    switch (o) {\n      case Number a : System.out.println(\"A Number\");\n      case Integer _, String _  : System.out.println(\"Integer\");\n      default: System.out.println(\"Object\");\n    }\n  }\n  public static void main(String [] args) {\n  \tfoo(\"\");\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tcase Integer _, String _  : System.out.println(\"Integer\");\n\t     ^^^^^^^^^\nThis case label is dominated by one of the preceding case labels\n----------\n");
    }

    public void testExternalDomination_3() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  static void foo(Object o) {\n    switch (o) {\n      case Number _ : System.out.println(\"A Number\");\n      case X _, Integer _, String _  : System.out.println(\"Integer\");\n      default: System.out.println(\"Object\");\n    }\n  }\n  public static void main(String [] args) {\n  \tfoo(\"\");\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tcase X _, Integer _, String _  : System.out.println(\"Integer\");\n\t          ^^^^^^^^^\nThis case label is dominated by one of the preceding case labels\n----------\n");
    }

    public void testExternalDomination_3_1() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\n  static void foo(Object o) {\n    switch (o) {\n      case Number _ when o != null : System.out.println(\"A Number\");\n      case X _, Integer _, String _  : System.out.println(\"Multi\");\n      default: System.out.println(\"Object\");\n    }\n  }\n  public static void main(String [] args) {\n  \tfoo(\"\");\n  }\n}\n"}, "Multi\nObject");
    }

    public void testExternalDomination_4() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  static void foo(Object o) {\n    switch (o) {\n      case X _, Number _, String _  : System.out.println(\"Multi label\");\n      case Integer _ : System.out.println(\"A Integer\");\n      default: System.out.println(\"Object\");\n    }\n  }\n  public static void main(String [] args) {\n  \tfoo(\"\");\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tcase Integer _ : System.out.println(\"A Integer\");\n\t     ^^^^^^^^^\nThis case label is dominated by one of the preceding case labels\n----------\n");
    }

    public void testExternalDomination_4_1() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\n  static void foo(Object o) {\n    switch (o) {\n      case X _, Number _, String _  when o != null : System.out.println(\"Multi label\");\n      case Integer _ : System.out.println(\"A Integer\");\n      default: System.out.println(\"Object\");\n    }\n  }\n  public static void main(String [] args) {\n  \tfoo(\"\");\n  }\n}\n"}, "Multi label\nA Integer\nObject");
    }

    public void testNaming() throws Exception {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.testFiles = new String[]{"X.java", "public class X {\n  record Point (int x, int y) {}\n  static void foo(Object o) {\n    switch (o) {\n      case Integer _, Point(int x, int _), String _  : System.out.println(\"Integer\");\n      default: System.out.println(\"Object\");\n    }\n  }\n  public static void main(String [] args) {\n  \tfoo(\"\");\n  }\n}\n"};
        runner.expectedCompilerLog = "----------\n1. ERROR in X.java (at line 5)\n\tcase Integer _, Point(int x, int _), String _  : System.out.println(\"Integer\");\n\t                          ^\nNamed pattern variables are not allowed here\n----------\n";
        runner.javacTestOptions = AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacBug8348928;
        runner.runNegativeTest();
    }

    public void testGuard_0() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\n\tpublic static void main(String... args) {\n\t\tObject o = new Pantaloon(new Chartreuse(), 12);\n\t\tswitch (o) {\n\t\tcase Pantaloon(Chartreuse _, int _), Pantaloon(Melon _, int _) when o == null : System.out.println(\"success\"); break;\n\t\tdefault: System.out.println(\"default\"); break;\n\t\t}\n\t}\n\n\tstatic sealed abstract class Flavour permits Chartreuse, Orange, Licorice, Melon { }\n\tstatic final class Chartreuse extends Flavour {}\n\tstatic final class Orange extends Flavour {}\n\tstatic final class Licorice extends Flavour {}\n\tstatic final class Melon extends Flavour {}\n\tstatic record Pantaloon(Flavour flavour, int i) {}\n\n}\n"}, "default");
    }

    public void testGuard_2() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\n\tpublic static void main(String... args) {\n\t\tObject o = new Pantaloon(new Melon(), 12);\n\t\tswitch (o) {\n\t\tcase Pantaloon(Chartreuse _, int _), Pantaloon(Melon _, int _) when o == null : System.out.println(\"success\"); break;\n\t\tdefault: System.out.println(\"default\"); break;\n\t\t}\n\t}\n\n\tstatic sealed abstract class Flavour permits Chartreuse, Orange, Licorice, Melon { }\n\tstatic final class Chartreuse extends Flavour {}\n\tstatic final class Orange extends Flavour {}\n\tstatic final class Licorice extends Flavour {}\n\tstatic final class Melon extends Flavour {}\n\tstatic record Pantaloon(Flavour flavour, int i) {}\n\n}\n"}, "default");
    }

    public void testGuard_3() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\n\tpublic static void main(String... args) {\n\t\tObject o = new Pantaloon(new Chartreuse(), 12);\n\t\tswitch (o) {\n\t\tcase Pantaloon(Chartreuse _, int _), Pantaloon(Melon _, int _) when o != null : System.out.println(\"success\"); break;\n\t\tdefault: System.out.println(\"default\"); break;\n\t\t}\n\t}\n\n\tstatic sealed abstract class Flavour permits Chartreuse, Orange, Licorice, Melon { }\n\tstatic final class Chartreuse extends Flavour {}\n\tstatic final class Orange extends Flavour {}\n\tstatic final class Licorice extends Flavour {}\n\tstatic final class Melon extends Flavour {}\n\tstatic record Pantaloon(Flavour flavour, int i) {}\n\n}\n"}, "success");
    }

    public void testGuard_4() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\n\tpublic static void main(String... args) {\n\t\tObject o = new Pantaloon(new Melon(), 12);\n\t\tswitch (o) {\n\t\tcase Pantaloon(Chartreuse _, int _), Pantaloon(Melon _, int _) when o != null : System.out.println(\"success\"); break;\n\t\tdefault: System.out.println(\"default\"); break;\n\t\t}\n\t}\n\n\tstatic sealed abstract class Flavour permits Chartreuse, Orange, Licorice, Melon { }\n\tstatic final class Chartreuse extends Flavour {}\n\tstatic final class Orange extends Flavour {}\n\tstatic final class Licorice extends Flavour {}\n\tstatic final class Melon extends Flavour {}\n\tstatic record Pantaloon(Flavour flavour, int i) {}\n\n}\n"}, "success");
    }

    public void testFallThrough() {
        this.runConformTest(new String[]{"X.java", "sealed interface I permits A, B, C, D {}\nfinal class A implements I{}\nfinal class B implements I{}\nfinal class C implements I{}\nfinal class D implements I{}\npublic class X<T> {\n    public boolean foo(I r) {\n    \tboolean ret = false;\n    \tswitch (r) {\n    \tcase A _, B _ : case C _ : ret = true; break;\n    \t\tdefault : ret = false;\n    \t};\n    \treturn ret;\n    }\n    public static void main(String argv[]) {\n    \tSystem.out.println(new X<>().foo(new A()));\n    \tSystem.out.println(new X<>().foo(new B()));\n    \tSystem.out.println(new X<>().foo(new C()));\n    \tSystem.out.println(new X<>().foo(new D()));\n    }\n}\n"}, "true\ntrue\ntrue\nfalse");
    }

    public void testTypePattern() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static void main(String... args) {\n        Object o = new String();\n        switch (o) {\n        case String _, X _, Integer _ : System.out.println(\"success\"); break;\n        default: System.out.println(\"failure\"); break;\n        }\n    }\n}\n"}, "success");
    }

    public void testTypePattern_2() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static void main(String... args) {\n        Object o = new X();\n        switch (o) {\n        case String _, X _, Integer _ : System.out.println(\"success\"); break;\n        default: System.out.println(\"failure\"); break;\n        }\n    }\n}\n"}, "success");
    }

    public void testIssue2070() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public boolean foo(Object o) {\n    \treturn switch (o) {\n    \tcase Integer _, Integer[] _ -> true;\n    \t\tdefault -> false;\n    \t};\n    }\n    public static void main(String argv[]) {\n    \tSystem.out.println(new X().foo(new Object()));\n    }\n}\n"}, "false");
    }

    public void testIssue2956() {
        this.runConformTest(new String[]{"Main.java", "public class Main {\n    public sealed interface MyType {\n        record A() implements MyType {\n        }\n\n        record B(int value) implements MyType {\n        }\n\n        record C() implements MyType {\n        }\n    }\n\n    public static void main(String[] args) {\n        MyType myType = new MyType.A();\n        switch (myType) {\n            case MyType.A(), MyType.B(_) -> { System.out.println(\"A or B\");}\n            case MyType.C() -> {}\n        }\n    }\n}\n"}, "A or B");
    }

    public void testIssue2956_2() {
        this.runConformTest(new String[]{"Main.java", "public class Main {\n    public sealed interface MyType {\n        record A() implements MyType {\n        }\n\n        record B(int value) implements MyType {\n        }\n\n        record C() implements MyType {\n        }\n    }\n\n    public static void main(String[] args) {\n        MyType myType = new MyType.A();\n        switch (myType) {\n            case MyType.A()  ->  { System.out.println(\"A\");}\n            case MyType.B(_) ->  { System.out.println(\"B\");}\n            case MyType.C()  ->  { System.out.println(\"C\");}\n        }\n    }\n}\n"}, "A");
    }

    public void testIssue2956_3() {
        this.runConformTest(new String[]{"Main.java", "public class Main {\n    public sealed interface MyType {\n        record A() implements MyType {\n        }\n\n        record B(int value) implements MyType {\n        }\n\n        record C() implements MyType {\n        }\n    }\n\n    public static void main(String[] args) {\n        MyType myType = new MyType.A();\n        switch (myType) {\n            case MyType.B(_), MyType.A()  -> { System.out.println(\"A or B\");}\n            case MyType.C() -> {}\n        }\n    }\n}\n"}, "A or B");
    }

    public void testIssue3109() {
        this.runConformTest(new String[]{"Maybe.java", "import java.util.function.Function;\nimport java.util.function.Predicate;\n\npublic sealed interface Maybe<T>  {\n\n  static <T> Maybe<T> of(T value) {\n    return new Some<>(value);\n  }\n\n  static <T> Maybe<T> empty() {\n    return new None<>();\n  }\n\n  default Maybe<T> filter(Predicate<T> predicate){\n    return switch (this) {\n      case Some(T value) when predicate.test(value) -> this; // unsupported line with 4 errors\n      case Some(_), None<T> _ -> empty();\n    };\n  }\n\n  default Maybe<T> filter2(Predicate<T> predicate){\n    return switch (this) {\n      case Some(_), None<T> _ -> empty(); //also unsupported with 1 error\n    };\n  }\n  record Some<T>(T value) implements Maybe<T> {}\n  record None<T>() implements Maybe<T>{}\n}\n"}, "");
    }

    public void testIssue3318() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tstatic /* @NonNull */ Object foo(/*@NonNull */ Object o) {\n\t    switch (o) {\n\t        case String s:\n\t        default:\n\t        \tSystem.out.println();\n\t    }\n\t    return o;\n\t}\n}\nclass X2 {\n\tstatic /* @NonNull */ Object foo(/*@NonNull */ Object o) {\n\t    switch (o) {\n\t        case String s:\n\t        default:\n\t        \tSystem.out.println(s);\n\t    }\n\t    return o;\n\t}\n}\nclass X3 {\n\tstatic  Object foo( Object o) {\n\t    switch (o) {\n\t        case String _ :\n\t        default :\n\t        \tSystem.out.println();\n\t    }\n\t    return o;\n\t}\n}\nclass X4 {\n\tstatic /* @NonNull */ Object foo(/*@NonNull */ Object o) {\n\t    switch (o) {\n\t        case String s:\n\t        \tSystem.out.println();  // first println\n\t        default:\n\t        \tSystem.out.println();\n\t    }\n\t    return o;\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tcase String s:\n\t^^^^^^^^^^^^^\nIllegal fall-through from a case label pattern\n----------\n2. ERROR in X.java (at line 16)\n\tSystem.out.println(s);\n\t                   ^\ns cannot be resolved to a variable\n----------\n");
    }

    public void testIssue3320() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tstatic boolean guard(String prefix) {\n\t\tSystem.out.println(prefix + \" guard\");\n\t\treturn false;\n\t}\n\tpublic static void main(String [] args) {\n        Object o = new Object();\n\t    switch (o) {\n\t        case String _, Object _ when guard(\"First\") -> System.out.println(\"First case\");  // first println\n\t        case String _, Object _ when guard(\"Second\") -> System.out.println(\"Second case\");  // first println\n\t        default -> System.out.println(\"Default\");\n\t    }\n\t}\n}\n"}, "First guard\nSecond guard\nDefault");
    }

    public void testIssue4038() {
        this.runConformTest(new String[]{"Problem.java", "public class Problem {\n\n    record R(Object o)  {}\n\n    static void execute(R stmt) {\n        switch (stmt) {\n            case R(var _) -> {\n                while (cond(null)) {\n                    execute(null);\n                }\n            }\n        }\n    }\n\n    static boolean cond(Object object) {\n        return true;\n    }\n\n    public static void main(String[] args) {\n    \tSystem.out.println(\"012012345678\");\n    }\n}\n"}, "012012345678");
    }

    public void testIssue4038_2() {
        this.runConformTest(new String[]{"Problem.java", "public class Problem {\n\n    record R(Object o)  {}\n\n    static void execute(R stmt) {\n        switch (stmt) {\n            case R(Object _) -> {\n                while (cond(null)) {\n                    execute(null);\n                }\n            }\n        }\n    }\n\n    static boolean cond(Object object) {\n        return true;\n    }\n\n    public static void main(String[] args) {\n    \tSystem.out.println(\"012012345678\");\n    }\n}\n"}, "012012345678");
    }

    public void testIssue4038_3() {
        this.runConformTest(new String[]{"Problem.java", "public class Problem {\n\n    record R(Object o)  {}\n\n    static int execute(R stmt) {\n    \tint retVal = -1;\n        switch (stmt) {\n            case R(String _) -> {\n            \ttry {\n\t                while (cond(null)) {\n\t                    execute(null);\n\t                }\n                } catch(NullPointerException npe) {\n                    retVal = 654321;\n                   }\n                   return retVal;\n            }\n            default -> { return 123456; }\n        }\n    }\n\n    static boolean cond(Object object) {\n        return true;\n    }\n\n    public static void main(String[] args) {\n    \tSystem.out.println(execute(new R(\"Hello\")));\n    \tSystem.out.println(execute(new R(new Problem())));\n    }\n}\n"}, "654321\n123456");
    }
}

