/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.util.HashMap;
import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;

public class TextBlockTest
extends AbstractRegressionTest {
    public static Class<?> testClass() {
        return TextBlockTest.class;
    }

    public static Test suite() {
        return TextBlockTest.buildMinimalComplianceTestSuite(TextBlockTest.testClass(), 4096);
    }

    public TextBlockTest(String testName) {
        super(testName);
    }

    @Override
    protected Map<String, String> getCompilerOptions() {
        return this.getCompilerOptions(true);
    }

    protected Map<String, String> getCompilerOptions(boolean previewFlag) {
        Map<String, String> defaultOptions = super.getCompilerOptions();
        defaultOptions.put("org.eclipse.jdt.core.compiler.compliance", "15");
        defaultOptions.put("org.eclipse.jdt.core.compiler.source", "15");
        defaultOptions.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "15");
        defaultOptions.put("org.eclipse.jdt.core.compiler.problem.reportPreviewFeatures", "ignore");
        return defaultOptions;
    }

    @Override
    protected void runConformTest(String[] testFiles, String expectedOutput, Map<String, String> customOptions, String[] vmArguments) {
        this.runConformTest(testFiles, expectedOutput, customOptions, vmArguments, new AbstractRegressionTest.JavacTestOptions("-source 15 "));
    }

    @Override
    protected void runConformTest(String[] testFiles, String expectedOutput, Map<String, String> customOptions) {
        this.runConformTest(true, testFiles, null, expectedOutput, null, new AbstractRegressionTest.JavacTestOptions("-source 15"));
    }

    protected void runConformTest(boolean shouldFlushOutputDirectory, String[] testFiles, String[] classLibraries, Map<String, String> customOptions, String expectedCompilerLog, String expectedOutputString, String expectedErrorString, String[] vmarguments, AbstractRegressionTest.JavacTestOptions javacTestOptions) {
        this.runTest(shouldFlushOutputDirectory, testFiles, classLibraries, customOptions, false, null, false, expectedCompilerLog, false, vmarguments, expectedOutputString, expectedErrorString, javacTestOptions);
    }

    public void test001() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static String textb = \"\"\"\"\"\";\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(textb);\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tpublic static String textb = \"\"\"\"\"\";\n\t                               ^^\nSyntax error on token \"\"\"\", invalid AssignmentOperator\n----------\n");
    }

    public void test002() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static String textb = \"\"\" \"\"\";\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(textb);\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tpublic static String textb = \"\"\" \"\"\";\n\t                               ^^^\nSyntax error on token \"\" \"\", invalid AssignmentOperator\n----------\n");
    }

    public void test003() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static String textb = \"\"\"\n\";\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(textb);\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tpublic static String textb = \"\"\"\n\";\n\t                             ^^^^^\nText block is not properly closed with the delimiter\n----------\n");
    }

    public void test003a() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static String textb = \"\"\"\n\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(textb);\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tpublic static String textb = \"\"\"\n\n\t                             ^^^^\nText block is not properly closed with the delimiter\n----------\n");
    }

    public void test004() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static String textb = \"\"\"\nabc\\def\"\"\";\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(textb);\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tpublic static String textb = \"\"\"\nabc\\def\"\"\";\n\t                             ^^^^^^^^^\nInvalid escape sequence (valid ones are  \\b  \\t  \\n  \\f  \\r  \\\"  \\'  \\\\ )\n----------\n");
    }

    public void test005() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static String textb = \"\"\"\n\"\"\";\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(textb);\n\t}\n}\n"}, "", null);
    }

    public void test006() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static String textb = \"\"\"\nabc\\\\def\"\"\";\n\tpublic static void main(String[] args) {\n\t\tSystem.out.print(textb);\n\t}\n}\n"}, "abc\\def", null);
    }

    public void test006a() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static String textb = \"\"\"\n\\u007Babc\\\\def\"\"\";\n\tpublic static void main(String[] args) {\n\t\tSystem.out.print(textb);\n\t}\n}\n"}, "{abc\\def", null);
    }

    public void test007() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static String textb = \"\"\"\n    line 1\n    line 2\n  \n  line 3\"\"\";\n\tpublic static void main(String[] args) {\n\t\tSystem.out.print(textb);\n\t}\n}\n"}, "line 1\n  line 2\n\nline 3", null);
    }

    public void test008() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static String textb = \"\"\"\n    line 1\n    line 2\r  \r  line 3\"\"\";\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(textb);\n\t}\n}\n"}, "line 1\n  line 2\n\nline 3", null);
    }

    public void test008a() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static String textb = \"\"\"\n    line 1\n    line 2\r  \r  line 3\n\"\"\";\n\tpublic static void main(String[] args) {\n\t\tSystem.out.print(\"<\");\n\t\tSystem.out.print(textb);\n\t\tSystem.out.print(\">\");\n\t}\n}\n"}, "<    line 1\n    line 2\n\n  line 3\n>", null);
    }

    public void test009() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static String textb = \"\"\"\n\"abc-def\"\"\";\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(textb);\n\t}\n}\n"}, "\"abc-def", null);
    }

    public void test010() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static String textb = \"\"\"\n\"abc-def\\\"\"\"\";\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(textb);\n\t}\n}\n"}, "\"abc-def\"", null);
    }

    public void test011() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static String textb = \"\"\"\n\"abc\\\"\"\"def\"\"\";\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(textb);\n\t}\n}\n"}, "\"abc\"\"\"def", null);
    }

    public void test012() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static String textb = \"\"\"\n\\u0ba4\\u0bae\\u0bbf\\u0bb4\"\"\";\n\tpublic static String str = \"\\u0ba4\\u0bae\\u0bbf\\u0bb4\";\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(str.equals(textb));\n\t}\n}\n"}, "true", null);
    }

    public void test013() {
        this.runConformTest(new String[]{"X.java", "public class X {\nstatic String code = \"\"\"\n              public void print(Object o) {\n                  System.out.println(Objects.toString(o));\n              }\n              \"\"\";\n\tpublic static void main(String[] args) {\n\t\tSystem.out.print(code);\n\t}\n}\n"}, "public void print(Object o) {\n    System.out.println(Objects.toString(o));\n}", null);
    }

    public void test014() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tstatic String code = \"public void print(Object o) {\\n\" +\n              \"\"\"\n                  System.out.println(Objects.toString(o));\n              }\n              \"\"\";\n\tpublic static void main(String[] args) {\n\t\tSystem.out.print(code);\n\t}\n}\n"}, "public void print(Object o) {\n    System.out.println(Objects.toString(o));\n}", null);
    }

    public void test015() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tstatic String story = \"\"\"\n    \"When I use a word,\" Humpty Dumpty said,\n    in rather a scornful tone, \"it means just what I\n    choose it to mean - neither more nor less.\"\n    \"The question is,\" said Alice, \"whether you\n    can make words mean so many different things.\"\n    \"The question is,\" said Humpty Dumpty,\n    \"which is to be master - that's all.\"\"\";\n\tpublic static void main(String[] args) {\n\t\tSystem.out.print(story);\n\t}\n}\n"}, "\"When I use a word,\" Humpty Dumpty said,\nin rather a scornful tone, \"it means just what I\nchoose it to mean - neither more nor less.\"\n\"The question is,\" said Alice, \"whether you\ncan make words mean so many different things.\"\n\"The question is,\" said Humpty Dumpty,\n\"which is to be master - that's all.", null);
    }

    public void test016() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tstatic String html = \"\"\"\n              <html>\n                  <body>\n                      <p>Hello, world</p>\n                  </body>\n              </html>\"\"\";\n\tpublic static void main(String[] args) {\n\t\tSystem.out.print(html);\n\t}\n}\n"}, "<html>\n    <body>\n        <p>Hello, world</p>\n    </body>\n</html>", null);
    }

    public void test016a() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tstatic String html = \"\"\"\n              <html>\\r\\n                  <body>\\r\\n                      <p>Hello, world</p>\\r\\n                  </body>\\r\\n              </html>\\r\\n              \"\"\";\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(html);\n\t}\n}\n"}, "<html>\n                  <body>\n                      <p>Hello, world</p>\n                  </body>\n              </html>", null);
    }

    public void test016c() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tstatic String html = \"\"\"\n              <html>\n                  <body>\n                      <p>Hello, world</p>\n                  </body>\n              </html>\n              \"\"\";\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(html);\n\t}\n}\n"}, "<html>\n    <body>\n        <p>Hello, world</p>\n    </body>\n</html>", null);
    }

    public void test017() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tstatic String html = \"\"\"\n              <html>  \n                  <body>    \n                      <p>Hello, world</p>      \n                  </body>    \n              </html>  \n                   \"\"\";\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(html);\n\t}\n}\n"}, "<html>\n    <body>\n        <p>Hello, world</p>\n    </body>\n</html>", null);
    }

    public void test018() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tstatic String html = \"\"\"\n              <html>\\040\\040\n                  <body>\\040\\040\n                      <p>Hello, world</p>\\040\\040\\040\n                  </body>\\040\\040\n              </html>\"\"\";\n\tpublic static void main(String[] args) {\n\t\tSystem.out.print(html);\n\t}\n}\n"}, "<html>  \n    <body>  \n        <p>Hello, world</p>   \n    </body>  \n</html>", null);
    }

    public void test019() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(\"\"\"\n              <html>\\n                  <body>\\n                      <p>Hello, world</p>\\n                  </body>\\n              </html>\\n              \"\"\");\n\t}\n}\n"}, "<html>\n                  <body>\n                      <p>Hello, world</p>\n                  </body>\n              </html>", null);
    }

    public void test020() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tString html = \"\"\"\n              <html>\n                  <body>\n                      <p>Hello, world</p>\n                  </body>\n              </html>\n                  \"\"\";\n\t\tSystem.out.println(html);\n\t}\n}\n"}, "<html>\n    <body>\n        <p>Hello, world</p>\n    </body>\n</html>", null);
    }

    public void test021() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tString html = \"\"\"\n              <html>\n                  <body>\n                      <p>Hello, world</p>\n                  </body>\n              </html>\n                  \"\"\";\n       String s = html;\n\t\tSystem.out.println(s);\n\t}\n}\n"}, "<html>\n    <body>\n        <p>Hello, world</p>\n    </body>\n</html>", null);
    }

    public void test024() {
        this.runConformTest(true, new String[]{"Main.java", "@SuppressWarnings(\"preview\")\npublic class Main {\n    public static void main(String[] args) {\n\t\trunConformTest(\n\t\t\t\tnew String[] {\n\t\t\t\t\t\t\"XYZ.java\",\n\t\t\t\t\t\t\"\"\"\n\t\t\t\t\t\t\t\tpublic class XYZ {\n\t\t\t\t\t\t\t\t\tpublic static String textb = \\\"\"\"\n\t\t\t\t\t\t\t\t\t\t\tabc\\\\\\\"\"\"def\"  \n\t\t\t\t\t\t\t\t\t\t\t\t\\\"\"\";\n\t\t\t\t\t\t\t\t\tpublic static void main(String[] args) {\n\t\t\t\t\t\t\t\t\t\tSystem.out.println(textb);\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}\"\"\"\t\t\t\t}, \n\t\t\t\t\"\",\n\t\t\t\tnull,\n\t\t\t\tnew String[] {\"--enable-preview\"});\n    }\n\tprivate static void runConformTest(String[] strings, String text, Object object, String[] strings2) {\n\t\tSystem.out.println(strings[1]);\n\t}\n}"}, null, "public class XYZ {\n\tpublic static String textb = \"\"\"\n\t\t\tabc\\\"\"\"def\"\n\t\t\t\t\"\"\";\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(textb);\n\t}\n}", null, AbstractRegressionTest.JavacTestOptions.DEFAULT);
    }

    public void test025() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t\tpublic static String textb = \"\"\"\n\t\t\tabc\\def\"\"\";\n\t\tpublic static void main(String[] args) {\n\t\t\tSystem.out.println(textb);\n\t\t}\n\t}"}, "----------\n1. ERROR in X.java (at line 2)\n\tpublic static String textb = \"\"\"\n\t\t\tabc\\def\"\"\";\n\t                             ^^^^^^^^^^^^\nInvalid escape sequence (valid ones are  \\b  \\t  \\n  \\f  \\r  \\\"  \\'  \\\\ )\n----------\n", null, true, this.getCompilerOptions());
    }

    public void test027() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  public static void main (String[] args) {\n     String xyz = \n       \"\"\"\n         public class Switch {\n           public static void bar(int arg0) {\n             int arg1 = 0;\n             pointer: foo(\n               switch (0 + arg0) {\n                 case 1 -> 1;\n                 default -> {break p;}\\n\"\n               }\n             });\n             public static void foo(int arg0) {\n               bar(MyDay.SUNDAY);\n               }\n             }\\n\"\"\";  \n    System.out.println(xyz);\n  }\n}"}, "public class Switch {\n  public static void bar(int arg0) {\n    int arg1 = 0;\n    pointer: foo(\n      switch (0 + arg0) {\n        case 1 -> 1;\n        default -> {break p;}\n\"\n      }\n    });\n    public static void foo(int arg0) {\n      bar(MyDay.SUNDAY);\n      }\n    }", this.getCompilerOptions());
    }

    public void test028() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  public static void main (String[] args) {\n     String xyz = \n       \"\"\"\n         \\n\"\"\";  \n    System.out.println(xyz);\n  }\n}"}, "", this.getCompilerOptions());
    }

    public void test029() {
        this.runConformTest(new String[]{"Cls2.java", "@SuppressWarnings(\"preview\")\npublic class Cls2 {\n\tpublic static String str = \"\"\"\n\t\t\t   Hello Guru\t\n\t\t\t\t\n\t\t\t\"\"\";\n  public static void main (String[] args) {\n    System.out.println(str);\n  }\n}"}, "Hello Guru", this.getCompilerOptions());
    }

    public void testBug551948_1() {
        this.runConformTest(new String[]{"Cls2.java", "@SuppressWarnings(\"preview\")\npublic class Cls2 {\nstatic String text = \"\"\"\n            Lorem ipsum dolor sit amet, consectetur adipiscing \\\n            elit, sed do eiusmod tempor incididunt ut labore \\\n            et dolore magna aliqua.\\\n            \"\"\";\n  public static void main (String[] args) {\n    System.out.print(text);\n  }\n}"}, "Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.", this.getCompilerOptions());
    }

    public void testBug551948_2() {
        this.runConformTest(new String[]{"Cls2.java", "@SuppressWarnings(\"preview\")\npublic class Cls2 {\nstatic String noLastLF = \"\"\"\n    abc\n        def\\\n    ghi\"\"\";\n  public static void main (String[] args) {\n    System.out.print(noLastLF);\n  }\n}"}, "abc\n    defghi", this.getCompilerOptions());
    }

    public void testBug551948_3() {
        this.runConformTest(new String[]{"Cls2.java", "@SuppressWarnings(\"preview\")\npublic class Cls2 {\nstatic String python = \"\"\"\n    if x == True and \\\\\n        y == False\n    \"\"\";\n  public static void main (String[] args) {\n    System.out.print(python);\n  }\n}"}, "if x == True and \\\n    y == False", this.getCompilerOptions());
    }

    public void testBug551948_4() {
        this.runConformTest(new String[]{"Cls2.java", "@SuppressWarnings(\"preview\")\npublic class Cls2 {\nstatic String colors = \"\"\"\n    red   \\\n    green \\\n    blue  \\\n    orange\"\"\"; \n  public static void main (String[] args) {\n    System.out.print(colors);\n  }\n}"}, "red   green blue  orange", this.getCompilerOptions());
    }

    public void testBug551948_5() {
        this.runNegativeTest(new String[]{"Cls2.java", "@SuppressWarnings(\"preview\")\npublic class Cls2 {\nstatic String colors = \"\"\"\n    \\red   \n    \\green \n    \\blue  \n    \\orange\"\"\"; \n  public static void main (String[] args) {\n    System.out.print(colors);\n  }\n}"}, "----------\n1. ERROR in Cls2.java (at line 3)\n\tstatic String colors = \"\"\"\n    \\red   \n    \\green \n\t                       ^^^^^^^^^^^^^^^^^^^^^^\nInvalid escape sequence (valid ones are  \\b  \\t  \\n  \\f  \\r  \\\"  \\'  \\\\ )\n----------\n", null, true, this.getCompilerOptions(true));
    }

    public void testBug551948_6() {
        this.runConformTest(new String[]{"Cls2.java", "@SuppressWarnings(\"preview\")\npublic class Cls2 {\nstatic String str = \"A\\sline\\swith\\sspaces\";\n  public static void main (String[] args) {\n    System.out.print(str);\n  }\n}"}, "A line with spaces", this.getCompilerOptions());
    }

    public void testBug551948_7() {
        this.runConformTest(new String[]{"Cls2.java", "@SuppressWarnings(\"preview\")\npublic class Cls2 {\nstatic String colors = \"\"\"\n    red  \\s\n    green\\s\n    blue \\s\n    \"\"\";\n  public static void main (String[] args) {\n    System.out.print(colors);\n  }\n}"}, "red   \ngreen \nblue", this.getCompilerOptions());
    }

    public void testBug551948_8() {
        this.runConformTest(new String[]{"Cls2.java", "@SuppressWarnings(\"preview\")\npublic class Cls2 {\nstatic String s = \"\"\"\naaa\n\nbbb\n\n\nccc\"\"\";\n  public static void main (String[] args) {\n    System.out.print(s);\n  }\n}"}, "aaa\n\nbbb\n\n\nccc", this.getCompilerOptions());
    }

    public void testCompliances_1() {
        this.runConformTest(new String[]{"C.java", "@SuppressWarnings(\"preview\")\npublic class C {\n    public static void main(String argv[]) {\n    \tString textBlock = \"\"\"\n\n    \t\t\taa\"\"\";\n    \t System.out.print(compare(textBlock));\n    }\n    private static boolean compare(String textBlock) {\n    \tchar LF  = (char) 0x000A;\n        String str = \"\" + LF + \"aa\";\n        return textBlock.equals(str);\n    }\n}"}, "true", this.getCompilerOptions());
    }

    public void testCompliances_2() {
        this.runConformTest(new String[]{"C.java", "@SuppressWarnings(\"preview\")\npublic class C {\n    public static void main(String argv[]) {\n    \tString textBlock = \"\"\"\n\\n\\n\"\"\";\n    \t System.out.print(compare(textBlock));\n    }\n    private static boolean compare(String textBlock) {\n    \t char LF  = (char) 0x000A;\n        String str = \"\" + LF + LF + \"\";\n        return textBlock.equals(str);\n    }\n}"}, "true", this.getCompilerOptions());
    }

    public void testCompliances_3() {
        this.runConformTest(new String[]{"C.java", "@SuppressWarnings(\"preview\")\npublic class C {\n    public static void main(String argv[]) {\n    \t String textBlock = \"\"\"\n\u0015\n\"\"\";\n    \t System.out.print(textBlock);\n    \t System.out.print(compare(textBlock));\n    }\n    private static boolean compare(String textBlock) {\n    \t char LF  = (char) 0x000A;\n        String str = \"\" + '\\u0015' + LF + \"\";\n        return textBlock.equals(str.stripIndent());\n    }\n}"}, "true", this.getCompilerOptions());
    }

    public void testCompliances_4() {
        this.runConformTest(new String[]{"C.java", "@SuppressWarnings(\"preview\")\npublic class C {\n    public static void main(String argv[]) {\n    \t String textBlock = \"\"\"\nv\r\rvaa\"\"\";\n\tchar[] cs = textBlock.toCharArray();\n    for (char c : cs) {\n\t\t//System.out.print((int)c);\n\t\t//System.out.print(',');\n\t}\n    //System.out.println();\n    \t System.out.print(compare(textBlock));\n    }\n    private static boolean compare(String textBlock) {\n    \t char LF  = (char) 0x000A;\n        String str = \"v\" + LF + LF + '\\u0076' + \"aa\";\n        return textBlock.equals(str.stripIndent());\n    }\n}"}, "true", this.getCompilerOptions());
    }

    public void testCompliances_5() {
        this.runConformTest(new String[]{"C.java", "@SuppressWarnings(\"preview\")\npublic class C {\n    public static void main(String argv[]) {\n    \t String textBlock = \"\"\"\naa\f\f\"\"\";\n    \t System.out.print(compare(textBlock));\n    }\n    private static boolean compare(String textBlock) {\n    \t char LF  = (char) 0x000A;\n        String str = \"aa\" + LF + LF + \"\";\n        return textBlock.equals(str);\n    }\n}"}, "false", this.getCompilerOptions());
    }

    public void testCompliances_6() {
        this.runConformTest(new String[]{"C.java", "@SuppressWarnings(\"preview\")\npublic class C {\n    public static void main(String argv[]) {\n    \t String textBlock = \"\"\"\n\u0015\n\"\"\";\n    \t System.out.print(compare(textBlock));\n    }\n    private static boolean compare(String textBlock) {\n    \t char LF  = (char) 0x000A;\n        String str = \"\" + '\\u0015' + LF + \"\";\n        return textBlock.equals(str);\n    }\n}"}, "true", this.getCompilerOptions());
    }

    public void testCompliances_7() {
        this.runConformTest(new String[]{"C.java", "@SuppressWarnings(\"preview\")\npublic class C {\n    public static void main(String argv[]) {\n    \t String textBlock = \"\"\"\naav\n\"\"\";\n    \t System.out.print(compare(textBlock));\n    }\n    private static boolean compare(String textBlock) {\n    \t char LF  = (char) 0x000A;\n        String str = \"aa\" + '\\u0076' + LF + \"\";\n        return textBlock.equals(str.stripIndent());\n    }\n}"}, "true", this.getCompilerOptions());
    }

    public void testCompliances_8() {
        this.runConformTest(new String[]{"C.java", "@SuppressWarnings(\"preview\")\npublic class C {\n    public static void main(String argv[]) {\n    \t String textBlock = \"\"\"\n\\\"some\\\"\\n \\\"string\\\" \\n \\\"here\\\"\\n\"\"\";\n    \t System.out.print(textBlock.length());\n    }\n}"}, "26", this.getCompilerOptions());
    }

    public void testCompliances_9() {
        this.runConformTest(new String[]{"C.java", "@SuppressWarnings(\"preview\")\npublic class C {\n    public static void main(String argv[]) {\n    \t String textBlock = \"\"\"\nsome string ends with \\\"\"\"\\n\"\"\";\n    \t System.out.print(textBlock.length());\n    }\n}"}, "26", this.getCompilerOptions());
    }

    public void testCompliances_10() {
        this.runConformTest(new String[]{"C.java", "@SuppressWarnings(\"preview\")\npublic class C {\n    public static void main(String argv[]) {\n    \t String textBlock = \"\"\"\nsome string ends with \"\\\"\"\\n\"\"\";\n    \t System.out.print(textBlock.length());\n    }\n}"}, "26", this.getCompilerOptions());
    }

    public void testCompliances_11() {
        this.runConformTest(new String[]{"C.java", "@SuppressWarnings(\"preview\")\npublic class C {\n    public static void main(String argv[]) {\n    \t String textBlock = \"\"\"\nsome string ends with \"\"\\\"\\n\"\"\";\n    \t System.out.print(textBlock.length());\n    }\n}"}, "26", this.getCompilerOptions());
    }

    public void testCompliances_12() {
        this.runConformTest(new String[]{"C.java", "@SuppressWarnings(\"preview\")\npublic class C {\n    public static void main(String argv[]) {\n    \tString textBlock = \"\"\"\n\r\n    \t\t\taa\"\"\";\n    \t System.out.print(compare(textBlock));\n    }\n    private static boolean compare(String textBlock) {\n    \tchar LF  = (char) 0x000A;\n        String str = \"\" + LF + \"aa\";\n        return textBlock.equals(str);\n    }\n}"}, "true", this.getCompilerOptions());
    }

    public void testCompliances_13() {
        this.runConformTest(new String[]{"C.java", "@SuppressWarnings(\"preview\")\npublic class C {\n    public static void main(String argv[]) {\n    \tString textb = \"\"\"\n\\0\\1\\2\\3\\4\\5\\6\\7\\10\\11\\12\\13\\14\\15\\16\\17\\20\\21\\22\\23\\24\\25\\26\\27\\30\\31\\32\\33\\34\\35\\36\\37\\40\\41\\42\\43\\44\\45\\46\\47\\50\\51\\52\\53\\54\\55\\56\\57\\60\\61\\62\\63\\64\\65\\66\\67\\70\\71\\72\\73\\74\\75\\76\\77\\100\\101\\102\\103\\104\\105\\106\\107\\110\\111\\112\\113\\114\\115\\116\\117\\120\\121\\122\\123\\124\\125\\126\\127\\130\\131\\132\\133\\134\\135\\136\\137\\140\\141\\142\\143\\144\\145\\146\\147\\150\\151\\152\\153\\154\\155\\156\\157\\160\\161\\162\\163\\164\\165\\166\\167\\170\\171\\172\\173\\174\\175\\176\\177\\200\\201\\202\\203\\204\\205\\206\\207\\210\\211\\212\\213\\214\\215\\216\\217\\220\\221\\222\\223\\224\\225\\226\\227\\230\\231\\232\\233\\234\\235\\236\\237\\240\\241\\242\\243\\244\\245\\246\\247\\250\\251\\252\\253\\254\\255\\256\\257\\260\\261\\262\\263\\264\\265\\266\\267\\270\\271\\272\\273\\274\\275\\276\\277\\300\\301\\302\\303\\304\\305\\306\\307\\310\\311\\312\\313\\314\\315\\316\\317\\320\\321\\322\\323\\324\\325\\326\\327\\330\\331\\332\\333\\334\\335\\336\\337\\340\\341\\342\\343\\344\\345\\346\\347\\350\\351\\352\\353\\354\\355\\356\\357\\360\\361\\362\\363\\364\\365\\366\\367\\370\\371\\372\\373\\374\\375\\376\\377\"\"\";\n\t\tSystem.out.println(textb.length());\n\t\tfor (int i=0; i<=0xFF; i++) {\n            if (i != (int)textb.charAt(i)) {\n                System.out.println(\"Error in octal escape :\" + i);\n            }\n        }\n    }\n}"}, "256", this.getCompilerOptions());
    }

    public void testCompliances_14() {
        this.runConformTest(new String[]{"C.java", "@SuppressWarnings(\"preview\")\npublic class C {\n    public static void main(String argv[]) {\n    \tString textBlock = \"\"\"\r\n          This is a multi-line\n          message that is super-\n          exciting!\"\"\";\n    \t System.out.print(compare(textBlock));\n    }\n    private static boolean compare(String textBlock) {\n        String str = \"This is a multi-line\\n\" + \n\t\t\t\t\"message that is super-\\n\" + \n\t\t\t\t\"exciting!\";\n        return textBlock.equals(str);\n    }\n}"}, "true", this.getCompilerOptions());
    }

    public void testBug553252() {
        Map<String, String> defaultOptions = super.getCompilerOptions();
        HashMap<String, String> copy = new HashMap<String, String>(defaultOptions);
        copy.put("org.eclipse.jdt.core.compiler.compliance", "14");
        copy.put("org.eclipse.jdt.core.compiler.source", "14");
        copy.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "14");
        copy.put("org.eclipse.jdt.core.compiler.problem.enablePreviewFeatures", "disabled");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static String textb = \"\"\"\n\"\"\";\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(textb);\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tpublic static String textb = \"\"\"\n\"\"\";\n\t                             ^^^^^^^\nThe Java feature 'Text Blocks' is only available with source level 15 and above\n----------\n", null, true, new String[]{"-source 14 "}, copy);
    }

    public void testBug562460() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static String textb = \"\"\"\na\\sb\\sc\"\"\";\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(textb.equals(\"a b c\"));\n\t}\n}\n"}, "true", this.getCompilerOptions());
    }

    public void testCompliances_15() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static String textb = \"\"\"\n\t\\baa\"\"\";\n\tpublic static void main(String[] args) {\n\t\tprint(textb.toCharArray());\n\t}\n   private static void print(char[] val) {\n        for (char c : val) {\n            System.out.print((int)c + \",\");\n        }\n    }\n}\n"}, "8,97,97,", this.getCompilerOptions());
    }

    public void testCompliances_16() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static String textb = \"\"\"\n\t\\baa\"\"\";\n\tpublic static void main(String[] args) {\n\t\tprint(textb.toCharArray());\n\t}\n   private static void print(char[] val) {\n        for (char c : val) {\n            System.out.print((int)c + \",\");\n        }\n    }\n}\n"}, "8,97,97,", this.getCompilerOptions());
    }

    public void testCompliances_17() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static String textb = \"\"\"\n\\t\\baa\"\"\";\n\tpublic static void main(String[] args) {\n\t\tprint(textb.toCharArray());\n\t}\n   private static void print(char[] val) {\n        for (char c : val) {\n            System.out.print((int)c + \",\");\n        }\n    }\n}\n"}, "9,8,97,97,", this.getCompilerOptions());
    }

    public void testCompliances_18() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static String textb = \"\"\"\n\\013\\baa\"\"\";\n\tpublic static void main(String[] args) {\n\t\tprint(textb.toCharArray());\n\t}\n   private static void print(char[] val) {\n        for (char c : val) {\n            System.out.print((int)c + \",\");\n        }\n    }\n}\n"}, "11,8,97,97,", this.getCompilerOptions());
    }

    public void testBug565639_1() {
        this.runConformTest(true, new String[]{"X.java", "public class X {\n    static final String TEXT_BLOCK = \"\"\"\n              1\n              2\n              3\n              4\n              5\n            \"\"\";\n    public static void main(String[] args)  {\n        throw new RuntimeException(\"This is line 10.\");\n    }\n}\n"}, null, this.getCompilerOptions(), "", "", "Exception in thread \"main\" java.lang.RuntimeException: This is line 10.\n\tat X.main(X.java:10)", new String[]{"--enable-preview"}, new AbstractRegressionTest.JavacTestOptions("-source 14 --enable-preview"));
    }

    public void testBug565639_2() {
        this.runConformTest(true, new String[]{"X.java", "public class X {\n    public static void main(String[] args)  {\n    \tString TEXT_BLOCK = \"\"\"\n              1\n              2\n              3\n              4\n              5\n            \"\"\";\n        throw new RuntimeException(\"This is line 10.\");\n    }\n}\n"}, null, this.getCompilerOptions(), "", "", "Exception in thread \"main\" java.lang.RuntimeException: This is line 10.\n\tat X.main(X.java:10)", new String[]{"--enable-preview"}, new AbstractRegressionTest.JavacTestOptions("-source 14 --enable-preview"));
    }

    public void testBug565639_3() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    public static void main(String[] args)  {\n    \tString TEXT_BLOCK = \"\"\"\n              1\n              2\n              3\n              4\n              5\n            \"\"\"\";\n        throw new RuntimeException(\"This is line 10.\");\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\t\"\"\"\";\n\t   ^^\nString literal is not properly closed by a double-quote\n----------\n");
    }

    public void testBug565639_4() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    public static void main(String[] args)  {\n    \tString TEXT_BLOCK = \"\"\"\n              1\n              2\n              3\n              4\n              5\n            \"\"\"\"\";\n        throw new RuntimeException(\"This is line 10.\");\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\t\"\"\"\"\";\n\t   ^^\nSyntax error on token \"\"\"\", delete this token\n----------\n");
    }

    public void testBug565639_5() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    public static void main(String[] args)  {\n    \tString TEXT_BLOCK = \"\"\"\n              1\n              2\n              3\n              4\n              5\n            \\\"\"\"\"\"\";\n        throw new RuntimeException(\"This is line 10.\");\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\t\\\"\"\"\"\"\";\n\t     ^^\nSyntax error on token \"\"\"\", delete this token\n----------\n");
    }

    public void testBug565639_6() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static void main(String[] args)  {\n    \tString TEXT_BLOCK = \"\"\"\n              1\n              2\n              3\n              4\n              \\\"\"\"\n              \"\"\";\n        System.out.println(TEXT_BLOCK);\n    }\n}\n"}, "1\n2\n3\n4\n\"\"\"", this.getCompilerOptions(), new String[]{"--enable-preview"});
    }

    public void testBug575953() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static void main(String[] args)  {\n    \tString TEXT_BLOCK = \"\"\"\n           public class A {\n               public void foo() {\\s\n                   String k = \\\"\"\"\n                       abcdefg\n                       \\\"\"\"\n                   System.out.pri\\\n           ntln(\"abc\");\\s\n               }\n           }\\\n           \"\"\";\n        System.out.println(TEXT_BLOCK);\n    }\n}\n"}, "public class A {\n    public void foo() { \n        String k = \"\"\"\n            abcdefg\n            \"\"\"\n        System.out.println(\"abc\"); \n    }\n}", this.getCompilerOptions(), new String[]{"--enable-preview"});
    }

    public void testBug578649_1() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static void main(String[] args) {\n        System.out.println(\"\"\"\n        <record>\n          <value field=\\\"NAME2\\\">b\\tc</value>\n          <value field=\\\"NAME1\\\">a\\tb</value>\n        </record>\n        \"\"\");\n    }\n}\n"}, "<record>\n  <value field=\"NAME2\">b\tc</value>\n  <value field=\"NAME1\">a\tb</value>\n</record>", this.getCompilerOptions());
    }

    public void testBug578649_2() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static void main(String[] args) {\n        System.out.println(\"\"\"\n        123\\b45\n        \"\"\");\n    }\n}\n"}, "123\b45", this.getCompilerOptions());
    }

    public void test016b() {
        String text = "<html>\n    <body>\n      <p>Hello, world</p>\n    </body>\n  </html>";
        this.runConformTest(new String[]{"X.java", "public class X {\n\tstatic String html = \"\"\"\n" + text + "\\n\"\"\";\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(html);\n\t}\n}\n"}, text.stripIndent().translateEscapes(), null, new String[]{"--enable-preview"});
    }

    public void test022() {
        String text = "abc\\\\def";
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static String textb = \"\"\"\n" + text + "\"\"\";\n\tpublic static void main(String[] args) {\n\t\tSystem.out.print(textb);\n\t}\n}\n"}, text.translateEscapes(), null, new String[]{"--enable-preview"});
    }

    public void test023() {
        String text = "abc\\\"\"\"def\"  ";
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static String textb = \"\"\"\n" + text + "\"\"\";\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(textb);\n\t}\n}\n"}, text.translateEscapes().stripIndent(), null, new String[]{"--enable-preview"});
    }

    public void testIssue544_1() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static void main(String argv[]) {\n      String outer = \"\"\"\n                String inner = \\\"\"\"\n                       \\\"\"\";\"\"\";\n      System.out.println(outer.length());\n    }\n}\n"}, "30", this.getCompilerOptions());
    }

    public void testIssue544_2() {
        this.runConformTest(new String[]{"X.java", "\t\t\t\t\tpublic class X {\n\t\t\t\t\t  public static void main(String argv[]) {\n\t\t\t\t\t  String outer = \"\"\"\nString text = \\\"\"\"\n          String text = \\\"\"\"\n                  String text = \\\"\"\"\n                          A text block inside a text block at level 3\n                      \\\"\"\";\n              \\\"\"\";\n      \\\"\"\";\"\"\";\n  System.out.println(outer.equals(\n              \"String text = \\\"\\\"\\\"\\n\" +\n              \"          String text = \\\"\\\"\\\"\\n\" +\n              \"                  String text = \\\"\\\"\\\"\\n\" +\n              \"                          A text block inside a text block at level 3\\n\" +\n              \"                      \\\"\\\"\\\";\\n\" +\n              \"              \\\"\\\"\\\";\\n\" +\n              \"      \\\"\\\"\\\";\"\n              ));\n\t\t\t\t\t}\n\t\t\t\t\t}"}, "true", this.getCompilerOptions());
    }

    public void testIssue544_3() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static void main(String argv[]) {\n        String s = \"\"\"\n\"\"\";\n        System.out.println(compare(s));\n    }\n    private static boolean compare(String s) {\n        return s.equals(\"\");\n    }\n}\n"}, "true", this.getCompilerOptions());
    }

    public void testIssue544_4() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static void main(String argv[]) {\n        String s = \"\"\"\nsome newline\nstring.\"\"\";\n        System.out.println(compare(s));\n    }\n    private static boolean compare(String s) {\n        return s.equals(\"\"\"\nsome newline\nstring.\"\"\");\n    }\n}\n"}, "true", this.getCompilerOptions());
    }

    public void testIssue4129() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static void main(String[] args)\n    {\n        System.out.println(\"\"\"\n            A \\\\\\\"-\\\\\\\" B\"\"\");\n        System.out.println(\"\"\"\n            \\u0041 \\\\\\\"-\\\\\\\" B\"\"\");\n    }\n}\n"}, "A \\\"-\\\" B\nA \\\"-\\\" B");
    }

    public void testIssue4153() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static void main(String argv[]) {\n    \tString text = \\u0022\"\\u0022\n        Hello\"\"\";\n       \n        System.out.println(text);\n    }\n}\n"}, "Hello");
    }

    public void testBug561978() {
        this.runConformTest(true, new String[]{"X.java", "/*  1 */ public class X {\n/*  2 */\n/*  3 */     public static void main(String[] args) {\n/*  4 */\n/*  5 */         String text = \"\"\"\n                     Lorem ipsum dolor sit amet, consectetur adipiscing \\\n                     elit, sed do eiusmod tempor incididunt ut labore \\\n                     et dolore magna aliqua.\\\n                     \"\"\";\n/* 10 */\n/* 11 */         \tthrow new RuntimeException(\"This is line 11.\");\n/* 12 */    }\n/* 13 */ }\n"}, null, this.getCompilerOptions(), "", "", "Exception in thread \"main\" java.lang.RuntimeException: This is line 11.\n\tat X.main(X.java:11)", new String[]{"--enable-preview"}, new AbstractRegressionTest.JavacTestOptions("-source 14 --enable-preview"));
    }

    public void testBug570719() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\n\t\tSystem.out.println(\"\"\"\n\t\t\t\ttext \\s\\\n\t\t\t\tblock\n\t\t\t\t\"\"\");\n\n\t\tSystem.out.println(\"\"\"\n\t\t\t\ttext \\s\n\t\t\t\tblock\\\n\t\t\t\t!!!\n\t\t\t\t\"\"\");\n\n\t\tSystem.out.println(\"\"\"\n\t\t\t\ttext \\\n\t\t\t\tblock\n\t\t\t\t\"\"\");\n\n\t\tSystem.out.println(\"\"\"\n\t\t\t\ttext \\\n\t\t\t\tblock \\s\n\t\t\t\t!!!\n\t\t\t\t\"\"\");\n\t\tSystem.out.println(\"Done\");\n\t}\n}\n\n"}, "text  block\n\ntext  \nblock!!!\n\ntext block\n\ntext block  \n!!!\n\nDone");
    }
}

