/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;

public class TryStatement9Test
extends AbstractRegressionTest {
    public TryStatement9Test(String name) {
        super(name);
    }

    public static Test suite() {
        return TryStatement9Test.buildMinimalComplianceTestSuite(TryStatement9Test.testClass(), 64);
    }

    public void testBug488569_001() {
        this.runConformTest(new String[]{"X.java", "import java.io.Closeable;\nimport java.io.IOException;\n\nclass Y implements Closeable {\n        @Override\n        public void close() throws IOException {\n                // nothing\n        }\n}\npublic class X {\n\n        public void foo() throws IOException {\n             final Y y1 = new Y();\n             try (y1) { \n            \t //\n             }\n        } \n        public static void main(String[] args) {\n\t\t\tSystem.out.println(\"Done\");\n\t\t}\n} \n"}, "Done");
    }

    public void testBug488569_002() {
        this.runConformTest(new String[]{"X.java", "import java.io.Closeable;\nimport java.io.IOException;\n\nclass Y implements Closeable {\n        @Override\n        public void close() throws IOException {\n                // nothing\n        }\n}\npublic class X {\n\n        public void foo() throws IOException {\n             final Y y1 = new Y();\n             try (y1;) { \n            \t //\n             }\n        } \n        public static void main(String[] args) {\n\t\t\tSystem.out.println(\"Done\");\n\t\t}\n} \n"}, "Done");
    }

    public void testBug488569_003() {
        this.runConformTest(new String[]{"X.java", "import java.io.Closeable;\nimport java.io.IOException;\n\nclass Y implements Closeable {\n        @Override\n        public void close() throws IOException {\n                // nothing\n        }\n}\npublic class X {\n\n        public void foo() throws IOException {\n             final Y y1 = new Y();\n             final Y y2 = new Y();\n             try (y1; y2) { \n            \t //\n             }\n        } \n        public static void main(String[] args) {\n\t\t\tSystem.out.println(\"Done\");\n\t\t}\n} \n"}, "Done");
    }

    public void testBug488569_004() {
        this.runConformTest(new String[]{"X.java", "import java.io.Closeable;\nimport java.io.IOException;\n\nclass Y implements Closeable {\n        @Override\n        public void close() throws IOException {\n                // nothing\n        }\n}\npublic class X {\n\n        public void foo() throws IOException {\n             final Y y1 = new Y();\n             try (y1; final Y y2 = new Y()) { \n            \t //\n             }\n        } \n        public static void main(String[] args) {\n\t\t\tSystem.out.println(\"Done\");\n\t\t}\n} \n"}, "Done");
    }

    public void testBug488569_005() {
        this.runConformTest(new String[]{"X.java", "import java.io.Closeable;\nimport java.io.IOException;\n\nclass Y implements Closeable {\n        @Override\n        public void close() throws IOException {\n                // nothing\n        }\n}\npublic class X {\n\n        public void foo() throws IOException {\n             final Y y1 = new Y();\n             try (final Y y = new Y(); y1; final Y y2 = new Y()) { \n            \t //\n             }\n        } \n        public static void main(String[] args) {\n\t\t\tSystem.out.println(\"Done\");\n\t\t}\n} \n"}, "Done");
    }

    public void testBug488569_006() {
        this.runConformTest(new String[]{"X.java", "import java.io.Closeable;\nimport java.io.IOException;\n\npublic class X { \n    public void foo() throws IOException {\n         Y y1 = new Y();\n         try(y1) { \n             return;\n         }\n    } \n}  \n\nclass Y implements Closeable {\n\t\tfinal int x = 10;\n        @Override\n        public void close() throws IOException {\n                // nothing\n        }\n}"}, "");
    }

    public void testBug488569_007() {
        this.runNegativeTest(new String[]{"X.java", "import java.io.Closeable;\nimport java.io.IOException;\n\nclass Y implements Closeable {\n        @Override\n        public void close() throws IOException {\n                // nothing\n        }\n}\npublic class X {\n\n        public void foo() throws IOException {\n             Y y1 = new Y();\n             y1 = new Y();\n             try (y1) { \n            \t //\n             }\n        } \n        public static void main(String[] args) {\n\t\t\tSystem.out.println(\"Done\");\n\t\t}\n}"}, "----------\n1. ERROR in X.java (at line 14)\n\ty1 = new Y();\n\t^^\nLocal variable y1 used as a resource in a try with resources statement is required to be final or effectively final\n----------\n2. WARNING in X.java (at line 14)\n\ty1 = new Y();\n\t^^^^^^^^^^^^\nResource leak: 'y1' is not closed at this location\n----------\n3. ERROR in X.java (at line 15)\n\ttry (y1) { \n\t     ^^\nLocal variable y1 used as a resource in a try with resources statement is required to be final or effectively final\n----------\n");
    }

    public void testBug488569_008() {
        this.runNegativeTest(new String[]{"X.java", "import java.io.Closeable;\nimport java.io.IOException;\n\nclass Y implements Closeable {\n        @Override\n        public void close() throws IOException {\n                // nothing\n        }\n}\npublic class X {\n\n        public void foo() throws IOException {\n             try (y1; Y y1 = new Y()) { \n            \t //\n             }\n        } \n        public static void main(String[] args) {\n\t\t\tSystem.out.println(\"Done\");\n\t\t}\n}"}, "----------\n1. ERROR in X.java (at line 13)\n\ttry (y1; Y y1 = new Y()) { \n\t     ^^\ny1 cannot be resolved\n----------\n");
    }

    public void testBug488569_009() {
        this.runNegativeTest(new String[]{"X.java", "import java.io.Closeable;\nimport java.io.IOException;\n\nclass Y implements Closeable {\n        @Override\n        public void close() throws IOException {\n                // nothing\n        }\n}\npublic class X {\n\n        public void foo() throws IOException {\n             try (Y y1 = new Y(); y1) { \n            \t //\n             }\n        } \n        public static void main(String[] args) {\n\t\t\tSystem.out.println(\"Done\");\n\t\t}\n}"}, "----------\n1. WARNING in X.java (at line 13)\n\ttry (Y y1 = new Y(); y1) { \n\t                     ^^\nDuplicate resource reference y1\n----------\n");
    }

    public void testBug488569_010() {
        this.runNegativeTest(new String[]{"X.java", "import java.io.Closeable;\nimport java.io.IOException;\n\nclass Y implements Closeable {\n        @Override\n        public void close() throws IOException {\n                // nothing\n        }\n}\npublic class X {\n\n        public void foo() throws IOException {\n             Y y1 = new Y();\n             try (y1; y1) { \n            \t //\n             }\n        } \n        public static void main(String[] args) {\n\t\t\tSystem.out.println(\"Done\");\n\t\t}\n}"}, "----------\n1. WARNING in X.java (at line 14)\n\ttry (y1; y1) { \n\t         ^^\nDuplicate resource reference y1\n----------\n");
    }

    public void testBug488569_011() {
        this.runConformTest(new String[]{"X.java", "import java.io.Closeable;\nimport java.io.IOException;\n\nclass Y implements Closeable {\n        @Override\n        public void close() throws IOException {\n                // nothing\n        }\n}\npublic class X {\n\n        public void foo() throws IOException {\n             try (Y y1 = new Y();y1) { \n            \t //\n             }\n        } \n        public static void main(String[] args) {\n\t\t\tSystem.out.println(\"Done\");\n\t\t}\n} \n"}, "Done");
    }

    public void testBug488569_012() {
        this.runConformTest(new String[]{"X.java", "import java.io.Closeable;\nimport java.io.IOException;\n\nclass Y implements Closeable {\n        @Override\n        public void close() throws IOException {\n                // nothing\n        }\n}\npublic class X {\n\n        public void foo() throws IOException {\n             Y y = new Y();\n             try (Y y1 = new Y();y;y1) { \n            \t //\n             }\n        } \n        public static void main(String[] args) {\n\t\t\tSystem.out.println(\"Done\");\n\t\t}\n} \n"}, "Done");
    }

    public void testBug488569_013() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static void main(String [] args) throws Exception {\n    \tZ z1 = new Z();\n        try (Y y = new Y();z1;y) {\n        }\n    }  \n}\nclass Y implements AutoCloseable {\n\tpublic void close() throws Exception {\n\t\tSystem.out.println(\"Y CLOSE\");\n\t}\n}\n\nclass Z implements AutoCloseable {\n\tpublic void close() throws Exception {\n\t\tSystem.out.println(\"Z CLOSE\");\n\t}\n}\n"}, "Y CLOSE\nZ CLOSE\nY CLOSE");
    }

    public void testBug488569_014() {
        this.runNegativeTest(new String[]{"X.java", "import java.io.IOException;\n\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tY y1 = new Y();\t\t \t\t \n\t\ttry (y1)  {\n\t\t\tSystem.out.println(\"In Try\");\n\t\t} finally {\n\t\t}\n\t}\n}\n   \nclass Y implements AutoCloseable {\n\tpublic void close() throws IOException {\n\t\tSystem.out.println(\"Closed\");\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 6)\n\ttry (y1)  {\n\t     ^^\nUnhandled exception type IOException thrown by automatic close() invocation on y1\n----------\n");
    }

    public void testBug488569_015() {
        this.runConformTest(new String[]{"X.java", "import java.io.IOException;\n\npublic class X {\n\tfinal Y y = new Y();\n\tpublic static void main(String[] args) {\n\t\tnew X().foo();\n\t}\n\tpublic void foo() {\n\t\ttry (y)  {\n\t\t\tSystem.out.println(\"In Try\");\n\t\t} catch (IOException e) {\n\t\t\te.printStackTrace();\n\t\t}\n\t\tfinally {  \n\t\t}  \n\t\t//y1 = new Y();\t \n\t} \n} \n   \nclass Y implements AutoCloseable {\n\tpublic void close() throws IOException {\n\t\tSystem.out.println(\"Closed\");\n\t}\n}\n"}, "In Try\nClosed");
    }

    public void testBug488569_016() {
        this.runConformTest(new String[]{"X.java", "import java.io.IOException;\n\npublic class X {\n\tfinal Y y = null;\n\tpublic static void main(String[] args) {\n\t\tnew X().foo();\n\t}\n\tpublic void foo() {\n\t\ttry (y)  {\n\t\t\tSystem.out.println(\"In Try\");\n\t\t} catch (IOException e) {\n\t\t\te.printStackTrace();\n\t\t}\n\t\tfinally {  \n\t\t}  \n\t} \n} \n   \nclass Y implements AutoCloseable {\n\tpublic void close() throws IOException {\n\t\tSystem.out.println(\"Closed\");\n\t}\n}\n"}, "In Try");
    }

    public void testBug488569_017() {
        this.runConformTest(new String[]{"X.java", "import java.io.IOException;\n\nclass Z {\n\tfinal Y yz = new Y();\n}\npublic class X extends Z {\n\tfinal Y y2 = new Y();\n\t\n\tpublic void foo() {\n\t\ttry (super.yz; y2)  {\n\t\t\tSystem.out.println(\"In Try\");\n\t\t} catch (IOException e) {\n\t\t\t\n\t\t}finally { \n\t\t}\n\t}\n\tpublic static void main(String[] args) {\n\t\tnew X().foo();\n\t}\n}\nclass Y implements AutoCloseable {\n\t@Override\n\tpublic void close() throws IOException {\n\t\tSystem.out.println(\"Closed\");\n\t} \n}  \n"}, "In Try\nClosed\nClosed");
    }

    public void testBug488569_018() {
        this.runNegativeTest(new String[]{"X.java", "import java.io.IOException;\n\nclass Z {\n\t Y yz = new Y();\n}\npublic class X extends Z {\n\t Y y2 = new Y();\n\t\n\tpublic void foo() {\n\t\ttry (this.y2; super.yz;y2)  {  \n\t\t\tSystem.out.println(\"In Try\");\n\t\t} catch (IOException e) {\t\t\t  \n\t\t}\n\t}\n\tpublic static void main(String[] args) {\n\t\tnew X().foo();\n\t}\n}\nclass Y implements AutoCloseable {\n\t@Override\n\tpublic void close() throws IOException {\n\t\tSystem.out.println(\"Closed\");\n\t} \n}"}, "----------\n1. ERROR in X.java (at line 10)\n\ttry (this.y2; super.yz;y2)  {  \n\t          ^^\nField y2 used as a resource in a try with resources statement must be declared final\n----------\n2. ERROR in X.java (at line 10)\n\ttry (this.y2; super.yz;y2)  {  \n\t                    ^^\nField yz used as a resource in a try with resources statement must be declared final\n----------\n3. ERROR in X.java (at line 10)\n\ttry (this.y2; super.yz;y2)  {  \n\t                       ^^\nField y2 used as a resource in a try with resources statement must be declared final\n----------\n");
    }

    public void testBug488569_019() {
        this.runNegativeTest(new String[]{"X.java", "import java.io.IOException;\n\nclass Z {\n\t final Y yz = new Y();\n}\npublic class X extends Z {\n\tfinal  Y y2 = new Y();\n\t\n\t Y bar() {\n\t\t return new Y();\n\t }\n\tpublic void foo() {\n\t\tY y3 = new Y();\n\t\ttry (y3; y3;super.yz;super.yz;this.y2;)  {  \n\t\t\tSystem.out.println(\"In Try\");\n\t\t} catch (IOException e) {\t\t\t  \n\t\t} \n\t}\n\tpublic static void main(String[] args) {\n\t\tnew X().foo();\n\t}\n}\nclass Y implements AutoCloseable {\n\t@Override\n\tpublic void close() throws IOException {\n\t\tSystem.out.println(\"Closed\");\n\t}  \n}  \n"}, "----------\n1. WARNING in X.java (at line 14)\n\ttry (y3; y3;super.yz;super.yz;this.y2;)  {  \n\t         ^^\nDuplicate resource reference y3\n----------\n2. WARNING in X.java (at line 14)\n\ttry (y3; y3;super.yz;super.yz;this.y2;)  {  \n\t                     ^^^^^^^^\nDuplicate resource reference super.yz\n----------\n");
    }

    public void testBug488569_020() {
        this.runConformTest(new String[]{"X.java", "import java.io.IOException;\n\npublic class X {\n     final Z y2 = new Z();\n     public static void main(String[] args) throws Exception {\n          X t = new X();\n          try (t.y2) {     \n          }          \n     }  \n}\n\nclass Z implements AutoCloseable {\n     @Override\n     public void close() throws IOException {\n          System.out.println(\"Done\");\n     }\n} \n"}, "Done");
    }

    public void testBug488569_021() {
        this.runNegativeTest(new String[]{"X.java", "import java.io.IOException;\n\npublic class X {\n     final Z z = new Z();\n     public X() {\n          try(this.z) {\n               \n          }\n     }\n}\n\nclass Z implements AutoCloseable {\n     @Override\n     public void close() throws IOException {\n          System.out.println(\"Closed\");\n     } \n}  \n"}, "----------\n1. ERROR in X.java (at line 6)\n\ttry(this.z) {\n\t    ^^^^^^\nUnhandled exception type IOException thrown by automatic close() invocation on z\n----------\n");
    }

    public void testBug577128_1() {
        this.runConformTest(new String[]{"X.java", "import java.io.IOException;\npublic class X implements AutoCloseable {\n\tprivate void release() {\n\t\tX cl = new X();\n\t\ttry (this;cl) {} \n        \tcatch (IOException e) {\n        }\n\t}\n\tpublic static void main(String[] args) {\n\t\tX cl = new X();\n\t\tcl.release();\n\t}\n\t@Override\n\tpublic void close() throws IOException {\n\t\tSystem.out.println(\"close() call\");\n\t}\n}\n"}, "close() call\nclose() call");
    }

    public void testGH1825() {
        this.runNegativeTest(new String[]{"X.java", "import java.io.*;\nclass X {\n\tprotected X read() throws IOException {\n\t\tInputStream is = null;\n\n\t\ttry (InputStream ){\n\t\t}\n\t\treturn null;\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\ttry (InputStream ){\n\t     ^^^^^^^^^^^\nInputStream cannot be resolved to a variable\n----------\n");
    }

    public void testIssue3841() {
        this.runNegativeTest(new String[]{"X.java", "import java.io.IOException;\n\nclass Flags {\n\tstatic final boolean DEBUG = false;\n}\n\nclass Z {\n\tY yz = new Y();\n}\n\npublic class X extends Z {\n\tY y2 = new Y();\n\n\tpublic void foo() {\n\t\tif (Flags.DEBUG) {\n\t\t\ttry (this.y2) {\n\t\t\t\tSystem.out.println(\"In Try\");\n\t\t\t} catch (IOException e) {\n\t\t\t}\n\t\t}\n\t}\n\n\tpublic static void main(String[] args) {\n\t\tnew X().foo();\n\t}\n}\n\nclass Y implements AutoCloseable {\n\t@Override\n\tpublic void close() throws IOException {\n\t\tSystem.out.println(\"Closed\");\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 16)\n\ttry (this.y2) {\n\t          ^^\nField y2 used as a resource in a try with resources statement must be declared final\n----------\n");
    }

    public static Class testClass() {
        return TryStatement9Test.class;
    }
}

