/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.util.Arrays;
import org.eclipse.jdt.core.tests.compiler.regression.NullReferenceImplTests;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.UnconditionalFlowInfo;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;

class UnconditionalFlowInfoTestHarness
extends UnconditionalFlowInfo {
    int testPosition;

    UnconditionalFlowInfoTestHarness() {
    }

    NullReferenceImplTests.State asState() {
        return UnconditionalFlowInfoTestHarness.asState(this, 0);
    }

    NullReferenceImplTests.State asState(int position) {
        return UnconditionalFlowInfoTestHarness.asState(this, position);
    }

    public FlowInfo copy() {
        UnconditionalFlowInfoTestHarness copy = new UnconditionalFlowInfoTestHarness();
        copy.testPosition = this.testPosition;
        UnconditionalFlowInfoTestHarness.copy(this, copy);
        return copy;
    }

    public void markAsDefinitelyNonNull(LocalVariableBinding local) {
        this.grow(local.id + this.maxFieldCount);
        super.markAsDefinitelyNonNull(local);
    }

    public void markAsDefinitelyNull(LocalVariableBinding local) {
        this.grow(local.id + this.maxFieldCount);
        super.markAsDefinitelyNull(local);
    }

    public void markAsDefinitelyUnknown(LocalVariableBinding local) {
        this.grow(local.id + this.maxFieldCount);
        super.markAsDefinitelyUnknown(local);
    }

    public static UnconditionalFlowInfoTestHarness testUnconditionalFlowInfo(long[] nullBits) {
        return UnconditionalFlowInfoTestHarness.testUnconditionalFlowInfo(nullBits, 0);
    }

    public static UnconditionalFlowInfoTestHarness testUnconditionalFlowInfo(long[] nullBits, int position) {
        UnconditionalFlowInfoTestHarness result = new UnconditionalFlowInfoTestHarness();
        result.testPosition = position;
        UnconditionalFlowInfoTestHarness.init(result, nullBits, position);
        return result;
    }

    public static UnconditionalFlowInfoTestHarness testUnconditionalFlowInfo(NullReferenceImplTests.State state) {
        return UnconditionalFlowInfoTestHarness.testUnconditionalFlowInfo(state, 0);
    }

    public static UnconditionalFlowInfoTestHarness testUnconditionalFlowInfo(NullReferenceImplTests.State state, int position) {
        UnconditionalFlowInfoTestHarness result = new UnconditionalFlowInfoTestHarness();
        long[] nullBits = state.asLongArray();
        result.testPosition = position;
        UnconditionalFlowInfoTestHarness.init(result, nullBits, position);
        return result;
    }

    public boolean testEquals(UnconditionalFlowInfo other) {
        return UnconditionalFlowInfoTestHarness.testEquals(this, other);
    }

    public boolean testEquals(UnconditionalFlowInfo other, int position) {
        return UnconditionalFlowInfoTestHarness.testEquals(this, other, position);
    }

    public String testString() {
        if (this == DEAD_END) {
            return "FlowInfo.DEAD_END";
        }
        return UnconditionalFlowInfoTestHarness.testString(this, this.testPosition);
    }

    public String testString(int position) {
        return UnconditionalFlowInfoTestHarness.testString(this, position);
    }

    static NullReferenceImplTests.State asState(UnconditionalFlowInfo zis, int position) {
        if ((zis.tagBits & 4) == 0) {
            return NullReferenceImplTests.State.start;
        }
        if (position < 64) {
            return NullReferenceImplTests.State.fromLongValues(zis.nullBit1 >> position & 1L, zis.nullBit2 >> position & 1L, zis.nullBit3 >> position & 1L, zis.nullBit4 >> position & 1L, 0L, 0L);
        }
        int vectorIndex = position / 64 - 1;
        position %= 64;
        if (vectorIndex >= zis.extra[2].length) {
            return NullReferenceImplTests.State.start;
        }
        return NullReferenceImplTests.State.fromLongValues(zis.extra[2][vectorIndex] >> position & 1L, zis.extra[3][vectorIndex] >> position & 1L, zis.extra[4][vectorIndex] >> position & 1L, zis.extra[5][vectorIndex] >> position & 1L, 0L, 0L);
    }

    static void copy(UnconditionalFlowInfo source, UnconditionalFlowInfo target) {
        block5: {
            boolean hasNullInfo;
            target.definiteInits = source.definiteInits;
            target.potentialInits = source.potentialInits;
            boolean bl = hasNullInfo = (source.tagBits & 4) != 0;
            if (hasNullInfo) {
                target.nullBit1 = source.nullBit1;
                target.nullBit2 = source.nullBit2;
                target.nullBit3 = source.nullBit3;
                target.nullBit4 = source.nullBit4;
            }
            target.iNBit = source.iNBit;
            target.iNNBit = source.iNNBit;
            target.iDefNBit = source.iDefNBit;
            target.iDefNNBit = source.iDefNNBit;
            target.tagBits = source.tagBits;
            target.maxFieldCount = source.maxFieldCount;
            if (source.extra == null) break block5;
            target.extra = new long[10][];
            int length = source.extra[0].length;
            target.extra[0] = new long[length];
            System.arraycopy(source.extra[0], 0, target.extra[0], 0, length);
            target.extra[1] = new long[length];
            System.arraycopy(source.extra[1], 0, target.extra[1], 0, length);
            if (hasNullInfo) {
                int j = 0;
                while (j < 10) {
                    target.extra[j] = new long[length];
                    System.arraycopy(source.extra[j], 0, target.extra[j], 0, length);
                    ++j;
                }
            } else {
                int j = 0;
                while (j < 10) {
                    target.extra[j] = new long[length];
                    ++j;
                }
            }
        }
    }

    public void grow(int position) {
        block3: {
            int length;
            block2: {
                int vectorIndex = position / 64 - 1;
                length = vectorIndex + 1;
                if (this.extra != null) break block2;
                this.extra = new long[10][];
                int j = 0;
                while (j < 10) {
                    this.extra[j] = new long[length];
                    ++j;
                }
                break block3;
            }
            int oldLength = this.extra[2].length;
            if (length <= oldLength) break block3;
            int j = 0;
            while (j < 10) {
                this.extra[j] = new long[length];
                System.arraycopy(this.extra[j], 0, this.extra[j], 0, oldLength);
                ++j;
            }
        }
    }

    static void init(UnconditionalFlowInfo zis, long[] nullBits, int position) {
        if (position < 64) {
            zis.nullBit1 = nullBits[0] << position;
            zis.nullBit2 = nullBits[1] << position;
            zis.nullBit3 = nullBits[2] << position;
            zis.nullBit4 = nullBits[3] << position;
        } else {
            int vectorIndex = position / 64 - 1;
            int length = vectorIndex + 1;
            position %= 64;
            zis.extra = new long[10][];
            zis.extra[0] = new long[length];
            zis.extra[1] = new long[length];
            int j = 2;
            while (j < 10) {
                zis.extra[j] = new long[length];
                zis.extra[j][vectorIndex] = nullBits[j - 2] << position;
                ++j;
            }
            Arrays.fill(zis.extra[6], -1L);
            Arrays.fill(zis.extra[7], -1L);
        }
        zis.iNBit = -1L;
        zis.iNNBit = -1L;
        zis.iDefNBit = -1L;
        zis.iDefNNBit = -1L;
        if (nullBits[0] != 0L || nullBits[1] != 0L || nullBits[2] != 0L || nullBits[3] != 0L || nullBits[4] != 0L || nullBits[5] != 0L) {
            zis.tagBits |= 4;
        }
        zis.maxFieldCount = 0;
    }

    static boolean testEquals(UnconditionalFlowInfo zis, UnconditionalFlowInfo other) {
        int j;
        if (zis.tagBits != other.tagBits) {
            return false;
        }
        if (zis.nullBit1 != other.nullBit1 || zis.nullBit2 != other.nullBit2 || zis.nullBit3 != other.nullBit3 || zis.nullBit4 != other.nullBit4) {
            return false;
        }
        int left = zis.extra == null ? 0 : zis.extra[2].length;
        int right = other.extra == null ? 0 : other.extra[2].length;
        int both = 0;
        both = left > right ? right : left;
        int i = 0;
        while (i < both) {
            j = 2;
            while (j < 10) {
                if (zis.extra[j][i] != other.extra[j][i]) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        while (i < left) {
            j = 2;
            while (j < 10) {
                if (zis.extra[j][i] != 0L) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        while (i < right) {
            j = 2;
            while (j < 10) {
                if (other.extra[j][i] != 0L) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    static boolean testEquals(UnconditionalFlowInfo zis, UnconditionalFlowInfo other, int position) {
        int both;
        int vectorIndex = position / 64 - 1;
        if ((zis.tagBits & other.tagBits & 4) == 0) {
            return true;
        }
        if (vectorIndex < 0) {
            long mask = 1L << position;
            return (zis.nullBit1 & mask ^ other.nullBit1 & mask) == 0L && (zis.nullBit2 & mask ^ other.nullBit2 & mask) == 0L && (zis.nullBit3 & mask ^ other.nullBit3 & mask) == 0L && (zis.nullBit4 & mask ^ other.nullBit4 & mask) == 0L;
        }
        int left = zis.extra == null ? 0 : zis.extra[0].length;
        int right = other.extra == null ? 0 : other.extra[0].length;
        int n = both = left < right ? left : right;
        if (vectorIndex < both) {
            long mask = 1L << position % 64;
            int j = 2;
            while (j < 10) {
                if ((zis.extra[j][vectorIndex] & mask ^ other.extra[j][vectorIndex] & mask) != 0L) {
                    return false;
                }
                ++j;
            }
            return true;
        }
        if (vectorIndex < left) {
            return ((zis.extra[2][vectorIndex] | zis.extra[3][vectorIndex] | zis.extra[4][vectorIndex] | zis.extra[5][vectorIndex] | zis.extra[6][vectorIndex] | zis.extra[7][vectorIndex]) & 1L << position % 64) == 0L;
        }
        return ((other.extra[2][vectorIndex] | other.extra[3][vectorIndex] | other.extra[4][vectorIndex] | other.extra[5][vectorIndex] | other.extra[6][vectorIndex] | other.extra[7][vectorIndex]) & 1L << position % 64) == 0L;
    }

    static String testString(UnconditionalFlowInfo zis, int position) {
        if (zis == DEAD_END) {
            return "FlowInfo.DEAD_END";
        }
        if (position < 64) {
            return "{" + (zis.nullBit1 >> position) + "," + (zis.nullBit2 >> position) + "," + (zis.nullBit3 >> position) + "," + (zis.nullBit4 >> position) + "}";
        }
        int vectorIndex = position / 64 - 1;
        int shift = position % 64;
        return "{" + (zis.extra[2][vectorIndex] >> shift) + "," + (zis.extra[3][vectorIndex] >> shift) + "," + (zis.extra[4][vectorIndex] >> shift) + "," + (zis.extra[5][vectorIndex] >> shift) + "}";
    }
}

