/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.io.File;
import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest9;

public class UnnamedModuleTest
extends AbstractRegressionTest9 {
    public UnnamedModuleTest(String name) {
        super(name);
    }

    public static Test suite() {
        return UnnamedModuleTest.buildMinimalComplianceTestSuite(UnnamedModuleTest.testClass(), 64);
    }

    public static Class<UnnamedModuleTest> testClass() {
        return UnnamedModuleTest.class;
    }

    public void testBug522327() {
        this.runConformTest(new String[]{"nonmodular/ProblemWithThrowable.java", "package nonmodular;\n\nimport java.io.IOException;\nimport java.sql.SQLException;\n\npublic class ProblemWithThrowable {\n    public void saveProperties() throws IOException {\n    }\n}\n"});
    }

    public void testBug522326() {
        this.runConformTest(new String[]{"nonmodular/ProblemWithNested.java", "package nonmodular;\n\nimport java.sql.Connection;\nimport java.util.Map.Entry;\n\npublic class ProblemWithNested {\n}\n"});
    }

    public void testIgnoreUnnamedModule1() {
        String path = this.getCompilerTestsPluginDirectoryPath() + File.separator + "workspace" + File.separator + "ignore-unnamed-module-test.jar";
        String[] defaultLibs = this.getDefaultClassPaths();
        int len = defaultLibs.length;
        String[] libs = new String[len + 1];
        System.arraycopy(defaultLibs, 0, libs, 0, len);
        libs[len] = path;
        Map<String, String> compilerOptions = this.getCompilerOptions();
        compilerOptions.put("org.eclipse.jdt.core.compiler.ignoreUnnamedModuleForSplitPackage", "enabled");
        this.runConformTest(true, new String[]{"X.java", "import org.xml.sax.SAXException;\npublic class X {\n\tvoid foo() {\n\t\tSAXException s;\n\t}\n}"}, libs, compilerOptions, "", "", "", AbstractRegressionTest.JavacTestOptions.DEFAULT);
    }

    public void testIgnoreUnnamedModule2() {
        String path = this.getCompilerTestsPluginDirectoryPath() + File.separator + "workspace" + File.separator + "ignore-unnamed-module-test.jar";
        String[] defaultLibs = this.getDefaultClassPaths();
        int len = defaultLibs.length;
        String[] libs = new String[len + 1];
        System.arraycopy(defaultLibs, 0, libs, 0, len);
        libs[len] = path;
        Map<String, String> compilerOptions = this.getCompilerOptions();
        compilerOptions.put("org.eclipse.jdt.core.compiler.ignoreUnnamedModuleForSplitPackage", "enabled");
        this.runConformTest(true, new String[]{"X.java", "public class X {\n\tvoid foo() {\n\t\torg.xml.sax.SAXException s;\n\t}\n}"}, libs, compilerOptions, "", "", "", AbstractRegressionTest.JavacTestOptions.DEFAULT);
    }

    public void testIgnoreUnnamedModule3() {
        String path = this.getCompilerTestsPluginDirectoryPath() + File.separator + "workspace" + File.separator + "ignore-unnamed-module-test.jar";
        String[] defaultLibs = this.getDefaultClassPaths();
        int len = defaultLibs.length;
        String[] libs = new String[len + 1];
        System.arraycopy(defaultLibs, 0, libs, 0, len);
        libs[len] = path;
        Map<String, String> compilerOptions = this.getCompilerOptions();
        compilerOptions.put("org.eclipse.jdt.core.compiler.ignoreUnnamedModuleForSplitPackage", "enabled");
        this.runConformTest(true, new String[]{"X.java", "import static org.xml.sax.helpers.NamespaceSupport.XMLNS;\npublic class X {\n\tvoid foo() {\n\t\tString s = XMLNS;\n\t}\n}"}, libs, compilerOptions, "", "", "", AbstractRegressionTest.JavacTestOptions.DEFAULT);
    }

    public void testIgnoreUnnamedModule4() {
        String path = this.getCompilerTestsPluginDirectoryPath() + File.separator + "workspace" + File.separator + "ignore-unnamed-module-test.jar";
        String[] defaultLibs = this.getDefaultClassPaths();
        int len = defaultLibs.length;
        String[] libs = new String[len + 1];
        System.arraycopy(defaultLibs, 0, libs, 0, len);
        libs[len] = path;
        Map<String, String> compilerOptions = this.getCompilerOptions();
        compilerOptions.put("org.eclipse.jdt.core.compiler.ignoreUnnamedModuleForSplitPackage", "enabled");
        this.runConformTest(true, new String[]{"X.java", "public class X {\n\tvoid foo() {\n\t\tString s = org.xml.sax.helpers.NamespaceSupport.XMLNS;\n\t}\n}"}, libs, compilerOptions, "", "", "", AbstractRegressionTest.JavacTestOptions.DEFAULT);
    }

    public void testConflictWithUnnamedModule() {
        String path = this.getCompilerTestsPluginDirectoryPath() + File.separator + "workspace" + File.separator + "ignore-unnamed-module-test.jar";
        String[] defaultLibs = this.getDefaultClassPaths();
        int len = defaultLibs.length;
        String[] libs = new String[len + 1];
        System.arraycopy(defaultLibs, 0, libs, 0, len);
        libs[len] = path;
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.classLibraries = libs;
        runner.testFiles = new String[]{"X.java", "public class X {\n\tvoid foo() {\n\t\tString s = org.xml.sax.helpers.NamespaceSupport.XMLNS;\n\t}\n}"};
        runner.expectedCompilerLog = "----------\n1. ERROR in X.java (at line 3)\n\tString s = org.xml.sax.helpers.NamespaceSupport.XMLNS;\n\t           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nThe package org.xml.sax.helpers is accessible from more than one module: <unnamed>, java.xml\n----------\n";
        runner.runNegativeTest();
    }

    public void testGH445_1() {
        String path = this.getCompilerTestsPluginDirectoryPath() + File.separator + "workspace" + File.separator + "ignore-unnamed-module-test.jar";
        String[] defaultLibs = this.getDefaultClassPaths();
        int len = defaultLibs.length;
        String[] libs = new String[len + 1];
        System.arraycopy(defaultLibs, 0, libs, 0, len);
        libs[len] = path;
        Map<String, String> compilerOptions = this.getCompilerOptions();
        compilerOptions.put("org.eclipse.jdt.internal.debug.compile.mode", "enabled");
        this.runConformTest(true, new String[]{"X.java", "import org.xml.sax.SAXException;\npublic class X {\n\tvoid foo() {\n\t\tSAXException s;\n\t}\n}"}, libs, compilerOptions, "", "", "", AbstractRegressionTest.JavacTestOptions.DEFAULT);
    }

    public void testGH445_2() {
        String path = this.getCompilerTestsPluginDirectoryPath() + File.separator + "workspace" + File.separator + "ignore-unnamed-module-test.jar";
        String[] defaultLibs = this.getDefaultClassPaths();
        int len = defaultLibs.length;
        String[] libs = new String[len + 1];
        System.arraycopy(defaultLibs, 0, libs, 0, len);
        libs[len] = path;
        Map<String, String> compilerOptions = this.getCompilerOptions();
        compilerOptions.put("org.eclipse.jdt.internal.debug.compile.mode", "enabled");
        this.runConformTest(true, new String[]{"X.java", "import org.xml.sax.*;\npublic class X {\n\tvoid foo() {\n\t\tSAXException s;\n\t}\n}"}, libs, compilerOptions, "", "", "", AbstractRegressionTest.JavacTestOptions.DEFAULT);
    }
}

