/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.io.IOException;
import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractBatchCompilerTest;
import org.eclipse.jdt.core.util.ClassFormatException;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;

public class UnnamedPatternsAndVariablesTest
extends AbstractBatchCompilerTest {
    public static Test suite() {
        return UnnamedPatternsAndVariablesTest.buildMinimalComplianceTestSuite(UnnamedPatternsAndVariablesTest.class, 0x100000);
    }

    public UnnamedPatternsAndVariablesTest(String name) {
        super(name);
    }

    @Override
    protected Map<String, String> getCompilerOptions() {
        CompilerOptions compilerOptions = new CompilerOptions(super.getCompilerOptions());
        return compilerOptions.getMap();
    }

    @Override
    public void runConformTest(String[] files, String expectedOutput) {
        if (!isJRE22Plus) {
            return;
        }
        super.runConformTest(files, expectedOutput, null, null);
    }

    public void testAllSnippetsFromUnnamedVariablesAndPatternsProposal() {
        this.runConformTest(new String[]{"X.java", "import java.util.Queue;\nimport java.util.LinkedList;\nimport java.util.stream.Collectors;\nimport java.util.stream.Stream;\n\nrecord Point(int x, int y) { }\nenum Color { RED, GREEN, BLUE }\nrecord ColoredPoint(Point p, Color c) { }\nrecord Box<T extends Ball>(T content) { }\n\nsealed abstract class Ball permits RedBall, BlueBall, GreenBall { }\nfinal  class RedBall   extends Ball { }\nfinal  class BlueBall  extends Ball { }\nfinal  class GreenBall extends Ball { }\n\npublic class X {\n\tpublic static void main(String[] args) throws Exception {\n\t\tColoredPoint r = new ColoredPoint(new Point(3,4), Color.GREEN);\n\t\tif (r instanceof ColoredPoint(Point(int x, int y), Color _)) {\n\t\t}\n\t\tif (r instanceof ColoredPoint(Point(int x, int y), var _)) {\n\t\t}\n\t\tfor (int i = 0, _ = sideEffect(); i < 10; i++) {\n\t\t}\n\t\tQueue<Integer> q = new LinkedList<>();\n\t\tq.offer(1); q.offer(1); q.offer(1);\n\t\twhile (q.size() >= 3) {\n\t\t\tvar x = q.remove();\n\t\t\tvar _ = q.remove();       // Unnamed variable\n\t\t\tvar _ = q.remove();       // Unnamed variable\n\t\t}\n\t\tString s = \"\";\n\t\ttry {\n\t\t\tint i = Integer.parseInt(s);\n\t\t} catch (NumberFormatException _) {        // Unnamed variable\n\t\t\tSystem.out.println(\"Bad number: \" + s);\n\t\t} catch (NullPointerException _) {\n\t\t}\n\t\tclass ScopedContext implements AutoCloseable {\n\t\t\tpublic static ScopedContext acquire() {\n\t\t\t\treturn null;\n\t\t\t}\n\t\t\t@Override\n\t\t\tpublic void close() throws Exception {\n\t\t\t}\n\t\t}\n\t\ttry (var _ = ScopedContext.acquire()) {    // Unnamed variable\n\t\t}\n\t\tStream<String> stream = new LinkedList<String>().stream();\n\t\tstream.collect(Collectors.toMap(String::toUpperCase, _ -> \"NODATA\")) ;\n\t\tBall ball = new GreenBall();\n\t\tswitch (ball) {\n\t\t\tcase RedBall   _   -> process(ball);\n\t\t\tcase BlueBall  _  -> process(ball);\n\t\t\tcase GreenBall _ -> stopProcessing();\n\t\t}\n\t\tBox<? extends Ball> box = new Box<>(new GreenBall());\n\t\tswitch (box) {\n\t\t\tcase Box(RedBall   red)     -> processBox(box);\n\t\t\tcase Box(BlueBall  blue)    -> processBox(box);\n\t\t\tcase Box(GreenBall green)   -> stopProcessing();\n\t\t\tcase Box(var       itsNull) -> pickAnotherBox();\n\t\t\tdefault -> throw new IllegalArgumentException(\"Unexpected value: \" + box);\n\t\t}\n\t\tswitch (box) {\n\t\t\tcase Box(RedBall _)   -> processBox(box);   // Unnamed pattern variable\n\t\t\tcase Box(BlueBall _)  -> processBox(box);   // Unnamed pattern variable\n\t\t\tcase Box(GreenBall _) -> stopProcessing();  // Unnamed pattern variable\n\t\t\tcase Box(var _)       -> pickAnotherBox();  // Unnamed pattern variable\n\t\t\tdefault -> throw new IllegalArgumentException(\"Unexpected value: \" + box);\n\t\t}\n\t}\n\n\tprivate static Object pickAnotherBox() {\n\t\t// TODO Auto-generated method stub\n\t\treturn null;\n\t}\n\n\tprivate static Object processBox(Box<? extends Ball> box) {\n\t\t// TODO Auto-generated method stub\n\t\treturn null;\n\t}\n\n\tprivate static Object stopProcessing() {\n\t\treturn null;\n\t}\n\n\tprivate static Object process(Ball ball) {\n\t\treturn null;\n\t}\n\n\tstatic int sideEffect() {\n\t\treturn 0;\n\t}\n\n\tclass Order {}\n\n\tstatic int count(Iterable<Order> orders) {\n\t\tint total = 0;\n\t\tfor (Order _ : orders)    // Unnamed variable\n\t\t\ttotal++;\n\t\treturn total;\n\t}\n}\n"}, "Bad number:");
    }

    public void testCatchStatementWithUnnamedVars() {
        this.runConformTest(new String[]{"A.java", "public class A {\n\tpublic static void main(String... args) {\n\t\ttry {\n\t\t\tthrow new Exception();\n\t\t} catch( Exception _) {\n\t\t\tint i = 12;\n\t\t\tSystem.out.println(Integer.toString(i));\n\t\t}\n\t}\n}\n"}, "12");
    }

    public void testTryWithResourcesWithUnnamedVars() {
        this.runConformTest(new String[]{"A.java", "import java.io.File;\nimport java.io.FileInputStream;\nimport java.io.InputStream;\npublic class A {\n\tpublic static void main(String... args) {\n\t\tFile f = null;\n\t\ttry (final InputStream _ = new FileInputStream(f)){\n\t\t\tSystem.out.println(\"unexpected success\");\n\t\t} catch( Exception e) {\n\t\t\tSystem.out.println(\"expected failure\");\n\t\t}\n\t}\n}\n"}, "expected failure");
    }

    public void testLambdaUnnamedParameter() {
        this.runConformTest(new String[]{"A.java", "public class A {\n\tinterface FuncInterface {\n\t\tvoid abstractFun(int x, String y);\n\t}\n\tpublic static void main(String args[]) {\n\t\tFuncInterface fobj = (int x, String _) -> System.out.println(2 * x);\n\t\tfobj.abstractFun(5, \"blah\");\n\t}\n}\n"}, "10");
    }

    public void testLambdaBracketedUnnamedParameter() {
        this.runConformTest(new String[]{"A.java", "import java.util.function.Function;\npublic class A {\n\tpublic static void main(String... args) {\n\t\tFunction<Integer, String> myFunc =  (Integer _) -> \"Hello\";\n\t\tSystem.out.println(myFunc.apply(1));\n\t}\n}\n"}, "Hello");
    }

    public void testLambdaNoTypeBracketedUnnamedParameter() {
        this.runConformTest(new String[]{"A.java", "import java.util.function.Function;\npublic class A {\n\tpublic static void main(String... args) {\n\t\tFunction<Integer, String> myFunc =  (_) -> \"Hello\";\n\t\tSystem.out.println(myFunc.apply(1));\n\t}\n}\n"}, "Hello");
    }

    public void testLambdaNoTypeNoBracketsUnnamedParameter() {
        this.runConformTest(new String[]{"A.java", "import java.util.function.Function;\npublic class A {\n\tpublic static void main(String... args) {\n\t\tFunction<Integer, String> myFunc =  _ -> \"Hello\";\n\t\tSystem.out.println(myFunc.apply(1));\n\t}\n}\n"}, "Hello");
    }

    public void testLambdaTypeWithNoParens() {
        this.runNegativeTest(new String[]{"A.java", "import java.util.function.Function;\npublic class A {\n\tpublic static void main(String... args) {\n\t\tFunction<Integer, String> myFunc = Integer _ -> \"Hello\";\n\t\tSystem.out.println(myFunc.apply(1));\n\t}\n}\n"}, "----------\n1. ERROR in A.java (at line 4)\n\tFunction<Integer, String> myFunc = Integer _ -> \"Hello\";\n\t                                   ^^^^^^^\nSyntax error, insert \":: IdentifierOrNew\" to complete ReferenceExpression\n----------\n2. ERROR in A.java (at line 4)\n\tFunction<Integer, String> myFunc = Integer _ -> \"Hello\";\n\t                                   ^^^^^^^\nSyntax error, insert \";\" to complete BlockStatements\n----------\n3. ERROR in A.java (at line 4)\n\tFunction<Integer, String> myFunc = Integer _ -> \"Hello\";\n\t                                                ^^^^^^^\nSyntax error, insert \"AssignmentOperator Expression\" to complete Expression\n----------\n");
    }

    public void testLambdaBiFunctionBracketedWithOneNamedParam() {
        this.runConformTest(new String[]{"A.java", "import java.util.function.BiFunction;\npublic class A {\n\tpublic static void main(String... args) {\n\t\tBiFunction<Integer, Integer, String> myFunc =  (_,b) -> \"Hello, \" + b;\n\t\tSystem.out.println(myFunc.apply(2, 3));\n\t}\n}\n"}, "Hello, 3");
    }

    public void testLambdaBiFunctionBracketedWithNoNamedParam() {
        this.runConformTest(new String[]{"A.java", "import java.util.function.BiFunction;\npublic class A {\n\tpublic static void main(String... args) {\n\t\tBiFunction<Integer, Integer, String> myFunc =  (_,_) -> \"Hello\";\n\t\tSystem.out.println(myFunc.apply(2, 3));\n\t}\n}\n"}, "Hello");
    }

    public void testLambdaBiFunctionUnbracketedWithNoNamedParam() {
        this.runNegativeTest(new String[]{"A.java", "import java.util.function.BiFunction;\npublic class A {\n\tpublic static void main(String... args) {\n\t\tBiFunction<Integer, Integer, String> myFunc =  _,_ -> \"Hello\";\n\t\tSystem.out.println(myFunc.apply(2, 3));\n\t}\n}\n"}, "----------\n1. ERROR in A.java (at line 4)\n\tBiFunction<Integer, Integer, String> myFunc =  _,_ -> \"Hello\";\n\t                                                ^\nSyntax error on token \",\", -> expected\n----------\n");
    }

    public void testInstanceOfPatternMatchingWithUnnamedPatterns() {
        this.runConformTest(new String[]{"A.java", "public class A {\n\tpublic static void main(String[] args) {\n\t\tvar namedPoint = new NamedPoint(\"salutations\", new Point(1, 2));\n\t\tif (namedPoint instanceof NamedPoint(_, Point(_, _))) {\n\t\t\tSystem.out.println(\"matched point\");\n\t\t}\n\t}\n}\nrecord NamedPoint(String name, Point point) {}\nrecord Point(int x, int y) {}\n"}, "matched point");
    }

    public void testInstanceOfPatternMatchingWithMixedPatterns() {
        this.runConformTest(new String[]{"A.java", "public class A {\n\tpublic static void main(String[] args) {\n\t\tvar namedPoint = new NamedPoint(\"salutations\", new Point(1, 2));\n\t\tif (namedPoint instanceof NamedPoint(_, Point(_, int y))) {\n\t\t\tSystem.out.println(\"matched point! y: \" + y);\n\t\t}\n\t}\n}\nrecord NamedPoint(String name, Point point) {}\nrecord Point(int x, int y) {}\n"}, "matched point! y: 2");
    }

    public void testInstanceOfPatternMatchingWithMixedPatterns2() {
        this.runConformTest(new String[]{"A.java", "public class A {\n\tpublic static void main(String[] args) {\n\t\tvar namedPoint = new NamedPoint(\"salutations\", new Point(1, 2));\n\t\tif (namedPoint instanceof NamedPoint(_, Point(int x, _))) {\n\t\t\tSystem.out.println(\"matched point! x: \" + x);\n\t\t}\n\t}\n}\nrecord NamedPoint(String name, Point point) {}\nrecord Point(int x, int y) {}\n"}, "matched point! x: 1");
    }

    public void testInstanceOfPatternMatchingWithUnnamedVariables() {
        this.runConformTest(new String[]{"A.java", "public class A {\n\tpublic static void main(String[] args) {\n\t\tvar namedPoint = new NamedPoint(\"salutations\", new Point(1, 2));\n\t\tif (namedPoint instanceof NamedPoint(String _, Point(int _, int _))) {\n\t\t\tSystem.out.println(\"matched point\");\n\t\t}\n\t}\n}\nrecord NamedPoint(String name, Point point) {}\nrecord Point(int x, int y) {}\n"}, "matched point");
    }

    public void testSwitchPatternMatchingWithUnnamedPatterns() {
        this.runConformTest(new String[]{"A.java", "public class A {\n\tpublic static void main(String[] args) {\n\t\tvar namedPoint = new NamedPoint(\"name\", new Point(1, 2));\n\t\tswitch (namedPoint) {\n\t\t\tcase NamedPoint(_, Point(_, _)) -> System.out.println(\"I am utilizing pattern matching\");\n\t\t\tdefault -> System.out.println(\"oh no\");\n\t\t}\n\t}\n}\nrecord NamedPoint(String name, Point point) {}\nrecord Point(int x, int y) {}\n"}, "I am utilizing pattern matching");
    }

    public void testSwitchPatternMatchingWithMixedPatterns() {
        this.runConformTest(new String[]{"A.java", "public class A {\n\tpublic static void main(String[] args) {\n\t\tvar namedPoint = new NamedPoint(\"name\", new Point(1, 2));\n\t\tswitch (namedPoint) {\n\t\t\tcase NamedPoint(_, Point(int x, _)) -> System.out.println(x);\n\t\t\tdefault -> System.out.println(\"oh no\");\n\t\t}\n\t}\n}\nrecord NamedPoint(String name, Point point) {}\nrecord Point(int x, int y) {}\n"}, "1");
    }

    public void testSwitchPatternMatchingWithUnnamedVariables() {
        this.runConformTest(new String[]{"A.java", "public class A {\n\tpublic static void main(String[] args) {\n\t\tvar namedPoint = new NamedPoint(\"name\", new Point(1, 2));\n\t\tswitch (namedPoint) {\n\t\t\tcase NamedPoint(String _, Point(int _, int y)) -> System.out.println(y);\n\t\t\tdefault -> System.out.println(\"oh no\");\n\t\t}\n\t}\n}\nrecord NamedPoint(String name, Point point) {}\nrecord Point(int x, int y) {}\n"}, "2");
    }

    public void testSwitchPatternMatchingWithUnnamedVariablesVar() {
        this.runConformTest(new String[]{"A.java", "public class A {\n\tpublic static void main(String[] args) {\n\t\tvar namedPoint = new NamedPoint(\"name\", new Point(1, 2));\n\t\tswitch (namedPoint) {\n\t\t\tcase NamedPoint(String _, Point(var _, int y)) -> System.out.println(y);\n\t\t\tdefault -> System.out.println(\"oh no\");\n\t\t}\n\t}\n}\nrecord NamedPoint(String name, Point point) {}\nrecord Point(int x, int y) {}\n"}, "2");
    }

    public void testSwitchPatternMatchingWithUnnamedVariablesUnicodeEscape() {
        this.runConformTest(new String[]{"A.java", "public class A {\n\tpublic static void main(String[] args) {\n\t\tvar namedPoint = new NamedPoint(\"name\", new Point(1, 2));\n\t\tswitch (namedPoint) {\n\t\t\tcase NamedPoint(String _, Point(var \\u005F, int y)) -> System.out.println(y);\n\t\t\tdefault -> System.out.println(\"oh no\");\n\t\t}\n\t}\n}\nrecord NamedPoint(String name, Point point) {}\nrecord Point(int x, int y) {}\n"}, "2");
    }

    public void testEnhancedForLoopVariableWithModifier() {
        this.runConformTest(new String[]{"A.java", "import java.util.List;\npublic class A {\n\tpublic static void main(String... args) {\n\t\tList<String> myList = List.of(\"hi\", \"hello\", \"salu\", \"bonjour\");\n\t\tint accumulator = 0;\n\t\tfor (final String _ : myList) {\n\t\t\taccumulator++;\n\t\t}\n\t\tSystem.out.println(accumulator);\n\t\taccumulator = 0;\n\t\tfor (final int _ : new int[0]) {\n\t\t}\n\t\tSystem.out.println(accumulator);\n\t}\n}\n"}, "4\n0");
    }

    public void testInstanceofUnnamedPatternMatching() {
        this.runConformTest(new String[]{"A.java", "public class A {\n\tpublic static void main(String[] args) {\n\t\tObject r = null;\n\t\tif (r instanceof ColoredPoint(Point(int x, _), _)) {\n\t\t\tSystem.out.println(\"Hello, World!\" + x);\n\t\t}\n\t}\n}\nrecord Point(int x, int y) { }\nenum Color { RED, GREEN, BLUE }\nrecord ColoredPoint(Point p, Color c) { }\n"}, "");
    }

    public void testReuseLocalUnnamedVariable() {
        this.runConformTest(new String[]{"A.java", "public class A {\n\tpublic static void main(String[] args) {\n\t\tint _ = 1;\n\t\tint _ = 2;\n\t\tint _ = 3;\n\t}\n}\nrecord Point(int x, int y) { }\nenum Color { RED, GREEN, BLUE }\nrecord ColoredPoint(Point p, Color c) { }\n"}, "");
    }

    public void testReuseLocalUnnamedVariableUnicodeEscape() {
        this.runConformTest(new String[]{"A.java", "public class A {\n\tpublic static void main(String[] args) {\n\t\tint _ = 1;\n\t\tint \\u005F = 2;\n\t\tint \\u005F = 3;\n\t}\n}\nrecord Point(int x, int y) { }\nenum Color { RED, GREEN, BLUE }\nrecord ColoredPoint(Point p, Color c) { }\n"}, "");
    }

    public void testUnnamedVariableInEnhancedFor() {
        this.runConformTest(new String[]{"A.java", "import java.util.List;\npublic class A {\n\tpublic static void main(String[] args) {\n\t\tList<Order> orders = List.of(new Order(), new Order());\n\t\tint total = 0;\n\t\tfor (Order _ : orders)\n\t\t\ttotal++;\n\t\tSystem.out.println(total);\n\t}\n}\nclass Order {}\n"}, "2");
    }

    public void testUnnamedVariableAsLambdaParameter() {
        this.runConformTest(new String[]{"A.java", "import java.util.function.Function;\npublic class A {\n\tpublic static void main(String[] args) {\n\t\tFunction<Integer, Integer> myFunc = _ -> 1;\n\t\tSystem.out.println(myFunc.apply(0));\n\t}\n}\n"}, "1");
    }

    public void testUnnamedVariableWithoutInitializer() {
        this.runNegativeTest(new String[]{"A.java", "import java.io.BufferedReader;\nimport java.io.IOException;\nimport java.util.List;\npublic class A {\n\tvoid foo(int x, int y) {\n\t\tint _;\n\t\tint _;\n\t\ttry (BufferedReader _ = null) {\n\t\t} catch (IOException _) {\n\t\t}\n\t\tfor (String _ : List.of(\"hello\")) {\n\t\t}\n\t\tint i = 12;\n\t\tfor (int _; i < 14; i++) {\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in A.java (at line 6)\n\tint _;\n\t    ^\nUnnamed variables must have an initializer\n----------\n2. ERROR in A.java (at line 7)\n\tint _;\n\t    ^\nUnnamed variables must have an initializer\n----------\n3. ERROR in A.java (at line 14)\n\tfor (int _; i < 14; i++) {\n\t         ^\nUnnamed variables must have an initializer\n----------\n");
    }

    public void test001() {
        this.runConformTest(new String[]{"X.java", "public class X {\n public static int foo() {\n   int _ = 1;\n   return 0;\n }\n public static void main(String[] args) {\n   System.out.println(X.foo());\n }\n}"}, "0");
    }

    public void test002() {
        this.runConformTest(new String[]{"X.java", "@SuppressWarnings(\"preview\")\npublic class X {\n public static int foo() {\n   int _ = bar();\n   return 0;\n }\n public static int bar() {\n   return 0;\n }\n public static void main(String[] args) {\n   System.out.println(X.foo());\n }\n}"}, "0");
    }

    public void test003() {
        this.runNegativeTest(new String[]{"X.java", "@SuppressWarnings(\"preview\")\npublic class X {\n public static int foo() {\n   int _;\n   return 0;\n }\n public static void main(String[] args) {\n   System.out.println(X.foo());\n }\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\tint _;\n\t    ^\nUnnamed variables must have an initializer\n----------\n");
    }

    public void test004() {
        this.runNegativeTest(new String[]{"X.java", "@SuppressWarnings(\"preview\")\npublic class X {\n public static int foo() {\n   int _ = 0;\n   return _;\n }\n public static void main(String[] args) {\n   System.out.println(X.foo());\n }\n}"}, "----------\n1. ERROR in X.java (at line 5)\n\treturn _;\n\t       ^\nSyntax error, insert \"-> LambdaBody\" to complete Expression\n----------\n");
    }

    public void test005() {
        this.runNegativeTest(new String[]{"X.java", "@SuppressWarnings(\"preview\")\npublic class X {\n   public int _;\n public static void main(String[] args) {\n   System.out.println(0);\n }\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tpublic int _;\n\t           ^\nAs of release 22, '_' is only allowed to declare unnamed patterns, local variables, exception parameters or lambda parameters\n----------\n");
    }

    public void testIssue2024() {
        this.runConformTest(new String[]{"X.java", "record A(){}\nrecord R<T>(T t) {}\npublic class X {\n    private static boolean foo(R<A> r) {\n        return r instanceof R(var _);\n    }\n    public static void main(String argv[]) {\n        System.out.println(foo(new R<A>(new A())) ? \"Pass\" : \"Fail\");\n    }\n}\n"}, "Pass");
    }

    public void testIssue2024_2() {
        this.runConformTest(new String[]{"X.java", "record A(){}\nrecord R<T>(T t) {}\npublic class X {\n    private static boolean foo(R<? extends A> r) {\n        return r instanceof R(var _);\n    }\n    public static void main(String argv[]) {\n        System.out.println(foo(new R<A>(new A())) ? \"Pass\" : \"Fail\");\n    }\n}\n"}, "Pass");
    }

    public void testIssue2024_3() {
        this.runConformTest(new String[]{"X.java", "interface I {}\nrecord A() implements I {}\nrecord R<T>(T t) {}\n\npublic class X {\n    private static boolean foo(R<? extends I> r) {\n        return r instanceof R(var _);\n    }\n    public static void main(String argv[]) {\n        System.out.println(foo(new R<A>(new A())) ? \"Pass\" : \"Fail\");\n    }\n}\n"}, "Pass");
    }

    public void testIssue2020() throws ClassFormatException, IOException {
        String source = "\t\t\tpublic class X {\n  record Point3D (int x, int y, int z) {\n\n  }\n\n  public static void main(String[] args) {\n\tObject o = new Point3D(1,2,3);\n\tif (o instanceof Point3D(_, int y, _)) {\n\t\tSystem.out.println(y);\n\t}\n  }\n}\n";
        String expectedOutput = "  // Method descriptor #15 ([Ljava/lang/String;)V\n  // Stack: 5, Locals: 3\n  public static void main(String[] args);\n     0  new X$Point3D [16]\n     3  dup\n     4  iconst_1\n     5  iconst_2\n     6  iconst_3\n     7  invokespecial X$Point3D(int, int, int) [18]\n    10  astore_1 [o]\n    11  aload_1 [o]\n    12  instanceof X$Point3D [16]\n    15  ifeq 43\n    18  aload_1 [o]\n    19  checkcast X$Point3D [16]\n    22  dup\n    23  invokevirtual X$Point3D.x() : int [21]\n    26  pop\n    27  dup\n    28  invokevirtual X$Point3D.y() : int [25]\n    31  istore_2 [y]\n    32  invokevirtual X$Point3D.z() : int [28]\n    35  pop\n    36  getstatic System.out : PrintStream [31]\n    39  iload_2 [y]\n    40  invokevirtual PrintStream.println(int) : void [37]\n    43  return\n    44  new MatchException [43]\n    47  dup_x1\n    48  swap\n    49  dup\n    50  invokevirtual Throwable.toString() : String [45]\n    53  swap\n    54  invokespecial MatchException(String, Throwable) [51]\n    57  athrow\n      Exception Table:\n        [pc: 23, pc: 26] -> 44 when : Throwable\n        [pc: 28, pc: 31] -> 44 when : Throwable\n        [pc: 32, pc: 35] -> 44 when : Throwable\n      Line numbers:\n        [pc: 0, line: 7]\n        [pc: 11, line: 8]\n        [pc: 36, line: 9]\n        [pc: 43, line: 11]\n      Local variable table:\n        [pc: 0, pc: 58] local: args index: 0 type: String[]\n        [pc: 11, pc: 44] local: o index: 1 type: Object\n        [pc: 32, pc: 43] local: y index: 2 type: int\n      Stack map table: number of frames 2\n        [pc: 43, append: {Object}]\n        [pc: 44, full, stack: {Throwable}, locals: {String[]}]\n";
        boolean savedPreview = this.enablePreview;
        try {
            this.enablePreview = true;
            this.checkClassFile("X", source, expectedOutput, 9);
        }
        finally {
            this.enablePreview = savedPreview;
        }
        this.runConformTest(new String[]{"X.java", source}, "2");
    }

    public void testIssue2020_2() throws ClassFormatException, IOException {
        String source = "\t\t\tpublic class X {\n  record Point3D (long x, long y, long z) {\n\n  }\n\n  public static void main(String[] args) {\n\tObject o = new Point3D(1,2,3);\n\tif (o instanceof Point3D(_, long y, _)) {\n\t\tSystem.out.println(y);\n\t}\n  }\n}\n";
        String expectedOutput = "  // Method descriptor #15 ([Ljava/lang/String;)V\n  // Stack: 8, Locals: 4\n  public static void main(String[] args);\n     0  new X$Point3D [16]\n     3  dup\n     4  lconst_1\n     5  ldc2_w <Long 2> [18]\n     8  ldc2_w <Long 3> [20]\n    11  invokespecial X$Point3D(long, long, long) [22]\n    14  astore_1 [o]\n    15  aload_1 [o]\n    16  instanceof X$Point3D [16]\n    19  ifeq 47\n    22  aload_1 [o]\n    23  checkcast X$Point3D [16]\n    26  dup\n    27  invokevirtual X$Point3D.x() : long [25]\n    30  pop2\n    31  dup\n    32  invokevirtual X$Point3D.y() : long [29]\n    35  lstore_2 [y]\n    36  invokevirtual X$Point3D.z() : long [32]\n    39  pop2\n    40  getstatic System.out : PrintStream [35]\n    43  lload_2 [y]\n    44  invokevirtual PrintStream.println(long) : void [41]\n    47  return\n    48  new MatchException [47]\n    51  dup_x1\n    52  swap\n    53  dup\n    54  invokevirtual Throwable.toString() : String [49]\n    57  swap\n    58  invokespecial MatchException(String, Throwable) [55]\n    61  athrow\n      Exception Table:\n        [pc: 27, pc: 30] -> 48 when : Throwable\n        [pc: 32, pc: 35] -> 48 when : Throwable\n        [pc: 36, pc: 39] -> 48 when : Throwable\n      Line numbers:\n        [pc: 0, line: 7]\n        [pc: 15, line: 8]\n        [pc: 40, line: 9]\n        [pc: 47, line: 11]\n      Local variable table:\n        [pc: 0, pc: 62] local: args index: 0 type: String[]\n        [pc: 15, pc: 48] local: o index: 1 type: Object\n        [pc: 36, pc: 47] local: y index: 2 type: long\n      Stack map table: number of frames 2\n        [pc: 47, append: {Object}]\n        [pc: 48, full, stack: {Throwable}, locals: {String[]}]\n";
        boolean savedPreview = this.enablePreview;
        try {
            this.enablePreview = true;
            this.checkClassFile("X", source, expectedOutput, 9);
        }
        finally {
            this.enablePreview = savedPreview;
        }
        this.runConformTest(new String[]{"X.java", source}, "2");
    }

    public void testIssue2020_3() throws ClassFormatException, IOException {
        String source = "\t\t\tpublic class X {\n  record Point3D (String x, String y, String z) {\n\n  }\n\n  public static void main(String[] args) {\n\tObject o = new Point3D(\"1\",\"2\",\"3\");\n\tif (o instanceof Point3D(_, String y, _)) {\n\t\tSystem.out.println(y);\n\t}\n  }\n}\n";
        String expectedOutput = "  // Method descriptor #15 ([Ljava/lang/String;)V\n  // Stack: 5, Locals: 3\n  public static void main(String[] args);\n     0  new X$Point3D [16]\n     3  dup\n     4  ldc <String \"1\"> [18]\n     6  ldc <String \"2\"> [20]\n     8  ldc <String \"3\"> [22]\n    10  invokespecial X$Point3D(String, String, String) [24]\n    13  astore_1 [o]\n    14  aload_1 [o]\n    15  instanceof X$Point3D [16]\n    18  ifeq 46\n    21  aload_1 [o]\n    22  checkcast X$Point3D [16]\n    25  dup\n    26  invokevirtual X$Point3D.x() : String [27]\n    29  pop\n    30  dup\n    31  invokevirtual X$Point3D.y() : String [31]\n    34  astore_2 [y]\n    35  invokevirtual X$Point3D.z() : String [34]\n    38  pop\n    39  getstatic System.out : PrintStream [37]\n    42  aload_2 [y]\n    43  invokevirtual PrintStream.println(String) : void [43]\n    46  return\n    47  new MatchException [49]\n    50  dup_x1\n    51  swap\n    52  dup\n    53  invokevirtual Throwable.toString() : String [51]\n    56  swap\n    57  invokespecial MatchException(String, Throwable) [56]\n    60  athrow\n      Exception Table:\n        [pc: 26, pc: 29] -> 47 when : Throwable\n        [pc: 31, pc: 34] -> 47 when : Throwable\n        [pc: 35, pc: 38] -> 47 when : Throwable\n      Line numbers:\n        [pc: 0, line: 7]\n        [pc: 14, line: 8]\n        [pc: 39, line: 9]\n        [pc: 46, line: 11]\n      Local variable table:\n        [pc: 0, pc: 61] local: args index: 0 type: String[]\n        [pc: 14, pc: 47] local: o index: 1 type: Object\n        [pc: 35, pc: 46] local: y index: 2 type: String\n      Stack map table: number of frames 2\n        [pc: 46, append: {Object}]\n        [pc: 47, full, stack: {Throwable}, locals: {String[]}]\n";
        boolean savedPreview = this.enablePreview;
        try {
            this.enablePreview = true;
            this.checkClassFile("X", source, expectedOutput, 9);
        }
        finally {
            this.enablePreview = savedPreview;
        }
        this.runConformTest(new String[]{"X.java", source}, "2");
    }

    public void testIssue2020_4() throws ClassFormatException, IOException {
        String source = "\t\t\tinterface I {}\n\t\t\tpublic class X implements I {\n\n  record Point3D (I x, I y, I z) {\n\n  }\n\n  public static void main(String[] args) {\n\tObject o = new Point3D(null, new X(), null);\n\tif (o instanceof Point3D(_, X y, _)) {\n\t\tSystem.out.println(\"Y is of class: \" + y.getClass());\n\t}\n  }\n}\n";
        String expectedOutput = "  // Method descriptor #17 ([Ljava/lang/String;)V\n  // Stack: 5, Locals: 3\n  public static void main(String[] args);\n     0  new X$Point3D [18]\n     3  dup\n     4  aconst_null\n     5  new X [1]\n     8  dup\n     9  invokespecial X() [20]\n    12  aconst_null\n    13  invokespecial X$Point3D(I, I, I) [21]\n    16  astore_1 [o]\n    17  aload_1 [o]\n    18  instanceof X$Point3D [18]\n    21  ifeq 74\n    24  aload_1 [o]\n    25  checkcast X$Point3D [18]\n    28  dup\n    29  invokevirtual X$Point3D.x() : I [24]\n    32  pop\n    33  dup\n    34  invokevirtual X$Point3D.y() : I [28]\n    37  dup\n    38  instanceof X [1]\n    41  ifne 48\n    44  pop2\n    45  goto 74\n    48  checkcast X [1]\n    51  astore_2 [y]\n    52  invokevirtual X$Point3D.z() : I [31]\n    55  pop\n    56  getstatic System.out : PrintStream [34]\n    59  aload_2 [y]\n    60  invokevirtual Object.getClass() : Class [40]\n    63  invokestatic String.valueOf(Object) : String [44]\n    66  invokedynamic 0 makeConcatWithConstants(String) : String [50]\n    71  invokevirtual PrintStream.println(String) : void [54]\n    74  return\n    75  new MatchException [60]\n    78  dup_x1\n    79  swap\n    80  dup\n    81  invokevirtual Throwable.toString() : String [62]\n    84  swap\n    85  invokespecial MatchException(String, Throwable) [68]\n    88  athrow\n      Exception Table:\n        [pc: 29, pc: 32] -> 75 when : Throwable\n        [pc: 34, pc: 37] -> 75 when : Throwable\n        [pc: 52, pc: 55] -> 75 when : Throwable\n      Line numbers:\n        [pc: 0, line: 9]\n        [pc: 17, line: 10]\n        [pc: 56, line: 11]\n        [pc: 74, line: 13]\n      Local variable table:\n        [pc: 0, pc: 89] local: args index: 0 type: String[]\n        [pc: 17, pc: 75] local: o index: 1 type: Object\n        [pc: 52, pc: 74] local: y index: 2 type: X\n      Stack map table: number of frames 3\n        [pc: 48, full, stack: {X$Point3D, I}, locals: {String[], Object}]\n        [pc: 74, same]\n        [pc: 75, full, stack: {Throwable}, locals: {String[]}]\n";
        boolean savedPreview = this.enablePreview;
        try {
            this.enablePreview = true;
            this.checkClassFile("X", source, expectedOutput, 9);
        }
        finally {
            this.enablePreview = savedPreview;
        }
        this.runConformTest(new String[]{"X.java", source}, "Y is of class: class X");
    }

    public void testIssue2020_5() throws ClassFormatException, IOException {
        String source = "\t\t\tinterface I {}\n\t\t\tpublic class X implements I {\n\n  record Point3D (I x, I y, I z) {\n\n  }\n\n  public static void main(String[] args) {\n\tObject o = new Point3D(null, null, null);\n\tif (o instanceof Point3D(_, X y, _)) {\n\t\tSystem.out.println(\"Y is of class: \" + y.getClass());\n\t} else {\n\t\tSystem.out.println(\"No match\");\n\t}\n  }\n}\n";
        this.runConformTest(new String[]{"X.java", source}, "No match");
    }

    public void testIssue2020_6() throws ClassFormatException, IOException {
        String source = "\t\t\tinterface I {}\n\t\t\tpublic class X implements I {\n\n  record Point3D (I x, I y, I z) {\n\n  }\n\n  public static void main(String[] args) {\n\tObject o = new Point3D(null, null, new X());\n\tif (o instanceof Point3D(_, _, X y)) {\n\t\tSystem.out.println(\"Y is of class: \" + y.getClass());\n\t}\n  }\n}\n";
        this.runConformTest(new String[]{"X.java", source}, "Y is of class: class X");
    }

    public void testIssue1889_2() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic Object a0 = new Boolean(false);\n\n\tpublic boolean testMethod() {\n\t\tObject ax = a0;\n\t\tboolean res = false;\n\n\t\tif (ax instanceof Boolean _) {\n\t\t\tres = true;\n\t\t}\n\t\treturn res;\n\t}\n\n\tpublic static void main(String argv[]) {\n\t\tX c = new X();\n\t\tSystem.out.println(c.testMethod());\n\t}\n}\n"}, "true");
    }

    public void testIssue2007() {
        this.runConformTest(new String[]{"X.java", "record I<J> (int x) {}\nrecord O<T> (I<T> i) {}\npublic class X<T> {\n    public static void main(String argv[]) {\n    \tObject o = null;\n    \tif (o instanceof O(_)) {\n    \t\tSystem.out.println(\"Fail\");\n    \t} else {\n\t    \tSystem.out.println(\"Pass\");\n    \t}\n    }\n}\n"}, "Pass");
    }
}

