/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractBatchCompilerTest;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;

public class UseOfUnderscoreJava22Test
extends AbstractBatchCompilerTest {
    public static Test suite() {
        return UseOfUnderscoreJava22Test.buildMinimalComplianceTestSuite(UseOfUnderscoreJava22Test.class, 524288);
    }

    public UseOfUnderscoreJava22Test(String name) {
        super(name);
    }

    @Override
    protected Map<String, String> getCompilerOptions() {
        CompilerOptions compilerOptions = new CompilerOptions(super.getCompilerOptions());
        return compilerOptions.getMap();
    }

    @Override
    protected void runNegativeTest(String[] testFiles, String expectedCompilerLog) {
        if (!isJRE22Plus) {
            return;
        }
        this.runNegativeTest(false, null, testFiles, expectedCompilerLog);
    }

    public void testReportsUnderscoreInstanceMemberAsError() {
        String message = "As of release 22, '_' is only allowed to declare unnamed patterns, local variables, exception parameters or lambda parameters";
        String errorLevel = "ERROR";
        this.runNegativeTest(new String[]{"A.java", "public class A {\n\tint _ = 1;\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(\"Hello, World!\");\n\t}\n}\n"}, "----------\n1. " + errorLevel + " in A.java (at line 2)\n\tint _ = 1;\n\t    ^\n" + message + "\n----------\n");
    }

    public void testReportsUnicodeEscapeUnderscoreInstanceMemberAsError() {
        String message = "As of release 22, '_' is only allowed to declare unnamed patterns, local variables, exception parameters or lambda parameters";
        String errorLevel = "ERROR";
        this.runNegativeTest(new String[]{"A.java", "public class A {\n\tint \\u005F = 1;\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(\"Hello, World!\");\n\t}\n}\n"}, "----------\n1. " + errorLevel + " in A.java (at line 2)\n\tint \\u005F = 1;\n\t    ^^^^^^\n" + message + "\n----------\n");
    }

    public void testReportsUnderscoreParameterAsError() {
        String message = "As of release 22, '_' is only allowed to declare unnamed patterns, local variables, exception parameters or lambda parameters";
        String errorLevel = "ERROR";
        this.runNegativeTest(new String[]{"A.java", "public class A {\n\tpublic static void main(String[] args) {\n\t\tfoo(1);\n\t}\n\tpublic static void foo(int _) {\n\t\tSystem.out.println(\"Hello, World!\");\n\t}\n}\n"}, "----------\n1. " + errorLevel + " in A.java (at line 5)\n\tpublic static void foo(int _) {\n\t                           ^\n" + message + "\n----------\n");
    }

    public void testReportsUnderscoreParameterAsErrorUnicodeEscape() {
        String message = "As of release 22, '_' is only allowed to declare unnamed patterns, local variables, exception parameters or lambda parameters";
        String errorLevel = "ERROR";
        this.runNegativeTest(new String[]{"A.java", "public class A {\n\tpublic static void main(String[] args) {\n\t\tfoo(1);\n\t}\n\tpublic static void foo(int \\u005F) {\n\t\tSystem.out.println(\"Hello, World!\");\n\t}\n}\n"}, "----------\n1. " + errorLevel + " in A.java (at line 5)\n\tpublic static void foo(int \\u005F) {\n\t                           ^^^^^^\n" + message + "\n----------\n");
    }

    public void testReportsUnderscoreLocalVariableAsErrorUnicodeEscape() {
        if (!isJRE22Plus) {
            return;
        }
        this.runConformTest(new String[]{"A.java", "public class A {\n\tpublic static void main(String[] args) {\n\t\tint \\u005F = 12;\n\t\tSystem.out.println(\"hello, world\");\n\t}\n}\n"}, "hello, world", null, new String[]{"--enable-preview"});
    }
}

