/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractBatchCompilerTest;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;

public class UseOfUnderscoreTest
extends AbstractBatchCompilerTest {
    public static Test suite() {
        return UseOfUnderscoreTest.buildMinimalComplianceTestSuite(UseOfUnderscoreTest.class, 32);
    }

    public UseOfUnderscoreTest(String name) {
        super(name);
    }

    public void testReportsUnderscoreInstanceMemberAsError() {
        String errorLevel;
        String message;
        CompilerOptions options = new CompilerOptions(this.getCompilerOptions());
        if (options.sourceLevel < 0x350000L) {
            message = "'_' should not be used as an identifier, since it is a reserved keyword from source level 1.8 on";
            errorLevel = "WARNING";
        } else if (options.sourceLevel < 0x420000L) {
            message = "'_' is a keyword from source level 9 onwards, cannot be used as identifier";
            errorLevel = "ERROR";
        } else {
            message = "As of release 22, '_' is only allowed to declare unnamed patterns, local variables, exception parameters or lambda parameters";
            errorLevel = "ERROR";
        }
        this.runNegativeTest(new String[]{"A.java", "public class A {\n\tint _ = 1;\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(\"Hello, World!\");\n\t}\n}\n"}, "----------\n1. " + errorLevel + " in A.java (at line 2)\n\tint _ = 1;\n\t    ^\n" + message + "\n----------\n");
    }

    public void testReportsUnicodeEscapeUnderscoreInstanceMemberAsError() {
        String errorLevel;
        String message;
        CompilerOptions options = new CompilerOptions(this.getCompilerOptions());
        if (options.sourceLevel < 0x350000L) {
            message = "'_' should not be used as an identifier, since it is a reserved keyword from source level 1.8 on";
            errorLevel = "WARNING";
        } else if (options.sourceLevel < 0x420000L) {
            message = "'_' is a keyword from source level 9 onwards, cannot be used as identifier";
            errorLevel = "ERROR";
        } else {
            message = "As of release 22, '_' is only allowed to declare unnamed patterns, local variables, exception parameters or lambda parameters";
            errorLevel = "ERROR";
        }
        this.runNegativeTest(new String[]{"A.java", "public class A {\n\tint \\u005F = 1;\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(\"Hello, World!\");\n\t}\n}\n"}, "----------\n1. " + errorLevel + " in A.java (at line 2)\n\tint \\u005F = 1;\n\t    ^^^^^^\n" + message + "\n----------\n");
    }

    public void testReportsUnderscoreParameterAsError() {
        String errorLevel;
        String message;
        CompilerOptions options = new CompilerOptions(this.getCompilerOptions());
        if (options.sourceLevel < 0x350000L) {
            message = "'_' should not be used as an identifier, since it is a reserved keyword from source level 1.8 on";
            errorLevel = "WARNING";
        } else if (options.sourceLevel < 0x420000L) {
            message = "'_' is a keyword from source level 9 onwards, cannot be used as identifier";
            errorLevel = "ERROR";
        } else {
            message = "As of release 22, '_' is only allowed to declare unnamed patterns, local variables, exception parameters or lambda parameters";
            errorLevel = "ERROR";
        }
        this.runNegativeTest(new String[]{"A.java", "public class A {\n\tpublic static void main(String[] args) {\n\t\tfoo(1);\n\t}\n\tpublic static void foo(int _) {\n\t\tSystem.out.println(\"Hello, World!\");\n\t}\n}\n"}, "----------\n1. " + errorLevel + " in A.java (at line 5)\n\tpublic static void foo(int _) {\n\t                           ^\n" + message + "\n----------\n");
    }

    public void testReportsUnderscoreParameterAsErrorUnicodeEscape() {
        String errorLevel;
        String message;
        CompilerOptions options = new CompilerOptions(this.getCompilerOptions());
        if (options.sourceLevel < 0x350000L) {
            message = "'_' should not be used as an identifier, since it is a reserved keyword from source level 1.8 on";
            errorLevel = "WARNING";
        } else if (options.sourceLevel < 0x420000L) {
            message = "'_' is a keyword from source level 9 onwards, cannot be used as identifier";
            errorLevel = "ERROR";
        } else {
            message = "As of release 22, '_' is only allowed to declare unnamed patterns, local variables, exception parameters or lambda parameters";
            errorLevel = "ERROR";
        }
        this.runNegativeTest(new String[]{"A.java", "public class A {\n\tpublic static void main(String[] args) {\n\t\tfoo(1);\n\t}\n\tpublic static void foo(int \\u005F) {\n\t\tSystem.out.println(\"Hello, World!\");\n\t}\n}\n"}, "----------\n1. " + errorLevel + " in A.java (at line 5)\n\tpublic static void foo(int \\u005F) {\n\t                           ^^^^^^\n" + message + "\n----------\n");
    }

    public void testReportsUnderscoreLocalVariableAsErrorUnicodeEscape() {
        CompilerOptions options = new CompilerOptions(this.getCompilerOptions());
        String SOURCE_CODE = "\tpublic class A {\n\tpublic static void main(String[] args) {\n\t\tint \\u005F = 12;\n\t\tSystem.out.println(\"hello, world\");\n\t}\n}\n";
        if (options.sourceLevel < 0x350000L) {
            this.runNegativeTest(new String[]{"A.java", SOURCE_CODE}, "----------\n1. WARNING in A.java (at line 3)\n\tint \\u005F = 12;\n\t    ^^^^^^\n'_' should not be used as an identifier, since it is a reserved keyword from source level 1.8 on\n----------\n");
        } else if (options.sourceLevel < 0x420000L) {
            this.runNegativeTest(new String[]{"A.java", SOURCE_CODE}, "----------\n1. ERROR in A.java (at line 3)\n\tint \\u005F = 12;\n\t    ^^^^^^\n'_' is a keyword from source level 9 onwards, cannot be used as identifier\n----------\n");
        } else {
            this.runConformTest(new String[]{"A.java", SOURCE_CODE}, "hello, world");
        }
    }
}

