/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileConstants;

public class ValueBasedAnnotationTests
extends AbstractRegressionTest {
    public static Class<?> testClass() {
        return ValueBasedAnnotationTests.class;
    }

    public static Test suite() {
        return ValueBasedAnnotationTests.buildMinimalComplianceTestSuite(ValueBasedAnnotationTests.testClass(), 8192);
    }

    public ValueBasedAnnotationTests(String testName) {
        super(testName);
    }

    @Override
    protected Map<String, String> getCompilerOptions() {
        Map<String, String> defaultOptions = super.getCompilerOptions();
        if (this.complianceLevel >= ClassFileConstants.getLatestJDKLevel()) {
            defaultOptions.put("org.eclipse.jdt.core.compiler.problem.enablePreviewFeatures", "enabled");
        }
        return defaultOptions;
    }

    protected void runWarningTest(String[] testFiles, String expectedCompilerLog) {
        this.runWarningTest(testFiles, expectedCompilerLog, null);
    }

    protected void runWarningTest(String[] testFiles, String expectedCompilerLog, Map<String, String> customOptions) {
        this.runWarningTest(testFiles, expectedCompilerLog, customOptions, null);
    }

    protected void runWarningTest(String[] testFiles, String expectedCompilerLog, Map<String, String> customOptions, String javacAdditionalTestOptions) {
        if (!isJRE16Plus) {
            return;
        }
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.testFiles = testFiles;
        runner.expectedCompilerLog = expectedCompilerLog;
        runner.customOptions = customOptions;
        runner.vmArguments = new String[]{"--enable-preview"};
        runner.javacTestOptions = javacAdditionalTestOptions == null ? AbstractRegressionTest.JavacTestOptions.forReleaseWithPreview("16") : AbstractRegressionTest.JavacTestOptions.forReleaseWithPreview("16", javacAdditionalTestOptions);
        runner.runWarningTest();
    }

    @Override
    protected void runConformTest(String[] testFiles) {
        this.runConformTest(testFiles, (Map<String, String>)null, (String)null);
    }

    protected void runConformTest(String[] testFiles, Map<String, String> customOptions, String javacAdditionalTestOptions) {
        if (!isJRE16Plus) {
            return;
        }
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.testFiles = testFiles;
        runner.customOptions = customOptions;
        runner.vmArguments = new String[]{"--enable-preview"};
        runner.javacTestOptions = javacAdditionalTestOptions == null ? AbstractRegressionTest.JavacTestOptions.forReleaseWithPreview("16") : AbstractRegressionTest.JavacTestOptions.forReleaseWithPreview("16", javacAdditionalTestOptions);
        runner.runConformTest();
    }

    public void testBug571507_001() {
        this.runWarningTest(new String[]{"X.java", "class X {\n  public static void main(String[] args){\n\t\tInteger abc= Integer.valueOf(10);\n\t\tsynchronized(abc) {\n\t\t\t\n\t\t}  }\n}\n"}, "----------\n1. WARNING in X.java (at line 4)\n\tsynchronized(abc) {\n\t             ^^^\nInteger is a value-based type which is a discouraged argument for the synchronized statement\n----------\n");
    }

    public void testBug571507_002() {
        this.runWarningTest(new String[]{"X.java", "import java.util.Optional;\n\nclass X {\n  public static void main(String[] args){\n\t\tString[] sentence = new String[10];\n       Optional<String> abc = Optional.ofNullable(sentence[9]);  \n\t\tsynchronized (abc) { // no error given here.\n\t\t}\n  }\n}\n"}, "----------\n1. WARNING in X.java (at line 7)\n\tsynchronized (abc) { // no error given here.\n\t              ^^^\nOptional<T> is a value-based type which is a discouraged argument for the synchronized statement\n----------\n");
    }

    public void testBug571507_003() {
        this.runConformTest(new String[]{"X.java", "import java.util.HashSet;\n\nclass X {\n  public static void main(String[] args){\n\t\tString[] sentence = new String[10];\n       HashSet<String> abc = new HashSet<>();  \n\t\tsynchronized (abc) { // no error given here.\n\t\t}\n  }\n}\n"});
    }
}

