/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.io.File;
import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractComparableTest;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;
import org.eclipse.jdt.core.util.IClassFileAttribute;
import org.eclipse.jdt.core.util.IClassFileReader;
import org.eclipse.jdt.core.util.IMethodInfo;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;

public class VarargsTest
extends AbstractComparableTest {
    public VarargsTest(String name) {
        super(name);
    }

    public static Test suite() {
        return VarargsTest.buildComparableTestSuite(VarargsTest.testClass());
    }

    public static Class testClass() {
        return VarargsTest.class;
    }

    @Override
    protected Map getCompilerOptions() {
        Map defaultOptions = super.getCompilerOptions();
        defaultOptions.put("org.eclipse.jdt.core.compiler.problem.unusedLambdaParameter", "ignore");
        return defaultOptions;
    }

    @Override
    protected String intersection(String ... types) {
        return String.join((CharSequence)" & ", types);
    }

    public void test001() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] s) {\n\t\tSystem.out.print('<');\n\t\tY y = new Y();\n\t\ty = new Y(null);\n\t\ty = new Y(1);\n\t\ty = new Y(1, 2, (byte) 3, 4);\n\t\ty = new Y(new int[] {1, 2, 3, 4 });\n\t\t\n\t\tY.count();\n\t\tY.count(null);\n\t\tY.count(1);\n\t\tY.count(1, 2, (byte) 3, 4);\n\t\tY.count(new int[] {1, 2, 3, 4 });\n\t\tSystem.out.print('>');\n\t}\n}\n", "Y.java", "public class Y {\n\tpublic Y(int ... values) {\n\t\tint result = 0;\n\t\tfor (int i = 0, l = values == null ? 0 : values.length; i < l; i++)\n\t\t\tresult += values[i];\n\t\tSystem.out.print(result);\n\t\tSystem.out.print(' ');\n\t}\n\tpublic static void count(int ... values) {\n\t\tint result = 0;\n\t\tfor (int i = 0, l = values == null ? 0 : values.length; i < l; i++)\n\t\t\tresult += values[i];\n\t\tSystem.out.print(result);\n\t\tSystem.out.print(' ');\n\t}\n}\n"}, "<0 0 1 10 10 0 0 1 10 10 >");
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] s) {\n\t\tSystem.out.print('<');\n\t\tY y = new Y();\n\t\ty = new Y(null);\n\t\ty = new Y(1);\n\t\ty = new Y(1, 2, (byte) 3, 4);\n\t\ty = new Y(new int[] {1, 2, 3, 4 });\n\t\t\n\t\tY.count();\n\t\tY.count(null);\n\t\tY.count(1);\n\t\tY.count(1, 2, (byte) 3, 4);\n\t\tY.count(new int[] {1, 2, 3, 4 });\n\t\tSystem.out.print('>');\n\t}\n}\n"}, "<0 0 1 10 10 0 0 1 10 10 >", null, false, null);
    }

    public void test002() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] s) {\n\t\tSystem.out.print('<');\n\t\tY y = new Y();\n\t\ty = new Y(null);\n\t\ty = new Y(1);\n\t\ty = new Y(1, 2, (byte) 3, 4);\n\t\ty = new Y(new int[] {1, 2, 3, 4 });\n\t\tSystem.out.print('>');\n\t}\n}\n", "Y.java", "public class Y extends Z {\n\tpublic Y(int ... values) { super(values); }\n}\nclass Z {\n\tpublic Z(int ... values) {\n\t\tint result = 0;\n\t\tfor (int i = 0, l = values == null ? 0 : values.length; i < l; i++)\n\t\t\tresult += values[i];\n\t\tSystem.out.print(result);\n\t\tSystem.out.print(' ');\n\t}\n}\n"}, "<0 0 1 10 10 >");
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] s) {\n\t\tSystem.out.print('<');\n\t\tY y = new Y();\n\t\ty = new Y(null);\n\t\ty = new Y(1);\n\t\ty = new Y(1, 2, (byte) 3, 4);\n\t\ty = new Y(new int[] {1, 2, 3, 4 });\n\t\tSystem.out.print('>');\n\t}\n}\n"}, "<0 0 1 10 10 >", null, false, null);
    }

    public void test003() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] s) {\n\t\tSystem.out.print('<');\n\t\tY.count();\n\t\tY.count((int[]) null);\n\t\tY.count((int[][]) null);\n\t\tY.count(new int[] {1});\n\t\tY.count(new int[] {1, 2}, new int[] {3, 4});\n\t\tY.count(new int[][] {new int[] {1, 2, 3}, new int[] {4}});\n\t\tSystem.out.print('>');\n\t}\n}\n", "Y.java", "public class Y {\n\tpublic static int count(int[] values) {\n\t\tint result = 0;\n\t\tfor (int i = 0, l = values == null ? 0 : values.length; i < l; i++)\n\t\t\tresult += values[i];\n\t\tSystem.out.print(' ');\n\t\tSystem.out.print(result);\n\t\treturn result;\n\t}\n\tpublic static void count(int[] ... values) {\n\t\tint result = 0;\n\t\tfor (int i = 0, l = values == null ? 0 : values.length; i < l; i++)\n\t\t\tresult += count(values[i]);\n\t\tSystem.out.print('=');\n\t\tSystem.out.print(result);\n\t}\n}\n"}, "<=0 0=0 1 3 7=10 6 4=10>");
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] s) {\n\t\tSystem.out.print('<');\n\t\tY.count();\n\t\tY.count((int[]) null);\n\t\tY.count((int[][]) null);\n\t\tY.count(new int[] {1});\n\t\tY.count(new int[] {1, 2}, new int[] {3, 4});\n\t\tY.count(new int[][] {new int[] {1, 2, 3}, new int[] {4}});\n\t\tSystem.out.print('>');\n\t}\n}\n"}, "<=0 0=0 1 3 7=10 6 4=10>", null, false, null);
    }

    public void test004() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] s) {\n\t\tSystem.out.print('<');\n\t\tY.count(0);\n\t\tY.count(-1, (int[]) null);\n\t\tY.count(-2, (int[][]) null);\n\t\tY.count(1);\n\t\tY.count(2, new int[] {1});\n\t\tY.count(3, new int[] {1}, new int[] {2, 3}, new int[] {4});\n\t\tY.count((byte) 4, new int[][] {new int[] {1}, new int[] {2, 3}, new int[] {4}});\n\t\tSystem.out.print('>');\n\t}\n}\n", "Y.java", "public class Y {\n\tpublic static int count(int j, int[] values) {\n\t\tint result = j;\n\t\tSystem.out.print(' ');\n\t\tSystem.out.print('[');\n\t\tfor (int i = 0, l = values == null ? 0 : values.length; i < l; i++)\n\t\t\tresult += values[i];\n\t\tSystem.out.print(result);\n\t\tSystem.out.print(']');\n\t\treturn result;\n\t}\n\tpublic static void count(int j, int[] ... values) {\n\t\tint result = j;\n\t\tSystem.out.print(' ');\n\t\tSystem.out.print(result);\n\t\tSystem.out.print(':');\n\t\tfor (int i = 0, l = values == null ? 0 : values.length; i < l; i++)\n\t\t\tresult += count(j, values[i]);\n\t\tSystem.out.print('=');\n\t\tSystem.out.print(result);\n\t}\n}\n"}, "< 0:=0 [-1] -2:=-2 1:=1 [3] 3: [4] [8] [7]=22 4: [5] [9] [8]=26>");
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] s) {\n\t\tSystem.out.print('<');\n\t\tY.count(0);\n\t\tY.count(-1, (int[]) null);\n\t\tY.count(-2, (int[][]) null);\n\t\tY.count(1);\n\t\tY.count(2, new int[] {1});\n\t\tY.count(3, new int[] {1}, new int[] {2, 3}, new int[] {4});\n\t\tY.count((byte) 4, new int[][] {new int[] {1}, new int[] {2, 3}, new int[] {4}});\n\t\tSystem.out.print('>');\n\t}\n}\n"}, "< 0:=0 [-1] -2:=-2 1:=1 [3] 3: [4] [8] [7]=22 4: [5] [9] [8]=26>", null, false, null);
    }

    public void test005() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] s) {\n\t\tSystem.out.print('<');\n\t\tY.print();\n\t\tY.print(Integer.valueOf(1));\n\t\tY.print(Integer.valueOf(1), Byte.valueOf((byte) 3), Integer.valueOf(7));\n\t\tY.print(new Integer[] {Integer.valueOf(11) });\n\t\tSystem.out.print('>');\n\t}\n}\n", "Y.java", "public class Y {\n\tpublic static void print(Number ... values) {\n\t\tfor (int i = 0, l = values.length; i < l; i++) {\n\t\t\tSystem.out.print(' ');\n\t\t\tSystem.out.print(values[i]);\n\t\t}\n\t\tSystem.out.print(',');\n\t}\n}\n"}, "<, 1, 1 3 7, 11,>");
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] s) {\n\t\tSystem.out.print('<');\n\t\tY.print();\n\t\tY.print(Integer.valueOf(1));\n\t\tY.print(Integer.valueOf(1), Byte.valueOf((byte) 3), Integer.valueOf(7));\n\t\tY.print(new Integer[] {Integer.valueOf(11) });\n\t\tSystem.out.print('>');\n\t}\n}\n"}, "<, 1, 1 3 7, 11,>", null, false, null);
    }

    public void test006() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] s) {\n\t\tString[] T_NAMES = new String[] {\"foo\"};\n\t\tString error = \"error\";\n\t\tY.format(\"E_UNSUPPORTED_CONV\", Integer.valueOf(0));\n\t\tY.format(\"E_SAVE\", T_NAMES[0], error);\n\t}\n}\nclass Y {\n\tpublic static String format(String key) { return null; }\n\tpublic static String format(String key, Object ... args) { return null; }\n}\n"}, "");
    }

    public void test007() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] s) {\n\t\tY.byte2(null);\n\t\tY.byte2((byte) 1);\n\t\tY.byte2(new byte[] {});\n\t\tY.byte2(new byte[][] {});\n\t\tY.byte2(new byte[][][] {});\n\n\t\tY.object(null);\n\t\tY.object((byte) 1);\n\t\tY.object(new byte[] {});\n\t\tY.object(new byte[][] {});\n\t\tY.object(new byte[][][] {});\n\n\t\tY.object(new String());\n\t\tY.object(new String[] {});\n\t\tY.object(new String[][] {});\n\n\t\tY.object2(null);\n\t\tY.object2((byte) 1);\n\t\tY.object2(new byte[] {});\n\t\tY.object2(new byte[][] {});\n\t\tY.object2(new byte[][][] {});\n\n\t\tY.object2(new String());\n\t\tY.object2(new String[] {});\n\t\tY.object2(new String[][] {});\n\n\t\tY.string(null);\n\t\tY.string(new String());\n\t\tY.string(new String[] {});\n\t\tY.string(new String[][] {});\n\n\t\tY.string(new Object());\n\t\tY.string(new Object[] {});\n\t\tY.string(new Object[][] {});\n\t}\n}\nclass Y {\n\tpublic static void byte2(byte[] ... values) {}\n\tpublic static void object(Object ... values) {}\n\tpublic static void object2(Object[] ... values) {}\n\tpublic static void string(String ... values) {}\n}\n"}, "----------\n1. WARNING in X.java (at line 3)\n\tY.byte2(null);\n\t^^^^^^^^^^^^^\nType null of the last argument to method byte2(byte[]...) doesn't exactly match the vararg parameter type. Cast to byte[][] to confirm the non-varargs invocation, or pass individual arguments of type byte[] for a varargs invocation.\n----------\n2. ERROR in X.java (at line 4)\n\tY.byte2((byte) 1);\n\t  ^^^^^\nThe method byte2(byte[]...) in the type Y is not applicable for the arguments (byte)\n----------\n3. ERROR in X.java (at line 7)\n\tY.byte2(new byte[][][] {});\n\t  ^^^^^\nThe method byte2(byte[]...) in the type Y is not applicable for the arguments (byte[][][])\n----------\n4. WARNING in X.java (at line 9)\n\tY.object(null);\n\t^^^^^^^^^^^^^^\nType null of the last argument to method object(Object...) doesn't exactly match the vararg parameter type. Cast to Object[] to confirm the non-varargs invocation, or pass individual arguments of type Object for a varargs invocation.\n----------\n5. WARNING in X.java (at line 12)\n\tY.object(new byte[][] {});\n\t^^^^^^^^^^^^^^^^^^^^^^^^^\nType byte[][] of the last argument to method object(Object...) doesn't exactly match the vararg parameter type. Cast to Object[] to confirm the non-varargs invocation, or pass individual arguments of type Object for a varargs invocation.\n----------\n6. WARNING in X.java (at line 13)\n\tY.object(new byte[][][] {});\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType byte[][][] of the last argument to method object(Object...) doesn't exactly match the vararg parameter type. Cast to Object[] to confirm the non-varargs invocation, or pass individual arguments of type Object for a varargs invocation.\n----------\n7. WARNING in X.java (at line 16)\n\tY.object(new String[] {});\n\t^^^^^^^^^^^^^^^^^^^^^^^^^\nType String[] of the last argument to method object(Object...) doesn't exactly match the vararg parameter type. Cast to Object[] to confirm the non-varargs invocation, or pass individual arguments of type Object for a varargs invocation.\n----------\n8. WARNING in X.java (at line 17)\n\tY.object(new String[][] {});\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType String[][] of the last argument to method object(Object...) doesn't exactly match the vararg parameter type. Cast to Object[] to confirm the non-varargs invocation, or pass individual arguments of type Object for a varargs invocation.\n----------\n9. WARNING in X.java (at line 19)\n\tY.object2(null);\n\t^^^^^^^^^^^^^^^\nType null of the last argument to method object2(Object[]...) doesn't exactly match the vararg parameter type. Cast to Object[][] to confirm the non-varargs invocation, or pass individual arguments of type Object[] for a varargs invocation.\n----------\n10. ERROR in X.java (at line 20)\n\tY.object2((byte) 1);\n\t  ^^^^^^^\nThe method object2(Object[]...) in the type Y is not applicable for the arguments (byte)\n----------\n11. ERROR in X.java (at line 21)\n\tY.object2(new byte[] {});\n\t  ^^^^^^^\nThe method object2(Object[]...) in the type Y is not applicable for the arguments (byte[])\n----------\n12. WARNING in X.java (at line 23)\n\tY.object2(new byte[][][] {});\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType byte[][][] of the last argument to method object2(Object[]...) doesn't exactly match the vararg parameter type. Cast to Object[][] to confirm the non-varargs invocation, or pass individual arguments of type Object[] for a varargs invocation.\n----------\n13. ERROR in X.java (at line 25)\n\tY.object2(new String());\n\t  ^^^^^^^\nThe method object2(Object[]...) in the type Y is not applicable for the arguments (String)\n----------\n14. WARNING in X.java (at line 27)\n\tY.object2(new String[][] {});\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType String[][] of the last argument to method object2(Object[]...) doesn't exactly match the vararg parameter type. Cast to Object[][] to confirm the non-varargs invocation, or pass individual arguments of type Object[] for a varargs invocation.\n----------\n15. WARNING in X.java (at line 29)\n\tY.string(null);\n\t^^^^^^^^^^^^^^\nType null of the last argument to method string(String...) doesn't exactly match the vararg parameter type. Cast to String[] to confirm the non-varargs invocation, or pass individual arguments of type String for a varargs invocation.\n----------\n16. ERROR in X.java (at line 32)\n\tY.string(new String[][] {});\n\t  ^^^^^^\nThe method string(String...) in the type Y is not applicable for the arguments (String[][])\n----------\n17. ERROR in X.java (at line 34)\n\tY.string(new Object());\n\t  ^^^^^^\nThe method string(String...) in the type Y is not applicable for the arguments (Object)\n----------\n18. ERROR in X.java (at line 35)\n\tY.string(new Object[] {});\n\t  ^^^^^^\nThe method string(String...) in the type Y is not applicable for the arguments (Object[])\n----------\n19. ERROR in X.java (at line 36)\n\tY.string(new Object[][] {});\n\t  ^^^^^^\nThe method string(String...) in the type Y is not applicable for the arguments (Object[][])\n----------\n");
    }

    public void test008() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] s) {\n\t\tY y = new Y(null);\n\t\ty = new Y(true, null);\n\t\ty = new Y('i', null);\n\t}\n}\nclass Y {\n\tpublic Y(int ... values) {}\n\tpublic Y(boolean b, Object ... values) {}\n\tpublic Y(char c, int[] ... values) {}\n}\n"}, "----------\n1. WARNING in X.java (at line 4)\n\ty = new Y(true, null);\n\t    ^^^^^^^^^^^^^^^^^\nType null of the last argument to constructor Y(boolean, Object...) doesn't exactly match the vararg parameter type. Cast to Object[] to confirm the non-varargs invocation, or pass individual arguments of type Object for a varargs invocation.\n----------\n2. WARNING in X.java (at line 5)\n\ty = new Y('i', null);\n\t    ^^^^^^^^^^^^^^^^\nType null of the last argument to constructor Y(char, int[]...) doesn't exactly match the vararg parameter type. Cast to int[][] to confirm the non-varargs invocation, or pass individual arguments of type int[] for a varargs invocation.\n----------\n");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] s) {\n\t\tY y = new Y(null);\n\t\ty = new Y(true, null);\n\t\ty = new Y('i', null);\n\t}\n}\nclass Y extends Z {\n\tpublic Y(int ... values) { super(values); }\n\tpublic Y(boolean b, Object ... values) { super(b, values); }\n\tpublic Y(char c, int[] ... values) {}\n}\nclass Z {\n\tpublic Z(int ... values) {}\n\tpublic Z(boolean b, Object ... values) {}\n\tpublic Z(char c, int[] ... values) {}\n}\n"}, "----------\n1. WARNING in X.java (at line 4)\n\ty = new Y(true, null);\n\t    ^^^^^^^^^^^^^^^^^\nType null of the last argument to constructor Y(boolean, Object...) doesn't exactly match the vararg parameter type. Cast to Object[] to confirm the non-varargs invocation, or pass individual arguments of type Object for a varargs invocation.\n----------\n2. WARNING in X.java (at line 5)\n\ty = new Y('i', null);\n\t    ^^^^^^^^^^^^^^^^\nType null of the last argument to constructor Y(char, int[]...) doesn't exactly match the vararg parameter type. Cast to int[][] to confirm the non-varargs invocation, or pass individual arguments of type int[] for a varargs invocation.\n----------\n");
    }

    public void test009() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] s) {\n\t\tSystem.out.print('<');\n\t\tY.count(null);\n\t\tY.count(1);\n\t\tY.count(1, 2);\n\n\t\tZ.count(1L, 1);\n\t\tZ.count(1, 1);\n\t\tZ.count(1, null);\n\t\tZ.count2(1, null);\n\t\tZ.count2(1L, null);\n\t\tSystem.out.print('>');\n\t}\n}\nclass Y {\n\tpublic static void count(int values) { System.out.print('1'); }\n\tpublic static void count(int ... values) { System.out.print('2'); }\n}\nclass Z {\n\tpublic static void count(long l, long values) { System.out.print('3'); }\n\tpublic static void count(int i, int ... values) { System.out.print('4'); }\n\tpublic static void count2(int i, int values) { System.out.print('5'); }\n\tpublic static void count2(long l, int ... values) { System.out.print('6'); }\n}\n"}, "<21233466>");
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] s) {\n\t\tSystem.out.print('<');\n\t\tY.test((Object[]) null);\n\t\tY.test(null, null);\n\t\tY.test(null, null, null);\n\t\tSystem.out.print('>');\n\t}\n}\nclass Y {\n\tpublic static void test(Object o, Object o2) { System.out.print('1'); }\n\tpublic static void test(Object ... values) { System.out.print('2'); }\n}\n"}, "<212>");
    }

    public void test010() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] s) {\n\t\tSystem.out.print('<');\n\t\tY.count((Object) Integer.valueOf(1));\n\t\tY.count(Integer.valueOf(1));\n\n\t\tY.count((Object) null);\n\t\tY.count((Object[]) null);\n\t\tSystem.out.print('>');\n\t}\n}\nclass Y {\n\tpublic static void count(Object values) { System.out.print('1'); }\n\tpublic static void count(Object ... values) { System.out.print('2'); }\n}\n"}, "<1112>");
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] s) {\n\t\tSystem.out.print('<');\n\t\tY.count(new Object[] {Integer.valueOf(1)});\n\t\tY.count(new Integer[] {Integer.valueOf(1)});\n\n\t\tY.count((Object[]) null);\n\t\tY.count((Object[][]) null);\n\t\tSystem.out.print('>');\n\t}\n}\nclass Y {\n\tpublic static void count(Object[] values) { System.out.print('1'); }\n\tpublic static void count(Object[] ... values) { System.out.print('2'); }\n}\n"}, "<1112>");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] s) {\n\t\tY.string(null);\n\t\tY.string2(null);\n\t\tY.int2(null);\n\t}\n}\nclass Y {\n\tpublic static void string(String values) { System.out.print('1'); }\n\tpublic static void string(String ... values) { System.out.print('2'); }\n\tpublic static void string2(String[] values) { System.out.print('1'); }\n\tpublic static void string2(String[] ... values) { System.out.print('2'); }\n\tpublic static void int2(int[] values) { System.out.print('1'); }\n\tpublic static void int2(int[] ... values) { System.out.print('2'); }\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tY.string(null);\n\t  ^^^^^^\nThe method string(String) is ambiguous for the type Y\n----------\n2. ERROR in X.java (at line 4)\n\tY.string2(null);\n\t  ^^^^^^^\nThe method string2(String[]) is ambiguous for the type Y\n----------\n3. ERROR in X.java (at line 5)\n\tY.int2(null);\n\t  ^^^^\nThe method int2(int[]) is ambiguous for the type Y\n----------\n");
    }

    public void test011() {
        this.runConformTest(true, new String[]{"X.java", "public class X { void count(int ... values) {} }\nclass Y extends X { void count(int[] values) {} }\nclass Z extends Y { void count(int... values) {} }\n"}, "----------\n1. WARNING in X.java (at line 2)\n\tclass Y extends X { void count(int[] values) {} }\n\t                         ^^^^^^^^^^^^^^^^^^^\nVarargs methods should only override or be overridden by other varargs methods unlike Y.count(int[]) and X.count(int...)\n----------\n2. WARNING in X.java (at line 2)\n\tclass Y extends X { void count(int[] values) {} }\n\t                         ^^^^^^^^^^^^^^^^^^^\nThe method count(int[]) of type Y should be tagged with @Override since it actually overrides a superclass method\n----------\n3. WARNING in X.java (at line 3)\n\tclass Z extends Y { void count(int... values) {} }\n\t                         ^^^^^^^^^^^^^^^^^^^^\nVarargs methods should only override or be overridden by other varargs methods unlike Z.count(int...) and Y.count(int[])\n----------\n4. WARNING in X.java (at line 3)\n\tclass Z extends Y { void count(int... values) {} }\n\t                         ^^^^^^^^^^^^^^^^^^^^\nThe method count(int...) of type Z should be tagged with @Override since it actually overrides a superclass method\n----------\n", null, null, AbstractRegressionTest.JavacTestOptions.EclipseHasABug.EclipseBug236379);
    }

    public void test012() {
        this.runConformTest(new String[]{"X.java", "public class X {\n   public static void main (String ... args) {\n       for (String a:args) {\n           System.out.println(a);\n       }\n   }\n}\n\n"});
    }

    public void test013() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] s) {\n\t\tY.count(1, 1);\n\t}\n}\nclass Y {\n\tpublic static void count(long i, int j) { System.out.print(1); }\n\tpublic static void count(int ... values) { System.out.print(2); }\n}\n"}, "1");
    }

    public void test014() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] s) {\n\t\tY.count(new int[0], 1);\n\t\tY.count(new int[0], 1, 1);\n\t}\n}\nclass Y {\n\tpublic static void count(int[] array, int ... values) { System.out.print(1); }\n\tpublic static void count(Object o, int ... values) { System.out.print(2); }\n}\n"}, "11");
    }

    public void test015() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] s) {\n\t\tY.count(new int[0]);\n\t}\n}\nclass Y {\n\tpublic static void count(int[] array, int ... values) { System.out.print(1); }\n\tpublic static void count(int[] array, int[] ... values) { System.out.print(2); }\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tY.count(new int[0]);\n\t  ^^^^^\nThe method count(int[], int[]) is ambiguous for the type Y\n----------\n");
    }

    public void test015_tolerate() throws Exception {
        Map options = this.getCompilerOptions();
        try {
            System.setProperty("tolerateIllegalAmbiguousVarargsInvocation", "true");
            this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] s) {\n\t\tY.count(new int[0]);\n\t}\n}\nclass Y {\n\tpublic static void count(int[] array, int ... values) { System.out.print(1); }\n\tpublic static void count(int[] array, int[] ... values) { System.out.print(2); }\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tY.count(new int[0]);\n\t  ^^^^^\nThe method count(int[], int[]) is ambiguous for the type Y\n----------\n", null, true, options);
        }
        finally {
            System.setProperty("tolerateIllegalAmbiguousVarargsInvocation", "false");
        }
    }

    public void test016() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] s) {\n\t\tY.count(new int[0]);\n\t\tY.count(new int[0], null);\n\t}\n}\nclass Y {\n\tpublic static void count(int[] array, int ... values) { System.out.print(0); }\n\tpublic static void count(int[] array, int[][] ... values) { System.out.print(1); }\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tY.count(new int[0]);\n\t  ^^^^^\nThe method count(int[], int[]) is ambiguous for the type Y\n----------\n2. ERROR in X.java (at line 4)\n\tY.count(new int[0], null);\n\t  ^^^^^\nThe method count(int[], int[]) is ambiguous for the type Y\n----------\n");
    }

    public void test017() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] s) {\n\t\tY.count(new int[0], 1);\n\t\tY.count(new int[0], 1, 1);\n\t\tY.count(new int[0], 1, 1, 1);\n\t}\n}\nclass Y {\n\tpublic static void count(int[] array, int ... values) {}\n\tpublic static void count(int[] array, int[] ... values) {}\n\tpublic static void count(int[] array, int i, int ... values) {}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tY.count(new int[0], 1);\n\t  ^^^^^\nThe method count(int[], int[]) is ambiguous for the type Y\n----------\n2. ERROR in X.java (at line 4)\n\tY.count(new int[0], 1, 1);\n\t  ^^^^^\nThe method count(int[], int[]) is ambiguous for the type Y\n----------\n3. ERROR in X.java (at line 5)\n\tY.count(new int[0], 1, 1, 1);\n\t  ^^^^^\nThe method count(int[], int[]) is ambiguous for the type Y\n----------\n");
    }

    public void test018() {
        this.runConformTest(new String[]{"X.java", "import java.util.*;\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tString[][] x = {{\"X\"}, {\"Y\"}};\n\t\tList l = Arrays.asList(x);\n\t\tSystem.out.println(l.size() + \" \" + l.get(0).getClass().getName());\n\t}\n}\n"}, "2 [Ljava.lang.String;");
    }

    public void test019() {
        this.runConformTest(new String[]{"X.java", "import java.util.*;\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tString[][] x = {{\"X\"}, {\"Y\"}};\n\t\tSystem.out.println(asList(x[0], x[1]).get(1).getClass().getName());\n\t}\n\tstatic <U> List<U> asList(U u1, U... us) {\n\t\tList<U> result = new ArrayList<U>();\n\t\tresult.add(u1);\n\t\tresult.add(us[0]);\n\t\treturn result;\n\t}\n}\n"}, "java.lang.String");
    }

    public void test020() {
        this.runConformTest(new String[]{"X.java", "import java.util.*;\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tString[][] x = {{\"X\"}, {\"Y\"}};\n\t\tSystem.out.println(asList(x[0], x).get(1).getClass().getName());\n\t}\n\tstatic <U> List<U> asList(U u1, U... us) {\n\t\tList<U> result = new ArrayList<U>();\n\t\tresult.add(u1);\n\t\tresult.add(us[0]);\n\t\treturn result;\n\t}\n}\n"}, "[Ljava.lang.String;");
    }

    public void test021() {
        this.runConformTest(new String[]{"X.java", "import java.util.ArrayList;\nimport java.util.Arrays;\n\npublic class X {\n   public static void main(String[] args) {\n      String[][] arr = new String[][] { args };\n      ArrayList<String[]> al = new ArrayList<String[]>(Arrays.asList(arr));\n   }\n}\n"}, "");
    }

    public void test022() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tString[] args;\n\tpublic X(String... args) {\n\t\tthis.args = args;\n\t}\n\tpublic static X foo() {\n\t\treturn new X(\"SU\", \"C\", \"CE\", \"SS\"){};\n\t}\n\tpublic String bar() {\n\t\tif (this.args != null) {\n\t\t\tStringBuffer buffer = new StringBuffer();\n\t\t\tfor (String s : this.args) {\n\t\t\t\tbuffer.append(s);\n\t\t\t}\n\t\t\treturn String.valueOf(buffer);\n\t\t}\n\t\treturn null;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.print(foo().bar());\n\t}\n}\n"}, "SUCCESS");
    }

    public void test023() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static void main (String[] args) {\n        new X().test (new byte[5]);\n\t\t System.out.print(\"SUCCESS\");\n    }\n    private void test (Object... params) {\n    }\n}"}, "SUCCESS");
    }

    public void test024() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tstatic boolean foo(Object... args) {\n\t\treturn args == null;\n\t}\n\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(foo(null, null));\n\t}\n}"}, "false");
    }

    public void test025() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tstatic boolean foo(Object... args) {\n\t\treturn args == null;\n\t}\n\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(foo(null));\n\t}\n}"}, "true");
    }

    public void test026() {
        this.runConformTest(new String[]{"X.java", "import java.util.*;\npublic class X {\n\tstatic void foo(int[] intarray) {\n\t\tList<int[]> l = Arrays.asList(intarray);\n\t\tSystem.out.print(l.get(0).length);\n\t}\n\tstatic void foo(String[] strarray) {\n\t\tList l = Arrays.asList(strarray);\n\t\tSystem.out.print(l);\n\t}\t\n\tpublic static void main(String[] args) {\n\t\tfoo(new int[]{0, 1});\n\t\tfoo(new String[]{\"a\",\"b\"});\n\t\tSystem.out.println(\"done\");\n\t}\n}\n"}, "2[a, b]done");
    }

    public void test027() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\ttransient private X() {}\n\tvoid test() { X x = new X(); }\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\r\n\ttransient private X() {}\r\n\t                  ^^^\nIllegal modifier for the constructor in type X; only public, protected & private are permitted\n----------\n");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\ttransient private X(Object... o) {}\n\tvoid test() { X x = new X(1, 2); }\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\ttransient private X(Object... o) {}\n\t                  ^^^^^^^^^^^^^^\nIllegal modifier for the constructor in type X; only public, protected & private are permitted\n----------\n");
    }

    public void test028() {
        this.runNegativeTest(new String[]{"X.java", "import java.lang.reflect.Method;\n\npublic class X {\n\tvoid test(Method method){ \n\t\ttry {\n\t\t\tmethod.invoke(this);\n\t\t\tmethod.invoke(this, new Class[0]);\n\t\t\tmethod.invoke(this, (Object[])new Class[0]);\n\t\t} catch (Exception e) {\n\t\t}\t\t\n\t}\n  Zork z;\n}\n"}, "----------\n1. WARNING in X.java (at line 7)\n\tmethod.invoke(this, new Class[0]);\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType Class[] of the last argument to method invoke(Object, Object...) doesn't exactly match the vararg parameter type. Cast to Object[] to confirm the non-varargs invocation, or pass individual arguments of type Object for a varargs invocation.\n----------\n2. ERROR in X.java (at line 12)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test029() {
        this.runNegativeTest(new String[]{"X.java", "/**\n * Whatever you do, eclipse doesn't like it.\n */\npublic class X {\n\n\t/**\n\t * Passing a String vararg to a method needing an Object array makes eclipse\n\t * either ask for a cast or complain that it is unnecessary. You cannot do\n\t * it right.\n\t * \n\t * @param s\n\t */\n\tpublic static void q(String... s) {\n\t\t // OK reports: Varargs argument String[] should be cast to Object[] when passed to the method \tprintf(String, Object...) from type PrintStream\n\t\tSystem.out.printf(\"\", s);\n\t\t// WRONG reports: Unnecessary cast from String[] to Object[]\n\t\tSystem.out.printf(\"\", (Object[]) s); \n\t}\n  Zork z;\n}\n"}, "----------\n1. WARNING in X.java (at line 15)\n\tSystem.out.printf(\"\", s);\n\t^^^^^^^^^^^^^^^^^^^^^^^^\nType String[] of the last argument to method printf(String, Object...) doesn't exactly match the vararg parameter type. Cast to Object[] to confirm the non-varargs invocation, or pass individual arguments of type Object for a varargs invocation.\n----------\n2. ERROR in X.java (at line 19)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test030() {
        this.runConformTest(new String[]{"X.java", "import java.io.Serializable;\npublic class X {\n\tpublic static void main(String[] args) {\n\t\taudit(\"osvaldo\", \"localhost\", \"logged\", \"X\", Integer.valueOf(0));\n\t\taudit(\"osvaldo\", \"localhost\", \"logged\", \"X\", \"Y\");\n\t\taudit(\"osvaldo\", \"localhost\", \"logged\", new Float(0), new java.awt.Point(0, 0));\n\t}\n\tpublic static <A extends Serializable> void audit(String login,\n\t\t\tString address, String event, A... args) {\n\t\tfor (A a : args) {\n\t\t\tSystem.out.println(a.getClass());\n\t\t}\n\t}\n}"}, "class java.lang.String\nclass java.lang.Integer\nclass java.lang.String\nclass java.lang.String\nclass java.lang.Float\nclass java.awt.Point");
    }

    public void test031() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\n\tpublic static void main(String[] args) {\n\t\tTest<String> t = new Tester();\n\t\tt.method(\"SUCCESS\");\n\t}\n\n\tstatic abstract class Test<A> {\n\t\tabstract void method(A... args);\n\t}\n\n\tstatic class Tester extends Test<String> {\n\n\t\t@Override void method(String... args) {\n\t\t\tcall(args);\n\t\t}\n\n\t\tvoid call(String[] args) {\n\t\t\tfor (String str : args)\n\t\t\t\tSystem.out.println(str);\n\t\t}\n\t}\n}\n"}, "SUCCESS");
    }

    public void test032() {
        this.runConformTest(new String[]{"Functor.java", "public class Functor<T> {\n\tpublic void func(T... args) {\n\t\t// do noting;\n\t}\n\t\n\tpublic static void main(String... args) {\n\t\tFunctor<String> functor = new Functor<String>() {\n\t\t\tpublic void func(String... args) {\n\t\t\t\tSystem.out.println(args.length);\n\t\t\t}\n\t\t};\n\t\tfunctor.func(\"Hello!\");\n\t}\n}\n"}, "1");
    }

    public void test033() {
        this.runNegativeTest(false, null, new String[]{"X.java", "public class X {\n\tvoid a(boolean b, Object... o) {System.out.print(1);}\n\tvoid a(Object... o) {System.out.print(2);}\n\tpublic static void main(String[] args) {\n\t\tX x = new X();\n\t\tx.a(true);\n\t\tx.a(true, \"foobar\");\n\t\tx.a(\"foo\", \"bar\");\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tx.a(true);\n\t  ^\nThe method a(boolean, Object[]) is ambiguous for the type X\n----------\n2. ERROR in X.java (at line 7)\n\tx.a(true, \"foobar\");\n\t  ^\nThe method a(boolean, Object[]) is ambiguous for the type X\n----------\n");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid b(boolean b, Object... o) {}\n\tvoid b(Boolean... o) {}\n\tvoid c(boolean b, boolean b2, Object... o) {}\n\tvoid c(Boolean b, Object... o) {}\n\tpublic static void main(String[] args) {\n\t\tX x = new X();\n\t\tx.b(true);\n\t\tx.b(true, false);\n\t\tx.c(true, true, true);\n\t\tx.c(Boolean.TRUE, Boolean.TRUE, Boolean.TRUE);\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 8)\r\n\tx.b(true);\r\n\t  ^\nThe method b(boolean, Object[]) is ambiguous for the type X\n----------\n2. ERROR in X.java (at line 9)\r\n\tx.b(true, false);\r\n\t  ^\nThe method b(boolean, Object[]) is ambiguous for the type X\n----------\n3. ERROR in X.java (at line 10)\r\n\tx.c(true, true, true);\r\n\t  ^\nThe method c(boolean, boolean, Object[]) is ambiguous for the type X\n----------\n4. ERROR in X.java (at line 11)\r\n\tx.c(Boolean.TRUE, Boolean.TRUE, Boolean.TRUE);\r\n\t  ^\nThe method c(boolean, boolean, Object[]) is ambiguous for the type X\n----------\n");
    }

    public void test033_tolerate() {
        Map options = this.getCompilerOptions();
        try {
            System.setProperty("tolerateIllegalAmbiguousVarargsInvocation", "true");
            this.runNegativeTest(false, null, new String[]{"X.java", "public class X {\n\tvoid a(boolean b, Object... o) {System.out.print(1);}\n\tvoid a(Object... o) {System.out.print(2);}\n\tpublic static void main(String[] args) {\n\t\tX x = new X();\n\t\tx.a(true);\n\t\tx.a(true, \"foobar\");\n\t\tx.a(\"foo\", \"bar\");\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tx.a(true);\n\t  ^\nThe method a(boolean, Object[]) is ambiguous for the type X\n----------\n2. ERROR in X.java (at line 7)\n\tx.a(true, \"foobar\");\n\t  ^\nThe method a(boolean, Object[]) is ambiguous for the type X\n----------\n", null, true, options);
        }
        finally {
            System.setProperty("tolerateIllegalAmbiguousVarargsInvocation", "false");
        }
    }

    public void test034() {
        this.runConformTest(new String[]{"X.java", "import java.util.*; \n\npublic class X {\n  public static void main(String[] args) {\n    double[][] d = { { 1 } , { 2 } }; \n    List<double[]> l = Arrays.asList(d); // <T> List<T> asList(T... a)\n    System.out.println(\"List size: \" + l.size());\n  }\n}\n"}, "List size: 2");
    }

    public void test035() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  public static <T> void foo(T ... values) {\n      System.out.print(values.getClass());\n  }\n\tpublic static void main(String args[]) {\n\t   X.<String>foo(\"monkey\", \"cat\");\n      X.<String>foo(new String[] { \"monkey\", \"cat\" });\n\t}\n}"}, "class [Ljava.lang.String;class [Ljava.lang.String;");
    }

    public void test036() {
        this.runConformTest(new String[]{"X.java", "import java.util.*;\npublic class X {\n    public void testBreak() {\n        Collection<Class> classes = new ArrayList<Class>();\n        classes.containsAll(Arrays.asList(String.class, Integer.class, Long.class));\n    }\n}\n"}, "");
    }

    public void test037() {
        this.runConformTest(new String[]{"V.java", "public class V {\n    public static void main(String[] s) {\n        V v = new V();\n        v.foo(\"\", v, null, \"\");\n        v.foo(\"\", v, null, \"\", 1);\n        v.foo2(\"\");\n        v.foo2(\"\", null);\n        v.foo2(\"\", null, null);\n        v.foo3(\"\", v, null, \"\", null);\n    }\n    void foo(String s, V v, Object... obs) {System.out.print(1);}\n    void foo(String s, V v, String r, Object o, Object... obs) {System.out.print(2);}\n    void foo2(Object... a) {System.out.print(1);}\n    void foo2(String s, Object... a) {System.out.print(2);}\n    void foo2(String s, Object o, Object... a) {System.out.print(3);}\n    void foo3(String s, V v, String... obs) {System.out.print(1);}\n    void foo3(String s, V v, String r, Object o, Object... obs) {System.out.print(2);}\n}\n"}, "222232");
        this.runNegativeTest(new String[]{"V.java", "public class V {\n    public static void main(String[] s) {\n        V v = new V();\n        v.foo2(null, \"\");\n        v.foo2(null, \"\", \"\");\n        v.foo3(\"\", v, null, \"\");\n    }\n    void foo2(String s, Object... a) {System.out.print(2);}\n    void foo2(String s, Object o, Object... a) {System.out.print(3);}\n    void foo3(String s, V v, String... obs) {System.out.print(1);}\n    void foo3(String s, V v, String r, Object o, Object... obs) {System.out.print(2);}\n}\n"}, "----------\n1. ERROR in V.java (at line 4)\n\tv.foo2(null, \"\");\n\t  ^^^^\nThe method foo2(String, Object[]) is ambiguous for the type V\n----------\n2. ERROR in V.java (at line 5)\n\tv.foo2(null, \"\", \"\");\n\t  ^^^^\nThe method foo2(String, Object[]) is ambiguous for the type V\n----------\n");
    }

    public void test038() {
        this.runNegativeTest(new String[]{"X.java", "import java.io.Serializable;\nimport java.util.Arrays;\n\npublic class X {\n    static void varargs(Serializable... items) {\n        System.out.println(Arrays.deepToString(items) + \" (argument wrapped)\");\n    }\n    @SuppressWarnings({\"boxing\"})\n    public static void main(String[] args) {\n\t     varargs(new Object[] {1, 2}); //warns \"Varargs argument Object[] \n\t     //should be cast to Serializable[] ..\", but proposed cast to\n\t     //Serializable[] fails at runtime (javac does not warn here)\n\t     varargs((Serializable[])new Object[] {1, 2}); //warns \"Varargs argument Object[] \n\t     //should be cast to Serializable[] ..\", but proposed cast to\n\t     //Serializable[] fails at runtime (javac does not warn here)\n        Zork z;\n    }\n}\n"}, "----------\n1. WARNING in X.java (at line 13)\n\tvarargs((Serializable[])new Object[] {1, 2}); //warns \"Varargs argument Object[] \n\t        ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nUnnecessary cast from Object[] to Serializable[]\n----------\n2. ERROR in X.java (at line 16)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test039() {
        this.runConformTest(new String[]{"X.java", "import java.io.Serializable;\nimport java.util.Arrays;\n\npublic class X {\n    static void varargs(Serializable... items) {\n        System.out.print(Arrays.deepToString(items) + \" (argument wrapped)\");\n    }\n    @SuppressWarnings({\"boxing\"})\n    public static void main(String[] args) {\n    \ttry {\n\t        varargs(new Object[] {1, 2}); //warns \"Varargs argument Object[] \n\t        \t//should be cast to Serializable[] ..\", but proposed cast to\n\t            //Serializable[] fails at runtime (javac does not warn here)\n\t        varargs((Serializable[])new Object[] {1, 2}); //warns \"Varargs argument Object[] \n\t    \t//should be cast to Serializable[] ..\", but proposed cast to\n\t        //Serializable[] fails at runtime (javac does not warn here)\n    \t} catch(ClassCastException e) {\n    \t\tSystem.out.println(\"SUCCESS\");\n    \t}\n    }\n}\n"}, "[[1, 2]] (argument wrapped)SUCCESS");
    }

    public void test040() {
        this.runConformTest(new String[]{"X.java", "import java.io.Serializable;\nimport java.util.Arrays;\n\npublic class X {\n    static void array(Serializable... items) {\n        System.out.print(Arrays.deepToString(items));\n    }\n    @SuppressWarnings({\"boxing\"})\n    public static void main(String[] args) {\n        array(new Serializable[] {3, 4});\n        array(new Integer[] {5, 6}); //warns (as javac does)\n        array(null); //warns (as javac does)\n    }\n}\n"}, "[3, 4][5, 6]null");
    }

    public void test041() {
        this.runNegativeTest(new String[]{"X.java", "import java.io.Serializable;\nimport java.util.Arrays;\n\npublic class X {\n    static void array(Serializable... items) {\n        System.out.print(Arrays.deepToString(items));\n    }\n    @SuppressWarnings({\"boxing\"})\n    public static void main(String[] args) {\n        array(new Serializable[] {3, 4});\n        array(new Integer[] {5, 6}); //warns (as javac does)\n        array(null); //warns (as javac does)\n        Zork z;\n    }\n}\n"}, "----------\n1. WARNING in X.java (at line 11)\n\tarray(new Integer[] {5, 6}); //warns (as javac does)\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType Integer[] of the last argument to method array(Serializable...) doesn't exactly match the vararg parameter type. Cast to Serializable[] to confirm the non-varargs invocation, or pass individual arguments of type Serializable for a varargs invocation.\n----------\n2. WARNING in X.java (at line 12)\n\tarray(null); //warns (as javac does)\n\t^^^^^^^^^^^\nType null of the last argument to method array(Serializable...) doesn't exactly match the vararg parameter type. Cast to Serializable[] to confirm the non-varargs invocation, or pass individual arguments of type Serializable for a varargs invocation.\n----------\n3. ERROR in X.java (at line 13)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test042() {
        this.runConformTest(new String[]{"X.java", "import java.io.Serializable;\nimport java.util.Arrays;\n\npublic class X {\n    static void varargs(Serializable... items) {\n        System.out.print(Arrays.deepToString(items) + \" (argument wrapped)\");\n    }\n    @SuppressWarnings({\"boxing\"})\n    public static void main(String[] args) {\n        varargs((Serializable) new Object[] {1, 2});\n        varargs((Serializable) new Serializable[] {3, 4}); //warns about\n            //unnecessary cast, although cast is necessary (causes varargs call)\n        varargs((Serializable) new Integer[] {5, 6});\n        varargs((Serializable) null);\n    }\n}\n"}, "[[1, 2]] (argument wrapped)[[3, 4]] (argument wrapped)[[5, 6]] (argument wrapped)[null] (argument wrapped)");
    }

    public void test043() {
        this.runNegativeTest(new String[]{"X.java", "import java.io.Serializable;\nimport java.util.Arrays;\n\npublic class X {\n    static void varargs(Serializable... items) {\n        System.out.print(Arrays.deepToString(items) + \" (argument wrapped)\");\n    }\n    @SuppressWarnings({\"boxing\"})\n    public static void main(String[] args) {\n        varargs((Serializable) new Object[] {1, 2});\n        varargs((Serializable) new Serializable[] {3, 4}); //warns about\n            //unnecessary cast, although cast is necessary (causes varargs call)\n        varargs((Serializable) new Integer[] {5, 6});\n        varargs((Serializable) null);\n        Zork z;\n    }\n}\n"}, "----------\n1. WARNING in X.java (at line 10)\n\tvarargs((Serializable) new Object[] {1, 2});\n\t        ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nUnnecessary cast from Object[] to Serializable\n----------\n2. ERROR in X.java (at line 15)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test044() {
        this.runConformTest(new String[]{"X.java", "import java.io.Serializable;\nimport java.util.Arrays;\n\npublic class X {\n    static void array(Serializable... items) {\n        System.out.print(Arrays.deepToString(items));\n    }\n    @SuppressWarnings({\"boxing\"})\n    public static void main(String[] args) {\n        array((Serializable[]) new Serializable[] {3, 4}); //warns about unnecessary cast\n        array((Serializable[]) new Integer[] {5, 6});\n        array((Serializable[]) null);\n        try {\n\t        array((Serializable[]) new Object[] {1, 2}); // CCE at run time\n        } catch(ClassCastException e) {\n        \tSystem.out.println(\"SUCCESS\");\n        }\n    }\n}\n"}, "[3, 4][5, 6]nullSUCCESS");
    }

    public void test045() {
        this.runNegativeTest(new String[]{"X.java", "import java.io.Serializable;\nimport java.util.Arrays;\n\npublic class X {\n    static void array(Serializable... items) {\n        System.out.print(Arrays.deepToString(items));\n    }\n    @SuppressWarnings({\"boxing\"})\n    public static void main(String[] args) {\n        array((Serializable[]) new Serializable[] {3, 4}); //warns about unnecessary cast\n        array((Serializable[]) new Integer[] {5, 6});\n        array((Serializable[]) null);\n\t     array((Serializable[]) new Object[] {1, 2}); // CCE at run time\n        Zork z;\n    }\n}\n"}, "----------\n1. WARNING in X.java (at line 10)\n\tarray((Serializable[]) new Serializable[] {3, 4}); //warns about unnecessary cast\n\t      ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nUnnecessary cast from Serializable[] to Serializable[]\n----------\n2. WARNING in X.java (at line 13)\n\tarray((Serializable[]) new Object[] {1, 2}); // CCE at run time\n\t      ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nUnnecessary cast from Object[] to Serializable[]\n----------\n3. ERROR in X.java (at line 14)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test046() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo(Throwable... exceptions) {\n\t}\n\tvoid bar(Exception[] exceptions) {\n\t\tfoo((Throwable[])exceptions);\n\t}\n\tZork z;\n}\n"}, "----------\n1. WARNING in X.java (at line 5)\n\tfoo((Throwable[])exceptions);\n\t    ^^^^^^^^^^^^^^^^^^^^^^^\nUnnecessary cast from Exception[] to Throwable[]\n----------\n2. ERROR in X.java (at line 7)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test047() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tvoid foo(Object id, Object value, String... groups) {}\n\tvoid foo(Y y, String... groups) {System.out.println(true);}\n\tpublic static void main(String[] args) {\n\t\tnew X().foo(new Y(), \"a\", \"b\");\n\t}\n}\nclass Y {}"}, "true");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo(Y y, Object value, String... groups) {}\n\tvoid foo(Object id, String... groups) {}\n\tpublic static void main(String[] args) {\n\t\tnew X().foo(new Y(), \"a\", \"b\");\n\t}\n}\nclass Y {}"}, "----------\n1. ERROR in X.java (at line 5)\r\n\tnew X().foo(new Y(), \"a\", \"b\");\r\n\t        ^^^\nThe method foo(Y, Object, String[]) is ambiguous for the type X\n----------\n");
    }

    public void test048() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n        Y<String> [] foo() {\n                return null;\n        }\n        void bar(Y... y) {\n        }\n        void fred() {\n                bar(foo());\n                bar((Y[])foo());\n                Zork z;\n        }\n}\nclass Y<E> {\n}\n"}, "----------\n1. WARNING in X.java (at line 5)\n\tvoid bar(Y... y) {\n\t         ^\nY is a raw type. References to generic type Y<E> should be parameterized\n----------\n2. WARNING in X.java (at line 9)\n\tbar((Y[])foo());\n\t    ^^^^^^^^^^\nUnnecessary cast from Y<String>[] to Y[]\n----------\n3. ERROR in X.java (at line 10)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test049() {
        this.runConformTest(new String[]{"Y.java", "public class Y extends X {\n\tpublic static void main(String[] args) {\n\t\tY y = new Y();\n\t\ty.a(null, \"\");\n\t\ty.a(null);\n\t\ty.a(y, \"\");\n\t\ty.a(y);\n\t\ty.a(y, \"\", y, y);\n\t\ty.a(y, y, y);\n\t}\n\t@Override public void a(Object anObject, String aString, Object... args) { super.a(anObject, aString, this, args); }\n\t@Override public void a(Object anObject, Object... args) { super.a(anObject, this, args); }\n}\nclass X implements I {\n\tpublic void a(Object anObject, String aString, Object... args) { System.out.print(1); }\n\tpublic void a(Object anObject, Object... args) { System.out.print(2); }\n}\ninterface I {\n\tvoid a(Object anObject, String aString, Object... args);\n\tvoid a(Object anObject, Object... args);\n}\n"}, "121212");
    }

    public void test050() {
        this.runNegativeTest(new String[]{"X.java", " import java.util.Arrays;\n public class X {\n   public static void main( String args[] ) {\n      Object test = new Object[] { \"Hello\", \"World\" };\n      System.out.println(Arrays.asList(test));\n      System.out.println(Arrays.asList((Object[])test)); // Warning here\n\t   Zork z;\n   }\n}"}, "----------\n1. ERROR in X.java (at line 7)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test051() {
        this.runConformTest(new String[]{"X.java", " import java.util.Arrays;\n public class X {\n   public static void main( String args[] ) {\n      Object test = new Object[] { \"Hello\", \"World\" };\n      System.out.print(Arrays.asList(test).size());\n      System.out.println(Arrays.asList((Object[])test).size()); // Warning here\n   }\n}"}, "12");
    }

    public void test052() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n\tvoid addChildren(Widget w) {\n\t\tif (w instanceof Composite) {\n\t\t\tComposite composite = (Composite) w;\n\t\t\taddAll((Widget[]) composite.getChildren());\n\t\t\taddAll(composite.getChildren());\n\t\t}\n\t\tZork z;\n\t}\n\tvoid addAll(Widget... widgets) {\n\t}\n}\n\nclass Widget {}\nclass Control extends Widget {}\nclass Composite extends Control {\n\tControl[] getChildren() {\n\t\treturn null;\n\t}\n}"}, "----------\n1. WARNING in X.java (at line 5)\n\taddAll((Widget[]) composite.getChildren());\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nUnnecessary cast from Control[] to Widget[]\n----------\n2. ERROR in X.java (at line 8)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test053() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n\tvoid addChildren(Widget w) {\n\t\tif (w instanceof Composite) {\n\t\t\tComposite composite = (Composite) w;\n\t\t\taddAll((Control[]) composite.getChildren());\n\t\t\taddAll(composite.getChildren());\n\t\t}\n\t\tZork z;\n\t}\n\tvoid addAll(Control... widgets) {\n\t}\n}\n\nclass Widget {}\nclass Control extends Widget {}\nclass Composite extends Control {\n\tControl[] getChildren() {\n\t\treturn null;\n\t}\n}"}, "----------\n1. WARNING in X.java (at line 5)\n\taddAll((Control[]) composite.getChildren());\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nUnnecessary cast from Control[] to Control[]\n----------\n2. ERROR in X.java (at line 8)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test054() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tZork z;\n\tpublic static void varargs(Object... args) {\n\t\tif (args == null) {\n\t\t\tSystem.out.println(\"args is null\");\n\t\t\treturn;\n\t\t}\n\t\tif (args.length == 0) {\n\t\t\tSystem.out.println(\"args is of length 0\");\n\t\t\treturn;\n\t\t}\n\n\t\tSystem.out.println(args.length + \" \" + args[0]);\n\t}\n\n\tpublic static void main(String[] args) {\n\t\t@SuppressWarnings(\"boxing\")\n\t\tInteger[] i = { 0, 1, 2, 3, 4 };\n\t\tvarargs(i);\n\t\tvarargs((Object[]) i);\n\t\tvarargs((Object) i);\n\t\tvarargs(i.clone());\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n2. WARNING in X.java (at line 19)\n\tvarargs(i);\n\t^^^^^^^^^^\nType Integer[] of the last argument to method varargs(Object...) doesn't exactly match the vararg parameter type. Cast to Object[] to confirm the non-varargs invocation, or pass individual arguments of type Object for a varargs invocation.\n----------\n3. WARNING in X.java (at line 22)\n\tvarargs(i.clone());\n\t^^^^^^^^^^^^^^^^^^\nType Integer[] of the last argument to method varargs(Object...) doesn't exactly match the vararg parameter type. Cast to Object[] to confirm the non-varargs invocation, or pass individual arguments of type Object for a varargs invocation.\n----------\n");
    }

    public void test055() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tprivate static int elementCount(Object... elements) {\n     return elements == null ? 0 : elements.length;\n   }\n   public static void main(String... args) {\n     System.out.print(\"null length array: \" + elementCount(null));\n     System.out.print(\"/[null] length array: \" + elementCount((Object)null));\n     System.out.print(\"/empty length array: \" + elementCount());\n     System.out.println(\"/[a,b,c] length array: \" + elementCount(\"a\", \"b\", \"c\"));\n   }\n}"}, "null length array: 0/[null] length array: 1/empty length array: 0/[a,b,c] length array: 3");
    }

    public void test056() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tZork z;\n\tprivate static int elementCount(Object... elements) {\n     return elements == null ? 0 : elements.length;\n   }\n   public static void main(String... args) {\n     System.out.print(\"null length array: \" + elementCount(null));\n     System.out.print(\"/[null] length array: \" + elementCount((Object)null));\n     System.out.print(\"/empty length array: \" + elementCount());\n     System.out.println(\"/[a,b,c] length array: \" + elementCount(\"a\", \"b\", \"c\"));\n   }\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n2. WARNING in X.java (at line 7)\n\tSystem.out.print(\"null length array: \" + elementCount(null));\n\t                                         ^^^^^^^^^^^^^^^^^^\nType null of the last argument to method elementCount(Object...) doesn't exactly match the vararg parameter type. Cast to Object[] to confirm the non-varargs invocation, or pass individual arguments of type Object for a varargs invocation.\n----------\n");
    }

    public void test057() {
        this.runNegativeTest(new String[]{"X.java", "import java.lang.annotation.RetentionPolicy;\n\npublic class X {\n\n  void a(Enum<?>...enums) {}\n\n  void b () {\n    RetentionPolicy[] t = null;\n    a(t);\n    a((Enum<?>[])t);\n    Zork z;\n  }\n}\n"}, "----------\n1. WARNING in X.java (at line 10)\n\ta((Enum<?>[])t);\n\t  ^^^^^^^^^^^^\nUnnecessary cast from RetentionPolicy[] to Enum<?>[]\n----------\n2. ERROR in X.java (at line 11)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test058() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    public void testPassingSubclassArrayAsVararg() {\n        // The argument of type VarargsTest.Subclass[] should explicitly be\n        // cast to VarargsTest.Parent[] for the invocation of the varargs\n        // method processVararg(VarargsTest.Parent...) from type VarargsTest.\n        // It could alternatively be cast to VarargsTest.Parent for a varargs\n        // invocation\n        processVararg(new Subclass[] {});\n    }\n\n    public void testPassingSubclassArrayAsVarargWithCast() {\n        // Unnecessary cast from VarargsTest.Subclass[] to\n        // VarargsTest.Parent[]\n        processVararg((Parent[]) new Subclass[] {});\n        processVararg(new Subclass[] {});\n        Zork z;\n    }\n\n    private void processVararg(Parent... objs) {\n    }\n\n    class Parent {\n    }\n\n    class Subclass extends Parent {\n    }\n}\n"}, "----------\n1. WARNING in X.java (at line 14)\n\tprocessVararg((Parent[]) new Subclass[] {});\n\t              ^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nUnnecessary cast from X.Subclass[] to X.Parent[]\n----------\n2. ERROR in X.java (at line 16)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test059() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic void foo() {\n\t\tInteger[] array = null;\n\t\tvarargs(array);\n\t}\n\n\tpublic void varargs(Number... o) {\n\t}\n    Zork z;\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test060() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.compliance", CompilerOptions.getFirstSupportedJavaVersion());
        options.put("org.eclipse.jdt.core.compiler.source", CompilerOptions.getFirstSupportedJavaVersion());
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", CompilerOptions.getFirstSupportedJavaVersion());
        this.runConformTest(new String[]{"X.java", "public class X {\n   public static String varargMethod( Object... objects ) {\r\n      String s = \"\";\n      for (Object object : objects)\n         s += \",\" + object.toString();\n      return s;\n   }\n}"}, "", null, true, null, options, null);
        IClassFileReader reader = ToolFactory.createDefaultClassFileReader((String)(OUTPUT_DIR + File.separator + "X.class"), (int)65535);
        IMethodInfo[] methodInfos = reader.getMethodInfos();
        VarargsTest.assertEquals((String)"Wrong size", (int)2, (int)methodInfos.length);
        IMethodInfo methodInfo = null;
        if (CharOperation.equals((char[])methodInfos[0].getName(), (char[])"varargMethod".toCharArray())) {
            methodInfo = methodInfos[0];
        } else if (CharOperation.equals((char[])methodInfos[1].getName(), (char[])"varargMethod".toCharArray())) {
            methodInfo = methodInfos[1];
        }
        VarargsTest.assertTrue((String)"ACC_VARARGS is set", ((methodInfo.getAccessFlags() & 0x80) == 128 ? 1 : 0) != 0);
        VarargsTest.assertNotNull((String)"Method varargMethodshould be there", (Object)methodInfo);
        VarargsTest.assertEquals((String)"1", (int)1, (int)methodInfo.getAttributeCount());
        IClassFileAttribute[] attributes = methodInfo.getAttributes();
        VarargsTest.assertTrue((String)"Code attribute not found", (boolean)CharOperation.equals((char[])attributes[0].getAttributeName(), (char[])"Code".toCharArray()));
        options.put("org.eclipse.jdt.core.compiler.compliance", CompilerOptions.getFirstSupportedJavaVersion());
        options.put("org.eclipse.jdt.core.compiler.source", CompilerOptions.getFirstSupportedJavaVersion());
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", CompilerOptions.getFirstSupportedJavaVersion());
        this.runConformTest(new String[]{"UseVararg.java", "public class UseVararg {\r\n   public static void main( String[] args ) {\n      String arg = \"SUCCESS\";\n      String results = X.varargMethod(arg);\n      System.out.println( results );\n   }\r\n}"}, ",SUCCESS", null, false, null, options, null);
    }

    public void test061() {
        String expectedOutput = "----------\n1. WARNING in X.java (at line 5)\n\tCollections.addAll(constantClassSet, String.class, Object.class);\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: A generic array of Class<? extends Object> is created for a varargs parameter\n----------\n2. ERROR in X.java (at line 6)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n";
        expectedOutput = "----------\n1. ERROR in X.java (at line 6)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n";
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tHashSet<Class<?>> constantClassSet = new HashSet<Class<?>>();\n\t\tCollections.addAll(constantClassSet, String.class, Object.class);\n\t\tZork z;\n\t}\n}\n"}, expectedOutput);
    }

    public void test062() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\r\n\tprivate static final String CONST = \"\";\r\n\r\n\tpublic static class A {\r\n\t\tA(Integer i, String... tab) {}\r\n\t}\r\n\t\r\n\tObject foo(final Float f) {\r\n\t\treturn new A(Integer.valueOf(0), CONST) {\r\n\t\t\tpublic String toString() {\r\n\t\t\t\treturn f.toString();\r\n\t\t\t}\r\n\t\t};\r\n\t}\r\n}"}, "");
        String expectedOutput = "  // Method descriptor #10 (LX;Ljava/lang/Integer;[Ljava/lang/String;Ljava/lang/Float;)V\n  // Stack: 3, Locals: 5\n  X$1(X arg0, java.lang.Integer $anonymous0, java.lang.String... $anonymous1, java.lang.Float arg3);\n";
        this.checkDisassembledClassFile(OUTPUT_DIR + File.separator + "X$1.class", "X$1", expectedOutput);
    }

    public void test063() throws Exception {
        this.runConformTest(new String[]{"Y.java", "import java.util.ArrayList;\nimport java.util.List;\npublic class Y {\r\n\t@SafeVarargs\n\tpublic static <T> List<T> asList(T... a) {\n\t\treturn null;\n\t}\n}"}, "");
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.uncheckedTypeOperation", "error");
        this.runConformTest(new String[]{"X.java", "import java.util.ArrayList;\nimport java.util.List;\npublic class X {\r\n\tpublic void bar() {\n\t\tList<? extends Class<?>> classes = Y.asList(String.class, Boolean.class);\n\t}\n}"}, "", null, false, null, options, null);
    }

    public void test064() throws Exception {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.uncheckedTypeOperation", "error");
        this.runConformTest(new String[]{"X.java", "import java.util.ArrayList;\nimport java.util.List;\npublic class X {\r\n\t@SafeVarargs\n\tpublic static <T> List<T> asList(T... a) {\n\t\treturn null;\n\t}\n\tpublic void bar() {\n\t\tList<? extends Class<?>> classes = X.asList(String.class, Boolean.class);\n\t}\n}"}, "", null, false, null, options, null);
    }

    public void test065() throws Exception {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.uncheckedTypeOperation", "error");
        this.runConformTest(new String[]{"X.java", "import java.util.ArrayList;\nimport java.util.List;\npublic class X {\r\n\t@SafeVarargs\n\tpublic static <T> List<T> asList(T... a) {\n\t\treturn null;\n\t}\n\tpublic void bar() {\n\t\tList<List<String>> classes = X.asList(X.asList(\"Hello\", \"World\"));\n\t}\n}"}, "", null, false, null, options, null);
    }

    public void test066() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.missingOverrideAnnotationForInterfaceMethodImplementation", "disabled");
        this.runNegativeTest(new String[]{"X.java", "import java.util.Collection;\nimport java.util.Iterator;\npublic class X {\n    public static class IteratorChain<T> implements Iterator<T> {\n       public IteratorChain(Collection<? extends T> a, Collection<? extends T> b, Collection<? extends T> ... collections) {\n        }\n        public boolean hasNext() {\n            return false;\n        }\n        public T next() {\n            return null;\n        }\n        public void remove() {\n            throw new UnsupportedOperationException();\n        }\n    }\n    public static void main(String[] args) {\n        new IteratorChain<Number>(null, null);\n    }\n}\n"}, "----------\n1. WARNING in X.java (at line 5)\n\tpublic IteratorChain(Collection<? extends T> a, Collection<? extends T> b, Collection<? extends T> ... collections) {\n\t                                                                                                       ^^^^^^^^^^^\nType safety: Potential heap pollution via varargs parameter collections\n----------\n2. WARNING in X.java (at line 18)\n\tnew IteratorChain<Number>(null, null);\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: A generic array of Collection<? extends Number> is created for a varargs parameter\n----------\n", null, true, options);
    }

    public void test067() throws Exception {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.uncheckedTypeOperation", "error");
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\npublic class X {\n\t@SafeVarargs\n\tpublic static <T> List<T> asList() {  // Error, not varargs\n\t\treturn null;\n\t}\n\t@SafeVarargs\n\tpublic <T> List<T> asList2(T ... a) {    // error not static or final\n\t\treturn null;\n\t}\n\t@SafeVarargs\n\tpublic static <T> List<T> asList3(T ... a) {  // OK, varargs & static\n\t\treturn null;\n\t}\n\t@SafeVarargs\n\tpublic final <T> List<T> asList4(T ... a) {  // OK varargs & final\n\t\treturn null;\n\t}\n\t@SafeVarargs\n\tpublic final static <T> List<T> asList5(T ... a) {  // OK, varargs & static & final\n\t\treturn null;\n\t}\n\t@SafeVarargs\n\tpublic int b;\n}\ninterface I {\n\t@SafeVarargs\n\tpublic  <T> List<T> asList(T ... t);\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tpublic static <T> List<T> asList() {  // Error, not varargs\n\t                          ^^^^^^^^\n@SafeVarargs annotation cannot be applied to fixed arity method asList\n----------\n2. ERROR in X.java (at line 8)\n\tpublic <T> List<T> asList2(T ... a) {    // error not static or final\n\t                   ^^^^^^^^^^^^^^^^\n@SafeVarargs annotation cannot be applied to non-final instance method asList2\n----------\n3. ERROR in X.java (at line 23)\n\t@SafeVarargs\n\t^^^^^^^^^^^^\nThe annotation @SafeVarargs is disallowed for this location\n----------\n4. ERROR in X.java (at line 28)\n\tpublic  <T> List<T> asList(T ... t);\n\t                    ^^^^^^^^^^^^^^^\n@SafeVarargs annotation cannot be applied to non-final instance method asList\n----------\n");
    }

    public void test067b() throws Exception {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.uncheckedTypeOperation", "error");
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\npublic class X {\n\t@SafeVarargs\n\tpublic X() {  // Error, not varargs\n\t}\n\t@SafeVarargs\n\tpublic <T> X(T ... a) {\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tpublic X() {  // Error, not varargs\n\t       ^^^\n@SafeVarargs annotation cannot be applied to fixed arity method X\n----------\n");
    }

    public void test068() throws Exception {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.uncheckedTypeOperation", "error");
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\npublic class X {\n\tpublic <T> X(String ... a) {\n\t}\n\tpublic <T> X(int i, String ... a) {\n\t}\n   public <T> List<T> asList(String ... a) {\n       return null;\n   }\n   public <T> List<T> asList(Zork t, String ... a) {\n       return null;\n   }\n}\n"}, "----------\n1. ERROR in X.java (at line 10)\n\tpublic <T> List<T> asList(Zork t, String ... a) {\n\t                          ^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test068b() throws Exception {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.uncheckedTypeOperation", "error");
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\npublic class X {\n\tpublic <T> X(T ... a) {\n\t}\n\tpublic <T> X(int i, T ... a) {\n\t}\n   public <T> List<T> asList(T ... a) {\n       return null;\n   }\n   public <T> List<T> asList(T t, T ... a) {\n       return null;\n   }\n}\n"}, "----------\n1. WARNING in X.java (at line 3)\n\tpublic <T> X(T ... a) {\n\t                   ^\nType safety: Potential heap pollution via varargs parameter a\n----------\n2. WARNING in X.java (at line 5)\n\tpublic <T> X(int i, T ... a) {\n\t                          ^\nType safety: Potential heap pollution via varargs parameter a\n----------\n3. WARNING in X.java (at line 7)\n\tpublic <T> List<T> asList(T ... a) {\n\t                                ^\nType safety: Potential heap pollution via varargs parameter a\n----------\n4. WARNING in X.java (at line 10)\n\tpublic <T> List<T> asList(T t, T ... a) {\n\t                                     ^\nType safety: Potential heap pollution via varargs parameter a\n----------\n");
    }

    public void test068c() throws Exception {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.uncheckedTypeOperation", "error");
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\npublic class X {\n   @SafeVarargs\n\tpublic <T> X(T ... a) {\n\t}\n   @SafeVarargs\n\tpublic <T> X(int i, T ... a) {\n\t}\n   @SafeVarargs\n   public <T> List<T> asList(T ... a) {\n       return null;\n   }\n   @SafeVarargs\n   public <T> List<T> asList(T t, T ... a) {\n       return null;\n   }\n}\n"}, "----------\n1. ERROR in X.java (at line 10)\n\tpublic <T> List<T> asList(T ... a) {\n\t                   ^^^^^^^^^^^^^^^\n@SafeVarargs annotation cannot be applied to non-final instance method asList\n----------\n2. ERROR in X.java (at line 14)\n\tpublic <T> List<T> asList(T t, T ... a) {\n\t                   ^^^^^^^^^^^^^^^^^^^^\n@SafeVarargs annotation cannot be applied to non-final instance method asList\n----------\n");
    }

    public void test068d() throws Exception {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.uncheckedTypeOperation", "error");
        String[] bounds = new String[]{"Object", "Serializable", "Comparable<?>"};
        String[] bounds15 = new String[]{"Object", "Serializable", "Comparable<?>", "Constable"};
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\npublic class X {\n   @SafeVarargs\n   public static <T> List<T> asList(T ... a) {\n       return null;\n   }\n   public static <T> List<T> asList2(T ... a) {\n       return null;\n   }\n\tList<? extends Class<?>> classes; \n   {\n     classes = X.asList(String.class, Boolean.class);\n\t  classes = X.asList2(String.class, Boolean.class);\n   }\n}\n"}, "----------\n1. WARNING in X.java (at line 7)\n\tpublic static <T> List<T> asList2(T ... a) {\n\t                                        ^\nType safety: Potential heap pollution via varargs parameter a\n----------\n2. WARNING in X.java (at line 13)\n\tclasses = X.asList2(String.class, Boolean.class);\n\t          ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: A generic array of Class<? extends " + this.intersection(isJRE15Plus ? bounds15 : bounds) + "> is created for a varargs parameter\n----------\n");
    }

    public void test068e() throws Exception {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.uncheckedTypeOperation", "error");
        String[] bounds = new String[]{"Object", "Serializable", "Comparable<?>"};
        String[] bounds15 = new String[]{"Object", "Serializable", "Comparable<?>", "Constable"};
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\npublic class X {\n   @SafeVarargs\n   public static <T> List<T> asList(T ... a) {\n       return null;\n   }\n   @SuppressWarnings(\"unchecked\")\n   public static <T> List<T> asList2(T ... a) {\n       return null;\n   }\n\tList<? extends Class<?>> classes; \n   {\n     classes = X.asList(String.class, Boolean.class);\n\t  classes = X.asList2(String.class, Boolean.class);\n   }\n}\n"}, "----------\n1. WARNING in X.java (at line 14)\n\tclasses = X.asList2(String.class, Boolean.class);\n\t          ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: A generic array of Class<? extends " + this.intersection(isJRE15Plus ? bounds15 : bounds) + "> is created for a varargs parameter\n----------\n");
    }

    public void test069() throws Exception {
        this.runNegativeTest(new String[]{"p1/B.java", "package p1;\nclass A {\n}\npublic class B extends A {\n public void foo(A... args) {\n }\n}\n", "p2/C.java", "package p2;\nimport p1.B;\npublic class C {\n\n public static final void main(String[] args) {\n   (new B()).foo(new B(), new B());\n }\n}\n"}, "----------\n1. ERROR in p2\\C.java (at line 6)\n\t(new B()).foo(new B(), new B());\n\t          ^^^\nThe method foo(A...) of type B is not applicable as the formal varargs element type A is not accessible here\n----------\n");
    }

    public void test070() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\n        public static void foo(int ...i) {}\n        public static void foo(double...d) {}\n        public static void main(String[] args) {\n            foo(1, 2, 3);\n            System.out.println (\"Done\");\n        }\n}\n"}, "Done");
    }

    public void test070_tolerate() throws Exception {
        Map options = this.getCompilerOptions();
        try {
            System.setProperty("tolerateIllegalAmbiguousVarargsInvocation", "true");
            this.runConformTest(new String[]{"X.java", "public class X {\n        public static void foo(int ...i) {}\n        public static void foo(double...d) {}\n        public static void main(String[] args) {\n            foo(1, 2, 3);\n            System.out.println (\"Done\");\n        }\n}\n"}, "Done", null, true, null, options, null);
        }
        finally {
            System.setProperty("tolerateIllegalAmbiguousVarargsInvocation", "false");
        }
    }

    public void test070_tolerate2() throws Exception {
        Map options = this.getCompilerOptions();
        try {
            System.setProperty("tolerateIllegalAmbiguousVarargsInvocation", "true");
            this.runNegativeTest(false, null, new String[]{"X.java", "import java.util.Arrays;\npublic class X {\n        public static void test(int... a) {\n\t\t\tSystem.out.println(Arrays.toString(a));\n}\n        public static <T> void test(Object... a) {\n\t\t\tSystem.out.println(Arrays.toString(a));\n}\n        public static void main(String[] args) {\n            test(1);\n        }\n}\n"}, "----------\n1. ERROR in X.java (at line 10)\n\ttest(1);\n\t^^^^\nThe method test(int[]) is ambiguous for the type X\n----------\n", null, true, options);
        }
        finally {
            System.setProperty("tolerateIllegalAmbiguousVarargsInvocation", "false");
        }
    }

    public void test070a() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\n        public static <T> void foo(int ...i) {}\n        public static <T> void foo(double...d) {}\n        public static void main(String[] args) {\n            foo(1, 2, 3);\n            System.out.println (\"Done\");\n        }\n}\n"}, "Done");
    }

    public void test070a_tolerate() throws Exception {
        Map options = this.getCompilerOptions();
        try {
            System.setProperty("tolerateIllegalAmbiguousVarargsInvocation", "true");
            this.runConformTest(new String[]{"X.java", "public class X {\n        public static <T> void foo(int ...i) {}\n        public static <T> void foo(double...d) {}\n        public static void main(String[] args) {\n            foo(1, 2, 3);\n            System.out.println (\"Done\");\n        }\n}\n"}, "Done", null, true, null, options, null);
        }
        finally {
            System.setProperty("tolerateIllegalAmbiguousVarargsInvocation", "false");
        }
    }

    public void test070b() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\n        public static void foo(int ...i) {}\n        public static void foo(double d1, double...d) {}\n        public static void main(String[] args) {\n            foo(1, 2, 3);     // foo NOT flagged ambiguous\n        }\n}\n"}, "");
    }

    public void test070b_tolerate() throws Exception {
        String[] src = new String[]{"X.java", "public class X {\n        public static void foo(int ...i) {}\n        public static void foo(double d1, double...d) {}\n        public static void main(String[] args) {\n            foo(1, 2, 3);     // foo NOT flagged ambiguous\n        }\n}\n"};
        try {
            System.setProperty("tolerateIllegalAmbiguousVarargsInvocation", "true");
            this.runConformTest(src, "");
        }
        finally {
            System.setProperty("tolerateIllegalAmbiguousVarargsInvocation", "false");
        }
    }

    public void test070c() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    public static void main(String[] s) {\n        count(1);\n        count(1, 1);\n        count(1, 1, 1);\n    }\n    public static void count(int ... values) {}\n    public static void count(int i, int ... values) {}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tcount(1);\n\t^^^^^\nThe method count(int[]) is ambiguous for the type X\n----------\n2. ERROR in X.java (at line 4)\n\tcount(1, 1);\n\t^^^^^\nThe method count(int[]) is ambiguous for the type X\n----------\n3. ERROR in X.java (at line 5)\n\tcount(1, 1, 1);\n\t^^^^^\nThe method count(int[]) is ambiguous for the type X\n----------\n");
    }

    public void test070d() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid b(boolean b, Object... o) {}\n\tvoid b(Boolean... o) {}\n\tvoid c(boolean b, boolean b2, Object... o) {}\n\tvoid c(Boolean b, Object... o) {}\n\tpublic static void main(String[] args) {\n\t\tX x = new X();\n\t\tx.b(true);\n\t\tx.b(true, false);\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 8)\r\n\tx.b(true);\r\n\t  ^\nThe method b(boolean, Object[]) is ambiguous for the type X\n----------\n2. ERROR in X.java (at line 9)\r\n\tx.b(true, false);\r\n\t  ^\nThe method b(boolean, Object[]) is ambiguous for the type X\n----------\n");
    }

    public void test071() {
        this.runConformTest(new String[]{"X.java", "public class X implements IClass{\n    X(IClass c, X t, IType... args) {\n\t     System.out.println (\"1\");\n    }\n    X(IClass c, IType... args) {\n\t    System.out.println (\"2\");\n    }\n    public static void main(String args[]) {\n        IClass c = null;\n        X t = null;\n        X t2 = new X(c, t);     // incorrectly flagged ambiguous\n    }\n}\ninterface IType{}\ninterface IClass extends IType{}\n"}, "1");
    }

    public void test071_tolerate() throws Exception {
        String[] src = new String[]{"X.java", "public class X implements IClass{\n    X(IClass c, X t, IType... args) {\n\t     System.out.println (\"1\");\n    }\n    X(IClass c, IType... args) {\n\t    System.out.println (\"2\");\n    }\n    public static void main(String args[]) {\n        IClass c = null;\n        X t = null;\n        X t2 = new X(c, t);     // incorrectly flagged ambiguous\n    }\n}\ninterface IType{}\ninterface IClass extends IType{}\n"};
        try {
            System.setProperty("tolerateIllegalAmbiguousVarargsInvocation", "true");
            this.runConformTest(src, "1");
        }
        finally {
            System.setProperty("tolerateIllegalAmbiguousVarargsInvocation", "false");
        }
    }

    public void test072() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tprivate class Z {}\n\tpublic void foo() {\n\t\t\tZ[] zs = null;\n\t\t\tY.bar(zs, new Z());\n\t}\n\tpublic static void main(String[] args) {}\n}", "Y.java", "public class Y {\n\tpublic native static <T> void bar(T[] t, T t1, T... t2);\n}"}, "");
    }

    public void test073() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static final String CONSTANT = \"\";\n\tprivate static class A {\n\t\tA(String s, String s2, String s3, A... a) {}\n\t}\n\tprivate static class B extends A {\n\t\tB(String s, String s2) {\n\t\t\tsuper(s, s2, CONSTANT);\n\t\t}\n\t}\n\tprivate static void foo(Object o, A ... a) {\n\t}\n\tprivate static B bar() {\n\t\treturn null;\n\t}\n\tpublic static void main(String[] args) {\n\t\tObject o = null;\n\t\tfoo(o, bar(), bar());\n\t}\n}"}, "");
    }

    public void test074() throws Exception {
        this.runNegativeTest(new String[]{"p1/B.java", "package p1;\nclass A {}\npublic class B extends A {\n public B(A... args) {}\n public B() {}\n}\n", "p2/C.java", "package p2;\nimport p1.B;\npublic class C {\n\tpublic static final void main(String[] args) {\n\t\tnew B(new B(), new B());\n\t}\n}\n"}, "----------\n1. ERROR in p2\\C.java (at line 5)\n\tnew B(new B(), new B());\n\t^^^^^^^^^^^^^^^^^^^^^^^\nThe constructor B(A...) of type B is not applicable as the formal varargs element type A is not accessible here\n----------\n");
    }

    public void testBug382469() throws Exception {
        String[] src = new String[]{"X.java", "public class X {\n    private static void bar(Object... objs) {\n\t     System.out.println (\"1\");\n    }\n    private static void bar(int intValue, Object... objs) {\n\t     System.out.println (\"2\");\n    }\n    public static void main(String args[]) {\n        bar(5);\n    }\n}\n"};
        try {
            System.setProperty("tolerateIllegalAmbiguousVarargsInvocation", "true");
            this.runNegativeTest(src, "----------\n1. WARNING in X.java (at line 5)\n\tprivate static void bar(int intValue, Object... objs) {\n\t                    ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nThe method bar(int, Object...) from the type X is never used locally\n----------\n2. ERROR in X.java (at line 9)\n\tbar(5);\n\t^^^\nThe method bar(Object[]) is ambiguous for the type X\n----------\n");
        }
        finally {
            System.setProperty("tolerateIllegalAmbiguousVarargsInvocation", "false");
        }
    }

    public void testBug386361() throws Exception {
        String[] src = new String[]{"X.java", "public class X {\n    public static void test(int i, Object... objects) {\n\t     System.out.println (\"1\");\n    }\n    public static void test(Object... objects) {\n\t     System.out.println (\"2\");\n    }\n    public static void main(String args[]) {\n        test(1,\"test\");\n    }\n}\n"};
        try {
            System.setProperty("tolerateIllegalAmbiguousVarargsInvocation", "true");
            this.runNegativeTest(src, "----------\n1. ERROR in X.java (at line 9)\n\ttest(1,\"test\");\n\t^^^^\nThe method test(int, Object[]) is ambiguous for the type X\n----------\n");
        }
        finally {
            System.setProperty("tolerateIllegalAmbiguousVarargsInvocation", "false");
        }
    }

    public void test426678() {
        this.runNegativeTest(new String[]{"X.java", "import p.*;\npublic class X  {\n    public static void main(String argv[]) {\n        new B().foo(null, null);\n    }\n}\n", "p/B.java", "package p;\nclass A {\n}\npublic class B extends A {\n    public void foo(A ... o) { System.out.println(\"MB:A\"); }\n    public void foo(Object... o) { System.out.println(\"MB:O\"); }\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tnew B().foo(null, null);\n\t        ^^^\nThe method foo(A...) of type B is not applicable as the formal varargs element type A is not accessible here\n----------\n");
    }

    public void test436474() {
        this.runConformTest(new String[]{"Scratch.java", "import java.util.Arrays;\nimport java.util.List;\npublic class Scratch {\n    public static void vararg(String... strs) {\n    \tSystem.out.println(strs[0]);\n    }\n    \n    public static void main(String[] args) {\n        List<String> l = Arrays.asList(\"a\");\n        vararg(l.toArray(new String[0]));\n    }\n}"}, "a");
    }

    public void test437973() {
        this.runConformTest(new String[]{"X.java", "class W {}\nclass Y extends W {}\nclass Z extends Y {}\nclass A{}\npublic class X {\n\tvoid foo(String format, Object ... args) {\n\t\tSystem.out.println(\"foo Object Varargs\");\n\t}\n\tvoid foo(String ... s) {\n\t\tSystem.out.println(\"foo String Varargs\");\n\t}\n\tvoid foo1(Z ... z) {\n\t\tSystem.out.println(\"foo1 Z varargs\");\n\t}\n\tvoid foo1(Z z, Y ... y) {\n\t\tSystem.out.println(\"foo1 Y varargs\");\n\t}\n\tvoid foo2(Z z, W ... w) {\n\t\tSystem.out.println(\"foo2 W varargs\");\n\t}\n\tvoid foo2(Z z, Y ... y) {\n\t\tSystem.out.println(\"foo2 Y varargs\");\n\t}\n\tvoid foo3(A a, W ... w) {\n\t\tSystem.out.println(\"foo3 W varargs\");\n\t}\n\tvoid foo3(A a, Y ... y) {\n\t\tSystem.out.println(\"foo3 Y varargs\");\n\t}\n\tvoid foo4(W w) {\n\t\tSystem.out.println(\"foo4 W\");\n\t}\n\tvoid foo4(W w, A ... a) {\n\t\tSystem.out.println(\"foo4 A varargs\");\n\t}\n\tvoid foo5(W w) {\n\t\tSystem.out.println(\"foo5 W\");\n\t}\n\tvoid foo5(W ... w) {\n\t\tSystem.out.println(\"foo5 W varargs\");\n\t}\n\tvoid foo6(W ... w) {\n\t\tSystem.out.println(\"foo6 W varargs\");\n\t}\n\tvoid foo6(Y ... y) {\n\t\tSystem.out.println(\"foo6 Y varargs\");\n\t}\n   void foo7(String format, Object ... args) {\n\t    System.out.println(\"foo7 Object Varargs\");\n   }\n   void foo8(String ... s) {\n\t    System.out.println(\"foo8 String Varargs\");\n   }\n\tvoid bar() {\n\t\tfoo(\"f\");\n\t\tfoo(\"f\", 12);\n\t\tfoo1(new Z());\n\t\tfoo2(new Z());\n\t\tfoo3(new A());\n\t\tfoo4(new W());\n\t\tfoo5(new W());\n\t\tfoo6(new W());\n\t\tfoo6(new Y());\n       foo7(\"f\", 12);\n       foo8(\"f\");\n\t}\n\tpublic static void main(String[] args) {\n\t\tX x = new X();\n\t\tx.bar();\n\t}\n}\n"}, "foo String Varargs\nfoo Object Varargs\nfoo1 Z varargs\nfoo2 Y varargs\nfoo3 Y varargs\nfoo4 W\nfoo5 W\nfoo6 W varargs\nfoo6 Y varargs\nfoo7 Object Varargs\nfoo8 String Varargs");
    }

    public void test437973a() {
        this.runConformTest(new String[]{"X.java", "class W {}\nclass Y extends W {}\npublic class X {\n\tvoid foo(W w, Y ... y) {\n\t\tSystem.out.println(\"foo Y varargs\");\n   }\n\tvoid foo(W ... w) {\n\t\tSystem.out.println(\"foo W varargs\");\n   }\n\tvoid bar() {\n\t\tfoo(new W(), new W(), new W());\n\t\tfoo(new Y(), new Y(), new Y());\n\t\tfoo(new W());\n\t\tfoo(new Y());\n\t}\n\tpublic static void main(String[] args) {\n\t\tX x = new X();\n\t\tx.bar();\n\t}\n}\n"}, "foo W varargs\nfoo Y varargs\nfoo Y varargs\nfoo Y varargs");
    }

    public void test437973b() {
        this.runNegativeTest(new String[]{"X.java", "class W {}\nclass A {}\npublic class X {\n    void foo(W ... w) {}\n    void foo(W w, A ... a) {}\n    void bar() {\n        foo(new W()); // 1.8 Error: Ambiguous method error\n    }\n    public static void main(String[] args) {}\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tfoo(new W()); // 1.8 Error: Ambiguous method error\n\t^^^\nThe method foo(W[]) is ambiguous for the type X\n----------\n");
    }

    public void test437973c() {
        this.runNegativeTest(new String[]{"X.java", "class W {}\nclass Y extends W {}\nclass Z extends Y {}\nclass A{}\n\ninterface I1 {\n\tvoid foo (Y ... y); \n\tdefault void foo (Y y, W ... w) {}\n}\n\npublic class X {\n\tvoid bar() {\n\t\tI1 i1 = (x) -> {};\n\t\ti1.foo(new Y());\n\t}\n}\n"}, "");
    }

    public void test437973d() {
        this.runConformTest(new String[]{"Junk16.java", "public class Junk16 {\n    public static String junk(String format, Object... args) {\n\t\t System.out.println(\"junk 1\");\n        return null;\n    }\n    public static String junk(String... s) {\n\t\t System.out.println(\"junk 2\");\n        return null;\n    }\n    public static void main(String[] args) {\n        // COMPILE ERROR IN ECLIPSE (none in JDK) WITHOUT FIX\n        junk(\"fred\");\n        //NO COMPILE ERROR\n        junk(\"fred\", 12);\n    }\n}\n"}, "junk 2\njunk 1");
    }

    public void _test443596() {
        this.runConformTest(new String[]{"Collections2.java", "public final class Collections2 {\n    static interface Predicate<T> { boolean test(T object); }\n    public static <T> Predicate<T> in(Predicate<? extends T> arg) { return null; }\n    public static <T> Predicate<T> and(Predicate<? super T>... arg) { return null; }\n    public static <T> Predicate<T> and(Predicate<? super T> arg0, Predicate<? super T> arg1) { return null; }\n    static class FilteredCollection<E> {\n        Predicate<? super E> predicate;\n        public void error(Predicate<?> arg) { and(predicate, in(arg)); } // no compile\n    }\n}\n"});
    }

    public void test470370() {
        this.runConformTest(new String[]{"TestVarargs.java", "import java.util.*;\npublic class TestVarargs {\n    public static void main(String[] args) {\n        bar(new Class<?>[]{});\n        foo(new Class<?>[]{});\n    }\n    public static Object foo(Class<?>[] sig) {\n        return Arrays.asList(Arrays.copyOfRange(sig, 0, sig.length));\n    }\n    public static List<Class<?>> bar(Class<?>[] sig) {\n        return Arrays.asList(Arrays.copyOfRange(sig, 0, sig.length));\n    }\n}"}, "");
    }

    public void testBug488658_001() throws Exception {
        if (this.complianceLevel < 0x350000L) {
            return;
        }
        this.runConformTest(new String[]{"X.java", "class Y<T> {}\n@SuppressWarnings(\"unused\")\npublic class X {\n\t@SafeVarargs\n\tprivate <T> Y<T> foo(T ... a) {\n\t\treturn null;\n\t}\n}\n"}, "");
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.uncheckedTypeOperation", "error");
        this.runNegativeTest(new String[]{"X.java", "class Y<T> {}\npublic class X {\n@SuppressWarnings(\"unused\")\n\tprivate <T> Y<T> foo(T ... a) {\n\t\treturn null;\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 4)\n\tprivate <T> Y<T> foo(T ... a) {\n\t                           ^\nType safety: Potential heap pollution via varargs parameter a\n----------\n");
    }
}

