/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;

public class XLargeTest2
extends AbstractRegressionTest {
    public XLargeTest2(String name) {
        super(name);
    }

    public static Test suite() {
        return XLargeTest2.buildMinimalComplianceTestSuite(XLargeTest2.testClass(), 32);
    }

    public static Class<?> testClass() {
        return XLargeTest2.class;
    }

    public void testBug542084_error() {
        int enumsCount = this.getEnumsCountForError();
        StringBuilder lotOfEnums = new StringBuilder(enumsCount * 7);
        int i = 0;
        while (i < enumsCount) {
            lotOfEnums.append("A").append(i).append(", ");
            ++i;
        }
        String expectedCompilerLog = this.complianceLevel > 0x340000L ? "1. ERROR in X.java (at line 2)\n\tenum Y {\n\t     ^\nThe code for the static initializer is exceeding the 65535 bytes limit\n" : "1. ERROR in X.java (at line 6)\n\tswitch(y){\n        case A0:\n            System.out.println(\"a\");\n            break;\n        default:\n            System.out.println(\"default\");\n            break;\n        }\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nThe code for the switch table on enum X.Y is exceeding the 65535 bytes limit\n";
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    enum Y {\n" + lotOfEnums.toString() + "    }\n    public static void main(String[] args) {\n        X.Y y = X.Y.A0;\n        switch(y){\n        case A0:\n            System.out.println(\"a\");\n            break;\n        default:\n            System.out.println(\"default\");\n            break;\n        }\n    }\n    public void z2(Y y) {\n        switch(y){\n        case A0:\n            System.out.println(\"a\");\n            break;\n        default:\n            System.out.println(\"default\");\n            break;\n        }\n    }\n}"}, "----------\n" + expectedCompilerLog + "----------\n");
    }

    public void testBug542084_no_error() {
        int enumsCount = this.getEnumsCountForSuccess();
        StringBuilder lotOfEnums = new StringBuilder(enumsCount * 7);
        int i = 0;
        while (i < enumsCount) {
            lotOfEnums.append("A").append(i).append(", ");
            ++i;
        }
        this.runConformTest(true, AbstractRegressionTest.JavacTestOptions.SKIP, new String[]{"X.java", "public class X {\n    enum Y {\n" + lotOfEnums.toString() + "    }\n    public static void main(String[] args) {\n        X.Y y = X.Y.A0;\n        switch(y){\n        case A0:\n            System.out.println(\"SUCCESS\");\n            break;\n        default:\n            System.out.println(\"default\");\n            break;\n        }\n    }\n}"}, "SUCCESS");
    }

    private int getEnumsCountForError() {
        if (this.complianceLevel > 0x340000L) {
            return 2800;
        }
        return 4500;
    }

    private int getEnumsCountForSuccess() {
        if (this.complianceLevel > 0x340000L) {
            return 2300;
        }
        return 4300;
    }

    public void testBug550063() {
        this.runConformTest(new String[]{"p001/bip.java", "package p001;\n\n" + this.getManyInterfaceDeclarations() + "\nclass bip implements brj, brk, cem, cen, cey, cez, cfk, cfl, cgu, cgx, che, chh, chq, chr, cji, cjj, ckk, ckl, clb, clc, clf, cli, cnk,\n\tcnl, cok, cqa, cqd, cqw, cqx, crs, crv, csu, csv, ctq, ctt, cvg, cvj, cvo, cvp, cwk, cwn, cwu, cww, cxh, cxk, daz, dba, dbr, dbu, dck,\n\tdcl, deh, dei, dep, deq, dff, dfg, dfl, dfo, dsp, dss, dtp, dtq, dtt, dtw, duj, duk, dvm, dvp, dvs, dvv, dwe, dwh, dxd, dxg, dyq, dys,\n\tdyv, dyw, dzh, dzk, dzn, dzo, dzx, eaa, ecw, ecx, edr, eds, efc, efd, eiw, eiz, ejy, ekb, emi, eml, eor, eou, epe, eph, epk, epl, eqi,\n\teqj, erv, erw, etd, etg, etm, eto, fbc, fbd, feu, fev, ffc, fff, fgf, fgh, fgo, fgp, fhm, fhn, fib, fki, fkj, fkw, fkx, fmh, fmk, fnk,\n\tfnl, fnz, foc, fof, foi, fvk, fvn, fvv, fvw, fwy, fxb, fyb, fye, fyl, fym, fyv, fyy, fzq, fzs, gad, gag, gaq, gas, gav, gax, gbc, gbd,\n\tgco, gcr, gdc, gdf, gdn, gdq, gei, gej, gih, gik, gku, gkx, gln, glo, gmi, gmj, gmu, gmv, gpx, gpy, gqb, gqe, gqp, gqs, grb, grc, grh,\n\tgri, grn, gro, grv, grw, gtr, gtu, gxc, gvt, gvw, gwz {\n}\n"});
    }

    public void testBug550063_b() {
        this.runNegativeTest(new String[]{"p001/bip.java", "package p001;\n\n" + this.getManyInterfaceDeclarations() + "\nclass bop implements missing,\n\tbrj, brk, cem, cen, cey, cez, cfk, cfl, cgu, cgx, che, chh, chq, chr, cji, cjj, ckk, ckl, clb, clc, clf, cli, cnk,\n\tcnl, cok, cqa, cqd, cqw, cqx, crs, crv, csu, csv, ctq, ctt, cvg, cvj, cvo, cvp, cwk, cwn, cwu, cww, cxh, cxk, daz, dba, dbr, dbu, dck,\n\tdcl, deh, dei, dep, deq, dff, dfg, dfl, dfo, dsp, dss, dtp, dtq, dtt, dtw, duj, duk, dvm, dvp, dvs, dvv, dwe, dwh, dxd, dxg, dyq, dys,\n\tdyv, dyw, dzh, dzk, dzn, dzo, dzx, eaa, ecw, ecx, edr, eds, efc, efd, eiw, eiz, ejy, ekb, emi, eml, eor, eou, epe, eph, epk, epl, eqi,\n\teqj, erv, erw, etd, etg, etm, eto, fbc, fbd, feu, fev, ffc, fff, fgf, fgh, fgo, fgp, fhm, fhn, fib, fki, fkj, fkw, fkx, fmh, fmk, fnk,\n\tfnl, fnz, foc, fof, foi, fvk, fvn, fvv, fvw, fwy, fxb, fyb, fye, fyl, fym, fyv, fyy, fzq, fzs, gad, gag, gaq, gas, gav, gax, gbc, gbd,\n\tgco, gcr, gdc, gdf, gdn, gdq, gei, gej, gih, gik, gku, gkx, gln, glo, gmi, gmj, gmu, gmv, gpx, gpy, gqb, gqe, gqp, gqs, grb, grc, grh,\n\tgri, grn, gro, grv, grw, gtr, gtu, gxc, gvt, gvw, gwz {\n}\n"}, "----------\n1. ERROR in p001\\bip.java (at line 200)\n\tclass bop implements missing,\n\t                     ^^^^^^^\nmissing cannot be resolved to a type\n----------\n");
    }

    private String getManyInterfaceDeclarations() {
        return "interface brj {}\ninterface brk {}\ninterface cem {}\ninterface cen {}\ninterface cey {}\ninterface cez {}\ninterface cfk {}\ninterface cfl {}\ninterface cgu {}\ninterface cgx {}\ninterface che {}\ninterface chh {}\ninterface chq {}\ninterface chr {}\ninterface cji {}\ninterface cjj {}\ninterface ckk {}\ninterface ckl {}\ninterface clb {}\ninterface clc {}\ninterface clf {}\ninterface cli {}\ninterface cnk {}\ninterface cnl {}\ninterface cok {}\ninterface cqa {}\ninterface cqd {}\ninterface cqw {}\ninterface cqx {}\ninterface crs {}\ninterface crv {}\ninterface csu {}\ninterface csv {}\ninterface ctq {}\ninterface ctt {}\ninterface cvg {}\ninterface cvj {}\ninterface cvo {}\ninterface cvp {}\ninterface cwk {}\ninterface cwn {}\ninterface cwu {}\ninterface cww {}\ninterface cxh {}\ninterface cxk {}\ninterface daz {}\ninterface dba {}\ninterface dbr {}\ninterface dbu {}\ninterface dck {}\ninterface dcl {}\ninterface deh {}\ninterface dei {}\ninterface dep {}\ninterface deq {}\ninterface dff {}\ninterface dfg {}\ninterface dfl {}\ninterface dfo {}\ninterface dsp {}\ninterface dss {}\ninterface dtp {}\ninterface dtq {}\ninterface dtt {}\ninterface dtw {}\ninterface duj {}\ninterface duk {}\ninterface dvm {}\ninterface dvp {}\ninterface dvs {}\ninterface dvv {}\ninterface dwe {}\ninterface dwh {}\ninterface dxd {}\ninterface dxg {}\ninterface dyq {}\ninterface dys {}\ninterface dyv {}\ninterface dyw {}\ninterface dzh {}\ninterface dzk {}\ninterface dzn {}\ninterface dzo {}\ninterface dzx {}\ninterface eaa {}\ninterface ecw {}\ninterface ecx {}\ninterface edr {}\ninterface eds {}\ninterface efc {}\ninterface efd {}\ninterface eiw {}\ninterface eiz {}\ninterface ejy {}\ninterface ekb {}\ninterface emi {}\ninterface eml {}\ninterface eor {}\ninterface eou {}\ninterface epe {}\ninterface eph {}\ninterface epk {}\ninterface epl {}\ninterface eqi {}\ninterface eqj {}\ninterface erv {}\ninterface erw {}\ninterface etd {}\ninterface etg {}\ninterface etm {}\ninterface eto {}\ninterface fbc {}\ninterface fbd {}\ninterface feu {}\ninterface fev {}\ninterface ffc {}\ninterface fff {}\ninterface fgf {}\ninterface fgh {}\ninterface fgo {}\ninterface fgp {}\ninterface fhm {}\ninterface fhn {}\ninterface fib {}\ninterface fki {}\ninterface fkj {}\ninterface fkw {}\ninterface fkx {}\ninterface fmh {}\ninterface fmk {}\ninterface fnk {}\ninterface fnl {}\ninterface fnz {}\ninterface foc {}\ninterface fof {}\ninterface foi {}\ninterface fvk {}\ninterface fvn {}\ninterface fvv {}\ninterface fvw {}\ninterface fwy {}\ninterface fxb {}\ninterface fyb {}\ninterface fye {}\ninterface fyl {}\ninterface fym {}\ninterface fyv {}\ninterface fyy {}\ninterface fzq {}\ninterface fzs {}\ninterface gad {}\ninterface gag {}\ninterface gaq {}\ninterface gas {}\ninterface gav {}\ninterface gax {}\ninterface gbc {}\ninterface gbd {}\ninterface gco {}\ninterface gcr {}\ninterface gdc {}\ninterface gdf {}\ninterface gdn {}\ninterface gdq {}\ninterface gei {}\ninterface gej {}\ninterface gih {}\ninterface gik {}\ninterface gku {}\ninterface gkx {}\ninterface gln {}\ninterface glo {}\ninterface gmi {}\ninterface gmj {}\ninterface gmu {}\ninterface gmv {}\ninterface gpx {}\ninterface gpy {}\ninterface gqb {}\ninterface gqe {}\ninterface gqp {}\ninterface gqs {}\ninterface grb {}\ninterface grc {}\ninterface grh {}\ninterface gri {}\ninterface grn {}\ninterface gro {}\ninterface grv {}\ninterface grw {}\ninterface gtr {}\ninterface gtu {}\ninterface gvt {}\ninterface gvw {}\ninterface gwz {}\ninterface gxc {}\n";
    }

    public void testBug550480() {
        StringBuilder source = new StringBuilder();
        source.append("package p;\n");
        CharSequence[] names = new String[571];
        int i = 0;
        while (i < 571) {
            names[i] = "I" + i;
            source.append("interface ").append((String)names[i]).append(" {}\n");
            ++i;
        }
        source.append("public abstract class hft implements ");
        source.append(String.join((CharSequence)", ", names));
        source.append("\n{\n}\n");
        this.runConformTest(new String[]{"p/hft.java", source.toString()});
    }

    public void testManyGenericsHangGh177() {
        this.runConformTest(new String[]{"C0.java", "public class C0\n<\nA1 extends C0<A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>,\nA2 extends C0<A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>,\nA3 extends C0<A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>,\nA4 extends C0<A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>,\nA5 extends C0<A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>,\nA6 extends C0<A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>,\nA7 extends C0<A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>,\nA8 extends C0<A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>,\nA9 extends C0<A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>,\nA10 extends C0<A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>,\nA11 extends C0<A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>,\nA12 extends C0<A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>,\nA13 extends C0<A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>,\nA14 extends C0<A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>,\nA15 extends C0<A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>,\nA16 extends C0<A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>,\nA17 extends C0<A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>,\nA18 extends C0<A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>,\nA19 extends C0<A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>,\nA20 extends C0<A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>\n>\n{\n\tpublic A1 a1 = null;\n\tpublic A1 getA1() {\n\t\treturn a1;\n\t}\n\tpublic static void main (String[] args) {\n\t}\n}\n"}, "");
    }
}

